Ext.define('Svod.ChatBotPanel', {
    extend: Ext.panel.Panel,

    tooltip: 'Чат-бот',

    xtype: 'chatBotPanel',

    reference: 'chatBotPanel',

    referenceHolder: true,

    cls: 'chatBotPanel',

    height: '100%',

    width: '100%',

    border: false,
    
    iconCls: 'ks-icon-chat-bot24',

    header: false,

    chatModelId: -1,

    ChatId: null,

    chatMessageModelId: null,

    // кнопки баг-трекера, технической поддержки и тд.
    chatBotMenu: null,

    // модальное окно при создании чата
    creatingChatModal: null,

    // список чатов
    chatListArea: null,

    // форма отправки сообщения и отображения сообщений
    displayChatSendMessageContainer: null,

    // стор сообщений
    chatMessageStore: null,

    // расположение класса стора сообщений
    chatMessageStoreName: 'Svod.ChatMessageModel-',

    // стор чатов
    chatStore: null,

    // расположение класса стора чатов
    chatStoreName: 'Svod.ChatModel-',

    // кнопка скролла вниз
    scrollBottomBtn: null,

    // контроль метода инициализации Чат-бота
    isInitalGetChatListCompleted: false,

    // контроль метода отправки сообщения Чат-бота
    isSendingMessage: false,

    // учёт отображаемых чатов при создании нового чата
    maxChatCount: 10,

    // количество сообщений при запросе на получение сообщений, приходит из бекенда
    pageSize: null,

    // минимальная ширина для приятного глазу отображения интерфейса
    componentMinWidth: 430,

    // Подключенные Чат-боты
    chatBotInfo: [],

    layout: 'vbox',

    items: [],

    listeners: {
        afterrender() {
            const component = this;
            component.chatMessageStore = Ext.getStore('chatMessage');
            component.chatStore = Ext.getStore('chatListBot');

            var view = component.parentView;

            component
                .addDisplayChatSendMessageContainer({
                    mainComponent: component,
                    parentView: view
                })
                .then((result) => {
                    return (component.displayChatSendMessageContainer =
                        component.add(result));
                })
                .then(() => {
                    return component.addChatListArea({
                        mainComponent: component,
                        parentView: view
                    });
                })
                .then((result) => {
                    return (component.chatListArea = component.add(result));
                })
                .then(() => {
                    return component.addChatBotMenu({
                        mainComponent: component,
                        parentView: view                        
                    });
                })
                .then((result) => {
                    return (component.chatBotMenu = component.add(result));
                })
                .then(() => {
                    return view.initialGetChatList(component);
                });

            component.Refresh = () => {
                if (component?.isInitalGetChatListCompleted) {
                    view.initialGetChatList(component);
                }
            };
        },

        resize() {
            const component = this;
            const creatingChatModal = this?.creatingChatModal;

            creatingChatModal?.setPosition(
                (component.getWidth() - creatingChatModal.getWidth()) / 2,
                (component.getHeight() - creatingChatModal.getHeight()) / 2
            );
        }
    },

    async addChatListArea(config) {
        return await new Promise((resolve) => {
            setTimeout(
                () =>
                    resolve({
                        xtype: 'chatListArea',
                        scrollable: 'vertical',
                        hidden: true,
                        ...config
                    }),
                0
            );
        });
    },

    async addDisplayChatSendMessageContainer(config) {
        return await new Promise((resolve) => {
            setTimeout(
                () =>
                    resolve({
                        xtype: 'displayChatSendMessageContainer',
                        ...config
                    }),
                0
            );
        });
    },

    async addChatBotMenu(config) {
        return await new Promise((resolve) => {
            setTimeout(
                () =>
                    resolve({
                        xtype: 'chatBotMenu',
                        ...config
                    }),
                0
            );
        });
    }
});
