UserContactFormView = KS.extend(BaseSvodView, {});

// ============= COMMON =======================
(function (viewClass) {
    KS.apply(viewClass, {
        onTemplateRendered: function () {
            if (this.phoneContainer)
                this.fillPhoneContainer();
        },

        fillPhoneContainer: function(){
            this.editorPhone = new Ext.form.TextField({
                value : this.phoneContainer.phoneValue,
                ctrlId : "editorPhone", 
                emptyText : "+7 (ххх) ххх-хх-хх",
                inputMask: "+7 (999) 999-99-99",
                allowBlank: this.phoneContainer.allowBlank,
                regexText: "Номер телефона должен быть указан в формате +7 (ххх) ххх-хх-хх"
            });
            this.phoneContainer.add(this.editorPhone);
            this.editorAdditionalPhone = new Ext.form.TextField({
                ctrlId : "editorAdditionalPhone",
                margin : "0 0 0 10",
                maskRe : /[+0-9 ()-]/,
                width : 40
            });
            this.phoneContainer.add(this.editorAdditionalPhone);
            
            if (this.secondPhoneContainer){
                this.editorSecondPhone = new Ext.form.TextField({
                    value : this.secondPhoneContainer.secondPhoneValue,
                    ctrlId : "editorSecondPhone",
                    emptyText : "+7 (ххх) ххх-хх-хх",
                    inputMask: "+7 (999) 999-99-99",
                    regexText: "Номер телефона должен быть указан в формате +7 (ххх) ххх-хх-хх"
                });
                this.secondPhoneContainer.add(this.editorSecondPhone);
                this.editorSecondAdditionalPhone = new Ext.form.TextField({
                    ctrlId : "editorSecondAdditionalPhone",
                    margin : "0 0 0 10",
                    maskRe : /[+0-9 ()-]/,
                    width : 40
                });
                this.secondPhoneContainer.add(this.editorSecondAdditionalPhone);
            }
        },

        consentCheckChange: function(comp, newValue){
            if (this.submitBtn){
                this.submitBtn.setDisabled(!newValue);
            }
        },

        saveFiles: function(fileKeys) {
            var view = this.parentView || this;
            view.serverCall({
                method: 'SaveFiles',
                params: [fileKeys],
                waitMessage: 'Сохранение ...',
                success: view.fillAttachedFiles
            });
        },

        deleteFile: function(btn){
            var fileName = btn.fileName;
            var view = this.parentView || this;
            view.serverCall({
                method: 'DeleteFile',
                params: [fileName],
                disableFog: true,
                success: view.fillAttachedFiles
            });
        },
        
        // Каждый раз перерисовываем весь список файлов чтобы точно ничего не потерять, например при F5
        fillAttachedFiles: function(filePanels){
            if (this.attachedFiles)
            {
                this.attachedFiles.removeAll();
                this.attachedFiles.setHidden(Ext.isEmpty(filePanels));
                var view = this;
                Ext.each(filePanels, function(filePanel){
                    var filePanelComp = KS.create(filePanel);
                    view.addPanelItems(filePanel, filePanelComp);
                    view.attachedFiles.add(filePanelComp);
                });
            }
        },

        openBudgetTree: function(){
            var view = this.parentView || this;
            view.serverCall({
                method: 'OpenBudgetTree',
                waitMessage: 'Загрузка дерева организаций и бюджетов...',
                success: function(){
                    view.containerPanel.mask('Загрузка дерева организаций и бюджетов...');
                    setTimeout(function(){view.containerPanel.unmask()}, 3000);
                }
            });
        },

        onServerChangeOrganization: function(orgName){
            this.editorOrganization.setValue(orgName);
        },

        changeClassification: function(comp, newValue){
            this.serverCall({
                method: 'ChangeClassification',
                params: [newValue],
                disableFog: true
            });
        },

        periodCompChange: function(){
            var pCmp = this.periodComponent;
            var period = {
                Year : pCmp.getYear(),
                Type : pCmp.getType(),
                Number : pCmp.getNumber()
            }
            this.serverCall({
                method: 'PeriodChange',
                params: [period],
                disableFog: true
            });
        },

        submitData: function(){
            var view = this.parentView || this;
            var fields = view.getAllFields();
            if (!view.validateFields(fields)) return;
            var newValues = view.collectValues(fields);
            view.serverCall({
                method: 'SubmitData',
                params: [newValues],
                success: function(errorFields){
                    if (!Ext.isEmpty(errorFields)){
                        view.validateFields(errorFields)
                    }
                }
            });
        },
        
        getAllFields: function(){
            var fieldNameRelations = this.data.fieldNameRelations;
            var fieldsDict = [];
            for (var field in fieldNameRelations){
                if (fieldNameRelations.hasOwnProperty(field))
                    fieldsDict.push(field);
            }
            return fieldsDict;
        },

        // клиентская проверка полей на пустоту и соответствие маске
        validateFields: function(fields){
            var view = this;
            var isValid = true;
            Ext.each(fields, function(field){
                var editorName = "editor" + field;
                var editorField = view[editorName]; 
                // проверяем что такое поле есть и это текстовое поле с функцией validate
                // пока считаем что период заполнен и ошибочным быть не может
                if (editorField){
                    if (editorField.textField) // текстовое поле создано на сервере
                        editorField = editorField.textField;
                    if (Ext.isFunction(editorField.validate) &&
                        !editorField.validate())
                        isValid = false;
                }
            });
            return isValid;
        },
        
        collectValues: function(fields){
            var view = this;
            var newValues = {};
            Ext.each(fields, function(field){
                var editorName = "editor" + field;
                var editorField = view[editorName];
                if (editorField){ // период не берём
                    if (editorField.displayField) { // комбобоксы, например классификация
                        if (editorField.selection) // есть выбранная запись
                            newValues[field] = editorField.selection.get(editorField.displayField);
                    } else {
                        newValues[field] = editorField.getValue();
                    }
                }
            });
            return newValues;
        },

        onServerCloseView: function(){
            this.close();
        }
    });
}(UserContactFormView.prototype));

if (typeof(Sys) !== 'undefined') Sys.Application.notifyScriptLoaded();