﻿SvodMonitorView = KS.extend(BaseTreeView, {});

(function(viewClass) {
    var sc = SvodMonitorView.superclass;

    KS.apply(viewClass, {
        getTbarClickHandler: function (tbarItem) {
            switch (tbarItem.code) {
                case "RELOAD_STAT":
                    return this.reloadStat;
                    
                case "EMAIL":
                    return this.sendEmail;
                    
                case "FIND":
                    return this.changeSearchPanelVisible;
                    
                case "PRINT_COMMON":
                case "PRINT_LIST":
                    return this.exportToExcel;
                    
                case "PRINT":
                    return this.printWithTemplate;
                    
                default:
                    return sc.getTbarClickHandler.call(this, tbarItem);
            }
        },

        processToolbarItemControl: function(ctrl, tbarItem) {
            if (tbarItem.nodeStyle === 4) {
                switch (tbarItem.code) {
                    case 'BeginDate':
                    case 'EndDate':
                        ctrl = new Ext.form.field.Date({
                            format: 'd.m.Y',
                            code: tbarItem.code,
                            margin: '0 0 0 5',
                            enableKeyEvents: false,
                            value: new Date()
                        });
                        ctrl.on('change', this.dateChange, this);
                        return ctrl;
                    
                    case 'Container1':
                        ctrl.on('change', this.filterByDate, this);
                        break;
                        
                    case 'DataSourcesList':
                        if (tbarItem.additional != null && tbarItem.additional["LIST_ITEMS"]) {
                            var comboStore = Ext.create('Ext.data.Store', {
                                fields: ['DATA_VALUE', 'DISPLAY_TEXT'],
                                data: tbarItem.additional["LIST_ITEMS"]
                            });
                            ctrl = new Ext.form.field.ComboBox({
                                store: comboStore,
                                value: 0,
                                queryMode: 'local',
                                displayField: 'DISPLAY_TEXT',
                                valueField: 'DATA_VALUE',
                                parentView: this,
                                listeners: {
                                    select: this.dataSourceChanged
                                }
                            });
                        }
                        break;
                }
            }
            if (tbarItem.nodeStyle === 7) { // у label добавляем отступы
                ctrl.margin = "0 0 0 5";
            }
            switch (tbarItem.code){
                case "EMAIL":
                    ctrl.hidden = true;
                    break;
                case "PRINT_COMMON":
                case "PRINT_LIST":
                    ctrl.gridPropertyName = "mainGrid";
                    break;
            }
            return sc.processToolbarItemControl.apply(this, arguments);
        }        
    });
}(SvodMonitorView.prototype));

//====== TREE ===========
(function(viewClass) {
    KS.apply(viewClass, {        
        baseTreeNodeSelect: function(treeModel, selected){
            if(!Ext.isEmpty(selected)){
                var code = selected[0].id;
                this.setEmailButtonVisible(code === "EXPORT_KSP" || code === "EXPORT_GKU" || code === "EXPORT_AM");
                this.setPrintButtonVisibility(code);
                this.serverCall({
                    method: 'LoadGridData',
                    params: [code, this.getDateData()]
                });
            }
        },

        baseTreeLoaded: function(){
            this.baseTree.selectFirstNode();
        },

        searchTree: "baseTree"
    });
}(SvodMonitorView.prototype));

//====== GRID ===========
(function(viewClass) {
    KS.apply(viewClass, {
        onServerCreateGrid: function(mainGrid){
            if (Ext.isEmpty(mainGrid)) return;
            this.gridPanel.removeAll();
            if (Ext.isString(mainGrid)){
                this.gridPanel.setHtml(mainGrid);
            } else {
                this.createTemplateControl(mainGrid);
                this.gridPanel.add(this.mainGrid);
            }
        },
        
        reloadStat: function(){
            var view = this.parentView || this;
            var selNode = view.baseTree.getSelNode();
            if (selNode){
                view.baseTreeNodeSelect(null, [selNode]);
            }
        },
        
        dateChange: function(){
            
        },

        filterByDate: function(comp, newValue){
            var beginDate = this.getToolbarItem(this.gridPanel, null, 'BeginDate');
            if (beginDate)
                beginDate.setDisabled(!newValue);
            var endDate = this.getToolbarItem(this.gridPanel, null, 'EndDate');
            if (endDate)
                endDate.setDisabled(!newValue);
        },

        getDateData: function(){
            var container1 = this.getToolbarItem(this.gridPanel, null, 'Container1');
            var beginDate = this.getToolbarItem(this.gridPanel, null, 'BeginDate');
            var endDate = this.getToolbarItem(this.gridPanel, null, 'EndDate');
            return {
                "DateFilter" : container1 != null ? container1.getValue() : null,
                "BeginDate" : beginDate != null ? beginDate.getValue() : null,
                "EndDate" : endDate != null ? endDate.getValue() : null
            }
        },
        
        setEmailButtonVisible: function(visible){
            var email = this.getToolbarItem(this.gridPanel, null, 'EMAIL');
            if (email)
                email.setHidden(!visible);
        },

        sendEmail: function(){
            var view = this.parentView || this;
            var selNode = view.baseTree.getSelNode();
            if (selNode){
                var code = selNode.id;
                view.serverCall({
                    method: 'SendEmail',
                    params: [code, this.getDateData()]
                });
            }
        },

        setPrintButtonVisibility: function(code){
            var view = this;
            view.serverCall({
                method: 'GetPrintButtonVisibility',
                disableFog: true,
                params: [code],
                success: function(visibility){
                    var parentBtn = view.getToolbarItem(view.gridPanel, null, "PRINT_COMMON");
                    if (parentBtn){
                        var printBtn = parentBtn.getMenu().items.findBy(function(item) {
                            return (item && item.tbarNode && (item.tbarNode.code === "PRINT"));
                        });
                        if (printBtn)
                            printBtn.setHidden(!visibility);
                    }
                }
            });
        },

        printWithTemplate: function(){
            var view = this.parentView || this;
            var selNode = view.baseTree.getSelNode();
            if (selNode){
                var code = selNode.id;
                view.serverCall({
                    method: 'PrintWithTemplate',
                    params: [code, this.getDateData()]
                });
            }
        },

        rowDblClickHandler: function(gridView, record, element, rowIndex, e) {
            var closeCode = KS.Grid.getAnyCase(record, "ENTITY_CLOSE_CODE"),
                column = e.position.column;

            if (column.renderer === svodMonitorUrlRenderer)
                return;

            var view = this;
            view.serverCall({
                method: 'GetCellDetails',
                disableFog: true,
                params: [closeCode, column.dataIndex],
                success: function(text){
                    view.showCellDetails(text, column.text)
                }
            });
        },
        
        showCellDetails: function(text, title){
            var view = this;
            view.detailsWin = KS.showModal({
                xtype: 'textarea',
                editable: false,
                value: text
            },{
                layout: 'fit',
                plain: true,
                frame: true,
                autoScroll: true,
                modal: true,
                maximizable: true,
                minWidth: 400,
                minHeight: 300,
                width: Math.max(400, KS.rootViewport.getWidth() / 1.5),
                height: Math.max(300, KS.rootViewport.getHeight() / 1.5),
                title: title,
                buttonAlign: 'center',
                buttons: new Array({
                    text: 'Закрыть',
                    cls: 'marked-button',
                    handler: function () {
                        view.detailsWin.close(true);
                    }
                })
            }, true);
        },

        dataSourceChanged: function (combo, record) {
            var view = combo.parentView;
            view.serverCall({
                method: 'DataSourceChanged',
                params: [KS.Grid.getAnyCase(record, "DATA_VALUE") || 0],
                success: view.reloadStat
            });
        },

        urlClick: function(openMode, colKey, value){
            var code = this.baseTree.getSelNodeId();
            if (code) {
                this.serverCall({
                    method: 'ShowUrlProtocol',
                    params: [openMode, code, colKey, value]
                });
            }
        }
    });
}(SvodMonitorView.prototype));

function svodMonitorStringRenderer(value) {
    return value.replace(/</g,"&lt;").replace(/>/g,"&gt;");
}

function svodMonitorUrlRenderer(value, metadata, record, rowIndex, colIndex, store){
    var mode = metadata.column.aspType === 'url' ? "'by_value'" : "'by_link'";
    var dataIndex = "'" + metadata.column.dataIndex + "'";
    return '<span class="like-hypertext" onclick="KS.getView(' + "'" + store.grid.parentView.viewID + "'" + ').urlClick(' + mode + ',' + dataIndex + ',' + value + ');return false;"/>' + 'Открыть' + '</span>';
}

if (typeof(Sys) !== 'undefined') Sys.Application.notifyScriptLoaded();