﻿SvodFileListView = KS.extend(BaseDictionaryView,
    {
        saveFiles: function(fileKeys) {
            var view = this.parentView || this;
            view.serverCall({
                method: 'SaveFiles',
                params: [fileKeys],
                waitMessage: 'Сохранение ...',
                success: function() {
                    view.mainGrid.reload();
                }
            });
        },

        exportFiles: function() {
            var view = this.parentView || this;
            var checkedCodes = view.mainGrid.getCheckedCodes();
            if (!Ext.isEmpty(checkedCodes)) {
                view.serverCall({
                    method: 'ExportFiles',
                    params: [checkedCodes]
                });
            }
        },

        editHandler: function() {
            var view = this.parentView || this;
            var checkedCodes = view.mainGrid.getCheckedCodes();
            if (!Ext.isEmpty(checkedCodes)) {
                view.serverCall({
                    method: 'OpenFile',
                    params: [checkedCodes[0]]
                });
            }
        }
    });

if (typeof(Sys) !== 'undefined') Sys.Application.notifyScriptLoaded();