﻿// ============= VIEW =======================
RouteAgreementFormNastrView = KS.extend(BaseSvodView, {
    onTemplateRendered: function () {
        this.addComboInNastrPanel();
        this.hasNastrChanges = false;
    }
});

// ===== MAIN TOOLBAR ======
(function (viewClass) {
    KS.apply(viewClass, {

        refresh: function () {
            var view = this.parentView || this;
            if (!view.hasNastrChanges) {
                view.doRefresh();
                return;
            }
            KS.confirm("Все несохраненные данные бдут потеряны. Продолжить? ",
                "Подтвердите обновление",
                function (btn) {
                    if (btn === 'yes') {
                        view.doRefresh();
                    }
                });
        },

        doRefresh: function () {
            var view = this.parentView || this;
            view.serverCall({
                method: 'RefreshNastr',
                success: function(result) {
                    view.afterRefresh(result);
                }
            });
        },

        afterRefresh: function(result) {
            var checkAllValue = result.checkAll === "true" ? true : false;
            this.getToolbarItem(this.mainPanel, 'top', 'CHECK_ALL_FORM').setValue(checkAllValue);
            this.formTables.setDisabled(checkAllValue);
            this.nastrPanel.setDisabled(checkAllValue);

            this.gridColumns.reload();
            this.gridRows.reload();

            this.setComboValue(result.comboValue);
            this.hasNastrChanges = false;
        },

        checkAllFormChange: function(component, newValue) {
            var view = this.parentView || this;
            view.formTables.setDisabled(newValue);
            view.nastrPanel.setDisabled(newValue);
            view.serverCall({
                method: 'CheckAllFormChange',
                params: [newValue]
            });
            view.hasNastrChanges = true;
        },

        validateComboChange: function(component, newValue) {
            var view = this.parentView || this;
            switch(newValue) {
                case 0:
                    view.gridColumns.setHidden(true);
                    view.gridRows.setHidden(true);
                    break;
                case 1:
                    view.gridColumns.setHidden(false);
                    view.gridRows.setHidden(true);
                    break;
                case 2:
                    view.gridColumns.setHidden(true);
                    view.gridRows.setHidden(false);
                    break;
                case 3:
                    view.gridColumns.setHidden(true);
                    view.gridRows.setHidden(true);
                    break;
            }

            view.serverCall({
                method: 'ComboChange',
                params: [newValue],
                success: function() {
                    view.hasNastrChanges = true;
                }
            });
        },

        exit: function () {
            var view = this.parentView || this;
            view.close();
        }
    });
}(RouteAgreementFormNastrView.prototype));

// ===== BASE ======
(function (viewClass) {
    KS.apply(viewClass, {
       
        addComboInNastrPanel: function() {
            var view = this;
            var states = Ext.create('Ext.data.Store', {
                fields: ['state', 'name'],
                data : [
                    {"state": 0, "name":"Не проверять"},
                    {"state": 1, "name":"Проверять отдельные графы"},
                    {"state": 2, "name":"Проверять отдельные строки"},
                    {"state": 3, "name":"Проверять всю таблицу"}
                ]
            });

            var comboBox = new Ext.form.ComboBox({
                fieldLabel: 'Проверять',
                width: 300,
                store: states,
                queryMode: 'local',
                displayField: 'name',
                valueField: 'state',
                value: 0,
                listeners: {
                    scope: view,
                    'change' : view.validateComboChange
                }
            });

            view.nastrPanel.addDocked(comboBox);
        },

        selectFirstNodeAfterLoad: function(node) {
            var record = node.childNodes[0];
            this.setActiveItemInFormTables(record);
        },
        
        selectActiveItemFormTablesByClick: function(tree, td, cellIndex, record) {
            this.setActiveItemInFormTables(record);
        },

        setActiveItemInFormTables: function(node) {
            var view = this;
            if (node) {
                var key = node.id;
                this.formTables.getSelectionModel().select(node);
                view.serverCall({
                    method: 'FormsTableSelectActiveItem',
                    params: [key],
                    success: function(comboValue) {
                        view.gridColumns.reload();
                        view.gridRows.reload();
                        view.setComboValue(comboValue);
                    }
                });
            }
        },

        setComboValue: function(comboValue) {
            var combo = this.nastrPanel.getDockedItems()[0];
            combo.setValue(comboValue);
        },
        
        OKClick: function() {
            var view = this.parentView || this;
            view.serverCall({
                method: 'ButtonOKClick',
                params: [view.hasNastrChanges],
                success: function() {
                    view.close();
                }
            });
        },

        newRow: function() {
            var view = this.parentView || this;
            view.serverCall({
                    method: 'AddRowInGridRows',
                    success: function() {
                        view.hasNastrChanges = true;
                    }
            });
        },
        
        deleteRow: function() {
            var view = this.parentView || this;
            var selectedRows = view.gridRows.getSelection();
            var linkList = [];
            Ext.each(selectedRows, function (row) {
                linkList.push(row.data["CODE"]);
            });
            view.serverCall({
                method: 'DeleteRowInGridRows',
                params: [linkList],
                success: function() {
                    view.gridRows.reload();
                    view.hasNastrChanges = true;
                }
            }); 
        },

        onValuesSelected: function (data) {
            var arg = data[0][0];
            switch (arg["CLOSE_CODE"]) {
                case "LINK_DICTION_ROW":
                    this.gridRows.reload();
                    break;
            }
        },

        openUrl: function () {
            KS.openUrl.apply(this, arguments);
        }

    });
}(RouteAgreementFormNastrView.prototype));

if (typeof (Sys) !== 'undefined') Sys.Application.notifyScriptLoaded();