﻿ReportTaskListCheckView = KS.extend(BaseReportTaskListView, {});

// ============= TOOLBAR =======================
(function (viewClass) {
    var sc = ReportTaskListCheckView.superclass;
    
    KS.apply(viewClass, {
        onTemplateRendered: function() {
            this.tunePeriodComp();
        },

        processToolbarItemControl: function(ctrl, tbarNode) {
            switch (tbarNode.code) {
                case 'Container1': // Компонент выбора периода
                    ctrl = this.createTemplateControl(this.tpl.controls['periodComponent']);
                    break;

                case 'Container2': // Комбобокс "Отображать отчеты"
                    ctrl.on('select', this.reportTypeComboChange, this);
                    break; 

                case 'Container3': // Чекбокс "Все периоды"
                    ctrl.on('change', this.allPeriodsCheckedChange, this);
                    break;  

                case 'SEND_EMAIL':
                    ctrl.setValue(this.data.settings.DocumentCheckSendMail);
                    ctrl.on('change', this.sendEmailCheckChange, this);
                    break;
            }
            return sc.processToolbarItemControl.call(this, ctrl, tbarNode);
        },

        getTbarClickHandler: function(tbarItem) {
            switch (tbarItem.code) {
                case "PRINT_MENU":
                case "CHECK_KS_MENU":
                    return null;

                case "PRINT":
                case "CHECK_SUMS_DOCUMENT_INSIDE":
                case "CHECK2":
                case "CHECK3":
                case "CHECK_INSIDE_FORMULA":
                case "CHECK_SUMS_BETWEEN_DOCUMENT":
                case "CHECK_OUTSIDE_FORMULA":
                case "EDS_INFO":
                case "ROUTE_SIGN_LIST":
                case "SHOW_ROUTE_LIST_ROW":
                    return this.executeToolbarOperation;

                case "EDIT":
                    return this.beforeEditRecord;

                case "SIGN_MENU":
                case "SIGN":
                case "UNSIGN":
                    return this.beforeSignChange;

                default:
                    return sc.getTbarClickHandler.apply(this, arguments);
            }
        },

        tunePeriodComp: function() {
            this.getAllPeriodsComp().setValue(false);
        },

        getPeriodComp: function() {
            return this.getToolbarItem(this.mainGrid, null, "Container1");
        },
        
        getAllPeriodsComp: function() {
            return this.getToolbarItem(this.mainGrid, null, "Container3");
        },

        periodCompChange:function() {
            var periodComp = this.getPeriodComp();
            this.serverCall({
                method: 'PeriodComponentChange',
                params: [periodComp.getPeriod()],
                success: function() {
                    this.mainGrid.reload();
                }
            });
        },

        allPeriodsCheckedChange: function(checkbox, newValue) {
            var periodComp = this.getPeriodComp();
            periodComp.setDisabled(newValue);
            this.serverCall({
                method: 'AllPeriodsCheckedChange',
                params: [newValue, periodComp.getPeriod()],
                success: function() {
                    this.mainGrid.reload();
                }
            });
        },

        executeToolbarOperation: function() {
            var view = this.parentView,
                grid = view.mainGrid;
            if (grid && this.tbarNode) {
                var code = this.tbarNode.code || '';
                view.executeOperation(code, grid);
            }
        },

        executeOperation: function (opCode, grid, additional) {
            var rows = this.buildChosenRows(grid, opCode !== 'CREATE_NOTIFICATION');
            this.currentOpArgs = [].slice.call(arguments);

            if (Ext.isEmpty(rows)) {
                KS.alert("Для выполнения операции необходимо выделить один или несколько отчётов");
                return;
            }

            this.serverCall({
                method: 'OnExecuteOperation',
                params: [opCode, rows, additional || {}],
                success: this.executeOperationCallback
            });
        },

         executeOperationCallback: function (result) {
            switch (result.operationCode) {
                case 'EDIT':
                    if (result.statusChanged) 
                        this.reload();
                    break;

                case "SIGN_MENU":
                case "SIGN":
                case "UNSIGN":
                case "CHECK_SUMS_DOCUMENT_INSIDE":
                case "CHECK2":
                case "CHECK3":
                case "CHECK_INSIDE_FORMULA":
                case "CHECK_SUMS_BETWEEN_DOCUMENT":
                case "CHECK_OUTSIDE_FORMULA":
                    this.reload();
                    break;

                default:
                    break;
            }

            this.processTaskResult(result.taskResultContext);
        },

        rowDblClickHandler: function() {
            this.beforeEditRecord();
        },

        beforeEditRecord: function() {
            var view = this.parentView || this,
                grid = view.mainGrid,
                rows = grid.getCheckedRows();
            if (Ext.isEmpty(rows)) return;
            var record = rows.shift();
            var statusLink = KS.Grid.getAnyCase(record, "LINK_SAVED_FORM_STATUS");
            if (statusLink) {
                if (statusLink === view.data.checkingSavedFormStatusLink.toString()) {
                    KS.confirm( "Начать проверку отчета?", "Внимание",
                        function(btn) {
                            if (btn === 'yes') {
                                view.executeOperation("EDIT", grid, { "CHANGE_STATUS" : false });
                            }
                        });
                } else {
                    var checkingDirty = KS.Grid.getAnyCase(record, "CHECKING");
                    if (checkingDirty !== "1") {
                        KS.confirm("Перевести отчет в статус 'Проверяется'?",
                            "Внимание",
                            function(btn) {
                                view.executeOperation("EDIT", grid, { "CHANGE_STATUS" : btn === 'yes' });
                            });
                    } else {
                        view.executeOperation("EDIT", grid, { "CHANGE_STATUS" : false });
                    }
                }
            }
        },

        beforeSignChange: function() {
            var view = this.parentView || this,
                grid = view.mainGrid,
                opCode = this.tbarNode.code,
                isSign = opCode !== "UNSIGN";

            view.signCommentWindow = new Ext.Window({
                layout: 'fit',
                plain: true,
                frame: true,
                autoScroll: true,
                modal: true,
                maximizable: true,
                minWidth: 400,
                minHeight: 300,
                width: Math.max(400, KS.rootViewport.getWidth() / 2),
                height: Math.max(300, KS.rootViewport.getHeight() / 1.5),
                title: isSign ? "Добавить комментарий к подписи" : "Добавить комментарий",
                items: {
                    xtype: 'textarea',
                    itemId: 'commentArea'
                },
                buttonAlign: 'right',
                buttons: [{
                    text: 'Далее',
                    cls: 'marked-button',
                    handler: function () {
                        var commentValue = view.signCommentWindow.getComponent("commentArea").getValue();
                        view.executeOperation(opCode, grid, { "COMMENT" : commentValue });
                        view.signCommentWindow.close(true);
                    }
                }, { xtype: 'tbspacer', width: 8 },{
                    text: 'Отмена',
                    cls: 'marked-button',
                    handler: function () {
                        view.signCommentWindow.close(true);
                    }
                }]
            }).show();
        },

        findOwnerGrid: function() {
            return this.mainGrid;
        },

        reportTypeComboChange: function(combo) {
            var newValue = combo.getValue();
            this.serverCall({
                method: 'ReportTypeComboChange',
                params: [newValue],
                success: function() {
                    this.mainGrid.reload();
                }
            });
        },

        sendEmailCheckChange: function(checkbox, newValue) {
            this.serverCall({
                method: 'SendEmailCheckChange',
                params: [newValue],
                waitMessage: 'Установка настройки...'
            });
        }
    });
}(ReportTaskListCheckView.prototype));

if (typeof(Sys) !== 'undefined') Sys.Application.notifyScriptLoaded();