﻿ReportStructView = KS.extend(BaseSvodView, { });
var sc = ReportStructView.superclass;

// ============= COMMON =======================
(function(viewClass) {
    KS.apply(viewClass, {

        onTemplateRendered: function () {
            this.childViews = [];
            this.cachedValues = [];
            this.addGeneralPropertyGrid(); 
            this.setAccess();
            this.formatListGridJsonLoad();
            if (!KS.isEmpty(this.deferredAddChildViews)) {
                for (var idx = 0; idx < this.deferredAddChildViews.length; idx++) {
                    this.addChildView(this.deferredAddChildViews[idx]);
                }
                delete this.deferredAddChildViews;
            }
            if (this.data.identifier.IsNewOutcome)
                this.touch();
        },

        setAccess: function() {
            if (!this.data.isDevelop && !Ext.isEmpty(this.data.lockUserName)) 
                KS.alert("Невозможно открыть форму для редактирования. Форма уже открыта пользователем " + this.data.lockUserName, "Внимание");
        },

        onSetSavedState: function(saved) {
            this.getToolbarItem(this.rootPanel, null, 'SAVE').setDisabled(saved);
        },

        navigationTreeClick: function(treeView, td, cellIndex, record, tr, rowIndex ) {
            var view = this.parentView || this;
            view.tabControl.setActiveTab(rowIndex);
        },

        navigationTreeLoad: function() {
            this.navigationTree.selectFirstNode();
        },

        formatListGridJsonLoad: function() {
            var checkedRows = this.formatListGrid.getCheckedRows();
            if (checkedRows.length > 0) 
                this.selectFormatListGrid(this.formatListGrid, checkedRows[0]);
        },

        selectFormatListGrid: function(grid, record) {
            this.formatDescrFilter = "link_exchange_format = -1";
            var linkFormat = KS.Grid.getAnyCase(record, "LINK_EXCHANGE_FORMAT");
            if (linkFormat) 
                this.formatDescrFilter += " OR link_exchange_format = " + linkFormat;
            this.formatDescriptionGrid.reload();
        },

        getAdditionalGetDataParams: function(gdp) {
            if (gdp.itemId === "formatDescriptionGrid") 
                gdp.constantFilter = this.formatDescrFilter || "";
        },

        getCheckedFileRows: function (field) {
            var recs = this.filesGrid.checkList;
            if (Ext.isString(field) && !Ext.isEmpty(field)) {
                var fields = [];
                Ext.each(recs, function (r) {
                    fields.push(KS.Grid.getAnyCase(r, field));
                });
                return fields;
            }
            return recs;
        },
        
        correctValueForEqual: function(value) {
            var correctValue = "";
            switch(Ext.typeOf(value)) {
                case "date":
                    correctValue = Ext.util.Format.date(value, 'd.m.Y');
                    break;
                  
                case "array":
                    correctValue = value.join(",");
                    break;
                
                case "null":
                    value = "";
                    break;
            }
            return !Ext.isEmpty(correctValue) ? correctValue : value;
        },
        
        editGridCell: function(plugin, context) {
            if (context.originalValue !== this.correctValueForEqual(context.value)) {
                this.addInCachedValues(context.grid.ctrlId, 
                    context.grid.closeCode, 
                    KS.Grid.getAnyCase(context.record, context.grid.closeCode),
                    context.field, 
                    context.value);
                this.touch();
            }
        },

        addInCachedValues: function(gridId, closeCodeFieldName, closeCodeValue, dataIndex, newValue) {
            var cvalue = {
                'gridId': gridId,
                'closeCodeFieldName': closeCodeFieldName,
                'closeCodeValue': closeCodeValue,
                'dataIndex': dataIndex,
                'newValue': newValue
            };
            this.cachedValues.push(cvalue);
        },
        
        celldblclickFormAttrGrid: function(gridView, td, cellIndex, record, tr, rowIndex, e) {
            var col = e.position.column;
            if (col.dataIndex === "VISIBLE_VALUE") {
                var linkDiction = KS.Grid.getAnyCase(record, "link_diction");
                if (!Ext.isEmpty(linkDiction)) {
                    var closeCode = KS.Grid.getAnyCase(record, "ENTITY_CLOSE_CODE");
                    this.serverCall({
                        method: 'SelectDictionFormAttr',
                        disableFog: true,
                        params: [closeCode]
                    });
                    return false;
                }
            }
            return true;
        },

        editFormAttrGridCell: function(plugin, context) {
            if (context.originalValue !== context.value) {
                var dataIndex = context.field;
                var closeCode = KS.Grid.getAnyCase(context.record, context.grid.closeCode);
                var newValue = context.value;
                var view = this;
                this.serverCall({
                    method: 'EditFormAttrGridCell',
                    disableFog: true,
                    params: [closeCode, dataIndex, newValue],
                    success: function() {
                        view.touch();
                    }
                });
            }
        },

        celldblclickEdsSchemaGrid: function(gridView, td, cellIndex, record) {
            var view = this.parentView || this,
                link = gridView.grid.getCloseCode(record);

            view.serverCall({
                method: 'EditEdsSchema',
                params: [link]
            });
        },

        cellClickFormatDescGrid: function(gridView, td, cellIndex, record, tr, rowIndex, e) {
            var col = e.position.column;
            if (col.editable && 
                col.dataIndex === "SCHEMA") {
                var value = KS.Grid.getAnyCase(record, col.dataIndex);
                this.showEODSchemeEditor(value, col, record, gridView.grid);
            }
        },

        showEODSchemeEditor: function (value, cfg, rec, grid) { // \r\n убираются в GridExtender SetJsonValue
            var view = this;
            view.pseWin = KS.showModal({
                xtype: 'textarea',
                itemId: 'pseArea',
                value: value
            },{
                layout: 'fit',
                plain: true,
                frame: true,
                autoScroll: true,
                modal: true,
                maximizable: true,
                minWidth: 400,
                minHeight: 300,
                width: Math.max(400, KS.rootViewport.getWidth() / 2),
                height: Math.max(300, KS.rootViewport.getHeight() / 1.5),
                title: cfg.text,
                buttonAlign: 'right',
                buttons: new Array({
                    text: 'Применить',
                    cls: 'marked-button',
                    handler: function () {
                        var newValue = view.pseWin.getComponent("pseArea").getValue();
                        if (value !== newValue) {
                            rec.set(cfg.dataIndex, newValue);
                            view.addInCachedValues(grid.ctrlId, grid.closeCode, KS.Grid.getAnyCase(rec, grid.closeCode), cfg.dataIndex, newValue);
                            view.touch();
                        }
                        view.pseWin.close(true);
                    }
                })
            }, true);

            view.pseWin.getComponent("pseArea").selectText(value.length);
        },

        onValuesSelected: function (arg) {
            if (arg[0][0]) {
                var activeTab = this.tabControl.getActiveTab();
                switch (activeTab.ctrlId) {
                    case "eodPanel":
                        this.formatListGrid.reload();
                        this.touch();
                        break;

                    case "filesGrid":
                    case "groupsGrid":
                    case "taskAttributesGrid":
                    case "formAttributeGrid":
                    case "printTemplatesGrid":
                    case 'edsSchemaGrid':
                        activeTab.reload();
                        this.touch();
                        break;
                }
            }
        },

        getMarkableGrid: function() {
            var activeTab = this.tabControl.getActiveTab();

            if (activeTab.ctrlId === 'eodPanel') {
                var activeComponent = Ext.Element.getActiveElement(true).component;

                if (!Ext.isEmpty(activeComponent.gridPropertyName))
                    return this[activeComponent.gridPropertyName];
                else
                    return null;
            }

            return activeTab;
        }
    });
}(ReportStructView.prototype));

// ============= TOOLBAR =======================
(function(viewClass) {
    var sc = ReportStructView.superclass;
    KS.apply(viewClass, {
        getTbarClickHandler: function (tbarItem) {
            var code = tbarItem.code || '';
            switch (code) {
                case 'NEW':
                    return this.newHandler;

                case 'DELETE':
                    return this.deleteHandler;

                case 'UP':
                case 'DOWN':
                case "SVOD_TYPE_0":
                case "SVOD_TYPE_1":
                case "SVOD_TYPE_2":
                    return this.taskAttributeOperation;

                case "ADD_EXISTS":
                    return this.addEODExistsFormat;

                case "EXPORT_TEMPLATE":
                case "EXPORT_LINK":
                case "EXPORT_PROCEDURE":
                case "EXPORT_TEMPLATE_AND_LINK":
                case "EXPORT_TEMPLATE_AND_LINK_AND_PROCEDURE":
                    return this.exportPrintTemplate;

                case 'CHECK_SUMS_MENU':
                case 'SETTINGS_MENU':
                case 'MENU-1737822498':
                case 'ADD_MENU':
                case 'EXPORT_MENU_TEMP':
                    return null;
            }
            return sc.getTbarClickHandler.apply(this, arguments);
        },

        saveChanges: function() {
            var view = this.parentView || this;
            view.serverCall({
                method: 'ChachedValuesAndValidateChanges',
                params: [view.cachedValues],
                waitMessage: 'Сохранение изменений...',
                success: view.validateCallback
            });
        },

        validateCallback: function(result) {
            if (result["hasFatalErrors"]) return;
            var view = this;
            if (result["hasNotFatalErrors"]) {
                KS.confirm("Игнорировать найденные ошибки?", "Внимание", function (btn) {
                    if (btn === 'yes') {
                        if (result["hasTabCellChanges"]) {
                            view.showTabCellChangesWin();
                        } else {
                            view.doSaveChanges();
                        }
                    }
                });
            } else if (result["hasTabCellChanges"]) {
                this.showTabCellChangesWin();
            } else {
                this.doSaveChanges();
            }
        },

        doSaveChanges: function() {
            this.serverCall({
                method: 'SaveChanges',
                waitMessage: 'Сохранение...',
                success: this.saveChangesCallback
            });
        },

        saveChangesCallback: function(hasError) {
            if (!hasError) {
                this.discardChanges();
                KS.defer(this.reload, null, this, 0); // почему то this.reload() тут не работает
                this.cachedValues = [];
            }
        },
  
        showTabCellChangesWin: function() {
            var view = this;
            this.tabCellChangesWin = KS.showModal(view.updateModeGroup = new Ext.form.RadioGroup({
                    columns: 1,
                    vertical: true,
                    items: [
                        { boxLabel: 'Не обновлять значения по умолчанию в существующих формах', name: 'updateMode', inputValue: '0', checked: true },
                        { boxLabel: 'Обновить значения по умолчанию в формах в статусе - Запланирован, Редактирование', name: 'updateMode', inputValue: '1' },
                        { boxLabel: 'Обновить значения по умолчанию во всех формах', name: 'updateMode', inputValue: '2'}
                    ]
                }),
                {
                    title: 'Обновление фиксированных значений в отчётах',
                    autoHeight: false,
                    layout: "fit",
                    minWidth: 400,
                    minHeight: 150,
                    width: 700,
                    height: 200,
                    buttonAlign: 'left',
                    buttons: ['->',
                        {
                            text: 'ОК',
                            cls: 'dim-button',
                            handler: function() {
                                var updateMode = view.updateModeGroup.getValue().updateMode;
                                view.saveChangesWithUpdateMode(updateMode);
                            }
                        },
                        { xtype: 'tbspacer', width: 8 },
                        {
                            text: 'Отмена',
                            cls: 'dim-button',
                            handler: function() {
                                view.tabCellChangesWin.close();
                            }
                        }]
                },
                true);
        },

        saveChangesWithUpdateMode: function(mode) {
            this.tabCellChangesWin.close();
            this.serverCall({
                method: 'SaveChangesWithUpdateMode',
                params: [mode],
                waitMessage: 'Сохранение...',
                success: this.saveChangesCallback
            });
        },

        // Если сохраняем скопированную форму, то предлагаем скопировать еще и КС
        onServerCopySourceCheckSums: function(link){
            var view = this;
            KS.confirm("Скопировать контрольные соотношения?", "Внимание", function (btn) {
                if (btn === 'yes')
                    view.serverCall({
                        method: 'CopySourceCheckSums',
                        params: [link]
                    });
            });
        },

        resetView: function () {
            this.addGeneralPropertyGrid();
            
            this.groupsGrid.reload();
            this.taskAttributesGrid.reload();
            this.formAttributeGrid.reload();
            this.formatListGrid.reload();
            this.formatDescriptionGrid.reload();
            this.printTemplatesGrid.reload();
            this.filesGrid.reload();
            this.edsSchemaGrid.reload();

            this.refreshAllTables();
        },

        refreshAllTables: function () {
            this.eachTable(function (tableView) {
                if (tableView.isActiveView()) {
                    try {
                        tableView.doRefreshTable();
                    } catch (e) {
                        KS.log('RefreshTable failed: ' + e);
                    }
                } else {
                    tableView.needRefresh = true;
                }
            });
        },

        eachTable: function (fn) {
            Ext.each(this.childViews, function (tableView) {
                if (tableView && fn && typeof (fn) == 'function') {
                    fn.call(tableView, tableView);
                }
            });
        },

        newHandler: function() {
            var view = this.parentView || this,
                grid = view[this.gridPropertyName];
            if (grid) {
                view.serverCall({
                    method: 'AddNewRow',
                    disableFog : true,
                    params: [this.gridPropertyName]
                });
            }
        },

        deleteHandler: function() {
            var view = this.parentView || this;
            var gridId = this.gridPropertyName;
            if (!view[gridId]) return;
            var ccc = view[gridId].getCheckedCodes(true);
            if (Ext.isEmpty(ccc)) return;
            KS.confirm("Удалить выделенные строки?", "Подтвердите удаление", function (btn) {
                if (btn === 'yes')
                    view.deleteHandlerInternal(ccc, gridId);
            });
        },

        deleteHandlerInternal: function (ccc, gridId) {
            var view = this;
            this.serverCall({
                method: 'DeleteRows',
                params: [gridId, ccc],
                waitMessage: 'Удаление ...',
                success: function(deleted) {
                    if (deleted) {
                        view[gridId].reload();
                        view.touch();
                    }
                }
            });
        },

        onGenerate: function() {
            var view = this.parentView || this;
            if (view.data.identifier.Link > 0 && 
                view.data.tablesCount > 0) {
                KS.confirm("Обновить структуры таблиц?", "Внимание", function (btn) {
                    if (btn === 'yes')
                        view.serverCall({
                            method: 'OnGenerate',
                            waitMessage: 'Генерация таблиц...'
                        });
                });
            } else {
                KS.alert("Нет таблиц для обновления структур", "Внимание");
            }
        },

        setPrintSettings: function() {
            var view = this.parentView || this;
            view.serverCall({
                method: 'SetPrintSettings',
                disableFog: true
            });
        },

        openDefaultEODFormats: function() {
            var view = this.parentView || this;
            view.serverCall({
                method: 'OpenDefaultEODFormats',
                disableFog: true
            });
        },

        addNewFile: function() {
            var view = this.parentView || this;
            view.serverCall({
                method: 'AddNewFile',
                success: view.changeFilesCallback
            });
        },

        openSelectFiles: function() {
            var view = this.parentView,
                links = this.parentView.getCheckedFileRows('LINK_FILE');
            if (Ext.isEmpty(links))
                return;
            view.serverCall({
                method: 'OpenFiles',
                params: [links],
                success: function (ulrList) {
                    Ext.each(ulrList, function (url) {
                        KS.downloadFile(url);
                    });
                }
            });
        },

        deleteSelectFiles: function() {
            var view = this.parentView,
                links = this.parentView.getCheckedFileRows('LINK_FILE');
            if (Ext.isEmpty(links))
                return;
            view.serverCall({
                method: 'DeleteFiles',
                params: [links],
                success: view.changeFilesCallback
            });
        },

        changeFilesCallback: function() {
            this.filesGrid.reload();
            this.touch();
        },

        addEODExistsFormat: function(){
            var view = this.parentView;
            view.serverCall({
                method: 'AddEODExistsFormat',
                disableFog: true
            });
        },

        addNewEODFormat: function() {
            var view = this.parentView;
            view.createEODFormatPropGrid("NEW", null);
        },

        editEODFormat: function() {
            var view = this.parentView;
            var closeCodes = view.formatListGrid.getCheckedCodes();
            if (closeCodes.length > 0) 
                view.createEODFormatPropGrid("EDIT", closeCodes[0]);
        },

        dblclickFormatListGrid: function(gridView, td, cellIndex, record) {
            var closeCode = KS.Grid.getAnyCase(record, gridView.grid.closeCode);
            if (closeCode) 
                this.createEODFormatPropGrid("EDIT", closeCode);
            return false;
        },

        addNewEODFormatDesc: function() {
            var view = this.parentView || this;
            var checkedRows = view.formatListGrid.getCheckedRows();
            if (checkedRows.length > 0) {
                var linkFormat = KS.Grid.getAnyCase(checkedRows[0], "LINK_EXCHANGE_FORMAT");
                var closeCodeName = view.formatDescriptionGrid.closeCode;
                view.serverCall({
                    method: 'AddEODDescRow',
                    disableFog: true,
                    params: [linkFormat, closeCodeName],
                    success: function(dataRow) {
                        view.formatDescriptionGrid.addRecord(dataRow);
                        view.touch();
                    }
                });
            }
        },

        editEODFormatDesc: function() {

        },

        addExistsPrintTemplate: function() {
            var view = this.parentView || this;
            view.serverCall({
                method: 'AddExistsPrintTemplate',
                disableFog: true
            });
        },

        editPrintTemplate: function () {
            var view = this.parentView || this;
            var closeCodes = view.printTemplatesGrid.getCheckedCodes();

            if (closeCodes.length === 0) {
                KS.alert('Шаблон не выбран.', 'Редактирование шаблона');
                return;
            }

            view.serverCall({
                method: 'EditPrintTemplate',
                params: [closeCodes[0], view.printTemplatesGrid.closeCode],
                success: function (templateName) {
                    if (!Ext.isEmpty(templateName)) {
                        view.tryOpenTemplate(templateName);
                    }
                }
            });
        },

        tryOpenTemplate: function (templateName) {
            //Из-за проблем с передачей имени шаблона во вью из презентера используется setInterval
            var retrice = 0;
            var intervalID = setInterval(function () {
                var templateManagerView = KS.findSingleView('customName', 'TemplateManagerView');

                if (templateManagerView == null)
                    return;

                if (templateManagerView && templateManagerView.rendered) {
                    templateManagerView.openTemplateByName(templateName);
                }

                if (++retrice === 20 || templateManagerView.rendered) {
                    window.clearInterval(intervalID);
                }
            }, 1000); 
        },

        copyPrintTemplate: function() {
            var view = this.parentView || this;
            var closeCodes = view.printTemplatesGrid.getCheckedCodes();
            if (closeCodes.length > 0) {
                view.serverCall({
                    method: 'CopyPrintTemplate',
                    params: [closeCodes[0], view.printTemplatesGrid.closeCode],
                    disableFog: true,
                    success: function(result) {
                        if (result) {
                            view.printTemplatesGrid.reload();
                            view.touch();
                        }
                    }
                });
            }
        },

        exportPrintTemplate: function() {
            var view = this.parentView;
            var code = this.tbarNode.code;
            var closeCodes = view.printTemplatesGrid.getCheckedCodes();
            if (closeCodes.length > 0) {
                view.serverCall({
                    method: 'ExportPrintTemplate',
                    params: [closeCodes[0], view.printTemplatesGrid.closeCode, code]
                });
            }
        },

        createNewTemplateByStruct: function() {
            var view = this.parentView || this;
            view.serverCall({
                method: 'DoLoadDataForNewTemplate'
            });
        },

        editEdsSchema: function() {
            var view = this.parentView || this,
                checkedCodes = view.edsSchemaGrid.getCheckedCodes();

            if (checkedCodes.length === 0)
                return;

            view.serverCall({
                method: 'EditEdsSchema',
                params: [checkedCodes[0]]
            });
        },
        
        setDefaultsAttrValues: function() {
            var view = this.parentView || this;
            var gridId = this.gridPropertyName;
            var grid = view[gridId];
            if (!grid) return;
            var ccc = grid.getCheckedCodes(this);
            if (Ext.isEmpty(ccc)) return;
            var message = ccc.length > 1
                ? "Установить значение по умолчанию для выбранных строк?"
                : "Установить значение по умолчанию для выбранной строки?";
            KS.confirm(message, "Внимание", function (btn) {
                if (btn === 'yes')
                    view.serverCall({
                        method: 'SetDefaultsAttrValues',
                        disableFog : true,
                        params: [gridId, ccc],
                        success: function(result) {
                            if (result) {
                                grid.reload();
                                view.touch();
                            }
                        }
                    });
            });
        },

        checkSumsInDocument: function() {
            var view = this.parentView;
            view.serverCall({
                method: 'CheckSumsInDocument',
                disableFog : true
            });
        },

        copyCheckSums: function() {
            var view = this.parentView;
            view.serverCall({
                method: 'CopyCheckSums',
                disableFog : true
            });
        },

        onServerConfirmCopyCheckSums: function(formName, linkForm) {
            var view = this;
            KS.confirm("Копировать правила КС в форму " + formName + "?", "Внимание", function (btn) {
                if (btn === 'yes') {
                    view.serverCall({
                        method: 'ConfirmCopyCheckSums',
                        params: [formName, linkForm]
                    });
                }
            });            
        }
    });
}(ReportStructView.prototype));

// ============= TABLES =======================
(function (viewClass) {
    KS.apply(viewClass, {
        activateTabHandler: function (tabPanel, newTab) {
            var idParts = newTab.ctrlId.split('_');
            if (idParts[0] !== 'TABLE') {
                return;
            }
            var tableLink = +idParts[1];
            
            if (newTab.nestedView) {
                // Opened
                if (newTab.nestedView.needRefresh) {
                    newTab.nestedView.doRefreshTable.apply(newTab.nestedView);
                    newTab.nestedView.needRefresh = false;
                }
            } else {
                // Not opened
                this.openTable(tableLink);
            }
        },

        openTable: function (tableLink) {
            this.serverCall({
                method: 'OpenTable',
                waitMsg: 'Открытие таблицы ...',
                params: [tableLink]
            });
        },

        addChildView: function (panel) {
            if (!this.rootTabPanel) {
                // Parent view is not ready, render child later
                if (!this.deferredAddChildViews) {
                    this.deferredAddChildViews = [];
                }
                this.deferredAddChildViews.push(panel);
                return true;
            }
            var tab = this.rootTabPanel.getActiveTab();
            var tabIndex = this.rootTabPanel.items.indexOf(tab);
            if (tabIndex > 0) {
                panel.tbar = false;
                panel.header = false;
                tab.add(panel);
                var tableView = eval(panel.classInstance);
                if (tableView) {
                    this.childViews[tabIndex] = tableView;
                    tableView.parentView = this;
                    tab.nestedView = tableView;
                }
                KS.updateLayout(tab);
                return true;
            }
            return false;
        },

        onDependentChanged: function () {
            if (KS.isEmpty(this.dependentViews)) return;
            KS.updateLayout(this.containerPanel);
        },

        addNewTable: function() {
            var view = this.parentView || this;
            if (Ext.isEmpty(this.data.beginDate)) {
                KS.alert("Не указана дата начала действия формы", "Внимание");
                return false;
            }
            var tableCount = view.rootTabPanel.items.length;
            var title = 'Таблица ' + (tableCount - 1);
            var order = tableCount > 1 ? tableCount - 1 : 0;
            var code = order.toString();
            if (code.Length < 3)
            {
                while (code.Length !== 3)
                {
                    code = "0" + code;
                }
            }
            view.serverCall({
                method: 'AddNewTable',
                disableFog : true,
                params: [title, order, code],
                success: view.insertNewTable
            });
            return false;
        },

        insertNewTable: function(table, newTableIndex) {
            var newTable = this.createTemplateControl(table);
            if (Ext.isEmpty(newTableIndex)) {
                newTableIndex = this.rootTabPanel.items.length - 1;
            }
            var newTab = this.rootTabPanel.insert(newTableIndex, newTable);
            this.rootTabPanel.setActiveTab(newTab);
            this.data.tablesCount++;
            this.touch();
        },

        copyTable: function(tableLink) {
            var view = this;
            this.serverCall({
                method: 'CopyTable',
                params: [tableLink],
                success: function(table) {
                    var sourceTable = view.rootTabPanel.getActiveTab();
                    var newTabIndex = view.rootTabPanel.items.indexOf(sourceTable) + 1;
                    view.insertNewTable(table, newTabIndex);
                }
            });
        },

        deleteTable: function(tableLink) {
            var view = this;
            this.serverCall({
                method: 'DeleteTable',
                params: [tableLink],
                success: function() {
                    var deleteTab = view.rootTabPanel.getActiveTab();
                    view.rootTabPanel.setActiveTab(0);
                    view.rootTabPanel.remove(deleteTab);
                    view.data.tablesCount--;
                    view.touch();
                }
            });
        }
    });
}(ReportStructView.prototype));

// ============= REPORT ATTRIBUTE =======================
(function (viewClass) {
    KS.apply(viewClass, {
        taskAttributeOperation: function() {
            var view = this.parentView;
            var code = this.tbarNode.code;
            var checkedCodes = view.taskAttributesGrid.getCheckedCodes(true);
            if (checkedCodes.length > 0) {
                view.serverCall({
                    method: 'TaskAttributeOperation',
                    disableFog: true,
                    params: [checkedCodes, code],
                    success: function() {
                        view.taskAttributesGrid.reload();
                        view.touch();
                    }
                });
            }
        },
        
        editReportAttrGridCell: function(edPlugin, context) {
            if (context.field === "SVOD_ALL" &&  // Неключевой атрибут не может быть сводным (с) Антон
                context.value === true) {
                var isCode = KS.Grid.getAnyCase(context.record, "IS_CODE");
                if (isCode === false) {
                    context.record.set("SVOD_ALL", false);
                    return;
                }
            }
            if (context.column.aspType === "checkcolumn")
                return false;
            this.editGridCell(edPlugin, context);
        },

        cellClickReportAttrGrid: function(gridView, td, cellIndex, record, tr, rowIndex, e){
            var col = e.position.column;
            if (col.aspType === "checkcolumn"){
                var newValue = KS.Grid.getAnyCase(record, col.dataIndex);
                var context = {
                    value : newValue,
                    originalValue : !newValue,
                    grid : gridView.grid,
                    record : record,
                    field : col.dataIndex
                }
                this.editGridCell(null, context);                
            }
        },

        cellDblClickReportAttrGrid: function(gridView, td, cellIndex, record, tr, rowIndex, e) {
            var col = e.position.column;
            if (col.dataIndex === "VISUAL_SCHEMA") {
                var cellValue = KS.Grid.getAnyCase(record, e.position.column.dataIndex);
                var closeCode = KS.Grid.getAnyCase(record, gridView.grid.closeCode);
                this.editFilterValue(cellValue, closeCode);
                return false;
            }
            if (col.aspType === "checkcolumn")
                return false;
            return true;
        },

        editFilterValue: function(cellValue, closeCode) {
            this.serverCall({
                method: 'GetEditFilterGrid',
                params: [cellValue],
                disableFog: true,
                success: function(grid) {
                    this.showEditFilterGrid(grid, closeCode);
                }
            });
        },

        showEditFilterGrid: function(grid, closeCode) {
            if (grid) {
                var view = this;
                this.editFilterGrid = this.createTemplateControl(grid);
                this.editFilterWin = KS.showModal(this.editFilterGrid,
                {
                    title: 'Фильтр',
                    autoHeight: false,
                    layout: "fit",
                    minWidth: 400,
                    minHeight: 300,
                    width: Math.max(400, KS.rootViewport.getWidth() / 2),
                    height: Math.max(300, KS.rootViewport.getHeight() / 1.5),
                    buttonAlign: 'left',
                    buttons: ['->',
                        {
                            text: 'ОК',
                            cls: 'dim-button',
                            handler: function() {
                                view.setNewFilterValue(closeCode);
                            }
                        },
                        { xtype: 'tbspacer', width: 8 },
                        {
                            text: 'Отмена',
                            cls: 'dim-button',
                            handler: function() {
                                view.editFilterWin.close();
                            }
                        }]
                },
                true);
            }
        },

        setNewFilterValue: function(closeCode) {
            var view = this;
            this.serverCall({
                method: 'SetNewFilterValue',
                disableFog: true,
                params: [closeCode],
                success: function(newFilterValue) {
                    if (newFilterValue != null) {
                        var attrRow = view.taskAttributesGrid.findRecord(closeCode);
                        if (attrRow != null) {
                            attrRow.set("VISUAL_SCHEMA", newFilterValue);
                            view.touch();
                        }
                    }
                    view.editFilterWin.close();
                }
            });
        },

        filterGridDblClick: function(gridView, td, cellIndex, record, tr, rowIndex, e) {
            var dataIndex = e.position.column.dataIndex;
            if (["LEFT_ITEM_VALUE", "RIGHT_ITEM_VALUE", "FILTER_WHERE"].indexOf(dataIndex) !== -1) {
                var leftItemType = KS.Grid.getAnyCase(record, "LEFT_ITEM_TYPE");
                if (dataIndex === "LEFT_ITEM_VALUE" && (leftItemType === "TaskAttribute" || leftItemType === "Column")) {
                    return this.changeFilterGridCellEditor(gridView.grid, leftItemType);
                }
                var value = KS.Grid.getAnyCase(record, dataIndex);
                this.showPopupFilterEditor(value, record, dataIndex);
                return false;
            }
            return true;
        },

        changeFilterGridCellEditor: function(grid, leftItemType) {
            var column = grid.getColConfigByKey("LEFT_ITEM_VALUE");

            if (leftItemType === "TaskAttribute")
                column.dataIndex = "LEFT_ITEM_VALUE_ATTR";
            else if (leftItemType === "Column")
                column.dataIndex = "LEFT_ITEM_VALUE_COLUMN";

            try {
                column.vlItems = null;
                var editorType = eval(window.valuesListEditor);
                column.editor = new editorType({
                    grid : grid,
                    col : column
                });
                return true;
            } catch (e) {
                return false;
            }
        },

        showPopupFilterEditor: function (originalValue, record, dataIndex) {
            var view = this;
            view.pseWin = KS.showModal({
                xtype: 'textarea',
                itemId: 'pseArea',
                value: originalValue
            },{
                layout: 'fit',
                plain: true,
                frame: true,
                autoScroll: true,
                modal: true,
                maximizable: true,
                minWidth: 500,
                minHeight: 400,
                width: Math.max(500, KS.rootViewport.getWidth() / 3),
                height: Math.max(400, KS.rootViewport.getHeight() / 2),
                title: "Редактирование...",
                buttonAlign: 'left',
                buttons: ['->', {
                        text: 'ОК',
                        cls: 'dim-button',
                        handler: function () {
                            var newValue = view.pseWin.getComponent("pseArea").getValue();
                            record.set(dataIndex, newValue);
                            var context = {
                                originalValue : originalValue,
                                value : newValue,
                                field: dataIndex,
                                record: record
                            }
                            view.filterGridEditCell(null, context);
                            view.pseWin.close(true);
                        }
                    }, { xtype: 'tbspacer', width: 8 },
                    {
                        text: 'Отмена',
                        cls: 'dim-button',
                        handler: function() {
                            view.pseWin.close();
                        }
                    }]
            }, true);

            view.pseWin.getComponent("pseArea").selectText(originalValue.length);
        },

        filterGridEditCell: function(edPlugin, context) {
            var dataIndex = context.field;
            if (dataIndex === "LEFT_ITEM_VALUE_ATTR" || dataIndex === "LEFT_ITEM_VALUE_COLUMN") {
                var colCfg = context.grid.getColConfigByKey(dataIndex);
                dataIndex = "LEFT_ITEM_VALUE";
                colCfg.dataIndex = dataIndex;
            }
            if (context.originalValue !== context.value) {
                var closeCode = KS.Grid.getAnyCase(context.record, this.editFilterGrid.closeCode);
                var newValue = context.value;
                this.serverCall({
                    method: 'FilterGridEditCell',
                    disableFog: true,
                    params: [closeCode, dataIndex, newValue],
                    success: function(result) {
                        if (result === false) 
                            context.record.reject();
                    }
                });
            }
        },

        newFilterRow: function() {
            var view = this.parentView;
            view.serverCall({
                method: 'NewFilterRow',
                disableFog: true,
                success: function(dataRow) {
                    view.editFilterGrid.addRecord(dataRow);
                }
            });
        },

        deleteFilterRow: function() {
            var view = this.parentView;
            var closeCodes = view.editFilterGrid.getCheckedCodes();
            if (Ext.isEmpty(closeCodes)) return;
            var checkedRows = view.editFilterGrid.getCheckedRows();
            view.serverCall({
                method: 'DeleteFilterRows',
                params: [closeCodes],
                disableFog: true,
                success: function(result) {
                    if (result) {
                        view.editFilterGrid.getStore().remove(checkedRows);
                    }
                }
            });
        },

        copyFilterRow: function() {
            var view = this.parentView;
            var closeCodes = view.editFilterGrid.getCheckedCodes();
            if (Ext.isEmpty(closeCodes)) return;
            view.serverCall({
                method: 'CopyFilterRow',
                params: [closeCodes[0]],
                disableFog: true,
                success: function(dataRow) {
                    view.editFilterGrid.addRecord(dataRow);
                }
            });
        },

        upFilterRow: function() {
            var view = this.parentView;
            var closeCodes = view.editFilterGrid.getCheckedCodes();
            if (Ext.isEmpty(closeCodes)) return;
            var checkedRows = view.editFilterGrid.getCheckedRows();
            view.serverCall({
                method: 'MoveUpFilterRow',
                params: [closeCodes[0]],
                disableFog: true,
                success: function(newOrder) {
                    if (!Ext.isEmpty(newOrder)) {
                        var topRow = view.editFilterGrid.getStore().getAt(newOrder);
                        view.editFilterGrid.getStore().remove(checkedRows[0]);
                        checkedRows[0].set("ORDER", newOrder);
                        view.editFilterGrid.getStore().insert(newOrder, checkedRows[0]);
                        topRow.set("ORDER", newOrder + 1);
                    }
                }
            });
        },

        downFilterRow: function() {
            var view = this.parentView;
            var closeCodes = view.editFilterGrid.getCheckedCodes();
            if (Ext.isEmpty(closeCodes)) return;
            var checkedRows = view.editFilterGrid.getCheckedRows();
            view.serverCall({
                method: 'MoveDownFilterRow',
                params: [closeCodes[0]],
                disableFog: true,
                success: function(newOrder) {
                    if (!Ext.isEmpty(newOrder)) {
                        var bottomRow = view.editFilterGrid.getStore().getAt(newOrder);
                        view.editFilterGrid.getStore().remove(checkedRows[0]);
                        checkedRows[0].set("ORDER", newOrder);
                        view.editFilterGrid.getStore().insert(newOrder, checkedRows[0]);
                        bottomRow.set("ORDER", newOrder - 1);
                    }
                }
            });
        }
    });
}(ReportStructView.prototype));

// ============= PROPERTY GRID =======================
(function (viewClass) {
    KS.apply(viewClass, {
        addGeneralPropertyGrid: function() { //Добавить propertyGrid в Общие
            var view = this;
            view.serverCall({
                method: 'GetGeneralGridData',
                waitMessage: 'Обновление вкладки "Общие" ...',
                success: function(settings) {
                    var generalPanel = view.generalPanel;
                    var propertyGrid = view.getPropertyGridByOption(settings, "generalPropertyGrid", "Общие");
                    propertyGrid.setDisabled(!view.data.isDevelop);
                    propertyGrid.on("propertychange", view.generalPropertyGridChange, view);
                    generalPanel.add(propertyGrid);
                }
            });
        },

        correctPropertyValue: function(value) {
            switch(Ext.typeOf(value)) {
                case "date":
                    value = Ext.util.Format.date(value, 'd.m.Y H:i:s');
                    break;
                case "number":
                    value = value.toString();
                    break;
                case "boolean":
                    value = value ? "True" : "False";
                    break;
                case "array":
                    value = "isPeriod_" + value.join(",");
                    break;
            }
            return value;
        },

        generalPropertyGridChange: function(source, recordId, value, oldValue) {
            if (this.correctValueForEqual(value) !== oldValue) {
                value = this.correctPropertyValue(value);
                var code = recordId.split("#")[1] || "";
                var view = this;
                this.serverCall({
                    method: 'ChangePropertyGridValue',
                    disableFog: true,
                    params: [code, value],
                    success: function(data) {
                        if (!Ext.isEmpty(data)) 
                            view.data = data;
                        view.touch();
                    }
                });
            }
        },

        createEODFormatPropGrid: function(mode, closeCode) {
            var view = this;
            var closeCodeName = this.formatListGrid.closeCode;
            view.serverCall({
                method: 'GetEODPropGridData',
                waitMessage: 'Открывается ...',
                params: [mode, closeCode, closeCodeName],
                success: function(settings) {
                    view.showEODFormatPropGrid(settings, mode === "EDIT", closeCode);
                }
            });
        },

        showEODFormatPropGrid: function(settings, isEdit, closeCode) {
            this.eodFormatGrid = this.getPropertyGridByOption(settings, "eodFormatGrid", "Свойства");
            var view = this;
            this.eodFormatPanel =  KS.showModal(this.eodFormatGrid, {
                title: 'Свойства',
                autoHeight: false,    
                layout: "fit",
                height: 500, 
                minHeight: 200,
                width: 650,
                minWidth: 300,
                buttonAlign: 'left',
                buttons: ['->', {
                        text: 'ОК',
                        cls: 'dim-button',
                        handler: function () {
                            view.editEODFormGrid(isEdit, closeCode);
                        }
                    }, { xtype: 'tbspacer', width: 8 },
                    {
                        text: 'Отмена',
                        cls: 'dim-button',
                        handler: function() {
                            view.cancelCreateEODFormat(isEdit);
                        }
                    }]
            }, true);
        },

        editEODFormGrid: function(isEdit, closeCode) {
            var view = this;
            var newValues = this.eodFormatGrid.source;
            var closeCodeName = this.formatListGrid.closeCode;
            view.serverCall({
                method: 'EditEODFormat',
                params: [newValues, isEdit, closeCode, closeCodeName],
                waitMessage: isEdit ? 'Редактрование ...' : 'Создание ...',
                success: function(result) {
                    if (result === true) {
                        view.formatListGrid.reload();
                        view.eodFormatPanel.close();
                        view.touch();
                    }
                }
            });
        },

        cancelCreateEODFormat: function (isEdit) {
            this.eodFormatPanel.close();
            if (isEdit) return;
            this.serverCall({
                method: 'CancelCreateEODFormat',
                disableFog: true
            });
        }
    });
}(ReportStructView.prototype));

// ============== PRINT TEMPLATE ==============
(function (ViewClass) {
    KS.apply(ViewClass, {
        onServerNewTemplateFilled: function(panel, printFormLink) {
            var view = this;
            view.spreadsheetFrame = view.createTemplateControl(panel);
            view.addPanelItems(panel, view.spreadsheetFrame);
            view.templateWin = KS.showModal(view.spreadsheetFrame, {
                title: 'Печатный шаблон',
                autoHeight: false,
                resizable: true,
                autoScroll: true,
                maximizable: true,
                width: KS.rootViewport.getWidth() * 0.8,
                height: KS.rootViewport.getHeight() * 0.8,
                minHeight: 300,
                minWidth: 400,
                buttonAlign: 'left',
                buttons: ['->', {
                    text: 'ОК',
                    cls: 'dim-button',
                    handler: function () {
                        view.spreadsheetFrame.saveDocument(function () {
                            view.saveNewPrintTemplate(printFormLink);
                        }, view);
                    }
                }, { xtype: 'tbspacer', width: 8 },
                    {
                        text: 'Отмена',
                        cls: 'dim-button',
                        handler: function () {
                            view.rejectPrintTemplateCreation(printFormLink);
                        }
                    }]
            }, true);
        },

        saveNewPrintTemplate: function (printFormLink) {
            var view = this;
            var templateCode = view.getToolbarItem(view.spreadsheetFrame, null, 'templateCode').getValue();

            if (Ext.isEmpty(templateCode)) {
                KS.error('Пустое наименование шаблона');
                return;
            }

            view.serverCall({
                method: 'SaveNewPrintTemplate',
                params: [printFormLink, templateCode],
                success: function (success) {
                    if (success) {
                        view.printTemplatesGrid.reload();
                        view.touch();
                    }
                    else {
                        KS.alert('Обнаружены ошибки в шаблоне');
                    }
                    view.templateWin.close();
                }
            });
        },

        rejectPrintTemplateCreation: function (printFormLink) {
            var view = this;
            view.serverCall({
                method: 'RejectPrintTemplateCreation',
                params: [printFormLink],
                success: function () {
                    view.templateWin.close();
                }
            });
        }
    });
}(ReportStructView.prototype));

Ext.define('ReportStruct.numberEditor',
    {
        extend: 'Ext.form.TextField',
        allowBlank: true,
        maskRe: /[0-9.,-]/
    });

function reportStructDateRenderer(value) {
    if (!Ext.isEmpty(value) && (new Date(value) != "Invalid Date") && (Ext.isString(value) &&value.indexOf("GMT") !== -1)) {
        value = new Date(value);
    }
    if (Ext.isString(value) && !Ext.isEmpty(value)) {
        value = value.substring(0, 10);
    } else {
        value = Ext.util.Format.date(value, 'd.m.Y');
    }
    return (value === '06.06.2079') ? '' : value;
}

function reportStructLabelRenderer(value, metadata) {
    if (Ext.isEmpty(value)) {
        value = "(Пусто)";
        if (metadata.css == null) metadata.css = "";
        metadata.css += " emptyAttrNameAppearance";
    }
    return value;
}

function reportStructAttrFormRenderer(value, metadata, record) {
    var linkDiction = KS.Grid.getAnyCase(record, "link_diction");
    if (!Ext.isEmpty(linkDiction)) {
        metadata.css += ' sidewall-dict-cell';
    }
    return value;
}

function reportStructFilterRenderer(value, metadata) {
    value = value.replace(/</g, "&lt;").replace(/>/g, "&gt;");
    setTooltip(metadata, value);
    metadata.css += ' sidewall-dict-cell';
    return value;
}

function reportStructValuesListRenderer(value, metadata, record, rowIndex, colIndex, store) {
    var vl = store.grid.valueLists;
    if (vl) {
        var colCfg = store.grid.getColCfgByIndex(colIndex);
        var colDataIndex = colCfg.dataIndex;

        var leftItemType = KS.Grid.getAnyCase(record, "LEFT_ITEM_TYPE");
        if (colDataIndex === "LEFT_ITEM_VALUE" &&
            (leftItemType === "TaskAttribute" || leftItemType === "Column")) {
            if (leftItemType === "TaskAttribute")
                colDataIndex = "LEFT_ITEM_VALUE_ATTR";
            else if (leftItemType === "Column")
                colDataIndex= "LEFT_ITEM_VALUE_COLUMN";
            colCfg.vlItems = null;
        }

        if (!colCfg.vlItems) {
            colCfg.vlItems = {};
            Ext.each(vl, function (vlEl) {
                if (vlEl.ColumnKey.toUpperCase() === colDataIndex.toUpperCase()) {
                    Ext.each(vlEl.Items, function (item) {
                        colCfg.vlItems[item.StringDataValue] = item.DisplayText;
                    });
                }
            });
        }
        return colCfg.vlItems[value] || value;
    }
    return value;
}

function reportStructSchemaRenderer(value) {
    return value.replace(/</g, "&lt;").replace(/>/g, "&gt;");
}

if (typeof(Sys) !== 'undefined') Sys.Application.notifyScriptLoaded();