﻿ReportStructExcelCreationView = KS.extend(BaseSvodView, {
    customName: 'ReportStructExcelCreationView'
});

// ================ COMMON ====================
(function (viewClass) {
    KS.apply(viewClass, {
        tableStructSelections: {},

        titleColor: "#ffff35",
        sidewallColor: "#d5ffaa",
        keyColor: "#bfcef9",
        disabledColor: "#838383",

        activateTabHandler: function (tabPanel, openedTab) {
            var view = this;

            if (openedTab.ctrlId === 'newTableButtonTab') // если кнопка создания новой таблицы
                return;

            var excelTablePanel = openedTab;

            if (excelTablePanel.spreadsheetView) {
                // Opened
                if (excelTablePanel.spreadsheetView.needRefresh) {
                    excelTablePanel.spreadsheetView.doRefreshTable.apply(excelTablePanel.spreadsheetView);
                    excelTablePanel.spreadsheetView.needRefresh = false;
                }
            } else {
                // Not opened
                view.openSpreadsheetView(excelTablePanel);
            }
        },

        addChildView: function (panel) {
            var view = this,
                excelTablePanel = view.excelTablesTabPanel.getActiveTab();

            if (!this.excelTablesTabPanel) {
                return view.deferPanelToQueue(panel);
            }

            panel.header = false;

            if (excelTablePanel) {
                excelTablePanel.removeAll();
                excelTablePanel.add(panel);
                var childView = eval(panel.classInstance);
                if (childView) {
                    if (!view.childViews) view.childViews = [];
                    view.childViews.push(childView);
                    excelTablePanel.spreadsheetView = childView;
                    childView.parentView = view;
                    childView.excelTablePanel = excelTablePanel;
                }
                KS.updateLayout(excelTablePanel);
                excelTablePanel.mask('Загрузка excel-документа...');
                setTimeout(() => excelTablePanel.unmask(), 5000);
                return true;
            }

            return false;
        },

        deferPanelToQueue: function (panel) {
            // Parent view is not ready, render child later
            if (!this.deferredAddChildViews) {
                this.deferredAddChildViews = [];
            }
            this.deferredAddChildViews.push(panel);
        },

        onSetSavedState: function(saved) {
            var view = this;
            if (Ext.isEmpty(view.mainPanel) || Ext.isEmpty(view.mainPanel.dockedItems)) return;
            var saveBtn = view.getToolbarItem(view.mainPanel, null, 'SAVE');
            if (saveBtn)
                saveBtn.setDisabled(saved);
        },

        insertNewTable: function(excelTablePanel) {
            var view = this;
            var newTable = view.createTemplateControl(excelTablePanel);
            var newTab = view.excelTablesTabPanel.insert(excelTablePanel.json.structTableIndex, newTable);
            view.excelTablesTabPanel.setActiveTab(newTab);
            view.touch();
        },

        getFormRequisites: function () {
            var view = this;

            var formRequisites= {
                formCode: null,
                formName: null,
                beginDateYear: null,
                beginDateMonth: null,
                beginDateDay: null,
                endDateYear: null,
                endDateMonth: null,
                endDateDay: null,
                periodType: null,
                isAutofill: false,
                isSystem: false,
                comment: null
            };

            formRequisites.formCode = view.formCode.getValue();
            formRequisites.formName = view.formName.getValue();

            var beginDate = view.formBeginDate.getValue();
            formRequisites.beginDateYear = beginDate.getFullYear();
            formRequisites.beginDateMonth = beginDate.getMonth();
            formRequisites.beginDateDay = beginDate.getDate();

            var endDate = view.formEndDate.getValue();
            formRequisites.endDateYear = endDate != null ? endDate.getFullYear() : null;
            formRequisites.endDateMonth = endDate != null ? endDate.getMonth() : null;
            formRequisites.endDateDay = endDate != null ? endDate.getDate() : null;

            formRequisites.comment = view.formComment.getValue();

            formRequisites.isAutofill = view.AutofillCheckbox.checked;
            formRequisites.isSystem = view.SystemCheckbox.checked;

            formRequisites.periodType = view.getPeriodType();

            return formRequisites;
        },

        getPeriodType: function () {
            var view = this,
                periodStr = '';

            periodStr += view.DailyCheckbox.checked ? '1' : 0;
            periodStr += view.WeeklyCheckbox.checked ? '1' : 0;
            periodStr += view.MonthlyCheckbox.checked ? '1' : 0;
            periodStr += view.QuarterlyCheckbox.checked ? '1' : 0;
            periodStr += view.YearlyCheckbox.checked ? '1' : 0;

            return periodStr;
        },

        checkIsValidFormData: function (formRequisites) {
            if (formRequisites.periodType === '00000') {
                KS.error("Не выбран ни один тип периодичности формы", "Ошибка");
                return false;
            }

            return true;
        },

        createFormByExcel: function (reportTableStructs) {
            var view = this;
            var formRequisites = view.getFormRequisites();

            var allFormDataValid = view.checkIsValidFormData(formRequisites);
            if (!allFormDataValid)
                return;

            view.serverCall({
                method: 'CreateFormByExcel',
                params: [reportTableStructs, formRequisites, view.tableStructSelections],
                success: function (result) {
                    if (result && result.success && result.link > 0) {
                        view.discardChanges();
                        var message = `Форма с кодом '${formRequisites.formCode}' создана. Открыть созданную форму в стандартном конструкторе форм?`;
                        KS.confirm(message, 'Внимание', function (btn) {
                            if (btn !== 'yes') return;
                            view.openCreatedReportStruct(result.link);
                        });
                    }
                    else {
                        view.reloadAllExcels();
                    }
                }
            });
        },

        openCreatedReportStruct: function (link) {
            var view = this;
            view.serverCall({
                method: 'OpenCreatedReportStruct',
                params: [link],
                success: function () {
                    view.close();
                }
            })
        }
    });
}(ReportStructExcelCreationView.prototype));

// =============== TOOLBAR ====================
(function (viewClass) {
    KS.apply(viewClass, {
        saveChanges: function () {
            var view = this.parentView || this;
            var reportTableStructs = [];
            Ext.each(view.childViews, function (spreadsheetView) {
                var state = spreadsheetView.getSpreadsheetState();
                var excelTablePanel = spreadsheetView.excelTablePanel;
                var tableStruct = {
                    spreadsheetClientState: state,
                    spreadsheetViewId: spreadsheetView.viewID,
                    tableName: excelTablePanel.getTitle(),
                    tableIndex: view.excelTablesTabPanel.items.indexOf(excelTablePanel)
                };
                reportTableStructs.push(tableStruct);
            });

            view.createFormByExcel(reportTableStructs);
        },

        addNewTable: function() {
            var view = this.parentView || this;
            var tableCount = view.excelTablesTabPanel.items.length;
            var tableIndex = tableCount > 1 ? tableCount - 1 : 0;
            view.serverCall({
                method: 'AddNewTable',
                disableFog : true,
                params: [tableIndex],
                success: view.insertNewTable
            });

            return false; // prevent activating for fake tab
        },

        editTableName: function () {
            var view = this.parentView || this;
            var spreadsheetView = view.getCurrentSpreadsheetView();
            var panel = spreadsheetView.excelTablePanel;
            KS.prompt('Введите новое имя таблицы', 'Переименование таблицы', panel.getTitle(), function (name) { panel.setTitle(name); });
        },

        deleteTable: function () {
            var view = this.parentView || this;
            var spreadsheetView = view.getCurrentSpreadsheetView();
            delete view.tableStructSelections[spreadsheetView.viewID];
            view.excelTablesTabPanel.remove(spreadsheetView.excelTablePanel);
            var viewIdx = view.childViews.indexOf(spreadsheetView);
            view.childViews.splice(viewIdx, 1);
            spreadsheetView.close();
        },

        reloadCurrentExcel: function () {
            var view = this.parentView || this;
            var spreadsheetView = view.getCurrentSpreadsheetView();
            spreadsheetView.reloadFrame();
        },

        reloadAllExcels: function () {
            var view = this.parentView || this;
            Ext.each(view.childViews, function (spreadsheetView) {
                spreadsheetView.reloadFrame();
            })
        },

        setTitleCells: function () {
            var view = this.parentView || this;
            var spreadsheetView = view.getCurrentSpreadsheetView();
            var selection = spreadsheetView.getSelection();
            if (!view.tableStructSelections[spreadsheetView.viewID])
                view.tableStructSelections[spreadsheetView.viewID] = {};
            view.tableStructSelections[spreadsheetView.viewID].titleCells = selection; // todo: нет учета пересечения областей
            view.setColorForSelection(spreadsheetView, view.titleColor, selection);
        },

        setSidewallCells: function () {
            var view = this.parentView || this;
            var spreadsheetView = view.getCurrentSpreadsheetView();
            var selection = spreadsheetView.getSelection();
            view.tableStructSelections[spreadsheetView.viewID].sidewallCells = selection; // todo: нет учета пересечения областей
            view.setColorForSelection(spreadsheetView, view.sidewallColor, selection);
        },

        setKeyColumnsCells: function () {
            var view = this.parentView || this;
            var spreadsheetView = view.getCurrentSpreadsheetView();
            var selection = spreadsheetView.getSelection();
            view.tableStructSelections[spreadsheetView.viewID].keyColumnsCells = selection; // todo: нет учета пересечения областей
            view.setColorForSelection(spreadsheetView, view.keyColor, selection);
        },

        setDisabledCells: function () {
            var view = this.parentView || this;
            var spreadsheetView = view.getCurrentSpreadsheetView();
            var selection = spreadsheetView.getSelection();
            view.tableStructSelections[spreadsheetView.viewID].disabledCells = selection; // todo: нет учета пересечения областей
            view.setColorForSelection(spreadsheetView, view.disabledColor, selection);
        },

        openAdditionalSettings: function () {
            var view = this.parentView || this;
            console.error('Not implemented');
        }
    });
}(ReportStructExcelCreationView.prototype));

// ============= SPREADSHEET ==================
(function (viewClass) {
    KS.apply(viewClass, {
        openSpreadsheetView: function (excelTablePanel) {
            var view = this;
            view.serverCall({
                method: 'OpenSpreadsheetView',
                params: [excelTablePanel.structTableIndex],
                success: function (fileKey) {
                    excelTablePanel.openedExcelKey = fileKey;
                }
            });
        },

        getCurrentSpreadsheetView: function () {
            var view = this;
            var excelTablePanel = view.excelTablesTabPanel.getActiveTab();
            return excelTablePanel.spreadsheetView;
        },

        setColorForSelection: function (spreadsheetView, colorHex, selection) {
            var view = this;
            spreadsheetView.setBackgroundColorForSelection(colorHex, selection);
            spreadsheetView.reloadFrame();
            view.touch();
        },

        onSpreadsheetCellEndEdit: function (s, e) {
            var view = this;
            view.touch();
        },
    });
}(ReportStructExcelCreationView.prototype));