﻿PrintOptionsView = KS.extend(BaseSvodView, {});
var vc = PrintOptionsView.prototype;

// ============= COMMON =======================
(function (viewClass) {
    KS.apply(viewClass, {
        onTemplateRendered: function () {
            if (this.data.allSettingsHidden){
                this.selected();
                return;
            }
            
            addSelectedButton(this);

            if (this.optionsPanel.getHeight() + 80 < this.containerPanel.getHeight())
                this.containerPanel.setHeight(this.optionsPanel.getHeight() + 80);
            
            if (this.templatesCombo) {
                this.templatesCombo.labelEl.setStyle({
                    color: 'red',
                    fontWeight: 'bold'
                });
            }
            KS.updateLayout(this.containerPanel);
        },

        collectOptionsValues: function(optionsPanel) {
            var view = this;
            var panel = optionsPanel || view.optionsPanel;
            if (Ext.isEmpty(panel)) return;
            panel.items.each(function(item) {
                switch (item.xtype) {
                    case 'panel':
                    case 'fieldset':
                        view.collectOptionsValues(item);
                        break;
                        
                    case 'radio':
                    case 'radiofield':
                    case 'checkbox':
                    case 'checkboxfield':
                    case 'numberfield':
                        view.storeOptionValue(item.groupLink || 0, item.getItemId(), item.getValue());
                        break;
                        
                    case 'datefield':
                        var date = item.getValue();
                        if (Ext.isDate(date)) {
                            var str = date.getFullYear() + '' + ('0' + (date.getMonth() + 1)).slice(-2) + '' + ('0' + date.getDate()).slice(-2);
                            view.storeOptionValue(item.groupLink || 0, item.code, str, item.xtype);
                        }
                        break;
                        
                    case 'radiogroup':
                        var radioGroupValue = item.getChecked()[0].inputValue;
                        view.storeOptionValue(item.groupLink || 0, item.getItemId(), radioGroupValue);
                        break;
                }
            });
        },

        storeOptionValue: function (groupLink, code, value, optionXtype) {
            if (optionXtype !== 'datefield') 
                value = +value;
            this.printOptions.push({
                GroupLink: groupLink,
                Code: code,
                Value: value
            })
        },

        getPrintFormLink: function() {
            return (this.templatesCombo) ? this.templatesCombo.getValue() : 0;
        },

        selected: function() {
            var view = this.parentView || this;
            view.printOptions = [];
            view.collectOptionsValues();
            view.disableContainer();
            view.serverCall({
                method: 'Selected',
                params: [view.printOptions, view.getPrintFormLink()],
                success: view.afterSelected,
                error: view.enableContainer
            });
        },

        afterSelected: function(url) {
            if (!Ext.isEmpty(url)) {
                this.downloadFile(url);
            }

            this.close();
        }
    });
})(vc);

// ============= USERS =======================
(function(viewClass) {
    var sc = PrintOptionsView.superclass;

    KS.apply(viewClass,
        {
            selectUsers: function() {
                this.parentView.serverCall({ method: 'SelectUsers' });
            },

            selectUsersFromGrid: function() {
                this.parentView.serverCall({ method: 'SelectUsersFromGrid' });
            },

            onValuesSelected: function(args) {
                var users = args[0][0]['USERS'];
                this.users.setValue(users);
                sc.onValuesSelected.apply(this, arguments);
            }
        });
})(vc);

function addSelectedButton(view) {
    view.containerPanel.addDocked({
        xtype: 'toolbar',
        dock: 'bottom',
        border: false,
        style: {
            background: 'transparent'
        },
        items: [
            { xtype: 'tbfill' },
            { xtype: 'button', 
              text: 'Выполнить',
              cls: 'marked-button',
              scope: view,
              handler: view.selected
            }
        ]
    });
}

if (typeof(Sys) !== 'undefined') Sys.Application.notifyScriptLoaded();