﻿PlannerListView = KS.extend(BaseDictionaryView, { });

(function (viewClass) {
    var sc = PlannerListView.superclass;
    KS.apply(viewClass, {
        onValuesSelected: function (args) {
            this.mainGrid.reload();  
        },
        
        getTbarClickHandler: function(tbarItem) {
            switch (tbarItem.code) {
                case "ADD_USERS":
                case "REMOVE_USERS":
                    return this.editUsers;

                case "ADD_FORMS":
                    return this.addForms;
                    
                case "DELETE_FORMS":
                    return this.deleteForms;
                    
                default:
                    return sc.getTbarClickHandler.apply(this, arguments);
            }
        },

        editUsers: function(){
            var view = this.parentView || this;
            var links = view.mainGrid.getCheckedCodes();
            if (!Ext.isEmpty(links)){
                var toolKey = this.tbarNode.code;
                view.serverCall({
                    method: 'EditUsers',
                    params: [toolKey, links]
                });
            }
        },

        addForms: function(){
            var view = this.parentView || this;
            
        },
        
        deleteForms: function(){
            var view = this.parentView || this;
            var links = view.mainGrid.getCheckedCodes();
            if (!Ext.isEmpty(links)){
                var toolKey = this.tbarNode.code;
                view.serverCall({
                    method: 'DeleteForms',
                    params: [toolKey, links]
                });
            }           
        }
    });
}(PlannerListView.prototype));

if (typeof(Sys) !== 'undefined') Sys.Application.notifyScriptLoaded();
