﻿CheckSumsReplaceView = KS.extend(BaseSvodView, { });

(function(viewClass) {
    KS.apply(viewClass, {
        onTemplateRendered: function () {
            // Если копируются правила, можно не редактировать для сохранения
            if (this.data.identifier.IsCopyMode)
                this.touch();
            else
                this.discardChanges();
        },

        onSetSavedState: function(saved) {
            var saveBtn = this.getToolbarItem(this.formGrid, null, 'SAVE');
            if (saveBtn)
                saveBtn.setDisabled(saved);
        },

        resetView: function() {
            this.formGrid.reload();
        },

        addNewForm: function() {
            var view = this.parentView || this;
            view.serverCall({
                method: 'AddNewForm',
                disableFog: true,
                success: view.addNewFormCallback
            });
        },

        addNewFormCallback: function(newRowData) {
            if (!Ext.isEmpty(newRowData)) {
                var newRow = this.formGrid.addRecord(newRowData);
                this.formGrid.getSelectionModel().select([newRow]);
            }
            this.touch();
        },

        copyForm: function() {
            var view = this.parentView || this;
            var checkedCodes = view.formGrid.getCheckedCodes();
            if (!Ext.isEmpty(checkedCodes)) {
                view.serverCall({
                    method: 'CopyForm',
                    params: [checkedCodes[0]],
                    disableFog: true,
                    success: view.addNewFormCallback
                });
            }
        },

        deleteForms: function() {
            var view = this.parentView || this;
            var checkedCodes = view.formGrid.getCheckedCodes();
            if (!Ext.isEmpty(checkedCodes)) {
                KS.confirm("Удалить выделенные строки?",
                    "Подтвердите удаление",
                    function(btn) {
                        if (btn === 'yes')
                            view.deleteHandlerInternal(checkedCodes);
                    });
            }
        },

        deleteHandlerInternal: function (checkedCodes) {
            this.serverCall({
                method: 'DeleteForms',
                params: [checkedCodes, true],
                disableFog: true,
                success: this.deleteCallback
            });
        },

        deleteCallback: function() {
            var checkedRows = this.formGrid.getCheckedRows();
            this.formGrid.store.remove(checkedRows);
            this.touch();
        },

        formGridDblClick: function(gridView, td, cellIndex, record, tr, rowIndex, e) {
            if (e.position.column.dataIndex.toLowerCase() === "code_to") {
                var linkForm = KS.Grid.getAnyCase(record, "link_form");
                this.serverCall({
                    method: 'OpenFormsDictionary',
                    params: [linkForm]
                });
            }
        },

        onValuesSelected: function(args) {
            if (Ext.isEmpty(args) || Ext.isEmpty(args[0])) return;
            this.formGrid.reload();
            this.touch();
        },

        formGridEdit: function(e, context) {
            if (context.value === null) return false;
            if (context.value === context.originalValue) return false;
            var linkForm = KS.Grid.getAnyCase(context.record, "link_form");
            var dataIndex = context.column.dataIndex;
            this.serverCall({
                method: 'EditGridCell',
                params: [linkForm, dataIndex, context.value],
                disableFog: true,
                success: this.touch
            });
            return true;
        }
    });
}(CheckSumsReplaceView.prototype));

if (typeof(Sys) !== 'undefined') Sys.Application.notifyScriptLoaded();