﻿BudgetTypesDictionaryView = KS.extend(BaseDictionaryView, {
        newHandler: function() {
            var view = this.parentView;
            view.getBudgetGridData("NEW", 0);
        },
        
        editHandler: function() {
            var view = this.parentView;
            var ccc = view.mainGrid.getCheckedCodes(true);
            if (Ext.isEmpty(ccc)) return;
            if (ccc[0]) {
                view.getBudgetGridData("EDIT", ccc[0]);
            }
        },

        getBudgetGridData: function(mode, budgetId) {
            var view = this;
            view.serverCall({
                method: 'GetBudgetGridData',
                waitMessage: 'Открывается ...',
                params: [mode, budgetId],
                success: function(settings) {
                    view.showCreateNewBudget(settings, mode === "EDIT", budgetId);
                }
            });
        },

        showCreateNewBudget: function(settings, isEdit, budgetId) {
            this.propertyGrid = this.getPropertyGridByOption(settings, "propertyGrid", "Общие");
            var view = this;
            this.budgetPanelWin =  KS.showModal(this.propertyGrid, {
                title: 'Свойства',
                autoHeight: false,    
                layout: "anchor",
                height: 400, 
                minHeight: 200,
                width: 600,
                minWidth: 300,
                buttonAlign: 'left',
                buttons: new Array('->', {
                        text: 'ОК',
                        cls: 'dim-button',
                        handler: function () {
                            view.doEditBudget(isEdit, budgetId);
                        }
                    }, { xtype: 'tbspacer', width: 8 },
                    {
                        text: 'Отмена',
                        cls: 'dim-button',
                        handler: function() {
                            view.rejectBudget(isEdit, budgetId);
                        }
                    })
            }, true);
        },
        
        doEditBudget: function(isEdit, budgetId) {
            var view = this;
            var newValues = this.propertyGrid.source;
            view.serverCall({
                method: 'EditBudget',
                params: [newValues, isEdit, budgetId],
                waitMessage: isEdit ? 'Редактрование ...' : 'Создание ...',
                success: function(result) {
                    if (result === true) {
                        view.mainGrid.reload();
                        view.budgetPanelWin.close();
                    }
                }
            });
        },

        rejectBudget: function(isEdit, budgetId) {
            var view = this;
            view.serverCall({
                method: 'RejectBudget',
                params: [isEdit, budgetId],
                waitMessage: 'Отмена...',
                success: function() {
                    view.budgetPanelWin.close();
                }
            });
        }
    });

if (typeof(Sys) !== 'undefined') Sys.Application.notifyScriptLoaded();