Ext.define("CryptoModule.Initor", {

    firefoxAdditionalInstallFile: '/Modules/CA.crt',

    constructor: function (args) {
        this.cryptModulesInfo = this.createCryptModulesInfo();

        Ext.apply(this, args);
        this.gui = this.createGui();
        this.signerServerM = this.createSignerServerM();
        this.lavanda = this.createLavanda();
        this.signer = this.createSigner();
        
        this.formSigner = this.createFormSigner();

        this.successInstall = false;
        this.isAllModulesIsVerified = false;
        this.initLavanda();
    },

    //modules
    getCryptModulesInfo: function () {
        return this.cryptModulesInfo;
    },

    setCryptModuleInfoParam: function (name, params) {
        var modules = this.getCryptModulesInfo();
        var module = modules.find(function (item) {
            return item.name === name;
        });
        Ext.apply(module, params);
        return module;
    },

    removeCryptModuleInfo: function (name) {
        var modules = this.getCryptModulesInfo();
        var index = modules.findIndex(function (item) {
            return item.name === name;
        });
        return modules.splice(index, 1);
    },

    createCryptModulesInfo: function () {
        var modules = [
            {
                name: "",
                version: "",
                filename: "",
                description: "",
                isAvailable: null,
                verifiedOnServer: false
            },
            {
                name: "cpro",
                version: "",
                filename: "",
                description: "КриптоПро CSP",
                isAvailable: null,
                verifiedOnServer: false
            },
            {
                name: "vnet",
                version: "",
                filename: "",
                description: "ViPNet CSP",
                isAvailable: null,
                verifiedOnServer: false
            }
        ];

        if (Ext.isWindows) {
            return modules.slice(0, 1);
        } else if (Ext.isLinux) {
            return modules.slice(1);
        }
    },

    setModuleVersion: function (moduleItem, res) {

        moduleItem.verifiedOnServer = true;

        if (res.success) {
            moduleItem.filename = res.filename;
            moduleItem.version = res.version;
            moduleItem.isAvailable = true;
        } else {
            moduleItem.isAvailable = false;
        }

        this.checkIsAllModulesIsVerified();

        if (this.isAllModulesIsVerified) {
            this.buildResponseHtml();
        }
    },

    checkIsAllModulesIsVerified: function () {
        var modules = this.getCryptModulesInfo();
        this.isAllModulesIsVerified = modules.every(function (module) {
            return module.verifiedOnServer;
        });
    },

    //init
    getMaskTarget: function () {
        return ObjX.idContainer;
    },

    setLavandaMethods: function () {
        this.lavandaMethods = {
            resume: this.installParams.resume,
            cancel: this.installParams.cancel,
            afterShow: this.installParams.afterShow
        };
    },

    createSignerServerM: function () {
        return FormSignerServer({
            shadowObjId: ObjX.idContainer
        });
    },

    createLavanda: function () {
        return new Lavanda({
            saveParams: this.saveParamsLavanda.bind(this),
            loadParams: this.loadParamsLavanda.bind(this),
            install: this.showInstallWindow.bind(this),
            start: this.startLavanda.bind(this),
            getServerVersion: this.signerServerM.GetServerVersion,
            sitePrefix: this.sitePrefix
        });
    },

    createSigner: function () {
        return new Signer({
            module: this.lavanda
        });
    },

    createGui: function () {
        return GetSignerGuiMethods();
    },

    createFormSigner: function (signer, signerServerM, gui) {
        return new InitFormSign({
            signer: this.signer || signer,
            server: this.signerServerM || signerServerM,
            gui: this.gui || gui
        });
    },

    initLavanda: function () {
        this.container.Lavanda = this.lavanda;
        this.container.Signer = this.signer;
        this.container.FormSigner = this.formSigner;
    },

    showData: function (p) {
        var data = p.data;
        var panel = Ext.create("Ext.window.Window", {
            modal: true,
            height: Ext.getViewportHeight - 200,
            width: 560
        }).show();
    },

    //lavanda methods
    startLavanda: function (url) {
        var ifr = this.createIFrameEl();
        ifr.src = url;
        document.body.appendChild(ifr);
        setTimeout(function () {
            document.body.removeChild(ifr);
        }, 1000 * 5);
    },

    saveParamsLavanda: function (key, params) {
        localStorage.setItem(key, params);
    },

    loadParamsLavanda: function (key) {
        return localStorage.getItem(key);
    },

    createIFrameEl: function () {
        var ifr = document.createElement("iframe");
        ifr.style.display = "none";
        return ifr;
    },

    //install modules check
    showInstallWindow: function (params) {
        this.installParams = params;
        this.setLavandaMethods();

        if (this.isAllModulesIsVerified) {
            this.buildResponseHtml();
        } else {
            if (!params) {
                return ExtAlert("#err#Ошибка проверки версий криптомодуля");
            }
            this.checkModules();
        }
    },

    checkModules: function () {
        var params = this.installParams;
        var modules = this.getCryptModulesInfo();

        if (!modules) {
            return ExtAlert("#err#Ваша операционная система не поддерживает ЭЦП «Keysystems.CryptoModule»");
        }

        modules.forEach(function (module) {
            this.signerServerM.GetServerVersion({
                moduleName: params.name,
                shadowObjId: this.getMaskTarget(),
                mod: module.name,
                onSuccess: this.setModuleVersion.bind(this, module),
                onError: ShowError
            });
        }, this);
    },
    
    //dialogs
    buildResponseHtml: function () {
        var _this = this;
        var installWindowComponent = this.getInstallWindow();
        this.lavandaMethods.afterShow({
            close: function () {
                _this.successInstall = true;
                installWindowComponent.close();
            }
        });
    },

    getInstallWindow: function () {
        if (!this.installWindow) {
            this.installWindow = this.createInstallWindow();
        }
        return this.installWindow;
    },

    getDownloadsBtns: function () {
        if (!this.downloadBtns) {
            this.downloadBtns = this.createDownloadBtns();
        }
        return this.downloadBtns;
    },


    getResponseHtml: function () {
        if (!this.responseHtml) {
            this.responseHtml = this.createResponseHtml();
        }
        return this.responseHtml;
    },


    createInstallWindow: function () {
        var html = this.getResponseHtml();
        var btns = this.getDownloadsBtns();
        return Ext.create("Ext.window.Window", {
            width: 560,
            bodyPadding: 28,
            title: "Список сертификатов",
            modal: true,
            layout: {
                type: "vbox",
                align: "stretch"
            },
            listeners: {
                close: {
                    fn: function () {
                        this.installWindow = null;
                        if (!this.successInstall) {
                            this.lavandaMethods.cancel();
                            this.formSigner.CancelProgress();
                        }
                    },
                    scope: this
                },
                show: function () {
                    var windowCmp = this;
                    document.querySelector(".kss-install-window__browser-image").onload = function () {
                        windowCmp.update();
                        windowCmp.center();
                    };
                }
            },
            items: [{
                xtype: "panel",
                border: 0,
                scrollable: "y",
                html: html,
                margin: "0 0 0 0",
                flex: 5
            },
            {
                xtype: "panel",
                layout: "hbox",
                margin: "0 -4",
                border: 0,
                items: btns
            }
            ],
            buttons: [{
                text: "Отмена",
                handler: function () {
                    this.up("window").close();
                }
            }]
        }).show();
    },

    createResponseHtml: function () {
        var browserImage = this.getInstructionBrowserImage();

        var style = "<style>" +
            ".kss-install-window h2 { color: #000; }" +
            ".kss-install-window p { margin-top: 0px; line-height: 1.38;}" +
            ".kss-install-window__title {margin-top: 0;font-size: 18px;font-weight: 400;line-height: 1.33;}" +
            ".kss-install-window__block-logo {margin-bottom: 16px;display: flex;align-items: center;}" +
            ".kss-install-window__logo-text {font-size:18px;margin:0;flex-grow:1;}" +
            ".kss-install-window__logo {max-width: 32px;height: 32px;margin-right: 10px;flex-grow:1;}" +
            ".kss-install-window__text {margin-bottom: 16px;}" +
            ".kss-install-window__browser-image-block {margin-bottom: 16px; text-align: center;}" +
            ".kss-install-window__browser-image {max-height: 220px; height: auto;max-width: 100%;}" +
            "</style>";

        var isWin = Ext.isWindows,
            imgSrc = _all.rsa + "/images/kss-instruction/" + browserImage.image;

        var html = "<div class=\"kss-install-window\">" +
            "<h2 class=\"kss-install-window__title\">Для получения списка сертификатов необходимо установить/запустить приложение для подписи документов:</h2>" +
            "<div class=\"kss-install-window__block-logo\">" +
            "<div class=\"kss-install-window__logo ks-icon-kss_logo32\"></div>" +
            "<h2 class=\"kss-install-window__logo-text\">Keysystems.CryptoModule</h2>" +
            "</div>" +
            "<div class=\"kss-install-window__text\">" +
            "<p><b>Если модуль не установлен:</b> скачайте архив с приложением, распакуйте и запустите файл Keysystems.CryptoModule" + (isWin ? ".exe" : "") + ".</p>" +
            "<p><b>Если модуль установлен:</b> в всплывающем окне браузера поставьте галочку <b>Запомнить мой выбор для этого типа ссылок</b> и нажмите кнопку <b>Открыть приложение «Keysystems.CryptoModule».</b></p>" +
            "</div>" +
            "<div class=\"kss-install-window__browser-image-block\">" +
            "<img class=\"kss-install-window__browser-image\" src=\"" + imgSrc + "\" alt=\"" + browserImage.name + "\">" +
            "</div>" +
            "<p class=\"kss-install-window__text\">Для повторной или ручной установки приложения cкачайте еще раз архив, распакуйте и запустите файл Keysystems.CryptoModule" + (isWin ? ".exe" : "") + "</p>" +
            "</div>";

        return style + html;
    },

    createDownloadBtns: function () {
        var me = this,
            availableModules = me
                .getCryptModulesInfo()
                .filter(function (module) {
                    return module.isAvailable;
                });

        return availableModules.map(function (moduleItem) {
            var description = moduleItem.description ? "(" + moduleItem.description + ")" : "",
                downloadLink = me.sitePrefix + Connection.Info.signGetFilePath + moduleItem.filename;

            return {
                xtype: "button",
                html: "Cкачать архив " + description,
                textAlign: "center",
                margin: "0 4",
                scale: availableModules.length == 1 ? "large" : "medium",
                iconCls: "ks-icon-download_icon",
                handler: function () {
                    ExtUtils.SilentAnchorClick(downloadLink, true);

                    Ext.isFirefox && Ext.isWindows && ExtUtils.SilentAnchorClick(_all.rsa + me.firefoxAdditionalInstallFile);
                }
            };
        });
    },

    getInstructionBrowserImage: function () {
        var browserName = Ext.browser.name;

        var images = {
            "Edge": "edge.png",
            "Opera": "opera.png",
            "IE": "ie.png",
            "Firefox": "firefox.png",
            "Chrome": "chrome.png",
            "default": "chrome.png"
        };

        var image = images[browserName] || images["default"];

        return {
            image: image,
            name: browserName || ""
        };
    }
});