﻿function usersActivityTimeRenderer(value) {
    var sec = Math.floor(parseFloat(value.replace(',', '.'))),
        min = Math.floor(sec / 60),
        hour = Math.floor(min / 24);
    return KS.zeroFill(hour, 2) + ':' + KS.zeroFill(min % 60, 2) + ':' + KS.zeroFill(sec % 60, 2);
}

UsersActivityView = KS.extend(KS.Ext.ClientView,
    {
        constructor: function(viewId) {
            UsersActivityView.superclass.constructor.call(this, viewId);
        },

        buildContainerToolbarItemControl: function (tbarNode) {
            if (tbarNode.code.startsWith('Spinner')) {
                var view = this;
                return new Ext.form.field.Spinner({
                    value: this.data.inactivityMinutes,
                    allowNegative: false,
                    step: 1,
                    onSpinUp: function() {
                        var me = this;
                        if (!me.readOnly) {
                            var val = parseInt(me.getValue());
                            me.setValue(val + me.step);
                        }
                    },

                    // override onSpinDown
                    onSpinDown: function() {
                        var me = this;
                        if (!me.readOnly) {
                            var val = parseInt(me.getValue());
                            me.setValue(val - me.step);
                        }
                    },
                    listeners: {
                        change: function() {
                            view.UsersActivityGrid.reload();
                        },
                        buffer: 500
                    },
                    width: 50
                });
            }

            return {};
        },

        kickUsers: function() {
            var view = this.parentView,
                grid = view.UsersActivityGrid,
                selRecs = grid.getCheckedRows(),
                userNames = [];

            if (Ext.isEmpty(selRecs)) return;
            Ext.each(selRecs,
                function(rec) {
                    userNames.push(rec.data.UserName);
                });

            KS.confirm(KS.L10n.deleteUsers,
                KS.L10n.deleteConfirmation,
                function(btn) {
                    if (btn == 'yes') {
                        view.serverCall({
                            method: 'KickUsers',
                            params: [userNames],
                            waitMessage: KS.L10n.deletionWaitMessage,
                            success: function() {
                                Ext.each(selRecs,
                                    function(r) {
                                        grid.store.remove(r);
                                    });
                            }
                        });
                    }
                });
        },

        addToolbarButton: function(icon, tooltip, method) {
            var view = this;
            view.usersGrid.getTopToolbar().add({
                icon: icon,
                tooltip: tooltip,
                scope: view,
                handler: view[method]
            });
        }
    });