﻿SqlQueryManagerView = KS.extend(KS.Ext.ClientView, {
    getLastQueryIndex: function() {
        var idx = 1;
        while (!!this['query' + idx++]) {}
        return idx;
    },

    getActiveQueryField: function () {
        var activeTab = this.queryTabs.getActiveTab();
        return activeTab.items.first();
    },

    addTab: function() {
        var view = this.parentView;
        view.serverCall({
            method: 'GetQueryTab',
            progressOnly: true,
            params: [view.queryTabs.items.getCount() + 1],
            success: view.renderNewTab
        });
    },

    activateTab: function (tp, activeTab) {
        this.serverCall({
            method: 'SetActiveQueryTab',
            progressOnly: true,
            params: [activeTab.items.first().ctrlId],
            success: this.showResult
        });
        activeTab.items.first().focus();
    },

    renderNewTab: function (tabCtrl) {
        var newTab = this.createTemplateControl(tabCtrl);
        this.addPanelItems(tabCtrl, newTab);
        this.queryTabs.setActiveTab(this.queryTabs.add(newTab));
    },

    execute: function () {
        var view = this.parentView,
            user = view.user.getValue(),
            pass = view.pass.getValue(),
            queryField = view.getActiveQueryField();
        if (KS.isEmpty(queryField.getValue())) return;
        view.serverCall({
            method: 'Execute',
            waitMessage: KS.L10n.executeWaitMessage,
            params: [user, pass, queryField.ctrl.itemId, queryField.getValue()],
            success: view.showResult
        });
    },

    showResult: function (result) {
        if (!result) {
            this.consolePanel.update('');
            this.gridsPanel.removeAll();
            return;
        }
        this.result = result;
        if (this.result.ErrorExecute) {
            this.resultTabPanel.setActiveTab(1);
        }
        if (this.consolePanel.rendered) {
            this.renderConsole();
        } else {
            this.consolePanel.on('activate', this.renderConsole, this, { single: true });
        }
        this.renderTables();
    },

    renderConsole: function () {
        var view = this,
            console = '';
        Ext.each(view.result.ConsoleOutput, function (msg) {
            console += (msg.Item1 || msg.Item2);
        });
        view.consolePanel.update(console);
    },

    renderTables: function () {
        this.gridsPanel.removeAll();
        Ext.each(this.result.Grids, function (grid) {
            this.gridsPanel.add(this.createTemplateControl(grid));
        }, this);
        this.gridsPanel.setActiveTab(0);
    },

    htmlExport: function () {
        this.parentView.doExport(this.gridSettings.Band[0].Summaries[0], 'html');
    },

    excelExport: function () {
        this.parentView.doExport('excel');
    },

    getActiveGrid: function() {
        var activeTab = this.gridsPanel.getActiveTab();
        if (!activeTab || !activeTab.ctrlId) return -1;
        return +activeTab.ctrlId.replace('grid_', '');
    },

    doExport: function (format) {
        var gridIdx = this.getActiveGrid();
        if (!(gridIdx >= 0)) return;
        this.serverCall({
            method: 'ExcelExport',
            params: [gridIdx, format],
            waitMessage: KS.L10n.tableExport,
            success: function (url) {
                if (url) {
                    window.open(url, '_blank', 'height=580, width=840, resizable=yes, menubar=yes, location=no,status=yes, scrollbars=yes');
                }
            }
        });
    }
});
