ActivationView = KS.extend(KS.Ext.ClientView, {
    customName: 'ActivationView'
});

(function (viewClass) {
    KS.apply(viewClass, {
        beforeGridRender: function(grid) {
            var gridView = grid.getView();
            gridView.getRowClass = this.gridGetRowClass;
        },

        gridGetRowClass: function(record) {
            if (KS.Grid.getAnyCase(record, "ID_CODE").indexOf("PROJECT") >= 0)
                return "project-row";
            return "";
        },

        onServerUpdateGridColors: function(){
            this.complexGrid.reload();
        },

        openAdditionalInfoWindow: function () {
            var view = this.parentView || this;
            view.serverCall({
                method: 'GetAdditionalInfoPanel',
                success: function (panel) {
                    view.showAdditionalInfoPanel(panel);
                }
            })
        },

        showAdditionalInfoPanel: function(panel){
            var view = this;
            if (Ext.isEmpty(panel)) return;
            view.additionalInfoPanel = view.createTemplateControl(panel, 'additionalInfoPanel');
            view.addPanelItems(panel, view.additionalInfoPanel);
            view.additionalInfoWin = KS.showModal(view.additionalInfoPanel, {
                title: 'Дополнительно',
                autoHeight: false,
                maximizable: false,
                height: '300px',
                width: '500px',
                layout: 'fit',
                buttonAlign: 'left',
                buttons: ['->',
                    {
                        text: 'ОК',
                        cls: 'dim-button',
                        handler: function () {
                            view.doBrokerEdit();
                        }
                    }, { xtype: 'tbspacer', width: 8 },
                    {
                        text: 'Отмена',
                        cls: 'dim-button',
                        handler: function () {
                            view.additionalInfoWin.close();
                        }
                    }]
            }, true);
        },

        doBrokerEdit: function(){
            var view = this;
            var args = view.collectBrokerEditValue();
            view.additionalInfoWin.mask('Сохранение...');
            view.serverCall({
                method: 'DoBrokerEdit',
                params:[args],
                success: function() {
                    view.additionalInfoWin.unmask();
                    view.additionalInfoWin.close();
                },
                error: function() {
                    view.additionalInfoWin.unmask();
                    view.additionalInfoWin.close();
                }
            })
        },

        collectBrokerEditValue: function () {
            return {
                "BROKER_NAME": this.editorName.getValue(),
                "BROKER_PHONE": this.editorPhone.getValue(),
                "BROKER_WEB": this.editorSite.getValue(),
                "BROKER_EMAIL": this.editorEmail.getValue()
            }
        },

        openSendRequestOnPortalWindow: function () {
            var view = this.parentView || this;
            view.serverCall({
                method: 'GetSendRequestOnPortalPanel',
                success: function (panel) {
                    view.showSendRequestOnPortalWin(panel);
                }
            })
        },

        showSendRequestOnPortalWin: function(panel){
            var view = this;
            if (Ext.isEmpty(panel)) return;
            view.sendRequestOnPortalPanel = view.createTemplateControl(panel, 'sendRequestOnPortalPanel');
            view.addPanelItems(panel, view.sendRequestOnPortalPanel);
            view.sendRequestOnPortalWin = KS.showModal(view.sendRequestOnPortalPanel, {
                title: 'Запрос на активацию',
                autoHeight: false,
                maximizable: false,
                height: '300px',
                width: '400px',
                layout: 'fit',
                buttonAlign: 'left',
                buttons: ['->',
                    {
                        text: 'ОК',
                        cls: 'dim-button',
                        handler: function () {
                            view.doSendRequestOnPortal();
                        }
                    }, { xtype: 'tbspacer', width: 8 },
                    {
                        text: 'Отмена',
                        cls: 'dim-button',
                        handler: function () {
                            view.sendRequestOnPortalWin.close();
                        }
                    }]
            }, true);
        },

        doSendRequestOnPortal: function(){
            var view = this;
            var address = this.editorAddress.getValue();
            var login = this.editorLogin.getValue();
            var password = this.editorPassword.getValue();
            view.sendRequestOnPortalWin.mask('Отправка запроса...');
            view.serverCall({
                method: 'SendRequestOnPortal',
                params:[address, login, password],
                success: function() {
                    view.sendRequestOnPortalWin.unmask();
                    view.sendRequestOnPortalWin.close();
                },
                error: function() {
                    view.sendRequestOnPortalWin.unmask();
                }
            })
        },

        openEnterActivationKeyWindow: function () {
            var view = this.parentView || this;
            var checkedRows = view.complexGrid.getCheckedRows();
            if(Ext.isEmpty(checkedRows))
            {
                KS.alert('Необходимо выбрать программный комплекс');
                return;
            }
            var checkedRow = checkedRows[0];
            var progName = KS.Grid.getAnyCase(checkedRow, "PROGNAME");
            view.serverCall({
                method: 'GetEnterActivationKeyPanel',
                params: [progName],
                success: function (panel) {
                    view.showActivationKeyWindow(panel)
                }
            })
        },

        showActivationKeyWindow: function(panel){
            var view = this;
            if (Ext.isEmpty(panel)) return;
            view.enterActivationKeyPanel = view.createTemplateControl(panel, 'enterActivationKeyPanel');
            view.addPanelItems(panel, view.enterActivationKeyPanel);
            view.enterActivationKeyWindow = KS.showModal(view.enterActivationKeyPanel, {
                title: view.containerPanel.title,
                autoHeight: false,
                autoWidth: false,
                height: '300px',
                width: '400px',
                layout: 'fit',
                buttonAlign: 'left',
                buttons: ['->',
                    {
                        text: 'ОК',
                        cls: 'dim-button',
                        handler: function () {
                            view.doActivateComplex();
                        }
                    }, { xtype: 'tbspacer', width: 8 },
                    {
                        text: 'Отмена',
                        cls: 'dim-button',
                        handler: function () {
                            view.enterActivationKeyWindow.close();
                        }
                    }]
            }, true);
        },

        doActivateComplex: function(){
            var view = this;
            var checkedCodes = view.complexGrid.getCheckedCodes();
            if(Ext.isEmpty(checkedCodes))
            {
                KS.alert('Необходимо выбрать программный комплекс');
                return;
            }
            view.enterActivationKeyWindow.mask('Активация комплекса...');
            var complexId = checkedCodes[0];
            var key = view.editorKey.getValue();
            view.serverCall({
                method: 'ActivateComplex',
                params:[complexId, key],
                success: function() {
                    view.enterActivationKeyWindow.unmask();
                    view.enterActivationKeyWindow.close();
                },
                error: function(){
                    view.enterActivationKeyWindow.unmask();
                }
            })
        },

        openSubKeyInfo: function(){
            var view = this.parentView || this;
            view.serverCall({
                method: 'OpenSubKeyInfo'
            })
        },

        copySignature: function(){
            var view = this.parentView || this;
            var signature = view.signature.getValue();
            KS.copyToClipBoard(signature);
        },

        closeButton: function () {
            var view = this.parentView || this;
            view.close();
        }
    });
}(ActivationView.prototype));

function openSendRequestOnPortalWindow(){
    var view = KS.findSingleView('customName', 'ActivationView');
    if (view)
        view.openSendRequestOnPortalWindow();
}

function openEnterActivationKeyWindow(){
    var view = KS.findSingleView('customName', 'ActivationView');
    if (view)
        view.openEnterActivationKeyWindow();
}

function openSubKeyInfo(){
    var view = KS.findSingleView('customName', 'ActivationView');
    if (view)
        view.openSubKeyInfo();
}

function activationDateRenderer(value, metadata){
    if (value != null && value.length > 10) {
        var retDate = new Date(value);
        return Ext.Date.format(retDate, 'd.m.Y');
    } else if (Ext.isDate(value)) {
        return Ext.util.Format.date(value, metadata.column.format);
    }
    return value;
}

function activationDateUpdRenderer(value, metadata, record){
    if (Date.now() >= Date.parse(KS.Grid.getAnyCase(record, "DATE_UPD"))){
        metadata.css += " color-red-row";
    } else {
        metadata.css += " color-black-row";
    }
    return activationDateRenderer(value, metadata);
}

function activationDateMaxRenderer(value, metadata, record){
    if (Date.now() >= Date.parse(KS.Grid.getAnyCase(record, "DATE_MAX"))){
        metadata.css += " color-red-row";
    } else {
        metadata.css += " color-black-row";
    }
    return activationDateRenderer(value, metadata);
}