﻿(function() {
    var __webpack_modules__ = {
        9279: function(__unused_webpack_module, exports) {
            "use strict";
            Object.defineProperty(exports, "__esModule", {
                value: !0
            }), exports.Browser = void 0;
            var Browser = function() {
                function Browser() {}
                return Browser.IdentUserAgent = function(userAgent, ignoreDocumentMode) {
                    void 0 === ignoreDocumentMode && (ignoreDocumentMode = !1);
                    var browserTypesOrderedList = [ "Mozilla", "IE", "Firefox", "Netscape", "Safari", "Chrome", "Opera", "Opera10", "Edge" ], defaultVersions = {
                        Safari: 2,
                        Chrome: .1,
                        Mozilla: 1.9,
                        Netscape: 8,
                        Firefox: 2,
                        Opera: 9,
                        IE: 6,
                        Edge: 12
                    };
                    if (userAgent && 0 !== userAgent.length) {
                        userAgent = userAgent.toLowerCase(), Browser.indentPlatformMajorVersion(userAgent);
                        try {
                            for (var platformIdentStrings = {
                                Windows: "Win",
                                Macintosh: "Mac",
                                "Mac OS": "Mac",
                                Mac_PowerPC: "Mac",
                                "cpu os": "MacMobile",
                                "cpu iphone os": "MacMobile",
                                Android: "Android",
                                "!Windows Phone": "WinPhone",
                                "!WPDesktop": "WinPhone",
                                "!ZuneWP": "WinPhone"
                            }, optVersion = "(?:(\\d+)(?:\\.((?:\\d+?[1-9])|\\d)0*?)?)?", patterns = {
                                Safari: "applewebkit(?:.*?(?:version/(\\d+)(?:\\.((?:\\d+?[1-9])|\\d)0*?)?[\\.\\w\\d]*?(?:\\s+mobile/\\S*)?\\s+safari))?",
                                Chrome: "(?:chrome|crios)(?!frame)(?:/|\\s*)?" + optVersion,
                                Mozilla: "mozilla(?:.*rv:" + optVersion + ".*Gecko)?",
                                Netscape: "(?:netscape|navigator)\\d*/?\\s*" + optVersion,
                                Firefox: "firefox(?:/|\\s*)?" + optVersion,
                                Opera: "(?:opera|\\sopr)(?:/|\\s*)?" + optVersion,
                                Opera10: "opera.*\\s*version(?:/|\\s*)?" + optVersion,
                                IE: "msie\\s*" + optVersion,
                                Edge: "edge(?:/|\\s*)?" + optVersion
                            }, browserType = null, version = -1, i = 0; i < browserTypesOrderedList.length; i++) {
                                var browserTypeCandidate = browserTypesOrderedList[i], matches = new RegExp(patterns[browserTypeCandidate], "i").exec(userAgent);
                                if (matches && matches.index >= 0) {
                                    if ("IE" === browserType && version >= 11 && "Safari" === browserTypeCandidate) continue;
                                    "Opera10" === (browserType = browserTypeCandidate) && (browserType = "Opera");
                                    var tridentPattern = "trident(?:/|\\s*)?" + optVersion;
                                    version = Browser.GetBrowserVersion(userAgent, matches, tridentPattern, Browser.getIECompatibleVersionString()), 
                                    "Mozilla" === browserType && version >= 11 && (browserType = "IE");
                                }
                            }
                            browserType || (browserType = "IE");
                            var browserVersionDetected = -1 !== version;
                            browserVersionDetected || (version = defaultVersions[browserType]);
                            var platform = null, minOccurenceIndex = Number.MAX_VALUE;
                            for (var identStr in platformIdentStrings) if (Object.prototype.hasOwnProperty.call(platformIdentStrings, identStr)) {
                                var importantIdent = "!" === identStr.substr(0, 1), occurenceIndex = userAgent.indexOf((importantIdent ? identStr.substr(1) : identStr).toLowerCase());
                                occurenceIndex >= 0 && (occurenceIndex < minOccurenceIndex || importantIdent) && (minOccurenceIndex = importantIdent ? 0 : occurenceIndex, 
                                platform = platformIdentStrings[identStr]);
                            }
                            var m = userAgent.toUpperCase().match("SM-[A-Z]"), isSamsungAndroidDevice = m && m.length > 0;
                            "WinPhone" === platform && version < 9 && (version = Math.floor(Browser.getVersionFromTrident(userAgent, "trident(?:/|\\s*)?" + optVersion))), 
                            !ignoreDocumentMode && "IE" === browserType && version > 7 && document.documentMode < version && (version = document.documentMode), 
                            "WinPhone" === platform && (version = Math.max(9, version)), platform || (platform = "Win"), 
                            platform !== platformIdentStrings["cpu os"] || browserVersionDetected || (version = 4), 
                            Browser.fillUserAgentInfo(browserTypesOrderedList, browserType, version, platform, isSamsungAndroidDevice);
                        } catch (e) {
                            Browser.fillUserAgentInfo(browserTypesOrderedList, "IE", defaultVersions.IE, "Win");
                        }
                    } else Browser.fillUserAgentInfo(browserTypesOrderedList, "IE", defaultVersions.IE, "Win");
                }, Browser.GetBrowserVersion = function(userAgent, matches, tridentPattern, ieCompatibleVersionString) {
                    var version = Browser.getVersionFromMatches(matches);
                    if (ieCompatibleVersionString) {
                        var versionFromTrident = Browser.getVersionFromTrident(userAgent, tridentPattern);
                        if ("edge" === ieCompatibleVersionString || parseInt(ieCompatibleVersionString) === versionFromTrident) return versionFromTrident;
                    }
                    return version;
                }, Browser.getIECompatibleVersionString = function() {
                    if (document.compatible) for (var i = 0; i < document.compatible.length; i++) if ("IE" === document.compatible[i].userAgent && document.compatible[i].version) return document.compatible[i].version.toLowerCase();
                    return "";
                }, Browser.isTouchEnabled = function() {
                    return Browser.hasTouchStart() || Browser.hasMaxTouchPoints() || Browser.hasMsMaxTouchPoints();
                }, Browser.hasTouchStart = function() {
                    return "ontouchstart" in window;
                }, Browser.hasMaxTouchPoints = function() {
                    return navigator.maxTouchPoints > 0;
                }, Browser.hasMsMaxTouchPoints = function() {
                    return navigator.msMaxTouchPoints > 0;
                }, Browser.hasNavigator = function() {
                    return "undefined" != typeof navigator;
                }, Browser.fillUserAgentInfo = function(browserTypesOrderedList, browserType, version, platform, isSamsungAndroidDevice) {
                    void 0 === isSamsungAndroidDevice && (isSamsungAndroidDevice = !1);
                    for (var i = 0; i < browserTypesOrderedList.length; i++) {
                        var type = browserTypesOrderedList[i];
                        Browser[type] = type === browserType;
                    }
                    Browser.Version = Math.floor(10 * version) / 10, Browser.MajorVersion = Math.floor(Browser.Version), 
                    Browser.WindowsPlatform = "Win" === platform || "WinPhone" === platform, Browser.MacOSMobilePlatform = "MacMobile" === platform || "Mac" === platform && Browser.isTouchEnabled(), 
                    Browser.MacOSPlatform = "Mac" === platform && !Browser.MacOSMobilePlatform, Browser.AndroidMobilePlatform = "Android" === platform, 
                    Browser.WindowsPhonePlatform = "WinPhone" === platform, Browser.WebKitFamily = Browser.Safari || Browser.Chrome || Browser.Opera && Browser.MajorVersion >= 15, 
                    Browser.NetscapeFamily = Browser.Netscape || Browser.Mozilla || Browser.Firefox, 
                    Browser.WebKitTouchUI = Browser.MacOSMobilePlatform || Browser.AndroidMobilePlatform;
                    var isIETouchUI = Browser.IE && Browser.MajorVersion > 9 && Browser.WindowsPlatform && Browser.UserAgent.toLowerCase().indexOf("touch") >= 0;
                    if (Browser.MSTouchUI = isIETouchUI || Browser.Edge && !!window.navigator.maxTouchPoints, 
                    Browser.TouchUI = Browser.WebKitTouchUI || Browser.MSTouchUI, Browser.MobileUI = Browser.WebKitTouchUI || Browser.WindowsPhonePlatform, 
                    Browser.AndroidDefaultBrowser = Browser.AndroidMobilePlatform && !Browser.Chrome, 
                    Browser.AndroidChromeBrowser = Browser.AndroidMobilePlatform && Browser.Chrome, 
                    isSamsungAndroidDevice && (Browser.SamsungAndroidDevice = isSamsungAndroidDevice), 
                    Browser.MSTouchUI) {
                        var isARMArchitecture = Browser.UserAgent.toLowerCase().indexOf("arm;") > -1;
                        Browser.VirtualKeyboardSupported = isARMArchitecture || Browser.WindowsPhonePlatform;
                    } else Browser.VirtualKeyboardSupported = Browser.WebKitTouchUI;
                    Browser.fillDocumentElementBrowserTypeClassNames(browserTypesOrderedList);
                }, Browser.indentPlatformMajorVersion = function(userAgent) {
                    var matches = /(?:(?:windows nt|macintosh|mac os|cpu os|cpu iphone os|android|windows phone|linux) )(\d+)(?:[-0-9_.])*/.exec(userAgent);
                    matches && (Browser.PlaformMajorVersion = matches[1]);
                }, Browser.getVersionFromMatches = function(matches) {
                    var result = -1, versionStr = "";
                    return matches && (matches[1] && (versionStr += matches[1], matches[2] && (versionStr += "." + matches[2])), 
                    "" !== versionStr && (result = parseFloat(versionStr), isNaN(result) && (result = -1))), 
                    result;
                }, Browser.getVersionFromTrident = function(userAgent, tridentPattern) {
                    var matches = new RegExp(tridentPattern, "i").exec(userAgent);
                    return Browser.getVersionFromMatches(matches) + 4;
                }, Browser.fillDocumentElementBrowserTypeClassNames = function(browserTypesOrderedList) {
                    for (var documentElementClassName = "", browserTypeslist = browserTypesOrderedList.concat([ "WindowsPlatform", "MacOSPlatform", "MacOSMobilePlatform", "AndroidMobilePlatform", "WindowsPhonePlatform", "WebKitFamily", "WebKitTouchUI", "MSTouchUI", "TouchUI", "AndroidDefaultBrowser" ]), i = 0; i < browserTypeslist.length; i++) {
                        var type = browserTypeslist[i];
                        Browser[type] && (documentElementClassName += "dx" + type + " ");
                    }
                    documentElementClassName += "dxBrowserVersion-" + Browser.MajorVersion, "undefined" != typeof document && document && document.documentElement && ("" !== document.documentElement.className && (documentElementClassName = " " + documentElementClassName), 
                    document.documentElement.className += documentElementClassName, Browser.Info = documentElementClassName);
                }, Browser.getUserAgent = function() {
                    return Browser.hasNavigator() && navigator.userAgent ? navigator.userAgent.toLowerCase() : "";
                }, Browser.UserAgent = Browser.getUserAgent(), Browser._foo = Browser.IdentUserAgent(Browser.UserAgent), 
                Browser;
            }();
            exports.Browser = Browser;
        },
        1772: function(__unused_webpack_module, exports) {
            "use strict";
            exports.m1 = exports.IS = void 0;
            var BatchUpdatableObject = function() {
                function BatchUpdatableObject() {
                    this.suspendUpdateCount = 0, this.occurredEvents = 0;
                }
                return BatchUpdatableObject.prototype.beginUpdate = function() {
                    0 === this.suspendUpdateCount && this.onUpdateLocked(), this.suspendUpdateCount < 0 ? this.suspendUpdateCount-- : this.suspendUpdateCount++;
                }, BatchUpdatableObject.prototype.endUpdate = function() {
                    if (this.suspendUpdateCount < 0 ? this.suspendUpdateCount++ : this.suspendUpdateCount > 0 && this.suspendUpdateCount--, 
                    !this.isUpdateLocked()) {
                        var occurredEvents = this.occurredEvents;
                        this.occurredEvents = 0, this.onUpdateUnlocked(occurredEvents);
                    }
                }, BatchUpdatableObject.prototype.suspendUpdate = function() {
                    if (this.suspendUpdateCount > 0) {
                        this.suspendUpdateCount *= -1;
                        var occurredEvents = this.occurredEvents;
                        this.occurredEvents = 0, this.onUpdateUnlocked(occurredEvents);
                    }
                }, BatchUpdatableObject.prototype.continueUpdate = function() {
                    this.suspendUpdateCount < 0 && (this.suspendUpdateCount *= -1);
                }, BatchUpdatableObject.prototype.isUpdateLocked = function() {
                    return this.suspendUpdateCount > 0;
                }, BatchUpdatableObject.prototype.onUpdateLocked = function() {}, BatchUpdatableObject.prototype.registerOccurredEvent = function(eventMask) {
                    this.occurredEvents |= eventMask;
                }, BatchUpdatableObject.prototype.resetOccurredEvents = function() {
                    this.occurredEvents = 0;
                }, BatchUpdatableObject.prototype.isLocked = function() {
                    return 0 !== this.suspendUpdateCount;
                }, BatchUpdatableObject;
            }();
            exports.IS = BatchUpdatableObject;
            var EmptyBatchUpdatableObject = function() {
                function EmptyBatchUpdatableObject() {}
                return EmptyBatchUpdatableObject.prototype.beginUpdate = function() {}, EmptyBatchUpdatableObject.prototype.endUpdate = function() {}, 
                EmptyBatchUpdatableObject;
            }();
            exports.m1 = EmptyBatchUpdatableObject;
        },
        677: function(__unused_webpack_module, exports) {
            "use strict";
            exports.T = void 0;
            var ChunkedText = function() {
                function ChunkedText(text, maxChunkSize) {
                    void 0 === maxChunkSize && (maxChunkSize = 2e3), this.maxChunkSize = maxChunkSize, 
                    this.chunks = [], this._textLength = 0, this.pushText(text), this.resetToStart();
                }
                return Object.defineProperty(ChunkedText.prototype, "currChar", {
                    get: function() {
                        return this.chunk[this.posInChunk];
                    },
                    enumerable: !1,
                    configurable: !0
                }), Object.defineProperty(ChunkedText.prototype, "currPos", {
                    get: function() {
                        return this._currPos;
                    },
                    enumerable: !1,
                    configurable: !0
                }), Object.defineProperty(ChunkedText.prototype, "textLength", {
                    get: function() {
                        return this._textLength;
                    },
                    enumerable: !1,
                    configurable: !0
                }), ChunkedText.prototype.resetToStart = function() {
                    this.setChunk(0), this.posInChunk = -1, this._currPos = -1;
                }, ChunkedText.prototype.resetToEnd = function() {
                    this.setChunk(this.chunks.length - 1), this.posInChunk = this.chunkLength - 1, this._currPos = this._textLength;
                }, ChunkedText.prototype.addText = function(text) {
                    this.pushText(text), -1 === this._currPos ? (this.chunk = this.chunks[0], this.chunkLength = this.chunk.length) : this.setPositionTo(this._currPos);
                }, ChunkedText.prototype.getText = function() {
                    return this.chunks.join("");
                }, ChunkedText.prototype.moveToNextChar = function() {
                    return this.posInChunk++, this._currPos++, this.posInChunk < this.chunkLength || (this.setChunk(this.chunkIndex + 1) ? (this.posInChunk = 0, 
                    !0) : (this.posInChunk = this.chunkLength, this._currPos = this._textLength, !1));
                }, ChunkedText.prototype.moveToPrevChar = function() {
                    return this.posInChunk--, this._currPos--, this.posInChunk >= 0 || (this.setChunk(this.chunkIndex - 1) ? (this.posInChunk = this.chunkLength - 1, 
                    !0) : (this.posInChunk = -1, this._currPos = -1, !1));
                }, ChunkedText.prototype.setPositionTo = function(position) {
                    var restLength = position;
                    this.chunkIndex = 0;
                    for (var ind = 0; ;ind++) {
                        if (!this.setChunk(ind)) return this.posInChunk = this.chunkLength, void (this._currPos = this._textLength);
                        if (!(restLength > this.chunkLength)) return this.posInChunk = restLength, void (this._currPos = position);
                        restLength -= this.chunk.length;
                    }
                }, ChunkedText.prototype.setChunk = function(index) {
                    var prevChunkVal = this.chunk;
                    return this.chunk = this.chunks[index], this.chunk ? (this.chunkIndex = index, this.chunkLength = this.chunk.length, 
                    !0) : (this.chunk = prevChunkVal, !1);
                }, ChunkedText.prototype.pushText = function(text) {
                    if (text.length) {
                        for (var textPos = 0; textPos < text.length; ) {
                            if (0 === textPos) {
                                var lastChunk = this.chunks.pop();
                                if (lastChunk) {
                                    if (lastChunk.length < this.maxChunkSize) {
                                        var restLen = this.maxChunkSize - lastChunk.length;
                                        this.chunks.push(lastChunk + text.substr(textPos, restLen)), textPos += restLen;
                                        continue;
                                    }
                                    this.chunks.push(lastChunk);
                                }
                            }
                            this.chunks.push(text.substr(textPos, this.maxChunkSize)), textPos += this.maxChunkSize;
                        }
                        this._textLength += text.length;
                    }
                }, ChunkedText;
            }();
            exports.T = ChunkedText;
        },
        6218: function(__unused_webpack_module, exports) {
            "use strict";
            exports.R = void 0;
            var DelayedActionManager = function() {
                function DelayedActionManager(action) {
                    this.action = action, this.reset();
                }
                return Object.defineProperty(DelayedActionManager.prototype, "actionExecuted", {
                    get: function() {
                        return null === this.actionTimeoutId;
                    },
                    enumerable: !1,
                    configurable: !0
                }), DelayedActionManager.prototype.reset = function() {
                    this.actionTimeout = void 0, this.actionTimeoutId = void 0, this.actionStartTime = void 0;
                }, DelayedActionManager.prototype.start = function(timeout) {
                    var _this = this;
                    this.actionTimeout = timeout, this.actionTimeoutId = setTimeout((function() {
                        return _this.executeAction();
                    }), this.actionTimeout), this.actionStartTime = Date.now();
                }, DelayedActionManager.prototype.executeIfTimerExpired = function() {
                    Date.now() - this.actionStartTime > this.actionTimeout && this.executeAction();
                }, DelayedActionManager.prototype.executeAction = function() {
                    this.actionExecuted || (this.action(), this.stop());
                }, DelayedActionManager.prototype.stop = function() {
                    clearTimeout(this.actionTimeoutId), this.actionTimeoutId = null;
                }, DelayedActionManager;
            }();
            exports.R = DelayedActionManager;
        },
        6136: function(__unused_webpack_module, exports, __webpack_require__) {
            "use strict";
            exports.$ = void 0;
            var touch_1 = __webpack_require__(1632), DomEventHandler = function DomEventHandler(element, eventName, handler, options) {
                void 0 === options && (options = !0), this.element = element, this.eventName = eventName, 
                this.handler = handler, this.options = options;
            }, DomEventHandlersHolder = function() {
                function DomEventHandlersHolder() {
                    this.handlers = [];
                }
                return DomEventHandlersHolder.prototype.addListener = function(element, eventName, handler, options) {
                    void 0 === options && (options = !0), this.handlers.push(new DomEventHandler(element, eventName, handler, options)), 
                    element.addEventListener(eventName, handler, options);
                }, DomEventHandlersHolder.prototype.addListenerToWindow = function(eventName, handler, options) {
                    void 0 === options && (options = !0), this.handlers.push(new DomEventHandler(window, eventName, handler, options)), 
                    window.addEventListener(eventName, handler, options);
                }, DomEventHandlersHolder.prototype.addListenerToDocument = function(eventName, handler, options) {
                    void 0 === options && (options = !0), touch_1.TouchUtils.onEventAttachingToDocument(eventName, handler) && (this.handlers.push(new DomEventHandler(document, eventName, handler, options)), 
                    document.addEventListener(eventName, handler, options));
                }, DomEventHandlersHolder.prototype.removeAllListeners = function() {
                    this.handlers.forEach((function(evtHandler) {
                        return evtHandler.element.removeEventListener(evtHandler.eventName, evtHandler.handler, evtHandler.options);
                    })), this.handlers = [];
                }, DomEventHandlersHolder;
            }();
            exports.$ = DomEventHandlersHolder;
        },
        7820: function(__unused_webpack_module, exports) {
            "use strict";
            Object.defineProperty(exports, "__esModule", {
                value: !0
            }), exports.Flag = void 0;
            var Flag = function() {
                function Flag(initValue) {
                    void 0 === initValue && (initValue = 0), this.value = initValue;
                }
                return Flag.prototype.get = function(enumVal) {
                    return (this.value & enumVal) === enumVal;
                }, Flag.prototype.set = function(enumVal, newValue) {
                    return (this.value & enumVal) === enumVal !== newValue && (newValue ? this.value |= enumVal : this.value ^= enumVal), 
                    this;
                }, Flag.prototype.add = function(value) {
                    this.value |= value;
                }, Flag.prototype.anyOf = function() {
                    for (var flags = [], _i = 0; _i < arguments.length; _i++) flags[_i] = arguments[_i];
                    for (var _a = 0, flags_1 = flags; _a < flags_1.length; _a++) {
                        var flag = flags_1[_a];
                        if ((this.value & flag) === flag) return !0;
                    }
                    return !1;
                }, Flag.prototype.getValue = function() {
                    return this.value;
                }, Flag.prototype.clone = function() {
                    return new Flag(this.value);
                }, Flag;
            }();
            exports.Flag = Flag;
        },
        7496: function(__unused_webpack_module, exports) {
            "use strict";
            exports.m7 = void 0;
            var Initializer = function() {
                function Initializer() {}
                return Initializer.prototype.set = function(property, value) {
                    return this[property] = value, this;
                }, Initializer;
            }();
            exports.m7 = Initializer;
        },
        6799: function(__unused_webpack_module, exports, __webpack_require__) {
            "use strict";
            Object.defineProperty(exports, "__esModule", {
                value: !0
            }), exports.ExtendedMinMax = exports.ExtendedMax = exports.ExtendedMin = exports.MinMaxNumber = exports.MinMax = void 0;
            var tslib_1 = __webpack_require__(2020), MinMax = function MinMax(minElement, maxElement) {
                this.minElement = minElement, this.maxElement = maxElement;
            };
            exports.MinMax = MinMax;
            var MinMaxNumber = function(_super) {
                function MinMaxNumber() {
                    return null !== _super && _super.apply(this, arguments) || this;
                }
                return tslib_1.__extends(MinMaxNumber, _super), Object.defineProperty(MinMaxNumber.prototype, "length", {
                    get: function() {
                        return this.maxElement - this.minElement;
                    },
                    enumerable: !1,
                    configurable: !0
                }), MinMaxNumber;
            }(MinMax);
            exports.MinMaxNumber = MinMaxNumber;
            var ExtendedMin = function ExtendedMin(minElement, minValue) {
                this.minElement = minElement, this.minValue = minValue;
            };
            exports.ExtendedMin = ExtendedMin;
            var ExtendedMax = function ExtendedMax(maxElement, maxValue) {
                this.maxElement = maxElement, this.maxValue = maxValue;
            };
            exports.ExtendedMax = ExtendedMax;
            var ExtendedMinMax = function(_super) {
                function ExtendedMinMax(minElement, minValue, maxElement, maxValue) {
                    var _this = _super.call(this, minElement, maxElement) || this;
                    return _this.minValue = minValue, _this.maxValue = maxValue, _this;
                }
                return tslib_1.__extends(ExtendedMinMax, _super), ExtendedMinMax;
            }(MinMax);
            exports.ExtendedMinMax = ExtendedMinMax;
        },
        9094: function(__unused_webpack_module, exports) {
            "use strict";
            exports.K = void 0;
            var Stack = function() {
                function Stack() {
                    this.list = [], this._count = 0, this.last = void 0;
                }
                return Stack.prototype.push = function(val) {
                    this.list.push(val), this.last = val, this._count++;
                }, Stack.prototype.pop = function() {
                    this._count--;
                    var result = this.list.pop();
                    return this.last = this.list[this.list.length - 1], result;
                }, Stack.prototype.peek = function() {
                    return this.last;
                }, Object.defineProperty(Stack.prototype, "count", {
                    get: function() {
                        return this._count;
                    },
                    enumerable: !1,
                    configurable: !0
                }), Stack.prototype.getPrevious = function() {
                    return this.list[this._count - 2];
                }, Stack;
            }();
            exports.K = Stack;
        },
        9291: function(__unused_webpack_module, exports) {
            "use strict";
            exports.u = void 0;
            var UnitConverter = function() {
                function UnitConverter() {}
                return UnitConverter.hundredthsOfMillimeterToTwipsRound = function(value) {
                    return Math.round(1440 * value / 2540);
                }, UnitConverter.documentsToTwips = function(value) {
                    return 24 * value / 5;
                }, UnitConverter.pixelsToTwips = function(value) {
                    return Math.round(UnitConverter.pixelsToTwipsF(value));
                }, UnitConverter.pixelsToTwipsCustomDpi = function(value, dpi) {
                    return Math.round(UnitConverter.pixelsToTwipsFCustomDpi(value, dpi));
                }, UnitConverter.inchesToTwips = function(value) {
                    return Math.round(UnitConverter.inchesToTwipsF(value));
                }, UnitConverter.pointsToTwips = function(value) {
                    return Math.round(UnitConverter.pointsToTwipsF(value));
                }, UnitConverter.picasToTwips = function(value) {
                    return Math.round(1440 * value / UnitConverter.PICAS_PER_INCH);
                }, UnitConverter.centimetersToTwips = function(value) {
                    return Math.round(UnitConverter.centimetersToTwipsF(value));
                }, UnitConverter.pixelsToTwipsF = function(value) {
                    return 1440 * value / UnitConverter.DPI;
                }, UnitConverter.pixelsToTwipsFCustomDpi = function(value, dpi) {
                    return 1440 * value / dpi;
                }, UnitConverter.inchesToTwipsF = function(value) {
                    return 1440 * value;
                }, UnitConverter.pointsToTwipsF = function(value) {
                    return 20 * value;
                }, UnitConverter.centimetersToTwipsF = function(value) {
                    return 1440 * value / UnitConverter.CENTIMETERS_PER_INCH;
                }, UnitConverter.twipsToDegrees = function(value) {
                    return value / 6e4;
                }, UnitConverter.twipsToRadians = function(value) {
                    return value / 6e4 * Math.PI / 180;
                }, UnitConverter.degreesToTwips = function(value) {
                    return 6e4 * value;
                }, UnitConverter.radiansToTwips = function(value) {
                    return 6e4 * value / Math.PI * 180;
                }, UnitConverter.radiansToDegrees = function(value) {
                    return value / Math.PI * 180;
                }, UnitConverter.twipsToFD = function(value) {
                    return Math.round(2048 * value / 1875);
                }, UnitConverter.fdToTwips = function(value) {
                    return Math.round(1875 * value / 2048);
                }, UnitConverter.emuToTwips = function(val) {
                    return val / 635;
                }, UnitConverter.twipsToPixels = function(value) {
                    return Math.round(UnitConverter.twipsToPixelsF(value));
                }, UnitConverter.inchesToPixels = function(value) {
                    return Math.round(UnitConverter.DPI * value);
                }, UnitConverter.centimeterToPixel = function(value) {
                    return Math.round(this.centimeterToPixelF(value));
                }, UnitConverter.centimeterToPixelF = function(value) {
                    return value * UnitConverter.DPI / UnitConverter.CENTIMETERS_PER_INCH;
                }, UnitConverter.millimetersToPixel = function(value) {
                    return Math.round(value / (UnitConverter.CENTIMETERS_PER_INCH / UnitConverter.DPI) / 10);
                }, UnitConverter.pointsToPixels = function(value) {
                    return Math.round(value * UnitConverter.DPI / 72);
                }, UnitConverter.pointsToPixelsF = function(value) {
                    return value * UnitConverter.DPI / 72;
                }, UnitConverter.twipsToPixelsF = function(value) {
                    return value * UnitConverter.DPI / 1440;
                }, UnitConverter.pixelsToPoints = function(value) {
                    return Math.round(72 * value / UnitConverter.DPI);
                }, UnitConverter.pixelsToPointsF = function(value) {
                    return 72 * value / UnitConverter.DPI;
                }, UnitConverter.twipsToPoints = function(value) {
                    return Math.round(this.twipsToPointsF(value));
                }, UnitConverter.twipsToPointsF = function(value) {
                    return value / 20;
                }, UnitConverter.twipsToInches = function(value) {
                    return value / 1440;
                }, UnitConverter.pixelsToInches = function(value) {
                    return value / UnitConverter.DPI;
                }, UnitConverter.twipsToCentimeters = function(value) {
                    return value * UnitConverter.CENTIMETERS_PER_INCH / 1440;
                }, UnitConverter.pixelToCentimeters = function(value) {
                    return value * UnitConverter.CENTIMETERS_PER_INCH / UnitConverter.DPI;
                }, UnitConverter.twipsToHundredthsOfMillimeter = function(value) {
                    return Math.round(127 * value / 72);
                }, UnitConverter.pixelsToHundredthsOfMillimeter = function(value) {
                    return Math.round(2540 * value / UnitConverter.DPI);
                }, UnitConverter.hundredthsOfMillimeterToTwips = function(value) {
                    return 15 * value / 127;
                }, UnitConverter.twipsToEmu = function(val) {
                    return 635 * val;
                }, UnitConverter.twipsToDegree = function(value) {
                    return value / 6e4;
                }, UnitConverter.DPI = 96, UnitConverter.CENTIMETERS_PER_INCH = 2.54, UnitConverter.PICAS_PER_INCH = 6, 
                UnitConverter;
            }();
            exports.u = UnitConverter;
        },
        8785: function(__unused_webpack_module, exports) {
            "use strict";
            Object.defineProperty(exports, "__esModule", {
                value: !0
            }), exports.Int32Constants = exports.Constants = void 0;
            var Constants = function() {
                function Constants() {}
                return Constants.MIN_SAFE_INTEGER = -(Math.pow(2, 53) - 1), Constants.MAX_SAFE_INTEGER = Math.pow(2, 53) - 1, 
                Constants.MAX_BYTE = Math.pow(2, 8) - 1, Constants;
            }();
            exports.Constants = Constants;
            var Int32Constants = function() {
                function Int32Constants() {}
                return Int32Constants.MIN_VALUE = -2147483648, Int32Constants.MAX_VALUE = 2147483647, 
                Int32Constants;
            }();
            exports.Int32Constants = Int32Constants;
        },
        7774: function(__unused_webpack_module, exports) {
            "use strict";
            exports.D = void 0;
            var Errors = function() {
                function Errors() {}
                return Errors.internalExceptionTemplate = function(str) {
                    return Errors.InternalException + " " + str;
                }, Errors.NotImplemented = "The method is not implemented.", Errors.InternalException = "Internal exception.", 
                Errors.ValueCannotBeNull = "Value cannot be null.", Errors;
            }();
            exports.D = Errors;
        },
        8889: function(__unused_webpack_module, exports, __webpack_require__) {
            "use strict";
            exports.J = void 0;
            var tslib_1 = __webpack_require__(2020), DateTimeFieldFormatter = function() {
                function DateTimeFieldFormatter(options) {
                    this.AMPMKeyword = "am/pm", this.options = options;
                }
                return DateTimeFieldFormatter.prototype.format = function(date, formatString) {
                    this.date = date, this.formatString = formatString, this.result = "";
                    for (var index = 0, formatLength = this.formatString.length; index < formatLength; ) index += this.formatNext(index);
                    return this.result;
                }, DateTimeFieldFormatter.prototype.formatNext = function(index) {
                    var ch = this.formatString[index], formattingItem = this.tryCreateFormattingItem(ch);
                    return formattingItem ? this.processAsFormattingItem(index, formattingItem) : this.isKeyword(this.AMPMKeyword, index) ? this.processAsAMPMKeyword() : "'" === ch ? this.processAsEmbedText(index) : this.processAsSingleCharacter(index);
                }, DateTimeFieldFormatter.prototype.isKeyword = function(keyword, index) {
                    if (keyword.length > this.formatString.length - index) return !1;
                    var substring = this.formatString.substr(index, keyword.length);
                    return keyword.toLowerCase() === substring.toLowerCase();
                }, DateTimeFieldFormatter.prototype.processAsAMPMKeyword = function() {
                    var result = this.date.getHours() - 12 >= 0 ? this.options.pm : this.options.am;
                    return this.result += result, this.AMPMKeyword.length;
                }, DateTimeFieldFormatter.prototype.processAsEmbedText = function(index) {
                    var startTextIndex = index + 1;
                    if (startTextIndex >= this.formatString.length - 1) return 1;
                    var textLength = this.getCharacterSequenceLength(this.formatString[index], startTextIndex, this.charsAreNotEqual);
                    return textLength + startTextIndex === this.formatString.length ? (this.result += "'", 
                    1) : (this.result += this.formatString.substr(startTextIndex, textLength), textLength + 2);
                }, DateTimeFieldFormatter.prototype.processAsSingleCharacter = function(index) {
                    return this.result += this.formatString[index], 1;
                }, DateTimeFieldFormatter.prototype.processAsFormattingItem = function(index, formattingItem) {
                    var sequenceLength = this.getCharacterSequenceLength(this.formatString[index], index, this.charsAreEqual), patternLength = formattingItem.getAvailablePatternLength(sequenceLength), result = formattingItem.format(this.date, patternLength);
                    return this.result += result, Math.min(sequenceLength, patternLength);
                }, DateTimeFieldFormatter.prototype.getCharacterSequenceLength = function(ch, index, predicate) {
                    for (var length = this.formatString.length, nextCharIndex = index + 1; nextCharIndex < length && predicate(ch, this.formatString[nextCharIndex]); ) nextCharIndex++;
                    return nextCharIndex - index;
                }, DateTimeFieldFormatter.prototype.tryCreateFormattingItem = function(formattingChar) {
                    switch (formattingChar) {
                      case "h":
                        return new Hour12FormattingItem(this.options);

                      case "H":
                        return new Hour24FormattingItem(this.options);

                      case "m":
                        return new MinuteFormattingItem(this.options);

                      case "S":
                      case "s":
                        return new SecondFormattingItem(this.options);

                      case "Y":
                      case "y":
                        return new YearFormattingItem(this.options);

                      case "M":
                        return new MonthFormattingItem(this.options);

                      case "D":
                      case "d":
                        return new DayFormattingItem(this.options);
                    }
                    return null;
                }, DateTimeFieldFormatter.prototype.charsAreEqual = function(ch1, ch2) {
                    return ch1 === ch2;
                }, DateTimeFieldFormatter.prototype.charsAreNotEqual = function(ch1, ch2) {
                    return ch1 !== ch2;
                }, DateTimeFieldFormatter;
            }();
            exports.J = DateTimeFieldFormatter;
            var DateTimeFormattingItem = function() {
                function DateTimeFormattingItem(options) {
                    this.options = options;
                }
                return DateTimeFormattingItem.prototype.getAvailablePatternLength = function(patternLength) {
                    for (var count = this.patternsLength.length, i = 0; i < count; i++) if (this.patternsLength[i] >= patternLength) return this.patternsLength[i];
                    return this.patternsLength[count - 1];
                }, DateTimeFormattingItem;
            }(), NumericFormattingItem = function(_super) {
                function NumericFormattingItem() {
                    var _this = null !== _super && _super.apply(this, arguments) || this;
                    return _this.patternsLength = [ 1, 2 ], _this;
                }
                return tslib_1.__extends(NumericFormattingItem, _super), NumericFormattingItem.prototype.formatCore = function(value, patternLength) {
                    var result = "" + value;
                    return 2 === patternLength && 1 === result.length ? "0" + result : result;
                }, NumericFormattingItem;
            }(DateTimeFormattingItem), CombinedFormattingItem = function(_super) {
                function CombinedFormattingItem() {
                    var _this = null !== _super && _super.apply(this, arguments) || this;
                    return _this.patternsLength = [ 1, 2, 3, 4 ], _this;
                }
                return tslib_1.__extends(CombinedFormattingItem, _super), CombinedFormattingItem.prototype.format = function(date, patternLength) {
                    return patternLength <= 2 ? this.formatCore(this.getNumericValue(date), patternLength) : 3 === patternLength ? this.getAbbreviatedName(date) : this.getFullName(date);
                }, CombinedFormattingItem;
            }(NumericFormattingItem), Hour24FormattingItem = function(_super) {
                function Hour24FormattingItem() {
                    return null !== _super && _super.apply(this, arguments) || this;
                }
                return tslib_1.__extends(Hour24FormattingItem, _super), Hour24FormattingItem.prototype.format = function(date, patternLength) {
                    return this.formatCore(date.getHours(), patternLength);
                }, Hour24FormattingItem;
            }(NumericFormattingItem), Hour12FormattingItem = function(_super) {
                function Hour12FormattingItem() {
                    return null !== _super && _super.apply(this, arguments) || this;
                }
                return tslib_1.__extends(Hour12FormattingItem, _super), Hour12FormattingItem.prototype.format = function(date, patternLength) {
                    var hour = date.getHours() % 12;
                    return 0 === hour && (hour = 12), this.formatCore(hour, patternLength);
                }, Hour12FormattingItem;
            }(NumericFormattingItem), MinuteFormattingItem = function(_super) {
                function MinuteFormattingItem() {
                    return null !== _super && _super.apply(this, arguments) || this;
                }
                return tslib_1.__extends(MinuteFormattingItem, _super), MinuteFormattingItem.prototype.format = function(date, patternLength) {
                    return this.formatCore(date.getMinutes(), patternLength);
                }, MinuteFormattingItem;
            }(NumericFormattingItem), SecondFormattingItem = function(_super) {
                function SecondFormattingItem() {
                    return null !== _super && _super.apply(this, arguments) || this;
                }
                return tslib_1.__extends(SecondFormattingItem, _super), SecondFormattingItem.prototype.format = function(date, patternLength) {
                    return this.formatCore(date.getSeconds(), patternLength);
                }, SecondFormattingItem;
            }(NumericFormattingItem), DayFormattingItem = function(_super) {
                function DayFormattingItem() {
                    return null !== _super && _super.apply(this, arguments) || this;
                }
                return tslib_1.__extends(DayFormattingItem, _super), DayFormattingItem.prototype.getAbbreviatedName = function(date) {
                    return this.options.abbrDayNames[this.getDayOfWeek(date)];
                }, DayFormattingItem.prototype.getFullName = function(date) {
                    return this.options.dayNames[this.getDayOfWeek(date)];
                }, DayFormattingItem.prototype.getNumericValue = function(date) {
                    return date.getDate();
                }, DayFormattingItem.prototype.getDayOfWeek = function(date) {
                    return date.getDay();
                }, DayFormattingItem;
            }(CombinedFormattingItem), MonthFormattingItem = function(_super) {
                function MonthFormattingItem() {
                    return null !== _super && _super.apply(this, arguments) || this;
                }
                return tslib_1.__extends(MonthFormattingItem, _super), MonthFormattingItem.prototype.getAbbreviatedName = function(date) {
                    return this.options.abbrMonthNames[date.getMonth()];
                }, MonthFormattingItem.prototype.getFullName = function(date) {
                    return this.options.monthNames[date.getMonth()];
                }, MonthFormattingItem.prototype.getNumericValue = function(date) {
                    return date.getMonth() + 1;
                }, MonthFormattingItem;
            }(CombinedFormattingItem), YearFormattingItem = function(_super) {
                function YearFormattingItem() {
                    var _this = null !== _super && _super.apply(this, arguments) || this;
                    return _this.patternsLength = [ 2, 4 ], _this;
                }
                return tslib_1.__extends(YearFormattingItem, _super), YearFormattingItem.prototype.format = function(date, patternLength) {
                    var year = date.getFullYear();
                    if (2 === patternLength && year > 99) {
                        var result = "" + year % 100;
                        return 1 === result.length ? "0" + result : result;
                    }
                    return "" + year;
                }, YearFormattingItem;
            }(DateTimeFormattingItem);
        },
        8786: function(__unused_webpack_module, exports) {
            "use strict";
            Object.defineProperty(exports, "__esModule", {
                value: !0
            }), exports.DateUtils = void 0;
            var DateUtils = function() {
                function DateUtils() {}
                return DateUtils.fixTimezoneGap = function(oldDate, newDate) {
                    var diff = newDate.getHours() - oldDate.getHours();
                    if (0 !== diff) {
                        var sign = 1 === diff || -23 === diff ? -1 : 1, trial = new Date(newDate.getTime() + 36e5 * sign);
                        newDate.getHours() - trial.getHours() === diff && (sign > 0 || trial.getDate() === newDate.getDate()) && newDate.setTime(trial.getTime());
                    }
                }, DateUtils.expandTwoDigitYear = function(value, options) {
                    return (value += 1900) + 99 < options.twoDigitYearMax && (value += 100), value;
                }, DateUtils.toUtcTime = function(date) {
                    var result = new Date;
                    return result.setTime(date.valueOf() + DateUtils.getTimeZoneOffset(date)), result;
                }, DateUtils.getTimeZoneOffset = function(date) {
                    var utcFullYear = date.getUTCFullYear(), utcDate = new Date(utcFullYear, date.getUTCMonth(), date.getUTCDate(), date.getUTCHours(), date.getUTCMinutes(), date.getUTCSeconds(), date.getUTCMilliseconds());
                    return utcFullYear < 100 && utcDate.setFullYear(utcFullYear), utcDate.valueOf() - date.valueOf();
                }, DateUtils;
            }();
            exports.DateUtils = DateUtils;
        },
        5308: function(__unused_webpack_module, exports, __webpack_require__) {
            "use strict";
            Object.defineProperty(exports, "__esModule", {
                value: !0
            }), exports.DateFormatter = void 0;
            var string_1 = __webpack_require__(2866), string_2 = __webpack_require__(49), date_utils_1 = __webpack_require__(8786), DateFormatter = function() {
                function DateFormatter(options) {
                    this.date = new Date(2e3, 0, 1), this.mask = "", this.specifiers = {}, this.spPositions = [], 
                    this.parserKeys = [], this.savedYear = -1, this.isYearParsed = !1, this.parsedMonth = -1, 
                    this.knownSpecifiers = [ "d", "M", "y", "H", "h", "m", "s", "f", "F", "g", "t" ], 
                    this.replacers = {
                        d: this.replaceDay,
                        M: this.replaceMonth,
                        y: this.replaceYear,
                        H: this.replaceHours23,
                        h: this.replaceHours12,
                        m: this.replaceMinutes,
                        s: this.replaceSeconds,
                        F: this.replaceMsTrimmed,
                        f: this.replaceMs,
                        g: this.replaceEra,
                        t: this.replaceAmPm
                    }, this.parsers = {
                        d: this.parseDay,
                        M: this.parseMonth,
                        y: this.parseYear,
                        H: this.parseHours,
                        h: this.parseHours,
                        m: this.parseMinutes,
                        s: this.parseSeconds,
                        F: this.parseMs,
                        f: this.parseMs,
                        g: this.parseEra,
                        t: this.parseAmPm
                    }, this.options = options;
                }
                return DateFormatter.prototype.setFormatString = function(mask) {
                    2 === mask.length && "%" === mask.charAt(0) && (mask = mask.charAt(1));
                    var stringContainsDateSeparator = !!mask && -1 !== mask.indexOf(this.options.ds);
                    this.specifiers = {}, this.spPositions = [], this.mask = "";
                    for (var subt = 0, startPos = 0, skip = !1, backslash = !1, sp = "", prevCh = "", pos = 0; ;pos++) {
                        var ch = mask.charAt(pos);
                        if ("" === ch) {
                            sp.length > 0 && this.registerSpecifier(startPos, sp, stringContainsDateSeparator);
                            break;
                        }
                        "\\" !== ch || backslash ? (backslash || "'" !== ch && '"' !== ch ? (skip || ("/" === ch ? ch = this.options.ds : ":" === ch ? ch = this.options.ts : this.isKnownSpecifier(ch) && (0 === prevCh.length && (prevCh = ch), 
                        ch === prevCh ? sp += ch : (sp.length > 0 && this.registerSpecifier(startPos, sp, stringContainsDateSeparator), 
                        sp = ch, startPos = pos - subt))), this.mask += ch) : (skip = !skip, subt++), backslash = !1) : (backslash = !0, 
                        subt++), prevCh = ch;
                    }
                    this.spPositions.reverse();
                }, DateFormatter.prototype.format = function(date) {
                    this.date = date;
                    for (var result = this.mask, _i = 0, _a = this.spPositions; _i < _a.length; _i++) {
                        var pos = _a[_i], sp = this.specifiers[pos], replacerKey = sp.substr(0, 1);
                        this.replacers[replacerKey] && (result = result.substr(0, pos) + this.replacers[replacerKey].call(this, sp.length) + result.substr(pos + sp.length));
                    }
                    return result;
                }, DateFormatter.prototype.parse = function(str, rememberParserKeys) {
                    var now = new Date;
                    this.savedYear = now.getFullYear(), this.isYearParsed = !1, this.parsedMonth = -1, 
                    this.date = new Date(2e3, 0, now.getDate()), this.strToParse = str, this.catchNumbers(str), 
                    this.hasAmPm = !1;
                    for (var _i = 0, _a = this.spPositions; _i < _a.length; _i++) {
                        var pos = _a[_i], sp = this.specifiers[pos], parserKey = sp.substr(0, 1);
                        if (this.parsers[parserKey] && (rememberParserKeys && this.parserKeys.push(parserKey), 
                        !this.parsers[parserKey].call(this, sp.length))) return !1;
                    }
                    return !(this.hasAmPm && !this.fixHours()) && (this.isYearParsed || this.date.setFullYear(this.savedYear), 
                    this.parsedMonth < 0 && (this.parsedMonth = now.getMonth()), this.applyMonth(), 
                    this.date);
                }, DateFormatter.prototype.hasYear = function() {
                    return this.hasParserKey("y");
                }, DateFormatter.prototype.hasMonth = function() {
                    return this.hasParserKey("M");
                }, DateFormatter.prototype.hasDay = function() {
                    return this.hasParserKey("d");
                }, DateFormatter.prototype.hasHours = function() {
                    return this.hasParserKey("h") || this.hasParserKey("H");
                }, DateFormatter.prototype.hasMinutes = function() {
                    return this.hasParserKey("m");
                }, DateFormatter.prototype.hasSeconds = function() {
                    return this.hasParserKey("s");
                }, DateFormatter.prototype.hasMilliseconds = function() {
                    return this.hasParserKey("f") || this.hasParserKey("F");
                }, DateFormatter.prototype.hasParserKey = function(key) {
                    return -1 !== this.parserKeys.indexOf(key);
                }, DateFormatter.expandPredefinedFormat = function(format, options) {
                    switch (format) {
                      case "d":
                        return options.shortDate;

                      case "D":
                        return options.longDate;

                      case "t":
                        return options.shortTime;

                      case "T":
                        return options.longTime;

                      case "g":
                        return options.shortDate + " " + options.shortTime;

                      case "f":
                        return options.longDate + " " + options.shortTime;

                      case "G":
                        return options.shortDate + " " + options.longTime;

                      case "F":
                      case "U":
                        return options.longDate + " " + options.longTime;

                      case "M":
                      case "m":
                        return options.monthDay;

                      case "Y":
                      case "y":
                        return options.yearMonth;

                      case "O":
                      case "o":
                        return "yyyy'-'MM'-'dd'T'HH':'mm':'ss.fffffff";

                      case "R":
                      case "r":
                        return "ddd, dd MMM yyyy HH':'mm':'ss 'GMT'";

                      case "s":
                        return "yyyy'-'MM'-'dd'T'HH':'mm':'ss";

                      case "u":
                        return "yyyy'-'MM'-'dd HH':'mm':'ss'Z'";
                    }
                    return format;
                }, DateFormatter.prototype.applyMonth = function() {
                    for (var trial, day = this.date.getDate(); (trial = new Date).setTime(this.date.getTime()), 
                    trial.setMonth(this.parsedMonth), trial.getMonth() !== this.parsedMonth; ) --day, 
                    this.date.setDate(day);
                    date_utils_1.DateUtils.fixTimezoneGap(this.date, trial), this.date = trial;
                }, DateFormatter.prototype.registerSpecifier = function(pos, sp, stringContainsDateSeparator) {
                    if (this.options.ds.length > 1 && this.mask && !stringContainsDateSeparator) {
                        var dateParts = this.mask.split(this.options.ds);
                        dateParts && (dateParts.length > 0 && "" === dateParts[dateParts.length - 1] && dateParts.pop(), 
                        pos += (dateParts.length - 1) * (this.options.ds.length - 1));
                    }
                    this.spPositions.push(pos), this.specifiers[pos] = sp;
                }, DateFormatter.prototype.replaceDay = function(length) {
                    if (length < 3) {
                        var value = this.date.getDate().toString();
                        return 2 === length ? this.padLeft(value, 2) : value;
                    }
                    return 3 === length ? this.options.abbrDayNames[this.date.getDay()] : this.options.dayNames[this.date.getDay()];
                }, DateFormatter.prototype.replaceMonth = function(length) {
                    var value = 1 + this.date.getMonth();
                    switch (length) {
                      case 1:
                        return value.toString();

                      case 2:
                        return this.padLeft(value.toString(), 2);

                      case 3:
                        return this.options.abbrMonthNames[value - 1];

                      default:
                        for (var i in this.specifiers) if (Object.prototype.hasOwnProperty.call(this.specifiers, i)) {
                            var spec = this.specifiers[i];
                            if ("d" === spec || "dd" === spec) return this.options.genMonthNames[value - 1];
                        }
                        return this.options.monthNames[value - 1];
                    }
                }, DateFormatter.prototype.replaceYear = function(length) {
                    var value = this.date.getFullYear();
                    return length <= 2 && (value %= 100), this.padLeft(value.toString(), length);
                }, DateFormatter.prototype.replaceHours23 = function(length) {
                    var value = this.date.getHours().toString();
                    return length > 1 ? this.padLeft(value, 2) : value;
                }, DateFormatter.prototype.replaceHours12 = function(length) {
                    var value = this.date.getHours() % 12;
                    0 === value && (value = 12);
                    var strValue = value.toString();
                    return length > 1 ? this.padLeft(strValue, 2) : strValue;
                }, DateFormatter.prototype.replaceMinutes = function(length) {
                    var value = this.date.getMinutes().toString();
                    return length > 1 ? this.padLeft(value, 2) : value;
                }, DateFormatter.prototype.replaceSeconds = function(length) {
                    var value = this.date.getSeconds().toString();
                    return length > 1 ? this.padLeft(value, 2) : value;
                }, DateFormatter.prototype.replaceMsTrimmed = function(length) {
                    return this.formatMs(length, !0);
                }, DateFormatter.prototype.replaceMs = function(length) {
                    return this.formatMs(length, !1);
                }, DateFormatter.prototype.replaceEra = function(_length) {
                    return "A.D.";
                }, DateFormatter.prototype.replaceAmPm = function(length) {
                    var value = this.date.getHours() < 12 ? this.options.am : this.options.pm;
                    return length < 2 ? value.charAt(0) : value;
                }, DateFormatter.prototype.catchNumbers = function(str) {
                    var _this = this;
                    this.parseNumbers = [];
                    for (var match, regex = /\d+/g; match = regex.exec(str); ) this.parseNumbers.push(this.parseDecInt(match[0]));
                    var spCount = 0, now = new Date;
                    string_1.StringMapUtils.forEach(this.specifiers, (function(sp) {
                        if ("string" == typeof sp && _this.isNumericSpecifier(sp) && (spCount++, _this.parseNumbers.length < spCount)) {
                            var defaultValue = 0;
                            "y" === sp.charAt(0) && (defaultValue = now.getFullYear()), _this.parseNumbers.push(defaultValue);
                        }
                    }));
                    var excess = this.parseNumbers.length - spCount;
                    excess > 0 && this.parseNumbers.splice(spCount, excess), this.currentParseNumber = this.parseNumbers.length - 1;
                }, DateFormatter.prototype.popParseNumber = function() {
                    return this.parseNumbers[this.currentParseNumber--];
                }, DateFormatter.prototype.findAbbrMonth = function() {
                    return this.findMonthCore(this.options.abbrMonthNames);
                }, DateFormatter.prototype.findFullMonth = function() {
                    return this.findMonthCore(this.options.genMonthNames);
                }, DateFormatter.prototype.findMonthCore = function(monthNames) {
                    for (var inputLower = this.strToParse.toLowerCase(), i = 0; i < monthNames.length; i++) {
                        var monthName = monthNames[i].toLowerCase();
                        if (monthName.length > 0 && inputLower.indexOf(monthName) > -1) return this.strToParse = this.strToParse.replace(new RegExp(monthName, "gi"), string_2.StringUtils.repeat(" ", monthName.length)), 
                        1 + i;
                    }
                    return !1;
                }, DateFormatter.prototype.parseDay = function(length) {
                    if (length < 3) {
                        var value = this.popParseNumber();
                        if (value < 1 || value > 31) return !1;
                        this.date.setDate(value);
                    }
                    return !0;
                }, DateFormatter.prototype.parseMonth = function(length) {
                    var value;
                    switch (length) {
                      case 1:
                      case 2:
                        value = this.popParseNumber();
                        break;

                      case 3:
                        value = this.findAbbrMonth();
                        break;

                      default:
                        value = this.findFullMonth();
                    }
                    return !(!1 === value || value < 1 || value > 12) && (this.parsedMonth = value - 1, 
                    !0);
                }, DateFormatter.prototype.parseYear = function(_length) {
                    var value = this.popParseNumber();
                    return !(value > 9999) && (value < 100 && (value = date_utils_1.DateUtils.expandTwoDigitYear(value, this.options)), 
                    this.date.setFullYear(value), this.isYearParsed = !0, !0);
                }, DateFormatter.prototype.parseHours = function(_length) {
                    var value = this.popParseNumber();
                    return !(value > 23) && (this.date.setHours(value), !0);
                }, DateFormatter.prototype.parseMinutes = function(_length) {
                    var value = this.parseMinSecCore();
                    return -1 !== value && (this.date.setMinutes(value), !0);
                }, DateFormatter.prototype.parseSeconds = function(_length) {
                    var value = this.parseMinSecCore();
                    return -1 !== value && (this.date.setSeconds(value), !0);
                }, DateFormatter.prototype.parseMs = function(length) {
                    length > 3 && (length = 3);
                    for (var thr = 1, i = 0; i < length; i++) thr *= 10;
                    thr -= 1;
                    for (var value = this.popParseNumber(); value > thr; ) value /= 10;
                    return this.date.setMilliseconds(Math.round(value)), !0;
                }, DateFormatter.prototype.parseEra = function(_length) {
                    return !0;
                }, DateFormatter.prototype.parseAmPm = function(_length) {
                    return this.hasAmPm = this.options.am.length > 0 && this.options.pm.length > 0, 
                    !0;
                }, DateFormatter.prototype.parseDecInt = function(str) {
                    return parseInt(str, 10);
                }, DateFormatter.prototype.padLeft = function(str, length) {
                    for (;str.length < length; ) str = "0" + str;
                    return str;
                }, DateFormatter.prototype.formatMs = function(length, trim) {
                    var numVal = Math.floor(this.date.getMilliseconds() * Math.pow(10, length - 3)), value = this.padLeft(numVal.toString(), length);
                    if (trim) {
                        for (var pos = value.length - 1, req = !1; "0" === value.charAt(pos); ) req = !0, 
                        pos--;
                        req && (value = value.substring(0, pos + 1));
                    }
                    return value;
                }, DateFormatter.prototype.parseMinSecCore = function() {
                    var value = this.popParseNumber();
                    return value > 59 ? -1 : value;
                }, DateFormatter.prototype.fixHours = function() {
                    var state = this.getAmPmState(this.strToParse, !1);
                    if (!state) return !0;
                    var h = this.date.getHours();
                    switch (state) {
                      case "P":
                        if (h > 12) return !1;
                        h < 12 && this.date.setHours(12 + h);
                        break;

                      case "A":
                        12 === h && this.date.setHours(0);
                    }
                    return !0;
                }, DateFormatter.prototype.getAmPmState = function(str, skipCorrection) {
                    var am = this.options.am.charAt(0).toLowerCase(), pm = this.options.pm.charAt(0).toLowerCase(), amMatches = new RegExp(am, "gi").exec(str), pmMatches = new RegExp(pm, "gi").exec(str), amCount = amMatches ? amMatches.length : 0, pmCount = pmMatches ? pmMatches.length : 0, hasAm = amCount > 0;
                    return hasAm !== pmCount > 0 && amCount < 2 && pmCount < 2 ? hasAm ? "A" : "P" : skipCorrection ? null : (str = str.replace(new RegExp(this.getDayMonthNameReplacePattern(), "gi"), ""), 
                    this.getAmPmState(str, !0));
                }, DateFormatter.prototype.getDayMonthNameReplacePattern = function() {
                    return this.dayMonthNameReplacePattern ? this.dayMonthNameReplacePattern : this.createDayMonthNameReplacePattern();
                }, DateFormatter.prototype.createDayMonthNameReplacePattern = function() {
                    var parts = [];
                    return parts.push("(?:"), parts.push(this.createReplacePattern(this.options.monthNames)), 
                    parts.push(this.createReplacePattern(this.options.genMonthNames)), parts.push(this.createReplacePattern(this.options.abbrMonthNames)), 
                    parts.push(this.createReplacePattern(this.options.abbrDayNames)), parts.push(this.createReplacePattern(this.options.dayNames)), 
                    parts.push(")"), parts.join("");
                }, DateFormatter.prototype.createReplacePattern = function(names) {
                    return names && names.length > 0 ? "\\b" + names.join("\\b|\\b") + "\\b" : "";
                }, DateFormatter.prototype.isNumericSpecifier = function(sp) {
                    var ch = sp.charAt(0);
                    return !("g" === ch || "t" === ch || ("M" === ch || "d" === ch) && sp.length > 2);
                }, DateFormatter.prototype.isKnownSpecifier = function(sp) {
                    return sp = sp.charAt(0), -1 !== this.knownSpecifiers.indexOf(sp);
                }, DateFormatter;
            }();
            exports.DateFormatter = DateFormatter;
        },
        1768: function(__unused_webpack_module, exports, __webpack_require__) {
            "use strict";
            exports.$ = void 0;
            var tslib_1 = __webpack_require__(2020), date_1 = __webpack_require__(5308), number_1 = __webpack_require__(2004), string_1 = __webpack_require__(5418), SimpleFormattersManager = function() {
                function SimpleFormattersManager(options) {
                    this.options = options, this.dateFormatter = new date_1.DateFormatter(options), 
                    this.numberFormatter = new number_1.NumberFormatter(options), this.stringFormatter = new string_1.StringFormatter(this.dateFormatter, this.numberFormatter);
                }
                return SimpleFormattersManager.prototype.formatString = function(pattern) {
                    for (var _a, args = [], _i = 1; _i < arguments.length; _i++) args[_i - 1] = arguments[_i];
                    return (_a = this.stringFormatter).format.apply(_a, tslib_1.__spreadArray([ pattern ], args));
                }, SimpleFormattersManager.prototype.formatDate = function(format, date) {
                    return this.dateFormatter.setFormatString(format), this.dateFormatter.format(date);
                }, SimpleFormattersManager.prototype.formatNumber = function(format, value) {
                    return this.numberFormatter.format(format, value);
                }, SimpleFormattersManager;
            }();
            exports.$ = SimpleFormattersManager;
        },
        2004: function(__unused_webpack_module, exports) {
            "use strict";
            Object.defineProperty(exports, "__esModule", {
                value: !0
            }), exports.NumberFormatter = void 0;
            var NumberFormatter = function() {
                function NumberFormatter(options) {
                    this.positive = !0, this.digits = [], this.pointPos = 0, this.spec = "", this.prec = -1, 
                    this.upper = !0, this.custom = !1, this.options = options;
                }
                return NumberFormatter.prototype.format = function(format, value) {
                    if (isNaN(value)) return this.options.numNan;
                    if (!isFinite(value)) return value > 0 ? this.options.numPosInf : this.options.numNegInf;
                    if (this.fillFormatInfo(format), "X" === this.spec) return this.formatHex(value);
                    switch (this.fillDigitInfo(value), this.spec) {
                      case "C":
                        return this.formatCurrency();

                      case "D":
                        return this.formatDecimal();

                      case "E":
                        return this.formatExp();

                      case "F":
                        return this.formatFixed();

                      case "G":
                        return this.formatGeneral();

                      case "N":
                        return this.formatNumber();

                      case "P":
                        return this.formatPercent();

                      default:
                        return this.custom ? this.formatCustom(format) : "?";
                    }
                }, NumberFormatter.prototype.formatCurrency = function() {
                    this.prec < 0 && (this.prec = this.options.currPrec), this.round(this.prec);
                    var bag = [];
                    if (this.positive) switch (this.options.currPosPattern) {
                      case 0:
                        bag.push(this.options.currency);
                        break;

                      case 2:
                        bag.push(this.options.currency, " ");
                    } else switch (this.options.currNegPattern) {
                      case 0:
                        bag.push("(", this.options.currency);
                        break;

                      case 1:
                        bag.push("-", this.options.currency);
                        break;

                      case 2:
                        bag.push(this.options.currency, "-");
                        break;

                      case 3:
                        bag.push(this.options.currency);
                        break;

                      case 4:
                      case 15:
                        bag.push("(");
                        break;

                      case 5:
                      case 8:
                        bag.push("-");
                        break;

                      case 9:
                        bag.push("-", this.options.currency, " ");
                        break;

                      case 11:
                        bag.push(this.options.currency, " ");
                        break;

                      case 12:
                        bag.push(this.options.currency, " -");
                        break;

                      case 14:
                        bag.push("(", this.options.currency, " ");
                    }
                    if (this.appendGroupedInteger(bag, this.options.currGroups, this.options.currGroupSeparator), 
                    this.prec > 0 && (bag.push(this.options.currDecimalPoint), this.appendDigits(bag, this.pointPos, this.pointPos + this.prec)), 
                    this.positive) switch (this.options.currPosPattern) {
                      case 1:
                        bag.push(this.options.currency);
                        break;

                      case 3:
                        bag.push(" ", this.options.currency);
                    } else switch (this.options.currNegPattern) {
                      case 0:
                      case 14:
                        bag.push(")");
                        break;

                      case 3:
                      case 11:
                        bag.push("-");
                        break;

                      case 4:
                        bag.push(this.options.currency, ")");
                        break;

                      case 5:
                        bag.push(this.options.currency);
                        break;

                      case 6:
                        bag.push("-", this.options.currency);
                        break;

                      case 7:
                        bag.push(this.options.currency, "-");
                        break;

                      case 8:
                        bag.push(" ", this.options.currency);
                        break;

                      case 10:
                        bag.push(" ", this.options.currency, "-");
                        break;

                      case 13:
                        bag.push("- ", this.options.currency);
                        break;

                      case 15:
                        bag.push(" ", this.options.currency, ")");
                    }
                    return bag.join("");
                }, NumberFormatter.prototype.formatDecimal = function() {
                    if (this.prec < this.pointPos && (this.prec = this.pointPos), this.prec < 1) return "0";
                    var bag = [];
                    return this.positive || bag.push("-"), this.appendDigits(bag, this.pointPos - this.prec, this.pointPos), 
                    bag.join("");
                }, NumberFormatter.prototype.formatExp = function() {
                    return this.prec < 0 && (this.prec = 6), this.round(1 - this.pointPos + this.prec), 
                    this.formatExpCore(3);
                }, NumberFormatter.prototype.formatExpCore = function(minExpDigits) {
                    var bag = [];
                    this.positive || bag.push("-"), this.appendDigits(bag, 0, 1), this.prec > 0 && (bag.push(this.options.numDecimalPoint), 
                    this.appendDigits(bag, 1, 1 + this.prec)), bag.push(this.upper ? "E" : "e");
                    var order = this.pointPos - 1;
                    order >= 0 ? bag.push("+") : (bag.push("-"), order = -order);
                    for (var orderStr = String(order), i = orderStr.length; i < minExpDigits; i++) bag.push(0);
                    return bag.push(orderStr), bag.join("");
                }, NumberFormatter.prototype.formatFixed = function() {
                    this.prec < 0 && (this.prec = this.options.numPrec), this.round(this.prec);
                    var bag = [];
                    return this.positive || bag.push("-"), this.pointPos < 1 ? bag.push(0) : this.appendDigits(bag, 0, this.pointPos), 
                    this.prec > 0 && (bag.push(this.options.numDecimalPoint), this.appendDigits(bag, this.pointPos, this.pointPos + this.prec)), 
                    bag.join("");
                }, NumberFormatter.prototype.formatGeneral = function() {
                    var allowExp, hasFrac = this.pointPos < this.digits.length;
                    return this.prec < 0 ? (allowExp = hasFrac, this.prec = hasFrac ? 15 : 10) : (allowExp = !0, 
                    this.prec < 1 && (this.prec = hasFrac ? 15 : 10), this.round(this.prec - this.pointPos)), 
                    allowExp && (this.pointPos > this.prec || this.pointPos <= -4) ? (this.prec = this.digits.length - 1, 
                    this.formatExpCore(2)) : (this.prec = Math.min(this.prec, Math.max(1, this.digits.length)) - this.pointPos, 
                    this.formatFixed());
                }, NumberFormatter.prototype.formatNumber = function() {
                    this.prec < 0 && (this.prec = this.options.numPrec), this.round(this.prec);
                    var bag = [];
                    if (!this.positive) switch (this.options.numNegPattern) {
                      case 0:
                        bag.push("(");
                        break;

                      case 1:
                        bag.push("-");
                        break;

                      case 2:
                        bag.push("- ");
                    }
                    if (this.appendGroupedInteger(bag, this.options.numGroups, this.options.numGroupSeparator), 
                    this.prec > 0 && (bag.push(this.options.numDecimalPoint), this.appendDigits(bag, this.pointPos, this.pointPos + this.prec)), 
                    !this.positive) switch (this.options.numNegPattern) {
                      case 0:
                        bag.push(")");
                        break;

                      case 3:
                        bag.push("-");
                        break;

                      case 4:
                        bag.push(" -");
                    }
                    return bag.join("");
                }, NumberFormatter.prototype.formatPercent = function() {
                    this.prec < 0 && (this.prec = this.options.numPrec), this.digits.length > 0 && (this.pointPos += 2), 
                    this.round(this.prec);
                    var bag = [];
                    switch (this.positive || bag.push("-"), 2 === this.options.percentPattern && bag.push("%"), 
                    this.appendGroupedInteger(bag, this.options.numGroups, this.options.numGroupSeparator), 
                    this.prec > 0 && (bag.push(this.options.numDecimalPoint), this.appendDigits(bag, this.pointPos, this.pointPos + this.prec)), 
                    this.options.percentPattern) {
                      case 0:
                        bag.push(" %");
                        break;

                      case 1:
                        bag.push("%");
                    }
                    return bag.join("");
                }, NumberFormatter.prototype.formatHex = function(value) {
                    var result = value.toString(16);
                    if (result.indexOf("(") > -1) return result;
                    if (result = this.upper ? result.toUpperCase() : result.toLowerCase(), this.prec <= result.length) return result;
                    for (var bag = [], i = result.length; i < this.prec; i++) bag.push(0);
                    return bag.push(result), bag.join("");
                }, NumberFormatter.prototype.formatCustom = function(format) {
                    var sectionList = NumberFormatter.getCustomFormatSections(format), section = this.selectCustomFormatSection(sectionList);
                    if ("" === section) return this.positive ? "" : "-";
                    var info = NumberFormatter.parseCustomFormatSection(section), lists = this.createCustomFormatLists(info);
                    sectionList.length > 2 && section !== sectionList[2] && ("" === lists.i.concat(lists.f).join("").split("0").join("") && (section = sectionList[2], 
                    info = NumberFormatter.parseCustomFormatSection(section), lists = this.createCustomFormatLists(info)));
                    return this.formatCustomCore(section, info, lists);
                }, NumberFormatter.getCustomFormatSections = function(format) {
                    for (var sections = [], escaping = !1, quote = "", length = 0, prevPos = 0, i = 0; i < format.length; i++) {
                        var ch = format.charAt(i);
                        if (escaping || "" !== quote || ";" !== ch) escaping ? escaping = !1 : ch === quote ? quote = "" === quote ? ch : "" : "\\" === ch ? escaping = !0 : "'" !== ch && '"' !== ch || (quote = ch), 
                        ++length; else if (sections.push(format.substr(prevPos, length)), length = 0, prevPos = i + 1, 
                        sections.length > 2) break;
                    }
                    return length > 0 && sections.push(format.substr(prevPos, length)), sections.length < 1 && sections.push(format), 
                    sections;
                }, NumberFormatter.prototype.selectCustomFormatSection = function(sections) {
                    return !this.positive && sections.length > 1 && "" !== sections[1] ? (this.positive = !0, 
                    sections[1]) : this.digits.length < 1 && sections.length > 2 && "" !== sections[2] ? sections[2] : sections[0];
                }, NumberFormatter.createCustomFormatInfo = function() {
                    return {
                        pointPos: -1,
                        grouping: !1,
                        exp: !1,
                        expShowPlus: !1,
                        percent: !1,
                        scaling: 0,
                        intDigits: 0,
                        fracDigits: 0,
                        expDigits: 0,
                        intSharps: 0,
                        fracSharps: 0,
                        expSharps: 0
                    };
                }, NumberFormatter.parseCustomFormatSection = function(section) {
                    for (var quote = "", area = "i", canParseIntSharps = !0, result = NumberFormatter.createCustomFormatInfo(), groupSeparators = 0, i = 0; i < section.length; i++) {
                        var ch = section.charAt(i);
                        if (ch !== quote) {
                            if ("" === quote) if ("e" !== area || "0" === ch || "#" === ch) switch (ch) {
                              case "\\":
                                i++;
                                continue;

                              case "'":
                              case '"':
                                quote = ch;
                                continue;

                              case "#":
                              case "0":
                                if ("#" === ch) switch (area) {
                                  case "i":
                                    canParseIntSharps && result.intSharps++;
                                    break;

                                  case "f":
                                    result.fracSharps++;
                                    break;

                                  case "e":
                                    result.expSharps++;
                                } else switch (canParseIntSharps = !1, area) {
                                  case "f":
                                    result.fracSharps = 0;
                                    break;

                                  case "e":
                                    result.expSharps = 0;
                                }
                                switch (area) {
                                  case "i":
                                    result.intDigits++, groupSeparators > 0 && (result.grouping = !0), groupSeparators = 0;
                                    break;

                                  case "f":
                                    result.fracDigits++;
                                    break;

                                  case "e":
                                    result.expDigits++;
                                }
                                break;

                              case "e":
                              case "E":
                                if (result.exp) break;
                                if (result.exp = !0, area = "e", i < section.length - 1) {
                                    var next = section.charAt(1 + i);
                                    "+" === next || "-" === next ? ("+" === next && (result.expShowPlus = !0), i++) : "0" !== next && "#" !== next && (result.exp = !1, 
                                    result.pointPos < 0 && (area = "i"));
                                }
                                break;

                              case ".":
                                area = "f", result.pointPos < 0 && (result.pointPos = i);
                                break;

                              case "%":
                                result.percent = !0;
                                break;

                              case ",":
                                "i" === area && result.intDigits > 0 && groupSeparators++;
                            } else area = result.pointPos < 0 ? "i" : "f", i--;
                        } else quote = "";
                    }
                    return result.expDigits < 1 ? result.exp = !1 : result.intSharps = 0, result.fracDigits < 1 && (result.pointPos = -1), 
                    result.scaling = 3 * groupSeparators, result;
                }, NumberFormatter.prototype.createCustomFormatLists = function(info) {
                    var intList = [], fracList = [], expList = [];
                    this.digits.length > 0 && (info.percent && (this.pointPos += 2), this.pointPos -= info.scaling);
                    var expPositive = !0;
                    if (info.exp && (info.intDigits > 0 || info.fracDigits > 0)) {
                        var diff = 0;
                        this.digits.length > 0 && (this.round(info.intDigits + info.fracDigits - this.pointPos), 
                        diff -= this.pointPos - info.intDigits, this.pointPos = info.intDigits), expPositive = diff <= 0, 
                        expList = String(diff < 0 ? -diff : diff).split("");
                    } else this.round(info.fracDigits);
                    if (this.digits.length < 1 || this.pointPos < 1 ? intList = [ 0 ] : this.appendDigits(intList, 0, this.pointPos), 
                    this.appendDigits(fracList, this.pointPos, this.digits.length), info.exp) {
                        for (;intList.length < info.intDigits; ) intList.unshift(0);
                        for (;expList.length < info.expDigits - info.expSharps; ) expList.unshift(0);
                        expPositive && info.expShowPlus ? expList.unshift("+") : expPositive || expList.unshift("-");
                    } else {
                        for (;intList.length < info.intDigits - info.intSharps; ) intList.unshift(0);
                        if (info.intSharps >= info.intDigits) {
                            for (var zero = !0, i = 0; i < intList.length; i++) if (0 !== intList[i]) {
                                zero = !1;
                                break;
                            }
                            zero && (intList = []);
                        }
                    }
                    for (;fracList.length < info.fracDigits - info.fracSharps; ) fracList.push(0);
                    return {
                        i: intList,
                        f: fracList,
                        e: expList
                    };
                }, NumberFormatter.prototype.formatCustomCore = function(section, info, lists) {
                    var intLen = 0, total = 0, groupIndex = 0, counter = 0, groupSize = 0;
                    if (info.grouping && this.options.numGroups.length > 0) {
                        intLen = lists.i.length;
                        for (var i = 0; i < this.options.numGroups.length; i++) total + this.options.numGroups[i] <= intLen && (total += this.options.numGroups[i], 
                        groupIndex = i);
                        var fraction = intLen > total ? intLen - total : 0;
                        if (0 === (groupSize = this.options.numGroups[groupIndex])) {
                            for (;groupIndex >= 0 && 0 === this.options.numGroups[groupIndex]; ) groupIndex--;
                            groupSize = fraction > 0 ? fraction : this.options.numGroups[groupIndex];
                        }
                        0 === fraction ? counter = groupSize : (groupIndex += Math.floor(fraction / groupSize), 
                        0 === (counter = fraction % groupSize) ? counter = groupSize : groupIndex++);
                    } else info.grouping = !1;
                    var bag = [], area = "i", intSharps = 0, intListIndex = 0, fracListIndex = 0, savedCh = "";
                    for (i = 0; i < section.length; i++) {
                        var ch = section.charAt(i);
                        if (ch !== savedCh) if ("" === savedCh) switch (ch) {
                          case "\\":
                            ++i < section.length && bag.push(section.charAt(i));
                            continue;

                          case "'":
                          case '"':
                            savedCh = ch;
                            continue;

                          case "#":
                          case "0":
                            if ("i" === area) {
                                if (intSharps++, "0" === ch || info.intDigits - intSharps < lists.i.length + intListIndex) for (;info.intDigits - intSharps + intListIndex < lists.i.length; ) bag.push(lists.i[intListIndex].toString()), 
                                intListIndex++, info.grouping && --intLen > 0 && 0 == --counter && (bag.push(this.options.numGroupSeparator), 
                                --groupIndex < this.options.numGroups.length && groupIndex >= 0 && (groupSize = this.options.numGroups[groupIndex]), 
                                counter = groupSize);
                            } else "f" === area && fracListIndex < lists.f.length && (bag.push(lists.f[fracListIndex].toString()), 
                            fracListIndex++);
                            break;

                          case "e":
                          case "E":
                            if (null == lists.e || !info.exp) {
                                bag.push(ch);
                                break;
                            }
                            for (var q = i + 1; q < section.length && (q === i + 1 && ("+" === section.charAt(q) || "-" === section.charAt(q)) || "0" === section.charAt(q) || "#" === section.charAt(q)); q++) ;
                            i = q - 1, area = info.pointPos < 0 ? "i" : "f", bag.push(ch), bag = bag.concat(lists.e), 
                            lists.e = null;
                            break;

                          case ".":
                            info.pointPos === i && lists.f.length > 0 && bag.push(this.options.numDecimalPoint), 
                            area = "f";
                            break;

                          case ",":
                            break;

                          default:
                            bag.push(ch);
                        } else bag.push(ch); else savedCh = "";
                    }
                    return this.positive || bag.unshift("-"), bag.join("");
                }, NumberFormatter.prototype.fillDigitInfo = function(value) {
                    if (this.positive = !0, value < 0 && (value = -value, this.positive = !1), this.digits = [], 
                    this.pointPos = 0, 0 !== value && isFinite(value) && !isNaN(value)) {
                        var list = String(value).split("e"), str = list[0];
                        list.length > 1 && (this.pointPos = Number(list[1]));
                        for (var frac = !1, decimalCount = 0, i = 0; i < str.length; i++) {
                            var ch = str.charAt(i);
                            "." === ch ? frac = !0 : (frac && decimalCount++, ("0" !== ch || this.digits.length > 0) && this.digits.push(Number(ch)));
                        }
                        this.pointPos += this.digits.length - decimalCount;
                    } else this.pointPos = 1;
                }, NumberFormatter.prototype.fillFormatInfo = function(format) {
                    var spec;
                    if (this.upper = !0, this.custom = !1, this.prec = -1, (spec = null == format || format.length < 1 ? "G" : format.charAt(0)) >= "a" && spec <= "z" && (spec = spec.toUpperCase(), 
                    this.upper = !1), spec >= "A" && spec <= "Z") {
                        if (null != format && format.length > 1) {
                            var prec = Number(format.substr(1));
                            isNaN(prec) ? this.custom = !0 : this.prec = prec;
                        }
                    } else this.custom = !0;
                    this.spec = this.custom ? "0" : spec;
                }, NumberFormatter.prototype.round = function(shift) {
                    var amount = this.digits.length - this.pointPos - shift;
                    if (!(amount <= 0)) {
                        var cutPos = this.pointPos + shift;
                        if (cutPos < 0) return this.digits = [], void (this.pointPos = 0);
                        var digit = this.digits[cutPos];
                        if (digit > 4) for (var i = 0; i < amount; i++) {
                            var index = cutPos - 1 - i;
                            if (index < 0 && (this.digits.unshift(0), this.pointPos++, cutPos++, index++), (digit = this.digits[index]) < 9) {
                                this.digits[index] = 1 + digit;
                                break;
                            }
                            this.digits[index] = 0, amount++;
                        }
                        for (i = cutPos - 1; i >= 0 && !(this.digits[i] > 0); i--) cutPos--;
                        this.digits.splice(cutPos, this.digits.length - cutPos);
                    }
                }, NumberFormatter.prototype.appendGroupedInteger = function(list, groups, separator) {
                    if (this.pointPos < 1) list.push(0); else {
                        for (var total = 0, groupIndex = 0, i = 0; i < groups.length && total + groups[i] <= this.pointPos; i++) total += groups[i], 
                        groupIndex = i;
                        if (groups.length > 0 && total > 0) {
                            var counter = void 0, groupSize = groups[groupIndex], fraction = this.pointPos > total ? this.pointPos - total : 0;
                            if (0 === groupSize) {
                                for (;groupIndex >= 0 && 0 === groups[groupIndex]; ) groupIndex--;
                                groupSize = fraction > 0 ? fraction : groups[groupIndex];
                            }
                            0 === fraction ? counter = groupSize : (groupIndex += Math.floor(fraction / groupSize), 
                            0 === (counter = fraction % groupSize) ? counter = groupSize : groupIndex++);
                            for (i = 0; ;) {
                                if (this.pointPos - i <= counter || 0 === counter) {
                                    this.appendDigits(list, i, this.pointPos);
                                    break;
                                }
                                this.appendDigits(list, i, i + counter), list.push(separator), i += counter, --groupIndex < groups.length && groupIndex >= 0 && (groupSize = groups[groupIndex]), 
                                counter = groupSize;
                            }
                        } else this.appendDigits(list, 0, this.pointPos);
                    }
                }, NumberFormatter.prototype.appendDigits = function(list, start, end) {
                    for (var i = start; i < end; i++) i < 0 || i >= this.digits.length ? list.push(0) : list.push(this.digits[i]);
                }, NumberFormatter;
            }();
            exports.NumberFormatter = NumberFormatter;
        },
        5418: function(__unused_webpack_module, exports, __webpack_require__) {
            "use strict";
            Object.defineProperty(exports, "__esModule", {
                value: !0
            }), exports.StringFormatter = void 0;
            var date_1 = __webpack_require__(5308), date_utils_1 = __webpack_require__(8786), StringFormatter = function() {
                function StringFormatter(dateFormatter, numberFormatter) {
                    this.activeDateFormat = null, this.dateFormatter = dateFormatter, this.numberFormatter = numberFormatter;
                }
                return StringFormatter.prototype.format = function(pattern) {
                    for (var args = [], _i = 1; _i < arguments.length; _i++) args[_i - 1] = arguments[_i];
                    for (var bag = [], pos = 0, savedPos = 0; pos < pattern.length; ) {
                        var ch = pattern.charAt(pos);
                        if (pos++, "{" === ch) {
                            if (bag.push(pattern.substr(savedPos, pos - savedPos - 1)), "{" === pattern.charAt(pos)) {
                                savedPos = pos, pos++;
                                continue;
                            }
                            var spec = this.parseSpec(pattern, pos);
                            pos = spec.pos;
                            var arg = args[spec.index], argString = void 0;
                            if (null == arg) argString = ""; else if ("number" == typeof arg) argString = this.numberFormatter.format(spec.format, arg); else if (arg instanceof Date) spec.format !== this.activeDateFormat && (this.activeDateFormat = spec.format, 
                            "" === spec.format && (spec.format = "G"), 1 === spec.format.length && (spec.format = date_1.DateFormatter.expandPredefinedFormat(spec.format, this.dateFormatter.options)), 
                            this.dateFormatter.setFormatString(spec.format)), "U" === this.activeDateFormat && (arg = date_utils_1.DateUtils.toUtcTime(arg)), 
                            argString = this.dateFormatter.format(arg); else if (argString = String(arg), "" !== spec.format && argString.length > 0) {
                                var num = Number(argString.replace(",", "."));
                                isNaN(num) || (argString = this.numberFormatter.format(spec.format, num));
                            }
                            var padLen = spec.width - argString.length;
                            if (padLen > 0) {
                                spec.left && bag.push(argString);
                                for (var i = 0; i < padLen; i++) bag.push(" ");
                                spec.left || bag.push(argString);
                            } else bag.push(argString);
                            savedPos = pos;
                        } else if ("}" === ch && pos < pattern.length && "}" === pattern.charAt(pos)) bag.push(pattern.substr(savedPos, pos - savedPos - 1)), 
                        savedPos = pos, pos++; else if ("}" === ch) return "";
                    }
                    return savedPos < pattern.length && bag.push(pattern.substr(savedPos)), bag.join("");
                }, StringFormatter.prototype.parseSpec = function(format, pos) {
                    var savedPos, ch, result = {
                        index: -1,
                        left: !1,
                        width: 0,
                        format: "",
                        pos: 0
                    };
                    for (savedPos = pos; !((ch = format.charAt(pos)) < "0" || ch > "9"); ) pos++;
                    if (pos > savedPos && (result.index = Number(format.substr(savedPos, pos - savedPos))), 
                    "," === format.charAt(pos)) {
                        for (pos++; " " === (ch = format.charAt(pos)) || "\t" === ch; ) pos++;
                        for (result.left = "-" === format.charAt(pos), result.left && pos++, savedPos = pos; !((ch = format.charAt(pos)) < "0" || ch > "9"); ) pos++;
                        pos > savedPos && (result.width = Number(format.substr(savedPos, pos - savedPos)));
                    }
                    if (":" === format.charAt(pos)) {
                        for (savedPos = ++pos; "}" !== format.charAt(pos); ) pos++;
                        result.format = format.substr(savedPos, pos - savedPos);
                    }
                    return pos++, result.pos = pos, result;
                }, StringFormatter;
            }();
            exports.StringFormatter = StringFormatter;
        },
        3604: function(__unused_webpack_module, exports, __webpack_require__) {
            "use strict";
            exports.m = void 0;
            var tslib_1 = __webpack_require__(2020), Margins = function(_super) {
                function Margins() {
                    return null !== _super && _super.apply(this, arguments) || this;
                }
                return tslib_1.__extends(Margins, _super), Margins.empty = function() {
                    return new Margins(0, 0, 0, 0);
                }, Margins.prototype.clone = function() {
                    return new Margins(this.left, this.right, this.top, this.bottom);
                }, Margins;
            }(__webpack_require__(4125).Offsets);
            exports.m = Margins;
        },
        5596: function(__unused_webpack_module, exports) {
            "use strict";
            Object.defineProperty(exports, "__esModule", {
                value: !0
            }), exports.Metrics = void 0;
            var Metrics = function() {
                function Metrics() {}
                return Metrics.euclideanDistance = function(a, b) {
                    var xDist = a.x - b.x, yDist = a.y - b.y;
                    return Math.sqrt(xDist * xDist + yDist * yDist);
                }, Metrics.manhattanDistance = function(a, b) {
                    return Math.abs(a.x - b.x) + Math.abs(a.y - b.y);
                }, Metrics;
            }();
            exports.Metrics = Metrics;
        },
        4125: function(__unused_webpack_module, exports) {
            "use strict";
            Object.defineProperty(exports, "__esModule", {
                value: !0
            }), exports.Offsets = void 0;
            var Offsets = function() {
                function Offsets(left, right, top, bottom) {
                    this.left = left, this.right = right, this.top = top, this.bottom = bottom;
                }
                return Offsets.empty = function() {
                    return new Offsets(0, 0, 0, 0);
                }, Object.defineProperty(Offsets.prototype, "horizontal", {
                    get: function() {
                        return this.left + this.right;
                    },
                    enumerable: !1,
                    configurable: !0
                }), Object.defineProperty(Offsets.prototype, "vertical", {
                    get: function() {
                        return this.top + this.bottom;
                    },
                    enumerable: !1,
                    configurable: !0
                }), Offsets.fromNumber = function(offset) {
                    return new Offsets(offset, offset, offset, offset);
                }, Offsets.fromOffsets = function(offsets) {
                    return new Offsets(offsets.left, offsets.right, offsets.top, offsets.bottom);
                }, Offsets.fromSide = function(horizontal, vertical) {
                    return new Offsets(horizontal, horizontal, vertical, vertical);
                }, Offsets.prototype.normalize = function() {
                    return this.left = Math.max(0, this.left), this.right = Math.max(0, this.right), 
                    this.top = Math.max(0, this.top), this.bottom = Math.max(0, this.bottom), this;
                }, Offsets.prototype.toString = function() {
                    return JSON.stringify(this);
                }, Offsets.prototype.isEmpty = function() {
                    return 0 === this.left && 0 === this.right && 0 === this.top && 0 === this.bottom;
                }, Offsets.prototype.offset = function(offset) {
                    return this.left += offset.left, this.right += offset.right, this.top += offset.top, 
                    this.bottom += offset.bottom, this;
                }, Offsets.prototype.multiply = function(multLeft, multRight, multTop, multBottom) {
                    switch (arguments.length) {
                      case 1:
                        return this.left *= multLeft, this.right *= multLeft, this.top *= multLeft, this.bottom *= multLeft, 
                        this;

                      case 2:
                        return this.left *= multLeft, this.right *= multLeft, this.top *= multRight, this.bottom *= multRight, 
                        this;

                      case 4:
                        return this.left *= multLeft, this.right *= multRight, this.top *= multTop, this.bottom *= multBottom, 
                        this;
                    }
                    return this;
                }, Offsets.prototype.clone = function() {
                    return new Offsets(this.left, this.right, this.top, this.bottom);
                }, Offsets.prototype.copyFrom = function(obj) {
                    this.left = obj.left, this.right = obj.right, this.top = obj.top, this.bottom = obj.bottom;
                }, Offsets.prototype.equals = function(obj) {
                    return this.top === obj.top && this.bottom === obj.bottom && this.right === obj.right && this.left === obj.left;
                }, Offsets.prototype.applyConverter = function(converter) {
                    return this.left = converter(this.left), this.right = converter(this.right), this.top = converter(this.top), 
                    this.bottom = converter(this.bottom), this;
                }, Offsets;
            }();
            exports.Offsets = Offsets;
        },
        8900: function(__unused_webpack_module, exports) {
            "use strict";
            Object.defineProperty(exports, "__esModule", {
                value: !0
            }), exports.Point = void 0;
            var Point = function() {
                function Point(x, y) {
                    this.x = x, this.y = y;
                }
                return Point.zero = function() {
                    return new Point(0, 0);
                }, Point.fromNumber = function(num) {
                    return new Point(num, num);
                }, Point.prototype.isZero = function() {
                    return 0 === this.x && 0 === this.y;
                }, Point.prototype.toString = function() {
                    return JSON.stringify(this);
                }, Point.prototype.copyFrom = function(obj) {
                    this.x = obj.x, this.y = obj.y;
                }, Point.prototype.clone = function() {
                    return new Point(this.x, this.y);
                }, Point.prototype.equals = function(obj) {
                    return this.x === obj.x && this.y === obj.y;
                }, Point.prototype.offset = function(offsetX, offsetY) {
                    return this.x += offsetX, this.y += offsetY, this;
                }, Point.prototype.offsetByPoint = function(offset) {
                    return this.x += offset.x, this.y += offset.y, this;
                }, Point.prototype.multiply = function(multiplierX, multiplierY) {
                    return this.x *= multiplierX, this.y *= multiplierY, this;
                }, Point.prototype.negative = function() {
                    return this.x *= -1, this.y *= -1, this;
                }, Point.prototype.applyConverter = function(converter) {
                    return this.x = converter(this.x), this.y = converter(this.y), this;
                }, Point.plus = function(a, b) {
                    return new Point(a.x + b.x, a.y + b.y);
                }, Point.minus = function(a, b) {
                    return new Point(a.x - b.x, a.y - b.y);
                }, Point.xComparer = function(a, b) {
                    return a.x - b.x;
                }, Point.yComparer = function(a, b) {
                    return a.y - b.y;
                }, Point.equals = function(a, b) {
                    return a.x === b.x && a.y === b.y;
                }, Point;
            }();
            exports.Point = Point;
        },
        9210: function(__unused_webpack_module, exports, __webpack_require__) {
            "use strict";
            exports.VW = exports.mg = void 0;
            var CollisionResult, tslib_1 = __webpack_require__(2020), point_1 = __webpack_require__(8900), vector_1 = __webpack_require__(9716), segment_1 = __webpack_require__(1335), Polygon = function(_super) {
                function Polygon() {
                    return null !== _super && _super.apply(this, arguments) || this;
                }
                return tslib_1.__extends(Polygon, _super), Object.defineProperty(Polygon.prototype, "numEdges", {
                    get: function() {
                        return this.points.length;
                    },
                    enumerable: !1,
                    configurable: !0
                }), Polygon.fromRectangle = function(rect) {
                    var right = rect.x + rect.width, bottom = rect.y + rect.height;
                    return new Polygon([ new point_1.Point(rect.x, rect.y), new point_1.Point(right, rect.y), new point_1.Point(right, bottom), new point_1.Point(rect.x, bottom) ]);
                }, Polygon.prototype.getEdge = function(edgeIndex) {
                    return new segment_1.Segment(this.points[edgeIndex], this.points[(edgeIndex + 1) % this.numEdges]);
                }, Polygon.collision = function(a, b) {
                    for (var edgeCountA = a.numEdges, edgeCountB = b.numEdges, intersect = !1, edgeIndex = 0; edgeIndex < edgeCountA + edgeCountB; edgeIndex++) {
                        var edge = edgeIndex < edgeCountA ? a.getEdge(edgeIndex) : b.getEdge(edgeIndex - edgeCountA), edgeVector = vector_1.Vector.fromSegment(edge), axis = new vector_1.Vector(-edgeVector.y, edgeVector.x).normalize(), projectionA = a.projection(axis), projectionB = b.projection(axis), intersectionOfProjection = projectionA.minValue < projectionB.minValue ? projectionB.minValue - projectionA.maxValue : projectionA.minValue - projectionB.maxValue;
                        if (intersectionOfProjection > 0) return CollisionResult.None;
                        intersectionOfProjection < 0 && (intersect = !0);
                    }
                    return intersect ? CollisionResult.Intersect : CollisionResult.Contact;
                }, Polygon;
            }(__webpack_require__(2313).PolygonalChain);
            exports.mg = Polygon, function(CollisionResult) {
                CollisionResult[CollisionResult.None = 0] = "None", CollisionResult[CollisionResult.Intersect = 1] = "Intersect", 
                CollisionResult[CollisionResult.Contact = 2] = "Contact";
            }(CollisionResult = exports.VW || (exports.VW = {}));
        },
        2313: function(__unused_webpack_module, exports, __webpack_require__) {
            "use strict";
            Object.defineProperty(exports, "__esModule", {
                value: !0
            }), exports.PolygonalChain = void 0;
            var list_1 = __webpack_require__(2940), point_1 = __webpack_require__(8900), rectangle_1 = __webpack_require__(8011), segment_1 = __webpack_require__(1335), vector_1 = __webpack_require__(9716), PolygonalChain = function() {
                function PolygonalChain(points) {
                    this.points = [], this.points = points;
                }
                return PolygonalChain.prototype.getSegment = function(edgeIndex) {
                    return new segment_1.Segment(this.points[edgeIndex], this.points[edgeIndex + 1]);
                }, Object.defineProperty(PolygonalChain.prototype, "bounds", {
                    get: function() {
                        var vertBounds = list_1.ListUtils.minMaxExtended(this.points, (function(p) {
                            return p.y;
                        })), horBounds = list_1.ListUtils.minMaxExtended(this.points, (function(p) {
                            return p.x;
                        }));
                        return new rectangle_1.Rectangle(horBounds.minValue, vertBounds.minValue, horBounds.maxValue - horBounds.minValue, vertBounds.maxValue - vertBounds.minValue);
                    },
                    enumerable: !1,
                    configurable: !0
                }), PolygonalChain.prototype.rotateAround = function(point, angle, rightSC, byClockwise) {
                    void 0 === rightSC && (rightSC = !1), void 0 === byClockwise && (byClockwise = !0);
                    var center = new point_1.Point(point.x, point.y);
                    this.changeCoordinateCenterTo(center);
                    for (var sinFi = Math.sin(angle), cosFi = Math.cos(angle), sign = (rightSC ? 1 : 0) ^ (byClockwise ? 1 : 0) ? -1 : 1, _i = 0, _a = this.points; _i < _a.length; _i++) {
                        var pt = _a[_i], clone = pt.clone();
                        pt.x = clone.x * cosFi + sign * clone.y * sinFi, pt.y = -sign * clone.x * sinFi + clone.y * cosFi;
                    }
                    return this.changeCoordinateCenterTo(center.multiply(-1, -1)), this;
                }, PolygonalChain.prototype.changeCoordinateCenterTo = function(p) {
                    var offset = new point_1.Point(p.x, p.y).multiply(-1, -1);
                    return list_1.ListUtils.forEach(this.points, (function(rp) {
                        return rp.offsetByPoint(offset);
                    })), this;
                }, PolygonalChain.prototype.projection = function(axis) {
                    return list_1.ListUtils.minMaxExtended(this.points, (function(p) {
                        return vector_1.Vector.scalarProduct(p, axis);
                    }));
                }, PolygonalChain;
            }();
            exports.PolygonalChain = PolygonalChain;
        },
        8011: function(__unused_webpack_module, exports, __webpack_require__) {
            "use strict";
            Object.defineProperty(exports, "__esModule", {
                value: !0
            }), exports.RectangleDeviation = exports.HitTestDeviation = exports.Rectangle = void 0;
            var HitTestDeviation, flag_1 = __webpack_require__(7820), algorithms_1 = __webpack_require__(1104), fixed_1 = __webpack_require__(8860), point_1 = __webpack_require__(8900), size_1 = __webpack_require__(6353), Rectangle = function() {
                function Rectangle(x, y, width, height) {
                    this.x = x, this.y = y, this.width = width, this.height = height;
                }
                return Object.defineProperty(Rectangle.prototype, "right", {
                    get: function() {
                        return this.x + this.width;
                    },
                    enumerable: !1,
                    configurable: !0
                }), Object.defineProperty(Rectangle.prototype, "bottom", {
                    get: function() {
                        return this.y + this.height;
                    },
                    enumerable: !1,
                    configurable: !0
                }), Object.defineProperty(Rectangle.prototype, "center", {
                    get: function() {
                        return Rectangle.center(this);
                    },
                    enumerable: !1,
                    configurable: !0
                }), Rectangle.prototype.createRectangle = function() {
                    return new Rectangle(this.x, this.y, this.width, this.height);
                }, Rectangle.prototype.createSize = function() {
                    return new size_1.Size(this.width, this.height);
                }, Rectangle.prototype.createPosition = function() {
                    return new point_1.Point(this.x, this.y);
                }, Rectangle.prototype.createVerticalInterval = function() {
                    return new fixed_1.FixedInterval(this.y, this.height);
                }, Rectangle.prototype.createHorizontalInterval = function() {
                    return new fixed_1.FixedInterval(this.x, this.width);
                }, Rectangle.fromGeometry = function(point, size) {
                    return new Rectangle(point.x, point.y, size.width, size.height);
                }, Rectangle.fromPoints = function(pointA, pointB) {
                    return new Rectangle(Math.min(pointA.x, pointB.x), Math.min(pointA.y, pointB.y), Math.abs(pointA.x - pointB.x), Math.abs(pointA.y - pointB.y));
                }, Rectangle.fromPositions = function(x1, y1, x2, y2) {
                    return new Rectangle(Math.min(x1, x2), Math.min(y1, y2), Math.abs(x2 - x1), Math.abs(y2 - y1));
                }, Rectangle.fromCenter = function(center, minRadius) {
                    return new Rectangle(center.x - minRadius, center.y - minRadius, 2 * minRadius, 2 * minRadius);
                }, Rectangle.prototype.isCollapsed = function() {
                    return 0 === this.width || 0 === this.height;
                }, Rectangle.prototype.isEmpty = function() {
                    return 0 === this.x && 0 === this.y && 0 === this.width && 0 === this.height;
                }, Rectangle.prototype.toString = function() {
                    return JSON.stringify(this);
                }, Rectangle.prototype.setPosition = function(pos) {
                    return this.x = pos.x, this.y = pos.y, this;
                }, Rectangle.prototype.setSize = function(size) {
                    return this.width = size.width, this.height = size.height, this;
                }, Rectangle.prototype.setGeomerty = function(rect) {
                    return this.x = rect.x, this.y = rect.y, this.width = rect.width, this.height = rect.height, 
                    this;
                }, Rectangle.prototype.moveRectangle = function(offsetX, offsetY) {
                    return this.x += offsetX, this.y += offsetY, this;
                }, Rectangle.prototype.moveRectangleByPoint = function(offset) {
                    return this.x += offset.x, this.y += offset.y, this;
                }, Rectangle.prototype.resize = function(deltaX, deltaY) {
                    return this.width += deltaX, this.height += deltaY, this;
                }, Rectangle.prototype.nonNegativeSize = function() {
                    return this.width < 0 && (this.width = 0), this.height < 0 && (this.height = 0), 
                    this;
                }, Rectangle.prototype.multiply = function(multiplierX, multiplierY) {
                    return this.x *= multiplierX, this.y *= multiplierY, this.width *= multiplierX, 
                    this.height *= multiplierY, this;
                }, Rectangle.prototype.equals = function(obj) {
                    return Rectangle.equals(this, obj);
                }, Rectangle.prototype.clone = function() {
                    var rect = new Rectangle(0, 0, 0, 0);
                    return rect.copyFrom(this), rect;
                }, Rectangle.prototype.copyFrom = function(obj) {
                    this.x = obj.x, this.y = obj.y, this.width = obj.width, this.height = obj.height;
                }, Rectangle.prototype.containsPoint = function(point) {
                    return Rectangle.containsPoint(this, point);
                }, Rectangle.prototype.containsRectangle = function(rectangle) {
                    return this.x <= rectangle.x && this.right >= rectangle.right && this.y <= rectangle.y && this.bottom >= rectangle.bottom;
                }, Rectangle.prototype.inflate = function(deltaX, deltaY) {
                    return void 0 === deltaY && (deltaY = deltaX), this.x -= deltaX, this.y -= deltaY, 
                    this.width += 2 * deltaX, this.height += 2 * deltaY, this;
                }, Rectangle.prototype.applyOffsetsInside = function(offsets) {
                    return this.x += offsets.left, this.y += offsets.top, this.width -= offsets.left + offsets.right, 
                    this.height -= offsets.top + offsets.bottom, this;
                }, Rectangle.prototype.applyNormalizedOffsetsInside = function(offsets) {
                    var left = Math.max(0, offsets.left), horSum = left + Math.max(0, offsets.right);
                    0 !== horSum && (horSum <= this.width ? (this.x += left, this.width -= horSum) : (this.x += this.width * (left / horSum), 
                    this.width = 0));
                    var top = Math.max(0, offsets.top), vertSum = top + Math.max(0, offsets.bottom);
                    return 0 !== vertSum && (vertSum <= this.height ? (this.y += top, this.height -= vertSum) : (this.y += this.height * (top / vertSum), 
                    this.height = 0)), this;
                }, Rectangle.prototype.applyOffsetsOutside = function(offsets) {
                    return this.x -= offsets.left, this.y -= offsets.top, this.width += offsets.left + offsets.right, 
                    this.height += offsets.top + offsets.bottom, this;
                }, Rectangle.prototype.applyConverter = function(converter) {
                    return this.x = converter(this.x), this.y = converter(this.y), this.width = converter(this.width), 
                    this.height = converter(this.height), this;
                }, Rectangle.getHorizIntersection = function(objA, objB) {
                    return algorithms_1.IntervalAlgorithms.getIntersection(new fixed_1.FixedInterval(objA.x, objA.width), new fixed_1.FixedInterval(objB.x, objB.width));
                }, Rectangle.getVertIntersection = function(objA, objB) {
                    return algorithms_1.IntervalAlgorithms.getIntersection(new fixed_1.FixedInterval(objA.y, objA.height), new fixed_1.FixedInterval(objB.y, objB.height));
                }, Rectangle.getIntersection = function(objA, objB) {
                    var horInters = algorithms_1.IntervalAlgorithms.getIntersection(new fixed_1.FixedInterval(objA.x, objA.width), new fixed_1.FixedInterval(objB.x, objB.width));
                    if (!horInters) return null;
                    var vertInters = algorithms_1.IntervalAlgorithms.getIntersection(new fixed_1.FixedInterval(objA.y, objA.height), new fixed_1.FixedInterval(objB.y, objB.height));
                    return vertInters ? new Rectangle(horInters.start, vertInters.start, horInters.length, vertInters.length) : null;
                }, Rectangle.getHorNonCollapsedIntersection = function(objA, objB) {
                    var inters = Rectangle.getHorizIntersection(objA, objB);
                    return inters && !inters.isCollapsed() ? inters : null;
                }, Rectangle.getVertNonCollapsedIntersection = function(objA, objB) {
                    var inters = Rectangle.getVertIntersection(objA, objB);
                    return inters && !inters.isCollapsed() ? inters : null;
                }, Rectangle.getNonCollapsedIntersection = function(objA, objB) {
                    var inters = Rectangle.getIntersection(objA, objB);
                    return inters && !inters.isCollapsed() ? inters : null;
                }, Rectangle.areIntersected = function(rectA, rectB) {
                    return !(rectA.x > rectB.x + rectB.width || rectB.x > rectA.x + rectA.width || rectA.y > rectB.y + rectB.height || rectB.y > rectA.y + rectA.height);
                }, Rectangle.union = function(rectA, rectB) {
                    var right = Math.max(rectA.x + rectA.width, rectB.x + rectB.width), bottom = Math.max(rectA.y + rectA.height, rectB.y + rectB.height), x = Math.min(rectA.x, rectB.x), y = Math.min(rectA.y, rectB.y);
                    return new Rectangle(x, y, right - x, bottom - y);
                }, Rectangle.equals = function(a, b) {
                    return a.x === b.x && a.y === b.y && a.width === b.width && a.height === b.height;
                }, Rectangle.center = function(rect) {
                    return new point_1.Point(rect.x + rect.width / 2, rect.y + rect.height / 2);
                }, Rectangle.containsPoint = function(rect, point) {
                    var right = rect.x + rect.width, bottom = rect.y + rect.height;
                    return point.y >= rect.y && bottom >= point.y && point.x >= rect.x && right >= point.x;
                }, Rectangle;
            }();
            exports.Rectangle = Rectangle, function(HitTestDeviation) {
                HitTestDeviation[HitTestDeviation.None = 0] = "None", HitTestDeviation[HitTestDeviation.Top = 1] = "Top", 
                HitTestDeviation[HitTestDeviation.Bottom = 2] = "Bottom", HitTestDeviation[HitTestDeviation.Left = 4] = "Left", 
                HitTestDeviation[HitTestDeviation.Right = 8] = "Right";
            }(HitTestDeviation = exports.HitTestDeviation || (exports.HitTestDeviation = {}));
            var RectangleDeviation = function() {
                function RectangleDeviation(initRectangle, initPoint) {
                    this.initRectangle = initRectangle, this.initPoint = initPoint, this.deviation = new flag_1.Flag(HitTestDeviation.None);
                }
                return RectangleDeviation.prototype.calcDeviation = function() {
                    return this.initPoint.x < this.initRectangle.x ? this.deviation.set(HitTestDeviation.Left, !0) : this.initPoint.x > this.initRectangle.right && this.deviation.set(HitTestDeviation.Right, !0), 
                    this.initPoint.y < this.initRectangle.y ? this.deviation.set(HitTestDeviation.Top, !0) : this.initPoint.y > this.initRectangle.bottom && this.deviation.set(HitTestDeviation.Bottom, !0), 
                    this;
                }, RectangleDeviation.prototype.calcAdditionalParams = function() {
                    return this.insidePoint = this.initPoint.clone(), this.offsetToInside = new point_1.Point(0, 0), 
                    this.deviation.get(HitTestDeviation.Left) ? (this.insidePoint.x = this.initRectangle.x, 
                    this.offsetToInside.x = this.insidePoint.x - this.initPoint.x) : this.deviation.get(HitTestDeviation.Right) && (this.insidePoint.x = this.initRectangle.right, 
                    this.offsetToInside.x = this.initPoint.x - this.insidePoint.x), this.deviation.get(HitTestDeviation.Top) ? (this.insidePoint.y = this.initRectangle.y, 
                    this.offsetToInside.y = this.insidePoint.y - this.initPoint.y) : this.deviation.get(HitTestDeviation.Bottom) && (this.insidePoint.y = this.initRectangle.bottom, 
                    this.offsetToInside.y = this.initPoint.y - this.insidePoint.y), this;
                }, RectangleDeviation;
            }();
            exports.RectangleDeviation = RectangleDeviation;
        },
        1335: function(__unused_webpack_module, exports, __webpack_require__) {
            "use strict";
            Object.defineProperty(exports, "__esModule", {
                value: !0
            }), exports.Segment = void 0;
            var math_1 = __webpack_require__(8679), metrics_1 = __webpack_require__(5596), point_1 = __webpack_require__(8900), rectangle_1 = __webpack_require__(8011), Segment = function() {
                function Segment(startPoint, endPoint) {
                    this.startPoint = startPoint, this.endPoint = endPoint;
                }
                return Object.defineProperty(Segment.prototype, "length", {
                    get: function() {
                        return metrics_1.Metrics.euclideanDistance(this.startPoint, this.endPoint);
                    },
                    enumerable: !1,
                    configurable: !0
                }), Object.defineProperty(Segment.prototype, "xLength", {
                    get: function() {
                        return Math.abs(this.endPoint.x - this.startPoint.x);
                    },
                    enumerable: !1,
                    configurable: !0
                }), Object.defineProperty(Segment.prototype, "yLength", {
                    get: function() {
                        return Math.abs(this.endPoint.y - this.startPoint.y);
                    },
                    enumerable: !1,
                    configurable: !0
                }), Object.defineProperty(Segment.prototype, "center", {
                    get: function() {
                        return new point_1.Point(this.startPoint.x + (this.endPoint.x - this.startPoint.x) / 2, this.startPoint.y + (this.endPoint.y - this.startPoint.y) / 2);
                    },
                    enumerable: !1,
                    configurable: !0
                }), Segment.prototype.isIntersected = function(segment) {
                    return this.startPoint.equals(segment.startPoint) || this.endPoint.equals(segment.startPoint) || this.startPoint.equals(segment.endPoint) || this.endPoint.equals(segment.endPoint) || this.intersectCore(segment) && segment.intersectCore(this);
                }, Segment.prototype.containsPoint = function(point, accuracy) {
                    return void 0 === accuracy && (accuracy = 1e-7), this.startPoint.equals(point) || this.endPoint.equals(point) || math_1.MathUtils.numberCloseTo(this.length, metrics_1.Metrics.euclideanDistance(this.startPoint, point) + metrics_1.Metrics.euclideanDistance(this.endPoint, point), accuracy);
                }, Segment.prototype.isIntersectedByRect = function(rect) {
                    if (rectangle_1.Rectangle.containsPoint(rect, this.startPoint) || rectangle_1.Rectangle.containsPoint(rect, this.endPoint)) return !0;
                    var left = rect.x, right = rect.x + rect.width, top = rect.y, bottom = rect.y + rect.height;
                    return this.isIntersected(new Segment(new point_1.Point(left, top), new point_1.Point(left, bottom))) || this.isIntersected(new Segment(new point_1.Point(right, top), new point_1.Point(right, bottom))) || this.isIntersected(new Segment(new point_1.Point(left, top), new point_1.Point(right, top))) || this.isIntersected(new Segment(new point_1.Point(left, bottom), new point_1.Point(right, bottom)));
                }, Segment.prototype.intersectCore = function(segment) {
                    if (this.startPoint.x === this.endPoint.x) {
                        if (this.startPoint.x - segment.endPoint.x != 0) return (this.startPoint.x - segment.startPoint.x) / (this.startPoint.x - segment.endPoint.x) <= 0;
                        if (segment.endPoint.y - this.endPoint.y != 0) return (segment.endPoint.y - this.startPoint.y) / (segment.endPoint.y - this.endPoint.y) <= 0;
                    }
                    if (this.startPoint.y === this.endPoint.y) {
                        if (this.startPoint.y - segment.endPoint.y != 0) return (this.startPoint.y - segment.startPoint.y) / (this.startPoint.y - segment.endPoint.y) <= 0;
                        if (segment.endPoint.x - this.endPoint.x != 0) return (segment.endPoint.x - this.startPoint.x) / (segment.endPoint.x - this.endPoint.x) <= 0;
                    }
                    var tg = (this.endPoint.y - this.startPoint.y) / (this.endPoint.x - this.startPoint.x), y1 = this.startPoint.y + (segment.startPoint.x - this.startPoint.x) * tg, y2 = this.startPoint.y + (segment.endPoint.x - this.startPoint.x) * tg, dy1 = segment.startPoint.y - y1, dy2 = segment.endPoint.y - y2;
                    return 0 === dy1 && 0 === dy2 ? (this.startPoint.y - y1) / (this.endPoint.y - y1) <= 0 || (this.startPoint.y - y2) / (this.endPoint.y - y2) <= 0 : 0 === dy1 || 0 === dy2 || dy1 / dy2 < 0;
                }, Segment;
            }();
            exports.Segment = Segment;
        },
        6353: function(__unused_webpack_module, exports) {
            "use strict";
            Object.defineProperty(exports, "__esModule", {
                value: !0
            }), exports.Size = void 0;
            var Size = function() {
                function Size(width, height) {
                    this.width = width, this.height = height;
                }
                return Size.empty = function() {
                    return new Size(0, 0);
                }, Size.fromNumber = function(num) {
                    return new Size(num, num);
                }, Size.initByCommonAction = function(action) {
                    var widthAdp = function(s) {
                        return s.width;
                    }, heightAdp = function(s) {
                        return s.height;
                    };
                    return new Size(action(widthAdp, heightAdp), action(heightAdp, widthAdp));
                }, Size.prototype.isEmpty = function() {
                    return 0 === this.width && 0 === this.height;
                }, Size.prototype.toString = function() {
                    return JSON.stringify(this);
                }, Size.prototype.nonNegativeSize = function() {
                    return this.width < 0 && (this.width = 0), this.height < 0 && (this.height = 0), 
                    this;
                }, Size.prototype.offset = function(offsetWidth, offsetHeight) {
                    return this.width = this.width + offsetWidth, this.height = this.height + offsetHeight, 
                    this;
                }, Size.prototype.multiply = function(multiplierW, multiplierH) {
                    return this.width *= multiplierW, this.height *= multiplierH, this;
                }, Size.prototype.equals = function(obj) {
                    return this.width === obj.width && this.height === obj.height;
                }, Size.prototype.clone = function() {
                    return new Size(this.width, this.height);
                }, Size.prototype.copyFrom = function(obj) {
                    this.width = obj.width, this.height = obj.height;
                }, Size.prototype.applyConverter = function(conv) {
                    return this.width = conv(this.width), this.height = conv(this.height), this;
                }, Size.equals = function(a, b) {
                    return a.width === b.width && a.height === b.height;
                }, Size;
            }();
            exports.Size = Size;
        },
        9716: function(__unused_webpack_module, exports) {
            "use strict";
            Object.defineProperty(exports, "__esModule", {
                value: !0
            }), exports.Vector = void 0;
            var Vector = function() {
                function Vector(x, y) {
                    void 0 === x && (x = 0), void 0 === y && (y = 0), this.x = x, this.y = y;
                }
                return Object.defineProperty(Vector.prototype, "length", {
                    get: function() {
                        return Math.sqrt(this.x * this.x + this.y * this.y);
                    },
                    enumerable: !1,
                    configurable: !0
                }), Vector.fromPoints = function(begin, end) {
                    return new Vector(end.x - begin.x, end.y - begin.y);
                }, Vector.fromSegment = function(segment) {
                    return new Vector(segment.endPoint.x - segment.startPoint.x, segment.endPoint.y - segment.startPoint.y);
                }, Vector.prototype.normalize = function() {
                    var length = this.length;
                    return 0 !== length && (this.x /= length, this.y /= length), this;
                }, Vector.prototype.negative = function() {
                    return this.x *= -1, this.y *= -1, this;
                }, Object.defineProperty(Vector, "axisX", {
                    get: function() {
                        return new Vector(1, 0);
                    },
                    enumerable: !1,
                    configurable: !0
                }), Object.defineProperty(Vector, "axisY", {
                    get: function() {
                        return new Vector(0, 1);
                    },
                    enumerable: !1,
                    configurable: !0
                }), Vector.angleBetween = function(a, b) {
                    var cosFi = Vector.scalarProduct(a, b) / (a.length * b.length);
                    return Math.acos(cosFi);
                }, Vector.scalarProduct = function(a, b) {
                    return a.x * b.x + a.y * b.y;
                }, Vector;
            }();
            exports.Vector = Vector;
        },
        1104: function(__unused_webpack_module, exports, __webpack_require__) {
            "use strict";
            Object.defineProperty(exports, "__esModule", {
                value: !0
            }), exports.IntervalAlgorithms = void 0;
            var list_1 = __webpack_require__(2940), search_1 = __webpack_require__(2400), fixed_1 = __webpack_require__(8860), collector_1 = __webpack_require__(6102), IntervalAlgorithms = function() {
                function IntervalAlgorithms() {}
                return IntervalAlgorithms.oneConstainsOtherArraysOfInterval = function(mergedIntervalsA, intervalsB) {
                    for (var shouldBeContais = list_1.ListUtils.deepCopy(intervalsB), currenInterval = shouldBeContais.pop(); currenInterval; ) {
                        if (!list_1.ListUtils.unsafeAnyOf(mergedIntervalsA, (function(mergedInterval) {
                            return mergedInterval.containsInterval(currenInterval);
                        }))) return !1;
                        currenInterval = shouldBeContais.pop();
                    }
                    return !0;
                }, IntervalAlgorithms.getIntersection = function(intervalA, intervalB) {
                    return IntervalAlgorithms.getIntersectionTemplate(intervalA, intervalB, intervalA);
                }, IntervalAlgorithms.getIntersectionTemplate = function(intervalA, intervalB, template) {
                    var start = Math.max(intervalA.start, intervalB.start), end = Math.min(intervalA.end, intervalB.end);
                    return start > end ? null : template.makeByStartEnd(start, end);
                }, IntervalAlgorithms.getIntersectionNonNullLength = function(intervalA, intervalB) {
                    return IntervalAlgorithms.getIntersectionNonNullLengthTemplate(intervalA, intervalB, intervalA);
                }, IntervalAlgorithms.getIntersectionNonNullLengthTemplate = function(intervalA, intervalB, template) {
                    var inters = IntervalAlgorithms.getIntersectionTemplate(intervalA, intervalB, template);
                    return inters && inters.length ? inters : null;
                }, IntervalAlgorithms.getIntersectionsTwoArraysOfInterval = function(intervalsA, intervalsB) {
                    return IntervalAlgorithms.getIntersectionsTwoArraysOfIntervalTemplate(intervalsA, intervalsB, intervalsA[0]);
                }, IntervalAlgorithms.getIntersectionsTwoArraysOfIntervalTemplate = function(intervalsA, intervalsB, template) {
                    for (var result = [], lengthIntervalsA = intervalsA.length, lengthIntervalsB = intervalsB.length, intervalsAIndex = 0, intervalsBIndex = 0, currAInterval = intervalsA[intervalsAIndex], currBInterval = intervalsB[intervalsBIndex], currResultInterval = null; intervalsAIndex < lengthIntervalsA && intervalsBIndex < lengthIntervalsB; ) {
                        var intersection = IntervalAlgorithms.getIntersectionTemplate(currAInterval, currBInterval, template);
                        intersection && (currResultInterval && currResultInterval.end === intersection.start ? currResultInterval.length += intersection.length : (currResultInterval = intersection, 
                        result.push(currResultInterval))), currAInterval.end < currBInterval.end ? currAInterval = intervalsA[++intervalsAIndex] : currBInterval = intervalsB[++intervalsBIndex];
                    }
                    return result;
                }, IntervalAlgorithms.getAffectedObjects = function(objects, intervals, getFirstIndex, conflictResolver) {
                    return void 0 === getFirstIndex && (getFirstIndex = function(start) {
                        return search_1.SearchUtils.normedInterpolationIndexOf(objects, (function(obj) {
                            return obj.interval.start;
                        }), start);
                    }), void 0 === conflictResolver && (conflictResolver = function(objectInterval, touchingIntervalLength, touchPoint) {
                        return objectInterval.start === touchPoint && 0 === touchingIntervalLength;
                    }), IntervalAlgorithms.getAffectedObjectsTemplate(objects, intervals, intervals[0], getFirstIndex, conflictResolver);
                }, IntervalAlgorithms.getAffectedObjectsTemplate = function(objects, intervals, template, getFirstIndex, conflictResolver) {
                    void 0 === getFirstIndex && (getFirstIndex = function(start) {
                        return search_1.SearchUtils.normedInterpolationIndexOf(objects, (function(obj) {
                            return obj.interval.start;
                        }), start);
                    }), void 0 === conflictResolver && (conflictResolver = function(objectInterval, touchingIntervalLength, touchPoint) {
                        return objectInterval.start === touchPoint && 0 === touchingIntervalLength;
                    });
                    for (var collector = new collector_1.SparseIntervalsCollector(template), _i = 0, intervals_1 = intervals; _i < intervals_1.length; _i++) for (var interval = intervals_1[_i], ind = Math.max(0, getFirstIndex(interval.start, objects)), obj = void 0; obj = objects[ind]; ind++) {
                        var objInterval = obj.interval;
                        if (objInterval.start > interval.end) break;
                        var intersection = IntervalAlgorithms.getIntersectionTemplate(objInterval, interval, template);
                        intersection && (intersection.length || conflictResolver(objInterval, interval.length, intersection.start)) && collector.add(ind);
                    }
                    return collector.getIntervals();
                }, IntervalAlgorithms.handleAffectedObjects = function(objects, intervals, callback, getFirstIndex) {
                    void 0 === getFirstIndex && (getFirstIndex = function(start) {
                        return search_1.SearchUtils.normedInterpolationIndexOf(objects, (function(obj) {
                            return obj.interval.start;
                        }), start);
                    });
                    for (var template = new fixed_1.FixedInterval(0, 0), _i = 0, intervals_2 = intervals; _i < intervals_2.length; _i++) for (var interval = intervals_2[_i], ind = Math.max(0, getFirstIndex(interval.start, objects)), obj = void 0; obj = objects[ind]; ind++) {
                        var objInterval = obj.interval;
                        if (objInterval.start > interval.end) break;
                        var intersection = IntervalAlgorithms.getIntersectionTemplate(objInterval, interval, template);
                        intersection && callback(obj, ind, interval, intersection);
                    }
                }, IntervalAlgorithms.getMergedIntervals = function(intervals, needSort) {
                    return IntervalAlgorithms.getMergedIntervalsTemplate(intervals, needSort, intervals[0]);
                }, IntervalAlgorithms.getMergedIntervalsTemplate = function(intervals, needSort, template) {
                    if (intervals.length < 2) return intervals.length > 0 ? [ template.makeByStartLength(intervals[0].start, intervals[0].length) ] : [];
                    for (var sortedIntervals = needSort ? [].concat(intervals).sort((function(a, b) {
                        return a.start - b.start;
                    })) : intervals, result = [], i = 0, interval = void 0; interval = sortedIntervals[i]; ) {
                        var minBound = interval.start, maxBound = interval.end;
                        for (++i; void 0 !== (interval = sortedIntervals[i]) && interval.start <= maxBound; i++) interval.end > maxBound && (maxBound = interval.end);
                        result.push(template.makeByStartEnd(minBound, maxBound));
                    }
                    return result;
                }, IntervalAlgorithms.reflectIntervals = function(intervals, bounds) {
                    return IntervalAlgorithms.reflectIntervalsTemplate(intervals, bounds, bounds);
                }, IntervalAlgorithms.reflectIntervalsTemplate = function(intervals, bounds, template) {
                    if (!intervals.length) return [ template.makeByStartLength(bounds.start, bounds.length) ];
                    var lastIntervalEnd = list_1.ListUtils.last(intervals).end, result = list_1.ListUtils.reducedMap(intervals, (function(curr, i) {
                        return IntervalAlgorithms.getIntersectionNonNullLengthTemplate(template.makeByStartEnd(intervals[i - 1].end, curr.start), bounds, template);
                    }), 1);
                    return bounds.start < intervals[0].start && result.unshift(template.makeByStartEnd(bounds.start, intervals[0].start)), 
                    bounds.end > lastIntervalEnd && result.push(template.makeByStartEnd(lastIntervalEnd, bounds.end)), 
                    result;
                }, IntervalAlgorithms.reflectionOfPointOnInterval = function(value, valInterval, targetInterval) {
                    return (value - valInterval.start) / valInterval.length * targetInterval.length + targetInterval.start;
                }, IntervalAlgorithms;
            }();
            exports.IntervalAlgorithms = IntervalAlgorithms;
        },
        7093: function(__unused_webpack_module, exports, __webpack_require__) {
            "use strict";
            exports.e = void 0;
            var tslib_1 = __webpack_require__(2020), BoundaryInterval = function(_super) {
                function BoundaryInterval(start, end) {
                    var _this = _super.call(this) || this;
                    return _this.start = start, _this.end = end, _this;
                }
                return tslib_1.__extends(BoundaryInterval, _super), Object.defineProperty(BoundaryInterval.prototype, "length", {
                    get: function() {
                        return this.end - this.start;
                    },
                    set: function(newLength) {
                        this.end = this.start + newLength;
                    },
                    enumerable: !1,
                    configurable: !0
                }), Object.defineProperty(BoundaryInterval.prototype, "center", {
                    get: function() {
                        return (this.start + this.end) / 2;
                    },
                    enumerable: !1,
                    configurable: !0
                }), BoundaryInterval.normalized = function(pointA, pointB) {
                    return pointA > pointB ? new BoundaryInterval(pointB, pointA) : new BoundaryInterval(pointA, pointB);
                }, BoundaryInterval.prototype.copyFrom = function(obj) {
                    this.start = obj.start, this.end = obj.end;
                }, BoundaryInterval.prototype.equals = function(obj) {
                    return obj && this.start === obj.start && this.end === obj.end;
                }, BoundaryInterval.prototype.clone = function() {
                    return new BoundaryInterval(this.start, this.length);
                }, BoundaryInterval.prototype.makeByStartEnd = function(start, end) {
                    return new BoundaryInterval(start, end);
                }, BoundaryInterval.prototype.makeByStartLength = function(start, length) {
                    return new BoundaryInterval(start, start + length);
                }, BoundaryInterval.prototype.makeByLengthEnd = function(length, end) {
                    return new BoundaryInterval(end - length, end);
                }, BoundaryInterval.makeByConstInterval = function(interval) {
                    return new BoundaryInterval(interval.start, interval.end);
                }, BoundaryInterval.prototype.expand = function(interval) {
                    return this.start = Math.min(interval.start, this.start), this.end = Math.max(interval.end, this.end), 
                    this;
                }, BoundaryInterval;
            }(__webpack_require__(8678).MutableInterval);
            exports.e = BoundaryInterval;
        },
        7814: function(__unused_webpack_module, exports) {
            "use strict";
            Object.defineProperty(exports, "__esModule", {
                value: !0
            }), exports.ConstInterval = void 0;
            var ConstInterval = function() {
                function ConstInterval() {}
                return Object.defineProperty(ConstInterval.prototype, "center", {
                    get: function() {
                        return this.start + this.length / 2;
                    },
                    enumerable: !1,
                    configurable: !0
                }), ConstInterval.prototype.isNormalized = function() {
                    return this.end >= this.start;
                }, ConstInterval.prototype.isCollapsed = function() {
                    return 0 === this.length;
                }, ConstInterval.prototype.equals = function(obj) {
                    return this.start === obj.start && this.end === obj.end;
                }, ConstInterval.isCollapsed = function(intervals) {
                    return !intervals[1] && intervals[0].isCollapsed();
                }, ConstInterval.prototype.containsInterval = function(interval) {
                    return this.start <= interval.start && this.end >= interval.end;
                }, ConstInterval.prototype.containsIntervalWithoutEnd = function(interval) {
                    return this.start <= interval.start && this.end > interval.end;
                }, ConstInterval.prototype.contains = function(pos) {
                    return this.start <= pos && pos < this.end;
                }, ConstInterval.prototype.containsWithIntervalEnd = function(val) {
                    return this.start <= val && val <= this.end;
                }, ConstInterval.prototype.containsWithoutIntervalEndAndStart = function(pos) {
                    return this.start < pos && pos < this.end;
                }, ConstInterval;
            }();
            exports.ConstInterval = ConstInterval;
        },
        8860: function(__unused_webpack_module, exports, __webpack_require__) {
            "use strict";
            Object.defineProperty(exports, "__esModule", {
                value: !0
            }), exports.FixedInterval = void 0;
            var tslib_1 = __webpack_require__(2020), FixedInterval = function(_super) {
                function FixedInterval(start, length) {
                    var _this = _super.call(this) || this;
                    return _this.start = start, _this.length = length, _this;
                }
                return tslib_1.__extends(FixedInterval, _super), Object.defineProperty(FixedInterval.prototype, "end", {
                    get: function() {
                        return this.start + this.length;
                    },
                    set: function(newEnd) {
                        this.length = newEnd - this.start;
                    },
                    enumerable: !1,
                    configurable: !0
                }), Object.defineProperty(FixedInterval.prototype, "center", {
                    get: function() {
                        return this.start + this.length / 2;
                    },
                    enumerable: !1,
                    configurable: !0
                }), FixedInterval.prototype.copyFrom = function(obj) {
                    this.start = obj.start, this.length = obj.length;
                }, FixedInterval.prototype.equals = function(obj) {
                    return obj && this.start === obj.start && this.length === obj.length;
                }, FixedInterval.prototype.clone = function() {
                    return new FixedInterval(this.start, this.length);
                }, FixedInterval.prototype.makeByStartEnd = function(start, end) {
                    return new FixedInterval(start, end - start);
                }, FixedInterval.prototype.makeByStartLength = function(start, length) {
                    return new FixedInterval(start, length);
                }, FixedInterval.prototype.makeByLengthEnd = function(length, end) {
                    return new FixedInterval(end - length, length);
                }, FixedInterval.fromPositions = function(start, end) {
                    return new FixedInterval(start, end - start);
                }, FixedInterval.makeByConstInterval = function(interval) {
                    return new FixedInterval(interval.start, interval.length);
                }, FixedInterval.prototype.expand = function(interval) {
                    var end = Math.max(interval.end, this.end);
                    return this.start = Math.min(interval.start, this.start), this.end = end, this;
                }, FixedInterval;
            }(__webpack_require__(8678).MutableInterval);
            exports.FixedInterval = FixedInterval;
        },
        8678: function(__unused_webpack_module, exports, __webpack_require__) {
            "use strict";
            Object.defineProperty(exports, "__esModule", {
                value: !0
            }), exports.MutableInterval = void 0;
            var tslib_1 = __webpack_require__(2020), MutableInterval = function(_super) {
                function MutableInterval() {
                    return null !== _super && _super.apply(this, arguments) || this;
                }
                return tslib_1.__extends(MutableInterval, _super), MutableInterval.prototype.normalizeLength = function() {
                    return this.length < 0 && (this.length = 0), this;
                }, MutableInterval;
            }(__webpack_require__(7814).ConstInterval);
            exports.MutableInterval = MutableInterval;
        },
        6102: function(__unused_webpack_module, exports, __webpack_require__) {
            "use strict";
            Object.defineProperty(exports, "__esModule", {
                value: !0
            }), exports.SparseIntervalsCollector = void 0;
            var intervals_1 = __webpack_require__(448), SparseIntervalsCollector = function() {
                function SparseIntervalsCollector(template) {
                    this.intervals = [], this.template = template;
                }
                return SparseIntervalsCollector.prototype.add = function(index) {
                    this.curr && this.curr.end === index ? this.curr.length++ : (this.curr = this.template.makeByStartLength(index, 1), 
                    this.intervals.push(this.curr));
                }, SparseIntervalsCollector.prototype.getIntervals = function() {
                    return new intervals_1.SparseIntervals(this.intervals);
                }, SparseIntervalsCollector;
            }();
            exports.SparseIntervalsCollector = SparseIntervalsCollector;
        },
        448: function(__unused_webpack_module, exports, __webpack_require__) {
            "use strict";
            Object.defineProperty(exports, "__esModule", {
                value: !0
            }), exports.SparseIntervals = void 0;
            var iterator_1 = __webpack_require__(8094), objects_iterator_1 = __webpack_require__(510), SparseIntervals = function() {
                function SparseIntervals(list) {
                    void 0 === list && (list = []), this.list = list, this._count = 0, this._numIntervals = 0;
                    for (var _i = 0, list_1 = list; _i < list_1.length; _i++) {
                        var curr = list_1[_i];
                        this._count += curr.length, this._numIntervals++;
                    }
                }
                return Object.defineProperty(SparseIntervals.prototype, "count", {
                    get: function() {
                        return this._count;
                    },
                    enumerable: !1,
                    configurable: !0
                }), Object.defineProperty(SparseIntervals.prototype, "numIntervals", {
                    get: function() {
                        return this._numIntervals;
                    },
                    enumerable: !1,
                    configurable: !0
                }), SparseIntervals.prototype.getInterval = function(index) {
                    return this.list[index];
                }, SparseIntervals.prototype.getNativeIterator = function() {
                    return new iterator_1.SparseIntervalsIterator(this);
                }, SparseIntervals.prototype.getObjectsIterator = function(objects) {
                    return new objects_iterator_1.SparseObjectsIterator(this, objects);
                }, SparseIntervals;
            }();
            exports.SparseIntervals = SparseIntervals;
        },
        8094: function(__unused_webpack_module, exports) {
            "use strict";
            Object.defineProperty(exports, "__esModule", {
                value: !0
            }), exports.SparseIntervalsIterator = void 0;
            var SparseIntervalsIterator = function() {
                function SparseIntervalsIterator(sparseIntervals) {
                    this.sparseIntervals = sparseIntervals, this.intervalIndex = -1;
                }
                return Object.defineProperty(SparseIntervalsIterator.prototype, "isStarted", {
                    get: function() {
                        return !!this.curr;
                    },
                    enumerable: !1,
                    configurable: !0
                }), SparseIntervalsIterator.prototype.moveNext = function() {
                    return this.curr && this.posInInterval + 1 < this.curr.length ? (this.posInInterval++, 
                    this.index++, this.initObject(), !0) : this.intervalIndex + 1 < this.sparseIntervals.numIntervals && (this.intervalIndex++, 
                    this.curr = this.sparseIntervals.getInterval(this.intervalIndex), this.curr.length ? (this.posInInterval = 0, 
                    this.index = this.curr.start, this.initObject(), !0) : this.moveNext());
                }, SparseIntervalsIterator.prototype.movePrev = function() {
                    return this.curr && this.posInInterval - 1 >= this.curr.start ? (this.posInInterval--, 
                    this.index--, this.initObject(), !0) : (this.isStarted || (this.intervalIndex = this.sparseIntervals.numIntervals), 
                    this.intervalIndex - 1 >= 0 && (this.intervalIndex--, this.curr = this.sparseIntervals.getInterval(this.intervalIndex), 
                    this.posInInterval = Math.max(this.curr.length - 1, this.curr.start), this.index = this.curr.start, 
                    this.initObject(), !0));
                }, SparseIntervalsIterator.prototype.initObject = function() {}, SparseIntervalsIterator;
            }();
            exports.SparseIntervalsIterator = SparseIntervalsIterator;
        },
        1215: function(__unused_webpack_module, exports, __webpack_require__) {
            "use strict";
            exports.g = void 0;
            var map_iterator_1 = __webpack_require__(3578), SparseIntervalsMapCollector = function() {
                function SparseIntervalsMapCollector(cmp, template) {
                    this.intervals = [], this.valMap = {}, this.cmp = cmp, this.template = template;
                }
                return SparseIntervalsMapCollector.prototype.add = function(index, value) {
                    this.curr && this.curr.end === index && 0 === this.cmp(this.currVal, value) ? this.curr.length++ : (this.curr = this.template.makeByStartLength(index, 1), 
                    this.intervals.push(this.curr), this.currVal = value, this.valMap[index] = value);
                }, SparseIntervalsMapCollector.prototype.getIterator = function() {
                    return new map_iterator_1.SparseIntervalsMapIterator(this.intervals, this.valMap);
                }, SparseIntervalsMapCollector;
            }();
            exports.g = SparseIntervalsMapCollector;
        },
        3578: function(__unused_webpack_module, exports, __webpack_require__) {
            "use strict";
            Object.defineProperty(exports, "__esModule", {
                value: !0
            }), exports.SparseIntervalsMapIterator = void 0;
            var intervals_1 = __webpack_require__(448), SparseIntervalsMapIterator = function() {
                function SparseIntervalsMapIterator(intervals, valMap) {
                    this.sparseIntervals = new intervals_1.SparseIntervals(intervals), this.valMap = valMap, 
                    this.intervalIndex = -1;
                }
                return Object.defineProperty(SparseIntervalsMapIterator.prototype, "numIntervals", {
                    get: function() {
                        return this.sparseIntervals.numIntervals;
                    },
                    enumerable: !1,
                    configurable: !0
                }), SparseIntervalsMapIterator.prototype.moveToNextPosition = function() {
                    return this.interval && this.posInInterval + 1 < this.interval.length ? (this.posInInterval++, 
                    this.position++, !0) : this.moveToNextInterval();
                }, SparseIntervalsMapIterator.prototype.moveToNextInterval = function() {
                    return this.intervalIndex + 1 < this.sparseIntervals.numIntervals && (this.intervalIndex++, 
                    this.interval = this.sparseIntervals.getInterval(this.intervalIndex), this.posInInterval = 0, 
                    this.position = this.interval.start, this.object = this.valMap[this.position], !0);
                }, SparseIntervalsMapIterator;
            }();
            exports.SparseIntervalsMapIterator = SparseIntervalsMapIterator;
        },
        510: function(__unused_webpack_module, exports, __webpack_require__) {
            "use strict";
            Object.defineProperty(exports, "__esModule", {
                value: !0
            }), exports.SparseObjectsIterator = void 0;
            var tslib_1 = __webpack_require__(2020), SparseObjectsIterator = function(_super) {
                function SparseObjectsIterator(sparseIntervals, objects) {
                    var _this = _super.call(this, sparseIntervals) || this;
                    return _this.objects = objects, _this;
                }
                return tslib_1.__extends(SparseObjectsIterator, _super), SparseObjectsIterator.prototype.initObject = function() {
                    this.obj = this.objects[this.index];
                }, SparseObjectsIterator;
            }(__webpack_require__(8094).SparseIntervalsIterator);
            exports.SparseObjectsIterator = SparseObjectsIterator;
        },
        1695: function(__unused_webpack_module, exports, __webpack_require__) {
            "use strict";
            exports.E = void 0;
            var browser_1 = __webpack_require__(9279), dom_1 = __webpack_require__(6907), plugin_helper_1 = __webpack_require__(5438), PdfHelperFrame = function() {
                function PdfHelperFrame(container, frameClassName) {
                    this.helperFrame = null, this.helperFrameName = null, this.container = container, 
                    this.frameClassName = frameClassName;
                }
                return PdfHelperFrame.prototype.dispose = function() {
                    this.removeHelperFrame();
                }, PdfHelperFrame.prototype.showPrintDialog = function(resourceUrl) {
                    if (browser_1.Browser.Edge || plugin_helper_1.PdfPluginHelper.isInstalled()) this.getHelperFrame().document.location = resourceUrl; else {
                        var printWindow_1 = window.open(resourceUrl, "print", "height=" + window.innerHeight + ",width=" + window.innerWidth + ",tabbar=no");
                        printWindow_1 && (printWindow_1.focus(), setTimeout((function() {
                            printWindow_1.print();
                        }), 100));
                    }
                }, PdfHelperFrame.prototype.getHelperFrame = function() {
                    return browser_1.Browser.Firefox && this.removeHelperFrame(), this.helperFrame || this.createHelperFrame(), 
                    this.helperFrame;
                }, PdfHelperFrame.prototype.removeHelperFrame = function() {
                    if (this.helperFrame) {
                        dom_1.DomUtils.hideNode(this.helperFrame);
                        try {
                            delete window.frames[this.helperFrameName];
                        } catch (e) {}
                        this.helperFrame = null, this.helperFrameName = null;
                    }
                }, PdfHelperFrame.prototype.createHelperFrame = function() {
                    var helperFrame = document.createElement("iframe"), frameSize = browser_1.Browser.Safari ? "1px" : "0px";
                    helperFrame.style.width = frameSize, helperFrame.style.height = frameSize, helperFrame.name = this.getNewName(), 
                    helperFrame.className = this.frameClassName, (browser_1.Browser.Chrome && browser_1.Browser.Version >= 77 || browser_1.Browser.Edge || browser_1.Browser.Safari) && helperFrame.addEventListener("load", (function() {
                        var _a, _b, _c;
                        "application/pdf" === (null === (_a = helperFrame.contentDocument) || void 0 === _a ? void 0 : _a.contentType) && (browser_1.Browser.Edge ? null === (_b = helperFrame.contentWindow) || void 0 === _b || _b.document.execCommand("print", !1, void 0) : browser_1.Browser.Safari ? setTimeout((function() {
                            var _a;
                            null === (_a = helperFrame.contentWindow) || void 0 === _a || _a.print();
                        }), 1e3) : null === (_c = helperFrame.contentWindow) || void 0 === _c || _c.print());
                    })), this.container.appendChild(helperFrame), this.helperFrame = window.frames[helperFrame.name], 
                    this.helperFrameName = helperFrame.name;
                }, PdfHelperFrame.prototype.getNewName = function() {
                    for (var index = 0; ;index++) {
                        var name_1 = "dxreHelperFrame" + index;
                        if (!window.frames[name_1]) return name_1;
                    }
                }, PdfHelperFrame;
            }();
            exports.E = PdfHelperFrame;
        },
        5438: function(__unused_webpack_module, exports, __webpack_require__) {
            "use strict";
            Object.defineProperty(exports, "__esModule", {
                value: !0
            }), exports.PdfPluginHelper = void 0;
            var browser_1 = __webpack_require__(9279), PdfPluginHelper = function() {
                function PdfPluginHelper() {}
                return PdfPluginHelper.isInstalled = function() {
                    return !!PdfPluginHelper.getPdfPlugin();
                }, PdfPluginHelper.getPdfPlugin = function() {
                    return PdfPluginHelper.plugin || (PdfPluginHelper.plugin = browser_1.Browser.IE ? PdfPluginHelper.getActiveXObject("AcroPDF.PDF") || PdfPluginHelper.getActiveXObject("PDF.PdfCtrl") : PdfPluginHelper.getNavigatorPlugin("Adobe Acrobat") || PdfPluginHelper.getNavigatorPlugin("Chrome PDF Viewer") || PdfPluginHelper.getNavigatorPlugin("WebKit built-in PDF") || PdfPluginHelper.getNavigatorPlugin("Chromium PDF Viewer")), 
                    PdfPluginHelper.plugin;
                }, PdfPluginHelper.getActiveXObject = function(name) {
                    try {
                        return new ActiveXObject(name);
                    } catch (e) {
                        return null;
                    }
                }, PdfPluginHelper.getNavigatorPlugin = function(name) {
                    var plugins = navigator.plugins;
                    for (var key in plugins) if (Object.prototype.hasOwnProperty.call(plugins, key)) {
                        var plugin = plugins[key];
                        if (plugin.name === name) return plugin;
                    }
                    return null;
                }, PdfPluginHelper.getVersion = function() {
                    try {
                        var plugin = PdfPluginHelper.getPdfPlugin();
                        if (browser_1.Browser.IE) {
                            var latest = plugin.GetVersions().split(",")[0].split("=");
                            return parseFloat(latest[1]);
                        }
                        return plugin.version ? parseInt(plugin.version) : plugin.name;
                    } catch (e) {
                        return null;
                    }
                }, PdfPluginHelper;
            }();
            exports.PdfPluginHelper = PdfPluginHelper;
        },
        2217: function(__unused_webpack_module, exports, __webpack_require__) {
            "use strict";
            exports.F = void 0;
            var browser_1 = __webpack_require__(9279), AttrUtils = function() {
                function AttrUtils() {}
                return AttrUtils.setElementAttribute = function(obj, attrName, value) {
                    obj.setAttribute && (browser_1.Browser.IE && browser_1.Browser.MajorVersion >= 11 && "src" === attrName.toLowerCase() && obj.setAttribute(attrName, ""), 
                    obj.setAttribute(attrName, value));
                }, AttrUtils.setStyleAttribute = function(obj, attrName, value) {
                    obj.setProperty && obj.setProperty(attrName, value, "");
                }, AttrUtils.getElementAttribute = function(obj, attrName) {
                    return obj.getAttribute(attrName);
                }, AttrUtils.getStyleAttribute = function(obj, attrName) {
                    if (obj.getPropertyValue) {
                        if (browser_1.Browser.Firefox) try {
                            return obj.getPropertyValue(attrName);
                        } catch (e) {
                            return obj[attrName];
                        }
                        return obj.getPropertyValue(attrName);
                    }
                    return null;
                }, AttrUtils.removeElementAttribute = function(obj, attrName) {
                    obj.removeAttribute && obj.removeAttribute(attrName);
                }, AttrUtils.removeStyleAttribute = function(obj, attrName) {
                    obj.removeProperty && obj.removeProperty(attrName);
                }, AttrUtils.changeElementStyleAttribute = function(obj, attrName, newValue) {
                    AttrUtils.saveStyleAttributeInElement(obj, attrName), AttrUtils.setStyleAttribute(obj.style, attrName, newValue);
                }, AttrUtils.restoreElementStyleAttribute = function(obj, attrName) {
                    var savedAttrName = "dxwu_saved" + attrName, style = obj.style;
                    if (AttrUtils.isExistsAttributeInElement(obj, savedAttrName)) {
                        var oldValue = AttrUtils.getElementAttribute(obj, savedAttrName);
                        return oldValue === AttrUtils.emptyObject || null === oldValue ? AttrUtils.removeStyleAttribute(style, attrName) : AttrUtils.setStyleAttribute(style, attrName, oldValue), 
                        AttrUtils.removeElementAttribute(obj, savedAttrName), !0;
                    }
                    return !1;
                }, AttrUtils.saveStyleAttributeInElement = function(obj, attrName) {
                    var savedAttrName = "dxwu_saved" + attrName, style = obj.style;
                    if (!AttrUtils.isExistsAttributeInElement(obj, savedAttrName)) {
                        var oldValue = AttrUtils.getStyleAttribute(style, attrName);
                        AttrUtils.setElementAttribute(obj, savedAttrName, AttrUtils.isAttributeExists(oldValue) ? oldValue : AttrUtils.emptyObject);
                    }
                }, AttrUtils.isExistsAttributeInElement = function(obj, attrName) {
                    var value = AttrUtils.getElementAttribute(obj, attrName);
                    return AttrUtils.isAttributeExists(value);
                }, AttrUtils.isAttributeExists = function(attrValue) {
                    return null !== attrValue && "" !== attrValue;
                }, AttrUtils.emptyObject = "DxEmptyValue", AttrUtils;
            }();
            exports.F = AttrUtils;
        },
        6477: function(__unused_webpack_module, exports, __webpack_require__) {
            "use strict";
            Object.defineProperty(exports, "__esModule", {
                value: !0
            }), exports.Base64Utils = void 0;
            var file_1 = __webpack_require__(2674), mime_type_1 = __webpack_require__(4633), Base64Utils = function() {
                function Base64Utils() {}
                return Base64Utils.normalizeToDataUrl = function(base64, mimeType) {
                    return Base64Utils.checkPrependDataUrl(base64) || (base64 = Base64Utils.prependByDataUrl(base64, mimeType)), 
                    base64;
                }, Base64Utils.prependByDataUrl = function(base64, mimeType) {
                    return "data:" + mimeType + ";base64," + base64;
                }, Base64Utils.checkPrependDataUrl = function(base64) {
                    return Base64Utils.dataUrl.test(base64);
                }, Base64Utils.deleteDataUrlPrefix = function(base64DataUrl) {
                    return base64DataUrl.replace(Base64Utils.dataUrl, "");
                }, Base64Utils.getUint8Array = function(base64) {
                    for (var n = (base64 = atob(base64)).length, arr = new Uint8Array(n); n--; ) arr[n] = base64.charCodeAt(n);
                    return arr;
                }, Base64Utils.fromArrayBuffer = function(buffer) {
                    for (var binary = [], bytes = new Uint8Array(buffer), len = bytes.byteLength, i = 0; i < len; i++) binary.push(String.fromCharCode(bytes[i]));
                    return window.btoa(binary.join(""));
                }, Base64Utils.getFileFromBase64 = function(base64, fileName, options) {
                    void 0 === fileName && (fileName = "");
                    var data = Base64Utils.getUint8Array(base64);
                    return file_1.FileUtils.createFile([ data ], fileName, options);
                }, Base64Utils.getMimeTypeAsString = function(base64) {
                    var match = base64.match(Base64Utils.dataUrl);
                    return match ? match[1] : null;
                }, Base64Utils.getKnownMimeType = function(base64) {
                    var match = base64.match(Base64Utils.dataUrl);
                    return match ? mime_type_1.MimeTypeUtils.stringTypeToType(match[1]) : mime_type_1.DxMimeType.Unknown;
                }, Base64Utils.fromBlobAsArrayBuffer = function(blob, callback) {
                    var reader = new FileReader;
                    reader.onloadend = function() {
                        return callback(Base64Utils.fromArrayBuffer(reader.result));
                    }, reader.readAsArrayBuffer(blob);
                }, Base64Utils.fromBlobAsDataUrl = function(blob, callback) {
                    var reader = new FileReader;
                    reader.onloadend = function() {
                        return callback(reader.result);
                    }, reader.readAsDataURL(blob);
                }, Base64Utils.dataUrl = /^data:(.*?)(;(.*?))??(;base64)?,/, Base64Utils;
            }();
            exports.Base64Utils = Base64Utils;
        },
        13: function(__unused_webpack_module, exports, __webpack_require__) {
            "use strict";
            exports.i = void 0;
            var string_1 = __webpack_require__(49), ColorUtils = function() {
                function ColorUtils() {}
                return ColorUtils.getAlpha = function(color) {
                    return color >> 24 & 255;
                }, ColorUtils.getRed = function(color) {
                    return color >> 16 & 255;
                }, ColorUtils.getGreen = function(color) {
                    return color >> 8 & 255;
                }, ColorUtils.getBlue = function(color) {
                    return 255 & color;
                }, ColorUtils.redPartToString = function(color) {
                    var redStr = ColorUtils.getRed(color).toString(16);
                    return redStr.length > 1 ? redStr : "0" + redStr;
                }, ColorUtils.greenPartToString = function(color) {
                    var greenStr = ColorUtils.getGreen(color).toString(16);
                    return greenStr.length > 1 ? greenStr : "0" + greenStr;
                }, ColorUtils.bluePartToString = function(color) {
                    var blueStr = ColorUtils.getBlue(color).toString(16);
                    return blueStr.length > 1 ? blueStr : "0" + blueStr;
                }, ColorUtils.fromArgbNumber = function(alpha, red, green, blue) {
                    return alpha << 24 | red << 16 | green << 8 | blue;
                }, ColorUtils.fromRgbaString = function(color, alpha) {
                    void 0 === alpha && (alpha = 255);
                    var matchesRGBA = color.replace(/ +/g, "").match(/(rgba?)|(\d+(\.\d+)?%?)|(\.\d+)/g);
                    if (matchesRGBA && matchesRGBA.length > 3) {
                        for (var result = [], i = 1, matchItem = void 0; matchItem = matchesRGBA[i]; i++) {
                            var item = -1 !== matchItem.indexOf("%") ? Math.round(2.55 * parseFloat(matchItem)) : parseInt(matchItem);
                            if (item < 0 || item > 255) return null;
                            result.push(item);
                        }
                        if (0 === color.indexOf("rgba")) {
                            if (isNaN(result[3]) || result[3] < 0 || result[3] > 1) return null;
                            result[3] <= 1 && (result[3] = Math.round(255 * result[3]));
                        } else if (result[3]) return null;
                        return (255 & result[0]) << 16 | (255 & result[1]) << 8 | 255 & result[2] | (255 & (result.length > 3 ? result[3] : alpha)) << 24;
                    }
                    return null;
                }, ColorUtils.fromHashString = function(hash, alpha) {
                    return void 0 === alpha && (alpha = 255), ColorUtils.isHashColorString(hash) ? ("#" === hash.charAt(0) && (hash = hash.substr(1)), 
                    3 === hash.length && (hash = string_1.StringUtils.repeat(hash.charAt(0), 2) + string_1.StringUtils.repeat(hash.charAt(1), 2) + string_1.StringUtils.repeat(hash.charAt(2), 2)), 
                    parseInt(hash, 16) | alpha << 24) : null;
                }, ColorUtils.fromColorName = function(color, alpha) {
                    void 0 === alpha && (alpha = 255);
                    var colorNameAsHash = ColorUtils.colorNames[color.toLowerCase()];
                    return colorNameAsHash ? ColorUtils.fromHashString(colorNameAsHash, alpha) : null;
                }, ColorUtils.fromString = function(color, alpha) {
                    void 0 === alpha && (alpha = 255);
                    var rgbaColor = ColorUtils.fromRgbaString(color, alpha);
                    if (null !== rgbaColor) return rgbaColor;
                    var hashColor = ColorUtils.fromHashString(color, alpha);
                    return null !== hashColor ? hashColor : ColorUtils.fromColorName(color, alpha);
                }, ColorUtils.colorToHash = function(color) {
                    return "#" + ColorUtils.redPartToString(color) + ColorUtils.greenPartToString(color) + ColorUtils.bluePartToString(color);
                }, ColorUtils.stringToHash = function(color) {
                    var result = this.fromString(color);
                    return null !== result ? this.colorToHash(result) : null;
                }, ColorUtils.isHashColorString = function(color) {
                    return /^#?([0-9a-f]{6})$/i.test(color) || /^#?([0-9a-f]{3})$/i.test(color);
                }, ColorUtils.isKnownColorName = function(color) {
                    return !!ColorUtils.colorNames[color.toLowerCase()];
                }, ColorUtils.isGray = function(color) {
                    var red = ColorUtils.getRed(color);
                    return red === ColorUtils.getGreen(color) && red === ColorUtils.getBlue(color);
                }, ColorUtils.DARK_COLOR = -16777216, ColorUtils.LIGHT_COLOR = -1, ColorUtils.colorNames = {
                    aliceblue: "#f0f8ff",
                    antiquewhite: "#faebd7",
                    aqua: "#00ffff",
                    aquamarine: "#7fffd4",
                    azure: "#f0ffff",
                    beige: "#f5f5dc",
                    bisque: "#ffe4c4",
                    black: "#000000",
                    blanchedalmond: "#ffebcd",
                    blue: "#0000ff",
                    blueviolet: "#8a2be2",
                    brown: "#a52a2a",
                    burlywood: "#deb887",
                    cadetblue: "#5f9ea0",
                    chartreuse: "#7fff00",
                    chocolate: "#d2691e",
                    coral: "#ff7f50",
                    cornflowerblue: "#6495ed",
                    cornsilk: "#fff8dc",
                    crimson: "#dc143c",
                    cyan: "#00ffff",
                    darkblue: "#00008b",
                    darkcyan: "#008b8b",
                    darkgoldenrod: "#b8860b",
                    darkgray: "#a9a9a9",
                    darkgreen: "#006400",
                    darkkhaki: "#bdb76b",
                    darkmagenta: "#8b008b",
                    darkolivegreen: "#556b2f",
                    darkorange: "#ff8c00",
                    darkorchid: "#9932cc",
                    darkred: "#8b0000",
                    darksalmon: "#e9967a",
                    darkseagreen: "#8fbc8f",
                    darkslateblue: "#483d8b",
                    darkslategray: "#2f4f4f",
                    darkturquoise: "#00ced1",
                    darkviolet: "#9400d3",
                    deeppink: "#ff1493",
                    deepskyblue: "#00bfff",
                    dimgray: "#696969",
                    dodgerblue: "#1e90ff",
                    feldspar: "#d19275",
                    firebrick: "#b22222",
                    floralwhite: "#fffaf0",
                    forestgreen: "#228b22",
                    fuchsia: "#ff00ff",
                    gainsboro: "#dcdcdc",
                    ghostwhite: "#f8f8ff",
                    gold: "#ffd700",
                    goldenrod: "#daa520",
                    gray: "#808080",
                    green: "#00ff00",
                    greenyellow: "#adff2f",
                    honeydew: "#f0fff0",
                    hotpink: "#ff69b4",
                    indianred: "#cd5c5c",
                    indigo: "#4b0082",
                    ivory: "#fffff0",
                    khaki: "#f0e68c",
                    lavender: "#e6e6fa",
                    lavenderblush: "#fff0f5",
                    lawngreen: "#7cfc00",
                    lemonchiffon: "#fffacd",
                    lightblue: "#add8e6",
                    lightcoral: "#f08080",
                    lightcyan: "#e0ffff",
                    lightgoldenrodyellow: "#fafad2",
                    lightgray: "#d3d3d3",
                    lightgreen: "#90ee90",
                    lightpink: "#ffb6c1",
                    lightsalmon: "#ffa07a",
                    lightseagreen: "#20b2aa",
                    lightskyblue: "#87cefa",
                    lightslateblue: "#8470ff",
                    lightslategray: "#778899",
                    lightsteelblue: "#b0c4de",
                    lightyellow: "#ffffe0",
                    lime: "#00ff00",
                    limegreen: "#32cd32",
                    linen: "#faf0e6",
                    magenta: "#ff00ff",
                    maroon: "#800000",
                    mediumaquamarine: "#66cdaa",
                    mediumblue: "#0000cd",
                    mediumorchid: "#ba55d3",
                    mediumpurple: "#9370d8",
                    mediumseagreen: "#3cb371",
                    mediumslateblue: "#7b68ee",
                    mediumspringgreen: "#00fa9a",
                    mediumturquoise: "#48d1cc",
                    mediumvioletred: "#c71585",
                    midnightblue: "#191970",
                    mintcream: "#f5fffa",
                    mistyrose: "#ffe4e1",
                    moccasin: "#ffe4b5",
                    navajowhite: "#ffdead",
                    navy: "#000080",
                    oldlace: "#fdf5e6",
                    olive: "#808000",
                    olivedrab: "#6b8e23",
                    orange: "#ffa500",
                    orangered: "#ff4500",
                    orchid: "#da70d6",
                    palegoldenrod: "#eee8aa",
                    palegreen: "#98fb98",
                    paleturquoise: "#afeeee",
                    palevioletred: "#d87093",
                    papayawhip: "#ffefd5",
                    peachpuff: "#ffdab9",
                    peru: "#cd853f",
                    pink: "#ffc0cb",
                    plum: "#dda0dd",
                    powderblue: "#b0e0e6",
                    purple: "#800080",
                    red: "#ff0000",
                    rosybrown: "#bc8f8f",
                    royalblue: "#4169e1",
                    saddlebrown: "#8b4513",
                    salmon: "#fa8072",
                    sandybrown: "#f4a460",
                    seagreen: "#2e8b57",
                    seashell: "#fff5ee",
                    sienna: "#a0522d",
                    silver: "#c0c0c0",
                    skyblue: "#87ceeb",
                    slateblue: "#6a5acd",
                    slategray: "#708090",
                    snow: "#fffafa",
                    springgreen: "#00ff7f",
                    steelblue: "#4682b4",
                    tan: "#d2b48c",
                    teal: "#008080",
                    thistle: "#d8bfd8",
                    tomato: "#ff6347",
                    turquoise: "#40e0d0",
                    violet: "#ee82ee",
                    violetred: "#d02090",
                    wheat: "#f5deb3",
                    white: "#ffffff",
                    whitesmoke: "#f5f5f5",
                    yellow: "#ffff00",
                    yellowgreen: "#9acd32",
                    windowtext: "#000000"
                }, ColorUtils;
            }();
            exports.i = ColorUtils;
        },
        2491: function(__unused_webpack_module, exports, __webpack_require__) {
            "use strict";
            Object.defineProperty(exports, "__esModule", {
                value: !0
            }), exports.numberToStringHex = exports.numberToStringBin = exports.isOdd = exports.isEven = exports.isNonNullString = exports.isString = exports.isNumber = exports.boolToString = exports.boolToInt = exports.isDefined = void 0;
            var string_1 = __webpack_require__(49);
            exports.isDefined = function isDefined(value) {
                return null != value;
            }, exports.boolToInt = function boolToInt(value) {
                return value ? 1 : 0;
            }, exports.boolToString = function boolToString(value) {
                return value ? "1" : "0";
            }, exports.isNumber = function isNumber(obj) {
                return "number" == typeof obj;
            }, exports.isString = function isString(obj) {
                return "string" == typeof obj;
            }, exports.isNonNullString = function isNonNullString(str) {
                return !!str;
            }, exports.isEven = function isEven(num) {
                return num % 2 != 0;
            }, exports.isOdd = function isOdd(num) {
                return num % 2 == 0;
            }, exports.numberToStringBin = function numberToStringBin(num, minLength) {
                return void 0 === minLength && (minLength = 0), string_1.StringUtils.padLeft(num.toString(2), minLength, "0");
            }, exports.numberToStringHex = function numberToStringHex(num, minLength) {
                return void 0 === minLength && (minLength = 0), string_1.StringUtils.padLeft(num.toString(16), minLength, "0");
            };
        },
        4170: function(__unused_webpack_module, exports) {
            "use strict";
            Object.defineProperty(exports, "__esModule", {
                value: !0
            }), exports.Equals = exports.Comparers = void 0;
            var Comparers = function() {
                function Comparers() {}
                return Comparers.number = function(a, b) {
                    return a - b;
                }, Comparers.string = function(a, b) {
                    return a === b ? 0 : a > b ? 1 : -1;
                }, Comparers.stringIgnoreCase = function(a, b) {
                    return (a = a.toLowerCase()) === (b = b.toLowerCase()) ? 0 : a > b ? 1 : -1;
                }, Comparers;
            }();
            exports.Comparers = Comparers;
            var Equals = function() {
                function Equals() {}
                return Equals.simpleType = function(a, b) {
                    return a === b;
                }, Equals.object = function(a, b) {
                    return a && b && (a === b || a.equals(b));
                }, Equals;
            }();
            exports.Equals = Equals;
        },
        8475: function(__unused_webpack_module, exports, __webpack_require__) {
            "use strict";
            exports.F = void 0;
            var browser_1 = __webpack_require__(9279), DataTransferUtils = function() {
                function DataTransferUtils() {}
                return DataTransferUtils.isBrowserSupportExtendedClientBuffer = function() {
                    return browser_1.Browser.WebKitFamily || browser_1.Browser.Firefox && browser_1.Browser.MajorVersion >= 50 || browser_1.Browser.Edge && browser_1.Browser.MajorVersion >= 14;
                }, DataTransferUtils.getPlainTextItem = function(items) {
                    return DataTransferUtils.getTransferItemByType(items, "text/plain");
                }, DataTransferUtils.getRtfTextItem = function(items) {
                    return DataTransferUtils.getTransferItemByType(items, "text/rtf");
                }, DataTransferUtils.getImageItem = function(items) {
                    for (var len = items.length; len--; ) if (items[len].type.indexOf("image") >= 0) return items[len].getAsFile();
                    return null;
                }, DataTransferUtils.getTransferItemByType = function(items, type) {
                    if (this.isBrowserSupportExtendedClientBuffer()) for (var len = items.length; len--; ) {
                        var item = items[len];
                        if (item.type.indexOf(type) >= 0) return item;
                    }
                    return null;
                }, DataTransferUtils;
            }();
            exports.F = DataTransferUtils;
        },
        6907: function(__unused_webpack_module, exports, __webpack_require__) {
            "use strict";
            Object.defineProperty(exports, "__esModule", {
                value: !0
            }), exports.DomUtils = void 0;
            var browser_1 = __webpack_require__(9279), common_1 = __webpack_require__(2491), math_1 = __webpack_require__(8679), string_1 = __webpack_require__(49), DomUtils = function() {
                function DomUtils() {}
                return DomUtils.clearInnerHtml = function(element) {
                    for (;element.firstChild; ) element.removeChild(element.firstChild);
                }, DomUtils.setStylePosition = function(style, point) {
                    style.left = math_1.MathUtils.round(point.x, 3) + "px", style.top = math_1.MathUtils.round(point.y, 3) + "px";
                }, DomUtils.setStyleSize = function(style, size) {
                    style.width = math_1.MathUtils.round(size.width, 3) + "px", style.height = math_1.MathUtils.round(size.height, 3) + "px";
                }, DomUtils.setStyleSizeAndPosition = function(style, rectangle) {
                    DomUtils.setStylePosition(style, rectangle), DomUtils.setStyleSize(style, rectangle);
                }, DomUtils.hideNode = function(node) {
                    if (node) {
                        var parentNode = node.parentNode;
                        parentNode && parentNode.removeChild(node);
                    }
                }, DomUtils.isHTMLElementNode = function(node) {
                    return node.nodeType === Node.ELEMENT_NODE;
                }, DomUtils.isTextNode = function(node) {
                    return node.nodeType === Node.TEXT_NODE;
                }, DomUtils.isElementNode = function(node) {
                    return node.nodeType === Node.ELEMENT_NODE;
                }, DomUtils.isHTMLTableRowElement = function(element) {
                    return "TR" === element.tagName;
                }, DomUtils.isItParent = function(parentElement, element) {
                    if (!parentElement || !element) return !1;
                    for (;element; ) {
                        if (element === parentElement) return !0;
                        if ("BODY" === element.tagName) return !1;
                        element = element.parentNode;
                    }
                    return !1;
                }, DomUtils.getParentByTagName = function(element, tagName) {
                    for (tagName = tagName.toUpperCase(); element; ) {
                        if ("BODY" === element.tagName) return null;
                        if (element.tagName === tagName) return element;
                        element = element.parentNode;
                    }
                    return null;
                }, DomUtils.getDocumentScrollTop = function() {
                    var isScrollBodyIE = browser_1.Browser.IE && "hidden" === DomUtils.getCurrentStyle(document.body).overflow && document.body.scrollTop > 0;
                    return browser_1.Browser.WebKitFamily || browser_1.Browser.Edge || isScrollBodyIE ? browser_1.Browser.MacOSMobilePlatform ? window.pageYOffset : browser_1.Browser.WebKitFamily && document.documentElement.scrollTop || document.body.scrollTop : document.documentElement.scrollTop;
                }, DomUtils.getDocumentScrollLeft = function() {
                    var isScrollBodyIE = browser_1.Browser.IE && "hidden" === DomUtils.getCurrentStyle(document.body).overflow && document.body.scrollLeft > 0;
                    return browser_1.Browser.Edge || isScrollBodyIE ? document.body ? document.body.scrollLeft : document.documentElement.scrollLeft : browser_1.Browser.WebKitFamily ? document.documentElement.scrollLeft || document.body.scrollLeft : document.documentElement.scrollLeft;
                }, DomUtils.getCurrentStyle = function(element) {
                    if (element.currentStyle) return element.currentStyle;
                    if (document.defaultView && document.defaultView.getComputedStyle) {
                        var result = document.defaultView.getComputedStyle(element, null);
                        if (!result && browser_1.Browser.Firefox && window.frameElement) {
                            for (var changes = [], curElement = window.frameElement; !(result = document.defaultView.getComputedStyle(element, null)); ) changes.push([ curElement, curElement.style.display ]), 
                            curElement.style.setProperty("display", "block", "important"), curElement = "BODY" === curElement.tagName ? curElement.ownerDocument.defaultView.frameElement : curElement.parentNode;
                            result = function cloneObject(srcObject) {
                                if ("object" != typeof srcObject || !common_1.isDefined(srcObject)) return srcObject;
                                var newObject = {};
                                for (var i in srcObject) newObject[i] = srcObject[i];
                                return newObject;
                            }(result);
                            for (var ch = void 0, i = 0; ch = changes[i]; i++) ch[0].style.display = ch[1];
                            document.body.offsetWidth;
                        }
                        return result;
                    }
                    return window.getComputedStyle(element, null);
                }, DomUtils.setFocus = function(element) {
                    function focusCore() {
                        try {
                            element.focus(), browser_1.Browser.IE && document.activeElement !== element && element.focus();
                        } catch (e) {}
                    }
                    browser_1.Browser.MacOSMobilePlatform ? focusCore() : setTimeout((function() {
                        focusCore();
                    }), 100);
                }, DomUtils.hasClassName = function(element, className) {
                    try {
                        var classNames = className.split(" "), classList = element.classList;
                        if (classList) {
                            for (var i = classNames.length - 1; i >= 0; i--) if (!classList.contains(classNames[i])) return !1;
                        } else {
                            var elementClassName = element.getAttribute && element.getAttribute("class");
                            if (!elementClassName) return !1;
                            var elementClasses = elementClassName.split(" ");
                            for (i = classNames.length - 1; i >= 0; i--) if (elementClasses.indexOf(classNames[i]) < 0) return !1;
                        }
                        return !0;
                    } catch (e) {
                        return !1;
                    }
                }, DomUtils.addClassName = function(element, className) {
                    if (!DomUtils.hasClassName(element, className)) {
                        var elementClassName = element.getAttribute && element.getAttribute("class");
                        element.setAttribute("class", "" === elementClassName ? className : elementClassName + " " + className);
                    }
                }, DomUtils.removeClassName = function(element, className) {
                    var updClassName = " " + (element.getAttribute && element.getAttribute("class")) + " ", newClassName = updClassName.replace(" " + className + " ", " ");
                    updClassName.length !== newClassName.length && element.setAttribute("class", string_1.StringUtils.trim(newClassName));
                }, DomUtils.toggleClassName = function(element, className, toggle) {
                    void 0 === toggle ? DomUtils.hasClassName(element, className) ? DomUtils.removeClassName(element, className) : DomUtils.addClassName(element, className) : toggle ? DomUtils.addClassName(element, className) : DomUtils.removeClassName(element, className);
                }, DomUtils.pxToInt = function(px) {
                    return pxToNumber(px, parseInt);
                }, DomUtils.pxToFloat = function(px) {
                    return pxToNumber(px, parseFloat);
                }, DomUtils.getAbsolutePositionY = function(element) {
                    function getAbsolutePositionY_FF3(element) {
                        return Math.round(element.getBoundingClientRect().top + DomUtils.getDocumentScrollTop());
                    }
                    return element ? browser_1.Browser.IE ? function getAbsolutePositionY_IE(element) {
                        return browser_1.Browser.IE && null === element.parentNode ? 0 : element.getBoundingClientRect().top + DomUtils.getDocumentScrollTop();
                    }(element) : browser_1.Browser.Firefox && browser_1.Browser.Version >= 3 ? getAbsolutePositionY_FF3(element) : browser_1.Browser.Opera ? function getAbsolutePositionY_Opera(curEl) {
                        var isFirstCycle = !0;
                        curEl && DomUtils.isHTMLTableRowElement(curEl) && curEl.cells.length > 0 && (curEl = curEl.cells[0]);
                        for (var pos = getAbsoluteScrollOffset_OperaFF(curEl, !1); null != curEl; ) pos += curEl.offsetTop, 
                        isFirstCycle || (pos -= curEl.scrollTop), curEl = curEl.offsetParent, isFirstCycle = !1;
                        return pos += document.body.scrollTop;
                    }(element) : browser_1.Browser.NetscapeFamily && (!browser_1.Browser.Firefox || browser_1.Browser.Version < 3) ? function getAbsolutePositionY_NS(curEl) {
                        for (var pos = getAbsoluteScrollOffset_OperaFF(curEl, !1), isFirstCycle = !0; null != curEl; ) {
                            if (pos += curEl.offsetTop, isFirstCycle || null == curEl.offsetParent || (pos -= curEl.scrollTop), 
                            !isFirstCycle && browser_1.Browser.Firefox) {
                                var style = DomUtils.getCurrentStyle(curEl);
                                "DIV" === curEl.tagName && "visible" !== style.overflow && (pos += DomUtils.pxToInt(style.borderTopWidth));
                            }
                            isFirstCycle = !1, curEl = curEl.offsetParent;
                        }
                        return pos;
                    }(element) : browser_1.Browser.WebKitFamily || browser_1.Browser.Edge ? getAbsolutePositionY_FF3(element) : function getAbsolutePositionY_Other(curEl) {
                        for (var pos = 0, isFirstCycle = !0; null != curEl; ) pos += curEl.offsetTop, isFirstCycle || null == curEl.offsetParent || (pos -= curEl.scrollTop), 
                        isFirstCycle = !1, curEl = curEl.offsetParent;
                        return pos;
                    }(element) : 0;
                }, DomUtils.getAbsolutePositionX = function(element) {
                    function getAbsolutePositionX_FF3(element) {
                        return Math.round(element.getBoundingClientRect().left + DomUtils.getDocumentScrollLeft());
                    }
                    return element ? browser_1.Browser.IE ? function getAbsolutePositionX_IE(element) {
                        return browser_1.Browser.IE && null === element.parentNode ? 0 : element.getBoundingClientRect().left + DomUtils.getDocumentScrollLeft();
                    }(element) : browser_1.Browser.Firefox && browser_1.Browser.Version >= 3 ? getAbsolutePositionX_FF3(element) : browser_1.Browser.Opera && browser_1.Browser.Version <= 12 ? function getAbsolutePositionX_Opera(curEl) {
                        for (var isFirstCycle = !0, pos = getAbsoluteScrollOffset_OperaFF(curEl, !0); null != curEl; ) pos += curEl.offsetLeft, 
                        isFirstCycle || (pos -= curEl.scrollLeft), curEl = curEl.offsetParent, isFirstCycle = !1;
                        return pos += document.body.scrollLeft;
                    }(element) : browser_1.Browser.NetscapeFamily && (!browser_1.Browser.Firefox || browser_1.Browser.Version < 3) ? function getAbsolutePositionX_NS(curEl) {
                        for (var pos = getAbsoluteScrollOffset_OperaFF(curEl, !0), isFirstCycle = !0; null != curEl; ) {
                            if (pos += curEl.offsetLeft, isFirstCycle || null == curEl.offsetParent || (pos -= curEl.scrollLeft), 
                            !isFirstCycle && browser_1.Browser.Firefox) {
                                var style = DomUtils.getCurrentStyle(curEl);
                                "DIV" === curEl.tagName && "visible" !== style.overflow && (pos += DomUtils.pxToInt(style.borderLeftWidth));
                            }
                            isFirstCycle = !1, curEl = curEl.offsetParent;
                        }
                        return pos;
                    }(element) : browser_1.Browser.WebKitFamily || browser_1.Browser.Edge ? getAbsolutePositionX_FF3(element) : function getAbsolutePositionX_Other(curEl) {
                        for (var pos = 0, isFirstCycle = !0; null != curEl; ) pos += curEl.offsetLeft, isFirstCycle || null == curEl.offsetParent || (pos -= curEl.scrollLeft), 
                        isFirstCycle = !1, curEl = curEl.offsetParent;
                        return pos;
                    }(element) : 0;
                }, DomUtils.isInteractiveControl = function(element) {
                    return [ "A", "INPUT", "SELECT", "OPTION", "TEXTAREA", "BUTTON", "IFRAME" ].indexOf(element.tagName) > -1;
                }, DomUtils.getClearClientHeight = function(element) {
                    return element.offsetHeight - (DomUtils.getTopBottomPaddings(element) + DomUtils.getVerticalBordersWidth(element));
                }, DomUtils.getTopBottomPaddings = function(element, style) {
                    var currentStyle = style || DomUtils.getCurrentStyle(element);
                    return DomUtils.pxToInt(currentStyle.paddingTop) + DomUtils.pxToInt(currentStyle.paddingBottom);
                }, DomUtils.getVerticalBordersWidth = function(element, style) {
                    common_1.isDefined(style) || (style = browser_1.Browser.IE && 9 !== browser_1.Browser.MajorVersion && window.getComputedStyle ? window.getComputedStyle(element) : DomUtils.getCurrentStyle(element));
                    var res = 0;
                    return "none" !== style.borderTopStyle && (res += DomUtils.pxToFloat(style.borderTopWidth)), 
                    "none" !== style.borderBottomStyle && (res += DomUtils.pxToFloat(style.borderBottomWidth)), 
                    res;
                }, DomUtils.getNodes = function(parent, predicate) {
                    for (var collection = parent.all || parent.getElementsByTagName("*"), result = [], i = 0; i < collection.length; i++) {
                        var element = collection[i];
                        predicate(element) && result.push(element);
                    }
                    return result;
                }, DomUtils.getChildNodes = function(parent, predicate) {
                    for (var collection = parent.childNodes, result = [], i = 0; i < collection.length; i++) {
                        var element = collection[i];
                        predicate(element) && result.push(element);
                    }
                    return result;
                }, DomUtils.getNodesByClassName = function(parent, className) {
                    if (parent.querySelectorAll) {
                        var children = parent.querySelectorAll("." + className), result_1 = [];
                        return children.forEach((function(element) {
                            return result_1.push(element);
                        })), result_1;
                    }
                    return DomUtils.getNodes(parent, (function(elem) {
                        return DomUtils.hasClassName(elem, className);
                    }));
                }, DomUtils.getChildNodesByClassName = function(parent, className) {
                    return parent.querySelectorAll ? function nodeListToArray(nodeList, filter) {
                        for (var result = [], i = 0; i < nodeList.length; i++) {
                            var element = nodeList[i];
                            filter(element) && result.push(element);
                        }
                        return result;
                    }(parent.querySelectorAll("." + className), (function(element) {
                        return element.parentNode === parent;
                    })) : DomUtils.getChildNodes(parent, (function(elem) {
                        return !!DomUtils.isElementNode(elem) && (common_1.isNonNullString(elem.className) && DomUtils.hasClassName(elem, elem.className));
                    }));
                }, DomUtils.getVerticalScrollBarWidth = function() {
                    if (void 0 === DomUtils.verticalScrollBarWidth) {
                        var container = document.createElement("DIV");
                        container.style.cssText = "position: absolute; top: 0px; left: 0px; visibility: hidden; width: 200px; height: 150px; overflow: hidden; box-sizing: content-box", 
                        document.body.appendChild(container);
                        var child = document.createElement("P");
                        container.appendChild(child), child.style.cssText = "width: 100%; height: 200px;";
                        var widthWithoutScrollBar = child.offsetWidth;
                        container.style.overflow = "scroll";
                        var widthWithScrollBar = child.offsetWidth;
                        widthWithoutScrollBar === widthWithScrollBar && (widthWithScrollBar = container.clientWidth), 
                        DomUtils.verticalScrollBarWidth = widthWithoutScrollBar - widthWithScrollBar, document.body.removeChild(container);
                    }
                    return DomUtils.verticalScrollBarWidth;
                }, DomUtils.getHorizontalBordersWidth = function(element, style) {
                    common_1.isDefined(style) || (style = browser_1.Browser.IE && window.getComputedStyle ? window.getComputedStyle(element) : DomUtils.getCurrentStyle(element));
                    var res = 0;
                    return "none" !== style.borderLeftStyle && (res += DomUtils.pxToFloat(style.borderLeftWidth)), 
                    "none" !== style.borderRightStyle && (res += DomUtils.pxToFloat(style.borderRightWidth)), 
                    res;
                }, DomUtils.getFontFamiliesFromCssString = function(cssString) {
                    return cssString.split(",").map((function(fam) {
                        return string_1.StringUtils.trim(fam.replace(/'|"/gi, ""));
                    }));
                }, DomUtils.getInnerText = function(container) {
                    if (browser_1.Browser.Safari && browser_1.Browser.MajorVersion <= 5) {
                        null === DomUtils.html2PlainTextFilter && (DomUtils.html2PlainTextFilter = document.createElement("DIV"), 
                        DomUtils.html2PlainTextFilter.style.width = "0", DomUtils.html2PlainTextFilter.style.height = "0", 
                        DomUtils.html2PlainTextFilter.style.overflow = "visible", DomUtils.html2PlainTextFilter.style.display = "none", 
                        document.body.appendChild(DomUtils.html2PlainTextFilter));
                        var filter = DomUtils.html2PlainTextFilter;
                        filter.innerHTML = container.innerHTML, filter.style.display = "";
                        var innerText = filter.innerText;
                        return filter.style.display = "none", innerText;
                    }
                    return browser_1.Browser.NetscapeFamily || browser_1.Browser.WebKitFamily || browser_1.Browser.IE && browser_1.Browser.Version >= 9 || browser_1.Browser.Edge ? container.textContent : container.innerText;
                }, DomUtils.html2PlainTextFilter = null, DomUtils.verticalScrollBarWidth = void 0, 
                DomUtils;
            }();
            function pxToNumber(px, parseFunction) {
                var result = 0;
                if (common_1.isDefined(px) && "" !== px) try {
                    var indexOfPx = px.indexOf("px");
                    indexOfPx > -1 && (result = parseFunction(px.substr(0, indexOfPx)));
                } catch (e) {}
                return result;
            }
            function getAbsoluteScrollOffset_OperaFF(curEl, isX) {
                for (var pos = 0, isFirstCycle = !0; null != curEl && "BODY" !== curEl.tagName; ) {
                    var style = DomUtils.getCurrentStyle(curEl);
                    if ("absolute" === style.position) break;
                    isFirstCycle || "DIV" !== curEl.tagName || "" !== style.position && "static" !== style.position || (pos -= isX ? curEl.scrollLeft : curEl.scrollTop), 
                    curEl = curEl.parentNode, isFirstCycle = !1;
                }
                return pos;
            }
            exports.DomUtils = DomUtils;
        },
        9712: function(__unused_webpack_module, exports) {
            "use strict";
            Object.defineProperty(exports, "__esModule", {
                value: !0
            }), exports.EncodeUtils = void 0;
            var EncodeUtils = function() {
                function EncodeUtils() {}
                return EncodeUtils.encodeHtml = function(text) {
                    return text.replace(/&/g, "&amp;").replace(/</g, "&lt;").replace(/>/g, "&gt;");
                }, EncodeUtils.decodeHtml = function(text) {
                    return text.replace(/&amp;/g, "&").replace(/&lt;/g, "<").replace(/&gt;/g, ">");
                }, EncodeUtils.prepareTextForRequest = function(text) {
                    return text.replace(/%/g, "%25").replace(/&/g, "%26amp;").replace(/\+/g, "%2B").replace(/</g, "%26lt;").replace(/>/g, "%26gt;").replace(/"/g, "%26quot;");
                }, EncodeUtils.prepareTextForCallBackRequest = function(text) {
                    return text.replace(/&/g, "&amp;").replace(/</g, "&lt;").replace(/>/g, "&gt;").replace(/"/g, "&quot;");
                }, EncodeUtils.decodeViaTextArea = function(html) {
                    var textArea = document.createElement("TEXTAREA");
                    return textArea.innerHTML = html, textArea.value;
                }, EncodeUtils;
            }();
            exports.EncodeUtils = EncodeUtils;
        },
        310: function(__unused_webpack_module, exports) {
            "use strict";
            exports.Y = void 0;
            var EnumUtils = function() {
                function EnumUtils() {}
                return EnumUtils.forEach = function(enumObject, callback) {
                    for (var key in enumObject) if (Object.prototype.hasOwnProperty.call(enumObject, key)) {
                        var keyNum = parseInt(key);
                        isNaN(keyNum) || callback(keyNum);
                    }
                }, EnumUtils.isAnyOf = function(value) {
                    for (var params = [], _i = 1; _i < arguments.length; _i++) params[_i - 1] = arguments[_i];
                    for (var _a = 0, params_1 = params; _a < params_1.length; _a++) {
                        if (value === params_1[_a]) return !0;
                    }
                    return !1;
                }, EnumUtils;
            }();
            exports.Y = EnumUtils;
        },
        3714: function(__unused_webpack_module, exports, __webpack_require__) {
            "use strict";
            exports.g = void 0;
            var browser_1 = __webpack_require__(9279), common_1 = __webpack_require__(2491), dom_1 = __webpack_require__(6907), touch_1 = __webpack_require__(1632), EvtUtils = function() {
                function EvtUtils() {}
                return EvtUtils.preventEvent = function(evt) {
                    evt.cancelable && (evt.preventDefault ? evt.preventDefault() : evt.returnValue = !1);
                }, EvtUtils.getEventSource = function(evt) {
                    return common_1.isDefined(evt) ? EvtUtils.getEventSourceCore(evt) : null;
                }, EvtUtils.getEventSourceByPosition = function(evt) {
                    if (!common_1.isDefined(evt)) return null;
                    if (!document.elementFromPoint) return EvtUtils.getEventSourceCore(evt);
                    var clientX = EvtUtils.getEventX(evt) - (EvtUtils.clientEventRequiresDocScrollCorrection() ? dom_1.DomUtils.getDocumentScrollLeft() : 0), clientY = EvtUtils.getEventY(evt) - (EvtUtils.clientEventRequiresDocScrollCorrection() ? dom_1.DomUtils.getDocumentScrollTop() : 0);
                    return void 0 === clientX || void 0 === clientY ? EvtUtils.getEventSourceCore(evt) : document.elementFromPoint(clientX, clientY);
                }, EvtUtils.getEventSourceCore = function(evt) {
                    return evt.srcElement ? evt.srcElement : evt.target;
                }, EvtUtils.getMouseWheelEventName = function() {
                    return browser_1.Browser.Safari ? "mousewheel" : browser_1.Browser.NetscapeFamily && browser_1.Browser.MajorVersion < 17 ? "DOMMouseScroll" : "wheel";
                }, EvtUtils.isLeftButtonPressed = function(evt) {
                    return !!touch_1.TouchUtils.isTouchEvent(evt) || !!(evt = browser_1.Browser.IE && common_1.isDefined(event) ? event : evt) && (browser_1.Browser.IE && browser_1.Browser.Version < 11 ? !!browser_1.Browser.MSTouchUI || evt.button % 2 == 1 : browser_1.Browser.WebKitFamily ? "pointermove" === evt.type || "pointerenter" === evt.type || "pointerleave" === evt.type ? 1 === evt.buttons : 1 === evt.which : browser_1.Browser.NetscapeFamily || browser_1.Browser.Edge || browser_1.Browser.IE && browser_1.Browser.Version >= 11 ? EvtUtils.isMoveEventName(evt.type) ? 1 === evt.buttons : 1 === evt.which : !browser_1.Browser.Opera || 0 === evt.button);
                }, EvtUtils.isMoveEventName = function(type) {
                    return type === touch_1.TouchUtils.touchMouseMoveEventName || type === EvtUtils.getMoveEventName();
                }, EvtUtils.getMoveEventName = function() {
                    return window.PointerEvent ? "pointermove" : browser_1.Browser.TouchUI ? "touchmove" : "mousemove";
                }, EvtUtils.preventEventAndBubble = function(evt) {
                    EvtUtils.preventEvent(evt), evt.stopPropagation && evt.stopPropagation(), evt.cancelBubble = !0;
                }, EvtUtils.clientEventRequiresDocScrollCorrection = function() {
                    var isSafariVerLess3 = browser_1.Browser.Safari && browser_1.Browser.Version < 3, isMacOSMobileVerLess51 = browser_1.Browser.MacOSMobilePlatform && browser_1.Browser.Version < 5.1;
                    return browser_1.Browser.AndroidDefaultBrowser || browser_1.Browser.AndroidChromeBrowser || !(isSafariVerLess3 || isMacOSMobileVerLess51);
                }, EvtUtils.getEventX = function(evt) {
                    return touch_1.TouchUtils.isTouchEvent(evt) ? touch_1.TouchUtils.getEventX(evt) : evt.clientX + (EvtUtils.clientEventRequiresDocScrollCorrection() ? dom_1.DomUtils.getDocumentScrollLeft() : 0);
                }, EvtUtils.getEventY = function(evt) {
                    return touch_1.TouchUtils.isTouchEvent(evt) ? touch_1.TouchUtils.getEventY(evt) : evt.clientY + (EvtUtils.clientEventRequiresDocScrollCorrection() ? dom_1.DomUtils.getDocumentScrollTop() : 0);
                }, EvtUtils.cancelBubble = function(evt) {
                    evt.cancelBubble = !0;
                }, EvtUtils.getWheelDelta = function(evt) {
                    var ret;
                    return ret = browser_1.Browser.NetscapeFamily && browser_1.Browser.MajorVersion < 17 ? -evt.detail : browser_1.Browser.Safari ? evt.wheelDelta : -evt.deltaY, 
                    browser_1.Browser.Opera && browser_1.Browser.Version < 9 && (ret = -ret), ret;
                }, EvtUtils;
            }();
            exports.g = EvtUtils;
        },
        2674: function(__unused_webpack_module, exports, __webpack_require__) {
            "use strict";
            Object.defineProperty(exports, "__esModule", {
                value: !0
            }), exports.FileUtils = void 0;
            var browser_1 = __webpack_require__(9279), base64_1 = __webpack_require__(6477), common_1 = __webpack_require__(2491), FileUtils = function() {
                function FileUtils() {}
                return FileUtils.loadJavascriptFile = function(srcUri, callback) {
                    var _a, headElem = document.getElementsByTagName("head")[0];
                    if (!headElem) {
                        headElem = document.createElement("head");
                        var bodyElem = document.getElementsByTagName("body")[0];
                        null === (_a = bodyElem.parentNode) || void 0 === _a || _a.insertBefore(headElem, bodyElem);
                    }
                    var scriptElem = document.createElement("script");
                    return scriptElem.onload = callback, scriptElem.src = srcUri, headElem.appendChild(scriptElem), 
                    {
                        htmlScriptElement: scriptElem
                    };
                }, FileUtils.startDownloadFileLocal = function(content, fileName) {
                    if (content instanceof ArrayBuffer && (content = base64_1.Base64Utils.fromArrayBuffer(content)), 
                    common_1.isString(content) && (content = base64_1.Base64Utils.getFileFromBase64(content)), 
                    window.navigator.msSaveOrOpenBlob) window.navigator.msSaveOrOpenBlob(content, fileName); else {
                        var a_1 = document.createElement("a"), url_1 = URL.createObjectURL(content);
                        a_1.href = url_1, a_1.download = fileName, document.body.appendChild(a_1), a_1.click(), 
                        setTimeout((function() {
                            document.body.removeChild(a_1), window.URL.revokeObjectURL(url_1);
                        }), 0);
                    }
                }, FileUtils.createFile = function(fileBits, fileName, options) {
                    var _a;
                    if (browser_1.Browser.IE || browser_1.Browser.Edge && browser_1.Browser.MajorVersion < 86) {
                        var blob = new Blob(fileBits, options);
                        return blob.lastModifiedDate = null !== (_a = null == options ? void 0 : options.lastModified) && void 0 !== _a ? _a : Date.now(), 
                        blob.name = fileName, blob;
                    }
                    return new File(fileBits, fileName, options);
                }, FileUtils.isFile = function(file) {
                    return browser_1.Browser.IE || browser_1.Browser.Edge && browser_1.Browser.MajorVersion < 86 ? file instanceof File || file instanceof Blob && common_1.isDefined(file.name) : file instanceof File;
                }, FileUtils;
            }();
            exports.FileUtils = FileUtils;
        },
        4004: function(__unused_webpack_module, exports) {
            "use strict";
            function addFontToDocument(loadedFace) {
                document.fonts.add(loadedFace);
            }
            exports.mx = exports.mw = exports.lX = void 0, exports.lX = function fontWebApiAvailable() {
                return document.fonts && document.fonts.ready && document.fonts.ready.then;
            }, exports.mw = function afterFontsLoaded(callback) {
                document.fonts.ready.then(callback);
            }, exports.mx = function loadFont(fontFamily, source, fontFaceDescriptors, callback) {
                new window.FontFace(fontFamily, source, fontFaceDescriptors).load().then((function(loadedFace) {
                    addFontToDocument(loadedFace), callback(null);
                })).catch((function(error) {
                    return callback(error);
                }));
            };
        },
        2153: function(__unused_webpack_module, exports, __webpack_require__) {
            "use strict";
            exports.VD = exports.tx = exports.LN = void 0;
            var ModifierKey, KeyCode, browser_1 = __webpack_require__(9279), encode_1 = __webpack_require__(9712), string_1 = __webpack_require__(49), KeyUtils = function() {
                function KeyUtils() {}
                return KeyUtils.getKeyModifiers = function(evt) {
                    var result = 0;
                    return evt.altKey && (result |= ModifierKey.Alt), evt.ctrlKey && (result |= ModifierKey.Ctrl), 
                    evt.shiftKey && (result |= ModifierKey.Shift), evt.metaKey && (result |= ModifierKey.Meta), 
                    result;
                }, KeyUtils.getShortcutCode = function(keyCode, isCtrlKey, isShiftKey, isAltKey, isMetaKey) {
                    var value = keyCode;
                    return value |= isCtrlKey ? ModifierKey.Ctrl : 0, value |= isShiftKey ? ModifierKey.Shift : 0, 
                    value |= isAltKey ? ModifierKey.Alt : 0, value |= isMetaKey ? ModifierKey.Meta : 0;
                }, KeyUtils.getShortcutCodeByEvent = function(evt) {
                    return KeyUtils.getShortcutCode(KeyUtils.getEventKeyCode(evt), evt.ctrlKey, evt.shiftKey, evt.altKey, !!browser_1.Browser.MacOSPlatform && evt.metaKey);
                }, KeyUtils.getEventKeyCode = function(evt) {
                    return browser_1.Browser.NetscapeFamily || browser_1.Browser.Opera ? evt.which : evt.keyCode;
                }, KeyUtils.parseShortcutString = function(shortcutString) {
                    if (!shortcutString) return 0;
                    var isCtrlKey = !1, isShiftKey = !1, isAltKey = !1, isMetaKey = !1, keyCode = null, shcKeys = shortcutString.toString().split("+");
                    if (shcKeys.length > 0) for (var i = 0; i < shcKeys.length; i++) {
                        var key = string_1.StringUtils.trim(shcKeys[i].toUpperCase());
                        switch (key) {
                          case "CONTROL":
                          case "CONTROLKEY":
                          case "CTRL":
                            isCtrlKey = !0;
                            break;

                          case "SHIFT":
                          case "SHIFTKEY":
                            isShiftKey = !0;
                            break;

                          case "ALT":
                            isAltKey = !0;
                            break;

                          case "CMD":
                            isMetaKey = !0;
                            break;

                          case "F1":
                            keyCode = KeyCode.F1;
                            break;

                          case "F2":
                            keyCode = KeyCode.F2;
                            break;

                          case "F3":
                            keyCode = KeyCode.F3;
                            break;

                          case "F4":
                            keyCode = KeyCode.F4;
                            break;

                          case "F5":
                            keyCode = KeyCode.F5;
                            break;

                          case "F6":
                            keyCode = KeyCode.F6;
                            break;

                          case "F7":
                            keyCode = KeyCode.F7;
                            break;

                          case "F8":
                            keyCode = KeyCode.F8;
                            break;

                          case "F9":
                            keyCode = KeyCode.F9;
                            break;

                          case "F10":
                            keyCode = KeyCode.F10;
                            break;

                          case "F11":
                            keyCode = KeyCode.F11;
                            break;

                          case "F12":
                            keyCode = KeyCode.F12;
                            break;

                          case "RETURN":
                          case "ENTER":
                            keyCode = KeyCode.Enter;
                            break;

                          case "HOME":
                            keyCode = KeyCode.Home;
                            break;

                          case "END":
                            keyCode = KeyCode.End;
                            break;

                          case "LEFT":
                            keyCode = KeyCode.Left;
                            break;

                          case "RIGHT":
                            keyCode = KeyCode.Right;
                            break;

                          case "UP":
                            keyCode = KeyCode.Up;
                            break;

                          case "DOWN":
                            keyCode = KeyCode.Down;
                            break;

                          case "PAGEUP":
                            keyCode = KeyCode.PageUp;
                            break;

                          case "PAGEDOWN":
                            keyCode = KeyCode.PageDown;
                            break;

                          case "SPACE":
                            keyCode = KeyCode.Space;
                            break;

                          case "TAB":
                            keyCode = KeyCode.Tab;
                            break;

                          case "BACKSPACE":
                          case "BACK":
                            keyCode = KeyCode.Backspace;
                            break;

                          case "CONTEXT":
                            keyCode = KeyCode.ContextMenu;
                            break;

                          case "ESCAPE":
                          case "ESC":
                            keyCode = KeyCode.Esc;
                            break;

                          case "DELETE":
                          case "DEL":
                            keyCode = KeyCode.Delete;
                            break;

                          case "INSERT":
                          case "INS":
                            keyCode = KeyCode.Insert;
                            break;

                          case "PLUS":
                            keyCode = "+".charCodeAt(0);
                            break;

                          default:
                            keyCode = key.charCodeAt(0);
                        }
                    } else alert(encode_1.EncodeUtils.decodeViaTextArea("Invalid shortcut"));
                    return KeyUtils.getShortcutCode(keyCode, isCtrlKey, isShiftKey, isAltKey, isMetaKey);
                }, KeyUtils;
            }();
            exports.LN = KeyUtils, function(ModifierKey) {
                ModifierKey[ModifierKey.None = 0] = "None", ModifierKey[ModifierKey.Ctrl = 65536] = "Ctrl", 
                ModifierKey[ModifierKey.Shift = 262144] = "Shift", ModifierKey[ModifierKey.Alt = 1048576] = "Alt", 
                ModifierKey[ModifierKey.Meta = 16777216] = "Meta";
            }(ModifierKey = exports.tx || (exports.tx = {})), function(KeyCode) {
                KeyCode[KeyCode.Backspace = 8] = "Backspace", KeyCode[KeyCode.Tab = 9] = "Tab", 
                KeyCode[KeyCode.Enter = 13] = "Enter", KeyCode[KeyCode.Pause = 19] = "Pause", KeyCode[KeyCode.CapsLock = 20] = "CapsLock", 
                KeyCode[KeyCode.Esc = 27] = "Esc", KeyCode[KeyCode.Space = 32] = "Space", KeyCode[KeyCode.PageUp = 33] = "PageUp", 
                KeyCode[KeyCode.PageDown = 34] = "PageDown", KeyCode[KeyCode.End = 35] = "End", 
                KeyCode[KeyCode.Home = 36] = "Home", KeyCode[KeyCode.Left = 37] = "Left", KeyCode[KeyCode.Up = 38] = "Up", 
                KeyCode[KeyCode.Right = 39] = "Right", KeyCode[KeyCode.Down = 40] = "Down", KeyCode[KeyCode.Insert = 45] = "Insert", 
                KeyCode[KeyCode.Delete = 46] = "Delete", KeyCode[KeyCode.Key_0 = 48] = "Key_0", 
                KeyCode[KeyCode.Key_1 = 49] = "Key_1", KeyCode[KeyCode.Key_2 = 50] = "Key_2", KeyCode[KeyCode.Key_3 = 51] = "Key_3", 
                KeyCode[KeyCode.Key_4 = 52] = "Key_4", KeyCode[KeyCode.Key_5 = 53] = "Key_5", KeyCode[KeyCode.Key_6 = 54] = "Key_6", 
                KeyCode[KeyCode.Key_7 = 55] = "Key_7", KeyCode[KeyCode.Key_8 = 56] = "Key_8", KeyCode[KeyCode.Key_9 = 57] = "Key_9", 
                KeyCode[KeyCode.Key_a = 65] = "Key_a", KeyCode[KeyCode.Key_b = 66] = "Key_b", KeyCode[KeyCode.Key_c = 67] = "Key_c", 
                KeyCode[KeyCode.Key_d = 68] = "Key_d", KeyCode[KeyCode.Key_e = 69] = "Key_e", KeyCode[KeyCode.Key_f = 70] = "Key_f", 
                KeyCode[KeyCode.Key_g = 71] = "Key_g", KeyCode[KeyCode.Key_h = 72] = "Key_h", KeyCode[KeyCode.Key_i = 73] = "Key_i", 
                KeyCode[KeyCode.Key_j = 74] = "Key_j", KeyCode[KeyCode.Key_k = 75] = "Key_k", KeyCode[KeyCode.Key_l = 76] = "Key_l", 
                KeyCode[KeyCode.Key_m = 77] = "Key_m", KeyCode[KeyCode.Key_n = 78] = "Key_n", KeyCode[KeyCode.Key_o = 79] = "Key_o", 
                KeyCode[KeyCode.Key_p = 80] = "Key_p", KeyCode[KeyCode.Key_q = 81] = "Key_q", KeyCode[KeyCode.Key_r = 82] = "Key_r", 
                KeyCode[KeyCode.Key_s = 83] = "Key_s", KeyCode[KeyCode.Key_t = 84] = "Key_t", KeyCode[KeyCode.Key_u = 85] = "Key_u", 
                KeyCode[KeyCode.Key_v = 86] = "Key_v", KeyCode[KeyCode.Key_w = 87] = "Key_w", KeyCode[KeyCode.Key_x = 88] = "Key_x", 
                KeyCode[KeyCode.Key_y = 89] = "Key_y", KeyCode[KeyCode.Key_z = 90] = "Key_z", KeyCode[KeyCode.Windows = 91] = "Windows", 
                KeyCode[KeyCode.ContextMenu = 93] = "ContextMenu", KeyCode[KeyCode.Numpad_0 = 96] = "Numpad_0", 
                KeyCode[KeyCode.Numpad_1 = 97] = "Numpad_1", KeyCode[KeyCode.Numpad_2 = 98] = "Numpad_2", 
                KeyCode[KeyCode.Numpad_3 = 99] = "Numpad_3", KeyCode[KeyCode.Numpad_4 = 100] = "Numpad_4", 
                KeyCode[KeyCode.Numpad_5 = 101] = "Numpad_5", KeyCode[KeyCode.Numpad_6 = 102] = "Numpad_6", 
                KeyCode[KeyCode.Numpad_7 = 103] = "Numpad_7", KeyCode[KeyCode.Numpad_8 = 104] = "Numpad_8", 
                KeyCode[KeyCode.Numpad_9 = 105] = "Numpad_9", KeyCode[KeyCode.Multiply = 106] = "Multiply", 
                KeyCode[KeyCode.Add = 107] = "Add", KeyCode[KeyCode.Subtract = 109] = "Subtract", 
                KeyCode[KeyCode.Decimal = 110] = "Decimal", KeyCode[KeyCode.Divide = 111] = "Divide", 
                KeyCode[KeyCode.F1 = 112] = "F1", KeyCode[KeyCode.F2 = 113] = "F2", KeyCode[KeyCode.F3 = 114] = "F3", 
                KeyCode[KeyCode.F4 = 115] = "F4", KeyCode[KeyCode.F5 = 116] = "F5", KeyCode[KeyCode.F6 = 117] = "F6", 
                KeyCode[KeyCode.F7 = 118] = "F7", KeyCode[KeyCode.F8 = 119] = "F8", KeyCode[KeyCode.F9 = 120] = "F9", 
                KeyCode[KeyCode.F10 = 121] = "F10", KeyCode[KeyCode.F11 = 122] = "F11", KeyCode[KeyCode.F12 = 123] = "F12", 
                KeyCode[KeyCode.NumLock = 144] = "NumLock", KeyCode[KeyCode.ScrollLock = 145] = "ScrollLock", 
                KeyCode[KeyCode.Semicolon = 186] = "Semicolon", KeyCode[KeyCode.Equals = 187] = "Equals", 
                KeyCode[KeyCode.Comma = 188] = "Comma", KeyCode[KeyCode.Dash = 189] = "Dash", KeyCode[KeyCode.Period = 190] = "Period", 
                KeyCode[KeyCode.ForwardSlash = 191] = "ForwardSlash", KeyCode[KeyCode.GraveAccent = 192] = "GraveAccent", 
                KeyCode[KeyCode.OpenBracket = 219] = "OpenBracket", KeyCode[KeyCode.BackSlash = 220] = "BackSlash", 
                KeyCode[KeyCode.CloseBracket = 221] = "CloseBracket", KeyCode[KeyCode.SingleQuote = 222] = "SingleQuote";
            }(KeyCode = exports.VD || (exports.VD = {}));
        },
        2940: function(__unused_webpack_module, exports, __webpack_require__) {
            "use strict";
            Object.defineProperty(exports, "__esModule", {
                value: !0
            }), exports.ListUtils = void 0;
            var min_max_1 = __webpack_require__(6799), comparers_1 = __webpack_require__(4170), ListUtils = function() {
                function ListUtils() {}
                return ListUtils.remove = function(list, element) {
                    var index = list.indexOf(element, 0);
                    index >= 0 && list.splice(index, 1);
                }, ListUtils.removeBy = function(list, callback) {
                    for (var len = list.length, index = 0; index < len; index++) if (callback(list[index], index)) return list.splice(index, 1)[0];
                    return null;
                }, ListUtils.shallowCopy = function(list) {
                    return list.slice();
                }, ListUtils.deepCopy = function(list) {
                    return ListUtils.map(list, (function(val) {
                        return val.clone();
                    }));
                }, ListUtils.initByValue = function(numElements, initValue) {
                    for (var result = []; numElements > 0; numElements--) result.push(initValue);
                    return result;
                }, ListUtils.initByCallback = function(numElements, initCallback) {
                    for (var result = [], index = 0; index < numElements; index++) result.push(initCallback(index));
                    return result;
                }, ListUtils.forEachOnInterval = function(interval, callback) {
                    for (var end = interval.end, index = interval.start; index < end; index++) callback(index);
                }, ListUtils.reverseForEachOnInterval = function(interval, callback) {
                    for (var start = interval.start, index = interval.end - 1; index >= start; index--) callback(index);
                }, ListUtils.reducedMap = function(list, callback, startIndex, endIndex) {
                    void 0 === startIndex && (startIndex = 0), void 0 === endIndex && (endIndex = list.length);
                    for (var result = [], index = startIndex; index < endIndex; index++) {
                        var newItem = callback(list[index], index);
                        null !== newItem && result.push(newItem);
                    }
                    return result;
                }, ListUtils.filter = function(list, callback, startIndex, endIndex) {
                    void 0 === startIndex && (startIndex = 0), void 0 === endIndex && (endIndex = list.length);
                    for (var result = [], index = startIndex; index < endIndex; index++) {
                        var item = list[index];
                        callback(item, index) && result.push(item);
                    }
                    return result;
                }, ListUtils.map = function(list, callback, startIndex, endIndex) {
                    void 0 === startIndex && (startIndex = 0), void 0 === endIndex && (endIndex = list.length);
                    for (var result = [], index = startIndex; index < endIndex; index++) result.push(callback(list[index], index));
                    return result;
                }, ListUtils.indexBy = function(list, callback, startIndex, endIndex) {
                    void 0 === startIndex && (startIndex = 0), void 0 === endIndex && (endIndex = list.length);
                    for (var ind = startIndex; ind < endIndex; ind++) if (callback(list[ind], ind)) return ind;
                    return -1;
                }, ListUtils.reverseIndexBy = function(list, callback, startIndex, endIndex) {
                    void 0 === startIndex && (startIndex = list.length - 1), void 0 === endIndex && (endIndex = 0);
                    for (var ind = startIndex; ind >= endIndex; ind--) if (callback(list[ind], ind)) return ind;
                    return -1;
                }, ListUtils.elementBy = function(list, callback, startIndex, endIndex) {
                    void 0 === startIndex && (startIndex = 0), void 0 === endIndex && (endIndex = list.length);
                    var ind = ListUtils.indexBy(list, callback, startIndex, endIndex);
                    return ind < 0 ? null : list[ind];
                }, ListUtils.reverseElementBy = function(list, callback, startIndex, endIndex) {
                    void 0 === startIndex && (startIndex = list.length - 1), void 0 === endIndex && (endIndex = 0);
                    var ind = ListUtils.reverseIndexBy(list, callback, startIndex, endIndex);
                    return ind < 0 ? null : list[ind];
                }, ListUtils.last = function(list) {
                    return list[list.length - 1];
                }, ListUtils.setLast = function(list, newVal) {
                    return list[list.length - 1] = newVal;
                }, ListUtils.incLast = function(list) {
                    return ++list[list.length - 1];
                }, ListUtils.decLast = function(list) {
                    return --list[list.length - 1];
                }, ListUtils.equals = function(a, b) {
                    return a.length === b.length && ListUtils.allOf2(a, b, (function(a, b) {
                        return a.equals(b);
                    }));
                }, ListUtils.equalsByReference = function(a, b) {
                    var aLen = a.length;
                    if (aLen !== a.length) return !1;
                    for (var i = 0; i < aLen; i++) if (a[i] !== b[i]) return !1;
                    return !0;
                }, ListUtils.unique = function(list, cmp, equal, finalizeObj) {
                    void 0 === equal && (equal = cmp), void 0 === finalizeObj && (finalizeObj = function() {});
                    var len = list.length;
                    if (0 === len) return [];
                    var prevValue = (list = list.sort(cmp))[0], result = ListUtils.reducedMap(list, (function(v) {
                        return 0 !== equal(prevValue, v) ? (prevValue = v, v) : (finalizeObj(v), null);
                    }), 1, len);
                    return result.unshift(list[0]), result;
                }, ListUtils.uniqueNumber = function(list) {
                    list = list.sort(comparers_1.Comparers.number);
                    for (var prevValue = Number.NaN, i = list.length - 1; i >= 0; i--) prevValue === list[i] ? list.splice(i, 1) : prevValue = list[i];
                    return list;
                }, ListUtils.forEach = function(list, callback, startIndex, endIndex) {
                    void 0 === startIndex && (startIndex = 0), void 0 === endIndex && (endIndex = list.length);
                    for (var index = startIndex; index < endIndex; index++) callback(list[index], index);
                }, ListUtils.forEach2 = function(listA, listB, callback, startIndex, endIndex) {
                    void 0 === startIndex && (startIndex = 0), void 0 === endIndex && (endIndex = listA.length);
                    for (var index = startIndex; index < endIndex; index++) callback(listA[index], listB[index], index);
                }, ListUtils.reverseForEach = function(list, callback, startIndex, endIndex) {
                    void 0 === startIndex && (startIndex = list.length - 1), void 0 === endIndex && (endIndex = 0);
                    for (var index = startIndex; index >= endIndex; index--) callback(list[index], index);
                }, ListUtils.reverseIndexOf = function(list, element, startIndex, endIndex) {
                    void 0 === startIndex && (startIndex = list.length - 1), void 0 === endIndex && (endIndex = 0);
                    for (var index = startIndex; index >= endIndex; index--) if (list[index] === element) return index;
                    return -1;
                }, ListUtils.accumulate = function(list, initAccValue, callback, startIndex, endIndex) {
                    void 0 === startIndex && (startIndex = 0), void 0 === endIndex && (endIndex = list.length);
                    for (var acc = initAccValue, ind = startIndex; ind < endIndex; ind++) acc = callback(acc, list[ind], ind);
                    return acc;
                }, ListUtils.accumulateNumber = function(list, callback, initAccValue, startIndex, endIndex) {
                    void 0 === initAccValue && (initAccValue = 0), void 0 === startIndex && (startIndex = 0), 
                    void 0 === endIndex && (endIndex = list.length);
                    for (var acc = initAccValue, ind = startIndex; ind < endIndex; ind++) acc += callback(list[ind], ind, acc);
                    return acc;
                }, ListUtils.anyOf = function(list, callback, startIndex, endIndex) {
                    void 0 === startIndex && (startIndex = 0), void 0 === endIndex && (endIndex = list.length);
                    for (var index = startIndex; index < endIndex; index++) if (callback(list[index], index)) return !0;
                    return !1;
                }, ListUtils.unsafeAnyOf = function(list, callback, startIndex, endIndex) {
                    void 0 === startIndex && (startIndex = 0), void 0 === endIndex && (endIndex = list.length);
                    for (var index = startIndex; index < endIndex; index++) {
                        var currResult = callback(list[index], index);
                        if (currResult) return currResult;
                    }
                    return null;
                }, ListUtils.reverseAnyOf = function(list, callback, startIndex, endIndex) {
                    void 0 === startIndex && (startIndex = list.length - 1), void 0 === endIndex && (endIndex = 0);
                    for (var index = startIndex; index >= endIndex; index--) if (callback(list[index], index)) return !0;
                    return !1;
                }, ListUtils.unsafeReverseAnyOf = function(list, callback, startIndex, endIndex) {
                    void 0 === startIndex && (startIndex = list.length - 1), void 0 === endIndex && (endIndex = 0);
                    for (var index = startIndex; index >= endIndex; index--) {
                        var currResult = callback(list[index], index);
                        if (currResult) return currResult;
                    }
                    return null;
                }, ListUtils.anyOf2 = function(listA, listB, callback, startIndex, endIndex) {
                    void 0 === startIndex && (startIndex = 0), void 0 === endIndex && (endIndex = listA.length);
                    for (var index = startIndex; index < endIndex; index++) if (callback(listA[index], listB[index], index)) return !0;
                    return !1;
                }, ListUtils.allOf = function(list, callback, startIndex, endIndex) {
                    void 0 === startIndex && (startIndex = 0), void 0 === endIndex && (endIndex = list.length);
                    for (var index = startIndex; index < endIndex; index++) if (!callback(list[index], index)) return !1;
                    return !0;
                }, ListUtils.allOf2 = function(listA, listB, callback, startIndex, endIndex) {
                    void 0 === startIndex && (startIndex = 0), void 0 === endIndex && (endIndex = listA.length);
                    for (var index = startIndex; index < endIndex; index++) if (!callback(listA[index], listB[index], index)) return !1;
                    return !0;
                }, ListUtils.allOfOnInterval = function(interval, callback) {
                    for (var endIndex = interval.end, index = interval.start; index < endIndex; index++) if (!callback(index)) return !1;
                    return !0;
                }, ListUtils.addListOnTail = function(resultList, addedList) {
                    for (var i = 0, elem = void 0; elem = addedList[i]; i++) resultList.push(elem);
                    return resultList;
                }, ListUtils.joinLists = function(converter) {
                    for (var lists = [], _i = 1; _i < arguments.length; _i++) lists[_i - 1] = arguments[_i];
                    return ListUtils.accumulate(lists, [], (function(accList, list) {
                        return ListUtils.addListOnTail(accList, converter(list)), accList;
                    }));
                }, ListUtils.push = function(list, element) {
                    return list.push(element), list;
                }, ListUtils.countIf = function(list, callback) {
                    return ListUtils.accumulateNumber(list, (function(elem, ind) {
                        return callback(elem, ind) ? 1 : 0;
                    }));
                }, ListUtils.clear = function(list) {
                    list.splice(0);
                }, ListUtils.merge = function(list, cmp, shouldMerge, merge, startIndex, endIndex) {
                    if (void 0 === startIndex && (startIndex = 0), void 0 === endIndex && (endIndex = list.length), 
                    list = list.slice(startIndex, endIndex), endIndex - startIndex < 2) return list;
                    for (var prevObj = (list = list.sort(cmp))[startIndex], result = [ prevObj ], ind = startIndex + 1; ind < endIndex; ind++) {
                        var obj = list[ind];
                        shouldMerge(prevObj, obj) ? merge(prevObj, obj) : (prevObj = obj, result.push(prevObj));
                    }
                    return result;
                }, ListUtils.min = function(list, getValue, startIndex, endIndex) {
                    void 0 === startIndex && (startIndex = 0), void 0 === endIndex && (endIndex = list.length);
                    var res = ListUtils.minExtended(list, getValue, startIndex, endIndex);
                    return res ? res.minElement : null;
                }, ListUtils.max = function(list, getValue, startIndex, endIndex) {
                    void 0 === startIndex && (startIndex = 0), void 0 === endIndex && (endIndex = list.length);
                    var res = ListUtils.maxExtended(list, getValue, startIndex, endIndex);
                    return res ? res.maxElement : null;
                }, ListUtils.minMax = function(list, getValue, startIndex, endIndex) {
                    void 0 === startIndex && (startIndex = 0), void 0 === endIndex && (endIndex = list.length);
                    var res = ListUtils.minMaxExtended(list, getValue, startIndex, endIndex);
                    return res ? new min_max_1.MinMax(res.minElement, res.maxElement) : null;
                }, ListUtils.minExtended = function(list, getValue, startIndex, endIndex) {
                    if (void 0 === startIndex && (startIndex = 0), void 0 === endIndex && (endIndex = list.length), 
                    0 === list.length) return null;
                    for (var minElement = list[startIndex], minValue = getValue(minElement), index = startIndex + 1; index < endIndex; index++) {
                        var elem = list[index], elemValue = getValue(elem);
                        elemValue < minValue && (minValue = elemValue, minElement = elem);
                    }
                    return new min_max_1.ExtendedMin(minElement, minValue);
                }, ListUtils.maxExtended = function(list, getValue, startIndex, endIndex) {
                    if (void 0 === startIndex && (startIndex = 0), void 0 === endIndex && (endIndex = list.length), 
                    0 === list.length) return null;
                    for (var maxElement = list[startIndex], maxValue = getValue(maxElement), index = startIndex + 1; index < endIndex; index++) {
                        var elem = list[index], elemValue = getValue(elem);
                        elemValue > maxValue && (maxValue = elemValue, maxElement = elem);
                    }
                    return new min_max_1.ExtendedMax(maxElement, maxValue);
                }, ListUtils.minMaxExtended = function(list, getValue, startIndex, endIndex) {
                    if (void 0 === startIndex && (startIndex = 0), void 0 === endIndex && (endIndex = list.length), 
                    0 === list.length) return null;
                    for (var minElement = list[startIndex], maxElement = minElement, minValue = getValue(minElement), maxValue = minValue, index = startIndex + 1; index < endIndex; index++) {
                        var elem = list[index], elemValue = getValue(elem);
                        elemValue < minValue ? (minValue = elemValue, minElement = elem) : elemValue > maxValue && (maxValue = elemValue, 
                        maxElement = elem);
                    }
                    return new min_max_1.ExtendedMinMax(minElement, minValue, maxElement, maxValue);
                }, ListUtils.minByCmp = function(list, cmp, startIndex, endIndex) {
                    if (void 0 === startIndex && (startIndex = 0), void 0 === endIndex && (endIndex = list.length), 
                    0 === list.length) return null;
                    for (var found = list[startIndex], index = startIndex + 1; index < endIndex; index++) {
                        var elem = list[index];
                        cmp(elem, found) < 0 && (found = elem);
                    }
                    return found;
                }, ListUtils.maxByCmp = function(list, cmp, startIndex, endIndex) {
                    if (void 0 === startIndex && (startIndex = 0), void 0 === endIndex && (endIndex = list.length), 
                    0 === list.length) return null;
                    for (var found = list[startIndex], index = startIndex + 1; index < endIndex; index++) {
                        var elem = list[index];
                        cmp(elem, found) > 0 && (found = elem);
                    }
                    return found;
                }, ListUtils.minMaxByCmp = function(list, cmp, startIndex, endIndex) {
                    if (void 0 === startIndex && (startIndex = 0), void 0 === endIndex && (endIndex = list.length), 
                    0 === list.length) return null;
                    for (var min = list[startIndex], max = min, index = startIndex + 1; index < endIndex; index++) {
                        var elem = list[index], res = cmp(elem, min);
                        res > 0 ? max = elem : res < 0 && (min = elem);
                    }
                    return new min_max_1.MinMax(min, max);
                }, ListUtils;
            }();
            exports.ListUtils = ListUtils;
        },
        1167: function(__unused_webpack_module, exports, __webpack_require__) {
            "use strict";
            exports.j = void 0;
            var constants_1 = __webpack_require__(8785), min_max_1 = __webpack_require__(6799), NumberMapUtils = function() {
                function NumberMapUtils() {}
                return NumberMapUtils.forEach = function(map, callback) {
                    for (var key in map) Object.prototype.hasOwnProperty.call(map, key) && callback(map[key], parseInt(key));
                }, NumberMapUtils.map = function(map, callback) {
                    var result = {};
                    for (var key in map) Object.prototype.hasOwnProperty.call(map, key) && (result[key] = callback(map[key], parseInt(key)));
                    return result;
                }, NumberMapUtils.reducedMap = function(map, callback) {
                    var result = {};
                    for (var key in map) if (Object.prototype.hasOwnProperty.call(map, key)) {
                        var newItem = callback(map[key], parseInt(key));
                        null !== newItem && (result[key] = newItem);
                    }
                    return result;
                }, NumberMapUtils.clear = function(map) {
                    for (var key in map) Object.prototype.hasOwnProperty.call(map, key) && delete map[key];
                }, NumberMapUtils.shallowCopy = function(map) {
                    return NumberMapUtils.map(map, (function(val) {
                        return val;
                    }));
                }, NumberMapUtils.deepCopy = function(map) {
                    return NumberMapUtils.map(map, (function(val) {
                        return val.clone();
                    }));
                }, NumberMapUtils.isEmpty = function(map) {
                    for (var key in map) if (Object.prototype.hasOwnProperty.call(map, key)) return !1;
                    return !0;
                }, NumberMapUtils.accumulate = function(map, initAccValue, callback) {
                    var acc = initAccValue;
                    for (var key in map) Object.prototype.hasOwnProperty.call(map, key) && (acc = callback(acc, map[key], parseInt(key)));
                    return acc;
                }, NumberMapUtils.keyBy = function(map, callback) {
                    for (var key in map) if (Object.prototype.hasOwnProperty.call(map, key)) {
                        var intKey = parseInt(key);
                        if (callback(map[key], intKey)) return intKey;
                    }
                    return null;
                }, NumberMapUtils.elementBy = function(map, callback) {
                    var key = NumberMapUtils.keyBy(map, callback);
                    return null === key ? null : map[key];
                }, NumberMapUtils.containsBy = function(map, callback) {
                    return null !== NumberMapUtils.keyBy(map, callback);
                }, NumberMapUtils.toList = function(map) {
                    return NumberMapUtils.toListBy(map, (function(elem) {
                        return elem;
                    }));
                }, NumberMapUtils.toListBy = function(map, callback, maxElements) {
                    void 0 === maxElements && (maxElements = constants_1.Constants.MAX_SAFE_INTEGER);
                    var result = [];
                    for (var key in map) if (Object.prototype.hasOwnProperty.call(map, key) && (result.push(callback(map[key], parseInt(key))), 
                    ! --maxElements)) break;
                    return result;
                }, NumberMapUtils.anyOf = function(map, callback) {
                    for (var key in map) if (Object.prototype.hasOwnProperty.call(map, key)) {
                        var res = callback(map[key], parseInt(key));
                        if (null !== res) return res;
                    }
                    return null;
                }, NumberMapUtils.unsafeAnyOf = function(map, callback) {
                    for (var key in map) if (Object.prototype.hasOwnProperty.call(map, key)) {
                        var res = callback(map[key], parseInt(key));
                        if (res) return res;
                    }
                    return null;
                }, NumberMapUtils.allOf = function(map, callback) {
                    for (var key in map) if (Object.prototype.hasOwnProperty.call(map, key) && !callback(map[key], parseInt(key))) return !1;
                    return !0;
                }, NumberMapUtils.mapLength = function(map) {
                    var length = 0;
                    for (var key in map) Object.prototype.hasOwnProperty.call(map, key) && length++;
                    return length;
                }, NumberMapUtils.min = function(map, getValue) {
                    var res = NumberMapUtils.minExtended(map, getValue);
                    return null === res ? null : res.minElement;
                }, NumberMapUtils.max = function(map, getValue) {
                    var res = NumberMapUtils.maxExtended(map, getValue);
                    return null === res ? null : res.maxElement;
                }, NumberMapUtils.minMax = function(map, getValue) {
                    var res = NumberMapUtils.minMaxExtended(map, getValue);
                    return null === res ? null : new min_max_1.MinMax(res.minElement, res.maxElement);
                }, NumberMapUtils.minExtended = function(map, getValue) {
                    var minElement, minValue = constants_1.Constants.MAX_SAFE_INTEGER;
                    for (var key in map) if (Object.prototype.hasOwnProperty.call(map, key)) {
                        var currElem = map[key], currValue = getValue(currElem, parseInt(key));
                        currValue < minValue && (minElement = currElem, minValue = currValue);
                    }
                    return void 0 === minElement ? null : new min_max_1.ExtendedMin(minElement, minValue);
                }, NumberMapUtils.maxExtended = function(map, getValue) {
                    var maxElement, maxValue = constants_1.Constants.MIN_SAFE_INTEGER;
                    for (var key in map) if (Object.prototype.hasOwnProperty.call(map, key)) {
                        var currElem = map[key], currValue = getValue(currElem, parseInt(key));
                        currValue > maxValue && (maxElement = currElem, maxValue = currValue);
                    }
                    return void 0 === maxElement ? null : new min_max_1.ExtendedMax(maxElement, maxValue);
                }, NumberMapUtils.minMaxExtended = function(map, getValue) {
                    var minElement, maxElement, minValue = constants_1.Constants.MAX_SAFE_INTEGER, maxValue = constants_1.Constants.MIN_SAFE_INTEGER;
                    for (var key in map) if (Object.prototype.hasOwnProperty.call(map, key)) {
                        var currElem = map[key], currValue = getValue(currElem, parseInt(key));
                        currValue < minValue ? (minElement = currElem, minValue = currValue) : currValue > maxValue && (maxElement = currElem, 
                        maxValue = currValue);
                    }
                    return void 0 === minElement ? null : new min_max_1.ExtendedMinMax(minElement, minValue, maxElement, maxValue);
                }, NumberMapUtils.maxByCmp = function(map, cmp) {
                    var found;
                    for (var key in map) if (Object.prototype.hasOwnProperty.call(map, key)) if (void 0 !== found) {
                        var elem = map[key];
                        cmp(elem, found) > 0 && (found = elem);
                    } else found = map[key];
                    return void 0 === found ? null : found;
                }, NumberMapUtils.minByCmp = function(map, cmp) {
                    var found;
                    for (var key in map) if (Object.prototype.hasOwnProperty.call(map, key)) if (void 0 !== found) {
                        var elem = map[key];
                        cmp(elem, found) < 0 && (found = elem);
                    } else found = map[key];
                    return void 0 === found ? null : found;
                }, NumberMapUtils;
            }();
            exports.j = NumberMapUtils;
        },
        2866: function(__unused_webpack_module, exports, __webpack_require__) {
            "use strict";
            Object.defineProperty(exports, "__esModule", {
                value: !0
            }), exports.StringMapUtils = void 0;
            var min_max_1 = __webpack_require__(6799), constants_1 = __webpack_require__(8785), StringMapUtils = function() {
                function StringMapUtils() {}
                return StringMapUtils.forEach = function(map, callback) {
                    for (var key in map) Object.prototype.hasOwnProperty.call(map, key) && callback(map[key], key);
                }, StringMapUtils.map = function(map, callback) {
                    var result = {};
                    for (var key in map) Object.prototype.hasOwnProperty.call(map, key) && (result[key] = callback(map[key], key));
                    return result;
                }, StringMapUtils.reducedMap = function(map, callback) {
                    var result = {};
                    for (var key in map) if (Object.prototype.hasOwnProperty.call(map, key)) {
                        var newItem = callback(map[key], key);
                        null !== newItem && (result[key] = newItem);
                    }
                    return result;
                }, StringMapUtils.clear = function(map) {
                    for (var key in map) Object.prototype.hasOwnProperty.call(map, key) && delete map[key];
                }, StringMapUtils.shallowCopy = function(map) {
                    return StringMapUtils.map(map, (function(val) {
                        return val;
                    }));
                }, StringMapUtils.deepCopy = function(map) {
                    return StringMapUtils.map(map, (function(val) {
                        return val.clone();
                    }));
                }, StringMapUtils.isEmpty = function(map) {
                    for (var key in map) if (Object.prototype.hasOwnProperty.call(map, key)) return !1;
                    return !0;
                }, StringMapUtils.accumulate = function(map, initAccValue, callback) {
                    var acc = initAccValue;
                    for (var key in map) Object.prototype.hasOwnProperty.call(map, key) && (acc = callback(acc, map[key], key));
                    return acc;
                }, StringMapUtils.keyBy = function(map, callback) {
                    for (var key in map) if (Object.prototype.hasOwnProperty.call(map, key) && callback(map[key], key)) return key;
                    return null;
                }, StringMapUtils.elementBy = function(map, callback) {
                    var key = StringMapUtils.keyBy(map, callback);
                    return null === key ? null : map[key];
                }, StringMapUtils.containsBy = function(map, callback) {
                    return null !== StringMapUtils.keyBy(map, callback);
                }, StringMapUtils.toList = function(map) {
                    return StringMapUtils.toListBy(map, (function(elem) {
                        return elem;
                    }));
                }, StringMapUtils.toListBy = function(map, callback, maxElements) {
                    void 0 === maxElements && (maxElements = constants_1.Constants.MAX_SAFE_INTEGER);
                    var result = [];
                    for (var key in map) if (Object.prototype.hasOwnProperty.call(map, key) && (result.push(callback(map[key], key)), 
                    ! --maxElements)) break;
                    return result;
                }, StringMapUtils.anyOf = function(map, callback) {
                    for (var key in map) if (Object.prototype.hasOwnProperty.call(map, key)) {
                        var res = callback(map[key], key);
                        if (null !== res) return res;
                    }
                    return null;
                }, StringMapUtils.unsafeAnyOf = function(map, callback) {
                    for (var key in map) if (Object.prototype.hasOwnProperty.call(map, key)) {
                        var res = callback(map[key], key);
                        if (res) return res;
                    }
                    return null;
                }, StringMapUtils.allOf = function(map, callback) {
                    for (var key in map) if (Object.prototype.hasOwnProperty.call(map, key) && !callback(map[key], key)) return !1;
                    return !0;
                }, StringMapUtils.mapLength = function(map) {
                    var length = 0;
                    for (var key in map) Object.prototype.hasOwnProperty.call(map, key) && length++;
                    return length;
                }, StringMapUtils.min = function(map, getValue) {
                    var res = StringMapUtils.minExtended(map, getValue);
                    return null === res ? null : res.minElement;
                }, StringMapUtils.max = function(map, getValue) {
                    var res = StringMapUtils.maxExtended(map, getValue);
                    return null === res ? null : res.maxElement;
                }, StringMapUtils.minMax = function(map, getValue) {
                    var res = StringMapUtils.minMaxExtended(map, getValue);
                    return null === res ? null : new min_max_1.MinMax(res.minElement, res.maxElement);
                }, StringMapUtils.minExtended = function(map, getValue) {
                    var minElement, minValue = constants_1.Constants.MAX_SAFE_INTEGER;
                    for (var key in map) if (Object.prototype.hasOwnProperty.call(map, key)) {
                        var currElem = map[key], currValue = getValue(currElem, key);
                        currValue < minValue && (minElement = currElem, minValue = currValue);
                    }
                    return void 0 === minElement ? null : new min_max_1.ExtendedMin(minElement, minValue);
                }, StringMapUtils.maxExtended = function(map, getValue) {
                    var maxElement, maxValue = constants_1.Constants.MIN_SAFE_INTEGER;
                    for (var key in map) if (Object.prototype.hasOwnProperty.call(map, key)) {
                        var currElem = map[key], currValue = getValue(currElem, key);
                        currValue > maxValue && (maxElement = currElem, maxValue = currValue);
                    }
                    return void 0 === maxElement ? null : new min_max_1.ExtendedMax(maxElement, maxValue);
                }, StringMapUtils.minMaxExtended = function(map, getValue) {
                    var minElement, maxElement, minValue = constants_1.Constants.MAX_SAFE_INTEGER, maxValue = constants_1.Constants.MIN_SAFE_INTEGER;
                    for (var key in map) if (Object.prototype.hasOwnProperty.call(map, key)) {
                        var currElem = map[key], currValue = getValue(currElem, key);
                        currValue < minValue ? (minElement = currElem, minValue = currValue) : currValue > maxValue && (maxElement = currElem, 
                        maxValue = currValue);
                    }
                    return void 0 === minElement ? null : new min_max_1.ExtendedMinMax(minElement, minValue, maxElement, maxValue);
                }, StringMapUtils.maxByCmp = function(map, cmp) {
                    var found;
                    for (var key in map) if (Object.prototype.hasOwnProperty.call(map, key)) if (void 0 !== found) {
                        var elem = map[key];
                        cmp(elem, found) > 0 && (found = elem);
                    } else found = map[key];
                    return void 0 === found ? null : found;
                }, StringMapUtils.minByCmp = function(map, cmp) {
                    var found;
                    for (var key in map) if (Object.prototype.hasOwnProperty.call(map, key)) if (void 0 !== found) {
                        var elem = map[key];
                        cmp(elem, found) < 0 && (found = elem);
                    } else found = map[key];
                    return void 0 === found ? null : found;
                }, StringMapUtils;
            }();
            exports.StringMapUtils = StringMapUtils;
        },
        8679: function(__unused_webpack_module, exports, __webpack_require__) {
            "use strict";
            Object.defineProperty(exports, "__esModule", {
                value: !0
            }), exports.MathUtils = void 0;
            var list_1 = __webpack_require__(2940), MathUtils = function() {
                function MathUtils() {}
                return MathUtils.round = function(value, digits) {
                    void 0 === digits && (digits = 0);
                    var factor = MathUtils.powFactor[digits];
                    return Math.round(value * factor) / factor;
                }, MathUtils.numberCloseTo = function(num, to, accuracy) {
                    return void 0 === accuracy && (accuracy = 1e-5), Math.abs(num - to) < accuracy;
                }, MathUtils.restrictValue = function(val, minVal, maxVal) {
                    return maxVal < minVal && (maxVal = minVal), val > maxVal ? maxVal : val < minVal ? minVal : val;
                }, MathUtils.getRandomInt = function(min, max) {
                    return Math.floor(Math.random() * (max - min + 1)) + min;
                }, MathUtils.generateGuid = function() {
                    return "xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx".replace(/[xy]/g, (function(c) {
                        var r = 16 * Math.random() | 0;
                        return ("x" === c ? r : 3 & r | 8).toString(16);
                    }));
                }, MathUtils.powFactor = list_1.ListUtils.initByCallback(20, (function(ind) {
                    return Math.pow(10, ind);
                })), MathUtils.somePrimes = [ 1009, 1013, 1019, 1021, 1031, 1033, 1039, 1049, 1051, 1061, 1063, 1069, 1087, 1091, 1093, 1097, 1103, 1109, 1117, 1123, 1129, 1151, 1153, 1163, 1171, 1181, 1187, 1193, 1201, 1213, 1217, 1223, 1229, 1231, 1237, 1249, 1259, 1277, 1279, 1283, 1289, 1291, 1297, 1301, 1303, 1307, 1319, 1321, 1327, 1361, 1367, 1373, 1381, 1399, 1409, 1423, 1427, 1429, 1433, 1439, 1447, 1451, 1453, 1459, 1471, 1481, 1483, 1487, 1489, 1493, 1499, 1511, 1523, 1531, 1543, 1549, 1553, 1559, 1567, 1571, 1579, 1583, 1597, 1601, 1607, 1609, 1613, 1619, 1621, 1627, 1637, 1657, 1663, 1667, 1669, 1693, 1697, 1699, 1709, 1721, 1723, 1733, 1741, 1747, 1753, 1759, 1777, 1783, 1787, 1789, 1801, 1811, 1823, 1831, 1847, 1861, 1867, 1871, 1873, 1877, 1879, 1889, 1901, 1907, 1913, 1931, 1933, 1949, 1951, 1973, 1979, 1987, 1993, 1997, 1999, 2003 ], 
                MathUtils;
            }();
            exports.MathUtils = MathUtils;
        },
        4633: function(__unused_webpack_module, exports) {
            "use strict";
            var _a, _b, _c, DxMimeType;
            Object.defineProperty(exports, "__esModule", {
                value: !0
            }), exports.MimeTypeUtils = exports.DxMimeType = exports.ImageWebpMimeType = exports.ImageWbmpMimeType = exports.ImageIcoMimeType = exports.ImageTiffMimeType = exports.ImageSvgMimeType = exports.ImagePjpegMimeType = exports.ImageJpegMimeType = exports.ImageGifMimeType = exports.ImagePngMimeType = exports.DocmMimeType = exports.PlainTextMimeType = exports.RtfMimeType = exports.OpenXmlMimeType = void 0, 
            exports.OpenXmlMimeType = "application/vnd.openxmlformats-officedocument.wordprocessingml.document", 
            exports.RtfMimeType = "application/rtf", exports.PlainTextMimeType = "text/plain", 
            exports.DocmMimeType = "application/vnd.ms-word.document.macroEnabled.12", exports.ImagePngMimeType = "image/png", 
            exports.ImageGifMimeType = "image/gif", exports.ImageJpegMimeType = "image/jpeg", 
            exports.ImagePjpegMimeType = "image/pjpeg", exports.ImageSvgMimeType = "image/svg+xml", 
            exports.ImageTiffMimeType = "image/tiff", exports.ImageIcoMimeType = "image/vnd.microsoft.icon", 
            exports.ImageWbmpMimeType = "image/vnd.wap.wbmp", exports.ImageWebpMimeType = "image/webp", 
            function(DxMimeType) {
                DxMimeType[DxMimeType.Unknown = 0] = "Unknown", DxMimeType[DxMimeType.OpenXml = 1] = "OpenXml", 
                DxMimeType[DxMimeType.Rtf = 2] = "Rtf", DxMimeType[DxMimeType.PlainText = 3] = "PlainText", 
                DxMimeType[DxMimeType.Docm = 4] = "Docm", DxMimeType[DxMimeType.Png = 5] = "Png", 
                DxMimeType[DxMimeType.Gif = 6] = "Gif", DxMimeType[DxMimeType.Jpeg = 7] = "Jpeg", 
                DxMimeType[DxMimeType.Pjpeg = 8] = "Pjpeg", DxMimeType[DxMimeType.Svg = 9] = "Svg", 
                DxMimeType[DxMimeType.Tiff = 10] = "Tiff", DxMimeType[DxMimeType.Ico = 11] = "Ico", 
                DxMimeType[DxMimeType.Wbmp = 12] = "Wbmp", DxMimeType[DxMimeType.Webp = 13] = "Webp";
            }(DxMimeType = exports.DxMimeType || (exports.DxMimeType = {}));
            var MimeTypeUtils = function() {
                function MimeTypeUtils() {}
                return MimeTypeUtils.stringTypeToExtension = function(mimeTypeAsStr) {
                    var mimeType = MimeTypeUtils.stringTypeToTypeMap[mimeTypeAsStr];
                    return void 0 === mimeType ? "" : MimeTypeUtils.typeToExtensionMap[mimeType];
                }, MimeTypeUtils.typeToExtension = function(mimeType) {
                    var ext = MimeTypeUtils.typeToExtensionMap[mimeType];
                    return null != ext ? ext : "";
                }, MimeTypeUtils.extensionToType = function(extension) {
                    "." !== (extension = extension.toLowerCase())[0] && (extension += ".");
                    var mimeType = MimeTypeUtils.extensionToTypeMap[extension];
                    return null != mimeType ? mimeType : DxMimeType.Unknown;
                }, MimeTypeUtils.typeToStringType = function(mimeType) {
                    var str = MimeTypeUtils.typeToStringTypeMap[mimeType];
                    return null != str ? str : "";
                }, MimeTypeUtils.stringTypeToType = function(mimeTypeAsStr) {
                    var mimeType = MimeTypeUtils.stringTypeToTypeMap[mimeTypeAsStr];
                    return void 0 === mimeType ? DxMimeType.Unknown : mimeType;
                }, MimeTypeUtils.stringTypeToTypeMap = ((_a = {})[exports.OpenXmlMimeType] = DxMimeType.OpenXml, 
                _a[exports.RtfMimeType] = DxMimeType.Rtf, _a[exports.PlainTextMimeType] = DxMimeType.PlainText, 
                _a[exports.DocmMimeType] = DxMimeType.Docm, _a[exports.ImagePngMimeType] = DxMimeType.Png, 
                _a[exports.ImageGifMimeType] = DxMimeType.Gif, _a[exports.ImageJpegMimeType] = DxMimeType.Jpeg, 
                _a[exports.ImagePjpegMimeType] = DxMimeType.Pjpeg, _a[exports.ImageSvgMimeType] = DxMimeType.Svg, 
                _a[exports.ImageTiffMimeType] = DxMimeType.Tiff, _a[exports.ImageIcoMimeType] = DxMimeType.Ico, 
                _a[exports.ImageWbmpMimeType] = DxMimeType.Wbmp, _a[exports.ImageWebpMimeType] = DxMimeType.Webp, 
                _a), MimeTypeUtils.typeToStringTypeMap = ((_b = {})[DxMimeType.Unknown] = void 0, 
                _b[DxMimeType.OpenXml] = exports.OpenXmlMimeType, _b[DxMimeType.Rtf] = exports.RtfMimeType, 
                _b[DxMimeType.PlainText] = exports.PlainTextMimeType, _b[DxMimeType.Docm] = exports.DocmMimeType, 
                _b[DxMimeType.Png] = exports.ImagePngMimeType, _b[DxMimeType.Gif] = exports.ImageGifMimeType, 
                _b[DxMimeType.Jpeg] = exports.ImageJpegMimeType, _b[DxMimeType.Pjpeg] = exports.ImagePjpegMimeType, 
                _b[DxMimeType.Svg] = exports.ImageSvgMimeType, _b[DxMimeType.Tiff] = exports.ImageTiffMimeType, 
                _b[DxMimeType.Ico] = exports.ImageIcoMimeType, _b[DxMimeType.Wbmp] = exports.ImageWbmpMimeType, 
                _b[DxMimeType.Webp] = exports.ImageWebpMimeType, _b), MimeTypeUtils.typeToExtensionMap = ((_c = {})[DxMimeType.Unknown] = void 0, 
                _c[DxMimeType.OpenXml] = ".docx", _c[DxMimeType.Rtf] = ".rtf", _c[DxMimeType.PlainText] = ".txt", 
                _c[DxMimeType.Docm] = ".docm", _c[DxMimeType.Png] = ".png", _c[DxMimeType.Gif] = ".gif", 
                _c[DxMimeType.Jpeg] = ".jpeg", _c[DxMimeType.Pjpeg] = ".pjpeg", _c[DxMimeType.Svg] = ".svg", 
                _c[DxMimeType.Tiff] = ".tiff", _c[DxMimeType.Ico] = ".ico", _c[DxMimeType.Wbmp] = ".wbmp", 
                _c[DxMimeType.Webp] = ".webp", _c), MimeTypeUtils.extensionToTypeMap = {
                    ".docx": DxMimeType.OpenXml,
                    ".rtf": DxMimeType.Rtf,
                    ".txt": DxMimeType.PlainText,
                    ".docm": DxMimeType.Docm,
                    ".png": DxMimeType.Png,
                    ".gif": DxMimeType.Gif,
                    ".jpeg": DxMimeType.Jpeg,
                    ".pjpeg": DxMimeType.Pjpeg,
                    ".svg": DxMimeType.Svg,
                    ".tiff": DxMimeType.Tiff,
                    ".ico": DxMimeType.Ico,
                    ".wbmp": DxMimeType.Wbmp,
                    ".webp": DxMimeType.Webp
                }, MimeTypeUtils;
            }();
            exports.MimeTypeUtils = MimeTypeUtils;
        },
        499: function(__unused_webpack_module, exports, __webpack_require__) {
            "use strict";
            exports.y = void 0;
            var browser_1 = __webpack_require__(9279), PopupUtils = function() {
                function PopupUtils() {}
                return PopupUtils.preventContextMenu = function(evt) {
                    null == evt || evt.stopPropagation(), null == evt || evt.preventDefault(), browser_1.Browser.WebKitFamily && (evt.returnValue = !1);
                }, PopupUtils;
            }();
            exports.y = PopupUtils;
        },
        2400: function(__unused_webpack_module, exports) {
            "use strict";
            Object.defineProperty(exports, "__esModule", {
                value: !0
            }), exports.SearchUtils = void 0;
            var SearchUtils = function() {
                function SearchUtils() {}
                return SearchUtils.binaryIndexOf = function(array, comparer, minIndex, maxIndex) {
                    void 0 === minIndex && (minIndex = 0), void 0 === maxIndex && (maxIndex = -2);
                    var findFromZeroPosition = 0 === minIndex;
                    for (-2 === maxIndex && (maxIndex = array.length - 1); minIndex <= maxIndex; ) {
                        var currentIndex = minIndex + (maxIndex - minIndex >> 1), compare = comparer(array[currentIndex]);
                        if (compare < 0) minIndex = currentIndex + 1; else {
                            if (!(compare > 0)) return currentIndex;
                            maxIndex = currentIndex - 1;
                        }
                    }
                    return findFromZeroPosition ? ~minIndex : -1;
                }, SearchUtils.normedBinaryIndexOf = function(array, comparer, minIndex, maxIndex) {
                    void 0 === minIndex && (minIndex = 0), void 0 === maxIndex && (maxIndex = -2);
                    var index = SearchUtils.binaryIndexOf(array, comparer, minIndex, maxIndex);
                    return SearchUtils.binaryIndexNormalizator(index);
                }, SearchUtils.binaryIndexNormalizator = function(index) {
                    return index < 0 ? ~index - 1 : index;
                }, SearchUtils.normedInterpolationIndexOf = function(array, getValue, toFind, lowIndex, highIndex) {
                    void 0 === lowIndex && (lowIndex = 0), void 0 === highIndex && (highIndex = -2), 
                    -2 === highIndex && (highIndex = array.length - 1);
                    var firstObject = array[Math.min(lowIndex, highIndex)];
                    if (void 0 === firstObject || toFind < getValue(firstObject)) return -1;
                    for (var lowValue = getValue(array[lowIndex]), highValue = getValue(array[highIndex]); ;) {
                        if (!(toFind > lowValue && toFind < highValue)) return toFind === lowValue ? lowIndex : highIndex;
                        var midIndex = lowIndex + Math.floor((toFind - lowValue) * (highIndex - lowIndex) / (highValue - lowValue)), midValue = getValue(array[midIndex]);
                        if (toFind > midValue) {
                            if (toFind < (lowValue = getValue(array[lowIndex = midIndex + 1]))) return midIndex;
                        } else {
                            if (!(toFind < midValue)) return midIndex;
                            highValue = getValue(array[highIndex = midIndex - 1]);
                        }
                    }
                }, SearchUtils;
            }();
            exports.SearchUtils = SearchUtils;
        },
        49: function(__unused_webpack_module, exports) {
            "use strict";
            Object.defineProperty(exports, "__esModule", {
                value: !0
            }), exports.StringUtils = void 0;
            var StringUtils = function() {
                function StringUtils() {}
                return StringUtils.isAlpha = function(ch) {
                    return ch >= "a" && ch <= "z" || ch >= "A" && ch <= "Z";
                }, StringUtils.isDigit = function(ch) {
                    return ch >= "0" && ch <= "9";
                }, StringUtils.stringHashCode = function(str) {
                    var hash = 0;
                    if (0 === str.length) return hash;
                    for (var strLen = str.length, i = 0; i < strLen; i++) hash = (hash << 5) - hash + str.charCodeAt(i), 
                    hash |= 0;
                    return hash;
                }, StringUtils.endsAt = function(str, template) {
                    var strInd = str.length - 1, tmplInd = template.length - 1, strStartInd = strInd - tmplInd;
                    if (strStartInd < 0) return !1;
                    for (;strInd >= strStartInd; strInd--, tmplInd--) if (str[strInd] !== template[tmplInd]) return !1;
                    return !0;
                }, StringUtils.startsAt = function(str, template) {
                    return str.substr(0, template.length) === template;
                }, StringUtils.stringInLowerCase = function(str) {
                    return str.toLowerCase() === str;
                }, StringUtils.stringInUpperCase = function(str) {
                    return str.toUpperCase() === str;
                }, StringUtils.atLeastOneSymbolInUpperCase = function(str) {
                    for (var i = 0, char = void 0; char = str[i]; i++) if (StringUtils.stringInUpperCase(char) && !StringUtils.stringInLowerCase(char)) return !0;
                    return !1;
                }, StringUtils.getSymbolFromEnd = function(text, posFromEnd) {
                    return text[text.length - posFromEnd];
                }, StringUtils.trim = function(str, trimChars) {
                    if (void 0 === trimChars) return StringUtils.trimInternal(str, !0, !0);
                    var joinedChars = trimChars.join("");
                    return str.replace(new RegExp("(^[" + joinedChars + "]*)|([" + joinedChars + "]*$)", "g"), "");
                }, StringUtils.trimStart = function(str, trimChars) {
                    if (void 0 === trimChars) return StringUtils.trimInternal(str, !0, !1);
                    var joinedChars = trimChars.join("");
                    return str.replace(new RegExp("^[" + joinedChars + "]*", "g"), "");
                }, StringUtils.trimEnd = function(str, trimChars) {
                    if (void 0 === trimChars) return StringUtils.trimInternal(str, !1, !0);
                    var joinedChars = trimChars.join("");
                    return str.replace(new RegExp("[" + joinedChars + "]*$", "g"), "");
                }, StringUtils.getDecimalSeparator = function() {
                    return 1.1.toLocaleString().substr(1, 1);
                }, StringUtils.repeat = function(str, count) {
                    return new Array(count <= 0 ? 0 : count + 1).join(str);
                }, StringUtils.isNullOrEmpty = function(str) {
                    return !str || !str.length;
                }, StringUtils.padLeft = function(str, totalWidth, paddingChar) {
                    return StringUtils.repeat(paddingChar, Math.max(0, totalWidth - str.length)) + str;
                }, StringUtils.trimInternal = function(source, trimStart, trimEnd) {
                    var len = source.length;
                    if (!len) return source;
                    if (len < 764833) {
                        var result = source;
                        return trimStart && (result = result.replace(/^\s+/, "")), trimEnd && (result = result.replace(/\s+$/, "")), 
                        result;
                    }
                    var start = 0;
                    if (trimEnd) for (;len > 0 && /\s/.test(source[len - 1]); ) len--;
                    if (trimStart && len > 0) for (;start < len && /\s/.test(source[start]); ) start++;
                    return source.substring(start, len);
                }, StringUtils;
            }();
            exports.StringUtils = StringUtils;
        },
        1632: function(__unused_webpack_module, exports, __webpack_require__) {
            "use strict";
            Object.defineProperty(exports, "__esModule", {
                value: !0
            }), exports.TouchUtils = void 0;
            var browser_1 = __webpack_require__(9279), common_1 = __webpack_require__(2491), TouchUtils = function() {
                function TouchUtils() {}
                return TouchUtils.onEventAttachingToDocument = function(eventName, func) {
                    return !browser_1.Browser.MacOSMobilePlatform || !TouchUtils.isTouchEventName(eventName) || (TouchUtils.documentTouchHandlers[eventName] || (TouchUtils.documentTouchHandlers[eventName] = []), 
                    TouchUtils.documentTouchHandlers[eventName].push(func), TouchUtils.documentEventAttachingAllowed);
                }, TouchUtils.isTouchEventName = function(eventName) {
                    return browser_1.Browser.WebKitTouchUI && (eventName.indexOf("touch") > -1 || eventName.indexOf("gesture") > -1);
                }, TouchUtils.isTouchEvent = function(evt) {
                    return browser_1.Browser.WebKitTouchUI && common_1.isDefined(evt.changedTouches);
                }, TouchUtils.getEventX = function(evt) {
                    return browser_1.Browser.IE ? evt.pageX : evt.changedTouches[0].pageX;
                }, TouchUtils.getEventY = function(evt) {
                    return browser_1.Browser.IE ? evt.pageY : evt.changedTouches[0].pageY;
                }, TouchUtils.touchMouseDownEventName = browser_1.Browser.WebKitTouchUI ? "touchstart" : browser_1.Browser.Edge && browser_1.Browser.MSTouchUI && window.PointerEvent ? "pointerdown" : "mousedown", 
                TouchUtils.touchMouseUpEventName = browser_1.Browser.WebKitTouchUI ? "touchend" : browser_1.Browser.Edge && browser_1.Browser.MSTouchUI && window.PointerEvent ? "pointerup" : "mouseup", 
                TouchUtils.touchMouseMoveEventName = browser_1.Browser.WebKitTouchUI ? "touchmove" : browser_1.Browser.Edge && browser_1.Browser.MSTouchUI && window.PointerEvent ? "pointermove" : "mousemove", 
                TouchUtils.msTouchDraggableClassName = "dxMSTouchDraggable", TouchUtils.documentTouchHandlers = {}, 
                TouchUtils.documentEventAttachingAllowed = !0, TouchUtils;
            }();
            exports.TouchUtils = TouchUtils;
        },
        6795: function(__unused_webpack_module, exports, __webpack_require__) {
            "use strict";
            var __webpack_unused_export__;
            __webpack_unused_export__ = {
                value: !0
            }, exports.R = void 0;
            var browser_1 = __webpack_require__(9279), common_1 = __webpack_require__(2491), string_1 = __webpack_require__(49), javascriptPrefix = "javascript:", Url = function() {
                function Url() {}
                return Url.containsClientScript = function(url) {
                    return -1 !== url.toLowerCase().indexOf(javascriptPrefix);
                }, Url.navigate = function(url, target) {
                    if (!string_1.StringUtils.isNullOrEmpty(url)) if (Url.containsClientScript(url)) eval(url.substr(javascriptPrefix.length)); else try {
                        common_1.isNonNullString(target) ? Url.navigateTo(url, target) : location.href = url;
                    } catch (e) {}
                }, Url.navigateTo = function(url, target) {
                    var lowerCaseTarget = target.toLowerCase();
                    if ("_top" === lowerCaseTarget) top.location.href = url; else if ("_self" === lowerCaseTarget) location.href = url; else if ("_search" === lowerCaseTarget) Url.openInNewWindow(url); else if ("_media" === lowerCaseTarget) Url.openInNewWindow(url); else if ("_parent" === lowerCaseTarget) window.parent.location.href = url; else if ("_blank" === lowerCaseTarget) Url.openInNewWindow(url); else {
                        var frame = Url.getFrame(top.frames, target);
                        null !== frame ? frame.location.href = url : Url.openInNewWindow(url);
                    }
                }, Url.openInNewWindow = function(url) {
                    if (browser_1.Browser.Safari) Url.openInNewWindowViaIframe(url); else {
                        var newWindow = window.open();
                        newWindow && (newWindow.opener = null, newWindow.location.assign(url));
                    }
                }, Url.openInNewWindowViaIframe = function(url) {
                    var iframe = document.createElement("iframe");
                    iframe.style.display = "none", document.body.appendChild(iframe);
                    var iframeDoc = iframe.contentDocument || iframe.contentWindow.document, openArgs = '"' + url + '"', script = iframeDoc.createElement("script");
                    script.type = "text/javascript", script.text = "window.parent = null; window.top = null;window.frameElement = null;var child = window.open(" + openArgs + ");child.opener = null", 
                    iframeDoc.body.appendChild(script), document.body.removeChild(iframe);
                }, Url.getFrame = function(frames, name) {
                    if (frames[name]) return frames[name];
                    for (var i = 0; i < frames.length; i++) try {
                        var frame = frames[i];
                        if (frame.name === name) return frame;
                        if (null !== (frame = Url.getFrame(frame.frames, name))) return frame;
                    } catch (e) {}
                    return null;
                }, Url;
            }();
            exports.R = Url;
        },
        2020: function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {
            "use strict";
            __webpack_require__.r(__webpack_exports__), __webpack_require__.d(__webpack_exports__, {
                __assign: function() {
                    return __assign;
                },
                __asyncDelegator: function() {
                    return __asyncDelegator;
                },
                __asyncGenerator: function() {
                    return __asyncGenerator;
                },
                __asyncValues: function() {
                    return __asyncValues;
                },
                __await: function() {
                    return __await;
                },
                __awaiter: function() {
                    return __awaiter;
                },
                __classPrivateFieldGet: function() {
                    return __classPrivateFieldGet;
                },
                __classPrivateFieldSet: function() {
                    return __classPrivateFieldSet;
                },
                __createBinding: function() {
                    return __createBinding;
                },
                __decorate: function() {
                    return __decorate;
                },
                __exportStar: function() {
                    return __exportStar;
                },
                __extends: function() {
                    return __extends;
                },
                __generator: function() {
                    return __generator;
                },
                __importDefault: function() {
                    return __importDefault;
                },
                __importStar: function() {
                    return __importStar;
                },
                __makeTemplateObject: function() {
                    return __makeTemplateObject;
                },
                __metadata: function() {
                    return __metadata;
                },
                __param: function() {
                    return __param;
                },
                __read: function() {
                    return __read;
                },
                __rest: function() {
                    return __rest;
                },
                __spread: function() {
                    return __spread;
                },
                __spreadArray: function() {
                    return __spreadArray;
                },
                __spreadArrays: function() {
                    return __spreadArrays;
                },
                __values: function() {
                    return __values;
                }
            });
            var extendStatics = function(d, b) {
                return extendStatics = Object.setPrototypeOf || {
                    __proto__: []
                } instanceof Array && function(d, b) {
                    d.__proto__ = b;
                } || function(d, b) {
                    for (var p in b) Object.prototype.hasOwnProperty.call(b, p) && (d[p] = b[p]);
                }, extendStatics(d, b);
            };
            function __extends(d, b) {
                if ("function" != typeof b && null !== b) throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
                function __() {
                    this.constructor = d;
                }
                extendStatics(d, b), d.prototype = null === b ? Object.create(b) : (__.prototype = b.prototype, 
                new __);
            }
            var __assign = function() {
                return __assign = Object.assign || function __assign(t) {
                    for (var s, i = 1, n = arguments.length; i < n; i++) for (var p in s = arguments[i]) Object.prototype.hasOwnProperty.call(s, p) && (t[p] = s[p]);
                    return t;
                }, __assign.apply(this, arguments);
            };
            function __rest(s, e) {
                var t = {};
                for (var p in s) Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0 && (t[p] = s[p]);
                if (null != s && "function" == typeof Object.getOwnPropertySymbols) {
                    var i = 0;
                    for (p = Object.getOwnPropertySymbols(s); i < p.length; i++) e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]) && (t[p[i]] = s[p[i]]);
                }
                return t;
            }
            function __decorate(decorators, target, key, desc) {
                var d, c = arguments.length, r = c < 3 ? target : null === desc ? desc = Object.getOwnPropertyDescriptor(target, key) : desc;
                if ("object" == typeof Reflect && "function" == typeof Reflect.decorate) r = Reflect.decorate(decorators, target, key, desc); else for (var i = decorators.length - 1; i >= 0; i--) (d = decorators[i]) && (r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r);
                return c > 3 && r && Object.defineProperty(target, key, r), r;
            }
            function __param(paramIndex, decorator) {
                return function(target, key) {
                    decorator(target, key, paramIndex);
                };
            }
            function __metadata(metadataKey, metadataValue) {
                if ("object" == typeof Reflect && "function" == typeof Reflect.metadata) return Reflect.metadata(metadataKey, metadataValue);
            }
            function __awaiter(thisArg, _arguments, P, generator) {
                return new (P || (P = Promise))((function(resolve, reject) {
                    function fulfilled(value) {
                        try {
                            step(generator.next(value));
                        } catch (e) {
                            reject(e);
                        }
                    }
                    function rejected(value) {
                        try {
                            step(generator.throw(value));
                        } catch (e) {
                            reject(e);
                        }
                    }
                    function step(result) {
                        result.done ? resolve(result.value) : function adopt(value) {
                            return value instanceof P ? value : new P((function(resolve) {
                                resolve(value);
                            }));
                        }(result.value).then(fulfilled, rejected);
                    }
                    step((generator = generator.apply(thisArg, _arguments || [])).next());
                }));
            }
            function __generator(thisArg, body) {
                var f, y, t, g, _ = {
                    label: 0,
                    sent: function() {
                        if (1 & t[0]) throw t[1];
                        return t[1];
                    },
                    trys: [],
                    ops: []
                };
                return g = {
                    next: verb(0),
                    throw: verb(1),
                    return: verb(2)
                }, "function" == typeof Symbol && (g[Symbol.iterator] = function() {
                    return this;
                }), g;
                function verb(n) {
                    return function(v) {
                        return function step(op) {
                            if (f) throw new TypeError("Generator is already executing.");
                            for (;_; ) try {
                                if (f = 1, y && (t = 2 & op[0] ? y.return : op[0] ? y.throw || ((t = y.return) && t.call(y), 
                                0) : y.next) && !(t = t.call(y, op[1])).done) return t;
                                switch (y = 0, t && (op = [ 2 & op[0], t.value ]), op[0]) {
                                  case 0:
                                  case 1:
                                    t = op;
                                    break;

                                  case 4:
                                    return _.label++, {
                                        value: op[1],
                                        done: !1
                                    };

                                  case 5:
                                    _.label++, y = op[1], op = [ 0 ];
                                    continue;

                                  case 7:
                                    op = _.ops.pop(), _.trys.pop();
                                    continue;

                                  default:
                                    if (!(t = _.trys, (t = t.length > 0 && t[t.length - 1]) || 6 !== op[0] && 2 !== op[0])) {
                                        _ = 0;
                                        continue;
                                    }
                                    if (3 === op[0] && (!t || op[1] > t[0] && op[1] < t[3])) {
                                        _.label = op[1];
                                        break;
                                    }
                                    if (6 === op[0] && _.label < t[1]) {
                                        _.label = t[1], t = op;
                                        break;
                                    }
                                    if (t && _.label < t[2]) {
                                        _.label = t[2], _.ops.push(op);
                                        break;
                                    }
                                    t[2] && _.ops.pop(), _.trys.pop();
                                    continue;
                                }
                                op = body.call(thisArg, _);
                            } catch (e) {
                                op = [ 6, e ], y = 0;
                            } finally {
                                f = t = 0;
                            }
                            if (5 & op[0]) throw op[1];
                            return {
                                value: op[0] ? op[1] : void 0,
                                done: !0
                            };
                        }([ n, v ]);
                    };
                }
            }
            var __createBinding = Object.create ? function(o, m, k, k2) {
                void 0 === k2 && (k2 = k), Object.defineProperty(o, k2, {
                    enumerable: !0,
                    get: function() {
                        return m[k];
                    }
                });
            } : function(o, m, k, k2) {
                void 0 === k2 && (k2 = k), o[k2] = m[k];
            };
            function __exportStar(m, o) {
                for (var p in m) "default" === p || Object.prototype.hasOwnProperty.call(o, p) || __createBinding(o, m, p);
            }
            function __values(o) {
                var s = "function" == typeof Symbol && Symbol.iterator, m = s && o[s], i = 0;
                if (m) return m.call(o);
                if (o && "number" == typeof o.length) return {
                    next: function() {
                        return o && i >= o.length && (o = void 0), {
                            value: o && o[i++],
                            done: !o
                        };
                    }
                };
                throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
            }
            function __read(o, n) {
                var m = "function" == typeof Symbol && o[Symbol.iterator];
                if (!m) return o;
                var r, e, i = m.call(o), ar = [];
                try {
                    for (;(void 0 === n || n-- > 0) && !(r = i.next()).done; ) ar.push(r.value);
                } catch (error) {
                    e = {
                        error
                    };
                } finally {
                    try {
                        r && !r.done && (m = i.return) && m.call(i);
                    } finally {
                        if (e) throw e.error;
                    }
                }
                return ar;
            }
            function __spread() {
                for (var ar = [], i = 0; i < arguments.length; i++) ar = ar.concat(__read(arguments[i]));
                return ar;
            }
            function __spreadArrays() {
                for (var s = 0, i = 0, il = arguments.length; i < il; i++) s += arguments[i].length;
                var r = Array(s), k = 0;
                for (i = 0; i < il; i++) for (var a = arguments[i], j = 0, jl = a.length; j < jl; j++, 
                k++) r[k] = a[j];
                return r;
            }
            function __spreadArray(to, from, pack) {
                if (pack || 2 === arguments.length) for (var ar, i = 0, l = from.length; i < l; i++) !ar && i in from || (ar || (ar = Array.prototype.slice.call(from, 0, i)), 
                ar[i] = from[i]);
                return to.concat(ar || Array.prototype.slice.call(from));
            }
            function __await(v) {
                return this instanceof __await ? (this.v = v, this) : new __await(v);
            }
            function __asyncGenerator(thisArg, _arguments, generator) {
                if (!Symbol.asyncIterator) throw new TypeError("Symbol.asyncIterator is not defined.");
                var i, g = generator.apply(thisArg, _arguments || []), q = [];
                return i = {}, verb("next"), verb("throw"), verb("return"), i[Symbol.asyncIterator] = function() {
                    return this;
                }, i;
                function verb(n) {
                    g[n] && (i[n] = function(v) {
                        return new Promise((function(a, b) {
                            q.push([ n, v, a, b ]) > 1 || resume(n, v);
                        }));
                    });
                }
                function resume(n, v) {
                    try {
                        !function step(r) {
                            r.value instanceof __await ? Promise.resolve(r.value.v).then(fulfill, reject) : settle(q[0][2], r);
                        }(g[n](v));
                    } catch (e) {
                        settle(q[0][3], e);
                    }
                }
                function fulfill(value) {
                    resume("next", value);
                }
                function reject(value) {
                    resume("throw", value);
                }
                function settle(f, v) {
                    f(v), q.shift(), q.length && resume(q[0][0], q[0][1]);
                }
            }
            function __asyncDelegator(o) {
                var i, p;
                return i = {}, verb("next"), verb("throw", (function(e) {
                    throw e;
                })), verb("return"), i[Symbol.iterator] = function() {
                    return this;
                }, i;
                function verb(n, f) {
                    i[n] = o[n] ? function(v) {
                        return (p = !p) ? {
                            value: __await(o[n](v)),
                            done: "return" === n
                        } : f ? f(v) : v;
                    } : f;
                }
            }
            function __asyncValues(o) {
                if (!Symbol.asyncIterator) throw new TypeError("Symbol.asyncIterator is not defined.");
                var i, m = o[Symbol.asyncIterator];
                return m ? m.call(o) : (o = __values(o), i = {}, verb("next"), verb("throw"), verb("return"), 
                i[Symbol.asyncIterator] = function() {
                    return this;
                }, i);
                function verb(n) {
                    i[n] = o[n] && function(v) {
                        return new Promise((function(resolve, reject) {
                            (function settle(resolve, reject, d, v) {
                                Promise.resolve(v).then((function(v) {
                                    resolve({
                                        value: v,
                                        done: d
                                    });
                                }), reject);
                            })(resolve, reject, (v = o[n](v)).done, v.value);
                        }));
                    };
                }
            }
            function __makeTemplateObject(cooked, raw) {
                return Object.defineProperty ? Object.defineProperty(cooked, "raw", {
                    value: raw
                }) : cooked.raw = raw, cooked;
            }
            var __setModuleDefault = Object.create ? function(o, v) {
                Object.defineProperty(o, "default", {
                    enumerable: !0,
                    value: v
                });
            } : function(o, v) {
                o.default = v;
            };
            function __importStar(mod) {
                if (mod && mod.__esModule) return mod;
                var result = {};
                if (null != mod) for (var k in mod) "default" !== k && Object.prototype.hasOwnProperty.call(mod, k) && __createBinding(result, mod, k);
                return __setModuleDefault(result, mod), result;
            }
            function __importDefault(mod) {
                return mod && mod.__esModule ? mod : {
                    default: mod
                };
            }
            function __classPrivateFieldGet(receiver, state, kind, f) {
                if ("a" === kind && !f) throw new TypeError("Private accessor was defined without a getter");
                if ("function" == typeof state ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot read private member from an object whose class did not declare it");
                return "m" === kind ? f : "a" === kind ? f.call(receiver) : f ? f.value : state.get(receiver);
            }
            function __classPrivateFieldSet(receiver, state, value, kind, f) {
                if ("m" === kind) throw new TypeError("Private method is not writable");
                if ("a" === kind && !f) throw new TypeError("Private accessor was defined without a setter");
                if ("function" == typeof state ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot write private member to an object whose class did not declare it");
                return "a" === kind ? f.call(receiver, value) : f ? f.value = value : state.set(receiver, value), 
                value;
            }
        },
        9742: function(__unused_webpack_module, exports) {
            "use strict";
            exports.byteLength = function byteLength(b64) {
                var lens = getLens(b64), validLen = lens[0], placeHoldersLen = lens[1];
                return 3 * (validLen + placeHoldersLen) / 4 - placeHoldersLen;
            }, exports.toByteArray = function toByteArray(b64) {
                var tmp, i, lens = getLens(b64), validLen = lens[0], placeHoldersLen = lens[1], arr = new Arr(function _byteLength(b64, validLen, placeHoldersLen) {
                    return 3 * (validLen + placeHoldersLen) / 4 - placeHoldersLen;
                }(0, validLen, placeHoldersLen)), curByte = 0, len = placeHoldersLen > 0 ? validLen - 4 : validLen;
                for (i = 0; i < len; i += 4) tmp = revLookup[b64.charCodeAt(i)] << 18 | revLookup[b64.charCodeAt(i + 1)] << 12 | revLookup[b64.charCodeAt(i + 2)] << 6 | revLookup[b64.charCodeAt(i + 3)], 
                arr[curByte++] = tmp >> 16 & 255, arr[curByte++] = tmp >> 8 & 255, arr[curByte++] = 255 & tmp;
                2 === placeHoldersLen && (tmp = revLookup[b64.charCodeAt(i)] << 2 | revLookup[b64.charCodeAt(i + 1)] >> 4, 
                arr[curByte++] = 255 & tmp);
                1 === placeHoldersLen && (tmp = revLookup[b64.charCodeAt(i)] << 10 | revLookup[b64.charCodeAt(i + 1)] << 4 | revLookup[b64.charCodeAt(i + 2)] >> 2, 
                arr[curByte++] = tmp >> 8 & 255, arr[curByte++] = 255 & tmp);
                return arr;
            }, exports.fromByteArray = function fromByteArray(uint8) {
                for (var tmp, len = uint8.length, extraBytes = len % 3, parts = [], i = 0, len2 = len - extraBytes; i < len2; i += 16383) parts.push(encodeChunk(uint8, i, i + 16383 > len2 ? len2 : i + 16383));
                1 === extraBytes ? (tmp = uint8[len - 1], parts.push(lookup[tmp >> 2] + lookup[tmp << 4 & 63] + "==")) : 2 === extraBytes && (tmp = (uint8[len - 2] << 8) + uint8[len - 1], 
                parts.push(lookup[tmp >> 10] + lookup[tmp >> 4 & 63] + lookup[tmp << 2 & 63] + "="));
                return parts.join("");
            };
            for (var lookup = [], revLookup = [], Arr = "undefined" != typeof Uint8Array ? Uint8Array : Array, code = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/", i = 0; i < 64; ++i) lookup[i] = code[i], 
            revLookup[code.charCodeAt(i)] = i;
            function getLens(b64) {
                var len = b64.length;
                if (len % 4 > 0) throw new Error("Invalid string. Length must be a multiple of 4");
                var validLen = b64.indexOf("=");
                return -1 === validLen && (validLen = len), [ validLen, validLen === len ? 0 : 4 - validLen % 4 ];
            }
            function encodeChunk(uint8, start, end) {
                for (var tmp, num, output = [], i = start; i < end; i += 3) tmp = (uint8[i] << 16 & 16711680) + (uint8[i + 1] << 8 & 65280) + (255 & uint8[i + 2]), 
                output.push(lookup[(num = tmp) >> 18 & 63] + lookup[num >> 12 & 63] + lookup[num >> 6 & 63] + lookup[63 & num]);
                return output.join("");
            }
            revLookup["-".charCodeAt(0)] = 62, revLookup["_".charCodeAt(0)] = 63;
        },
        8764: function(__unused_webpack_module, exports, __webpack_require__) {
            "use strict";
            const base64 = __webpack_require__(9742), ieee754 = __webpack_require__(645), customInspectSymbol = "function" == typeof Symbol && "function" == typeof Symbol.for ? Symbol.for("nodejs.util.inspect.custom") : null;
            exports.lW = Buffer, exports.h2 = 50;
            const K_MAX_LENGTH = 2147483647;
            function createBuffer(length) {
                if (length > K_MAX_LENGTH) throw new RangeError('The value "' + length + '" is invalid for option "size"');
                const buf = new Uint8Array(length);
                return Object.setPrototypeOf(buf, Buffer.prototype), buf;
            }
            function Buffer(arg, encodingOrOffset, length) {
                if ("number" == typeof arg) {
                    if ("string" == typeof encodingOrOffset) throw new TypeError('The "string" argument must be of type string. Received type number');
                    return allocUnsafe(arg);
                }
                return from(arg, encodingOrOffset, length);
            }
            function from(value, encodingOrOffset, length) {
                if ("string" == typeof value) return function fromString(string, encoding) {
                    "string" == typeof encoding && "" !== encoding || (encoding = "utf8");
                    if (!Buffer.isEncoding(encoding)) throw new TypeError("Unknown encoding: " + encoding);
                    const length = 0 | byteLength(string, encoding);
                    let buf = createBuffer(length);
                    const actual = buf.write(string, encoding);
                    actual !== length && (buf = buf.slice(0, actual));
                    return buf;
                }(value, encodingOrOffset);
                if (ArrayBuffer.isView(value)) return function fromArrayView(arrayView) {
                    if (isInstance(arrayView, Uint8Array)) {
                        const copy = new Uint8Array(arrayView);
                        return fromArrayBuffer(copy.buffer, copy.byteOffset, copy.byteLength);
                    }
                    return fromArrayLike(arrayView);
                }(value);
                if (null == value) throw new TypeError("The first argument must be one of type string, Buffer, ArrayBuffer, Array, or Array-like Object. Received type " + typeof value);
                if (isInstance(value, ArrayBuffer) || value && isInstance(value.buffer, ArrayBuffer)) return fromArrayBuffer(value, encodingOrOffset, length);
                if ("undefined" != typeof SharedArrayBuffer && (isInstance(value, SharedArrayBuffer) || value && isInstance(value.buffer, SharedArrayBuffer))) return fromArrayBuffer(value, encodingOrOffset, length);
                if ("number" == typeof value) throw new TypeError('The "value" argument must not be of type number. Received type number');
                const valueOf = value.valueOf && value.valueOf();
                if (null != valueOf && valueOf !== value) return Buffer.from(valueOf, encodingOrOffset, length);
                const b = function fromObject(obj) {
                    if (Buffer.isBuffer(obj)) {
                        const len = 0 | checked(obj.length), buf = createBuffer(len);
                        return 0 === buf.length || obj.copy(buf, 0, 0, len), buf;
                    }
                    if (void 0 !== obj.length) return "number" != typeof obj.length || numberIsNaN(obj.length) ? createBuffer(0) : fromArrayLike(obj);
                    if ("Buffer" === obj.type && Array.isArray(obj.data)) return fromArrayLike(obj.data);
                }(value);
                if (b) return b;
                if ("undefined" != typeof Symbol && null != Symbol.toPrimitive && "function" == typeof value[Symbol.toPrimitive]) return Buffer.from(value[Symbol.toPrimitive]("string"), encodingOrOffset, length);
                throw new TypeError("The first argument must be one of type string, Buffer, ArrayBuffer, Array, or Array-like Object. Received type " + typeof value);
            }
            function assertSize(size) {
                if ("number" != typeof size) throw new TypeError('"size" argument must be of type number');
                if (size < 0) throw new RangeError('The value "' + size + '" is invalid for option "size"');
            }
            function allocUnsafe(size) {
                return assertSize(size), createBuffer(size < 0 ? 0 : 0 | checked(size));
            }
            function fromArrayLike(array) {
                const length = array.length < 0 ? 0 : 0 | checked(array.length), buf = createBuffer(length);
                for (let i = 0; i < length; i += 1) buf[i] = 255 & array[i];
                return buf;
            }
            function fromArrayBuffer(array, byteOffset, length) {
                if (byteOffset < 0 || array.byteLength < byteOffset) throw new RangeError('"offset" is outside of buffer bounds');
                if (array.byteLength < byteOffset + (length || 0)) throw new RangeError('"length" is outside of buffer bounds');
                let buf;
                return buf = void 0 === byteOffset && void 0 === length ? new Uint8Array(array) : void 0 === length ? new Uint8Array(array, byteOffset) : new Uint8Array(array, byteOffset, length), 
                Object.setPrototypeOf(buf, Buffer.prototype), buf;
            }
            function checked(length) {
                if (length >= K_MAX_LENGTH) throw new RangeError("Attempt to allocate Buffer larger than maximum size: 0x" + K_MAX_LENGTH.toString(16) + " bytes");
                return 0 | length;
            }
            function byteLength(string, encoding) {
                if (Buffer.isBuffer(string)) return string.length;
                if (ArrayBuffer.isView(string) || isInstance(string, ArrayBuffer)) return string.byteLength;
                if ("string" != typeof string) throw new TypeError('The "string" argument must be one of type string, Buffer, or ArrayBuffer. Received type ' + typeof string);
                const len = string.length, mustMatch = arguments.length > 2 && !0 === arguments[2];
                if (!mustMatch && 0 === len) return 0;
                let loweredCase = !1;
                for (;;) switch (encoding) {
                  case "ascii":
                  case "latin1":
                  case "binary":
                    return len;

                  case "utf8":
                  case "utf-8":
                    return utf8ToBytes(string).length;

                  case "ucs2":
                  case "ucs-2":
                  case "utf16le":
                  case "utf-16le":
                    return 2 * len;

                  case "hex":
                    return len >>> 1;

                  case "base64":
                    return base64ToBytes(string).length;

                  default:
                    if (loweredCase) return mustMatch ? -1 : utf8ToBytes(string).length;
                    encoding = ("" + encoding).toLowerCase(), loweredCase = !0;
                }
            }
            function slowToString(encoding, start, end) {
                let loweredCase = !1;
                if ((void 0 === start || start < 0) && (start = 0), start > this.length) return "";
                if ((void 0 === end || end > this.length) && (end = this.length), end <= 0) return "";
                if ((end >>>= 0) <= (start >>>= 0)) return "";
                for (encoding || (encoding = "utf8"); ;) switch (encoding) {
                  case "hex":
                    return hexSlice(this, start, end);

                  case "utf8":
                  case "utf-8":
                    return utf8Slice(this, start, end);

                  case "ascii":
                    return asciiSlice(this, start, end);

                  case "latin1":
                  case "binary":
                    return latin1Slice(this, start, end);

                  case "base64":
                    return base64Slice(this, start, end);

                  case "ucs2":
                  case "ucs-2":
                  case "utf16le":
                  case "utf-16le":
                    return utf16leSlice(this, start, end);

                  default:
                    if (loweredCase) throw new TypeError("Unknown encoding: " + encoding);
                    encoding = (encoding + "").toLowerCase(), loweredCase = !0;
                }
            }
            function swap(b, n, m) {
                const i = b[n];
                b[n] = b[m], b[m] = i;
            }
            function bidirectionalIndexOf(buffer, val, byteOffset, encoding, dir) {
                if (0 === buffer.length) return -1;
                if ("string" == typeof byteOffset ? (encoding = byteOffset, byteOffset = 0) : byteOffset > 2147483647 ? byteOffset = 2147483647 : byteOffset < -2147483648 && (byteOffset = -2147483648), 
                numberIsNaN(byteOffset = +byteOffset) && (byteOffset = dir ? 0 : buffer.length - 1), 
                byteOffset < 0 && (byteOffset = buffer.length + byteOffset), byteOffset >= buffer.length) {
                    if (dir) return -1;
                    byteOffset = buffer.length - 1;
                } else if (byteOffset < 0) {
                    if (!dir) return -1;
                    byteOffset = 0;
                }
                if ("string" == typeof val && (val = Buffer.from(val, encoding)), Buffer.isBuffer(val)) return 0 === val.length ? -1 : arrayIndexOf(buffer, val, byteOffset, encoding, dir);
                if ("number" == typeof val) return val &= 255, "function" == typeof Uint8Array.prototype.indexOf ? dir ? Uint8Array.prototype.indexOf.call(buffer, val, byteOffset) : Uint8Array.prototype.lastIndexOf.call(buffer, val, byteOffset) : arrayIndexOf(buffer, [ val ], byteOffset, encoding, dir);
                throw new TypeError("val must be string, number or Buffer");
            }
            function arrayIndexOf(arr, val, byteOffset, encoding, dir) {
                let i, indexSize = 1, arrLength = arr.length, valLength = val.length;
                if (void 0 !== encoding && ("ucs2" === (encoding = String(encoding).toLowerCase()) || "ucs-2" === encoding || "utf16le" === encoding || "utf-16le" === encoding)) {
                    if (arr.length < 2 || val.length < 2) return -1;
                    indexSize = 2, arrLength /= 2, valLength /= 2, byteOffset /= 2;
                }
                function read(buf, i) {
                    return 1 === indexSize ? buf[i] : buf.readUInt16BE(i * indexSize);
                }
                if (dir) {
                    let foundIndex = -1;
                    for (i = byteOffset; i < arrLength; i++) if (read(arr, i) === read(val, -1 === foundIndex ? 0 : i - foundIndex)) {
                        if (-1 === foundIndex && (foundIndex = i), i - foundIndex + 1 === valLength) return foundIndex * indexSize;
                    } else -1 !== foundIndex && (i -= i - foundIndex), foundIndex = -1;
                } else for (byteOffset + valLength > arrLength && (byteOffset = arrLength - valLength), 
                i = byteOffset; i >= 0; i--) {
                    let found = !0;
                    for (let j = 0; j < valLength; j++) if (read(arr, i + j) !== read(val, j)) {
                        found = !1;
                        break;
                    }
                    if (found) return i;
                }
                return -1;
            }
            function hexWrite(buf, string, offset, length) {
                offset = Number(offset) || 0;
                const remaining = buf.length - offset;
                length ? (length = Number(length)) > remaining && (length = remaining) : length = remaining;
                const strLen = string.length;
                let i;
                for (length > strLen / 2 && (length = strLen / 2), i = 0; i < length; ++i) {
                    const parsed = parseInt(string.substr(2 * i, 2), 16);
                    if (numberIsNaN(parsed)) return i;
                    buf[offset + i] = parsed;
                }
                return i;
            }
            function utf8Write(buf, string, offset, length) {
                return blitBuffer(utf8ToBytes(string, buf.length - offset), buf, offset, length);
            }
            function asciiWrite(buf, string, offset, length) {
                return blitBuffer(function asciiToBytes(str) {
                    const byteArray = [];
                    for (let i = 0; i < str.length; ++i) byteArray.push(255 & str.charCodeAt(i));
                    return byteArray;
                }(string), buf, offset, length);
            }
            function base64Write(buf, string, offset, length) {
                return blitBuffer(base64ToBytes(string), buf, offset, length);
            }
            function ucs2Write(buf, string, offset, length) {
                return blitBuffer(function utf16leToBytes(str, units) {
                    let c, hi, lo;
                    const byteArray = [];
                    for (let i = 0; i < str.length && !((units -= 2) < 0); ++i) c = str.charCodeAt(i), 
                    hi = c >> 8, lo = c % 256, byteArray.push(lo), byteArray.push(hi);
                    return byteArray;
                }(string, buf.length - offset), buf, offset, length);
            }
            function base64Slice(buf, start, end) {
                return 0 === start && end === buf.length ? base64.fromByteArray(buf) : base64.fromByteArray(buf.slice(start, end));
            }
            function utf8Slice(buf, start, end) {
                end = Math.min(buf.length, end);
                const res = [];
                let i = start;
                for (;i < end; ) {
                    const firstByte = buf[i];
                    let codePoint = null, bytesPerSequence = firstByte > 239 ? 4 : firstByte > 223 ? 3 : firstByte > 191 ? 2 : 1;
                    if (i + bytesPerSequence <= end) {
                        let secondByte, thirdByte, fourthByte, tempCodePoint;
                        switch (bytesPerSequence) {
                          case 1:
                            firstByte < 128 && (codePoint = firstByte);
                            break;

                          case 2:
                            secondByte = buf[i + 1], 128 == (192 & secondByte) && (tempCodePoint = (31 & firstByte) << 6 | 63 & secondByte, 
                            tempCodePoint > 127 && (codePoint = tempCodePoint));
                            break;

                          case 3:
                            secondByte = buf[i + 1], thirdByte = buf[i + 2], 128 == (192 & secondByte) && 128 == (192 & thirdByte) && (tempCodePoint = (15 & firstByte) << 12 | (63 & secondByte) << 6 | 63 & thirdByte, 
                            tempCodePoint > 2047 && (tempCodePoint < 55296 || tempCodePoint > 57343) && (codePoint = tempCodePoint));
                            break;

                          case 4:
                            secondByte = buf[i + 1], thirdByte = buf[i + 2], fourthByte = buf[i + 3], 128 == (192 & secondByte) && 128 == (192 & thirdByte) && 128 == (192 & fourthByte) && (tempCodePoint = (15 & firstByte) << 18 | (63 & secondByte) << 12 | (63 & thirdByte) << 6 | 63 & fourthByte, 
                            tempCodePoint > 65535 && tempCodePoint < 1114112 && (codePoint = tempCodePoint));
                        }
                    }
                    null === codePoint ? (codePoint = 65533, bytesPerSequence = 1) : codePoint > 65535 && (codePoint -= 65536, 
                    res.push(codePoint >>> 10 & 1023 | 55296), codePoint = 56320 | 1023 & codePoint), 
                    res.push(codePoint), i += bytesPerSequence;
                }
                return function decodeCodePointsArray(codePoints) {
                    const len = codePoints.length;
                    if (len <= MAX_ARGUMENTS_LENGTH) return String.fromCharCode.apply(String, codePoints);
                    let res = "", i = 0;
                    for (;i < len; ) res += String.fromCharCode.apply(String, codePoints.slice(i, i += MAX_ARGUMENTS_LENGTH));
                    return res;
                }(res);
            }
            Buffer.TYPED_ARRAY_SUPPORT = function typedArraySupport() {
                try {
                    const arr = new Uint8Array(1), proto = {
                        foo: function() {
                            return 42;
                        }
                    };
                    return Object.setPrototypeOf(proto, Uint8Array.prototype), Object.setPrototypeOf(arr, proto), 
                    42 === arr.foo();
                } catch (e) {
                    return !1;
                }
            }(), Buffer.TYPED_ARRAY_SUPPORT || "undefined" == typeof console || "function" != typeof console.error || console.error("This browser lacks typed array (Uint8Array) support which is required by `buffer` v5.x. Use `buffer` v4.x if you require old browser support."), 
            Object.defineProperty(Buffer.prototype, "parent", {
                enumerable: !0,
                get: function() {
                    if (Buffer.isBuffer(this)) return this.buffer;
                }
            }), Object.defineProperty(Buffer.prototype, "offset", {
                enumerable: !0,
                get: function() {
                    if (Buffer.isBuffer(this)) return this.byteOffset;
                }
            }), Buffer.poolSize = 8192, Buffer.from = function(value, encodingOrOffset, length) {
                return from(value, encodingOrOffset, length);
            }, Object.setPrototypeOf(Buffer.prototype, Uint8Array.prototype), Object.setPrototypeOf(Buffer, Uint8Array), 
            Buffer.alloc = function(size, fill, encoding) {
                return function alloc(size, fill, encoding) {
                    return assertSize(size), size <= 0 ? createBuffer(size) : void 0 !== fill ? "string" == typeof encoding ? createBuffer(size).fill(fill, encoding) : createBuffer(size).fill(fill) : createBuffer(size);
                }(size, fill, encoding);
            }, Buffer.allocUnsafe = function(size) {
                return allocUnsafe(size);
            }, Buffer.allocUnsafeSlow = function(size) {
                return allocUnsafe(size);
            }, Buffer.isBuffer = function isBuffer(b) {
                return null != b && !0 === b._isBuffer && b !== Buffer.prototype;
            }, Buffer.compare = function compare(a, b) {
                if (isInstance(a, Uint8Array) && (a = Buffer.from(a, a.offset, a.byteLength)), isInstance(b, Uint8Array) && (b = Buffer.from(b, b.offset, b.byteLength)), 
                !Buffer.isBuffer(a) || !Buffer.isBuffer(b)) throw new TypeError('The "buf1", "buf2" arguments must be one of type Buffer or Uint8Array');
                if (a === b) return 0;
                let x = a.length, y = b.length;
                for (let i = 0, len = Math.min(x, y); i < len; ++i) if (a[i] !== b[i]) {
                    x = a[i], y = b[i];
                    break;
                }
                return x < y ? -1 : y < x ? 1 : 0;
            }, Buffer.isEncoding = function isEncoding(encoding) {
                switch (String(encoding).toLowerCase()) {
                  case "hex":
                  case "utf8":
                  case "utf-8":
                  case "ascii":
                  case "latin1":
                  case "binary":
                  case "base64":
                  case "ucs2":
                  case "ucs-2":
                  case "utf16le":
                  case "utf-16le":
                    return !0;

                  default:
                    return !1;
                }
            }, Buffer.concat = function concat(list, length) {
                if (!Array.isArray(list)) throw new TypeError('"list" argument must be an Array of Buffers');
                if (0 === list.length) return Buffer.alloc(0);
                let i;
                if (void 0 === length) for (length = 0, i = 0; i < list.length; ++i) length += list[i].length;
                const buffer = Buffer.allocUnsafe(length);
                let pos = 0;
                for (i = 0; i < list.length; ++i) {
                    let buf = list[i];
                    if (isInstance(buf, Uint8Array)) pos + buf.length > buffer.length ? (Buffer.isBuffer(buf) || (buf = Buffer.from(buf)), 
                    buf.copy(buffer, pos)) : Uint8Array.prototype.set.call(buffer, buf, pos); else {
                        if (!Buffer.isBuffer(buf)) throw new TypeError('"list" argument must be an Array of Buffers');
                        buf.copy(buffer, pos);
                    }
                    pos += buf.length;
                }
                return buffer;
            }, Buffer.byteLength = byteLength, Buffer.prototype._isBuffer = !0, Buffer.prototype.swap16 = function swap16() {
                const len = this.length;
                if (len % 2 != 0) throw new RangeError("Buffer size must be a multiple of 16-bits");
                for (let i = 0; i < len; i += 2) swap(this, i, i + 1);
                return this;
            }, Buffer.prototype.swap32 = function swap32() {
                const len = this.length;
                if (len % 4 != 0) throw new RangeError("Buffer size must be a multiple of 32-bits");
                for (let i = 0; i < len; i += 4) swap(this, i, i + 3), swap(this, i + 1, i + 2);
                return this;
            }, Buffer.prototype.swap64 = function swap64() {
                const len = this.length;
                if (len % 8 != 0) throw new RangeError("Buffer size must be a multiple of 64-bits");
                for (let i = 0; i < len; i += 8) swap(this, i, i + 7), swap(this, i + 1, i + 6), 
                swap(this, i + 2, i + 5), swap(this, i + 3, i + 4);
                return this;
            }, Buffer.prototype.toString = function toString() {
                const length = this.length;
                return 0 === length ? "" : 0 === arguments.length ? utf8Slice(this, 0, length) : slowToString.apply(this, arguments);
            }, Buffer.prototype.toLocaleString = Buffer.prototype.toString, Buffer.prototype.equals = function equals(b) {
                if (!Buffer.isBuffer(b)) throw new TypeError("Argument must be a Buffer");
                return this === b || 0 === Buffer.compare(this, b);
            }, Buffer.prototype.inspect = function inspect() {
                let str = "";
                const max = exports.h2;
                return str = this.toString("hex", 0, max).replace(/(.{2})/g, "$1 ").trim(), this.length > max && (str += " ... "), 
                "<Buffer " + str + ">";
            }, customInspectSymbol && (Buffer.prototype[customInspectSymbol] = Buffer.prototype.inspect), 
            Buffer.prototype.compare = function compare(target, start, end, thisStart, thisEnd) {
                if (isInstance(target, Uint8Array) && (target = Buffer.from(target, target.offset, target.byteLength)), 
                !Buffer.isBuffer(target)) throw new TypeError('The "target" argument must be one of type Buffer or Uint8Array. Received type ' + typeof target);
                if (void 0 === start && (start = 0), void 0 === end && (end = target ? target.length : 0), 
                void 0 === thisStart && (thisStart = 0), void 0 === thisEnd && (thisEnd = this.length), 
                start < 0 || end > target.length || thisStart < 0 || thisEnd > this.length) throw new RangeError("out of range index");
                if (thisStart >= thisEnd && start >= end) return 0;
                if (thisStart >= thisEnd) return -1;
                if (start >= end) return 1;
                if (this === target) return 0;
                let x = (thisEnd >>>= 0) - (thisStart >>>= 0), y = (end >>>= 0) - (start >>>= 0);
                const len = Math.min(x, y), thisCopy = this.slice(thisStart, thisEnd), targetCopy = target.slice(start, end);
                for (let i = 0; i < len; ++i) if (thisCopy[i] !== targetCopy[i]) {
                    x = thisCopy[i], y = targetCopy[i];
                    break;
                }
                return x < y ? -1 : y < x ? 1 : 0;
            }, Buffer.prototype.includes = function includes(val, byteOffset, encoding) {
                return -1 !== this.indexOf(val, byteOffset, encoding);
            }, Buffer.prototype.indexOf = function indexOf(val, byteOffset, encoding) {
                return bidirectionalIndexOf(this, val, byteOffset, encoding, !0);
            }, Buffer.prototype.lastIndexOf = function lastIndexOf(val, byteOffset, encoding) {
                return bidirectionalIndexOf(this, val, byteOffset, encoding, !1);
            }, Buffer.prototype.write = function write(string, offset, length, encoding) {
                if (void 0 === offset) encoding = "utf8", length = this.length, offset = 0; else if (void 0 === length && "string" == typeof offset) encoding = offset, 
                length = this.length, offset = 0; else {
                    if (!isFinite(offset)) throw new Error("Buffer.write(string, encoding, offset[, length]) is no longer supported");
                    offset >>>= 0, isFinite(length) ? (length >>>= 0, void 0 === encoding && (encoding = "utf8")) : (encoding = length, 
                    length = void 0);
                }
                const remaining = this.length - offset;
                if ((void 0 === length || length > remaining) && (length = remaining), string.length > 0 && (length < 0 || offset < 0) || offset > this.length) throw new RangeError("Attempt to write outside buffer bounds");
                encoding || (encoding = "utf8");
                let loweredCase = !1;
                for (;;) switch (encoding) {
                  case "hex":
                    return hexWrite(this, string, offset, length);

                  case "utf8":
                  case "utf-8":
                    return utf8Write(this, string, offset, length);

                  case "ascii":
                  case "latin1":
                  case "binary":
                    return asciiWrite(this, string, offset, length);

                  case "base64":
                    return base64Write(this, string, offset, length);

                  case "ucs2":
                  case "ucs-2":
                  case "utf16le":
                  case "utf-16le":
                    return ucs2Write(this, string, offset, length);

                  default:
                    if (loweredCase) throw new TypeError("Unknown encoding: " + encoding);
                    encoding = ("" + encoding).toLowerCase(), loweredCase = !0;
                }
            }, Buffer.prototype.toJSON = function toJSON() {
                return {
                    type: "Buffer",
                    data: Array.prototype.slice.call(this._arr || this, 0)
                };
            };
            const MAX_ARGUMENTS_LENGTH = 4096;
            function asciiSlice(buf, start, end) {
                let ret = "";
                end = Math.min(buf.length, end);
                for (let i = start; i < end; ++i) ret += String.fromCharCode(127 & buf[i]);
                return ret;
            }
            function latin1Slice(buf, start, end) {
                let ret = "";
                end = Math.min(buf.length, end);
                for (let i = start; i < end; ++i) ret += String.fromCharCode(buf[i]);
                return ret;
            }
            function hexSlice(buf, start, end) {
                const len = buf.length;
                (!start || start < 0) && (start = 0), (!end || end < 0 || end > len) && (end = len);
                let out = "";
                for (let i = start; i < end; ++i) out += hexSliceLookupTable[buf[i]];
                return out;
            }
            function utf16leSlice(buf, start, end) {
                const bytes = buf.slice(start, end);
                let res = "";
                for (let i = 0; i < bytes.length - 1; i += 2) res += String.fromCharCode(bytes[i] + 256 * bytes[i + 1]);
                return res;
            }
            function checkOffset(offset, ext, length) {
                if (offset % 1 != 0 || offset < 0) throw new RangeError("offset is not uint");
                if (offset + ext > length) throw new RangeError("Trying to access beyond buffer length");
            }
            function checkInt(buf, value, offset, ext, max, min) {
                if (!Buffer.isBuffer(buf)) throw new TypeError('"buffer" argument must be a Buffer instance');
                if (value > max || value < min) throw new RangeError('"value" argument is out of bounds');
                if (offset + ext > buf.length) throw new RangeError("Index out of range");
            }
            function wrtBigUInt64LE(buf, value, offset, min, max) {
                checkIntBI(value, min, max, buf, offset, 7);
                let lo = Number(value & BigInt(4294967295));
                buf[offset++] = lo, lo >>= 8, buf[offset++] = lo, lo >>= 8, buf[offset++] = lo, 
                lo >>= 8, buf[offset++] = lo;
                let hi = Number(value >> BigInt(32) & BigInt(4294967295));
                return buf[offset++] = hi, hi >>= 8, buf[offset++] = hi, hi >>= 8, buf[offset++] = hi, 
                hi >>= 8, buf[offset++] = hi, offset;
            }
            function wrtBigUInt64BE(buf, value, offset, min, max) {
                checkIntBI(value, min, max, buf, offset, 7);
                let lo = Number(value & BigInt(4294967295));
                buf[offset + 7] = lo, lo >>= 8, buf[offset + 6] = lo, lo >>= 8, buf[offset + 5] = lo, 
                lo >>= 8, buf[offset + 4] = lo;
                let hi = Number(value >> BigInt(32) & BigInt(4294967295));
                return buf[offset + 3] = hi, hi >>= 8, buf[offset + 2] = hi, hi >>= 8, buf[offset + 1] = hi, 
                hi >>= 8, buf[offset] = hi, offset + 8;
            }
            function checkIEEE754(buf, value, offset, ext, max, min) {
                if (offset + ext > buf.length) throw new RangeError("Index out of range");
                if (offset < 0) throw new RangeError("Index out of range");
            }
            function writeFloat(buf, value, offset, littleEndian, noAssert) {
                return value = +value, offset >>>= 0, noAssert || checkIEEE754(buf, 0, offset, 4), 
                ieee754.write(buf, value, offset, littleEndian, 23, 4), offset + 4;
            }
            function writeDouble(buf, value, offset, littleEndian, noAssert) {
                return value = +value, offset >>>= 0, noAssert || checkIEEE754(buf, 0, offset, 8), 
                ieee754.write(buf, value, offset, littleEndian, 52, 8), offset + 8;
            }
            Buffer.prototype.slice = function slice(start, end) {
                const len = this.length;
                (start = ~~start) < 0 ? (start += len) < 0 && (start = 0) : start > len && (start = len), 
                (end = void 0 === end ? len : ~~end) < 0 ? (end += len) < 0 && (end = 0) : end > len && (end = len), 
                end < start && (end = start);
                const newBuf = this.subarray(start, end);
                return Object.setPrototypeOf(newBuf, Buffer.prototype), newBuf;
            }, Buffer.prototype.readUintLE = Buffer.prototype.readUIntLE = function readUIntLE(offset, byteLength, noAssert) {
                offset >>>= 0, byteLength >>>= 0, noAssert || checkOffset(offset, byteLength, this.length);
                let val = this[offset], mul = 1, i = 0;
                for (;++i < byteLength && (mul *= 256); ) val += this[offset + i] * mul;
                return val;
            }, Buffer.prototype.readUintBE = Buffer.prototype.readUIntBE = function readUIntBE(offset, byteLength, noAssert) {
                offset >>>= 0, byteLength >>>= 0, noAssert || checkOffset(offset, byteLength, this.length);
                let val = this[offset + --byteLength], mul = 1;
                for (;byteLength > 0 && (mul *= 256); ) val += this[offset + --byteLength] * mul;
                return val;
            }, Buffer.prototype.readUint8 = Buffer.prototype.readUInt8 = function readUInt8(offset, noAssert) {
                return offset >>>= 0, noAssert || checkOffset(offset, 1, this.length), this[offset];
            }, Buffer.prototype.readUint16LE = Buffer.prototype.readUInt16LE = function readUInt16LE(offset, noAssert) {
                return offset >>>= 0, noAssert || checkOffset(offset, 2, this.length), this[offset] | this[offset + 1] << 8;
            }, Buffer.prototype.readUint16BE = Buffer.prototype.readUInt16BE = function readUInt16BE(offset, noAssert) {
                return offset >>>= 0, noAssert || checkOffset(offset, 2, this.length), this[offset] << 8 | this[offset + 1];
            }, Buffer.prototype.readUint32LE = Buffer.prototype.readUInt32LE = function readUInt32LE(offset, noAssert) {
                return offset >>>= 0, noAssert || checkOffset(offset, 4, this.length), (this[offset] | this[offset + 1] << 8 | this[offset + 2] << 16) + 16777216 * this[offset + 3];
            }, Buffer.prototype.readUint32BE = Buffer.prototype.readUInt32BE = function readUInt32BE(offset, noAssert) {
                return offset >>>= 0, noAssert || checkOffset(offset, 4, this.length), 16777216 * this[offset] + (this[offset + 1] << 16 | this[offset + 2] << 8 | this[offset + 3]);
            }, Buffer.prototype.readBigUInt64LE = defineBigIntMethod((function readBigUInt64LE(offset) {
                validateNumber(offset >>>= 0, "offset");
                const first = this[offset], last = this[offset + 7];
                void 0 !== first && void 0 !== last || boundsError(offset, this.length - 8);
                const lo = first + 256 * this[++offset] + 65536 * this[++offset] + this[++offset] * 2 ** 24, hi = this[++offset] + 256 * this[++offset] + 65536 * this[++offset] + last * 2 ** 24;
                return BigInt(lo) + (BigInt(hi) << BigInt(32));
            })), Buffer.prototype.readBigUInt64BE = defineBigIntMethod((function readBigUInt64BE(offset) {
                validateNumber(offset >>>= 0, "offset");
                const first = this[offset], last = this[offset + 7];
                void 0 !== first && void 0 !== last || boundsError(offset, this.length - 8);
                const hi = first * 2 ** 24 + 65536 * this[++offset] + 256 * this[++offset] + this[++offset], lo = this[++offset] * 2 ** 24 + 65536 * this[++offset] + 256 * this[++offset] + last;
                return (BigInt(hi) << BigInt(32)) + BigInt(lo);
            })), Buffer.prototype.readIntLE = function readIntLE(offset, byteLength, noAssert) {
                offset >>>= 0, byteLength >>>= 0, noAssert || checkOffset(offset, byteLength, this.length);
                let val = this[offset], mul = 1, i = 0;
                for (;++i < byteLength && (mul *= 256); ) val += this[offset + i] * mul;
                return mul *= 128, val >= mul && (val -= Math.pow(2, 8 * byteLength)), val;
            }, Buffer.prototype.readIntBE = function readIntBE(offset, byteLength, noAssert) {
                offset >>>= 0, byteLength >>>= 0, noAssert || checkOffset(offset, byteLength, this.length);
                let i = byteLength, mul = 1, val = this[offset + --i];
                for (;i > 0 && (mul *= 256); ) val += this[offset + --i] * mul;
                return mul *= 128, val >= mul && (val -= Math.pow(2, 8 * byteLength)), val;
            }, Buffer.prototype.readInt8 = function readInt8(offset, noAssert) {
                return offset >>>= 0, noAssert || checkOffset(offset, 1, this.length), 128 & this[offset] ? -1 * (255 - this[offset] + 1) : this[offset];
            }, Buffer.prototype.readInt16LE = function readInt16LE(offset, noAssert) {
                offset >>>= 0, noAssert || checkOffset(offset, 2, this.length);
                const val = this[offset] | this[offset + 1] << 8;
                return 32768 & val ? 4294901760 | val : val;
            }, Buffer.prototype.readInt16BE = function readInt16BE(offset, noAssert) {
                offset >>>= 0, noAssert || checkOffset(offset, 2, this.length);
                const val = this[offset + 1] | this[offset] << 8;
                return 32768 & val ? 4294901760 | val : val;
            }, Buffer.prototype.readInt32LE = function readInt32LE(offset, noAssert) {
                return offset >>>= 0, noAssert || checkOffset(offset, 4, this.length), this[offset] | this[offset + 1] << 8 | this[offset + 2] << 16 | this[offset + 3] << 24;
            }, Buffer.prototype.readInt32BE = function readInt32BE(offset, noAssert) {
                return offset >>>= 0, noAssert || checkOffset(offset, 4, this.length), this[offset] << 24 | this[offset + 1] << 16 | this[offset + 2] << 8 | this[offset + 3];
            }, Buffer.prototype.readBigInt64LE = defineBigIntMethod((function readBigInt64LE(offset) {
                validateNumber(offset >>>= 0, "offset");
                const first = this[offset], last = this[offset + 7];
                void 0 !== first && void 0 !== last || boundsError(offset, this.length - 8);
                const val = this[offset + 4] + 256 * this[offset + 5] + 65536 * this[offset + 6] + (last << 24);
                return (BigInt(val) << BigInt(32)) + BigInt(first + 256 * this[++offset] + 65536 * this[++offset] + this[++offset] * 2 ** 24);
            })), Buffer.prototype.readBigInt64BE = defineBigIntMethod((function readBigInt64BE(offset) {
                validateNumber(offset >>>= 0, "offset");
                const first = this[offset], last = this[offset + 7];
                void 0 !== first && void 0 !== last || boundsError(offset, this.length - 8);
                const val = (first << 24) + 65536 * this[++offset] + 256 * this[++offset] + this[++offset];
                return (BigInt(val) << BigInt(32)) + BigInt(this[++offset] * 2 ** 24 + 65536 * this[++offset] + 256 * this[++offset] + last);
            })), Buffer.prototype.readFloatLE = function readFloatLE(offset, noAssert) {
                return offset >>>= 0, noAssert || checkOffset(offset, 4, this.length), ieee754.read(this, offset, !0, 23, 4);
            }, Buffer.prototype.readFloatBE = function readFloatBE(offset, noAssert) {
                return offset >>>= 0, noAssert || checkOffset(offset, 4, this.length), ieee754.read(this, offset, !1, 23, 4);
            }, Buffer.prototype.readDoubleLE = function readDoubleLE(offset, noAssert) {
                return offset >>>= 0, noAssert || checkOffset(offset, 8, this.length), ieee754.read(this, offset, !0, 52, 8);
            }, Buffer.prototype.readDoubleBE = function readDoubleBE(offset, noAssert) {
                return offset >>>= 0, noAssert || checkOffset(offset, 8, this.length), ieee754.read(this, offset, !1, 52, 8);
            }, Buffer.prototype.writeUintLE = Buffer.prototype.writeUIntLE = function writeUIntLE(value, offset, byteLength, noAssert) {
                if (value = +value, offset >>>= 0, byteLength >>>= 0, !noAssert) {
                    checkInt(this, value, offset, byteLength, Math.pow(2, 8 * byteLength) - 1, 0);
                }
                let mul = 1, i = 0;
                for (this[offset] = 255 & value; ++i < byteLength && (mul *= 256); ) this[offset + i] = value / mul & 255;
                return offset + byteLength;
            }, Buffer.prototype.writeUintBE = Buffer.prototype.writeUIntBE = function writeUIntBE(value, offset, byteLength, noAssert) {
                if (value = +value, offset >>>= 0, byteLength >>>= 0, !noAssert) {
                    checkInt(this, value, offset, byteLength, Math.pow(2, 8 * byteLength) - 1, 0);
                }
                let i = byteLength - 1, mul = 1;
                for (this[offset + i] = 255 & value; --i >= 0 && (mul *= 256); ) this[offset + i] = value / mul & 255;
                return offset + byteLength;
            }, Buffer.prototype.writeUint8 = Buffer.prototype.writeUInt8 = function writeUInt8(value, offset, noAssert) {
                return value = +value, offset >>>= 0, noAssert || checkInt(this, value, offset, 1, 255, 0), 
                this[offset] = 255 & value, offset + 1;
            }, Buffer.prototype.writeUint16LE = Buffer.prototype.writeUInt16LE = function writeUInt16LE(value, offset, noAssert) {
                return value = +value, offset >>>= 0, noAssert || checkInt(this, value, offset, 2, 65535, 0), 
                this[offset] = 255 & value, this[offset + 1] = value >>> 8, offset + 2;
            }, Buffer.prototype.writeUint16BE = Buffer.prototype.writeUInt16BE = function writeUInt16BE(value, offset, noAssert) {
                return value = +value, offset >>>= 0, noAssert || checkInt(this, value, offset, 2, 65535, 0), 
                this[offset] = value >>> 8, this[offset + 1] = 255 & value, offset + 2;
            }, Buffer.prototype.writeUint32LE = Buffer.prototype.writeUInt32LE = function writeUInt32LE(value, offset, noAssert) {
                return value = +value, offset >>>= 0, noAssert || checkInt(this, value, offset, 4, 4294967295, 0), 
                this[offset + 3] = value >>> 24, this[offset + 2] = value >>> 16, this[offset + 1] = value >>> 8, 
                this[offset] = 255 & value, offset + 4;
            }, Buffer.prototype.writeUint32BE = Buffer.prototype.writeUInt32BE = function writeUInt32BE(value, offset, noAssert) {
                return value = +value, offset >>>= 0, noAssert || checkInt(this, value, offset, 4, 4294967295, 0), 
                this[offset] = value >>> 24, this[offset + 1] = value >>> 16, this[offset + 2] = value >>> 8, 
                this[offset + 3] = 255 & value, offset + 4;
            }, Buffer.prototype.writeBigUInt64LE = defineBigIntMethod((function writeBigUInt64LE(value, offset = 0) {
                return wrtBigUInt64LE(this, value, offset, BigInt(0), BigInt("0xffffffffffffffff"));
            })), Buffer.prototype.writeBigUInt64BE = defineBigIntMethod((function writeBigUInt64BE(value, offset = 0) {
                return wrtBigUInt64BE(this, value, offset, BigInt(0), BigInt("0xffffffffffffffff"));
            })), Buffer.prototype.writeIntLE = function writeIntLE(value, offset, byteLength, noAssert) {
                if (value = +value, offset >>>= 0, !noAssert) {
                    const limit = Math.pow(2, 8 * byteLength - 1);
                    checkInt(this, value, offset, byteLength, limit - 1, -limit);
                }
                let i = 0, mul = 1, sub = 0;
                for (this[offset] = 255 & value; ++i < byteLength && (mul *= 256); ) value < 0 && 0 === sub && 0 !== this[offset + i - 1] && (sub = 1), 
                this[offset + i] = (value / mul | 0) - sub & 255;
                return offset + byteLength;
            }, Buffer.prototype.writeIntBE = function writeIntBE(value, offset, byteLength, noAssert) {
                if (value = +value, offset >>>= 0, !noAssert) {
                    const limit = Math.pow(2, 8 * byteLength - 1);
                    checkInt(this, value, offset, byteLength, limit - 1, -limit);
                }
                let i = byteLength - 1, mul = 1, sub = 0;
                for (this[offset + i] = 255 & value; --i >= 0 && (mul *= 256); ) value < 0 && 0 === sub && 0 !== this[offset + i + 1] && (sub = 1), 
                this[offset + i] = (value / mul | 0) - sub & 255;
                return offset + byteLength;
            }, Buffer.prototype.writeInt8 = function writeInt8(value, offset, noAssert) {
                return value = +value, offset >>>= 0, noAssert || checkInt(this, value, offset, 1, 127, -128), 
                value < 0 && (value = 255 + value + 1), this[offset] = 255 & value, offset + 1;
            }, Buffer.prototype.writeInt16LE = function writeInt16LE(value, offset, noAssert) {
                return value = +value, offset >>>= 0, noAssert || checkInt(this, value, offset, 2, 32767, -32768), 
                this[offset] = 255 & value, this[offset + 1] = value >>> 8, offset + 2;
            }, Buffer.prototype.writeInt16BE = function writeInt16BE(value, offset, noAssert) {
                return value = +value, offset >>>= 0, noAssert || checkInt(this, value, offset, 2, 32767, -32768), 
                this[offset] = value >>> 8, this[offset + 1] = 255 & value, offset + 2;
            }, Buffer.prototype.writeInt32LE = function writeInt32LE(value, offset, noAssert) {
                return value = +value, offset >>>= 0, noAssert || checkInt(this, value, offset, 4, 2147483647, -2147483648), 
                this[offset] = 255 & value, this[offset + 1] = value >>> 8, this[offset + 2] = value >>> 16, 
                this[offset + 3] = value >>> 24, offset + 4;
            }, Buffer.prototype.writeInt32BE = function writeInt32BE(value, offset, noAssert) {
                return value = +value, offset >>>= 0, noAssert || checkInt(this, value, offset, 4, 2147483647, -2147483648), 
                value < 0 && (value = 4294967295 + value + 1), this[offset] = value >>> 24, this[offset + 1] = value >>> 16, 
                this[offset + 2] = value >>> 8, this[offset + 3] = 255 & value, offset + 4;
            }, Buffer.prototype.writeBigInt64LE = defineBigIntMethod((function writeBigInt64LE(value, offset = 0) {
                return wrtBigUInt64LE(this, value, offset, -BigInt("0x8000000000000000"), BigInt("0x7fffffffffffffff"));
            })), Buffer.prototype.writeBigInt64BE = defineBigIntMethod((function writeBigInt64BE(value, offset = 0) {
                return wrtBigUInt64BE(this, value, offset, -BigInt("0x8000000000000000"), BigInt("0x7fffffffffffffff"));
            })), Buffer.prototype.writeFloatLE = function writeFloatLE(value, offset, noAssert) {
                return writeFloat(this, value, offset, !0, noAssert);
            }, Buffer.prototype.writeFloatBE = function writeFloatBE(value, offset, noAssert) {
                return writeFloat(this, value, offset, !1, noAssert);
            }, Buffer.prototype.writeDoubleLE = function writeDoubleLE(value, offset, noAssert) {
                return writeDouble(this, value, offset, !0, noAssert);
            }, Buffer.prototype.writeDoubleBE = function writeDoubleBE(value, offset, noAssert) {
                return writeDouble(this, value, offset, !1, noAssert);
            }, Buffer.prototype.copy = function copy(target, targetStart, start, end) {
                if (!Buffer.isBuffer(target)) throw new TypeError("argument should be a Buffer");
                if (start || (start = 0), end || 0 === end || (end = this.length), targetStart >= target.length && (targetStart = target.length), 
                targetStart || (targetStart = 0), end > 0 && end < start && (end = start), end === start) return 0;
                if (0 === target.length || 0 === this.length) return 0;
                if (targetStart < 0) throw new RangeError("targetStart out of bounds");
                if (start < 0 || start >= this.length) throw new RangeError("Index out of range");
                if (end < 0) throw new RangeError("sourceEnd out of bounds");
                end > this.length && (end = this.length), target.length - targetStart < end - start && (end = target.length - targetStart + start);
                const len = end - start;
                return this === target && "function" == typeof Uint8Array.prototype.copyWithin ? this.copyWithin(targetStart, start, end) : Uint8Array.prototype.set.call(target, this.subarray(start, end), targetStart), 
                len;
            }, Buffer.prototype.fill = function fill(val, start, end, encoding) {
                if ("string" == typeof val) {
                    if ("string" == typeof start ? (encoding = start, start = 0, end = this.length) : "string" == typeof end && (encoding = end, 
                    end = this.length), void 0 !== encoding && "string" != typeof encoding) throw new TypeError("encoding must be a string");
                    if ("string" == typeof encoding && !Buffer.isEncoding(encoding)) throw new TypeError("Unknown encoding: " + encoding);
                    if (1 === val.length) {
                        const code = val.charCodeAt(0);
                        ("utf8" === encoding && code < 128 || "latin1" === encoding) && (val = code);
                    }
                } else "number" == typeof val ? val &= 255 : "boolean" == typeof val && (val = Number(val));
                if (start < 0 || this.length < start || this.length < end) throw new RangeError("Out of range index");
                if (end <= start) return this;
                let i;
                if (start >>>= 0, end = void 0 === end ? this.length : end >>> 0, val || (val = 0), 
                "number" == typeof val) for (i = start; i < end; ++i) this[i] = val; else {
                    const bytes = Buffer.isBuffer(val) ? val : Buffer.from(val, encoding), len = bytes.length;
                    if (0 === len) throw new TypeError('The value "' + val + '" is invalid for argument "value"');
                    for (i = 0; i < end - start; ++i) this[i + start] = bytes[i % len];
                }
                return this;
            };
            const errors = {};
            function E(sym, getMessage, Base) {
                errors[sym] = class NodeError extends Base {
                    constructor() {
                        super(), Object.defineProperty(this, "message", {
                            value: getMessage.apply(this, arguments),
                            writable: !0,
                            configurable: !0
                        }), this.name = `${this.name} [${sym}]`, this.stack, delete this.name;
                    }
                    get code() {
                        return sym;
                    }
                    set code(value) {
                        Object.defineProperty(this, "code", {
                            configurable: !0,
                            enumerable: !0,
                            value,
                            writable: !0
                        });
                    }
                    toString() {
                        return `${this.name} [${sym}]: ${this.message}`;
                    }
                };
            }
            function addNumericalSeparator(val) {
                let res = "", i = val.length;
                const start = "-" === val[0] ? 1 : 0;
                for (;i >= start + 4; i -= 3) res = `_${val.slice(i - 3, i)}${res}`;
                return `${val.slice(0, i)}${res}`;
            }
            function checkIntBI(value, min, max, buf, offset, byteLength) {
                if (value > max || value < min) {
                    const n = "bigint" == typeof min ? "n" : "";
                    let range;
                    throw range = byteLength > 3 ? 0 === min || min === BigInt(0) ? `>= 0${n} and < 2${n} ** ${8 * (byteLength + 1)}${n}` : `>= -(2${n} ** ${8 * (byteLength + 1) - 1}${n}) and < 2 ** ${8 * (byteLength + 1) - 1}${n}` : `>= ${min}${n} and <= ${max}${n}`, 
                    new errors.ERR_OUT_OF_RANGE("value", range, value);
                }
                !function checkBounds(buf, offset, byteLength) {
                    validateNumber(offset, "offset"), void 0 !== buf[offset] && void 0 !== buf[offset + byteLength] || boundsError(offset, buf.length - (byteLength + 1));
                }(buf, offset, byteLength);
            }
            function validateNumber(value, name) {
                if ("number" != typeof value) throw new errors.ERR_INVALID_ARG_TYPE(name, "number", value);
            }
            function boundsError(value, length, type) {
                if (Math.floor(value) !== value) throw validateNumber(value, type), new errors.ERR_OUT_OF_RANGE(type || "offset", "an integer", value);
                if (length < 0) throw new errors.ERR_BUFFER_OUT_OF_BOUNDS;
                throw new errors.ERR_OUT_OF_RANGE(type || "offset", `>= ${type ? 1 : 0} and <= ${length}`, value);
            }
            E("ERR_BUFFER_OUT_OF_BOUNDS", (function(name) {
                return name ? `${name} is outside of buffer bounds` : "Attempt to access memory outside buffer bounds";
            }), RangeError), E("ERR_INVALID_ARG_TYPE", (function(name, actual) {
                return `The "${name}" argument must be of type number. Received type ${typeof actual}`;
            }), TypeError), E("ERR_OUT_OF_RANGE", (function(str, range, input) {
                let msg = `The value of "${str}" is out of range.`, received = input;
                return Number.isInteger(input) && Math.abs(input) > 2 ** 32 ? received = addNumericalSeparator(String(input)) : "bigint" == typeof input && (received = String(input), 
                (input > BigInt(2) ** BigInt(32) || input < -(BigInt(2) ** BigInt(32))) && (received = addNumericalSeparator(received)), 
                received += "n"), msg += ` It must be ${range}. Received ${received}`, msg;
            }), RangeError);
            const INVALID_BASE64_RE = /[^+/0-9A-Za-z-_]/g;
            function utf8ToBytes(string, units) {
                let codePoint;
                units = units || 1 / 0;
                const length = string.length;
                let leadSurrogate = null;
                const bytes = [];
                for (let i = 0; i < length; ++i) {
                    if (codePoint = string.charCodeAt(i), codePoint > 55295 && codePoint < 57344) {
                        if (!leadSurrogate) {
                            if (codePoint > 56319) {
                                (units -= 3) > -1 && bytes.push(239, 191, 189);
                                continue;
                            }
                            if (i + 1 === length) {
                                (units -= 3) > -1 && bytes.push(239, 191, 189);
                                continue;
                            }
                            leadSurrogate = codePoint;
                            continue;
                        }
                        if (codePoint < 56320) {
                            (units -= 3) > -1 && bytes.push(239, 191, 189), leadSurrogate = codePoint;
                            continue;
                        }
                        codePoint = 65536 + (leadSurrogate - 55296 << 10 | codePoint - 56320);
                    } else leadSurrogate && (units -= 3) > -1 && bytes.push(239, 191, 189);
                    if (leadSurrogate = null, codePoint < 128) {
                        if ((units -= 1) < 0) break;
                        bytes.push(codePoint);
                    } else if (codePoint < 2048) {
                        if ((units -= 2) < 0) break;
                        bytes.push(codePoint >> 6 | 192, 63 & codePoint | 128);
                    } else if (codePoint < 65536) {
                        if ((units -= 3) < 0) break;
                        bytes.push(codePoint >> 12 | 224, codePoint >> 6 & 63 | 128, 63 & codePoint | 128);
                    } else {
                        if (!(codePoint < 1114112)) throw new Error("Invalid code point");
                        if ((units -= 4) < 0) break;
                        bytes.push(codePoint >> 18 | 240, codePoint >> 12 & 63 | 128, codePoint >> 6 & 63 | 128, 63 & codePoint | 128);
                    }
                }
                return bytes;
            }
            function base64ToBytes(str) {
                return base64.toByteArray(function base64clean(str) {
                    if ((str = (str = str.split("=")[0]).trim().replace(INVALID_BASE64_RE, "")).length < 2) return "";
                    for (;str.length % 4 != 0; ) str += "=";
                    return str;
                }(str));
            }
            function blitBuffer(src, dst, offset, length) {
                let i;
                for (i = 0; i < length && !(i + offset >= dst.length || i >= src.length); ++i) dst[i + offset] = src[i];
                return i;
            }
            function isInstance(obj, type) {
                return obj instanceof type || null != obj && null != obj.constructor && null != obj.constructor.name && obj.constructor.name === type.name;
            }
            function numberIsNaN(obj) {
                return obj != obj;
            }
            const hexSliceLookupTable = function() {
                const table = new Array(256);
                for (let i = 0; i < 16; ++i) {
                    const i16 = 16 * i;
                    for (let j = 0; j < 16; ++j) table[i16 + j] = "0123456789abcdef"[i] + "0123456789abcdef"[j];
                }
                return table;
            }();
            function defineBigIntMethod(fn) {
                return "undefined" == typeof BigInt ? BufferBigIntNotDefined : fn;
            }
            function BufferBigIntNotDefined() {
                throw new Error("BigInt not supported");
            }
        },
        645: function(__unused_webpack_module, exports) {
            exports.read = function(buffer, offset, isLE, mLen, nBytes) {
                var e, m, eLen = 8 * nBytes - mLen - 1, eMax = (1 << eLen) - 1, eBias = eMax >> 1, nBits = -7, i = isLE ? nBytes - 1 : 0, d = isLE ? -1 : 1, s = buffer[offset + i];
                for (i += d, e = s & (1 << -nBits) - 1, s >>= -nBits, nBits += eLen; nBits > 0; e = 256 * e + buffer[offset + i], 
                i += d, nBits -= 8) ;
                for (m = e & (1 << -nBits) - 1, e >>= -nBits, nBits += mLen; nBits > 0; m = 256 * m + buffer[offset + i], 
                i += d, nBits -= 8) ;
                if (0 === e) e = 1 - eBias; else {
                    if (e === eMax) return m ? NaN : 1 / 0 * (s ? -1 : 1);
                    m += Math.pow(2, mLen), e -= eBias;
                }
                return (s ? -1 : 1) * m * Math.pow(2, e - mLen);
            }, exports.write = function(buffer, value, offset, isLE, mLen, nBytes) {
                var e, m, c, eLen = 8 * nBytes - mLen - 1, eMax = (1 << eLen) - 1, eBias = eMax >> 1, rt = 23 === mLen ? Math.pow(2, -24) - Math.pow(2, -77) : 0, i = isLE ? 0 : nBytes - 1, d = isLE ? 1 : -1, s = value < 0 || 0 === value && 1 / value < 0 ? 1 : 0;
                for (value = Math.abs(value), isNaN(value) || value === 1 / 0 ? (m = isNaN(value) ? 1 : 0, 
                e = eMax) : (e = Math.floor(Math.log(value) / Math.LN2), value * (c = Math.pow(2, -e)) < 1 && (e--, 
                c *= 2), (value += e + eBias >= 1 ? rt / c : rt * Math.pow(2, 1 - eBias)) * c >= 2 && (e++, 
                c /= 2), e + eBias >= eMax ? (m = 0, e = eMax) : e + eBias >= 1 ? (m = (value * c - 1) * Math.pow(2, mLen), 
                e += eBias) : (m = value * Math.pow(2, eBias - 1) * Math.pow(2, mLen), e = 0)); mLen >= 8; buffer[offset + i] = 255 & m, 
                i += d, m /= 256, mLen -= 8) ;
                for (e = e << mLen | m, eLen += mLen; eLen > 0; buffer[offset + i] = 255 & e, i += d, 
                e /= 256, eLen -= 8) ;
                buffer[offset + i - d] |= 128 * s;
            };
        },
        7910: function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {
            "use strict";
            __webpack_require__.d(__webpack_exports__, {
                Fw: function() {
                    return searchTreeItem;
                },
                tm: function() {
                    return convertToFunction;
                },
                xj: function() {
                    return rotatePoint;
                }
            });
            var _mks_utils_lib_geometry_point__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(8900), _mks_utils_lib_utils_list__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(2940);
            function rotatePoint(point, angle, center) {
                const x = center.x + (point.x - center.x) * Math.cos(angle) - (point.y - center.y) * Math.sin(angle), y = center.y + (point.y - center.y) * Math.cos(angle) + (point.x - center.x) * Math.sin(angle);
                return new _mks_utils_lib_geometry_point__WEBPACK_IMPORTED_MODULE_0__.Point(x, y);
            }
            class SearchTreeItemResult {
                constructor(parentList, itemIndex, item) {
                    this.parentList = parentList, this.itemIndex = itemIndex, this.item = item;
                }
            }
            function searchTreeItem(items, comparer) {
                return _mks_utils_lib_utils_list__WEBPACK_IMPORTED_MODULE_1__.ListUtils.unsafeAnyOf(items, ((item, index) => {
                    if (comparer(item)) return new SearchTreeItemResult(items, index, item);
                    if (item.items) {
                        const res = searchTreeItem(item.items, comparer);
                        if (res) return res;
                    }
                    return null;
                }));
            }
            function convertToFunction(func) {
                const type = typeof func;
                if ("function" == type) return func;
                if ("string" == type) {
                    let funcName = func.trim();
                    if (/^\b\w+?\b$/.test(funcName) && /^[^0-9]/.test(funcName)) try {
                        const handler = eval(funcName);
                        if ("function" == typeof handler) return handler;
                    } catch (e) {}
                    let text = funcName;
                    0 != text.indexOf("function") && (text = `function(s, e){${text}}`);
                    let result = null;
                    try {
                        result = eval(`(${text})`);
                    } catch (_e) {
                        return console.error(`Parse error: ${func}`), null;
                    }
                    return result;
                }
                return null;
            }
        }
    }, __webpack_module_cache__ = {};
    function __webpack_require__(moduleId) {
        var cachedModule = __webpack_module_cache__[moduleId];
        if (void 0 !== cachedModule) return cachedModule.exports;
        var module = __webpack_module_cache__[moduleId] = {
            exports: {}
        };
        return __webpack_modules__[moduleId](module, module.exports, __webpack_require__), 
        module.exports;
    }
    __webpack_require__.n = function(module) {
        var getter = module && module.__esModule ? function() {
            return module.default;
        } : function() {
            return module;
        };
        return __webpack_require__.d(getter, {
            a: getter
        }), getter;
    }, __webpack_require__.d = function(exports, definition) {
        for (var key in definition) __webpack_require__.o(definition, key) && !__webpack_require__.o(exports, key) && Object.defineProperty(exports, key, {
            enumerable: !0,
            get: definition[key]
        });
    }, __webpack_require__.o = function(obj, prop) {
        return Object.prototype.hasOwnProperty.call(obj, prop);
    }, __webpack_require__.r = function(exports) {
        "undefined" != typeof Symbol && Symbol.toStringTag && Object.defineProperty(exports, Symbol.toStringTag, {
            value: "Module"
        }), Object.defineProperty(exports, "__esModule", {
            value: !0
        });
    };
    var __webpack_exports__ = {};
    !function() {
        "use strict";
        var events_namespaceObject = {};
        __webpack_require__.r(events_namespaceObject), __webpack_require__.d(events_namespaceObject, {
            ActiveSubDocumentChangedEvent: function() {
                return ActiveSubDocumentChangedEvent;
            },
            AutoCorrectEvent: function() {
                return AutoCorrectEvent;
            },
            AutoCorrectEventArgs: function() {
                return AutoCorrectEventArgs;
            },
            CalculateDocumentVariableAsyncEvent: function() {
                return CalculateDocumentVariableAsyncEvent;
            },
            CalculateDocumentVariableEvent: function() {
                return CalculateDocumentVariableEvent;
            },
            CalculateDocumentVariableEventArgs: function() {
                return CalculateDocumentVariableEventArgs;
            },
            CharacterPropertiesChangedEvent: function() {
                return CharacterPropertiesChangedEvent;
            },
            CommandStateChangedEvent: function() {
                return CommandStateChangedEvent;
            },
            CommandStateChangedEventArgs: function() {
                return CommandStateChangedEventArgs;
            },
            ContentChangedEventArgs: function() {
                return ContentChangedEventArgs;
            },
            ContentInsertedEvent: function() {
                return ContentInsertedEvent;
            },
            ContentRemovedEvent: function() {
                return ContentRemovedEvent;
            },
            ContentRemovedEventArgs: function() {
                return ContentRemovedEventArgs;
            },
            ContextMenuShowingEvent: function() {
                return ContextMenuShowingEvent;
            },
            ContextMenuShowingEventArgs: function() {
                return ContextMenuShowingEventArgs;
            },
            CustomCommandExecutedEvent: function() {
                return CustomCommandExecutedEvent;
            },
            CustomCommandExecutedEventArgs: function() {
                return CustomCommandExecutedEventArgs;
            },
            DocumentChangedEvent: function() {
                return DocumentChangedEvent;
            },
            DocumentFormattedEvent: function() {
                return DocumentFormattedEvent;
            },
            DocumentFormattedEventArgs: function() {
                return DocumentFormattedEventArgs;
            },
            DocumentLinkType: function() {
                return DocumentLinkType;
            },
            DocumentLoadedEvent: function() {
                return DocumentLoadedEvent;
            },
            Event: function() {
                return Event;
            },
            EventArgs: function() {
                return EventArgs;
            },
            GotFocusEvent: function() {
                return GotFocusEvent;
            },
            HyperlinkClickEvent: function() {
                return HyperlinkClickEvent;
            },
            HyperlinkClickEventArgs: function() {
                return HyperlinkClickEventArgs;
            },
            KeyDownEvent: function() {
                return KeyDownEvent;
            },
            KeyUpEvent: function() {
                return KeyUpEvent;
            },
            KeyboardEventArgs: function() {
                return KeyboardEventArgs;
            },
            LostFocusEvent: function() {
                return LostFocusEvent;
            },
            ParagraphPropertiesChangedEvent: function() {
                return ParagraphPropertiesChangedEvent;
            },
            ParagraphPropertiesChangedEventArgs: function() {
                return ParagraphPropertiesChangedEventArgs;
            },
            PdfExportedEvent: function() {
                return PdfExportedEvent;
            },
            PdfExportedEventArgs: function() {
                return PdfExportedEventArgs;
            },
            PdfExportingEvent: function() {
                return PdfExportingEvent;
            },
            PdfExportingEventArgs: function() {
                return PdfExportingEventArgs;
            },
            PointerDownEvent: function() {
                return PointerDownEvent;
            },
            PointerEventArgs: function() {
                return PointerEventArgs;
            },
            PointerUpEvent: function() {
                return PointerUpEvent;
            },
            RichEditEvent: function() {
                return RichEditEvent;
            },
            SavedEvent: function() {
                return SavedEvent;
            },
            SavedEventArgs: function() {
                return SavedEventArgs;
            },
            SavingEvent: function() {
                return SavingEvent;
            },
            SavingEventArgs: function() {
                return SavingEventArgs;
            },
            SelectionChangedEvent: function() {
                return SelectionChangedEvent;
            }
        });
        var rich_edit_namespaceObject = {};
        __webpack_require__.r(rich_edit_namespaceObject), __webpack_require__.d(rich_edit_namespaceObject, {
            AuthenticationOptions: function() {
                return AuthenticationOptionsApi;
            },
            Bookmark: function() {
                return BookmarkApi;
            },
            BookmarkBase: function() {
                return BookmarkBaseApi;
            },
            BookmarkCollectionBase: function() {
                return BookmarkCollectionBaseApi;
            },
            CharacterProperties: function() {
                return CharacterPropertiesApi;
            },
            CharacterPropertiesScript: function() {
                return CharacterPropertiesScriptApi;
            },
            Characters: function() {
                return characters_Characters;
            },
            ContextMenuCommandId: function() {
                return ContextMenuCommandId;
            },
            ContextMenuItem: function() {
                return ContextMenuItem;
            },
            DocumentFormat: function() {
                return DocumentFormatApi;
            },
            DocumentProcessor: function() {
                return DocumentProcessorApi;
            },
            DocumentProcessorBase: function() {
                return DocumentProcessorBaseApi;
            },
            Events: function() {
                return Events;
            },
            Field: function() {
                return FieldApi;
            },
            FieldName: function() {
                return FieldNameApi;
            },
            FileTabCommandId: function() {
                return FileTabCommandId;
            },
            FloatingImage: function() {
                return FloatingImageApi;
            },
            FloatingObjectHorizontalAlignment: function() {
                return FloatingObjectHorizontalAlignmentApi;
            },
            FloatingObjectHorizontalAnchorElement: function() {
                return FloatingObjectHorizontalAnchorElementApi;
            },
            FloatingObjectHorizontalPositionType: function() {
                return FloatingObjectHorizontalPositionTypeApi;
            },
            FloatingObjectVerticalAlignment: function() {
                return FloatingObjectVerticalAlignmentApi;
            },
            FloatingObjectVerticalAnchorElement: function() {
                return FloatingObjectVerticalAnchorElementApi;
            },
            FloatingObjectVerticalPositionType: function() {
                return FloatingObjectVerticalPositionTypeApi;
            },
            FloatingObjectsFormatTabCommandId: function() {
                return FloatingObjectsFormatTabCommandId;
            },
            Font: function() {
                return ModelFontApi;
            },
            HeaderAndFooterTabCommandId: function() {
                return HeaderAndFooterTabCommandId;
            },
            HeaderFooterType: function() {
                return HeaderFooterTypeApi;
            },
            HomeTabCommandId: function() {
                return HomeTabCommandId;
            },
            HorizontalAbsolutePosition: function() {
                return HorizontalAbsolutePositionApi;
            },
            HorizontalAlignedPosition: function() {
                return HorizontalAlignedPositionApi;
            },
            HorizontalRelativePosition: function() {
                return HorizontalRelativePositionApi;
            },
            Hyperlink: function() {
                return HyperlinkApi;
            },
            HyperlinkInfo: function() {
                return HyperlinkInfoApi;
            },
            Image: function() {
                return ImageApi;
            },
            ImageIterator: function() {
                return ImageIteratorApi;
            },
            Images: function() {
                return ImagesApi;
            },
            InlineImage: function() {
                return InlineImageApi;
            },
            InsertTabCommandId: function() {
                return InsertTabCommandId;
            },
            Interval: function() {
                return IntervalApi;
            },
            KeyCode: function() {
                return KeyCode;
            },
            List: function() {
                return ListApi;
            },
            ListLevelFormat: function() {
                return ListLevelFormatApi;
            },
            ListLevelNumberAlignment: function() {
                return ListLevelNumberAlignmentApi;
            },
            ListLevelSettings: function() {
                return ListLevelSettingsApi;
            },
            ListType: function() {
                return ListTypeApi;
            },
            LoadingPanel: function() {
                return LoadingPanelApi;
            },
            MailMergeOptions: function() {
                return MailMergeOptionsApi;
            },
            MailMergeTabCommandId: function() {
                return MailMergeTabCommandId;
            },
            Margins: function() {
                return MarginsApi;
            },
            MergeMode: function() {
                return rich_edit_MergeMode;
            },
            Paddings: function() {
                return Paddings;
            },
            PageLayoutTabCommandId: function() {
                return PageLayoutTabCommandId;
            },
            PaperSize: function() {
                return PaperSizeApi;
            },
            Paragraph: function() {
                return ParagraphApi;
            },
            ParagraphAlignment: function() {
                return ParagraphAlignmentApi;
            },
            ParagraphFirstLineIndent: function() {
                return ParagraphFirstLineIndentApi;
            },
            ParagraphLineSpacingType: function() {
                return ParagraphLineSpacingTypeApi;
            },
            ParagraphProperties: function() {
                return ParagraphPropertiesApi;
            },
            PrintMode: function() {
                return PrintModeApi;
            },
            RangePermission: function() {
                return RangePermissionApi;
            },
            RangePermissionOptions: function() {
                return RangePermissionOptionsApi;
            },
            ReferencesTabCommandId: function() {
                return ReferencesTabCommandId;
            },
            RichEdit: function() {
                return RichEditPublic;
            },
            RichEditDocumentBase: function() {
                return RichEditDocumentApi;
            },
            Section: function() {
                return SectionApi;
            },
            SectionBreakType: function() {
                return SectionBreakTypeApi;
            },
            ShortcutOptions: function() {
                return ShortcutOptions;
            },
            Size: function() {
                return SizeApi;
            },
            SpellCheckerOptions: function() {
                return SpellCheckerOptionsApi;
            },
            SubDocument: function() {
                return SubDocumentApi;
            },
            SubDocumentBase: function() {
                return SubDocumentBaseApi;
            },
            SubDocumentCollectionBase: function() {
                return SubDocumentCollectionBaseApi;
            },
            SubDocumentType: function() {
                return SubDocumentTypeApi;
            },
            Table: function() {
                return TableApi;
            },
            TableCell: function() {
                return TableCellApi;
            },
            TableDesignTabCommandId: function() {
                return TableDesignTabCommandId;
            },
            TableLayoutTabCommandId: function() {
                return TableLayoutTabCommandId;
            },
            TableRow: function() {
                return TableRowApi;
            },
            UpdateFieldsOptions: function() {
                return UpdateFieldsOptionsApi;
            },
            Utils: function() {
                return Utils;
            },
            VerticalAbsolutePosition: function() {
                return VerticalAbsolutePositionApi;
            },
            VerticalAlignedPosition: function() {
                return VerticalAlignedPositionApi;
            },
            VerticalRelativePosition: function() {
                return VerticalRelativePositionApi;
            },
            ViewTabCommandId: function() {
                return ViewTabCommandId;
            },
            ViewType: function() {
                return rich_edit_ViewType;
            },
            WrapSide: function() {
                return WrapSideApi;
            },
            WrapType: function() {
                return WrapTypeApi;
            }
        });
        var IsModified, JSONResponseError, JSONCommandParametersProperty, JSONPropertyStateBasedCommand, JSONInitSessionProperty, JSONResponceLevelProperty, JSONCachesDataProperty, JSONGetRtfCommand, JSONInsertRtfCommand, public_options_namespaceObject = {};
        __webpack_require__.r(public_options_namespaceObject), __webpack_require__.d(public_options_namespaceObject, {
            FileTabItemId: function() {
                return FileTabItemId;
            },
            FloatingObjectsFormatTabItemId: function() {
                return FloatingObjectsFormatTabItemId;
            },
            HeaderAndFooterTabItemId: function() {
                return HeaderAndFooterTabItemId;
            },
            HomeTabItemId: function() {
                return HomeTabItemId;
            },
            InsertTabItemId: function() {
                return InsertTabItemId;
            },
            MailMergeTabItemId: function() {
                return MailMergeTabItemId;
            },
            PageLayoutTabItemId: function() {
                return PageLayoutTabItemId;
            },
            ReferencesTabItemId: function() {
                return ReferencesTabItemId;
            },
            Ribbon: function() {
                return ribbon_Ribbon;
            },
            RibbonButtonItem: function() {
                return RibbonButtonItem;
            },
            RibbonColorBoxItem: function() {
                return RibbonColorBoxItem;
            },
            RibbonContextTab: function() {
                return RibbonContextTab;
            },
            RibbonItemBase: function() {
                return RibbonItemBase;
            },
            RibbonItemType: function() {
                return RibbonItemType;
            },
            RibbonMenuItem: function() {
                return RibbonMenuItem;
            },
            RibbonNumberBoxItem: function() {
                return RibbonNumberBoxItem;
            },
            RibbonSelectBoxItem: function() {
                return RibbonSelectBoxItem;
            },
            RibbonSubMenuItem: function() {
                return RibbonSubMenuItem;
            },
            RibbonTab: function() {
                return RibbonTab;
            },
            RibbonTabType: function() {
                return RibbonTabType;
            },
            RichEditUnit: function() {
                return RichEditUnit;
            },
            TableDesignTabItemId: function() {
                return TableDesignTabItemId;
            },
            TableLayoutTabItemId: function() {
                return TableLayoutTabItemId;
            },
            ViewTabItemId: function() {
                return ViewTabItemId;
            },
            create: function() {
                return create;
            },
            createOptions: function() {
                return createOptions;
            }
        }), function(IsModified) {
            IsModified[IsModified.False = 0] = "False", IsModified[IsModified.True = 1] = "True", 
            IsModified[IsModified.SaveInProgress = 2] = "SaveInProgress";
        }(IsModified || (IsModified = {})), function(JSONResponseError) {
            JSONResponseError[JSONResponseError.NoErrors = 0] = "NoErrors", JSONResponseError[JSONResponseError.ModelIsChanged = 1] = "ModelIsChanged", 
            JSONResponseError[JSONResponseError.InnerException = 2] = "InnerException", JSONResponseError[JSONResponseError.AuthException = 3] = "AuthException", 
            JSONResponseError[JSONResponseError.CantSaveToAlreadyOpenedFile = 4] = "CantSaveToAlreadyOpenedFile", 
            JSONResponseError[JSONResponseError.CantSaveDocument = 5] = "CantSaveDocument", 
            JSONResponseError[JSONResponseError.CantOpenDocument = 6] = "CantOpenDocument", 
            JSONResponseError[JSONResponseError.CalculateDocumentVariableException = 7] = "CalculateDocumentVariableException", 
            JSONResponseError[JSONResponseError.PathTooLongException = 8] = "PathTooLongException", 
            JSONResponseError[JSONResponseError.CantSaveToEmptyPath = 9] = "CantSaveToEmptyPath", 
            JSONResponseError[JSONResponseError.InsertContentFromServerException = 10] = "InsertContentFromServerException", 
            JSONResponseError[JSONResponseError.LoadPictureException = 11] = "LoadPictureException", 
            JSONResponseError[JSONResponseError.SessionHasExpired = 12] = "SessionHasExpired";
        }(JSONResponseError || (JSONResponseError = {})), function(JSONCommandParametersProperty) {
            JSONCommandParametersProperty[JSONCommandParametersProperty.CommandType = 0] = "CommandType", 
            JSONCommandParametersProperty[JSONCommandParametersProperty.IncId = 1] = "IncId", 
            JSONCommandParametersProperty[JSONCommandParametersProperty.ServerParams = 2] = "ServerParams", 
            JSONCommandParametersProperty[JSONCommandParametersProperty.EditIncId = 3] = "EditIncId", 
            JSONCommandParametersProperty[JSONCommandParametersProperty.SubDocumentId = 5] = "SubDocumentId", 
            JSONCommandParametersProperty[JSONCommandParametersProperty.Caches = 6] = "Caches", 
            JSONCommandParametersProperty[JSONCommandParametersProperty.IsNewWorkSession = 7] = "IsNewWorkSession";
        }(JSONCommandParametersProperty || (JSONCommandParametersProperty = {})), function(JSONPropertyStateBasedCommand) {
            JSONPropertyStateBasedCommand[JSONPropertyStateBasedCommand.State = 0] = "State", 
            JSONPropertyStateBasedCommand[JSONPropertyStateBasedCommand.Property = 1] = "Property";
        }(JSONPropertyStateBasedCommand || (JSONPropertyStateBasedCommand = {})), function(JSONInitSessionProperty) {
            JSONInitSessionProperty[JSONInitSessionProperty.IsNewDocument = 0] = "IsNewDocument", 
            JSONInitSessionProperty[JSONInitSessionProperty.SessionGuid = 1] = "SessionGuid", 
            JSONInitSessionProperty[JSONInitSessionProperty.FileName = 2] = "FileName", JSONInitSessionProperty[JSONInitSessionProperty.LastExecutedEditCommandId = 3] = "LastExecutedEditCommandId", 
            JSONInitSessionProperty[JSONInitSessionProperty.SubDocumentsCounter = 5] = "SubDocumentsCounter", 
            JSONInitSessionProperty[JSONInitSessionProperty.IsModified = 6] = "IsModified", 
            JSONInitSessionProperty[JSONInitSessionProperty.InvalidDocument = 7] = "InvalidDocument", 
            JSONInitSessionProperty[JSONInitSessionProperty.Document = 8] = "Document", JSONInitSessionProperty[JSONInitSessionProperty.Caches = 9] = "Caches", 
            JSONInitSessionProperty[JSONInitSessionProperty.Options = 10] = "Options", JSONInitSessionProperty[JSONInitSessionProperty.HistoryId = 11] = "HistoryId", 
            JSONInitSessionProperty[JSONInitSessionProperty.Src = 12] = "Src", JSONInitSessionProperty[JSONInitSessionProperty.FolderPath = 13] = "FolderPath", 
            JSONInitSessionProperty[JSONInitSessionProperty.DocumentFormat = 14] = "DocumentFormat", 
            JSONInitSessionProperty[JSONInitSessionProperty.FirstRecordIndex = 15] = "FirstRecordIndex", 
            JSONInitSessionProperty[JSONInitSessionProperty.LastRecordIndex = 16] = "LastRecordIndex", 
            JSONInitSessionProperty[JSONInitSessionProperty.MergeMode = 17] = "MergeMode", JSONInitSessionProperty[JSONInitSessionProperty.DocumentHasSource = 18] = "DocumentHasSource";
        }(JSONInitSessionProperty || (JSONInitSessionProperty = {})), function(JSONResponceLevelProperty) {
            JSONResponceLevelProperty[JSONResponceLevelProperty.ErrorCode = 0] = "ErrorCode", 
            JSONResponceLevelProperty[JSONResponceLevelProperty.CommandsResults = 1] = "CommandsResults";
        }(JSONResponceLevelProperty || (JSONResponceLevelProperty = {})), function(JSONCachesDataProperty) {
            JSONCachesDataProperty[JSONCachesDataProperty.CharacterPropertiesCache = 0] = "CharacterPropertiesCache", 
            JSONCachesDataProperty[JSONCachesDataProperty.ParagraphPropertiesCache = 1] = "ParagraphPropertiesCache", 
            JSONCachesDataProperty[JSONCachesDataProperty.ListLevelPropertiesCache = 2] = "ListLevelPropertiesCache", 
            JSONCachesDataProperty[JSONCachesDataProperty.TableRowPropertiesCache = 3] = "TableRowPropertiesCache", 
            JSONCachesDataProperty[JSONCachesDataProperty.TableCellPropertiesCache = 4] = "TableCellPropertiesCache", 
            JSONCachesDataProperty[JSONCachesDataProperty.SubDocuments = 5] = "SubDocuments", 
            JSONCachesDataProperty[JSONCachesDataProperty.FontInfoCache = 6] = "FontInfoCache", 
            JSONCachesDataProperty[JSONCachesDataProperty.ColorModelInfoCache = 7] = "ColorModelInfoCache", 
            JSONCachesDataProperty[JSONCachesDataProperty.ShadingInfoCache = 8] = "ShadingInfoCache";
        }(JSONCachesDataProperty || (JSONCachesDataProperty = {})), function(JSONGetRtfCommand) {
            JSONGetRtfCommand[JSONGetRtfCommand.Position = 0] = "Position", JSONGetRtfCommand[JSONGetRtfCommand.Length = 1] = "Length", 
            JSONGetRtfCommand[JSONGetRtfCommand.SubDocumentId = 2] = "SubDocumentId", JSONGetRtfCommand[JSONGetRtfCommand.ResultRtf = 3] = "ResultRtf", 
            JSONGetRtfCommand[JSONGetRtfCommand.Id = 4] = "Id";
        }(JSONGetRtfCommand || (JSONGetRtfCommand = {})), function(JSONInsertRtfCommand) {
            JSONInsertRtfCommand[JSONInsertRtfCommand.RtfText = 0] = "RtfText", JSONInsertRtfCommand[JSONInsertRtfCommand.Result = 1] = "Result", 
            JSONInsertRtfCommand[JSONInsertRtfCommand.Id = 2] = "Id";
        }(JSONInsertRtfCommand || (JSONInsertRtfCommand = {}));
        var unit_converter = __webpack_require__(9291), manager = __webpack_require__(1768), utils_list = __webpack_require__(2940), number = __webpack_require__(1167), search = __webpack_require__(2400), common = __webpack_require__(2491), utils_enum = __webpack_require__(310), math = __webpack_require__(8679), utils_color = __webpack_require__(13);
        class ColorHelper {
            static getPredefinedColor(color) {
                return utils_color.i.fromHashString(color, 0);
            }
            static anyToColor(value, defaultValue) {
                if ((0, common.isNumber)(value) && !isNaN(value)) return value;
                if ("string" == typeof value) {
                    var intValue = parseInt(value);
                    return isNaN(intValue) || value != intValue ? utils_color.i.fromHashString(value) : intValue;
                }
                return defaultValue;
            }
            static getActualForeColor(foreColor, backColor) {
                foreColor == ColorHelper.AUTOMATIC_COLOR && (foreColor = backColor == ColorHelper.AUTOMATIC_COLOR || backColor == ColorHelper.NO_COLOR || ColorHelper.calculateLumaY(backColor) >= ColorHelper.DEFAULT_BOUNDARY_LUMA ? utils_color.i.DARK_COLOR : utils_color.i.LIGHT_COLOR);
                return ColorHelper.getCssString(foreColor, !0);
            }
            static getCssString(color, isAutoColorTranslateToDark) {
                return color == ColorHelper.AUTOMATIC_COLOR ? utils_color.i.colorToHash(isAutoColorTranslateToDark ? utils_color.i.DARK_COLOR : utils_color.i.LIGHT_COLOR) : ColorHelper.getCssStringInternal(color);
            }
            static IsDarkColor(color) {
                return ColorHelper.calculateLumaY(color) < ColorHelper.DEFAULT_BOUNDARY_LUMA;
            }
            static getCssStringInternal(color) {
                switch (utils_color.i.getAlpha(color)) {
                  case 0:
                    return "transparent";

                  case 255:
                    return utils_color.i.colorToHash(color);

                  default:
                    return "rgba(" + utils_color.i.getRed(color) + "," + utils_color.i.getGreen(color) + "," + utils_color.i.getBlue(color) + "," + ColorHelper.getOpacity(color) + ")";
                }
            }
            static getOpacity(color) {
                return utils_color.i.getAlpha(color) / 255;
            }
            static isEmptyBgColor(color) {
                return color === this.AUTOMATIC_COLOR || color === this.NO_COLOR;
            }
            static calculateLumaY(color) {
                return ColorHelper.DEFAULT_BOUNDARY_LUMA_RED * utils_color.i.getRed(color) + ColorHelper.DEFAULT_BOUNDARY_LUMA_GREEN * utils_color.i.getGreen(color) + ColorHelper.DEFAULT_BOUNDARY_LUMA_BLUE * utils_color.i.getBlue(color);
            }
        }
        ColorHelper.DEFAULT_BOUNDARY_LUMA = 3982098.432, ColorHelper.DEFAULT_BOUNDARY_LUMA_RED = 19595.264, 
        ColorHelper.DEFAULT_BOUNDARY_LUMA_BLUE = 7471.104, ColorHelper.DEFAULT_BOUNDARY_LUMA_GREEN = 38469.632, 
        ColorHelper.BLACK_COLOR = -16777216, ColorHelper.AUTOMATIC_COLOR = 0, ColorHelper.NO_COLOR = 16777215;
        var JSONFontInfoProperty, JSONColorModelInfoProperty, JSONCharacterFormattingProperty, JSONLangInfoProperty, JSONCompositeFontInfoProperty, JSONInsertTextCommandProperty, JSONLoadFontInfoCommand, errors = __webpack_require__(7774);
        !function(JSONFontInfoProperty) {
            JSONFontInfoProperty[JSONFontInfoProperty.Name = 0] = "Name", JSONFontInfoProperty[JSONFontInfoProperty.ScriptMultiplier = 1] = "ScriptMultiplier", 
            JSONFontInfoProperty[JSONFontInfoProperty.CssString = 2] = "CssString", JSONFontInfoProperty[JSONFontInfoProperty.CanBeSet = 3] = "CanBeSet", 
            JSONFontInfoProperty[JSONFontInfoProperty.SubScriptOffset = 4] = "SubScriptOffset", 
            JSONFontInfoProperty[JSONFontInfoProperty.FontFamily = 5] = "FontFamily";
        }(JSONFontInfoProperty || (JSONFontInfoProperty = {})), function(JSONColorModelInfoProperty) {
            JSONColorModelInfoProperty[JSONColorModelInfoProperty.ColorType = 0] = "ColorType", 
            JSONColorModelInfoProperty[JSONColorModelInfoProperty.Auto = 1] = "Auto", JSONColorModelInfoProperty[JSONColorModelInfoProperty.ThemeColorIndex = 2] = "ThemeColorIndex", 
            JSONColorModelInfoProperty[JSONColorModelInfoProperty.Tint = 3] = "Tint", JSONColorModelInfoProperty[JSONColorModelInfoProperty.Rgb = 4] = "Rgb", 
            JSONColorModelInfoProperty[JSONColorModelInfoProperty.ColorIndex = 5] = "ColorIndex";
        }(JSONColorModelInfoProperty || (JSONColorModelInfoProperty = {})), function(JSONCharacterFormattingProperty) {
            JSONCharacterFormattingProperty[JSONCharacterFormattingProperty.FontInfoIndex = 0] = "FontInfoIndex", 
            JSONCharacterFormattingProperty[JSONCharacterFormattingProperty.Size = 1] = "Size", 
            JSONCharacterFormattingProperty[JSONCharacterFormattingProperty.Bold = 2] = "Bold", 
            JSONCharacterFormattingProperty[JSONCharacterFormattingProperty.Italic = 3] = "Italic", 
            JSONCharacterFormattingProperty[JSONCharacterFormattingProperty.StrikeoutType = 4] = "StrikeoutType", 
            JSONCharacterFormattingProperty[JSONCharacterFormattingProperty.UnderlineType = 5] = "UnderlineType", 
            JSONCharacterFormattingProperty[JSONCharacterFormattingProperty.AllCaps = 6] = "AllCaps", 
            JSONCharacterFormattingProperty[JSONCharacterFormattingProperty.StrikeoutWordsOnly = 7] = "StrikeoutWordsOnly", 
            JSONCharacterFormattingProperty[JSONCharacterFormattingProperty.UnderlineWordsOnly = 8] = "UnderlineWordsOnly", 
            JSONCharacterFormattingProperty[JSONCharacterFormattingProperty.Script = 9] = "Script", 
            JSONCharacterFormattingProperty[JSONCharacterFormattingProperty.Hidden = 10] = "Hidden", 
            JSONCharacterFormattingProperty[JSONCharacterFormattingProperty.LangInfo = 11] = "LangInfo", 
            JSONCharacterFormattingProperty[JSONCharacterFormattingProperty.NoProof = 12] = "NoProof", 
            JSONCharacterFormattingProperty[JSONCharacterFormattingProperty.UseValue = 13] = "UseValue", 
            JSONCharacterFormattingProperty[JSONCharacterFormattingProperty.FontName = 14] = "FontName", 
            JSONCharacterFormattingProperty[JSONCharacterFormattingProperty.CompositeFontInfo = 15] = "CompositeFontInfo", 
            JSONCharacterFormattingProperty[JSONCharacterFormattingProperty.TextColor = 16] = "TextColor", 
            JSONCharacterFormattingProperty[JSONCharacterFormattingProperty.ShadingInfo = 17] = "ShadingInfo", 
            JSONCharacterFormattingProperty[JSONCharacterFormattingProperty.HighlightColor = 18] = "HighlightColor", 
            JSONCharacterFormattingProperty[JSONCharacterFormattingProperty.UnderlineColor = 19] = "UnderlineColor", 
            JSONCharacterFormattingProperty[JSONCharacterFormattingProperty.StrikeoutColor = 20] = "StrikeoutColor", 
            JSONCharacterFormattingProperty[JSONCharacterFormattingProperty.TextColorIndex = 21] = "TextColorIndex", 
            JSONCharacterFormattingProperty[JSONCharacterFormattingProperty.ShadingInfoIndex = 22] = "ShadingInfoIndex", 
            JSONCharacterFormattingProperty[JSONCharacterFormattingProperty.HighlightColorIndex = 23] = "HighlightColorIndex", 
            JSONCharacterFormattingProperty[JSONCharacterFormattingProperty.UnderlineColorIndex = 24] = "UnderlineColorIndex", 
            JSONCharacterFormattingProperty[JSONCharacterFormattingProperty.StrikeoutColorIndex = 25] = "StrikeoutColorIndex", 
            JSONCharacterFormattingProperty[JSONCharacterFormattingProperty.SmallCaps = 26] = "SmallCaps";
        }(JSONCharacterFormattingProperty || (JSONCharacterFormattingProperty = {})), function(JSONLangInfoProperty) {
            JSONLangInfoProperty[JSONLangInfoProperty.Latin = 0] = "Latin", JSONLangInfoProperty[JSONLangInfoProperty.Bidi = 1] = "Bidi", 
            JSONLangInfoProperty[JSONLangInfoProperty.EastAsia = 2] = "EastAsia";
        }(JSONLangInfoProperty || (JSONLangInfoProperty = {})), function(JSONCompositeFontInfoProperty) {
            JSONCompositeFontInfoProperty[JSONCompositeFontInfoProperty.asciiFontName = 0] = "asciiFontName", 
            JSONCompositeFontInfoProperty[JSONCompositeFontInfoProperty.hightAnsiFontName = 1] = "hightAnsiFontName", 
            JSONCompositeFontInfoProperty[JSONCompositeFontInfoProperty.complexScriptFontName = 2] = "complexScriptFontName", 
            JSONCompositeFontInfoProperty[JSONCompositeFontInfoProperty.eastAsiaFontName = 3] = "eastAsiaFontName", 
            JSONCompositeFontInfoProperty[JSONCompositeFontInfoProperty.asciiThemeFont = 4] = "asciiThemeFont", 
            JSONCompositeFontInfoProperty[JSONCompositeFontInfoProperty.hightAnsiThemeFont = 5] = "hightAnsiThemeFont", 
            JSONCompositeFontInfoProperty[JSONCompositeFontInfoProperty.complexScriptThemeFont = 6] = "complexScriptThemeFont", 
            JSONCompositeFontInfoProperty[JSONCompositeFontInfoProperty.eastAsiaThemeFont = 7] = "eastAsiaThemeFont", 
            JSONCompositeFontInfoProperty[JSONCompositeFontInfoProperty.hintFont = 8] = "hintFont";
        }(JSONCompositeFontInfoProperty || (JSONCompositeFontInfoProperty = {})), function(JSONInsertTextCommandProperty) {
            JSONInsertTextCommandProperty[JSONInsertTextCommandProperty.Text = 0] = "Text", 
            JSONInsertTextCommandProperty[JSONInsertTextCommandProperty.RunType = 1] = "RunType", 
            JSONInsertTextCommandProperty[JSONInsertTextCommandProperty.Length = 2] = "Length", 
            JSONInsertTextCommandProperty[JSONInsertTextCommandProperty.Position = 3] = "Position", 
            JSONInsertTextCommandProperty[JSONInsertTextCommandProperty.CharacterStyleName = 4] = "CharacterStyleName", 
            JSONInsertTextCommandProperty[JSONInsertTextCommandProperty.CharacterPropertiesIndex = 5] = "CharacterPropertiesIndex", 
            JSONInsertTextCommandProperty[JSONInsertTextCommandProperty.CharacterProperties = 6] = "CharacterProperties";
        }(JSONInsertTextCommandProperty || (JSONInsertTextCommandProperty = {})), function(JSONLoadFontInfoCommand) {
            JSONLoadFontInfoCommand[JSONLoadFontInfoCommand.FontInfo = 0] = "FontInfo", JSONLoadFontInfoCommand[JSONLoadFontInfoCommand.FontInfoIndex = 1] = "FontInfoIndex";
        }(JSONLoadFontInfoCommand || (JSONLoadFontInfoCommand = {}));
        var LogSource, string = __webpack_require__(2866);
        !function(LogSource) {
            LogSource[LogSource.Main = 1] = "Main", LogSource[LogSource.RowFormatter = 2] = "RowFormatter", 
            LogSource[LogSource.LayoutFormatter = 3] = "LayoutFormatter", LogSource[LogSource.LayoutFormatterNotifier = 4] = "LayoutFormatterNotifier", 
            LogSource[LogSource.LayoutFormatterInvalidator = 5] = "LayoutFormatterInvalidator", 
            LogSource[LogSource.CanvasManager = 6] = "CanvasManager", LogSource[LogSource.DocumentRenderer = 7] = "DocumentRenderer", 
            LogSource[LogSource.SelectionRenderer = 8] = "SelectionRenderer", LogSource[LogSource.SelectionFormatter = 9] = "SelectionFormatter", 
            LogSource[LogSource.DiplayPageInfo = 10] = "DiplayPageInfo", LogSource[LogSource.DiplayTableBoundsInfo = 11] = "DiplayTableBoundsInfo", 
            LogSource[LogSource.DiplayLayoutBoundsInfo = 12] = "DiplayLayoutBoundsInfo", LogSource[LogSource.RestartManager = 13] = "RestartManager", 
            LogSource[LogSource.BoxWrapHolder = 14] = "BoxWrapHolder", LogSource[LogSource.PositionSaver = 15] = "PositionSaver", 
            LogSource[LogSource.EventManager = 16] = "EventManager", LogSource[LogSource.TableFormatter = 17] = "TableFormatter", 
            LogSource[LogSource.HtmlImporter = 18] = "HtmlImporter", LogSource[LogSource.SimpleViewRenderer = 19] = "SimpleViewRenderer", 
            LogSource[LogSource.DocxImporter = 20] = "DocxImporter";
        }(LogSource || (LogSource = {}));
        class LogSourceParams {
            constructor(enabled, logSource) {
                this.enabled = enabled, this.logSource = logSource, this.name = LogSource[logSource];
            }
            getName() {
                return this.name;
            }
            isEnabled(_functionInfo) {
                return this.enabled;
            }
            setEnabled(isEnable) {
                this.enabled = isEnable;
            }
            handle(_functionInfo, _valOrFunc) {
                return !1;
            }
        }
        class ModelParamsHolder {
            constructor() {
                this.logSourceParams = {}, utils_enum.Y.forEach(LogSource, (keyNum => {
                    this.handle(keyNum);
                }));
            }
            handle(logSourceKey) {
                this.logSourceParams[logSourceKey] = new LogSourceParams(!1, logSourceKey);
            }
        }
        class Logger {
            constructor() {
                this._paramsHolder = new ModelParamsHolder, this._isEnabled = !1, this.isDebug = !1, 
                this.splitBy = ", ", this.SOLID_BLOCK = String.fromCharCode(9608), this.DOUBLE_SOLID_BLOCK = this.SOLID_BLOCK + this.SOLID_BLOCK, 
                this.TRIPLE_SOLID_BLOCK = this.DOUBLE_SOLID_BLOCK + this.SOLID_BLOCK;
            }
            static getInstance() {
                return Logger.instance ? Logger.instance : Logger.instance = new Logger;
            }
            set paramsHolder(val) {
                this._paramsHolder = val;
            }
            get paramsHolder() {
                return this._paramsHolder;
            }
            get logSourceParams() {
                return this._paramsHolder.logSourceParams;
            }
            get isEnabled() {
                return this._isEnabled;
            }
            disableAll() {
                this.isEnabled = !1, number.j.forEach(this.logSourceParams, (param => param.setEnabled(!1)));
            }
            print(logSource, functionInfo, valOrFunc) {
                if (!this._isEnabled) return !1;
                const logSourceParams = this.logSourceParams[logSource];
                logSourceParams ? logSourceParams.isEnabled(functionInfo) && !logSourceParams.handle(functionInfo, valOrFunc) && console.log(`${this.SOLID_BLOCK} ${logSourceParams.getName()} ${functionInfo} ${"function" == typeof valOrFunc ? valOrFunc() : valOrFunc}`) : console.log(`Log.print ${LogSource[logSource]} not defined`);
            }
            flip(func, aArgPos, bArgPos) {
                return (...params) => (params.splice(bArgPos, 1, params.splice(aArgPos, 1, params[bArgPos])[0]), 
                func.apply(func, params));
            }
            w(numFuncParams, func, currParamsStack = []) {
                return (...params) => {
                    const newStack = currParamsStack.concat(0 == params.length ? void 0 : params);
                    return newStack.length >= numFuncParams ? func.apply(func, currParamsStack.concat(params)) : this.w(numFuncParams, func, newStack);
                };
            }
            join(sep, list) {
                return list.join(sep);
            }
            map(func, list) {
                return utils_list.ListUtils.map(list, func);
            }
            mask(objEnum, mask, excessNullValue = Number.MAX_VALUE) {
                let res = [], isFoundNullValue = !1;
                return string.StringMapUtils.forEach(objEnum, ((_t, key) => {
                    const keyNum = parseInt(key);
                    isNaN(keyNum) || (keyNum & mask) != keyNum || (excessNullValue != keyNum ? res.push(objEnum[key]) : isFoundNullValue = !0);
                })), isFoundNullValue && !res.length && res.push(objEnum[excessNullValue]), res.join(this.splitBy);
            }
            set isEnabled(val) {
                this._isEnabled = val;
            }
        }
        const Log = Logger.getInstance();
        class DrawingValueConstants {}
        DrawingValueConstants.ThousandthOfPercentage = 1e5, DrawingValueConstants.MinCoordinate = -27273042329600, 
        DrawingValueConstants.MaxCoordinate = 27273042316900, DrawingValueConstants.OnePositiveFixedAngle = 6e4, 
        DrawingValueConstants.MaxPositiveFixedAngle = 216e5, DrawingValueConstants.MaxFixedAngle = 54e5, 
        DrawingValueConstants.MaxFOVAngle = 108e5, DrawingValueConstants.MaxOutlineWidth = 20116800, 
        DrawingValueConstants.MaxPositiveCoordinate32 = 51206400, DrawingValueConstants.MinTextIndentLevel = -2, 
        DrawingValueConstants.MaxTextIndentLevel = 8, DrawingValueConstants.MaxTextSpacingPercent = 132e5, 
        DrawingValueConstants.MaxTextSpacingPoints = 158400, DrawingValueConstants.MaxStartAtNumValue = 32767, 
        DrawingValueConstants.MinTextBulletSizePercent = 25e3, DrawingValueConstants.MaxTextBulletSizePercent = 4e5, 
        DrawingValueConstants.MinTextBulletSizePoints = 100, DrawingValueConstants.MaxTextBulletSizePoints = 4e5, 
        DrawingValueConstants.MaxWidthInPoints = 1584, DrawingValueConstants.EmusInPoint = 12700;
        class DXColor {
            static isTransparentOrEmpty(color) {
                return null == color || color === DXColor.empty || color === DXColor.transparent;
            }
            static isTransparentOrEmptyorNoColor(color) {
                return color == ColorHelper.NO_COLOR || DXColor.isTransparentOrEmpty(color);
            }
            static isTransparentColor(color) {
                return 0 == utils_color.i.getAlpha(color);
            }
            static isEmpty(color) {
                return null == color || null == color;
            }
            static isSemitransparentColor(color) {
                const alpha = utils_color.i.getAlpha(color);
                return alpha > 0 && alpha < 255;
            }
            static fromArgb(alpha, rgbColor) {
                return alpha << 24 | utils_color.i.getRed(rgbColor) << 16 | utils_color.i.getGreen(rgbColor) << 8 | utils_color.i.getBlue(rgbColor);
            }
            static fromRgb(red, green, blue) {
                return 255 << 24 | red << 16 | green << 8 | blue;
            }
            static fromName(name) {
                const hash = utils_color.i.colorNames[name.toLowerCase()];
                return hash ? utils_color.i.fromHashString(hash) : ColorHelper.AUTOMATIC_COLOR;
            }
            static blend(color, backgroundColor) {
                if (utils_color.i.getAlpha(color) >= 255) return color;
                const alpha = utils_color.i.getAlpha(color) / 255, one_alpha = 1 - alpha;
                return DXColor.fromRgb(Math.floor(utils_color.i.getRed(color) * alpha + utils_color.i.getRed(backgroundColor) * one_alpha), Math.floor(utils_color.i.getGreen(color) * alpha + utils_color.i.getGreen(backgroundColor) * one_alpha), Math.floor(utils_color.i.getBlue(color) * alpha + utils_color.i.getBlue(backgroundColor) * one_alpha));
            }
            static calculateNearestColor(colorsToChooseFrom, startColor) {
                const startHslColor = ColorHSL.fromColorRGB(startColor);
                return colorsToChooseFrom.length ? utils_list.ListUtils.min(colorsToChooseFrom, (color => {
                    const hslColor = ColorHSL.fromColorRGB(color);
                    let hue = Math.abs(hslColor.floatHue - startHslColor.floatHue);
                    return hue > 1 && (hue = 1 - hue), Math.pow(hue, 2) + Math.pow(hslColor.floatSaturation - startHslColor.floatSaturation, 2) + Math.pow(hslColor.luminance - startHslColor.luminance, 2);
                })) : DXColor.empty;
            }
        }
        DXColor.empty = ColorHelper.getPredefinedColor("#000000"), DXColor.transparent = utils_color.i.fromHashString("#FFFFFF", 0), 
        DXColor.white = utils_color.i.fromHashString(utils_color.i.colorNames.white, 255);
        class ColorHSL {
            constructor(hue, saturation, luminance) {
                if (Log.isEnabled && !(hue <= 1 && hue >= 0 && saturation <= 1 && saturation >= 0 && luminance <= 1 && luminance >= 0)) throw new Error(errors.D.InternalException);
                this._hue = hue, this._saturation = saturation, this._luminance = luminance;
            }
            calculateHash() {
                return math.MathUtils.somePrimes[0] * this._hue ^ math.MathUtils.somePrimes[0] * this._luminance ^ math.MathUtils.somePrimes[0] * this._saturation;
            }
            static makeFromHSL(hue, saturation, luminance) {
                return new ColorHSL(hue / ColorHSL.MaxAngle, saturation / ColorHSL.MaxThousandthOfPercentage, luminance / ColorHSL.MaxThousandthOfPercentage);
            }
            static rgbToHsl(r, g, b) {
                r /= 255, g /= 255, b /= 255;
                var h, s, max = Math.max(r, g, b), min = Math.min(r, g, b), l = (max + min) / 2;
                if (max == min) h = s = 0; else {
                    var d = max - min;
                    switch (s = l > .5 ? d / (2 - max - min) : d / (max + min), max) {
                      case r:
                        h = (g - b) / d + (g < b ? 6 : 0);
                        break;

                      case g:
                        h = (b - r) / d + 2;
                        break;

                      case b:
                        h = (r - g) / d + 4;
                    }
                    h /= 6;
                }
                return [ h, s, l ];
            }
            static fromColorRGB(color) {
                const r = utils_color.i.getRed(color) / 255, g = utils_color.i.getGreen(color) / 255, b = utils_color.i.getBlue(color) / 255, max = Math.max(r, g, b), min = Math.min(r, g, b);
                let h, s;
                const l = (max + min) / 2;
                if (max == min) s = 0, h = 4 / 6; else {
                    const d = max - min;
                    switch (s = l > .5 ? d / (2 - max - min) : d / (max + min), max) {
                      case r:
                        h = (g - b) / d + (g < b ? 6 : 0);
                        break;

                      case g:
                        h = (b - r) / d + 2;
                        break;

                      case b:
                        h = (r - g) / d + 4;
                    }
                    h /= 6;
                }
                return new ColorHSL(h, s, l);
            }
            static calculateColorRGB(color, tint) {
                return color == DXColor.empty || 0 == tint ? color : ColorHSL.fromColorRGB(color).applyTint(tint).toRgb();
            }
            toRgb() {
                const value1 = this._luminance < .5 ? this._luminance * (1 + this._saturation) : this._luminance + this._saturation - this._luminance * this._saturation, value2 = 2 * this._luminance - value1, rgb = utils_list.ListUtils.map([ this._hue + 1 / 3, this._hue, this._hue - 1 / 3 ], (value => (value < 0 && (value += 1), 
                value > 1 && (value -= 1), value = 6 * value < 1 ? value2 + 6 * (value1 - value2) * value : 6 * value >= 1 && 6 * value < 3 ? value1 : 6 * value >= 3 && 6 * value < 4 ? value2 + (value1 - value2) * (4 - 6 * value) : value2, 
                this.toIntValue(value))));
                return DXColor.fromRgb(rgb[0], rgb[1], rgb[2]);
            }
            get hue() {
                return this.getIntValue(this._hue, ColorHSL.MaxAngle);
            }
            set hue(value) {
                this._hue = this.getFloatValue(this.getValidValue(value), ColorHSL.MaxAngle);
            }
            get saturation() {
                return this.getIntValue(this._saturation, ColorHSL.MaxThousandthOfPercentage);
            }
            set saturation(value) {
                this._saturation = this.getFloatValue(this.getValidValue(value), ColorHSL.MaxThousandthOfPercentage);
            }
            get luminance() {
                return this.getIntValue(this._luminance, ColorHSL.MaxThousandthOfPercentage);
            }
            set luminance(value) {
                this._luminance = this.getFloatValue(this.getValidValue(value), ColorHSL.MaxThousandthOfPercentage);
            }
            get floatHue() {
                return this._hue;
            }
            set floatHue(value) {
                this._hue = this.getValidValue(value);
            }
            get floatSaturation() {
                return this._saturation;
            }
            set floatSaturation(value) {
                this._saturation = this.getValidValue(value);
            }
            get floatLuminance() {
                return this._luminance;
            }
            set floatLuminance(value) {
                this._luminance = this.getValidValue(value);
            }
            getComplementColor() {
                return this._hue += this._hue > .5 ? -.5 : .5, this;
            }
            applyHue(value) {
                return this.floatHue = value / ColorHSL.MaxAngle, this;
            }
            applyHueMod(value) {
                return this._hue = this._hue * value / ColorHSL.MaxThousandthOfPercentage, this.fixHue(), 
                this;
            }
            applyHueOffset(value) {
                return this._hue += value / ColorHSL.MaxAngle, this.fixHue(), this;
            }
            applySaturation(value) {
                return this.floatSaturation = value / ColorHSL.MaxThousandthOfPercentage, this;
            }
            applySaturationMod(value) {
                return this._saturation = this._saturation * value / ColorHSL.MaxThousandthOfPercentage, 
                this;
            }
            applySaturationOffset(value) {
                return this._saturation += value / ColorHSL.MaxThousandthOfPercentage, this;
            }
            applyLuminance(value) {
                return this.floatLuminance = value / ColorHSL.MaxThousandthOfPercentage, this;
            }
            applyLuminanceMod(value) {
                return this._luminance = this._luminance * value / ColorHSL.MaxThousandthOfPercentage, 
                this;
            }
            applyLuminanceOffset(value) {
                return this._luminance += value / ColorHSL.MaxThousandthOfPercentage, this;
            }
            fixHue() {
                this._hue > 1 && (this._hue -= Math.floor(this._hue));
            }
            toIntValue(value) {
                return this.fixIntValue(Math.round(255 * value));
            }
            fixIntValue(value) {
                return math.MathUtils.restrictValue(value, 0, 255);
            }
            getIntValue(value, maxValue) {
                return Math.round(value * maxValue);
            }
            getFloatValue(value, maxValue) {
                return value / maxValue;
            }
            getValidValue(value) {
                return math.MathUtils.restrictValue(value, 0, 1);
            }
            applyTint(tint) {
                return tint < 0 ? this._luminance *= 1 + tint : tint > 0 && (this._luminance = this._luminance * (1 - tint) + tint), 
                this;
            }
            equals(obj) {
                return obj && this._hue == obj._hue && this._saturation == obj._saturation && this._luminance == obj._luminance;
            }
        }
        var ColorType, DrawingColorType, ThemeColorValues, JSONBorderBaseProperty, JSONShadingInfoProperty, JSONSDrawingColorProperty, JSONSDrawingColorModelInfoProperty, JSONSColorHSLProperty, JSONSScRGBColorProperty, JSONSelectionState, json_general_enums_JSONFixedInterval, JSONCheckSpellingCommand, JSONSize, JSONForceSyncWithServerCommand, JSONInsertContentFromServerCommand, ShadingPattern, CharacterPropertiesMask, CharacterFormattingScript, ThemeFontType, FontTypeHint, StrikeoutType, UnderlineType, BorderLineStyle;
        ColorHSL.MaxAngle = DrawingValueConstants.MaxPositiveFixedAngle, ColorHSL.MaxThousandthOfPercentage = DrawingValueConstants.ThousandthOfPercentage, 
        ColorHSL.defaultValue = new ColorHSL(0, 0, 0), function(ColorType) {
            ColorType[ColorType.Rgb = 0] = "Rgb", ColorType[ColorType.Theme = 1] = "Theme", 
            ColorType[ColorType.Index = 2] = "Index", ColorType[ColorType.Auto = 3] = "Auto";
        }(ColorType || (ColorType = {}));
        class ThemeColorIndexConstants {}
        ThemeColorIndexConstants.None = -1, ThemeColorIndexConstants.Light1 = 0, ThemeColorIndexConstants.Dark1 = 1, 
        ThemeColorIndexConstants.Light2 = 2, ThemeColorIndexConstants.Dark2 = 3, ThemeColorIndexConstants.Accent1 = 4, 
        ThemeColorIndexConstants.Accent2 = 5, ThemeColorIndexConstants.Accent3 = 6, ThemeColorIndexConstants.Accent4 = 7, 
        ThemeColorIndexConstants.Accent5 = 8, ThemeColorIndexConstants.Accent6 = 9, ThemeColorIndexConstants.Hyperlink = 10, 
        ThemeColorIndexConstants.FollowedHyperlink = 11, function(DrawingColorType) {
            DrawingColorType[DrawingColorType.Rgb = 0] = "Rgb", DrawingColorType[DrawingColorType.System = 1] = "System", 
            DrawingColorType[DrawingColorType.Scheme = 2] = "Scheme", DrawingColorType[DrawingColorType.Preset = 3] = "Preset", 
            DrawingColorType[DrawingColorType.ScRgb = 4] = "ScRgb", DrawingColorType[DrawingColorType.Hsl = 5] = "Hsl";
        }(DrawingColorType || (DrawingColorType = {})), function(ThemeColorValues) {
            ThemeColorValues[ThemeColorValues.None = -1] = "None", ThemeColorValues[ThemeColorValues.Light1 = 0] = "Light1", 
            ThemeColorValues[ThemeColorValues.Dark1 = 1] = "Dark1", ThemeColorValues[ThemeColorValues.Light2 = 2] = "Light2", 
            ThemeColorValues[ThemeColorValues.Dark2 = 3] = "Dark2", ThemeColorValues[ThemeColorValues.Accent1 = 4] = "Accent1", 
            ThemeColorValues[ThemeColorValues.Accent2 = 5] = "Accent2", ThemeColorValues[ThemeColorValues.Accent3 = 6] = "Accent3", 
            ThemeColorValues[ThemeColorValues.Accent4 = 7] = "Accent4", ThemeColorValues[ThemeColorValues.Accent5 = 8] = "Accent5", 
            ThemeColorValues[ThemeColorValues.Accent6 = 9] = "Accent6", ThemeColorValues[ThemeColorValues.Hyperlink = 10] = "Hyperlink", 
            ThemeColorValues[ThemeColorValues.FollowedHyperlink = 11] = "FollowedHyperlink", 
            ThemeColorValues[ThemeColorValues.Background1 = 12] = "Background1", ThemeColorValues[ThemeColorValues.Background2 = 13] = "Background2", 
            ThemeColorValues[ThemeColorValues.Text1 = 14] = "Text1", ThemeColorValues[ThemeColorValues.Text2 = 15] = "Text2";
        }(ThemeColorValues || (ThemeColorValues = {}));
        class color_model_info_ColorModelInfo {
            constructor() {
                this._themeColorIndex = ThemeColorIndexConstants.None, this._themeValue = ThemeColorValues.None, 
                this._colorIndex = color_model_info_ColorModelInfo.defaultColorIndex, this.restoreDefaultValues();
            }
            static get nullColor() {
                return color_model_info_ColorModelInfo.makeByColor(ColorHelper.AUTOMATIC_COLOR);
            }
            static makeByThemeColorIndex(themeColorIndex, tint = 0) {
                const result = new color_model_info_ColorModelInfo;
                return result.themeColorIndex = themeColorIndex, result.tint = tint, result;
            }
            static makeByColor(color, tint = 0) {
                const result = new color_model_info_ColorModelInfo;
                return result.rgb = color, result.tint = tint, result;
            }
            static makeByColorIndex(colorIndex, tint = 0) {
                const result = new color_model_info_ColorModelInfo;
                return result.colorIndex = colorIndex, result.tint = tint, result;
            }
            get colorType() {
                return this._colorType;
            }
            get rgb() {
                return this._rgb;
            }
            set rgb(value) {
                this.setColorType(ColorType.Rgb), this._rgb != value && (this._rgb = value);
            }
            get themeColorIndex() {
                return this._themeColorIndex;
            }
            set themeColorIndex(value) {
                this.setColorType(ColorType.Theme), this._themeColorIndex != value && (this._themeColorIndex = value);
            }
            get themeValue() {
                return this._themeValue;
            }
            set themeValue(value) {
                this.setColorType(ColorType.Theme), this._themeValue != value && (this._themeValue = value);
            }
            get colorIndex() {
                return this._colorIndex;
            }
            set colorIndex(value) {
                this.setColorType(ColorType.Index), this._colorIndex != value && (this._colorIndex = value);
            }
            get tint() {
                return this._tint;
            }
            set tint(value) {
                if (Math.abs(value) > 1) throw new Error(errors.D.InternalException);
                this._tint = value;
            }
            get isEmpty() {
                return this.colorType == ColorType.Rgb && DXColor.isTransparentOrEmpty(this.rgb);
            }
            restoreDefaultValues() {
                this._themeColorIndex = ThemeColorIndexConstants.None, this._themeValue = ThemeColorValues.None, 
                this._colorIndex = color_model_info_ColorModelInfo.defaultColorIndex, this._rgb = DXColor.empty, 
                this._colorType = ColorType.Rgb, this._tint = 0;
            }
            setColorType(colorType) {
                this._colorType != colorType && (this.restoreDefaultValues(), this._colorType = colorType);
            }
            static makeAuto() {
                const result = new color_model_info_ColorModelInfo;
                return result.setColorType(ColorType.Auto), result;
            }
            toRgb(colorProvider) {
                let color = DXColor.empty;
                switch (this.colorType) {
                  case ColorType.Index:
                    this.colorIndex != color_model_info_ColorModelInfo.defaultColorIndex && (color = colorProvider.palette.getColorByIndex(this.colorIndex), 
                    0 == utils_color.i.getAlpha(color) && (color = DXColor.fromArgb(255, color)));
                    break;

                  case ColorType.Theme:
                    this.themeColorIndex != ThemeColorIndexConstants.None && (color = colorProvider.officeTheme.colors.getColorByThemeColorIndex(colorProvider, this.themeColorIndex));
                    break;

                  case ColorType.Rgb:
                    color = this.rgb;
                }
                return ColorHSL.calculateColorRGB(color, this.tint);
            }
            clone() {
                const result = new color_model_info_ColorModelInfo;
                return result.copyFrom(this), result;
            }
            copyFrom(value) {
                this._themeColorIndex = value.themeColorIndex, this._themeValue = value.themeValue, 
                this._colorIndex = value.colorIndex, this._rgb = value.rgb, this._colorType = value.colorType, 
                this.tint = value.tint;
            }
            equals(info) {
                return info && this._colorType == info.colorType && this.rgb == info.rgb && this.themeColorIndex == info.themeColorIndex && this.colorIndex == info.colorIndex && this.tint == info.tint && this.themeValue == info.themeValue;
            }
            static equalsBinary(a, b) {
                return a && b && (a === b || a._colorType == b._colorType && a._rgb == b._rgb && a._colorIndex == b._colorIndex && a._themeColorIndex == b._themeColorIndex && a._tint == b._tint && a._themeValue == b._themeValue);
            }
            calculateHash() {
                let hash = math.MathUtils.somePrimes[0] * this._colorType;
                return void 0 !== this._rgb && (hash ^= math.MathUtils.somePrimes[1] * this._rgb), 
                void 0 !== this._tint && (hash ^= math.MathUtils.somePrimes[2] * this._tint), void 0 !== this._colorIndex && (hash ^= math.MathUtils.somePrimes[3] * this._colorIndex), 
                void 0 !== this._themeColorIndex && (hash ^= math.MathUtils.somePrimes[4] * this._themeColorIndex), 
                hash;
            }
            getHashCode() {
                return void 0 === this.hash ? this.hash = this.calculateHash() : this.hash;
            }
            toJSON() {
                const result = {};
                return result[JSONColorModelInfoProperty.ColorType] = this.colorType, result[JSONColorModelInfoProperty.Tint] = this.tint, 
                result[JSONColorModelInfoProperty.ColorIndex] = this.colorIndex, result[JSONColorModelInfoProperty.ThemeColorIndex] = this.themeColorIndex, 
                result[JSONColorModelInfoProperty.Rgb] = this.rgb, result;
            }
            toDebugString() {
                return `type: ${ColorType[this.colorType]}, rgb ${this.rgb}, themeColorIndex: ${this.themeColorIndex}, themeValue: ${this.themeValue}`;
            }
        }
        color_model_info_ColorModelInfo.defaultColorIndex = -1, color_model_info_ColorModelInfo.empty = new color_model_info_ColorModelInfo, 
        color_model_info_ColorModelInfo.auto = color_model_info_ColorModelInfo.makeAuto(), 
        color_model_info_ColorModelInfo.autoColor = color_model_info_ColorModelInfo.makeByColor(ColorHelper.AUTOMATIC_COLOR), 
        color_model_info_ColorModelInfo.noColor = color_model_info_ColorModelInfo.makeByColor(ColorHelper.NO_COLOR), 
        function(JSONBorderBaseProperty) {
            JSONBorderBaseProperty[JSONBorderBaseProperty.Style = 0] = "Style", JSONBorderBaseProperty[JSONBorderBaseProperty.Color = 1] = "Color", 
            JSONBorderBaseProperty[JSONBorderBaseProperty.ColorIndex = 2] = "ColorIndex", JSONBorderBaseProperty[JSONBorderBaseProperty.Width = 3] = "Width", 
            JSONBorderBaseProperty[JSONBorderBaseProperty.Offset = 4] = "Offset", JSONBorderBaseProperty[JSONBorderBaseProperty.Frame = 5] = "Frame", 
            JSONBorderBaseProperty[JSONBorderBaseProperty.Shadow = 6] = "Shadow";
        }(JSONBorderBaseProperty || (JSONBorderBaseProperty = {})), function(JSONShadingInfoProperty) {
            JSONShadingInfoProperty[JSONShadingInfoProperty.ShadingPattern = 0] = "ShadingPattern", 
            JSONShadingInfoProperty[JSONShadingInfoProperty.BackColor = 1] = "BackColor", JSONShadingInfoProperty[JSONShadingInfoProperty.ForeColor = 2] = "ForeColor", 
            JSONShadingInfoProperty[JSONShadingInfoProperty.ForeColorIndex = 3] = "ForeColorIndex", 
            JSONShadingInfoProperty[JSONShadingInfoProperty.BackColorIndex = 4] = "BackColorIndex";
        }(JSONShadingInfoProperty || (JSONShadingInfoProperty = {})), function(JSONSDrawingColorProperty) {
            JSONSDrawingColorProperty[JSONSDrawingColorProperty.Color = 0] = "Color";
        }(JSONSDrawingColorProperty || (JSONSDrawingColorProperty = {})), function(JSONSDrawingColorModelInfoProperty) {
            JSONSDrawingColorModelInfoProperty[JSONSDrawingColorModelInfoProperty.ColorType = 0] = "ColorType", 
            JSONSDrawingColorModelInfoProperty[JSONSDrawingColorModelInfoProperty.Rgb = 1] = "Rgb", 
            JSONSDrawingColorModelInfoProperty[JSONSDrawingColorModelInfoProperty.System = 2] = "System", 
            JSONSDrawingColorModelInfoProperty[JSONSDrawingColorModelInfoProperty.Scheme = 3] = "Scheme", 
            JSONSDrawingColorModelInfoProperty[JSONSDrawingColorModelInfoProperty.Preset = 4] = "Preset", 
            JSONSDrawingColorModelInfoProperty[JSONSDrawingColorModelInfoProperty.Hsl = 5] = "Hsl", 
            JSONSDrawingColorModelInfoProperty[JSONSDrawingColorModelInfoProperty.ScRgb = 6] = "ScRgb";
        }(JSONSDrawingColorModelInfoProperty || (JSONSDrawingColorModelInfoProperty = {})), 
        function(JSONSColorHSLProperty) {
            JSONSColorHSLProperty[JSONSColorHSLProperty.Hue = 0] = "Hue", JSONSColorHSLProperty[JSONSColorHSLProperty.Saturation = 1] = "Saturation", 
            JSONSColorHSLProperty[JSONSColorHSLProperty.Luminance = 2] = "Luminance";
        }(JSONSColorHSLProperty || (JSONSColorHSLProperty = {})), function(JSONSScRGBColorProperty) {
            JSONSScRGBColorProperty[JSONSScRGBColorProperty.ScR = 0] = "ScR", JSONSScRGBColorProperty[JSONSScRGBColorProperty.ScG = 1] = "ScG", 
            JSONSScRGBColorProperty[JSONSScRGBColorProperty.ScB = 2] = "ScB";
        }(JSONSScRGBColorProperty || (JSONSScRGBColorProperty = {})), function(JSONSelectionState) {
            JSONSelectionState[JSONSelectionState.ForwardDirection = 0] = "ForwardDirection", 
            JSONSelectionState[JSONSelectionState.KeepX = 1] = "KeepX", JSONSelectionState[JSONSelectionState.EndOfLine = 2] = "EndOfLine", 
            JSONSelectionState[JSONSelectionState.Intervals = 3] = "Intervals";
        }(JSONSelectionState || (JSONSelectionState = {})), function(JSONFixedInterval) {
            JSONFixedInterval[JSONFixedInterval.Start = 0] = "Start", JSONFixedInterval[JSONFixedInterval.Length = 1] = "Length";
        }(json_general_enums_JSONFixedInterval || (json_general_enums_JSONFixedInterval = {})), 
        function(JSONCheckSpellingCommand) {
            JSONCheckSpellingCommand[JSONCheckSpellingCommand.StartPosition = 0] = "StartPosition", 
            JSONCheckSpellingCommand[JSONCheckSpellingCommand.EndPosition = 1] = "EndPosition", 
            JSONCheckSpellingCommand[JSONCheckSpellingCommand.TextToCheck = 2] = "TextToCheck", 
            JSONCheckSpellingCommand[JSONCheckSpellingCommand.SpellingErrors = 3] = "SpellingErrors", 
            JSONCheckSpellingCommand[JSONCheckSpellingCommand.IntervalsToCheck = 4] = "IntervalsToCheck", 
            JSONCheckSpellingCommand[JSONCheckSpellingCommand.CheckedIntervals = 5] = "CheckedIntervals", 
            JSONCheckSpellingCommand[JSONCheckSpellingCommand.SubDocumentId = 6] = "SubDocumentId", 
            JSONCheckSpellingCommand[JSONCheckSpellingCommand.AddedWord = 7] = "AddedWord", 
            JSONCheckSpellingCommand[JSONCheckSpellingCommand.CustomDictionaryGuid = 8] = "CustomDictionaryGuid", 
            JSONCheckSpellingCommand[JSONCheckSpellingCommand.ErrorType = 9] = "ErrorType", 
            JSONCheckSpellingCommand[JSONCheckSpellingCommand.Suggestions = 10] = "Suggestions", 
            JSONCheckSpellingCommand[JSONCheckSpellingCommand.ErrorWord = 11] = "ErrorWord", 
            JSONCheckSpellingCommand[JSONCheckSpellingCommand.ErrorStart = 12] = "ErrorStart", 
            JSONCheckSpellingCommand[JSONCheckSpellingCommand.ErrorLength = 13] = "ErrorLength";
        }(JSONCheckSpellingCommand || (JSONCheckSpellingCommand = {})), function(JSONSize) {
            JSONSize[JSONSize.Width = 0] = "Width", JSONSize[JSONSize.Height = 1] = "Height";
        }(JSONSize || (JSONSize = {})), function(JSONForceSyncWithServerCommand) {
            JSONForceSyncWithServerCommand[JSONForceSyncWithServerCommand.Id = 0] = "Id";
        }(JSONForceSyncWithServerCommand || (JSONForceSyncWithServerCommand = {})), function(JSONInsertContentFromServerCommand) {
            JSONInsertContentFromServerCommand[JSONInsertContentFromServerCommand.UserRequestId = 0] = "UserRequestId", 
            JSONInsertContentFromServerCommand[JSONInsertContentFromServerCommand.Id = 1] = "Id", 
            JSONInsertContentFromServerCommand[JSONInsertContentFromServerCommand.Model = 2] = "Model", 
            JSONInsertContentFromServerCommand[JSONInsertContentFromServerCommand.SimpleText = 3] = "SimpleText";
        }(JSONInsertContentFromServerCommand || (JSONInsertContentFromServerCommand = {}));
        class JSONColorModelInfoConverter {
            static convertFromJSON(obj) {
                switch (obj[JSONColorModelInfoProperty.ColorType]) {
                  case ColorType.Auto:
                    return color_model_info_ColorModelInfo.auto;

                  case ColorType.Index:
                    return color_model_info_ColorModelInfo.makeByColorIndex(obj[JSONColorModelInfoProperty.ColorIndex], obj[JSONColorModelInfoProperty.Tint]);

                  case ColorType.Rgb:
                    return color_model_info_ColorModelInfo.makeByColor(obj[JSONColorModelInfoProperty.Rgb], obj[JSONColorModelInfoProperty.Tint]);

                  case ColorType.Theme:
                    return color_model_info_ColorModelInfo.makeByThemeColorIndex(obj[JSONColorModelInfoProperty.ThemeColorIndex], obj[JSONColorModelInfoProperty.Tint]);
                }
            }
            static convertToJSON(source) {
                return source.toJSON();
            }
        }
        class JSONShadingInfoConverter {
            static convertFromJSON(obj, cache) {
                let backColor = cache.getItemByJsonKey(obj[JSONShadingInfoProperty.BackColorIndex]);
                backColor || (backColor = JSONColorModelInfoConverter.convertFromJSON(obj[JSONShadingInfoProperty.BackColor]));
                let foreColor = cache.getItemByJsonKey(obj[JSONShadingInfoProperty.ForeColorIndex]);
                return foreColor || (foreColor = JSONColorModelInfoConverter.convertFromJSON(obj[JSONShadingInfoProperty.ForeColor])), 
                new ShadingInfo(obj[JSONShadingInfoProperty.ShadingPattern], backColor, foreColor);
            }
            static convertToJSON(source) {
                const result = {};
                return result[JSONShadingInfoProperty.ShadingPattern] = source.shadingPattern, result[JSONShadingInfoProperty.BackColor] = JSONColorModelInfoConverter.convertToJSON(source.backColor), 
                result[JSONShadingInfoProperty.ForeColor] = JSONColorModelInfoConverter.convertToJSON(source.foreColor), 
                result;
            }
        }
        !function(ShadingPattern) {
            ShadingPattern[ShadingPattern.Clear = 0] = "Clear", ShadingPattern[ShadingPattern.DiagCross = 1] = "DiagCross", 
            ShadingPattern[ShadingPattern.DiagStripe = 2] = "DiagStripe", ShadingPattern[ShadingPattern.HorzCross = 3] = "HorzCross", 
            ShadingPattern[ShadingPattern.HorzStripe = 4] = "HorzStripe", ShadingPattern[ShadingPattern.Nil = 5] = "Nil", 
            ShadingPattern[ShadingPattern.Pct5 = 6] = "Pct5", ShadingPattern[ShadingPattern.Pct10 = 7] = "Pct10", 
            ShadingPattern[ShadingPattern.Pct12 = 8] = "Pct12", ShadingPattern[ShadingPattern.Pct15 = 9] = "Pct15", 
            ShadingPattern[ShadingPattern.Pct20 = 10] = "Pct20", ShadingPattern[ShadingPattern.Pct25 = 11] = "Pct25", 
            ShadingPattern[ShadingPattern.Pct30 = 12] = "Pct30", ShadingPattern[ShadingPattern.Pct35 = 13] = "Pct35", 
            ShadingPattern[ShadingPattern.Pct37 = 14] = "Pct37", ShadingPattern[ShadingPattern.Pct40 = 15] = "Pct40", 
            ShadingPattern[ShadingPattern.Pct45 = 16] = "Pct45", ShadingPattern[ShadingPattern.Pct50 = 17] = "Pct50", 
            ShadingPattern[ShadingPattern.Pct55 = 18] = "Pct55", ShadingPattern[ShadingPattern.Pct60 = 19] = "Pct60", 
            ShadingPattern[ShadingPattern.Pct62 = 20] = "Pct62", ShadingPattern[ShadingPattern.Pct65 = 21] = "Pct65", 
            ShadingPattern[ShadingPattern.Pct70 = 22] = "Pct70", ShadingPattern[ShadingPattern.Pct75 = 23] = "Pct75", 
            ShadingPattern[ShadingPattern.Pct80 = 24] = "Pct80", ShadingPattern[ShadingPattern.Pct85 = 25] = "Pct85", 
            ShadingPattern[ShadingPattern.Pct87 = 26] = "Pct87", ShadingPattern[ShadingPattern.Pct90 = 27] = "Pct90", 
            ShadingPattern[ShadingPattern.Pct95 = 28] = "Pct95", ShadingPattern[ShadingPattern.ReverseDiagStripe = 29] = "ReverseDiagStripe", 
            ShadingPattern[ShadingPattern.Solid = 30] = "Solid", ShadingPattern[ShadingPattern.ThinDiagCross = 31] = "ThinDiagCross", 
            ShadingPattern[ShadingPattern.ThinDiagStripe = 32] = "ThinDiagStripe", ShadingPattern[ShadingPattern.ThinHorzCross = 33] = "ThinHorzCross", 
            ShadingPattern[ShadingPattern.ThinHorzStripe = 34] = "ThinHorzStripe", ShadingPattern[ShadingPattern.ThinReverseDiagStripe = 35] = "ThinReverseDiagStripe", 
            ShadingPattern[ShadingPattern.ThinVertStripe = 36] = "ThinVertStripe", ShadingPattern[ShadingPattern.VertStripe = 37] = "VertStripe", 
            ShadingPattern[ShadingPattern.Pct2 = 38] = "Pct2", ShadingPattern[ShadingPattern.Pct7 = 39] = "Pct7", 
            ShadingPattern[ShadingPattern.Pct17 = 40] = "Pct17", ShadingPattern[ShadingPattern.Pct22 = 41] = "Pct22", 
            ShadingPattern[ShadingPattern.Pct27 = 42] = "Pct27", ShadingPattern[ShadingPattern.Pct32 = 43] = "Pct32", 
            ShadingPattern[ShadingPattern.Pct42 = 44] = "Pct42", ShadingPattern[ShadingPattern.Pct47 = 45] = "Pct47", 
            ShadingPattern[ShadingPattern.Pct52 = 46] = "Pct52", ShadingPattern[ShadingPattern.Pct57 = 47] = "Pct57", 
            ShadingPattern[ShadingPattern.Pct67 = 48] = "Pct67", ShadingPattern[ShadingPattern.Pct72 = 49] = "Pct72", 
            ShadingPattern[ShadingPattern.Pct77 = 50] = "Pct77", ShadingPattern[ShadingPattern.Pct82 = 51] = "Pct82", 
            ShadingPattern[ShadingPattern.Pct92 = 52] = "Pct92", ShadingPattern[ShadingPattern.Pct97 = 53] = "Pct97";
        }(ShadingPattern || (ShadingPattern = {}));
        class ShadingPatternInfo {
            constructor(shadingPatternValue, shadingPattern) {
                this.shadingPatternValue = shadingPatternValue, this.shadingPattern = shadingPattern;
            }
        }
        class ShadingHelper {
            static initStatics() {
                ShadingHelper.infos = [ new ShadingPatternInfo(0, ShadingPattern.Clear), new ShadingPatternInfo(25, ShadingPattern.Pct2), new ShadingPatternInfo(50, ShadingPattern.Pct5), new ShadingPatternInfo(75, ShadingPattern.Pct7), new ShadingPatternInfo(100, ShadingPattern.Pct10), new ShadingPatternInfo(125, ShadingPattern.Pct12), new ShadingPatternInfo(150, ShadingPattern.Pct15), new ShadingPatternInfo(175, ShadingPattern.Pct17), new ShadingPatternInfo(200, ShadingPattern.Pct20), new ShadingPatternInfo(225, ShadingPattern.Pct22), new ShadingPatternInfo(250, ShadingPattern.Pct25), new ShadingPatternInfo(275, ShadingPattern.Pct27), new ShadingPatternInfo(300, ShadingPattern.Pct30), new ShadingPatternInfo(325, ShadingPattern.Pct32), new ShadingPatternInfo(350, ShadingPattern.Pct35), new ShadingPatternInfo(375, ShadingPattern.Pct37), new ShadingPatternInfo(400, ShadingPattern.Pct40), new ShadingPatternInfo(425, ShadingPattern.Pct42), new ShadingPatternInfo(450, ShadingPattern.Pct45), new ShadingPatternInfo(475, ShadingPattern.Pct47), new ShadingPatternInfo(500, ShadingPattern.Pct50), new ShadingPatternInfo(525, ShadingPattern.Pct52), new ShadingPatternInfo(550, ShadingPattern.Pct55), new ShadingPatternInfo(575, ShadingPattern.Pct57), new ShadingPatternInfo(600, ShadingPattern.Pct60), new ShadingPatternInfo(625, ShadingPattern.Pct62), new ShadingPatternInfo(650, ShadingPattern.Pct65), new ShadingPatternInfo(675, ShadingPattern.Pct67), new ShadingPatternInfo(700, ShadingPattern.Pct70), new ShadingPatternInfo(725, ShadingPattern.Pct72), new ShadingPatternInfo(750, ShadingPattern.Pct75), new ShadingPatternInfo(775, ShadingPattern.Pct77), new ShadingPatternInfo(800, ShadingPattern.Pct80), new ShadingPatternInfo(825, ShadingPattern.Pct82), new ShadingPatternInfo(850, ShadingPattern.Pct85), new ShadingPatternInfo(875, ShadingPattern.Pct87), new ShadingPatternInfo(900, ShadingPattern.Pct90), new ShadingPatternInfo(925, ShadingPattern.Pct92), new ShadingPatternInfo(950, ShadingPattern.Pct95), new ShadingPatternInfo(975, ShadingPattern.Pct97), new ShadingPatternInfo(1e3, ShadingPattern.Solid) ], 
                ShadingHelper.shadingPatterns = {}, ShadingHelper.patternMultipliers = {};
                for (let info of ShadingHelper.infos) ShadingHelper.shadingPatterns[info.shadingPatternValue] = info.shadingPattern, 
                ShadingHelper.patternMultipliers[info.shadingPattern] = info.shadingPatternValue;
                return ShadingHelper.infos;
            }
            static calculateShadingPattern(shadingPatternValue) {
                const value = ShadingHelper.shadingPatterns[shadingPatternValue];
                return void 0 === value ? ShadingPattern.Clear : value;
            }
            static getShadingPattern(index) {
                return ShadingHelper.infos[index].shadingPattern;
            }
            static calculateShadingPatternValue(shadingPattern) {
                const value = ShadingHelper.patternMultipliers[shadingPattern];
                return void 0 === value ? -1 : value;
            }
            static getActualBackColor(fill, patternColor, pattern) {
                if (pattern == ShadingPattern.Clear || pattern == ShadingPattern.Nil) return fill;
                const white = DXColor.white;
                if ((DXColor.isTransparentOrEmpty(fill) || fill == white) && DXColor.isTransparentOrEmpty(patternColor)) {
                    const multiplier = ShadingHelper.patternMultipliers[pattern];
                    if (void 0 !== multiplier) {
                        const intensity = 255 * (1e3 - multiplier) / 1e3;
                        return DXColor.fromRgb(intensity, intensity, intensity);
                    }
                }
                return pattern == ShadingPattern.Solid || DXColor.isTransparentOrEmpty(fill) ? patternColor : fill;
            }
            static getActualBackColorByMultiplier(fill, patternColor, multiplier) {
                const white = DXColor.white;
                if ((DXColor.isTransparentOrEmpty(fill) || fill == white) && DXColor.isTransparentOrEmpty(patternColor)) {
                    const intensity = 255 * (1e3 - multiplier) / 1e3;
                    return DXColor.fromRgb(intensity, intensity, intensity);
                }
                return 1e3 == multiplier ? fill : patternColor;
            }
        }
        ShadingHelper.infos = ShadingHelper.initStatics();
        class ShadingInfo {
            constructor(shadingPattern, backColor, foreColor) {
                this.shadingPattern = shadingPattern, this.backColor = backColor, this.foreColor = foreColor;
            }
            static get noColor() {
                return ShadingInfo.createByColor(color_model_info_ColorModelInfo.noColor);
            }
            static get auto() {
                return ShadingInfo.createByColor(color_model_info_ColorModelInfo.auto);
            }
            static get nullColor() {
                return ShadingInfo.createByColor(color_model_info_ColorModelInfo.makeByColor(0));
            }
            static createByColor(backColor) {
                return new ShadingInfo(ShadingPattern.Clear, backColor, color_model_info_ColorModelInfo.nullColor);
            }
            static createByFullData(cache, pattern, fill, patternColor) {
                return new ShadingInfo(pattern, cache.getItem(color_model_info_ColorModelInfo.makeByColor(fill)), cache.getItem(color_model_info_ColorModelInfo.makeByColor(patternColor)));
            }
            getActualColor(colorProvider) {
                const fill = this.backColor.toRgb(colorProvider), patternColor = this.foreColor.toRgb(colorProvider);
                return ShadingHelper.getActualBackColor(fill, patternColor, this.shadingPattern);
            }
            equals(obj) {
                return obj && this.shadingPattern == obj.shadingPattern && this.backColor.equals(obj.backColor) && this.foreColor.equals(obj.foreColor);
            }
            static equalsBinary(a, b) {
                return a && b && (a === b || a.shadingPattern == b.shadingPattern && a.backColor.equals(b.backColor) && a.foreColor.equals(b.foreColor));
            }
            clone() {
                return new ShadingInfo(this.shadingPattern, this.backColor, this.foreColor);
            }
            calculateHash() {
                return math.MathUtils.somePrimes[0] * this.shadingPattern ^ math.MathUtils.somePrimes[1] * this.backColor.getHashCode() ^ math.MathUtils.somePrimes[2] * this.foreColor.getHashCode();
            }
            getHashCode() {
                return void 0 === this.hash ? this.hash = this.calculateHash() : this.hash;
            }
            toJSON() {
                return JSONShadingInfoConverter.convertToJSON(this);
            }
        }
        !function(CharacterPropertiesMask) {
            CharacterPropertiesMask[CharacterPropertiesMask.UseNone = 0] = "UseNone", CharacterPropertiesMask[CharacterPropertiesMask.UseFontName = 1] = "UseFontName", 
            CharacterPropertiesMask[CharacterPropertiesMask.UseDoubleFontSize = 2] = "UseDoubleFontSize", 
            CharacterPropertiesMask[CharacterPropertiesMask.UseFontBold = 4] = "UseFontBold", 
            CharacterPropertiesMask[CharacterPropertiesMask.UseFontItalic = 8] = "UseFontItalic", 
            CharacterPropertiesMask[CharacterPropertiesMask.UseFontStrikeoutType = 16] = "UseFontStrikeoutType", 
            CharacterPropertiesMask[CharacterPropertiesMask.UseFontUnderlineType = 32] = "UseFontUnderlineType", 
            CharacterPropertiesMask[CharacterPropertiesMask.UseAllCaps = 64] = "UseAllCaps", 
            CharacterPropertiesMask[CharacterPropertiesMask.UseForeColorIndex = 128] = "UseForeColorIndex", 
            CharacterPropertiesMask[CharacterPropertiesMask.UseShadingInfoIndex = 256] = "UseShadingInfoIndex", 
            CharacterPropertiesMask[CharacterPropertiesMask.UseUnderlineColorIndex = 512] = "UseUnderlineColorIndex", 
            CharacterPropertiesMask[CharacterPropertiesMask.UseStrikeoutColorIndex = 1024] = "UseStrikeoutColorIndex", 
            CharacterPropertiesMask[CharacterPropertiesMask.UseUnderlineWordsOnly = 2048] = "UseUnderlineWordsOnly", 
            CharacterPropertiesMask[CharacterPropertiesMask.UseStrikeoutWordsOnly = 4096] = "UseStrikeoutWordsOnly", 
            CharacterPropertiesMask[CharacterPropertiesMask.UseScript = 8192] = "UseScript", 
            CharacterPropertiesMask[CharacterPropertiesMask.UseHidden = 16384] = "UseHidden", 
            CharacterPropertiesMask[CharacterPropertiesMask.UseLangInfo = 32768] = "UseLangInfo", 
            CharacterPropertiesMask[CharacterPropertiesMask.UseNoProof = 65536] = "UseNoProof", 
            CharacterPropertiesMask[CharacterPropertiesMask.UseFontInfo = 131072] = "UseFontInfo", 
            CharacterPropertiesMask[CharacterPropertiesMask.UseHighlightColorIndex = 262144] = "UseHighlightColorIndex", 
            CharacterPropertiesMask[CharacterPropertiesMask.UseRightToLeft = 524288] = "UseRightToLeft", 
            CharacterPropertiesMask[CharacterPropertiesMask.UseCompositeFontInfo = 1048576] = "UseCompositeFontInfo", 
            CharacterPropertiesMask[CharacterPropertiesMask.UseSmallCaps = 8589934592] = "UseSmallCaps", 
            CharacterPropertiesMask[CharacterPropertiesMask.UseAll = 9007199254740991] = "UseAll";
        }(CharacterPropertiesMask || (CharacterPropertiesMask = {})), function(CharacterFormattingScript) {
            CharacterFormattingScript[CharacterFormattingScript.Normal = 0] = "Normal", CharacterFormattingScript[CharacterFormattingScript.Subscript = 1] = "Subscript", 
            CharacterFormattingScript[CharacterFormattingScript.Superscript = 2] = "Superscript";
        }(CharacterFormattingScript || (CharacterFormattingScript = {})), function(ThemeFontType) {
            ThemeFontType[ThemeFontType.None = 0] = "None", ThemeFontType[ThemeFontType.MajorEastAsia = 1] = "MajorEastAsia", 
            ThemeFontType[ThemeFontType.MajorBidi = 2] = "MajorBidi", ThemeFontType[ThemeFontType.MajorAscii = 3] = "MajorAscii", 
            ThemeFontType[ThemeFontType.MajorHAnsi = 4] = "MajorHAnsi", ThemeFontType[ThemeFontType.MinorEastAsia = 5] = "MinorEastAsia", 
            ThemeFontType[ThemeFontType.MinorBidi = 6] = "MinorBidi", ThemeFontType[ThemeFontType.MinorAscii = 7] = "MinorAscii", 
            ThemeFontType[ThemeFontType.MinorHAnsi = 8] = "MinorHAnsi";
        }(ThemeFontType || (ThemeFontType = {})), function(FontTypeHint) {
            FontTypeHint[FontTypeHint.Default = 0] = "Default", FontTypeHint[FontTypeHint.Cs = 1] = "Cs", 
            FontTypeHint[FontTypeHint.EastAsia = 2] = "EastAsia", FontTypeHint[FontTypeHint.None = 3] = "None";
        }(FontTypeHint || (FontTypeHint = {})), function(StrikeoutType) {
            StrikeoutType[StrikeoutType.None = 0] = "None", StrikeoutType[StrikeoutType.Single = 1] = "Single", 
            StrikeoutType[StrikeoutType.Double = 2] = "Double";
        }(StrikeoutType || (StrikeoutType = {})), function(UnderlineType) {
            UnderlineType[UnderlineType.None = 0] = "None", UnderlineType[UnderlineType.Single = 1] = "Single", 
            UnderlineType[UnderlineType.Dotted = 2] = "Dotted", UnderlineType[UnderlineType.Dashed = 3] = "Dashed", 
            UnderlineType[UnderlineType.DashDotted = 4] = "DashDotted", UnderlineType[UnderlineType.DashDotDotted = 5] = "DashDotDotted", 
            UnderlineType[UnderlineType.Double = 6] = "Double", UnderlineType[UnderlineType.HeavyWave = 7] = "HeavyWave", 
            UnderlineType[UnderlineType.LongDashed = 8] = "LongDashed", UnderlineType[UnderlineType.ThickSingle = 9] = "ThickSingle", 
            UnderlineType[UnderlineType.ThickDotted = 10] = "ThickDotted", UnderlineType[UnderlineType.ThickDashed = 11] = "ThickDashed", 
            UnderlineType[UnderlineType.ThickDashDotted = 12] = "ThickDashDotted", UnderlineType[UnderlineType.ThickDashDotDotted = 13] = "ThickDashDotDotted", 
            UnderlineType[UnderlineType.ThickLongDashed = 14] = "ThickLongDashed", UnderlineType[UnderlineType.DoubleWave = 15] = "DoubleWave", 
            UnderlineType[UnderlineType.Wave = 16] = "Wave", UnderlineType[UnderlineType.DashSmallGap = 17] = "DashSmallGap";
        }(UnderlineType || (UnderlineType = {}));
        class CompositeFontInfo {
            constructor() {
                this.asciiFontName = "", this.hightAnsiFontName = "", this.complexScriptFontName = "", 
                this.eastAsiaFontName = "", this.asciiThemeFont = ThemeFontType.None, this.hightAnsiThemeFont = ThemeFontType.None, 
                this.complexScriptThemeFont = ThemeFontType.None, this.eastAsiaThemeFont = ThemeFontType.None, 
                this.hintFont = FontTypeHint.Default;
            }
            equals(obj) {
                return obj && this.asciiFontName == this.asciiFontName && this.hightAnsiFontName == this.hightAnsiFontName && this.complexScriptFontName == this.complexScriptFontName && this.eastAsiaFontName == this.eastAsiaFontName && this.asciiThemeFont == this.asciiThemeFont && this.hightAnsiThemeFont == this.hightAnsiThemeFont && this.complexScriptThemeFont == this.complexScriptThemeFont && this.eastAsiaThemeFont == this.eastAsiaThemeFont && this.hintFont == this.hintFont;
            }
            clone() {
                const result = new CompositeFontInfo;
                return result.asciiFontName = this.asciiFontName, result.hightAnsiFontName = this.hightAnsiFontName, 
                result.complexScriptFontName = this.complexScriptFontName, result.eastAsiaFontName = this.eastAsiaFontName, 
                result.asciiThemeFont = this.asciiThemeFont, result.hightAnsiThemeFont = this.hightAnsiThemeFont, 
                result.complexScriptThemeFont = this.complexScriptThemeFont, result.eastAsiaThemeFont = this.eastAsiaThemeFont, 
                result.hintFont = this.hintFont, result;
            }
        }
        class LangInfo {
            constructor(bidi, eastAsia, latin) {
                this.bidi = bidi || "", this.eastAsia = eastAsia || "", this.latin = latin || "";
            }
            copyFrom(obj) {
                this.bidi = obj.bidi, this.eastAsia = obj.eastAsia, this.latin = obj.latin;
            }
            equals(obj) {
                return obj && this.bidi == obj.bidi && this.eastAsia == obj.eastAsia && this.latin == obj.latin;
            }
            static equalsBinary(langInfoA, langInfoB) {
                return langInfoA && langInfoB && langInfoA.bidi == langInfoB.bidi && langInfoA.eastAsia == langInfoB.eastAsia && langInfoA.latin == langInfoB.latin;
            }
            clone() {
                var obj = new LangInfo(null, null, null);
                return obj.copyFrom(this), obj;
            }
            isEmpty() {
                return "" == this.bidi && "" == this.eastAsia && "" == this.latin;
            }
        }
        class LayoutCharacterPropertiesColorInfo {
            constructor(textColor, foregroundColor, strikeoutColor, underlineColor) {
                this.textColor = textColor, this.foregroundColor = foregroundColor, this.strikeoutColor = strikeoutColor, 
                this.underlineColor = underlineColor;
            }
            equals(obj) {
                return obj && this.textColor == obj.textColor && this.foregroundColor == obj.foregroundColor && this.strikeoutColor == obj.strikeoutColor && this.underlineColor == obj.underlineColor;
            }
            clone() {
                return new LayoutCharacterPropertiesColorInfo(this.textColor, this.foregroundColor, this.strikeoutColor, this.underlineColor);
            }
        }
        class CharacterProperties {
            constructor() {
                this.measurerSizes = Object.create(null), this.fontSize = 11, this.fontBold = !1, 
                this.fontItalic = !1, this.fontInfo = null, this.script = CharacterFormattingScript.Normal, 
                this.fontStrikeoutType = StrikeoutType.None, this.fontUnderlineType = UnderlineType.None, 
                this.allCaps = !1, this.smallCaps = !1, this.underlineWordsOnly = !1, this.strikeoutWordsOnly = !1, 
                this.noProof = !1, this.hidden = !1, this.langInfo = new LangInfo, this.compositeFontInfo = new CompositeFontInfo, 
                this.textColor = color_model_info_ColorModelInfo.nullColor, this.shadingInfo = ShadingInfo.nullColor, 
                this.highlightColor = color_model_info_ColorModelInfo.nullColor, this.strikeoutColor = color_model_info_ColorModelInfo.nullColor, 
                this.underlineColor = color_model_info_ColorModelInfo.nullColor;
            }
            calculateHash() {
                return this.fontSize ^ math.MathUtils.somePrimes[0] * (0, common.boolToInt)(this.fontBold) ^ math.MathUtils.somePrimes[1] * (0, 
                common.boolToInt)(this.fontItalic) ^ math.MathUtils.somePrimes[2] * this.shadingInfo.getHashCode() ^ math.MathUtils.somePrimes[3] * this.textColor.getHashCode() ^ math.MathUtils.somePrimes[4] * this.highlightColor.getHashCode();
            }
            getHashCode() {
                return void 0 === this.hash ? this.hash = this.calculateHash() : this.hash;
            }
            equals(obj) {
                return !!obj && (this.fontBold == obj.fontBold && this.fontItalic == obj.fontItalic && this.fontInfo && obj.fontInfo && this.fontInfo.equals(obj.fontInfo) && this.fontSize == obj.fontSize && this.script == obj.script && this.fontStrikeoutType == obj.fontStrikeoutType && this.fontUnderlineType == obj.fontUnderlineType && this.allCaps == obj.allCaps && this.smallCaps == obj.smallCaps && this.underlineWordsOnly == obj.underlineWordsOnly && this.strikeoutWordsOnly == obj.strikeoutWordsOnly && this.noProof == obj.noProof && this.hidden == obj.hidden && this.shadingInfo.equals(obj.shadingInfo) && this.textColor.equals(obj.textColor) && this.highlightColor.equals(obj.highlightColor) && this.strikeoutColor.equals(obj.strikeoutColor) && this.underlineColor.equals(obj.underlineColor) && this.langInfo && obj.langInfo && this.langInfo.equals(obj.langInfo) && this.compositeFontInfo && this.compositeFontInfo.equals(obj.compositeFontInfo));
            }
            clone() {
                var result = new CharacterProperties;
                return result.copyFrom(this), result;
            }
            copyFrom(obj) {
                this.fontInfo = obj.fontInfo, this.fontSize = obj.fontSize, this.fontBold = obj.fontBold, 
                this.fontItalic = obj.fontItalic, this.script = obj.script, this.fontStrikeoutType = obj.fontStrikeoutType, 
                this.fontUnderlineType = obj.fontUnderlineType, this.allCaps = obj.allCaps, this.smallCaps = obj.smallCaps, 
                this.underlineWordsOnly = obj.underlineWordsOnly, this.strikeoutWordsOnly = obj.strikeoutWordsOnly, 
                this.noProof = obj.noProof, this.hidden = obj.hidden, this.shadingInfo = obj.shadingInfo ? obj.shadingInfo.clone() : new ShadingInfo(ShadingPattern.Clear, color_model_info_ColorModelInfo.noColor, color_model_info_ColorModelInfo.noColor), 
                this.textColor = obj.textColor ? obj.textColor.clone() : color_model_info_ColorModelInfo.noColor, 
                this.highlightColor = obj.highlightColor ? obj.highlightColor.clone() : color_model_info_ColorModelInfo.noColor, 
                this.strikeoutColor = obj.strikeoutColor ? obj.strikeoutColor.clone() : color_model_info_ColorModelInfo.noColor, 
                this.underlineColor = obj.underlineColor ? obj.underlineColor.clone() : color_model_info_ColorModelInfo.noColor, 
                this.langInfo = obj.langInfo ? obj.langInfo.clone() : new LangInfo, this.compositeFontInfo = obj.compositeFontInfo ? obj.compositeFontInfo.clone() : new CompositeFontInfo, 
                this.clearSizes();
            }
            getSize(text) {
                return this.measurerSizes[text];
            }
            setSize(text, size) {
                this.measurerSizes[text] = size;
            }
            clearSizes() {
                this.measurerSizes = Object.create(null);
            }
            linkMeasurerSizes(obj) {
                this.measurerSizes = obj.measurerSizes;
            }
            getLayoutColorInfo(colorProvider) {
                return new LayoutCharacterPropertiesColorInfo(this.textColor.toRgb(colorProvider), CharacterProperties.getActualBackgroundColor(this, colorProvider), this.strikeoutColor.toRgb(colorProvider), this.underlineColor.toRgb(colorProvider));
            }
            static getActualBackgroundColor(charProps, colorProvider) {
                const backColor = charProps.shadingInfo.getActualColor(colorProvider), highlightColor = charProps.highlightColor.toRgb(colorProvider);
                return utils_enum.Y.isAnyOf(highlightColor, ColorHelper.NO_COLOR, ColorHelper.AUTOMATIC_COLOR) ? backColor : highlightColor;
            }
        }
        class MaskedCharacterProperties extends CharacterProperties {
            constructor() {
                super(...arguments), this.useValue = 0, this.useValueExt = 0;
            }
            calculateHash() {
                return super.calculateHash() + math.MathUtils.somePrimes[15] * this.useValue + math.MathUtils.somePrimes[16] * this.useValueExt;
            }
            getUseValue(value) {
                return value >= MaskedCharacterProperties.denominator ? !!(this.useValueExt & this.getHighPartUseValue(value)) : !!(this.useValue & this.getLowPartUseValue(value));
            }
            setUseValue(mask, value) {
                value ? (this.useValue |= this.getLowPartUseValue(mask), this.useValueExt |= this.getHighPartUseValue(mask)) : (this.useValue &= ~this.getLowPartUseValue(mask), 
                this.useValueExt &= ~this.getHighPartUseValue(mask));
            }
            setUseValueFull(value) {
                this.useValue = this.getLowPartUseValue(value), this.useValueExt = this.getHighPartUseValue(value);
            }
            getLowPartUseValue(value) {
                return 0 | value;
            }
            getHighPartUseValue(value) {
                return value < MaskedCharacterProperties.denominator ? 0 : (Math.trunc || (Math.trunc = function(v) {
                    return v = +v, isFinite(v) ? v - v % 1 || (v < 0 ? -0 : 0 === v ? v : 0) : v;
                }), Math.trunc(value / MaskedCharacterProperties.denominator));
            }
            getUseValueFull() {
                return this.useValue + this.useValueExt * MaskedCharacterProperties.denominator;
            }
            resetAllUse() {
                this.setUseValue(CharacterPropertiesMask.UseAll, !1);
            }
            setAllUse() {
                this.setUseValue(CharacterPropertiesMask.UseAll, !0);
            }
            clone() {
                var result = new MaskedCharacterProperties;
                return result.copyFrom(this), result;
            }
            copyFrom(obj) {
                super.copyFrom(obj), this.useValue = obj.useValue, this.useValueExt = obj.useValueExt;
            }
            equals(obj) {
                return super.equals(obj) && this.useValue == obj.useValue && this.useValueExt == obj.useValueExt;
            }
            static createDefault(model) {
                const prop = model.defaultCharacterProperties.clone();
                return prop.useValue = 0, prop.useValueExt = 0, prop;
            }
            setValue(desc, value) {
                desc.setProp(this, value), this.setUseValue(desc.maskValue(), !0);
            }
        }
        MaskedCharacterProperties.denominator = 4294967296;
        class HashBasedCacheCore {
            constructor() {
                this.clear();
            }
            get count() {
                return this.numElements;
            }
            clear() {
                this.hashtable = {}, this.numElements = 0;
            }
            getItem(item) {
                const existingElement = this.addItemInternal(this.hashtable, item);
                return null !== existingElement ? existingElement : (this.processNewItem(item), 
                this.numElements++, item);
            }
            forEach(callback) {
                number.j.forEach(this.hashtable, (items => utils_list.ListUtils.forEach(items, callback)));
            }
            findItemByPredicate(predicate) {
                return number.j.anyOf(this.hashtable, (items => utils_list.ListUtils.elementBy(items, (item => predicate(item)))));
            }
            processNewItem(_item) {}
            isExist(item) {
                const hash = item.getHashCode();
                let listOfElements = this.hashtable[hash];
                if (listOfElements) for (let elem, i = 0; elem = listOfElements[i]; i++) if (elem === item || elem.equals(item)) return !0;
                return !1;
            }
            DEBUG_MAX_CELL_LENGTH() {
                return number.j.max(this.hashtable, (a => a.length)).length;
            }
            removeItems(shouldRemove) {
                const newHashtable = {};
                let numElements = 0;
                number.j.forEach(this.hashtable, (items => items.forEach((item => {
                    shouldRemove(item) || (this.addItemInternal(newHashtable, item), numElements++);
                })))), this.hashtable = newHashtable, this.numElements = numElements;
            }
            addItemInternal(hashtable, item) {
                const hash = item.getHashCode();
                let listOfElements = hashtable[hash];
                if (listOfElements) {
                    for (let elem, i = 0; elem = listOfElements[i]; i++) if (elem === item || elem.equals(item)) return elem;
                } else hashtable[hash] = listOfElements = [];
                return listOfElements.push(item), null;
            }
        }
        class HashBasedCache extends HashBasedCacheCore {
            constructor() {
                super();
            }
            clearTemporaryCache() {
                this.tempCacheForMerge = {};
            }
            clear() {
                super.clear(), this.clearTemporaryCache();
            }
            merge(jsonObjs, convertFromJSON) {
                number.j.forEach(jsonObjs, ((property, index) => this.addItemForMerge(convertFromJSON(property), index)));
            }
            getItemByJsonKey(jsonKey) {
                return this.tempCacheForMerge[jsonKey];
            }
            addItemForMerge(item, jsonKey) {
                return this.tempCacheForMerge[jsonKey] = this.getItem(item);
            }
            convertToJSON(convertToJSON) {
                const result = [];
                return number.j.forEach(this.hashtable, (items => utils_list.ListUtils.forEach(items, (item => result.push(convertToJSON(item)))))), 
                result;
            }
            indexOf(_item) {
                throw new Error(errors.D.NotImplemented);
            }
            copyFrom(obj) {
                this.hashtable = number.j.map(obj.hashtable, (el => utils_list.ListUtils.deepCopy(el))), 
                this.tempCacheForMerge = number.j.deepCopy(obj.tempCacheForMerge), this.numElements = obj.numElements;
            }
        }
        class ColorModelInfoCache extends HashBasedCache {
            constructor() {
                super(), this.getItem(color_model_info_ColorModelInfo.empty);
            }
            copyFrom(obj) {
                super.copyFrom(obj);
            }
            clone() {
                const result = new ColorModelInfoCache;
                return result.copyFrom(this), result;
            }
        }
        ColorModelInfoCache.defaultItem = color_model_info_ColorModelInfo.empty, function(BorderLineStyle) {
            BorderLineStyle[BorderLineStyle.Nil = -1] = "Nil", BorderLineStyle[BorderLineStyle.None = 0] = "None", 
            BorderLineStyle[BorderLineStyle.Single = 1] = "Single", BorderLineStyle[BorderLineStyle.Thick = 2] = "Thick", 
            BorderLineStyle[BorderLineStyle.Double = 3] = "Double", BorderLineStyle[BorderLineStyle.Dotted = 4] = "Dotted", 
            BorderLineStyle[BorderLineStyle.Dashed = 5] = "Dashed", BorderLineStyle[BorderLineStyle.DotDash = 6] = "DotDash", 
            BorderLineStyle[BorderLineStyle.DotDotDash = 7] = "DotDotDash", BorderLineStyle[BorderLineStyle.Triple = 8] = "Triple", 
            BorderLineStyle[BorderLineStyle.ThinThickSmallGap = 9] = "ThinThickSmallGap", BorderLineStyle[BorderLineStyle.ThickThinSmallGap = 10] = "ThickThinSmallGap", 
            BorderLineStyle[BorderLineStyle.ThinThickThinSmallGap = 11] = "ThinThickThinSmallGap", 
            BorderLineStyle[BorderLineStyle.ThinThickMediumGap = 12] = "ThinThickMediumGap", 
            BorderLineStyle[BorderLineStyle.ThickThinMediumGap = 13] = "ThickThinMediumGap", 
            BorderLineStyle[BorderLineStyle.ThinThickThinMediumGap = 14] = "ThinThickThinMediumGap", 
            BorderLineStyle[BorderLineStyle.ThinThickLargeGap = 15] = "ThinThickLargeGap", BorderLineStyle[BorderLineStyle.ThickThinLargeGap = 16] = "ThickThinLargeGap", 
            BorderLineStyle[BorderLineStyle.ThinThickThinLargeGap = 17] = "ThinThickThinLargeGap", 
            BorderLineStyle[BorderLineStyle.Wave = 18] = "Wave", BorderLineStyle[BorderLineStyle.DoubleWave = 19] = "DoubleWave", 
            BorderLineStyle[BorderLineStyle.DashSmallGap = 20] = "DashSmallGap", BorderLineStyle[BorderLineStyle.DashDotStroked = 21] = "DashDotStroked", 
            BorderLineStyle[BorderLineStyle.ThreeDEmboss = 22] = "ThreeDEmboss", BorderLineStyle[BorderLineStyle.ThreeDEngrave = 23] = "ThreeDEngrave", 
            BorderLineStyle[BorderLineStyle.Outset = 24] = "Outset", BorderLineStyle[BorderLineStyle.Inset = 25] = "Inset", 
            BorderLineStyle[BorderLineStyle.Apples = 26] = "Apples", BorderLineStyle[BorderLineStyle.ArchedScallops = 27] = "ArchedScallops", 
            BorderLineStyle[BorderLineStyle.BabyPacifier = 28] = "BabyPacifier", BorderLineStyle[BorderLineStyle.BabyRattle = 29] = "BabyRattle", 
            BorderLineStyle[BorderLineStyle.Balloons3Colors = 30] = "Balloons3Colors", BorderLineStyle[BorderLineStyle.BalloonsHotAir = 31] = "BalloonsHotAir", 
            BorderLineStyle[BorderLineStyle.BasicBlackDashes = 32] = "BasicBlackDashes", BorderLineStyle[BorderLineStyle.BasicBlackDots = 33] = "BasicBlackDots", 
            BorderLineStyle[BorderLineStyle.BasicBlackSquares = 34] = "BasicBlackSquares", BorderLineStyle[BorderLineStyle.BasicThinLines = 35] = "BasicThinLines", 
            BorderLineStyle[BorderLineStyle.BasicWhiteDashes = 36] = "BasicWhiteDashes", BorderLineStyle[BorderLineStyle.BasicWhiteDots = 37] = "BasicWhiteDots", 
            BorderLineStyle[BorderLineStyle.BasicWhiteSquares = 38] = "BasicWhiteSquares", BorderLineStyle[BorderLineStyle.BasicWideInline = 39] = "BasicWideInline", 
            BorderLineStyle[BorderLineStyle.BasicWideMidline = 40] = "BasicWideMidline", BorderLineStyle[BorderLineStyle.BasicWideOutline = 41] = "BasicWideOutline", 
            BorderLineStyle[BorderLineStyle.Bats = 42] = "Bats", BorderLineStyle[BorderLineStyle.Birds = 43] = "Birds", 
            BorderLineStyle[BorderLineStyle.BirdsFlight = 44] = "BirdsFlight", BorderLineStyle[BorderLineStyle.Cabins = 45] = "Cabins", 
            BorderLineStyle[BorderLineStyle.CakeSlice = 46] = "CakeSlice", BorderLineStyle[BorderLineStyle.CandyCorn = 47] = "CandyCorn", 
            BorderLineStyle[BorderLineStyle.CelticKnotwork = 48] = "CelticKnotwork", BorderLineStyle[BorderLineStyle.CertificateBanner = 49] = "CertificateBanner", 
            BorderLineStyle[BorderLineStyle.ChainLink = 50] = "ChainLink", BorderLineStyle[BorderLineStyle.ChampagneBottle = 51] = "ChampagneBottle", 
            BorderLineStyle[BorderLineStyle.CheckedBarBlack = 52] = "CheckedBarBlack", BorderLineStyle[BorderLineStyle.CheckedBarColor = 53] = "CheckedBarColor", 
            BorderLineStyle[BorderLineStyle.Checkered = 54] = "Checkered", BorderLineStyle[BorderLineStyle.ChristmasTree = 55] = "ChristmasTree", 
            BorderLineStyle[BorderLineStyle.CirclesLines = 56] = "CirclesLines", BorderLineStyle[BorderLineStyle.CirclesRectangles = 57] = "CirclesRectangles", 
            BorderLineStyle[BorderLineStyle.ClassicalWave = 58] = "ClassicalWave", BorderLineStyle[BorderLineStyle.Clocks = 59] = "Clocks", 
            BorderLineStyle[BorderLineStyle.Compass = 60] = "Compass", BorderLineStyle[BorderLineStyle.Confetti = 61] = "Confetti", 
            BorderLineStyle[BorderLineStyle.ConfettiGrays = 62] = "ConfettiGrays", BorderLineStyle[BorderLineStyle.ConfettiOutline = 63] = "ConfettiOutline", 
            BorderLineStyle[BorderLineStyle.ConfettiStreamers = 64] = "ConfettiStreamers", BorderLineStyle[BorderLineStyle.ConfettiWhite = 65] = "ConfettiWhite", 
            BorderLineStyle[BorderLineStyle.CornerTriangles = 66] = "CornerTriangles", BorderLineStyle[BorderLineStyle.CouponCutoutDashes = 67] = "CouponCutoutDashes", 
            BorderLineStyle[BorderLineStyle.CouponCutoutDots = 68] = "CouponCutoutDots", BorderLineStyle[BorderLineStyle.CrazyMaze = 69] = "CrazyMaze", 
            BorderLineStyle[BorderLineStyle.CreaturesButterfly = 70] = "CreaturesButterfly", 
            BorderLineStyle[BorderLineStyle.CreaturesFish = 71] = "CreaturesFish", BorderLineStyle[BorderLineStyle.CreaturesInsects = 72] = "CreaturesInsects", 
            BorderLineStyle[BorderLineStyle.CreaturesLadyBug = 73] = "CreaturesLadyBug", BorderLineStyle[BorderLineStyle.CrossStitch = 74] = "CrossStitch", 
            BorderLineStyle[BorderLineStyle.Cup = 75] = "Cup", BorderLineStyle[BorderLineStyle.DecoArch = 76] = "DecoArch", 
            BorderLineStyle[BorderLineStyle.DecoArchColor = 77] = "DecoArchColor", BorderLineStyle[BorderLineStyle.DecoBlocks = 78] = "DecoBlocks", 
            BorderLineStyle[BorderLineStyle.DiamondsGray = 79] = "DiamondsGray", BorderLineStyle[BorderLineStyle.DoubleD = 80] = "DoubleD", 
            BorderLineStyle[BorderLineStyle.DoubleDiamonds = 81] = "DoubleDiamonds", BorderLineStyle[BorderLineStyle.Earth1 = 82] = "Earth1", 
            BorderLineStyle[BorderLineStyle.Earth2 = 83] = "Earth2", BorderLineStyle[BorderLineStyle.EclipsingSquares1 = 84] = "EclipsingSquares1", 
            BorderLineStyle[BorderLineStyle.EclipsingSquares2 = 85] = "EclipsingSquares2", BorderLineStyle[BorderLineStyle.EggsBlack = 86] = "EggsBlack", 
            BorderLineStyle[BorderLineStyle.Fans = 87] = "Fans", BorderLineStyle[BorderLineStyle.Film = 88] = "Film", 
            BorderLineStyle[BorderLineStyle.Firecrackers = 89] = "Firecrackers", BorderLineStyle[BorderLineStyle.FlowersBlockPrint = 90] = "FlowersBlockPrint", 
            BorderLineStyle[BorderLineStyle.FlowersDaisies = 91] = "FlowersDaisies", BorderLineStyle[BorderLineStyle.FlowersModern1 = 92] = "FlowersModern1", 
            BorderLineStyle[BorderLineStyle.FlowersModern2 = 93] = "FlowersModern2", BorderLineStyle[BorderLineStyle.FlowersPansy = 94] = "FlowersPansy", 
            BorderLineStyle[BorderLineStyle.FlowersRedRose = 95] = "FlowersRedRose", BorderLineStyle[BorderLineStyle.FlowersRoses = 96] = "FlowersRoses", 
            BorderLineStyle[BorderLineStyle.FlowersTeacup = 97] = "FlowersTeacup", BorderLineStyle[BorderLineStyle.FlowersTiny = 98] = "FlowersTiny", 
            BorderLineStyle[BorderLineStyle.Gems = 99] = "Gems", BorderLineStyle[BorderLineStyle.GingerbreadMan = 100] = "GingerbreadMan", 
            BorderLineStyle[BorderLineStyle.Gradient = 101] = "Gradient", BorderLineStyle[BorderLineStyle.Handmade1 = 102] = "Handmade1", 
            BorderLineStyle[BorderLineStyle.Handmade2 = 103] = "Handmade2", BorderLineStyle[BorderLineStyle.HeartBalloon = 104] = "HeartBalloon", 
            BorderLineStyle[BorderLineStyle.HeartGray = 105] = "HeartGray", BorderLineStyle[BorderLineStyle.Hearts = 106] = "Hearts", 
            BorderLineStyle[BorderLineStyle.HeebieJeebies = 107] = "HeebieJeebies", BorderLineStyle[BorderLineStyle.Holly = 108] = "Holly", 
            BorderLineStyle[BorderLineStyle.HouseFunky = 109] = "HouseFunky", BorderLineStyle[BorderLineStyle.Hypnotic = 110] = "Hypnotic", 
            BorderLineStyle[BorderLineStyle.IceCreamCones = 111] = "IceCreamCones", BorderLineStyle[BorderLineStyle.LightBulb = 112] = "LightBulb", 
            BorderLineStyle[BorderLineStyle.Lightning1 = 113] = "Lightning1", BorderLineStyle[BorderLineStyle.Lightning2 = 114] = "Lightning2", 
            BorderLineStyle[BorderLineStyle.MapleLeaf = 115] = "MapleLeaf", BorderLineStyle[BorderLineStyle.MapleMuffins = 116] = "MapleMuffins", 
            BorderLineStyle[BorderLineStyle.MapPins = 117] = "MapPins", BorderLineStyle[BorderLineStyle.Marquee = 118] = "Marquee", 
            BorderLineStyle[BorderLineStyle.MarqueeToothed = 119] = "MarqueeToothed", BorderLineStyle[BorderLineStyle.Moons = 120] = "Moons", 
            BorderLineStyle[BorderLineStyle.Mosaic = 121] = "Mosaic", BorderLineStyle[BorderLineStyle.MusicNotes = 122] = "MusicNotes", 
            BorderLineStyle[BorderLineStyle.Northwest = 123] = "Northwest", BorderLineStyle[BorderLineStyle.Ovals = 124] = "Ovals", 
            BorderLineStyle[BorderLineStyle.Packages = 125] = "Packages", BorderLineStyle[BorderLineStyle.PalmsBlack = 126] = "PalmsBlack", 
            BorderLineStyle[BorderLineStyle.PalmsColor = 127] = "PalmsColor", BorderLineStyle[BorderLineStyle.PaperClips = 128] = "PaperClips", 
            BorderLineStyle[BorderLineStyle.Papyrus = 129] = "Papyrus", BorderLineStyle[BorderLineStyle.PartyFavor = 130] = "PartyFavor", 
            BorderLineStyle[BorderLineStyle.PartyGlass = 131] = "PartyGlass", BorderLineStyle[BorderLineStyle.Pencils = 132] = "Pencils", 
            BorderLineStyle[BorderLineStyle.People = 133] = "People", BorderLineStyle[BorderLineStyle.PeopleHats = 134] = "PeopleHats", 
            BorderLineStyle[BorderLineStyle.PeopleWaving = 135] = "PeopleWaving", BorderLineStyle[BorderLineStyle.Poinsettias = 136] = "Poinsettias", 
            BorderLineStyle[BorderLineStyle.PostageStamp = 137] = "PostageStamp", BorderLineStyle[BorderLineStyle.Pumpkin1 = 138] = "Pumpkin1", 
            BorderLineStyle[BorderLineStyle.PushPinNote1 = 139] = "PushPinNote1", BorderLineStyle[BorderLineStyle.PushPinNote2 = 140] = "PushPinNote2", 
            BorderLineStyle[BorderLineStyle.Pyramids = 141] = "Pyramids", BorderLineStyle[BorderLineStyle.PyramidsAbove = 142] = "PyramidsAbove", 
            BorderLineStyle[BorderLineStyle.Quadrants = 143] = "Quadrants", BorderLineStyle[BorderLineStyle.Rings = 144] = "Rings", 
            BorderLineStyle[BorderLineStyle.Safari = 145] = "Safari", BorderLineStyle[BorderLineStyle.Sawtooth = 146] = "Sawtooth", 
            BorderLineStyle[BorderLineStyle.SawtoothGray = 147] = "SawtoothGray", BorderLineStyle[BorderLineStyle.ScaredCat = 148] = "ScaredCat", 
            BorderLineStyle[BorderLineStyle.Seattle = 149] = "Seattle", BorderLineStyle[BorderLineStyle.ShadowedSquares = 150] = "ShadowedSquares", 
            BorderLineStyle[BorderLineStyle.SharksTeeth = 151] = "SharksTeeth", BorderLineStyle[BorderLineStyle.ShorebirdTracks = 152] = "ShorebirdTracks", 
            BorderLineStyle[BorderLineStyle.Skyrocket = 153] = "Skyrocket", BorderLineStyle[BorderLineStyle.SnowflakeFancy = 154] = "SnowflakeFancy", 
            BorderLineStyle[BorderLineStyle.Snowflakes = 155] = "Snowflakes", BorderLineStyle[BorderLineStyle.Sombrero = 156] = "Sombrero", 
            BorderLineStyle[BorderLineStyle.Southwest = 157] = "Southwest", BorderLineStyle[BorderLineStyle.Stars = 158] = "Stars", 
            BorderLineStyle[BorderLineStyle.Stars3d = 159] = "Stars3d", BorderLineStyle[BorderLineStyle.StarsBlack = 160] = "StarsBlack", 
            BorderLineStyle[BorderLineStyle.StarsShadowed = 161] = "StarsShadowed", BorderLineStyle[BorderLineStyle.StarsTop = 162] = "StarsTop", 
            BorderLineStyle[BorderLineStyle.Sun = 163] = "Sun", BorderLineStyle[BorderLineStyle.Swirligig = 164] = "Swirligig", 
            BorderLineStyle[BorderLineStyle.TornPaper = 165] = "TornPaper", BorderLineStyle[BorderLineStyle.TornPaperBlack = 166] = "TornPaperBlack", 
            BorderLineStyle[BorderLineStyle.Trees = 167] = "Trees", BorderLineStyle[BorderLineStyle.TriangleParty = 168] = "TriangleParty", 
            BorderLineStyle[BorderLineStyle.Triangles = 169] = "Triangles", BorderLineStyle[BorderLineStyle.Tribal1 = 170] = "Tribal1", 
            BorderLineStyle[BorderLineStyle.Tribal2 = 171] = "Tribal2", BorderLineStyle[BorderLineStyle.Tribal3 = 172] = "Tribal3", 
            BorderLineStyle[BorderLineStyle.Tribal4 = 173] = "Tribal4", BorderLineStyle[BorderLineStyle.Tribal5 = 174] = "Tribal5", 
            BorderLineStyle[BorderLineStyle.Tribal6 = 175] = "Tribal6", BorderLineStyle[BorderLineStyle.TwistedLines1 = 176] = "TwistedLines1", 
            BorderLineStyle[BorderLineStyle.TwistedLines2 = 177] = "TwistedLines2", BorderLineStyle[BorderLineStyle.Vine = 178] = "Vine", 
            BorderLineStyle[BorderLineStyle.Waveline = 179] = "Waveline", BorderLineStyle[BorderLineStyle.WeavingAngles = 180] = "WeavingAngles", 
            BorderLineStyle[BorderLineStyle.WeavingBraid = 181] = "WeavingBraid", BorderLineStyle[BorderLineStyle.WeavingRibbon = 182] = "WeavingRibbon", 
            BorderLineStyle[BorderLineStyle.WeavingStrips = 183] = "WeavingStrips", BorderLineStyle[BorderLineStyle.WhiteFlowers = 184] = "WhiteFlowers", 
            BorderLineStyle[BorderLineStyle.Woodwork = 185] = "Woodwork", BorderLineStyle[BorderLineStyle.XIllusions = 186] = "XIllusions", 
            BorderLineStyle[BorderLineStyle.ZanyTriangles = 187] = "ZanyTriangles", BorderLineStyle[BorderLineStyle.ZigZag = 188] = "ZigZag", 
            BorderLineStyle[BorderLineStyle.ZigZagStitch = 189] = "ZigZagStitch", BorderLineStyle[BorderLineStyle.Disabled = 2147483647] = "Disabled";
        }(BorderLineStyle || (BorderLineStyle = {}));
        class BorderBase {
            constructor(style, width, color) {
                this.style = style, this.width = width, this.color = color;
            }
            static getEmpty() {
                return BorderBase.empty.clone();
            }
            clone() {
                return new BorderBase(this.style, this.width, this.color);
            }
            equals(obj) {
                return obj && this.style == obj.style && this.width == obj.width && this.color == obj.color;
            }
        }
        BorderBase.empty = new BorderBase(BorderLineStyle.None, 0, ColorHelper.AUTOMATIC_COLOR);
        class LayoutBorder extends BorderBase {}
        class BorderInfo {
            constructor() {
                this.style = BorderLineStyle.None, this.color = ColorModelInfoCache.defaultItem, 
                this.width = 0, this.offset = 0, this.frame = !1, this.shadow = !1;
            }
            getHashCode() {
                return math.MathUtils.somePrimes[0] * this.style ^ math.MathUtils.somePrimes[1] * this.color.getHashCode() ^ math.MathUtils.somePrimes[2] * this.width;
            }
            getBorderBase(colorProvider) {
                return new BorderBase(this.style, this.width, this.color.toRgb(colorProvider));
            }
            getLayoutBorder(colorProvider) {
                return new LayoutBorder(this.style, this.width, this.color.toRgb(colorProvider));
            }
            equals(obj) {
                return obj && this.style == obj.style && this.color.equals(obj.color) && this.width == obj.width && this.offset == obj.offset && this.frame == obj.frame && this.shadow == obj.shadow;
            }
            static equalsBinary(borderInfoA, borderInfoB) {
                return borderInfoA && borderInfoB && borderInfoA.style == borderInfoB.style && borderInfoA.color.equals(borderInfoB.color) && borderInfoA.width == borderInfoB.width && borderInfoA.offset == borderInfoB.offset && borderInfoA.frame == borderInfoB.frame && borderInfoA.shadow == borderInfoB.shadow;
            }
            copyFrom(obj) {
                this.style = obj.style, this.color = obj.color.clone(), this.width = obj.width, 
                this.offset = obj.offset, this.frame = obj.frame, this.shadow = obj.shadow;
            }
            clone() {
                var result = new BorderInfo;
                return result.copyFrom(this), result;
            }
        }
        var JSONParagraphFormattingProperty, JSONParagraphProperty, JSONMergeParagraphsCommandProperty, JSONInsertParagraphCommandProperty, JSONParagraphPropertiesChangedProperty, ParagraphPropertiesMask, ParagraphAlignment, ParagraphLineSpacingType, ParagraphFirstLineIndent, TableLayoutType, TableLookTypes, HorizontalAlignMode, VerticalAlignMode, HorizontalAnchorTypes, VerticalAnchorTypes, TextWrapping, TableRowAlignment, TableCellMergingState, TextDirection, TableCellVerticalAlignment, ConditionalTableStyleFormatting, TableHeightUnitType, TableWidthUnitType, TableCellPropertiesMask, comparers = __webpack_require__(4170);
        class history_item_HistoryItem {
            constructor(modelManipulator) {
                this.uniqueId = -1, this.modelManipulator = modelManipulator;
            }
            canBeMerged() {
                return !1;
            }
            changeModified() {
                return !0;
            }
        }
        class CompositionHistoryItem extends history_item_HistoryItem {
            constructor() {
                super(null), this.historyItems = [];
            }
            canBeMerged() {
                return !0;
            }
            changeModified() {
                for (var item, i = 0; item = this.historyItems[i]; i++) if (item.changeModified()) return !0;
                return !1;
            }
            redo() {
                for (var item, i = 0; item = this.historyItems[i]; i++) item.redo();
            }
            undo() {
                for (var item, i = this.historyItems.length - 1; item = this.historyItems[i]; i--) item.undo();
            }
            add(historyItem) {
                if (null == historyItem) throw new Error(errors.D.ValueCannotBeNull);
                this.historyItems.push(historyItem);
            }
        }
        class interval_based_history_item_IntervalBasedHistoryItem extends history_item_HistoryItem {
            constructor(modelManipulator, subDocInterval) {
                super(modelManipulator), this.subDocInterval = subDocInterval;
            }
            get boundSubDocument() {
                return this.subDocInterval.subDocument;
            }
            get interval() {
                return this.subDocInterval.interval;
            }
        }
        class ParagraphUseValueHistoryItem extends interval_based_history_item_IntervalBasedHistoryItem {
            constructor(modelManipulator, subDocInterval, newValue) {
                super(modelManipulator, subDocInterval), this.newValue = newValue;
            }
            redo() {
                this.oldState = this.modelManipulator.paragraphProperties.useValue.setValue(this.boundSubDocument, this.interval, this.newValue);
            }
            undo() {
                this.modelManipulator.paragraphProperties.useValue.restoreValue(this.boundSubDocument, this.oldState);
            }
        }
        class TabHistoryItemBase extends interval_based_history_item_IntervalBasedHistoryItem {
            constructor(modelManipulator, subDocInterval, tabInfo) {
                super(modelManipulator, subDocInterval), this.tabInfo = tabInfo;
            }
        }
        class InsertTabToParagraphHistoryItem extends TabHistoryItemBase {
            redo() {
                this.oldState = this.modelManipulator.tab.insertTabToParagraph(this.boundSubDocument, this.interval, this.tabInfo);
            }
            undo() {
                this.modelManipulator.tab.restoreInsertedTabToParagraph(this.boundSubDocument, this.oldState);
            }
        }
        class DeleteTabAtParagraphHistoryItem extends TabHistoryItemBase {
            redo() {
                this.oldState = this.modelManipulator.tab.deleteTabAtParagraph(this.boundSubDocument, this.interval, this.tabInfo);
            }
            undo() {
                this.modelManipulator.tab.restoreDeletedTabAtParagraph(this.boundSubDocument, this.oldState);
            }
        }
        class ParagraphPropertiesHistoryItemBase extends interval_based_history_item_IntervalBasedHistoryItem {
            constructor(modelManipulator, subDocInterval, newValue, newUse) {
                super(modelManipulator, subDocInterval), this.newValue = newValue, this.newUse = newUse;
            }
            redo() {
                this.oldState = this.getPropertiesManipulator().setValue(this.boundSubDocument, this.interval, this.newValue, this.newUse);
            }
            undo() {
                this.getPropertiesManipulator().restoreValue(this.boundSubDocument, this.oldState);
            }
            getPropertiesManipulator() {
                throw new Error(errors.D.NotImplemented);
            }
        }
        class ParagraphAlignmentHistoryItem extends ParagraphPropertiesHistoryItemBase {
            getPropertiesManipulator() {
                return this.modelManipulator.paragraphProperties.align;
            }
        }
        class ParagraphContextualSpacingHistoryItem extends ParagraphPropertiesHistoryItemBase {
            getPropertiesManipulator() {
                return this.modelManipulator.paragraphProperties.contextualSpacing;
            }
        }
        class ParagraphRightToLeftHistoryItem extends ParagraphPropertiesHistoryItemBase {
            getPropertiesManipulator() {
                return this.modelManipulator.paragraphProperties.rightToLeft;
            }
        }
        class ParagraphAfterAutoSpacingHistoryItem extends ParagraphPropertiesHistoryItemBase {
            getPropertiesManipulator() {
                return this.modelManipulator.paragraphProperties.afterAutoSpacing;
            }
        }
        class ParagraphShadingInfoIndexHistoryItem extends ParagraphPropertiesHistoryItemBase {
            getPropertiesManipulator() {
                return this.modelManipulator.paragraphProperties.shadingInfo;
            }
        }
        class ParagraphBeforeAutoSpacingHistoryItem extends ParagraphPropertiesHistoryItemBase {
            getPropertiesManipulator() {
                return this.modelManipulator.paragraphProperties.beforeAutoSpacing;
            }
        }
        class ParagraphFirstLineIndentHistoryItem extends ParagraphPropertiesHistoryItemBase {
            getPropertiesManipulator() {
                return this.modelManipulator.paragraphProperties.firstLineIndent;
            }
        }
        class ParagraphFirstLineIndentTypeHistoryItem extends ParagraphPropertiesHistoryItemBase {
            getPropertiesManipulator() {
                return this.modelManipulator.paragraphProperties.firstLineIndentType;
            }
        }
        class ParagraphKeepLinesTogetherHistoryItem extends ParagraphPropertiesHistoryItemBase {
            getPropertiesManipulator() {
                return this.modelManipulator.paragraphProperties.keepLinesTogether;
            }
        }
        class ParagraphLeftIndentHistoryItem extends ParagraphPropertiesHistoryItemBase {
            getPropertiesManipulator() {
                return this.modelManipulator.paragraphProperties.leftIndent;
            }
        }
        class ParagraphLineSpacingHistoryItem extends ParagraphPropertiesHistoryItemBase {
            getPropertiesManipulator() {
                return this.modelManipulator.paragraphProperties.lineSpacing;
            }
        }
        class ParagraphLineSpacingTypeHistoryItem extends ParagraphPropertiesHistoryItemBase {
            getPropertiesManipulator() {
                return this.modelManipulator.paragraphProperties.lineSpacingType;
            }
        }
        class ParagraphOutlineLevelHistoryItem extends ParagraphPropertiesHistoryItemBase {
            getPropertiesManipulator() {
                return this.modelManipulator.paragraphProperties.outlineLevel;
            }
        }
        class ParagraphPageBreakBeforeHistoryItem extends ParagraphPropertiesHistoryItemBase {
            getPropertiesManipulator() {
                return this.modelManipulator.paragraphProperties.pageBreakBefore;
            }
        }
        class ParagraphRightIndentHistoryItem extends ParagraphPropertiesHistoryItemBase {
            getPropertiesManipulator() {
                return this.modelManipulator.paragraphProperties.rightIndent;
            }
        }
        class ParagraphSpacingAfterHistoryItem extends ParagraphPropertiesHistoryItemBase {
            getPropertiesManipulator() {
                return this.modelManipulator.paragraphProperties.spacingAfter;
            }
        }
        class ParagraphSpacingBeforeHistoryItem extends ParagraphPropertiesHistoryItemBase {
            getPropertiesManipulator() {
                return this.modelManipulator.paragraphProperties.spacingBefore;
            }
        }
        class ParagraphSuppressHyphenationHistoryItem extends ParagraphPropertiesHistoryItemBase {
            getPropertiesManipulator() {
                return this.modelManipulator.paragraphProperties.suppressHyphenation;
            }
        }
        class ParagraphSuppressLineNumbersHistoryItem extends ParagraphPropertiesHistoryItemBase {
            getPropertiesManipulator() {
                return this.modelManipulator.paragraphProperties.suppressLineNumbers;
            }
        }
        class ParagraphWidowOrphanControlHistoryItem extends ParagraphPropertiesHistoryItemBase {
            getPropertiesManipulator() {
                return this.modelManipulator.paragraphProperties.widowOrphanControl;
            }
        }
        class ParagraphDivIdHistoryItem extends ParagraphPropertiesHistoryItemBase {
            getPropertiesManipulator() {
                return this.modelManipulator.paragraphProperties.divId;
            }
        }
        class ParagraphKeepWithNextHistoryItem extends ParagraphPropertiesHistoryItemBase {
            getPropertiesManipulator() {
                return this.modelManipulator.paragraphProperties.keepWithNext;
            }
        }
        class ParagraphPropertiesHistoryItem extends history_item_HistoryItem {
            constructor(modelManipulator, subDocument, paragraphIndex, paragraphProperties, style, numberingListIndex, listLevelIndex, tabs) {
                super(modelManipulator), this.subDocument = subDocument, this.paragraphIndex = paragraphIndex, 
                this.style = style, this.numberingListIndex = numberingListIndex, this.listLevelIndex = listLevelIndex, 
                this.paragraphProperties = paragraphProperties, this.tabs = tabs.clone();
            }
            redo() {
                let paragraph = this.subDocument.paragraphs[this.paragraphIndex];
                this.oldParagraphProperties = paragraph.maskedParagraphProperties, this.oldStyle = paragraph.paragraphStyle, 
                this.oldNumberingListIndex = paragraph.numberingListIndex, this.oldListLevelIndex = paragraph.listLevelIndex, 
                this.oldTabs = paragraph.tabs.clone(), this.modelManipulator.paragraphProperties.changeAllProperties(this.subDocument, this.paragraphIndex, this.paragraphProperties, this.style, this.tabs, this.numberingListIndex, this.listLevelIndex);
            }
            undo() {
                this.modelManipulator.paragraphProperties.changeAllProperties(this.subDocument, this.paragraphIndex, this.oldParagraphProperties, this.oldStyle, this.oldTabs, this.oldNumberingListIndex, this.oldListLevelIndex);
            }
        }
        !function(JSONParagraphFormattingProperty) {
            JSONParagraphFormattingProperty[JSONParagraphFormattingProperty.Alignment = 0] = "Alignment", 
            JSONParagraphFormattingProperty[JSONParagraphFormattingProperty.FirstLineIndent = 1] = "FirstLineIndent", 
            JSONParagraphFormattingProperty[JSONParagraphFormattingProperty.FirstLineIndentType = 2] = "FirstLineIndentType", 
            JSONParagraphFormattingProperty[JSONParagraphFormattingProperty.LeftIndent = 3] = "LeftIndent", 
            JSONParagraphFormattingProperty[JSONParagraphFormattingProperty.LineSpacing = 4] = "LineSpacing", 
            JSONParagraphFormattingProperty[JSONParagraphFormattingProperty.LineSpacingType = 5] = "LineSpacingType", 
            JSONParagraphFormattingProperty[JSONParagraphFormattingProperty.RightIndent = 6] = "RightIndent", 
            JSONParagraphFormattingProperty[JSONParagraphFormattingProperty.SpacingBefore = 7] = "SpacingBefore", 
            JSONParagraphFormattingProperty[JSONParagraphFormattingProperty.SpacingAfter = 8] = "SpacingAfter", 
            JSONParagraphFormattingProperty[JSONParagraphFormattingProperty.SuppressHyphenation = 9] = "SuppressHyphenation", 
            JSONParagraphFormattingProperty[JSONParagraphFormattingProperty.SuppressLineNumbers = 10] = "SuppressLineNumbers", 
            JSONParagraphFormattingProperty[JSONParagraphFormattingProperty.ContextualSpacing = 11] = "ContextualSpacing", 
            JSONParagraphFormattingProperty[JSONParagraphFormattingProperty.PageBreakBefore = 12] = "PageBreakBefore", 
            JSONParagraphFormattingProperty[JSONParagraphFormattingProperty.BeforeAutoSpacing = 13] = "BeforeAutoSpacing", 
            JSONParagraphFormattingProperty[JSONParagraphFormattingProperty.AfterAutoSpacing = 14] = "AfterAutoSpacing", 
            JSONParagraphFormattingProperty[JSONParagraphFormattingProperty.KeepWithNext = 15] = "KeepWithNext", 
            JSONParagraphFormattingProperty[JSONParagraphFormattingProperty.KeepLinesTogether = 16] = "KeepLinesTogether", 
            JSONParagraphFormattingProperty[JSONParagraphFormattingProperty.WidowOrphanControl = 17] = "WidowOrphanControl", 
            JSONParagraphFormattingProperty[JSONParagraphFormattingProperty.OutlineLevel = 18] = "OutlineLevel", 
            JSONParagraphFormattingProperty[JSONParagraphFormattingProperty.ShadingInfo = 19] = "ShadingInfo", 
            JSONParagraphFormattingProperty[JSONParagraphFormattingProperty.ShadingInfoIndex = 20] = "ShadingInfoIndex", 
            JSONParagraphFormattingProperty[JSONParagraphFormattingProperty.LeftBorder = 21] = "LeftBorder", 
            JSONParagraphFormattingProperty[JSONParagraphFormattingProperty.RightBorder = 22] = "RightBorder", 
            JSONParagraphFormattingProperty[JSONParagraphFormattingProperty.TopBorder = 23] = "TopBorder", 
            JSONParagraphFormattingProperty[JSONParagraphFormattingProperty.BottomBorder = 24] = "BottomBorder", 
            JSONParagraphFormattingProperty[JSONParagraphFormattingProperty.DivId = 25] = "DivId", 
            JSONParagraphFormattingProperty[JSONParagraphFormattingProperty.RightToLeft = 26] = "RightToLeft", 
            JSONParagraphFormattingProperty[JSONParagraphFormattingProperty.BetweenBorder = 27] = "BetweenBorder", 
            JSONParagraphFormattingProperty[JSONParagraphFormattingProperty.UseValue = 28] = "UseValue";
        }(JSONParagraphFormattingProperty || (JSONParagraphFormattingProperty = {})), function(JSONParagraphProperty) {
            JSONParagraphProperty[JSONParagraphProperty.MaskedParagraphPropertiesIndex = 0] = "MaskedParagraphPropertiesIndex", 
            JSONParagraphProperty[JSONParagraphProperty.ParagraphStyleIndex = 1] = "ParagraphStyleIndex", 
            JSONParagraphProperty[JSONParagraphProperty.LogPosition = 2] = "LogPosition", JSONParagraphProperty[JSONParagraphProperty.Length = 3] = "Length", 
            JSONParagraphProperty[JSONParagraphProperty.Tabs = 4] = "Tabs", JSONParagraphProperty[JSONParagraphProperty.ListIndex = 5] = "ListIndex", 
            JSONParagraphProperty[JSONParagraphProperty.ListLevelIndex = 6] = "ListLevelIndex";
        }(JSONParagraphProperty || (JSONParagraphProperty = {})), function(JSONMergeParagraphsCommandProperty) {
            JSONMergeParagraphsCommandProperty[JSONMergeParagraphsCommandProperty.Position = 0] = "Position", 
            JSONMergeParagraphsCommandProperty[JSONMergeParagraphsCommandProperty.GetPropertiesFromNext = 1] = "GetPropertiesFromNext";
        }(JSONMergeParagraphsCommandProperty || (JSONMergeParagraphsCommandProperty = {})), 
        function(JSONInsertParagraphCommandProperty) {
            JSONInsertParagraphCommandProperty[JSONInsertParagraphCommandProperty.Position = 0] = "Position", 
            JSONInsertParagraphCommandProperty[JSONInsertParagraphCommandProperty.NumberingListIndex = 1] = "NumberingListIndex", 
            JSONInsertParagraphCommandProperty[JSONInsertParagraphCommandProperty.ListLevelIndex = 2] = "ListLevelIndex", 
            JSONInsertParagraphCommandProperty[JSONInsertParagraphCommandProperty.StyleName = 3] = "StyleName", 
            JSONInsertParagraphCommandProperty[JSONInsertParagraphCommandProperty.ParagraphProperties = 4] = "ParagraphProperties", 
            JSONInsertParagraphCommandProperty[JSONInsertParagraphCommandProperty.ParagraphPropertiesIndex = 5] = "ParagraphPropertiesIndex", 
            JSONInsertParagraphCommandProperty[JSONInsertParagraphCommandProperty.TabsProperties = 6] = "TabsProperties";
        }(JSONInsertParagraphCommandProperty || (JSONInsertParagraphCommandProperty = {})), 
        function(JSONParagraphPropertiesChangedProperty) {
            JSONParagraphPropertiesChangedProperty[JSONParagraphPropertiesChangedProperty.ParagraphIndex = 0] = "ParagraphIndex", 
            JSONParagraphPropertiesChangedProperty[JSONParagraphPropertiesChangedProperty.ParagraphProperties = 1] = "ParagraphProperties", 
            JSONParagraphPropertiesChangedProperty[JSONParagraphPropertiesChangedProperty.NumberingListIndex = 2] = "NumberingListIndex", 
            JSONParagraphPropertiesChangedProperty[JSONParagraphPropertiesChangedProperty.ListLevelIndex = 3] = "ListLevelIndex", 
            JSONParagraphPropertiesChangedProperty[JSONParagraphPropertiesChangedProperty.TabsProperties = 4] = "TabsProperties", 
            JSONParagraphPropertiesChangedProperty[JSONParagraphPropertiesChangedProperty.StyleName = 5] = "StyleName";
        }(JSONParagraphPropertiesChangedProperty || (JSONParagraphPropertiesChangedProperty = {}));
        !function(ParagraphPropertiesMask) {
            ParagraphPropertiesMask[ParagraphPropertiesMask.UseNone = 0] = "UseNone", ParagraphPropertiesMask[ParagraphPropertiesMask.UseAlignment = 1] = "UseAlignment", 
            ParagraphPropertiesMask[ParagraphPropertiesMask.UseLeftIndent = 2] = "UseLeftIndent", 
            ParagraphPropertiesMask[ParagraphPropertiesMask.UseRightIndent = 4] = "UseRightIndent", 
            ParagraphPropertiesMask[ParagraphPropertiesMask.UseSpacingBefore = 8] = "UseSpacingBefore", 
            ParagraphPropertiesMask[ParagraphPropertiesMask.UseSpacingAfter = 16] = "UseSpacingAfter", 
            ParagraphPropertiesMask[ParagraphPropertiesMask.UseLineSpacing = 32] = "UseLineSpacing", 
            ParagraphPropertiesMask[ParagraphPropertiesMask.UseFirstLineIndent = 64] = "UseFirstLineIndent", 
            ParagraphPropertiesMask[ParagraphPropertiesMask.UseSuppressHyphenation = 128] = "UseSuppressHyphenation", 
            ParagraphPropertiesMask[ParagraphPropertiesMask.UseSuppressLineNumbers = 256] = "UseSuppressLineNumbers", 
            ParagraphPropertiesMask[ParagraphPropertiesMask.UseContextualSpacing = 512] = "UseContextualSpacing", 
            ParagraphPropertiesMask[ParagraphPropertiesMask.UsePageBreakBefore = 1024] = "UsePageBreakBefore", 
            ParagraphPropertiesMask[ParagraphPropertiesMask.UseBeforeAutoSpacing = 2048] = "UseBeforeAutoSpacing", 
            ParagraphPropertiesMask[ParagraphPropertiesMask.UseAfterAutoSpacing = 4096] = "UseAfterAutoSpacing", 
            ParagraphPropertiesMask[ParagraphPropertiesMask.UseKeepWithNext = 8192] = "UseKeepWithNext", 
            ParagraphPropertiesMask[ParagraphPropertiesMask.UseKeepLinesTogether = 16384] = "UseKeepLinesTogether", 
            ParagraphPropertiesMask[ParagraphPropertiesMask.UseWidowOrphanControl = 32768] = "UseWidowOrphanControl", 
            ParagraphPropertiesMask[ParagraphPropertiesMask.UseOutlineLevel = 65536] = "UseOutlineLevel", 
            ParagraphPropertiesMask[ParagraphPropertiesMask.UseShadingInfoIndex = 131072] = "UseShadingInfoIndex", 
            ParagraphPropertiesMask[ParagraphPropertiesMask.UseLeftBorder = 262144] = "UseLeftBorder", 
            ParagraphPropertiesMask[ParagraphPropertiesMask.UseRightBorder = 524288] = "UseRightBorder", 
            ParagraphPropertiesMask[ParagraphPropertiesMask.UseTopBorder = 1048576] = "UseTopBorder", 
            ParagraphPropertiesMask[ParagraphPropertiesMask.UseBottomBorder = 2097152] = "UseBottomBorder", 
            ParagraphPropertiesMask[ParagraphPropertiesMask.UseDivId = 4194304] = "UseDivId", 
            ParagraphPropertiesMask[ParagraphPropertiesMask.UseBorders = 20709376] = "UseBorders", 
            ParagraphPropertiesMask[ParagraphPropertiesMask.UseRightToLeft = 8388608] = "UseRightToLeft", 
            ParagraphPropertiesMask[ParagraphPropertiesMask.UseBetweenBorder = 16777216] = "UseBetweenBorder", 
            ParagraphPropertiesMask[ParagraphPropertiesMask.UseAll = 2147483647] = "UseAll";
        }(ParagraphPropertiesMask || (ParagraphPropertiesMask = {})), function(ParagraphAlignment) {
            ParagraphAlignment[ParagraphAlignment.Left = 0] = "Left", ParagraphAlignment[ParagraphAlignment.Right = 1] = "Right", 
            ParagraphAlignment[ParagraphAlignment.Center = 2] = "Center", ParagraphAlignment[ParagraphAlignment.Justify = 3] = "Justify", 
            ParagraphAlignment[ParagraphAlignment.JustifyMedium = 4] = "JustifyMedium", ParagraphAlignment[ParagraphAlignment.JustifyHigh = 5] = "JustifyHigh", 
            ParagraphAlignment[ParagraphAlignment.JustifyLow = 6] = "JustifyLow", ParagraphAlignment[ParagraphAlignment.Distribute = 7] = "Distribute", 
            ParagraphAlignment[ParagraphAlignment.ThaiDistribute = 8] = "ThaiDistribute";
        }(ParagraphAlignment || (ParagraphAlignment = {})), function(ParagraphLineSpacingType) {
            ParagraphLineSpacingType[ParagraphLineSpacingType.Single = 0] = "Single", ParagraphLineSpacingType[ParagraphLineSpacingType.Sesquialteral = 1] = "Sesquialteral", 
            ParagraphLineSpacingType[ParagraphLineSpacingType.Double = 2] = "Double", ParagraphLineSpacingType[ParagraphLineSpacingType.Multiple = 3] = "Multiple", 
            ParagraphLineSpacingType[ParagraphLineSpacingType.Exactly = 4] = "Exactly", ParagraphLineSpacingType[ParagraphLineSpacingType.AtLeast = 5] = "AtLeast";
        }(ParagraphLineSpacingType || (ParagraphLineSpacingType = {})), function(ParagraphFirstLineIndent) {
            ParagraphFirstLineIndent[ParagraphFirstLineIndent.None = 0] = "None", ParagraphFirstLineIndent[ParagraphFirstLineIndent.Indented = 1] = "Indented", 
            ParagraphFirstLineIndent[ParagraphFirstLineIndent.Hanging = 2] = "Hanging";
        }(ParagraphFirstLineIndent || (ParagraphFirstLineIndent = {}));
        class ParagraphPropertyDescriptor {}
        ParagraphPropertyDescriptor.firstLineIndent = new class ParagraphPropertiesFirstLineIndentDescriptor {
            constructor() {
                this.binaryEquals = comparers.Equals.simpleType, this.defaultValue = 0;
            }
            setProp(props, newValue) {
                props.firstLineIndent = newValue;
            }
            getProp(props) {
                return props.firstLineIndent;
            }
            maskValue() {
                return ParagraphPropertiesMask.UseFirstLineIndent;
            }
            getHistoryItemConstructor() {
                return ParagraphFirstLineIndentHistoryItem;
            }
            getJSONProperty() {
                return JSONParagraphFormattingProperty.FirstLineIndent;
            }
        }, ParagraphPropertyDescriptor.widowOrphanControl = new class ParagraphPropertiesWidowOrphanControlDescriptor {
            constructor() {
                this.binaryEquals = comparers.Equals.simpleType, this.defaultValue = !0;
            }
            setProp(props, newValue) {
                props.widowOrphanControl = newValue;
            }
            getProp(props) {
                return props.widowOrphanControl;
            }
            maskValue() {
                return ParagraphPropertiesMask.UseWidowOrphanControl;
            }
            getHistoryItemConstructor() {
                return ParagraphWidowOrphanControlHistoryItem;
            }
            getJSONProperty() {
                return JSONParagraphFormattingProperty.WidowOrphanControl;
            }
        }, ParagraphPropertyDescriptor.firstLineIndentType = new class ParagraphPropertiesFirstLineIndentTypeDescriptor {
            constructor() {
                this.binaryEquals = comparers.Equals.simpleType, this.defaultValue = ParagraphFirstLineIndent.None;
            }
            setProp(props, newValue) {
                props.firstLineIndentType = newValue;
            }
            getProp(props) {
                return props.firstLineIndentType;
            }
            maskValue() {
                return ParagraphPropertiesMask.UseFirstLineIndent;
            }
            getHistoryItemConstructor() {
                return ParagraphFirstLineIndentTypeHistoryItem;
            }
            getJSONProperty() {
                return JSONParagraphFormattingProperty.FirstLineIndentType;
            }
        }, ParagraphPropertyDescriptor.afterAutoSpacing = new class ParagraphPropertiesAfterAutoSpacingDescriptor {
            constructor() {
                this.binaryEquals = comparers.Equals.simpleType, this.defaultValue = !1;
            }
            setProp(props, newValue) {
                props.afterAutoSpacing = newValue;
            }
            getProp(props) {
                return props.afterAutoSpacing;
            }
            maskValue() {
                return ParagraphPropertiesMask.UseAfterAutoSpacing;
            }
            getHistoryItemConstructor() {
                return ParagraphAfterAutoSpacingHistoryItem;
            }
            getJSONProperty() {
                return JSONParagraphFormattingProperty.AfterAutoSpacing;
            }
        }, ParagraphPropertyDescriptor.outlineLevel = new class ParagraphPropertiesOutlineLevelDescriptor {
            constructor() {
                this.binaryEquals = comparers.Equals.simpleType, this.defaultValue = 0;
            }
            setProp(props, newValue) {
                props.outlineLevel = newValue;
            }
            getProp(props) {
                return props.outlineLevel;
            }
            maskValue() {
                return ParagraphPropertiesMask.UseOutlineLevel;
            }
            getHistoryItemConstructor() {
                return ParagraphOutlineLevelHistoryItem;
            }
            getJSONProperty() {
                return JSONParagraphFormattingProperty.OutlineLevel;
            }
        }, ParagraphPropertyDescriptor.beforeAutoSpacing = new class ParagraphPropertiesBeforeAutoSpacingDescriptor {
            constructor() {
                this.binaryEquals = comparers.Equals.simpleType, this.defaultValue = !1;
            }
            setProp(props, newValue) {
                props.beforeAutoSpacing = newValue;
            }
            getProp(props) {
                return props.beforeAutoSpacing;
            }
            maskValue() {
                return ParagraphPropertiesMask.UseBeforeAutoSpacing;
            }
            getHistoryItemConstructor() {
                return ParagraphBeforeAutoSpacingHistoryItem;
            }
            getJSONProperty() {
                return JSONParagraphFormattingProperty.BeforeAutoSpacing;
            }
        }, ParagraphPropertyDescriptor.pageBreakBefore = new class ParagraphPropertiesPageBreakBeforeDescriptor {
            constructor() {
                this.binaryEquals = comparers.Equals.simpleType, this.defaultValue = !1;
            }
            setProp(props, newValue) {
                props.pageBreakBefore = newValue;
            }
            getProp(props) {
                return props.pageBreakBefore;
            }
            maskValue() {
                return ParagraphPropertiesMask.UsePageBreakBefore;
            }
            getHistoryItemConstructor() {
                return ParagraphPageBreakBeforeHistoryItem;
            }
            getJSONProperty() {
                return JSONParagraphFormattingProperty.PageBreakBefore;
            }
        }, ParagraphPropertyDescriptor.rightIndent = new class ParagraphPropertiesRightIndentDescriptor {
            constructor() {
                this.binaryEquals = comparers.Equals.simpleType, this.defaultValue = 0;
            }
            setProp(props, newValue) {
                props.rightIndent = newValue;
            }
            getProp(props) {
                return props.rightIndent;
            }
            maskValue() {
                return ParagraphPropertiesMask.UseRightIndent;
            }
            getHistoryItemConstructor() {
                return ParagraphRightIndentHistoryItem;
            }
            getJSONProperty() {
                return JSONParagraphFormattingProperty.RightIndent;
            }
        }, ParagraphPropertyDescriptor.suppressHyphenation = new class ParagraphPropertiesSuppressHyphenationDescriptor {
            constructor() {
                this.binaryEquals = comparers.Equals.simpleType, this.defaultValue = !1;
            }
            setProp(props, newValue) {
                props.suppressHyphenation = newValue;
            }
            getProp(props) {
                return props.suppressHyphenation;
            }
            maskValue() {
                return ParagraphPropertiesMask.UseSuppressHyphenation;
            }
            getHistoryItemConstructor() {
                return ParagraphSuppressHyphenationHistoryItem;
            }
            getJSONProperty() {
                return JSONParagraphFormattingProperty.SuppressHyphenation;
            }
        }, ParagraphPropertyDescriptor.lineSpacing = new class ParagraphPropertiesLineSpacingDescriptor {
            constructor() {
                this.binaryEquals = comparers.Equals.simpleType, this.defaultValue = 0;
            }
            setProp(props, newValue) {
                props.lineSpacing = newValue;
            }
            getProp(props) {
                return props.lineSpacing;
            }
            maskValue() {
                return ParagraphPropertiesMask.UseLineSpacing;
            }
            getHistoryItemConstructor() {
                return ParagraphLineSpacingHistoryItem;
            }
            getJSONProperty() {
                return JSONParagraphFormattingProperty.LineSpacing;
            }
        }, ParagraphPropertyDescriptor.suppressLineNumbers = new class ParagraphPropertiesSuppressLineNumbersDescriptor {
            constructor() {
                this.binaryEquals = comparers.Equals.simpleType, this.defaultValue = !1;
            }
            setProp(props, newValue) {
                props.suppressLineNumbers = newValue;
            }
            getProp(props) {
                return props.suppressLineNumbers;
            }
            maskValue() {
                return ParagraphPropertiesMask.UseSuppressLineNumbers;
            }
            getHistoryItemConstructor() {
                return ParagraphSuppressLineNumbersHistoryItem;
            }
            getJSONProperty() {
                return JSONParagraphFormattingProperty.SuppressLineNumbers;
            }
        }, ParagraphPropertyDescriptor.keepLinesTogether = new class ParagraphPropertiesKeepLinesTogetherDescriptor {
            constructor() {
                this.binaryEquals = comparers.Equals.simpleType, this.defaultValue = !1;
            }
            setProp(props, newValue) {
                props.keepLinesTogether = newValue;
            }
            getProp(props) {
                return props.keepLinesTogether;
            }
            maskValue() {
                return ParagraphPropertiesMask.UseKeepLinesTogether;
            }
            getHistoryItemConstructor() {
                return ParagraphKeepLinesTogetherHistoryItem;
            }
            getJSONProperty() {
                return JSONParagraphFormattingProperty.KeepLinesTogether;
            }
        }, ParagraphPropertyDescriptor.keepWithNext = new class ParagraphPropertiesKeepWithNextDescriptor {
            constructor() {
                this.binaryEquals = comparers.Equals.simpleType, this.defaultValue = !1;
            }
            setProp(props, newValue) {
                props.keepWithNext = newValue;
            }
            getProp(props) {
                return props.keepWithNext;
            }
            maskValue() {
                return ParagraphPropertiesMask.UseKeepWithNext;
            }
            getHistoryItemConstructor() {
                return ParagraphKeepWithNextHistoryItem;
            }
            getJSONProperty() {
                return JSONParagraphFormattingProperty.KeepWithNext;
            }
        }, ParagraphPropertyDescriptor.shadingInfo = new class ParagraphPropertiesShadingInfoIndexDescriptor {
            constructor() {
                this.binaryEquals = comparers.Equals.object, this.defaultValue = ShadingInfo.noColor;
            }
            setProp(props, newValue) {
                props.shadingInfo = newValue;
            }
            getProp(props) {
                return props.shadingInfo;
            }
            maskValue() {
                return ParagraphPropertiesMask.UseShadingInfoIndex;
            }
            getHistoryItemConstructor() {
                return ParagraphShadingInfoIndexHistoryItem;
            }
            getJSONProperty() {
                return JSONParagraphFormattingProperty.ShadingInfo;
            }
        }, ParagraphPropertyDescriptor.leftIndent = new class ParagraphPropertiesLeftIndentDescriptor {
            constructor() {
                this.binaryEquals = comparers.Equals.simpleType, this.defaultValue = 0;
            }
            setProp(props, newValue) {
                props.leftIndent = newValue;
            }
            getProp(props) {
                return props.leftIndent;
            }
            maskValue() {
                return ParagraphPropertiesMask.UseLeftIndent;
            }
            getHistoryItemConstructor() {
                return ParagraphLeftIndentHistoryItem;
            }
            getJSONProperty() {
                return JSONParagraphFormattingProperty.LeftIndent;
            }
        }, ParagraphPropertyDescriptor.lineSpacingType = new class ParagraphPropertiesLineSpacingTypeDescriptor {
            constructor() {
                this.binaryEquals = comparers.Equals.simpleType, this.defaultValue = ParagraphLineSpacingType.Single;
            }
            setProp(props, newValue) {
                props.lineSpacingType = newValue;
            }
            getProp(props) {
                return props.lineSpacingType;
            }
            maskValue() {
                return ParagraphPropertiesMask.UseLineSpacing;
            }
            getHistoryItemConstructor() {
                return ParagraphLineSpacingTypeHistoryItem;
            }
            getJSONProperty() {
                return JSONParagraphFormattingProperty.LineSpacingType;
            }
        }, ParagraphPropertyDescriptor.alignment = new class ParagraphPropertiesAlignmentDescriptor {
            constructor() {
                this.binaryEquals = comparers.Equals.simpleType, this.defaultValue = ParagraphAlignment.Left;
            }
            setProp(props, newValue) {
                props.alignment = newValue;
            }
            getProp(props) {
                return props.alignment;
            }
            maskValue() {
                return ParagraphPropertiesMask.UseAlignment;
            }
            getHistoryItemConstructor() {
                return ParagraphAlignmentHistoryItem;
            }
            getJSONProperty() {
                return JSONParagraphFormattingProperty.Alignment;
            }
        }, ParagraphPropertyDescriptor.contextualSpacing = new class ParagraphPropertiesContextualSpacingDescriptor {
            constructor() {
                this.binaryEquals = comparers.Equals.simpleType, this.defaultValue = !1;
            }
            setProp(props, newValue) {
                props.contextualSpacing = newValue;
            }
            getProp(props) {
                return props.contextualSpacing;
            }
            maskValue() {
                return ParagraphPropertiesMask.UseContextualSpacing;
            }
            getHistoryItemConstructor() {
                return ParagraphContextualSpacingHistoryItem;
            }
            getJSONProperty() {
                return JSONParagraphFormattingProperty.ContextualSpacing;
            }
        }, ParagraphPropertyDescriptor.spacingBefore = new class ParagraphPropertiesSpacingBeforeDescriptor {
            constructor() {
                this.binaryEquals = comparers.Equals.simpleType, this.defaultValue = 0;
            }
            setProp(props, newValue) {
                props.spacingBefore = newValue;
            }
            getProp(props) {
                return props.spacingBefore;
            }
            maskValue() {
                return ParagraphPropertiesMask.UseSpacingBefore;
            }
            getHistoryItemConstructor() {
                return ParagraphSpacingBeforeHistoryItem;
            }
            getJSONProperty() {
                return JSONParagraphFormattingProperty.SpacingBefore;
            }
        }, ParagraphPropertyDescriptor.spacingAfter = new class ParagraphPropertiesSpacingAfterDescriptor {
            constructor() {
                this.binaryEquals = comparers.Equals.simpleType, this.defaultValue = 0;
            }
            setProp(props, newValue) {
                props.spacingAfter = newValue;
            }
            getProp(props) {
                return props.spacingAfter;
            }
            maskValue() {
                return ParagraphPropertiesMask.UseSpacingAfter;
            }
            getHistoryItemConstructor() {
                return ParagraphSpacingAfterHistoryItem;
            }
            getJSONProperty() {
                return JSONParagraphFormattingProperty.SpacingAfter;
            }
        }, ParagraphPropertyDescriptor.rightToLeft = new class ParagraphPropertiesRightToLeftDescriptor {
            constructor() {
                this.binaryEquals = comparers.Equals.simpleType, this.defaultValue = !1;
            }
            setProp(props, newValue) {
                props.rightToLeft = newValue;
            }
            getProp(props) {
                return props.rightToLeft;
            }
            maskValue() {
                return ParagraphPropertiesMask.UseRightToLeft;
            }
            getHistoryItemConstructor() {
                return ParagraphRightToLeftHistoryItem;
            }
            getJSONProperty() {
                return JSONParagraphFormattingProperty.RightToLeft;
            }
        }, ParagraphPropertyDescriptor.leftBorder = new class ParagraphPropertiesLeftBorderDescriptor {
            constructor() {
                this.binaryEquals = comparers.Equals.object, this.defaultValue = new BorderInfo;
            }
            setProp(props, newValue) {
                props.leftBorder = newValue;
            }
            getProp(props) {
                return props.leftBorder;
            }
            maskValue() {
                return ParagraphPropertiesMask.UseLeftBorder;
            }
            getHistoryItemConstructor() {
                throw Error(errors.D.NotImplemented);
            }
            getJSONProperty() {
                throw Error(errors.D.NotImplemented);
            }
        }, ParagraphPropertyDescriptor.rightBorder = new class ParagraphPropertiesRightBorderDescriptor {
            constructor() {
                this.binaryEquals = comparers.Equals.object, this.defaultValue = new BorderInfo;
            }
            setProp(props, newValue) {
                props.rightBorder = newValue;
            }
            getProp(props) {
                return props.rightBorder;
            }
            maskValue() {
                return ParagraphPropertiesMask.UseRightBorder;
            }
            getHistoryItemConstructor() {
                throw Error(errors.D.NotImplemented);
            }
            getJSONProperty() {
                throw Error(errors.D.NotImplemented);
            }
        }, ParagraphPropertyDescriptor.topBorder = new class ParagraphPropertiesTopBorderDescriptor {
            constructor() {
                this.binaryEquals = comparers.Equals.object, this.defaultValue = new BorderInfo;
            }
            setProp(props, newValue) {
                props.topBorder = newValue;
            }
            getProp(props) {
                return props.topBorder;
            }
            maskValue() {
                return ParagraphPropertiesMask.UseTopBorder;
            }
            getHistoryItemConstructor() {
                throw Error(errors.D.NotImplemented);
            }
            getJSONProperty() {
                throw Error(errors.D.NotImplemented);
            }
        }, ParagraphPropertyDescriptor.bottomBorder = new class ParagraphPropertiesBottomBorderDescriptor {
            constructor() {
                this.binaryEquals = comparers.Equals.object, this.defaultValue = new BorderInfo;
            }
            setProp(props, newValue) {
                props.bottomBorder = newValue;
            }
            getProp(props) {
                return props.bottomBorder;
            }
            maskValue() {
                return ParagraphPropertiesMask.UseBottomBorder;
            }
            getHistoryItemConstructor() {
                throw Error(errors.D.NotImplemented);
            }
            getJSONProperty() {
                throw Error(errors.D.NotImplemented);
            }
        }, ParagraphPropertyDescriptor.betweenBorder = new class ParagraphPropertiesBetweenBorderDescriptor {
            constructor() {
                this.binaryEquals = comparers.Equals.object, this.defaultValue = new BorderInfo;
            }
            setProp(props, newValue) {
                props.betweenBorder = newValue;
            }
            getProp(props) {
                return props.betweenBorder;
            }
            maskValue() {
                return ParagraphPropertiesMask.UseBetweenBorder;
            }
            getHistoryItemConstructor() {
                throw Error(errors.D.NotImplemented);
            }
            getJSONProperty() {
                throw Error(errors.D.NotImplemented);
            }
        }, ParagraphPropertyDescriptor.divId = new class ParagraphPropertiesDivIdDescriptor {
            constructor() {
                this.binaryEquals = comparers.Equals.simpleType, this.defaultValue = 0;
            }
            setProp(props, newValue) {
                props.divId = newValue;
            }
            getProp(props) {
                return props.divId;
            }
            maskValue() {
                return ParagraphPropertiesMask.UseDivId;
            }
            getHistoryItemConstructor() {
                return ParagraphDivIdHistoryItem;
            }
            getJSONProperty() {
                return JSONParagraphFormattingProperty.DivId;
            }
        }, ParagraphPropertyDescriptor.ALL_FIELDS = [ ParagraphPropertyDescriptor.firstLineIndent, ParagraphPropertyDescriptor.widowOrphanControl, ParagraphPropertyDescriptor.firstLineIndentType, ParagraphPropertyDescriptor.afterAutoSpacing, ParagraphPropertyDescriptor.outlineLevel, ParagraphPropertyDescriptor.beforeAutoSpacing, ParagraphPropertyDescriptor.pageBreakBefore, ParagraphPropertyDescriptor.rightIndent, ParagraphPropertyDescriptor.suppressHyphenation, ParagraphPropertyDescriptor.lineSpacing, ParagraphPropertyDescriptor.suppressLineNumbers, ParagraphPropertyDescriptor.keepLinesTogether, ParagraphPropertyDescriptor.keepWithNext, ParagraphPropertyDescriptor.shadingInfo, ParagraphPropertyDescriptor.leftIndent, ParagraphPropertyDescriptor.lineSpacingType, ParagraphPropertyDescriptor.alignment, ParagraphPropertyDescriptor.contextualSpacing, ParagraphPropertyDescriptor.spacingBefore, ParagraphPropertyDescriptor.spacingAfter, ParagraphPropertyDescriptor.rightToLeft, ParagraphPropertyDescriptor.leftBorder, ParagraphPropertyDescriptor.rightBorder, ParagraphPropertyDescriptor.topBorder, ParagraphPropertyDescriptor.bottomBorder, ParagraphPropertyDescriptor.betweenBorder, ParagraphPropertyDescriptor.divId ];
        class ParagraphProperties {
            constructor() {
                this.firstLineIndent = 0, this.widowOrphanControl = !0, this.firstLineIndentType = ParagraphFirstLineIndent.None, 
                this.afterAutoSpacing = !1, this.outlineLevel = 0, this.beforeAutoSpacing = !1, 
                this.pageBreakBefore = !1, this.rightIndent = 0, this.suppressHyphenation = !1, 
                this.lineSpacing = 0, this.suppressLineNumbers = !1, this.keepLinesTogether = !1, 
                this.keepWithNext = !1, this.shadingInfo = ShadingInfo.nullColor, this.rightToLeft = !1, 
                this.leftIndent = 0, this.lineSpacingType = ParagraphLineSpacingType.Single, this.alignment = ParagraphAlignment.Left, 
                this.contextualSpacing = !1, this.spacingBefore = 0, this.spacingAfter = 0, this.leftBorder = new BorderInfo, 
                this.rightBorder = new BorderInfo, this.topBorder = new BorderInfo, this.bottomBorder = new BorderInfo, 
                this.betweenBorder = new BorderInfo, this.divId = 0;
            }
            calculateHash() {
                return math.MathUtils.somePrimes[0] * this.leftIndent ^ math.MathUtils.somePrimes[1] * this.rightIndent ^ math.MathUtils.somePrimes[2] * this.firstLineIndent ^ math.MathUtils.somePrimes[3] * this.spacingBefore ^ math.MathUtils.somePrimes[4] * this.spacingAfter;
            }
            getHashCode() {
                return void 0 === this.hash ? this.hash = this.calculateHash() : this.hash;
            }
            copyFrom(obj) {
                this.alignment = obj.alignment, this.leftIndent = obj.leftIndent, this.rightIndent = obj.rightIndent, 
                this.spacingBefore = obj.spacingBefore, this.spacingAfter = obj.spacingAfter, this.lineSpacing = obj.lineSpacing, 
                this.firstLineIndent = obj.firstLineIndent, this.suppressHyphenation = obj.suppressHyphenation, 
                this.suppressLineNumbers = obj.suppressLineNumbers, this.contextualSpacing = obj.contextualSpacing, 
                this.pageBreakBefore = obj.pageBreakBefore, this.beforeAutoSpacing = obj.beforeAutoSpacing, 
                this.afterAutoSpacing = obj.afterAutoSpacing, this.keepWithNext = obj.keepWithNext, 
                this.keepLinesTogether = obj.keepLinesTogether, this.widowOrphanControl = obj.widowOrphanControl, 
                this.outlineLevel = obj.outlineLevel, this.firstLineIndentType = obj.firstLineIndentType, 
                this.lineSpacingType = obj.lineSpacingType, this.rightToLeft = obj.rightToLeft, 
                this.shadingInfo = obj.shadingInfo ? obj.shadingInfo.clone() : obj.shadingInfo, 
                obj.leftBorder ? this.leftBorder.copyFrom(obj.leftBorder) : this.leftBorder = obj.leftBorder, 
                obj.rightBorder ? this.rightBorder.copyFrom(obj.rightBorder) : this.rightBorder = obj.rightBorder, 
                obj.topBorder ? this.topBorder.copyFrom(obj.topBorder) : this.topBorder = obj.topBorder, 
                obj.bottomBorder ? this.bottomBorder.copyFrom(obj.bottomBorder) : this.bottomBorder = obj.bottomBorder, 
                obj.betweenBorder ? this.betweenBorder.copyFrom(obj.betweenBorder) : this.betweenBorder = obj.betweenBorder, 
                this.divId = obj.divId;
            }
            clone() {
                var result = new ParagraphProperties;
                return result.copyFrom(this), result;
            }
            equals(obj) {
                return !!obj && (this.firstLineIndent == obj.firstLineIndent && this.firstLineIndentType == obj.firstLineIndentType && this.afterAutoSpacing == obj.afterAutoSpacing && this.outlineLevel == obj.outlineLevel && this.beforeAutoSpacing == obj.beforeAutoSpacing && this.pageBreakBefore == obj.pageBreakBefore && this.rightIndent == obj.rightIndent && this.suppressHyphenation == obj.suppressHyphenation && this.lineSpacing == obj.lineSpacing && this.suppressLineNumbers == obj.suppressLineNumbers && this.keepLinesTogether == obj.keepLinesTogether && this.keepWithNext == obj.keepWithNext && this.shadingInfo.equals(obj.shadingInfo) && this.leftIndent == obj.leftIndent && this.lineSpacingType == obj.lineSpacingType && this.alignment == obj.alignment && this.contextualSpacing == obj.contextualSpacing && this.rightToLeft == obj.rightToLeft && this.spacingBefore == obj.spacingBefore && this.spacingAfter == obj.spacingAfter && this.leftBorder.equals(obj.leftBorder) && this.rightBorder.equals(obj.rightBorder) && this.topBorder.equals(obj.topBorder) && this.bottomBorder.equals(obj.bottomBorder) && this.betweenBorder.equals(obj.betweenBorder) && this.divId == obj.divId);
            }
            getLeftIndentForFirstRow() {
                let indent = this.leftIndent;
                switch (this.firstLineIndentType) {
                  case ParagraphFirstLineIndent.None:
                  case ParagraphFirstLineIndent.Indented:
                    indent += this.firstLineIndent;
                    break;

                  case ParagraphFirstLineIndent.Hanging:
                    indent -= this.firstLineIndent;
                }
                return indent;
            }
            getLeftIndentForOtherRow() {
                return this.leftIndent;
            }
            getLeftIndentForParagraphFrame() {
                let indent = this.leftIndent;
                return this.firstLineIndentType == ParagraphFirstLineIndent.Hanging && (indent -= this.firstLineIndent), 
                unit_converter.u.twipsToPixelsF(indent);
            }
        }
        class MaskedParagraphProperties extends ParagraphProperties {
            constructor() {
                super(...arguments), this.useValue = ParagraphPropertiesMask.UseNone;
            }
            getUseValue(value) {
                return !!(this.useValue & value);
            }
            calculateHash() {
                return super.calculateHash() + math.MathUtils.somePrimes[15] * this.useValue;
            }
            setUseValue(mask, value) {
                value ? this.useValue |= mask : this.useValue &= ~mask;
            }
            copyFrom(obj) {
                super.copyFrom(obj), this.useValue = obj.useValue;
            }
            equals(obj) {
                return super.equals(obj) && this.useValue == obj.useValue;
            }
            clone() {
                var result = new MaskedParagraphProperties;
                return result.copyFrom(this), result;
            }
            static createDefault(model) {
                var prop = model.defaultParagraphProperties.clone();
                return prop.useValue = ParagraphPropertiesMask.UseNone, prop;
            }
            setValue(desc, value) {
                desc.setProp(this, value), this.setUseValue(desc.maskValue(), !0);
            }
        }
        class FontUseValueHistoryItem extends interval_based_history_item_IntervalBasedHistoryItem {
            constructor(modelManipulator, subDocInterval, newValue) {
                super(modelManipulator, subDocInterval), this.newValue = newValue;
            }
            redo() {
                this.oldState = this.modelManipulator.characterProperties.useValue.setValue(this.boundSubDocument, this.interval, this.newValue);
            }
            undo() {
                this.modelManipulator.characterProperties.useValue.restoreValue(this.boundSubDocument, this.oldState);
            }
        }
        class CharacterPropertiesHistoryItem extends interval_based_history_item_IntervalBasedHistoryItem {
            constructor(modelManipulator, subDocInterval, newValue) {
                super(modelManipulator, subDocInterval), this.newValue = newValue;
            }
            redo() {
                this.oldState = this.modelManipulator.characterProperties.setValue(this.boundSubDocument, this.interval, this.newValue);
            }
            undo() {
                this.modelManipulator.characterProperties.restoreValue(this.boundSubDocument, this.oldState);
            }
        }
        class CharacterPropertiesHistoryItemBase extends interval_based_history_item_IntervalBasedHistoryItem {
            constructor(modelManipulator, subDocInterval, newValue, newUse) {
                super(modelManipulator, subDocInterval), this.newValue = newValue, this.newUse = newUse;
            }
            redo() {
                this.oldState = this.getPropertiesManipulator().setValue(this.boundSubDocument, this.interval, this.newValue, this.newUse);
            }
            undo() {
                this.getPropertiesManipulator().restoreValue(this.boundSubDocument, this.oldState);
            }
            getPropertiesManipulator() {
                throw new Error(errors.D.NotImplemented);
            }
        }
        class FontBoldHistoryItem extends CharacterPropertiesHistoryItemBase {
            getPropertiesManipulator() {
                return this.modelManipulator.characterProperties.fontBold;
            }
        }
        class FontCapsHistoryItem extends CharacterPropertiesHistoryItemBase {
            getPropertiesManipulator() {
                return this.modelManipulator.characterProperties.fontCaps;
            }
        }
        class FontSmallCapsHistoryItem extends CharacterPropertiesHistoryItemBase {
            getPropertiesManipulator() {
                return this.modelManipulator.characterProperties.fontSmallCaps;
            }
        }
        class FontUnderlineTypeHistoryItem extends CharacterPropertiesHistoryItemBase {
            getPropertiesManipulator() {
                return this.modelManipulator.characterProperties.fontUnderlineType;
            }
        }
        class FontTextColorHistoryItem extends CharacterPropertiesHistoryItemBase {
            getPropertiesManipulator() {
                return this.modelManipulator.characterProperties.textColor;
            }
        }
        class FontShadingInfoHistoryItem extends CharacterPropertiesHistoryItemBase {
            getPropertiesManipulator() {
                return this.modelManipulator.characterProperties.shadingInfo;
            }
        }
        class FontHiddenHistoryItem extends CharacterPropertiesHistoryItemBase {
            getPropertiesManipulator() {
                return this.modelManipulator.characterProperties.fontHidden;
            }
        }
        class FontItalicHistoryItem extends CharacterPropertiesHistoryItemBase {
            getPropertiesManipulator() {
                return this.modelManipulator.characterProperties.fontItalic;
            }
        }
        class FontNameHistoryItem extends CharacterPropertiesHistoryItemBase {
            getPropertiesManipulator() {
                return this.modelManipulator.characterProperties.fontName;
            }
        }
        class FontScriptHistoryItem extends CharacterPropertiesHistoryItemBase {
            getPropertiesManipulator() {
                return this.modelManipulator.characterProperties.script;
            }
        }
        class FontSizeHistoryItem extends CharacterPropertiesHistoryItemBase {
            getPropertiesManipulator() {
                return this.modelManipulator.characterProperties.fontSize;
            }
        }
        class FontStrikeoutTypeHistoryItem extends CharacterPropertiesHistoryItemBase {
            getPropertiesManipulator() {
                return this.modelManipulator.characterProperties.fontStrikeoutType;
            }
        }
        class FontStrikeoutWordsOnlyHistoryItem extends CharacterPropertiesHistoryItemBase {
            getPropertiesManipulator() {
                return this.modelManipulator.characterProperties.fontStrikeoutWordsOnly;
            }
        }
        class FontStrikeoutColorHistoryItem extends CharacterPropertiesHistoryItemBase {
            getPropertiesManipulator() {
                return this.modelManipulator.characterProperties.fontStrikeoutColor;
            }
        }
        class FontUnderlineColorHistoryItem extends CharacterPropertiesHistoryItemBase {
            getPropertiesManipulator() {
                return this.modelManipulator.characterProperties.fontUnderlineColor;
            }
        }
        class FontHighlightColorHistoryItem extends CharacterPropertiesHistoryItemBase {
            getPropertiesManipulator() {
                return this.modelManipulator.characterProperties.fontHighlightColor;
            }
        }
        class FontUnderlineWordsOnlyHistoryItem extends CharacterPropertiesHistoryItemBase {
            getPropertiesManipulator() {
                return this.modelManipulator.characterProperties.fontUnderlineWordsOnly;
            }
        }
        class FontNoProofHistoryItem extends CharacterPropertiesHistoryItemBase {
            getPropertiesManipulator() {
                return this.modelManipulator.characterProperties.fontNoProof;
            }
        }
        class FontLangInfoHistoryItem extends CharacterPropertiesHistoryItemBase {
            getPropertiesManipulator() {
                return this.modelManipulator.characterProperties.langInfo;
            }
        }
        class FontCompositeFontInfoHistoryItem extends CharacterPropertiesHistoryItemBase {
            getPropertiesManipulator() {
                return this.modelManipulator.characterProperties.compositeFontInfo;
            }
        }
        class character_property_descriptor_CharacterPropertyDescriptor {}
        character_property_descriptor_CharacterPropertyDescriptor.allCaps = new class CharacterPropertiesAllCapsDescriptor {
            constructor() {
                this.binaryEquals = comparers.Equals.simpleType, this.defaultValue = !1;
            }
            setProp(props, newValue) {
                props.allCaps = newValue;
            }
            getProp(props) {
                return props.allCaps;
            }
            maskValue() {
                return CharacterPropertiesMask.UseAllCaps;
            }
            getHistoryItemConstructor() {
                return FontCapsHistoryItem;
            }
            getJSONProperty() {
                return JSONCharacterFormattingProperty.AllCaps;
            }
        }, character_property_descriptor_CharacterPropertyDescriptor.size = new class CharacterPropertiesFontSizeDescriptor {
            constructor() {
                this.binaryEquals = comparers.Equals.simpleType, this.defaultValue = 11;
            }
            setProp(props, newValue) {
                props.fontSize = newValue;
            }
            getProp(props) {
                return props.fontSize;
            }
            maskValue() {
                return CharacterPropertiesMask.UseDoubleFontSize;
            }
            getHistoryItemConstructor() {
                return FontSizeHistoryItem;
            }
            getJSONProperty() {
                return JSONCharacterFormattingProperty.Size;
            }
        }, character_property_descriptor_CharacterPropertyDescriptor.bold = new class CharacterPropertiesFontBoldDescriptor {
            constructor() {
                this.binaryEquals = comparers.Equals.simpleType, this.defaultValue = !1;
            }
            setProp(props, newValue) {
                props.fontBold = newValue;
            }
            getProp(props) {
                return props.fontBold;
            }
            maskValue() {
                return CharacterPropertiesMask.UseFontBold;
            }
            getHistoryItemConstructor() {
                return FontBoldHistoryItem;
            }
            getJSONProperty() {
                return JSONCharacterFormattingProperty.Bold;
            }
        }, character_property_descriptor_CharacterPropertyDescriptor.italic = new class CharacterPropertiesFontItalicDescriptor {
            constructor() {
                this.binaryEquals = comparers.Equals.simpleType, this.defaultValue = !1;
            }
            setProp(props, newValue) {
                props.fontItalic = newValue;
            }
            getProp(props) {
                return props.fontItalic;
            }
            maskValue() {
                return CharacterPropertiesMask.UseFontItalic;
            }
            getHistoryItemConstructor() {
                return FontItalicHistoryItem;
            }
            getJSONProperty() {
                return JSONCharacterFormattingProperty.Italic;
            }
        }, character_property_descriptor_CharacterPropertyDescriptor.fontInfo = new class CharacterPropertiesFontInfoDescriptor {
            constructor() {
                this.binaryEquals = comparers.Equals.object, this.defaultValue = void 0;
            }
            setProp(props, newValue) {
                props.fontInfo = newValue;
            }
            getProp(props) {
                return props.fontInfo;
            }
            maskValue() {
                return CharacterPropertiesMask.UseFontName;
            }
            getHistoryItemConstructor() {
                return FontNameHistoryItem;
            }
            getJSONProperty() {
                return JSONCharacterFormattingProperty.FontName;
            }
        }, character_property_descriptor_CharacterPropertyDescriptor.script = new class CharacterPropertiesScriptDescriptor {
            constructor() {
                this.binaryEquals = comparers.Equals.simpleType, this.defaultValue = CharacterFormattingScript.Normal;
            }
            setProp(props, newValue) {
                props.script = newValue;
            }
            getProp(props) {
                return props.script;
            }
            maskValue() {
                return CharacterPropertiesMask.UseScript;
            }
            getHistoryItemConstructor() {
                return FontScriptHistoryItem;
            }
            getJSONProperty() {
                return JSONCharacterFormattingProperty.Script;
            }
        }, character_property_descriptor_CharacterPropertyDescriptor.strikeoutType = new class CharacterPropertiesStrikeoutTypeDescriptor {
            constructor() {
                this.binaryEquals = comparers.Equals.simpleType, this.defaultValue = StrikeoutType.None;
            }
            setProp(props, newValue) {
                props.fontStrikeoutType = newValue;
            }
            getProp(props) {
                return props.fontStrikeoutType;
            }
            maskValue() {
                return CharacterPropertiesMask.UseFontStrikeoutType;
            }
            getHistoryItemConstructor() {
                return FontStrikeoutTypeHistoryItem;
            }
            getJSONProperty() {
                return JSONCharacterFormattingProperty.StrikeoutType;
            }
        }, character_property_descriptor_CharacterPropertyDescriptor.underlineType = new class CharacterPropertiesUnderlineTypeDescriptor {
            constructor() {
                this.binaryEquals = comparers.Equals.simpleType, this.defaultValue = UnderlineType.None;
            }
            setProp(props, newValue) {
                props.fontUnderlineType = newValue;
            }
            getProp(props) {
                return props.fontUnderlineType;
            }
            maskValue() {
                return CharacterPropertiesMask.UseFontUnderlineType;
            }
            getHistoryItemConstructor() {
                return FontUnderlineTypeHistoryItem;
            }
            getJSONProperty() {
                return JSONCharacterFormattingProperty.UnderlineType;
            }
        }, character_property_descriptor_CharacterPropertyDescriptor.underlineWordsOnly = new class CharacterPropertiesUnderlineWordsOnlyDescriptor {
            constructor() {
                this.binaryEquals = comparers.Equals.simpleType, this.defaultValue = !1;
            }
            setProp(props, newValue) {
                props.underlineWordsOnly = newValue;
            }
            getProp(props) {
                return props.underlineWordsOnly;
            }
            maskValue() {
                return CharacterPropertiesMask.UseUnderlineWordsOnly;
            }
            getHistoryItemConstructor() {
                return FontUnderlineWordsOnlyHistoryItem;
            }
            getJSONProperty() {
                return JSONCharacterFormattingProperty.UnderlineWordsOnly;
            }
        }, character_property_descriptor_CharacterPropertyDescriptor.strikeoutWordsOnly = new class CharacterPropertiesStrikeoutWordsOnlyDescriptor {
            constructor() {
                this.binaryEquals = comparers.Equals.simpleType, this.defaultValue = !1;
            }
            setProp(props, newValue) {
                props.strikeoutWordsOnly = newValue;
            }
            getProp(props) {
                return props.strikeoutWordsOnly;
            }
            maskValue() {
                return CharacterPropertiesMask.UseStrikeoutWordsOnly;
            }
            getHistoryItemConstructor() {
                return FontStrikeoutWordsOnlyHistoryItem;
            }
            getJSONProperty() {
                return JSONCharacterFormattingProperty.StrikeoutWordsOnly;
            }
        }, character_property_descriptor_CharacterPropertyDescriptor.noProof = new class CharacterPropertiesNoProofDescriptor {
            constructor() {
                this.binaryEquals = comparers.Equals.simpleType, this.defaultValue = !1;
            }
            setProp(props, newValue) {
                props.noProof = newValue;
            }
            getProp(props) {
                return props.noProof;
            }
            maskValue() {
                return CharacterPropertiesMask.UseNoProof;
            }
            getHistoryItemConstructor() {
                return FontNoProofHistoryItem;
            }
            getJSONProperty() {
                return JSONCharacterFormattingProperty.NoProof;
            }
        }, character_property_descriptor_CharacterPropertyDescriptor.hidden = new class CharacterPropertiesHiddenDescriptor {
            constructor() {
                this.binaryEquals = comparers.Equals.simpleType, this.defaultValue = !1;
            }
            setProp(props, newValue) {
                props.hidden = newValue;
            }
            getProp(props) {
                return props.hidden;
            }
            maskValue() {
                return CharacterPropertiesMask.UseHidden;
            }
            getHistoryItemConstructor() {
                return FontHiddenHistoryItem;
            }
            getJSONProperty() {
                return JSONCharacterFormattingProperty.Hidden;
            }
        }, character_property_descriptor_CharacterPropertyDescriptor.langInfo = new class CharacterPropertiesLangInfoDescriptor {
            constructor() {
                this.binaryEquals = comparers.Equals.object, this.defaultValue = new LangInfo;
            }
            setProp(props, newValue) {
                props.langInfo = newValue;
            }
            getProp(props) {
                return props.langInfo;
            }
            maskValue() {
                return CharacterPropertiesMask.UseLangInfo;
            }
            getHistoryItemConstructor() {
                return FontLangInfoHistoryItem;
            }
            getJSONProperty() {
                return JSONCharacterFormattingProperty.LangInfo;
            }
        }, character_property_descriptor_CharacterPropertyDescriptor.compositeFontInfo = new class CharacterPropertiesCompositeFontInfoDescriptor {
            constructor() {
                this.binaryEquals = comparers.Equals.object, this.defaultValue = new CompositeFontInfo;
            }
            setProp(props, newValue) {
                props.compositeFontInfo = newValue;
            }
            getProp(props) {
                return props.compositeFontInfo;
            }
            maskValue() {
                return CharacterPropertiesMask.UseCompositeFontInfo;
            }
            getHistoryItemConstructor() {
                return FontCompositeFontInfoHistoryItem;
            }
            getJSONProperty() {
                return JSONCharacterFormattingProperty.CompositeFontInfo;
            }
        }, character_property_descriptor_CharacterPropertyDescriptor.textColor = new class CharacterPropertiesTextColorDescriptor {
            constructor() {
                this.binaryEquals = comparers.Equals.object, this.defaultValue = color_model_info_ColorModelInfo.autoColor;
            }
            setProp(props, newValue) {
                props.textColor = newValue;
            }
            getProp(props) {
                return props.textColor;
            }
            maskValue() {
                return CharacterPropertiesMask.UseForeColorIndex;
            }
            getHistoryItemConstructor() {
                return FontTextColorHistoryItem;
            }
            getJSONProperty() {
                return JSONCharacterFormattingProperty.TextColor;
            }
        }, character_property_descriptor_CharacterPropertyDescriptor.shadingInfo = new class CharacterPropertiesShadingInfoColorDescriptor {
            constructor() {
                this.binaryEquals = comparers.Equals.object, this.defaultValue = ShadingInfo.noColor;
            }
            setProp(props, newValue) {
                props.shadingInfo = newValue;
            }
            getProp(props) {
                return props.shadingInfo;
            }
            maskValue() {
                return CharacterPropertiesMask.UseShadingInfoIndex;
            }
            getHistoryItemConstructor() {
                return FontShadingInfoHistoryItem;
            }
            getJSONProperty() {
                return JSONCharacterFormattingProperty.ShadingInfo;
            }
        }, character_property_descriptor_CharacterPropertyDescriptor.highlightColor = new class CharacterPropertiesHighlightColorDescriptor {
            constructor() {
                this.binaryEquals = comparers.Equals.object, this.defaultValue = color_model_info_ColorModelInfo.noColor;
            }
            setProp(props, newValue) {
                props.highlightColor = newValue;
            }
            getProp(props) {
                return props.highlightColor;
            }
            maskValue() {
                return CharacterPropertiesMask.UseHighlightColorIndex;
            }
            getHistoryItemConstructor() {
                return FontHighlightColorHistoryItem;
            }
            getJSONProperty() {
                return JSONCharacterFormattingProperty.HighlightColor;
            }
        }, character_property_descriptor_CharacterPropertyDescriptor.strikeoutColor = new class CharacterPropertiesStrikeoutColorDescriptor {
            constructor() {
                this.binaryEquals = comparers.Equals.object, this.defaultValue = color_model_info_ColorModelInfo.noColor;
            }
            setProp(props, newValue) {
                props.strikeoutColor = newValue;
            }
            getProp(props) {
                return props.strikeoutColor;
            }
            maskValue() {
                return CharacterPropertiesMask.UseStrikeoutColorIndex;
            }
            getHistoryItemConstructor() {
                return FontStrikeoutColorHistoryItem;
            }
            getJSONProperty() {
                return JSONCharacterFormattingProperty.StrikeoutColor;
            }
        }, character_property_descriptor_CharacterPropertyDescriptor.underlineColor = new class CharacterPropertiesUnderlineColorDescriptor {
            constructor() {
                this.binaryEquals = comparers.Equals.object, this.defaultValue = color_model_info_ColorModelInfo.noColor;
            }
            setProp(props, newValue) {
                props.underlineColor = newValue;
            }
            getProp(props) {
                return props.underlineColor;
            }
            maskValue() {
                return CharacterPropertiesMask.UseUnderlineColorIndex;
            }
            getHistoryItemConstructor() {
                return FontUnderlineColorHistoryItem;
            }
            getJSONProperty() {
                return JSONCharacterFormattingProperty.UnderlineColor;
            }
        }, character_property_descriptor_CharacterPropertyDescriptor.smallCaps = new class CharacterPropertiesSmallCapsDescriptor {
            constructor() {
                this.binaryEquals = comparers.Equals.simpleType, this.defaultValue = !1;
            }
            setProp(props, newValue) {
                props.smallCaps = newValue;
            }
            getProp(props) {
                return props.smallCaps;
            }
            maskValue() {
                return CharacterPropertiesMask.UseSmallCaps;
            }
            getHistoryItemConstructor() {
                return FontSmallCapsHistoryItem;
            }
            getJSONProperty() {
                return JSONCharacterFormattingProperty.SmallCaps;
            }
        }, character_property_descriptor_CharacterPropertyDescriptor.ALL_FIELDS = [ character_property_descriptor_CharacterPropertyDescriptor.allCaps, character_property_descriptor_CharacterPropertyDescriptor.size, character_property_descriptor_CharacterPropertyDescriptor.bold, character_property_descriptor_CharacterPropertyDescriptor.italic, character_property_descriptor_CharacterPropertyDescriptor.fontInfo, character_property_descriptor_CharacterPropertyDescriptor.script, character_property_descriptor_CharacterPropertyDescriptor.strikeoutType, character_property_descriptor_CharacterPropertyDescriptor.underlineType, character_property_descriptor_CharacterPropertyDescriptor.underlineWordsOnly, character_property_descriptor_CharacterPropertyDescriptor.strikeoutWordsOnly, character_property_descriptor_CharacterPropertyDescriptor.noProof, character_property_descriptor_CharacterPropertyDescriptor.hidden, character_property_descriptor_CharacterPropertyDescriptor.langInfo, character_property_descriptor_CharacterPropertyDescriptor.compositeFontInfo, character_property_descriptor_CharacterPropertyDescriptor.textColor, character_property_descriptor_CharacterPropertyDescriptor.shadingInfo, character_property_descriptor_CharacterPropertyDescriptor.highlightColor, character_property_descriptor_CharacterPropertyDescriptor.strikeoutColor, character_property_descriptor_CharacterPropertyDescriptor.underlineColor, character_property_descriptor_CharacterPropertyDescriptor.smallCaps ], 
        character_property_descriptor_CharacterPropertyDescriptor.whatNeedSetWhenCreateHyperlinkField = [ character_property_descriptor_CharacterPropertyDescriptor.size, character_property_descriptor_CharacterPropertyDescriptor.bold, character_property_descriptor_CharacterPropertyDescriptor.italic, character_property_descriptor_CharacterPropertyDescriptor.fontInfo, character_property_descriptor_CharacterPropertyDescriptor.script, character_property_descriptor_CharacterPropertyDescriptor.strikeoutType, character_property_descriptor_CharacterPropertyDescriptor.allCaps, character_property_descriptor_CharacterPropertyDescriptor.underlineWordsOnly, character_property_descriptor_CharacterPropertyDescriptor.strikeoutWordsOnly, character_property_descriptor_CharacterPropertyDescriptor.noProof, character_property_descriptor_CharacterPropertyDescriptor.hidden, character_property_descriptor_CharacterPropertyDescriptor.shadingInfo, character_property_descriptor_CharacterPropertyDescriptor.strikeoutColor, character_property_descriptor_CharacterPropertyDescriptor.underlineColor, character_property_descriptor_CharacterPropertyDescriptor.langInfo, character_property_descriptor_CharacterPropertyDescriptor.smallCaps ];
        class TableBordersBase {
            getHashCode() {
                return math.MathUtils.somePrimes[10] * this.topBorder.getHashCode() ^ math.MathUtils.somePrimes[11] * this.rightBorder.getHashCode() ^ math.MathUtils.somePrimes[12] * this.bottomBorder.getHashCode() ^ math.MathUtils.somePrimes[13] * this.leftBorder.getHashCode();
            }
            equals(obj) {
                return !!obj && (this.bottomBorder.equals(obj.bottomBorder) && this.leftBorder.equals(obj.leftBorder) && this.rightBorder.equals(obj.rightBorder) && this.topBorder.equals(obj.topBorder));
            }
            copyFrom(obj) {
                this.bottomBorder = obj.bottomBorder.clone(), this.leftBorder = obj.leftBorder.clone(), 
                this.rightBorder = obj.rightBorder.clone(), this.topBorder = obj.topBorder.clone();
            }
        }
        class TableCellBorders extends TableBordersBase {
            equals(obj) {
                return super.equals(obj) && this.topLeftDiagonalBorder.equals(obj.topLeftDiagonalBorder) && this.topRightDiagonalBorder.equals(obj.topRightDiagonalBorder);
            }
            copyFrom(obj) {
                super.copyFrom(obj), this.topLeftDiagonalBorder = obj.topLeftDiagonalBorder.clone(), 
                this.topRightDiagonalBorder = obj.topRightDiagonalBorder.clone();
            }
            clone() {
                var result = new TableCellBorders;
                return result.copyFrom(this), result;
            }
            static create(top, right, bottom, left, topLeftDiagonal, topRightDiagonal) {
                let result = new TableCellBorders;
                return result.topBorder = top, result.rightBorder = right, result.bottomBorder = bottom, 
                result.leftBorder = left, result.topLeftDiagonalBorder = topLeftDiagonal, result.topRightDiagonalBorder = topRightDiagonal, 
                result;
            }
        }
        class TableCellMargins {
            equals(obj) {
                return !!obj && (this.top.equals(obj.top) && this.right.equals(obj.right) && this.left.equals(obj.left) && this.bottom.equals(obj.bottom));
            }
            copyFrom(obj) {
                this.top = obj.top.clone(), this.right = obj.right.clone(), this.left = obj.left.clone(), 
                this.bottom = obj.bottom.clone();
            }
            clone() {
                var result = new TableCellMargins;
                return result.copyFrom(this), result;
            }
            static create(top, right, bottom, left) {
                let result = new TableCellMargins;
                return result.top = top, result.right = right, result.bottom = bottom, result.left = left, 
                result;
            }
        }
        !function(TableLayoutType) {
            TableLayoutType[TableLayoutType.Fixed = 0] = "Fixed", TableLayoutType[TableLayoutType.Autofit = 1] = "Autofit";
        }(TableLayoutType || (TableLayoutType = {})), function(TableLookTypes) {
            TableLookTypes[TableLookTypes.None = 0] = "None", TableLookTypes[TableLookTypes.ApplyFirstRow = 32] = "ApplyFirstRow", 
            TableLookTypes[TableLookTypes.ApplyLastRow = 64] = "ApplyLastRow", TableLookTypes[TableLookTypes.ApplyFirstColumn = 128] = "ApplyFirstColumn", 
            TableLookTypes[TableLookTypes.ApplyLastColumn = 256] = "ApplyLastColumn", TableLookTypes[TableLookTypes.DoNotApplyRowBanding = 512] = "DoNotApplyRowBanding", 
            TableLookTypes[TableLookTypes.DoNotApplyColumnBanding = 1024] = "DoNotApplyColumnBanding";
        }(TableLookTypes || (TableLookTypes = {})), function(HorizontalAlignMode) {
            HorizontalAlignMode[HorizontalAlignMode.None = 0] = "None", HorizontalAlignMode[HorizontalAlignMode.Center = 1] = "Center", 
            HorizontalAlignMode[HorizontalAlignMode.Inside = 2] = "Inside", HorizontalAlignMode[HorizontalAlignMode.Left = 3] = "Left", 
            HorizontalAlignMode[HorizontalAlignMode.Outside = 4] = "Outside", HorizontalAlignMode[HorizontalAlignMode.Right = 5] = "Right";
        }(HorizontalAlignMode || (HorizontalAlignMode = {})), function(VerticalAlignMode) {
            VerticalAlignMode[VerticalAlignMode.None = 0] = "None", VerticalAlignMode[VerticalAlignMode.Bottom = 1] = "Bottom", 
            VerticalAlignMode[VerticalAlignMode.Center = 2] = "Center", VerticalAlignMode[VerticalAlignMode.Inline = 3] = "Inline", 
            VerticalAlignMode[VerticalAlignMode.Inside = 4] = "Inside", VerticalAlignMode[VerticalAlignMode.Outside = 5] = "Outside", 
            VerticalAlignMode[VerticalAlignMode.Top = 6] = "Top";
        }(VerticalAlignMode || (VerticalAlignMode = {})), function(HorizontalAnchorTypes) {
            HorizontalAnchorTypes[HorizontalAnchorTypes.Margin = 0] = "Margin", HorizontalAnchorTypes[HorizontalAnchorTypes.Page = 1] = "Page", 
            HorizontalAnchorTypes[HorizontalAnchorTypes.Column = 2] = "Column";
        }(HorizontalAnchorTypes || (HorizontalAnchorTypes = {})), function(VerticalAnchorTypes) {
            VerticalAnchorTypes[VerticalAnchorTypes.Margin = 0] = "Margin", VerticalAnchorTypes[VerticalAnchorTypes.Page = 1] = "Page", 
            VerticalAnchorTypes[VerticalAnchorTypes.Paragraph = 2] = "Paragraph";
        }(VerticalAnchorTypes || (VerticalAnchorTypes = {})), function(TextWrapping) {
            TextWrapping[TextWrapping.Never = 0] = "Never", TextWrapping[TextWrapping.Around = 1] = "Around";
        }(TextWrapping || (TextWrapping = {})), function(TableRowAlignment) {
            TableRowAlignment[TableRowAlignment.Both = 0] = "Both", TableRowAlignment[TableRowAlignment.Center = 1] = "Center", 
            TableRowAlignment[TableRowAlignment.Distribute = 2] = "Distribute", TableRowAlignment[TableRowAlignment.Left = 3] = "Left", 
            TableRowAlignment[TableRowAlignment.NumTab = 4] = "NumTab", TableRowAlignment[TableRowAlignment.Right = 5] = "Right";
        }(TableRowAlignment || (TableRowAlignment = {})), function(TableCellMergingState) {
            TableCellMergingState[TableCellMergingState.None = 0] = "None", TableCellMergingState[TableCellMergingState.Continue = 1] = "Continue", 
            TableCellMergingState[TableCellMergingState.Restart = 2] = "Restart";
        }(TableCellMergingState || (TableCellMergingState = {})), function(TextDirection) {
            TextDirection[TextDirection.LeftToRightTopToBottom = 0] = "LeftToRightTopToBottom", 
            TextDirection[TextDirection.TopToBottomRightToLeft = 1] = "TopToBottomRightToLeft", 
            TextDirection[TextDirection.TopToBottomLeftToRightRotated = 2] = "TopToBottomLeftToRightRotated", 
            TextDirection[TextDirection.BottomToTopLeftToRight = 3] = "BottomToTopLeftToRight", 
            TextDirection[TextDirection.LeftToRightTopToBottomRotated = 4] = "LeftToRightTopToBottomRotated", 
            TextDirection[TextDirection.TopToBottomRightToLeftRotated = 5] = "TopToBottomRightToLeftRotated";
        }(TextDirection || (TextDirection = {})), function(TableCellVerticalAlignment) {
            TableCellVerticalAlignment[TableCellVerticalAlignment.Top = 0] = "Top", TableCellVerticalAlignment[TableCellVerticalAlignment.Both = 1] = "Both", 
            TableCellVerticalAlignment[TableCellVerticalAlignment.Center = 2] = "Center", TableCellVerticalAlignment[TableCellVerticalAlignment.Bottom = 3] = "Bottom";
        }(TableCellVerticalAlignment || (TableCellVerticalAlignment = {})), function(ConditionalTableStyleFormatting) {
            ConditionalTableStyleFormatting[ConditionalTableStyleFormatting.WholeTable = 4096] = "WholeTable", 
            ConditionalTableStyleFormatting[ConditionalTableStyleFormatting.FirstRow = 2048] = "FirstRow", 
            ConditionalTableStyleFormatting[ConditionalTableStyleFormatting.LastRow = 1024] = "LastRow", 
            ConditionalTableStyleFormatting[ConditionalTableStyleFormatting.FirstColumn = 512] = "FirstColumn", 
            ConditionalTableStyleFormatting[ConditionalTableStyleFormatting.LastColumn = 256] = "LastColumn", 
            ConditionalTableStyleFormatting[ConditionalTableStyleFormatting.OddColumnBanding = 128] = "OddColumnBanding", 
            ConditionalTableStyleFormatting[ConditionalTableStyleFormatting.EvenColumnBanding = 64] = "EvenColumnBanding", 
            ConditionalTableStyleFormatting[ConditionalTableStyleFormatting.OddRowBanding = 32] = "OddRowBanding", 
            ConditionalTableStyleFormatting[ConditionalTableStyleFormatting.EvenRowBanding = 16] = "EvenRowBanding", 
            ConditionalTableStyleFormatting[ConditionalTableStyleFormatting.TopRightCell = 8] = "TopRightCell", 
            ConditionalTableStyleFormatting[ConditionalTableStyleFormatting.TopLeftCell = 4] = "TopLeftCell", 
            ConditionalTableStyleFormatting[ConditionalTableStyleFormatting.BottomRightCell = 2] = "BottomRightCell", 
            ConditionalTableStyleFormatting[ConditionalTableStyleFormatting.BottomLeftCell = 1] = "BottomLeftCell";
        }(ConditionalTableStyleFormatting || (ConditionalTableStyleFormatting = {}));
        class TableCustomUnit {
            getHashCode() {
                return math.MathUtils.somePrimes[0] * this.value ^ math.MathUtils.somePrimes[1] * this.type;
            }
            equals(obj) {
                return !!obj && (this.value == obj.value && this.type == obj.type);
            }
            copyFrom(obj) {
                this.value = obj.value, this.type = obj.type;
            }
        }
        class TableWidthUnit extends TableCustomUnit {
            static createDefault() {
                return (new TableWidthUnit).init(0, TableWidthUnitType.Nil);
            }
            static create(value, type) {
                return (new TableWidthUnit).init(value, type);
            }
            init(value, type) {
                return this.value = Math.floor(value), this.type = type, this;
            }
            clone() {
                return (new TableWidthUnit).init(this.value, this.type);
            }
            asNumberNoPercentType(converter) {
                switch (this.type) {
                  case TableWidthUnitType.Nil:
                  case TableWidthUnitType.Auto:
                    return 0;

                  case TableWidthUnitType.ModelUnits:
                    return converter(this.value);

                  case TableWidthUnitType.FiftiethsOfPercent:
                    return 0;
                }
            }
            asNumber(avaliableWidth, converter) {
                switch (this.type) {
                  case TableWidthUnitType.Nil:
                  case TableWidthUnitType.Auto:
                    return 0;

                  case TableWidthUnitType.ModelUnits:
                    return converter(this.value);

                  case TableWidthUnitType.FiftiethsOfPercent:
                    return avaliableWidth * this.value / TableWidthUnit.MAX_PERCENT_WIDTH;
                }
            }
            divide(n) {
                n > 1 && (this.value = Math.floor(this.value / n));
            }
        }
        TableWidthUnit.MAX_PERCENT_WIDTH = 5e3, TableWidthUnit.MUTLIPLIER_FOR_PERCENTS = 50;
        class TableHeightUnit extends TableCustomUnit {
            init(value, type) {
                return this.value = Math.floor(value), this.type = type, this;
            }
            clone() {
                return (new TableHeightUnit).init(this.value, this.type);
            }
            static create(value, type) {
                return (new TableHeightUnit).init(value, type);
            }
            static createDefault() {
                return (new TableHeightUnit).init(0, TableHeightUnitType.Auto);
            }
        }
        !function(TableHeightUnitType) {
            TableHeightUnitType[TableHeightUnitType.Minimum = 0] = "Minimum", TableHeightUnitType[TableHeightUnitType.Auto = 1] = "Auto", 
            TableHeightUnitType[TableHeightUnitType.Exact = 2] = "Exact";
        }(TableHeightUnitType || (TableHeightUnitType = {})), function(TableWidthUnitType) {
            TableWidthUnitType[TableWidthUnitType.Nil = 0] = "Nil", TableWidthUnitType[TableWidthUnitType.Auto = 1] = "Auto", 
            TableWidthUnitType[TableWidthUnitType.FiftiethsOfPercent = 2] = "FiftiethsOfPercent", 
            TableWidthUnitType[TableWidthUnitType.ModelUnits = 3] = "ModelUnits";
        }(TableWidthUnitType || (TableWidthUnitType = {}));
        class TableCellProperties {
            constructor() {
                this.mask = TableCellPropertiesMask.UseNone, this.cellMargins = TableCellMargins.create(TableWidthUnit.createDefault(), TableWidthUnit.createDefault(), TableWidthUnit.createDefault(), TableWidthUnit.createDefault()), 
                this.borders = TableCellBorders.create(new BorderInfo, new BorderInfo, new BorderInfo, new BorderInfo, new BorderInfo, new BorderInfo), 
                this.hideCellMark = !1, this.noWrap = !1, this.fitText = !1, this.textDirection = TextDirection.LeftToRightTopToBottom, 
                this.verticalAlignment = TableCellVerticalAlignment.Top, this.shadingInfo = ShadingInfo.noColor;
            }
            calculateHash() {
                return math.MathUtils.somePrimes[0] * this.mask ^ math.MathUtils.somePrimes[1] * this.borders.getHashCode() ^ math.MathUtils.somePrimes[2] * this.verticalAlignment ^ math.MathUtils.somePrimes[3] * this.shadingInfo.getHashCode();
            }
            getHashCode() {
                return void 0 === this.hash ? this.hash = this.calculateHash() : this.hash;
            }
            equals(obj) {
                return !!obj && (this.mask == obj.mask && this.cellMargins.equals(obj.cellMargins) && this.borders.equals(obj.borders) && this.hideCellMark == obj.hideCellMark && this.noWrap == obj.noWrap && this.fitText == obj.fitText && this.textDirection == obj.textDirection && this.verticalAlignment == obj.verticalAlignment && this.shadingInfo.equals(obj.shadingInfo));
            }
            clone() {
                var result = new TableCellProperties;
                return result.copyFrom(this), result;
            }
            copyFrom(obj) {
                this.mask = obj.mask, this.cellMargins = obj.cellMargins.clone(), this.borders = obj.borders.clone(), 
                this.hideCellMark = obj.hideCellMark, this.noWrap = obj.noWrap, this.fitText = obj.fitText, 
                this.textDirection = obj.textDirection, this.verticalAlignment = obj.verticalAlignment, 
                obj.shadingInfo && (this.shadingInfo = obj.shadingInfo.clone());
            }
            setUseValue(mask, value) {
                value ? this.mask |= mask : this.mask &= ~mask;
            }
            getUseValue(mask) {
                return !!(this.mask & mask);
            }
            setValue(desc, value) {
                desc.setProp(this, value), this.setUseValue(desc.maskValue(), !0);
            }
        }
        !function(TableCellPropertiesMask) {
            TableCellPropertiesMask[TableCellPropertiesMask.UseNone = 0] = "UseNone", TableCellPropertiesMask[TableCellPropertiesMask.UseHideCellMark = 2] = "UseHideCellMark", 
            TableCellPropertiesMask[TableCellPropertiesMask.UseNoWrap = 4] = "UseNoWrap", TableCellPropertiesMask[TableCellPropertiesMask.UseFitText = 8] = "UseFitText", 
            TableCellPropertiesMask[TableCellPropertiesMask.UseLeftMargin = 16] = "UseLeftMargin", 
            TableCellPropertiesMask[TableCellPropertiesMask.UseRightMargin = 32] = "UseRightMargin", 
            TableCellPropertiesMask[TableCellPropertiesMask.UseTopMargin = 64] = "UseTopMargin", 
            TableCellPropertiesMask[TableCellPropertiesMask.UseBottomMargin = 128] = "UseBottomMargin", 
            TableCellPropertiesMask[TableCellPropertiesMask.UseTextDirection = 256] = "UseTextDirection", 
            TableCellPropertiesMask[TableCellPropertiesMask.UseVerticalAlignment = 512] = "UseVerticalAlignment", 
            TableCellPropertiesMask[TableCellPropertiesMask.UseCellConditionalFormatting = 2048] = "UseCellConditionalFormatting", 
            TableCellPropertiesMask[TableCellPropertiesMask.UseLeftBorder = 4096] = "UseLeftBorder", 
            TableCellPropertiesMask[TableCellPropertiesMask.UseRightBorder = 8192] = "UseRightBorder", 
            TableCellPropertiesMask[TableCellPropertiesMask.UseTopBorder = 16384] = "UseTopBorder", 
            TableCellPropertiesMask[TableCellPropertiesMask.UseBottomBorder = 32768] = "UseBottomBorder", 
            TableCellPropertiesMask[TableCellPropertiesMask.UseTopLeftDiagonalBorder = 262144] = "UseTopLeftDiagonalBorder", 
            TableCellPropertiesMask[TableCellPropertiesMask.UseTopRightDiagonalBorder = 524288] = "UseTopRightDiagonalBorder", 
            TableCellPropertiesMask[TableCellPropertiesMask.UseShadingInfoIndex = 1048576] = "UseShadingInfoIndex", 
            TableCellPropertiesMask[TableCellPropertiesMask.UseAll = 2147483647] = "UseAll";
        }(TableCellPropertiesMask || (TableCellPropertiesMask = {}));
        class TableCellPropertyDescriptor {}
        TableCellPropertyDescriptor.topBorder = new class TableCellPropertiesTopBorderDescriptor {
            setProp(props, newValue) {
                props.borders.topBorder = newValue;
            }
            getProp(props) {
                return props.borders.topBorder;
            }
            maskValue() {
                return TableCellPropertiesMask.UseTopBorder;
            }
        }, TableCellPropertyDescriptor.rightBorder = new class TableCellPropertiesRightBorderDescriptor {
            setProp(props, newValue) {
                props.borders.rightBorder = newValue;
            }
            getProp(props) {
                return props.borders.rightBorder;
            }
            maskValue() {
                return TableCellPropertiesMask.UseRightBorder;
            }
        }, TableCellPropertyDescriptor.bottomBorder = new class TableCellPropertiesBottomBorderDescriptor {
            setProp(props, newValue) {
                props.borders.bottomBorder = newValue;
            }
            getProp(props) {
                return props.borders.bottomBorder;
            }
            maskValue() {
                return TableCellPropertiesMask.UseBottomBorder;
            }
        }, TableCellPropertyDescriptor.leftBorder = new class TableCellPropertiesLeftBorderDescriptor {
            setProp(props, newValue) {
                props.borders.leftBorder = newValue;
            }
            getProp(props) {
                return props.borders.leftBorder;
            }
            maskValue() {
                return TableCellPropertiesMask.UseLeftBorder;
            }
        }, TableCellPropertyDescriptor.topLeftDiagonalBorder = new class TableCellPropertiesTopLeftDiagonalBorderDescriptor {
            setProp(props, newValue) {
                props.borders.topLeftDiagonalBorder = newValue;
            }
            getProp(props) {
                return props.borders.topLeftDiagonalBorder;
            }
            maskValue() {
                return TableCellPropertiesMask.UseTopLeftDiagonalBorder;
            }
        }, TableCellPropertyDescriptor.topRightDiagonalBorder = new class TableCellPropertiesTopRightDiagonalBorderDescriptor {
            setProp(props, newValue) {
                props.borders.topRightDiagonalBorder = newValue;
            }
            getProp(props) {
                return props.borders.topRightDiagonalBorder;
            }
            maskValue() {
                return TableCellPropertiesMask.UseTopRightDiagonalBorder;
            }
        }, TableCellPropertyDescriptor.topMargin = new class TableCellPropertiesTopMarginDescriptor {
            setProp(props, newValue) {
                props.cellMargins.top = newValue;
            }
            getProp(props) {
                return props.cellMargins.top;
            }
            maskValue() {
                return TableCellPropertiesMask.UseTopMargin;
            }
        }, TableCellPropertyDescriptor.rightMargin = new class TableCellPropertiesRightMarginDescriptor {
            setProp(props, newValue) {
                props.cellMargins.right = newValue;
            }
            getProp(props) {
                return props.cellMargins.right;
            }
            maskValue() {
                return TableCellPropertiesMask.UseRightMargin;
            }
        }, TableCellPropertyDescriptor.bottomMargin = new class TableCellPropertiesBottomMarginDescriptor {
            setProp(props, newValue) {
                props.cellMargins.bottom = newValue;
            }
            getProp(props) {
                return props.cellMargins.bottom;
            }
            maskValue() {
                return TableCellPropertiesMask.UseBottomMargin;
            }
        }, TableCellPropertyDescriptor.leftMargin = new class TableCellPropertiesLeftMarginDescriptor {
            setProp(props, newValue) {
                props.cellMargins.left = newValue;
            }
            getProp(props) {
                return props.cellMargins.left;
            }
            maskValue() {
                return TableCellPropertiesMask.UseLeftMargin;
            }
        }, TableCellPropertyDescriptor.fitText = new class TableCellPropertiesFitTextDescriptor {
            setProp(props, newValue) {
                props.fitText = newValue;
            }
            getProp(props) {
                return props.fitText;
            }
            maskValue() {
                return TableCellPropertiesMask.UseFitText;
            }
        }, TableCellPropertyDescriptor.hideCellMark = new class TableCellPropertiesHideCellMarkDescriptor {
            setProp(props, newValue) {
                props.hideCellMark = newValue;
            }
            getProp(props) {
                return props.hideCellMark;
            }
            maskValue() {
                return TableCellPropertiesMask.UseHideCellMark;
            }
        }, TableCellPropertyDescriptor.noWrap = new class TableCellPropertiesNoWrapDescriptor {
            setProp(props, newValue) {
                props.noWrap = newValue;
            }
            getProp(props) {
                return props.noWrap;
            }
            maskValue() {
                return TableCellPropertiesMask.UseNoWrap;
            }
        }, TableCellPropertyDescriptor.shadingInfo = new class TableCellPropertiesShadingInfoDescriptor {
            setProp(props, newValue) {
                props.shadingInfo = newValue;
            }
            getProp(props) {
                return props.shadingInfo;
            }
            maskValue() {
                return TableCellPropertiesMask.UseShadingInfoIndex;
            }
        }, TableCellPropertyDescriptor.textDirection = new class TableCellPropertiesTextDirectionDescriptor {
            setProp(props, newValue) {
                props.textDirection = newValue;
            }
            getProp(props) {
                return props.textDirection;
            }
            maskValue() {
                return TableCellPropertiesMask.UseTextDirection;
            }
        }, TableCellPropertyDescriptor.vertivalAlignment = new class TableCellPropertiesVerticalAlignmentDescriptor {
            setProp(props, newValue) {
                props.verticalAlignment = newValue;
            }
            getProp(props) {
                return props.verticalAlignment;
            }
            maskValue() {
                return TableCellPropertiesMask.UseVerticalAlignment;
            }
        }, TableCellPropertyDescriptor.ALL_FIELDS = [ TableCellPropertyDescriptor.topBorder, TableCellPropertyDescriptor.rightBorder, TableCellPropertyDescriptor.bottomBorder, TableCellPropertyDescriptor.leftBorder, TableCellPropertyDescriptor.topLeftDiagonalBorder, TableCellPropertyDescriptor.topRightDiagonalBorder, TableCellPropertyDescriptor.topMargin, TableCellPropertyDescriptor.rightMargin, TableCellPropertyDescriptor.bottomMargin, TableCellPropertyDescriptor.leftMargin, TableCellPropertyDescriptor.fitText, TableCellPropertyDescriptor.hideCellMark, TableCellPropertyDescriptor.noWrap, TableCellPropertyDescriptor.shadingInfo, TableCellPropertyDescriptor.textDirection, TableCellPropertyDescriptor.vertivalAlignment ];
        var TablePropertiesMask, class_flag = __webpack_require__(7820);
        class TableBorders extends TableBordersBase {
            getHashCode() {
                return super.getHashCode() ^ math.MathUtils.somePrimes[14] * this.insideHorizontalBorder.getHashCode() ^ math.MathUtils.somePrimes[15] * this.insideVerticalBorder.getHashCode();
            }
            equals(obj) {
                return super.equals(obj) && this.insideHorizontalBorder.equals(obj.insideHorizontalBorder) && this.insideVerticalBorder.equals(obj.insideVerticalBorder);
            }
            copyFrom(obj) {
                super.copyFrom(obj), this.insideHorizontalBorder = obj.insideHorizontalBorder.clone(), 
                this.insideVerticalBorder = obj.insideVerticalBorder.clone();
            }
            clone() {
                var result = new TableBorders;
                return result.copyFrom(this), result;
            }
            static create(top, right, bottom, left, insideHorizontal, insideVertical) {
                let result = new TableBorders;
                return result.topBorder = top, result.rightBorder = right, result.bottomBorder = bottom, 
                result.leftBorder = left, result.insideHorizontalBorder = insideHorizontal, result.insideVerticalBorder = insideVertical, 
                result;
            }
        }
        class TableProperties {
            constructor() {
                this.mask = 0, this.cellMargins = TableCellMargins.create(TableWidthUnit.createDefault(), TableWidthUnit.createDefault(), TableWidthUnit.createDefault(), TableWidthUnit.createDefault()), 
                this.cellSpacing = TableWidthUnit.createDefault(), this.indent = TableWidthUnit.createDefault(), 
                this.borders = TableBorders.create(new BorderInfo, new BorderInfo, new BorderInfo, new BorderInfo, new BorderInfo, new BorderInfo), 
                this.tableStyleColumnBandSize = 1, this.tableStyleRowBandSize = 1, this.avoidDoubleBorders = !1, 
                this.layoutType = TableLayoutType.Autofit, this.shadingInfo = ShadingInfo.noColor, 
                this.tableRowAlignment = TableRowAlignment.Left, this.isTableOverlap = !0, this.bottomFromText = 0, 
                this.leftFromText = 0, this.topFromText = 0, this.rightFromText = 0, this.tableHorizontalPosition = 0, 
                this.tableVerticalPosition = 0, this.horizontalAlignMode = HorizontalAlignMode.None, 
                this.verticalAlignMode = VerticalAlignMode.None, this.horizontalAnchorType = HorizontalAnchorTypes.Page, 
                this.verticalAnchorType = VerticalAnchorTypes.Page, this.textWrapping = TextWrapping.Never;
            }
            calculateHash() {
                return math.MathUtils.somePrimes[0] * this.mask ^ math.MathUtils.somePrimes[1] * this.borders.getHashCode() ^ math.MathUtils.somePrimes[2] * this.indent.getHashCode() ^ math.MathUtils.somePrimes[3] * this.tableRowAlignment ^ math.MathUtils.somePrimes[4] * this.shadingInfo.getHashCode();
            }
            getHashCode() {
                return void 0 === this.hash ? this.hash = this.calculateHash() : this.hash;
            }
            equals(obj) {
                return !!obj && (this.mask == obj.mask && this.cellMargins.equals(obj.cellMargins) && this.cellSpacing.equals(obj.cellSpacing) && this.indent.equals(obj.indent) && this.borders.equals(obj.borders) && this.tableStyleColumnBandSize == obj.tableStyleColumnBandSize && this.tableStyleRowBandSize == obj.tableStyleRowBandSize && this.isTableOverlap == obj.isTableOverlap && this.avoidDoubleBorders == obj.avoidDoubleBorders && this.layoutType == obj.layoutType && this.shadingInfo.equals(obj.shadingInfo) && this.tableRowAlignment == obj.tableRowAlignment && this.bottomFromText == obj.bottomFromText && this.leftFromText == obj.leftFromText && this.topFromText == obj.topFromText && this.rightFromText == obj.rightFromText && this.tableHorizontalPosition == obj.tableHorizontalPosition && this.tableVerticalPosition == obj.tableVerticalPosition && this.horizontalAlignMode == obj.horizontalAlignMode && this.verticalAlignMode == obj.verticalAlignMode && this.horizontalAnchorType == obj.horizontalAnchorType && this.verticalAnchorType == obj.verticalAnchorType && this.textWrapping == obj.textWrapping);
            }
            clone() {
                var result = new TableProperties;
                return result.copyFrom(this), result;
            }
            copyFrom(obj) {
                this.mask = obj.mask, this.cellMargins = obj.cellMargins.clone(), this.cellSpacing = obj.cellSpacing.clone(), 
                this.indent = obj.indent.clone(), this.borders = obj.borders.clone(), this.tableStyleColumnBandSize = obj.tableStyleColumnBandSize, 
                this.tableStyleRowBandSize = obj.tableStyleRowBandSize, this.isTableOverlap = obj.isTableOverlap, 
                this.avoidDoubleBorders = obj.avoidDoubleBorders, this.layoutType = obj.layoutType, 
                obj.shadingInfo && (this.shadingInfo = obj.shadingInfo.clone()), this.tableRowAlignment = obj.tableRowAlignment, 
                this.bottomFromText = obj.bottomFromText, this.leftFromText = obj.leftFromText, 
                this.topFromText = obj.topFromText, this.rightFromText = obj.rightFromText, this.tableHorizontalPosition = obj.tableHorizontalPosition, 
                this.tableVerticalPosition = obj.tableVerticalPosition, this.horizontalAlignMode = obj.horizontalAlignMode, 
                this.verticalAlignMode = obj.verticalAlignMode, this.horizontalAnchorType = obj.horizontalAnchorType, 
                this.verticalAnchorType = obj.verticalAnchorType, this.textWrapping = obj.textWrapping;
            }
            setUseValue(mask, value) {
                value ? this.mask |= mask : this.mask &= ~mask;
            }
            getUseValue(mask) {
                return !!(this.mask & mask);
            }
            setValue(desc, value) {
                desc.setProp(this, value), this.setUseValue(desc.maskValue(), !0);
            }
        }
        !function(TablePropertiesMask) {
            TablePropertiesMask[TablePropertiesMask.UseNone = 0] = "UseNone", TablePropertiesMask[TablePropertiesMask.UseLeftMargin = 1] = "UseLeftMargin", 
            TablePropertiesMask[TablePropertiesMask.UseRightMargin = 2] = "UseRightMargin", 
            TablePropertiesMask[TablePropertiesMask.UseTopMargin = 4] = "UseTopMargin", TablePropertiesMask[TablePropertiesMask.UseBottomMargin = 8] = "UseBottomMargin", 
            TablePropertiesMask[TablePropertiesMask.UseCellSpacing = 16] = "UseCellSpacing", 
            TablePropertiesMask[TablePropertiesMask.UseTableIndent = 32] = "UseTableIndent", 
            TablePropertiesMask[TablePropertiesMask.UseTableLayout = 64] = "UseTableLayout", 
            TablePropertiesMask[TablePropertiesMask.UseTableStyleColBandSize = 512] = "UseTableStyleColBandSize", 
            TablePropertiesMask[TablePropertiesMask.UseTableStyleRowBandSize = 1024] = "UseTableStyleRowBandSize", 
            TablePropertiesMask[TablePropertiesMask.UseIsTableOverlap = 2048] = "UseIsTableOverlap", 
            TablePropertiesMask[TablePropertiesMask.UseFloatingPosition = 4096] = "UseFloatingPosition", 
            TablePropertiesMask[TablePropertiesMask.UseLeftBorder = 8192] = "UseLeftBorder", 
            TablePropertiesMask[TablePropertiesMask.UseRightBorder = 16384] = "UseRightBorder", 
            TablePropertiesMask[TablePropertiesMask.UseTopBorder = 32768] = "UseTopBorder", 
            TablePropertiesMask[TablePropertiesMask.UseBottomBorder = 65536] = "UseBottomBorder", 
            TablePropertiesMask[TablePropertiesMask.UseInsideHorizontalBorder = 131072] = "UseInsideHorizontalBorder", 
            TablePropertiesMask[TablePropertiesMask.UseInsideVerticalBorder = 262144] = "UseInsideVerticalBorder", 
            TablePropertiesMask[TablePropertiesMask.UseShadingInfoIndex = 524288] = "UseShadingInfoIndex", 
            TablePropertiesMask[TablePropertiesMask.UseTableAlignment = 1048576] = "UseTableAlignment", 
            TablePropertiesMask[TablePropertiesMask.UseAvoidDoubleBorders = 2097152] = "UseAvoidDoubleBorders", 
            TablePropertiesMask[TablePropertiesMask.UseRightToLeft = 4194304] = "UseRightToLeft", 
            TablePropertiesMask[TablePropertiesMask.UseAll = 2147483647] = "UseAll";
        }(TablePropertiesMask || (TablePropertiesMask = {}));
        class TablePropertyDescriptor {}
        TablePropertyDescriptor.avoidDoubleBorders = new class TablePropertiesAvoidDoubleBordersDescriptor {
            setProp(props, newValue) {
                props.avoidDoubleBorders = newValue;
            }
            getProp(props) {
                return props.avoidDoubleBorders;
            }
            maskValue() {
                return TablePropertiesMask.UseAvoidDoubleBorders;
            }
        }, TablePropertyDescriptor.topBorder = new class TablePropertiesTopBorderDescriptor {
            setProp(props, newValue) {
                props.borders.topBorder = newValue;
            }
            getProp(props) {
                return props.borders.topBorder;
            }
            maskValue() {
                return TablePropertiesMask.UseTopBorder;
            }
        }, TablePropertyDescriptor.rightBorder = new class TablePropertiesRightBorderDescriptor {
            setProp(props, newValue) {
                props.borders.rightBorder = newValue;
            }
            getProp(props) {
                return props.borders.rightBorder;
            }
            maskValue() {
                return TablePropertiesMask.UseRightBorder;
            }
        }, TablePropertyDescriptor.bottomBorder = new class TablePropertiesBottomBorderDescriptor {
            setProp(props, newValue) {
                props.borders.bottomBorder = newValue;
            }
            getProp(props) {
                return props.borders.bottomBorder;
            }
            maskValue() {
                return TablePropertiesMask.UseBottomBorder;
            }
        }, TablePropertyDescriptor.leftBorder = new class TablePropertiesLeftBorderDescriptor {
            setProp(props, newValue) {
                props.borders.leftBorder = newValue;
            }
            getProp(props) {
                return props.borders.leftBorder;
            }
            maskValue() {
                return TablePropertiesMask.UseLeftBorder;
            }
        }, TablePropertyDescriptor.insideHorizontalBorder = new class TablePropertiesInsideHorizontalBorderDescriptor {
            setProp(props, newValue) {
                props.borders.insideHorizontalBorder = newValue;
            }
            getProp(props) {
                return props.borders.insideHorizontalBorder;
            }
            maskValue() {
                return TablePropertiesMask.UseInsideHorizontalBorder;
            }
        }, TablePropertyDescriptor.insideVerticalBorder = new class TablePropertiesInsideVerticalBorderDescriptor {
            setProp(props, newValue) {
                props.borders.insideVerticalBorder = newValue;
            }
            getProp(props) {
                return props.borders.insideVerticalBorder;
            }
            maskValue() {
                return TablePropertiesMask.UseInsideVerticalBorder;
            }
        }, TablePropertyDescriptor.topMargin = new class TablePropertiesTopMarginDescriptor {
            setProp(props, newValue) {
                props.cellMargins.top = newValue;
            }
            getProp(props) {
                return props.cellMargins.top;
            }
            maskValue() {
                return TablePropertiesMask.UseTopMargin;
            }
        }, TablePropertyDescriptor.rightMargin = new class TablePropertiesRightMarginDescriptor {
            setProp(props, newValue) {
                props.cellMargins.right = newValue;
            }
            getProp(props) {
                return props.cellMargins.right;
            }
            maskValue() {
                return TablePropertiesMask.UseRightMargin;
            }
        }, TablePropertyDescriptor.bottomMargin = new class TablePropertiesBottomMarginDescriptor {
            setProp(props, newValue) {
                props.cellMargins.bottom = newValue;
            }
            getProp(props) {
                return props.cellMargins.bottom;
            }
            maskValue() {
                return TablePropertiesMask.UseBottomMargin;
            }
        }, TablePropertyDescriptor.leftMargin = new class TablePropertiesLeftMarginDescriptor {
            setProp(props, newValue) {
                props.cellMargins.left = newValue;
            }
            getProp(props) {
                return props.cellMargins.left;
            }
            maskValue() {
                return TablePropertiesMask.UseLeftMargin;
            }
        }, TablePropertyDescriptor.cellSpacing = new class TablePropertiesCellSpacingDescriptor {
            setProp(props, newValue) {
                props.cellSpacing = newValue;
            }
            getProp(props) {
                return props.cellSpacing;
            }
            maskValue() {
                return TablePropertiesMask.UseCellSpacing;
            }
        }, TablePropertyDescriptor.indent = new class TablePropertiesIndentDescriptor {
            setProp(props, newValue) {
                props.indent = newValue;
            }
            getProp(props) {
                return props.indent;
            }
            maskValue() {
                return TablePropertiesMask.UseTableIndent;
            }
        }, TablePropertyDescriptor.layoutType = new class TablePropertiesLayoutTypeDescriptor {
            setProp(props, newValue) {
                props.layoutType = newValue;
            }
            getProp(props) {
                return props.layoutType;
            }
            maskValue() {
                return TablePropertiesMask.UseTableLayout;
            }
        }, TablePropertyDescriptor.shadingInfo = new class TablePropertiesShadingInfoDescriptor {
            setProp(props, newValue) {
                props.shadingInfo = newValue;
            }
            getProp(props) {
                return props.shadingInfo;
            }
            maskValue() {
                return TablePropertiesMask.UseShadingInfoIndex;
            }
        }, TablePropertyDescriptor.rowAlignment = new class TablePropertiesRowAlignmentDescriptor {
            setProp(props, newValue) {
                props.tableRowAlignment = newValue;
            }
            getProp(props) {
                return props.tableRowAlignment;
            }
            maskValue() {
                return TablePropertiesMask.UseTableAlignment;
            }
        }, TablePropertyDescriptor.styleColumnBandSize = new class TablePropertiesStyleColumnBandSizeDescriptor {
            setProp(props, newValue) {
                props.tableStyleColumnBandSize = newValue;
            }
            getProp(props) {
                return props.tableStyleColumnBandSize;
            }
            maskValue() {
                return TablePropertiesMask.UseTableStyleColBandSize;
            }
        }, TablePropertyDescriptor.styleRowBandSize = new class TablePropertiesStyleRowBandSizeDescriptor {
            setProp(props, newValue) {
                props.tableStyleRowBandSize = newValue;
            }
            getProp(props) {
                return props.tableStyleRowBandSize;
            }
            maskValue() {
                return TablePropertiesMask.UseTableStyleRowBandSize;
            }
        }, TablePropertyDescriptor.ALL_FIELDS = [ TablePropertyDescriptor.avoidDoubleBorders, TablePropertyDescriptor.topBorder, TablePropertyDescriptor.rightBorder, TablePropertyDescriptor.bottomBorder, TablePropertyDescriptor.leftBorder, TablePropertyDescriptor.insideHorizontalBorder, TablePropertyDescriptor.insideVerticalBorder, TablePropertyDescriptor.topMargin, TablePropertyDescriptor.rightMargin, TablePropertyDescriptor.bottomMargin, TablePropertyDescriptor.leftMargin, TablePropertyDescriptor.cellSpacing, TablePropertyDescriptor.indent, TablePropertyDescriptor.layoutType, TablePropertyDescriptor.shadingInfo, TablePropertyDescriptor.rowAlignment, TablePropertyDescriptor.styleColumnBandSize, TablePropertyDescriptor.styleRowBandSize ];
        class TablePropertiesMergerBase {
            getProperty(container, style, condStyleFormattingFlags, defaultContainer) {
                if (this.getPropertyInternal(container)) return this.result;
                if (this.processTablePropertiesException()) return this.result;
                for (;style; ) {
                    const condStyleList = this.getCondTableStyleFormattingListForThisContainer();
                    for (let cond of condStyleList) if (condStyleFormattingFlags & cond) {
                        const condStyle = style.conditionalStyles[cond];
                        if (condStyle && this.getPropertyInternal(this.getContainerFromConditionalStyle(condStyle))) return this.result;
                    }
                    const baseConditionalStyleContainer = this.getContainerFromConditionalStyle(style.baseConditionalStyle);
                    if (baseConditionalStyleContainer && this.getPropertyInternal(baseConditionalStyleContainer)) return this.result;
                    style = style.parent;
                }
                return this.actionBeforeDefaultValue() ? this.result : this.getPropertyFromContainer(defaultContainer);
            }
            processTablePropertiesException() {
                if (!this.tablePropertiesException) return !1;
                const res = this.getNotMergedProperty();
                return !!res.isFound && (this.result = res.result, !0);
            }
            getPropertyInternal(container) {
                return !!this.canUseValue(container) && (this.result = this.getPropertyFromContainer(container), 
                !0);
            }
            actionBeforeDefaultValue() {
                return !1;
            }
        }
        class TableMergerNotMergedPropertyResult {
            constructor(isFound, result) {
                this.isFound = isFound, this.result = result;
            }
        }
        class TablePropertiesMerger extends TablePropertiesMergerBase {
            getContainerFromConditionalStyle(condStyle) {
                return condStyle.tableProperties;
            }
            canUseValue(props) {
                return !!(props.mask & this.getPropertyMask());
            }
            getCondTableStyleFormattingListForThisContainer() {
                return TablePropertiesMerger.conditionalTableStyleFormattingPriority;
            }
            getTableNotMergedProperty(container) {
                return this.canUseValue(container) ? new TableMergerNotMergedPropertyResult(!0, this.getPropertyFromContainer(container)) : new TableMergerNotMergedPropertyResult(!1, null);
            }
            getNotMergedProperty() {
                return this.getTableNotMergedProperty(this.tablePropertiesException);
            }
        }
        TablePropertiesMerger.conditionalTableStyleFormattingPriority = [ ConditionalTableStyleFormatting.WholeTable ];
        class TablePropertiesMergerIndent extends TablePropertiesMerger {
            getPropertyFromContainer(container) {
                return container.indent;
            }
            getPropertyMask() {
                return TablePropertiesMask.UseTableIndent;
            }
        }
        class TablePropertiesMergerCellSpacing extends TablePropertiesMerger {
            getPropertyFromContainer(container) {
                return container.cellSpacing;
            }
            getPropertyMask() {
                return TablePropertiesMask.UseCellSpacing;
            }
        }
        class TablePropertiesMergerBorderBase extends TablePropertiesMerger {
            constructor(isTableOuterBorder) {
                super(), this.isTableOuterBorder = isTableOuterBorder;
            }
            getPropertiesMaskCore(mask) {
                if (this.isTableOuterBorder) return mask;
                const flag = new class_flag.Flag(mask);
                return (flag.get(TablePropertiesMask.UseLeftBorder) || flag.get(TablePropertiesMask.UseRightBorder)) && flag.set(TablePropertiesMask.UseInsideVerticalBorder, !0), 
                (flag.get(TablePropertiesMask.UseTopBorder) || flag.get(TablePropertiesMask.UseBottomBorder)) && flag.set(TablePropertiesMask.UseInsideHorizontalBorder, !0), 
                flag.set(TablePropertiesMask.UseLeftBorder, !1), flag.set(TablePropertiesMask.UseRightBorder, !1), 
                flag.set(TablePropertiesMask.UseTopBorder, !1), flag.set(TablePropertiesMask.UseBottomBorder, !1), 
                flag.getValue();
            }
        }
        class TablePropertiesMergerBorderLeft extends TablePropertiesMergerBorderBase {
            constructor(isTableOuterBorder = !0) {
                super(isTableOuterBorder);
            }
            getPropertyFromContainer(container) {
                return container.borders.leftBorder;
            }
            getPropertyMask() {
                return super.getPropertiesMaskCore(TablePropertiesMask.UseLeftBorder);
            }
        }
        class TablePropertiesMergerBorderRight extends TablePropertiesMergerBorderBase {
            constructor(isTableOuterBorder = !0) {
                super(isTableOuterBorder);
            }
            getPropertyFromContainer(container) {
                return container.borders.rightBorder;
            }
            getPropertyMask() {
                return super.getPropertiesMaskCore(TablePropertiesMask.UseRightBorder);
            }
        }
        class TablePropertiesMergerBorderTop extends TablePropertiesMergerBorderBase {
            constructor(isTableOuterBorder = !0) {
                super(isTableOuterBorder);
            }
            getPropertyFromContainer(container) {
                return container.borders.topBorder;
            }
            getPropertyMask() {
                return super.getPropertiesMaskCore(TablePropertiesMask.UseTopBorder);
            }
        }
        class TablePropertiesMergerBorderBottom extends TablePropertiesMergerBorderBase {
            constructor(isTableOuterBorder = !0) {
                super(isTableOuterBorder);
            }
            getPropertyFromContainer(container) {
                return container.borders.bottomBorder;
            }
            getPropertyMask() {
                return super.getPropertiesMaskCore(TablePropertiesMask.UseBottomBorder);
            }
        }
        class TablePropertiesMergerBorderVertical extends TablePropertiesMerger {
            getPropertyFromContainer(container) {
                return container.borders.insideVerticalBorder;
            }
            getPropertyMask() {
                return TablePropertiesMask.UseInsideVerticalBorder;
            }
        }
        class TablePropertiesMergerBorderHorizontal extends TablePropertiesMerger {
            getPropertyFromContainer(container) {
                return container.borders.insideHorizontalBorder;
            }
            getPropertyMask() {
                return TablePropertiesMask.UseInsideHorizontalBorder;
            }
        }
        class TablePropertiesMergerMarginLeft extends TablePropertiesMerger {
            getPropertyFromContainer(container) {
                return container.cellMargins.left;
            }
            getPropertyMask() {
                return TablePropertiesMask.UseLeftMargin;
            }
        }
        class TablePropertiesMergerMarginRight extends TablePropertiesMerger {
            getPropertyFromContainer(container) {
                return container.cellMargins.right;
            }
            getPropertyMask() {
                return TablePropertiesMask.UseRightMargin;
            }
        }
        class TablePropertiesMergerMarginTop extends TablePropertiesMerger {
            getPropertyFromContainer(container) {
                return container.cellMargins.top;
            }
            getPropertyMask() {
                return TablePropertiesMask.UseTopMargin;
            }
        }
        class TablePropertiesMergerMarginBottom extends TablePropertiesMerger {
            getPropertyFromContainer(container) {
                return container.cellMargins.bottom;
            }
            getPropertyMask() {
                return TablePropertiesMask.UseBottomMargin;
            }
        }
        class TablePropertiesMergerLayoutType extends TablePropertiesMerger {
            getPropertyFromContainer(container) {
                return container.layoutType;
            }
            getPropertyMask() {
                return TablePropertiesMask.UseTableLayout;
            }
        }
        class TablePropertiesMergerShadingInfo extends TablePropertiesMerger {
            getPropertyFromContainer(container) {
                return container.shadingInfo;
            }
            getPropertyMask() {
                return TablePropertiesMask.UseShadingInfoIndex;
            }
        }
        class TablePropertiesMergerStyleColumnBandSize extends TablePropertiesMerger {
            getPropertyFromContainer(container) {
                return container.tableStyleColumnBandSize;
            }
            getPropertyMask() {
                return TablePropertiesMask.UseTableStyleColBandSize;
            }
        }
        class TablePropertiesMergerStyleRowBandSize extends TablePropertiesMerger {
            getPropertyFromContainer(container) {
                return container.tableStyleRowBandSize;
            }
            getPropertyMask() {
                return TablePropertiesMask.UseTableStyleRowBandSize;
            }
        }
        class TablePropertiesMergerHorizontalAlignment extends TablePropertiesMerger {
            getPropertyFromContainer(container) {
                return container.tableRowAlignment;
            }
            getPropertyMask() {
                return TablePropertiesMask.UseTableAlignment;
            }
            actionBeforeDefaultValue() {
                return this.result = TableRowAlignment.Left, !0;
            }
        }
        class TableCellPropertiesMerger extends TablePropertiesMergerBase {
            getContainerFromConditionalStyle(condStyle) {
                return condStyle.tableCellProperties;
            }
            canUseValue(props) {
                return !!(props.mask & this.getPropertyMask());
            }
            getCondTableStyleFormattingListForThisContainer() {
                return TableCellPropertiesMerger.conditionalTableStyleFormattingPriority;
            }
            getNotMergedProperty() {
                return new TableMergerNotMergedPropertyResult(!1, null);
            }
        }
        TableCellPropertiesMerger.conditionalTableStyleFormattingPriority = [ ConditionalTableStyleFormatting.TopLeftCell, ConditionalTableStyleFormatting.TopRightCell, ConditionalTableStyleFormatting.BottomLeftCell, ConditionalTableStyleFormatting.BottomRightCell, ConditionalTableStyleFormatting.FirstRow, ConditionalTableStyleFormatting.LastRow, ConditionalTableStyleFormatting.FirstColumn, ConditionalTableStyleFormatting.LastColumn, ConditionalTableStyleFormatting.EvenColumnBanding, ConditionalTableStyleFormatting.OddColumnBanding, ConditionalTableStyleFormatting.EvenRowBanding, ConditionalTableStyleFormatting.OddRowBanding, ConditionalTableStyleFormatting.WholeTable ];
        class TableCellPropertiesMergerMarginBase extends TableCellPropertiesMerger {
            constructor(table, model, tablePropertiesException) {
                super(), this.table = table, this.model = model, this.tablePropertiesException = tablePropertiesException;
            }
            actionBeforeDefaultValue() {
                return this.result = this.getMarginMerger().getProperty(this.table.properties, this.table.style, ConditionalTableStyleFormatting.WholeTable, this.model.defaultTableProperties), 
                !0;
            }
            getNotMergedProperty() {
                return this.getMarginMerger().getTableNotMergedProperty(this.tablePropertiesException);
            }
        }
        class TableCellPropertiesMergerMarginLeft extends TableCellPropertiesMergerMarginBase {
            getPropertyMask() {
                return TableCellPropertiesMask.UseLeftMargin;
            }
            getPropertyFromContainer(container) {
                return container.cellMargins.left;
            }
            getMarginMerger() {
                return new TablePropertiesMergerMarginLeft;
            }
        }
        class TableCellPropertiesMergerMarginRight extends TableCellPropertiesMergerMarginBase {
            getPropertyMask() {
                return TableCellPropertiesMask.UseRightMargin;
            }
            getPropertyFromContainer(container) {
                return container.cellMargins.right;
            }
            getMarginMerger() {
                return new TablePropertiesMergerMarginRight;
            }
        }
        class TableCellPropertiesMergerMarginTop extends TableCellPropertiesMergerMarginBase {
            getPropertyMask() {
                return TableCellPropertiesMask.UseTopMargin;
            }
            getPropertyFromContainer(container) {
                return container.cellMargins.top;
            }
            getMarginMerger() {
                return new TablePropertiesMergerMarginTop;
            }
        }
        class TableCellPropertiesMergerMarginBottom extends TableCellPropertiesMergerMarginBase {
            getPropertyMask() {
                return TableCellPropertiesMask.UseBottomMargin;
            }
            getPropertyFromContainer(container) {
                return container.cellMargins.bottom;
            }
            getMarginMerger() {
                return new TablePropertiesMergerMarginBottom;
            }
        }
        class TableCellPropertiesMergerBorderBase extends TableCellPropertiesMerger {
            constructor(tablePropertiesException) {
                super(), this.tablePropertiesException = tablePropertiesException;
            }
            actionBeforeDefaultValue() {
                return this.result = null, !0;
            }
        }
        class TableCellPropertiesMergerBorderLeft extends TableCellPropertiesMergerBorderBase {
            constructor(tablePropertiesException, isOutsideBorder) {
                super(tablePropertiesException), this.isOutsideBorder = isOutsideBorder;
            }
            getPropertyFromContainer(container) {
                return container.borders.leftBorder;
            }
            getPropertyMask() {
                return TableCellPropertiesMask.UseLeftBorder;
            }
            getNotMergedProperty() {
                return (new (this.isOutsideBorder ? TablePropertiesMergerBorderLeft : TablePropertiesMergerBorderVertical)).getTableNotMergedProperty(this.tablePropertiesException);
            }
        }
        class TableCellPropertiesMergerBorderRight extends TableCellPropertiesMergerBorderBase {
            constructor(tablePropertiesException, isOutsideBorder) {
                super(tablePropertiesException), this.isOutsideBorder = isOutsideBorder;
            }
            getPropertyFromContainer(container) {
                return container.borders.rightBorder;
            }
            getPropertyMask() {
                return TableCellPropertiesMask.UseRightBorder;
            }
            getNotMergedProperty() {
                return (new (this.isOutsideBorder ? TablePropertiesMergerBorderRight : TablePropertiesMergerBorderVertical)).getTableNotMergedProperty(this.tablePropertiesException);
            }
        }
        class TableCellPropertiesMergerBorderTop extends TableCellPropertiesMergerBorderBase {
            constructor(tablePropertiesException, isOutsideBorder) {
                super(tablePropertiesException), this.isOutsideBorder = isOutsideBorder;
            }
            getPropertyFromContainer(container) {
                return container.borders.topBorder;
            }
            getPropertyMask() {
                return TableCellPropertiesMask.UseTopBorder;
            }
            getNotMergedProperty() {
                return (new (this.isOutsideBorder ? TablePropertiesMergerBorderTop : TablePropertiesMergerBorderHorizontal)).getTableNotMergedProperty(this.tablePropertiesException);
            }
        }
        class TableCellPropertiesMergerBorderBottom extends TableCellPropertiesMergerBorderBase {
            constructor(tablePropertiesException, isOutsideBorder) {
                super(tablePropertiesException), this.isOutsideBorder = isOutsideBorder;
            }
            getPropertyFromContainer(container) {
                return container.borders.bottomBorder;
            }
            getPropertyMask() {
                return TableCellPropertiesMask.UseBottomBorder;
            }
            getNotMergedProperty() {
                return (new (this.isOutsideBorder ? TablePropertiesMergerBorderBottom : TablePropertiesMergerBorderHorizontal)).getTableNotMergedProperty(this.tablePropertiesException);
            }
        }
        class TableCellPropertiesMergerBorderTopLeftDiagonal extends TableCellPropertiesMergerBorderBase {
            getPropertyFromContainer(container) {
                return container.borders.topLeftDiagonalBorder;
            }
            getPropertyMask() {
                return TableCellPropertiesMask.UseTopLeftDiagonalBorder;
            }
        }
        class TableCellPropertiesMergerBorderTopRightDiagonal extends TableCellPropertiesMergerBorderBase {
            getPropertyFromContainer(container) {
                return container.borders.topRightDiagonalBorder;
            }
            getPropertyMask() {
                return TableCellPropertiesMask.UseTopRightDiagonalBorder;
            }
        }
        class TableCellPropertiesMergerNoWrap extends TableCellPropertiesMerger {
            getPropertyFromContainer(container) {
                return container.noWrap;
            }
            getPropertyMask() {
                return TableCellPropertiesMask.UseNoWrap;
            }
        }
        class TableCellPropertiesMergerShadingInfo extends TableCellPropertiesMerger {
            getPropertyFromContainer(container) {
                return container.shadingInfo;
            }
            getPropertyMask() {
                return TableCellPropertiesMask.UseShadingInfoIndex;
            }
        }
        class TableCellVerticalAlignmentMerger extends TableCellPropertiesMerger {
            getPropertyFromContainer(container) {
                return container.verticalAlignment;
            }
            getPropertyMask() {
                return TableCellPropertiesMask.UseVerticalAlignment;
            }
        }
        class TableStyleCharacterPropertiesMerger extends TablePropertiesMergerBase {
            getContainerFromConditionalStyle(condStyle) {
                return condStyle.maskedCharacterProperties;
            }
            canUseValue(props) {
                return !!props.getUseValue(this.getPropertyMask());
            }
            getCondTableStyleFormattingListForThisContainer() {
                return TableCellPropertiesMerger.conditionalTableStyleFormattingPriority;
            }
            actionBeforeDefaultValue() {
                return this.result = null, !0;
            }
            getNotMergedProperty() {
                return new TableMergerNotMergedPropertyResult(!1, null);
            }
        }
        class TableStyleCharacterPropertiesMergerHidden extends TableStyleCharacterPropertiesMerger {
            getPropertyFromContainer(container) {
                return container.hidden;
            }
            getPropertyMask() {
                return CharacterPropertiesMask.UseHidden;
            }
        }
        class TableStyleCharacterPropertiesMergerScript extends TableStyleCharacterPropertiesMerger {
            getPropertyFromContainer(container) {
                return container.script;
            }
            getPropertyMask() {
                return CharacterPropertiesMask.UseScript;
            }
        }
        class TableStyleCharacterPropertiesMergerAllCaps extends TableStyleCharacterPropertiesMerger {
            getPropertyFromContainer(container) {
                return container.allCaps;
            }
            getPropertyMask() {
                return CharacterPropertiesMask.UseAllCaps;
            }
        }
        class TableStyleCharacterPropertiesMergerSmallCaps extends TableStyleCharacterPropertiesMerger {
            getPropertyFromContainer(container) {
                return container.smallCaps;
            }
            getPropertyMask() {
                return CharacterPropertiesMask.UseSmallCaps;
            }
        }
        class TableStyleCharacterPropertiesMergerNoProof extends TableStyleCharacterPropertiesMerger {
            getPropertyFromContainer(container) {
                return container.noProof;
            }
            getPropertyMask() {
                return CharacterPropertiesMask.UseNoProof;
            }
        }
        class TableStyleCharacterPropertiesMergerFontBold extends TableStyleCharacterPropertiesMerger {
            getPropertyFromContainer(container) {
                return container.fontBold;
            }
            getPropertyMask() {
                return CharacterPropertiesMask.UseFontBold;
            }
        }
        class TableStyleCharacterPropertiesMergerFontName extends TableStyleCharacterPropertiesMerger {
            getPropertyFromContainer(container) {
                return container.fontInfo;
            }
            getPropertyMask() {
                return CharacterPropertiesMask.UseFontName;
            }
        }
        class TableStyleCharacterPropertiesMergerShadingInfo extends TableStyleCharacterPropertiesMerger {
            getPropertyFromContainer(container) {
                return container.shadingInfo;
            }
            getPropertyMask() {
                return CharacterPropertiesMask.UseShadingInfoIndex;
            }
        }
        class TableStyleCharacterPropertiesMergerTextColor extends TableStyleCharacterPropertiesMerger {
            getPropertyFromContainer(container) {
                return container.textColor;
            }
            getPropertyMask() {
                return CharacterPropertiesMask.UseForeColorIndex;
            }
        }
        class TableStyleCharacterPropertiesMergerFontSize extends TableStyleCharacterPropertiesMerger {
            getPropertyFromContainer(container) {
                return container.fontSize;
            }
            getPropertyMask() {
                return CharacterPropertiesMask.UseDoubleFontSize;
            }
        }
        class TableStyleCharacterPropertiesMergerFontItalic extends TableStyleCharacterPropertiesMerger {
            getPropertyFromContainer(container) {
                return container.fontItalic;
            }
            getPropertyMask() {
                return CharacterPropertiesMask.UseFontItalic;
            }
        }
        class TableStyleCharacterPropertiesMergerHighlightColor extends TableStyleCharacterPropertiesMerger {
            getPropertyFromContainer(container) {
                return container.highlightColor;
            }
            getPropertyMask() {
                return CharacterPropertiesMask.UseStrikeoutColorIndex;
            }
        }
        class TableStyleCharacterPropertiesMergerStrikeoutColor extends TableStyleCharacterPropertiesMerger {
            getPropertyFromContainer(container) {
                return container.strikeoutColor;
            }
            getPropertyMask() {
                return CharacterPropertiesMask.UseStrikeoutColorIndex;
            }
        }
        class TableStyleCharacterPropertiesMergerUnderlineColor extends TableStyleCharacterPropertiesMerger {
            getPropertyFromContainer(container) {
                return container.underlineColor;
            }
            getPropertyMask() {
                return CharacterPropertiesMask.UseUnderlineColorIndex;
            }
        }
        class TableStyleCharacterPropertiesMergerFontStrikeoutType extends TableStyleCharacterPropertiesMerger {
            getPropertyFromContainer(container) {
                return container.fontStrikeoutType;
            }
            getPropertyMask() {
                return CharacterPropertiesMask.UseFontStrikeoutType;
            }
        }
        class TableStyleCharacterPropertiesMergerFontUnderlineType extends TableStyleCharacterPropertiesMerger {
            getPropertyFromContainer(container) {
                return container.fontUnderlineType;
            }
            getPropertyMask() {
                return CharacterPropertiesMask.UseFontUnderlineType;
            }
        }
        class TableStyleCharacterPropertiesMergerStrikeoutWordsOnly extends TableStyleCharacterPropertiesMerger {
            getPropertyFromContainer(container) {
                return container.strikeoutWordsOnly;
            }
            getPropertyMask() {
                return CharacterPropertiesMask.UseStrikeoutWordsOnly;
            }
        }
        class TableStyleCharacterPropertiesMergerUnderlineWordsOnly extends TableStyleCharacterPropertiesMerger {
            getPropertyFromContainer(container) {
                return container.underlineWordsOnly;
            }
            getPropertyMask() {
                return CharacterPropertiesMask.UseUnderlineWordsOnly;
            }
        }
        class PropertiesMergerBase {
            constructor(initialialProperties, descriptors) {
                this.innerProperties = initialialProperties, this.descriptors = descriptors;
            }
            mergeInternal(properties, mask, setValue) {
                !this.innerProperties.getUseValue(mask) && properties.getUseValue(mask) && (setValue(), 
                this.innerProperties.setUseValue(mask, !0));
            }
            mergeOnlyOwnInternal(properties, parentProperties, mask, setValue, equals) {
                !this.innerProperties.getUseValue(mask) && properties.getUseValue(mask) && (parentProperties.getUseValue(mask) && equals() || (setValue(), 
                this.innerProperties.setUseValue(mask, !0)));
            }
            mergeTableProperties(descriptor, getValue) {
                const mask = descriptor.maskValue();
                if (this.innerProperties.getUseValue(mask)) return;
                const prop = getValue();
                null !== prop && (descriptor.setProp(this.innerProperties, prop), this.innerProperties.setUseValue(mask, !0));
            }
            mergeAll(from) {
                if (from) {
                    const to = this.innerProperties;
                    for (let desc of this.descriptors) {
                        const mask = desc.maskValue();
                        !to.getUseValue(mask) && from.getUseValue(mask) && (desc.setProp(to, desc.getProp(from)), 
                        to.setUseValue(mask, !0));
                    }
                }
            }
            mergeOnlyOwnProperties(from, parent) {
                const to = this.innerProperties;
                for (let desc of this.descriptors) {
                    const mask = desc.maskValue();
                    if (!to.getUseValue(mask) && from.getUseValue(mask)) {
                        if (parent.getUseValue(mask) && desc.binaryEquals(desc.getProp(from), desc.getProp(parent))) continue;
                        desc.setProp(to, desc.getProp(from)), to.setUseValue(mask, !0);
                    }
                }
            }
        }
        class CharacterPropertiesMerger extends PropertiesMergerBase {
            constructor() {
                super(new MaskedCharacterProperties, character_property_descriptor_CharacterPropertyDescriptor.ALL_FIELDS);
            }
            mergeCharacterProperties(maskedCharacterProperties) {
                this.mergeAll(maskedCharacterProperties);
            }
            mergeOnlyOwnCharacterProperties(sourceProperties, parentProperties) {
                this.mergeOnlyOwnProperties(sourceProperties, parentProperties);
            }
            mergeMergedCharacterProperties(mergedCharacterProperties) {
                var maskedCharacterProperties = new MaskedCharacterProperties;
                maskedCharacterProperties.copyFrom(mergedCharacterProperties), maskedCharacterProperties.setAllUse(), 
                this.mergeAll(maskedCharacterProperties);
            }
            mergeCharacterStyle(characterStyle) {
                for (var currentCharacterStyle = characterStyle; currentCharacterStyle; ) this.mergeAll(currentCharacterStyle.maskedCharacterProperties), 
                currentCharacterStyle = currentCharacterStyle.parent;
            }
            mergeParagraphStyle(paragraphStyle) {
                for (var currentParagraphStyle = paragraphStyle; currentParagraphStyle; ) this.mergeAll(currentParagraphStyle.maskedCharacterProperties), 
                currentParagraphStyle = currentParagraphStyle.parent;
            }
            mergeTableStyles(tableCell) {
                const tableStyle = tableCell.parentRow.parentTable.style, fakeContainer = new MaskedCharacterProperties;
                fakeContainer.resetAllUse(), this.mergeTableProperties(character_property_descriptor_CharacterPropertyDescriptor.hidden, (() => (new TableStyleCharacterPropertiesMergerHidden).getProperty(fakeContainer, tableStyle, tableCell.conditionalFormatting, null))), 
                this.mergeTableProperties(character_property_descriptor_CharacterPropertyDescriptor.script, (() => (new TableStyleCharacterPropertiesMergerScript).getProperty(fakeContainer, tableStyle, tableCell.conditionalFormatting, null))), 
                this.mergeTableProperties(character_property_descriptor_CharacterPropertyDescriptor.allCaps, (() => (new TableStyleCharacterPropertiesMergerAllCaps).getProperty(fakeContainer, tableStyle, tableCell.conditionalFormatting, null))), 
                this.mergeTableProperties(character_property_descriptor_CharacterPropertyDescriptor.smallCaps, (() => (new TableStyleCharacterPropertiesMergerSmallCaps).getProperty(fakeContainer, tableStyle, tableCell.conditionalFormatting, null))), 
                this.mergeTableProperties(character_property_descriptor_CharacterPropertyDescriptor.noProof, (() => (new TableStyleCharacterPropertiesMergerNoProof).getProperty(fakeContainer, tableStyle, tableCell.conditionalFormatting, null))), 
                this.mergeTableProperties(character_property_descriptor_CharacterPropertyDescriptor.bold, (() => (new TableStyleCharacterPropertiesMergerFontBold).getProperty(fakeContainer, tableStyle, tableCell.conditionalFormatting, null))), 
                this.mergeTableProperties(character_property_descriptor_CharacterPropertyDescriptor.fontInfo, (() => (new TableStyleCharacterPropertiesMergerFontName).getProperty(fakeContainer, tableStyle, tableCell.conditionalFormatting, null))), 
                this.mergeTableProperties(character_property_descriptor_CharacterPropertyDescriptor.size, (() => (new TableStyleCharacterPropertiesMergerFontSize).getProperty(fakeContainer, tableStyle, tableCell.conditionalFormatting, null))), 
                this.mergeTableProperties(character_property_descriptor_CharacterPropertyDescriptor.italic, (() => (new TableStyleCharacterPropertiesMergerFontItalic).getProperty(fakeContainer, tableStyle, tableCell.conditionalFormatting, null))), 
                this.mergeTableProperties(character_property_descriptor_CharacterPropertyDescriptor.strikeoutType, (() => (new TableStyleCharacterPropertiesMergerFontStrikeoutType).getProperty(fakeContainer, tableStyle, tableCell.conditionalFormatting, null))), 
                this.mergeTableProperties(character_property_descriptor_CharacterPropertyDescriptor.underlineType, (() => (new TableStyleCharacterPropertiesMergerFontUnderlineType).getProperty(fakeContainer, tableStyle, tableCell.conditionalFormatting, null))), 
                this.mergeTableProperties(character_property_descriptor_CharacterPropertyDescriptor.strikeoutWordsOnly, (() => (new TableStyleCharacterPropertiesMergerStrikeoutWordsOnly).getProperty(fakeContainer, tableStyle, tableCell.conditionalFormatting, null))), 
                this.mergeTableProperties(character_property_descriptor_CharacterPropertyDescriptor.underlineWordsOnly, (() => (new TableStyleCharacterPropertiesMergerUnderlineWordsOnly).getProperty(fakeContainer, tableStyle, tableCell.conditionalFormatting, null))), 
                this.mergeTableProperties(character_property_descriptor_CharacterPropertyDescriptor.textColor, (() => (new TableStyleCharacterPropertiesMergerTextColor).getProperty(fakeContainer, tableStyle, tableCell.conditionalFormatting, null))), 
                this.mergeTableProperties(character_property_descriptor_CharacterPropertyDescriptor.shadingInfo, (() => (new TableStyleCharacterPropertiesMergerShadingInfo).getProperty(fakeContainer, tableStyle, tableCell.conditionalFormatting, null))), 
                this.mergeTableProperties(character_property_descriptor_CharacterPropertyDescriptor.highlightColor, (() => (new TableStyleCharacterPropertiesMergerHighlightColor).getProperty(fakeContainer, tableStyle, tableCell.conditionalFormatting, null))), 
                this.mergeTableProperties(character_property_descriptor_CharacterPropertyDescriptor.strikeoutColor, (() => (new TableStyleCharacterPropertiesMergerStrikeoutColor).getProperty(fakeContainer, tableStyle, tableCell.conditionalFormatting, null))), 
                this.mergeTableProperties(character_property_descriptor_CharacterPropertyDescriptor.underlineColor, (() => (new TableStyleCharacterPropertiesMergerUnderlineColor).getProperty(fakeContainer, tableStyle, tableCell.conditionalFormatting, null)));
            }
            getMergedProperties() {
                const result = new CharacterProperties;
                return result.copyFrom(this.innerProperties), result;
            }
        }
        class TableStyleParagraphPropertiesMerger extends TablePropertiesMergerBase {
            getContainerFromConditionalStyle(condStyle) {
                return condStyle.maskedParagraphProperties;
            }
            canUseValue(props) {
                return !!(props.useValue & this.getPropertyMask());
            }
            getCondTableStyleFormattingListForThisContainer() {
                return TableCellPropertiesMerger.conditionalTableStyleFormattingPriority;
            }
            actionBeforeDefaultValue() {
                return this.result = null, !0;
            }
            getNotMergedProperty() {
                return new TableMergerNotMergedPropertyResult(!1, null);
            }
        }
        class TableStyleParagraphPropertiesMergerAlignment extends TableStyleParagraphPropertiesMerger {
            getPropertyFromContainer(container) {
                return container.alignment;
            }
            getPropertyMask() {
                return ParagraphPropertiesMask.UseAlignment;
            }
        }
        class TableStyleParagraphPropertiesMergerShadingInfo extends TableStyleParagraphPropertiesMerger {
            getPropertyFromContainer(container) {
                return container.shadingInfo;
            }
            getPropertyMask() {
                return ParagraphPropertiesMask.UseShadingInfoIndex;
            }
        }
        class TableStyleParagraphPropertiesMergerLeftIndent extends TableStyleParagraphPropertiesMerger {
            getPropertyFromContainer(container) {
                return container.leftIndent;
            }
            getPropertyMask() {
                return ParagraphPropertiesMask.UseLeftIndent;
            }
        }
        class TableStyleParagraphPropertiesMergerRightIndent extends TableStyleParagraphPropertiesMerger {
            getPropertyFromContainer(container) {
                return container.rightIndent;
            }
            getPropertyMask() {
                return ParagraphPropertiesMask.UseRightIndent;
            }
        }
        class TableStyleParagraphPropertiesMergerTopBorder extends TableStyleParagraphPropertiesMerger {
            getPropertyFromContainer(container) {
                return container.topBorder;
            }
            getPropertyMask() {
                return ParagraphPropertiesMask.UseTopBorder;
            }
        }
        class TableStyleParagraphPropertiesMergerKeepWithNext extends TableStyleParagraphPropertiesMerger {
            getPropertyFromContainer(container) {
                return container.keepWithNext;
            }
            getPropertyMask() {
                return ParagraphPropertiesMask.UseKeepWithNext;
            }
        }
        class TableStyleParagraphPropertiesMergerOutlineLevel extends TableStyleParagraphPropertiesMerger {
            getPropertyFromContainer(container) {
                return container.outlineLevel;
            }
            getPropertyMask() {
                return ParagraphPropertiesMask.UseOutlineLevel;
            }
        }
        class TableStyleParagraphPropertiesMergerSpacingAfter extends TableStyleParagraphPropertiesMerger {
            getPropertyFromContainer(container) {
                return container.spacingAfter;
            }
            getPropertyMask() {
                return ParagraphPropertiesMask.UseSpacingAfter;
            }
        }
        class TableStyleParagraphPropertiesMergerLeftBorder extends TableStyleParagraphPropertiesMerger {
            getPropertyFromContainer(container) {
                return container.leftBorder;
            }
            getPropertyMask() {
                return ParagraphPropertiesMask.UseLeftBorder;
            }
        }
        class TableStyleParagraphPropertiesMergerSpacingBefore extends TableStyleParagraphPropertiesMerger {
            getPropertyFromContainer(container) {
                return container.spacingBefore;
            }
            getPropertyMask() {
                return ParagraphPropertiesMask.UseSpacingBefore;
            }
        }
        class TableStyleParagraphPropertiesMergerRightBorder extends TableStyleParagraphPropertiesMerger {
            getPropertyFromContainer(container) {
                return container.rightBorder;
            }
            getPropertyMask() {
                return ParagraphPropertiesMask.UseRightBorder;
            }
        }
        class TableStyleParagraphPropertiesMergerBottomBorder extends TableStyleParagraphPropertiesMerger {
            getPropertyFromContainer(container) {
                return container.bottomBorder;
            }
            getPropertyMask() {
                return ParagraphPropertiesMask.UseBottomBorder;
            }
        }
        class TableStyleParagraphPropertiesMergerBetweenBorder extends TableStyleParagraphPropertiesMerger {
            getPropertyFromContainer(container) {
                return container.betweenBorder;
            }
            getPropertyMask() {
                return ParagraphPropertiesMask.UseBetweenBorder;
            }
        }
        class TableStyleParagraphPropertiesMergerPageBreakBefore extends TableStyleParagraphPropertiesMerger {
            getPropertyFromContainer(container) {
                return container.pageBreakBefore;
            }
            getPropertyMask() {
                return ParagraphPropertiesMask.UsePageBreakBefore;
            }
        }
        class TableStyleParagraphPropertiesMergerAfterAutoSpacing extends TableStyleParagraphPropertiesMerger {
            getPropertyFromContainer(container) {
                return container.afterAutoSpacing;
            }
            getPropertyMask() {
                return ParagraphPropertiesMask.UseAfterAutoSpacing;
            }
        }
        class TableStyleParagraphPropertiesMergerKeepLinesTogether extends TableStyleParagraphPropertiesMerger {
            getPropertyFromContainer(container) {
                return container.keepLinesTogether;
            }
            getPropertyMask() {
                return ParagraphPropertiesMask.UseKeepLinesTogether;
            }
        }
        class TableStyleParagraphPropertiesMergerRightToLeft extends TableStyleParagraphPropertiesMerger {
            getPropertyFromContainer(container) {
                return container.rightToLeft;
            }
            getPropertyMask() {
                return ParagraphPropertiesMask.UseRightToLeft;
            }
        }
        class TableStyleParagraphPropertiesMergerBeforeAutoSpacing extends TableStyleParagraphPropertiesMerger {
            getPropertyFromContainer(container) {
                return container.beforeAutoSpacing;
            }
            getPropertyMask() {
                return ParagraphPropertiesMask.UseBeforeAutoSpacing;
            }
        }
        class TableStyleParagraphPropertiesMergerContextualSpacing extends TableStyleParagraphPropertiesMerger {
            getPropertyFromContainer(container) {
                return container.contextualSpacing;
            }
            getPropertyMask() {
                return ParagraphPropertiesMask.UseContextualSpacing;
            }
        }
        class TableStyleParagraphPropertiesMergerWidowOrphanControl extends TableStyleParagraphPropertiesMerger {
            getPropertyFromContainer(container) {
                return container.widowOrphanControl;
            }
            getPropertyMask() {
                return ParagraphPropertiesMask.UseWidowOrphanControl;
            }
        }
        class TableStyleParagraphPropertiesMergerSuppressHyphenation extends TableStyleParagraphPropertiesMerger {
            getPropertyFromContainer(container) {
                return container.suppressHyphenation;
            }
            getPropertyMask() {
                return ParagraphPropertiesMask.UseSuppressHyphenation;
            }
        }
        class TableStyleParagraphPropertiesMergerSuppressLineNumbers extends TableStyleParagraphPropertiesMerger {
            getPropertyFromContainer(container) {
                return container.suppressLineNumbers;
            }
            getPropertyMask() {
                return ParagraphPropertiesMask.UseSuppressLineNumbers;
            }
        }
        class TableStyleParagraphPropertiesMergerFirstLineIndent extends TableStyleParagraphPropertiesMerger {
            getPropertyFromContainer(container) {
                return container.firstLineIndent;
            }
            getPropertyMask() {
                return ParagraphPropertiesMask.UseFirstLineIndent;
            }
        }
        class TableStyleParagraphPropertiesMergerFirstLineIndentType extends TableStyleParagraphPropertiesMerger {
            getPropertyFromContainer(container) {
                return container.firstLineIndentType;
            }
            getPropertyMask() {
                return ParagraphPropertiesMask.UseFirstLineIndent;
            }
        }
        class TableStyleParagraphPropertiesMergerLineSpacing extends TableStyleParagraphPropertiesMerger {
            getPropertyFromContainer(container) {
                return container.lineSpacing;
            }
            getPropertyMask() {
                return ParagraphPropertiesMask.UseLineSpacing;
            }
        }
        class TableStyleParagraphPropertiesMergerLineSpacingType extends TableStyleParagraphPropertiesMerger {
            getPropertyFromContainer(container) {
                return container.lineSpacingType;
            }
            getPropertyMask() {
                return ParagraphPropertiesMask.UseLineSpacing;
            }
        }
        class TableStyleParagraphPropertiesMergerDivId extends TableStyleParagraphPropertiesMerger {
            getPropertyFromContainer(container) {
                return container.divId;
            }
            getPropertyMask() {
                return ParagraphPropertiesMask.UseDivId;
            }
        }
        class ParagraphPropertiesMerger extends PropertiesMergerBase {
            constructor() {
                super(new MaskedParagraphProperties, ParagraphPropertiesMerger.fields);
            }
            mergeMaskedParagraphProperties(maskedParagraphProperties) {
                this.merge(maskedParagraphProperties);
            }
            mergeOnlyOwnCharacterProperties(sourceProperties, parentProperties) {
                this.mergeOnlyOwnProperties(sourceProperties, parentProperties), this.mergeOnlyOwnInternal(sourceProperties, parentProperties, ParagraphPropertiesMask.UseFirstLineIndent, (() => {
                    this.innerProperties.firstLineIndent = sourceProperties.firstLineIndent, this.innerProperties.firstLineIndentType = sourceProperties.firstLineIndentType;
                }), (() => sourceProperties.firstLineIndent == parentProperties.firstLineIndent && sourceProperties.firstLineIndentType == parentProperties.firstLineIndentType)), 
                this.mergeOnlyOwnInternal(sourceProperties, parentProperties, ParagraphPropertiesMask.UseLineSpacing, (() => {
                    this.innerProperties.lineSpacing = sourceProperties.lineSpacing, this.innerProperties.lineSpacingType = sourceProperties.lineSpacingType;
                }), (() => sourceProperties.lineSpacing == parentProperties.lineSpacing && sourceProperties.lineSpacingType == parentProperties.lineSpacingType));
            }
            mergeParagraphStyle(paragraphStyle) {
                let currentParagraphStyle = paragraphStyle;
                for (;currentParagraphStyle; ) this.merge(currentParagraphStyle.maskedParagraphProperties), 
                currentParagraphStyle = currentParagraphStyle.parent;
            }
            mergeParagraphStyleConsiderNumbering(paragraphStyle, model) {
                let currentParagraphStyle = paragraphStyle;
                for (;currentParagraphStyle; ) this.merge(currentParagraphStyle.maskedParagraphProperties), 
                currentParagraphStyle.isInOwnList() && this.merge(currentParagraphStyle.getListLevel(model).getParagraphProperties()), 
                currentParagraphStyle = currentParagraphStyle.parent;
            }
            mergeTableStyle(tableCell) {
                const tableStyle = tableCell.parentRow.parentTable.style, fakeContainer = new MaskedParagraphProperties;
                fakeContainer.useValue = ParagraphPropertiesMask.UseNone, this.mergeTableProperties(ParagraphPropertyDescriptor.alignment, (() => (new TableStyleParagraphPropertiesMergerAlignment).getProperty(fakeContainer, tableStyle, tableCell.conditionalFormatting, null))), 
                this.mergeTableProperties(ParagraphPropertyDescriptor.shadingInfo, (() => (new TableStyleParagraphPropertiesMergerShadingInfo).getProperty(fakeContainer, tableStyle, tableCell.conditionalFormatting, null))), 
                this.mergeTableProperties(ParagraphPropertyDescriptor.leftIndent, (() => (new TableStyleParagraphPropertiesMergerLeftIndent).getProperty(fakeContainer, tableStyle, tableCell.conditionalFormatting, null))), 
                this.mergeTableProperties(ParagraphPropertyDescriptor.rightIndent, (() => (new TableStyleParagraphPropertiesMergerRightIndent).getProperty(fakeContainer, tableStyle, tableCell.conditionalFormatting, null))), 
                this.mergeTableProperties(ParagraphPropertyDescriptor.topBorder, (() => (new TableStyleParagraphPropertiesMergerTopBorder).getProperty(fakeContainer, tableStyle, tableCell.conditionalFormatting, null))), 
                this.mergeTableProperties(ParagraphPropertyDescriptor.keepWithNext, (() => (new TableStyleParagraphPropertiesMergerKeepWithNext).getProperty(fakeContainer, tableStyle, tableCell.conditionalFormatting, null))), 
                this.mergeTableProperties(ParagraphPropertyDescriptor.outlineLevel, (() => (new TableStyleParagraphPropertiesMergerOutlineLevel).getProperty(fakeContainer, tableStyle, tableCell.conditionalFormatting, null))), 
                this.mergeTableProperties(ParagraphPropertyDescriptor.spacingAfter, (() => (new TableStyleParagraphPropertiesMergerSpacingAfter).getProperty(fakeContainer, tableStyle, tableCell.conditionalFormatting, null))), 
                this.mergeTableProperties(ParagraphPropertyDescriptor.leftBorder, (() => (new TableStyleParagraphPropertiesMergerLeftBorder).getProperty(fakeContainer, tableStyle, tableCell.conditionalFormatting, null))), 
                this.mergeTableProperties(ParagraphPropertyDescriptor.spacingBefore, (() => (new TableStyleParagraphPropertiesMergerSpacingBefore).getProperty(fakeContainer, tableStyle, tableCell.conditionalFormatting, null))), 
                this.mergeTableProperties(ParagraphPropertyDescriptor.rightBorder, (() => (new TableStyleParagraphPropertiesMergerRightBorder).getProperty(fakeContainer, tableStyle, tableCell.conditionalFormatting, null))), 
                this.mergeTableProperties(ParagraphPropertyDescriptor.bottomBorder, (() => (new TableStyleParagraphPropertiesMergerBottomBorder).getProperty(fakeContainer, tableStyle, tableCell.conditionalFormatting, null))), 
                this.mergeTableProperties(ParagraphPropertyDescriptor.betweenBorder, (() => (new TableStyleParagraphPropertiesMergerBetweenBorder).getProperty(fakeContainer, tableStyle, tableCell.conditionalFormatting, null))), 
                this.mergeTableProperties(ParagraphPropertyDescriptor.pageBreakBefore, (() => (new TableStyleParagraphPropertiesMergerPageBreakBefore).getProperty(fakeContainer, tableStyle, tableCell.conditionalFormatting, null))), 
                this.mergeTableProperties(ParagraphPropertyDescriptor.afterAutoSpacing, (() => (new TableStyleParagraphPropertiesMergerAfterAutoSpacing).getProperty(fakeContainer, tableStyle, tableCell.conditionalFormatting, null))), 
                this.mergeTableProperties(ParagraphPropertyDescriptor.keepLinesTogether, (() => (new TableStyleParagraphPropertiesMergerKeepLinesTogether).getProperty(fakeContainer, tableStyle, tableCell.conditionalFormatting, null))), 
                this.mergeTableProperties(ParagraphPropertyDescriptor.beforeAutoSpacing, (() => (new TableStyleParagraphPropertiesMergerBeforeAutoSpacing).getProperty(fakeContainer, tableStyle, tableCell.conditionalFormatting, null))), 
                this.mergeTableProperties(ParagraphPropertyDescriptor.contextualSpacing, (() => (new TableStyleParagraphPropertiesMergerContextualSpacing).getProperty(fakeContainer, tableStyle, tableCell.conditionalFormatting, null))), 
                this.mergeTableProperties(ParagraphPropertyDescriptor.widowOrphanControl, (() => (new TableStyleParagraphPropertiesMergerWidowOrphanControl).getProperty(fakeContainer, tableStyle, tableCell.conditionalFormatting, null))), 
                this.mergeTableProperties(ParagraphPropertyDescriptor.suppressHyphenation, (() => (new TableStyleParagraphPropertiesMergerSuppressHyphenation).getProperty(fakeContainer, tableStyle, tableCell.conditionalFormatting, null))), 
                this.mergeTableProperties(ParagraphPropertyDescriptor.suppressLineNumbers, (() => (new TableStyleParagraphPropertiesMergerSuppressLineNumbers).getProperty(fakeContainer, tableStyle, tableCell.conditionalFormatting, null))), 
                this.mergeTableProperties(ParagraphPropertyDescriptor.firstLineIndent, (() => (new TableStyleParagraphPropertiesMergerFirstLineIndent).getProperty(fakeContainer, tableStyle, tableCell.conditionalFormatting, null))), 
                this.mergeTableProperties(ParagraphPropertyDescriptor.firstLineIndentType, (() => (new TableStyleParagraphPropertiesMergerFirstLineIndentType).getProperty(fakeContainer, tableStyle, tableCell.conditionalFormatting, null))), 
                this.mergeTableProperties(ParagraphPropertyDescriptor.lineSpacing, (() => (new TableStyleParagraphPropertiesMergerLineSpacing).getProperty(fakeContainer, tableStyle, tableCell.conditionalFormatting, null))), 
                this.mergeTableProperties(ParagraphPropertyDescriptor.lineSpacingType, (() => (new TableStyleParagraphPropertiesMergerLineSpacingType).getProperty(fakeContainer, tableStyle, tableCell.conditionalFormatting, null))), 
                this.mergeTableProperties(ParagraphPropertyDescriptor.divId, (() => (new TableStyleParagraphPropertiesMergerDivId).getProperty(fakeContainer, tableStyle, tableCell.conditionalFormatting, null))), 
                this.mergeTableProperties(ParagraphPropertyDescriptor.rightToLeft, (() => (new TableStyleParagraphPropertiesMergerRightToLeft).getProperty(fakeContainer, tableStyle, tableCell.conditionalFormatting, null)));
            }
            getMergedProperties() {
                const result = new ParagraphProperties;
                return result.copyFrom(this.innerProperties), result;
            }
            merge(properties) {
                properties && (this.mergeAll(properties), this.mergeInternal(properties, ParagraphPropertiesMask.UseFirstLineIndent, (() => {
                    this.innerProperties.firstLineIndent = properties.firstLineIndent, this.innerProperties.firstLineIndentType = properties.firstLineIndentType;
                })), this.mergeInternal(properties, ParagraphPropertiesMask.UseLineSpacing, (() => {
                    this.innerProperties.lineSpacing = properties.lineSpacing, this.innerProperties.lineSpacingType = properties.lineSpacingType;
                })));
            }
        }
        ParagraphPropertiesMerger.fields = utils_list.ListUtils.reducedMap(ParagraphPropertyDescriptor.ALL_FIELDS, (f => utils_enum.Y.isAnyOf(f.maskValue(), ParagraphPropertiesMask.UseFirstLineIndent, ParagraphPropertiesMask.UseLineSpacing) ? null : f));
        class ListLevel {
            constructor(documentModel, maskedCharacterProperties, maskedParagraphProperties, listLevelProperties) {
                this.documentModel = documentModel, this.setCharacterProperties(maskedCharacterProperties), 
                this.setParagraphProperties(maskedParagraphProperties), this.setListLevelProperties(listLevelProperties);
            }
            getListLevelProperties() {
                return this.listLevelProperties;
            }
            setListLevelProperties(properties) {
                this.listLevelProperties = this.documentModel.cache.listLevelPropertiesCache.getItem(properties);
            }
            changeListLevelProperties(change) {
                const currentPropertiesCopy = this.listLevelProperties.clone();
                change(currentPropertiesCopy), this.setListLevelProperties(currentPropertiesCopy);
            }
            getCharacterProperties() {
                return this.maskedCharacterProperties;
            }
            getParagraphProperties() {
                return this.maskedParagraphProperties;
            }
            setParagraphProperties(properties) {
                this.maskedParagraphProperties = this.documentModel.cache.maskedParagraphPropertiesCache.getItem(properties);
            }
            onParagraphPropertiesChanged() {
                this.resetParagraphMergedProperties();
            }
            resetParagraphMergedProperties() {
                this.mergedParagraphProperties = null;
            }
            getParagraphMergedProperties() {
                if (!this.hasParagraphMergedProperies()) {
                    var merger = new ParagraphPropertiesMerger;
                    merger.mergeMaskedParagraphProperties(this.maskedParagraphProperties), merger.mergeMaskedParagraphProperties(this.documentModel.defaultParagraphProperties), 
                    this.mergedParagraphProperties = merger.getMergedProperties();
                }
                return this.mergedParagraphProperties;
            }
            setParagraphMergedProperies(properties) {
                this.mergedParagraphProperties = this.documentModel.cache.mergedParagraphPropertiesCache.getItem(properties);
            }
            hasParagraphMergedProperies() {
                return !!this.mergedParagraphProperties;
            }
            setCharacterProperties(properties) {
                this.maskedCharacterProperties = this.documentModel.cache.maskedCharacterPropertiesCache.getItem(properties);
            }
            onCharacterPropertiesChanged() {
                this.resetCharacterMergedProperties();
            }
            resetCharacterMergedProperties() {
                this.mergedCharacterProperties = null;
            }
            getCharacterMergedProperties() {
                if (!this.hasCharacterMergedProperies()) {
                    var merger = new CharacterPropertiesMerger;
                    merger.mergeCharacterProperties(this.maskedCharacterProperties), merger.mergeCharacterProperties(this.documentModel.defaultCharacterProperties), 
                    this.mergedCharacterProperties = merger.getMergedProperties();
                }
                return this.mergedCharacterProperties;
            }
            setCharacterMergedProperies(properties) {
                this.mergedCharacterProperties = this.documentModel.cache.mergedCharacterPropertiesCache.getItem(properties);
            }
            hasCharacterMergedProperies() {
                return !!this.mergedCharacterProperties;
            }
            equals(obj) {
                return obj === this || !!obj.getCharacterProperties().equals(this.getCharacterProperties()) && (!!obj.getParagraphProperties().equals(this.getParagraphProperties()) && !!obj.getListLevelProperties().equals(this.getListLevelProperties()));
            }
            externallyEquals(obj) {
                return obj === this || obj.getListLevelProperties().displayFormatString == this.getListLevelProperties().displayFormatString && obj.getListLevelProperties().format == this.getListLevelProperties().format && obj.getListLevelProperties().start == this.getListLevelProperties().start && obj.getCharacterProperties().fontBold == this.getCharacterProperties().fontBold && obj.getCharacterProperties().fontItalic == this.getCharacterProperties().fontItalic && obj.getCharacterProperties().fontSize == this.getCharacterProperties().fontSize && obj.getCharacterProperties().textColor.equals(this.getCharacterProperties().textColor) && obj.getCharacterProperties().fontInfo.equals(this.getCharacterProperties().fontInfo);
            }
            copyFrom(obj) {
                this.setListLevelProperties(obj.getListLevelProperties()), this.setCharacterProperties(obj.getCharacterProperties()), 
                this.setParagraphProperties(obj.getParagraphProperties()), this.onCharacterPropertiesChanged(), 
                this.onParagraphPropertiesChanged();
            }
        }
        class NumberingListReferenceLevel {
            constructor(owner, level) {
                this.overrideStart = !1, this.newStart = 1, this.owner = owner, this.level = level, 
                this.documentModel = owner.documentModel;
            }
            getListLevelProperties() {
                return this.getOwnerLevel().getListLevelProperties();
            }
            setListLevelProperties(properties) {
                this.getOwnerLevel().setListLevelProperties(properties);
            }
            getCharacterProperties() {
                return this.getOwnerLevel().getCharacterProperties();
            }
            getParagraphProperties() {
                return this.getOwnerLevel().getParagraphProperties();
            }
            setParagraphProperties(properties) {
                this.getOwnerLevel().setParagraphProperties(properties);
            }
            onParagraphPropertiesChanged() {
                this.getOwnerLevel().onParagraphPropertiesChanged();
            }
            getParagraphMergedProperties() {
                return this.getOwnerLevel().getParagraphMergedProperties();
            }
            setParagraphMergedProperies(properties) {
                this.getOwnerLevel().setParagraphMergedProperies(properties);
            }
            hasParagraphMergedProperies() {
                return this.getOwnerLevel().hasParagraphMergedProperies();
            }
            resetParagraphMergedProperties() {
                this.getOwnerLevel().resetParagraphMergedProperties();
            }
            setCharacterProperties(properties) {
                this.getOwnerLevel().setCharacterProperties(properties);
            }
            onCharacterPropertiesChanged() {
                this.getOwnerLevel().onCharacterPropertiesChanged();
            }
            getCharacterMergedProperties() {
                return this.getOwnerLevel().getCharacterMergedProperties();
            }
            setCharacterMergedProperies(properties) {
                this.getOwnerLevel().setCharacterMergedProperies(properties);
            }
            hasCharacterMergedProperies() {
                return this.getOwnerLevel().hasCharacterMergedProperies();
            }
            resetCharacterMergedProperties() {
                this.getOwnerLevel().resetCharacterMergedProperties();
            }
            getNewStart() {
                return this.newStart;
            }
            setNewStart(newStart) {
                this.newStart = newStart;
            }
            getOwnerLevel() {
                return this.owner.getAbstractNumberingList().levels[this.level];
            }
            equals(obj) {
                return this.getOwnerLevel().equals(obj.getOwnerLevel());
            }
            externallyEquals(obj) {
                return this.getOwnerLevel().externallyEquals(obj.getOwnerLevel());
            }
            copyFrom(obj) {
                if (!(obj instanceof NumberingListReferenceLevel)) throw new Error("Source level should have equal type");
                this.newStart = obj.newStart, this.overrideStart = obj.overrideStart;
            }
        }
        class OverrideListLevel extends ListLevel {
            constructor() {
                super(...arguments), this.overrideStart = !1;
            }
            getNewStart() {
                return this.getListLevelProperties().start;
            }
            setNewStart(newStart) {
                var properties = this.getListLevelProperties().clone();
                properties.start = newStart, this.setListLevelProperties(properties);
            }
            copyFrom(obj) {
                if (!(obj instanceof OverrideListLevel)) throw new Error("Source level should have equal type");
                super.copyFrom(obj), this.overrideStart = obj.overrideStart;
            }
        }
        var NumberingFormat, ListNumberAlignment, numbering_list_NumberingType, utils_string = __webpack_require__(49), algorithms = __webpack_require__(1104), fixed = __webpack_require__(8860);
        class RichUtils {
            static getSelectedParagraphs(intervals, subDocument) {
                intervals = algorithms.IntervalAlgorithms.getMergedIntervals(intervals, !0);
                for (var interval, selectedParagraphs = [], i = 0; interval = intervals[i]; i++) selectedParagraphs = selectedParagraphs.concat(subDocument.getParagraphsByInterval(interval));
                var paragraph, newSelectedParagraphs = [ (selectedParagraphs = selectedParagraphs.sort((function(a, b) {
                    return a.startLogPosition.value < b.startLogPosition.value ? -1 : 1;
                })))[0] ], prevLogPos = newSelectedParagraphs[0].startLogPosition.value;
                for (i = 1; paragraph = selectedParagraphs[i]; i++) paragraph.startLogPosition.value != prevLogPos && (newSelectedParagraphs.push(paragraph), 
                prevLogPos = paragraph.startLogPosition.value);
                return {
                    paragraphs: newSelectedParagraphs,
                    intervals
                };
            }
            static getIntervalsOfSelectedParagraphs(intervals, subDocument) {
                let result = [];
                const paragraphs = this.getSelectedParagraphs(intervals, subDocument).paragraphs;
                return utils_list.ListUtils.forEach(paragraphs, (p => {
                    result.push(fixed.FixedInterval.fromPositions(p.startLogPosition.value, p.getEndPosition()));
                })), result;
            }
            static getCopyPasteGuid(guids) {
                return `re-rangecopy&${guids.sguid}&${guids.cguid}`;
            }
            static getCopyPasteGuidLabel(guids) {
                return `id="${RichUtils.getCopyPasteGuid(guids)}"`;
            }
            static getNextPredefinedFontSize(current) {
                var index = search.SearchUtils.normedInterpolationIndexOf(RichUtils.predefinedFontSizes, (a => a), current);
                return void 0 !== RichUtils.predefinedFontSizes[index + 1] ? RichUtils.predefinedFontSizes[index + 1] : 10 * Math.floor(current / 10) + 10;
            }
            static getPreviousPredefinedFontSize(current) {
                var index = search.SearchUtils.binaryIndexOf(RichUtils.predefinedFontSizes, (a => a - current));
                if (index > 0) return RichUtils.predefinedFontSizes[index - 1];
                if (index < 0 && (index = ~index), 0 === index) return Math.max(1, current - 1);
                var predefinedFontsCount = RichUtils.predefinedFontSizes.length;
                if (index < predefinedFontsCount) return RichUtils.predefinedFontSizes[index - 1];
                var newValue = current % 10 > 0 ? 10 * Math.floor(current / 10) : 10 * Math.floor(current / 10) - 10;
                return newValue >= RichUtils.predefinedFontSizes[predefinedFontsCount - 1] ? newValue : RichUtils.predefinedFontSizes[predefinedFontsCount - 1];
            }
            static replaceParagraphEndCharsWithLineBreak(text) {
                return text.replace(/(\r\n)|(\n)|(\r)/g, RichUtils.specialCharacters.LineBreak);
            }
        }
        RichUtils.isLatinLetter = /\w/, RichUtils.isWhitespace = /\s/, RichUtils.isAlphanumeric = /^[\u00C0-\u1FFF\u2C00-\uD7FF\w]+$/, 
        RichUtils.predefinedFontSizes = [ 8, 9, 10, 11, 12, 14, 16, 18, 20, 22, 24, 26, 28, 36, 48, 72 ], 
        RichUtils.minFontSize = 1, RichUtils.maxFontSize = 600, RichUtils.specialCharacters = new class SpecialCharacters {
            constructor() {
                this.Dot = ".", this.Colon = ":", this.Underscore = "_", this.EqualSign = "=", this.MiddleDot = "·", 
                this.Dash = "-", this.ParagraphMark = String.fromCharCode(13), this.SectionMark = String.fromCharCode(29), 
                this.Hyphen = "‐", this.TabMark = String.fromCharCode(9), this.NonBreakingSpace = " ", 
                this.Space = " ", this.EmSpace = " ", this.EnSpace = " ", this.QmSpace = " ", this.LineBreak = "\v", 
                this.PageBreak = "\f", this.ColumnBreak = "", this.ObjectMark = "￼", this.FloatingObjectMark = "\b", 
                this.NumberingListMark = "￻", this.EmDash = "—", this.EnDash = "–", this.Bullet = "•", 
                this.LeftSingleQuote = "‘", this.RightSingleQuote = "’", this.LeftDoubleQuote = "“", 
                this.RightDoubleQuote = "”", this.PilcrowSign = "¶", this.CurrencySign = "¤", this.CopyrightSymbol = "©", 
                this.TrademarkSymbol = "™", this.OptionalHyphen = "­", this.RegisteredTrademarkSymbol = "®", 
                this.Ellipsis = "…", this.OpeningSingleQuotationMark = "‘", this.ClosingSingleQuotationMark = "’", 
                this.OpeningDoubleQuotationMark = "“", this.ClosingDoubleQuotationMark = "”", this.SeparatorMark = "|", 
                this.HiddenLineBreak = String.fromCharCode(8626), this.HiddenParagraphMark = String.fromCharCode(182), 
                this.HiddenSpace = String.fromCharCode(183), this.HiddenTabSpace = String.fromCharCode(8594), 
                this.FieldCodeStartRun = "{", this.FieldCodeEndRun = "}", this.FieldResultEndRun = ">", 
                this.LayoutDependentText = "#";
            }
            DEBUG_CONVERTER(str) {
                let result = [];
                const len = str.length;
                for (let i = 0; i < len; i++) {
                    const char = str[i];
                    switch (char) {
                      case this.Bullet:
                        result.push("[Bullet]");
                        break;

                      case this.TabMark:
                        result.push("[TabMark]");
                        break;

                      case this.NonBreakingSpace:
                        result.push("[NonBreakingSpace]");
                        break;

                      case this.Space:
                        result.push("[Space]");
                        break;

                      case this.ParagraphMark:
                        result.push("¶");
                        break;

                      default:
                        result.push(char);
                    }
                }
                return result.join("");
            }
        };
        class ListLevelProperties {
            constructor() {
                this.start = 1, this.format = NumberingFormat.Decimal, this.alignment = ListNumberAlignment.Left, 
                this.convertPreviousLevelNumberingToDecimal = !1, this.separator = RichUtils.specialCharacters.TabMark, 
                this.suppressRestart = !1, this.suppressBulletResize = !1, this.displayFormatString = "{0}.", 
                this.relativeRestartLevel = 0, this.templateCode = 0, this.originalLeftIndent = 0, 
                this.legacy = !1, this.legacySpace = 0, this.legacyIndent = 0;
            }
            calculateHash() {
                return math.MathUtils.somePrimes[0] * this.start ^ math.MathUtils.somePrimes[1] * this.format ^ math.MathUtils.somePrimes[2] * this.alignment ^ math.MathUtils.somePrimes[3] * utils_string.StringUtils.stringHashCode(this.separator) ^ math.MathUtils.somePrimes[4] * (0, 
                common.boolToInt)(this.suppressRestart) ^ math.MathUtils.somePrimes[5] * this.originalLeftIndent ^ math.MathUtils.somePrimes[6] * this.templateCode ^ math.MathUtils.somePrimes[7] * utils_string.StringUtils.stringHashCode(this.displayFormatString);
            }
            getHashCode() {
                return void 0 === this.hash ? this.hash = this.calculateHash() : this.hash;
            }
            equals(obj) {
                return this.alignment === obj.alignment && this.convertPreviousLevelNumberingToDecimal === obj.convertPreviousLevelNumberingToDecimal && this.displayFormatString === obj.displayFormatString && this.format === obj.format && this.legacy === obj.legacy && this.legacyIndent === obj.legacyIndent && this.legacySpace === obj.legacySpace && this.originalLeftIndent === obj.originalLeftIndent && this.relativeRestartLevel === obj.relativeRestartLevel && this.separator === obj.separator && this.start === obj.start && this.suppressBulletResize === obj.suppressBulletResize && this.suppressRestart === obj.suppressRestart && this.templateCode === obj.templateCode;
            }
            copyFrom(obj) {
                this.alignment = obj.alignment, this.convertPreviousLevelNumberingToDecimal = obj.convertPreviousLevelNumberingToDecimal, 
                this.displayFormatString = obj.displayFormatString, this.format = obj.format, this.legacy = obj.legacy, 
                this.legacyIndent = obj.legacyIndent, this.legacySpace = obj.legacySpace, this.originalLeftIndent = obj.originalLeftIndent, 
                this.relativeRestartLevel = obj.relativeRestartLevel, this.separator = obj.separator, 
                this.start = obj.start, this.suppressBulletResize = obj.suppressBulletResize, this.suppressRestart = obj.suppressRestart, 
                this.templateCode = obj.templateCode;
            }
            clone() {
                var clone = new ListLevelProperties;
                return clone.copyFrom(this), clone;
            }
        }
        !function(NumberingFormat) {
            NumberingFormat[NumberingFormat.Decimal = 0] = "Decimal", NumberingFormat[NumberingFormat.AIUEOHiragana = 1] = "AIUEOHiragana", 
            NumberingFormat[NumberingFormat.AIUEOFullWidthHiragana = 2] = "AIUEOFullWidthHiragana", 
            NumberingFormat[NumberingFormat.ArabicAbjad = 3] = "ArabicAbjad", NumberingFormat[NumberingFormat.ArabicAlpha = 4] = "ArabicAlpha", 
            NumberingFormat[NumberingFormat.Bullet = 5] = "Bullet", NumberingFormat[NumberingFormat.CardinalText = 6] = "CardinalText", 
            NumberingFormat[NumberingFormat.Chicago = 7] = "Chicago", NumberingFormat[NumberingFormat.ChineseCounting = 8] = "ChineseCounting", 
            NumberingFormat[NumberingFormat.ChineseCountingThousand = 9] = "ChineseCountingThousand", 
            NumberingFormat[NumberingFormat.ChineseLegalSimplified = 10] = "ChineseLegalSimplified", 
            NumberingFormat[NumberingFormat.Chosung = 11] = "Chosung", NumberingFormat[NumberingFormat.DecimalEnclosedCircle = 12] = "DecimalEnclosedCircle", 
            NumberingFormat[NumberingFormat.DecimalEnclosedCircleChinese = 13] = "DecimalEnclosedCircleChinese", 
            NumberingFormat[NumberingFormat.DecimalEnclosedFullstop = 14] = "DecimalEnclosedFullstop", 
            NumberingFormat[NumberingFormat.DecimalEnclosedParentheses = 15] = "DecimalEnclosedParentheses", 
            NumberingFormat[NumberingFormat.DecimalFullWidth = 16] = "DecimalFullWidth", NumberingFormat[NumberingFormat.DecimalFullWidth2 = 17] = "DecimalFullWidth2", 
            NumberingFormat[NumberingFormat.DecimalHalfWidth = 18] = "DecimalHalfWidth", NumberingFormat[NumberingFormat.DecimalZero = 19] = "DecimalZero", 
            NumberingFormat[NumberingFormat.Ganada = 20] = "Ganada", NumberingFormat[NumberingFormat.Hebrew1 = 21] = "Hebrew1", 
            NumberingFormat[NumberingFormat.Hebrew2 = 22] = "Hebrew2", NumberingFormat[NumberingFormat.Hex = 23] = "Hex", 
            NumberingFormat[NumberingFormat.HindiConsonants = 24] = "HindiConsonants", NumberingFormat[NumberingFormat.HindiDescriptive = 25] = "HindiDescriptive", 
            NumberingFormat[NumberingFormat.HindiNumbers = 26] = "HindiNumbers", NumberingFormat[NumberingFormat.HindiVowels = 27] = "HindiVowels", 
            NumberingFormat[NumberingFormat.IdeographDigital = 28] = "IdeographDigital", NumberingFormat[NumberingFormat.IdeographEnclosedCircle = 29] = "IdeographEnclosedCircle", 
            NumberingFormat[NumberingFormat.IdeographLegalTraditional = 30] = "IdeographLegalTraditional", 
            NumberingFormat[NumberingFormat.IdeographTraditional = 31] = "IdeographTraditional", 
            NumberingFormat[NumberingFormat.IdeographZodiac = 32] = "IdeographZodiac", NumberingFormat[NumberingFormat.IdeographZodiacTraditional = 33] = "IdeographZodiacTraditional", 
            NumberingFormat[NumberingFormat.Iroha = 34] = "Iroha", NumberingFormat[NumberingFormat.IrohaFullWidth = 35] = "IrohaFullWidth", 
            NumberingFormat[NumberingFormat.JapaneseCounting = 36] = "JapaneseCounting", NumberingFormat[NumberingFormat.JapaneseDigitalTenThousand = 37] = "JapaneseDigitalTenThousand", 
            NumberingFormat[NumberingFormat.JapaneseLegal = 38] = "JapaneseLegal", NumberingFormat[NumberingFormat.KoreanCounting = 39] = "KoreanCounting", 
            NumberingFormat[NumberingFormat.KoreanDigital = 40] = "KoreanDigital", NumberingFormat[NumberingFormat.KoreanDigital2 = 41] = "KoreanDigital2", 
            NumberingFormat[NumberingFormat.KoreanLegal = 42] = "KoreanLegal", NumberingFormat[NumberingFormat.LowerLetter = 43] = "LowerLetter", 
            NumberingFormat[NumberingFormat.LowerRoman = 44] = "LowerRoman", NumberingFormat[NumberingFormat.None = 45] = "None", 
            NumberingFormat[NumberingFormat.NumberInDash = 46] = "NumberInDash", NumberingFormat[NumberingFormat.Ordinal = 47] = "Ordinal", 
            NumberingFormat[NumberingFormat.OrdinalText = 48] = "OrdinalText", NumberingFormat[NumberingFormat.RussianLower = 49] = "RussianLower", 
            NumberingFormat[NumberingFormat.RussianUpper = 50] = "RussianUpper", NumberingFormat[NumberingFormat.TaiwaneseCounting = 51] = "TaiwaneseCounting", 
            NumberingFormat[NumberingFormat.TaiwaneseCountingThousand = 52] = "TaiwaneseCountingThousand", 
            NumberingFormat[NumberingFormat.TaiwaneseDigital = 53] = "TaiwaneseDigital", NumberingFormat[NumberingFormat.ThaiDescriptive = 54] = "ThaiDescriptive", 
            NumberingFormat[NumberingFormat.ThaiLetters = 55] = "ThaiLetters", NumberingFormat[NumberingFormat.ThaiNumbers = 56] = "ThaiNumbers", 
            NumberingFormat[NumberingFormat.UpperLetter = 57] = "UpperLetter", NumberingFormat[NumberingFormat.UpperRoman = 58] = "UpperRoman", 
            NumberingFormat[NumberingFormat.VietnameseDescriptive = 59] = "VietnameseDescriptive";
        }(NumberingFormat || (NumberingFormat = {})), function(ListNumberAlignment) {
            ListNumberAlignment[ListNumberAlignment.Left = 0] = "Left", ListNumberAlignment[ListNumberAlignment.Center = 1] = "Center", 
            ListNumberAlignment[ListNumberAlignment.Right = 2] = "Right";
        }(ListNumberAlignment || (ListNumberAlignment = {}));
        class numbering_list_NumberingListBase {
            constructor(documentModel, levelCount) {
                this.innerId = -1, this.levels = [], this.deleted = !1, this.documentModel = documentModel, 
                this.initLevels(levelCount);
            }
            getId() {
                return -1 === this.innerId && (this.innerId = this.generateNewId()), this.innerId;
            }
            resetId() {
                this.innerId = -1;
            }
            initLevels(levelCount) {
                for (var i = 0; i < levelCount; i++) {
                    var listLevel = this.createLevel(i);
                    this.levels.push(listLevel);
                }
            }
            getLevelType(listLevelIndex) {
                return this.isBulletListLevel(this.levels[listLevelIndex]) ? numbering_list_NumberingType.Bullet : this.isHybridList() ? numbering_list_NumberingType.Simple : numbering_list_NumberingType.MultiLevel;
            }
            getListType() {
                return this.isHybridList() ? this.isBulletListLevel(this.levels[0]) ? numbering_list_NumberingType.Bullet : numbering_list_NumberingType.Simple : numbering_list_NumberingType.MultiLevel;
            }
            equals(obj) {
                for (var level, i = 0; level = obj.levels[i]; i++) if (!level.equals(this.levels[i])) return !1;
                return !0;
            }
            externallyEquals(obj) {
                if (this.getListType() !== obj.getListType()) return !1;
                for (var depth = this.getListType() == numbering_list_NumberingType.MultiLevel ? numbering_list_NumberingListBase.depth : 1, i = 0; i < depth; i++) if (!this.levels[i].externallyEquals(obj.levels[i])) return !1;
                return !0;
            }
            copyFrom(obj) {
                this.innerId = obj.innerId, this.deleted = obj.deleted, this.copyLevelsFrom(obj.levels);
            }
            isHybridList() {
                for (var listLevel, i = 0; listLevel = this.levels[i]; i++) if (0 !== listLevel.getListLevelProperties().templateCode) return !0;
                return !1;
            }
            isBulletListLevel(level) {
                return 1 === level.getListLevelProperties().displayFormatString.length;
            }
        }
        numbering_list_NumberingListBase.depth = 3, numbering_list_NumberingListBase.NoNumberingListIndex = -2, 
        numbering_list_NumberingListBase.NumberingListNotSettedIndex = -1;
        class AbstractNumberingList extends numbering_list_NumberingListBase {
            constructor(documentModel) {
                super(documentModel, 9);
            }
            generateNewId() {
                return this.documentModel.abstractNumberingListsIdProvider.getNextId();
            }
            createLevel(_index) {
                var characterProperties = MaskedCharacterProperties.createDefault(this.documentModel), paragraphProperties = MaskedParagraphProperties.createDefault(this.documentModel);
                return new ListLevel(this.documentModel, characterProperties, paragraphProperties, new ListLevelProperties);
            }
            copyLevelsFrom(levels) {
                for (var level, i = 0; level = this.levels[i]; i++) level.copyFrom(levels[i]);
            }
            clone(model) {
                const result = new AbstractNumberingList(model);
                return result.copyFrom(this), result;
            }
        }
        class NumberingList extends numbering_list_NumberingListBase {
            constructor(documentModel, abstractNumberingListIndex) {
                if (super(documentModel, 9), abstractNumberingListIndex < 0 || abstractNumberingListIndex >= documentModel.abstractNumberingLists.length) throw new Error("abstractNumberingListIndex should be positive and less than length of the abstractNumberingLists array");
                this.abstractNumberingListIndex = abstractNumberingListIndex;
            }
            getAbstractNumberingList() {
                return this.documentModel.abstractNumberingLists[this.abstractNumberingListIndex];
            }
            generateNewId() {
                return this.documentModel.numberingListsIdProvider.getNextId();
            }
            createLevel(index) {
                return new NumberingListReferenceLevel(this, index);
            }
            copyLevelsFrom(levels) {
                for (var i = 0; i < this.levels.length; i++) {
                    var sourceLevel = levels[i];
                    this.levels[i].constructor !== sourceLevel.constructor && (this.levels[i] = sourceLevel instanceof OverrideListLevel ? new OverrideListLevel(this.documentModel, sourceLevel.getCharacterProperties(), sourceLevel.getParagraphProperties(), sourceLevel.getListLevelProperties()) : new NumberingListReferenceLevel(this, i)), 
                    this.levels[i].copyFrom(sourceLevel);
                }
            }
            clone(model) {
                const result = new NumberingList(model, this.abstractNumberingListIndex);
                return result.copyFrom(this), result;
            }
        }
        !function(NumberingType) {
            NumberingType[NumberingType.MultiLevel = 0] = "MultiLevel", NumberingType[NumberingType.Simple = 1] = "Simple", 
            NumberingType[NumberingType.Bullet = 2] = "Bullet";
        }(numbering_list_NumberingType || (numbering_list_NumberingType = {}));
        class PropertiesBundle {
            constructor(properties, style) {
                this.props = properties, this.style = style;
            }
        }
        class ParagraphListInfo {
            constructor(numbericListIndex, listLevelIndex) {
                this.numberingListIndex = numbericListIndex, this.listLevelIndex = listLevelIndex;
            }
            static get default() {
                return new ParagraphListInfo(NumberingList.NumberingListNotSettedIndex, -1);
            }
            clone() {
                return new ParagraphListInfo(this.numberingListIndex, this.listLevelIndex);
            }
        }
        class MaskedCharacterPropertiesBundle extends PropertiesBundle {}
        class MaskedParagraphPropertiesBundle extends PropertiesBundle {}
        class MaskedParagraphPropertiesBundleFull extends PropertiesBundle {
            constructor(properties, style, listInfo, tabs) {
                super(properties, style), this.listInfo = listInfo, this.tabs = tabs;
            }
            static get notSetted() {
                return new MaskedParagraphPropertiesBundleFull(void 0, void 0, void 0, void 0);
            }
        }
        var dom = __webpack_require__(6907), utils_fonts = __webpack_require__(4004), boundary = __webpack_require__(7093);
        class FontFaceDescriptors {
            constructor() {
                this.style = "normal", this.weight = "normal", this.stretch = "normal", this.unicodeRange = "U+0-10FFFF", 
                this.variant = "normal", this.featureSettings = "normal", this.variationSettings = "normal", 
                this.display = "auto", this._cacheKey = null;
            }
            static get getDefaultUnicodeRange() {
                return new boundary.e(0, 1114111);
            }
            msWordItalic() {
                return /^\s*(italic|oblique(\s+\w*)?)\s*$/i.test(this.style);
            }
            msWordBold() {
                if ("number" == typeof this.weight) return this.weight >= 550;
                const numVal = parseInt(this.weight);
                return isNaN(numVal) ? /^\s*(bold|bolder)\s*$/i.test(this.weight) : numVal >= 550;
            }
            get cacheKey() {
                return this._cacheKey || (this._cacheKey = [ this.style.toString() + this.weight.toString() + this.stretch.toString() + this.unicodeRange.toString() + this.variant.toString() + this.featureSettings.toString() + this.variationSettings.toString() + this.display.toString() ].join("/")), 
                this._cacheKey;
            }
            parseUnicodeRanges() {
                const ranges = this.unicodeRange ? utils_list.ListUtils.reducedMap(this.unicodeRange.split(","), (range => {
                    const wildcardMatch = range.match(/U\+(\w*)(\?+)/i);
                    let start = NaN, end = NaN;
                    if (wildcardMatch) {
                        const lenOfWildcard = wildcardMatch[2].length;
                        start = parseInt(wildcardMatch[1] + utils_string.StringUtils.repeat("0", lenOfWildcard), 16), 
                        end = parseInt(wildcardMatch[1] + utils_string.StringUtils.repeat("F", lenOfWildcard), 16);
                    } else {
                        const match = range.match(/U\+(\w+)-?(\w*)/i);
                        match && (start = parseInt(match[1], 16), end = match[2].length ? parseInt(match[2], 16) : start);
                    }
                    return isNaN(start) || isNaN(end) ? null : new boundary.e(start, end + 1);
                })) : [];
                return ranges.length ? ranges.sort() : [ FontFaceDescriptors.getDefaultUnicodeRange ];
            }
            static create(obj) {
                const result = new FontFaceDescriptors;
                return obj ? (null !== obj.style && void 0 !== obj.style && (result.style = obj.style), 
                null !== obj.weight && void 0 !== obj.weight && (result.weight = obj.weight), null !== obj.stretch && void 0 !== obj.stretch && (result.stretch = obj.stretch), 
                null !== obj.unicodeRange && void 0 !== obj.unicodeRange && (result.unicodeRange = obj.unicodeRange), 
                null !== obj.variant && void 0 !== obj.variant && (result.variant = obj.variant), 
                null !== obj.featureSettings && void 0 !== obj.featureSettings && (result.featureSettings = obj.featureSettings), 
                null !== obj.variationSettings && void 0 !== obj.variationSettings && (result.variationSettings = obj.variationSettings), 
                null !== obj.display && void 0 !== obj.display && (result.display = obj.display), 
                result) : result;
            }
            clone() {
                const result = new FontFaceDescriptors;
                return result.style = this.style, result.weight = this.weight, result.stretch = this.stretch, 
                result.unicodeRange = this.unicodeRange, result.variant = this.variant, result.featureSettings = this.featureSettings, 
                result.variationSettings = this.variationSettings, result.display = this.display, 
                result;
            }
        }
        const FONT_NAME_TO_FILE_NAME = {
            "Angsana New": "angsana.ttc",
            "Angsana Newb": "angsana.ttc",
            "Angsana Newi": "angsana.ttc",
            "Angsana Newz": "angsana.ttc",
            Arial: "arial.ttf",
            Arialb: "arialbd.ttf",
            Ariali: "ariali.ttf",
            Arialz: "arialbi.ttf",
            "Arial Unicode MS": "Arialuni.ttf",
            "Arial Unicode MSb": "Arialuni.ttf",
            "Arial Unicode MSi": "Arialuni.ttf",
            "Arial Unicode MSz": "Arialuni.ttf",
            "Arial Black": "ariblk.ttf",
            "Arial Blackb": "ariblk.ttf",
            "Arial Blacki": "AriBlkIt.ttf",
            "Arial Blackz": "AriBlkIt.ttf",
            Batang: "batang.ttc",
            Batangb: "batang.ttc",
            Batangi: "batang.ttc",
            Batangz: "batang.ttc",
            "Book Antiqua": "BKANT",
            "Book Antiquab": "ANTQUAB",
            "Book Antiquai": "ANTQUAI",
            "Book Antiquaz": "ANTQUABI",
            "Bookman Old Style": "bookos.ttf",
            "Bookman Old Styleb": "bookos.ttf",
            "Bookman Old Stylei": "bookos.ttf",
            "Bookman Old Stylez": "bookos.ttf",
            Calibri: "Calibri.ttf",
            Calibrib: "Calibrib.ttf",
            Calibrii: "Calibrii.ttf",
            Calibriz: "Calibriz.ttf",
            "Calibri Light": "Calibril.ttf",
            "Calibri Lightb": "Calibril.ttf",
            "Calibri Lighti": "Calibrili.ttf",
            "Calibri Lightz": "Calibrili.ttf",
            Cambria: "cambria.ttc",
            Cambriab: "cambriab.ttf",
            Cambriai: "cambriai.ttf",
            Cambriaz: "cambriaz.ttf",
            Candara: "Candara.ttf",
            Candarab: "Candarab.ttf",
            Candarai: "Candarai.ttf",
            Candaraz: "Candaraz.ttf",
            Century: "CENTURY.ttf",
            Centuryb: "CENTURY.ttf",
            Centuryi: "CENTURY.ttf",
            Centuryz: "CENTURY.ttf",
            "Century Gothic": "gothic.ttf",
            "Century Gothicb": "gothic.ttf",
            "Century Gothici": "gothic.ttf",
            "Century Gothicz": "gothic.ttf",
            "CC-Gothic": "gothic.ttf",
            "CC-Gothicb": "gothic.ttf",
            "CC-Gothici": "gothic.ttf",
            "CC-Gothicz": "gothic.ttf",
            "Century Schoolbook": "censcbk.ttf",
            "Century Schoolbookb": "censcbk.ttf",
            "Century Schoolbooki": "censcbk.ttf",
            "Century Schoolbookz": "censcbk.ttf",
            "Comic Sans MS": "comic.ttf",
            "Comic Sans MSb": "comicbd.ttf",
            "Comic Sans MSi": "comici.ttf",
            "Comic Sans MSz": "comicz.ttf",
            Consolas: "Consola.ttf",
            Consolasb: "Consolab.ttf",
            Consolasi: "Consolai.ttf",
            Consolasz: "Consolaz.ttf",
            Constantia: "constan.ttf",
            Constantiab: "constanb.ttf",
            Constantiai: "constani.ttf",
            Constantiaz: "constanz.ttf",
            Corbel: "corbel.ttf",
            Corbelb: "corbelb.ttf",
            Corbeli: "corbeli.ttf",
            Corbelz: "corbelz.ttf",
            "Cordia New": "cordia.ttf",
            "Cordia Newb": "cordiab.ttf",
            "Cordia Newi": "cordiai.ttf",
            "Cordia Newz": "cordiaz.ttf",
            "Courier New": "cour.ttf",
            "Courier Newb": "courbd.ttf",
            "Courier Newi": "courbi.ttf",
            "Courier Newz": "couri.ttf",
            Courier: "cour.ttf",
            Courierb: "courbd.ttf",
            Courieri: "courbi.ttf",
            Courierz: "couri.ttf",
            DaunPenh: "daunpenh.ttf",
            DaunPenhb: "daunpenh.ttf",
            DaunPenhi: "daunpenh.ttf",
            DaunPenhz: "daunpenh.ttf",
            Dotum: "gulim.ttc",
            Dotumb: "gulim.ttc",
            Dotumi: "gulim.ttc",
            Dotumz: "gulim.ttc",
            FangSong: "simfang.ttf",
            FangSongb: "simfang.ttf",
            FangSongi: "simfang.ttf",
            FangSongz: "simfang.ttf",
            "Franklin Gothic Book": "frabk.ttf",
            "Franklin Gothic Bookb": "frabk.ttf",
            "Franklin Gothic Booki": "frabk.ttf",
            "Franklin Gothic Bookz": "frabk.ttf",
            "Franklin Gothic Medium": "frabk.ttf",
            "Franklin Gothic Mediumb": "frabk.ttf",
            "Franklin Gothic Mediumi": "frabk.ttf",
            "Franklin Gothic Mediumz": "frabk.ttf",
            Garamond: "GARA.TTF",
            Garamondb: "GARA.TTF",
            Garamondi: "GARA.TTF",
            Garamondz: "GARA.TTF",
            Gautami: "gautami.ttf",
            Gautamib: "Gautamib.ttf",
            Gautamii: "gautami.ttf",
            Gautamiz: "Gautamib.ttf",
            Georgia: "georgia.ttf",
            Georgiab: "georgiab.ttf",
            Georgiai: "georgiai.ttf",
            Georgiaz: "georgiaz.ttf",
            "Gill Sans MT": "gil_____.ttf",
            "Gill Sans MTb": "gil_____.ttf",
            "Gill Sans MTi": "gil_____.ttf",
            "Gill Sans MTz": "gil_____.ttf",
            Gulim: "gulim.ttc",
            Gulimb: "gulim.ttc",
            Gulimi: "gulim.ttc",
            Gulimz: "gulim.ttc",
            GungSuh: "batang.ttc",
            GungSuhb: "batang.ttc",
            GungSuhi: "batang.ttc",
            GungSuhz: "batang.ttc",
            Impact: "impact.ttf",
            Impactb: "impact.ttf",
            Impacti: "impact.ttf",
            Impactz: "impact.ttf",
            "Iskoola Pota": "iskpota.ttf",
            "Iskoola Potab": "iskpotab.ttf",
            "Iskoola Potai": "iskpota.ttf",
            "Iskoola Potaz": "iskpotab.ttf",
            KaiTi: "simkai.ttf",
            KaiTib: "simkai.ttf",
            KaiTii: "simkai.ttf",
            KaiTiz: "simkai.ttf",
            Kalinga: "kalinga.ttf",
            Kalingab: "kalingab.ttf",
            Kalingai: "kalinga.ttf",
            Kalingaz: "kalingab.ttf",
            Kartika: "kartika.ttf",
            Kartikab: "kartikab.ttf",
            Kartikai: "kartika.ttf",
            Kartikaz: "kartikab.ttf",
            Latha: "latha.ttf",
            Lathab: "Lathab.ttf",
            Lathai: "latha.ttf",
            Lathaz: "Lathab.ttf",
            "Lucida Console": "lucon.ttf",
            "Lucida Consoleb": "lucon.ttf",
            "Lucida Consolei": "lucon.ttf",
            "Lucida Consolez": "lucon.ttf",
            "Lucida Sans": "lsansdi.ttf",
            "Lucida Sansb": "lsansdi.ttf",
            "Lucida Sansi": "lsansdi.ttf",
            "Lucida Sansz": "lsansdi.ttf",
            "Lucida Sans Unicode": "l_10646.ttf",
            "Lucida Sans Unicodeb": "l_10646.ttf",
            "Lucida Sans Unicodei": "l_10646.ttf",
            "Lucida Sans Unicodez": "l_10646.ttf",
            "Malgun Gothic": "malgun.ttf",
            "Malgun Gothicb": "malgunbd.ttf",
            "Malgun Gothici": "malgun.ttf",
            "Malgun Gothicz": "malgunbd.ttf",
            Mangal: "Mangal.ttf",
            Mangalb: "MangalB.ttf",
            Mangali: "Mangal.ttf",
            Mangalz: "MangalB.ttf",
            Meiryo: "meiryo_00.ttf",
            Meiryob: "meiryob_00.ttf",
            Meiryoi: "meiryob_01.ttf",
            Meiryoz: "meiryo_01.ttf",
            "Microsoft JhengHei": "msjh_00.ttf",
            "Microsoft JhengHeib": "msjhbd_00.ttf",
            "Microsoft JhengHeii": "msjh_00.ttf",
            "Microsoft JhengHeiz": "msjhbd_00.ttf",
            "Microsoft YaHei": "msyh_00.ttf",
            "Microsoft YaHeib": "msyhbd_00.ttf",
            "Microsoft YaHeii": "msyh_00.ttf",
            "Microsoft YaHeiz": "msyhbd_00.ttf",
            MingLiU: "mingliu_00.ttf",
            MingLiUb: "mingliub_00.ttf",
            MingLiUi: "mingliu_00.ttf",
            MingLiUz: "mingliub_00.ttf",
            MingLiU_HKSCS: "mingliu_02.ttf",
            MingLiU_HKSCSb: "mingliub_02.ttf",
            MingLiU_HKSCSi: "mingliu_02.ttf",
            MingLiU_HKSCSz: "mingliub_02.ttf",
            "MS Gothic": "msgothic.ttc",
            "MS Gothicb": "msgothic.ttc",
            "MS Gothici": "msgothic.ttc",
            "MS Gothicz": "msgothic.ttc",
            "MS Mincho": "msmincho.ttc",
            "MS Minchob": "msmincho.ttc",
            "MS Minchoi": "msmincho.ttc",
            "MS Minchoz": "msmincho.ttc",
            "MS PGothic": "msgothic_02.ttf",
            "MS PGothicb": "msgothic_02.ttfc",
            "MS PGothici": "msgothic_02.ttf",
            "MS PGothicz": "msgothic_02.ttf",
            "MS PMincho": "msmincho_01.ttf",
            "MS PMinchob": "msmincho_01.ttfc",
            "MS PMinchoi": "msmincho_01.ttf",
            "MS PMinchoz": "msmincho_01.ttf",
            Nyala: "nyala.ttf",
            Nyalab: "nyala.ttf",
            Nyalai: "nyala.ttf",
            Nyalaz: "nyala.ttf",
            "Palatino Linotype": "pala.ttf",
            "Palatino Linotypeb": "palab.ttf",
            "Palatino Linotypei": "palai.ttf",
            "Palatino Linotypez": "palabi.ttf",
            PMingLiU: "mingliu_01.ttf",
            PMingLiUb: "mingliub_01.ttf",
            PMingLiUi: "mingliu_01.ttf",
            PMingLiUz: "mingliub_01.ttf",
            "PMingLiU-ExtB": "mingliub_02.ttf",
            "PMingLiU-ExtBb": "mingliub_02.ttf",
            "PMingLiU-ExtBi": "mingliub_02.ttf",
            "PMingLiU-ExtBz": "mingliub_02.ttf",
            Raavi: "raavi.ttf",
            Raavib: "raavib.ttf",
            Raavii: "raavi.ttf",
            Raaviz: "raavib.ttf",
            Rockwell: "rock.ttf",
            Rockwellb: "rockb.ttf",
            Rockwelli: "rocki.ttf",
            Rockwellz: "rockbi.ttf",
            "Segoe UI": "segoeui.ttf",
            "Segoe UIb": "segoeuib.ttf",
            "Segoe UIi": "segoeuii.ttf",
            "Segoe UIz": "segoeuiz.ttf",
            Shruti: "shruti.ttf",
            Shrutib: "shrutib.ttf",
            Shrutii: "shruti.ttf",
            Shrutiz: "shrutib.ttf",
            SimHei: "simhei.ttf",
            SimHeib: "simhei.ttf",
            SimHeii: "simhei.ttf",
            SimHeiz: "simhei.ttf",
            SimSun: "simsun_00.ttf",
            SimSunb: "simsunb.ttf",
            SimSuni: "simsun_00.ttf",
            SimSunz: "simsunb.ttf",
            Sylfaen: "sylfaen.ttf",
            Sylfaenb: "sylfaen.ttf",
            Sylfaeni: "sylfaen.ttf",
            Sylfaenz: "sylfaen.ttf",
            Tahoma: "tahoma.ttf",
            Tahomab: "tahomabd.ttf",
            Tahomai: "tahoma.ttf",
            Tahomaz: "tahomabd.ttf",
            Times: "times.ttf",
            Timesb: "timesbd.ttf",
            Timesi: "timesi.ttf",
            Timesz: "timesbi.ttf",
            "Times New Roman": "times.ttf",
            "Times New Romanb": "timesbd.ttf",
            "Times New Romani": "timesi.ttf",
            "Times New Romanz": "timesbi.ttf",
            "Trebuchet MS": "trebuc.ttf",
            "Trebuchet MSb": "trebucbd.ttf",
            "Trebuchet MSi": "trebucit.ttf",
            "Trebuchet MSz": "trebucbi.ttf",
            Tunga: "tunga.ttf",
            Tungab: "tungab.ttf",
            Tungai: "tunga.ttf",
            Tungaz: "tungab.ttf",
            "TW Cen MT": "tcm_____.ttf",
            "TW Cen MTb": "tcm_____.ttf",
            "TW Cen MTi": "tcm_____.ttf",
            "TW Cen MTz": "tcm_____.ttf",
            Verdana: "verdana.ttf",
            Verdanab: "verdanab.ttf",
            Verdanai: "verdanai.ttf",
            Verdanaz: "verdanaz.ttf",
            Vrinda: "vrinda.ttf",
            Vrindab: "vrindab.ttf",
            Vrindai: "vrinda.ttf",
            Vrindaz: "vrindab.ttf",
            Symbol: "symbol.ttf",
            Symbolb: "symbol.ttf",
            Symboli: "symbol.ttf",
            Symbolz: "symbol.ttf",
            Webdings: "Webdings.ttf",
            Webdingsb: "Webdings.ttf",
            Webdingsi: "Webdings.ttf",
            Webdingsz: "Webdings.ttf",
            Wingdings: "Wingding.ttf",
            Wingdingsb: "Wingding.ttf",
            Wingdingsi: "Wingding.ttf",
            Wingdingsz: "Wingding.ttf",
            "Microsoft Sans Serif": "Micross.ttf",
            "Microsoft Sans Serifb": "Micross.ttf",
            "Microsoft Sans Serifi": "Micross.ttf",
            "Microsoft Sans Serifz": "Micross.ttf",
            "Microsoft JhengHei Light": "Msjhl.ttf",
            "Microsoft JhengHei Lightb": "Msjhl.ttf",
            "Microsoft JhengHei Lighti": "Msjhl.ttf",
            "Microsoft JhengHei Lightz": "Msjhl.ttf"
        };
        var FontLoadStatus, ControlFontType, SchemeColorValues, SystemColorValues, XlFontSchemeStyles, StyleMatrixElementType;
        !function(FontLoadStatus) {
            FontLoadStatus[FontLoadStatus.Unloaded = 0] = "Unloaded", FontLoadStatus[FontLoadStatus.Loading = 1] = "Loading", 
            FontLoadStatus[FontLoadStatus.Loaded = 2] = "Loaded", FontLoadStatus[FontLoadStatus.Error = 3] = "Error";
        }(FontLoadStatus || (FontLoadStatus = {}));
        class ControlFont {
            constructor(fontFamily, descriptors, key) {
                this.isFontCollection = !1, this.status = FontLoadStatus.Unloaded, this.sourceUrls = [], 
                this._unicodeRanges = null, this.fontFamily = fontFamily, this.descriptors = descriptors, 
                this.cacheKey = key || [ this.fontFamily, this.descriptors.cacheKey ].join("/");
            }
            get loaded() {
                return this.status == FontLoadStatus.Loaded;
            }
            get unicodeRanges() {
                return this._unicodeRanges || (this._unicodeRanges = this.descriptors.parseUnicodeRanges()), 
                this._unicodeRanges;
            }
            get controlFontType() {
                const controlFontType = new class_flag.Flag;
                return controlFontType.set(ControlFontType.Bold, this.descriptors.msWordBold()), 
                controlFontType.set(ControlFontType.Italic, this.descriptors.msWordItalic()), controlFontType.getValue();
            }
            applySource(data, callback) {
                this.data || (this.data = data), (0, utils_fonts.lX)() ? (0, utils_fonts.mx)(this.fontFamily, data, this.descriptors, callback) : setTimeout(callback, 0);
            }
            clone() {
                const obj = new ControlFont(this.fontFamily, this.descriptors.clone(), this.cacheKey);
                return obj.status = this.status, obj.data = this.data, obj._unicodeRanges = this._unicodeRanges, 
                obj._unicodeRanges = this._unicodeRanges, obj.sourceUrls = utils_list.ListUtils.shallowCopy(this.sourceUrls), 
                obj.isFontCollection = this.isFontCollection, obj;
            }
            allSourceUrls(baseUrl) {
                return utils_list.ListUtils.addListOnTail(utils_list.ListUtils.shallowCopy(this.sourceUrls), this.defaultUrls(baseUrl));
            }
            defaultUrls(baseUrl) {
                const bold = this.descriptors.msWordBold(), italic = this.descriptors.msWordItalic(), fileName = bold && italic ? `${this.fontFamily}z` : `${this.fontFamily}${bold ? "b" : ""}${italic ? "i" : ""}`, resultUrls = [];
                let unicuePath = null;
                const fontNameWithExt = FONT_NAME_TO_FILE_NAME[fileName];
                fontNameWithExt && (unicuePath = baseUrl + fontNameWithExt, resultUrls.push(unicuePath));
                const addPath = extension => {
                    const p = `${baseUrl}${fileName}.${extension}`;
                    p !== unicuePath && resultUrls.push(p);
                };
                return addPath("woff"), addPath("ttf"), addPath("ttc"), resultUrls;
            }
            static createDefault(fontFamily, flag) {
                const desc = new FontFaceDescriptors;
                return flag.get(ControlFontType.Bold) && (desc.weight = "bold"), flag.get(ControlFontType.Italic) && (desc.style = "italic"), 
                new ControlFont(fontFamily, desc);
            }
        }
        !function(ControlFontType) {
            ControlFontType[ControlFontType.Regular = 0] = "Regular", ControlFontType[ControlFontType.Bold = 1] = "Bold", 
            ControlFontType[ControlFontType.Italic = 2] = "Italic", ControlFontType[ControlFontType.BoldItalic = 3] = "BoldItalic";
        }(ControlFontType || (ControlFontType = {}));
        class FontInfo {
            constructor(name) {
                this.controlFontMap = {
                    [ControlFontType.Regular]: null,
                    [ControlFontType.Bold]: null,
                    [ControlFontType.Italic]: null,
                    [ControlFontType.BoldItalic]: null
                }, this.name = name, this.cssString = name, this.isLoad = !0;
            }
            ensureAllControlFontsAssigned(controlFontsCache) {
                const fontFamily = this.getFontFamilies()[0], ensureFontAssigned = type => {
                    if (!this.controlFontMap[type]) {
                        let controlFont = controlFontsCache.findSimularFontByType(fontFamily, type);
                        controlFont || (controlFont = controlFontsCache.addFont(ControlFont.createDefault(fontFamily, new class_flag.Flag(type)))), 
                        this.controlFontMap[type] = controlFont.cacheKey;
                    }
                };
                ensureFontAssigned(ControlFontType.Regular), ensureFontAssigned(ControlFontType.Bold), 
                ensureFontAssigned(ControlFontType.Italic), ensureFontAssigned(ControlFontType.BoldItalic);
            }
            getFontFamilies() {
                return dom.DomUtils.getFontFamiliesFromCssString(this.cssString);
            }
            static calculateHashByName(name) {
                return utils_string.StringUtils.stringHashCode(name.toLowerCase());
            }
            calculateHash() {
                return FontInfo.calculateHashByName(this.name);
            }
            getHashCode() {
                return void 0 === this.hash ? this.hash = this.calculateHash() : this.hash;
            }
            copyFrom(obj) {
                this.name = obj.name, this.scriptMultiplier = obj.scriptMultiplier, this.canBeSet = obj.canBeSet, 
                this.cssString = obj.cssString, this.subScriptOffset = obj.subScriptOffset, this.controlFontMap = number.j.shallowCopy(obj.controlFontMap);
            }
            equals(obj) {
                return obj && this.name == obj.name && this.scriptMultiplier == obj.scriptMultiplier;
            }
            static equalsBinary(fontInfoA, fontInfoB) {
                return fontInfoA && fontInfoB && fontInfoA.name == fontInfoB.name && fontInfoA.scriptMultiplier == fontInfoB.scriptMultiplier;
            }
            clone() {
                var obj = new FontInfo(null);
                return obj.copyFrom(this), obj;
            }
            getBaseLine() {
                return void 0 === this.baseLine && this.measure(), this.baseLine;
            }
            getHeightFactor() {
                return void 0 === this.heightFactor && this.measure(), this.heightFactor;
            }
            reset() {
                this.baseLine = void 0, this.heightFactor = void 0;
            }
            getAscent(boxHeight) {
                return this.getBaseLine() * boxHeight;
            }
            getDescent(boxHeight) {
                return boxHeight - this.getAscent(boxHeight);
            }
            measure() {
                const info = this.measurer.getFontMeasurerInfo(this);
                this.baseLine = info.baseLine, this.heightFactor = info.heightFactor;
            }
        }
        class ControlFontsCache {
            constructor() {
                this.cache = {}, this.list = [];
            }
            addFont(info) {
                const oldFont = this.cache[info.cacheKey];
                return oldFont || (this.cache[info.cacheKey] = info, this.list.push(info), info);
            }
            getFontByKey(cacheKey) {
                return this.cache[cacheKey];
            }
            getFont(info) {
                return this.cache[info.cacheKey];
            }
            deleteFont(info) {
                this.cache[info.cacheKey] && (delete this.cache[info.cacheKey], utils_list.ListUtils.removeBy(this.list, (el => el.cacheKey == info.cacheKey)));
            }
            clone() {
                const result = new ControlFontsCache;
                return result.list = utils_list.ListUtils.deepCopy(this.list), result.cache = string.StringMapUtils.deepCopy(this.cache), 
                result;
            }
            findSimularFontByType(fontFamily, type) {
                const flag = new class_flag.Flag(type);
                return utils_list.ListUtils.elementBy(this.list, (controlFont => controlFont.fontFamily == fontFamily && controlFont.descriptors.msWordBold() == flag.get(ControlFontType.Bold) && controlFont.descriptors.msWordItalic() == flag.get(ControlFontType.Italic)));
            }
        }
        class CharacterPropertiesCache extends HashBasedCache {
            static getRareCharProperty(fontMeasurer) {
                if (!CharacterPropertiesCache._rareCharProperty) {
                    const prop = new CharacterProperties;
                    prop.fontInfo = new FontInfo("Calibri"), prop.fontInfo.measurer = fontMeasurer, 
                    prop.fontSize = 200, CharacterPropertiesCache._rareCharProperty = prop;
                }
                return CharacterPropertiesCache._rareCharProperty;
            }
            resetSizes() {
                this.forEach((prop => {
                    prop.clearSizes(), prop.fontInfo && prop.fontInfo.reset();
                }));
            }
            copyFrom(obj) {
                super.copyFrom(obj);
            }
            clone() {
                const result = new CharacterPropertiesCache;
                return result.copyFrom(this), result;
            }
        }
        class DXSystemColors {}
        DXSystemColors.control = utils_color.i.fromArgbNumber(255, 240, 240, 240), DXSystemColors.controlDark = utils_color.i.fromArgbNumber(255, 160, 160, 160), 
        DXSystemColors.window = utils_color.i.fromArgbNumber(255, 255, 255, 255), DXSystemColors.activeBorder = utils_color.i.fromArgbNumber(255, 180, 180, 180), 
        DXSystemColors.activeCaption = utils_color.i.fromArgbNumber(255, 153, 180, 209), 
        DXSystemColors.activeCaptionText = utils_color.i.fromArgbNumber(255, 0, 0, 0), DXSystemColors.appWorkspace = utils_color.i.fromArgbNumber(255, 171, 171, 171), 
        DXSystemColors.controlDarkDark = utils_color.i.fromArgbNumber(255, 105, 105, 105), 
        DXSystemColors.controlLight = utils_color.i.fromArgbNumber(255, 227, 227, 227), 
        DXSystemColors.controlLightLight = utils_color.i.fromArgbNumber(255, 255, 255, 255), 
        DXSystemColors.controlText = utils_color.i.fromArgbNumber(255, 0, 0, 0), DXSystemColors.desktop = utils_color.i.fromArgbNumber(255, 0, 0, 0), 
        DXSystemColors.grayText = utils_color.i.fromArgbNumber(255, 109, 109, 109), DXSystemColors.highlight = utils_color.i.fromArgbNumber(255, 0, 120, 215), 
        DXSystemColors.highlightText = utils_color.i.fromArgbNumber(255, 255, 255, 255), 
        DXSystemColors.hotTrack = utils_color.i.fromArgbNumber(255, 0, 102, 204), DXSystemColors.inactiveBorder = utils_color.i.fromArgbNumber(255, 244, 247, 252), 
        DXSystemColors.inactiveCaption = utils_color.i.fromArgbNumber(255, 191, 205, 219), 
        DXSystemColors.inactiveCaptionText = utils_color.i.fromArgbNumber(255, 0, 0, 0), 
        DXSystemColors.info = utils_color.i.fromArgbNumber(255, 255, 255, 225), DXSystemColors.infoText = utils_color.i.fromArgbNumber(255, 0, 0, 0), 
        DXSystemColors.menu = utils_color.i.fromArgbNumber(255, 240, 240, 240), DXSystemColors.menuText = utils_color.i.fromArgbNumber(255, 0, 0, 0), 
        DXSystemColors.scrollBar = utils_color.i.fromArgbNumber(255, 200, 200, 200), DXSystemColors.windowFrame = utils_color.i.fromArgbNumber(255, 100, 100, 100), 
        DXSystemColors.windowText = utils_color.i.fromArgbNumber(255, 0, 0, 0), DXSystemColors.gradientActiveCaption = utils_color.i.fromArgbNumber(255, 185, 209, 234), 
        DXSystemColors.gradientInactiveCaption = utils_color.i.fromArgbNumber(255, 215, 228, 242), 
        DXSystemColors.menuBar = utils_color.i.fromArgbNumber(255, 240, 240, 240), DXSystemColors.menuHighlight = utils_color.i.fromArgbNumber(255, 51, 153, 255);
        class ScRGBColor {
            constructor(scR, scG, scB) {
                this._scR = scR, this._scG = scG, this._scB = scB;
            }
            get scR() {
                return this._scR;
            }
            set scR(value) {
                this._scR = this.getValidValue(value);
            }
            get scG() {
                return this._scG;
            }
            set scG(value) {
                this._scG = this.getValidValue(value);
            }
            get scB() {
                return this._scB;
            }
            set scB(value) {
                this._scB = this.getValidValue(value);
            }
            calculateHash() {
                return math.MathUtils.somePrimes[0] * this._scR ^ math.MathUtils.somePrimes[1] * this._scG ^ math.MathUtils.somePrimes[2] * this._scB;
            }
            toRgb() {
                let r = 1 * this._scR / DrawingValueConstants.ThousandthOfPercentage, g = 1 * this._scG / DrawingValueConstants.ThousandthOfPercentage, b = 1 * this._scB / DrawingValueConstants.ThousandthOfPercentage;
                const a = .055;
                return r = r <= .0031308 ? 12.92 * r : (1 + a) * Math.pow(r, 1 / 2.4) - a, g = g <= .0031308 ? 12.92 * g : (1 + a) * Math.pow(g, 1 / 2.4) - a, 
                b = b <= .0031308 ? 12.92 * b : (1 + a) * Math.pow(b, 1 / 2.4) - a, r *= 255, g *= 255, 
                b *= 255, DXColor.fromRgb(Math.round(r), Math.round(g), Math.round(b));
            }
            getValidValue(value) {
                return value < 0 ? 0 : value;
            }
            equals(obj) {
                return obj && this._scR == obj._scR && this._scG == obj._scG && this._scB == obj._scB;
            }
        }
        ScRGBColor.defaultValue = new ScRGBColor(0, 0, 0), function(SchemeColorValues) {
            SchemeColorValues[SchemeColorValues.Accent1 = 0] = "Accent1", SchemeColorValues[SchemeColorValues.Accent2 = 1] = "Accent2", 
            SchemeColorValues[SchemeColorValues.Accent3 = 2] = "Accent3", SchemeColorValues[SchemeColorValues.Accent4 = 3] = "Accent4", 
            SchemeColorValues[SchemeColorValues.Accent5 = 4] = "Accent5", SchemeColorValues[SchemeColorValues.Accent6 = 5] = "Accent6", 
            SchemeColorValues[SchemeColorValues.Background1 = 6] = "Background1", SchemeColorValues[SchemeColorValues.Background2 = 7] = "Background2", 
            SchemeColorValues[SchemeColorValues.Dark1 = 8] = "Dark1", SchemeColorValues[SchemeColorValues.Dark2 = 9] = "Dark2", 
            SchemeColorValues[SchemeColorValues.FollowedHyperlink = 10] = "FollowedHyperlink", 
            SchemeColorValues[SchemeColorValues.Hyperlink = 11] = "Hyperlink", SchemeColorValues[SchemeColorValues.Light1 = 12] = "Light1", 
            SchemeColorValues[SchemeColorValues.Light2 = 13] = "Light2", SchemeColorValues[SchemeColorValues.Style = 14] = "Style", 
            SchemeColorValues[SchemeColorValues.Text1 = 15] = "Text1", SchemeColorValues[SchemeColorValues.Text2 = 16] = "Text2", 
            SchemeColorValues[SchemeColorValues.Empty = 17] = "Empty";
        }(SchemeColorValues || (SchemeColorValues = {})), function(SystemColorValues) {
            SystemColorValues[SystemColorValues.Sc3dDkShadow = 20] = "Sc3dDkShadow", SystemColorValues[SystemColorValues.Sc3dLight = 19] = "Sc3dLight", 
            SystemColorValues[SystemColorValues.ScActiveBorder = 21] = "ScActiveBorder", SystemColorValues[SystemColorValues.ScActiveCaption = 6] = "ScActiveCaption", 
            SystemColorValues[SystemColorValues.ScAppWorkspace = 24] = "ScAppWorkspace", SystemColorValues[SystemColorValues.ScBackground = 23] = "ScBackground", 
            SystemColorValues[SystemColorValues.ScBtnFace = 0] = "ScBtnFace", SystemColorValues[SystemColorValues.ScBtnHighlight = 7] = "ScBtnHighlight", 
            SystemColorValues[SystemColorValues.ScBtnShadow = 8] = "ScBtnShadow", SystemColorValues[SystemColorValues.ScBtnText = 9] = "ScBtnText", 
            SystemColorValues[SystemColorValues.ScCaptionText = 5] = "ScCaptionText", SystemColorValues[SystemColorValues.ScGradientActiveCaption = -2] = "ScGradientActiveCaption", 
            SystemColorValues[SystemColorValues.ScGradientInactiveCaption = -3] = "ScGradientInactiveCaption", 
            SystemColorValues[SystemColorValues.ScGrayText = 10] = "ScGrayText", SystemColorValues[SystemColorValues.ScHighlight = 3] = "ScHighlight", 
            SystemColorValues[SystemColorValues.ScHighlightText = 4] = "ScHighlightText", SystemColorValues[SystemColorValues.ScHotLight = -4] = "ScHotLight", 
            SystemColorValues[SystemColorValues.ScInactiveBorder = 22] = "ScInactiveBorder", 
            SystemColorValues[SystemColorValues.ScInactiveCaption = 11] = "ScInactiveCaption", 
            SystemColorValues[SystemColorValues.ScInactiveCaptionText = 12] = "ScInactiveCaptionText", 
            SystemColorValues[SystemColorValues.ScInfoBk = 13] = "ScInfoBk", SystemColorValues[SystemColorValues.ScInfoText = 14] = "ScInfoText", 
            SystemColorValues[SystemColorValues.ScMenu = 2] = "ScMenu", SystemColorValues[SystemColorValues.ScMenuBar = -5] = "ScMenuBar", 
            SystemColorValues[SystemColorValues.ScMenuHighlight = -6] = "ScMenuHighlight", SystemColorValues[SystemColorValues.ScMenuText = 15] = "ScMenuText", 
            SystemColorValues[SystemColorValues.ScScrollBar = 16] = "ScScrollBar", SystemColorValues[SystemColorValues.ScWindow = 17] = "ScWindow", 
            SystemColorValues[SystemColorValues.ScWindowFrame = 18] = "ScWindowFrame", SystemColorValues[SystemColorValues.ScWindowText = 1] = "ScWindowText", 
            SystemColorValues[SystemColorValues.Empty = -1] = "Empty";
        }(SystemColorValues || (SystemColorValues = {})), function(XlFontSchemeStyles) {
            XlFontSchemeStyles[XlFontSchemeStyles.None = 0] = "None", XlFontSchemeStyles[XlFontSchemeStyles.Minor = 1] = "Minor", 
            XlFontSchemeStyles[XlFontSchemeStyles.Major = 2] = "Major";
        }(XlFontSchemeStyles || (XlFontSchemeStyles = {})), function(StyleMatrixElementType) {
            StyleMatrixElementType[StyleMatrixElementType.None = 0] = "None", StyleMatrixElementType[StyleMatrixElementType.Subtle = 1] = "Subtle", 
            StyleMatrixElementType[StyleMatrixElementType.Moderate = 2] = "Moderate", StyleMatrixElementType[StyleMatrixElementType.Intense = 3] = "Intense";
        }(StyleMatrixElementType || (StyleMatrixElementType = {}));
        class DrawingColorModelInfo {
            constructor() {
                this.restoreDefaultValues();
            }
            calculateHash() {
                let hash = math.MathUtils.somePrimes[10] * this._colorType;
                switch (this._colorType) {
                  case DrawingColorType.Hsl:
                    hash ^= math.MathUtils.somePrimes[0] * this._hsl.calculateHash();
                    break;

                  case DrawingColorType.Preset:
                    hash ^= math.MathUtils.somePrimes[1] * utils_string.StringUtils.stringHashCode(this._preset);
                    break;

                  case DrawingColorType.Rgb:
                    hash ^= math.MathUtils.somePrimes[2] * this._rgb;
                    break;

                  case DrawingColorType.Scheme:
                    hash ^= math.MathUtils.somePrimes[3] * this._schemeColor;
                    break;

                  case DrawingColorType.ScRgb:
                    hash ^= math.MathUtils.somePrimes[4] * this._scRgb.calculateHash();
                    break;

                  case DrawingColorType.System:
                    hash ^= math.MathUtils.somePrimes[5] * this._systemColor;
                }
                return hash;
            }
            getHashCode() {
                return void 0 === this.hash ? this.hash = this.calculateHash() : this.hash;
            }
            setColorType(colorType) {
                this.restoreDefaultValues(), this._colorType = colorType;
            }
            get colorType() {
                return this._colorType;
            }
            get rgb() {
                return this._rgb;
            }
            set rgb(value) {
                this._colorType != DrawingColorType.Rgb && this.setColorType(DrawingColorType.Rgb), 
                this._rgb != value && (this._rgb = value);
            }
            get systemColor() {
                return this._systemColor;
            }
            set systemColor(value) {
                this._colorType != DrawingColorType.System && this.setColorType(DrawingColorType.System), 
                this._systemColor != value && (this._systemColor = value);
            }
            get schemeColor() {
                return this._schemeColor;
            }
            set schemeColor(value) {
                this._colorType != DrawingColorType.Scheme && this.setColorType(DrawingColorType.Scheme), 
                this._schemeColor != value && (this._schemeColor = value);
            }
            get hsl() {
                return this._hsl;
            }
            set hsl(value) {
                this._colorType != DrawingColorType.Hsl && this.setColorType(DrawingColorType.Hsl), 
                this._hsl.equals(value) || (this._hsl = value);
            }
            get preset() {
                return this._preset;
            }
            set preset(value) {
                this._colorType != DrawingColorType.Preset && this.setColorType(DrawingColorType.Preset), 
                this._preset == value || utils_string.StringUtils.isNullOrEmpty(value) || (this._preset = value);
            }
            get scRgb() {
                return this._scRgb;
            }
            set scRgb(value) {
                this._colorType != DrawingColorType.ScRgb && this.setColorType(DrawingColorType.ScRgb), 
                this._scRgb.equals(value) || (this._scRgb = value);
            }
            get isEmpty() {
                return DXColor.isTransparentOrEmpty(this._rgb) && this._colorType == DrawingColorType.Rgb;
            }
            static createRGB(rgb) {
                const result = new DrawingColorModelInfo;
                return result.rgb = DXColor.fromArgb(255, rgb), result;
            }
            static createARGB(argb) {
                var result = new DrawingColorModelInfo;
                return result.rgb = argb, result;
            }
            static createSystem(systemColor) {
                var result = new DrawingColorModelInfo;
                return result.systemColor = systemColor, result;
            }
            static createScheme(schemeColor) {
                var result = new DrawingColorModelInfo;
                return result.schemeColor = schemeColor, result;
            }
            static createPreset(preset) {
                var result = new DrawingColorModelInfo;
                return result.preset = preset, result;
            }
            static createScRgb(scColor) {
                var result = new DrawingColorModelInfo;
                return result.scRgb = scColor, result;
            }
            static createHSL(hsl) {
                var result = new DrawingColorModelInfo;
                return result.hsl = hsl, result;
            }
            static sRgbToRgb(hexColor) {
                return utils_color.i.fromHashString(hexColor);
            }
            toRgb(colorProvider, styleColor = DXColor.empty) {
                switch (this._colorType) {
                  case DrawingColorType.System:
                    return this.getRgbFromSystemColor();

                  case DrawingColorType.Scheme:
                    return this.getRgbFromSchemeColor(colorProvider, styleColor);

                  case DrawingColorType.Hsl:
                    return this._hsl.toRgb();

                  case DrawingColorType.Preset:
                    return this.getRgbFromPreset();

                  case DrawingColorType.ScRgb:
                    return this._scRgb.toRgb();

                  default:
                    return this._rgb;
                }
            }
            getRgbFromPreset() {
                var _a;
                return null !== (_a = utils_color.i.fromColorName(this._preset)) && void 0 !== _a ? _a : DXColor.empty;
            }
            getRgbFromSystemColor() {
                return this._systemColor == SystemColorValues.Empty ? DXColor.empty : DrawingColorModelInfo.systemColorTable[this._systemColor];
            }
            getRgbFromSchemeColor(colorProvider, styleColor) {
                return this._schemeColor == SchemeColorValues.Style ? styleColor : this._schemeColor == SchemeColorValues.Empty ? DXColor.empty : colorProvider.officeTheme.colors.getColorBySchemeColorValues(colorProvider, this._schemeColor);
            }
            restoreDefaultValues() {
                this._rgb = DXColor.empty, this._schemeColor = SchemeColorValues.Empty, this._systemColor = SystemColorValues.Empty, 
                this._preset = "", this._scRgb = ScRGBColor.defaultValue, this._hsl = ColorHSL.defaultValue;
            }
            clone() {
                var result = new DrawingColorModelInfo;
                return result.copyFrom(this), result;
            }
            copyFrom(value) {
                this._colorType = value._colorType, this._rgb = value._rgb, this._schemeColor = value._schemeColor, 
                this._systemColor = value._systemColor, this._preset = value._preset, this._scRgb = value._scRgb, 
                this._hsl = value._hsl;
            }
            equals(obj) {
                return obj && this._colorType == obj._colorType && this._rgb == obj._rgb && this._schemeColor == obj._schemeColor && this._systemColor == obj._systemColor && this._preset == obj._preset && this._scRgb.equals(obj._scRgb) && this._hsl.equals(obj._hsl);
            }
        }
        DrawingColorModelInfo.empty = new DrawingColorModelInfo, DrawingColorModelInfo.systemColorTable = {
            [SystemColorValues.Sc3dDkShadow]: DXSystemColors.controlDarkDark,
            [SystemColorValues.Sc3dLight]: DXSystemColors.controlLightLight,
            [SystemColorValues.ScActiveBorder]: DXSystemColors.activeBorder,
            [SystemColorValues.ScActiveCaption]: DXSystemColors.activeCaption,
            [SystemColorValues.ScAppWorkspace]: DXSystemColors.appWorkspace,
            [SystemColorValues.ScBackground]: DXSystemColors.desktop,
            [SystemColorValues.ScBtnFace]: DXSystemColors.control,
            [SystemColorValues.ScBtnHighlight]: DXSystemColors.controlLight,
            [SystemColorValues.ScBtnShadow]: DXSystemColors.controlDark,
            [SystemColorValues.ScBtnText]: DXSystemColors.controlText,
            [SystemColorValues.ScCaptionText]: DXSystemColors.activeCaptionText,
            [SystemColorValues.ScGradientActiveCaption]: DXSystemColors.gradientActiveCaption,
            [SystemColorValues.ScGradientInactiveCaption]: DXSystemColors.gradientInactiveCaption,
            [SystemColorValues.ScGrayText]: DXSystemColors.grayText,
            [SystemColorValues.ScHighlight]: DXSystemColors.highlight,
            [SystemColorValues.ScHighlightText]: DXSystemColors.highlightText,
            [SystemColorValues.ScHotLight]: DXSystemColors.hotTrack,
            [SystemColorValues.ScInactiveBorder]: DXSystemColors.inactiveBorder,
            [SystemColorValues.ScInactiveCaption]: DXSystemColors.inactiveCaption,
            [SystemColorValues.ScInactiveCaptionText]: DXSystemColors.inactiveCaptionText,
            [SystemColorValues.ScInfoBk]: DXSystemColors.info,
            [SystemColorValues.ScInfoText]: DXSystemColors.infoText,
            [SystemColorValues.ScMenu]: DXSystemColors.menu,
            [SystemColorValues.ScMenuBar]: DXSystemColors.menuBar,
            [SystemColorValues.ScMenuHighlight]: DXSystemColors.menuHighlight,
            [SystemColorValues.ScMenuText]: DXSystemColors.menuText,
            [SystemColorValues.ScScrollBar]: DXSystemColors.scrollBar,
            [SystemColorValues.ScWindow]: DXSystemColors.window,
            [SystemColorValues.ScWindowFrame]: DXSystemColors.windowFrame,
            [SystemColorValues.ScWindowText]: DXSystemColors.windowText
        };
        class DrawingColorModelInfoCache extends HashBasedCache {
            constructor() {
                super(), this.getItem(DrawingColorModelInfo.empty);
            }
            copyFrom(obj) {
                super.copyFrom(obj);
            }
            clone() {
                const result = new DrawingColorModelInfoCache;
                return result.copyFrom(this), result;
            }
        }
        DrawingColorModelInfoCache.defaultItem = new DrawingColorModelInfo;
        class HtmlConverter {
            static getCssRules(charProps, textColor, isWordBox, noStrikeoutAndUnderline, important) {
                var rules = HtmlConverter.getSizeSignificantRules(charProps, important);
                return rules.push(this.getForeColorRule(textColor)), noStrikeoutAndUnderline || (charProps.fontStrikeoutType == StrikeoutType.None || !isWordBox && charProps.strikeoutWordsOnly || rules.push("text-decoration: line-through"), 
                charProps.fontUnderlineType == UnderlineType.None || !isWordBox && charProps.underlineWordsOnly || rules.push("text-decoration: underline")), 
                rules;
            }
            static getForeColorRule(textColor) {
                return textColor = textColor !== ColorHelper.AUTOMATIC_COLOR ? textColor : ColorHelper.BLACK_COLOR, 
                "color: " + ColorHelper.getCssStringInternal(textColor);
            }
            static getSizeSignificantCssString(characterProperties) {
                return HtmlConverter.getSizeSignificantRules(characterProperties).join(";");
            }
            static getSizeSignificantRules(characterProperties, important = !0) {
                var rules = [];
                characterProperties.allCaps ? rules.push("text-transform: uppercase") : characterProperties.smallCaps && rules.push("font-variant: small-caps"), 
                rules.push("font-family: " + HtmlConverter.buildFontFamilyRule(characterProperties.fontInfo.cssString) + (important ? HtmlConverter.importantTag : "")), 
                characterProperties.fontBold && rules.push("font-weight: bold"), characterProperties.fontItalic && rules.push("font-style: italic");
                var fontSizePx = unit_converter.u.pointsToPixelsF(characterProperties.fontSize);
                return characterProperties.script == CharacterFormattingScript.Normal ? rules.push("font-size: " + math.MathUtils.round(fontSizePx, 3) + "px" + (important ? HtmlConverter.importantTag : "")) : rules.push("font-size: " + math.MathUtils.round(fontSizePx * characterProperties.fontInfo.scriptMultiplier, 3) + "px" + (important ? HtmlConverter.importantTag : "")), 
                rules;
            }
            static buildFontFamilyRule(cssString) {
                var result = cssString.replace(/"/g, "&quot;");
                return result.replace(/</g, "&lt;").replace(/>/g, "&gt;") != result && (result = result.replace(/'/g, "&quot;")), 
                result;
            }
        }
        HtmlConverter.importantTag = " !important";
        class FontMeasurer {
            getFontMeasurerInfo(font) {
                this.beginMeasuring(font);
                const baseLine = this.container.firstChild.offsetTop / this.container.lastChild.offsetHeight, heightFactor = this.container.lastChild.offsetHeight / FontMeasurer.testSpanHeigth;
                return this.endMeasuring(), new FontMeasurerInfo(baseLine, heightFactor);
            }
            beginMeasuring(font) {
                this.container || (this.container = document.createElement("div"), this.container.style.position = "absolute", 
                this.container.style.top = "-10000px", this.container.style.left = "-10000px", this.container.style.opacity = "0", 
                this.container.style.fontSize = "0px", this.container.style.lineHeight = "normal");
                var fontCssString = HtmlConverter.buildFontFamilyRule(font.cssString);
                this.container.innerHTML = "";
                var span = document.createElement("span");
                return span.style.cssText = "font-size:0; font-family: " + fontCssString + "; display: inline-block;", 
                span.innerHTML = "A", this.container.appendChild(span), (span = document.createElement("span")).style.cssText = "font-size:" + FontMeasurer.testSpanHeigth + "pt; font-family: " + fontCssString + "; display: inline-block;", 
                span.innerHTML = "A", this.container.appendChild(span), document.body.appendChild(this.container), 
                this.container;
            }
            endMeasuring() {
                this.container && this.container.parentNode && this.container.parentNode.removeChild(this.container);
            }
        }
        FontMeasurer.testSpanHeigth = 288;
        class FontMeasurerInfo {
            constructor(baseLine, heightFactor) {
                this.baseLine = baseLine, this.heightFactor = heightFactor;
            }
        }
        class FontInfoCache extends HashBasedCache {
            constructor(fontMeasurer) {
                super(), fontMeasurer ? this.fontMeasurer = fontMeasurer : (this.fontMeasurer = new FontMeasurer, 
                utils_list.ListUtils.forEach(FontInfoCache.defaultFonts, ((defaultFont, index) => this.addItemForMerge(defaultFont.clone(), index))));
            }
            static get defaultFontInfo() {
                return FontInfoCache._defaultFontInfo || (FontInfoCache._defaultFontInfo = utils_list.ListUtils.elementBy(FontInfoCache.defaultFonts, (f => f.name == FontInfoCache.defaultFontName))), 
                FontInfoCache._defaultFontInfo;
            }
            processNewItem(property) {
                property.measurer = this.fontMeasurer;
            }
            getItemByName(name) {
                const items = this.hashtable[FontInfo.calculateHashByName(name)];
                return items && items[0] ? items[0] : null;
            }
            getFontNames(sort = !1) {
                const result = [];
                return this.forEach((item => result.push(item.name))), sort && result.sort(), result;
            }
            getAllFonts() {
                const result = [];
                return this.forEach((item => result.push(item))), result;
            }
            addFont(name, cssString) {
                const newFontInfo = FontInfoCache.defaultFontInfo.clone();
                return newFontInfo.name = name, cssString && (newFontInfo.cssString = FontInfoCache.correctCssString(cssString)), 
                this.addItemForMerge(newFontInfo, this.count);
            }
            static correctCssString(cssString) {
                if (-1 != cssString.indexOf(" ")) {
                    "'" != cssString[0] && '"' != cssString[0] || (cssString = cssString.slice(1));
                    const lastChar = cssString[cssString.length - 1];
                    return "'" != lastChar && '"' != lastChar || (cssString = cssString.substr(0, cssString.length - 1)), 
                    `'${cssString}'`;
                }
                return cssString;
            }
            deleteFont(info) {
                const hash = FontInfo.calculateHashByName(info.name), items = this.hashtable[hash];
                items && items[0] && delete this.hashtable[hash];
            }
            static fillDefaultFonts(fontInfoCache) {
                0 == FontInfoCache.defaultFonts.length && (FontInfoCache.defaultFonts = utils_list.ListUtils.initByCallback(fontInfoCache.count, (ind => fontInfoCache.getItemByJsonKey(ind))));
            }
            copyFrom(obj) {
                super.copyFrom(obj), this.fontMeasurer = obj.fontMeasurer;
            }
            clone() {
                const result = new FontInfoCache(null);
                return result.copyFrom(this), result;
            }
        }
        FontInfoCache.defaultFonts = [], FontInfoCache.defaultFontName = "Calibri";
        class ListLevelPropertiesCache extends HashBasedCache {
            copyFrom(obj) {
                super.copyFrom(obj);
            }
            clone() {
                const result = new ListLevelPropertiesCache;
                return result.copyFrom(this), result;
            }
        }
        class MaskedCharacterPropertiesCache extends HashBasedCache {
            copyFrom(obj) {
                super.copyFrom(obj);
            }
            clone() {
                const result = new MaskedCharacterPropertiesCache;
                return result.copyFrom(this), result;
            }
        }
        class MaskedParagraphPropertiesCache extends HashBasedCache {
            copyFrom(obj) {
                super.copyFrom(obj);
            }
            clone() {
                const result = new MaskedParagraphPropertiesCache;
                return result.copyFrom(this), result;
            }
        }
        class ParagraphPropertiesCache extends HashBasedCache {
            copyFrom(obj) {
                super.copyFrom(obj);
            }
            clone() {
                const result = new ParagraphPropertiesCache;
                return result.copyFrom(this), result;
            }
        }
        class Scene3DPropertiesInfo {
            constructor() {
                this.packedValues = 0, this.zoom = DrawingValueConstants.ThousandthOfPercentage;
            }
            get cameraType() {
                return this.getUIntValue(Scene3DPropertiesInfo.maskPresetCameraType, 0);
            }
            set cameraType(value) {
                this.setUIntValue(Scene3DPropertiesInfo.maskPresetCameraType, 0, value);
            }
            get lightRigDirection() {
                return this.getUIntValue(Scene3DPropertiesInfo.maskLightRigDirection, 6);
            }
            set lightRigDirection(value) {
                this.setUIntValue(Scene3DPropertiesInfo.maskLightRigDirection, 6, value);
            }
            get lightRigPreset() {
                return this.getUIntValue(Scene3DPropertiesInfo.maskLightRigPreset, 10);
            }
            set lightRigPreset(value) {
                this.setUIntValue(Scene3DPropertiesInfo.maskLightRigPreset, 10, value);
            }
            get hasCameraRotation() {
                return this.getBooleanValue(Scene3DPropertiesInfo.maskHasCameraRotation);
            }
            set hasCameraRotation(value) {
                this.setBooleanValue(Scene3DPropertiesInfo.maskHasCameraRotation, value);
            }
            get hasLightRigRotation() {
                return this.getBooleanValue(Scene3DPropertiesInfo.maskHasLightRigRotation);
            }
            set hasLightRigRotation(value) {
                this.setBooleanValue(Scene3DPropertiesInfo.maskHasLightRigRotation, value);
            }
            get isDefault() {
                return this.equals(Scene3DPropertiesInfo.defaultInfo);
            }
            calculateHash() {
                return math.MathUtils.somePrimes[0] * this.packedValues ^ math.MathUtils.somePrimes[1] * this.fov ^ math.MathUtils.somePrimes[2] * this.zoom;
            }
            getHashCode() {
                return void 0 === this.hash ? this.hash = this.calculateHash() : this.hash;
            }
            getUIntValue(mask, offsetBits) {
                return (this.packedValues & mask) >> offsetBits;
            }
            setUIntValue(mask, offsetBits, value) {
                this.packedValues = ~mask, this.packedValues |= value << offsetBits & mask;
            }
            setBooleanValue(mask, bitVal) {
                this.packedValues = bitVal ? this.packedValues || mask : this.packedValues && ~mask;
            }
            getBooleanValue(mask) {
                return !!(this.packedValues & mask);
            }
            equals(obj) {
                return obj && this.packedValues == obj.packedValues && this.fov == obj.fov && this.zoom == obj.zoom;
            }
            clone() {
                const obj = new Scene3DPropertiesInfo;
                return obj.packedValues = this.packedValues, obj.fov = this.fov, obj.zoom = this.zoom, 
                obj;
            }
        }
        Scene3DPropertiesInfo.defaultInfo = new Scene3DPropertiesInfo, Scene3DPropertiesInfo.maskPresetCameraType = 63, 
        Scene3DPropertiesInfo.maskLightRigDirection = 960, Scene3DPropertiesInfo.maskLightRigPreset = 31744, 
        Scene3DPropertiesInfo.maskHasCameraRotation = 32768, Scene3DPropertiesInfo.maskHasLightRigRotation = 65536;
        class Scene3DPropertiesInfoCache extends HashBasedCache {
            copyFrom(obj) {
                super.copyFrom(obj);
            }
            clone() {
                const result = new Scene3DPropertiesInfoCache;
                return result.copyFrom(this), result;
            }
        }
        Scene3DPropertiesInfoCache.defaultItem = new Scene3DPropertiesInfo;
        class Scene3DRotationInfo {
            constructor(latitude = 0, longitude = 0, revolution = 0) {
                this.latitude = latitude, this.longitude = longitude, this.revolution = revolution;
            }
            calculateHash() {
                return math.MathUtils.somePrimes[0] * this.latitude ^ math.MathUtils.somePrimes[1] * this.longitude ^ math.MathUtils.somePrimes[2] * this.revolution;
            }
            getHashCode() {
                return void 0 === this.hash ? this.hash = this.calculateHash() : this.hash;
            }
            equals(obj) {
                return obj && this.latitude == obj.latitude && this.longitude == obj.longitude && this.revolution == obj.revolution;
            }
            clone() {
                const obj = new Scene3DRotationInfo;
                return obj.latitude = this.latitude, obj.longitude = this.longitude, obj.revolution = this.revolution, 
                obj;
            }
        }
        Scene3DRotationInfo.defaultInfo = new Scene3DRotationInfo;
        class Scene3DRotationInfoCache extends HashBasedCache {
            copyFrom(obj) {
                super.copyFrom(obj);
            }
            clone() {
                const result = new Scene3DRotationInfoCache;
                return result.copyFrom(this), result;
            }
        }
        Scene3DRotationInfoCache.defaultItem = new Scene3DRotationInfo;
        class ShadingInfoCache extends HashBasedCache {
            copyFrom(obj) {
                super.copyFrom(obj);
            }
            clone() {
                const result = new ShadingInfoCache;
                return result.copyFrom(this), result;
            }
        }
        class TableCellPropertiesCache extends HashBasedCache {
            copyFrom(obj) {
                super.copyFrom(obj);
            }
            clone() {
                const result = new TableCellPropertiesCache;
                return result.copyFrom(this), result;
            }
        }
        class TableRowPropertiesCache extends HashBasedCache {
            copyFrom(obj) {
                super.copyFrom(obj);
            }
            clone() {
                const result = new TableRowPropertiesCache;
                return result.copyFrom(this), result;
            }
        }
        var DrawingEffectContainerType, DrawingUnderlineFillType, DrawingFillType, DrawingBulletType, DrawingStrokeUnderlineType, PresetCameraType, LightRigDirection, LightRigPreset, PresetMaterialType, DrawingText3DType, PresetBevelType, geometry_size = __webpack_require__(6353), utils_base64 = __webpack_require__(6477), Buffer = __webpack_require__(8764).lW;
        class CacheImageInfo {
            constructor(base64, actualId, tmpId, imageUrl, file, referenceInfo, size, isLoaded) {
                this._base64 = void 0 !== base64 ? utils_base64.Base64Utils.normalizeToDataUrl(base64, "image/png") : void 0, 
                this.actualId = actualId, this.tmpId = tmpId, this._referenceInfo = referenceInfo, 
                this._size = size || CacheImageInfo.emptyPictureSize, this._isLoaded = void 0 !== isLoaded && isLoaded, 
                this.imageUrl = imageUrl, this.file = file;
            }
            static get emptyPictureSize() {
                return new geometry_size.Size(CacheImageInfo.emptyPicDimension, CacheImageInfo.emptyPicDimension);
            }
            get isLoaded() {
                return this._referenceInfo ? this._referenceInfo._isLoaded : this._isLoaded;
            }
            set isLoaded(val) {
                this._isLoaded = val;
            }
            get size() {
                return this._referenceInfo ? this._referenceInfo._size : this._size;
            }
            set size(val) {
                this._size = val;
            }
            get currId() {
                return void 0 !== this.actualId ? this.actualId : this.tmpId;
            }
            get base64() {
                return this._referenceInfo ? this._referenceInfo._base64 : this._base64;
            }
            set base64(val) {
                this._base64 = utils_base64.Base64Utils.normalizeToDataUrl(val, "image/png");
            }
            get pdfCompatibleBase64() {
                var _a;
                return null !== (_a = this._convertedBase64) && void 0 !== _a ? _a : this.base64;
            }
            get referenceInfo() {
                return this._referenceInfo;
            }
            set referenceInfo(val) {
                this._referenceInfo = val, this._base64 = void 0, this._size = void 0, this._isLoaded = void 0, 
                this.file = void 0;
            }
            equals(obj) {
                return (0, common.isDefined)(this._referenceInfo) && this._referenceInfo === obj._referenceInfo || this.actualId == obj.actualId && this.tmpId == obj.tmpId && this.base64 === obj.base64 && this.imageUrl === obj.imageUrl && this.file === obj.file && this.size.equals(obj.size);
            }
            clone() {
                return new CacheImageInfo(this._base64, this.actualId, this.tmpId, this.imageUrl, this.file, this._referenceInfo, this._size, this._isLoaded);
            }
            shouldMakeImagePdfCompatible() {
                return !(0, common.isDefined)(this._convertedBase64) && !this.isPdfCompatible();
            }
            isPdfCompatible() {
                if ((0, common.isDefined)(this._convertedBase64)) return !0;
                if ((0, common.isDefined)(this.base64)) {
                    const data = this.getImageHeader();
                    if (255 === data[0] && 216 === data[1]) return !0;
                    if (137 === data[0] && "PNG" === data.toString("ascii", 1, 4)) return !0;
                }
                return !1;
            }
            setPdfCompatibleBase64(val) {
                this._convertedBase64 = utils_base64.Base64Utils.normalizeToDataUrl(val, "image/png");
            }
            getImageHeader() {
                const header = /^data:.+;base64,(.*)$/.exec(this.base64)[1].substring(0, 8);
                return Buffer.from(header, "base64");
            }
        }
        CacheImageInfo.emptyPicDimension = unit_converter.u.pixelsToTwips(32);
        class ImageCache {
            constructor() {
                this.emptyImageId = 0, this.lastTmpId = 0, this.lastActualId = 1, this.cache = {};
                const onePixelSize = unit_converter.u.pixelsToTwips(1);
                this.createUnloadedInfoByBase64(ImageCache.transparentWhiteImage1_1, new geometry_size.Size(onePixelSize, onePixelSize)).isLoaded = !1;
            }
            get emptyImage() {
                return this.cache[this.emptyImageId];
            }
            getPictureData(id) {
                return this.cache[id];
            }
            createUnloadedInfoByUrl(imageUrl, size) {
                const info = this.findInfoByUrl(imageUrl);
                return info || this.registerPictureData(new CacheImageInfo(this.cache[this.emptyImageId].base64, void 0, this.lastTmpId--, imageUrl, void 0, void 0, this.origSizeCorrect(size) ? size : void 0));
            }
            createUnloadedInfoByFile(file) {
                return this.registerPictureData(new CacheImageInfo(this.cache[this.emptyImageId].base64, void 0, this.lastTmpId--, void 0, file));
            }
            registerFromAnotherModel(imageInfo) {
                imageInfo.isLoaded = !1, imageInfo.actualId = void 0, imageInfo.base64 = this.cache[this.emptyImageId].base64, 
                imageInfo.tmpId = this.lastTmpId--;
            }
            createUnloadedInfoByBase64(base64, size) {
                const info = this.findInfoByBase64(base64);
                if (info) return info;
                const origSizeCorrect = this.origSizeCorrect(size);
                return this.registerPictureData(new CacheImageInfo(base64, void 0, this.lastTmpId--, void 0, void 0, void 0, origSizeCorrect ? size : void 0));
            }
            createLoadedInfo(base64, size, id) {
                const info = this.findInfoByBase64(base64);
                return info ? void 0 === id || id === info.actualId ? info : this.registerPictureData(new CacheImageInfo(void 0, id, void 0, void 0, void 0, info, void 0)) : (void 0 === id && (id = this.getNextActualId()), 
                this.registerPictureData(new CacheImageInfo(base64, id, void 0, void 0, void 0, void 0, size, !!size)));
            }
            createUnloadedByBase64OrUrl(data, size) {
                return utils_base64.Base64Utils.checkPrependDataUrl(data) ? this.createUnloadedInfoByBase64(data, size) : this.createUnloadedInfoByUrl(data, size);
            }
            finalizeLoading(existingInfo, loadedInfo) {
                if (existingInfo.isLoaded = !0, existingInfo.size = loadedInfo.size, existingInfo.actualId = loadedInfo.actualId, 
                void 0 === existingInfo.actualId && (existingInfo.actualId = this.getNextActualId()), 
                this.registerPictureData(existingInfo), existingInfo.referenceInfo) return;
                const base64 = utils_base64.Base64Utils.normalizeToDataUrl(loadedInfo.base64, "image/png");
                number.j.containsBy(this.cache, (cacheElem => {
                    const isReference = cacheElem.base64 == base64 && cacheElem !== existingInfo && cacheElem.isLoaded;
                    return isReference && (existingInfo.referenceInfo = cacheElem.referenceInfo ? cacheElem.referenceInfo : cacheElem), 
                    isReference;
                })) || (existingInfo.base64 = base64);
            }
            getNextActualId() {
                return this.lastActualId++;
            }
            isDataRegistered(data) {
                return !!this.cache[data.actualId] || !!this.cache[data.tmpId];
            }
            registerPictureData(data) {
                let existingData = this.cache[data.actualId];
                return existingData || (existingData = this.cache[data.tmpId]), existingData || (existingData = data), 
                void 0 !== data.actualId && (this.cache[data.actualId] = existingData), void 0 !== data.tmpId && (this.cache[data.tmpId] = existingData), 
                existingData;
            }
            loadAllPictures(picture) {
                number.j.forEach(this.cache, (cacheInfo => {
                    this.emptyImageId != cacheInfo.actualId && picture.loader.load(cacheInfo);
                }));
            }
            findInfoByBase64(base64) {
                return base64 = utils_base64.Base64Utils.normalizeToDataUrl(base64, "image/png"), 
                number.j.elementBy(this.cache, (info => info.base64 == base64));
            }
            findInfoByUrl(imageUrl) {
                return number.j.elementBy(this.cache, (info => info.imageUrl == imageUrl));
            }
            origSizeCorrect(size) {
                return size && !!size.width && !!size.height;
            }
            clone() {
                const result = new ImageCache;
                return result.lastTmpId = this.lastTmpId, result.lastActualId = this.lastActualId, 
                result.cache = number.j.deepCopy(this.cache), number.j.forEach(result.cache, (el => {
                    el.referenceInfo && (el.referenceInfo = result.cache[el.currId]);
                })), result;
            }
        }
        ImageCache.transparentWhiteImage1_1 = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAYAAAAfFcSJAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAANSURBVBhXY/j///9/AAn7A/0FQ0XKAAAAAElFTkSuQmCC";
        class DocumentCache {
            constructor() {
                this.imageCache = new ImageCache, this.controlFontsCache = new ControlFontsCache, 
                this.fontInfoCache = new FontInfoCache(null), this.mergedCharacterPropertiesCache = new CharacterPropertiesCache, 
                this.mergedParagraphPropertiesCache = new ParagraphPropertiesCache, this.maskedCharacterPropertiesCache = new MaskedCharacterPropertiesCache, 
                this.maskedParagraphPropertiesCache = new MaskedParagraphPropertiesCache, this.tableRowPropertiesCache = new TableRowPropertiesCache, 
                this.tableCellPropertiesCache = new TableCellPropertiesCache, this.listLevelPropertiesCache = new ListLevelPropertiesCache, 
                this.shadingInfoCache = new ShadingInfoCache, this.colorModelInfoCache = new ColorModelInfoCache, 
                this.drawingColorModelInfoCache = new DrawingColorModelInfoCache, this.scene3DPropertiesInfoCache = new Scene3DPropertiesInfoCache, 
                this.scene3DRotationInfoCache = new Scene3DRotationInfoCache;
            }
            clearTemporaryCaches() {
                this.fontInfoCache.clearTemporaryCache(), this.mergedCharacterPropertiesCache.clearTemporaryCache(), 
                this.mergedParagraphPropertiesCache.clearTemporaryCache(), this.maskedCharacterPropertiesCache.clearTemporaryCache(), 
                this.maskedParagraphPropertiesCache.clearTemporaryCache(), this.listLevelPropertiesCache.clearTemporaryCache(), 
                this.tableRowPropertiesCache.clearTemporaryCache(), this.tableCellPropertiesCache.clearTemporaryCache(), 
                this.shadingInfoCache.clearTemporaryCache(), this.colorModelInfoCache.clearTemporaryCache(), 
                this.drawingColorModelInfoCache.clearTemporaryCache(), this.scene3DPropertiesInfoCache.clearTemporaryCache(), 
                this.scene3DRotationInfoCache.clearTemporaryCache();
            }
            DEBUG_DISTRIBUTION_INFO() {
                const result = [];
                return result.push(`maskedCharacterPropertiesCache \t{elems:${this.maskedCharacterPropertiesCache.count}, maxLen:${this.maskedCharacterPropertiesCache.DEBUG_MAX_CELL_LENGTH()}`), 
                result.push(`maskedParagraphPropertiesCache \t{elems:${this.maskedParagraphPropertiesCache.count}, maxLen:${this.maskedParagraphPropertiesCache.DEBUG_MAX_CELL_LENGTH()}`), 
                result.push(`mergedCharacterPropertiesCache \t{elems:${this.mergedCharacterPropertiesCache.count}, maxLen:${this.mergedCharacterPropertiesCache.DEBUG_MAX_CELL_LENGTH()}`), 
                result.push(`mergedParagraphPropertiesCache \t{elems:${this.mergedParagraphPropertiesCache.count}, maxLen:${this.mergedParagraphPropertiesCache.DEBUG_MAX_CELL_LENGTH()}`), 
                result.push(`listLevelPropertiesCache \t{elems:${this.listLevelPropertiesCache.count}, maxLen:${this.listLevelPropertiesCache.DEBUG_MAX_CELL_LENGTH()}`), 
                result.push(`tableRowPropertiesCache \t{elems:${this.tableRowPropertiesCache.count}, maxLen:${this.tableRowPropertiesCache.DEBUG_MAX_CELL_LENGTH()}`), 
                result.push(`tableCellPropertiesCache \t{elems:${this.tableCellPropertiesCache.count}, maxLen:${this.tableCellPropertiesCache.DEBUG_MAX_CELL_LENGTH()}`), 
                result.join("\n");
            }
            clone() {
                const cache = new DocumentCache;
                return cache.fontInfoCache = this.fontInfoCache.clone(), cache.controlFontsCache = this.controlFontsCache.clone(), 
                cache.mergedCharacterPropertiesCache = this.mergedCharacterPropertiesCache.clone(), 
                cache.mergedParagraphPropertiesCache = this.mergedParagraphPropertiesCache.clone(), 
                cache.maskedCharacterPropertiesCache = this.maskedCharacterPropertiesCache.clone(), 
                cache.maskedParagraphPropertiesCache = this.maskedParagraphPropertiesCache.clone(), 
                cache.tableRowPropertiesCache = this.tableRowPropertiesCache.clone(), cache.tableCellPropertiesCache = this.tableCellPropertiesCache.clone(), 
                cache.listLevelPropertiesCache = this.listLevelPropertiesCache.clone(), cache.imageCache = this.imageCache.clone(), 
                cache.shadingInfoCache = this.shadingInfoCache.clone(), cache.colorModelInfoCache = this.colorModelInfoCache.clone(), 
                cache.drawingColorModelInfoCache = this.drawingColorModelInfoCache.clone(), cache.scene3DPropertiesInfoCache = this.scene3DPropertiesInfoCache.clone(), 
                cache.scene3DRotationInfoCache = this.scene3DRotationInfoCache.clone(), cache;
            }
        }
        class Chunk {
            constructor(startLogPosition, textBuffer, isLast) {
                this.textBuffer = "", this.textRuns = [], this.startLogPosition = startLogPosition, 
                this.textBuffer = textBuffer, this.isLast = isLast;
            }
            getEndPosition() {
                return this.startLogPosition.value + this.textBuffer.length;
            }
            getRunText(run) {
                return this.textBuffer.substr(run.startOffset, run.getLength());
            }
            getTextInChunk(offsetAtStartChunk, length) {
                return this.textBuffer.substr(offsetAtStartChunk, length);
            }
            splitRun(runIndex, offset) {
                var run = this.textRuns[runIndex];
                if (!run) throw new Error("Undefined run");
                if (offset >= run.getLength()) throw new Error("Offset >= run.length");
                var newRun = run.createSimularity(run.startOffset + offset, run.getLength() - offset, run.paragraph, run.characterStyle, run.maskedCharacterProperties);
                run.setLength(offset), this.textRuns.splice(runIndex + 1, 0, newRun);
            }
            clone(subDocument) {
                const result = new Chunk(subDocument.positionManager.registerPosition(this.startLogPosition.value), this.textBuffer.slice(0), this.isLast);
                return result.textRuns = utils_list.ListUtils.map(this.textRuns, (r => r.cloneToNewSubDocument(subDocument))), 
                result;
            }
        }
        class DocumentProtectionSettings {
            constructor() {
                this.highlightRanges = !0, this.showBrackets = !0, this.rangeHighlightColor = "rgb(150, 200, 150)", 
                this.rangeHighlightBracketsColor = "rgb(127, 127, 127)", this.authenticationEMail = "", 
                this.authenticationGroup = "", this.authenticationUserName = "";
            }
            copyFrom(obj) {
                this.highlightRanges = obj.highlightRanges, this.showBrackets = obj.showBrackets, 
                this.rangeHighlightColor = obj.rangeHighlightColor, this.rangeHighlightBracketsColor = obj.rangeHighlightBracketsColor, 
                this.authenticationEMail = obj.authenticationEMail, this.authenticationGroup = obj.authenticationGroup, 
                this.authenticationUserName = obj.authenticationUserName;
            }
            clone() {
                const result = new DocumentProtectionSettings;
                return result.copyFrom(this), result;
            }
        }
        DocumentProtectionSettings.defaultColors = [ "rgb(213, 213, 255)", "rgb(255, 213, 255)", "rgb(255, 230, 213)", "rgb(213, 255, 254)", "rgb(255, 254, 213)", "rgb(233, 233, 233)", "rgb(255, 213, 213)", "rgb(213, 255, 213)" ];
        class ThemeDrawingColorCollection {
            constructor() {
                this.name = "", this.innerCollection = {};
            }
            tryGetDrawingColor(themeColorIndex) {
                return this.innerCollection[themeColorIndex];
            }
            setDrawingColor(themeColorIndex, value) {
                this.innerCollection[themeColorIndex] = value;
            }
            get Light1() {
                return this.tryGetDrawingColor(ThemeColorIndexConstants.Light1);
            }
            set Light1(value) {
                this.setDrawingColor(ThemeColorIndexConstants.Light1, value);
            }
            get Light2() {
                return this.tryGetDrawingColor(ThemeColorIndexConstants.Light2);
            }
            set Light2(value) {
                this.setDrawingColor(ThemeColorIndexConstants.Light2, value);
            }
            get Dark1() {
                return this.tryGetDrawingColor(ThemeColorIndexConstants.Dark1);
            }
            set Dark1(value) {
                this.setDrawingColor(ThemeColorIndexConstants.Dark1, value);
            }
            get Dark2() {
                return this.tryGetDrawingColor(ThemeColorIndexConstants.Dark2);
            }
            set Dark2(value) {
                this.setDrawingColor(ThemeColorIndexConstants.Dark2, value);
            }
            get Accent1() {
                return this.tryGetDrawingColor(ThemeColorIndexConstants.Accent1);
            }
            set Accent1(value) {
                this.setDrawingColor(ThemeColorIndexConstants.Accent1, value);
            }
            get Accent2() {
                return this.tryGetDrawingColor(ThemeColorIndexConstants.Accent2);
            }
            set Accent2(value) {
                this.setDrawingColor(ThemeColorIndexConstants.Accent2, value);
            }
            get Accent3() {
                return this.tryGetDrawingColor(ThemeColorIndexConstants.Accent3);
            }
            set Accent3(value) {
                this.setDrawingColor(ThemeColorIndexConstants.Accent3, value);
            }
            get Accent4() {
                return this.tryGetDrawingColor(ThemeColorIndexConstants.Accent4);
            }
            set Accent4(value) {
                this.setDrawingColor(ThemeColorIndexConstants.Accent4, value);
            }
            get Accent5() {
                return this.tryGetDrawingColor(ThemeColorIndexConstants.Accent5);
            }
            set Accent5(value) {
                this.setDrawingColor(ThemeColorIndexConstants.Accent5, value);
            }
            get Accent6() {
                return this.tryGetDrawingColor(ThemeColorIndexConstants.Accent6);
            }
            set Accent6(value) {
                this.setDrawingColor(ThemeColorIndexConstants.Accent6, value);
            }
            get Hyperlink() {
                return this.tryGetDrawingColor(ThemeColorIndexConstants.Hyperlink);
            }
            set Hyperlink(value) {
                this.setDrawingColor(ThemeColorIndexConstants.Hyperlink, value);
            }
            get FollowedHyperlink() {
                return this.tryGetDrawingColor(ThemeColorIndexConstants.FollowedHyperlink);
            }
            set FollowedHyperlink(value) {
                this.setDrawingColor(ThemeColorIndexConstants.FollowedHyperlink, value);
            }
            isValidate() {
                return this.checkValidation();
            }
            getColorByThemeColorIndex(colorProvider, themeColorIndex) {
                const drawingColor = this.tryGetDrawingColor(themeColorIndex);
                if (null == drawingColor) throw new Error(errors.D.InternalException);
                return drawingColor.finalColor(colorProvider);
            }
            getColorBySchemeColorValues(colorProvider, value) {
                return this.getColorByThemeColorIndex(colorProvider, ThemeDrawingColorCollection.schemeColorValuesToThemeColorIndexTranslationTable[value]);
            }
            copyFrom(sourceObj) {
                this.clear(), this.name = sourceObj.name, this.innerCollection = number.j.map(sourceObj.innerCollection, (val => val));
            }
            clear() {
                this.name = "", number.j.clear(this.innerCollection);
            }
            checkValidation() {
                return null != this.name && 12 == number.j.mapLength(this.innerCollection) && void 0 !== this.innerCollection[ThemeColorIndexConstants.Dark1] && void 0 !== this.innerCollection[ThemeColorIndexConstants.Light1] && void 0 !== this.innerCollection[ThemeColorIndexConstants.Dark2] && void 0 !== this.innerCollection[ThemeColorIndexConstants.Light2] && void 0 !== this.innerCollection[ThemeColorIndexConstants.Accent1] && void 0 !== this.innerCollection[ThemeColorIndexConstants.Accent2] && void 0 !== this.innerCollection[ThemeColorIndexConstants.Accent3] && void 0 !== this.innerCollection[ThemeColorIndexConstants.Accent4] && void 0 !== this.innerCollection[ThemeColorIndexConstants.Accent5] && void 0 !== this.innerCollection[ThemeColorIndexConstants.Accent6] && void 0 !== this.innerCollection[ThemeColorIndexConstants.Hyperlink] && void 0 !== this.innerCollection[ThemeColorIndexConstants.FollowedHyperlink];
            }
        }
        ThemeDrawingColorCollection.schemeColorValuesToThemeColorIndexTranslationTable = {
            [SchemeColorValues.Background1]: ThemeColorIndexConstants.Light1,
            [SchemeColorValues.Background2]: ThemeColorIndexConstants.Light2,
            [SchemeColorValues.Text1]: ThemeColorIndexConstants.Dark1,
            [SchemeColorValues.Text2]: ThemeColorIndexConstants.Dark2,
            [SchemeColorValues.Light1]: ThemeColorIndexConstants.Light1,
            [SchemeColorValues.Light2]: ThemeColorIndexConstants.Light2,
            [SchemeColorValues.Dark1]: ThemeColorIndexConstants.Dark1,
            [SchemeColorValues.Dark2]: ThemeColorIndexConstants.Dark2,
            [SchemeColorValues.Accent1]: ThemeColorIndexConstants.Accent1,
            [SchemeColorValues.Accent2]: ThemeColorIndexConstants.Accent2,
            [SchemeColorValues.Accent3]: ThemeColorIndexConstants.Accent3,
            [SchemeColorValues.Accent4]: ThemeColorIndexConstants.Accent4,
            [SchemeColorValues.Accent5]: ThemeColorIndexConstants.Accent5,
            [SchemeColorValues.Accent6]: ThemeColorIndexConstants.Accent6,
            [SchemeColorValues.Hyperlink]: ThemeColorIndexConstants.Hyperlink,
            [SchemeColorValues.FollowedHyperlink]: ThemeColorIndexConstants.FollowedHyperlink
        }, function(DrawingEffectContainerType) {
            DrawingEffectContainerType[DrawingEffectContainerType.Sibling = 0] = "Sibling", 
            DrawingEffectContainerType[DrawingEffectContainerType.Tree = 1] = "Tree";
        }(DrawingEffectContainerType || (DrawingEffectContainerType = {})), function(DrawingUnderlineFillType) {
            DrawingUnderlineFillType[DrawingUnderlineFillType.Fill = 0] = "Fill", DrawingUnderlineFillType[DrawingUnderlineFillType.FollowsText = 1] = "FollowsText";
        }(DrawingUnderlineFillType || (DrawingUnderlineFillType = {})), function(DrawingFillType) {
            DrawingFillType[DrawingFillType.Automatic = 0] = "Automatic", DrawingFillType[DrawingFillType.None = 1] = "None", 
            DrawingFillType[DrawingFillType.Solid = 2] = "Solid", DrawingFillType[DrawingFillType.Gradient = 3] = "Gradient", 
            DrawingFillType[DrawingFillType.Group = 4] = "Group", DrawingFillType[DrawingFillType.Pattern = 5] = "Pattern", 
            DrawingFillType[DrawingFillType.Picture = 6] = "Picture";
        }(DrawingFillType || (DrawingFillType = {})), function(DrawingBulletType) {
            DrawingBulletType[DrawingBulletType.Automatic = 0] = "Automatic", DrawingBulletType[DrawingBulletType.Color = 1] = "Color", 
            DrawingBulletType[DrawingBulletType.Size = 2] = "Size", DrawingBulletType[DrawingBulletType.Typeface = 3] = "Typeface", 
            DrawingBulletType[DrawingBulletType.Common = 4] = "Common";
        }(DrawingBulletType || (DrawingBulletType = {})), function(DrawingStrokeUnderlineType) {
            DrawingStrokeUnderlineType[DrawingStrokeUnderlineType.Automatic = 0] = "Automatic", 
            DrawingStrokeUnderlineType[DrawingStrokeUnderlineType.Outline = 1] = "Outline", 
            DrawingStrokeUnderlineType[DrawingStrokeUnderlineType.FollowsText = 2] = "FollowsText";
        }(DrawingStrokeUnderlineType || (DrawingStrokeUnderlineType = {})), function(PresetCameraType) {
            PresetCameraType[PresetCameraType.None = 0] = "None", PresetCameraType[PresetCameraType.LegacyObliqueTopLeft = 1] = "LegacyObliqueTopLeft", 
            PresetCameraType[PresetCameraType.LegacyObliqueTop = 2] = "LegacyObliqueTop", PresetCameraType[PresetCameraType.LegacyObliqueTopRight = 3] = "LegacyObliqueTopRight", 
            PresetCameraType[PresetCameraType.LegacyObliqueLeft = 4] = "LegacyObliqueLeft", 
            PresetCameraType[PresetCameraType.LegacyObliqueFront = 5] = "LegacyObliqueFront", 
            PresetCameraType[PresetCameraType.LegacyObliqueRight = 6] = "LegacyObliqueRight", 
            PresetCameraType[PresetCameraType.LegacyObliqueBottomLeft = 7] = "LegacyObliqueBottomLeft", 
            PresetCameraType[PresetCameraType.LegacyObliqueBottom = 8] = "LegacyObliqueBottom", 
            PresetCameraType[PresetCameraType.LegacyObliqueBottomRight = 9] = "LegacyObliqueBottomRight", 
            PresetCameraType[PresetCameraType.LegacyPerspectiveTopLeft = 10] = "LegacyPerspectiveTopLeft", 
            PresetCameraType[PresetCameraType.LegacyPerspectiveTop = 11] = "LegacyPerspectiveTop", 
            PresetCameraType[PresetCameraType.LegacyPerspectiveTopRight = 12] = "LegacyPerspectiveTopRight", 
            PresetCameraType[PresetCameraType.LegacyPerspectiveLeft = 13] = "LegacyPerspectiveLeft", 
            PresetCameraType[PresetCameraType.LegacyPerspectiveFront = 14] = "LegacyPerspectiveFront", 
            PresetCameraType[PresetCameraType.LegacyPerspectiveRight = 15] = "LegacyPerspectiveRight", 
            PresetCameraType[PresetCameraType.LegacyPerspectiveBottomLeft = 16] = "LegacyPerspectiveBottomLeft", 
            PresetCameraType[PresetCameraType.LegacyPerspectiveBottom = 17] = "LegacyPerspectiveBottom", 
            PresetCameraType[PresetCameraType.LegacyPerspectiveBottomRight = 18] = "LegacyPerspectiveBottomRight", 
            PresetCameraType[PresetCameraType.OrthographicFront = 19] = "OrthographicFront", 
            PresetCameraType[PresetCameraType.IsometricTopUp = 20] = "IsometricTopUp", PresetCameraType[PresetCameraType.IsometricTopDown = 21] = "IsometricTopDown", 
            PresetCameraType[PresetCameraType.IsometricBottomUp = 22] = "IsometricBottomUp", 
            PresetCameraType[PresetCameraType.IsometricBottomDown = 23] = "IsometricBottomDown", 
            PresetCameraType[PresetCameraType.IsometricLeftUp = 24] = "IsometricLeftUp", PresetCameraType[PresetCameraType.IsometricLeftDown = 25] = "IsometricLeftDown", 
            PresetCameraType[PresetCameraType.IsometricRightUp = 26] = "IsometricRightUp", PresetCameraType[PresetCameraType.IsometricRightDown = 27] = "IsometricRightDown", 
            PresetCameraType[PresetCameraType.IsometricOffAxis1Left = 28] = "IsometricOffAxis1Left", 
            PresetCameraType[PresetCameraType.IsometricOffAxis1Right = 29] = "IsometricOffAxis1Right", 
            PresetCameraType[PresetCameraType.IsometricOffAxis1Top = 30] = "IsometricOffAxis1Top", 
            PresetCameraType[PresetCameraType.IsometricOffAxis2Left = 31] = "IsometricOffAxis2Left", 
            PresetCameraType[PresetCameraType.IsometricOffAxis2Right = 32] = "IsometricOffAxis2Right", 
            PresetCameraType[PresetCameraType.IsometricOffAxis2Top = 33] = "IsometricOffAxis2Top", 
            PresetCameraType[PresetCameraType.IsometricOffAxis3Left = 34] = "IsometricOffAxis3Left", 
            PresetCameraType[PresetCameraType.IsometricOffAxis3Right = 35] = "IsometricOffAxis3Right", 
            PresetCameraType[PresetCameraType.IsometricOffAxis3Bottom = 36] = "IsometricOffAxis3Bottom", 
            PresetCameraType[PresetCameraType.IsometricOffAxis4Left = 37] = "IsometricOffAxis4Left", 
            PresetCameraType[PresetCameraType.IsometricOffAxis4Right = 38] = "IsometricOffAxis4Right", 
            PresetCameraType[PresetCameraType.IsometricOffAxis4Bottom = 39] = "IsometricOffAxis4Bottom", 
            PresetCameraType[PresetCameraType.ObliqueTopLeft = 40] = "ObliqueTopLeft", PresetCameraType[PresetCameraType.ObliqueTop = 41] = "ObliqueTop", 
            PresetCameraType[PresetCameraType.ObliqueTopRight = 42] = "ObliqueTopRight", PresetCameraType[PresetCameraType.ObliqueLeft = 43] = "ObliqueLeft", 
            PresetCameraType[PresetCameraType.ObliqueRight = 44] = "ObliqueRight", PresetCameraType[PresetCameraType.ObliqueBottomLeft = 45] = "ObliqueBottomLeft", 
            PresetCameraType[PresetCameraType.ObliqueBottom = 46] = "ObliqueBottom", PresetCameraType[PresetCameraType.ObliqueBottomRight = 47] = "ObliqueBottomRight", 
            PresetCameraType[PresetCameraType.PerspectiveFront = 48] = "PerspectiveFront", PresetCameraType[PresetCameraType.PerspectiveLeft = 49] = "PerspectiveLeft", 
            PresetCameraType[PresetCameraType.PerspectiveRight = 50] = "PerspectiveRight", PresetCameraType[PresetCameraType.PerspectiveAbove = 51] = "PerspectiveAbove", 
            PresetCameraType[PresetCameraType.PerspectiveBelow = 52] = "PerspectiveBelow", PresetCameraType[PresetCameraType.PerspectiveAboveLeftFacing = 53] = "PerspectiveAboveLeftFacing", 
            PresetCameraType[PresetCameraType.PerspectiveAboveRightFacing = 54] = "PerspectiveAboveRightFacing", 
            PresetCameraType[PresetCameraType.PerspectiveContrastingLeftFacing = 55] = "PerspectiveContrastingLeftFacing", 
            PresetCameraType[PresetCameraType.PerspectiveContrastingRightFacing = 56] = "PerspectiveContrastingRightFacing", 
            PresetCameraType[PresetCameraType.PerspectiveHeroicLeftFacing = 57] = "PerspectiveHeroicLeftFacing", 
            PresetCameraType[PresetCameraType.PerspectiveHeroicRightFacing = 58] = "PerspectiveHeroicRightFacing", 
            PresetCameraType[PresetCameraType.PerspectiveHeroicExtremeLeftFacing = 59] = "PerspectiveHeroicExtremeLeftFacing", 
            PresetCameraType[PresetCameraType.PerspectiveHeroicExtremeRightFacing = 60] = "PerspectiveHeroicExtremeRightFacing", 
            PresetCameraType[PresetCameraType.PerspectiveRelaxed = 61] = "PerspectiveRelaxed", 
            PresetCameraType[PresetCameraType.PerspectiveRelaxedModerately = 62] = "PerspectiveRelaxedModerately";
        }(PresetCameraType || (PresetCameraType = {})), function(LightRigDirection) {
            LightRigDirection[LightRigDirection.None = 0] = "None", LightRigDirection[LightRigDirection.Bottom = 1] = "Bottom", 
            LightRigDirection[LightRigDirection.BottomLeft = 2] = "BottomLeft", LightRigDirection[LightRigDirection.BottomRight = 3] = "BottomRight", 
            LightRigDirection[LightRigDirection.Left = 4] = "Left", LightRigDirection[LightRigDirection.Right = 5] = "Right", 
            LightRigDirection[LightRigDirection.Top = 6] = "Top", LightRigDirection[LightRigDirection.TopLeft = 7] = "TopLeft", 
            LightRigDirection[LightRigDirection.TopRight = 8] = "TopRight";
        }(LightRigDirection || (LightRigDirection = {})), function(LightRigPreset) {
            LightRigPreset[LightRigPreset.None = 0] = "None", LightRigPreset[LightRigPreset.LegacyFlat1 = 1] = "LegacyFlat1", 
            LightRigPreset[LightRigPreset.LegacyFlat2 = 2] = "LegacyFlat2", LightRigPreset[LightRigPreset.LegacyFlat3 = 3] = "LegacyFlat3", 
            LightRigPreset[LightRigPreset.LegacyFlat4 = 4] = "LegacyFlat4", LightRigPreset[LightRigPreset.LegacyNormal1 = 5] = "LegacyNormal1", 
            LightRigPreset[LightRigPreset.LegacyNormal2 = 6] = "LegacyNormal2", LightRigPreset[LightRigPreset.LegacyNormal3 = 7] = "LegacyNormal3", 
            LightRigPreset[LightRigPreset.LegacyNormal4 = 8] = "LegacyNormal4", LightRigPreset[LightRigPreset.LegacyHarsh1 = 9] = "LegacyHarsh1", 
            LightRigPreset[LightRigPreset.LegacyHarsh2 = 10] = "LegacyHarsh2", LightRigPreset[LightRigPreset.LegacyHarsh3 = 11] = "LegacyHarsh3", 
            LightRigPreset[LightRigPreset.LegacyHarsh4 = 12] = "LegacyHarsh4", LightRigPreset[LightRigPreset.ThreePt = 13] = "ThreePt", 
            LightRigPreset[LightRigPreset.Balanced = 14] = "Balanced", LightRigPreset[LightRigPreset.Soft = 15] = "Soft", 
            LightRigPreset[LightRigPreset.Harsh = 16] = "Harsh", LightRigPreset[LightRigPreset.Flood = 17] = "Flood", 
            LightRigPreset[LightRigPreset.Contrasting = 18] = "Contrasting", LightRigPreset[LightRigPreset.Morning = 19] = "Morning", 
            LightRigPreset[LightRigPreset.Sunrise = 20] = "Sunrise", LightRigPreset[LightRigPreset.Sunset = 21] = "Sunset", 
            LightRigPreset[LightRigPreset.Chilly = 22] = "Chilly", LightRigPreset[LightRigPreset.Freezing = 23] = "Freezing", 
            LightRigPreset[LightRigPreset.Flat = 24] = "Flat", LightRigPreset[LightRigPreset.TwoPt = 25] = "TwoPt", 
            LightRigPreset[LightRigPreset.Glow = 26] = "Glow", LightRigPreset[LightRigPreset.BrightRoom = 27] = "BrightRoom";
        }(LightRigPreset || (LightRigPreset = {})), function(PresetMaterialType) {
            PresetMaterialType[PresetMaterialType.None = 0] = "None", PresetMaterialType[PresetMaterialType.LegacyMatte = 1] = "LegacyMatte", 
            PresetMaterialType[PresetMaterialType.LegacyPlastic = 2] = "LegacyPlastic", PresetMaterialType[PresetMaterialType.LegacyMetal = 3] = "LegacyMetal", 
            PresetMaterialType[PresetMaterialType.LegacyWireframe = 4] = "LegacyWireframe", 
            PresetMaterialType[PresetMaterialType.Matte = 5] = "Matte", PresetMaterialType[PresetMaterialType.Plastic = 6] = "Plastic", 
            PresetMaterialType[PresetMaterialType.Metal = 7] = "Metal", PresetMaterialType[PresetMaterialType.WarmMatte = 8] = "WarmMatte", 
            PresetMaterialType[PresetMaterialType.TranslucentPowder = 9] = "TranslucentPowder", 
            PresetMaterialType[PresetMaterialType.Powder = 10] = "Powder", PresetMaterialType[PresetMaterialType.DarkEdge = 11] = "DarkEdge", 
            PresetMaterialType[PresetMaterialType.SoftEdge = 12] = "SoftEdge", PresetMaterialType[PresetMaterialType.Clear = 13] = "Clear", 
            PresetMaterialType[PresetMaterialType.Flat = 14] = "Flat", PresetMaterialType[PresetMaterialType.SoftMetal = 15] = "SoftMetal";
        }(PresetMaterialType || (PresetMaterialType = {})), function(DrawingText3DType) {
            DrawingText3DType[DrawingText3DType.Automatic = 0] = "Automatic", DrawingText3DType[DrawingText3DType.Shape3D = 1] = "Shape3D", 
            DrawingText3DType[DrawingText3DType.FlatText = 2] = "FlatText";
        }(DrawingText3DType || (DrawingText3DType = {})), function(PresetBevelType) {
            PresetBevelType[PresetBevelType.None = 0] = "None", PresetBevelType[PresetBevelType.RelaxedInset = 1] = "RelaxedInset", 
            PresetBevelType[PresetBevelType.Circle = 2] = "Circle", PresetBevelType[PresetBevelType.Slope = 3] = "Slope", 
            PresetBevelType[PresetBevelType.Cross = 4] = "Cross", PresetBevelType[PresetBevelType.Angle = 5] = "Angle", 
            PresetBevelType[PresetBevelType.SoftRound = 6] = "SoftRound", PresetBevelType[PresetBevelType.Convex = 7] = "Convex", 
            PresetBevelType[PresetBevelType.CoolSlant = 8] = "CoolSlant", PresetBevelType[PresetBevelType.Divot = 9] = "Divot", 
            PresetBevelType[PresetBevelType.Riblet = 10] = "Riblet", PresetBevelType[PresetBevelType.HardEdge = 11] = "HardEdge", 
            PresetBevelType[PresetBevelType.ArtDeco = 12] = "ArtDeco";
        }(PresetBevelType || (PresetBevelType = {}));
        class DrawingTextFont {
            constructor() {
                this.stringArray = [ "", "" ], this.byteArray = [ DrawingTextFont.DefaultCharset, DrawingTextFont.DefaultPitchFamily ];
            }
            get typeface() {
                return this.stringArray[DrawingTextFont.typefaceIndex];
            }
            set typeface(value) {
                this.setStringArray(DrawingTextFont.typefaceIndex, value);
            }
            get panose() {
                return this.stringArray[DrawingTextFont.panoseIndex];
            }
            set panose(value) {
                this.setStringArray(DrawingTextFont.panoseIndex, value);
            }
            get charset() {
                return this.byteArray[DrawingTextFont.charsetIndex];
            }
            set charset(value) {
                this.setByteArray(DrawingTextFont.charsetIndex, value);
            }
            get pitchFamily() {
                return this.byteArray[DrawingTextFont.pitchFamilyIndex];
            }
            set pitchFamily(value) {
                this.setByteArray(DrawingTextFont.pitchFamilyIndex, value);
            }
            get isDefault() {
                return utils_string.StringUtils.isNullOrEmpty(this.stringArray[DrawingTextFont.typefaceIndex]) && utils_string.StringUtils.isNullOrEmpty(this.stringArray[DrawingTextFont.panoseIndex]) && this.byteArray[DrawingTextFont.charsetIndex] == DrawingTextFont.DefaultCharset && this.byteArray[DrawingTextFont.pitchFamilyIndex] == DrawingTextFont.DefaultPitchFamily;
            }
            copyFrom(value) {
                this.stringArray[DrawingTextFont.typefaceIndex] = value.stringArray[DrawingTextFont.typefaceIndex], 
                this.stringArray[DrawingTextFont.panoseIndex] = value.stringArray[DrawingTextFont.panoseIndex], 
                this.byteArray[DrawingTextFont.charsetIndex] = value.byteArray[DrawingTextFont.charsetIndex], 
                this.byteArray[DrawingTextFont.pitchFamilyIndex] = value.byteArray[DrawingTextFont.pitchFamilyIndex];
            }
            clone() {
                var result = new DrawingTextFont;
                return result.copyFrom(this), result;
            }
            equals(other) {
                return other && this.stringArray[DrawingTextFont.typefaceIndex] == other.stringArray[DrawingTextFont.typefaceIndex] && this.stringArray[DrawingTextFont.panoseIndex] == other.stringArray[DrawingTextFont.panoseIndex] && this.byteArray[DrawingTextFont.charsetIndex] == other.byteArray[DrawingTextFont.charsetIndex] && this.byteArray[DrawingTextFont.pitchFamilyIndex] == other.byteArray[DrawingTextFont.pitchFamilyIndex];
            }
            clear() {
                this.typeface = "", this.panose = "", this.charset = DrawingTextFont.DefaultCharset, 
                this.pitchFamily = DrawingTextFont.DefaultPitchFamily;
            }
            get type() {
                return DrawingBulletType.Typeface;
            }
            setStringArray(index, value) {
                this.stringArray[index] != value && (this.stringArray[index] = value);
            }
            setByteArray(index, value) {
                this.byteArray[index] != value && (this.byteArray[index] = value);
            }
        }
        DrawingTextFont.DefaultCharset = 1, DrawingTextFont.DefaultPitchFamily = 0, DrawingTextFont.typefaceIndex = 0, 
        DrawingTextFont.panoseIndex = 1, DrawingTextFont.charsetIndex = 0, DrawingTextFont.pitchFamilyIndex = 1;
        class ThemeFontSchemePart {
            constructor() {
                this.supplementalFonts = {}, this.isValid = !1, this.latin = new DrawingTextFont, 
                this.eastAsian = new DrawingTextFont, this.complexScript = new DrawingTextFont;
            }
            addSupplementalFont(script, typeface) {
                utils_string.StringUtils.isNullOrEmpty(script) || void 0 === !this.supplementalFonts[script] || (this.supplementalFonts[script] = typeface);
            }
            copyFrom(value) {
                this.latin.copyFrom(value.latin), this.eastAsian.copyFrom(value.eastAsian), this.complexScript.copyFrom(value.complexScript), 
                this.isValid = value.isValid, string.StringMapUtils.clear(this.supplementalFonts), 
                string.StringMapUtils.forEach(value.supplementalFonts, ((value, key) => this.addSupplementalFont[key] = value));
            }
            getTypeface(currentUICulture) {
                const name = currentUICulture.name, script = ThemeFontSchemePart.cultureNameToScriptTable[name];
                return void 0 !== script && void 0 !== this.supplementalFonts[script] ? this.supplementalFonts[script] : this.getDefaultTypeface();
            }
            clear() {
                this.latin.clear(), this.eastAsian.clear(), this.complexScript.clear(), string.StringMapUtils.clear(this.supplementalFonts), 
                this.isValid = !1;
            }
            getDefaultTypeface() {
                return this.latin.typeface;
            }
        }
        ThemeFontSchemePart.cultureNameToScriptTable = {
            "ar-LY": "Arab",
            "ar-DZ": "Arab",
            "ar-MA": "Arab",
            "ar-TN": "Arab",
            "ar-OM": "Arab",
            "ar-YE": "Arab",
            "ar-SY": "Arab",
            "ar-JO": "Arab",
            "ar-LB": "Arab",
            "ar-KW": "Arab",
            "ar-AE": "Arab",
            "ar-BH": "Arab",
            "ar-QA": "Arab",
            "ar-SA": "Arab",
            "ur-PK": "Arab",
            "fa-IR": "Arab",
            "ps-AF": "Arab",
            "prs-AF": "Arab",
            "ar-IQ": "Arab",
            "ar-EG": "Arab",
            "hy-AM": "Armn",
            "bn-IN": "Beng",
            "as-IN": "Beng",
            "bn-BD": "Beng",
            "iu-Cans-CA": "Cans",
            "sr-Cyrl-BA": "Cyrl",
            "bs-Cyrl-BA": "Cyrl",
            "sr-Cyrl-RS": "Cyrl",
            "sr-Cyrl-ME": "Cyrl",
            "bg-BG": "Cyrl",
            "ru-RU": "Cyrl",
            "uk-UA": "Cyrl",
            "be-BY": "Cyrl",
            "tg-Cyrl-TJ": "Cyrl",
            "mk-MK": "Cyrl",
            "kk-KZ": "Cyrl",
            "ky-KG": "Cyrl",
            "tt-RU": "Cyrl",
            "mn-MN": "Cyrl",
            "ba-RU": "Cyrl",
            "sah-RU": "Cyrl",
            "az-Cyrl-AZ": "Cyrl",
            "uz-Cyrl-UZ": "Cyrl",
            "sr-Cyrl-CS": "Cyrl",
            "hi-IN": "Deva",
            "mr-IN": "Deva",
            "sa-IN": "Deva",
            "kok-IN": "Deva",
            "ne-NP": "Deva",
            "am-ET": "Ethi",
            "ka-GE": "Geor",
            "el-GR": "Grek",
            "gu-IN": "Gujr",
            "pa-IN": "Guru",
            "ko-KR": "Hang",
            "zh-SG": "Hans",
            "zh-CN": "Hans",
            "zh-MO": "Hant",
            "zh-TW": "Hant",
            "zh-HK": "Hant",
            "he-IL": "Hebr",
            "ja-JP": "Jpan",
            "km-KH": "Khmr",
            "kn-IN": "Knda",
            "lo-LA": "Laoo",
            "de-LU": "Latn",
            "en-CA": "Latn",
            "es-GT": "Latn",
            "fr-CH": "Latn",
            "hr-BA": "Latn",
            "smj-NO": "Latn",
            "de-LI": "Latn",
            "en-NZ": "Latn",
            "es-CR": "Latn",
            "fr-LU": "Latn",
            "bs-Latn-BA": "Latn",
            "smj-SE": "Latn",
            "en-IE": "Latn",
            "es-PA": "Latn",
            "fr-MC": "Latn",
            "sr-Latn-BA": "Latn",
            "sma-NO": "Latn",
            "en-ZA": "Latn",
            "es-DO": "Latn",
            "sma-SE": "Latn",
            "en-JM": "Latn",
            "es-VE": "Latn",
            "sms-FI": "Latn",
            "en-029": "Latn",
            "es-CO": "Latn",
            "sr-Latn-RS": "Latn",
            "smn-FI": "Latn",
            "en-BZ": "Latn",
            "es-PE": "Latn",
            "en-TT": "Latn",
            "es-AR": "Latn",
            "sr-Latn-ME": "Latn",
            "en-ZW": "Latn",
            "es-EC": "Latn",
            "en-PH": "Latn",
            "es-CL": "Latn",
            "es-UY": "Latn",
            "es-PY": "Latn",
            "en-IN": "Latn",
            "es-BO": "Latn",
            "ca-ES": "Latn",
            "cs-CZ": "Latn",
            "da-DK": "Latn",
            "de-DE": "Latn",
            "en-US": "Latn",
            "es-ES": "Latn",
            "fi-FI": "Latn",
            "fr-FR": "Latn",
            "hu-HU": "Latn",
            "is-IS": "Latn",
            "it-IT": "Latn",
            "nl-NL": "Latn",
            "nb-NO": "Latn",
            "pl-PL": "Latn",
            "pt-BR": "Latn",
            "rm-CH": "Latn",
            "ro-RO": "Latn",
            "hr-HR": "Latn",
            "sk-SK": "Latn",
            "sq-AL": "Latn",
            "sv-SE": "Latn",
            "tr-TR": "Latn",
            "id-ID": "Latn",
            "sl-SI": "Latn",
            "et-EE": "Latn",
            "lv-LV": "Latn",
            "lt-LT": "Latn",
            "az-Latn-AZ": "Latn",
            "eu-ES": "Latn",
            "hsb-DE": "Latn",
            "tn-ZA": "Latn",
            "xh-ZA": "Latn",
            "zu-ZA": "Latn",
            "af-ZA": "Latn",
            "fo-FO": "Latn",
            "mt-MT": "Latn",
            "se-NO": "Latn",
            "ms-MY": "Latn",
            "en-MY": "Latn",
            "es-SV": "Latn",
            "sw-KE": "Latn",
            "tk-TM": "Latn",
            "uz-Latn-UZ": "Latn",
            "cy-GB": "Latn",
            "gl-ES": "Latn",
            "fy-NL": "Latn",
            "fil-PH": "Latn",
            "ha-Latn-NG": "Latn",
            "yo-NG": "Latn",
            "quz-BO": "Latn",
            "nso-ZA": "Latn",
            "lb-LU": "Latn",
            "kl-GL": "Latn",
            "ig-NG": "Latn",
            "arn-CL": "Latn",
            "moh-CA": "Latn",
            "br-FR": "Latn",
            "en-SG": "Latn",
            "es-HN": "Latn",
            "mi-NZ": "Latn",
            "oc-FR": "Latn",
            "co-FR": "Latn",
            "gsw-FR": "Latn",
            "qut-GT": "Latn",
            "rw-RW": "Latn",
            "wo-SN": "Latn",
            "gd-GB": "Latn",
            "es-NI": "Latn",
            "es-PR": "Latn",
            "es-US": "Latn",
            "de-CH": "Latn",
            "en-GB": "Latn",
            "es-MX": "Latn",
            "fr-BE": "Latn",
            "it-CH": "Latn",
            "nl-BE": "Latn",
            "nn-NO": "Latn",
            "pt-PT": "Latn",
            "sr-Latn-CS": "Latn",
            "sv-FI": "Latn",
            "dsb-DE": "Latn",
            "se-SE": "Latn",
            "ga-IE": "Latn",
            "ms-BN": "Latn",
            "iu-Latn-CA": "Latn",
            "tzm-Latn-DZ": "Latn",
            "quz-EC": "Latn",
            "de-AT": "Latn",
            "en-AU": "Latn",
            "fr-CA": "Latn",
            "se-FI": "Latn",
            "quz-PE": "Latn",
            "ml-IN": "Mlym",
            "mn-Mong-CN": "Mong",
            "or-IN": "Orya",
            "si-LK": "Sinh",
            "syr-SY": "Syrc",
            "ta-IN": "Taml",
            "te-IN": "Telu",
            "dv-MV": "Thaa",
            "th-TH": "Thai",
            "bo-CN": "Tibt",
            "ug-CN": "Uigh",
            "vi-VN": "Viet",
            "ii-CN": "Yiii"
        };
        class ThemeFontScheme {
            constructor() {
                this.name = "", this.minorFont = new ThemeFontSchemePart, this.majorFont = new ThemeFontSchemePart;
            }
            get isValidate() {
                return !utils_string.StringUtils.isNullOrEmpty(this.name) && this.minorFont.isValid && this.majorFont.isValid;
            }
            getTypeface(schemeStyle, currentUICulture) {
                return schemeStyle == XlFontSchemeStyles.None ? "" : schemeStyle == XlFontSchemeStyles.Minor ? this.minorFont.getTypeface(currentUICulture) : this.majorFont.getTypeface(currentUICulture);
            }
            copyFrom(sourceObj) {
                this.name = sourceObj.name, this.majorFont.copyFrom(sourceObj.majorFont), this.minorFont.copyFrom(sourceObj.minorFont);
            }
            clear() {
                this.name = "", this.majorFont.clear(), this.minorFont.clear();
            }
        }
        class ThemeFormatScheme {
            constructor() {
                this.backgroundFillStyleList = [], this.fillStyleList = [], this.lineStyleList = [], 
                this.effectStyleList = [], this.name = "";
            }
            get isValidate() {
                return this.checkValidation();
            }
            getOutlineByType(type) {
                return this.getElementByType(type, this.lineStyleList);
            }
            getOutlineByIndex(index) {
                return this.getElementByIndex(index, this.lineStyleList);
            }
            getFillByType(type) {
                return this.getElementByType(type, this.fillStyleList);
            }
            getFillByIndex(index) {
                return index < 1e3 ? this.getElementByIndex(index, this.fillStyleList) : this.getElementByIndex(index - 1e3, this.backgroundFillStyleList);
            }
            getEffectStyle(type) {
                return this.getElementByType(type, this.effectStyleList);
            }
            getElementByType(type, items) {
                return type == StyleMatrixElementType.Subtle ? items[0] : type == StyleMatrixElementType.Moderate ? items[1] : type == StyleMatrixElementType.Intense ? items[2] : null;
            }
            getElementByIndex(index, items) {
                const count = items.length;
                return index < 1 || 0 == count ? null : items[Math.min(index, count) - 1];
            }
            checkValidation() {
                return this.backgroundFillStyleList.length >= 3 && this.fillStyleList.length >= 3 && this.lineStyleList.length >= 3 && this.effectStyleList.length >= 3;
            }
            copyFrom(obj) {
                this.clear(), this.name = obj.name, this.backgroundFillStyleList = utils_list.ListUtils.map(obj.backgroundFillStyleList, (e => e.clone())), 
                this.fillStyleList = utils_list.ListUtils.map(obj.fillStyleList, (e => e.clone())), 
                this.lineStyleList = utils_list.ListUtils.map(obj.lineStyleList, (e => e.clone())), 
                this.effectStyleList = utils_list.ListUtils.map(obj.effectStyleList, (e => e.clone()));
            }
            clear() {
                this.name = "", utils_list.ListUtils.clear(this.backgroundFillStyleList), utils_list.ListUtils.clear(this.fillStyleList), 
                utils_list.ListUtils.clear(this.lineStyleList), utils_list.ListUtils.clear(this.effectStyleList);
            }
        }
        class OfficeTheme {
            constructor() {
                this.name = "", this.colors = new ThemeDrawingColorCollection, this.fontScheme = new ThemeFontScheme, 
                this.formatScheme = new ThemeFormatScheme;
            }
            get isValidate() {
                return !utils_string.StringUtils.isNullOrEmpty(this.name) && this.colors.isValidate && this.fontScheme.isValidate && this.formatScheme.isValidate;
            }
            copyFrom(sourceObj) {
                this.name = sourceObj.name, this.colors.copyFrom(sourceObj.colors), this.fontScheme.copyFrom(sourceObj.fontScheme), 
                this.formatScheme.copyFrom(sourceObj.formatScheme);
            }
            clear() {
                this.name = "", this.colors.clear(), this.fontScheme.clear(), this.formatScheme.clear();
            }
            clone() {
                var result = new OfficeTheme;
                return result.copyFrom(this), result;
            }
        }
        var SubDocumentInfoType, JSONModelPropertyProperty, JSONDocumentModelProperty, JSONDocumentProtectionPropertiesProperty, DocumentProtectionType, JSONDocumentPropertiesProperty, JSONCompatibilitySettingsProperty, HashAlgorithmType, CryptProviderType, DigitType, constants = __webpack_require__(8785);
        class ColorDistanceInfo {
            constructor(distance, colorIndex) {
                this.distance = distance, this.colorIndex = colorIndex;
            }
            static comparator(a, b) {
                return a.distance - b.distance;
            }
        }
        class ColorDifference {
            static RGB(x, y) {
                return Math.sqrt(Math.pow((utils_color.i.getRed(x) - utils_color.i.getRed(y)) / 255, 2) + Math.pow((utils_color.i.getGreen(x) - utils_color.i.getGreen(y)) / 255, 2) + Math.pow((utils_color.i.getBlue(x) - utils_color.i.getBlue(y)) / 255, 2));
            }
            static HSB(x, y) {
                const xHSL = ColorHSL.fromColorRGB(x), yHSL = ColorHSL.fromColorRGB(y);
                let deltaH = Math.abs(xHSL.hue - yHSL.hue);
                deltaH > 180 && (deltaH = 360 - deltaH), deltaH /= 57.3;
                return 3 * Math.abs(xHSL.luminance - yHSL.luminance) + deltaH + 1.5 * Math.abs(xHSL.saturation - yHSL.saturation);
            }
        }
        class Palette {
            constructor() {
                this.reset();
            }
            getColorByIndex(index) {
                const color = this.colorTable[index];
                if (void 0 === color) throw new Error(errors.D.InternalException);
                return color;
            }
            setColor(index, color) {
                const oldColor = this.colorTable[index];
                if (void 0 === oldColor) throw new Error(errors.D.InternalException);
                oldColor != color && (this.isCustomIndexedColorTable = !0, this.colorTable[index] = color);
            }
            reset() {
                const sbc = DXSystemColors.scrollBar;
                this.colorTable = {
                    0: utils_color.i.fromArgbNumber(0, 0, 0, 0),
                    1: utils_color.i.fromArgbNumber(0, 255, 255, 255),
                    2: utils_color.i.fromArgbNumber(0, 255, 0, 0),
                    3: utils_color.i.fromArgbNumber(0, 0, 255, 0),
                    4: utils_color.i.fromArgbNumber(0, 0, 0, 255),
                    5: utils_color.i.fromArgbNumber(0, 255, 255, 0),
                    6: utils_color.i.fromArgbNumber(0, 255, 0, 255),
                    7: utils_color.i.fromArgbNumber(0, 0, 255, 255),
                    8: utils_color.i.fromArgbNumber(0, 0, 0, 0),
                    9: utils_color.i.fromArgbNumber(0, 255, 255, 255),
                    10: utils_color.i.fromArgbNumber(0, 255, 0, 0),
                    11: utils_color.i.fromArgbNumber(0, 0, 255, 0),
                    12: utils_color.i.fromArgbNumber(0, 0, 0, 255),
                    13: utils_color.i.fromArgbNumber(0, 255, 255, 0),
                    14: utils_color.i.fromArgbNumber(0, 255, 0, 255),
                    15: utils_color.i.fromArgbNumber(0, 0, 255, 255),
                    16: utils_color.i.fromArgbNumber(0, 128, 0, 0),
                    17: utils_color.i.fromArgbNumber(0, 0, 128, 0),
                    18: utils_color.i.fromArgbNumber(0, 0, 0, 128),
                    19: utils_color.i.fromArgbNumber(0, 128, 128, 0),
                    20: utils_color.i.fromArgbNumber(0, 128, 0, 128),
                    21: utils_color.i.fromArgbNumber(0, 0, 128, 128),
                    22: utils_color.i.fromArgbNumber(0, 192, 192, 192),
                    23: utils_color.i.fromArgbNumber(0, 128, 128, 128),
                    24: utils_color.i.fromArgbNumber(0, 153, 153, 255),
                    25: utils_color.i.fromArgbNumber(0, 153, 51, 102),
                    26: utils_color.i.fromArgbNumber(0, 255, 255, 204),
                    27: utils_color.i.fromArgbNumber(0, 204, 255, 255),
                    28: utils_color.i.fromArgbNumber(0, 102, 0, 102),
                    29: utils_color.i.fromArgbNumber(0, 255, 128, 128),
                    30: utils_color.i.fromArgbNumber(0, 0, 102, 204),
                    31: utils_color.i.fromArgbNumber(0, 204, 204, 255),
                    32: utils_color.i.fromArgbNumber(0, 0, 0, 128),
                    33: utils_color.i.fromArgbNumber(0, 255, 0, 255),
                    34: utils_color.i.fromArgbNumber(0, 255, 255, 0),
                    35: utils_color.i.fromArgbNumber(0, 0, 255, 255),
                    36: utils_color.i.fromArgbNumber(0, 128, 0, 128),
                    37: utils_color.i.fromArgbNumber(0, 128, 0, 0),
                    38: utils_color.i.fromArgbNumber(0, 0, 128, 128),
                    39: utils_color.i.fromArgbNumber(0, 0, 0, 255),
                    40: utils_color.i.fromArgbNumber(0, 0, 204, 255),
                    41: utils_color.i.fromArgbNumber(0, 204, 255, 255),
                    42: utils_color.i.fromArgbNumber(0, 204, 255, 204),
                    43: utils_color.i.fromArgbNumber(0, 255, 255, 153),
                    44: utils_color.i.fromArgbNumber(0, 153, 204, 255),
                    45: utils_color.i.fromArgbNumber(0, 255, 153, 204),
                    46: utils_color.i.fromArgbNumber(0, 204, 153, 255),
                    47: utils_color.i.fromArgbNumber(0, 255, 204, 153),
                    48: utils_color.i.fromArgbNumber(0, 51, 102, 255),
                    49: utils_color.i.fromArgbNumber(0, 51, 204, 204),
                    50: utils_color.i.fromArgbNumber(0, 153, 204, 0),
                    51: utils_color.i.fromArgbNumber(0, 255, 204, 0),
                    52: utils_color.i.fromArgbNumber(0, 255, 153, 0),
                    53: utils_color.i.fromArgbNumber(0, 255, 102, 0),
                    54: utils_color.i.fromArgbNumber(0, 102, 102, 153),
                    55: utils_color.i.fromArgbNumber(0, 150, 150, 150),
                    56: utils_color.i.fromArgbNumber(0, 0, 51, 102),
                    57: utils_color.i.fromArgbNumber(0, 51, 153, 102),
                    58: utils_color.i.fromArgbNumber(0, 0, 51, 0),
                    59: utils_color.i.fromArgbNumber(0, 51, 51, 0),
                    60: utils_color.i.fromArgbNumber(0, 153, 51, 0),
                    61: utils_color.i.fromArgbNumber(0, 153, 51, 102),
                    62: utils_color.i.fromArgbNumber(0, 51, 51, 153),
                    63: utils_color.i.fromArgbNumber(0, 51, 51, 51),
                    [Palette.SystemWindowFrameColorIndex]: DXSystemColors.windowFrame,
                    [Palette.System3DFaceColorIndex]: DXSystemColors.control,
                    [Palette.System3DTextColorIndex]: DXSystemColors.controlText,
                    [Palette.System3DHighlightColorIndex]: DXSystemColors.controlLight,
                    [Palette.System3DShadowColorIndex]: DXSystemColors.controlDark,
                    [Palette.SystemHighlightColorIndex]: DXSystemColors.highlight,
                    [Palette.SystemControlTextColorIndex]: DXSystemColors.controlText,
                    [Palette.SystemControlScrollColorIndex]: sbc,
                    [Palette.SystemControlInverseColorIndex]: DXColor.fromArgb(0, sbc),
                    [Palette.SystemControlBodyColorIndex]: DXSystemColors.window,
                    [Palette.SystemControlFrameColorIndex]: DXSystemColors.windowFrame,
                    [Palette.DefaultForegroundColorIndex]: DXSystemColors.windowText,
                    [Palette.DefaultBackgroundColorIndex]: DXSystemColors.window,
                    [Palette.DefaultChartForegroundColorIndex]: utils_color.i.fromArgbNumber(0, 0, 0, 0),
                    [Palette.DefaultChartBackgroundColorIndex]: utils_color.i.fromArgbNumber(0, 255, 255, 255),
                    [Palette.ChartNeutralColorIndex]: utils_color.i.fromArgbNumber(0, 0, 0, 0),
                    [Palette.ToolTipFillColorIndex]: DXSystemColors.info,
                    [Palette.ToolTipTextColorIndex]: DXSystemColors.infoText,
                    [Palette.FontAutomaticColorIndex]: DXColor.empty
                };
            }
            get defaultForegroundColor() {
                return this.colorTable[Palette.DefaultForegroundColorIndex];
            }
            set defaultForegroundColor(val) {
                this.colorTable[Palette.DefaultForegroundColorIndex] = val;
            }
            get defaultBackgroundColor() {
                return this.colorTable[Palette.DefaultBackgroundColorIndex];
            }
            set defaultBackgroundColor(val) {
                this.colorTable[Palette.DefaultBackgroundColorIndex] = val;
            }
            get defaultChartForegroundColor() {
                return this.colorTable[Palette.DefaultChartForegroundColorIndex];
            }
            set defaultChartForegroundColor(val) {
                this.colorTable[Palette.DefaultChartForegroundColorIndex] = val;
            }
            get defaultChartBackgroundColor() {
                return this.colorTable[Palette.DefaultChartBackgroundColorIndex];
            }
            set defaultChartBackgroundColor(val) {
                this.colorTable[Palette.DefaultChartBackgroundColorIndex] = val;
            }
            get chartNeutralColor() {
                return this.colorTable[Palette.ChartNeutralColorIndex];
            }
            get toolTipTextColor() {
                return this.colorTable[Palette.ToolTipTextColorIndex];
            }
            set toolTipTextColor(val) {
                this.colorTable[Palette.ToolTipTextColorIndex] = val;
            }
            get fontAutomaticColor() {
                return this.colorTable[Palette.FontAutomaticColorIndex];
            }
            set fontAutomaticColor(val) {
                this.colorTable[Palette.FontAutomaticColorIndex] = val;
            }
            isValidColorIndex(index) {
                return void 0 !== this.colorTable[index];
            }
            getColorIndex(colorProvider, colorInfo, foreground) {
                return ColorModelInfoCache.defaultItem.equals(colorInfo) || colorInfo.colorType == ColorType.Auto ? foreground ? Palette.DefaultForegroundColorIndex : Palette.DefaultBackgroundColorIndex : colorInfo.colorType == ColorType.Index ? this.isValidColorIndex(colorInfo.colorIndex) ? colorInfo.colorIndex : foreground ? Palette.DefaultForegroundColorIndex : Palette.DefaultBackgroundColorIndex : this.getPaletteNearestColorIndex(colorInfo.toRgb(colorProvider));
            }
            getFontColorIndex(colorProvider, colorInfo) {
                return colorInfo.colorType == ColorType.Auto ? Palette.FontAutomaticColorIndex : colorInfo.colorType == ColorType.Index ? this.isValidColorIndex(colorInfo.colorIndex) ? colorInfo.colorIndex : Palette.FontAutomaticColorIndex : this.getPaletteNearestColorIndex(colorInfo.toRgb(colorProvider));
            }
            getColorIndexByRgbColor(color) {
                let index = this.getExactColorIndex(color, new boundary.e(0, Palette.FontAutomaticColorIndex + 1));
                return -1 != index || 255 == utils_color.i.getAlpha(color) && (color = DXColor.fromArgb(0, color), 
                index = this.getExactColorIndex(color, new boundary.e(0, Palette.FontAutomaticColorIndex + 1)), 
                -1 != index) ? index : Palette.DefaultForegroundColorIndex;
            }
            getExactColorIndex(color, indexInterval) {
                const index = number.j.keyBy(this.colorTable, ((value, key) => indexInterval.contains(key) && value == color));
                return null === index ? -1 : index;
            }
            getNearestColorIndex(color) {
                const nearest = this.getExactColorIndex(color, new boundary.e(0, 64));
                return -1 != nearest ? nearest : this.getNearestColorIndexCore(color, new boundary.e(0, 64));
            }
            getPaletteNearestColorIndex(color) {
                const nearest = this.getExactColorIndex(color, new boundary.e(8, 63));
                return -1 != nearest ? nearest : this.getNearestColorIndexCore(color, new boundary.e(8, 64));
            }
            isCompatibleColors(x, y) {
                return utils_color.i.isGray(x) == utils_color.i.isGray(y);
            }
            getColorDistance(x, y, rgbWeight) {
                return ColorDifference.HSB(x, y) + ColorDifference.RGB(x, y) * rgbWeight;
            }
            getNearestColorIndexCore(color, indexInterval) {
                const items = [];
                number.j.forEach(this.colorTable, ((value, key) => {
                    indexInterval.contains(key) && this.isCompatibleColors(value, color) && items.push(new ColorDistanceInfo(this.getColorDistance(color, value, 3), key));
                })), items.sort(ColorDistanceInfo.comparator);
                items.length > 5 && items.splice(5);
                let nearest = -1, distance = constants.Constants.MAX_SAFE_INTEGER;
                for (let item of items) if (-1 == nearest) nearest = item.colorIndex, distance = this.getColorDistance(color, this.colorTable[item.colorIndex], 1.5); else {
                    const d = this.getColorDistance(color, this.colorTable[item.colorIndex], 1.5);
                    d < distance && (nearest = item.colorIndex, distance = d);
                }
                return nearest;
            }
            clone() {
                const result = new Palette;
                return result.isCustomIndexedColorTable = this.isCustomIndexedColorTable, result.colorTable = number.j.shallowCopy(this.colorTable), 
                result;
            }
        }
        Palette.BuiltInColorsCount = 8, Palette.DefaultForegroundColorIndex = 64, Palette.DefaultBackgroundColorIndex = 65, 
        Palette.SystemWindowFrameColorIndex = 66, Palette.System3DFaceColorIndex = 67, Palette.System3DTextColorIndex = 68, 
        Palette.System3DHighlightColorIndex = 69, Palette.System3DShadowColorIndex = 70, 
        Palette.SystemHighlightColorIndex = 71, Palette.SystemControlTextColorIndex = 72, 
        Palette.SystemControlScrollColorIndex = 73, Palette.SystemControlInverseColorIndex = 74, 
        Palette.SystemControlBodyColorIndex = 75, Palette.SystemControlFrameColorIndex = 76, 
        Palette.DefaultChartForegroundColorIndex = 77, Palette.DefaultChartBackgroundColorIndex = 78, 
        Palette.ChartNeutralColorIndex = 79, Palette.ToolTipFillColorIndex = 80, Palette.ToolTipTextColorIndex = 81, 
        Palette.FontAutomaticColorIndex = 32767;
        class ColorProvider {
            constructor(colorModelInfoCache) {
                this.rangePermissionColors = {}, this.rangePermissionColorIndex = 0, this.colorModelInfoCache = colorModelInfoCache, 
                this.officeTheme = new OfficeTheme, this.palette = new Palette;
            }
            getRgbaFromModelColor(color) {
                return color.toRgb(this);
            }
            getModelColorFromRgba(rgba) {
                return this.colorModelInfoCache.getItem(color_model_info_ColorModelInfo.makeByColor(rgba));
            }
            getColor() {
                this.rangePermissionColorIndex >= DocumentProtectionSettings.defaultColors.length && (this.rangePermissionColorIndex = 0);
                const result = DocumentProtectionSettings.defaultColors[this.rangePermissionColorIndex];
                return this.rangePermissionColorIndex++, result;
            }
            clone(colorModelInfoCache) {
                const result = new ColorProvider(colorModelInfoCache);
                return result.officeTheme = this.officeTheme.clone(), result.palette = this.palette.clone(), 
                result.rangePermissionColors = string.StringMapUtils.map(this.rangePermissionColors, (val => "" + val)), 
                result;
            }
        }
        !function(SubDocumentInfoType) {
            SubDocumentInfoType[SubDocumentInfoType.Main = 0] = "Main", SubDocumentInfoType[SubDocumentInfoType.Header = 1] = "Header", 
            SubDocumentInfoType[SubDocumentInfoType.Footer = 2] = "Footer", SubDocumentInfoType[SubDocumentInfoType.TextBox = 3] = "TextBox";
        }(SubDocumentInfoType || (SubDocumentInfoType = {})), function(JSONModelPropertyProperty) {
            JSONModelPropertyProperty[JSONModelPropertyProperty.DefaultTabWidth = 0] = "DefaultTabWidth", 
            JSONModelPropertyProperty[JSONModelPropertyProperty.OddEvenPages = 1] = "OddEvenPages", 
            JSONModelPropertyProperty[JSONModelPropertyProperty.PageColor = 2] = "PageColor";
        }(JSONModelPropertyProperty || (JSONModelPropertyProperty = {})), function(JSONDocumentModelProperty) {
            JSONDocumentModelProperty[JSONDocumentModelProperty.DocumentProperties = 0] = "DocumentProperties", 
            JSONDocumentModelProperty[JSONDocumentModelProperty.Styles = 1] = "Styles", JSONDocumentModelProperty[JSONDocumentModelProperty.Sections = 2] = "Sections", 
            JSONDocumentModelProperty[JSONDocumentModelProperty.AbstractNumberingLists = 3] = "AbstractNumberingLists", 
            JSONDocumentModelProperty[JSONDocumentModelProperty.NumberingLists = 4] = "NumberingLists", 
            JSONDocumentModelProperty[JSONDocumentModelProperty.Headers = 5] = "Headers", JSONDocumentModelProperty[JSONDocumentModelProperty.Footers = 6] = "Footers", 
            JSONDocumentModelProperty[JSONDocumentModelProperty.AbstractNumberingListTemplates = 7] = "AbstractNumberingListTemplates", 
            JSONDocumentModelProperty[JSONDocumentModelProperty.Images = 8] = "Images", JSONDocumentModelProperty[JSONDocumentModelProperty.PaletteColors = 9] = "PaletteColors", 
            JSONDocumentModelProperty[JSONDocumentModelProperty.OfficeThemeColors = 10] = "OfficeThemeColors", 
            JSONDocumentModelProperty[JSONDocumentModelProperty.CompatibilitySettings = 11] = "CompatibilitySettings";
        }(JSONDocumentModelProperty || (JSONDocumentModelProperty = {})), function(JSONDocumentProtectionPropertiesProperty) {
            JSONDocumentProtectionPropertiesProperty[JSONDocumentProtectionPropertiesProperty.EnforceProtection = 0] = "EnforceProtection", 
            JSONDocumentProtectionPropertiesProperty[JSONDocumentProtectionPropertiesProperty.ProtectionType = 1] = "ProtectionType", 
            JSONDocumentProtectionPropertiesProperty[JSONDocumentProtectionPropertiesProperty.HashAlgorithmType = 2] = "HashAlgorithmType", 
            JSONDocumentProtectionPropertiesProperty[JSONDocumentProtectionPropertiesProperty.HashIterationCount = 3] = "HashIterationCount", 
            JSONDocumentProtectionPropertiesProperty[JSONDocumentProtectionPropertiesProperty.PasswordHash = 4] = "PasswordHash", 
            JSONDocumentProtectionPropertiesProperty[JSONDocumentProtectionPropertiesProperty.PasswordPrefix = 5] = "PasswordPrefix", 
            JSONDocumentProtectionPropertiesProperty[JSONDocumentProtectionPropertiesProperty.Word2003PasswordHash = 6] = "Word2003PasswordHash", 
            JSONDocumentProtectionPropertiesProperty[JSONDocumentProtectionPropertiesProperty.OpenOfficePasswordHash = 7] = "OpenOfficePasswordHash";
        }(JSONDocumentProtectionPropertiesProperty || (JSONDocumentProtectionPropertiesProperty = {})), 
        function(DocumentProtectionType) {
            DocumentProtectionType[DocumentProtectionType.None = 0] = "None", DocumentProtectionType[DocumentProtectionType.ReadOnly = 1] = "ReadOnly", 
            DocumentProtectionType[DocumentProtectionType.AllowComments = 2] = "AllowComments", 
            DocumentProtectionType[DocumentProtectionType.TrackedChanges = 3] = "TrackedChanges";
        }(DocumentProtectionType || (DocumentProtectionType = {})), function(JSONDocumentPropertiesProperty) {
            JSONDocumentPropertiesProperty[JSONDocumentPropertiesProperty.DefaultTabWidth = 0] = "DefaultTabWidth", 
            JSONDocumentPropertiesProperty[JSONDocumentPropertiesProperty.DifferentOddAndEvenPages = 1] = "DifferentOddAndEvenPages", 
            JSONDocumentPropertiesProperty[JSONDocumentPropertiesProperty.DisplayBackgroundShape = 2] = "DisplayBackgroundShape", 
            JSONDocumentPropertiesProperty[JSONDocumentPropertiesProperty.PageBackColor = 3] = "PageBackColor", 
            JSONDocumentPropertiesProperty[JSONDocumentPropertiesProperty.DefaultCharacterProperties = 4] = "DefaultCharacterProperties", 
            JSONDocumentPropertiesProperty[JSONDocumentPropertiesProperty.DefaultParagraphProperties = 5] = "DefaultParagraphProperties", 
            JSONDocumentPropertiesProperty[JSONDocumentPropertiesProperty.DefaultTableProperties = 6] = "DefaultTableProperties", 
            JSONDocumentPropertiesProperty[JSONDocumentPropertiesProperty.DefaultTableRowProperties = 7] = "DefaultTableRowProperties", 
            JSONDocumentPropertiesProperty[JSONDocumentPropertiesProperty.DefaultTableCellProperties = 8] = "DefaultTableCellProperties", 
            JSONDocumentPropertiesProperty[JSONDocumentPropertiesProperty.ProtectionProperties = 9] = "ProtectionProperties";
        }(JSONDocumentPropertiesProperty || (JSONDocumentPropertiesProperty = {})), function(JSONCompatibilitySettingsProperty) {
            JSONCompatibilitySettingsProperty[JSONCompatibilitySettingsProperty.DontJustifyLinesEndingInSoftLineBreak = 0] = "DontJustifyLinesEndingInSoftLineBreak", 
            JSONCompatibilitySettingsProperty[JSONCompatibilitySettingsProperty.CompatibilityMode = 1] = "CompatibilityMode";
        }(JSONCompatibilitySettingsProperty || (JSONCompatibilitySettingsProperty = {}));
        class JSONMaskedCharacterPropertiesConverter {
            static convertFromJSON(obj, colorModelInfoCache, shadingInfoCache, fontCache) {
                var result = new MaskedCharacterProperties;
                return result.fontSize = obj[JSONCharacterFormattingProperty.Size], result.fontBold = !!obj[JSONCharacterFormattingProperty.Bold], 
                result.fontItalic = !!obj[JSONCharacterFormattingProperty.Italic], result.fontStrikeoutType = obj[JSONCharacterFormattingProperty.StrikeoutType], 
                result.fontUnderlineType = obj[JSONCharacterFormattingProperty.UnderlineType], result.allCaps = !!obj[JSONCharacterFormattingProperty.AllCaps], 
                result.smallCaps = !!obj[JSONCharacterFormattingProperty.SmallCaps], result.strikeoutWordsOnly = !!obj[JSONCharacterFormattingProperty.StrikeoutWordsOnly], 
                result.underlineWordsOnly = !!obj[JSONCharacterFormattingProperty.UnderlineWordsOnly], 
                result.script = obj[JSONCharacterFormattingProperty.Script], result.hidden = !!obj[JSONCharacterFormattingProperty.Hidden], 
                result.noProof = !!obj[JSONCharacterFormattingProperty.NoProof], result.setUseValueFull(obj[JSONCharacterFormattingProperty.UseValue]), 
                result.langInfo = JSONLangInfoConverter.convertFromJSON(obj[JSONCharacterFormattingProperty.LangInfo]), 
                result.fontInfo = fontCache instanceof FontInfoCache ? fontCache.getItemByJsonKey(obj[JSONCharacterFormattingProperty.FontInfoIndex]) : fontCache(obj[JSONCharacterFormattingProperty.FontInfoIndex]), 
                result.textColor = colorModelInfoCache.getItemByJsonKey(obj[JSONCharacterFormattingProperty.TextColorIndex]), 
                result.shadingInfo = shadingInfoCache.getItemByJsonKey(obj[JSONCharacterFormattingProperty.ShadingInfoIndex]), 
                result.highlightColor = colorModelInfoCache.getItemByJsonKey(obj[JSONCharacterFormattingProperty.HighlightColorIndex]), 
                result.underlineColor = colorModelInfoCache.getItemByJsonKey(obj[JSONCharacterFormattingProperty.UnderlineColorIndex]), 
                result.strikeoutColor = colorModelInfoCache.getItemByJsonKey(obj[JSONCharacterFormattingProperty.StrikeoutColorIndex]), 
                result;
            }
            static convertToJSON(source) {
                var result = {};
                return result[JSONCharacterFormattingProperty.FontName] = source.fontInfo.name, 
                result[JSONCharacterFormattingProperty.Size] = source.fontSize, result[JSONCharacterFormattingProperty.Bold] = (0, 
                common.boolToInt)(source.fontBold), result[JSONCharacterFormattingProperty.Italic] = (0, 
                common.boolToInt)(source.fontItalic), result[JSONCharacterFormattingProperty.StrikeoutType] = source.fontStrikeoutType, 
                result[JSONCharacterFormattingProperty.UnderlineType] = source.fontUnderlineType, 
                result[JSONCharacterFormattingProperty.AllCaps] = (0, common.boolToInt)(source.allCaps), 
                result[JSONCharacterFormattingProperty.SmallCaps] = (0, common.boolToInt)(source.smallCaps), 
                result[JSONCharacterFormattingProperty.StrikeoutWordsOnly] = (0, common.boolToInt)(source.strikeoutWordsOnly), 
                result[JSONCharacterFormattingProperty.UnderlineWordsOnly] = (0, common.boolToInt)(source.underlineWordsOnly), 
                result[JSONCharacterFormattingProperty.TextColor] = JSONColorModelInfoConverter.convertToJSON(source.textColor), 
                result[JSONCharacterFormattingProperty.ShadingInfo] = JSONShadingInfoConverter.convertToJSON(source.shadingInfo), 
                result[JSONCharacterFormattingProperty.HighlightColor] = JSONColorModelInfoConverter.convertToJSON(source.highlightColor), 
                result[JSONCharacterFormattingProperty.UnderlineColor] = JSONColorModelInfoConverter.convertToJSON(source.underlineColor), 
                result[JSONCharacterFormattingProperty.StrikeoutColor] = JSONColorModelInfoConverter.convertToJSON(source.strikeoutColor), 
                result[JSONCharacterFormattingProperty.Script] = source.script, result[JSONCharacterFormattingProperty.Hidden] = (0, 
                common.boolToInt)(source.hidden), result[JSONCharacterFormattingProperty.NoProof] = (0, 
                common.boolToInt)(source.noProof), result[JSONCharacterFormattingProperty.UseValue] = source.getUseValueFull(), 
                result[JSONCharacterFormattingProperty.LangInfo] = JSONLangInfoConverter.convertToJSON(source.langInfo), 
                result;
            }
        }
        class JSONLangInfoConverter {
            static convertFromJSON(obj) {
                const result = new LangInfo;
                return result.bidi = obj[JSONLangInfoProperty.Bidi] || "", result.eastAsia = obj[JSONLangInfoProperty.EastAsia] || "", 
                result.latin = obj[JSONLangInfoProperty.Latin] || "", result;
            }
            static convertToJSON(source) {
                const result = {};
                return result[JSONLangInfoProperty.Bidi] = source ? source.bidi : "", result[JSONLangInfoProperty.EastAsia] = source ? source.eastAsia : "", 
                result[JSONLangInfoProperty.Latin] = source ? source.latin : "", result;
            }
        }
        class JSONBorderInfoConverter {
            static convertFromJSON(obj, colorModelInfoCache) {
                const result = new BorderInfo;
                return result.style = obj[JSONBorderBaseProperty.Style], result.color = colorModelInfoCache.getItemByJsonKey(obj[JSONBorderBaseProperty.ColorIndex]), 
                result.color || (result.color = JSONColorModelInfoConverter.convertFromJSON(obj[JSONBorderBaseProperty.Color])), 
                result.width = obj[JSONBorderBaseProperty.Width], result.offset = obj[JSONBorderBaseProperty.Offset], 
                result.frame = !!obj[JSONBorderBaseProperty.Frame], result.shadow = !!obj[JSONBorderBaseProperty.Shadow], 
                result;
            }
            static convertToJSON(source) {
                const result = {};
                return result[JSONBorderBaseProperty.Style] = source.style, result[JSONBorderBaseProperty.Color] = JSONColorModelInfoConverter.convertToJSON(source.color), 
                result[JSONBorderBaseProperty.Width] = source.width, result[JSONBorderBaseProperty.Offset] = source.offset, 
                result[JSONBorderBaseProperty.Frame] = (0, common.boolToInt)(source.frame), result[JSONBorderBaseProperty.Shadow] = (0, 
                common.boolToInt)(source.shadow), result;
            }
        }
        class json_masked_paragraph_properties_converter_JSONMaskedParagraphPropertiesConverter {
            static convertFromJSON(obj, colorModelInfoCache, shadingInfoCache) {
                var result = new MaskedParagraphProperties;
                return result.alignment = obj[JSONParagraphFormattingProperty.Alignment], result.firstLineIndent = obj[JSONParagraphFormattingProperty.FirstLineIndent], 
                result.firstLineIndentType = obj[JSONParagraphFormattingProperty.FirstLineIndentType], 
                result.leftIndent = obj[JSONParagraphFormattingProperty.LeftIndent], result.lineSpacing = obj[JSONParagraphFormattingProperty.LineSpacing], 
                result.lineSpacingType = obj[JSONParagraphFormattingProperty.LineSpacingType], result.rightIndent = obj[JSONParagraphFormattingProperty.RightIndent], 
                result.spacingBefore = obj[JSONParagraphFormattingProperty.SpacingBefore], result.spacingAfter = obj[JSONParagraphFormattingProperty.SpacingAfter], 
                result.suppressHyphenation = !!obj[JSONParagraphFormattingProperty.SuppressHyphenation], 
                result.suppressLineNumbers = !!obj[JSONParagraphFormattingProperty.SuppressLineNumbers], 
                result.contextualSpacing = !!obj[JSONParagraphFormattingProperty.ContextualSpacing], 
                result.pageBreakBefore = !!obj[JSONParagraphFormattingProperty.PageBreakBefore], 
                result.beforeAutoSpacing = !!obj[JSONParagraphFormattingProperty.BeforeAutoSpacing], 
                result.afterAutoSpacing = !!obj[JSONParagraphFormattingProperty.AfterAutoSpacing], 
                result.keepWithNext = !!obj[JSONParagraphFormattingProperty.KeepWithNext], result.keepLinesTogether = !!obj[JSONParagraphFormattingProperty.KeepLinesTogether], 
                result.widowOrphanControl = !!obj[JSONParagraphFormattingProperty.WidowOrphanControl], 
                result.outlineLevel = obj[JSONParagraphFormattingProperty.OutlineLevel], result.shadingInfo = shadingInfoCache.getItemByJsonKey(obj[JSONParagraphFormattingProperty.ShadingInfoIndex]), 
                result.leftBorder = JSONBorderInfoConverter.convertFromJSON(obj[JSONParagraphFormattingProperty.LeftBorder], colorModelInfoCache), 
                result.rightBorder = JSONBorderInfoConverter.convertFromJSON(obj[JSONParagraphFormattingProperty.RightBorder], colorModelInfoCache), 
                result.topBorder = JSONBorderInfoConverter.convertFromJSON(obj[JSONParagraphFormattingProperty.TopBorder], colorModelInfoCache), 
                result.bottomBorder = JSONBorderInfoConverter.convertFromJSON(obj[JSONParagraphFormattingProperty.BottomBorder], colorModelInfoCache), 
                result.betweenBorder = JSONBorderInfoConverter.convertFromJSON(obj[JSONParagraphFormattingProperty.BetweenBorder], colorModelInfoCache), 
                result.divId = obj[JSONParagraphFormattingProperty.DivId], result.rightToLeft = obj[JSONParagraphFormattingProperty.RightToLeft], 
                result.useValue = obj[JSONParagraphFormattingProperty.UseValue], result;
            }
            static convertToJSON(source) {
                var result = {};
                return result[JSONParagraphFormattingProperty.Alignment] = source.alignment, result[JSONParagraphFormattingProperty.FirstLineIndent] = source.firstLineIndent, 
                result[JSONParagraphFormattingProperty.FirstLineIndentType] = source.firstLineIndentType, 
                result[JSONParagraphFormattingProperty.LeftIndent] = source.leftIndent, result[JSONParagraphFormattingProperty.LineSpacing] = source.lineSpacing, 
                result[JSONParagraphFormattingProperty.LineSpacingType] = source.lineSpacingType, 
                result[JSONParagraphFormattingProperty.RightIndent] = source.rightIndent, result[JSONParagraphFormattingProperty.SpacingBefore] = source.spacingBefore, 
                result[JSONParagraphFormattingProperty.SpacingAfter] = source.spacingAfter, result[JSONParagraphFormattingProperty.SuppressHyphenation] = (0, 
                common.boolToInt)(source.suppressHyphenation), result[JSONParagraphFormattingProperty.SuppressLineNumbers] = (0, 
                common.boolToInt)(source.suppressLineNumbers), result[JSONParagraphFormattingProperty.ContextualSpacing] = (0, 
                common.boolToInt)(source.contextualSpacing), result[JSONParagraphFormattingProperty.PageBreakBefore] = (0, 
                common.boolToInt)(source.pageBreakBefore), result[JSONParagraphFormattingProperty.BeforeAutoSpacing] = (0, 
                common.boolToInt)(source.beforeAutoSpacing), result[JSONParagraphFormattingProperty.AfterAutoSpacing] = (0, 
                common.boolToInt)(source.afterAutoSpacing), result[JSONParagraphFormattingProperty.KeepWithNext] = (0, 
                common.boolToInt)(source.keepWithNext), result[JSONParagraphFormattingProperty.KeepLinesTogether] = (0, 
                common.boolToInt)(source.keepLinesTogether), result[JSONParagraphFormattingProperty.WidowOrphanControl] = (0, 
                common.boolToInt)(source.widowOrphanControl), result[JSONParagraphFormattingProperty.OutlineLevel] = source.outlineLevel, 
                result[JSONParagraphFormattingProperty.ShadingInfo] = JSONShadingInfoConverter.convertToJSON(source.shadingInfo), 
                result[JSONParagraphFormattingProperty.LeftBorder] = JSONBorderInfoConverter.convertToJSON(source.leftBorder), 
                result[JSONParagraphFormattingProperty.RightBorder] = JSONBorderInfoConverter.convertToJSON(source.rightBorder), 
                result[JSONParagraphFormattingProperty.TopBorder] = JSONBorderInfoConverter.convertToJSON(source.topBorder), 
                result[JSONParagraphFormattingProperty.BottomBorder] = JSONBorderInfoConverter.convertToJSON(source.bottomBorder), 
                result[JSONParagraphFormattingProperty.BetweenBorder] = JSONBorderInfoConverter.convertToJSON(source.betweenBorder), 
                result[JSONParagraphFormattingProperty.DivId] = source.divId, result[JSONParagraphFormattingProperty.RightToLeft] = (0, 
                common.boolToInt)(source.rightToLeft), result[JSONParagraphFormattingProperty.UseValue] = source.useValue, 
                result;
            }
        }
        class NumberingListCountersCalculator {
            constructor(list) {
                this.counters = [], this.usedListIndecies = {}, this.currentParagraphIndex = -1, 
                this.list = list;
                for (var listLevel, i = 0; listLevel = this.list.levels[i]; i++) this.counters.push(listLevel.getListLevelProperties().start - 1);
            }
            calculateCounters(paragraph) {
                return this.currentParagraphIndex = -1, this.calculateNextCounters(paragraph);
            }
            calculateNextCounters(paragraph) {
                if (paragraph.subDocument.paragraphs[this.currentParagraphIndex] !== paragraph) for (var currentParagraph, abstractNumberingList = paragraph.getAbstractNumberingList(), i = this.currentParagraphIndex + 1; (currentParagraph = paragraph.subDocument.paragraphs[i]) && (this.currentParagraphIndex++, 
                this.shouldAdvanceListLevelCounters(currentParagraph, abstractNumberingList) && this.advanceListLevelCounters(currentParagraph, currentParagraph.getListLevelIndex()), 
                currentParagraph !== paragraph); i++) ;
                return this.getActualRangeCounters(paragraph.getListLevelIndex());
            }
            getLastCounters(paragraph) {
                return this.getActualRangeCounters(paragraph.getListLevelIndex());
            }
            shouldAdvanceListLevelCounters(paragraph, abstractNumberingList) {
                return paragraph.getAbstractNumberingList() === abstractNumberingList;
            }
            advanceListLevelCounters(paragraph, listLevelIndex) {
                var numberingListIndex = paragraph.getNumberingListIndex(), level = paragraph.subDocument.documentModel.numberingLists[numberingListIndex].levels[listLevelIndex];
                level.overrideStart && !this.usedListIndecies[numberingListIndex] ? (this.usedListIndecies[numberingListIndex] = !0, 
                this.counters[listLevelIndex] = level.getNewStart()) : this.counters[listLevelIndex]++, 
                this.advanceSkippedLevelCounters(listLevelIndex), this.restartNextLevelCounters(listLevelIndex);
            }
            advanceSkippedLevelCounters(listLevelIndex) {
                for (var i = 0; i < listLevelIndex; i++) {
                    var listLevel = this.list.levels[i];
                    this.counters[i] == listLevel.getListLevelProperties().start - 1 && this.counters[i]++;
                }
            }
            restartNextLevelCounters(listLevelIndex) {
                var restartedLevels = [];
                restartedLevels[listLevelIndex] = !0;
                for (var countersLength = this.counters.length, i = listLevelIndex + 1; i < countersLength; i++) {
                    var listLevelProperties = this.list.levels[i].getListLevelProperties();
                    if (!listLevelProperties.suppressRestart) {
                        var restartLevel = i - listLevelProperties.relativeRestartLevel - 1;
                        restartLevel >= 0 && restartLevel < countersLength && restartedLevels[restartLevel] && (this.counters[i] = listLevelProperties.start - 1, 
                        restartedLevels[i] = !0);
                    }
                }
            }
            getActualRangeCounters(listLevelIndex) {
                for (var rangeCounters = [], i = 0; i <= listLevelIndex; i++) rangeCounters[i] = this.counters[i];
                return rangeCounters;
            }
        }
        class ListIdProviderBase {
            constructor(documentModel) {
                this.documentModel = documentModel, this.lastId = 0;
            }
            getMap() {
                if (!this.map) {
                    this.map = {};
                    for (var list, i = 0; list = this.getLists()[i]; i++) this.map[list.innerId] = !0;
                }
                return this.map;
            }
            getNextId() {
                const map = this.getMap();
                do {
                    this.lastId++;
                } while (map[this.lastId]);
                return map[this.lastId] = !0, this.lastId;
            }
        }
        class NumberingListIdProvider extends ListIdProviderBase {
            getLists() {
                return this.documentModel.numberingLists;
            }
            clone(model) {
                const result = new NumberingListIdProvider(model);
                return result.map = number.j.shallowCopy(this.map), result;
            }
        }
        class AbstractNumberingListIdProvider extends ListIdProviderBase {
            getLists() {
                return this.documentModel.abstractNumberingLists;
            }
            clone(model) {
                const result = new AbstractNumberingListIdProvider(model);
                return result.map = number.j.shallowCopy(this.map), result;
            }
        }
        !function(HashAlgorithmType) {
            HashAlgorithmType[HashAlgorithmType.None = 0] = "None", HashAlgorithmType[HashAlgorithmType.Md2 = 1] = "Md2", 
            HashAlgorithmType[HashAlgorithmType.Md4 = 2] = "Md4", HashAlgorithmType[HashAlgorithmType.Md5 = 3] = "Md5", 
            HashAlgorithmType[HashAlgorithmType.Sha1 = 4] = "Sha1", HashAlgorithmType[HashAlgorithmType.Mac = 5] = "Mac", 
            HashAlgorithmType[HashAlgorithmType.Ripemd = 6] = "Ripemd", HashAlgorithmType[HashAlgorithmType.Ripemd160 = 7] = "Ripemd160", 
            HashAlgorithmType[HashAlgorithmType.HMac = 9] = "HMac", HashAlgorithmType[HashAlgorithmType.Sha256 = 12] = "Sha256", 
            HashAlgorithmType[HashAlgorithmType.Sha384 = 13] = "Sha384", HashAlgorithmType[HashAlgorithmType.Sha512 = 14] = "Sha512";
        }(HashAlgorithmType || (HashAlgorithmType = {})), function(CryptProviderType) {
            CryptProviderType[CryptProviderType.RsaFull = 0] = "RsaFull", CryptProviderType[CryptProviderType.RsaAES = 1] = "RsaAES";
        }(CryptProviderType || (CryptProviderType = {}));
        class DocumentProtectionProperties {
            constructor() {
                this.enforceProtection = !1;
            }
            copyFrom(obj) {
                this.enforceProtection = obj.enforceProtection, this.protectionType = obj.protectionType, 
                this.hashAlgorithmType = obj.hashAlgorithmType, this.cryptProviderType = obj.cryptProviderType, 
                this.hashIterationCount = obj.hashIterationCount, this.passwordHash = obj.passwordHash ? new Uint8Array(obj.passwordHash) : null, 
                this.passwordPrefix = obj.passwordPrefix ? new Uint8Array(obj.passwordPrefix) : null, 
                this.word2003PasswordHash = obj.word2003PasswordHash ? new Uint8Array(obj.word2003PasswordHash) : null, 
                this.openOfficePasswordHash = obj.openOfficePasswordHash ? new Uint8Array(obj.openOfficePasswordHash) : null;
            }
            clone() {
                const result = new DocumentProtectionProperties;
                return result.copyFrom(this), result;
            }
        }
        class OrdinalBasedNumberConverter {
            constructor() {
                this.maxValue = constants.Constants.MAX_SAFE_INTEGER, this.minValue = constants.Constants.MIN_SAFE_INTEGER;
            }
            convertNumber(value) {
                if (value >= this.minValue && value <= this.maxValue) return this.convertNumberCore(value);
                throw new Error("InvalidNumberConverterValue");
            }
        }
        class OrdinalLocalBasedNumberConverter extends OrdinalBasedNumberConverter {
            constructor(simpleFormattersManager) {
                super(), this.simpleFormattersManager = simpleFormattersManager, this.type = NumberingFormat.Ordinal;
            }
        }
        class OrdinalEnglishNumberConverter extends OrdinalLocalBasedNumberConverter {
            constructor(simpleFormattersManager) {
                super(simpleFormattersManager), this.ending = [ "st", "nd", "rd", "th" ];
            }
            convertNumberCore(value) {
                var temp = value % 100;
                if (temp < 21) switch (temp) {
                  case 1:
                    return this.simpleFormattersManager.formatString("{0}{1}", value, this.ending[0]);

                  case 2:
                    return this.simpleFormattersManager.formatString("{0}{1}", value, this.ending[1]);

                  case 3:
                    return this.simpleFormattersManager.formatString("{0}{1}", value, this.ending[2]);

                  default:
                    return this.simpleFormattersManager.formatString("{0}{1}", value, this.ending[3]);
                }
                return (temp = --value % 10) < 3 ? this.simpleFormattersManager.formatString("{0}{1}", value + 1, this.ending[temp % 3]) : this.simpleFormattersManager.formatString("{0}{1}", value + 1, this.ending[3]);
            }
        }
        class OrdinalFrenchNumberConverter extends OrdinalLocalBasedNumberConverter {
            constructor(simpleFormattersManager) {
                super(simpleFormattersManager);
            }
            convertNumberCore(value) {
                return 1 == value ? this.simpleFormattersManager.formatString("{0}er", value) : this.simpleFormattersManager.formatString("{0}e", value);
            }
        }
        class OrdinalGermanNumberConverter extends OrdinalLocalBasedNumberConverter {
            constructor(simpleFormattersManager) {
                super(simpleFormattersManager);
            }
            convertNumberCore(value) {
                return this.simpleFormattersManager.formatString("{0}.", value);
            }
        }
        class OrdinalItalianNumberConverter extends OrdinalLocalBasedNumberConverter {
            constructor(simpleFormattersManager) {
                super(simpleFormattersManager);
            }
            convertNumberCore(value) {
                return this.simpleFormattersManager.formatString("{0}°", value);
            }
        }
        class OrdinalTurkishNumberConverter extends OrdinalLocalBasedNumberConverter {
            constructor(simpleFormattersManager) {
                super(simpleFormattersManager);
            }
            convertNumberCore(value) {
                return this.simpleFormattersManager.formatString("{0}.", value);
            }
        }
        class OrdinalGreekNumberConverter extends OrdinalLocalBasedNumberConverter {
            constructor(simpleFormattersManager) {
                super(simpleFormattersManager);
            }
            convertNumberCore(value) {
                return this.simpleFormattersManager.formatString("{0}ο", value);
            }
        }
        class OrdinalSpanishNumberConverter extends OrdinalLocalBasedNumberConverter {
            constructor(simpleFormattersManager) {
                super(simpleFormattersManager);
            }
            convertNumberCore(value) {
                return this.simpleFormattersManager.formatString("{0}°", value);
            }
        }
        class OrdinalPortugueseNumberConverter extends OrdinalLocalBasedNumberConverter {
            constructor(simpleFormattersManager) {
                super(simpleFormattersManager);
            }
            convertNumberCore(value) {
                return this.simpleFormattersManager.formatString("{0}º", value);
            }
        }
        class OrdinalUkrainianNumberConverter extends OrdinalLocalBasedNumberConverter {
            constructor(simpleFormattersManager) {
                super(simpleFormattersManager);
            }
            convertNumberCore(value) {
                return this.simpleFormattersManager.formatString("{0}-й", value);
            }
        }
        class OrdinalRussianNumberConverter extends OrdinalLocalBasedNumberConverter {
            constructor(simpleFormattersManager) {
                super(simpleFormattersManager);
            }
            convertNumberCore(value) {
                return this.simpleFormattersManager.formatString("{0}-й", value);
            }
        }
        class OrdinalSwedishNumberConverter extends OrdinalLocalBasedNumberConverter {
            constructor(simpleFormattersManager) {
                super(simpleFormattersManager);
            }
            convertNumberCore(value) {
                return value % 10 == 1 || value % 10 == 2 ? this.simpleFormattersManager.formatString("{0}:a", value) : this.simpleFormattersManager.formatString("{0}:e", value);
            }
        }
        class BulletNumberConverter extends OrdinalBasedNumberConverter {
            constructor() {
                super(), this.type = NumberingFormat.Bullet;
            }
            convertNumberCore(_value) {
                return "•";
            }
        }
        class DecimalEnclosedParenthesesNumberConverter extends OrdinalBasedNumberConverter {
            constructor(simpleFormattersManager) {
                super(), this.simpleFormattersManager = simpleFormattersManager, this.type = NumberingFormat.DecimalEnclosedParentheses;
            }
            convertNumberCore(value) {
                return this.simpleFormattersManager.formatString("({0})", value);
            }
        }
        class DecimalNumberConverter extends OrdinalBasedNumberConverter {
            constructor() {
                super(), this.type = NumberingFormat.Decimal;
            }
            convertNumberCore(value) {
                return value.toString();
            }
        }
        class DecimalZeroNumberConverter extends OrdinalBasedNumberConverter {
            constructor(simpleFormattersManager) {
                super(), this.simpleFormattersManager = simpleFormattersManager, this.type = NumberingFormat.DecimalZero;
            }
            convertNumberCore(value) {
                return value < 10 ? this.simpleFormattersManager.formatString("0{0}", value) : value.toString();
            }
        }
        class NumericsProvider {
            constructor(separator, singlesNumeral, singles, teens, tenths, hundreds, thousands, million, billion, trillion, quadrillion, quintillion) {
                this.separator = separator, this.singlesNumeral = singlesNumeral, this.singles = singles, 
                this.teens = teens, this.tenths = tenths, this.hundreds = hundreds, this.thousands = thousands, 
                this.million = million, this.billion = billion, this.trillion = trillion, this.quadrillion = quadrillion, 
                this.quintillion = quintillion;
            }
        }
        class OrdinalEnglishNumericsProvider extends NumericsProvider {
            constructor() {
                super([ " ", "-" ], [ "first", "second", "third", "fourth", "fifth", "sixth", "seventh", "eighth", "ninth", "zeroth" ], [ "first", "second", "third", "fourth", "fifth", "sixth", "seventh", "eighth", "ninth", "zeroth" ], [ "tenth", "eleventh", "twelfth", "thirteenth", "fourteenth", "fifteenth", "sixteenth", "seventeenth", "eighteenth", "nineteenth" ], [ "twentieth", "thirtieth", "fortieth", "fiftieth", "sixtieth", "seventieth", "eightieth", "ninetieth" ], [ "one hundredth", "two hundredth", "three hundredth", "four hundredth", "five hundredth", "six hundredth", "seven hundredth", "eight hundredth", "nine hundredth" ], [ "thousandth" ], [ "millionth" ], [ "billionth" ], [ "trillionth" ], [ "quadrillionth" ], [ "quintillionth" ]);
            }
        }
        class CardinalEnglishNumericsProvider extends NumericsProvider {
            constructor() {
                super([ " ", "-" ], [ "one", "two", "three", "four", "five", "six", "seven", "eight", "nine", "zero" ], [ "one", "two", "three", "four", "five", "six", "seven", "eight", "nine", "zero" ], [ "ten", "eleven", "twelve", "thirteen", "fourteen", "fifteen", "sixteen", "seventeen", "eighteen", "nineteen" ], [ "twenty", "thirty", "forty", "fifty", "sixty", "seventy", "eighty", "ninety" ], [ "one hundred", "two hundred", "three hundred", "four hundred", "five hundred", "six hundred", "seven hundred", "eight hundred", "nine hundred" ], [ "thousand" ], [ "million" ], [ "billion" ], [ "trillion" ], [ "quadrillion" ], [ "quintillion" ]);
            }
        }
        !function(DigitType) {
            DigitType[DigitType.Zero = 0] = "Zero", DigitType[DigitType.SingleNumeral = 1] = "SingleNumeral", 
            DigitType[DigitType.Single = 2] = "Single", DigitType[DigitType.Teen = 3] = "Teen", 
            DigitType[DigitType.Tenth = 4] = "Tenth", DigitType[DigitType.Hundred = 5] = "Hundred", 
            DigitType[DigitType.Thousand = 6] = "Thousand", DigitType[DigitType.Million = 7] = "Million", 
            DigitType[DigitType.Billion = 8] = "Billion", DigitType[DigitType.Trillion = 9] = "Trillion", 
            DigitType[DigitType.Quadrillion = 10] = "Quadrillion", DigitType[DigitType.Quintillion = 11] = "Quintillion", 
            DigitType[DigitType.Separator = 12] = "Separator";
        }(DigitType || (DigitType = {}));
        class DigitInfo {
            constructor(provider, value, type) {
                this.provider = provider, this.value = value, this.type = type;
            }
            convertToString() {
                return this.getNumerics()[this.value];
            }
            getNumerics() {
                return [];
            }
        }
        class SeparatorDigitInfo extends DigitInfo {
            constructor(provider, value) {
                super(provider, value, DigitType.Separator);
            }
            getNumerics() {
                return this.provider.separator;
            }
        }
        class QuintillionDigitInfo extends DigitInfo {
            constructor(provider, value) {
                super(provider, value, DigitType.Quintillion);
            }
            getNumerics() {
                return this.provider.quintillion;
            }
        }
        class QuadrillionDigitInfo extends DigitInfo {
            constructor(provider, value) {
                super(provider, value, DigitType.Quadrillion);
            }
            getNumerics() {
                return this.provider.quadrillion;
            }
        }
        class TrillionDigitInfo extends DigitInfo {
            constructor(provider, value) {
                super(provider, value, DigitType.Trillion);
            }
            getNumerics() {
                return this.provider.trillion;
            }
        }
        class BillionDigitInfo extends DigitInfo {
            constructor(provider, value) {
                super(provider, value, DigitType.Billion);
            }
            getNumerics() {
                return this.provider.billion;
            }
        }
        class MillionDigitInfo extends DigitInfo {
            constructor(provider, value) {
                super(provider, value, DigitType.Million);
            }
            getNumerics() {
                return this.provider.million;
            }
        }
        class ThousandDigitInfo extends DigitInfo {
            constructor(provider, value) {
                super(provider, value, DigitType.Million);
            }
            getNumerics() {
                return this.provider.thousands;
            }
        }
        class HundredDigitInfo extends DigitInfo {
            constructor(provider, value) {
                super(provider, value - 1, DigitType.Hundred);
            }
            getNumerics() {
                return this.provider.hundreds;
            }
        }
        class TenthsDigitInfo extends DigitInfo {
            constructor(provider, value) {
                super(provider, value - 2, DigitType.Tenth);
            }
            getNumerics() {
                return this.provider.tenths;
            }
        }
        class TeensDigitInfo extends DigitInfo {
            constructor(provider, value) {
                super(provider, value, DigitType.Teen);
            }
            getNumerics() {
                return this.provider.teens;
            }
        }
        class SingleDigitInfo extends DigitInfo {
            constructor(provider, value) {
                super(provider, value - 1, DigitType.Single);
            }
            getNumerics() {
                return this.provider.singles;
            }
        }
        class ZeroDigitInfo extends DigitInfo {
            constructor(provider) {
                super(provider, 9, DigitType.Zero);
            }
            getNumerics() {
                return this.provider.singles;
            }
        }
        class DescriptiveEnglishNumberConverter extends OrdinalBasedNumberConverter {
            constructor() {
                super(), this.minValue = 0;
            }
            convertNumberCore(value) {
                var digits = this.generateDigits(value);
                return this.convertDigitsToString(digits);
            }
            generateDigits(value) {
                var digits = [];
                return 0 == (digits = this.generateDigitsCore(digits, value)).length && this.addZero(digits), 
                digits;
            }
            generateDigitsCore(digits, value) {
                var currentValue = value;
                return 0 != Math.floor(currentValue / 1e18) && this.generateQuintillionDigits(digits, Math.floor(currentValue / 1e18)), 
                currentValue %= 1e18, 0 != Math.floor(currentValue / 1e15) && this.generateQuadrillionDigits(digits, Math.floor(currentValue / 1e15)), 
                currentValue %= 1e15, 0 != Math.floor(currentValue / 1e12) && this.generateTrillionDigits(digits, Math.floor(currentValue / 1e12)), 
                currentValue %= 1e12, 0 != Math.floor(currentValue / 1e9) && this.generateBillionDigits(digits, Math.floor(currentValue / 1e9)), 
                currentValue %= 1e9, 0 != Math.floor(currentValue / 1e6) && this.generateMillionDigits(digits, Math.floor(currentValue / 1e6)), 
                currentValue %= 1e6, 0 != Math.floor(currentValue / 1e3) && this.generateThousandDigits(digits, Math.floor(currentValue / 1e3)), 
                currentValue %= 1e3, 0 != Math.floor(currentValue / 100) && this.generateHundredDigits(digits, Math.floor(currentValue / 100)), 
                0 == (currentValue %= 100) || (currentValue >= 20 ? this.generateTenthsDigits(digits, currentValue) : currentValue >= 10 ? this.generateTeensDigits(digits, currentValue % 10) : this.generateSinglesDigits(digits, currentValue)), 
                digits;
            }
            convertDigitsToString(digits) {
                for (var result = "", i = 0; i < digits.length; i++) result += digits[i].convertToString();
                return result.length > 0 && (result = result[0].toUpperCase() + result.substring(1)), 
                result;
            }
            addZero(digits) {
                digits.push(new ZeroDigitInfo(new CardinalEnglishNumericsProvider));
            }
            generateQuintillionDigits(digits, value) {
                this.generateDigitsCore(digits, value), digits.length && digits.push(new SeparatorDigitInfo(new CardinalEnglishNumericsProvider, 0)), 
                digits.push(new QuintillionDigitInfo(new CardinalEnglishNumericsProvider, 0));
            }
            generateQuadrillionDigits(digits, value) {
                this.generateDigitsCore(digits, value), digits.length && digits.push(new SeparatorDigitInfo(new CardinalEnglishNumericsProvider, 0)), 
                digits.push(new QuadrillionDigitInfo(new CardinalEnglishNumericsProvider, 0));
            }
            generateTrillionDigits(digits, value) {
                this.generateDigitsCore(digits, value), digits.length && digits.push(new SeparatorDigitInfo(new CardinalEnglishNumericsProvider, 0)), 
                digits.push(new TrillionDigitInfo(new CardinalEnglishNumericsProvider, 0));
            }
            generateBillionDigits(digits, value) {
                this.generateDigitsCore(digits, value), digits.length && digits.push(new SeparatorDigitInfo(new CardinalEnglishNumericsProvider, 0)), 
                digits.push(new BillionDigitInfo(new CardinalEnglishNumericsProvider, 0));
            }
            generateMillionDigits(digits, value) {
                this.generateDigitsCore(digits, value), digits.length && digits.push(new SeparatorDigitInfo(new CardinalEnglishNumericsProvider, 0)), 
                digits.push(new MillionDigitInfo(new CardinalEnglishNumericsProvider, 0));
            }
            generateThousandDigits(digits, value) {
                this.generateDigitsCore(digits, value), digits.length && digits.push(new SeparatorDigitInfo(new CardinalEnglishNumericsProvider, 0)), 
                digits.push(new ThousandDigitInfo(new CardinalEnglishNumericsProvider, 0));
            }
            generateHundredDigits(digits, value) {
                digits.length && digits.push(new SeparatorDigitInfo(new CardinalEnglishNumericsProvider, 0)), 
                digits.push(new HundredDigitInfo(new CardinalEnglishNumericsProvider, value));
            }
            generateTenthsDigits(digits, value) {
                digits.length && digits.push(new SeparatorDigitInfo(new CardinalEnglishNumericsProvider, 0)), 
                digits.push(new TenthsDigitInfo(new CardinalEnglishNumericsProvider, Math.floor(value / 10))), 
                this.generateSinglesDigits(digits, value % 10);
            }
            generateTeensDigits(digits, value) {
                digits.length && digits.push(new SeparatorDigitInfo(new CardinalEnglishNumericsProvider, 0)), 
                digits.push(new TeensDigitInfo(new CardinalEnglishNumericsProvider, value));
            }
            generateSinglesDigits(digits, value) {
                0 != value && (0 != digits.length && (digits[digits.length - 1].type == DigitType.Tenth ? digits.push(new SeparatorDigitInfo(new CardinalEnglishNumericsProvider, 1)) : digits.push(new SeparatorDigitInfo(new CardinalEnglishNumericsProvider, 0))), 
                digits.push(new SingleDigitInfo(new CardinalEnglishNumericsProvider, value)));
            }
        }
        class DescriptiveCardinalEnglishNumberConverter extends DescriptiveEnglishNumberConverter {
            constructor() {
                super(), this.type = NumberingFormat.CardinalText;
            }
        }
        class DescriptiveOrdinalEnglishNumberConverter extends DescriptiveEnglishNumberConverter {
            constructor() {
                super(), this.type = NumberingFormat.OrdinalText;
            }
            generateDigits(value) {
                var digits = super.generateDigits(value);
                return digits[digits.length - 1].provider = new OrdinalEnglishNumericsProvider, 
                digits;
            }
        }
        class HexNumberConverter extends OrdinalBasedNumberConverter {
            constructor() {
                super(), this.type = NumberingFormat.Hex;
            }
            convertNumberCore(value) {
                return value.toString(16);
            }
        }
        class AlphabetBasedNumberConverter extends OrdinalBasedNumberConverter {
            constructor(alphabet) {
                super(), this.minValue = 0, this.maxValue = 780, this.alphabet = alphabet;
            }
            convertNumberCore(value) {
                if (0 == value) return "";
                value--;
                var alphabetSize = this.alphabet.length, count = Math.floor(value / alphabetSize + 1), symbol = this.alphabet[value % alphabetSize];
                return Array(count + 1).join(symbol);
            }
        }
        class UpperLatinLetterNumberConverter extends AlphabetBasedNumberConverter {
            constructor() {
                super([ "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z" ]), 
                this.type = NumberingFormat.UpperLetter;
            }
        }
        class LowerLatinLetterNumberConverter extends AlphabetBasedNumberConverter {
            constructor() {
                super([ "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z" ]), 
                this.type = NumberingFormat.LowerLetter;
            }
        }
        class NumberInDashNumberConverter extends OrdinalBasedNumberConverter {
            constructor(simpleFormattersManager) {
                super(), this.simpleFormattersManager = simpleFormattersManager, this.type = NumberingFormat.NumberInDash;
            }
            convertNumberCore(value) {
                return this.simpleFormattersManager.formatString("- {0} -", value);
            }
        }
        class RomanNumberConverter extends OrdinalBasedNumberConverter {
            convertNumberCore(value) {
                for (var result = "", i = this.romans.length - 1; i >= 0; i--) for (;value >= this.arabics[i]; ) value -= this.arabics[i], 
                result += this.romans[i];
                return result;
            }
        }
        class UpperRomanNumberConverterClassic extends RomanNumberConverter {
            constructor() {
                super(), this.type = NumberingFormat.UpperRoman, this.arabics = [ 1, 4, 5, 9, 10, 40, 50, 90, 100, 400, 500, 900, 1e3 ], 
                this.romans = [ "I", "IV", "V", "IX", "X", "XL", "L", "XC", "C", "CD", "D", "CM", "M" ];
            }
        }
        class LowerRomanNumberConverterClassic extends RomanNumberConverter {
            constructor() {
                super(), this.type = NumberingFormat.LowerRoman, this.arabics = [ 1, 4, 5, 9, 10, 40, 50, 90, 100, 400, 500, 900, 1e3 ], 
                this.romans = [ "i", "iv", "v", "ix", "x", "xl", "l", "xc", "c", "cd", "d", "cm", "m" ];
            }
        }
        class number_converter_creator_NumberConverterCreator {
            static createConverter(type, simpleFormattersManager, langId = "en") {
                switch (type) {
                  case NumberingFormat.UpperRoman:
                    return new UpperRomanNumberConverterClassic;

                  case NumberingFormat.LowerRoman:
                    return new LowerRomanNumberConverterClassic;

                  case NumberingFormat.Ordinal:
                    return number_converter_creator_NumberConverterCreator.getOrdinalBasedNumberConverter(simpleFormattersManager, langId);

                  case NumberingFormat.OrdinalText:
                    return new DescriptiveOrdinalEnglishNumberConverter;

                  case NumberingFormat.CardinalText:
                    return new DescriptiveCardinalEnglishNumberConverter;

                  case NumberingFormat.UpperLetter:
                    return new UpperLatinLetterNumberConverter;

                  case NumberingFormat.LowerLetter:
                    return new LowerLatinLetterNumberConverter;

                  case NumberingFormat.NumberInDash:
                    return new NumberInDashNumberConverter(simpleFormattersManager);

                  case NumberingFormat.Bullet:
                    return new BulletNumberConverter;

                  case NumberingFormat.DecimalZero:
                    return new DecimalZeroNumberConverter(simpleFormattersManager);

                  case NumberingFormat.DecimalEnclosedParentheses:
                    return new DecimalEnclosedParenthesesNumberConverter(simpleFormattersManager);

                  case NumberingFormat.Hex:
                    return new HexNumberConverter;

                  case NumberingFormat.Decimal:
                  default:
                    return new DecimalNumberConverter;
                }
            }
            static getOrdinalBasedNumberConverter(simpleFormattersManager, langId) {
                switch (langId.substring(0, 2).toLowerCase()) {
                  case "en":
                    return new OrdinalEnglishNumberConverter(simpleFormattersManager);

                  case "fr":
                    return new OrdinalFrenchNumberConverter(simpleFormattersManager);

                  case "de":
                    return new OrdinalGermanNumberConverter(simpleFormattersManager);

                  case "it":
                    return new OrdinalItalianNumberConverter(simpleFormattersManager);

                  case "ru":
                    return new OrdinalRussianNumberConverter(simpleFormattersManager);

                  case "sv":
                    return new OrdinalSwedishNumberConverter(simpleFormattersManager);

                  case "tr":
                    return new OrdinalTurkishNumberConverter(simpleFormattersManager);

                  case "el":
                    return new OrdinalGreekNumberConverter(simpleFormattersManager);

                  case "es":
                    return new OrdinalSpanishNumberConverter(simpleFormattersManager);

                  case "pt":
                    return new OrdinalPortugueseNumberConverter(simpleFormattersManager);

                  case "uk":
                    return new OrdinalUkrainianNumberConverter(simpleFormattersManager);
                }
                return new DecimalNumberConverter;
            }
            static createConverterByTypeName(typeName, simpleFormattersManager) {
                const uppercaseTypeName = typeName.toUpperCase(), firstChar = typeName[0];
                switch (uppercaseTypeName) {
                  case "ALPHABETIC":
                    return firstChar.toUpperCase() == firstChar ? new UpperLatinLetterNumberConverter : new LowerLatinLetterNumberConverter;

                  case "ROMAN":
                    return firstChar.toUpperCase() == firstChar ? new UpperRomanNumberConverterClassic : new LowerRomanNumberConverterClassic;

                  case "ARABIC":
                  default:
                    return new DecimalNumberConverter;

                  case "ARABICDASH":
                    return new NumberInDashNumberConverter(simpleFormattersManager);

                  case "CARDTEXT":
                    return new DescriptiveCardinalEnglishNumberConverter;

                  case "CIRCLENUM":
                    return new DecimalEnclosedParenthesesNumberConverter(simpleFormattersManager);

                  case "HEX":
                    return new HexNumberConverter;

                  case "ORDINAL":
                    return new OrdinalEnglishNumberConverter(simpleFormattersManager);

                  case "ORDTEXT":
                    return new DescriptiveOrdinalEnglishNumberConverter;
                }
            }
        }
        var TableCellBoundFlags, TableRowPropertiesMask, TabAlign, rectangle = __webpack_require__(8011);
        !function(TableCellBoundFlags) {
            TableCellBoundFlags[TableCellBoundFlags.StartAndEndOnOtherColumns = 0] = "StartAndEndOnOtherColumns", 
            TableCellBoundFlags[TableCellBoundFlags.StartOnThisColumn = 1] = "StartOnThisColumn", 
            TableCellBoundFlags[TableCellBoundFlags.EndOnThisColumn = 2] = "EndOnThisColumn";
        }(TableCellBoundFlags || (TableCellBoundFlags = {}));
        class LayoutTableCellInfo extends rectangle.Rectangle {
            constructor(parentRow, bound, cellGridIndex, avaliableContentWidth) {
                super(bound.x, bound.y, bound.width, bound.height), this.layoutRows = [], this.parentRow = parentRow, 
                this.layoutRows = [], this.cellGridIndex = cellGridIndex, this.boundFlags = new class_flag.Flag(TableCellBoundFlags.StartOnThisColumn | TableCellBoundFlags.EndOnThisColumn), 
                this.internalTables = {}, this.avaliableContentWidth = avaliableContentWidth;
            }
            isStartWithInternalTable() {
                return !!this.internalTables[0];
            }
            isEndWithInternalTable() {
                return !!this.internalTables[this.layoutRows.length];
            }
            getLastLayoutRowIncludingInternalTables() {
                const lastInternalTable = this.internalTables[this.layoutRows.length];
                return lastInternalTable ? utils_list.ListUtils.last(utils_list.ListUtils.last(lastInternalTable.tableRows).rowCells).getLastLayoutRowIncludingInternalTables() : utils_list.ListUtils.last(this.layoutRows);
            }
            getFirstLayoutRowByModelPositionIncludingInternalTables() {
                const firstInternalTable = this.internalTables[0];
                return firstInternalTable ? utils_list.ListUtils.min(firstInternalTable.tableRows[0].rowCells, (cell => cell.getFirstLayoutRowByModelPositionIncludingInternalTables().columnOffset)).getFirstLayoutRowByModelPositionIncludingInternalTables() : this.layoutRows[0];
            }
            getEndPosition() {
                const internalTableAfterLastRow = this.internalTables[this.layoutRows.length];
                return internalTableAfterLastRow ? utils_list.ListUtils.last(utils_list.ListUtils.last(internalTableAfterLastRow.tableRows).rowCells).getEndPosition() : utils_list.ListUtils.last(this.layoutRows).getEndPosition();
            }
            isEmpty() {
                return !this.layoutRows.length && number.j.isEmpty(this.internalTables);
            }
        }
        class TableRowProperties {
            constructor() {
                this.mask = 0, this.cellSpacing = TableWidthUnit.createDefault(), this.cantSplit = !1, 
                this.hideCellMark = !1, this.header = !1, this.tableRowAlignment = TableRowAlignment.Left, 
                this.divId = 0;
            }
            calculateHash() {
                return math.MathUtils.somePrimes[0] * this.mask ^ math.MathUtils.somePrimes[1] * this.cellSpacing.getHashCode();
            }
            getHashCode() {
                return void 0 === this.hash ? this.hash = this.calculateHash() : this.hash;
            }
            equals(obj) {
                return !!obj && (this.mask == obj.mask && this.cellSpacing.equals(obj.cellSpacing) && this.cantSplit == obj.cantSplit && this.hideCellMark == obj.hideCellMark && this.header == obj.header && this.tableRowAlignment == obj.tableRowAlignment && this.divId == obj.divId);
            }
            clone() {
                var result = new TableRowProperties;
                return result.copyFrom(this), result;
            }
            copyFrom(obj) {
                this.mask = obj.mask, this.cellSpacing = obj.cellSpacing.clone(), this.cantSplit = obj.cantSplit, 
                this.hideCellMark = obj.hideCellMark, this.header = obj.header, this.tableRowAlignment = obj.tableRowAlignment, 
                this.divId = obj.divId;
            }
            setUseValue(mask, value) {
                value ? this.mask |= mask : this.mask &= ~mask;
            }
            getUseValue(mask) {
                return !!(this.mask & mask);
            }
            setValue(desc, value) {
                desc.setProp(this, value), this.setUseValue(desc.maskValue(), !0);
            }
        }
        !function(TableRowPropertiesMask) {
            TableRowPropertiesMask[TableRowPropertiesMask.UseNone = 0] = "UseNone", TableRowPropertiesMask[TableRowPropertiesMask.UseCantSplit = 2] = "UseCantSplit", 
            TableRowPropertiesMask[TableRowPropertiesMask.UseHideCellMark = 4] = "UseHideCellMark", 
            TableRowPropertiesMask[TableRowPropertiesMask.UseCellSpacing = 128] = "UseCellSpacing", 
            TableRowPropertiesMask[TableRowPropertiesMask.UseTableRowAlignment = 256] = "UseTableRowAlignment", 
            TableRowPropertiesMask[TableRowPropertiesMask.UseShadingInfoIndex = 2048] = "UseShadingInfoIndex", 
            TableRowPropertiesMask[TableRowPropertiesMask.UseHeader = 1024] = "UseHeader", TableRowPropertiesMask[TableRowPropertiesMask.UseDivId = 4096] = "UseDivId", 
            TableRowPropertiesMask[TableRowPropertiesMask.UseAll = 2147483647] = "UseAll";
        }(TableRowPropertiesMask || (TableRowPropertiesMask = {}));
        class TableRowPropertiesMerger extends TablePropertiesMergerBase {
            getContainerFromConditionalStyle(condStyle) {
                return condStyle.tableRowProperties;
            }
            canUseValue(props) {
                return !!(props.mask & this.getPropertyMask());
            }
            getCondTableStyleFormattingListForThisContainer() {
                return TableRowPropertiesMerger.conditionalTableStyleFormattingPriority;
            }
            getNotMergedProperty() {
                return new TableMergerNotMergedPropertyResult(!1, null);
            }
        }
        TableRowPropertiesMerger.conditionalTableStyleFormattingPriority = [ ConditionalTableStyleFormatting.FirstRow, ConditionalTableStyleFormatting.LastRow, ConditionalTableStyleFormatting.OddRowBanding, ConditionalTableStyleFormatting.EvenRowBanding, ConditionalTableStyleFormatting.WholeTable ];
        class TableRowPropertiesMergerCellSpacing extends TableRowPropertiesMerger {
            constructor(model, table, tablePropertiesException) {
                super(), this.tablePropertiesException = tablePropertiesException, this.model = model, 
                this.table = table;
            }
            getPropertyFromContainer(container) {
                return container.cellSpacing;
            }
            getPropertyMask() {
                return TableRowPropertiesMask.UseCellSpacing;
            }
            getNotMergedProperty() {
                return (new TablePropertiesMergerCellSpacing).getTableNotMergedProperty(this.tablePropertiesException);
            }
            actionBeforeDefaultValue() {
                return this.result = (new TablePropertiesMergerCellSpacing).getProperty(this.table.properties, this.table.style, ConditionalTableStyleFormatting.WholeTable, this.model.defaultTableProperties), 
                !0;
            }
        }
        class TableRowPropertiesMergerCantSplit extends TableRowPropertiesMerger {
            getPropertyFromContainer(container) {
                return container.cantSplit;
            }
            getPropertyMask() {
                return TableRowPropertiesMask.UseCantSplit;
            }
        }
        class TableRowPropertiesMergerHorizontalAlignment extends TableRowPropertiesMerger {
            constructor(tablePropertiesException) {
                super(), this.tablePropertiesException = tablePropertiesException;
            }
            getPropertyFromContainer(container) {
                return container.tableRowAlignment;
            }
            getPropertyMask() {
                return TableRowPropertiesMask.UseTableRowAlignment;
            }
            actionBeforeDefaultValue() {
                return this.result = null, !0;
            }
            getNotMergedProperty() {
                return (new TablePropertiesMergerHorizontalAlignment).getTableNotMergedProperty(this.tablePropertiesException);
            }
        }
        class TableRowPropertiesMergerDivId extends TableRowPropertiesMerger {
            getPropertyFromContainer(container) {
                return container.divId;
            }
            getPropertyMask() {
                return TableRowPropertiesMask.UseDivId;
            }
            actionBeforeDefaultValue() {
                return this.result = null, !0;
            }
        }
        class TableAlignmentApplier {
            static getTableAlignment(table) {
                const firstRowAlignment = new TableRowPropertiesMergerHorizontalAlignment(table.rows[0].tablePropertiesException).getProperty(table.rows[0].properties, table.style, table.rows[0].conditionalFormatting, null);
                return null != firstRowAlignment && utils_list.ListUtils.allOf(table.rows, (row => new TableRowPropertiesMergerHorizontalAlignment(row.tablePropertiesException).getProperty(row.properties, table.style, row.conditionalFormatting, null) == firstRowAlignment)) ? firstRowAlignment : (new TablePropertiesMergerHorizontalAlignment).getProperty(table.properties, table.style, ConditionalTableStyleFormatting.WholeTable, null);
            }
            static applyHorizontalAlignment(currTableColumnInfo, tableMaxWidth) {
                const table = currTableColumnInfo.logicInfo.grid.table, tableAlignment = this.getTableAlignment(table), avalSpace = currTableColumnInfo.x + tableMaxWidth - currTableColumnInfo.right;
                let offset;
                switch (null != tableAlignment ? tableAlignment : TableRowAlignment.Left) {
                  case TableRowAlignment.Right:
                    offset = avalSpace;
                    break;

                  case TableRowAlignment.Center:
                    offset = Math.floor(avalSpace / 2);
                    break;

                  case TableRowAlignment.Left:
                  default:
                    offset = 0;
                }
                offset <= 0 || TableAlignmentApplier.moveAllTable(currTableColumnInfo, (rect => rect.x += offset));
            }
            static applyCellsVerticalAlignment(defaultTableCellProps, grid, currTableColumnInfo, rowInfo) {
                const table = grid.table, tableStyle = table.style;
                for (let tblRow of currTableColumnInfo.tableRows) for (let tblCell of tblRow.rowCells) {
                    if (!tblCell.boundFlags.get(TableCellBoundFlags.StartOnThisColumn) || !tblCell.boundFlags.get(TableCellBoundFlags.EndOnThisColumn)) continue;
                    const cellGridInfo = grid.tableCellGridInfos[tblRow.rowIndex][tblCell.cellGridIndex], cellStartRowIndex = cellGridInfo.getStartRowIndex(), cellIndex = cellGridInfo.getCellIndex(0), cell = table.rows[cellStartRowIndex].cells[cellIndex], verticalAlignmentType = (new TableCellVerticalAlignmentMerger).getProperty(cell.properties, tableStyle, cell.conditionalFormatting, defaultTableCellProps), topAndBottomMargins = rowInfo[cellStartRowIndex].topAndBottomMargins, bottomBound = tblCell.bottom - topAndBottomMargins.bottomMargin - rowInfo[tblRow.rowIndex].cellSpacing * (tblRow.rowIndex == table.rows.length - 1 ? 2 : 1), numLayoutRows = tblCell.layoutRows.length, lastInnerTable = tblCell.internalTables[numLayoutRows], avalSpace = bottomBound - (lastInnerTable ? lastInnerTable.bottom : tblCell.layoutRows[numLayoutRows - 1].bottom);
                    var offset;
                    switch (verticalAlignmentType) {
                      case TableCellVerticalAlignment.Bottom:
                        offset = avalSpace;
                        break;

                      case TableCellVerticalAlignment.Center:
                        offset = Math.floor(avalSpace / 2);
                        break;

                      case TableCellVerticalAlignment.Top:
                      default:
                        offset = 0;
                    }
                    if (!(offset <= 0)) {
                        for (let layoutRow of tblCell.layoutRows) layoutRow.y += offset;
                        number.j.forEach(tblCell.internalTables, (table => TableAlignmentApplier.moveAllTable(table, (rect => rect.y += offset))));
                    }
                }
            }
            static moveAllTable(tblCol, mover) {
                mover(tblCol);
                for (let tblRow of tblCol.tableRows) {
                    mover(tblRow);
                    for (let tblCell of tblRow.rowCells) {
                        mover(tblCell), number.j.forEach(tblCell.internalTables, (table => TableAlignmentApplier.moveAllTable(table, mover)));
                        for (let layoutRow of tblCell.layoutRows) mover(layoutRow);
                    }
                }
            }
        }
        class Table {
            constructor(properties, style) {
                this.rows = [], this.preferredWidth = TableWidthUnit.createDefault(), this.lookTypes = TableLookTypes.None, 
                this.properties = properties, this.style = style;
            }
            getTotalVirtualColumnsCount() {
                return utils_list.ListUtils.maxExtended(this.rows, (row => row.getTotalCellsInRowConsiderGrid())).maxValue;
            }
            destructor(positionManager) {
                for (var tableRow, rowIndex = 0; tableRow = this.rows[rowIndex]; rowIndex++) tableRow.destructor(positionManager);
            }
            get interval() {
                return fixed.FixedInterval.fromPositions(this.getStartPosition(), this.getEndPosition());
            }
            getParentTable() {
                return this.parentCell ? this.parentCell.parentRow.parentTable : null;
            }
            getTopLevelParent() {
                let currTable = this;
                for (;currTable.parentCell; ) currTable = currTable.getParentTable();
                return currTable;
            }
            getStartPosition() {
                return this.rows[0].getStartPosition();
            }
            getEndPosition() {
                return this.rows[this.rows.length - 1].getEndPosition();
            }
            getLastCell() {
                let lastRow = this.rows[this.rows.length - 1];
                return lastRow.cells[lastRow.cells.length - 1];
            }
            getFirstCell() {
                return this.rows[0].cells[0];
            }
            getActualLeftBorder(defaultTableProperties, isTableOuterBorder = !0) {
                return this.getActualBorderCore(new TablePropertiesMergerBorderLeft(isTableOuterBorder), defaultTableProperties);
            }
            getActualRightBorder(defaultTableProperties, isTableOuterBorder = !0) {
                return this.getActualBorderCore(new TablePropertiesMergerBorderRight(isTableOuterBorder), defaultTableProperties);
            }
            getActualBottomBorder(defaultTableProperties, isTableOuterBorder = !0) {
                return this.getActualBorderCore(new TablePropertiesMergerBorderBottom(isTableOuterBorder), defaultTableProperties);
            }
            getActualTopBorder(defaultTableProperties, isTableOuterBorder = !0) {
                return this.getActualBorderCore(new TablePropertiesMergerBorderTop(isTableOuterBorder), defaultTableProperties);
            }
            getActualHorizontalBorder(defaultTableProperties) {
                return this.getActualBorderCore(new TablePropertiesMergerBorderHorizontal, defaultTableProperties);
            }
            getActualVerticalBorder(defaultTableProperties) {
                return this.getActualBorderCore(new TablePropertiesMergerBorderVertical, defaultTableProperties);
            }
            getActualBorderCore(tablePropertiesMerger, defaultTableProperties) {
                return tablePropertiesMerger.getProperty(this.properties, this.style, ConditionalTableStyleFormatting.WholeTable, defaultTableProperties);
            }
            getActualLeftMargin(defaultTableProperties) {
                return this.getActualMarginCore(new TablePropertiesMergerMarginLeft, defaultTableProperties);
            }
            getActualRightMargin(defaultTableProperties) {
                return this.getActualMarginCore(new TablePropertiesMergerMarginRight, defaultTableProperties);
            }
            getActualTopMargin(defaultTableProperties) {
                return this.getActualMarginCore(new TablePropertiesMergerMarginTop, defaultTableProperties);
            }
            getActualBottomMargin(defaultTableProperties) {
                return this.getActualMarginCore(new TablePropertiesMergerMarginBottom, defaultTableProperties);
            }
            getActualMarginCore(merger, defaultTableProperties) {
                return merger.getProperty(this.properties, this.style, ConditionalTableStyleFormatting.WholeTable, defaultTableProperties);
            }
            getActualTableAlignment() {
                return TableAlignmentApplier.getTableAlignment(this);
            }
            getActualTableIndent(defaultTableProperties) {
                return this.getActualTableAlignment() != TableRowAlignment.Left ? TableWidthUnit.createDefault() : (new TablePropertiesMergerIndent).getProperty(this.properties, this.style, ConditionalTableStyleFormatting.WholeTable, defaultTableProperties);
            }
            getActualTableLayout(defaultTableProperties) {
                return (new TablePropertiesMergerLayoutType).getProperty(this.properties, this.style, ConditionalTableStyleFormatting.WholeTable, defaultTableProperties);
            }
            static comparer(a, b) {
                const cmpPos = a.getStartPosition() - b.getStartPosition();
                return 0 == cmpPos ? a.nestedLevel - b.nestedLevel : cmpPos;
            }
            static sort(tables) {
                tables.sort(Table.comparer);
                for (let table, tableIndex = 0; table = tables[tableIndex]; tableIndex++) table.index = tableIndex;
            }
            static advanceIndices(tables, startIndex, shift) {
                for (let table, i = startIndex; table = tables[i]; i++) table.index += shift;
            }
            static fillTableByLevels(subDocument) {
                const tableByLevels = subDocument.tablesByLevels;
                let tableByLevelsLength = tableByLevels.length;
                for (let table, tableIndex = 0; table = subDocument.tables[tableIndex]; tableIndex++) table.index = tableIndex, 
                table.nestedLevel >= tableByLevelsLength && (tableByLevels.push([]), tableByLevelsLength++), 
                tableByLevels[table.nestedLevel].push(table);
            }
            static getTableCellByPosition(tables, position) {
                const table = Table.getTableByPosition(tables, position, !0);
                return table ? Table.getTableCellByPositionFromTable(table, position) : null;
            }
            static getTableCellByPositionFromTable(table, position) {
                const rowIndex = search.SearchUtils.normedInterpolationIndexOf(table.rows, (r => r.getStartPosition()), position), row = table.rows[rowIndex], cellIndex = search.SearchUtils.normedInterpolationIndexOf(row.cells, (c => c.startParagraphPosition.value), position);
                return row.cells[cellIndex];
            }
            static getTableByPosition(tables, position, maxNestedLevel, tableIndex = search.SearchUtils.normedInterpolationIndexOf(tables, (t => t.getStartPosition()), position)) {
                if (tableIndex < 0) return null;
                let table = tables[tableIndex];
                for (;position >= table.getEndPosition(); ) {
                    if (0 === table.nestedLevel) return null;
                    table = table.getParentTable();
                }
                return Table.correctBoundTable(tables, table.index, position, maxNestedLevel ? index => ++index : index => --index);
            }
            static correctBoundTable(tables, tableIndex, position, indexIterator) {
                let table = tables[tableIndex], tablePos = table.getStartPosition();
                tableIndex = indexIterator(tableIndex);
                for (let neighborTable; neighborTable = tables[tableIndex]; tableIndex = indexIterator(tableIndex)) {
                    const neighborTablePos = neighborTable.getStartPosition();
                    if (tablePos != neighborTablePos || position >= neighborTable.getEndPosition()) break;
                    tablePos = neighborTablePos, table = neighborTable;
                }
                return table;
            }
            static getFirstCellPositionInVerticalMergingGroup(tablePosition) {
                if (tablePosition.cell.verticalMerging != TableCellMergingState.Continue) return tablePosition;
                const tblPos = tablePosition.clone().init(), cellColumnIndex = tblPos.row.getCellColumnIndex(tblPos.cellIndex);
                for (;tblPos.moveToPrevRow(); ) {
                    let columnIndex = tblPos.row.gridBefore;
                    tblPos.setCell(0);
                    do {
                        if (cellColumnIndex <= columnIndex) {
                            if (tblPos.cell.verticalMerging != TableCellMergingState.Continue || 0 == tblPos.rowIndex) return tblPos;
                            break;
                        }
                        columnIndex += tblPos.cell.columnSpan;
                    } while (tblPos.moveToNextCell());
                }
                return null;
            }
            clone(subDocument) {
                const result = new Table(this.properties.clone(), subDocument.documentModel.stylesManager.getTableStyleByName(this.style.styleName));
                result.index = this.index, result.nestedLevel = this.nestedLevel;
                const tablesOnLevel = subDocument.tablesByLevels[result.nestedLevel];
                return tablesOnLevel ? tablesOnLevel.push(result) : subDocument.tablesByLevels.push([ result ]), 
                this.parentCell && (result.parentCell = Table.getTableCellByPositionFromTable(subDocument.tables[this.parentCell.parentRow.parentTable.index], this.parentCell.startParagraphPosition.value)), 
                result.rows = utils_list.ListUtils.map(this.rows, (r => r.clone(subDocument, result))), 
                result.preferredWidth = this.preferredWidth.clone(), result.lookTypes = this.lookTypes, 
                result;
            }
        }
        class TablePositionIndexes {
            constructor(rowIndex, cellIndex) {
                this.rowIndex = rowIndex, this.cellIndex = cellIndex;
            }
            equals(obj) {
                return obj && this.cellIndex == obj.cellIndex && this.rowIndex == obj.rowIndex;
            }
            copyFrom(obj) {
                this.rowIndex = obj.rowIndex, this.cellIndex = obj.cellIndex;
            }
            clone() {
                return new TablePositionIndexes(this.rowIndex, this.cellIndex);
            }
        }
        class TablePosition extends TablePositionIndexes {
            constructor(table, rowIndex, cellIndex) {
                super(rowIndex, cellIndex), this.table = table;
            }
            initIndexes(rowIndex, cellIndex) {
                return this.rowIndex = rowIndex, this.cellIndex = cellIndex, this;
            }
            init() {
                return this.row = this.table.rows[this.rowIndex], this.cell = this.row.cells[this.cellIndex], 
                this;
            }
            setRow(rowIndex) {
                return this.rowIndex = rowIndex, this.row = this.table.rows[this.rowIndex], this;
            }
            setCell(cellIndex) {
                this.cellIndex = cellIndex, this.cell = this.row.cells[cellIndex];
            }
            static createAndInit(table, rowIndex, cellIndex) {
                const position = new TablePosition(table, rowIndex, cellIndex);
                return position.init(), position;
            }
            static indexOfCell(positions, cell) {
                for (let pos, i = 0; pos = positions[i]; i++) if (pos.cell === cell) return i;
                return -1;
            }
            moveToPrevRow() {
                return !!this.rowIndex && (this.rowIndex--, this.row = this.table.rows[this.rowIndex], 
                !0);
            }
            moveToNextRow() {
                return this.rowIndex != this.table.rows.length - 1 && (this.rowIndex++, this.row = this.table.rows[this.rowIndex], 
                this.cellIndex = -1, !0);
            }
            moveToNextCell() {
                return this.cellIndex != this.row.cells.length - 1 && (this.cellIndex++, this.cell = this.row.cells[this.cellIndex], 
                !0);
            }
            copyFrom(obj) {
                super.copyFrom(obj), this.table = obj.table, this.row = obj.row, this.cell = obj.cell;
            }
            clone() {
                const pos = new TablePosition(this.table, this.rowIndex, this.cellIndex);
                return pos.row = this.row, pos.cell = this.cell, pos;
            }
            equals(obj) {
                return obj && this.table == obj.table && this.rowIndex == obj.rowIndex && this.cellIndex == obj.cellIndex;
            }
        }
        class StyleBase {
            constructor(styleName, localizedName, deleted, hidden, semihidden, isDefault, base64EncodedImage, id) {
                this.styleName = styleName, this.deleted = deleted, this.localizedName = localizedName, 
                this.hidden = hidden, this.semihidden = semihidden, this.isDefault = isDefault, 
                this.base64EncodedImage = base64EncodedImage || null, this.id = id;
            }
            equalsByName(obj) {
                return this.styleName == obj.styleName;
            }
        }
        class ParagraphStyle extends StyleBase {
            constructor(styleName, localizedName, deleted, hidden, semihidden, isDefault, maskedCharacterProperties, maskedParagraphProperties, tabs, autoUpdate, numberingListIndex, listLevelIndex, base64EncodedImage, id) {
                super(styleName, localizedName, deleted, hidden, semihidden, isDefault, base64EncodedImage, id), 
                this.linkedStyle = null, this.nextParagraphStyle = null, this.maskedCharacterProperties = maskedCharacterProperties, 
                this.maskedParagraphProperties = maskedParagraphProperties, this.tabs = tabs, this.autoUpdate = autoUpdate, 
                this.numberingListIndex = numberingListIndex, this.listLevelIndex = listLevelIndex;
            }
            getResultTabs() {
                var _a;
                const parentTabs = null === (_a = this.parent) || void 0 === _a ? void 0 : _a.getResultTabs(), tabs = this.tabs.clone();
                return tabs.merge(parentTabs), tabs;
            }
            getMergedParagraphProperties() {
                const paragraphMerger = new ParagraphPropertiesMerger;
                return paragraphMerger.mergeParagraphStyle(this), paragraphMerger.getMergedProperties();
            }
            isInOwnList() {
                return this.numberingListIndex >= 0;
            }
            getListLevel(model) {
                return this.getNumberingList(model).levels[this.getListLevelIndex()];
            }
            getNumberingList(model) {
                return model.numberingLists[this.getNumberingListIndex()];
            }
            getNumberingListIndex() {
                return this.numberingListIndex >= 0 || this.numberingListIndex === NumberingList.NoNumberingListIndex || !this.parent ? this.numberingListIndex : this.parent.getNumberingListIndex();
            }
            getListLevelIndex() {
                return this.listLevelIndex >= 0 || this.listLevelIndex === NumberingList.NoNumberingListIndex || !this.parent ? this.listLevelIndex : this.parent.getListLevelIndex();
            }
            clone() {
                const style = new ParagraphStyle(this.styleName, this.localizedName, this.deleted, this.hidden, this.semihidden, this.isDefault, this.maskedCharacterProperties, this.maskedParagraphProperties, this.tabs.clone(), this.autoUpdate, this.numberingListIndex, this.listLevelIndex, this.base64EncodedImage, this.id);
                return style.parent = this.parent, style.linkedStyle = this.linkedStyle, style.nextParagraphStyle = this.nextParagraphStyle, 
                style.primary = this.primary, style;
            }
        }
        ParagraphStyle.normalStyleName = "Normal", ParagraphStyle.headingStyleName = "heading", 
        ParagraphStyle.tocStyleName = "toc";
        class TabProperties {
            constructor() {
                this.tabsInfo = [];
            }
            clone() {
                const tabProperties = new TabProperties;
                for (let tab of this.tabsInfo) tabProperties.tabsInfo.push(tab.clone());
                return tabProperties;
            }
            equals(obj) {
                for (var tab, i = 0; tab = this.tabsInfo[i]; i++) if (!tab.equals(obj.tabsInfo[i])) return !1;
                return !0;
            }
            sort() {
                this.tabsInfo.sort(((a, b) => a.position - b.position));
            }
            indexOf(tabInfo) {
                return search.SearchUtils.binaryIndexOf(this.tabsInfo, (t => t.position - tabInfo.position));
            }
            add(tabInfo) {
                this.tabsInfo.push(tabInfo), this.sort();
            }
            deleteByIndex(index) {
                this.tabsInfo.splice(index, 1);
            }
            setTabs(tabProp) {
                this.tabsInfo = tabProp.tabsInfo, this.tabsInfo.sort(((a, b) => a.position - b.position));
            }
            merge(tabProperties) {
                tabProperties && (tabProperties.tabsInfo.filter((t => !t.deleted)).forEach((t => {
                    this.tabsInfo.some((st => t.position === st.position)) || this.add(t.clone());
                })), this.sort());
            }
        }
        class TabInfo {
            constructor(position, alignment, leader, deleted, isDefault) {
                this.position = position, this.alignment = alignment, this.leader = leader, this.isDefault = isDefault, 
                this.deleted = deleted;
            }
            clone() {
                return new TabInfo(this.position, this.alignment, this.leader, this.deleted, this.isDefault);
            }
            equals(obj) {
                return !!obj && (this.alignment == obj.alignment && this.leader == obj.leader && this.position == obj.position && this.deleted == obj.deleted && this.isDefault == obj.isDefault);
            }
        }
        class TabsInfo {}
        !function(TabAlign) {
            TabAlign[TabAlign.Left = 0] = "Left", TabAlign[TabAlign.Center = 1] = "Center", 
            TabAlign[TabAlign.Right = 2] = "Right", TabAlign[TabAlign.Decimal = 3] = "Decimal", 
            TabAlign[TabAlign.Numbering = 4] = "Numbering";
        }(TabAlign || (TabAlign = {}));
        class Paragraph {
            constructor(subDocument, startLogPosition, length, paragraphStyle, maskedParagraphProperties, indexInMaskedParagraphProperitesCache = void 0) {
                this.numberingListIndex = NumberingList.NumberingListNotSettedIndex, this.listLevelIndex = -1, 
                this.subDocument = subDocument, this.startLogPosition = startLogPosition, this.length = length, 
                this.paragraphStyle = paragraphStyle, void 0 === indexInMaskedParagraphProperitesCache ? maskedParagraphProperties ? this.setParagraphProperties(maskedParagraphProperties) : this.maskedParagraphProperties = null : this.maskedParagraphProperties = this.subDocument.documentModel.cache.maskedParagraphPropertiesCache.getItemByJsonKey(indexInMaskedParagraphProperitesCache), 
                this.mergedParagraphFormatting = null, this.tabs = new TabProperties;
            }
            get isEmpty() {
                return this.length <= 1;
            }
            getParagraphBundleFull(model) {
                return new MaskedParagraphPropertiesBundleFull(model.cache.maskedParagraphPropertiesCache.getItem(this.maskedParagraphProperties), model.stylesManager.addParagraphStyle(this.paragraphStyle), new ParagraphListInfo(this.numberingListIndex, this.listLevelIndex), this.tabs.clone());
            }
            getTableCell() {
                const parPos = this.startLogPosition.value, tables = this.subDocument.tables, table = Table.getTableByPosition(tables, parPos, !0);
                if (!table) return null;
                const rowIndex = search.SearchUtils.normedInterpolationIndexOf(table.rows, (r => r.getStartPosition()), parPos), row = table.rows[rowIndex], cellIndex = search.SearchUtils.normedInterpolationIndexOf(row.cells, (c => c.startParagraphPosition.value), parPos);
                return row.cells[cellIndex];
            }
            isInList() {
                return this.getNumberingListIndex() >= 0;
            }
            isInOwnList() {
                return this.numberingListIndex >= 0;
            }
            isInStyleList() {
                return this.paragraphStyle && this.paragraphStyle.numberingListIndex >= 0;
            }
            getListLevelIndex() {
                return this.listLevelIndex >= 0 ? this.listLevelIndex : this.paragraphStyle ? this.paragraphStyle.getListLevelIndex() : -1;
            }
            getListLevel() {
                return this.getNumberingList().levels[this.getListLevelIndex()];
            }
            getNumberingListIndex() {
                return this.numberingListIndex >= 0 || this.numberingListIndex === NumberingList.NoNumberingListIndex ? this.numberingListIndex : this.paragraphStyle ? this.paragraphStyle.getNumberingListIndex() : -1;
            }
            getNumberingList() {
                return this.subDocument.documentModel.numberingLists[this.getNumberingListIndex()];
            }
            getAbstractNumberingList() {
                var numberingList = this.getNumberingList();
                return numberingList ? numberingList.getAbstractNumberingList() : null;
            }
            getAbstractNumberingListIndex() {
                var numberingList = this.getNumberingList();
                return numberingList ? numberingList.abstractNumberingListIndex : -1;
            }
            getNumberingListText() {
                var counters = this.subDocument.documentModel.getRangeListCounters(this);
                return this.getNumberingListTextCore(counters);
            }
            getNumberingListTextCore(counters) {
                var levels = this.getNumberingList().levels, formatString = levels[this.getListLevelIndex()].getListLevelProperties().displayFormatString;
                return this.formatNumberingListText(formatString, counters, levels);
            }
            getNumberingListSeparatorChar() {
                return this.getListLevel().getListLevelProperties().separator;
            }
            getNumerationCharacterProperties() {
                var merger = new CharacterPropertiesMerger;
                merger.mergeCharacterProperties(this.getNumberingList().levels[this.getListLevelIndex()].getCharacterProperties());
                const paragraphRunProperties = this.subDocument.getRunByPosition(this.getEndPosition() - 1).getCharacterMergedProperties(), maskedParagraphRunProperties = new MaskedCharacterProperties;
                return maskedParagraphRunProperties.copyFrom(paragraphRunProperties), maskedParagraphRunProperties.setUseValueFull(CharacterPropertiesMask.UseAll ^ CharacterPropertiesMask.UseFontUnderlineType), 
                merger.mergeCharacterProperties(maskedParagraphRunProperties), this.subDocument.documentModel.cache.mergedCharacterPropertiesCache.getItem(merger.getMergedProperties());
            }
            getNumerationLanguageId() {
                const characterProperties = this.getNumerationCharacterProperties();
                if (!(0, common.isDefined)(characterProperties.langInfo)) return "en";
                const langId = characterProperties.langInfo.latin;
                return (0, common.isDefined)(langId) ? langId : "en";
            }
            formatNumberingListText(formatString, args, levels) {
                var objArgs = new Array(args.length);
                const langId = this.getNumerationLanguageId();
                for (var i = 0; i < args.length; i++) {
                    var converter = number_converter_creator_NumberConverterCreator.createConverter(levels[i].getListLevelProperties().format, this.subDocument.documentModel.simpleFormattersManager, langId);
                    objArgs[i] = converter.convertNumber(args[i]);
                }
                try {
                    return this.subDocument.documentModel.simpleFormattersManager.formatString(formatString, ...objArgs);
                } catch (e) {
                    try {
                        return objArgs[0];
                    } catch (e) {
                        return "";
                    }
                }
            }
            get interval() {
                return new fixed.FixedInterval(this.startLogPosition.value, this.length);
            }
            getEndPosition() {
                return this.startLogPosition.value + this.length;
            }
            setParagraphProperties(properties) {
                this.maskedParagraphProperties = this.subDocument.documentModel.cache.maskedParagraphPropertiesCache.getItem(properties);
            }
            onParagraphPropertiesChanged() {
                this.resetParagraphMergedProperties();
            }
            resetParagraphMergedProperties() {
                this.mergedParagraphFormatting = null;
            }
            getParagraphMergedProperties() {
                if (!this.mergedParagraphFormatting) {
                    var merger = new ParagraphPropertiesMerger;
                    merger.mergeMaskedParagraphProperties(this.maskedParagraphProperties), this.isInOwnList() && merger.mergeMaskedParagraphProperties(this.getListLevel().getParagraphProperties()), 
                    this.numberingListIndex == AbstractNumberingList.NoNumberingListIndex ? merger.mergeParagraphStyle(this.paragraphStyle) : merger.mergeParagraphStyleConsiderNumbering(this.paragraphStyle, this.subDocument.documentModel);
                    const tableCell = this.getTableCell();
                    tableCell && merger.mergeTableStyle(tableCell), merger.mergeMaskedParagraphProperties(this.subDocument.documentModel.defaultParagraphProperties), 
                    this.mergedParagraphFormatting = this.subDocument.documentModel.cache.mergedParagraphPropertiesCache.getItem(merger.getMergedProperties());
                }
                return this.mergedParagraphFormatting;
            }
            setParagraphMergedProperies(properties) {
                this.mergedParagraphFormatting = this.subDocument.documentModel.cache.mergedParagraphPropertiesCache.getItem(properties);
            }
            hasParagraphMergedProperies() {
                return !!this.mergedParagraphFormatting;
            }
            getTabs() {
                var result = new TabsInfo;
                if (result.defaultTabStop = this.subDocument.documentModel.defaultTabWidth, result.positions = [], 
                this.paragraphStyle) for (var styleTabs = this.paragraphStyle.getResultTabs().tabsInfo, i = 0; i < styleTabs.length; i++) if (!styleTabs[i].deleted) {
                    var tabPosition = styleTabs[i].clone();
                    (index = search.SearchUtils.binaryIndexOf(result.positions, (t => t.position - styleTabs[i].position))) < 0 ? result.positions.splice(~index, 0, tabPosition) : result.positions[index] = tabPosition;
                }
                var paragraphTabs = this.tabs.tabsInfo;
                for (i = 0; i < paragraphTabs.length; i++) {
                    var index;
                    (index = search.SearchUtils.binaryIndexOf(result.positions, (t => t.position - paragraphTabs[i].position))) < 0 ? (index = ~index, 
                    paragraphTabs[i].deleted || result.positions.splice(index, 0, paragraphTabs[i].clone())) : paragraphTabs[i].deleted ? result.positions.splice(index, 1) : result.positions[index] = paragraphTabs[i].clone();
                }
                return result;
            }
            clone(subDocument) {
                const result = new Paragraph(subDocument, subDocument.positionManager.registerPosition(this.startLogPosition.value), this.length, subDocument.documentModel.stylesManager.getParagraphStyleByName(this.paragraphStyle.styleName), this.maskedParagraphProperties);
                return result.tabs = this.tabs.clone(), result.numberingListIndex = this.numberingListIndex, 
                result.listLevelIndex = this.listLevelIndex, result;
            }
            copyFrom(from) {
                this.paragraphStyle = from.paragraphStyle, this.setParagraphProperties(from.maskedParagraphProperties), 
                from.hasParagraphMergedProperies() && this.setParagraphMergedProperies(from.getParagraphMergedProperties()), 
                this.numberingListIndex = from.numberingListIndex, this.listLevelIndex = from.listLevelIndex, 
                this.tabs = from.tabs.clone();
            }
        }
        class RichNumberConverter {
            static numberToBinary(num) {
                return (num >>> 0).toString(2);
            }
            static numberToHex(num) {
                return (num >>> 0).toString(16);
            }
            static convertToBinary(num) {
                return utils_string.StringUtils.padLeft(RichNumberConverter.numberToBinary(num), 2, "0");
            }
            static convertToHexBinary(num) {
                return utils_string.StringUtils.padLeft(RichNumberConverter.numberToHex(num), 8, "0");
            }
        }
        class MD5 {
            constructor() {
                this._t = [ -680876936, -389564586, 606105819, -1044525330, -176418897, 1200080426, -1473231341, -45705983, 1770035416, -1958414417, -42063, -1990404162, 1804603682, -40341101, -1502002290, 1236535329, -165796510, -1069501632, 643717713, -373897302, -701558691, 38016083, -660478335, -405537848, 568446438, -1019803690, -187363961, 1163531501, -1444681467, -51403784, 1735328473, -1926607734, -378558, -2022574463, 1839030562, -35309556, -1530992060, 1272893353, -155497632, -1094730640, 681279174, -358537222, -722521979, 76029189, -640364487, -421815835, 530742520, -995338651, -198630844, 1126891415, -1416354905, -57434055, 1700485571, -1894986606, -1051523, -2054922799, 1873313359, -30611744, -1560198380, 1309151649, -145523070, -1120210379, 718787259, -343485551 ];
            }
            computeHashCore(words) {
                const T = this._t;
                for (let i = 0; i < 16; i++) {
                    const offset_i = 0 + i, M_offset_i = words[offset_i];
                    words[offset_i] = 16711935 & (M_offset_i << 8 | M_offset_i >>> 24) | 4278255360 & (M_offset_i << 24 | M_offset_i >>> 8);
                }
                const H = this._hash, M_offset_0 = words[0], M_offset_1 = words[1], M_offset_2 = words[2], M_offset_3 = words[3], M_offset_4 = words[4], M_offset_5 = words[5], M_offset_6 = words[6], M_offset_7 = words[7], M_offset_8 = words[8], M_offset_9 = words[9], M_offset_10 = words[10], M_offset_11 = words[11], M_offset_12 = words[12], M_offset_13 = words[13], M_offset_14 = words[14], M_offset_15 = words[15];
                let a = H[0], b = H[1], c = H[2], d = H[3];
                a = this.FF(a, b, c, d, M_offset_0, 7, T[0]), d = this.FF(d, a, b, c, M_offset_1, 12, T[1]), 
                c = this.FF(c, d, a, b, M_offset_2, 17, T[2]), b = this.FF(b, c, d, a, M_offset_3, 22, T[3]), 
                a = this.FF(a, b, c, d, M_offset_4, 7, T[4]), d = this.FF(d, a, b, c, M_offset_5, 12, T[5]), 
                c = this.FF(c, d, a, b, M_offset_6, 17, T[6]), b = this.FF(b, c, d, a, M_offset_7, 22, T[7]), 
                a = this.FF(a, b, c, d, M_offset_8, 7, T[8]), d = this.FF(d, a, b, c, M_offset_9, 12, T[9]), 
                c = this.FF(c, d, a, b, M_offset_10, 17, T[10]), b = this.FF(b, c, d, a, M_offset_11, 22, T[11]), 
                a = this.FF(a, b, c, d, M_offset_12, 7, T[12]), d = this.FF(d, a, b, c, M_offset_13, 12, T[13]), 
                c = this.FF(c, d, a, b, M_offset_14, 17, T[14]), b = this.FF(b, c, d, a, M_offset_15, 22, T[15]), 
                a = this.GG(a, b, c, d, M_offset_1, 5, T[16]), d = this.GG(d, a, b, c, M_offset_6, 9, T[17]), 
                c = this.GG(c, d, a, b, M_offset_11, 14, T[18]), b = this.GG(b, c, d, a, M_offset_0, 20, T[19]), 
                a = this.GG(a, b, c, d, M_offset_5, 5, T[20]), d = this.GG(d, a, b, c, M_offset_10, 9, T[21]), 
                c = this.GG(c, d, a, b, M_offset_15, 14, T[22]), b = this.GG(b, c, d, a, M_offset_4, 20, T[23]), 
                a = this.GG(a, b, c, d, M_offset_9, 5, T[24]), d = this.GG(d, a, b, c, M_offset_14, 9, T[25]), 
                c = this.GG(c, d, a, b, M_offset_3, 14, T[26]), b = this.GG(b, c, d, a, M_offset_8, 20, T[27]), 
                a = this.GG(a, b, c, d, M_offset_13, 5, T[28]), d = this.GG(d, a, b, c, M_offset_2, 9, T[29]), 
                c = this.GG(c, d, a, b, M_offset_7, 14, T[30]), b = this.GG(b, c, d, a, M_offset_12, 20, T[31]), 
                a = this.HH(a, b, c, d, M_offset_5, 4, T[32]), d = this.HH(d, a, b, c, M_offset_8, 11, T[33]), 
                c = this.HH(c, d, a, b, M_offset_11, 16, T[34]), b = this.HH(b, c, d, a, M_offset_14, 23, T[35]), 
                a = this.HH(a, b, c, d, M_offset_1, 4, T[36]), d = this.HH(d, a, b, c, M_offset_4, 11, T[37]), 
                c = this.HH(c, d, a, b, M_offset_7, 16, T[38]), b = this.HH(b, c, d, a, M_offset_10, 23, T[39]), 
                a = this.HH(a, b, c, d, M_offset_13, 4, T[40]), d = this.HH(d, a, b, c, M_offset_0, 11, T[41]), 
                c = this.HH(c, d, a, b, M_offset_3, 16, T[42]), b = this.HH(b, c, d, a, M_offset_6, 23, T[43]), 
                a = this.HH(a, b, c, d, M_offset_9, 4, T[44]), d = this.HH(d, a, b, c, M_offset_12, 11, T[45]), 
                c = this.HH(c, d, a, b, M_offset_15, 16, T[46]), b = this.HH(b, c, d, a, M_offset_2, 23, T[47]), 
                a = this.II(a, b, c, d, M_offset_0, 6, T[48]), d = this.II(d, a, b, c, M_offset_7, 10, T[49]), 
                c = this.II(c, d, a, b, M_offset_14, 15, T[50]), b = this.II(b, c, d, a, M_offset_5, 21, T[51]), 
                a = this.II(a, b, c, d, M_offset_12, 6, T[52]), d = this.II(d, a, b, c, M_offset_3, 10, T[53]), 
                c = this.II(c, d, a, b, M_offset_10, 15, T[54]), b = this.II(b, c, d, a, M_offset_1, 21, T[55]), 
                a = this.II(a, b, c, d, M_offset_8, 6, T[56]), d = this.II(d, a, b, c, M_offset_15, 10, T[57]), 
                c = this.II(c, d, a, b, M_offset_6, 15, T[58]), b = this.II(b, c, d, a, M_offset_13, 21, T[59]), 
                a = this.II(a, b, c, d, M_offset_4, 6, T[60]), d = this.II(d, a, b, c, M_offset_11, 10, T[61]), 
                c = this.II(c, d, a, b, M_offset_2, 15, T[62]), b = this.II(b, c, d, a, M_offset_9, 21, T[63]), 
                H[0] = H[0] + a | 0, H[1] = H[1] + b | 0, H[2] = H[2] + c | 0, H[3] = H[3] + d | 0;
            }
            FF(a, b, c, d, x, s, t) {
                const n = a + (b & c | ~b & d) + x + t;
                return (n << s | n >>> 32 - s) + b;
            }
            GG(a, b, c, d, x, s, t) {
                const n = a + (b & d | c & ~d) + x + t;
                return (n << s | n >>> 32 - s) + b;
            }
            HH(a, b, c, d, x, s, t) {
                const n = a + (b ^ c ^ d) + x + t;
                return (n << s | n >>> 32 - s) + b;
            }
            II(a, b, c, d, x, s, t) {
                const n = a + (c ^ (b | ~d)) + x + t;
                return (n << s | n >>> 32 - s) + b;
            }
            resetCache() {
                this._hash = [ 1732584193, 4023233417, 2562383102, 271733878 ];
            }
            computeHash(source) {
                this.resetCache();
                const dataWords = source, nBitsTotal = 4 * source.length * 8, nBitsLeft = 4 * source.length * 8;
                dataWords[nBitsLeft >>> 5] |= 128 << 24 - nBitsLeft % 32;
                const nBitsTotalH = Math.floor(nBitsTotal / 4294967296), nBitsTotalL = nBitsTotal;
                dataWords[15 + (nBitsLeft + 64 >>> 9 << 4)] = 16711935 & (nBitsTotalH << 8 | nBitsTotalH >>> 24) | 4278255360 & (nBitsTotalH << 24 | nBitsTotalH >>> 8), 
                dataWords[14 + (nBitsLeft + 64 >>> 9 << 4)] = 16711935 & (nBitsTotalL << 8 | nBitsTotalL >>> 24) | 4278255360 & (nBitsTotalL << 24 | nBitsTotalL >>> 8), 
                this.computeHashCore(dataWords);
                const hash = this._hash;
                for (let i = 0; i < 4; i++) {
                    const H_i = hash[i];
                    hash[i] = 16711935 & (H_i << 8 | H_i >>> 24) | 4278255360 & (H_i << 24 | H_i >>> 8);
                }
                return hash;
            }
        }
        class RIPEMD160 {
            constructor() {
                this._zl = [ 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 7, 4, 13, 1, 10, 6, 15, 3, 12, 0, 9, 5, 2, 14, 11, 8, 3, 10, 14, 4, 9, 15, 8, 1, 2, 7, 0, 6, 13, 11, 5, 12, 1, 9, 11, 10, 0, 8, 12, 4, 13, 3, 7, 15, 14, 5, 6, 2, 4, 0, 5, 9, 7, 12, 2, 10, 14, 1, 3, 8, 11, 6, 15, 13 ], 
                this._zr = [ 5, 14, 7, 0, 9, 2, 11, 4, 13, 6, 15, 8, 1, 10, 3, 12, 6, 11, 3, 7, 0, 13, 5, 10, 14, 15, 8, 12, 4, 9, 1, 2, 15, 5, 1, 3, 7, 14, 6, 9, 11, 8, 12, 2, 10, 0, 4, 13, 8, 6, 4, 1, 3, 11, 15, 0, 5, 12, 2, 13, 9, 7, 10, 14, 12, 15, 10, 4, 1, 5, 8, 7, 6, 2, 13, 14, 0, 3, 9, 11 ], 
                this._sl = [ 11, 14, 15, 12, 5, 8, 7, 9, 11, 13, 14, 15, 6, 7, 9, 8, 7, 6, 8, 13, 11, 9, 7, 15, 7, 12, 15, 9, 11, 7, 13, 12, 11, 13, 6, 7, 14, 9, 13, 15, 14, 8, 13, 6, 5, 12, 7, 5, 11, 12, 14, 15, 14, 15, 9, 8, 9, 14, 5, 6, 8, 6, 5, 12, 9, 15, 5, 11, 6, 8, 13, 12, 5, 12, 13, 14, 11, 8, 5, 6 ], 
                this._sr = [ 8, 9, 9, 11, 13, 15, 15, 5, 7, 7, 8, 11, 14, 14, 12, 6, 9, 13, 15, 7, 12, 8, 9, 11, 7, 7, 12, 7, 6, 15, 13, 11, 9, 7, 15, 11, 8, 6, 6, 14, 12, 13, 5, 14, 13, 13, 7, 5, 15, 5, 8, 11, 14, 14, 6, 14, 6, 9, 12, 9, 12, 5, 15, 8, 8, 5, 12, 9, 12, 5, 14, 6, 8, 13, 6, 5, 15, 13, 11, 11 ], 
                this._hl = [ 0, 1518500249, 1859775393, 2400959708, 2840853838 ], this._hr = [ 1352829926, 1548603684, 1836072691, 2053994217, 0 ];
            }
            computeHashCore(M) {
                for (let i = 0; i < 16; i++) {
                    const offset_i = 0 + i, M_offset_i = M[offset_i];
                    M[offset_i] = 16711935 & (M_offset_i << 8 | M_offset_i >>> 24) | 4278255360 & (M_offset_i << 24 | M_offset_i >>> 8);
                }
                const H = this._hash, hl = this._hl, hr = this._hr, zl = this._zl, zr = this._zr, sl = this._sl, sr = this._sr;
                let al, bl, cl, dl, el, ar, br, cr, dr, er, t;
                ar = al = H[0], br = bl = H[1], cr = cl = H[2], dr = dl = H[3], er = el = H[4];
                for (let i = 0; i < 80; i += 1) t = al + M[0 + zl[i]] | 0, t += i < 16 ? this.f1(bl, cl, dl) + hl[0] : i < 32 ? this.f2(bl, cl, dl) + hl[1] : i < 48 ? this.f3(bl, cl, dl) + hl[2] : i < 64 ? this.f4(bl, cl, dl) + hl[3] : this.f5(bl, cl, dl) + hl[4], 
                t |= 0, t = this.rotl(t, sl[i]), t = t + el | 0, al = el, el = dl, dl = this.rotl(cl, 10), 
                cl = bl, bl = t, t = ar + M[0 + zr[i]] | 0, t += i < 16 ? this.f5(br, cr, dr) + hr[0] : i < 32 ? this.f4(br, cr, dr) + hr[1] : i < 48 ? this.f3(br, cr, dr) + hr[2] : i < 64 ? this.f2(br, cr, dr) + hr[3] : this.f1(br, cr, dr) + hr[4], 
                t |= 0, t = this.rotl(t, sr[i]), t = t + er | 0, ar = er, er = dr, dr = this.rotl(cr, 10), 
                cr = br, br = t;
                t = H[1] + cl + dr | 0, H[1] = H[2] + dl + er | 0, H[2] = H[3] + el + ar | 0, H[3] = H[4] + al + br | 0, 
                H[4] = H[0] + bl + cr | 0, H[0] = t;
            }
            f1(x, y, z) {
                return x ^ y ^ z;
            }
            f2(x, y, z) {
                return x & y | ~x & z;
            }
            f3(x, y, z) {
                return (x | ~y) ^ z;
            }
            f4(x, y, z) {
                return x & z | y & ~z;
            }
            f5(x, y, z) {
                return x ^ (y | ~z);
            }
            rotl(x, n) {
                return x << n | x >>> 32 - n;
            }
            resetCache() {
                this._hash = [ 1732584193, 4023233417, 2562383102, 271733878, 3285377520 ];
            }
            computeHash(source) {
                this.resetCache();
                const dataWords = source, nBitsTotal = 4 * source.length * 8, nBitsLeft = 4 * source.length * 8;
                dataWords[nBitsLeft >>> 5] |= 128 << 24 - nBitsLeft % 32, dataWords[14 + (nBitsLeft + 64 >>> 9 << 4)] = 16711935 & (nBitsTotal << 8 | nBitsTotal >>> 24) | 4278255360 & (nBitsTotal << 24 | nBitsTotal >>> 8);
                const H = this._hash;
                this.computeHashCore(dataWords);
                for (let i = 0; i < 5; i++) {
                    const H_i = H[i];
                    H[i] = 16711935 & (H_i << 8 | H_i >>> 24) | 4278255360 & (H_i << 24 | H_i >>> 8);
                }
                return this._hash;
            }
        }
        class SHA1 {
            computeHashCore(words) {
                const hash = this._hash;
                let temp = [], a = hash[0], b = hash[1], c = hash[2], d = hash[3], e = hash[4];
                for (let i = 0; i < 80; i++) {
                    if (i < 16) temp[i] = 0 | words[0 + i]; else {
                        const n = temp[i - 3] ^ temp[i - 8] ^ temp[i - 14] ^ temp[i - 16];
                        temp[i] = n << 1 | n >>> 31;
                    }
                    let t = (a << 5 | a >>> 27) + e + temp[i];
                    t += i < 20 ? 1518500249 + (b & c | ~b & d) : i < 40 ? 1859775393 + (b ^ c ^ d) : i < 60 ? (b & c | b & d | c & d) - 1894007588 : (b ^ c ^ d) - 899497514, 
                    e = d, d = c, c = b << 30 | b >>> 2, b = a, a = t;
                }
                hash[0] = hash[0] + a | 0, hash[1] = hash[1] + b | 0, hash[2] = hash[2] + c | 0, 
                hash[3] = hash[3] + d | 0, hash[4] = hash[4] + e | 0;
            }
            resetCache() {
                this._hash = [ 1732584193, 4023233417, 2562383102, 271733878, 3285377520 ];
            }
            computeHash(source) {
                this.resetCache();
                const dataWords = source, nBitsTotal = 4 * source.length * 8, nBitsLeft = 4 * source.length * 8;
                return dataWords[nBitsLeft >>> 5] |= 128 << 24 - nBitsLeft % 32, dataWords[14 + (nBitsLeft + 64 >>> 9 << 4)] = Math.floor(nBitsTotal / 4294967296), 
                dataWords[15 + (nBitsLeft + 64 >>> 9 << 4)] = nBitsTotal, this.computeHashCore(dataWords), 
                this._hash;
            }
        }
        class SHA256 {
            constructor() {
                this._constants = [ 1116352408, 1899447441, -1245643825, -373957723, 961987163, 1508970993, -1841331548, -1424204075, -670586216, 310598401, 607225278, 1426881987, 1925078388, -2132889090, -1680079193, -1046744716, -459576895, -272742522, 264347078, 604807628, 770255983, 1249150122, 1555081692, 1996064986, -1740746414, -1473132947, -1341970488, -1084653625, -958395405, -710438585, 113926993, 338241895, 666307205, 773529912, 1294757372, 1396182291, 1695183700, 1986661051, -2117940946, -1838011259, -1564481375, -1474664885, -1035236496, -949202525, -778901479, -694614492, -200395387, 275423344, 430227734, 506948616, 659060556, 883997877, 958139571, 1322822218, 1537002063, 1747873779, 1955562222, 2024104815, -2067236844, -1933114872, -1866530822, -1538233109, -1090935817, -965641998 ];
            }
            computeHashCore(words) {
                const constants = this._constants, hash = this._hash, temp = [];
                let a = hash[0], b = hash[1], c = hash[2], d = hash[3], e = hash[4], f = hash[5], g = hash[6], h = hash[7];
                for (let i = 0; i < 64; i++) {
                    if (i < 16) temp[i] = 0 | words[0 + i]; else {
                        const gamma0x = temp[i - 15], gamma0 = (gamma0x << 25 | gamma0x >>> 7) ^ (gamma0x << 14 | gamma0x >>> 18) ^ gamma0x >>> 3, gamma1x = temp[i - 2], gamma1 = (gamma1x << 15 | gamma1x >>> 17) ^ (gamma1x << 13 | gamma1x >>> 19) ^ gamma1x >>> 10;
                        temp[i] = gamma0 + temp[i - 7] + gamma1 + temp[i - 16];
                    }
                    const maj = a & b ^ a & c ^ b & c, sigma0 = (a << 30 | a >>> 2) ^ (a << 19 | a >>> 13) ^ (a << 10 | a >>> 22), t1 = h + ((e << 26 | e >>> 6) ^ (e << 21 | e >>> 11) ^ (e << 7 | e >>> 25)) + (e & f ^ ~e & g) + constants[i] + temp[i];
                    h = g, g = f, f = e, e = d + t1 | 0, d = c, c = b, b = a, a = t1 + (sigma0 + maj) | 0;
                }
                hash[0] = hash[0] + a | 0, hash[1] = hash[1] + b | 0, hash[2] = hash[2] + c | 0, 
                hash[3] = hash[3] + d | 0, hash[4] = hash[4] + e | 0, hash[5] = hash[5] + f | 0, 
                hash[6] = hash[6] + g | 0, hash[7] = hash[7] + h | 0;
            }
            resetCache() {
                this._hash = [ 1779033703, -1150833019, 1013904242, -1521486534, 1359893119, -1694144372, 528734635, 1541459225 ];
            }
            computeHash(source) {
                this.resetCache();
                const dataWords = source, nBitsTotal = 4 * source.length * 8, nBitsLeft = 4 * source.length * 8;
                return dataWords[nBitsLeft >>> 5] |= 128 << 24 - nBitsLeft % 32, dataWords[14 + (nBitsLeft + 64 >>> 9 << 4)] = Math.floor(nBitsTotal / 4294967296), 
                dataWords[15 + (nBitsLeft + 64 >>> 9 << 4)] = nBitsTotal, this.computeHashCore(dataWords), 
                this._hash;
            }
        }
        var RunType, JSONStylesProperty, JSONStylesGalleryHeader, JSONStyleBaseProperty, JSONCharacterStyleProperty, JSONParagraphStyleProperty, JSONNumberingListStyleProperty, JSONTableStyleProperty, JSONStyleLinkCommandBaseProperty, JSONEnumLoadPieceTableCommandParameters, JSONCreateHeaderFooterCommandBaseProperty, JSONChangeHeaderFooterIndexCommandBase, JSONEnumLoadPieceTable, JSONHeaderFooterInfoProperty, JSONBookmarkProperty, JSONRangePermissionProperty, JSONChunkProperty, JSONPieceTableInfo, JSONTabInfoProperty, JSONTableHeightUnitProperty, JSONTableWidthUnitProperty, JSONTableCellMarginsProperty, JSONTableBordersProperty, JSONTableCellBordersProperty, JSONTableConditionalStyleProperty, JSONEnumTable, JSONEnumTableProperty, JSONEnumTableParentCellInfo, JSONEnumClientTableInfo, JSONEnumClientTableFormatting, JSONEnumClientTablePosition, SectionStartType, HeaderFooterType, LineNumberingRestartType, JSONFieldProperty, JSONUpdateFieldCommand, JSONUpdateFieldCommandInfo, JSONUpdateFieldCommandDocVariableInfo, JSONUpdateFieldCommandDocVariableParameters, JSONUpdateFieldCommandResult, JSONServerUpdateFieldType, JSONRunBaseProperty, JSONInlinePictureRunProperty, JSONInlineTextBoxRunProperty, JSONAnchoredPictureRunProperty, JSONAnchoredTextBoxRunProperty, JSONDeleteRunsCommandProperty, JSONEnumTableCell, JSONEnumTableCellProperty, JSONEnumClientTableCellInfo, JSONEnumClientTableCellFormatting, JSONServerTableCellProperty, JSONEnumTableRow, JSONEnumTableRowProperty, JSONEnumClientTableRowInfo, JSONEnumClientTableRowFormatting, JSONServerTableRowProperty, JSONAbstractNumberingListProperty, JSONNumberingListProperty, JSONNumberingListLevelProperty, JSONNumberingOverrideListLevelProperty, JSONDeleteAbstractNumberingListCommandProperty, JSONAddAbstractNumberingListCommandPropery, JSONIOverrideListLevelProperty, JSONListLevelProperty, min_max = __webpack_require__(6799);
        class SHA512 {
            constructor() {
                this.initialize();
            }
            resetCache() {
                this._hash = this.getDefaultCache();
            }
            initialize() {
                this.resetCache(), this._k = [ new min_max.MinMaxNumber(3609767458, 1116352408), new min_max.MinMaxNumber(602891725, 1899447441), new min_max.MinMaxNumber(3964484399, 3049323471), new min_max.MinMaxNumber(2173295548, 3921009573), new min_max.MinMaxNumber(4081628472, 961987163), new min_max.MinMaxNumber(3053834265, 1508970993), new min_max.MinMaxNumber(2937671579, 2453635748), new min_max.MinMaxNumber(3664609560, 2870763221), new min_max.MinMaxNumber(2734883394, 3624381080), new min_max.MinMaxNumber(1164996542, 310598401), new min_max.MinMaxNumber(1323610764, 607225278), new min_max.MinMaxNumber(3590304994, 1426881987), new min_max.MinMaxNumber(4068182383, 1925078388), new min_max.MinMaxNumber(991336113, 2162078206), new min_max.MinMaxNumber(633803317, 2614888103), new min_max.MinMaxNumber(3479774868, 3248222580), new min_max.MinMaxNumber(2666613458, 3835390401), new min_max.MinMaxNumber(944711139, 4022224774), new min_max.MinMaxNumber(2341262773, 264347078), new min_max.MinMaxNumber(2007800933, 604807628), new min_max.MinMaxNumber(1495990901, 770255983), new min_max.MinMaxNumber(1856431235, 1249150122), new min_max.MinMaxNumber(3175218132, 1555081692), new min_max.MinMaxNumber(2198950837, 1996064986), new min_max.MinMaxNumber(3999719339, 2554220882), new min_max.MinMaxNumber(766784016, 2821834349), new min_max.MinMaxNumber(2566594879, 2952996808), new min_max.MinMaxNumber(3203337956, 3210313671), new min_max.MinMaxNumber(1034457026, 3336571891), new min_max.MinMaxNumber(2466948901, 3584528711), new min_max.MinMaxNumber(3758326383, 113926993), new min_max.MinMaxNumber(168717936, 338241895), new min_max.MinMaxNumber(1188179964, 666307205), new min_max.MinMaxNumber(1546045734, 773529912), new min_max.MinMaxNumber(1522805485, 1294757372), new min_max.MinMaxNumber(2643833823, 1396182291), new min_max.MinMaxNumber(2343527390, 1695183700), new min_max.MinMaxNumber(1014477480, 1986661051), new min_max.MinMaxNumber(1206759142, 2177026350), new min_max.MinMaxNumber(344077627, 2456956037), new min_max.MinMaxNumber(1290863460, 2730485921), new min_max.MinMaxNumber(3158454273, 2820302411), new min_max.MinMaxNumber(3505952657, 3259730800), new min_max.MinMaxNumber(106217008, 3345764771), new min_max.MinMaxNumber(3606008344, 3516065817), new min_max.MinMaxNumber(1432725776, 3600352804), new min_max.MinMaxNumber(1467031594, 4094571909), new min_max.MinMaxNumber(851169720, 275423344), new min_max.MinMaxNumber(3100823752, 430227734), new min_max.MinMaxNumber(1363258195, 506948616), new min_max.MinMaxNumber(3750685593, 659060556), new min_max.MinMaxNumber(3785050280, 883997877), new min_max.MinMaxNumber(3318307427, 958139571), new min_max.MinMaxNumber(3812723403, 1322822218), new min_max.MinMaxNumber(2003034995, 1537002063), new min_max.MinMaxNumber(3602036899, 1747873779), new min_max.MinMaxNumber(1575990012, 1955562222), new min_max.MinMaxNumber(1125592928, 2024104815), new min_max.MinMaxNumber(2716904306, 2227730452), new min_max.MinMaxNumber(442776044, 2361852424), new min_max.MinMaxNumber(593698344, 2428436474), new min_max.MinMaxNumber(3733110249, 2756734187), new min_max.MinMaxNumber(2999351573, 3204031479), new min_max.MinMaxNumber(3815920427, 3329325298), new min_max.MinMaxNumber(3928383900, 3391569614), new min_max.MinMaxNumber(566280711, 3515267271), new min_max.MinMaxNumber(3454069534, 3940187606), new min_max.MinMaxNumber(4000239992, 4118630271), new min_max.MinMaxNumber(1914138554, 116418474), new min_max.MinMaxNumber(2731055270, 174292421), new min_max.MinMaxNumber(3203993006, 289380356), new min_max.MinMaxNumber(320620315, 460393269), new min_max.MinMaxNumber(587496836, 685471733), new min_max.MinMaxNumber(1086792851, 852142971), new min_max.MinMaxNumber(365543100, 1017036298), new min_max.MinMaxNumber(2618297676, 1126000580), new min_max.MinMaxNumber(3409855158, 1288033470), new min_max.MinMaxNumber(4234509866, 1501505948), new min_max.MinMaxNumber(987167468, 1607167915), new min_max.MinMaxNumber(1246189591, 1816402316) ], 
                this._w = utils_list.ListUtils.initByCallback(80, (() => new min_max.MinMaxNumber(void 0, void 0)));
            }
            computeHashCore(words) {
                const W = this._w, K = this._k, H = this._hash, H0 = H[0], H1 = H[1], H2 = H[2], H3 = H[3], H4 = H[4], H5 = H[5], H6 = H[6], H7 = H[7];
                let H0h = H0.maxElement, H0l = H0.minElement, H1h = H1.maxElement, H1l = H1.minElement, H2h = H2.maxElement, H2l = H2.minElement, H3h = H3.maxElement, H3l = H3.minElement, H4h = H4.maxElement, H4l = H4.minElement, H5h = H5.maxElement, H5l = H5.minElement, H6h = H6.maxElement, H6l = H6.minElement, H7h = H7.maxElement, H7l = H7.minElement, ah = H0h, al = H0l, bh = H1h, bl = H1l, ch = H2h, cl = H2l, dh = H3h, dl = H3l, eh = H4h, el = H4l, fh = H5h, fl = H5l, gh = H6h, gl = H6l, hh = H7h, hl = H7l;
                for (let i = 0; i < 80; i++) {
                    let Wil, Wih;
                    const Wi = W[i];
                    if (i < 16) Wih = Wi.maxElement = 0 | words[0 + 2 * i], Wil = Wi.minElement = 0 | words[0 + 2 * i + 1]; else {
                        const gamma0x = W[i - 15], gamma0xh = gamma0x.maxElement, gamma0xl = gamma0x.minElement, gamma0h = (gamma0xh >>> 1 | gamma0xl << 31) ^ (gamma0xh >>> 8 | gamma0xl << 24) ^ gamma0xh >>> 7, gamma0l = (gamma0xl >>> 1 | gamma0xh << 31) ^ (gamma0xl >>> 8 | gamma0xh << 24) ^ (gamma0xl >>> 7 | gamma0xh << 25), gamma1x = W[i - 2], gamma1xh = gamma1x.maxElement, gamma1xl = gamma1x.minElement, gamma1h = (gamma1xh >>> 19 | gamma1xl << 13) ^ (gamma1xh << 3 | gamma1xl >>> 29) ^ gamma1xh >>> 6, gamma1l = (gamma1xl >>> 19 | gamma1xh << 13) ^ (gamma1xl << 3 | gamma1xh >>> 29) ^ (gamma1xl >>> 6 | gamma1xh << 26), Wi7 = W[i - 7], Wi7h = Wi7.maxElement, Wi7l = Wi7.minElement, Wi16 = W[i - 16], Wi16h = Wi16.maxElement, Wi16l = Wi16.minElement;
                        Wil = gamma0l + Wi7l, Wih = gamma0h + Wi7h + (Wil >>> 0 < gamma0l >>> 0 ? 1 : 0), 
                        Wil += gamma1l, Wih = Wih + gamma1h + (Wil >>> 0 < gamma1l >>> 0 ? 1 : 0), Wil += Wi16l, 
                        Wih = Wih + Wi16h + (Wil >>> 0 < Wi16l >>> 0 ? 1 : 0), Wi.maxElement = Wih, Wi.minElement = Wil;
                    }
                    const chh = eh & fh ^ ~eh & gh, chl = el & fl ^ ~el & gl, majh = ah & bh ^ ah & ch ^ bh & ch, majl = al & bl ^ al & cl ^ bl & cl, sigma0h = (ah >>> 28 | al << 4) ^ (ah << 30 | al >>> 2) ^ (ah << 25 | al >>> 7), sigma0l = (al >>> 28 | ah << 4) ^ (al << 30 | ah >>> 2) ^ (al << 25 | ah >>> 7), sigma1h = (eh >>> 14 | el << 18) ^ (eh >>> 18 | el << 14) ^ (eh << 23 | el >>> 9), sigma1l = (el >>> 14 | eh << 18) ^ (el >>> 18 | eh << 14) ^ (el << 23 | eh >>> 9), Ki = K[i], Kih = Ki.maxElement, Kil = Ki.minElement;
                    let t1l = hl + sigma1l, t1h = hh + sigma1h + (t1l >>> 0 < hl >>> 0 ? 1 : 0);
                    t1l += chl, t1h = t1h + chh + (t1l >>> 0 < chl >>> 0 ? 1 : 0), t1l += Kil, t1h = t1h + Kih + (t1l >>> 0 < Kil >>> 0 ? 1 : 0), 
                    t1l += Wil, t1h = t1h + Wih + (t1l >>> 0 < Wil >>> 0 ? 1 : 0);
                    const t2l = sigma0l + majl;
                    hh = gh, hl = gl, gh = fh, gl = fl, fh = eh, fl = el, el = dl + t1l | 0, eh = dh + t1h + (el >>> 0 < dl >>> 0 ? 1 : 0) | 0, 
                    dh = ch, dl = cl, ch = bh, cl = bl, bh = ah, bl = al, al = t1l + t2l | 0, ah = t1h + (sigma0h + majh + (t2l >>> 0 < sigma0l >>> 0 ? 1 : 0)) + (al >>> 0 < t1l >>> 0 ? 1 : 0) | 0;
                }
                H0l = H0.minElement = H0l + al, H0.maxElement = H0h + ah + (H0l >>> 0 < al >>> 0 ? 1 : 0), 
                H1l = H1.minElement = H1l + bl, H1.maxElement = H1h + bh + (H1l >>> 0 < bl >>> 0 ? 1 : 0), 
                H2l = H2.minElement = H2l + cl, H2.maxElement = H2h + ch + (H2l >>> 0 < cl >>> 0 ? 1 : 0), 
                H3l = H3.minElement = H3l + dl, H3.maxElement = H3h + dh + (H3l >>> 0 < dl >>> 0 ? 1 : 0), 
                H4l = H4.minElement = H4l + el, H4.maxElement = H4h + eh + (H4l >>> 0 < el >>> 0 ? 1 : 0), 
                H5l = H5.minElement = H5l + fl, H5.maxElement = H5h + fh + (H5l >>> 0 < fl >>> 0 ? 1 : 0), 
                H6l = H6.minElement = H6l + gl, H6.maxElement = H6h + gh + (H6l >>> 0 < gl >>> 0 ? 1 : 0), 
                H7l = H7.minElement = H7l + hl, H7.maxElement = H7h + hh + (H7l >>> 0 < hl >>> 0 ? 1 : 0);
            }
            getDefaultCache() {
                return [ new min_max.MinMaxNumber(4089235720, 1779033703), new min_max.MinMaxNumber(2227873595, 3144134277), new min_max.MinMaxNumber(4271175723, 1013904242), new min_max.MinMaxNumber(1595750129, 2773480762), new min_max.MinMaxNumber(2917565137, 1359893119), new min_max.MinMaxNumber(725511199, 2600822924), new min_max.MinMaxNumber(4215389547, 528734635), new min_max.MinMaxNumber(327033209, 1541459225) ];
            }
            computeHash(source) {
                this.resetCache();
                const dataWords = source, nBitsTotal = 4 * source.length * 8, nBitsLeft = 4 * source.length * 8;
                return dataWords[nBitsLeft >>> 5] |= 128 << 24 - nBitsLeft % 32, dataWords[30 + (nBitsLeft + 128 >>> 10 << 5)] = Math.floor(nBitsTotal / 4294967296), 
                dataWords[31 + (nBitsLeft + 128 >>> 10 << 5)] = nBitsTotal, this.computeHashCore(dataWords), 
                this.toX32Words(this._hash);
            }
            toX32Words(x64Words) {
                const x64WordsLength = x64Words.length, x32Words = [];
                for (let i = 0; i < x64WordsLength; i++) {
                    const x64Word = x64Words[i];
                    x32Words.push(x64Word.maxElement), x32Words.push(x64Word.minElement);
                }
                return x32Words;
            }
        }
        class SHA384 extends SHA512 {
            constructor() {
                super();
            }
            getDefaultCache() {
                return [ new min_max.MinMaxNumber(3238371032, 3418070365), new min_max.MinMaxNumber(914150663, 1654270250), new min_max.MinMaxNumber(812702999, 2438529370), new min_max.MinMaxNumber(4144912697, 355462360), new min_max.MinMaxNumber(4290775857, 1731405415), new min_max.MinMaxNumber(1750603025, 2394180231), new min_max.MinMaxNumber(1694076839, 3675008525), new min_max.MinMaxNumber(3204075428, 1203062813) ];
            }
            computeHash(source) {
                const words = super.computeHash(source);
                return words.length -= 4, words;
            }
        }
        class PasswordHashCodeCalculator {
            getBytes(val) {
                return new Uint8Array(new Uint32Array([ val ]).buffer);
            }
            calculateLegacyPasswordHash(password) {
                return utils_string.StringUtils.isNullOrEmpty(password) ? null : this.getBytes(this.calculateLegacyPasswordHashInt(password));
            }
            calculateLegacyPasswordHashInt(password) {
                if (utils_string.StringUtils.isNullOrEmpty(password)) return 0;
                const bytes = this.calculatePasswordBytes(password), high = this.calculateKeyHighWord(bytes), low = this.calculateKeyLowWord(bytes);
                return low << 24 & 4278190080 | low << 8 & 16711680 | high << 8 & 65280 | high >> 8 & 255;
            }
            calculatePasswordHash(password, prefix, hashCount, hashAlgorithmType) {
                const hashAlgorithm = this.createHashAlgorithm(hashAlgorithmType);
                if (hashAlgorithm) return this.calculatePasswordHashAfterDetectedAlgoritm(password, prefix, hashCount, hashAlgorithm);
                {
                    const legacyPasswordHash = this.calculateLegacyPasswordHashInt(password);
                    return this.concatenate(new Uint8Array(0), legacyPasswordHash);
                }
            }
            generatePasswordPrefix(length) {
                const result = [];
                for (let i = 0; i < length; i++) result[i] = math.MathUtils.getRandomInt(0, 1e3);
                return new Uint8Array(result);
            }
            createHashAlgorithm(hashAlgorithmType) {
                switch (hashAlgorithmType) {
                  case HashAlgorithmType.Sha1:
                    return new SHA1;

                  case HashAlgorithmType.Sha256:
                    return new SHA256;

                  case HashAlgorithmType.Sha384:
                    return new SHA384;

                  case HashAlgorithmType.Sha512:
                    return new SHA512;

                  case HashAlgorithmType.Md5:
                    return new MD5;

                  case HashAlgorithmType.Ripemd160:
                    return new RIPEMD160;

                  case HashAlgorithmType.None:
                  case HashAlgorithmType.Mac:
                  case HashAlgorithmType.HMac:
                  case HashAlgorithmType.Ripemd:
                  case HashAlgorithmType.Md2:
                  case HashAlgorithmType.Md4:
                  default:
                    return null;
                }
            }
            calculatePasswordHashAfterDetectedAlgoritm(password, prefix, hashCount, hashAlgorithm) {
                const legacyPasswordHash = this.calculateLegacyPasswordHashInt(password);
                return this.calculatePasswordHashCore(this.getUnicodeArray(RichNumberConverter.convertToHexBinary(legacyPasswordHash).toUpperCase()), prefix, hashCount, hashAlgorithm);
            }
            getUnicodeArray(base64) {
                let n = base64.length;
                const arr = new Uint8Array(2 * n);
                for (;n--; ) {
                    const index = 2 * n;
                    arr[index] = base64.charCodeAt(n), arr[index + 1] = 0;
                }
                return arr;
            }
            calculatePasswordHashCore(legacyPasswordHash, prefix, hashCount, hashAlgorithm) {
                let bytes = this.concatenateArrays(prefix, legacyPasswordHash), wordArray = this.byteArrayToWordArray(bytes);
                for (let i = 0; wordArray = hashAlgorithm.computeHash(wordArray), i < hashCount; ) wordArray = this.concatenateArray(wordArray, i), 
                i++;
                return new Uint8Array(this.wordArrayToByteArray(wordArray, wordArray.length));
            }
            byteArrayToWordArray(bytes) {
                const result = [];
                for (let i = 0; i < bytes.length; i++) result[i / 4 | 0] |= bytes[i] << 24 - 8 * i;
                return result;
            }
            wordToByteArray(word, length) {
                const bytes = [];
                return length > 0 && bytes.push(word >>> 24), length > 1 && bytes.push(word >>> 16 & 255), 
                length > 2 && bytes.push(word >>> 8 & 255), length > 3 && bytes.push(255 & word), 
                bytes;
            }
            wordArrayToByteArray(wordArray, length) {
                length = 4 * wordArray.length;
                const result = [];
                let bytes, i = 0;
                for (;length > 0; ) bytes = this.wordToByteArray(wordArray[i], Math.min(4, length)), 
                length -= bytes.length, result.push(bytes), i++;
                return [].concat.apply([], result);
            }
            concatenateArrays(b1, b2) {
                if (null == b1) return b2;
                if (null == b2) return b1;
                const result = new Uint8Array(b1.length + b2.length);
                return result.set(b1), result.set(b2, b1.length), result;
            }
            concatenate(bytes, num) {
                const countBytes = new Array(4);
                countBytes[3] = (4278190080 & num) >> 24, countBytes[2] = (16711680 & num) >> 16, 
                countBytes[1] = (65280 & num) >> 8, countBytes[0] = 255 & num;
                const result = new Uint8Array(bytes.length + countBytes.length);
                return result.set(bytes), result.set(countBytes, bytes.length), result;
            }
            concatenateArray(wordArray, num) {
                const countBytes = new Array(4);
                countBytes[3] = (4278190080 & num) >> 24, countBytes[2] = (16711680 & num) >> 16, 
                countBytes[1] = (65280 & num) >> 8, countBytes[0] = 255 & num;
                const newWordArray = this.byteArrayToWordArray(countBytes);
                return wordArray.concat(newWordArray);
            }
            static compareByteArrays(b1, b2) {
                if (b1 === b2) return !0;
                if (null == b1 || null == b2) return !1;
                if (b1.length != b2.length) return !1;
                const count = b1.length;
                for (let i = 0; i < count; i++) if (b1[i] != b2[i]) return !1;
                return !0;
            }
            calculatePasswordBytes(password) {
                password.length > 15 && (password = password.substr(0, 15));
                const count = password.length, bytes = new Array(count);
                for (let i = 0; i < count; i++) {
                    const ch = password.charCodeAt(i);
                    bytes[i] = 255 & ch ? 255 & ch : ch >> 8;
                }
                return bytes;
            }
            calculateKeyLowWord(bytes) {
                let result = 0;
                const count = bytes.length;
                for (let i = count - 1; i >= 0; i--) result = this.processLowWordByte(result, bytes[i]);
                return result = 52811 ^ this.processLowWordByte(result, count), result;
            }
            processLowWordByte(key, b) {
                return (key >> 14 & 1 | key << 1 & 32767) ^ b;
            }
            calculateKeyHighWord(bytes) {
                const count = bytes.length;
                let result = PasswordHashCodeCalculator.initialValues[count - 1];
                for (let i = 0; i < count; i++) result = this.processHighWordByte(result, bytes[i], 15 - (count - i));
                return result;
            }
            processHighWordByte(key, b, rowIndex) {
                let mask = 1;
                for (let i = 0; i <= 6; i++, mask <<= 1) b & mask && (key ^= PasswordHashCodeCalculator.encryptionMatrix[rowIndex][i]);
                return key;
            }
        }
        PasswordHashCodeCalculator.initialValues = [ 57840, 7439, 52380, 33984, 4364, 3600, 61902, 12606, 6258, 57657, 54287, 34041, 10252, 43370, 20163 ], 
        PasswordHashCodeCalculator.encryptionMatrix = [ [ 44796, 19929, 39858, 10053, 20106, 40212, 10761 ], [ 31585, 63170, 64933, 60267, 50935, 40399, 11199 ], [ 17763, 35526, 1453, 2906, 5812, 11624, 23248 ], [ 885, 1770, 3540, 7080, 14160, 28320, 56640 ], [ 55369, 41139, 20807, 41614, 21821, 43642, 17621 ], [ 28485, 56970, 44341, 19019, 38038, 14605, 29210 ], [ 60195, 50791, 40175, 10751, 21502, 43004, 24537 ], [ 18387, 36774, 3949, 7898, 15796, 31592, 63184 ], [ 47201, 24803, 49606, 37805, 14203, 28406, 56812 ], [ 17824, 35648, 1697, 3394, 6788, 13576, 27152 ], [ 43601, 17539, 35078, 557, 1114, 2228, 4456 ], [ 30388, 60776, 51953, 34243, 7079, 14158, 28316 ], [ 14128, 28256, 56512, 43425, 17251, 34502, 7597 ], [ 13105, 26210, 52420, 35241, 883, 1766, 3532 ], [ 4129, 8258, 16516, 33032, 4657, 9314, 18628 ] ];
        class RunBase {
            constructor(startOffset, paragraph, charPropsBundle) {
                this.startOffset = startOffset, this.paragraph = paragraph, this.characterStyle = charPropsBundle.style, 
                this.setCharacterProperties(charPropsBundle.props), this.mergedCharacterProperties = null;
            }
            isParagraphOrSectionRun() {
                return !1;
            }
            setCharacterProperties(properties) {
                this.maskedCharacterProperties = this.paragraph.subDocument.documentModel.cache.maskedCharacterPropertiesCache.getItem(properties);
            }
            onCharacterPropertiesChanged() {
                this.resetCharacterMergedProperties();
            }
            hasCharacterMergedProperies() {
                return !!this.mergedCharacterProperties;
            }
            resetCharacterMergedProperties() {
                this.mergedCharacterProperties = null;
            }
            getCharacterMergedProperties() {
                return this.mergedCharacterProperties || (this.mergedCharacterProperties = this.mergeCharacterProperties()), 
                this.mergedCharacterProperties;
            }
            mergeCharacterProperties(options) {
                const merger = new CharacterPropertiesMerger;
                merger.mergeCharacterProperties(this.maskedCharacterProperties), options && options.excludeCharacterStyle || merger.mergeCharacterStyle(this.characterStyle), 
                merger.mergeParagraphStyle(this.paragraph.paragraphStyle);
                const tableCell = this.paragraph.getTableCell();
                return tableCell && merger.mergeTableStyles(tableCell), merger.mergeCharacterProperties(this.paragraph.subDocument.documentModel.defaultCharacterProperties), 
                this.paragraph.subDocument.documentModel.cache.mergedCharacterPropertiesCache.getItem(merger.getMergedProperties());
            }
            setCharacterMergedProperies(properties) {
                this.mergedCharacterProperties = this.paragraph.subDocument.documentModel.cache.mergedCharacterPropertiesCache.getItem(properties);
            }
            copyFrom(obj) {
                this.startOffset = obj.startOffset, this.paragraph = obj.paragraph, this.characterStyle = obj.characterStyle, 
                this.maskedCharacterProperties = obj.maskedCharacterProperties, this.mergedCharacterProperties = obj.mergedCharacterProperties;
            }
            createSimularity(startOffset, length, paragraph, characterStyle, maskedCharacterProperties) {
                const simularity = this.clone();
                return simularity.startOffset = startOffset, simularity.paragraph = paragraph, simularity.characterStyle = characterStyle, 
                simularity.maskedCharacterProperties = maskedCharacterProperties, simularity.setLength(length), 
                simularity;
            }
            getCharPropsBundle(model) {
                return new MaskedCharacterPropertiesBundle(model.cache.maskedCharacterPropertiesCache.getItem(this.maskedCharacterProperties), model.stylesManager.addCharacterStyle(this.characterStyle));
            }
        }
        RunBase.anchoredObjectIdCounter = 0;
        class OneCharRun extends RunBase {
            getLength() {
                return 1;
            }
            setLength(newLength) {
                if (1 != newLength) throw new Error(errors.D.InternalException);
            }
            incLength(_additionalLength) {
                throw new Error(errors.D.InternalException);
            }
        }
        class PictureRun extends OneCharRun {
            constructor(startOffset, paragraph, charPropsBundle, info) {
                super(startOffset, paragraph, charPropsBundle), this.info = info;
            }
            get shape() {
                return this.info.shape;
            }
            set shape(val) {
                this.info.shape = val;
            }
            get size() {
                return this.info.size;
            }
            set size(val) {
                this.info.size = val;
            }
            get cacheInfo() {
                return this.info.cacheInfo;
            }
            getActualSize() {
                return this.info.size.actualSize;
            }
            copyFrom(obj) {
                super.copyFrom(obj), this.info = obj.info.clone();
            }
        }
        class TextBoxRun extends OneCharRun {
            constructor(startOffset, paragraph, charPropsBundle, shape, subDocId, textBoxProperties, containerProperties) {
                super(startOffset, paragraph, charPropsBundle), this.shape = shape, this.subDocId = subDocId, 
                this.textBoxProperties = textBoxProperties, this.containerProperties = containerProperties;
            }
            copyFrom(obj) {
                super.copyFrom(obj), this.shape = obj.shape.clone(), this.subDocId = obj.subDocId;
            }
        }
        !function(RunType) {
            RunType[RunType.Undefined = -1] = "Undefined", RunType[RunType.TextRun = 1] = "TextRun", 
            RunType[RunType.ParagraphRun = 2] = "ParagraphRun", RunType[RunType.SectionRun = 3] = "SectionRun", 
            RunType[RunType.FieldCodeStartRun = 4] = "FieldCodeStartRun", RunType[RunType.FieldCodeEndRun = 5] = "FieldCodeEndRun", 
            RunType[RunType.FieldResultEndRun = 6] = "FieldResultEndRun", RunType[RunType.AnchoredPictureRun = 7] = "AnchoredPictureRun", 
            RunType[RunType.AnchoredTextBoxRun = 8] = "AnchoredTextBoxRun", RunType[RunType.InlinePictureRun = 9] = "InlinePictureRun", 
            RunType[RunType.InlineTextBoxRun = 10] = "InlineTextBoxRun", RunType[RunType.LayoutDependentRun = 11] = "LayoutDependentRun", 
            RunType[RunType.FootNoteRun = 12] = "FootNoteRun", RunType[RunType.EndNoteRun = 13] = "EndNoteRun", 
            RunType[RunType.NoteSeparatorRun = 14] = "NoteSeparatorRun", RunType[RunType.NoteContinuationSeparatorRun = 15] = "NoteContinuationSeparatorRun";
        }(RunType || (RunType = {}));
        class SectionRun extends OneCharRun {
            getType() {
                return RunType.SectionRun;
            }
            isParagraphOrSectionRun() {
                return !0;
            }
            clone() {
                return new SectionRun(this.startOffset, this.paragraph, new MaskedCharacterPropertiesBundle(this.maskedCharacterProperties, this.characterStyle));
            }
            cloneToNewSubDocument(subDocument) {
                return new SectionRun(this.startOffset, subDocument.getParagraphByPosition(this.paragraph.startLogPosition.value), new MaskedCharacterPropertiesBundle(subDocument.documentModel.cache.maskedCharacterPropertiesCache.getItem(this.maskedCharacterProperties), subDocument.documentModel.stylesManager.getCharacterStyleByName(this.characterStyle.styleName)));
            }
        }
        class ParagraphRun extends OneCharRun {
            getType() {
                return RunType.ParagraphRun;
            }
            isParagraphOrSectionRun() {
                return !0;
            }
            clone() {
                return new ParagraphRun(this.startOffset, this.paragraph, new MaskedCharacterPropertiesBundle(this.maskedCharacterProperties, this.characterStyle));
            }
            cloneToNewSubDocument(subDocument) {
                return new ParagraphRun(this.startOffset, subDocument.getParagraphByPosition(this.paragraph.startLogPosition.value), new MaskedCharacterPropertiesBundle(subDocument.documentModel.cache.maskedCharacterPropertiesCache.getItem(this.maskedCharacterProperties), subDocument.documentModel.stylesManager.getCharacterStyleByName(this.characterStyle.styleName)));
            }
        }
        class FieldCodeStartRun extends OneCharRun {
            getType() {
                return RunType.FieldCodeStartRun;
            }
            clone() {
                return new FieldCodeStartRun(this.startOffset, this.paragraph, new MaskedCharacterPropertiesBundle(this.maskedCharacterProperties, this.characterStyle));
            }
            cloneToNewSubDocument(subDocument) {
                return new FieldCodeStartRun(this.startOffset, subDocument.getParagraphByPosition(this.paragraph.startLogPosition.value), new MaskedCharacterPropertiesBundle(subDocument.documentModel.cache.maskedCharacterPropertiesCache.getItem(this.maskedCharacterProperties), subDocument.documentModel.stylesManager.getCharacterStyleByName(this.characterStyle.styleName)));
            }
        }
        class FieldCodeEndRun extends OneCharRun {
            getType() {
                return RunType.FieldCodeEndRun;
            }
            clone() {
                return new FieldCodeEndRun(this.startOffset, this.paragraph, new MaskedCharacterPropertiesBundle(this.maskedCharacterProperties, this.characterStyle));
            }
            cloneToNewSubDocument(subDocument) {
                return new FieldCodeEndRun(this.startOffset, subDocument.getParagraphByPosition(this.paragraph.startLogPosition.value), new MaskedCharacterPropertiesBundle(subDocument.documentModel.cache.maskedCharacterPropertiesCache.getItem(this.maskedCharacterProperties), subDocument.documentModel.stylesManager.getCharacterStyleByName(this.characterStyle.styleName)));
            }
        }
        class FieldResultEndRun extends OneCharRun {
            getType() {
                return RunType.FieldResultEndRun;
            }
            clone() {
                return new FieldResultEndRun(this.startOffset, this.paragraph, new MaskedCharacterPropertiesBundle(this.maskedCharacterProperties, this.characterStyle));
            }
            cloneToNewSubDocument(subDocument) {
                return new FieldResultEndRun(this.startOffset, subDocument.getParagraphByPosition(this.paragraph.startLogPosition.value), new MaskedCharacterPropertiesBundle(subDocument.documentModel.cache.maskedCharacterPropertiesCache.getItem(this.maskedCharacterProperties), subDocument.documentModel.stylesManager.getCharacterStyleByName(this.characterStyle.styleName)));
            }
        }
        class LayoutDependentRun extends OneCharRun {
            getType() {
                return RunType.LayoutDependentRun;
            }
            clone() {
                return new LayoutDependentRun(this.startOffset, this.paragraph, new MaskedCharacterPropertiesBundle(this.maskedCharacterProperties, this.characterStyle));
            }
            cloneToNewSubDocument(subDocument) {
                return new LayoutDependentRun(this.startOffset, subDocument.getParagraphByPosition(this.paragraph.startLogPosition.value), new MaskedCharacterPropertiesBundle(subDocument.documentModel.cache.maskedCharacterPropertiesCache.getItem(this.maskedCharacterProperties), subDocument.documentModel.stylesManager.getCharacterStyleByName(this.characterStyle.styleName)));
            }
        }
        class FootNoteRun extends OneCharRun {
            getType() {
                return RunType.FootNoteRun;
            }
            clone() {
                return new FootNoteRun(this.startOffset, this.paragraph, new MaskedCharacterPropertiesBundle(this.maskedCharacterProperties, this.characterStyle));
            }
            cloneToNewSubDocument(subDocument) {
                return new FootNoteRun(this.startOffset, subDocument.getParagraphByPosition(this.paragraph.startLogPosition.value), new MaskedCharacterPropertiesBundle(subDocument.documentModel.cache.maskedCharacterPropertiesCache.getItem(this.maskedCharacterProperties), subDocument.documentModel.stylesManager.getCharacterStyleByName(this.characterStyle.styleName)));
            }
        }
        class EndNoteRun extends OneCharRun {
            getType() {
                return RunType.EndNoteRun;
            }
            clone() {
                return new EndNoteRun(this.startOffset, this.paragraph, new MaskedCharacterPropertiesBundle(this.maskedCharacterProperties, this.characterStyle));
            }
            cloneToNewSubDocument(subDocument) {
                return new EndNoteRun(this.startOffset, subDocument.getParagraphByPosition(this.paragraph.startLogPosition.value), new MaskedCharacterPropertiesBundle(subDocument.documentModel.cache.maskedCharacterPropertiesCache.getItem(this.maskedCharacterProperties), subDocument.documentModel.stylesManager.getCharacterStyleByName(this.characterStyle.styleName)));
            }
        }
        class NoteSeparatorRun extends OneCharRun {
            getType() {
                return RunType.NoteSeparatorRun;
            }
            clone() {
                return new NoteSeparatorRun(this.startOffset, this.paragraph, new MaskedCharacterPropertiesBundle(this.maskedCharacterProperties, this.characterStyle));
            }
            cloneToNewSubDocument(subDocument) {
                return new NoteSeparatorRun(this.startOffset, subDocument.getParagraphByPosition(this.paragraph.startLogPosition.value), new MaskedCharacterPropertiesBundle(subDocument.documentModel.cache.maskedCharacterPropertiesCache.getItem(this.maskedCharacterProperties), subDocument.documentModel.stylesManager.getCharacterStyleByName(this.characterStyle.styleName)));
            }
        }
        class NoteContinuationSeparatorRun extends OneCharRun {
            getType() {
                return RunType.NoteContinuationSeparatorRun;
            }
            clone() {
                return new NoteContinuationSeparatorRun(this.startOffset, this.paragraph, new MaskedCharacterPropertiesBundle(this.maskedCharacterProperties, this.characterStyle));
            }
            cloneToNewSubDocument(subDocument) {
                return new NoteContinuationSeparatorRun(this.startOffset, subDocument.getParagraphByPosition(this.paragraph.startLogPosition.value), new MaskedCharacterPropertiesBundle(subDocument.documentModel.cache.maskedCharacterPropertiesCache.getItem(this.maskedCharacterProperties), subDocument.documentModel.stylesManager.getCharacterStyleByName(this.characterStyle.styleName)));
            }
        }
        class CharacterStyle extends StyleBase {
            constructor(styleName, localizedName, deleted, hidden, semihidden, isDefault, maskedCharacterProperties, base64EncodedImage, id) {
                super(styleName, localizedName, deleted, hidden, semihidden, isDefault, base64EncodedImage || null, id), 
                this.maskedCharacterProperties = maskedCharacterProperties;
            }
            clone() {
                const style = new CharacterStyle(this.styleName, this.localizedName, this.deleted, this.hidden, this.semihidden, this.isDefault, this.maskedCharacterProperties, this.base64EncodedImage, this.id);
                return style.parent = this.parent, style.linkedStyle = this.linkedStyle, style.primary = this.primary, 
                style;
            }
        }
        CharacterStyle.defaultParagraphCharacterStyleName = "Default Paragraph Font", CharacterStyle.hyperlinkStyleName = "Hyperlink", 
        CharacterStyle.lineNumberingStyleName = "Line Number", function(JSONStylesProperty) {
            JSONStylesProperty[JSONStylesProperty.Character = 0] = "Character", JSONStylesProperty[JSONStylesProperty.Paragraph = 1] = "Paragraph", 
            JSONStylesProperty[JSONStylesProperty.Table = 2] = "Table", JSONStylesProperty[JSONStylesProperty.TableCell = 3] = "TableCell", 
            JSONStylesProperty[JSONStylesProperty.NumberingList = 4] = "NumberingList", JSONStylesProperty[JSONStylesProperty.Caches = 5] = "Caches", 
            JSONStylesProperty[JSONStylesProperty.MAX_VALUE = 6] = "MAX_VALUE";
        }(JSONStylesProperty || (JSONStylesProperty = {})), function(JSONStylesGalleryHeader) {
            JSONStylesGalleryHeader[JSONStylesGalleryHeader.Character = 6] = "Character", JSONStylesGalleryHeader[JSONStylesGalleryHeader.Paragraph = 7] = "Paragraph", 
            JSONStylesGalleryHeader[JSONStylesGalleryHeader.Table = 8] = "Table";
        }(JSONStylesGalleryHeader || (JSONStylesGalleryHeader = {})), function(JSONStyleBaseProperty) {
            JSONStyleBaseProperty[JSONStyleBaseProperty.StyleName = 0] = "StyleName", JSONStyleBaseProperty[JSONStyleBaseProperty.Deleted = 1] = "Deleted", 
            JSONStyleBaseProperty[JSONStyleBaseProperty.Hidden = 2] = "Hidden", JSONStyleBaseProperty[JSONStyleBaseProperty.ParentStyleName = 3] = "ParentStyleName", 
            JSONStyleBaseProperty[JSONStyleBaseProperty.Semihidden = 4] = "Semihidden", JSONStyleBaseProperty[JSONStyleBaseProperty.LocalizedStyleName = 5] = "LocalizedStyleName", 
            JSONStyleBaseProperty[JSONStyleBaseProperty.IsDefault = 6] = "IsDefault", JSONStyleBaseProperty[JSONStyleBaseProperty.Base64EncodedImage = 7] = "Base64EncodedImage", 
            JSONStyleBaseProperty[JSONStyleBaseProperty.MAX_VALUE = 8] = "MAX_VALUE";
        }(JSONStyleBaseProperty || (JSONStyleBaseProperty = {})), function(JSONCharacterStyleProperty) {
            JSONCharacterStyleProperty[JSONCharacterStyleProperty.LinkedStyleName = 8] = "LinkedStyleName", 
            JSONCharacterStyleProperty[JSONCharacterStyleProperty.CharacterPropertiesCacheIndex = 9] = "CharacterPropertiesCacheIndex";
        }(JSONCharacterStyleProperty || (JSONCharacterStyleProperty = {})), function(JSONParagraphStyleProperty) {
            JSONParagraphStyleProperty[JSONParagraphStyleProperty.CharacterPropertiesCacheIndex = 8] = "CharacterPropertiesCacheIndex", 
            JSONParagraphStyleProperty[JSONParagraphStyleProperty.ParagraphPropertiesCacheIndex = 9] = "ParagraphPropertiesCacheIndex", 
            JSONParagraphStyleProperty[JSONParagraphStyleProperty.LinkedStyleName = 10] = "LinkedStyleName", 
            JSONParagraphStyleProperty[JSONParagraphStyleProperty.NextParagraphStyleName = 11] = "NextParagraphStyleName", 
            JSONParagraphStyleProperty[JSONParagraphStyleProperty.AutoUpdate = 12] = "AutoUpdate", 
            JSONParagraphStyleProperty[JSONParagraphStyleProperty.Tabs = 13] = "Tabs", JSONParagraphStyleProperty[JSONParagraphStyleProperty.NumberingListIndex = 14] = "NumberingListIndex", 
            JSONParagraphStyleProperty[JSONParagraphStyleProperty.ListLevelIndex = 15] = "ListLevelIndex";
        }(JSONParagraphStyleProperty || (JSONParagraphStyleProperty = {})), function(JSONNumberingListStyleProperty) {
            JSONNumberingListStyleProperty[JSONNumberingListStyleProperty.NumberingListIndex = 8] = "NumberingListIndex";
        }(JSONNumberingListStyleProperty || (JSONNumberingListStyleProperty = {})), function(JSONTableStyleProperty) {
            JSONTableStyleProperty[JSONTableStyleProperty.BaseConditionalStyle = 8] = "BaseConditionalStyle", 
            JSONTableStyleProperty[JSONTableStyleProperty.ConditionalStyles = 9] = "ConditionalStyles";
        }(JSONTableStyleProperty || (JSONTableStyleProperty = {})), function(JSONStyleLinkCommandBaseProperty) {
            JSONStyleLinkCommandBaseProperty[JSONStyleLinkCommandBaseProperty.StyleName = 0] = "StyleName";
        }(JSONStyleLinkCommandBaseProperty || (JSONStyleLinkCommandBaseProperty = {})), 
        function(JSONEnumLoadPieceTableCommandParameters) {
            JSONEnumLoadPieceTableCommandParameters[JSONEnumLoadPieceTableCommandParameters.LoadOnOneRequest = 0] = "LoadOnOneRequest", 
            JSONEnumLoadPieceTableCommandParameters[JSONEnumLoadPieceTableCommandParameters.StartPosition = 1] = "StartPosition", 
            JSONEnumLoadPieceTableCommandParameters[JSONEnumLoadPieceTableCommandParameters.MaxChunkLength = 2] = "MaxChunkLength", 
            JSONEnumLoadPieceTableCommandParameters[JSONEnumLoadPieceTableCommandParameters.Length = 3] = "Length";
        }(JSONEnumLoadPieceTableCommandParameters || (JSONEnumLoadPieceTableCommandParameters = {})), 
        function(JSONCreateHeaderFooterCommandBaseProperty) {
            JSONCreateHeaderFooterCommandBaseProperty[JSONCreateHeaderFooterCommandBaseProperty.Type = 0] = "Type";
        }(JSONCreateHeaderFooterCommandBaseProperty || (JSONCreateHeaderFooterCommandBaseProperty = {})), 
        function(JSONChangeHeaderFooterIndexCommandBase) {
            JSONChangeHeaderFooterIndexCommandBase[JSONChangeHeaderFooterIndexCommandBase.SectionIndex = 0] = "SectionIndex", 
            JSONChangeHeaderFooterIndexCommandBase[JSONChangeHeaderFooterIndexCommandBase.NewObjectIndex = 1] = "NewObjectIndex", 
            JSONChangeHeaderFooterIndexCommandBase[JSONChangeHeaderFooterIndexCommandBase.Type = 2] = "Type";
        }(JSONChangeHeaderFooterIndexCommandBase || (JSONChangeHeaderFooterIndexCommandBase = {})), 
        function(JSONEnumLoadPieceTable) {
            JSONEnumLoadPieceTable[JSONEnumLoadPieceTable.Bookmarks = 0] = "Bookmarks", JSONEnumLoadPieceTable[JSONEnumLoadPieceTable.Fields = 1] = "Fields", 
            JSONEnumLoadPieceTable[JSONEnumLoadPieceTable.Tables = 2] = "Tables", JSONEnumLoadPieceTable[JSONEnumLoadPieceTable.Chunks = 3] = "Chunks", 
            JSONEnumLoadPieceTable[JSONEnumLoadPieceTable.Paragraphs = 4] = "Paragraphs", JSONEnumLoadPieceTable[JSONEnumLoadPieceTable.RangePermissions = 5] = "RangePermissions";
        }(JSONEnumLoadPieceTable || (JSONEnumLoadPieceTable = {})), function(JSONHeaderFooterInfoProperty) {
            JSONHeaderFooterInfoProperty[JSONHeaderFooterInfoProperty.SubDocumentId = 0] = "SubDocumentId", 
            JSONHeaderFooterInfoProperty[JSONHeaderFooterInfoProperty.Type = 1] = "Type";
        }(JSONHeaderFooterInfoProperty || (JSONHeaderFooterInfoProperty = {})), function(JSONBookmarkProperty) {
            JSONBookmarkProperty[JSONBookmarkProperty.StartPos = 0] = "StartPos", JSONBookmarkProperty[JSONBookmarkProperty.Length = 1] = "Length", 
            JSONBookmarkProperty[JSONBookmarkProperty.Name = 2] = "Name";
        }(JSONBookmarkProperty || (JSONBookmarkProperty = {})), function(JSONRangePermissionProperty) {
            JSONRangePermissionProperty[JSONRangePermissionProperty.Start = 0] = "Start", JSONRangePermissionProperty[JSONRangePermissionProperty.Length = 1] = "Length", 
            JSONRangePermissionProperty[JSONRangePermissionProperty.UserName = 2] = "UserName", 
            JSONRangePermissionProperty[JSONRangePermissionProperty.Group = 3] = "Group";
        }(JSONRangePermissionProperty || (JSONRangePermissionProperty = {})), function(JSONChunkProperty) {
            JSONChunkProperty[JSONChunkProperty.StartPos = 0] = "StartPos", JSONChunkProperty[JSONChunkProperty.TextBuffer = 1] = "TextBuffer", 
            JSONChunkProperty[JSONChunkProperty.Runs = 2] = "Runs", JSONChunkProperty[JSONChunkProperty.IsLast = 3] = "IsLast";
        }(JSONChunkProperty || (JSONChunkProperty = {})), function(JSONPieceTableInfo) {
            JSONPieceTableInfo[JSONPieceTableInfo.Type = 0] = "Type", JSONPieceTableInfo[JSONPieceTableInfo.Info = 1] = "Info", 
            JSONPieceTableInfo[JSONPieceTableInfo.ParentPieceTableId = 2] = "ParentPieceTableId";
        }(JSONPieceTableInfo || (JSONPieceTableInfo = {})), function(JSONTabInfoProperty) {
            JSONTabInfoProperty[JSONTabInfoProperty.Alignment = 0] = "Alignment", JSONTabInfoProperty[JSONTabInfoProperty.LeaderType = 1] = "LeaderType", 
            JSONTabInfoProperty[JSONTabInfoProperty.Position = 2] = "Position", JSONTabInfoProperty[JSONTabInfoProperty.IsDefault = 3] = "IsDefault", 
            JSONTabInfoProperty[JSONTabInfoProperty.IsDeleted = 4] = "IsDeleted";
        }(JSONTabInfoProperty || (JSONTabInfoProperty = {}));
        class JSONTabConverter {
            static convertFromJSONToTabProperties(obj) {
                const tabs = new TabProperties;
                for (let jsonTab of obj) tabs.tabsInfo.push(JSONTabConverter.convertFromJSON(jsonTab));
                return tabs;
            }
            static convertFromJSON(obj) {
                return new TabInfo(obj[JSONTabInfoProperty.Position], obj[JSONTabInfoProperty.Alignment], obj[JSONTabInfoProperty.LeaderType], !!obj[JSONTabInfoProperty.IsDeleted], !!obj[JSONTabInfoProperty.IsDefault]);
            }
            static convertToJSON(source) {
                var result = {};
                return result[JSONTabInfoProperty.Position] = source.position, result[JSONTabInfoProperty.Alignment] = source.alignment, 
                result[JSONTabInfoProperty.LeaderType] = source.leader, result[JSONTabInfoProperty.IsDeleted] = (0, 
                common.boolToInt)(source.deleted), result[JSONTabInfoProperty.IsDefault] = (0, common.boolToInt)(source.isDefault), 
                result;
            }
            static convertFromTabPropertiesToJSON(source) {
                var result = [];
                for (let tab of source.tabsInfo) result.push(JSONTabConverter.convertToJSON(tab));
                return result;
            }
        }
        class TableConditionalStyle {
            constructor(tableProperties, tableRowProperties, tableCellProperties, maskedParagraphProperties, maskedCharacterProperties, tabs) {
                this.tableProperties = tableProperties, this.tableRowProperties = tableRowProperties, 
                this.tableCellProperties = tableCellProperties, this.maskedParagraphProperties = maskedParagraphProperties, 
                this.maskedCharacterProperties = maskedCharacterProperties, this.tabs = tabs;
            }
            clone() {
                var _a;
                return new TableConditionalStyle(this.tableProperties, this.tableRowProperties, this.tableCellProperties, this.maskedParagraphProperties, this.maskedCharacterProperties, null === (_a = this.tabs) || void 0 === _a ? void 0 : _a.clone());
            }
        }
        !function(JSONTableHeightUnitProperty) {
            JSONTableHeightUnitProperty[JSONTableHeightUnitProperty.Type = 0] = "Type", JSONTableHeightUnitProperty[JSONTableHeightUnitProperty.Value = 1] = "Value";
        }(JSONTableHeightUnitProperty || (JSONTableHeightUnitProperty = {})), function(JSONTableWidthUnitProperty) {
            JSONTableWidthUnitProperty[JSONTableWidthUnitProperty.Type = 0] = "Type", JSONTableWidthUnitProperty[JSONTableWidthUnitProperty.Value = 1] = "Value";
        }(JSONTableWidthUnitProperty || (JSONTableWidthUnitProperty = {})), function(JSONTableCellMarginsProperty) {
            JSONTableCellMarginsProperty[JSONTableCellMarginsProperty.Top = 0] = "Top", JSONTableCellMarginsProperty[JSONTableCellMarginsProperty.Left = 1] = "Left", 
            JSONTableCellMarginsProperty[JSONTableCellMarginsProperty.Right = 2] = "Right", 
            JSONTableCellMarginsProperty[JSONTableCellMarginsProperty.Bottom = 3] = "Bottom";
        }(JSONTableCellMarginsProperty || (JSONTableCellMarginsProperty = {})), function(JSONTableBordersProperty) {
            JSONTableBordersProperty[JSONTableBordersProperty.TopBorder = 0] = "TopBorder", 
            JSONTableBordersProperty[JSONTableBordersProperty.LeftBorder = 1] = "LeftBorder", 
            JSONTableBordersProperty[JSONTableBordersProperty.RightBorder = 2] = "RightBorder", 
            JSONTableBordersProperty[JSONTableBordersProperty.BottomBorder = 3] = "BottomBorder", 
            JSONTableBordersProperty[JSONTableBordersProperty.InsideHorizontalBorder = 4] = "InsideHorizontalBorder", 
            JSONTableBordersProperty[JSONTableBordersProperty.InsideVerticalBorder = 5] = "InsideVerticalBorder";
        }(JSONTableBordersProperty || (JSONTableBordersProperty = {})), function(JSONTableCellBordersProperty) {
            JSONTableCellBordersProperty[JSONTableCellBordersProperty.TopBorder = 0] = "TopBorder", 
            JSONTableCellBordersProperty[JSONTableCellBordersProperty.LeftBorder = 1] = "LeftBorder", 
            JSONTableCellBordersProperty[JSONTableCellBordersProperty.RightBorder = 2] = "RightBorder", 
            JSONTableCellBordersProperty[JSONTableCellBordersProperty.BottomBorder = 3] = "BottomBorder", 
            JSONTableCellBordersProperty[JSONTableCellBordersProperty.TopLeftDiagonalBorder = 4] = "TopLeftDiagonalBorder", 
            JSONTableCellBordersProperty[JSONTableCellBordersProperty.TopRightDiagonalBorder = 5] = "TopRightDiagonalBorder";
        }(JSONTableCellBordersProperty || (JSONTableCellBordersProperty = {})), function(JSONTableConditionalStyleProperty) {
            JSONTableConditionalStyleProperty[JSONTableConditionalStyleProperty.TableProperties = 0] = "TableProperties", 
            JSONTableConditionalStyleProperty[JSONTableConditionalStyleProperty.TableRowPropertiesIndex = 1] = "TableRowPropertiesIndex", 
            JSONTableConditionalStyleProperty[JSONTableConditionalStyleProperty.TableCellPropertiesIndex = 2] = "TableCellPropertiesIndex", 
            JSONTableConditionalStyleProperty[JSONTableConditionalStyleProperty.MaskedParagraphPropertiesCacheIndex = 3] = "MaskedParagraphPropertiesCacheIndex", 
            JSONTableConditionalStyleProperty[JSONTableConditionalStyleProperty.MaskedCharacterPropertiesCacheIndex = 4] = "MaskedCharacterPropertiesCacheIndex", 
            JSONTableConditionalStyleProperty[JSONTableConditionalStyleProperty.Tabs = 5] = "Tabs";
        }(JSONTableConditionalStyleProperty || (JSONTableConditionalStyleProperty = {})), 
        function(JSONEnumTable) {
            JSONEnumTable[JSONEnumTable.StyleIndex = 0] = "StyleIndex", JSONEnumTable[JSONEnumTable.NestedLevel = 1] = "NestedLevel", 
            JSONEnumTable[JSONEnumTable.TableProperties = 2] = "TableProperties", JSONEnumTable[JSONEnumTable.Index = 3] = "Index", 
            JSONEnumTable[JSONEnumTable.PreferredWidth = 4] = "PreferredWidth", JSONEnumTable[JSONEnumTable.LookTypes = 5] = "LookTypes", 
            JSONEnumTable[JSONEnumTable.ParentCell = 6] = "ParentCell", JSONEnumTable[JSONEnumTable.Rows = 7] = "Rows";
        }(JSONEnumTable || (JSONEnumTable = {})), function(JSONEnumTableProperty) {
            JSONEnumTableProperty[JSONEnumTableProperty.CellMargins = 0] = "CellMargins", JSONEnumTableProperty[JSONEnumTableProperty.CellSpacing = 1] = "CellSpacing", 
            JSONEnumTableProperty[JSONEnumTableProperty.Indent = 2] = "Indent", JSONEnumTableProperty[JSONEnumTableProperty.PreferredWidth = 3] = "PreferredWidth", 
            JSONEnumTableProperty[JSONEnumTableProperty.Borders = 4] = "Borders", JSONEnumTableProperty[JSONEnumTableProperty.TableStyleColBandSize = 5] = "TableStyleColBandSize", 
            JSONEnumTableProperty[JSONEnumTableProperty.TableStyleRowBandSize = 6] = "TableStyleRowBandSize", 
            JSONEnumTableProperty[JSONEnumTableProperty.IsTableOverlap = 7] = "IsTableOverlap", 
            JSONEnumTableProperty[JSONEnumTableProperty.AvoidDoubleBorders = 8] = "AvoidDoubleBorders", 
            JSONEnumTableProperty[JSONEnumTableProperty.LayoutType = 9] = "LayoutType", JSONEnumTableProperty[JSONEnumTableProperty.TableLookTypes = 10] = "TableLookTypes", 
            JSONEnumTableProperty[JSONEnumTableProperty.ShadingInfo = 11] = "ShadingInfo", JSONEnumTableProperty[JSONEnumTableProperty.TableRowAlignment = 12] = "TableRowAlignment", 
            JSONEnumTableProperty[JSONEnumTableProperty.BottomFromText = 13] = "BottomFromText", 
            JSONEnumTableProperty[JSONEnumTableProperty.LeftFromText = 14] = "LeftFromText", 
            JSONEnumTableProperty[JSONEnumTableProperty.TopFromText = 15] = "TopFromText", JSONEnumTableProperty[JSONEnumTableProperty.RightFromText = 16] = "RightFromText", 
            JSONEnumTableProperty[JSONEnumTableProperty.TableHorizontalPosition = 17] = "TableHorizontalPosition", 
            JSONEnumTableProperty[JSONEnumTableProperty.TableVerticalPosition = 18] = "TableVerticalPosition", 
            JSONEnumTableProperty[JSONEnumTableProperty.HorizontalAlignMode = 19] = "HorizontalAlignMode", 
            JSONEnumTableProperty[JSONEnumTableProperty.VerticalAlignMode = 20] = "VerticalAlignMode", 
            JSONEnumTableProperty[JSONEnumTableProperty.HorizontalAnchorType = 21] = "HorizontalAnchorType", 
            JSONEnumTableProperty[JSONEnumTableProperty.VerticalAnchorType = 22] = "VerticalAnchorType", 
            JSONEnumTableProperty[JSONEnumTableProperty.TextWrapping = 23] = "TextWrapping", 
            JSONEnumTableProperty[JSONEnumTableProperty.UseValue = 24] = "UseValue", JSONEnumTableProperty[JSONEnumTableProperty.ShadingInfoIndex = 25] = "ShadingInfoIndex";
        }(JSONEnumTableProperty || (JSONEnumTableProperty = {})), function(JSONEnumTableParentCellInfo) {
            JSONEnumTableParentCellInfo[JSONEnumTableParentCellInfo.CellIndex = 0] = "CellIndex", 
            JSONEnumTableParentCellInfo[JSONEnumTableParentCellInfo.RowIndex = 1] = "RowIndex", 
            JSONEnumTableParentCellInfo[JSONEnumTableParentCellInfo.TableIndex = 2] = "TableIndex";
        }(JSONEnumTableParentCellInfo || (JSONEnumTableParentCellInfo = {})), function(JSONEnumClientTableInfo) {
            JSONEnumClientTableInfo[JSONEnumClientTableInfo.TablePosition = 0] = "TablePosition", 
            JSONEnumClientTableInfo[JSONEnumClientTableInfo.Position = 1] = "Position", JSONEnumClientTableInfo[JSONEnumClientTableInfo.Rows = 2] = "Rows", 
            JSONEnumClientTableInfo[JSONEnumClientTableInfo.TableInfo = 3] = "TableInfo";
        }(JSONEnumClientTableInfo || (JSONEnumClientTableInfo = {})), function(JSONEnumClientTableFormatting) {
            JSONEnumClientTableFormatting[JSONEnumClientTableFormatting.TableProperties = 0] = "TableProperties", 
            JSONEnumClientTableFormatting[JSONEnumClientTableFormatting.StyleName = 1] = "StyleName", 
            JSONEnumClientTableFormatting[JSONEnumClientTableFormatting.PreferredWidth = 2] = "PreferredWidth", 
            JSONEnumClientTableFormatting[JSONEnumClientTableFormatting.LookTypes = 3] = "LookTypes";
        }(JSONEnumClientTableFormatting || (JSONEnumClientTableFormatting = {})), function(JSONEnumClientTablePosition) {
            JSONEnumClientTablePosition[JSONEnumClientTablePosition.ParagraphStartPosition = 0] = "ParagraphStartPosition", 
            JSONEnumClientTablePosition[JSONEnumClientTablePosition.NestedLevel = 1] = "NestedLevel";
        }(JSONEnumClientTablePosition || (JSONEnumClientTablePosition = {}));
        class JSONTableBordersConverter {
            static convertFromJSON(obj, colorModelInfoCache) {
                var result = new TableBorders;
                return result.topBorder = JSONBorderInfoConverter.convertFromJSON(obj[JSONTableBordersProperty.TopBorder], colorModelInfoCache), 
                result.leftBorder = JSONBorderInfoConverter.convertFromJSON(obj[JSONTableBordersProperty.LeftBorder], colorModelInfoCache), 
                result.rightBorder = JSONBorderInfoConverter.convertFromJSON(obj[JSONTableBordersProperty.RightBorder], colorModelInfoCache), 
                result.bottomBorder = JSONBorderInfoConverter.convertFromJSON(obj[JSONTableBordersProperty.BottomBorder], colorModelInfoCache), 
                result.insideHorizontalBorder = JSONBorderInfoConverter.convertFromJSON(obj[JSONTableBordersProperty.InsideHorizontalBorder], colorModelInfoCache), 
                result.insideVerticalBorder = JSONBorderInfoConverter.convertFromJSON(obj[JSONTableBordersProperty.InsideVerticalBorder], colorModelInfoCache), 
                result;
            }
            static convertToJSON(source) {
                var result = {};
                return result[JSONTableBordersProperty.TopBorder] = JSONBorderInfoConverter.convertToJSON(source.topBorder), 
                result[JSONTableBordersProperty.LeftBorder] = JSONBorderInfoConverter.convertToJSON(source.leftBorder), 
                result[JSONTableBordersProperty.RightBorder] = JSONBorderInfoConverter.convertToJSON(source.rightBorder), 
                result[JSONTableBordersProperty.BottomBorder] = JSONBorderInfoConverter.convertToJSON(source.bottomBorder), 
                result[JSONTableBordersProperty.InsideHorizontalBorder] = JSONBorderInfoConverter.convertToJSON(source.insideHorizontalBorder), 
                result[JSONTableBordersProperty.InsideVerticalBorder] = JSONBorderInfoConverter.convertToJSON(source.insideVerticalBorder), 
                result;
            }
        }
        class JSONTableHeightUnitConverter {
            static convertFromJSON(obj) {
                var result = new TableHeightUnit;
                return result.type = obj[JSONTableHeightUnitProperty.Type], result.value = obj[JSONTableHeightUnitProperty.Value], 
                result;
            }
            static convertToJSON(source) {
                var result = {};
                return result[JSONTableHeightUnitProperty.Type] = source.type, result[JSONTableHeightUnitProperty.Value] = source.value, 
                result;
            }
        }
        class JSONTableWidthUnitConverter {
            static convertFromJSON(obj) {
                var result = new TableWidthUnit;
                return result.type = obj[JSONTableWidthUnitProperty.Type], result.value = obj[JSONTableWidthUnitProperty.Value], 
                result;
            }
            static convertToJSON(source) {
                var result = {};
                return result[JSONTableWidthUnitProperty.Type] = source.type, result[JSONTableWidthUnitProperty.Value] = source.value, 
                result;
            }
        }
        class JSONTableCellMarginsConverter {
            static convertFromJSON(obj) {
                var result = new TableCellMargins;
                return result.top = JSONTableWidthUnitConverter.convertFromJSON(obj[JSONTableCellMarginsProperty.Top]), 
                result.left = JSONTableWidthUnitConverter.convertFromJSON(obj[JSONTableCellMarginsProperty.Left]), 
                result.right = JSONTableWidthUnitConverter.convertFromJSON(obj[JSONTableCellMarginsProperty.Right]), 
                result.bottom = JSONTableWidthUnitConverter.convertFromJSON(obj[JSONTableCellMarginsProperty.Bottom]), 
                result;
            }
            static convertToJSON(source) {
                var result = {};
                return result[JSONTableCellMarginsProperty.Top] = JSONTableWidthUnitConverter.convertToJSON(source.top), 
                result[JSONTableCellMarginsProperty.Left] = JSONTableWidthUnitConverter.convertToJSON(source.left), 
                result[JSONTableCellMarginsProperty.Right] = JSONTableWidthUnitConverter.convertToJSON(source.right), 
                result[JSONTableCellMarginsProperty.Bottom] = JSONTableWidthUnitConverter.convertToJSON(source.bottom), 
                result;
            }
        }
        class JSONTablePropertiesConverter {
            static convertFromJSON(obj, colorModelInfoCache, shadingInfoCache) {
                var result = new TableProperties;
                return result.cellMargins = JSONTableCellMarginsConverter.convertFromJSON(obj[JSONEnumTableProperty.CellMargins]), 
                result.cellSpacing = JSONTableWidthUnitConverter.convertFromJSON(obj[JSONEnumTableProperty.CellSpacing]), 
                result.indent = JSONTableWidthUnitConverter.convertFromJSON(obj[JSONEnumTableProperty.Indent]), 
                result.borders = JSONTableBordersConverter.convertFromJSON(obj[JSONEnumTableProperty.Borders], colorModelInfoCache), 
                result.tableStyleColumnBandSize = obj[JSONEnumTableProperty.TableStyleColBandSize], 
                result.tableStyleRowBandSize = obj[JSONEnumTableProperty.TableStyleRowBandSize], 
                result.isTableOverlap = !!obj[JSONEnumTableProperty.IsTableOverlap], result.avoidDoubleBorders = !!obj[JSONEnumTableProperty.AvoidDoubleBorders], 
                result.layoutType = obj[JSONEnumTableProperty.LayoutType], result.shadingInfo = shadingInfoCache.getItemByJsonKey(obj[JSONEnumTableProperty.ShadingInfoIndex]), 
                result.table