///////////////////////////////////////////////////////////////////////////
// messages, error handling
KS.apply(KS, {
    _alertOpened: false,
    alert: function(msg, title, handler, details) {
        title = !!title ? title : KS.L10n.message;
        if (!KS._alertOpened) {
            KS._alertOpened = true;
            KS.msgBox(msg, title, function() {
                KS._alertOpened = false;
                if (!!handler) handler();
            }, details, KS.infoImage);
        }
    },
    confirm: function(msg, title, handler) {
        return confirm(msg, title, handler);
    },
    error: function(msg, title, handler, details, report) {
        KS.stopWaitingAll();

        title = !!title ? title : KS.L10n.appError;
        if (!msg) {
            if (KS.issueTracking)
                msg = KS.L10n.operationErrorUnhandled;
            else
                msg = KS.L10n.operationError;
        }

        KS.log(msg);

        if (!!details && !!details.Type)
            details = KS.describeException(details);

        KS.msgBox(msg, title, handler, details, KS.errorImage, typeof(report) !== 'undefined' ? report : true);
    },
    warning: function(msg, title, handler, details) {
        KS.stopWaitingAll();

        title = !!title ? title : KS.L10n.attention;
        KS.log(msg);
        if (!!details && !!details.Type)
            details = KS.describeException(details);
        KS.msgBox(msg, title, handler, details, KS.warningImage, false);
    },
    msg: function() {
    },
    prompt: function(msg, title, defaultValue, handler) {
        setTimeout(function() {
            var s = prompt(msg, defaultValue);
            if (handler) handler(s);
        }, 1);
    },
    msgBox: function(msg, title, handler/*, details, icon, report*/) {
        alert(msg, title, handler);
    },

    logLevels: KS.getCookie('loglevel', 'view,console,ajax').split(','),
    
    changeLogLevel: function(level, add) {
        var pos = jQuery.inArray(level, KS.logLevels);
        if (add) {
            if (pos >= 0) return;
            KS.logLevels.push(level);
        } else {
            if (pos < 0) return;
            KS.logLevels.splice(pos, 1);
        }
        KS.setCookie('loglevel', KS.logLevels.join(','), new Date().addDays(30));
    },
    
    logLevelEnabled: function(level) {
        return jQuery.inArray(level, KS.logLevels) >= 0;
    },

    formatLogMessage: function(msg, level) {
        if (level != 'console')
            msg = '</br>[' + new Date().toLocaleTimeString() + '] ' + level + ': ' + msg;
        else
            msg = '</br>' + msg;
        return msg;
    },

    log: function(msg, level) {
        if (typeof(level) !== 'undefined') {
            if (jQuery.inArray(level, KS.logLevels) < 0) return;
        } else
            level = 'global';

        if (KS.isValidProp(window, 'console')) window.console.log(KS.formatLogMessage(msg, level));
    },

    logActions: function() {
        if (KS.ajaxResultQueue.length == 0) return;
        var msg = 'Actions queue content: [';
        var delim = '';
        for (var n = 0; n < KS.ajaxResultQueue.length; n++) {
            var task = KS.ajaxResultQueue[n];
            msg += delim + KS._getActionDesc(task);
            delim = ', ';
        }
        msg += ']';
        KS.log(msg, 'queue');
    },

    _getActionDesc: function(task) {
        var r;
        var names = ['Regular', 'SubstituteView', 'UpdatePanel', 'SelectedEvent', 'UpdateEvent', 'ReloadEvent', 'CustomEvent', 'AddDependentViews', 'RemoveDependentViews', 'DropView', 'ChangeViewID', 'ActivateView', 'MacroSequence', 'ExecuteTask', 'CloseView', 'Refresh', 'MessageBox', 'ErrorBox', 'RepeatRequest', 'ConsoleOutput', 'ExecuteClientMethod', 'FatalRefresh', 'MethodQueued'];
        r = '(' + names[task.action] + ',' + task.container;
        if (typeof(task.params) !== 'undefined' && task.params.length > 0 && task.action != 19) {
            for (var d = 0; d < task.params.length; d++) {
                r += ',' + JSON.stringify(task.params[d]);
            }
        }
        r += ')';
        return r;
    }
});