Ext.define('Svod.displayChat.DisplayChat', {
    extend: Ext.view.View,

    xtype: 'displayChat',

    cls: 'displayChat',

    reference: 'displayChat',

    referenceHolder: true,

    scrollable: 'vertical',

    store: new Svod.ChatMessageStore({}),

    height: '100%',
    // контроль пагинации
    paginationLoadCheck: true,

    /* eslint-disable prettier/prettier */
    tpl: new Ext.XTemplate(
        '<div class="chatBot-displayChat-chatArea">',
            '<tpl for=".">',
                '<div class="chatBot-displayChat-messagesContainer">',
                    '<tpl if="Query">',
                        '<div class="personMessageContainer">',
                            '<p class="chatBot-displayChat-message">{Query}</p>',
                        '</div>',
                    '</tpl>',
                    '<tpl if="Result">',
                        '<tpl if="Type==0 || Type==false">',
                            '<div data-chatMessageModelId={id} class="botMessageContainer">',
                                '<p class="chatBot-displayChat-botName">Кейсистемс Чат-бот</p>',
                                '<tpl if="Comment">',
                                    '<p class="chatBot-displayChat-message">{Comment}</p>',
                                '<tpl else>',
                                    '<p class="chatBot-displayChat-message">Пожалуйста, задайте вопрос корректнее(Временно, ошибка в запросе)</p>',
                                '</tpl>',
                                '<tpl if="IsNeedForce">',
                                    '<button class="chatBot-displayChat-buttonAsk" data-query="{[values.Query]}">Всё равно спросить</button>',
                                '</tpl>',
                            '</div>',
                        '<tpl elseif="Type==-1">',
                            '<div class="botMessageContainer">',
                                '<p class="chatBot-displayChat-botName">Кейсистемс Чат-бот</p>',
                                '<p class="chatBot-displayChat-message">{Result}</p>',
                            '</div>',
                        '<tpl elseif="Type==1 || Type==2 || Type == true">',
                            '<div data-chatMessageModelId={id} class="botMessageContainer">',
                                '<p class="chatBot-displayChat-botName">Кейсистемс Чат-бот</p>',
                                '<tpl if="IsNotChosedChatBotType">',
                                    '<tpl if="ChatBotNames">',
                                        '<p class="chatBot-displayChat-message">{Result}</p>',
                                            '<div class="chooseChatBotTypeWrap">',
                                                '<div class="chooseChatBotTypeButtonsContainer">',
                                                    '<tpl for="ChatBotNames">',
                                                        '<button class="chooseChatBotTypeButton" data-chatBotType={ChatBotName} data-query="{[parent.Query]}">',
                                                            '<p class="chooseChatBotTypeName">{ChatBotName}</p>',
                                                        '</button>',
                                                    '</tpl>',
                                                '</div>',
                                            '</div>',
                                    '<tpl else>',
                                        '<p class="chatBot-displayChat-message">{Result}</p>',
                                    '</tpl>',
                        '<tpl else>',                        
                            '<tpl if="IsGptAnswer">',
                                '<tpl for="Result">',
                                    '<div class="gptAnswer">{GptAnswer}</div>',
                                    '<div class="chatBot-displayChat-rateContainer">',
                                        '<tpl if="this.checkContains(parent.UsefulNames, DataName) || this.checkContains(parent.NotUsefulNames, DataName)">',
                                            '<p class="chatBot-displayChat-message  ratePlease">Благодарим за вашу оценку! Это поможет найти наиболее точные результаты.</p>',
                                        '<tpl else>',
                                            '<p class="chatBot-displayChat-message  ratePlease">Пожалуйста, оцените полученный вами ответ:</p>',
                                        '</tpl>',
                                        '<div class="chatBot-displayChat-rateButtonContainer" data-answerType={DataName}>',
                                            '<tpl if="this.checkContains(parent.UsefulNames, DataName)">',
                                                '<button class="chatBot-displayChat-rateButton chatBot-displayChat-rateButtonLikeClicked" name="like" type="button">Мне нравится</button>',
                                                '<button class="chatBot-displayChat-rateButton" name="dislike" type="button">Мне не нравится</button>',
                                            '<tpl elseif="this.checkContains(parent.NotUsefulNames, DataName)">',
                                                '<button class="chatBot-displayChat-rateButton" name="like" type="button">Мне нравится</button>',
                                                '<button class="chatBot-displayChat-rateButton chatBot-displayChat-rateButtonDislikeClicked" name="dislike" type="button">Мне не нравится</button>',
                                            '<tpl else>',
                                                '<button class="chatBot-displayChat-rateButton" name="like" type="button">Мне нравится</button>',
                                                '<button class="chatBot-displayChat-rateButton" name="dislike" type="button">Мне не нравится</button>',
                                            '</tpl>',
                                        '</div>',
                                    '</div>',
                                '</tpl>',
                            '<tpl else>',
                                '<p class="chatBot-displayChat-message comment">Вот что я нашёл по вашему вопросу.</p>',
                                '<div class="accordion">',
                                    '<tpl for="Result">',
                                        '<tpl if="this.checkContains(parent.AccordionShowNames, DataName)">',
                                            '<div class="accordion__item  accordion__item_show">',
                                        '<tpl else>',
                                            '<div class="accordion__item">',
                                        '</tpl>',
                                                '<div data-header={DataName} class="accordion__header">{PreviewName}</div>',
                                                '<div class="accordion__body">',
                                                    '<div class="accordion__content">',
                                                        '<tpl if="MainArticle">',
                                                            '<p class="chatBot-displayChat-message">{TextParagraphs}</p>',
                                                            '<p class="chatBot-displayChat-message  mainInfo">Подробнее: ',
                                                                '<a class="chatBot-displayChat-link mainInfo-link" href={MainArticle.ArticleLink} target="_blank">{MainArticle.ArticleName}</a>',
                                                            '</p>',
                                                        '</tpl>',
                                                        '<ul class="chatBot-displayChat-list">',
                                                            '<tpl for="Articles">',
                                                                '<li class="chatBot-displayChat-list-element">',
                                                                    '<a class="chatBot-displayChat-link" href={ArticleLink} target="_blank">{ArticleName}</a>',
                                                                '</li>',
                                                            '</tpl>',
                                                        '</ul>',
                                                        '<div class="chatBot-displayChat-rateContainer">',
                                                            '<tpl if="this.checkContains(parent.UsefulNames, DataName) || this.checkContains(parent.NotUsefulNames, DataName)">',
                                                                '<p class="chatBot-displayChat-message  ratePlease">Благодарим за вашу оценку! Это поможет найти наиболее точные результаты.</p>',
                                                            '<tpl else>',
                                                                '<p class="chatBot-displayChat-message  ratePlease">Пожалуйста, оцените полученный вами ответ:</p>',
                                                            '</tpl>',
                                                            '<div class="chatBot-displayChat-rateButtonContainer" data-answerType={DataName}>',
                                                                '<tpl if="this.checkContains(parent.UsefulNames, DataName)">',
                                                                    '<button class="chatBot-displayChat-rateButton chatBot-displayChat-rateButtonLikeClicked" name="like" type="button">Мне нравится</button>',
                                                                    '<button class="chatBot-displayChat-rateButton" name="dislike" type="button">Мне не нравится</button>',
                                                                '<tpl elseif="this.checkContains(parent.NotUsefulNames, DataName)">',
                                                                    '<button class="chatBot-displayChat-rateButton" name="like" type="button">Мне нравится</button>',
                                                                    '<button class="chatBot-displayChat-rateButton chatBot-displayChat-rateButtonDislikeClicked" name="dislike" type="button">Мне не нравится</button>',
                                                                '<tpl else>',
                                                                    '<button class="chatBot-displayChat-rateButton" name="like" type="button">Мне нравится</button>',
                                                                    '<button class="chatBot-displayChat-rateButton" name="dislike" type="button">Мне не нравится</button>',
                                                                '</tpl>',
                                                            '</div>',
                                                        '</div>',
                                                    '</div>',
                                                '</div>',
                                            '</div>',
                                    '</tpl>',
                                '</div>',
                            '</tpl>',
                        '</tpl>',
            '</div>',
                    '</tpl>',
                    '<tpl else>',
                        '<div class="botMessageContainer">',
                            '<p class="chatBot-displayChat-botName">Кейсистемс Чат-бот</p>',
                            '<div class="dot-flashing"></div>',
                        '</div>',
                    '</tpl>',
                '</div>',
            '</tpl>',
        '</div>',
        {
            checkContains(data, checkItem) {
                return typeof data === 'string'
                    ? data.includes(checkItem)
                    : false;
            }
        }
    ),

    itemSelector: 'div.thumb-wrap',

    listeners: {
        afterrender(){
            this.parentView.displayChatAfterrender.call(this);
        }
    },

    showAccordeon(domElement) {
        const displayChat = this;
        const elBody = domElement.querySelector('.accordion__body');
        const scrollTop = displayChat.el.dom.scrollTop;

        if (
            elBody.classList.contains('collapsing') ||
            domElement.classList.contains('accordion__item_show')
        ) {
            return;
        }

        elBody.style.display = 'block';
        const height = elBody.offsetHeight;
        elBody.style.height = 0;
        elBody.style.overflow = 'hidden';
        elBody.style.transition = `height ${350}ms ease`;
        elBody.classList.add('collapsing');
        domElement.classList.add('accordion__item_slidedown');
        elBody.offsetHeight;
        elBody.style.height = `${height}px`;
        window.setTimeout(() => {
            elBody.classList.remove('collapsing');
            domElement.classList.remove('accordion__item_slidedown');
            elBody.classList.add('collapse');
            domElement.classList.add('accordion__item_show');
            elBody.style.display = '';
            elBody.style.height = '';
            elBody.style.transition = '';
            elBody.style.overflow = '';
            displayChat.updateLayout();

            displayChat.getScrollable().scrollTo(0, scrollTop);
        }, 350);

        const store = displayChat.store;
        const chatMessageModelId = domElement
            .closest('.botMessageContainer')
            .getAttribute('data-chatMessageModelId');
        const messageHeader = domElement
            .querySelector('.accordion__header')
            .getAttribute('data-header');

        displayChat.setCollapsed(
            messageHeader,
            false,
            store,
            chatMessageModelId
        );
    },

    hideAccordeon(domElement) {
        const displayChat = this;
        const elBody = domElement.querySelector('.accordion__body');
        let scrollTop = displayChat.el.dom.scrollTop;

        if (
            elBody.classList.contains('collapsing') ||
            !domElement.classList.contains('accordion__item_show')
        ) {
            return;
        }

        elBody.style.height = `${elBody.offsetHeight}px`;
        elBody.offsetHeight;
        elBody.style.display = 'block';
        elBody.style.height = 0;
        elBody.style.overflow = 'hidden';
        elBody.style.transition = `height ${350}ms ease`;
        elBody.classList.remove('collapse');
        domElement.classList.remove('accordion__item_show');
        elBody.classList.add('collapsing');
        window.setTimeout(() => {
            elBody.classList.remove('collapsing');
            elBody.classList.add('collapse');
            elBody.style.display = '';
            elBody.style.height = '';
            elBody.style.padding = '';
            elBody.style.transition = '';
            elBody.style.overflow = '';
            displayChat.updateLayout();

            // Необходимо для того, чтобы у кнопки промотки вниз работало сокрытие
            if (scrollTop === 0) {
                scrollTop = 1;
            }
            displayChat.getScrollable().scrollTo(0, scrollTop);
        }, 350);

        const store = displayChat.store;
        const chatMessageModelId = domElement
            .closest('.botMessageContainer')
            .getAttribute('data-chatMessageModelId');
        const messageHeader = domElement
            .querySelector('.accordion__header')
            .getAttribute('data-header');

        displayChat.setCollapsed(
            messageHeader,
            true,
            store,
            chatMessageModelId
        );
    },

    toggle(domElement) {
        domElement.classList.contains('accordion__item_show')
            ? this.hideAccordeon(domElement)
            : this.showAccordeon(domElement);
    },

    async postRate(domElement) {
        if (
            domElement.classList.contains(
                'chatBot-displayChat-rateButtonDislikeClicked'
            ) ||
            domElement.classList.contains(
                'chatBot-displayChat-rateButtonLikeClicked'
            )
        ) {
            return;
        }

        let view = this.parentView;
        const displayChat = this;
        const mainComponent = displayChat.displayChatSendMessageContainer.mainComponent;
        const store = displayChat.store;
        const chatMessageModelId = domElement
            .closest('.botMessageContainer')
            .getAttribute('data-chatMessageModelId');
        const usefulRate = domElement.getAttribute('name') === 'like';
        const answerType = domElement
            .closest('.chatBot-displayChat-rateButtonContainer')
            .getAttribute('data-answerType');
        const buttonToDisable = usefulRate
            ? domElement.nextSibling
            : domElement.previousSibling;
        const ratePlease = domElement.closest(
            '.chatBot-displayChat-rateButtonContainer'
        ).previousSibling;
        const currentChatBotInfo = view.getCurrentChatBotInfo(mainComponent);
        const chatMessageStore =
            displayChat.displayChatSendMessageContainer.mainComponent
                .chatMessageStore;

        function showThank() {
            // выполняем функцию при успешном запросе на оценку
            const thank = 'Благодарим за вашу оценку! Это поможет найти наиболее точные результаты.';

            displayChat.setUseful(
                answerType,
                usefulRate,
                store,
                chatMessageModelId
            );

            if (ratePlease.innerHTML === thank) {
                return;
            }

            ratePlease.innerHTML = thank;
            displayChat.updateLayout();
        }

        function revertButtons() {
            // выполняем функцию, если ловим ошибку в запросе
            domElement.classList.remove(
                usefulRate
                    ? 'chatBot-displayChat-rateButtonLikeClicked'
                    : 'chatBot-displayChat-rateButtonDislikeClicked'
            );
            buttonToDisable.classList.add(
                usefulRate
                    ? 'chatBot-displayChat-rateButtonDislikeClicked'
                    : 'chatBot-displayChat-rateButtonLikeClicked'
            );

            displayChat.setUseful(answerType, null, store, chatMessageModelId);
        }

        domElement.classList.add(
            usefulRate
                ? 'chatBot-displayChat-rateButtonLikeClicked'
                : 'chatBot-displayChat-rateButtonDislikeClicked'
        );
        buttonToDisable.classList.remove(
            usefulRate
                ? 'chatBot-displayChat-rateButtonDislikeClicked'
                : 'chatBot-displayChat-rateButtonLikeClicked'
        );

        const queryId = chatMessageStore.getById(chatMessageModelId).data.QueryId;

        view.postRate(
            queryId,
            answerType,
            usefulRate,
            currentChatBotInfo.ChatBotName,
            showThank
        )
    },

    forceSendMessage(domElement) {
        // функция кнопки "всё равно спросить" для отправки запроса без проверки на валидность
        const displayChat = this;
        const mainComponent =
            displayChat.displayChatSendMessageContainer.mainComponent;
        const id = domElement
            .closest('.botMessageContainer')
            .getAttribute('data-chatMessageModelId');
        const query = domElement.getAttribute('data-query');
        const chatMessageStore = mainComponent.chatMessageStore;

        if (!mainComponent.isSendingMessage) {
            chatMessageStore.getById(id).set({
                IsNeedForce: false
            });
            displayChat.parentView.sendMessage(query, mainComponent, id, true);
        }
    },

    setCollapsed(messageHeader, isCollapsed, store, id) {
        // для запоминания состояния аккордеона
        let showNames = store.getById(id).get('AccordionShowNames');

        if (isCollapsed) {
            showNames =
                typeof showNames === 'string' &&
                showNames.includes(messageHeader)
                    ? showNames.replace(messageHeader, '')
                    : showNames;
        } else {
            showNames =
                typeof showNames === 'string' &&
                showNames.includes(messageHeader)
                    ? showNames
                    : showNames + messageHeader;
        }

        store.getById(id).set({ AccordionShowNames: showNames });
    },

    setUseful(answerType, usefulRate, store, id) {
        // для запоминания оценки ответа

        let notUseful = store.getById(id).get('NotUsefulNames');
        let useFul = store.getById(id).get('UsefulNames');

        if (notUseful === null) {
            notUseful = '';
        }

        if (useFul === null) {
            useFul = '';
        }

        let isUseful = false;

        if (usefulRate === true) {
            notUseful =
                typeof notUseful === 'string' && notUseful.includes(answerType)
                    ? notUseful.replace(answerType, '')
                    : notUseful;
            useFul =
                typeof useFul === 'string' && useFul.includes(answerType)
                    ? useFul
                    : useFul + answerType;
        } else if (usefulRate === false) {
            notUseful =
                typeof notUseful === 'string' && notUseful.includes(answerType)
                    ? notUseful
                    : notUseful + answerType;
            useFul =
                typeof useFul === 'string' && useFul.includes(answerType)
                    ? useFul.replace(answerType, '')
                    : useFul;
        }

        if (useFul) {
            isUseful = true;
        }

        store.getById(id).set({
            UsefulNames: useFul,
            NotUsefulNames: notUseful,
            IsUseful: isUseful
        });
    },

    async createChatWithChoose(domElement) {
        const chatBotName = domElement.getAttribute('data-chatBotType');
        const msgValue = domElement.getAttribute('data-query');
        const chatModelId = this.displayChatSendMessageContainer.mainComponent.chatModelId;

        await this.parentView.createChatAndSendMessage(
            chatBotName,
            msgValue,
            this.displayChatSendMessageContainer.mainComponent,
            chatModelId
        );
    }
});
