Ext.define('Svod.chatList.ChatListArea', {
    extend: Ext.grid.Panel,

    xtype: 'chatListArea',

    cls: 'chatListArea',

    title: `<div class="chatListArea-titleContainer"> 
                <p class="chatListArea-title">Чаты</p> 
                <button class="chatListArea-addNewChat" value="newChat">Создать чат</button> 
            </div>`,

    reference: 'chatListArea',

    referenceHolder: true,

    width: '100%',

    hideHeaders: true,

    store: new Svod.ChatStore({}),

    // кнопка вызова модального окна создания чата
    addNewChatButton: null,

    floatable: false,

    flex: 1,

    allowDeselect: false,

    columns: [
        {
            text: 'Name',
            dataIndex: 'Name',
            tdCls: 'chatName',
            flex: 1,
            resizable: true
        },
        {
            text: 'ChatBotName',
            dataIndex: 'ChatBotName',
            align: 'right',
            tdCls: 'chatBotName',
            flex: 0,
            resizable: false
        }
    ],

    viewConfig: {
        markDirty: false
    },

    listeners: {
        cellclick(){
            this.parentView.chatListAreaCellClick.call(this);
        },

        afterrender(component) {
            let view = component.parentView;
            component.getEl().on(
                'click',
                function (event, domElement) {
                    view.addNewChatButtonHandler(component);
                },
                null,
                { delegate: '.chatListArea-addNewChat' }
            );

            component.getEl().on(
                'click',
                function (event, domElement) {
                    view.toggleView(
                        component.mainComponent.displayChatSendMessageContainer,
                        component
                    );
                },
                null,
                { delegate: '.chatListArea-createChat-back' }
            );

            new Ext.tip.ToolTip({
                target: component,
                delegate: ['.chatListArea-addNewChat'],
                listeners: {
                    beforeshow(tip) {
                        const current = tip.currentTarget.dom;
                        tip.setHtml(current.innerHTML.slice(0, 150));
                    }
                }
            });

            component.addNewChatButton = component
                .getEl()
                .dom.querySelector('.chatListArea-addNewChat');
        }
    },

    initComponent() {
        const component = this;
        Ext.grid.Panel.prototype.initComponent.call(this);
        component.view.deferEmptyText = false;
    }
});
