Ext.define('Svod.ChatBotMenu', {
    extend: Ext.panel.Panel,

    tooltip: 'Чат-бот',

    xtype: 'chatBotMenu',

    reference: 'chatBotMenu',

    referenceHolder: true,

    cls: 'chatBotMenu',

    width: '100%',

    border: false,
    
    html: `<div class = "chatBotMenu-container"> 
                <a class="chatBotMenu-button chatBotMenu-button-reference" target="_blank">Справка</a> 
                <a class="chatBotMenu-button chatBotMenu-button-support" target="_blank">Техподдержка</a> 
            </div>`,

    async initComponent() {
        Ext.panel.Panel.prototype.initComponent.call(this);

        this.parentView.getHelpLinks(this);
    },

    listeners: {
        afterrender() {
            new Ext.tip.ToolTip({
                target: this,
                delegate: ['.chatBotMenu-button'],
                listeners: {
                    beforeshow(tip) {
                        const current = tip.currentTarget.dom;
                        tip.setHtml(current.innerHTML);
                    }
                }
            });
        }
    },

    renderChatBotMenuContainer(helpTopic, bugTracking) {
        if (helpTopic) {
            this.el.dom.querySelector('.chatBotMenu-button-reference').href =
                helpTopic;
            this.el.dom.querySelector(
                '.chatBotMenu-button-reference'
            ).style.display = 'flex';
        }

        if (bugTracking) {
            this.el.dom.querySelector('.chatBotMenu-button-support').href =
                bugTracking;
            this.el.dom.querySelector(
                '.chatBotMenu-button-support'
            ).style.display = 'flex';
        }

        if (bugTracking || helpTopic) {
            this.el.dom.querySelector('.chatBotMenu-container').style.display =
                'flex';
        }
    }
});
