﻿class WatchTimerPlugin {
	apply(compiler) {
		compiler.hooks.done.tap('Watch Timer Plugin', () => {
			console.log("\x1b[1m", '\n[' + new Date().toLocaleString() + ']', '\x1b[0m');
		});
	}
}

const path = require("path");
const WebpackNotifierPlugin = require("webpack-notifier");
const TerserPlugin = require('terser-webpack-plugin');
const {CleanWebpackPlugin} = require('clean-webpack-plugin');

var entryList = [];
var tmpList = [
	"bowser",
	"Libs/Ks.Lib",
	"Other/Warnings",
	"Other/Log",
	"Libs/Convert.Lib",
	"Other/GlobalParams",
	"Views/ViewPort",
	"Libs/FileSaver.Lib",
	"Libs/Array.Lib",
	"Libs/Period.Lib",
	"Libs/Profile.Manager",
	"Libs/Sql.Manager",
	"Overrides/LoadMask.Override",
	"Other/LoadMask",
	"Other/QuickTip",
	"Other/ChooseBox",
	"Other/FunctionsController",
	"Other/ToolbarBuilder",
	"Base/Base.Abstract",
	"Base/Base.List",
	"Base/Base.List.Tree",
	"Base/Base.Edit.Store",
	"Base/Base.Edit",
	"Other/CacheEngine",
	"Libs/CBData.Lib",
	"Other/LocalStorage",
	"Libs/PageData.Lib",
	"Uploader/DataUploader",
	"Uploader/Uploader",
	"Uploader/Uploader.View",
	"Uploader/Uploader.Lib",
	"Base/Base.Ext.Extra",
	"Controls/Signal",
	"Layout/Flex",
	"Notification/NotificationList",
	"Notification/NotificationManager",
	"httpmodule/lavanda",
	"httpmodule/lavanda_crypto",
	"httpmodule/lavanda_mod",
	"httpmodule/lavanda_npx",
	"httpmodule/signer",
	"httpmodule/signer_gui",
	"CryptoModule/CryptoModule.DataForSignView",
	"CryptoModule/CryptoModule.Initor",
	"CryptoModule/formSigner",
	"CryptoModule/requestServer",
	"platform/base",
	"platform/sign",
	"platform/client_view",
	"renderer/RevizorRenderer",
	"renderer/document"
];

tmpList.map(url => {
	entryList.push(`./Scripts/${url}.js`);
});

tmpList = [
	"Calculator",
	"Controls",
	"ErrorStatus",
	"GridColumnManager",
	"KsPeriod",
	"NestedGrid",
	"GroupingGrid",
	"Panel.Gantt",
	"Panel.Prop",
	"Panel.Calc",
	"TaskGrid",
	"InvalidControlsPanel",
	"DocumentStatusBar",
	"SettingsGrid"
];


tmpList.map(url => {
	entryList.push(`./Scripts/Controls/${url}.js`);
});

tmpList = [
	"Chart",
	"About",
	"Appeals.Edit",
	"AppealsOrders.List",
	"Appeals.Edit.Answers",
	"File",
	"File.List",
	"Filter",
	"Formula.Edit",
	"Function.Edit",
	"Head",
	"List.Edit",
	"Login",
	"Options",
	"Orders.Edit",
	"Page",
	"Relations",
	"Users.List",
	"UserProperties",
	"EventsLog",
	"Settings",
	"ObjAccess",
	"BatchChange",
	"UsersGroups.Tree",
	"ToolbarAccess", 
	"Bubble",
	"UsersAdm.List",
	"UsersAdm.Edit",
	"GroupsAdm.List",
	"BPMSDivision.List",
	"EDSLvl.List",
	"Arm.List",
	"UsersTemplate.List",
	"ComplexList.List",
	"GroupsAdm.Edit"
];

tmpList.map(url => {
	entryList.push(`./Scripts/Views/${url}.js`);
});

tmpList = [
	"Bk.Edit",
	"SAdr.Edit",
	"SAdr.List",
	"SaveRules.Edit",
	"SCalc.Edit",
	"SCalc.List",
	"SCheck.Edit",
	"SDocVid.Edit",
	"SEdsLevel.Edit",
	"SInfo.Edit",
	"SKladr.Edit",
	"SKvartal.Edit",
	"SLand.Edit",
	"SNar.Edit",
	"SNpa.Edit",
	"SNpa.List",
	"SArticle.Edit",
	"SOkei.Edit",
	"SOrg.Edit",
	"SOtdel.Edit",
	"SPerson.Edit",
	"SPlan.Edit",
	"SProp.Edit",
	"SRegion.Edit",
	"SRespons.Edit",
	"SRnorm.Edit",
	"SRosnov.Edit",
	"SMosnov.Edit",
	"SRprog.Edit",
	"SRtema.Edit",
	"SStatus.Object.Edit",
	"STask.Doc",
	"STask.Edit",
	"STask.Gantt",
	"SVarParam.Edit",
	"SRDoc.Edit",
	"SAuthority.Edit",
	"SActivityIndex.Edit",
	"SActivityIndex.Tree",
	"SSklon.List",
	"SyncDictionary.List"
];

tmpList.map(url => {
	entryList.push(`./Scripts/Views/Dictionary/${url}.js`);
});


tmpList =
[
	"Documents.Edit",
	"Documents.Edit.NarRemove",
	"Documents.Edit.Request",
	"Documents.Edit.Reviz",
	"Documents.List",
	"Documents.Reviz.Report.Edit",
	"Documents.Reviz.Report.Edit.Doc",
	"Documents.Reviz.Report.List"
];
tmpList.map(url => {
	entryList.push(`./Scripts/Views/Documents/${url}.js`);
});

tmpList =
	[
		"DFSTask.Edit",
		"DFDocuments.List",
		"DFDocuments.Edit",
		"DFDocCorr.Edit",
		"DFTask.List",
		"DFTask.Edit"
	];
tmpList.map(url => {
	entryList.push(`./Scripts/Views/DF/${url}.js`);
});

//#endregion Documents

//#region Factnar

tmpList =
[
	"Factnar.Edit",
	"Factnar.List"
];
tmpList.map(url => {
	entryList.push(`./Scripts/Views/Factnar/${url}.js`);
});

//#endregion Factnar

//#region Financ

tmpList =
[
	"Financ.Edit",
	"Financ.List"
];
tmpList.map(url => {
	entryList.push(`./Scripts/Views/Financ/${url}.js`);
});

//#endregion Financ

//#region Contract

tmpList =
[
	"Contract.Edit",
	"Contract.List"
];
tmpList.map(url => {
	entryList.push(`./Scripts/Views/Contract/${url}.js`);
});

//#endregion Contract

//#region GanttView

tmpList =
[
	"GanttModel"
];
tmpList.map(url => {
	entryList.push(`./Scripts/Views/GanttView/${url}.js`);
});

//#endregion GanttView

//#region Infico

tmpList =
[
	"Action.Edit",
	"Operation.Edit",
	"Record.List",
	"Record.List.Mod",
	"Record.Edit",
	"SRiskLevel.Edit",
	"RiskLevel.Edit",
	"RiskLevelValue.Edit",
	"Register.List",
	"Register.Edit",
	"Register.Edit.Docs",
	"Register.Edit.Resp",
	"Procedure.Edit",
	"Procedure.Edit.Processes"
];
tmpList.map(url => {
	entryList.push(`./Scripts/Views/Infico/${url}.js`);
});

//#endregion Infico

//#region Info

tmpList =
[
	"Info.Edit",
	"Info.List"
];
tmpList.map(url => {
	entryList.push(`./Scripts/Views/Info/${url}.js`);
});

//#endregion Info

//#region Kurs

tmpList =
[
	"Kurs.List"
];
tmpList.map(url => {
	entryList.push(`./Scripts/Views/Kurs/${url}.js`);
});

//#endregion Kurs

//#region Map

tmpList =
[
	"Map.List"
];
tmpList.map(url => {
	entryList.push(`./Scripts/Views/Map/${url}.js`);
});

//#endregion Map

//#region ObjectionAct

entryList.push('./Scripts/Views/ObjectionAct/ObjectionAct.Edit.js');

//#endregion ObjectionAct

//#region OuterReviz

tmpList =
[
	"OuterReviz.Edit.FactNar",
	"OuterReviz.Edit",
	"OuterReviz.List"
];
tmpList.map(url => {
	entryList.push(`./Scripts/Views/OuterReviz/${url}.js`);
});

//#endregion OuterReviz

//#region Plan

tmpList =
[
	"Plan.Edit",
	"Plan.List",
	"Plan.List.Simple",
	"Plan.List.Mod"
];
tmpList.map(url => {
	entryList.push(`./Scripts/Views/Plan/${url}.js`);
});

//#endregion Plan

//#region PlanProj

tmpList =
[
	"PlanProj.Edit",
	"PlanProj.List"
];
tmpList.map(url => {
	entryList.push(`./Scripts/Views/PlanProj/${url}.js`);
});

//#endregion PlanProj

//#region Reports

tmpList =
[
	"Reports.List",
	"Reports.Post",
	"Reports.Sign.List",
	"Reports.Sign.Edit"
];
tmpList.map(url => {
	entryList.push(`./Scripts/Views/Reports/${url}.js`);
});

//#endregion Reports

//#region Reviz

tmpList =
[
	"Reviz.Edit.Formalize",
	"Reviz.Edit.Nar",
	"Reviz.Edit.General",
	"Reviz.Edit.Resp",
	"Reviz.Edit.Ap",
	"Reviz.Edit.Prepare",
	"Reviz.Edit",
	"Reviz.List"
];
tmpList.map(url => {
	entryList.push(`./Scripts/Views/Reviz/${url}.js`);
});

//#endregion Reviz

//#region RevizTask

tmpList =
[
	"RevizTask.List",
	"RevizTask.Edit"
];
tmpList.map(url => {
	entryList.push(`./Scripts/Views/RevizTask/${url}.js`);
});

//#endregion RevizTask

//#region Row

tmpList =
[
	"Row.FactNarRem.Edit",
	"Row.LandRights.Edit",
	"Row.RevizDoc.Edit",
	"Row.RevizOkp.Edit",
	"Row.Status.Edit",
	"Row.Authority.Edit"
];
tmpList.map(url => {
	entryList.push(`./Scripts/Views/Row/${url}.js`);
});

//#endregion Row

//#region Admprocs

tmpList =
[
	"Admprocs.List"
];
tmpList.map(url => {
	entryList.push(`./Scripts/Views/Admprocs/${url}.js`);
});

//#endregion Admprocs

//#region PlanRisk

tmpList =
	[
		"OrgActivity.List",
		"OrgActivity.Edit",
		"Rang",
		"RiskInfo.List"	
	];
tmpList.map(url => {
	entryList.push(`./Scripts/Views/PlanRisk/${url}.js`);
});

//#endregion PlanRisk

//#region Mail

tmpList =
	[
		"Mail",
		"Mail.List",
		"Mail.Edit",
		"Mail.Preview"
	];
tmpList.map(url => {
	entryList.push(`./Scripts/Views/Mail/${url}.js`);
});

//#endregion Factnar

//#endregion Вьюхи

//#region Остальное

tmpList =
[
	"Other/Desktop",
	"Other/TableListController",
	"Other/Navigator",
	"Other/ChannelController",
	"Other/Printer",
	"Other/FileEditorWindow",
	"Other/EDSServiceModule"
];
tmpList.map(url => {
	entryList.push(`./Scripts/${url}.js`);
});

//#endregion Остальное
let optimization = {};
let devtool = "";

if (process.env.NODE_ENV === 'production') {
	devtool = false;
	optimization = {
		minimize: true,
		minimizer: [new TerserPlugin()],
	  };
} else {
	devtool = "inline-source-map";
	optimization = {
		splitChunks: {
			cacheGroups: {
				commons: {
					name: 'part0',
					chunks: 'initial',
					minChunks: 2,
				},
			},
	}
	}
}

let entry = {
	'signalRController': './Scripts/SignalR/signalRController.js'
	},
 number = 1,
 i = 0,
 numFilesInBundle = 10;
do {
	let j = i + numFilesInBundle;
	entry[`part${number}`] = entryList.slice(i, j);	
	i = i + numFilesInBundle;
	number++;
} while(i < entryList.length)

module.exports = {
	target: ['web', 'es5'],
	externals: {
		// require("jquery") is external and available
		//  on the global var jQuery
		"jquery": "jQuery",
		$: 'jquery',
		jQuery: 'jquery'
	},
	entry,
	output: {
		path: path.resolve(__dirname, "./Scripts/dist"),
		filename: '[name].bundle.js',
	},
	module: {
		rules: [
			{
				test: /\.js$/,
				exclude: /node_modules/,
				use: {
					loader: "babel-loader"
				}
			}
		]
	},
	watchOptions: {
		poll: true
	},
	plugins: [
		new WebpackNotifierPlugin({
			title: 'Ревизор-WEB',
			alwaysNotify: true
		}),
		new CleanWebpackPlugin(),
		new WatchTimerPlugin()
	],
	//prod
	optimization,
	//dev
	devtool
};
