(function () {
    var firefox52EsrMessage = '<p class="browser-info">* ' + KS.L10n.sign_UseMozillaFirefoxESR52 +
        '<a target="_blank" href="https://download.mozilla.org/?product=firefox-52.0esr-SSL&os=win&lang=ru">'+ KS.L10n.sign_Download + '</a>)</p>';

    function buildXCryptRegisterMessage(reason) {
        var ss = KS.XCrypt.signSettings,
            msg = "<div class='xcrypt-header'>" + reason + "</div>";
        msg += "<div class='xcrypt-content'>" +
            "<p>" + KS.L10n.sign_InstallXCrypt + ss.edsModuleVersion + KS.L10n.sign_OneWay + "</p>" +
            "<ol class='x-normal'>" +
            "<li>" + KS.L10n.sign_DownloadOneVariantInstallator +
            "<ul class='x-minus'>" +
            "<li>.exe (<a target='_blank' href='" + ss.edsModulesPath + ".exe'>" + KS.L10n.sign_Download + "</a>)</li>" +
            "<li>.zip (<a target='_blank' href='" + ss.edsModulesPath + ".zip'>" + KS.L10n.sign_Download + "</a>)" + KS.L10n.sign_ArchiveNeedUnpackage + "</li></ul></li>" +
            "<p class='xcrypt-setup-header'>" + KS.L10n.sign_WayInstalled +
            "<ul class='x-minus'>" +
            "<li><span style='color:red'>" + KS.L10n.sign_CloseAllBrowsers + "</span></li>" +
            "<li>" + KS.L10n.sign_RunInstallator + "</li></ul>";

        if (isNativeMessagingSupported()) {
            msg += "</br><li>" + KS.L10n.sign_InstallExtension + "<a target='_blank' href='https://chrome.google.com/webstore/detail/cinbbhdcfmieecfcfbchhipanhahhonb'>" + KS.L10n.sign_Link + "</a>" + "</li>";
        }

        msg += "</ol></div>";

        if (KS.browser.name === 'firefox' && KS.browser.version > 51) {
            msg += firefox52EsrMessage;
        }

        return msg;
    }

    function validateXcrypt(installed) {
        var ss = KS.XCrypt.signSettings;
        if (!ss) {
            KS.showHtmlProtocol(KS.L10n.sign_DontDefinedSettings, KS.L10n.sign_DontDefinedSettings);
            return false;
        }

        if (KS.isEmpty(installed)) {
            KS.showHtmlProtocol(buildXCryptRegisterMessage(KS.L10n.sign_DontFindedXCrypt), KS.L10n.sign_DontFindedXCrypt);
            return false;
        }

        var needed = ss.edsModuleVersion;
        if (KS.isEmpty(needed)) return true;

        var nee = needed.split('.'),
            nv1 = nee[0],
            nv2 = nee[1],
            nv3 = nee[2],
            nv4 = 0;
        if (nee.length === 4)
            nv4 = nee[3];

        var ins = installed.split('.'),
            iv1 = ins[0],
            iv2 = ins[1],
            iv3 = ins[2],
            iv4 = 0;
        if (ins.length === 4)
            iv4 = ins[3];

        var isValid = !!(parseInt(iv1) > parseInt(nv1) || parseInt(iv1) == parseInt(nv1)
            && (parseInt(iv2) > parseInt(nv2) || parseInt(iv2) == parseInt(nv2)
                && (parseInt(iv3) > parseInt(nv3) || parseInt(iv3) == parseInt(nv3)
                    && (parseInt(iv4) > parseInt(nv4) || parseInt(iv4) == parseInt(nv4)))));

        if (!isValid) {
            var reason = KS.L10n.sign_CurrentVersionXCrypt + installed + KS.L10n.sign_DontNeedTrueth + needed + ".";
            KS.showHtmlProtocol(buildXCryptRegisterMessage(reason), KS.L10n.sign_InvalidVersionXCrypt);
        }

        return isValid;
    }

    function parseCertsXml(rawXml) {
        var x = KS.xml2json.parser(rawXml);
        if (!KS.isEmpty(x.error)) {
            KS.error(x.error);
            return null;
        }
        x = x.certificates.certificate;

        function fillRow(cert) {
            var row = "".split("");
            row[0] = cert.issuer;
            row[1] = $.trim(cert.notafter);
            row[2] = $.trim(cert.notbefore);
            row[3] = cert.serial;
            row[4] = cert.subject;
            row[5] = cert.message;
            row[6] = cert.error;
            row[7] = cert.subjectx500;

            if (KS.isEmpty(row[5])) row[5] = "";
            if (KS.isEmpty(row[6])) row[6] = "";

            return row;
        }

        var data = "".split("");

        if (x == null || x === "undefined") { // No certificates
        } else if (x.length == null || x.length === "undefined") { // Only one certificate
            data[0] = fillRow(x);
        } else {
            for (var i = 0; i < x.length; i++) {
                data[i] = fillRow(x[i]);
            }
        }

        return data;
    }

    function fillCertsGridStore(certGrid, certs, enableErrs) {
        var ss = KS.XCrypt.signSettings,
            cxf = ss.certXmlFields,
            isEmpty = true;

        KS.XCrypt.certsList = [];
        if (KS.isEmpty(certs)) return true;

        for (var cidx = 0; cidx < certs.length; cidx++) {
            var cert = certs[cidx],
                values = {},
                value,
                isError = false;
            if (KS.edsType === 2) {
                // CryptoModule returns cert as object
                for (var field in cert) {
                    if (cert.hasOwnProperty(field)) {
                        value = cert[field];
                        switch (field) {
                            case 'error':
                            case 'filterreason':
                                if (!KS.isEmpty(value)) isError = true;
                                break;
                            case 'notafter':
                            case 'notbefore':
                                value = KS.formatDate(new Date(value));
                                break;
                            case 'issuer':
                                if (KS.isObject(cert['issuerx500'])) {
                                    value = cert['issuerx500']['CN'];
                                }
                                break;
                            case 'subject':
                                if (KS.isObject(cert['subjectx500'])) {
                                    var fio = cert['subjectx500']['FIO'];
                                    value = cert['subjectx500']['CN'];
                                    if (!KS.isEmpty(fio) && value !== fio)
                                        value += ' (' + fio + ')';
                                }
                                break;
                            case 'subjectx500':
                                if (KS.isObject(value)) {
                                    var fio = getCertPart(value, "FIO"),
                                        cn = getCertPart(value, "CN"),
                                        sn = getCertPart(value, "SN"),
                                        g = getCertPart(value, "G");
                                    if (!KS.isEmpty(fio)) {
                                        value = fio;
                                    } else if (!KS.isEmpty(cn)) {
                                        value = cn;
                                    } else {
                                        value = sn + ' ' + g;
                                    }
                                }
                                break;
                        }
                        values[field] = value;
                    }
                }
            } else {
                // npXcrypt returns cert as xml
                for (var fidx = 0; fidx < cxf.length; fidx++) {
                    var name = cxf[fidx];
                    value = cert[fidx];
                    switch (name) {
                        case 'error':
                            if (!KS.isEmpty(value)) isError = true;
                            break;
                        case 'notafter':
                        case 'notbefore':
                            var date = new Date(parseInt(value + "000"));
                            value = KS.formatDate(date);
                            break;
                    }
                    values[name] = value;
                }
            }

            KS.XCrypt.certsList.push(values);

            if (!KS.isEmpty(KS.XCrypt.signSettings.keyId) && !certIsRequired(values)) {
            } else {
                certGrid.addRecord(values);
                isEmpty = false;
            }
        };

        if (enableErrs !== true) {
            certGrid.on('beforeselect', certGridBeforeSelectHandler);
        }
        certGrid.getView().getRowClass = certGridGetRowClass;

        return isEmpty;
    }

    function getCertPart(subjectx500, partName) {
        var val = subjectx500;
        if (KS.isEmpty(val)) return '';
        if (KS.isString(val)) {
            if (val.indexOf(partName + '=') >= 0) {
                val = val.substring(val.indexOf(partName + '=') + 3).split(',')[0];
            }
        } else if (val) {
            val = val[partName];
        }
        return val || '';
    }

    function certIsRequired(cert) {
        var key = KS.XCrypt.signSettings.keyId;
        if (KS.isEmpty(key)) return false;
        if (key[0] == "#") {
            var ser = cert['serial'];
            var normSer = ser.replace('#', '').replace('?', '').replace(/ /g, '').toUpperCase(),
                normKey = key.replace('#', '').replace('?', '').replace(/ /g, '').toUpperCase();
            return normSer === normKey;
        } else {
            var cn = getCertPart(cert['subjectx500'], "CN"),
                sn = getCertPart(cert['subjectx500'], "SN"),
                g = getCertPart(cert['subjectx500'], "G");

            return cn.indexOf(key) >= 0 || sn.indexOf(key) >= 0 || (sn + ' ' + g).indexOf(key) >= 0;
        }
    }

    function getCertError(record) {
        var error = KS.Grid.getAnyCase(record, 'error');
        if (KS.isEmpty(error) && KS.edsType === 2) {
            error = KS.Grid.getAnyCase(record, 'filterreason');
        }
        return error;
    }

    function certGridBeforeSelectHandler(selModel, record) {
        var error = getCertError(record);
        if (!KS.isEmpty(error)) {
            KS.msg(error);
            return false;
        }
    }

    KS.registerCssStyles([
        {
            Properties: { 'background-color': '#ffb6c1' },
            Selector: ".cert-grid-err-record"
        }
    ]);

    function certGridGetRowClass(record) {
        var error = getCertError(record);
        if (!KS.isEmpty(error))
            return 'cert-grid-err-record';
        return '';
    }

    function getSignerFilterString(keyId) {
        var ss = KS.XCrypt.signSettings,
            filter = "";

        if (!ss.noNeedFilter) {
            if (!KS.isEmpty(keyId)) {
                if (!KS.isEmpty(filter)) {
                    filter += "; ";
                }
                filter += KS.L10n.sign_ID + keyId;
            }
            if (!KS.isEmpty(ss.issuerFilter)) {
                if (!KS.isEmpty(filter)) filter += "; ";
                filter += KS.L10n.sign_Supplier + ss.issuerFilter;
            }
            if (!KS.isEmpty(ss.filterOid)) {
                if (!KS.isEmpty(filter)) filter += "; ";
                filter += KS.L10n.sign_Appointment + ss.filterOid;
            }
            if (!KS.isEmpty(ss.secretKeyValidity)) {
                if (!KS.isEmpty(filter)) filter += "; ";
                filter += KS.L10n.sign_ValidityPeriod + ss.secretKeyValidity;
            }
            if (!KS.isEmpty(filter)) filter = KS.L10n.sign_SystemFilter + filter;
        }
        return filter;
    }

    function prepareCertIdForDisplay(certId) {
        if (KS.isEmpty(certId)) return '';
        if (certId.length > 2 && certId.substring(0, 1) == '#') {
            var id = certId.replace('#', '').replace('?', '').replace(/ /g, ''),
                result = '';
            if (id.length % 2 == 0) {
                for (var idx = 0; idx < id.length; idx += 2) {
                    result += id[idx] + id[idx + 1] + ' ';
                }
                certId = result;
            }
        }
        return certId.replace('?', '');
    }

    function displayCertsList(certs, fn, scope, enableErrs) {
        var ss = KS.XCrypt.signSettings;

        KS.XCrypt.certGrid = KS.create(ss.сertGrid);

        var isEmpty = fillCertsGridStore(KS.XCrypt.certGrid, certs, enableErrs);

        KS.XCrypt.certWin = KS.showModal(KS.XCrypt.certGrid, {
            title: KS.L10n.sign_ChooseCertificate + getSignerFilterString(''),
            autoHeight: false,
            height: 400,
            buttonAlign: 'left',
            buttons: new Array({
                xtype: 'label',
                text: KS.L10n.sign_ChooseCertificate + prepareCertIdForDisplay(ss.nastrKeyId)
            }, '->', {
                text: KS.L10n.sign_Choose,
                fn: fn,
                fnScope: scope,
                handler: certificateSelected
            })
        }, true);

        if (isEmpty) {
            describeEmptyCertsList();
        }
    }

    function certificateSelected() {
        var recs = KS.XCrypt.certGrid.getSelectedRecs();
        if (!Ext.isEmpty(recs)) {
            KS.XCrypt.certWin.close();
            this.fn.call(this.fnScope, recs[0].data);
        }
    }

    function describeEmptyCertsList() {
        var storedKeyId = KS.XCrypt.signSettings.nastrKeyId,
            hasUnfilteredCerts = true,
            certType = KS.isEmpty(storedKeyId) ? 'empty' : (storedKeyId[0] == '#' ? 'num' : name),
            genitive = (certType == 'num') ? (KS.L10n.sign_Number + prepareCertIdForDisplay(storedKeyId)) : (KS.L10n.sign_Name + storedKeyId),
            todo = KS.L10n.sign_IssueAdministrator;
        KS.XCrypt.signSettings.nastrKeyId = null;
        if (KS.isEmpty(KS.XCrypt.selectCertificateInternal)) {
            KS.showHtmlProtocol(KS.certNotFoundMsg.replace('{genitive}', genitive) + todo, KS.L10n.sign_DontFindCertificate);
            return;
        }
        KS.XCrypt.selectCertificateInternal(function (rawXml) {
            KS.XCrypt.signSettings.nastrKeyId = storedKeyId;
            try {
                var allCertsList = parseCertsXml(rawXml);
                hasUnfilteredCerts = !KS.isEmpty(allCertsList);
                if (hasUnfilteredCerts) {
                    KS.warning(KS.certNotFoundMsg.replace('{genitive}', genitive) + todo);
                    return;
                }
            } catch (e) {
            }
            if (certType == 'empty') {
                KS.warning(KS.L10n.sign_FromSystemDontInstalled);
            } else {
                KS.warning(KS.certNotFoundMsg.replace('{genitive}', genitive) + todo);
            }
        }, KS.XCrypt.signSettings.selectCertificateParams);
    }

    // Public
    KS.XCrypt = {
        pleaseWait: function (msg) {
            //KS.XCrypt.stopWaiting();
            if (KS.XCrypt.viewContext && KS.isFunction(KS.XCrypt.viewContext.pleaseWait)) {
                KS.XCrypt.viewContext.pleaseWait(msg);
            }
        },

        stopWaiting: function () {
            if (KS.XCrypt.viewContext && KS.isFunction(KS.XCrypt.viewContext.stopWaiting)) {
                KS.XCrypt.viewContext.stopWaiting();
            }
        },

        initialize: function (signSettings, fn, scope, mode) {
            if (signSettings) KS.XCrypt.signSettings = signSettings;
            switch (KS.edsType) {
                case 1:
                    if ((isActiveXSupported() || isNpapiSupported()) && !KS.XCrypt.xObjAppended) {
                        $('<object id="XCryptObj" height="1" width="1" style="position:absolute;top:-1000;" type="application/x-xcrypt" tagName="object"> </object>').appendTo("body");
                        KS.XCrypt.xObjAppended = true;
                    }
                    if (!isActiveXSupported() && !isNpapiSupported() && !isNativeMessagingSupported()) {
                        KS.showHtmlProtocol("<h1>" + KS.L10n.sign_SupportedNextBrowsers + "</h1></br><ul class='x-minus'>" +
                            '<li>Internet explorer 8+</li>' +
                            '<li>Google Chrome 42+</li>' +
                            '<li>Mozilla Firefox*</li></ul></br>' + firefox52EsrMessage,
                            KS.L10n.sign_YourBrowserDontSupported);
                        return;
                    }
                    try {
                        KS.XCrypt.pleaseWait(KS.L10n.sign_InizializationXCrypt);
                        KS.XCrypt.getVersion(function (version) {
                            KS.XCrypt.stopWaiting();
                            if (validateXcrypt(version)) fn.call(scope || this, version);
                        });
                    } catch (e) {
                        KS.XCrypt.stopWaiting();
                        KS.log(e.message || e);
                        validateXcrypt(null);
                    }
                    break;

                case 2:
                    var view = scope;
                    KS.wbe.initCryptoModule(view);
                    if (mode === 'login') {
                        KS.apply(Connection.Info, view.data);
                    }
                    fn.call(scope);
                    break;
            }
        },

        selectCertificate: function (fn, scope, enableErrs) {
            KS.XCrypt.pleaseWait(KS.L10n.sign_AppealStoreCertificates);
            switch (KS.edsType) {
                case 1:
                    KS.XCrypt.selectCertificateInternal(function (rawXml) {
                        try {
                            KS.XCrypt.stopWaiting();
                            var certs = parseCertsXml(rawXml);
                            displayCertsList(certs, fn, scope);
                        } catch (e) {
                            KS.XCrypt.stopWaiting();
                            KS.showHtmlProtocol(e.message || e, KS.L10n.sign_ErrorReadListCertificates);
                        }
                    },
                        KS.XCrypt.signSettings.selectCertificateParams);
                    break;

                case 2:
                    var ss = KS.XCrypt.signSettings;
                    KS.XCrypt.cmInitor.container.Signer.SelectCertificates.call(KS.XCrypt.cmInitor,
                        {
                            keyId: ss.nastrKeyId,
                            issuerFilter: ss.issuerFilter,
                            filterOid: ss.filterOid,
                            numDaysWarnBeforeCertEnd: ss.numDaysWarnBeforeCertEnd + '',
                            onSuccess: function (certs) {
                                try {
                                    KS.XCrypt.stopWaiting();
                                    displayCertsList(certs, fn, scope, enableErrs);
                                } catch (e) {
                                    KS.XCrypt.stopWaiting();
                                    KS.showHtmlProtocol(e.message || e, KS.L10n.sign_ErrorReadListCertificates);
                                }
                            },
                            onError: function (err) {
                                KS.XCrypt.stopWaiting();
                                KS.showHtmlProtocol(err, KS.L10n.sign_ErrorReadListCertificates);
                            },
                            onCancel: function() {
                                KS.XCrypt.stopWaiting();
                            }
                        });
                    break;
            }
        },

        sign: function (text, cert, params, strParams, fn, scope) {
            KS.XCrypt.pleaseWait(KS.L10n.sign_SignatureBuilding);
            switch (KS.edsType) {
                case 1:
                    KS.XCrypt.signInternal(function (sign) {
                        KS.XCrypt.stopWaiting();
                        fn.call(scope || this, sign);
                    }, text, cert, params, strParams);
                    break;

                case 2:
                    var signData = (params == 1)
                        ? KS.XCrypt.cmInitor.container.Signer.Detached.B64Data
                        : KS.XCrypt.cmInitor.container.Signer.Detached.Data;


                    if (!KS.isEmpty(cert) && cert.charAt(0) !== '#')
                        cert = '#' + cert;

                    signData.Sign({
                        data: text,
                        params: params,
                        signParams: {
                            //CertInclude : null
                        },
                        certSubj: cert,
                        onSuccess: function (hash) {
                            try {
                                KS.XCrypt.stopWaiting();
                                fn.call(scope, hash);
                            } catch (e) {
                                KS.XCrypt.stopWaiting();
                                KS.showHtmlProtocol(e.message || e, KS.L10n.sign_ErrorReadListCertificates);
                            }
                        },
                        onError: function (err) {
                            KS.showHtmlProtocol(err, KS.L10n.sign_ErrorMarked);
                        }
                    });

                    break;
            }
        },

        certInfo: function (cert, fn, scope) {
            if (KS.isEmpty(cert) || KS.edsType !== 2) {
                fn.call(scope, {});
                return;
            }
            KS.XCrypt.pleaseWait(KS.L10n.sign_CheckedCertificate);
            var signData = KS.XCrypt.cmInitor.container.Signer.Detached.Data;

            signData.CertInfo({
                certId: cert.replace('#', '').replace('?', '').replace(/ /g, ''),
                onSuccess: function (certInfo) {
                    try {
                        KS.XCrypt.stopWaiting();
                        fn.call(scope, certInfo);
                    } catch (e) {
                    }
                },
                onError: function () {
                    fn.call(scope, {});
                }
            });
        },

        signFileWeb: function (path, cert, params, strParams, fn, scope) {
            switch (KS.edsType) {
                case 1:
                    KS.XCrypt.signFileWebInternal(function (sign) {
                        fn.call(scope || this, sign);
                    }, path, cert, params, strParams);
                    break;

                case 2:
                    KS.error(KS.L10n.sign_FunctionDontSupported);
                    break;
            }
        },

        downloadFile: function (url, fn, scope) {
            switch (KS.edsType) {
                case 1:
                    KS.XCrypt.downloadFileInternal(function (sign) {
                        fn.call(scope || this, sign);
                    }, url);
                    break;

                case 2:
                    KS.error(KS.L10n.sign_FunctionDontSupported);
                    break;
            }
        },

        certGridRenderer: function (value, metadata, record) {
            var error = getCertError(record);
            if (!KS.isEmpty(error)) {
                setTooltip(metadata, error);
            }
            return value;
        }
    }

    function isActiveXSupported() {
        return KS.edsType === 1 && KS.browser.name === 'msie';
    }

    function isNpapiSupported() {
        return KS.edsType === 1 && KS.browser.name === 'firefox' && KS.browser.version <= 52;
    }

    function isNativeMessagingSupported() {
        return KS.edsType === 1 && KS.browser.name === 'chrome' && KS.browser.version > 41;
    }

    if (isNativeMessagingSupported()) {
        // Native messaging implementation
        KS.appendScript('JavaScript/native_messaging.js');
    } else if (isActiveXSupported() || isNpapiSupported()) {
        // ActiveX / NPAPI implementation
        KS.apply(KS.XCrypt, {
            getXObj: function () {
                return document.getElementById('XCryptObj');
            },

            getVersion: function (fn, scope) {
                fn.call(scope || this, KS.XCrypt.getXObj().GetVersion());
            },

            selectCertificateInternal: function (fn, params) {
                var ss = KS.XCrypt.signSettings,
                    rawXml = KS.XCrypt.getXObj().SelectCertificate(ss.nastrKeyId || '', params);
                fn.call(this, rawXml);
            },

            signInternal: function (fn, text, cert, params, strParams) {
                var sign = KS.XCrypt.getXObj().Sign(text, cert, params, strParams);
                fn.call(this, sign);
            },

            signFileWebInternal: function (fn, text, cert, params, strParams) {
                var sign = KS.XCrypt.getXObj().SignFileWeb(text, cert, params, strParams);
                fn.call(this, sign);
            },

            downloadFileInternal: function (fn, url) {
                var path = KS.XCrypt.getXObj().DownloadFile(url);
                fn.call(this, path);
            }
        });
    }
})();
