window.GetSignerGuiMethods = function () {
    var getDateFromString = function (str) {
        var date = new Date(str);
        // https://learn.javascript.ru/intl
        return date.toLocaleString("ru", {
            year: "numeric",
            month: "2-digit",
            day: "2-digit",
            hour: "2-digit",
            minute: "2-digit",
            second: "2-digit"
        });
    };

    return {
        ShowSelectCertWindow: function (p) {
            var certs = (p.certs) ? p.certs : null,
                filterDesc = (typeof p.filterDesc === "string") ? p.filterDesc : "",
                onSelect = (typeof p.onSelect === "function") ? function (cert) {
                    p.onSelect(cert);
                } : function () { },
                onClose = (typeof p.onClose === "function") ? function () {
                    p.onClose();
                } : function () { },
                winWidth = (typeof p.winWidth === "number") ? p.winWidth : 1000,
                winHeight = (typeof p.winHeight === "number") ? p.winHeight : 600;

            if (!certs.length) {
                ExtAlert("#err#Нет сертификатов!");
                return onClose();
            }

            if (certs.length === 1) {
                return onSelect(certs[0]);
            }

            var store = Ext.create("Ext.data.Store", {
                fields: [
                    {
                        name: "issuer"
                    },
                    {
                        name: "notafter"
                    },
                    {
                        name: "notbefore"
                    },
                    {
                        name: "serial"
                    },
                    {
                        name: "subject"
                    },
                    {
                        name: "message"
                    },
                    {
                        name: "error"
                    },
                    {
                        name: "subjectx500"
                    },
                    {
                        name: "signaturealgoid"
                    }
                ],
                data: certs,
                filters: [
                    function (r) {
                        return !r.get("error");
                    }
                ]
            });

            var grid = Ext.create("Ext.grid.Panel", {
                store: store,
                columns: [{
                    header: "Кому выдан",
                    width: 550,
                    renderer: null,
                    dataIndex: "subject"
                },
                {
                    header: "Действителен с",
                    width: 100,
                    align: "right",
                    renderer: getDateFromString, //2016-01-30T08:39:09Z
                    dataIndex: "notbefore"
                },
                {
                    header: "Действителен по",
                    width: 100,
                    align: "right",
                    renderer: getDateFromString,
                    dataIndex: "notafter"
                },
                {
                    header: "УЦ",
                    width: 100,
                    dataIndex: "issuer"
                },
                {
                    header: "СН",
                    width: 100,
                    dataIndex: "serial"
                }
                ],
                renderTo: Ext.getBody(),
                //stripeRows: true,
                //autoExpandColumn: 'subject',
                height: 450,
                listeners: {
                    rowdblclick: function (grid, record) {
                        onSelect(record.getData());
                        win.close();
                    },
                    afterrender: function () {
                        this.setSelection(this.getStore().first());
                    }
                }
            });

            var view = grid.getView();
            Ext.create("Ext.tip.ToolTip", {
                target: view.el,
                delegate: view.itemSelector,
                trackMouse: true,
                renderTo: Ext.getBody(),
                listeners: {
                    beforeshow: function updateTipBody(tip) {
                        var rec = view.getRecord(tip.triggerElement);
                        var tt = "";
                        if (!IsEmpty(rec.get("error"))) {
                            //metaData.style += "color:red;";
                            tt = "<b>" + record.data.error + "</b><br/>" + tt;
                        }
                        if (!IsEmpty(rec.get("message"))) {
                            //metaData.style += "color:brown;";
                            tt = "<b>" + record.data.message + "</b><br/>" + tt;
                        }
                        tt = "<b>Кому выдан:&nbsp;</b>" + (rec.get("subject")) +
                            "<br/><br/><b>УЦ:&nbsp;</b>" + (rec.get("issuer")) +
                            "<br/><br/><b>Действителен с:&nbsp;</b>" + getDateFromString(rec.get("notbefore")) +
                            "<br/><b>Действителен по:&nbsp;</b>" + getDateFromString(rec.get("notafter")) +
                            "<br/><b>СН: </b>" + (rec.get("serial"));
                        tip.update(tt);
                    }
                }
            });

            var win = new Ext.Window({
                title: "Выбор сертификата" + filterDesc,
                width: winWidth,
                height: winHeight,
                minWidth: 300,
                minHeight: 200,
                layout: "fit",
                plain: true,
                modal: true,
                bodyStyle: "padding:5px;",
                buttonAlign: "center",
                html: "",
                items: grid,
                buttons: [ /*{ id: "chRemember", xtype: 'checkbox', boxLabel: 'Запомнить' },*/ {
                    text: "OK",
                    listeners: {
                        click: function () {
                            var sel = grid.getSelection()[0];
                            if (sel) {
                                onSelect(sel.getData());
                                win.close();
                            } else {
                                ExtAlert("Не выбран сертификат");
                            }
                        }
                    }
                }],
                listeners: {
                    beforeclose: function () {
                        onClose();
                        return true;
                    }
                },
                autoscroll: true,
                maximized: false, //!(settings && (p.onLogin || p.onSignMessage)),
                closable: true, //(settings && p.onLogin && (p.OnlyShowGrid || _at[0] == "Standard"))
            }).show();
        },

        ShowSelectCertWindowPromise: function (p) {
            return new Promise(function (resolve, reject) {
                var certs = (p.certs) ? p.certs : null,
                    filterDesc = (typeof p.filterDesc === "string") ? p.filterDesc : "",
                    onSelect = function (cert) {
                        resolve(cert);
                    },
                    onClose = function () {
                        reject({ cancel: true });
                    },
                    winWidth = (typeof p.winWidth === "number") ? p.winWidth : 1000,
                    winHeight = (typeof p.winHeight === "number") ? p.winHeight : 600;

                if (!certs.length) {
                    ExtAlert("#err#Нет сертификатов!");
                    onClose();
                    return;
                }

                if (certs.length === 1) {
                    onSelect(certs[0]);
                    return;
                }

                var store = Ext.create("Ext.data.Store", {
                    fields: [
                        {
                            name: "issuer"
                        },
                        {
                            name: "notafter"
                        },
                        {
                            name: "notbefore"
                        },
                        {
                            name: "serial"
                        },
                        {
                            name: "subject"
                        },
                        {
                            name: "message"
                        },
                        {
                            name: "error"
                        },
                        {
                            name: "subjectx500"
                        },
                        {
                            name: "signaturealgoid"
                        }
                    ],
                    data: certs,
                    filters: [
                        function (r) {
                            return !r.get("error");
                        }
                    ]
                });

                var grid = Ext.create("Ext.grid.Panel", {
                    store: store,
                    columns: [{
                        header: "Кому выдан",
                        width: 550,
                        renderer: null,
                        dataIndex: "subject"
                    },
                    {
                        header: "Действителен с",
                        width: 100,
                        align: "right",
                        renderer: getDateFromString, //2016-01-30T08:39:09Z
                        dataIndex: "notbefore"
                    },
                    {
                        header: "Действителен по",
                        width: 100,
                        align: "right",
                        renderer: getDateFromString,
                        dataIndex: "notafter"
                    },
                    {
                        header: "УЦ",
                        width: 100,
                        dataIndex: "issuer"
                    },
                    {
                        header: "СН",
                        width: 100,
                        dataIndex: "serial"
                    }
                    ],
                    renderTo: Ext.getBody(),
                    //stripeRows: true,
                    //autoExpandColumn: 'subject',
                    height: 450,
                    listeners: {
                        rowdblclick: function (grid, record) {
                            onSelect(record.getData());
                            win.close();
                        },
                        afterrender: function () {
                            this.setSelection(this.getStore().first());
                        }
                    }
                });

                var view = grid.getView();
                Ext.create("Ext.tip.ToolTip", {
                    target: view.el,
                    delegate: view.itemSelector,
                    trackMouse: true,
                    renderTo: Ext.getBody(),
                    listeners: {
                        beforeshow: function updateTipBody(tip) {
                            var rec = view.getRecord(tip.triggerElement);
                            var tt = "";
                            if (!IsEmpty(rec.get("error"))) {
                                //metaData.style += "color:red;";
                                tt = "<b>" + record.data.error + "</b><br/>" + tt;
                            }
                            if (!IsEmpty(rec.get("message"))) {
                                //metaData.style += "color:brown;";
                                tt = "<b>" + record.data.message + "</b><br/>" + tt;
                            }
                            tt = "<b>Кому выдан:&nbsp;</b>" + (rec.get("subject")) +
                                "<br/><br/><b>УЦ:&nbsp;</b>" + (rec.get("issuer")) +
                                "<br/><br/><b>Действителен с:&nbsp;</b>" + getDateFromString(rec.get("notbefore")) +
                                "<br/><b>Действителен по:&nbsp;</b>" + getDateFromString(rec.get("notafter")) +
                                "<br/><b>СН: </b>" + (rec.get("serial"));
                            tip.update(tt);
                        }
                    }
                });

                var win = new Ext.Window({
                    title: "Выбор сертификата" + filterDesc,
                    width: winWidth,
                    height: winHeight,
                    minWidth: 300,
                    minHeight: 200,
                    layout: "fit",
                    plain: true,
                    modal: true,
                    bodyStyle: "padding:5px;",
                    buttonAlign: "center",
                    html: "",
                    items: grid,
                    buttons: [ /*{ id: "chRemember", xtype: 'checkbox', boxLabel: 'Запомнить' },*/ {
                        text: "OK",
                        listeners: {
                            click: function () {
                                var sel = grid.getSelection()[0];
                                if (sel) {
                                    onSelect(sel.getData());
                                    win.close();
                                } else {
                                    ExtAlert("Не выбран сертификат");
                                }
                            }
                        }
                    }],
                    listeners: {
                        beforeclose: function () {
                            onClose();
                            return true;
                        }
                    },
                    autoscroll: true,
                    maximized: false, //!(settings && (p.onLogin || p.onSignMessage)),
                    closable: true, //(settings && p.onLogin && (p.OnlyShowGrid || _at[0] == "Standard"))
                }).show();
            });
        }

    };
}