window.Signer = function (p) {
    // ------------------------------------------------------------------------------------- //
    // >private
    var _module = (p.module) ? p.module : null;
    //delete p;

    var _self = this;

    var _strParams = "TspUrl=";

    var baseData = function (params, baseFunc) {
        return {
            B64Data: baseFunc(params | 1),
            Data: baseFunc(params & ~1)
        };
    };

    var baseSign = function (params) {
        return {
            Sign: function (p /*data, certSubj, onProgress, onSuccess, onError*/) {
                _module.Npx.Sign({
                    text: (p.data) ? p.data : null,
                    name: (typeof p.certSubj === "string") ? p.certSubj : null,
                    params: params,
                    strParams: _strParams,
                    onProgress: (typeof p.onProgress === "function") ? function (response, progressevent) {
                        p.onProgress(response, progressevent);
                    } : null,
                    onSuccess: (typeof p.onSuccess === "function") ? function (value) {
                        p.onSuccess(value);
                    } : null,
                    onError: (typeof p.onError === "function") ? function (msg) {
                        p.onError(msg);
                    } : null
                });
            },
            SignBinary: function (p /*data, certSubj, onProgress, onSuccess, onError*/) {
                _module.Crypto.Sign({
                    blob: p.data,
                    name: (typeof p.certSubj === "string") ? p.certSubj : null,
                    //params: params,
                    //strParams: _strParams,
                    onProgress: (typeof p.onProgress === "function") ? function (response, progressevent) {
                        p.onProgress(response, progressevent);
                    } : null,
                    onSuccess: (typeof p.onSuccess === "function") ? function (value) {
                        p.onSuccess(value);
                    } : null,
                    onError: (typeof p.onError === "function") ? function (msg) {
                        p.onError(msg);
                    } : null
                });
            },
            DownloadFileAndSign: function (p) {
                var
                    onProgress = (typeof p.onProgress === "function") ? function (response, progressevent) {
                        p.onProgress(response, progressevent);
                    } : null,
                    onError = (typeof p.onError === "function") ? function (msg) {
                        p.onError(msg);
                    } : null;

                _module.Npx.DownloadFile({
                    url: (p.url) ? p.url : null,
                    onProgress: onProgress,
                    onSuccess: function (path) {
                        _module.Npx.SignFileWeb({
                            path: path,
                            name: (typeof p.certSubj === "string") ? p.certSubj : null,
                            params: params,
                            strParams: _strParams,
                            onProgress: onProgress,
                            onSuccess: (typeof p.onSuccess === "function") ? function (value) {
                                p.onSuccess(value);
                            } : null,
                            onError: onError
                        });
                    },
                    onError: onError
                });
            },
            //подписывание данных через CryptoModule
            //Call crypto/sign/v1/, FormData: {data, cert}
            Sign2: function (p /*data, certSubj, onProgress, onSuccess, onError*/) {
                _module.Crypto.Sign({
                    blob: (p.data) ? p.data : null,
                    name: (typeof p.certSubj === "string") ? p.certSubj : null,
                    B64: p.B64,
                    SignParams: p.signParams,
                    params: params,
                    strParams: _strParams,
                    onProgress: (typeof p.onProgress === "function") ? function (response, progressevent) {
                        p.onProgress(response, progressevent);
                    } : null,
                    onSuccess: (typeof p.onSuccess === "function") ? function (value) {
                        p.onSuccess(value);
                    } : null,
                    onError: (typeof p.onError === "function") ? function (msg) {
                        p.onError(msg);
                    } : null
                });
            },
        };
    };

    var baseHash = function (params) {
        return {
            Sign: function (p /*data, certSubj, onProgress, onSuccess, onError*/) {
                _module.Npx.Sign({
                    text: (p.data) ? p.data : null,
                    name: (typeof p.certSubj === "string") ? p.certSubj : null,
                    params: params,
                    strParams: _strParams,
                    onProgress: (typeof p.onProgress === "function") ? function (response, progressevent) {
                        p.onProgress(response, progressevent);
                    } : null,
                    onSuccess: (typeof p.onSuccess === "function") ? function (value) {
                        p.onSuccess(value);
                    } : null,
                    onError: (typeof p.onError === "function") ? function (msg) {
                        p.onError(msg);
                    } : null
                });
            },
            Hash: function (p /*data, certSubj, onProgress, onSuccess, onError*/) {
                _module.Npx.Hash({
                    text: (p.data) ? p.data : null,
                    name: (typeof p.certSubj === "string") ? p.certSubj : null,
                    params: params,
                    strParams: _strParams,
                    onProgress: (typeof p.onProgress === "function") ? function (response, progressevent) {
                        p.onProgress(response, progressevent);
                    } : null,
                    onSuccess: (typeof p.onSuccess === "function") ? function (value) {
                        p.onSuccess(value);
                    } : null,
                    onError: (typeof p.onError === "function") ? function (msg) {
                        p.onError(msg);
                    } : null
                });
            },
            //подписывание хэша через CryptoModule
            //Call crypto/sign/v1/, FormData: {hash, cert}
            Sign2: function (p /*data, certSubj, onProgress, onSuccess, onError*/) {
                _module.Crypto.SignHash({
                    Data: (p.data) ? p.data : null,
                    CertSerial: (typeof p.certSubj === "string") ? p.certSubj : null,
                    B64: true,
                    SignParams: p.signParams,
                    onProgress: (typeof p.onProgress === "function") ? function (response, progressevent) {
                        p.onProgress(response, progressevent);
                    } : null,
                    onSuccess: (typeof p.onSuccess === "function") ? function (value) {
                        p.onSuccess(value);
                    } : null,
                    onError: (typeof p.onError === "function") ? function (msg) {
                        p.onError(msg);
                    } : null
                });
            },            
        };
    };
    ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    // FACE
    ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    // return Certs
    _self.SelectCertificates = function (p) {
        var params = 'FilterOID=' + ((typeof p.filterOid === "string") ? p.filterOid : "") +
            '\r\nIssuer=' + ((typeof p.issuerFilter === "string") ? p.issuerFilter : "") +
            '\r\nNumDaysWarnBeforeCertEnd=' + ((typeof p.numDaysWarnBeforeCertEnd === "string") ? p.numDaysWarnBeforeCertEnd : "");

        var filter = "";
        if (p.keyId) {
            if (filter) {
                filter += "; ";
            }
            filter += "Идентификатор: " + p.keyId;
        }
        if (p.issuerFilter) {
            if (filter) {
                filter += "; ";
            }
            filter += "Поставщик: " + p.issuerFilter;
        }
        if (p.filterOid) {
            if (filter) {
                filter += "; ";
            }
            filter += "Назначение (OID): " + p.filterOid;
        }
        if (filter) {
            filter = ". Системный фильтр: " + filter;
        }

        _module.Npx.SelectCertificates({
            keyId: (typeof p.keyId === "string") ? p.keyId : "",
            params: params,
            onSuccess: (typeof p.onSuccess === "function") ? function (certs) {
                p.onSuccess(certs, filter);
            } : null,
            onError: (typeof p.onError === "function") ? function (msg) {
                p.onError(msg);
            } : null,
            onCancel: (typeof p.onCancel === "function") ? function (msg) {
                p.onCancel(msg);
            } : null
        });
    };

    _self.SelectCertificatesPromise = function (p) {
        return new Promise(function (resolve, reject) {
            var params = 'FilterOID=' + ((typeof p.filterOid === "string") ? p.filterOid : "") +
                '\r\nIssuer=' + ((typeof p.issuerFilter === "string") ? p.issuerFilter : "") +
                '\r\nNumDaysWarnBeforeCertEnd=' + ((typeof p.numDaysWarnBeforeCertEnd === "string") ? p.numDaysWarnBeforeCertEnd : "");

            var filter = "";
            if (p.keyId) {
                if (filter) {
                    filter += "; ";
                }
                filter += "Идентификатор: " + p.keyId;
            }
            if (p.issuerFilter) {
                if (filter) {
                    filter += "; ";
                }
                filter += "Поставщик: " + p.issuerFilter;
            }
            if (p.filterOid) {
                if (filter) {
                    filter += "; ";
                }
                filter += "Назначение (OID): " + p.filterOid;
            }
            if (filter) {
                filter = ". Системный фильтр: " + filter;
            }

            _module.Npx.SelectCertificates({
                keyId: (typeof p.keyId === "string") ? p.keyId : "",
                params: params,
                onSuccess: function (certs) {
                    resolve({ certs: certs, filter: filter });
                },
                onError: reject
            });
        });
    };
    ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    /*
    //Params&1  = tText in base64
    //Params&2  = CAdES signature
    //Params&4  = Attached signature
    //Params&8  = is Smev signature (return Xml with <signature> and <certificate> in base64)
    //Params&16 = type of CAdES: 1 - CAdES-BES, 0 - CAdES-X Long Type 1
    //Params&32 = sign hash
    //Params&64 = get hashAlgOid by cert
    //Params&128= not include cert in pkcs7
    */
    ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    _self.Attached = baseData(4, baseSign);
    _self.Detached = baseData(0, baseSign);
    ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    // this.SignXml = baseData(8, baseSign);
    _self.SignXml = function (p) {
        _module.Crypto.SignXml({
            xml: p.xml,
            signedInfo: p.signedInfo,
            name: (typeof p.certSubj === "string") ? p.certSubj : null,
            //params: params,
            //strParams: _strParams,
            onProgress: (typeof p.onProgress === "function") ? function (response, progressevent) {
                p.onProgress(response, progressevent);
            } : null,
            onSuccess: (typeof p.onSuccess === "function") ? function (value) {
                p.onSuccess(value);
            } : null,
            onError: (typeof p.onError === "function") ? function (msg) {
                p.onError(msg);
            } : null
        });
    };
    ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    _self.SignHash = baseData(32, baseHash);
    ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    _self.GetHashAlgByCert = function (p /*certSubj, onProgress, onSign, onError*/) {
        _module.Npx.Sign({
            text: null,
            name: (typeof p.certSubj === "string") ? p.certSubj : null,
            params: 64,
            strParams: _strParams,
            onProgress: (typeof p.onProgress === "function") ? function (response, progressevent) {
                p.onProgress(response, progressevent);
            } : null,
            onSuccess: (typeof p.onSuccess === "function") ? function (value) {
                p.onSuccess(value);
            } : null,
            onError: (typeof p.onError === "function") ? function (msg) {
                p.onError(msg);
            } : null
        });
    };
    ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    _self.HashXml = baseData(2, baseHash);
    ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    _self.DeleteArchive = function () {
        _module.Npx.DeleteArchive({});
    };
    _self.Clear = function (p) {
        _module.Crypto.Clear(p);
    };
    ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    _self.HashPromise = function (p) {
        return _module.Crypto.HashPromise({
            data: p.data,
            algoid: p.algoid
        });
    };
    _self.SignHashPromise = function (p) {
        return _module.Crypto.SignHashPromise({
            data: p.data,
            certserial: p.certserial
        });
    }
    _self.SignPromise = function (p) {
        return _module.Crypto.SignPromise({
            data: p.data,
            certserial: p.certserial
        });
    };
    _self.SignSimplePromise = function (p) {
        return _module.Crypto.SignSimplePromise({
            data: p.data,
            certserial: p.certserial
        });
    };
};