﻿/*
Detect Browser version and show message about

http: //www.useragentstring.com/pages/Firefox/
https://github.com/ded/bowser
*/
/*!
  * Bowser - a browser detector
  * https://github.com/ded/bowser
  * MIT License | (c) Dustin Diaz 2014
  */

!function(name, definition) {
	if (typeof module != 'undefined' && module.exports)
		module.exports.browser = definition();
	else if (typeof define == 'function') define(definition);
	else this[name] = definition();
}('bowser', function() {
	/**
	 * See useragents.js for examples of navigator.userAgent
	 */

	var t = true;

	function detect(ua) {

		function getFirstMatch(regex) {
			var match = ua.match(regex);
			return (match && match.length > 1 && match[1]) || '';
		}

		var iosdevice = getFirstMatch(/(ipod|iphone|ipad)/i).toLowerCase(),
			likeAndroid = /like android/i.test(ua),
			android = !likeAndroid && /android/i.test(ua),
			versionIdentifier = getFirstMatch(/version\/(\d+(\.\d+)?)/i),
			tablet = /tablet/i.test(ua),
			mobile = !tablet && /[^-]mobi/i.test(ua),
			result;

		if (/opera|opr/i.test(ua)) {
			result = {
				name: 'Opera',
				opera: t,
				version: versionIdentifier || getFirstMatch(/(?:opera|opr)[\s\/](\d+(\.\d+)?)/i)
			};
		} else if (/windows phone/i.test(ua)) {
			result = {
				name: 'Windows Phone',
				windowsphone: t,
				msie: t,
				version: getFirstMatch(/iemobile\/(\d+(\.\d+)?)/i)
			};
		} else if (/msie|trident/i.test(ua)) {
			result = {
				name: 'Internet Explorer',
				msie: t,
				version: getFirstMatch(/(?:msie |rv:)(\d+(\.\d+)?)/i)
			};
		} else if (/chrome|crios|crmo/i.test(ua)) {
			result = {
				name: 'Chrome',
				chrome: t,
				version: getFirstMatch(/(?:chrome|crios|crmo)\/(\d+(\.\d+)?)/i)
			};
		} else if (iosdevice) {
			result = {
				name: iosdevice == 'iphone' ? 'iPhone' : iosdevice == 'ipad' ? 'iPad' : 'iPod'
			};
			// WTF: version is not part of user agent in web apps
			if (versionIdentifier) {
				result.version = versionIdentifier;
			}
		} else if (/sailfish/i.test(ua)) {
			result = {
				name: 'Sailfish',
				sailfish: t,
				version: getFirstMatch(/sailfish\s?browser\/(\d+(\.\d+)?)/i)
			};
		} else if (/seamonkey\//i.test(ua)) {
			result = {
				name: 'SeaMonkey',
				seamonkey: t,
				version: getFirstMatch(/seamonkey\/(\d+(\.\d+)?)/i)
			};
		} else if (/firefox|iceweasel/i.test(ua)) {
			result = {
				name: 'Firefox',
				firefox: t,
				version: getFirstMatch(/(?:firefox|iceweasel)[ \/](\d+(\.\d+)?)/i)
			};
			if (/\((mobile|tablet);[^\)]*rv:[\d\.]+\)/i.test(ua)) {
				result.firefoxos = t;
			}
		} else if (/silk/i.test(ua)) {
			result = {
				name: 'Amazon Silk',
				silk: t,
				version: getFirstMatch(/silk\/(\d+(\.\d+)?)/i)
			};
		} else if (android) {
			result = {
				name: 'Android',
				version: versionIdentifier
			};
		} else if (/phantom/i.test(ua)) {
			result = {
				name: 'PhantomJS',
				phantom: t,
				version: getFirstMatch(/phantomjs\/(\d+(\.\d+)?)/i)
			};
		} else if (/blackberry|\bbb\d+/i.test(ua) || /rim\stablet/i.test(ua)) {
			result = {
				name: 'BlackBerry',
				blackberry: t,
				version: versionIdentifier || getFirstMatch(/blackberry[\d]+\/(\d+(\.\d+)?)/i)
			};
		} else if (/(web|hpw)os/i.test(ua)) {
			result = {
				name: 'WebOS',
				webos: t,
				version: versionIdentifier || getFirstMatch(/w(?:eb)?osbrowser\/(\d+(\.\d+)?)/i)
			};
			/touchpad\//i.test(ua) && (result.touchpad = t);
		} else if (/bada/i.test(ua)) {
			result = {
				name: 'Bada',
				bada: t,
				version: getFirstMatch(/dolfin\/(\d+(\.\d+)?)/i)
			};
		} else if (/tizen/i.test(ua)) {
			result = {
				name: 'Tizen',
				tizen: t,
				version: getFirstMatch(/(?:tizen\s?)?browser\/(\d+(\.\d+)?)/i) || versionIdentifier
			};
		} else if (/safari/i.test(ua)) {
			result = {
				name: 'Safari',
				safari: t,
				version: versionIdentifier
			};
		} else result = {};

		// set webkit or gecko flag for browsers based on these engines
		if (/(apple)?webkit/i.test(ua)) {
			result.name = result.name || "Webkit";
			result.webkit = t;
			if (!result.version && versionIdentifier) {
				result.version = versionIdentifier;
			}
		} else if (!result.opera && /gecko\//i.test(ua)) {
			result.name = result.name || "Gecko";
			result.gecko = t;
			result.version = result.version || getFirstMatch(/gecko\/(\d+(\.\d+)?)/i);
		}

		// set OS flags for platforms that have multiple browsers
		if (android || result.silk) {
			result.android = t;
		} else if (iosdevice) {
			result[iosdevice] = t;
			result.ios = t;
		}

		// OS version extraction
		var osVersion = '';
		if (iosdevice) {
			osVersion = getFirstMatch(/os (\d+([_\s]\d+)*) like mac os x/i);
			osVersion = osVersion.replace(/[_\s]/g, '.');
		} else if (android) {
			osVersion = getFirstMatch(/android[ \/-](\d+(\.\d+)*)/i);
		} else if (result.windowsphone) {
			osVersion = getFirstMatch(/windows phone (?:os)?\s?(\d+(\.\d+)*)/i);
		} else if (result.webos) {
			osVersion = getFirstMatch(/(?:web|hpw)os\/(\d+(\.\d+)*)/i);
		} else if (result.blackberry) {
			osVersion = getFirstMatch(/rim\stablet\sos\s(\d+(\.\d+)*)/i);
		} else if (result.bada) {
			osVersion = getFirstMatch(/bada\/(\d+(\.\d+)*)/i);
		} else if (result.tizen) {
			osVersion = getFirstMatch(/tizen[\/\s](\d+(\.\d+)*)/i);
		}
		if (osVersion) {
			result.osversion = osVersion;
		}

		// device type extraction
		var osMajorVersion = osVersion.split('.')[0];
		if (tablet || iosdevice == 'ipad' || (android && (osMajorVersion == 3 || (osMajorVersion == 4 && !mobile))) || result.silk) {
			result.tablet = t;
		} else if (mobile || iosdevice == 'iphone' || iosdevice == 'ipod' || android || result.blackberry || result.webos || result.bada) {
			result.mobile = t;
		}

		// Graded Browser Support
		// http://developer.yahoo.com/yui/articles/gbs
		if ((result.msie && result.version >= 10) ||
			(result.chrome && result.version >= 20) ||
			(result.firefox && result.version >= 20.0) ||
			(result.safari && result.version >= 6) ||
			(result.opera && result.version >= 10.0) ||
			(result.ios && result.osversion && result.osversion.split(".")[0] >= 6)
		) {
			result.a = t;
		} else if ((result.msie && result.version < 10) ||
			(result.chrome && result.version < 20) ||
			(result.firefox && result.version < 20.0) ||
			(result.safari && result.version < 6) ||
			(result.opera && result.version < 10.0) ||
			(result.ios && result.osversion && result.osversion.split(".")[0] < 6)
		) {
			result.c = t;
		} else result.x = t;

		return result;
	}

	window.bowser = detect(typeof navigator !== 'undefined' ? navigator.userAgent : '');


	/*
   * Set our detect method to the main bowser object so we can
   * reuse it to test other user agents.
   * This is needed to implement future tests.
   */
	bowser._detect = detect;

	return bowser;
});

window.ShowMessage = function(link) {
	if (!window.badDiv) {
		var d1 = window.badDiv = document.createElement('div');

		d1.style.position = 'absolute';
		d1.style.top = '0px';
		d1.style.left = '0px';
		d1.style['background-color'] = 'black';
		d1.style.opacity = '0.75';
		d1.style.width = '100%';
		d1.style.height = '50%';
		d1.style.zIndex = 5000;

		var d2 = window.badDiv = document.createElement('div');

		d2.innerHTML = '<img src="/Images/oldBrowser.png" style="float: left;padding-right:10px"/><p style="text-align:center"><br/><strong>Извините! Данное приложение не поддерживается Вашим браузером </strong><br /><br />Если хотите воспользоваться нашим продуктом, пройдите на сайт разработчика и <a href="' + link + '">обновите браузер.</a></p>';
		d2.style.position = 'absolute';
		d2.style.top = '50%';
		d2.style.left = '50%';
		d2.style['margin-left'] = '-210px';
		d2.style['margin-top'] = '-100px';
		d2.style.width = '450px';
		d2.style.height = '200px';
		d2.style.zIndex = 6000;

		document.onactivate = function() {
			document.body.appendChild(d1);
			document.body.appendChild(d2);
		};
	}
};

window.CheckBrowser = function() {
	return false;
	/*if (window.bowser.firefox && bowser.version < 43) { //test for Firefox/x.x or Firefox x.x (ignoring remaining digits);
		{
			ShowMessage('http://getfirefox.org');
			return true;
		}
	} else if (bowser.msie && bowser.version < 11) {
		{
			ShowMessage('http://windows.microsoft.com/ru-Ru/internet-explorer/download-ie');
			return true;
		}
	} else if (bowser.opera && bowser.version < 35) { //test for Opera/x.x or Opera x.x (ignoring remaining decimal places);
		{
			ShowMessage("http://www.opera.com/download");
			return true;
		}
	} else if (bowser.safari && bowser.version < 9) { //test for Safari
		{
			ShowMessage("http://support.apple.com/downloads/#safari");
			return true;
		}
	} else if (bowser.chrome && bowser.version < 45) { //test for Chrome
		{
			ShowMessage("https://www.google.ru/intl/ru/chrome/browser/");
			return true;
		}
	}
	return false;*/
};

CheckBrowser();