﻿import HeadLib from './Head';
import LocalStorage from "../Other/LocalStorage";
import NavigatorLib from "../Other/Navigator";

/*
Copyright (c) 2014 Keysystems.ru

Contact:  http://www.keysystems.ru/contact

Commercial Usage
Licensees holding valid commercial licenses may use this file in accordance with the Commercial Software License Agreement provided with the Software or, alternatively, in accordance with the terms contained in a written agreement between you and Sencha.

If you are unsure which license is appropriate for your use, please contact the sales department at http://www.keysystems.ru/contact
*/

//Globally handle any Ext errors that may be raised
Ext.Error.handle = function(err) {
	if (err.someProperty == 'NotReallyAnError') {
		// maybe log something to the application here if applicable
		return true;
	}
	// any non-true return value (including none) will cause the error to be thrown
};
if (!CheckBrowser())
	Ext.define('RevizorViewer.App',
		{
			extend: 'Ext.container.Viewport',
			ret: null,
			initComponent: function() {
				var me = window.app = this;

				Ext.override(Ext.data.proxy.Ajax, { timeout: TimeOut });
				Ext.Ajax.timeout = TimeOut;
				Ext.override(Ext.data.proxy.Server, { timeout: Ext.Ajax.timeout });
				Ext.override(Ext.data.Connection, { timeout: Ext.Ajax.timeout });

				// event of esc
				Ext.override(Ext.Window,
					{
						listeners: {
							afterrender: function() {
								Ext.create('Ext.util.KeyNav', {
									target: this.getEl(),
									esc: function () {
										if (this.closable || this.closable === _) this.close();
									},
									scope: this
								});
							}
						}
					});

				//если произошла ошибка в данных то показываем на экране
				Ext.override(Ext.data.Store,
					{
						listeners: {
							'loadexception': function(proxy, options, response) {

								Ext.MessageBox.show({
									title: 'Error on store load',
									msg: Ext.decode(response.responseText).msg,
									buttons: Ext.Msg.OK,
									closable: false,
									icon: Ext.MessageBox.ERROR
								});
							}
						}
					});

				// RWEB-326
				Ext.apply(Ext.data.SortTypes,
					{
						asNatural: function(str) {
							// Pad all the numbers we can find with 10 zeros to the left, then trim
							// down to the last 10 digits. A primitive natural sort occurs.
							// WARN: May do odd things to any numbers longer than 10 digits. It will
							// also not work as you might expect on decimals.
							return (str + '').replace(/(\d+)/g, "0000000000$1").replace(/0*(\d{10,})/g, "$1");
						}
					});

				// RWEB-73
				//http://www.learnsomethings.com/2012/05/04/stop-the-backspace-key-from-going-to-the-previous-page-in-your-extjs-app/

				var inputTypes = ['text', 'password', 'textarea'];
				//Ext.EventManager
				Ext.getBody().addListener(
					'keydown',
					function(e) {
						if (e.getKey() === e.BACKSPACE && inputTypes.indexOf(e.getTarget().type) === -1) {
							e.preventDefault();
						}
					});

				window.beforeunloadFn = function() {
					if (window.reloadedOnce)
						return;
					window.reloadedOnce = true;
					ajaxRequest({
						url: '/Home/ReloadOthers'
					});
					
					if (!window.isDebug) {
						return wmc.get('UnLoadWindow');
					}
				};
				
				$(window).on('beforeunload', window.beforeunloadFn);

				window.globalVisible = function(visible) {
					objs.head.setVisible(visible);
					objs.navigator.setVisible(visible);
					window.bodyPanel.setVisible(visible);
				};

				Ext.apply(this,
					{
						layout: 'border',
						autoScroll: true,
						bodyBorder: false,
						defaults: { split: true },
						items: [
							objs.head = HeadLib.getHeadPanel(),
							objs.navigator = Ext.create('Ext.tab.Panel',
								{
									region: 'west',
									hidden: true,
									title: 'Навигатор',
									closable: false,
									autoRender: true,
									border:false,
									layout: 'fit',
									tabPosition: 'bottom',
									collapsible: true,
									collapseToolText: 'Свернуть',
									expandToolText: 'Развернуть',
									header:{
										items: [
											{
												xtype: 'tool',
												iconCls: 'x_btn_panel_refresh',
												handler: me.refreshActiveTab,
												tooltip: 'Обновить'
											},
										],
									},
									ui: window.Theme === 'crisp' ? 'navigator-ks' : 'default',
									listeners: {
										beforetabchange: function (th, newTab){
											th.setTitle(newTab.title);
										},
										tabchange: function(th, newTab){
											newTab.fireEvent('ksTabActivate', newTab);
										}
									}
								}),
							window.bodyPanel = Ext.create('Ext.panel.Panel',
								{
									layout: 'fit',
									region: 'center',
									hidden: true,
									border: 0,
									bodyPadding: 0,
									defaults: {
										split: true
									},
									items: [
										window.tabView = new Ext.tab.Panel({
											autoScroll: true,
											id: 'ks-main-tab-panel',
											ui: window.Theme === 'crisp' ? 'navigation-tabs-ks' : 'default',
											plugins: [
												Ext.create('Keysystems.ux.TabCloseMenu'),
												Ext.create('Ext.ux.TabReorderer')
											],
											listeners: {
												add: function(th, comp) { me.addOpenDict(comp.dict); },
												remove: function(th, comp) { me.remOpenDict(comp.dict); },
												tabchange: function() {

												}
											}
										})
									]
								})
						],
						listeners: {
							resize: function(th, width, height, oldWidth, oldHeight) {
								if (oldWidth && oldHeight) {
									if (width < objs.minWidth) {
										objs.mp.setWidth(objs.minWidth);
									}
									if (height < objs.minHeight) {
										objs.mp.setHeight(objs.minHeight);
									}
								}
							},
							add: function (me, item) {
								if (item.xtype == 'bordersplitter') item.width = 10;
							}
						}
					});


				me.callParent(arguments);
				/*
				var bgVideo = document.createElement('video');
				bgVideo.className = 'fullscreen-bg-video';
				bgVideo.autoplay = true;
				bgVideo.loop = true;
				bgVideo.poster = 'Images/bg.jpg';
				bgVideo.innerHTML = '<source type="video/mp4" src="Images/bg.mp4"><source type="video/webm" src="Images/bg.webm">';
				me.el.dom.insertBefore(bgVideo, me.el.dom.lastChild);
				window.bgVideo = bgVideo;*/
			},

			getListKey: function() {
				return JSON.stringify({
					key: 'OpenDictList',
					Server: user.Server,
					DataBase: user.DataBase,
					login: user.login
				});
			},
			getOpenList: function() { return JSON.parse(LocalStorage.get(this.getListKey(), 1) || '[]'); },
			setOpenList: function(v) { return LocalStorage.set(this.getListKey(), JSON.stringify(v), 1); },
			getDictKey: function(dict) {
				return JSON.stringify({
					title: dict.title,
					GateCode: dict.GateCode,
					code: dict.code
				});
			},
			addOpenDict: function(dict) {
				if (dict && !dict.isEventLog) {
					var me = this,
						key = me.getDictKey(dict),
						list = me.getOpenList();
					if (list.indexOf(key) === -1) list.push(key);
					me.setOpenList(list);
				}
			},
			remOpenDict: function(dict) {
				if (dict) {
					var me = this,
						key = me.getDictKey(dict),
						list = me.getOpenList();
					ArrayLib.remove(list, key);
					me.setOpenList(list);
				}
			},
			showDictList: function() {
				var me = this;

				Ext.each(me.getOpenList(),
					function(key) {
						var cfg = JSON.parse(key);
						cfg.checkModel =
							NavigatorLib.checkModelList && NavigatorLib.checkModelList.indexOf(cfg.code) !== -1;
						cfg.tabMode = true;
						cfg.parentView = window.tabView;
						const node = window.objs.subNavigator.store.findRecord('GateCode', cfg.GateCode);
						if (node) {
							cfg.beforeInitListData = () => node.set('loading', true);
							cfg.afterInitListData = () => node.set('loading', false);
						}
						window.openList(cfg);
					});
			},
			refreshActiveTab: function () {
				let tab = this.up('tabpanel')?.activeTab;
				tab && tab.fireEvent('ksRefresh');
			}
		});