﻿Ext.define('Keysystems.UsersTemplate.List', {
    extend: 'Keysystems.Base.List',
    
    multiSelectGridVisible: false,
    hidePagging: true,
    ignoreLoadNextPrevPages: true,
    profileLinkCode: 'UsersTemplate',

    viewCfg: function() {
        let me = this,
            res = me.callParent(arguments);

        delete res.dict;
        res.tabID = 'PLT_USERS_TEMPLATE_ADM';

        return res;
    },
    createTBar: function() {
        let me = this,
            res = me.callParent(arguments);

        if (me.viewMode === 'viewShow') {
            for (var btn in me.objs.tbarBtns) {
                if (me.objs.tbarBtns[btn].code !== 'refresh_plt') {
                    if (me.objs.tbarBtns[btn].setHidden) me.objs.tbarBtns[btn].setHidden(true);
                }
            }
        }
        
        return res;
    },    
    createItems() {
        let me = this,
            res = me.callParent(arguments);

        res.push(me.sksc('infoBlockPanel', Ext.create('Ext.panel.Panel',
            {
                hidden: true,
                title: 'Протокол сохранения',
                items: [
                ]
            })));

        return res;
    },
    
    refresh: function(reload, hideMsg) {
        let me = this;

        me.showLoadMask({
            msg: KS.L10n.updating_data,
            rid: me.ridGet = ajaxRequest({
                url: me.linkCode + '/Get_A',
                params: {
                    gzipData: SignalR.pack({
                        reload: true
                    })
                },
                success: function (data) {
                    me.objs.Grid.store.loadData(data.data.data);
                    me.dataCount = data.data.total;
                    me.setChecks(me.checkList,  me.objs.Grid.store.getData().items);
                    if (!me.Grid.selModel.getSelected().length) {
                        me.Grid.extraSelectFrst();
                    }
                    me.hideLoadMask();
                },
                failure: function (response) {
                    console.error(response);
                    me.loadMask.setErrorState();
                },
                callback: function () {
                    delete me.ridGet;
                }
            }),
            cancelFn: function () {
                if (me.ridGet) SignalR.delCallBack(me.ridGet);
            }
        });
        
    }
});