Ext.define('Keysystems.UsersGroups.Tree', {
	extend: 'Ext.window.Window',
	modal: true,
	iconCls: 'x_btn_users',
	layout: {type: 'vbox', align: 'stretch'},
	width: 600,
	height: 400,
	minHeight: 200,
	minWidth: 400,
	result: null,
	maximizable: true,

	labelWidth: 200,
	resizable: true,
	config: {
		uids: [],
		mode: null,
		multiSelect: false,
		formatName: false
	},
	data: null,

	constructor: function (cfg) {
		Ext.apply(this, cfg);
		this.callParent(arguments);
	},

	submit: function () {
		let me = this,
			res = me.getSelected();
		if (me.ok) me.ok(res);
		me.close();
	},

	createButtons: function () {
		let me = this;
		return [
			{text: 'Выбрать', handler: me.submit, scope: this},
			{text: 'Закрыть', handler: me.close, scope: this}
		];
	},

	initComponent: function () {
		let me = this;

		me.buttons = me.createButtons();
		me.items = [
			me.treePanel = Ext.create('Ext.tree.Panel', {
				hideHeaders: true,
				autoScroll: true,
				border: 0,
				flex: 1,
				tbar: [
					Ext.create('Ext.Button',
						{
							tooltip: 'Отметить все',
							tooltipType: 'title',
							iconCls: 'x_btn_galka',
							hidden: !me.multiSelect,
							handler: () => me.checkAll(true)
						}),
					Ext.create('Ext.Button',
						{
							tooltip: 'Разметить все',
							tooltipType: 'title',
							iconCls: 'x_btn_unmark',
							hidden: !me.multiSelect,
							handler: () => me.checkAll(false)
						}),
					Ext.create('Ext.Button',
						{
							tooltip: 'Обновить',
							tooltipType: 'title',
							iconCls: 'x_btn_refresh',
							handler: function () {
								me.refresh(true);
							}
						}),
					Ext.create('Ext.Button',
						{
							tooltip: 'Развернуть все узлы',
							tooltipType: 'title',
							iconCls: 'x_btn_treeexpand',
							handler: function () {
								me.treePanel.expandAll();
							}
						}),
					Ext.create('Ext.Button', {
						tooltip: 'Свернуть все узлы',
						tooltipType: 'title',
						iconCls: 'x_btn_treecollapse',
						handler: function () {
							me.treePanel.collapseAll();
						}
					}),
					Ext.create('Ext.Button', {
						tooltip: 'Выход',
						tooltipType: 'title',
						iconCls: 'x_btn_exit',
						handler: function () {
							me.close();
						}
					})
				],
				caseSensitive: false,
				columns: [{
					xtype: 'treecolumn',
					text: 'Name',
					width: 10000,
					dataIndex: 'NAME',
					renderer: (value, rec) => {
						let cls = rec.record.match;
						if (cls) return Ext.String.format('<span class="{0}">{1}</span>', cls, rec.record.data.NAME);
						return value;
					}
				}],
				store: Ext.create('Ext.data.TreeStore', {
					fields: ['LINK', 'UID', 'CODE', 'NAME'],
					root: {expanded: true, children: []},
					defaultRootText: ''
				}),
				rootVisible: false,
				listeners: {
					checkchange: function (node, checked) {
						if (!node.isLeaf()) {
							node.cascade(node => node.set('checked', checked));
						}
					},
					rowdblclick: function (t, node) {
						if (me.multiSelect) {
							if (node.isLeaf()) {
								node.set('checked', !node.get('checked'));
							}
						}
					},
				}
			})
		];
		me.treePanel.addDocked([me.createSearchPanel()]);
		me.callParent(arguments);
		me.on('afterrender', me.refresh.bind(me));
	},

	createSearchPanel: function () {
		let me = this;
		return me.searchField = Ext.create('Keysystems.Tree.SearchPanel', {
			treePanel: me.treePanel
		});
	},

	refresh: function (reload) {
		let me = this;
		const loadMask = new Ext.LoadMask({
			msg: reload ? KS.L10n.updating_data : KS.L10n.loading_data,
			target: me, 
			autoShow: true,
			rid: ajaxRequest({
				url: 'SUserGroup/GetUsersGroups_A',
				params: {code: me.code || null, mode: me.mode},
				success: function (result) {
					me.data = result.tree;
					me.treePanel.store.setRootNode({expanded: true, children: me.buildTree(null)});

					let nodeSelected;
					if (!me.multiSelect && me.uids && me.uids.length > 0)
						nodeSelected = me.treePanel.store.getRootNode().findChild('UID', me.uids[0], true);
					if (!nodeSelected)
						nodeSelected = me.treePanel.store.root.firstChild;

					let selModel = me.treePanel.getSelectionModel();
					if (selModel) selModel.select(nodeSelected);
				},
				callback: function () {
					loadMask.destroy();
				}
			})
		});
	},

	prepareData: function (r) {
		let me = this;
		if (r.image) r.iconCls = 'x_btn_' + r.image.toLowerCase() + ' x_btn_' + r.image.toUpperCase();
		if (me.multiSelect) r.checked = me.uids && me.uids.map(uid => uid.toString()).indexOf(r.UID.toString()) >= 0;
		Ext.each(r.children, me.prepareData, me);
	},
	buildTree: function () {
		let me = this;
		Ext.each(me.data, me.prepareData, me);
		return me.data;
	},

	getSelected: function () {
		let me = this,
			res = [];
		if (me.multiSelect) {
			res = this.treePanel.getChecked();
		} else {
			let node = this.treePanel.getFrstSelect();
			if (!node) return null;
			res = [node];
		}
		
		if (me.formatName) {
			res.forEach(row => {
				if (row.data.NAME.indexOf('<font') > 0)
					row.data.NAME = row.data.NAME.substring(0, row.data.NAME.indexOf('<font'));
			});
		}
		return res;
	},

	// getChecked: function () {
	// 	return this.treePanel.store.getDataExt().filter(r => r.checked);
	// },
	checkAll: function (checked) {
		this.treePanel.getRootNode().cascade(function (node) {
			if (node.data.checked != null) node.set('checked', checked);
		});
	}
})
;