﻿Ext.define('Keysystems.UsersAdm.List', {
    extend: 'Keysystems.Base.List',
    
    multiSelectGridVisible: false,
    hidePagging: true,
    ignoreLoadNextPrevPages: true,
    profileLinkCode: 'UsersAdm',

    initConfig: function(cfg) {
        let me = this;
        
        me.callParent(arguments);
        
        me.functions.edit = function(editCfg) {
            let tab = editCfg.f !== 'copy' && editCfg.data ? window.tabView.items.items.filter(tab => 
                tab.code === me.code && tab.tabLink === editCfg.data.data.UID)[0]
                : _;
            if (tab) {
                tab.show();
            } else {
                Ext.create(me.editClass, editCfg);
            }
        };
    },
    viewCfg: function() {
        let me = this,
            res = me.callParent(arguments);
        
        delete res.dict;
        res.tabID = 'PLT_USERS_ADM';
        
        return res;
    },
    createTBar: function() {
        let me = this,
            res = me.callParent(arguments);

        if (me.viewMode === 'viewShow') {
            for (var btn in me.objs.tbarBtns) {
                if (['mark_plt', 'unmark_plt', 'refresh_plt'].indexOf(me.objs.tbarBtns[btn].code) === -1) {
                    me.objs.tbarBtns[btn].setHidden(true);
                }
            }
        }

        return res;
    },

    createItems() {
        let me = this,
            res = me.callParent(arguments);

        res.push(me.sksc('infoBlockPanel', Ext.create('Ext.panel.Panel',
            {
                hidden: true,
                title: 'Протокол сохранения',
                items: [
                ]
            })));

        return res;
    },

    baseGetData: function(endFunc, params) {
        let me = this;

        if (!params) {
            params = {};
        }
        params.docCode = me.docCode || '';

        me.callParent(arguments);
    },    
    getRowClass: function(record) {
        return record.data.UID < 0
            ? 'ks-gray'
            : record.data.HIGHLIGHT === 13421823 
                ? 'ks-saSignUser' 
                : record.data.HIGHLIGHT === 13162741
                    ? 'ks-blockUser'
                    : record.data.HIGHLIGHT === 15531200
                        ? 'ks-saUser'
                        : '';
    },
    batchCreation: function() {
        let me = this;
        
        Ext.create('Keysystems.BatchUserCreation', {
            code: me.linkCode,
            afterSuccessSave: function() {
                me.refresh();
            }
        }).show();
    },
    ajaxFunc: function(cfg) {
        let me = this,
            checkRecs = me.checkList,
            recs = checkRecs.length ? checkRecs : me.objs.Grid.getSelectionModel().getSelection(),
            len = recs.length;

        if (!len) return;
        
        let links = recs.map(r => r.UID || r.data.UID),
            posLinks = links.filter(l => l > 0),
            params = {links: JSON.stringify(posLinks)};
        
        if (cfg.params) {
            Ext.apply(params, cfg.params);
        }
        
        let func = () => me.showLoadMask({
            msg: cfg.msg,
            rid: ajaxRequest({
                params,
                url: dictListController.DICTIONARY_USERS_ADM.linkCode + cfg.url,
                success: function(res) {
                    if (res.ErrorMsg) {
                        window.failureShow({
                            statusText: res.ErrorMsg,
                            messageText: cfg.errorText
                        }, "Внимание");
                        return;
                    }

                    if (res.html) {
                        showDetailEventsLog({
                            html: res.html,
                            modal: true,
                            title: '',
                            fullTitle: cfg.title ? cfg.title : cfg.msg
                        });
                    }

                    if (!cfg.skipRefresh) {
                        me.refresh();
                    }
                },
                failure: function() {
                    showError(cfg.errorText + '!');
                },
                callback: function() {
                    me.hideLoadMask();
                }
            })
        });

        if (!cfg.skipCheck) {
            if (!posLinks.length) {
                info(links.length === 1 ? 'Для выполнения данной операции необходимо предварительно сохранить документ.'
                    : 'Для выполнения данной операции необходимо предварительно сохранить документы.');
                return false;
            }

            if (posLinks.length != links.length) {
                let num = links.filter(l => l < 0).length,
                    message = `Среди выбранных документов есть ${num} документ${num === 1 ? '' : 'а'}, которы${num == 1 ? 'й' : 'е'} не был${num == 1 ? '' : 'и'} сохранен${num == 1 ? '' : 'ы'}.\r\nОперация \"${cfg.msg}\" не будет к ${num == 1 ? 'нему' : 'ним'} применена.`

                warning(message, func);
                return false;
            }
        }
        
        func();
    },
    restoreUser: function() {
        let me = this;
        
        me.ajaxFunc({
            msg: 'Восстановление пользователей',
            url: '/RestoreUsers_A',
            errorText: 'Ошибка при восстановлении пользователей'
        });
    },
    batchReplacement: function(param) {
        let me = this,
            checkRecs = me.checkList,
            recs = checkRecs.length ? checkRecs : me.objs.Grid.getSelectionModel().getSelection(),
            len = recs.length,
            visible = param && param.visible ? param.visible : '',
            objCode = param && param.ObjCode ? param.ObjCode : '',
            fieldsObjCode = param && param.FieldsObjCode ? param.FieldsObjCode : '';

        if (!len) {
            info('Выберите записи');
            return;
        }

        me.showLoadMask({
            msg: 'Получение данных',
            rid: ajaxRequest({
                params: { 
                    data: JSON.stringify({
                        links: JSON.stringify(recs.map(r => r.UID || r.data.UID)),
                        visible,
                        objCode,
                        fieldsObjCode
                    })
                },
                url: me.linkCode + '/GetDataForBatchReplacement_A',
                success: function(res) {
                    if (res.ErrorMsg) {
                        window.failureShow({
                            statusText: res.ErrorMsg,
                            messageText: 'Ошибка при получении данных'
                        }, "Внимание");
                        return;
                    }
                    
                    Ext.create('Keysystems.Platform.BatchUserCreation', {
                        title: res.caption,
                        userLinks: JSON.stringify(recs.map(r => r.LINK || r.data.LINK)),
                        operationValues: res.operationValues,
                        disableControls: res.disableControls,
                        fillControls: res.fillControls,
                        comboValues: res.comboValues,
                        chbControls: res.chbControls,
                        dictCode: res.dictCode,
                        modelData: {
                            links: JSON.stringify(recs.map(r => r.UID || r.data.UID)),
                            visible,
                            objCode,
                            fieldsObjCode
                        },
                        linkCode: me.linkCode,
                        parentView: me
                    }).show();
                },
                failure: function() {
                    showError('Ошибка при получении данных!');
                },
                callback: function() {
                    me.hideLoadMask();
                }
            })
        });
    },
    lockUser: function() {
        let me = this;

        me.ajaxFunc({
            msg: 'Блокирование пользователей',
            url: '/LockUsers_A',
            errorText: 'Ошибка при блокировании пользователей',
            params: {
                type: 'S',
                mode: 'set'
            }
        });
    },
    unlockUser: function() {
        let me = this;
        
        me.ajaxFunc({
            msg: 'Разблокирование пользователей',
            url: '/LockUsers_A',
            errorText: 'Ошибка при разблокировании пользователей',
            params: {
                type: 'S',
                mode: 'reset'
            }
        });
    },
    lockLogin: function() {
        let me = this;

        me.ajaxFunc({
            msg: 'Блокирование логинов',
            url: '/LockLogins_A',
            errorText: 'Ошибка при блокировании логинов',
            params: {
                mode: 'set'
            }
        });
    },
    unlockLogin: function() {
        let me = this;

        me.ajaxFunc({
            msg: 'Разблокирование логинов',
            url: '/LockLogins_A',
            errorText: 'Ошибка при разблокировании логинов',
            params: {
                mode: 'reset'
            }
        });
    },
    delete: function(param) {
        let me = this,
            checkRecs = me.checkList,
            recs = checkRecs.length ? checkRecs : me.objs.Grid.getSelectionModel().getSelection(),
            len = recs.length,
            delMode = param && param.X_DELMODE ? param.X_DELMODE : '';
        
        if (!len) return;

        selectDialogShow(wmc.getQuestion('Delete'),
            wmc.get('DeleteMessage', len),
            function() {
                let links = recs.map(r => r.UID || r.data.UID);

                me.ridDel = ajaxRequest({
                    params: {
                        links,
                        reason: null,
                        guid: null,
                        delMode
                    },
                    url: me.linkCode + '/DeleteDocument_A',
                    success: function(value) {
                        if (value.ErrorMsg) {
                            me.hideLoadMask();
                            window.failureShow({
                                statusText: value.ErrorMsg,
                                messageText: "Ошибка при удалении."
                            }, "Внимание");
                            return;
                        }
                        
                        // Запрос причины удаления
                        if (value.rid) {
                            Ext.create('Keysystems.Comment',
                                {
                                    title: 'Введите причину удаления',
                                    initText: '',
                                    labelWidth: 0,
                                    okFn: function() {
                                        var reason = this.textArea.getValue();
                                        
                                        me.ridDel = ajaxRequest({
                                            params: {
                                                links,
                                                reason,
                                                guid: value.rid,
                                                delMode
                                            },
                                            url: me.linkCode + '/DeleteDocument_A',
                                            success: function(val) {
                                                if (val.ErrorMsg) {
                                                    me.hideLoadMask();
                                                    window.failureShow({
                                                        statusText: val.ErrorMsg,
                                                        messageText: "Ошибка при удалении."
                                                    }, "Внимание");
                                                    return;
                                                }

                                                if (html.length) {
                                                    showDetailEventsLog({
                                                        html: value.html,
                                                        modal: true,
                                                        title: '',
                                                        fullTitle: 'Удаление данных'
                                                    });
                                                }

                                                me.hideLoadMask();
                                                me.checkList = [];
                                                me.refresh();
                                            },
                                            callback: function() {
                                                delete me.ridDel;
                                            }
                                        });

                                        me.showLoadMask({
                                            msg: wmc.getMask('Deleting'),
                                            rid: me.ridDel,
                                            cancelFn: function() {
                                                me.stopDel = true;
                                                if (me.ridDel) SignalR.delCallBack(me.ridDel);
                                            }
                                        });
                                    },
                                    cancelFn: function() {
                                        ajaxRequest({
                                            params: {
                                                guid: value.rid
                                            },
                                            url: me.linkCode + '/FinalizeDeleting_A',
                                            success: function(val) {
                                                me.hideLoadMask();
                                                if (val.ErrorMsg) {
                                                    showError(val.ErrorMsg);
                                                }
                                            }
                                        });
                                    }
                                }).show();

                            me.hideLoadMask();
                        } else {
                            if (value.html.length) {
                                showDetailEventsLog({
                                    html: value.html,
                                    modal: true,
                                    title: '',
                                    fullTitle: 'Удаление данных'
                                });                                
                            }

                            me.hideLoadMask();
                            me.checkList = [];
                            me.refresh();
                        }
                    },
                    callback: function() {
                        delete me.ridDel;
                    },
                    progress: function(response) {
                        me.loadMask.setMsg(response);
                    }
                });

                me.showLoadMask({
                    msg: 'Подготовка к удалению данных',
                    rid: me.ridDel,
                    cancelFn: function() {
                        me.stopDel = true;
                        if (me.ridDel) SignalR.delCallBack(me.ridDel);
                    }
                });
            });
    },
    printUsers: function(param) {
        let me = this,
            sels = me.objs.Grid.getSelectionModel().getSelection(),
            mode = param && param.mode ? param.mode : '';

        if (!mode.length) {
            me.ajaxFunc({
                msg: 'Печать пользователей',
                url: '/PrintUsers_A',
                errorText: 'Ошибка при печати пользователей'
            });
            
            return;
        }

        if (!sels.length) {
            info('Выберите пользователя');
            return;
        }
        
        me.ajaxFunc({
            msg: 'Печать пользователей',
            url: '/PrintUser_A',
            errorText: 'Ошибка при печати пользователей',
            title: 'Печать',
            skipCheck: true,
            skipRefresh: true,
            params: {
                links: null,
                link: sels[0].data.UID,
                mode
            }
        });
    },
    exportUsers: function(param) {
        let me = this,
            mode = param && param.Mode ? param.Mode : '',
            checkRecs = me.checkList,
            recs = checkRecs.length ? checkRecs : me.objs.Grid.getSelectionModel().getSelection(),
            len = recs.length;

        if (!len) return;
        
        let links = JSON.stringify(recs.map(r => r.LINK || r.data.LINK)),
            id = UploaderLib.getNextId(),
            templateCode = '',
            func = () => me.showLoadMask({
                msg: 'Выгрузка пользователей',
                rid: ajaxRequest({
                    params: {
                        data: JSON.stringify({
                            links,
                            mode,
                            templateCode,
                            id
                        })
                    },
                    url: me.linkCode + '/ExportUsers_A',
                    success: function (res) {
                        if (res.ErrorMsg) {
                            window.failureShow({
                                statusText: res.ErrorMsg,
                                messageText: 'Ошибка при выгрузке пользователей'
                            }, "Внимание");
                            return;
                        }

                        UploaderLib.getFileAndFree(id, res.fileName);
                        info('Выгрузка пользователей выполнена успешно!');
                    },
                    failure: function () {
                        showError('Ошибка при выгрузке пользователей!');
                    },
                    callback: function () {
                        me.hideLoadMask();
                    }
                })
            });

        if (mode === 'user') {
            dictFunc({
                    parentView: me.objs.view,
                    code: dnl.USERS_TEMPLATE_ADM,
                    mode: 'SINGL'
                },
                {
                    ok: function (value) {
                        if (!value.length) return;

                        templateCode = value[0].data.CODE;

                        func();
                    }
                });
        } else {
            func();
        }
    },
    showEventLogList: function() {
        let me = this,
            sels = me.objs.Grid.getSelectionModel().getSelection();

        if (!sels.length) {
            info('Выберите пользователя');
            return;
        }

        me.ajaxFunc({
            msg: 'Журнал событий',
            url: '/GetUserLog_A',
            errorText: 'Ошибка при получении журнала событий',
            skipCheck: true,
            skipRefresh: true,
            params: {
                links: null,
                link: sels[0].data.UID
            }
        });
    },
    userAccess: function() {
        let me = this,
            sels = me.objs.Grid.getSelectionModel().getSelection();

        if (!sels.length) {
            info('Выберите пользователя');
            return;
        }
        
        ObjAccess.show('', '', sels[0].data.UID);
    },
    userArm: function() {
        // Кнопка тулбара "АРМ навигатора" скрыта, в виду отсутствия необходимости в ней.
    },
    refresh: function(reload, hideMsg) {
        let me = this;

        me.showLoadMask({
            msg: KS.L10n.updating_data,
            rid: me.ridGet = ajaxRequest({
                url: me.linkCode + '/Get_A',
                params: {
                    gzipData: SignalR.pack({
                        docCode: me.docCode,
                        reload: true
                    })
                },
                success: function (data) {
                    me.objs.Grid.store.loadData(data.data.data);
                    me.dataCount = data.data.total;
                    me.setChecks(me.checkList,  me.objs.Grid.store.getData().items);
                    if (!me.Grid.selModel.getSelected().length) {
                        me.Grid.extraSelectFrst();
                    }
                    me.hideLoadMask();
                },
                failure: function (response) {
                    console.error(response);
                    me.loadMask.setErrorState();
                },
                callback: function () {
                    delete me.ridGet;
                }
            }),
            cancelFn: function () {
                if (me.ridGet) SignalR.delCallBack(me.ridGet);
            }
        });
        
    }
});

Ext.define('Keysystems.Platform.BatchUserCreation',
{
    extend: 'Ext.window.Window',
    bodyPadding: 5,
    modal: true,
    layout: {type: 'vbox', align: 'stretch'},
    labelWidth: 150,
    iconCls: 'x_btn_new',
    minWidth: 400,
    minHeight: 440,
    
    changeAccess: function(value) {
        let me = this,
            data = me.disableControls[value],
            controls = me.items.items.filter(i => i.platformCode === data.name),
            fn = (control) => {
                if (Object.keys(me.chbControls).indexOf(control.platformCode) === -1) {
                    control.setDisabled(false)
                }
                
                if (control.ksAllowEmpty) {
                    control.changeKsAllowEmpty();
                }
                
                if (me.fillControls[value].indexOf(control.platformCode) !== -1) {
                    control.changeKsAllowEmpty();
                }
            };
        
        Ext.each(me.items.items, c => {
            if (c.items) {
                Ext.each(c.items.items, i => {
                    fn(i);
                });
            }
            
            fn(c);
        });
        
        if (controls.length) {
            controls[0].setDisabled(true);
            if (data.clearMode === '1') {
                Ext.each(controls[0].items.items, c => c.setValue());
            }
        }
    },    
    initComponent: function() {
        let me = this;

        me.items = [
            me.cbProp = Ext.create('Ext.form.field.ComboBox', {
                fieldLabel: 'Реквизит',
                labelWidth: me.labelWidth,
                editable: false,
                value: 0,
                queryMode: 'local',
                store: Ext.create('Ext.data.Store', {
                    fields: CBDataLib.getFields(),
                    data: CBDataLib.get('', false, me.comboValues),
                    proxy: 'memory'
                }),
                value: Object.keys(me.comboValues)[0],
                displayField: CBDataLib.displayField,
                valueField: CBDataLib.valueField,
                width: 200,
                maxHeight: 22,
                platformCode: 'DOC_BATCH_REPLACE_FIELD',
                listeners: {
                    change: function(th, val) {
                        //todo: дописать метод, если появится больше одного реквизита
                    }
                }
            }),
            Ext.create('Ext.form.FieldSet', {
                title: 'Найти',
                bodyPadding: 5,
                platformCode: 'DOC_BATCH_REPLACE_PANEL_OLD',
                items: [
                    me.chbFind = Ext.create('Ext.form.field.Checkbox', {
                        hideLabel: true,
                        boxLabel: 'Произвольное значение',
                        platformCode: 'DOC_BATCH_REPLACE_IGNORE_OLD',
                        value: me.chbControls['DOC_BATCH_REPLACE_IGNORE_OLD'].checked,
                        disabled: me.chbControls['DOC_BATCH_REPLACE_IGNORE_OLD'].disabled
                    }),
                    me.dictFind = Ext.create('Keysystems.Controls.DictName.Edit', {
                        code: me.dictCode,
                        platformCode: 'DOC_BATCH_REPLACE_OLD_VALUE',
                        fieldLink: 'ID',
                        nameField: 'PROGNAME',
                        labelWidth: me.labelWidth,
                        fieldLabel: 'Найти',
                        hideLabel: true,
                        handler: function() {
                            dictFunc({
                                    parentView: me,
                                    code: me.dictCode,
                                    mode: 'MULTI',
                                    selectLinks: me.dictFind.getValue(),
                                    fieldLink: 'ID',
                                    control: me.dictFind,
                                    contextSearch: me.dictFind.contextSearch
                                },
                                {
                                    ok: function(value) {
                                        me.dictFind.setValue(value);
                                    }
                                },
                                function(form) {
                                    if (me.dictFind.contextSearch) {
                                        let field = me.dictFind.fieldCode || me.dictFind.fieldName || me.dictFind,
                                            oldValue = me.dictFind.fieldCode || me.dictFind.fieldName
                                                ? me.dictFind.getOldContextValue(me.dictFind.fieldCode ? me.dictFind.codeField : me.dictFind.nameField)
                                                : me.dictFind.originalValue;

                                        field.setValue(oldValue);
                                    }
                                }
                            );
                        }
                    })
                ]}),
            me.cbOperation = Ext.create('Ext.form.field.ComboBox', {
                fieldLabel: 'Операция',
                labelWidth: me.labelWidth,
                value: 0,
                queryMode: 'local',
                store: Ext.create('Ext.data.Store', {
                    fields: CBDataLib.getFields(),
                    data: CBDataLib.get('', false, me.operationValues),
                    proxy: 'memory'
                }),
                value: Object.keys(me.operationValues)[0],
                displayField: CBDataLib.displayField,
                valueField: CBDataLib.valueField,
                width: 200,
                maxHeight: 22,
                platformCode: 'DOC_BATCH_REPLACE_OPERTYPE',
                listeners: {
                    change: function(th, val) {
                        me.changeAccess(val);
                    }
                }
            }),
            Ext.create('Ext.form.FieldSet', {
                title: 'Новое значение',
                bodyPadding: 5,
                platformCode: 'DOC_BATCH_REPLACE_PANEL_NEW',
                items: [
                    me.chbFree = Ext.create('Ext.form.field.Checkbox', {
                        hideLabel: true,
                        boxLabel: 'Пустое значение',
                        platformCode: 'DOC_BATCH_REPLACE_DROP_VALUE',
                        value: me.chbControls['DOC_BATCH_REPLACE_DROP_VALUE'].checked,
                        disabled: me.chbControls['DOC_BATCH_REPLACE_DROP_VALUE'].disabled
                    }),
                    me.dictNewValue = Ext.create('Keysystems.Controls.DictName.Edit', {
                        code: me.dictCode,
                        platformCode: 'DOC_BATCH_REPLACE_NEW_VALUE',
                        fieldLink: 'ID',
                        nameField: 'PROGNAME',
                        labelWidth: me.labelWidth,
                        fieldLabel: 'Заменить на',
                        hideLabel: true,
                        handler: function() {
                            dictFunc({
                                    parentView: me,
                                    code: me.dictCode,
                                    mode: 'MULTI',
                                    selectLinks: me.dictNewValue.getValue(),
                                    fieldLink: 'ID',
                                    control: me.dictNewValue,
                                    contextSearch: me.dictNewValue.contextSearch
                                },
                                {
                                    ok: function(value) {
                                        me.dictNewValue.setValue(value);
                                    }
                                },
                                function(form) {
                                    if (me.dictNewValue.contextSearch) {
                                        let field = me.dictNewValue.fieldCode || me.dictNewValue.fieldName || me.dictNewValue,
                                            oldValue = me.dictNewValue.fieldCode || me.dictNewValue.fieldName
                                                ? me.dictNewValue.getOldContextValue(me.dictNewValue.fieldCode ? me.dictNewValue.codeField : me.dictNewValue.nameField)
                                                : me.dictNewValue.originalValue;

                                        field.setValue(oldValue);
                                    }
                                }
                            );
                        }
                    })
                ]}),
            Ext.create('Ext.form.Label', {
                text: 'Комментарий для журнала событий:',
                platformCode: ''
            }),
            me.comment = Ext.create('Ext.form.field.TextArea', {
                flex: 1,
                platformCode: 'DOC_BATCH_REPLACE_COMMENT'
            })
        ];
        
        me.tbar = [
            Ext.create('Ext.Button', {
                iconCls: 'x_btn_form_doc',
                tooltip: 'Выполнить',
                tooltipType: 'title',
                handler: function() {
                    me.batchFn();
                }
            })
        ];
        
        me.callParent(arguments);
    },
    listeners: {
        beforeshow: function() {
            this.changeAccess(this.cbOperation.getValue());
        }
    },
    isFilled: function() {
        let me = this,
            checkControls = me.fillControls[me.cbOperation.getValue()],
            res = true,
            fn = (control) => {
                if (checkControls.indexOf(control.platformCode) !== -1 
                    && control.getValue && control.getValue().hasOwnProperty('length') && !control.getValue().length) {
                    info(wmc.get('Input', control.fieldLabel), function() { 
                        (control.fieldName ? control.fieldName : control).focus(); 
                    });
                    res = false;
                }
            };
        
        Ext.each(me.items.items, control => {
            fn(control);
            
           if (control.items) {
               Ext.each(control.items.items, c => {
                  fn(c);
               });
           } 
        });
        
        return res;
    },
    dataCollector: function() {
        let me = this,
            data = {},
            dictOldVal = me.dictFind.getValue(),
            dictNewVal = me.dictNewValue.getValue(),
            oldVal = [],
            newVal = [];

        data.object = me.cbProp.getValue();
        data.field = me.cbProp.getRawValue();
        data.ignoreOld = me.chbFind.getValue();
        Ext.each(dictOldVal, val => oldVal.push({
            LINK: val.data.ID,
            NAME: val.data.PROGNAME
        }));
        data.oldVal = oldVal;
        data.opertype = me.cbOperation.getValue();
        data.dropValue = me.chbFree.getValue();
        Ext.each(dictNewVal, val => newVal.push({
            LINK: val.data.ID,
            NAME: val.data.PROGNAME
        }));
        data.newVal = newVal;
        data.note = me.comment.getValue();
        data.userLinks = me.userLinks;
        
        return data;
    },
    batchFn: function() {
        let me = this,
            text = 'контроле',
            successFunc = (data) => {
                if (data.successMsg) {
                    showDetailEventsLog({
                        html: data.successMsg,
                        modal: true,
                        title: '',
                        fullTitle: 'Протокол сохранения'
                    });
                }

                me.comment.setValue();
                text = 'контроле';
                me.parentView.checkList = [];
                me.parentView.refresh();
            };
        
        if (!me.isFilled()) {
            return;
        }

        const loadMask = new Ext.LoadMask({
            msg: 'Контроль данных',
            target: me,
            autoShow: true,
            rid: ajaxRequest({
                params: {
                    data: JSON.stringify({
                        modelData: me.modelData,
                        data: me.dataCollector()
                    })
                },
                url: me.linkCode + '/BatchReplacement_A',
                success: function(res) {
                    loadMask.destroy();
                    
                    if (res.ErrorMsg) {
                        window.failureShow({
                            statusText: res.ErrorMsg,
                            messageText: `Ошибка при ${text} данных`
                        }, "Внимание");
                        return;
                    }
                    
                    if (res.blockMsg) {
                        showDetailEventsLog({
                            html: res.blockMsg,
                            modal: true,
                            title: '',
                            fullTitle: 'Протокол контроля'
                        });
                        
                        return;
                    }
                    
                    if (res.partlyBlockMsg) {
                        showDetailEventsLog({
                            html: res.partlyBlockMsg,
                            modal: true,
                            title: '',
                            fullTitle: 'Протокол контроля',
                            continueFn: function() {
                                const loadMaskRe = new Ext.LoadMask({
                                    msg: 'Сохранение данных',
                                    target: me,
                                    autoShow: true,
                                    rid: ajaxRequest({
                                        url: me.linkCode + '/BatchReplacement_A',
                                        params: {
                                            data: JSON.stringify({
                                                modelData: me.modelData,
                                                data: me.dataCollector(),
                                                continueSave: true
                                            })
                                        },
                                        success: function(result) {
                                            loadMaskRe.destroy();
                                            
                                            if (result.ErrorMsg) {
                                                window.failureShow({
                                                    statusText: result.ErrorMsg,
                                                    messageText: 'Ошибка при сохранении данных'
                                                }, "Внимание");
                                                
                                                return;
                                            }

                                            successFunc(result);
                                        },
                                        failure: function(val) {
                                            loadMask.destroy();
                                            showError('Ошибка при сохранении данных!');
                                        }
                                    })
                                });

                            }
                        });
                        
                        return;
                    }

                    successFunc(res);
                },
                failure: function() {
                    loadMask.destroy();
                    showError(`Ошибка при ${text} данных!`);
                },
                progress: function(response) {
                    loadMask.setMsg(response);
                    text = 'сохранении';
                }                
            })
        });
    }
});