Ext.define('Keysystems.UsersAdm.Edit', {
    extend: 'Keysystems.Base.Edit',

    hideControlBtn: true,
    ignoreCheckStamp: true,
    
    getViewTitle: function() {
        let me = this;

        return dictListController.DICTIONARY_USERS_ADM.title + ': ' + (me.data ? me.data.data ? me.data.data.NAME : me.data.NAME : '_');
    },
    viewCfg: function() {
        let me = this,
            res = me.callParent(arguments);
        
        me.objs.viewCfg.tabLink = me.f !== 'copy' && me.data ? me.data.data.UID : -1;
        
        return res;
    },
    loadNewData: function() {
        let me = this;
        this.setLink(-1);
    },
    loadNewCopyData: function() { this.setLink(-1); },
    loadCopyEditData: function() {
        let me = this;

        me.setLink(me.data.data.UID);
    },
    isDiffPswrds: function() {
        let me = this,
            valP = me.gksc('P').getValue(),
            valCP = me.gksc('confirmP').getValue();
        
        return valP.length && valCP.length && valP !== valCP;
    },
    createTBar: function() {
        let me = this,
            objs = me.objs,
            res = me.callParent(arguments),
            saveBtn = res.splice(0, 1);
        
        res.unshift(me.sksc('saveBtn', objs.saveBtn = Ext.create('Ext.button.Split', {
            tooltip: 'Сохранить',
            tooltipType: 'title',
            iconCls: 'x_btn_save',
            menu: [
                {
                    text: 'Сохранить',
                    iconCls: 'x_btn_save',
                    handler: saveBtn[0].handler
                },
                {
                    iconCls: 'x_btn_save_and_close',
                    text: 'Выполнить',
                    handler: function() {
                        me.needClose = true;
                        saveBtn[0].handler.call(this, arguments);
                    }
                }
            ],
            handler: saveBtn[0].handler
        })));
        
        return res;
    },
    addGridRecord: function(gridName, cfg, linkField = 'LINK') {
        let me = this,
            grid = me.gksc(gridName),
            sel = [],
            itms = grid.store.data.items,
            len = itms.length,
            i = 0,
            settings = {
                parentView: me.objs.view,
                controlName: gridName + 'Add',
                selectLinks: sel,
                fieldLink: linkField
            };

        Ext.apply(settings, cfg);
    
        for (; i < len; i++) {
            let rec = { data: {} };
            rec.data[linkField] = itms[i].data[linkField];
            sel.push(rec);
        }
        
        dictFunc(settings, {
            ok: function(value) {
                let j = 0,
                    store = grid.store;

                for (len = value.length; j < len; j++) {
                    if (ArrayLib.find(itms, ['data', linkField], value[j].data[linkField]) === -1) {
                        let newRec = store.add({})[0];

                        newRec.beginEdit();
                        Ext.each(Object.keys(newRec.data), field => {
                            if (['CHECKED', 'id'].indexOf(field) === -1 && value[j].data.hasOwnProperty(field)) {
                                newRec.data[field] = value[j].data[field];
                            }
                        });
                        newRec.endEdit();
                    }
                }

                let dels = [];
                for (j = 0, len = itms.length; j < len; j++) {
                    if (ArrayLib.find(value, ['data', linkField], itms[j].data[linkField]) === -1) {
                        dels.push(itms[j]);
                    }
                }

                store.remove(dels);

                if (!grid.getSelectionModel().getSelection().length) {
                    grid.extraSelectFrst();
                }
            }
        });
    },
    removeGridRecord: function(grid) {
        let me = this,
            store = grid.getStore(),
            selModel = grid.getSelectionModel(),
            sel = selModel.getSelection(),
            checkRecs = store.data.items.filter(d => d.data.CHECKED),
            recs = checkRecs.length ? checkRecs : selModel.getSelection();

        if (recs.length) {
            let index = store.indexOf(sel[0]);
            store.remove(recs);
            selModel.selectByPosition({
                row: store.data.length > index ? index : store.data.length - 1
            });
        }
    },
    checkInversion: function(grid, value) {
        grid.store.each(function(rec) { rec.set('CHECKED', value !== _ ? value : !rec.get('CHECKED')); });
    },
    checkFstToSel: function(grid, reverse) {
        let me = this,
            sel = grid.getSelectionModel().getSelection();
        
        if (sel.length) {
            Ext.each(grid.store.data.items, function(rec) {
                if (!sel.length) return false;
                rec.set('CHECKED', true);
                ArrayLib.remove(sel, rec);
                return true;
            }, _, reverse);
        } else {
            me.checkInversion(grid, true);
        }
    },
    checkCheckToCheck: function(grid) {
        let me = this,
            store = grid.getStore(),
            frst = false,
            last = false;

        store.each(function(rec) {
            if (rec.get('CHECKED')) {
                if (!frst) frst = rec;
                last = rec;
            }
        });

        if (frst) {
            let start = store.indexOf(frst),
                end = store.indexOf(last);

            Ext.each(store.getRange(start, end), function(rec) { rec.set('CHECKED', true); });
        }
    },
    searchAndReplace: function(grid) {
        let me = this;

        Ext.create('Revizor.BatchChange',
            {
                title: `Поиск и замена (${grid.batchProps[0].CaptionText}): Все записи`,
                parentView: me.parentView,
                code: '',
                isPlatform: true,
                generateElements: function() {
                    let th = this,
                        cfg = {
                            DataType: 'String',
                            AllowDBNull: true,
                            AllowedConditions: ['0', '1']
                    };
                    th.batchProps = [];
                    
                    Ext.each(grid.batchProps, prop => th.batchProps.push(Ext.apply(prop, cfg)));

                    th.createItems();
                    th.cmbPropReplace.setValue(th.batchProps[0].Name);
                },
                controlChange: Ext.emptyFn,
                createTypedControls: function(prop) {
                    let th = this;
                    
                    th.callParent(arguments);

                    let cbCondition = th.gksc('FROM_VALUE_' + prop.Name).cbCondition;
                    cbCondition && cbCondition.setHidden(true);
                    th.gksc('FREE_VALUE_' + prop.Name).setValue(true);
                },
                genControlByElement: function(el) {
                    let propertyValues = JSON.parse(el.PropertyValues),
                        cfg = dictListController[propertyValues.Code];
                    
                    switch (miscTypes.ControlType[el.ControlType]) {
                        case 'Dictionary':
                            let dictEdit = Ext.create('Keysystems.Controls.DictName.Edit', {
                                clear: function () {
                                    dictEdit.change && dictEdit.change();
                                },
                                code: propertyValues.Code,
                                mode: el.mode ? el.mode : propertyValues.Action === 2 ? 'MULTI' : 'SINGL',
                                handler: function() {
                                    let cfg = {
                                        code: propertyValues.Code,
                                        mode: dictEdit.mode,
                                        checkList: dictEdit.getValue().slice(),
                                        parentView: me,
                                        controlName: el.Name,
                                        control: dictEdit,
                                        contextSearch: dictEdit.contextSearch,
                                    };
                                    
                                    Ext.apply(cfg, el.cfg);
                                    
                                    dictFunc(cfg, {
                                        ok: function (v) {
                                            dictEdit.setValue(v);
                                            dictEdit.change && dictEdit.change(dictEdit.getValue());
                                        }
                                    }, function(form) {
                                        if (dictEdit.contextSearch) {
                                            let field = dictEdit.fieldCode || dictEdit.fieldName || dictEdit,
                                                oldValue = dictEdit.fieldCode || dictEdit.fieldName
                                                    ? dictEdit.getOldContextValue(dictEdit.fieldCode ? dictEdit.codeField : dictEdit.nameField)
                                                    : dictEdit.originalValue;

                                            field.setValue(oldValue);
                                        }
                                    });
                                }
                            });
                    
                            return dictEdit;
                            break;
                        default:
                            return this.callParent(arguments);
                            break;
                    }
                },
                submit: function() {
                    let th = this,
                        propName = th.cmbPropReplace.getValue(),
                        prop = th.batchProps.filter(p => p.Name === propName)[0],
                        records = grid.store.data.items,
                        filterRecs = [],
                        linkField = prop.linkField ?? 'LINK';
                    
                    if (!propName || !prop) {
                        info(wmc.get('EmptyBatchProp'));
                        return false;
                    }

                    let freeValueEl = th.gksc('FREE_VALUE_' + propName),
                        fromEmptyEl = th.gksc('FROM_EMPTY_VALUE_' + propName),
                        fromValueEl = th.gksc('FROM_VALUE_' + propName),
                        filterVal = fromValueEl.getValue(),
                        emptyValueEl = th.gksc('TO_EMPTY_VALUE_' + propName),
                        toValueEl = th.gksc('TO_VALUE_' + propName),
                        newVal = toValueEl.getValue();
                    
                    // Найти: произвольное значение
                    if (freeValueEl.getValue()) {
                        filterRecs = records;
                    }
                    
                    // Найти: пустое значение
                    if (fromEmptyEl.getValue()) {
                        filterRecs = records.filter(r => !r.get(propName.toUpperCase()).length);
                    }
                    
                    // Найти: фильтр по значениям
                    if (filterVal.length) {
                        if (prop.ControlType === 6) {
                            let lst = [];
                            Ext.each(filterVal, v => lst.push(v.get(linkField)));
                            filterRecs = records.filter(r => lst.indexOf(r.get(linkField)) !== -1);
                        } else if (prop.ControlType === 5) {
                            filterRecs = records.filter(r => r.get(propName.toUpperCase()) === filterVal);
                        }
                    }
                    
                    if (!filterRecs.length) {
                        th.close();
                        return;
                    }
                    
                    if (newVal.length) {
                        if (prop.AllowEmptyStartValue) {
                            Ext.each(filterRecs, r => {
                                r.beginEdit();
                                r.set(propName.toUpperCase(), newVal);
                                r.endEdit();
                            })
                        } else {
                            // удалим отфильтрованные записи, т.к. не может быть несколько записей с одним и тем же значением
                            grid.store.remove(filterRecs);
                            // добавим одну запись
                            let newRec = grid.store.add({})[0];

                            newRec.beginEdit();
                            for (var field in newRec.data) {
                                if (field !== 'id') {
                                    newRec.set(field, newVal[0].get(field));
                                }
                            }
                            newRec.endEdit();
                        }
                    } else {
                        // Заменить на: пустое значение
                        if (prop.AllowEmptyStartValue) {
                            Ext.each(filterRecs, r => {
                                r.beginEdit();
                                r.set(propName.toUpperCase(), '');
                                r.endEdit();
                            })
                        } else {
                            // если не допустимы пустые значения, просто удаляем из грида записи,
                            // так как они теперь с пустым значением
                            grid.store.remove(filterRecs);
                        }
                    }
                    
                    th.close();
                }
            }).show();
    },
    panelSetValue: function() {
        let me = this,
            grid = me.items.items[0];

        grid.store.remove(grid.store.data.items);
    },
    createItems: function(items) {
        let me = this,
            objs = me.objs;

        return me.objs.items = [
            me.sksc('NAME', Ext.create('Ext.form.field.Text', {
                labelWidth: me.labelWidth,
                fieldLabel: 'Имя пользователя',
                ksAllowEmpty: true,
                msgTarget: 'side',
                allowBlank: false,
                maxLength: 128,
                maxWidth: 350,
                platformCode: 'name'
            })),
            me.sksc('NOTE', Ext.create('Ext.form.field.Text', {
                labelWidth: me.labelWidth,
                fieldLabel: 'Примечание',
                maxLength: 250,
                platformCode: 'note_id'
            })),
            Ext.create('Ext.form.FieldContainer', {
                layout: {type: 'hbox', align: 'stretch'},
                items: [
                    Ext.create('Ext.form.FieldSet', {
                        title: 'Изменение пароля',
                        items: [
                            me.sksc('chbChangeP', Ext.create('Ext.form.field.Checkbox', {
                                hideLabel: true,
                                boxLabel: 'Изменить пароль',
                                platformCode: 'checked',
                                listeners: {
                                    change: function (th, newValue) {
                                        me.gksc('P').setDisabled(!newValue);
                                        me.gksc('confirmP').setDisabled(!newValue);
                                    }
                                }
                            })),
                            me.sksc('P', Ext.create('Ext.form.field.Text', {
                                labelWidth: me.labelWidth,
                                inputType: 'password',
                                fieldLabel: 'Пароль пользователя',
                                disabled: true,
                                maxLength: 128,
                                width: 500,
                                platformCode: 'NewP',
                                validator: function() {
                                    if (me.isDiffPswrds()) {
                                        return 'Введенные пароли не совпадают';
                                    }
                                    return true;
                                },
                                listeners: {
                                    blur: function() {
                                        if (me.isDiffPswrds()) {
                                            Ext.Msg.show({
                                                title: KS.L10n.attention,
                                                msg: 'Введенные пароли не совпадают',
                                                buttons: Ext.MessageBox.OK,
                                                icon: Ext.MessageBox.WARNING
                                            });
                                        }
                                        me.gksc('confirmP').validateValue( me.gksc('confirmP').getValue());
                                    }
                                }
                            })),
                            me.sksc('confirmP', Ext.create('Ext.form.field.Text', {
                                labelWidth: me.labelWidth,
                                inputType: 'password',
                                fieldLabel: 'Подтверждение пароля',
                                disabled: true,
                                maxLength: 128,
                                width: 500,
                                platformCode: 'OldP',
                                validator: function() {
                                    if (me.isDiffPswrds()) {
                                        return 'Введенные пароли не совпадают';
                                    }
                                    return true;
                                },
                                listeners: {
                                    blur: function() {
                                        if (me.isDiffPswrds()) {
                                            Ext.Msg.show({
                                                title: KS.L10n.attention,
                                                msg: 'Введенные пароли не совпадают',
                                                buttons: Ext.MessageBox.OK,
                                                icon: Ext.MessageBox.WARNING
                                            });
                                        }
                                        me.gksc('P').validateValue( me.gksc('P').getValue());
                                    }
                                }
                            }))
                        ]
                    }),
                    Ext.create('Ext.form.FieldSet', {
                        title: 'Политика паролей',
                        flex: 2,
                        items: [
                            me.sksc('chbCanChangeP', Ext.create('Ext.form.field.Checkbox', {
                                hideLabel: true,
                                boxLabel: 'Может менять свой пароль',
                                platformCode: 'pwd_change_allow'
                            })),
                            me.sksc('chbChangeNextP', Ext.create('Ext.form.field.Checkbox', {
                                hideLabel: true,
                                boxLabel: 'Изменить пароль при следующем входе',
                                platformCode: 'pwd_must_change'
                            }))
                        ]
                    })]
            }),
            Ext.create('Ext.form.FieldSet', {
                title: 'Роль пользователя',
                bodyPadding: 5,
                items: [
                    Ext.create('Ext.form.FieldContainer', {
                        layout: {type: 'hbox', align: 'stretch'},
                        items: [
                            me.sksc('userRole', Ext.create('Ext.form.field.ComboBox', {
                                    editable: false,
                                    value: 0,
                                    queryMode: 'local',
                                    store: Ext.create('Ext.data.Store', {
                                        fields: CBDataLib.getFields(),
                                        data: [],
                                        proxy: 'memory'
                                    }),
                                    displayField: CBDataLib.displayField,
                                    valueField: CBDataLib.valueField,
                                    width: 200,
                                    maxHeight: 22,
                                    listeners: {
                                        change: function(th, val) {
                                            let userRoleData = me.gksd('userRoleData')[val];
                                            
                                            Ext.each(me.gksd('controlList'), controlName => {
                                                let controls = Object.values(me.ksControls).filter(c => c.platformCode === controlName);
                                                if (controls.length) {
                                                    controls[0].setDisabled(false);
                                                }
                                            });
                                            
                                            for (var controlName in userRoleData) {
                                                let controls = Object.values(me.ksControls).filter(c => c.platformCode === controlName);
                                                
                                                if (controls.length) {
                                                    if (userRoleData[controlName].clear) {
                                                        controls[0].setValue();
                                                    }
                                                    
                                                    if (userRoleData[controlName].value !== null) {
                                                        controls[0].setValue(userRoleData[controlName].value);
                                                    }

                                                    controls[0].setDisabled(true);
                                                }
                                            }
                                        }
                                    }
                                })),
                            Ext.create('Ext.form.FieldContainer', {
                                layout: {type: 'vbox', align: 'stretch'},
                                padding: '0 0 0 15',
                                items: [
                                    me.sksc('chbSysAdmin', Ext.create('Ext.form.field.Checkbox', {
                                        hideLabel: true,
                                        boxLabel: 'Системный администратор',
                                        platformCode: 'sys_adm'
                                    })),
                                    me.sksc('chbTuneCK', Ext.create('Ext.form.field.Checkbox', {
                                        hideLabel: true,
                                        boxLabel: 'Настройка автоматов, ЦК, открытие\\закрытие дней',
                                        platformCode: 'dbo_adm'
                                    }))
                                ]})
                        ]})
                ]
            }),
            Ext.create('Ext.tab.Panel', {
                flex: 1,
                padding: '5 0 0 0',
                items: [
                    me.sksc('tabEntry', Ext.create('Ext.panel.Panel', {
                        title: 'Вхождение в группы',
                        platformCode: 'DICT_USERS_ADM_RAGE1',
                        items: [
                            me.sksc('gridEntry', Ext.create('Ext.grid.Panel', {
                                flex: 3,
                                minHeight: 120,
                                border: 0,
                                columnLines: true,
                                batchProps: [{
                                    ControlType: 6,
                                    Name: 'Name',
                                    CaptionText: 'Наименование',
                                    DictCode: 'DICTIONARY_GROUPS_ADM',
                                    linkField: 'UID',
                                    PropertyValues: JSON.stringify({Code: 'DICTIONARY_GROUPS_ADM', Action: 2})
                                }],
                                lbar: [
                                    me.sksc('btnAddEntry', Ext.create('Ext.Button', {
                                        iconCls: 'x_btn_add_element',
                                        tooltip: 'Добавить строку',
                                        tooltipType: 'title',
                                        handler: function() {
                                            me.addGridRecord('gridEntry', {code: dnl.GROUPS_ADM}, 'UID');
                                        }
                                    })),
                                    me.sksc('btnRemoveEntry', Ext.create('Ext.Button', {
                                        iconCls: 'x_btn_delete_element',
                                        tooltip: 'Удалить строку',
                                        tooltipType: 'title',
                                        handler: function() {
                                            me.removeGridRecord(me.gksc('gridEntry'));
                                        }
                                    })),
                                    { 
                                        xtype: 'tbseparator'
                                    },
                                    me.sksc('btnInverseEntry', Ext.create('Ext.button.Split',
                                        {
                                            iconCls: 'x_btn_galka',
                                            tooltip: 'Инверсия',
                                            tooltipType: 'title',
                                            disabled: true,
                                            menu: [
                                                {
                                                    text: 'Инверсия',
                                                    iconCls: 'x_btn_galka',
                                                    handler: function() {
                                                        me.checkInversion(me.gksc('gridEntry'));
                                                    }
                                                }, {
                                                    text: 'Отметить все',
                                                    handler: function() {
                                                        me.checkInversion(me.gksc('gridEntry'), true);
                                                    }
                                                }, {
                                                    text: 'С начала до текущей',
                                                    handler: function() {
                                                        me.checkFstToSel(me.gksc('gridEntry'));
                                                    }
                                                }, {
                                                    text: 'С текущей до конца',
                                                    handler: function() {
                                                        me.checkFstToSel(me.gksc('gridEntry'), true);
                                                    }
                                                }, {
                                                    text: 'Между отмеченными',
                                                    handler: function() {
                                                        me.checkCheckToCheck(me.gksc('gridEntry'));
                                                    }
                                                }
                                            ],
                                            handler: function() {
                                                me.checkInversion(me.gksc('gridEntry'));
                                            }
                                        })),
                                    me.sksc('btnUnmarkEntry', Ext.create('Ext.Button', {
                                        iconCls: 'x_btn_unmark',
                                        tooltip: 'Разметить все',
                                        tooltipType: 'title',
                                        disabled: true,
                                        handler: function() {
                                            me.checkInversion(me.gksc('gridEntry'), false);
                                        }
                                    })),
                                    me.sksc('btnSearchReplaceEntry', Ext.create('Ext.Button', {
                                        iconCls: 'x_btn_search-replace',
                                        tooltip: 'Поиск и замена',
                                        tooltipType: 'title',
                                        disabled: true,
                                        handler: function() {
                                            me.searchAndReplace(me.gksc('gridEntry'));
                                        }
                                    }))
                                ],
                                store: Ext.create('Ext.data.Store', {
                                    fields: [],
                                    data: [],
                                    proxy: 'memory'
                                }),
                                listeners: {
                                    selectionchange: function(th, selected) {
                                        let sels = me.gksc('gridEntry').selModel.getSelection();
                                        me.gksc('btnInverseEntry').setDisabled(!sels.length);
                                        me.gksc('btnUnmarkEntry').setDisabled(!sels.length);
                                        me.gksc('btnSearchReplaceEntry').setDisabled(!sels.length);
                                    }
                                }
                            }))
                        ],
                        setValue: me.panelSetValue
                    })),
                    me.sksc('tabGroups', Ext.create('Ext.panel.Panel', {
                        title: 'Группы управления',
                        platformCode: 'DICT_USERS_ADM_RAGE2',
                        items: [
                            me.sksc('gridGroups', Ext.create('Ext.grid.Panel', {
                                flex: 3,
                                minHeight: 120,
                                border: 0,
                                columnLines: true,
                                batchProps: [{
                                    ControlType: 6,
                                    Name: 'Name',
                                    CaptionText: 'Наименование',
                                    DictCode: 'DICTIONARY_GROUPS_ADM',
                                    linkField: 'UID',
                                    PropertyValues: JSON.stringify({Code: 'DICTIONARY_GROUPS_ADM', Action: 2})
                                }],
                                lbar: [
                                    me.sksc('btnAddGroups', Ext.create('Ext.Button', {
                                        iconCls: 'x_btn_add_element',
                                        tooltip: 'Добавить строку',
                                        tooltipType: 'title',
                                        handler: function() {
                                            me.addGridRecord('gridGroups', {code: dnl.GROUPS_ADM}, 'UID');
                                        }
                                    })),
                                    me.sksc('btnRemoveGroups', Ext.create('Ext.Button', {
                                        iconCls: 'x_btn_delete_element',
                                        tooltip: 'Удалить строку',
                                        tooltipType: 'title',
                                        handler: function() {
                                            me.removeGridRecord(me.gksc('gridGroups'));
                                        }
                                    })),
                                    {
                                        xtype: 'tbseparator'
                                    },
                                    me.sksc('btnInverseGroups', Ext.create('Ext.button.Split',
                                        {
                                            iconCls: 'x_btn_galka',
                                            tooltip: 'Инверсия',
                                            tooltipType: 'title',
                                            disabled: true,
                                            menu: [
                                                {
                                                    text: 'Инверсия',
                                                    iconCls: 'x_btn_galka',
                                                    handler: function() {
                                                        me.checkInversion(me.gksc('gridGroups'));
                                                    }
                                                }, {
                                                    text: 'Отметить все',
                                                    handler: function() {
                                                        me.checkInversion(me.gksc('gridGroups'), true);
                                                    }
                                                }, {
                                                    text: 'С начала до текущей',
                                                    handler: function() {
                                                        me.checkFstToSel(me.gksc('gridGroups'));
                                                    }
                                                }, {
                                                    text: 'С текущей до конца',
                                                    handler: function() {
                                                        me.checkFstToSel(me.gksc('gridGroups'), true);
                                                    }
                                                }, {
                                                    text: 'Между отмеченными',
                                                    handler: function() {
                                                        me.checkCheckToCheck(me.gksc('gridGroups'));
                                                    }
                                                }
                                            ],
                                            handler: function() {
                                                me.checkInversion(me.gksc('gridGroups'));
                                            }
                                        })),
                                    me.sksc('btnUnmarkGroups', Ext.create('Ext.Button', {
                                        iconCls: 'x_btn_unmark',
                                        tooltip: 'Разметить все',
                                        tooltipType: 'title',
                                        disabled: true,
                                        handler: function() {
                                            me.checkInversion(me.gksc('gridGroups'), false);
                                        }
                                    })),
                                    me.sksc('btnSearchReplaceGroups', Ext.create('Ext.Button', {
                                        iconCls: 'x_btn_search-replace',
                                        tooltip: 'Поиск и замена',
                                        tooltipType: 'title',
                                        disabled: true,
                                        handler: function() {
                                            me.searchAndReplace(me.gksc('gridGroups'));
                                        }
                                    }))
                                ],
                                store: Ext.create('Ext.data.Store', {
                                    fields: [],
                                    data: [],
                                    proxy: 'memory'
                                }),
                                listeners: {
                                    selectionchange: function(th, selected) {
                                        let sels = me.gksc('gridGroups').selModel.getSelection();
                                        me.gksc('btnInverseGroups').setDisabled(!sels.length);
                                        me.gksc('btnUnmarkGroups').setDisabled(!sels.length);
                                        me.gksc('btnSearchReplaceGroups').setDisabled(!sels.length);
                                    }
                                }
                            }))
                        ],
                        setValue: me.panelSetValue
                    })),
                    me.sksc('tabComplex', Ext.create('Ext.panel.Panel', {
                        title: 'Доступные комплексы',
                        platformCode: 'DICT_USERS_ADM_RAGE3',
                        items: [
                            me.sksc('gridComplex', Ext.create('Ext.grid.Panel', {
                                flex: 3,
                                minHeight: 70,
                                border: 0,
                                columnLines: true,
                                lbar: [
                                    me.sksc('btnInverseComplex', Ext.create('Ext.button.Split',
                                        {
                                            iconCls: 'x_btn_galka',
                                            tooltip: 'Инверсия',
                                            tooltipType: 'title',
                                            disabled: true,
                                            menu: [
                                                {
                                                    text: 'Инверсия',
                                                    iconCls: 'x_btn_galka',
                                                    handler: function() {
                                                        me.checkInversion(me.gksc('gridComplex'));
                                                    }
                                                }, {
                                                    text: 'Отметить все',
                                                    handler: function() {
                                                        me.checkInversion(me.gksc('gridComplex'), true);
                                                    }
                                                }, {
                                                    text: 'С начала до текущей',
                                                    handler: function() {
                                                        me.checkFstToSel(me.gksc('gridComplex'));
                                                    }
                                                }, {
                                                    text: 'С текущей до конца',
                                                    handler: function() {
                                                        me.checkFstToSel(me.gksc('gridComplex'), true);
                                                    }
                                                }, {
                                                    text: 'Между отмеченными',
                                                    handler: function() {
                                                        me.checkCheckToCheck(me.gksc('gridComplex'));
                                                    }
                                                }
                                            ],
                                            handler: function() {
                                                me.checkInversion(me.gksc('gridComplex'));
                                            }
                                        })),
                                    me.sksc('btnUnmarkComplex', Ext.create('Ext.Button', {
                                        iconCls: 'x_btn_unmark',
                                        tooltip: 'Разметить все',
                                        tooltipType: 'title',
                                        disabled: true,
                                        handler: function() {
                                            me.checkInversion(me.gksc('gridComplex'), false);
                                        }
                                    })),
                                    me.sksc('btnSearchReplaceComplex', Ext.create('Ext.Button', {
                                        iconCls: 'x_btn_search-replace',
                                        tooltip: 'Поиск и замена',
                                        tooltipType: 'title',
                                        disabled: true,
                                        handler: function() {
                                            me.searchAndReplace(me.gksc('gridComplex'));
                                        }
                                    }))
                                ],
                                store: Ext.create('Ext.data.Store', {
                                    fields: [],
                                    data: [],
                                    proxy: 'memory'
                                }),
                                listeners: {
                                    selectionchange: function(th, selected) {
                                        let sels = me.gksc('gridComplex').selModel.getSelection();
                                        me.gksc('btnInverseComplex').setDisabled(!sels.length);
                                        me.gksc('btnUnmarkComplex').setDisabled(!sels.length);
                                    }
                                }
                            }))
                        ],
                        setValue: function() {
                            me.checkInversion(me.gksc('gridComplex'), false);
                        }
                    })),
                    me.sksc('tabImplementer', Ext.create('Ext.panel.Panel', {
                        title: 'Исполнитель',
                        layout: {type: 'vbox', align: 'stretch'},
                        height: 255,
                        bodyPadding: 6,
                        items: [
                            me.sksc('fio', Ext.create('Ext.form.field.Text', {
                                labelWidth: me.labelWidth,
                                fieldLabel: 'Ф.И.О.',
                                maxLength: 250,
                                platformCode: 'fio'
                            })),
                            me.sksc('position', Ext.create('Ext.form.field.Text', {
                                labelWidth: me.labelWidth,
                                fieldLabel: 'Должность',
                                maxLength: 250,
                                platformCode: 'post'
                            })),
                            me.sksc('phone', Ext.create('Ext.form.field.Text', {
                                labelWidth: me.labelWidth,
                                fieldLabel: 'Телефон',
                                maxLength: 50,
                                platformCode: 'phone'
                            })),
                            me.sksc('email', Ext.create('Ext.form.field.Text', {
                                labelWidth: me.labelWidth,
                                fieldLabel: 'Email',
                                maxLength: 128,
                                platformCode: 'email'
                            })),
                            me.sksc('emailName', Ext.create('Ext.form.field.Text', {
                                labelWidth: me.labelWidth,
                                fieldLabel: 'Имя входа Email',
                                maxLength: 128,
                                platformCode: 'email_login'
                            })),
                            me.sksc('emailP', Ext.create('Ext.form.field.Text', {
                                labelWidth: me.labelWidth,
                                inputType: 'password',
                                fieldLabel: 'Пароль Email',
                                maxLength: 128,
                                platformCode: 'email_password'
                            })),
                            me.sksc('certificate', Ext.create('Ext.form.field.Text', {
                                labelWidth: me.labelWidth,
                                fieldLabel: 'Сертификат входа',
                                maxLength: 250,
                                platformCode: 'keyid'
                            })),
                            me.sksc('staffUnit', Ext.create('Keysystems.Controls.DictName.Edit', {
                                labelWidth: me.labelWidth,
                                fieldLabel: 'Штатное подразделение',
                                code: dnl.BPMS_DIVISION,
                                platformCode: 'division_n',
                                handler: function() {
                                    dictFunc({
                                        parentView: objs.view,
                                        code: dnl.BPMS_DIVISION,
                                        mode: 'SINGL',
                                        selectLinks: me.gksc('staffUnit').getValue(),
                                        control: me.gksc('staffUnit'),
                                        contextSearch: me.gksc('staffUnit').contextSearch,
                                        divType: 1
                                    },
                                        {
                                            ok: function(value) {
                                                me.gksc('staffUnit').setValue(value);
                                            }
                                        },
                                        function(form) {
                                            let control = me.gksc('staffUnit');
                                            
                                            if (control.contextSearch) {
                                                let field = control.fieldCode || control.fieldName || control,
                                                    oldValue = control.fieldCode || control.fieldName
                                                        ? control.getOldContextValue(control.fieldCode ? control.codeField : control.nameField)
                                                        : control.originalValue;

                                                field.setValue(oldValue);
                                            }
                                        }
                                    );
                                }
                            }))
                        ]
                    })),
                    me.sksc('tabArms', Ext.create('Ext.panel.Panel', {
                        title: 'Настраиваемые армы',
                        platformCode: 'DICT_USERS_ADM_RAGE5',
                        items: [
                            me.sksc('gridArms', Ext.create('Ext.grid.Panel', {
                                flex: 3,
                                minHeight: 120,
                                border: 0,
                                columnLines: true,
                                store: Ext.create('Ext.data.Store', {
                                    fields: [],
                                    data: [],
                                    proxy: 'memory'
                                })
                            }))
                        ],
                        setValue: me.panelSetValue
                    })),
                    me.sksc('tabDiv', Ext.create('Ext.panel.Panel', {
                        title: 'Функциональные подразделения',
                        platformCode: 'DICT_USERS_ADM_RAGE6',
                        items: [
                            me.sksc('gridDiv', Ext.create('Ext.grid.Panel', {
                                flex: 3,
                                minHeight: 120,
                                border: 0,
                                columnLines: true,
                                batchProps: [{
                                    ControlType: 6,
                                    Name: 'Code',
                                    CaptionText: 'Код',
                                    DictCode: 'DICTIONARY_BPMS_DIVISION',
                                    PropertyValues: JSON.stringify({Code: 'DICTIONARY_BPMS_DIVISION', Action: 2}),
                                    cfg: { divType: 2 }
                                }],
                                lbar: [
                                    me.sksc('btnAddDiv', Ext.create('Ext.Button', {
                                        iconCls: 'x_btn_add_element',
                                        tooltip: 'Добавить строку',
                                        tooltipType: 'title',
                                        handler: function() {
                                            me.addGridRecord('gridDiv', {
                                                code: dnl.BPMS_DIVISION,
                                                divType: 2
                                            });
                                        }
                                    })),
                                    me.sksc('btnRemoveDiv', Ext.create('Ext.Button', {
                                        iconCls: 'x_btn_delete_element',
                                        tooltip: 'Удалить строку',
                                        tooltipType: 'title',
                                        handler: function() {
                                            me.removeGridRecord(me.gksc('gridDiv'));
                                        }
                                    })),
                                    {
                                        xtype: 'tbseparator'
                                    },
                                    me.sksc('btnInverseDiv', Ext.create('Ext.button.Split',
                                        {
                                            iconCls: 'x_btn_galka',
                                            tooltip: 'Инверсия',
                                            tooltipType: 'title',
                                            disabled: true,
                                            menu: [
                                                {
                                                    text: 'Инверсия',
                                                    iconCls: 'x_btn_galka',
                                                    handler: function() {
                                                        me.checkInversion(me.gksc('gridDiv'));
                                                    }
                                                }, {
                                                    text: 'Отметить все',
                                                    handler: function() {
                                                        me.checkInversion(me.gksc('gridDiv'), true);
                                                    }
                                                }, {
                                                    text: 'С начала до текущей',
                                                    handler: function() {
                                                        me.checkFstToSel(me.gksc('gridDiv'));
                                                    }
                                                }, {
                                                    text: 'С текущей до конца',
                                                    handler: function() {
                                                        me.checkFstToSel(me.gksc('gridDiv'), true);
                                                    }
                                                }, {
                                                    text: 'Между отмеченными',
                                                    handler: function() {
                                                        me.checkCheckToCheck(me.gksc('gridDiv'));
                                                    }
                                                }
                                            ],
                                            handler: function() {
                                                me.checkInversion(me.gksc('gridDiv'));
                                            }
                                        })),
                                    me.sksc('btnUnmarkDiv', Ext.create('Ext.Button', {
                                        iconCls: 'x_btn_unmark',
                                        tooltip: 'Разметить все',
                                        tooltipType: 'title',
                                        disabled: true,
                                        handler: function() {
                                            me.checkInversion(me.gksc('gridDiv'), false);
                                        }
                                    })),
                                    me.sksc('btnSearchReplaceDiv', Ext.create('Ext.Button', {
                                        iconCls: 'x_btn_search-replace',
                                        tooltip: 'Поиск и замена',
                                        tooltipType: 'title',
                                        disabled: true,
                                        handler: function() {
                                            me.searchAndReplace(me.gksc('gridDiv'));
                                        }
                                    }))
                                ],
                                store: Ext.create('Ext.data.Store', {
                                    fields: [],
                                    data: [],
                                    proxy: 'memory'
                                }),
                                listeners: {
                                    selectionchange: function(th, selected) {
                                        let sels = me.gksc('gridDiv').selModel.getSelection();
                                        me.gksc('btnInverseDiv').setDisabled(!sels.length);
                                        me.gksc('btnUnmarkDiv').setDisabled(!sels.length);
                                        me.gksc('btnSearchReplaceDiv').setDisabled(!sels.length);
                                    }
                                }
                            }))
                        ],
                        setValue: me.panelSetValue
                    })),
                    me.sksc('tabLevels', Ext.create('Ext.panel.Panel', {
                        title: 'Уровни ЭЦП',
                        platformCode: 'DICT_USERS_ADM_RAGE7',
                        items: [
                            me.sksc('gridLevels', Ext.create('Ext.grid.Panel', {
                                flex: 3,
                                minHeight: 70,
                                border: 0,
                                columnLines: true,
                                batchProps: [{
                                    ControlType: 6,
                                    Name: 'Name',
                                    CaptionText: 'Наименование',
                                    DictCode: 'DICTIONARY_EDS_LEVEL',
                                    PropertyValues: JSON.stringify({Code: 'DICTIONARY_EDS_LEVEL', Action: 2})
                                    }, {
                                        ControlType: 5,
                                        AllowEmptyStartValue: true,
                                        Name: 'KEYID',
                                        CaptionText: 'Идентификатор ключа',
                                        DictCode: '',
                                        PropertyValues: JSON.stringify({Code: '', Action: 2})
                                    }],
                                lbar: [
                                    me.sksc('btnAddLevels', Ext.create('Ext.Button', {
                                        iconCls: 'x_btn_add_element',
                                        tooltip: 'Добавить строку',
                                        tooltipType: 'title',
                                        handler: function() {
                                            me.addGridRecord('gridLevels', {code: dnl.EDS_LVL});
                                        }
                                    })),
                                    me.sksc('btnRemoveLevels', Ext.create('Ext.Button', {
                                        iconCls: 'x_btn_delete_element',
                                        tooltip: 'Удалить строку',
                                        tooltipType: 'title',
                                        handler: function() {
                                            me.removeGridRecord(me.gksc('gridLevels'));
                                        }
                                    })),
                                    {
                                        xtype: 'tbseparator'
                                    },
                                    me.sksc('btnSearchReplaceLevels', Ext.create('Ext.Button', {
                                        iconCls: 'x_btn_search-replace',
                                        tooltip: 'Поиск и замена',
                                        tooltipType: 'title',
                                        disabled: true,
                                        handler: function() {
                                            me.searchAndReplace(me.gksc('gridLevels'));
                                        }
                                    }))
                                ],
                                plugins: [
                                    Ext.create('Ext.grid.plugin.CellEditing', {
                                        clicksToEdit: 1
                                    })
                                ],
                                store: Ext.create('Ext.data.Store', {
                                    fields: [],
                                    data: [],
                                    proxy: 'memory'
                                }),
                                listeners: {
                                    selectionchange: function(th, selected) {
                                        let sels = me.gksc('gridLevels').selModel.getSelection();
                                        me.gksc('btnSearchReplaceLevels').setDisabled(!sels.length);
                                    }
                                }
                            }))
                        ],
                        setValue: me.panelSetValue
                    }))
                ]
            })
        ];
    },
    getExtraNew: function (callBack) { this.getExtra(callBack, -1); },
    adaptLevelsCols: function(columns) {
        let me = this,
            keyCol = ArrayLib.filter(columns, ['dataIndex'], 'KEYID')[0];        
        
        if (keyCol) {
            keyCol.editor = {
                xtype: 'textfield',
                maxLength: 250,
                enforceMaxLength: true
            };
        }
    },
    getExtra: function(callBack, link) {
        let me = this;

        me.baseGetExtra({ link: link }, function(value) {
            if (value.StopMsg) {
                Ext.Msg.show({
                    msg: value.StopMsg,
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.INFO,
                    fn: function(buttonId) {
                        me.afterCancelLoad();
                    }
                });
                return;
            }
            
            me.sksd('userRoleData', value.userRoleData);
            let controlList = [];
            Ext.each(Object.values(value.userRoleData), d => {
                ArrayLib.addMissing(controlList, Object.keys(d));
            });
            me.sksd('controlList', controlList);
            
            let name = me.gksc('NAME'),
                userRole = me.gksc('userRole'),
                chbChangeP = me.gksc('chbChangeP'),
                isNew = me.gksd('link') < 0,
                isCopy = me.f === 'copy';
            
            name.setValue(value.row.NAME);
            me.gksc('NOTE').setValue(value.row.NOTE_ID);
            chbChangeP.setValue(isNew && !isCopy);
            me.gksc('chbCanChangeP').setValue(value.row.PWD_CHANGE_ALLOW || isNew);
            me.gksc('chbChangeNextP').setValue(value.row.PWD_MUST_CHANGE);
            me.gksc('chbSysAdmin').setValue(value.row.SYS_ADM);
            me.gksc('chbTuneCK').setValue(value.row.DBO_ADM);

            userRole.store.loadData(CBDataLib.get('', false, value.userRoleValues));
            userRole.setValue(value.row.USER_TYPE);

            me.gksc('gridEntry').setMetaDate(value.groupData, {
                profileCode: me.code,
                profileKey: 'gridEntry',
                gateCode: me.keyEdit
            });

            me.gksc('gridGroups').setMetaDate(value.groupGrpData, {
                profileCode: me.code,
                profileKey: 'gridGroups',
                gateCode: me.keyEdit
            });
            
            me.gksc('gridComplex').setMetaDate(value.complexData, {
                profileCode: me.code,
                profileKey: 'gridComplex',
                gateCode: me.keyEdit
            });

            for(var key in value.ispData) {
                me.gksc(key).setValue(value.ispData[key]);
            }

            me.gksc('gridArms').setMetaDate(value.armData, {
                profileCode: me.code,
                profileKey: 'gridArms',
                gateCode: me.keyEdit
            });

            me.gksc('gridDiv').setMetaDate(value.divData, {
                profileCode: me.code,
                profileKey: 'gridDiv',
                gateCode: me.keyEdit
            });

            me.adaptLevelsCols(value.edslvlData.columns);            
            me.gksc('gridLevels').setMetaDate(value.edslvlData, {
                profileCode: me.code,
                profileKey: 'gridLevels',
                gateCode: me.keyEdit
            });

            name.setDisabled(!isNew);
            chbChangeP.setDisabled(isNew);
            
            KsLib.tryRun(callBack);
        });
    },
    isFilled: function() {
        let me = this,
            res = true,
            name = me.gksc('NAME');
        
        if (name.isEmpty()) {
            me.addToInvalidControls(name);
            res = false;
        }
        
        return res;
    }, 
    dataCollector: function() {
        let me = this,
            data = me.callParent([false]),
            staffRec = me.gksc('staffUnit').getValue();
        
        data.isCopy = me.f === 'copy';
        
        data.NAME = me.gksc('NAME').getValue();
        data.NOTE = me.gksc('NOTE').getValue();
        
        data.canChangeP = me.gksc('chbCanChangeP').getValue();
        data.changeNextP = me.gksc('chbChangeNextP').getValue();
        data.sysAdmin = me.gksc('chbSysAdmin').getValue();
        data.tuneCK = me.gksc('chbTuneCK').getValue();
        data.userRole = me.gksc('userRole').getValue();

        data.P = me.gksc('P').getValue();
        data.confirmP = me.gksc('confirmP').getValue();
        
        data.groupData = me.gksc('gridEntry').store.getDataExt();
        data.groupGrpData = me.gksc('gridGroups').store.getDataExt();
        data.complexData = me.gksc('gridComplex').store.getDataExt();
        
        data.ispData = [{
            fio: me.gksc('fio').getValue(),
            position: me.gksc('position').getValue(),
            phone: me.gksc('phone').getValue(),
            email: me.gksc('email').getValue(),
            emailName: me.gksc('emailName').getValue(),
            emailP: me.gksc('emailP').getValue(),
            certificate: me.gksc('certificate').getValue(),
            divLink: staffRec.length ? staffRec[0].LINK || staffRec[0].data.LINK : null,
            divName: staffRec.length ? staffRec[0].NAME || staffRec[0].data.NAME : null
        }];
        
        data.armData = me.gksc('gridArms').store.getDataExt();
        data.divData = me.gksc('gridDiv').store.getDataExt();
        data.edslvlData = me.gksc('gridLevels').store.getDataExt();
        
        data.continueSave = me.continueSave;
        
        return data;
    },
    saveData: function(endFunc, inputParams) {
        let me = this;
        
        if (me.needClose) {
            endFunc = function() {
                me.objs.view.close();
            }
        } else if (me.continueSave) {
            endFunc = function() {
                me.continueSave = false;
            }
        }
        
        me.callParent([endFunc, inputParams]);
    },
    parseCheckSaveResult: function(checkSaveResult, callback) {
        let me = this;
        
        if (checkSaveResult.Message) {
            showDetailEventsLog({
                html: checkSaveResult.Message,
                modal: true,
                title: '',
                fullTitle: 'Протокол контроля',
                continueFn: checkSaveResult.partlyBlock ? function() {
                    me.continueSave = true;
                    me.gksc('saveBtn').handler();
                } : _
            });
        }
    },
    successSaveFunc: function(result, endFunc, params) {
        let me = this,
            view = me.objs.view || me.gksc('view');
        
        if (result.result) {
            // так как 'Группа пользователей' наследуется от 'Пользователей'
            if (me.code === dnl.USERS_ADM) {
                let chbChangeP = me.gksc('chbChangeP');
                chbChangeP.setDisabled(false);
                chbChangeP.setValue(false);
                me.gksc('P').setValue();
                me.gksc('confirmP').setValue();
            }
        }
        
        me.callParent(arguments);

        if (result.result) {
            me.gksc('NAME').setDisabled(me.gksd('link') > 0);

            view.setTitle(me.getViewTitle());
            view.tabLink = result.SavedLink;
        }
        
        if (result.infoMsg) {
            showDetailEventsLog({
                html: result.infoMsg,
                modal: true,
                title: '',
                fullTitle: 'Протокол контроля'
            });
        }
    },
    
    cancel: Ext.emptyFn
});