﻿Ext.define('Keysystems.userList.Store', {
	extend: 'Ext.data.Store',
	loadData: function() {
		this.callParent(arguments);
		UserList.statusLabel.setText(wmc.get('userListCount', this.getCount()));
	}
});

window.UserList = function() {
	if (!window.isAuthorize || UserList.show) return;
	UserList.show = true;
	UserList.view = Ext.create('Ext.window.Window', {
		title: 'Список пользователей онлайн',
		iconCls: 'x_btn_keysystems',
		layout: 'anchor',
		height: 400,
		width: 600,
		items: [
			Ext.create('Ext.grid.Panel', {
				anchor: '100% 100%',
				autoScroll: true,
				autoRender: true,
				border: 0,
				store: UserList.store = Ext.create('Keysystems.userList.Store', {
					fields: ['login', 'fio', 'srip', 'srid', 'ping', 'Forwarded', 'HostEntry'],
					data: [],
					proxy: 'memory'
				}),
				columns: [
					{
						text: 'Login',
						dataIndex: 'login',
						flex: 1
					}, {
						text: 'FIO',
						dataIndex: 'fio',
						flex: 1
					}, {
						text: 'IP',
						dataIndex: 'srip',
						flex: 1
					}, {
						text: 'X-Forwarded-For',
						dataIndex: 'Forwarded',
						flex: 1
					}, {
						text: 'HostEntry',
						dataIndex: 'HostEntry',
						flex: 1
					}, {
						text: 'SignalRID',
						dataIndex: 'srid',
						flex: 1
					}, {
						text: 'Ping',
						dataIndex: 'ping',
						flex: 1
					}
				],
				columnLines: true,
				plugins: ['gridclipboard']
			})
		],
		buttons: [
			UserList.statusLabel = Ext.create('Ext.form.Label'),
			'->',
			Ext.create('Ext.Button', {
				text: 'Обновить',
				handler: function() {
					ajaxRequest({
						url: 'data/GetUsersList_A',
						success: function(val) {
							UserList.store.loadData(val, false);
						}
					});
				}
			})
		],
		listeners: {
			close: function() {
				UserList.show = false;
			}
		}
	});

	ajaxRequest({
		url: 'data/GetUsersList_A',
		success: function(val) {
			UserList.store.loadData(val, false);
			UserList.view.show();
		}
	});
};