﻿Ext.define('Keysystems.UserProperties', {
	extend: 'Keysystems.Base.Edit',
	width: 500,
	bodyPadding: 5,
	labelWidth: 100,
	resizable: true,
	hideControlBtn: true,
	_arr1: ['S_PERSON', 'S_ORG', 'S_OTDEL', 'S_DOLG', 'S_REGION'],
	_arr2: ['person', 'org', 'otdels', 'dolg', 'region'],

	viewCfg: function() {
		var res = this.callParent(arguments);
		//delete res.tbar;
		res.title = 'Реквизиты пользователя';
		res.iconCls = 'x_btn_dict';
		res.resizable = true;
		res.maximizable = false;
		res.minWidth = 500;
		res.minHeight = 322;
		res.maxWidth = 1000;
		res.maxHeight = 500;
		//this.objs.saveBtn.hide();
		return res;
	},

	createItems: function() {
		var me = this,
			objs = me.objs;
		return objs.items = [
			me.createDictEdit({
				readOnly: true,
				key: 'S_PERSON',
				mode: 'SINGL',
				code: dnl.S_PERSON,
				fieldLabel: 'Сотрудник',
				codeWidth: 125
			}),
			me.createDictEdit({
				readOnly: true,
				key: 'S_ORG',
				mode: 'SINGL',
				code: dnl.S_ORG,
				fieldLabel: 'Организация',
				codeWidth: 125
			}),
			me.createDictEdit({
				readOnly: true,
				key: 'S_OTDEL',
				mode: 'MULTI',
				code: dnl.S_OTDEL,
				fieldLabel: 'Подразделение',
				codeWidth: 125,
				initWhereArgs: function () {
					return {
						SOrgs: {
							value: JSON.stringify([me.gksc('S_ORG').getLink()]),
							type: 'List_int'
						}
					}
				}
			}),
			me.createDictEdit({
				readOnly: true,
				key: 'S_DOLG',
				mode: 'SINGL',
				code: dnl.S_DOLG,
				fieldLabel: 'Должности',
				codeWidth: 125
			}),
			me.createDictEdit({
				readOnly: true,
				key: 'S_REGION',
				mode: 'SINGL',
				code: dnl.S_REGION,
				fieldLabel: 'Территория',
				codeWidth: 125
			}),
			Ext.create('Ext.panel.Panel', {
				title: 'ГИС ЕСГФК',
				layout: { type: 'vbox', align: 'stretch' },
				border: 1,
				items: [
					objs.EsgfkLogin = Ext.create('Ext.form.field.Text', {
						key: 'EsgfkLogin',
						maxLength: 128,
						fieldLabel: 'Имя пользователя',
						ksAllowEmpty: false,
						labelWidth: me.labelWidth,
						enforceMaxLength: true,
						padding: "0 5 0 5"
					}),
					objs.EsgfkPassword = Ext.create('Ext.form.field.Text', {
						key: 'EsgfkPassword',
						maxLength: 128,
						fieldLabel: KS.L10n.password,
						emptyText: KS.L10n.password,
						inputType: 'password',
						selectOnFocus: true,
						padding: "0 5 0 5"
					})
				]
			})
		];
	},
	loadNewData: function() {
		var me = this,
			objs = me.objs;
		Ext.each(me._arr1, function(key1, i) {
			var key2 = me._arr2[i];
			objs[key1].setValue(user[key2]);
		});
		objs.EsgfkLogin.setValue(user['person'].data.GIS_LOGIN);
		objs.EsgfkPassword.setValue(user['person'].data.GIS_PASSWORD);
	},
	dataCollector: Ext.nullFn,
	getExtra: function (callback) { KsLib.tryRun(callback); },
	saveData: function (endFunc, params) {
		var me = this;
		Ext.util.Cookies.set('esgfkLogin', me.objs.EsgfkLogin.getValue());
		Ext.util.Cookies.set('esgfkPassword', me.objs.EsgfkPassword.getValue());
		me.showLoadMask({
			msg: KS.L10n.preparing_data,
			rid: ajaxRequest({
				url: 'SUserProperties/SaveAuthenticationData_A',
				params: {
					esgfkLogin: Ext.util.Cookies.get('esgfkLogin'),
					esgfkPassword: Ext.util.Cookies.get('esgfkPassword'),
				},
				success: function (result) {
					if (result.error) {
						if (result.ErrorMsg) {
							showError(result.ErrorMsg);
						}
						Log.sendLog(wmc.get('SavingError'));
						QuickMsgs.notSave();
					}
					else if (result.result)
					{
						Log.sendLog(wmc.get('SavingSuccess'));
						QuickMsgs.save();
					} 
				},
				callback: function() {
					Ext.util.Cookies.clear('esgfkLogin');
					Ext.util.Cookies.clear('esgfkPassword');
					me.loadMask.destroy();
				}
			})
		});
	}
});