Ext.define('Keysystems.ToolbarAccess', {
	extend: 'Ext.window.Window',
	modal: true,
	iconCls: 'x_btn_users',
	layout: {type: 'vbox', align: 'stretch'},
	width: 600,
	height: 400,
	minHeight: 200,
	minWidth: 400,
	result: null,
	maximizable: true,

	labelWidth: 200,
	resizable: true,
	user: null,
	data: null,
	changedObjects: [],
	checkChanges: true,

	initComponent: function () {
		let me = this;

		me.items = [
			me.treePanel = Ext.create('Ext.tree.Panel', {
				hideHeaders: true,
				autoScroll: true,
				border: 0,
				flex: 1,
				tbar: [
					me.btnSave = Ext.create('Ext.Button', {
						tooltip: 'Сохранить',
						tooltipType: 'title',
						iconCls: 'x_btn_save',
						disabled: true,
						handler: function () {
							me.save();
						}
					}),
					Ext.create('Ext.Button',
						{
							tooltip: 'Обновить',
							tooltipType: 'title',
							iconCls: 'x_btn_refresh',
							handler: function () {
								me.refresh();
							}
						}),
					Ext.create('Ext.Button',
						{
							tooltip: 'Развернуть все узлы',
							tooltipType: 'title',
							iconCls: 'x_btn_treeexpand',
							handler: function () {
								me.treePanel.expandAll();
							}
						}),
					Ext.create('Ext.Button', {
						tooltip: 'Свернуть все узлы',
						tooltipType: 'title',
						iconCls: 'x_btn_treecollapse',
						handler: function () {
							me.treePanel.collapseAll();
						}
					}),
					Ext.create('Ext.Button',
						{
							tooltip: 'Отметить все',
							tooltipType: 'title',
							iconCls: 'x_btn_galka',
							handler: function () {
								me.checkAll(true);
							}
						}),
					Ext.create('Ext.Button',
						{
							tooltip: 'Разметить все',
							tooltipType: 'title',
							iconCls: 'x_btn_unmark',
							handler: function () {
								me.checkAll(false);
							}
						}),

					Ext.create('Ext.Button', {
						tooltip: 'Выход',
						tooltipType: 'title',
						iconCls: 'x_btn_exit',
						handler: function () {
							me.close();
						}
					})
				],
				caseSensitive: false,
				columns: [{
					xtype: 'treecolumn',
					text: 'Name',
					width: 10000,
					dataIndex: 'NAME',
					renderer: (value, rec) => {
						let cls = rec.record.match;
						if (cls) return Ext.String.format('<span class="{0}">{1}</span>', cls, rec.record.data.NAME);
						return value;
					}
				}],
				store: Ext.create('Ext.data.TreeStore', {
					fields: ['LINK', 'UID', 'CODE', 'NAME'],
					root: {expanded: true, children: []},
					defaultRootText: ''
				}),
				rootVisible: false,
				listeners: {
					checkchange: (rec, checked) => {
						if (!checked) {
							rec.cascade(function (child) {
								child.set('checked', checked);
								me.checkChanged(child, checked);
							});
						} else
							me.checkChanged(rec, checked);

						me.enableTools();
					}
				}
			})
		];
		me.treePanel.addDocked([me.createSearchPanel()]);
		me.callParent(arguments);
		me.on('afterrender', me.refresh.bind(me));
	},

	createSearchPanel: function () {
		let me = this;
		return me.searchField = Ext.create('Keysystems.Tree.SearchPanel', {
			treePanel: me.treePanel
		});
	},

	refresh: function () {
		let me = this;
		const loadMask = new Ext.LoadMask({
			msg: wmc.getMask('Updating'),
			target: me,
			autoShow: true,
			rid: ajaxRequest({
				url: 'SObjAccess/GetToolbarAccess_A',
				params: {user: me.user, code: me.code},
				success: function (result) {
					me.data = result.tree;
					me.changedObjects = [];

					let node = me.treePanel.getFrstSelect(),
						linkSelected = node ? node.get('LINK') : null;
					me.treePanel.store.setRootNode({expanded: true, children: me.buildTree(null)});
					let selModel = me.treePanel.getSelectionModel();
					if (selModel) {
						let selectedNode = linkSelected ? me.treePanel.getStore().findNode('LINK', linkSelected) : null;
						selModel.select(selectedNode ?? me.treePanel.store.root.firstChild);
					}
				},
				callback: function () {
					loadMask.destroy();
				}
			})
		});
	},
	prepareData: function (r) {
		let me = this;
		if (r.image) r.iconCls = 'x_btn_' + r.image.toLowerCase() + ' x_btn_' + r.image.toUpperCase();

		Ext.each(r.children, me.prepareData, me);
	},
	buildTree: function () {
		let me = this;
		Ext.each(me.data, me.prepareData, me);
		return me.data;
	},
	checkAll: function (checked) {
		this.treePanel.getRootNode().cascade(function (node) {
			node.set('checked', checked);
			me.checkChanged(node, checked);
		});
	},
	enableTools: function () {
		let me = this;
		me.btnSave.setDisabled(me.changedObjects.length === 0);
	},
	save: function (callback) {
		let me = this;
		if (me.changedObjects.length === 0) return;

		Log.sendLog('Данные к сохранению');
		Log.sendRawLog(me.changedObjects);

		me.setLoading(wmc.get('ObjAccessSaving'));
		ajaxRequest({
			url: '/SObjAccess/SaveToolbarAccess_A',
			params: {user: me.user, code: me.code, changes: JSON.stringify(me.changedObjects)},
			success: function (result) {
				me.setLoading(false);
				if (!result || result.Fail) {
					failureShow(result.Message ?? wmc.get('ObjAccessSaveFailed'), wmc.get('SavingError'));
					console.warn(wmc.get('ObjAccessSaveFailed') + ',' + result.Message);
					return false;
				}
				QuickMsgs.save();
				me.changedObjects = [];
				me.enableTools();
				if (callback) callback();
			},

			failure: function (response) {
				me.setLoading(false);
				failureShow(wmc.get('ObjAccessSaveFailed'), wmc.get('SavingError'));
				console.error("Error", response.responseText);
			}
		});
	},
	checkChanged: function (node, checked) {
		let me = this,
			code = node.get('CODE'),
			iChecked = checked ? 1 : 0,
			rowChanges = me.changedObjects.filter(obj => obj.CODE === code)[0]
		if (iChecked !== parseInt(node.get('AccessBase'))) {
			if (!rowChanges) {
				me.changedObjects.push({
					CODE: code,
					checked: checked,
					AccessBase: node.get('AccessBase')
				});
			}
		} else {
			let idx = me.changedObjects.indexOf(rowChanges);
			if (idx >= 0) me.changedObjects.splice(idx, 1);
		}
	},
	listeners: {
		beforeclose: function () {
			let me = this;
			if (!me.checkChanges) return true;
			if (me.changedObjects.length) {
				Ext.Msg.show({
					title: wmc.get('Attention'),
					msg: wmc.get('SaveChanges'),
					buttons: Ext.MessageBox.YESNOCANCEL,
					fn: function (buttonId) {
						if (buttonId === 'yes') {
							me.save(() => {
								me.checkChanges = false;
								me.close();
							});
						}
						if (buttonId === 'no') {
							me.checkChanges = false;
							me.close();
						}
					},
					icon: Ext.MessageBox.QUESTION
				});
				return false;
			}
			return true;
		}
	}
});