﻿Ext.define('Keysystems.Panel.Settings', {
	extend: 'Ext.panel.Panel',
	mixins: ['Keysystems.Base.Abstract'],

	title: 'Настройки объектов',
	iconCls: 'x_btn_settings',
	border: 0,
	layout: {type: 'hbox', align: 'stretch'},
	header: false,
	flex: 1,
	labelWidth: 300,

	settings: {},
	nastrsToHide: [], //коды настроек, которые будут скрыты

	initComponent: function () {
		let me = this;
		me.beforeInitComponent();
		me.items = [
			me.treePanel = Ext.create('Ext.tree.Panel', {
				hideHeaders: true,
				width: 250,
				cls: Ext.baseCSSPrefix + 'autowidth-table',
				tbar: [
					me.btnSave = Ext.create('Ext.Button', {
						tooltip: 'Сохранить',
						tooltipType: 'title',
						disabled: true,
						iconCls: 'x_btn_save',
						handler: function () {
							me.save();
						}
					}),
					{
						iconCls: 'x_btn_refresh',
						tooltip: 'Обновить',
						tooltipType: 'title',
						handler: function () {
							me.refresh(me.code);
						}
					},
					{
						iconCls: 'x_btn_treeexpand',
						tooltip: 'Развернуть все узлы',
						tooltipType: 'title',
						handler: function () {
							me.treePanel.expandAll();
						}
					},
					{
						iconCls: 'x_btn_treecollapse',
						tooltip: 'Свернуть все узлы',
						tooltipType: 'title',
						handler: function () {
							me.treePanel.collapseAll();
						}
					},
					Ext.create('Ext.Button', {
						tooltip: 'Выход',
						tooltipType: 'title',
						iconCls: 'x_btn_exit',
						handler: function () {
							me.ownerCt.close();
						}
					})
				],
				caseSensitive: false,
				columns: [{
					xtype: 'treecolumn',
					text: 'Name',
					width: 10000,
					dataIndex: 'NAME',
					renderer: (value, rec) => {
						let cls = rec.record.match;
						if (cls) return Ext.String.format('<span class="{0}">{1}</span>', cls, rec.record.data.NAME);
						return value;
					}
				}],
				border: 0,
				autoScroll: true,
				store: Ext.create('Ext.data.TreeStore', {
					fields: ['NAME', 'CODE'],
					root: {expanded: true, children: []},
					defaultRootText: ''
				}),
				rootVisible: false,
				split: true,
				listeners: {
					beforeselect: function (th, rec) {
						let arrChanges = me.propertyGrid.getChanges();
						if (arrChanges.length) {
							Ext.Msg.show({
								title: KS.L10n.attention,
								msg: KS.L10n.saveChanges,
								buttons: Ext.MessageBox.YESNOCANCEL,
								fn: function (buttonId) {
									if (buttonId === 'yes') {
										me.save(() => {
											me.treePanel.getSelectionModel().select(rec);
											me.refreshPropGrid(rec.get('CODE'), me.cmbUsers.getValue());
											return true;
										});
									}
									if (buttonId === 'no') {
										me.cancel(() => {
											me.treePanel.getSelectionModel().select(rec);
											me.refreshPropGrid(rec.get('CODE'), me.cmbUsers.getValue());
											return true;
										});
									} else {
										return false;
									}
								},
								icon: Ext.MessageBox.QUESTION
							});
							return false;
						}

						me.refreshPropGrid(rec.get('CODE'), me.cmbUsers.getValue());
						return true;
					}
				}
			}),
			{xtype: 'splitter'},
			me.rightPanel = Ext.create('Ext.panel.Panel', {

				autoScroll: true,
				flex: 1,
				bodyPadding: 5,
				border: 0,
				layout: {type: 'vbox', align: 'stretch'},
				layoutConfig: {
					align: 'stretch',
					pack: 'start',
				},
				items: [
					Ext.create('Ext.panel.Panel',
						{
							layout: {type: 'hbox', align: 'stretch'},
							pack: 'end',
							border: 0,
							padding: '0 0 5px 0',
							items: [
								'->',
								me.cmbUsers = Ext.create('Keysystems.Controls.ComboBoxExtra', {
									editable: false,
									labelWidth: 150,
									fieldLabel: 'Пользователь',
									displayField: "userName",
									valueField: "userID",
									//readOnly: true,
									width: 500,
									store: CBDataLib.getStore([]),
									listeners: {
										beforeselect: function (th, rec) {
											let arrChanges = me.propertyGrid.getChanges(),
												objCode = me.treePanel.getFrstSelect().get('CODE'),
												user = rec.get('userID');
											if (arrChanges.length) {
												Ext.Msg.show({
													title: KS.L10n.attention,
													msg: KS.L10n.saveChanges,
													buttons: Ext.MessageBox.YESNOCANCEL,
													fn: function (buttonId) {
														if (buttonId === 'yes') {
															me.save(() => {
																me.cmbUsers.setValue(rec);
																me.refreshPropGrid(objCode, user);
																return true;
															});
														}
														if (buttonId === 'no') {
															me.cancel(() => {
																me.cmbUsers.setValue(rec);
																me.refreshPropGrid(objCode, user);
																return true;
															});
														} else {
															return false;
														}
													},
													icon: Ext.MessageBox.QUESTION
												});
												return false;
											}
											me.refreshPropGrid(objCode, user);
											return true;
										}
									}
								}),
							]
						}),
					me.bodyPanel = Ext.create('Ext.panel.Panel', {
						layout: {type: 'vbox', align: 'stretch'},
						autoScroll: true,
						flex: 1,
						bodyPadding: 5,
						border: 0,
						padding: '0 0 5px 0',
						layoutConfig: {
							align: 'stretch',
							pack: 'start',
						},
						items: [
							me.propertyGrid = Ext.create('Keysystems.Controls.SettingsGrid',
								{
									onPropertyChanged: () => me.btnSave.setDisabled(!me.propertyGrid.getChanges().length),
									onSelectionChanged: (sels) => {
										const valid =  sels && sels.length> 0;
										me.btnCopyPropName.setDisabled(!valid);
										me.btnShowPropJournal.setDisabled(!valid);

										if (valid) me.propertyGridToolbar.restoreTooltips();
									}
								})
						]

					})
				]
			}),

		]
		me.bodyPanel.addDocked([me.propertyGridToolbar = me.createPropertyGridToolbar()]);
		me.treePanel.addDocked([me.createSearchPanel()]);
		me.callParent(arguments);
		me.on('afterrender', me.refresh.bind(me, me.code));
	},

	createSearchPanel: function () {
		let me = this;
		return me.searchField = Ext.create('Keysystems.Tree.SearchPanel', {
			treePanel: me.treePanel
		});
	},

	createPropertyGridToolbar: function () {
		const me = this;
		return Ext.create('Ext.toolbar.Toolbar', {
			items: [
				Ext.create('Ext.Button', {
					iconCls: 'x_btn_subtotal',
					tooltip: 'По категориям',
					tooltipType: 'title',
					toggleGroup: "mode",
					allowDepress: false,
					pressed: true,
					handler: function () {
						me.propertyGrid.switchGrouping(this.pressed);
					}
				}),
				Ext.create('Ext.Button', {
					iconCls: 'x_btn_sort_a-z',
					tooltip: 'В алфавитном порядке',
					tooltipType: 'title',
					toggleGroup: "mode",
					allowDepress: false,
					handler: function () {
						me.propertyGrid.switchGrouping(!this.pressed);
					}
				}),
				me.btnCopyPropName = Ext.create('Ext.Button', {
					iconCls: 'x_btn_copy',
					tooltip: 'Копировать наименование',
					tooltipType: 'title',
					handler: function () {
						const item = me.propertyGrid.getFrstSelect();
						if (!item) return;
						
						ajaxRequest({
							url: 'SSettings/GetObjPath_A',
							params: {objCode: item.data.ObjCode},
							success: function (res) {
								const path = res + ' - ' + (item.data.Name.indexOf("* ") === 0 ? item.data.Name.substring(2) : item.data.Name);
								copyTextToClipboard({text: path, showToast: true});
							}
						});
					}
				}),
				Ext.create('Ext.Button', {
					iconCls: 'x_btn_export',
					tooltip: 'Выгрузка настроек',
					tooltipType: 'title',
					handler: function () {
						const selectedObj = me.treePanel.getFrstSelect();
						if (!selectedObj) return;

						const loadMask = new Ext.LoadMask({
							msg: KS.L10n.settings_exporting,
							target: me.bodyPanel,
							autoShow: true,
							rid: ajaxRequest({
								url: 'SSettings/Export_A',
								params: {objCode: selectedObj.get('CODE')},
								success: function (res) {
									if (!res) {
										warning(KS.L10n.no_export_data);
										return;
									}
									ChooseBox.ShowHTMLLog({
										text: `<pre>${res}</pre>`,
										title: 'Настройки',
										noPreStyle: true,
									});
								},
								callback: () => loadMask.destroy()
							})
						});
					}
				}),
				me.btnShowPropJournal = Ext.create('Ext.Button', {
					iconCls: 'x_btn_journal',
					tooltip: 'Журнал событий',
					tooltipType: 'title',
					handler: function () {
						const item = me.propertyGrid.getFrstSelect();
						if (!item) return;

						const loadMask = new Ext.LoadMask({
							msg: KS.L10n.loading_data,
							target: me.bodyPanel,
							autoShow: true,
							rid: ajaxRequest({
								url: 'data/DetailEventsLog_A',
								params: {
									code: item.data.ObjCode,
									links: [0],
									eventsObject: 'DOCUMENTS_SYS_EVENTS_NASTR',
									eventsProp: item.data.Code
								},
								success: function (res) {
									showDetailEventsLog.call(me, {
										html: res,
										modal: true,
										title: "Детализация"
									});
								},
								callback: () => loadMask.destroy()
							})
						});
					}
				})]
		});
	},

	/**
	 * Обновить данные грида свойств объектов
	 * @param objCode {string} код объекта
	 * @param user {int} идентификатор пользователя
	 * */
	refreshPropGrid: function (objCode, user) {
		let me = this;
		me.getPropValue(objCode, user, function (items) {
			/* с сервера получаем структуру: {
				data: данные со значениями настроек			
				adm: [1 - user может менять настройки других пользователей/ 0 - user может менять только свои настройки]
				user: пользователь, для которого получены настройки }
			*/
			let isAdmin = items.adm === 1;
			me.cmbUsers.setDisabled(!isAdmin);
			if (!isAdmin) {
				me.cmbUsers.setValue(items.user);
			}

			me.setLoading(KS.L10n.settings_loading);
			me.propertyGrid.loadData(items.data, items.user);
			me.setLoading(false);
		});
	},
	//#region получение и построение дерева объектов

	appendData: function (r) {
		let me = this;
		r.children = me.genData(r.LINK);
		r.leaf = !r.children.length;

		if (r.IMAGE_N !== 'FOLDER') r.iconCls = 'x_btn_' + r.IMAGE_N.toLowerCase() + ' x_btn_' + r.IMAGE_N.toUpperCase();
	},

	genData: function (rootId) {
		let me = this,
			res = ArrayLib.filter(me.data, ['LINK_SELF'], rootId);
		Ext.each(res, me.appendData, me);
		return res;
	},

	refresh: function (code) {
		let me = this;
		const loadMask = new Ext.LoadMask({
			msg: KS.L10n.objects_tree_loading,
			target: me.treePanel,
			autoShow: true,
			rid: ajaxRequest({
				url: 'SSettings/GetTreeData_A',
				params: {code: code || null},
				success: function (result) {
					me.decimalData = result.decimalData;
					me.data = result.data;
					me.cmbUsers.loadData(result.users);
					me.cmbUsers.setValue(result.currentUserId);
					let linkSelected =  me.treePanel.getFrstSelect()?.get('LINK');
					me.treePanel.store.setRoot({expanded: true, children: me.genData(null)});					
					let selModel = me.treePanel.getSelectionModel();
					if (selModel){
						let selectedNode = linkSelected ? me.treePanel.getStore().findNode('LINK', linkSelected) : null;
						selModel.select(selectedNode ?? me.treePanel.store.root.firstChild);
						if (selectedNode) me.treePanel.expandPath(selectedNode.getPath());
					}
				},
				callback: function () {
					loadMask.destroy();
				}
			})
		});
	},

	//#endregion получение и построение дерева объектов

	//#region получение настроек по объекту

	getPropValue: function (objCode, user, callback) {
		let me = this,
			key = JSON.stringify({ObjCode: objCode, User: user ?? -1}),
			cache = me.settings;

		if (cache[key]) {
			callback(cache[key]);
		} else {
			const loadMask = new Ext.LoadMask({
				msg: KS.L10n.settings_loading,
				target: me.bodyPanel,
				autoShow: true,
				rid: ajaxRequest({
					url: 'SSettings/GetProps_A',
					params: {objList: [key]},
					success: function (result) {
						loadMask.destroy();

						const data = result[key];

						cache[key] = data;
						me.oldData = me.dataCollector(data);
						callback(data);

					},
					callback: function () {
						loadMask.destroy();
					}
				})
			});
		}
	},

	//#endregion получение настроек по объекту

	//#region сохранение

	dataCollector: function () {
		const key = this.getActiveKey();
		return JSON.stringify(this.settings[key]);
	},

	getActiveKey: function () {
		let me = this,
			selectedObj = me.treePanel.getFrstSelect();
		if (!selectedObj) {
			return null;
		}

		let objCode = selectedObj.get('CODE'),
			user = me.cmbUsers.getValue(),
			key = JSON.stringify({ObjCode: objCode, User: user});
		return key;
	},

	save: function (callback) {
		let me = this,
			key = me.getActiveKey(),
			arrChanges = this.propertyGrid.getChanges();
		if (!arrChanges.length) {
			if (callback) callback();
			return;
		}

		this.setLoading(KS.L10n.settings_saving);
		let settings = arrChanges.map(item => {
			let val = item.Value;
			if (item.ObjCode === 'NASTR_USE_EDS') {
				window.useEDS = val != 1;
			}			
			if (item.DataType === "COMBO" || item.DataType === "CASE") {
				const extV = JSON.parse(item.EditorTypeName);
				val = (+item.Value + 1) + '#' + extV.join('#');
			}

			if (item.DataType === "MCASE") {
				const options = JSON.parse(item.EditorTypeName);
				let ncheck = 0,
					res = '';

				Ext.each(options, function (option, i) {
					option.Value = item.Value.indexOf(i) !== -1;
					if (i < 32 && option.Value) ncheck |= 1 << i;
					res += "#" + option.Text;
				});
				val = ncheck + res;
			}

			if (item.Code.indexOf("_COLOR") >= 0) {
				//для настроек цвета выполняем обратное преобразование вида [rgb(x,y,z)->x,y,z] для совместимости с win
				let formatValueToRgb = (val) => {
					let m = val.match(/\d{1,3},\s?\d{1,3},\s?\d{1,3}/);
					return m && m.length ? m[0] : val;
				}
				if (item.Code.lastIndexOf('_COLOR') === (item.Code.length - 6)) {
					val = formatValueToRgb(val);
				} else if (item.Code === 'NASTR_COLOR_RISK_MIN' || item.Code === 'NASTR_COLOR_RISK_AVERAGE' || item.Code === 'NASTR_COLOR_RISK_MAX') {
					let parts = val.split(';');
					if (parts.length) {
						let color = formatValueToRgb(parts[2]);
						if (color) val = parts[0] + ';' + parts[1] + ';' + color;
					}
				}
			}

			return {
				Value: val,
				ObjCode: item.ObjCode,
				PropCode: item.Code,
				User: me.cmbUsers.getValue(),
				IsRefer: false
			}
		});

		console.log('Сохранение настроек ');
		console.log(settings);

		ajaxRequest({
			url: '/SSettings/SaveSettings_A',
			params: {settingsList: JSON.stringify(settings)},
			success: function (result) {
				me.setLoading(false);
				if (!result) {// || !result.saved
					console.warn('Не удалось сохранить настройки ');
					return false;
				}
				QuickMsgs.save();

				me.propertyGrid.storeChanges();
				me.settings[key].data = me.propertyGrid.store.getDataExt();
				me.btnSave.setDisabled(true);

				me.oldData = me.dataCollector();
				console.log('Сохранение настроек выполнено успешно');
				if (callback) callback();
			},
			failure: function (response) {
				LoadMask.hide();
				console.error("Error", response.responseText);
			}
		});
	},

	cancel: function (callback) {
		let me = this,
			arrChanges = me.propertyGrid.getChanges();
		if (!arrChanges.length) {
			if (callback) callback();
			return;
		}
		me.propertyGrid.cancelChanges();
		me.settings[me.getActiveKey()].data = me.propertyGrid.store.getDataExt();
		if (callback) callback();
	},

	//#endregion сохранение
});

window.Settings = {
	showBtns: function () {
		NavigatorLib.hideSettings = false;
		NavigatorLib.settingsBtns.show();
	},

	show: function (code, title) {
		let parentView = window.tabView,
			tabID = 'SETTINGS' + (code ? '_' + code : '');
		if (parentView && code) {
			let tab = parentView.items.items.filter(item => item.tabID === tabID)[0];
			if (tab) {
				tab.show();
				return;
			}
		}

		let ps = Ext.create('Keysystems.Panel.Settings', {
			flex: 1,
			code: code,
			settings: this.settingsTable
		});
		let view = Ext.create('Ext.panel.Panel',
			{
				border: 0,
				closable: true,
				tabID: tabID,
				code: code,
				title: title || 'Настройки объектов',
				iconCls: 'x_btn_settings',
				autoScroll: true,
				layout: {type: 'vbox', pack: 'start', align: 'stretch'},
				items: ps,
				checkChanges: true,
				listeners: {
					beforeclose: function () {
						let me = this;
						if (!me.checkChanges) return true;

						let arrChanges = ps.propertyGrid.getChanges();
						if (arrChanges.length) {
							Ext.Msg.show({
								title: KS.L10n.attention,
								msg: KS.L10n.saveChanges,
								buttons: Ext.MessageBox.YESNOCANCEL,
								fn: function (buttonId) {
									if (buttonId === 'yes') {
										ps.save(() => {
											me.checkChanges = false;
											me.close();
										});
									}
									if (buttonId === 'no') {
										ps.cancel(() => {
											me.checkChanges = false;
											me.close();
										});
									}

								},
								icon: Ext.MessageBox.QUESTION
							});
							return false;
						}
						return true;
					}
				}
			});

		let tab = window.tabView.add(view);
		if (tab && window.tabView.setActiveTab) window.tabView.setActiveTab(tab);

		view.show(window.tabView);
		view.updateLayout();
	},

	settingsTable: {},

	//[{ Value, ObjCode, PropCode, User, IsRefer }]
	setValue: function (objList) {
		return new Promise(function (resolve, reject) {
			ajaxRequest({
				url: 'SSettings/SetValue_A',
				params: {objList: JSON.stringify(objList)},
				success: function (res) {
					QuickMsgs.save();
					resolve(res);
				},
				failure: function (r) {
					reject('error', r);
				}
			});
		});
	},

	//[{ ObjCode, PropCode, User, IsRefer }]
	getValue: function (objList) {
		var st = this.settingsTable;

		return new Promise(function (resolve, reject) {
			var arr = [];

			Ext.each(objList, function (obj) {
				var k = JSON.stringify(obj);
				if (st[k]) {
					obj.value = st[k];
				} else {
					arr.push(obj);
				}
			});

			if (arr.length) {
				var sarr = [];
				Ext.each(arr, function (obj) {
					sarr.push(JSON.stringify(obj));
				});
				ajaxRequest({
					url: 'SSettings/GetValue_A',
					params: {objList: sarr},
					success: function (res) {
						Ext.each(res, function (v, i) {
							arr[i].value = st[sarr[i]] = v;
						});
						resolve(objList);
					},
					failure: function (r) {
						reject(st, ['error', arr, r]);
					}
				});
			} else {
				resolve(objList);
			}
		});
	},

	getVfaSWork: function (setts, callback) {
		Settings.getValue([
			{ObjCode: 'NASTR_VFA', PropCode: 'NASTR_VFA_SWORK', User: 0, IsRefer: true}
		]).then(function (r) {
			setts.SWorks = r[0].value;
			callback(setts);
		});
	},

	getAutoSignSDolg: function (signDolgs) {
		var objList = [],

			//Director
			dolg = KsLib.getKeyByValue(miscTypes.AutoSignMethod, 'Руководитель');
		if ((signDolgs & dolg) == dolg) {
			objList.push({ObjCode: 'DICTIONARY_SDOLG', PropCode: 'NASTR_DOLG_DIRECTOR', User: 0, IsRefer: true});
		}

		//Zamestitel
		dolg = KsLib.getKeyByValue(miscTypes.AutoSignMethod, 'Заместитель');
		if ((signDolgs & dolg) == dolg) {
			objList.push({ObjCode: 'DICTIONARY_SDOLG', PropCode: 'NASTR_DOLG_ZAMESTITEL', User: 0, IsRefer: true});
		}

		//RukOtdel
		dolg = KsLib.getKeyByValue(miscTypes.AutoSignMethod, 'Руководитель подразделения');
		if ((signDolgs & dolg) == dolg) {
			objList.push({ObjCode: 'DICTIONARY_SDOLG', PropCode: 'NASTR_DOLG_RUKOTDEL', User: 0, IsRefer: true});
		}

		//RukReviz
		dolg = KsLib.getKeyByValue(miscTypes.AutoSignMethod, 'Руководитель группы');
		if ((signDolgs & dolg) == dolg) {
			objList.push({ObjCode: 'DICTIONARY_SDOLG', PropCode: 'NASTR_DOLG_RUKREVIZ', User: 0, IsRefer: true});
		}

		//ZamRukOtdela
		dolg = KsLib.getKeyByValue(miscTypes.AutoSignMethod, 'Заместитель руководителя подразделения');
		if ((signDolgs & dolg) == dolg) {
			objList.push({ObjCode: 'DICTIONARY_SDOLG', PropCode: 'NASTR_DOLG_ZAM_RUK_OTDELA', User: 0, IsRefer: true});
		}

		return new Promise(function (resolve) {
			Settings.getValue(objList).then(function (r) {
				var res = [];
				Ext.each(r, function (d) {
					res = res.concat(d.value);
				});
				resolve(res);
			}, function () {
				resolve([]);
			});
		});
	}
};