﻿Ext.define('Keysystems.Row.Status.Edit', {
	extend: 'Keysystems.Base.Edit',
	title: 'Статус',
	f: 'new',
	width: 600,
	_arr: ['INITIAL', 'READ_ONLY', 'MAIL_CURRENT_USER', 'MAIL_FORMULA', 'LAST_STATUS', 'TYPE', 'PREVIOUS_STATUS'],
	ignoreWA: {},

	constructor: function(cfg) {
		var me = this;
		Ext.apply(me, cfg);
		me.callParent(arguments);
	},

	createItems: function() {
		var me = this,
			objs = me.objs;

		return objs.items = [
			Ext.create('Ext.form.FieldContainer', {
				layout: { type: 'hbox', align: 'stretch' },
				items: [
					objs.S_STATUS = Ext.create('Ext.form.field.ComboBox', {
						editable: false,
						labelWidth: me.labelWidth,
						ksAllowEmpty: true,
						fieldLabel: 'Статус',
						queryMode: 'local',
						displayField: CBDataLib.displayField,
						valueField: CBDataLib.valueField,
						store: objs.sStatusStore = Ext.create('Ext.data.Store', {
							fields: CBDataLib.getFields(),
							data: [],
							proxy: 'memory'
						})
					}),
					'->',
					objs.INITIAL = Ext.create('Ext.form.field.Checkbox', {
						boxLabel: 'инициируюший',
						checked: false
					}),
					'->',
					objs.READ_ONLY = Ext.create('Ext.form.field.Checkbox', {
						boxLabel: 'запрет редактирования',
						checked: false,
						listeners: {
							change: function(th, v) {
								if (v) {
									objs.S_GRAND_USERS.setDisabled(false);
								} else {
									objs.S_GRAND_USERS.setValue();
									objs.S_GRAND_USERS.setDisabled(true);
								}
							}
						}
					})
				]
			}),
			objs.STATUSOBJP = Ext.create('Keysystems.Controls.Dict.Edit', {
				labelWidth: me.labelWidth,
				fieldLabel: 'Предыдущие',
				mode: 'MULTI',
				handler: function() { me.statusObjectDictFunc('STATUSOBJP'); }
			}),
			objs.STATUSOBJC = Ext.create('Keysystems.Controls.Dict.Edit', {
				labelWidth: me.labelWidth,
				fieldLabel: 'Следующие',
				mode: 'MULTI',
				handler: function() { me.statusObjectDictFunc('STATUSOBJC'); }
			}),
			objs.S_USERS = Ext.create('Keysystems.Controls.Dict.Edit', {
				fieldLabel: 'Пользователи',
				labelWidth: me.labelWidth,
				mode: 'MULTI',
				handler: function() {
					dictFunc({
						mode: 'MULTI',
						fieldLink: 'UID',
						parentView: objs.view,
						whereArgs: {
							IncludeGroups: { value: 'True', type: 'bool' },
							MarkBusy: { value: 'False', type: 'bool' },
							IgnoreHierarchy: { value: 'False', type: 'bool' }
						},
						selectLinks: objs.S_USERS.getValue(),
						code: dnl.S_LOGIN,
						readOnly: objs.S_USERS.readOnly,
						control: objs.S_USERS,
						contextSearch: objs.S_USERS.contextSearch
					}, { ok: function(value) { objs.S_USERS.setValue(value); } });
				}
			}),
			Ext.create('Ext.form.FieldContainer', {
				layout: { type: 'hbox', align: 'stretch' },
				fieldLabel: 'Оповещение по e-mail',
				labelWidth: me.labelWidth,
				items: [
					objs.STATUSOBJMAIL = Ext.create('Keysystems.Controls.Dict.Edit', {
						flex: 1,
						hidden: !!me.data.data.MAIL_FORMULA,
						handler: function() {
							dictFunc({
								mode: 'SINGLE',
								fieldLink: 'UID',
								parentView: objs.view,
								whereArgs: {
									IncludeGroups: { value: 'True', type: 'bool' },
									MarkBusy: { value: 'False', type: 'bool' },
									IgnoreHierarchy: { value: 'False', type: 'bool' }
								},
								selectLinks: objs.STATUSOBJMAIL.getValue(),
								code: dnl.S_LOGIN,
								readOnly: objs.STATUSOBJMAIL.readOnly,
								control: objs.STATUSOBJMAIL,
								contextSearch: objs.STATUSOBJMAIL.contextSearch
							}, { ok: function(value) { objs.STATUSOBJMAIL.setValue(value); } });
						}
					}),
					objs.MAIL_FORMULA = Ext.create('Keysystems.Controls.Formula.Edit', {
						flex: 1,
						hidden: (!me.data.data.MAIL_FORMULA),
						ksAllowEmpty: true
					}),
					objs.FORMULA = Ext.create('Ext.form.field.Checkbox', {
						boxLabel: 'Формула',
						checked: !!me.data.data.MAIL_FORMULA,
						padding: '0 0 0 10',
						listeners: {
							change: function(th1, newValue) {
								objs.STATUSOBJMAIL.setVisible(!newValue);
								objs.MAIL_FORMULA.setVisible(newValue);
							}
						}
					})
				]
			}),
			Ext.create('Ext.form.FieldContainer', {
				layout: 'hbox',
				items: [
					objs.MAIL_CURRENT_USER = Ext.create('Ext.form.field.Checkbox', {
						boxLabel: 'инициатору',
						checked: false,
						padding: '0 0 0 ' + (me.labelWidth + 5)
					}),
					objs.LAST_STATUS = Ext.create('Ext.form.field.Checkbox', {
						boxLabel: 'конечный статус',
						checked: false,
						padding: '0 0 0 20'
					})
				]
			}),
			objs.S_GRAND_USERS = Ext.create('Keysystems.Controls.Dict.Edit', {
				fieldLabel: 'Исключение на запрет редактирования',
				labelWidth: me.labelWidth,
				disabled: true,
				mode: 'MULTI',
				handler: function () {
					dictFunc({
						mode: 'MULTI',
						fieldLink: 'UID',
						parentView: objs.view,
						whereArgs: {
							IncludeGroups: { value: 'True', type: 'bool' },
							MarkBusy: { value: 'False', type: 'bool' },
							IgnoreHierarchy: { value: 'False', type: 'bool' }
						},
						selectLinks: objs.S_GRAND_USERS.getValue(),
						code: dnl.S_LOGIN,
						readOnly: objs.S_GRAND_USERS.readOnly,
						control: objs.S_GRAND_USERS,
						contextSearch: objs.S_GRAND_USERS.contextSearch
					}, { ok: function (value) { objs.S_GRAND_USERS.setValue(value); } });
				}
			}),
			objs.IGNORE_CONSTRAINTS = Ext.create('Keysystems.Controls.Dict.Edit', {
				fieldLabel: 'Исключаемые виды документов',
				labelWidth: me.labelWidth,
				hidden: me.dictIgnoreHidden,
				mode: 'MULTI',
				clear: function () {
					this._setValue();
					me.dictIgnore = [];
				},
				_setValue: function (value) {
					this.setValue(value);
				},
				handler: function() {
					dictFunc({
							mode: 'MULTI',
							parentView: objs.view,
							whereArgs: me.ignoreWA,
							selectLinks: objs.IGNORE_CONSTRAINTS.getValue(),
							code: me.planMod ? dnl.S_MOSNOV : dnl.S_DOCVID,
							readOnly: objs.IGNORE_CONSTRAINTS.readOnly,
							control: objs.IGNORE_CONSTRAINTS,
							contextSearch: objs.IGNORE_CONSTRAINTS.contextSearch
						},
						{
							ok: function(value) {
								objs.IGNORE_CONSTRAINTS.setValue(value);
								me.dictIgnore = value;
							}
						});
				}
			}),
			Ext.create('Ext.form.FieldContainer', {
				layout: 'hbox',
				items: [
					objs.TYPE = Ext.create('Keysystems.Controls.DocVid.Type', {
						labelWidth: me.labelWidth,
						fieldLabel: '',
						padding: '0 0 0 ' + (me.labelWidth + 5),
						inOutChange: Ext.emptyFn
					}),
					objs.PREVIOUS_STATUS = Ext.create('Ext.form.field.Checkbox', {
						boxLabel: 'предыдущий по статусу',
						checked: false,
						padding: '0 0 0 5'
					})
				]
			})
		];
	},

	//конфигурация основого окна
	viewCfg: function() {
		var result = this.callParent(arguments);
		result.width = this.width;
		return result;
	},

	loadData: function() {
		var me = this,
			objs = me.objs,
			data = me.data ? me.data.data : {};

		objs.sStatusStore.loadData(me.statusData, false);
		if (objs.sStatusStore.findRecord('index', data.S_STATUS)) {
			objs.S_STATUS.setValue(data.S_STATUS);
		} else {
			objs.S_STATUS.setValue((me.statusData[0] || {}).index);
		}

		Ext.each(me._arr, function(key) { objs[key].setValue(data[key]); });

		objs.STATUSOBJP.setValue(me.statusObjP);
		objs.STATUSOBJC.setValue(me.statusObjC);
		objs.STATUSOBJMAIL.setValue(me.mail);
		objs.S_USERS.setValue(me.users);
		objs.S_GRAND_USERS.setValue(me.grantUsers);

		if (me.planMod) {
			objs.IGNORE_CONSTRAINTS.fieldLabel = 'Исключаемые основания изменений';
			me.ignoreWA = { OsnovType: { value: 'PlanRevizOsnov', type: 'OsnovType' } };
		}
		if (me.dictIgnore) {
			objs.IGNORE_CONSTRAINTS.setValue(me.dictIgnore);
		}

		me.callParent(arguments);
	},

	loadNewData: function() {
		var me = this,
			objs = me.objs;
		if (objs.STATUSOBJP.isEmpty()) objs.INITIAL.setValue(true);
		me.callParent(arguments);
	},

	dataCollector: function() {
		var me = this,
			objs = me.objs,
			data = me.callParent(arguments);

		data.S_STATUS = objs.S_STATUS.getValue();
		data.STATUSOBJP = objs.STATUSOBJP.getCodeNameValue();
		data.STATUSOBJC = objs.STATUSOBJC.getCodeNameValue();
		data.STATUSOBJMAIL = objs.STATUSOBJMAIL.getValue();
		data.S_USERS = objs.S_USERS.getValue();
		data.S_GRAND_USERS = objs.S_GRAND_USERS.getValue();
		Ext.each(me._arr, function(key) { data[key] = objs[key].getValue(); });
		if (me.dictIgnore) {
			data.dictIgnore = me.dictIgnore;
		}

		return data;
	},

	statusObjectDictFunc: function(key) {
		var me = this,
			objs = me.objs,
			limitLinks = [];

		dictFunc({
			mode: 'MULTI',
			parentView: objs.view,
			btnsHide: { new: true, same: true, delete: true, add_slave: true, make_child: true, make_parent: true },
			selectLinks: objs[key].getValue(),
			code: dnl.S_STATUS,
			accessReadOnly: true,
			control: objs[key],
			contextSearch: objs[key].contextSearch
		}, {
			ok: function(value) { objs[key].setValue(value); },
			getData: function(endFunc, commonData) {
				let contextLinks = [];
				if (commonData.data && commonData.data.data.length) {
					Ext.each(commonData.data.data, d => {
						contextLinks.push(d.LINK);
					});

					limitLinks = contextLinks;
				}
				me.getStatusObjectShema(function(shema) {
					let statusData = me.getStatusObjectData(objs.link),
						data = contextLinks.length
							? statusData.filter(d => { return contextLinks.indexOf(d.LINK) !== -1; })
							: statusData;
					
					data = JSON.parse(JSON.stringify(data));
					shema = JSON.parse(JSON.stringify(shema));
					shema.data = { data: data, total: data.length };
					endFunc(shema);
				});
			},
			refresh: function(endFunc) {
				let statusData = me.getStatusObjectData(objs.link),
					data = limitLinks.length
						? statusData.filter(d => { return limitLinks.indexOf(d.LINK) !== -1; })
						: statusData;

				data = JSON.parse(JSON.stringify(data));
				endFunc({ data: data, total: data.length });
			}
		});
	},

	isFilled: function() {
		var me = this,
			objs = me.objs;
		let res = true;
		if (objs.S_STATUS.getValue() === null) {			
			me.addToInvalidControls(objs.S_STATUS);
			res = false;
		}

		if (objs.STATUSOBJP.isEmpty() && !objs.INITIAL.getValue()) {
			me.errorMessages.push(wmc.get('NoInitiatingStatus'));
		}

		if ((me.objs.FORMULA.getValue()) && (me.objs.MAIL_FORMULA.getValue() == '')) {
			res = false;
			me.addToInvalidControls(me.objs.MAIL_FORMULA, {title: 'Оповещение по e-mail'});
		}

		return res;
	}
})