﻿Ext.define('Keysystems.Row.RevizOkp.Edit', {
	extend: 'Keysystems.Base.Edit',
	title: 'Проверенная продукция',
	config: {
		f: 'new', // 'new'/'copy'/'edit'
		data: _,
		refreshFunc: _,
		parentView: _,
		TypeTransport: [],
		code: '',
		inputDicts: [],
		labelWidth: 150,
		width: 700,
		okFunc: _,
		personWhere: [],
		bodyPadding: 10
	},

	readOnlyList: [
		'TYPE', 'S_TN_VED', 'S_OKEI', 'COUNT', 'S_TRANSPORT', 'COUNT_TRANSPORT', 'S_TYPECARGO', 'S_PERSONP'
	],

	createItems: function() {
		var me = this,
			objs = me.objs,
			items = [
				objs.TYPE = Ext.create('Keysystems.Controls.ComboBoxExtra', {
					labelWidth: me.labelWidth,
					maxWidth: me.labelWidth * 2,
					editable: false,
					queryMode: 'local',
					fieldLabel: 'Перевозки',
					displayField: 'text',
					valueField: 'value',
					store: Ext.create('Ext.data.Store', {
						fields: [{ name: 'value', type: 'int', useNull: true }, 'text'],
						data: [],
						proxy: 'memory'
					})
				}),
				me.createDictEdit({
					key: 'S_TN_VED',
					mode: 'SINGL',
					code: dnl.S_TN_VED,
					fieldLabel: 'Наименование'
				}),
				me.createDictEdit({
					key: 'S_OKEI',
					mode: 'SINGL',
					code: dnl.S_OKEI,
					fieldLabel: 'Еденица измерения'
				}),
				objs.COUNT = Ext.create('Ext.form.field.Number', {
					fieldLabel: 'Количество',
					maxWidth: me.labelWidth * 2,
					labelWidth: me.labelWidth,
					minValue: 0
				}),
				me.createDictEdit({
					key: 'S_TRANSPORT',
					mode: 'SINGL',
					code: dnl.S_TRANSPORT,
					fieldLabel: 'Вид транспорта'
				}),
				objs.COUNT_TRANSPORT = Ext.create('Ext.form.field.Number', {
					fieldLabel: 'Количество ТС',
					labelWidth: me.labelWidth,
					maxWidth: me.labelWidth * 2,
					minValue: 0
				}),
				me.createDictEdit({
					key: 'S_TYPECARGO',
					mode: 'SINGL',
					code: dnl.S_TYPECARGO,
					fieldLabel: 'Типы грузов'
				}),
				me.createDictEdit({
					key: 'S_PERSONP',
					mode: 'SINGL',
					code: dnl.S_PERSON,
					fieldLabel: 'Проверил',
					initWhereArgs: function() {
						return {
							InLinks: {
								value: JSON.stringify(me.personWhere),
								type: 'List_int'
							},
							InLinksOnly: {
								value: 'True',
								type: 'bool'
							},
							HasFilterOnLoad: {
								value: 'False',
								type: 'bool'
							}
						};
					}
				})
			];

		return objs.items = items;
	},
	dataCollector: function() {
		var me = this,
			objs = me.objs;

		var data = me.callParent(arguments);
		data.TYPE = objs.TYPE.getValue();
		data.S_TN_VED = objs.S_TN_VED.getLink();
		data.S_OKEI = objs.S_OKEI.getLink();
		data.COUNT = objs.COUNT.getValue();
		data.COUNT_TRANSPORT = objs.COUNT_TRANSPORT.getValue();
		data.S_PERSONP = objs.S_PERSONP.getLink();
		data.S_TRANSPORT = objs.S_TRANSPORT.getLink();
		data.S_TYPECARGO = objs.S_TYPECARGO.getLink();
		data.LINK = me.getLink();

		return data;
	},

	saveData: function(endFunc) {
		var me = this,
			objs = me.objs,
			res = {},
			tmp,
			row;

		if (me.okFunc)
			res = me.okFunc(me.dataCollector());
		if (endFunc)
			endFunc();

		row = res;

		Ext.each(['S_OKEI', 'S_TN_VED', 'S_TRANSPORT', 'S_TYPECARGO'], function(key) {
			tmp = objs[key].getValue()[0];
			if (tmp) {
				row['TEMP_' + key.replace(/_/g, '') + '_CODE'] = tmp.data.CODE;
				row['TEMP_' + key.replace(/_/g, '') + '_NAME'] = tmp.data.NAME;
			}
		});

		tmp = objs['S_PERSONP'].getValue()[0];
		if (tmp) {
			row['TEMP_SPERSONP_CODE'] = tmp.data.CODE;
			row['TEMP_SPERSONP_FIO'] = tmp.data.NAME;
			row['FIRSTNAME'] = tmp.data.FIRSTNAME;
			row['LASTNAME'] = tmp.data.LASTNAME;
			row['PATRONYMIC'] = tmp.data.PATRONYMIC;
		}

		me.successSaveFunc({
			result: true,
			row: row,
			SavedLink: res.LINK
		}, null, {});

		me.oldData = JSON.stringify(me.dataCollector());
	},

	isFilled: function() { return true; },

	loadCopyEditData: function() {
		var me = this,
			objs = me.objs,
			data = me.data.data,
			personData = {};
		Object.assign(personData, data);

		objs.link = data.LINK;
		objs.S_TN_VED.setValue([
			{
				data: {
					LINK: data.S_TN_VED,
					CODE: data.TEMP_STNVED_CODE,
					NAME: data.TEMP_STNVED_NAME
				}
			}
		]);
		objs.S_OKEI.setValue([
			{
				data: {
					LINK: data.S_OKEI,
					CODE: data.TEMP_SOKEI_CODE,
					NAME: data.TEMP_SOKEI_NAME
				}
			}
		]);
		objs.COUNT.setValue(data.COUNT);
		objs.COUNT_TRANSPORT.setValue(data.COUNT_TRANSPORT);
		
		personData.LINK = data.S_PERSONP;
		personData.CODE = data.TEMP_SPERSONP_CODE;
		objs.S_PERSONP.setValue(personData);
	},
	loadNewData: function() {
		this.objs.TYPE.store.loadData(this.TypeTransport, false);
		this.objs.TYPE.setValue(null);
	},
	getExtra: function(endFunc) {
		var me = this,
			data = me.data && me.data.data || {},
			objs = me.objs;

		me.baseGetExtra({
			sTransport: data.S_TRANSPORT || 0,
			sTypeCargo: data.S_TYPECARGO || 0,
			needType: !me.TypeTransport
		}, function(value) {
			objs.S_TRANSPORT.setValue(value.sTransport);
			objs.S_TYPECARGO.setValue(value.sTypeCargo);
			if (value.TypeTransport) me.TypeTransport = value.TypeTransport;
			objs.TYPE.store.loadData(me.TypeTransport, false);
			objs.TYPE.setValue(data.TYPE);

			if (endFunc) {
				endFunc();
			}
		}, 'SReviz/GetRowRevizOkpExtra_A');
	}
});