﻿Ext.define('Keysystems.Row.RevizDoc.Edit', {
	extend: 'Keysystems.Base.Edit',
	title: 'Проверенный документ',
	isFileBtn: true,
	fieldName: 'NUMBER',
	config: {
		f: 'new', // 'new'/'copy'/'edit'
		data: undefined,
		refreshFunc: undefined,
		parentView: undefined,
		code: '',
		inputDicts: [],
		labelWidth: 150,
		width: 700,
		okFunc: undefined,
		bodyPadding: 10
	},
	readOnlyList: [
		'S_RDOC', 'NUMBER', 'DT'
	],

	createItems: function() {
		var me = this,
			objs = me.objs,
			items = [
				me.createDictEdit({
					key: 'S_RDOC',
					ksAllowEmpty: true,
					mode: 'SINGL',
					code: dnl.S_RDOC,
					fieldLabel: 'Вид документа'
				}),
				Ext.create('Ext.form.FieldContainer', {
					layout: 'hbox',
					items: [
						me.sksc('NUMBER', objs.NUMBER = Ext.create('Ext.form.field.Text', {
							labelWidth: me.labelWidth,
							fieldLabel: '№'
						})),
						me.sksc('DT', objs.DT = Ext.create('Ext.form.field.Date', {
							labelWidth: 20,
							fieldLabel: 'от',
							format: 'd.m.Y',
							padding: '0 0 0 10',
							minValue: '01.01.1900',
							maxValue: '31.12.2100',
							width: 130
						}))
					]
				})
			];

		return objs.items = items;
	},
	dataCollector: function() {
		var me = this,
			objs = me.objs,
			srdoc = objs.S_RDOC.getValue();

		var data = me.callParent([false]);
		data.LINK = objs.link;
		data.DT = objs.DT.getValue();
		data.NUMBER = objs.NUMBER.getValue();
		data.FILES = objs.fileData.FILES;
		data.TEMP_EXT = objs.fileData.TEMP_EXT;

		if (srdoc.length) {
			data.S_RDOC = srdoc[0].data.LINK;
			data.TEMP_SRDOC_CODE = srdoc[0].data.CODE;
			data.TEMP_SRDOC_NAME = srdoc[0].data.NAME;
		} else data.S_RDOC = 0;

		return data;
	},
	saveData: function(endFunc) {
		var me = this,
			res = {};

		if (me.okFunc)
			res = me.okFunc(me.dataCollector());
		if (endFunc)
			endFunc();

		me.successSaveFunc({
			result: true,
			row: res,
			SavedLink: res.LINK
		}, null, {});

		me.oldData = JSON.stringify(me.dataCollector());
	},
	isFilled: function() {
		const me = this;
		if (me.objs.S_RDOC.isEmpty()) {
			me.addToInvalidControls(me.objs.S_RDOC);
			return false;
		}
		return true;
	},
	loadNewData: function() {
		this.objs.fileData = { LINK: 0, FILES: 0, TEMP_EXT: '' };
		this.callParent(arguments);
	},

	//#region редактирование файла

	fileEdit: function() {
		var me = this;

		Ext.create('Keysystems.File', {
			iconCls: getExtStyle(me.objs.fileData[me.fieldExt]),
			createFile: function(callback) { me.createFile(me.getLink(), 0, callback); },
			updRecord: function(fileObj) { me.updFileRecord(fileObj); },
			getFileId: function() { return me.objs.fileData[me.fieldFile]; },
			downloadFile: function() { me.downloadFile(); },
			clearFile: function() { me.clearFile(); }
		});
	},
	clearFile: function() {
		var me = this,
			d = me.objs.fileData;

		d[me.fieldFile] = 0;
		me.objs.btnFile.setIconCls(getExtStyle(d[me.fieldExt] = ''));
	},
	updFileRecord: function(fileObj) {
		var me = this,
			d = me.objs.fileData;

		d[me.fieldFile] = fileObj.id;
		me.objs.btnFile.setIconCls(getExtStyle(d[me.fieldExt] = fileObj.ext));
	},
	downloadFile: function() {
		var me = this,
			d = me.objs.fileData;
		UploaderLib.getFile(d[me.fieldFile], me.objs[me.fieldName].getValue());
	},

	//#endregion редактирование файла

	loadCopyEditData: function() {
		var me = this,
			objs = me.objs,
			data = me.data.data;

		objs.link = data.LINK;
		objs.S_RDOC.setValue([
			{
				data: {
					LINK: data.S_RDOC,
					CODE: data.TEMP_SRDOC_CODE,
					NAME: data.TEMP_SRDOC_NAME
				}
			}
		]);
		objs.DT.setValue(data.DT);
		objs.NUMBER.setValue(data.NUMBER);
		objs.fileData = {
			LINK: 0,
			FILES: data.FILES,
			TEMP_EXT: data.TEMP_EXT
		};
		objs.btnFile.setIconCls(getExtStyle(data.TEMP_EXT));

		if (me.readOnly) me.setReadOnly(true);
		me.callParent(arguments);
	}
});