﻿Ext.define('Keysystems.Row.LandRights.Edit', {
	extend: 'Keysystems.Base.Edit',
	config: {
		f: 'new',
		data: undefined,
		//parentRecord: undefined,
		//refreshFunc: undefined,
		//parentView: undefined,
		//code: '',
		//inputDicts: [],
		//labelWidth: 150,
		width: 700,
		//okFunc: undefined,
		bodyPadding: 10
	},

	createItems: function() {
		var me = this,
			objs = me.objs,
			types = Ext.create('Ext.data.Store', {
				fields: ['val', 'name'],
				data: [{ "val": 4, "name": "ФЛ" }, { "val": 1, "name": "ЮЛ" }, { "val": 2, "name": "ИП" }]
			}),
			items = [
				objs.objsPanel = Ext.create('Ext.form.FieldContainer', {
					border: 0,
					layout: { type: 'hbox', align: 'stretch' },
					items: [
						Ext.create('Ext.form.Label', { 
							text: 'Тип:', 
							width: me.labelWidth, 
						}),
						objs.TYPECOMBO = Ext.create('Ext.form.field.ComboBox', {
							width: 50,
							editable: false,
							store: types,
							queryMode: 'local',
							displayField: 'name',
							valueField: 'val',
							fieldCls: 'ks-combo-text',
							margin: '0 5px 0 4px',
							ksAllowEmpty: true,
							listeners: {
								change: function(th, newValue, oldValue) {
									if (oldValue === 1) {
										objs.ЮЛ_ORG.setVisible(false);
										objs.ЮЛ_ORG.setValue({ data: { LINK: 0, CODE: '', NAME: '' } });
									} else if (oldValue === 2) {
										objs.ИП_ORG.setVisible(false);
										objs.ИП_ORG.setValue({ data: { LINK: 0, CODE: '', NAME: '' } });
									} else if (oldValue === 4) {
										objs.ФЛ_PERSON.setVisible(false);
										objs.ФЛ_PERSON.setValue({ data: { LINK: 0, SNAME: '' } });
									}
									var pnlNew = newValue === 1 ? objs.ЮЛ_ORG : newValue === 2 ? objs.ИП_ORG : newValue === 4 ? objs.ФЛ_PERSON : undefined;
									if (pnlNew) pnlNew.setVisible(true);
								}
							}
						}),
						objs.ЮЛ_ORG = me.createDictEdit({
							flex: 1,
							ksAllowEmpty: true,
							handler: function() {
								dictFunc({
									mode: 'SINGL',
									parentView: objs.view,
									selectLinks: objs.ЮЛ_ORG.getValue(),
									code: dnl.S_ORG,
									readOnly: me.readOnly,
									control: objs.ЮЛ_ORG,
									contextSearch: objs.ЮЛ_ORG.contextSearch,
									whereArgs: { NotSType: { value: me.ИП, type: 'List_int' } }
								}, {
									ok: function(value) { objs.ЮЛ_ORG.setValue(value); }
								});
							}
						}),
						objs.ИП_ORG = Ext.create('Keysystems.Controls.Dict.Edit', {
							flex: 1,
							ksAllowEmpty: true,
							hidden: true,
							handler: function() {
								dictFunc({
									mode: 'SINGL',
									parentView: objs.view,
									selectLinks: objs.ИП_ORG.getValue(),
									code: dnl.S_ORG,
									readOnly: me.readOnly,
									control: objs.ИП_ORG,
									contextSearch: objs.ИП_ORG.contextSearch,
									whereArgs: { SType: { value: me.ИП, type: 'List_int' } }
								}, {
									ok: function(value) { objs.ИП_ORG.setValue(value); }
								});
							}
						}),
						objs.ФЛ_PERSON = Ext.create('Keysystems.Controls.Dict.Edit', {
							flex: 1,
							hidden: true,
							nameField: "SNAME",
							ksAllowEmpty: true,
							code: dnl.S_PERSON,
							setValue: function(value) {
								let val = value && value.length ? value[0].data ?? value[0] : value;
								if (val) {
									val.SNAME = val.SNAME || val.NAME;
								}
								this.callParent(arguments);
							},
							handler: function() {
								dictFunc({
									mode: 'SINGL',
									parentView: objs.view,
									selectLinks: objs.ФЛ_PERSON.getValue(),
									code: dnl.S_PERSON,
									readOnly: me.readOnly,
									control: objs.ФЛ_PERSON,
									contextSearch: objs.ФЛ_PERSON.contextSearch
								}, {
									ok: function(value) { objs.ФЛ_PERSON.setValue(value); }
								});
							}
						})						
					],
				}),
				Ext.create('Ext.form.FieldContainer', {
					width: me.width,
					layout: 'hbox',
					border: 1,
					items: [
						objs.S_RTYPE = me.createDictEdit({
							mode: 'SINGL',
							code: dnl.S_RTYPE,
							labelWidth: me.labelWidth,
							fieldLabel: 'Вид права',
							flex: 1,
							ksSetValue: (value) => objs.S_RTYPE.setValue(value)
						}),						
						Ext.create('Ext.form.Label', { padding: '4 10 0 10', text: 'Размер доли в праве:' }),
						objs.CHISL = Ext.create('Ext.form.field.Text', { width: 50 }),
						Ext.create('Ext.form.Label', { padding: '4 2 0 2', text: '/' }),
						objs.ZNAM = Ext.create('Ext.form.field.Text', { width: 50 })
					]
				}),
				objs.DATEBEGIN = Ext.create('Ext.form.field.Date', {
					labelWidth: me.labelWidth,
					fieldLabel: 'Возникновение права',
					maxWidth: 100 + me.labelWidth
				}),
				objs.DATEREG = Ext.create('Ext.form.field.Date', {
					labelWidth: me.labelWidth,
					fieldLabel: 'Регистрация права',
					maxWidth: 100 + me.labelWidth
				}),
				objs.DATEEND = Ext.create('Ext.form.field.Date', {
					labelWidth: me.labelWidth,
					fieldLabel: 'Прекращение права',
					maxWidth: 100 + me.labelWidth
				})
			];

		return me.callParent([items]);
	},
	dataCollector: function() {
		var me = this,
			objs = me.objs,
			type = objs.TYPECOMBO.value,
			org = type === 1 || type === 2,
			dictObj = type === 1 ? objs.ЮЛ_ORG : type === 2 ? objs.ИП_ORG : objs.ФЛ_PERSON;

		var data = me.callParent([false]);
		data.LINK = objs.link;
		data.TEMP_TYPE = type;
		data.TEMP_TYPE_NAME = type === 1 ? "ЮЛ" : type === 2 ? "ИП" : "ФЛ";
		data.CHISL = objs.CHISL.getValue();
		data.ZNAM = objs.ZNAM.getValue();

		let links = dictObj.getValue();
		var dictData = links.length ? links[0].data : null;
		data.S_ORG = org && dictData ? dictData.LINK : 0;
		data.S_PERSON = org ? 0 : dictData ? dictData.LINK : 0;
		data.TEMP_INN = dictData ? dictData.INN : "";
		data.TEMP_CODE = dictData ? dictData.CODE : "";
		data.TEMP_NAME = org ? dictData ? dictData.NAME : "" : "";
		data.TEMP_SNAME = dictData ? dictData.SNAME : "";
		data.FIRSTNAME = !org && dictData ? dictData.FIRSTNAME : "";
		data.LASTNAME = !org && dictData ? dictData.LASTNAME : "";
		data.PATRONYMIC = !org && dictData ? dictData.PATRONYMIC : "";

		var empty = objs.S_RTYPE.isEmpty();
		data.S_RTYPE = empty ? 0 : objs.S_RTYPE.getLink();
		dictData = empty ? undefined : objs.S_RTYPE.getValue()[0].data;
		data.TEMP_RTYPE_CODE = empty ? "" : dictData.CODE;
		data.TEMP_RTYPE_NAME = empty ? "" : dictData.NAME;

		var dt = objs.DATEBEGIN.isValid() ? objs.DATEBEGIN.getValue() : null;
		data.DATE_BEGIN = dt ? dt.toDateString() : null;
		dt = objs.DATEREG.isValid() ? objs.DATEREG.getValue() : null;
		data.DATE_REG = dt ? dt.toDateString() : null;
		dt = objs.DATEEND.isValid() ? objs.DATEEND.getValue() : null;
		data.DATE_END = dt ? dt.toDateString() : null;
		return data;
	},
	saveData: function(endFunc) {
		var me = this,
			res = {};

		if (me.okFunc)
			res = me.okFunc(me.dataCollector());
		if (endFunc)
			endFunc();
		

		me.oldData = JSON.stringify(me.dataCollector());
	},

	isFilled: function() {
		var me = this,
			objs = me.objs;
		
		let res = false;
		const type = objs.TYPECOMBO.value;
		const dictObj = type === 1 ? objs.ЮЛ_ORG : type === 2 ? objs.ИП_ORG : objs.ФЛ_PERSON;
		if (dictObj.isEmpty()) {
			me.addToInvalidControls(dictObj, {title: 'Объект'});
			res = false;
		}
		if (!objs.CHISL.value || !objs.ZNAM.value) {
			me.addToInvalidControls(!objs.CHISL.value ? objs.CHISL : objs.ZNAM, {title: 'Размер доли в праве'});			
			res = false;
		}
		if (objs.CHISL.value > objs.ZNAM.value) {
			me.errorMessages.push('Числитель должен быть меньше знаменателя!');
		}
		return res;
	},

	loadNewData: function() {
		var me = this,
			objs = me.objs;
		me.callParent();
		objs.TYPECOMBO.setValue(1);
		objs.CHISL.setValue(1);
		objs.ZNAM.setValue(1);
	},

	baseGetExtra: function () { 
		this.afterGetExtra(); 
	},

	loadCopyEditData: function() {
		var me = this,
			objs = me.objs,
			data = me.data.data,
			personData = {};
		
		me.callParent();
		objs.S_RTYPE.setValue({ data: { LINK: data.S_RTYPE, CODE: data.TEMP_RTYPE_CODE, NAME: data.TEMP_RTYPE_NAME } })
		objs.CHISL.setValue(data.CHISL);
		objs.ZNAM.setValue(data.ZNAM);
		objs.DATEBEGIN.setValue(data.DATE_BEGIN);
		objs.DATEREG.setValue(data.DATE_REG);
		objs.DATEEND.setValue(data.DATE_END);

		var type = data.TEMP_TYPE;
		objs.TYPECOMBO.setValue(type);
		if (type == 4) {
			objs.ЮЛ_ORG.setVisible(false);
			Object.assign(personData, data);
			personData.LINK = data.S_PERSON;
			personData.CODE = data.TEMP_CODE;
			personData.SNAME = data.TEMP_SNAME;
			personData.INN = data.TEMP_INN;
			objs.ФЛ_PERSON.setValue(personData);
		} else {
			var dictOrg = type == 1 ? objs.ЮЛ_ORG : objs.ИП_ORG;
			(type == 1 ? objs.ИП_ORG : objs.ЮЛ_ORG).setVisible(false);
			dictOrg.setValue({ data: { LINK: data.S_ORG, CODE: data.TEMP_CODE, NAME: data.TEMP_NAME, SNAME: data.TEMP_NAME, INN: data.TEMP_INN } });
		}
	}
});