﻿Ext.define('Keysystems.Row.FactNarRem.Edit', {
	extend: 'Keysystems.Base.Edit',
	config: {
		f: 'new', // 'new'/'copy'/'edit'
		data: undefined,
		parentRecord: undefined,
		refreshFunc: undefined,
		parentView: undefined,
		code: '',
		inputDicts: [],
		labelWidth: 150,
		width: 700,
		okFunc: undefined,
		bodyPadding: 10
	},
	createItems: function() {
		var me = this,
			objs = me.objs,
			items = [
				Ext.create('Ext.form.FieldContainer', {
					layout: 'hbox',
					width: me.width,
					items: [
						objs.S_NAR = Ext.create('Keysystems.Controls.Dict.Edit', {
							labelWidth: me.labelWidth,
							codeWidth: 75,
							fieldLabel: 'Вид нарушения',
							disabled: true,
							flex: 1,
							handler: function() {
								dictFunc({
									mode: 'SINGL',
									parentView: objs.view,
									selectLinks: objs.S_NAR.getValue(),
									code: dnl.S_NAR
								}, {
									ok: function(value) {
										objs.S_NAR.setValue(value);
									}
								});
							}
						}),
						objs.S_NAR_NEW = Ext.create('Keysystems.Controls.Dict.Edit', {
							labelWidth: me.labelWidth,
							codeWidth: 75,
							fieldLabel: 'исправлено на',
							padding: '0 0 0 10',
							flex: 1,
							handler: function() {
								dictFunc({
									mode: 'SINGL',
									parentView: objs.view,
									selectLinks: objs.S_NAR_NEW.getValue(),
									code: dnl.S_NAR,
									control: objs.S_NAR_NEW,
									contextSearch: objs.S_NAR_NEW.contextSearch,
									initWhereArgs: function() {
										var wa = {};

										if (me.isDis) {
											wa.InLinksOnly = { value: true, type: 'bool' };
											wa.InLinks = { value: JSON.stringify(me.disLinks), type: 'List_int' };
										}
										return wa;
									}
								}, {
									ok: function(value) {
										objs.S_NAR_NEW.setValue(value);
									}
								});
							}
						})
					]
				}),
				Ext.create('Ext.form.FieldContainer', {
					layout: 'hbox',
					width: me.width,
					items: [
						objs.SUMMA = Ext.create('Keysystems.Controls.CalcField', {
							labelWidth: me.labelWidth,
							disabled: true,
							hidden: !me.isFinanc,
							flex: 1
						}),
						objs.SUMMA_NEW = Ext.create('Keysystems.Controls.CalcField', {
							labelWidth: me.labelWidth,
							fieldLabel: 'исправлено на',
							padding: '0 0 0 10',
							hidden: !me.isFinanc,
							flex: 1
						})
					]
				}),
				objs.NOTE = Ext.create('Ext.form.field.TextArea', {
					labelWidth: me.labelWidth,
					width: me.width,
					minHeight: 100,
					flex: 1,
					fieldLabel: 'Замечание'
				}),
				objs.DT = Ext.create('Ext.form.field.Date', {
					fieldLabel: 'Дата',
					format: 'd.m.Y',
					minValue: '01.01.1900',
					maxValue: '31.12.2100',
					labelWidth: me.labelWidth,
					maxWidth: me.labelWidth + 200,
					ksAllowEmpty: true
				})
			];

		return me.callParent([items]);
	},
	getExtra: function (callback) { callback && callback(); },
	dataCollector: function() {
		var me = this,
			objs = me.objs,
			sNar = objs.S_NAR.getValue(),
			sNarNew = objs.S_NAR_NEW.getValue();

		var data = me.callParent([false]);
		data.LINK = objs.link;
		data.SUMMA = objs.SUMMA.getValue();
		data.SUMMA_NEW = objs.SUMMA_NEW.getValue();
		data.NOTE = objs.NOTE.getValue();
		data.DT = objs.DT.getValue();

		data.S_NAR_NEW = sNarNew.length ? sNarNew[0].LINK || sNarNew[0].data.LINK : 0;
		data.S_NAR_NEW_CODE = sNarNew.length ? sNarNew[0].CODE || sNarNew[0].data.CODE : '';
		data.S_NAR_NEW_NAME = sNarNew.length ? sNarNew[0].NAME || sNarNew[0].data.NAME : '';

		data.S_NAR = sNar.length ? sNar[0].data.LINK : 0;
		data.S_NAR_CODE = sNar.length ? sNar[0].data.CODE : 0;
		data.S_NAR_NAME = sNar.length ? sNar[0].data.NAME : 0;
		return data;
	},
	isFilled: function () {
		var me = this,
			objs = me.objs;

		let res = true;
		if (!objs.S_NAR_NEW.getLink()) {
			me.addToInvalidControls(objs.S_NAR_NEW, {title: 'Вид нарушения'});
			res = false;
		} 
		if (!objs.DT.getValue()) {
			me.addToInvalidControls(objs.DT);
			res = false;
		}
		if (objs.S_NAR_NEW.getLink() === objs.S_NAR.getLink() &&
			(!objs.SUMMA.isVisible() || objs.SUMMA.getValue() === objs.SUMMA_NEW.getValue())) {
			if (objs.NOTE.isEmpty()) {
				me.addToInvalidControls(objs.NOTE);
				res = false;
			}			
			me.warningMessages.push('Нет исправлений!');			
		}
		if (objs.DT.getValue() < me.parentRecord.data.DTDETECT) {
			me.errorMessages.push('Дата замечания не может быть меньше даты совершения нарушения!');			
		}
		return res;
	},
	loadCopyEditData: function() {
		var me = this,
			objs = me.objs,
			data = me.data.data;
		objs.link = data.LINK;
		objs.S_NAR.setValue([
			{
				data: {
					LINK: data.S_NAR1,
					CODE: data.TEMP_SNAR1_CODE,
					NAME: data.TEMP_SNAR1_NAME
				}
			}]);
		objs.S_NAR_NEW.setValue([
			{
				data: {
					LINK: data.S_NAR2,
					CODE: data.TEMP_SNAR2_CODE,
					NAME: data.TEMP_SNAR2_NAME
				}
			}]);
		objs.SUMMA.setValue(data.SUMMA1);
		objs.SUMMA_NEW.setValue(data.SUMMA2);
		objs.NOTE.setValue(data.NOTE);
		objs.DT.setValue(data.DT);
	},
	loadNewData: function() {
		var me = this,
			objs = me.objs,
			rec = me.parentRecord;
		objs.S_NAR.setValue([
			{
				data: {
					LINK: rec.data.S_NAR,
					CODE: rec.data.TEMP_S_NAR_CODE,
					NAME: rec.data.TEMP_S_NAR_NAME
				}
			}]);
		objs.S_NAR_NEW.setValue([
			{
				data: {
					LINK: rec.data.S_NAR,
					CODE: rec.data.TEMP_S_NAR_CODE,
					NAME: rec.data.TEMP_S_NAR_NAME
				}
			}]);
		objs.SUMMA.setValue(rec.data.SUMMA);
		objs.SUMMA_NEW.setValue(rec.data.SUMMA);
		objs.DT.setValue(new Date());
	},
	//конфигурация основого окна
	viewCfg: function () {
		const result = this.callParent(arguments);
		result.resizable = true;
		result.maximizable = true;
		return result;
	},
});