﻿Ext.define('Keysystems.Row.Authority.Edit', {
	extend: 'Keysystems.Base.Edit',
	title: 'Полномочия',
	viewMinSize: [720, 300],
	bodyPadding: 0,
	hideControlBtn: true,
	f: 'edit',
	ignoreCheckStamp: true,
	needRemoveBusy: false,
	createItems: function () {
		var me = this,
			objs = me.objs;

		var items = [
			me.sksc('grid',
				Ext.create('Ext.tree.Panel',
					{
						flex: 1,
						border: 1,
						rootVisible: false,
						plugins: [
							Ext.create('Ext.grid.plugin.CellEditing',
								{
									clicksToEdit: 1,
									listeners: {
										beforeedit: function () {
											return !me.readOnly;
											if (!context.record.get('CHECKED')) return false;
										},
										edit: function () {
											me.enableTools();
										}
									}
								}),
							'gridclipboard'
						],

						features: [
							{
								ftype: 'summary',
								showSummaryRow: false
							}
						],
						store: Ext.create('Ext.data.TreeStore',
							{
								fields: [],
								proxy: 'memory',
								defaultRootText: '',
								rootNode: {expanded: true, children: []},
								sorters: ['CODE']
							}),
						columns: [],
						columnLines: true,
						lines: true,
						rowLines: true,
						listeners: {
							beforeedit: function (plugin, context) {
								if (!context.record.get('CHECKED')) return false;
							},

						},
					}))
		];

		return objs.items = items;
	},
	loadData: function () {
		var me = this;

		const loadMask = new Ext.LoadMask({
			msg: KS.L10n.loading_data,
			view: me.objs.view,
			autoShow: true,
			rid: ajaxRequest({
				url: 'SReviz/GetFinancAuthority_A',
				params: {
					revizLink: me.revizLink,
					financLink: me.financLink,
					revizMoney: JSON.stringify(me.revizMoney),
					authorityData: JSON.stringify(me.authorityData)
				},
				success: function (val) {
					loadMask.destroy();

					val.gridData.columns = me.columnsAdapted(val.gridData.columns);

					if (!val.gridData.fields.filter(f => f.name === 'id')[0])
						val.gridData.fields.push('id');
					if (!val.gridData.fields.filter(f => f.name === 'tree')[0])
						val.gridData.fields.push('tree');

					me.gksc('grid').setMetaDate(val.gridData,
						{
							profileCode: me.code,
							profileKey: 'FINANC_AUTHORITY_GRID',
							gateCode: me.keyEdit
						}, true);
					me.gksc('grid').getRootNode()?.expand(true);
					me.oldData = JSON.stringify(me.dataCollector());
					me.enableTools();
				},
				failure: function () {
					loadMask.destroy();
				}
			}),
			cancelFn: function () {
				me.objs.view.close();
			}
		});
	},
	columnsAdapted: function (columns) {
		const me = this;

		let index = ArrayLib.find(columns, ['dataIndex'], 'CHECKED');
		if (index !== -1) {
			columns[index].xtype = 'checkcolumnextra';
			columns[index].text = 'M';
			columns[index].width = 30;
			columns[index].readOnly = me.readOnly;
			columns[index].listeners = {
				checkchange: function (ths, rowIndex, checked, rec) {
					rec.set('SUMMA', checked ? me.financSum : null);
					me.enableTools();
				},
				beforecheckchange: function () {
					if (me.readOnly) return false;
				}
			};
		}

		index = ArrayLib.find(columns, ['dataIndex'], 'SUMMA');
		if (index !== -1) {
			columns[index].editor = {
				xtype: 'calcfield',
				fieldLabel: '',
				decimalData: me.decimalData,
				getValue: function () {
					return this.rawToValue(this.processRawValue(this.getRawValue()));
				},
				listeners: {
					blur: function (th) {
						if (th.getNumValue() > th.parseTextToNum(me.financSum)) {
                            warning('Проверенная сумма по полномочию больше проверенной суммы по факту финансирования! Проверенная сумма по полномочию скорректирована!');
                            th.setValue(me.financSum);

                            //для того, что сообщение не убегало на задний план. баг какой-то - видимо происходит активация ячейки
                            Ext.defer(() => Ext.Msg.toFront(), 20);
                        }
					}
				}
			}
		}

		index = ArrayLib.find(columns, ['dataIndex'], 'tree');
		if (index < 0) {
			columns.unshift(me.getTreeColumnCfg());
		}
		return columns;
	},
	enableTools: function () {
		this.gksc('saveBtn')?.setDisabled(!this.saveChangesFn());
	},
	dataCollector: function () {
		return this.gksc('grid').store?.getDataExt();
	},
	saveData: function (endFunc) {
		const me = this;
		if (me.saveFunc) {
			me.saveFunc(me.dataCollector());
		}
		if (endFunc) endFunc();
		me.oldData = JSON.stringify(me.dataCollector());
		me.enableTools();
	}
});