﻿Ext.define('Keysystems.RevizTask.List', {
	extend: 'Keysystems.Base.List',
	title: 'Задание на проведение КМ',
	iconCls: '',
	bodyPadding: 10,
	btnsHide: {
		same: true,
		search: true,
		autofilter: true,
		relations: true,
		galka: true,
		unmark: true
	},

	constructor: function (cfg) {
		var me = this,
			year = new Date().getFullYear();
		me.fromToolbar = cfg && !!cfg.fromToolbar;

		me.btnsHide.new = me.fromToolbar;
		me.btnsHide.edit = me.fromToolbar;
		me.btnsHide.delete = me.fromToolbar; 
		me.btnsHide.exit = !me.fromToolbar;


		me.dt1 = cfg.whereArgs && cfg.whereArgs.DBegin ? cfg.whereArgs.DBegin.value : new Date(year + '/01/01');
		me.dt2 = cfg.whereArgs && cfg.whereArgs.DEnd ? cfg.whereArgs.DEnd.value : new Date(year + '/12/31');

		me.callParent(arguments);
	},

	createItems: function () {
		var me = this,
			objs = me.objs,
			items = me.callParent(arguments);

		me.isCreate = true;
		if (me.fromToolbar) {
			items.unshift(objs.filterPanel = Ext.create('Ext.panel.Panel',
				{
					collapsible: true,
					title: 'Фильтр по Заданиям',
					layout: { type: 'vbox', align: 'stretch' },
					bodyPadding: me.bodyPadding + ' ' + me.bodyPadding + ' 0 ' + me.bodyPadding,
					border: 0,
					bodyBorder: 0,
					userCls: 'rks-filter-panel',
					items: [
						Ext.create('Ext.form.FieldContainer',
							{
								layout: { type: 'hbox', align: 'stretch' },
								items: [
									me.sksc('DT',
										Ext.create('Keysystems.Controls.KsPeriod',
											{
												startYear: me.year,
												width: 400,
												state: 4,
												labelWidth: 150,
												fieldLabel: 'Период проведения',
												allStates: 12,
												listeners: {
													ksChange: function() {
														if (!me.isCreate) {
															me.setWhereArgs();
															me.refresh();
														}
													}
												}
											}))
								]
							})
					]
				}));

			me.gksc('DT').setValue(me.dt1, me.dt2);
		}
		
		me.isCreate = false;

		return items;
	},
	setKsReadOnly: function (val) {
		if (val === _ || !this.objs.tbarBtns) return;
		var me = this;

		me.btnsHide.edit = val;
		me.btnsHide.delete = val;

		me.objs.tbarBtns.new.setVisible(!val);
		me.objs.tbarBtns.edit.setVisible(!val);
		me.objs.tbarBtns.delete.setVisible(!val);
		me.objs.tbarBtns.print.setVisible(!val);
		me.objs.tbarBtns.nastr_grid?.setVisible(!val);
		me.objs.tbarBtns.wrap?.setVisible(!val);
		me.objs.tbarBtns.exit.setVisible(!val);
	},
	setWhereArgs: function () {
		if (!this.gksc('DT')) return;
		var me = this,
			dh = me.gksc('DT').getValue(),
			whereArgs = {
				DBegin: { value: dh.dh1.toDateString(), type: 'Date' },
				DEnd: { value: dh.dh2.toDateString(), type: 'Date' }
			};
		whereArgs.OrgP = me.whereArgs.OrgP;

		me.afterSetWhereArgs && me.afterSetWhereArgs(whereArgs);

		return Ext.apply(me.whereArgs, whereArgs);
	},
	getGridCfg: function(){
		let res = this.callParent(arguments);
		if (this.fromToolbar) res.userCls = 'rks-grid-with-filter-panel';
		return res;
	},
})