﻿Ext.define('Keysystems.RevizTask.Edit', {
	extend: 'Keysystems.Base.Edit',

	constructor: function (cfg) {
		var me = this;

		if (cfg && cfg.whereArgs && cfg.whereArgs.Reviz) {
			me.reviz = cfg.whereArgs.Reviz.value;
		}

		me.callParent(arguments);
	},

	createItems: function () {
		var me = this,
			year = me.whereArgs.Year.value,

			items = [
				me.sksc('NUMBER',
					Ext.create('Ext.form.field.Number',
						{
							xtype: 'numberfield',
							maxWidth: 260,
							labelWidth: me.labelWidth,
							fieldLabel: '№ п/п',
							minValue: 0
						})),
				me.sksc('DEADLINE',
					Ext.create('Ext.form.field.Date',
						{
							fieldLabel: 'Срок предоставления материалов',
							labelWidth: me.labelWidth,
							maxWidth: 260
						})),
				me.createDictEdit({
					key: 'S_ORG',
					labelWidth: me.labelWidth,
					flex: 1,
					code: dnl.S_ORG,
					mode: 'SINGL',
					fieldLabel: 'Объект',
					codeWidth: 105,
					ksAllowEmpty: true,
					initWhereArgs: function() {
						return {
							RevizTaskReviz: { value: me.reviz || 0, type: 'int' },
							RevizTaskOrgP: { value: me.objs.S_ORGP.getLink(), type: 'int' }
						};
					}
				}),
				me.sksc('EXTOBJECTS',
					Ext.create('Ext.form.field.ComboBox',
						{
							store: [],
							flex: 1,
							margin: '0 0 0 ' + (me.labelWidth + 5)
						})),
				me.createDictEdit({
					key: 'S_ORGP',
					labelWidth: me.labelWidth,
					flex: 1,
					code: dnl.S_ORG,
					mode: 'SINGL',
					fieldLabel: 'Проверяющая организация',
					codeWidth: 105,
					ksAllowEmpty: true,
					margin: '0 0 11 0',
					whereArgs: { SType: { value: JSON.stringify([1]), type: 'List_int' } },
					listeners: {
						change: function(th) {
							if (me.isLoaded) return;
							me.objs.S_ORG.setValue([]);
						}
					}
				}),
				me.createDictEdit({
					key: 'S_WORK',
					labelWidth: me.labelWidth,
					flex: 1,
					code: dnl.S_WORK,
					mode: 'SINGL',
					fieldLabel: 'Вид работы',
					codeWidth: 105,
					whereArgs: {
						DH1: { value: new Date(year, 0, 1), type: 'Date' },
						DH2: { value: new Date(year, 11, 31), type: 'Date' }
					}
				}),
				me.sksc('REVIZ', Ext.create('Keysystems.Controls.DictName.Edit', {
					labelWidth: me.labelWidth,
					fieldLabel: 'КМ по заданию',
					cleaningKey: false,
					code: dnl.REVIZ,
					handler: {
						cls: 'x-dict-trigger x_btn_open',
						handler: function () {
							var link = me.gksc('REVIZ').getLink();
							if (!link) return;
							Ext.create(dictListController.DOCUMENT_REVIZ.editClass,
								{
									link: link,
									f: 'readOnly',
									linkCode: 'SReviz',
									data: {
										data: {
											LINK: link,
											LINK_SELF: me.reviz
											//linkPlanReviz,orderLink,appealLink,docLink
										}
									}
								});
						}
					},
					initWhereArgs: function () {
						var wa = {
							DBegin: { value: new Date(year, 0, 1), type: 'Date' },
							DEnd: { value: new Date(year, 11, 31), type: 'Date' }
						};
						return wa;
					}
				}))
			];

		return me.callParent([items]);
	},
	getExtra: function (endFunc, link) {
		var me = this,
			objs = me.objs,
			extObjectsData = [],
			reviz = me.reviz || 0;

		me.baseGetExtra({ link: link, reviz: reviz }, function (val) {
			var row = val.row;
			me.gksc('NUMBER').setValue(row.NUMBER);
			me.gksc('DEADLINE').setValue(row.DEADLINE);
			objs.S_ORG.setValue(val.SOrg);
			me.gksc('EXTOBJECTS').setValue(row.EXTOBJECTS);
			objs.S_ORGP.setValue(val.SOrgP);			
			objs.S_WORK.setValue(val.SWork);

			objs.S_ORGP.dictMode = val.multiSelectOrgP ? 'MULTI' : 'SINGL';
			objs.S_WORK.whereArgs.NotInLinks = { value: JSON.stringify(val.workNotInLinks), type: 'List_int' }

			if (row.CHILD_REVIZ) {
				me.gksc('REVIZ').setValue(val.RevizByTask);
				me.gksc('NUMBER').setReadOnly(true);
				me.gksc('NUMBER').addCls('ks-readOnly');
			} else {
				me.gksc('REVIZ').setReadOnly(true);
			}

			Ext.each(val.extosnovList, function (v) { extObjectsData.push([v]) });

			me.gksc('EXTOBJECTS').store.loadData(extObjectsData, true);
			me.gksc('EXTOBJECTS').setValue(val.row.EXTOBJECTS);

			me.setFullObjsAccess(val.extObjectsAccess, ['EXTOBJECTS']);

			if (endFunc) endFunc();
		});
	},
	dataCollector: function () {
		var me = this,
			objs = me.objs,
			data = me.callParent(arguments);

		data.number = me.gksc('NUMBER').getValue();
		data.deadline = me.gksc('DEADLINE').getValue()?.toDateString() ?? null;
		data.sorg = objs.S_ORG.getLink();
		data.extObjects = me.gksc('EXTOBJECTS').getValue();
		data.sorgp = objs.S_ORGP.getLinks(1);
		data.swork = objs.S_WORK.getLink();

		if (me.whereArgs.Reviz) data.reviz = me.whereArgs.Reviz.value || 0;

		return data;
	},
	isFilled: function () {
		var me = this,
			objs = me.objs;
		
		let res = true;
		if (me.gksc('NUMBER').isEmpty()) {
			me.addToInvalidControls(me.gksc('NUMBER'));
			res = false;
		}

		if (objs.S_ORG.isEmpty()) {
			me.addToInvalidControls(objs.S_ORG);
			res = false;
		}

		if (objs.S_ORGP.isEmpty()) {
			me.addToInvalidControls(objs.S_ORGP);
			res = false;
		}
		return res;
	}
})