﻿//import tinycolor from 'tinycolor2';

Ext.define('Keysystems.Reviz.List',
	{
		extend: 'Keysystems.Base.List.Tree',
		startYear: new Date().getFullYear(),
		bodyPadding: 10,
		labelWidth: 150,
		deleteCode: 'DOCUMENT_REVIZ',
		delByChecked: true,
		profileListeners: [
			{ name: 'holdingPeriod', method: 'KsPeriodChange' },
			{ name: 'S_PLAN', method: 'ksDictChange' }
		],
		revizColors: {},
		revizRegularExpressions: {
			"DraftBGColor": /\/\*DraftBGColor\*\/.*\/\*/g,
			"PreparedBGColor": /\/\*PreparedBGColor\*\/.*\/\*/g,
			"ClosedBGColor": /\/\*ClosedBGColor\*\/.*\/\*/g,
			"DoneBGColor": /\/\*DoneBGColor\*\/.*\/\*/g,
			"DraftColor": /\/\*DraftColor\*\/.*\/\*/g,
			"PreparedColor": /\/\*PreparedColor\*\/.*\/\*/g,
			"ClosedColor": /\/\*ClosedColor\*\/.*\/\*/g,
			"DoneColor": /\/\*DoneColor\*\/.*\/\*/g,
			"OverdueColor": /\/\*OverdueColor\*\/.*\/\*/g,

			'DraftBGColor-over': /\/\*DraftBGColor-over\*\/.*\/\*/g,
			'DraftBGColor-selected': /\/\*DraftBGColor-selected\*\/.*\/\*/g,

			'PreparedBGColor-over': /\/\*PreparedBGColor-over\*\/.*\/\*/g,
			'PreparedBGColor-selected': /\/\*PreparedBGColor-selected\*\/.*\/\*/g,

			'ClosedBGColor-over': /\/\*ClosedBGColor-over\*\/.*\/\*/g,
			'ClosedBGColor-selected': /\/\*ClosedBGColor-selected\*\/.*\/\*/g,

			'DoneBGColor-over': /\/\*DoneBGColor-over\*\/.*\/\*/g,
			'DoneBGColor-selected': /\/\*DoneBGColor-selected\*\/.*\/\*/g
		},
		
		createGridListeners: function() {
			var me = this;

			me.functions.select = function(dv, sels) {
				var rec = Array.isArray(sels) ? sels[0] : sels;

				if (Array.isArray(sels) && !sels.length) return;

				if (!me.gksc('splitter').hidden) {
					if (me.gksd('showDocs')) {
						me.getDocsData(rec.get('LINK'));
					} else {
						me.getAboutData(rec.get('LINK'));
					}
				}
			};
			return me.callParent(arguments);
		},
		setWhereArgs: function() {
			let me = this,
				objs = me.objs,
				dh = objs.holdingPeriod.getValue(),
				sPlan = objs.S_PLAN.getLinks() || [],
				whereArgs = {
					DBegin: { value: dh.dh1, type: 'Date' },
					DEnd: { value: dh.dh2, type: 'Date' },
					RazdelPlan: { value: JSON.stringify(sPlan), type: 'List_int' }
				};

			if (me.isVfa) whereArgs.SWorks = { value: JSON.stringify(me.SWorks || []), type: 'List_int' };

			me.afterSetWhereArgs && me.afterSetWhereArgs(whereArgs);

			return Ext.apply(me.whereArgs, whereArgs);
		},
		initializeFilter: function () {
			let me = this;
			if (!me.whereArgs) return;

			me.updateDateFromWhereArg(me.whereArgs.DBegin.value, me.whereArgs.DEnd.value, me.objs.holdingPeriod);			
			me.updateDictFromWhereArg(me.whereArgs.RazdelPlan, me.objs.S_PLAN);		
		},
		createItems: function() {
			var me = this,
				objs = me.objs,
				items = me.callParent(arguments);

			me.isCreate = true;
			items.unshift(objs.filterPanel = Ext.create('Ext.panel.Panel',
				{
					border: 0,
					bodyBorder: 0,
					collapsible: !me.hideBottomPanel,
					userCls: 'rks-filter-panel',
					header: {
						title: 'Фильтр по Мероприятиям',
						hidden: me.hideBottomPanel,
					},
					hideCollapseTool: me.hideBottomPanel,
					layout: { type: 'vbox', align: 'stretch' },
					bodyPadding: me.bodyPadding + ' ' + me.bodyPadding + ' 0 ' + me.bodyPadding,
					animCollapse: false,
					items: [
						Ext.create('Ext.form.FieldContainer',
							{
								layout: { type: 'hbox', align: 'stretch' },
								items: [
									objs.holdingPeriod = Ext.create('Keysystems.Controls.KsPeriod',
										{
											startYear: me.startYear,
											state: 4,
											allStates: 12,
											width: 400,
											listeners: {
												ksChange: function() {
													if (me.isLoading) return;
													me.setDate();
												}
											}
										}),
									me.objs.showDocuments = Ext.create('Ext.form.field.Checkbox',
										{
											boxLabel: 'Документы',
											padding: '0 20 0 20',
											hidden: me.hideBottomPanel,
											handler: function(th, check) {
												let isHidden = me.gksc('splitter').hidden,
													revizLink = me.Grid.getSelectionModel().hasSelection() 
														? me.Grid.getSelectionModel().getSelection()[0].get('LINK') 
														: 0;

												me.gksc('splitter')[isHidden ? 'show' : 'hide']();
												me.gksc('docsPanel')[isHidden ? 'show' : 'hide']();
												
												if (me.gksd('showDocs')) {
													if (!me.gksc('documentsGrid')) {
														me.gksc('docsPanel').add(me.createDocsGrid());
													}
													if (me.gksc('splitter').hidden) {
														me.gksc('documentsGrid').clearData();
													} else if (me.Grid.rendered) {
														me.getDocsData(revizLink);
													}
												} else {
													if (!me.gksc('aboutPanel')) {
														me.gksc('docsPanel').add(me.createAboutPanel());
													}
													if (me.gksc('splitter').hidden) {
														me.clearAboutPanel();
													} else if (me.Grid.rendered) {
														me.getAboutData(revizLink);
													}
												};
											}
										}),
									objs.S_PLAN = Ext.create('Keysystems.Controls.Dict.Edit',
										{
											fieldLabel: 'Раздел плана',
											labelWidth: 100,
											padding: '0 10 0 10',
											flex: 1,
											mode: 'MULTI',
											clear: function() {
												this._setValue();
												me.refresh();
											},
											_setValue: function(value) {
												this.setValue(value);
												if (me.isLoading) return;
												
												me.setWhereArgs();
											},
											handler: function() {
												dictFunc({
														mode: 'MULTI',
														parentView: objs.view,
														selectLinks: objs.S_PLAN.getValue(),
														code: dnl.S_PLAN,
														control: objs.S_PLAN,
														contextSearch: objs.S_PLAN.contextSearch
													},
													{
														ok: function(value) {
															objs.S_PLAN._setValue(value);
															me.refresh();
														}
													}
												);
											}
										})
								]
							})
					]
				}));
				items.push(
					me.sksc('splitter', Ext.create('Ext.resizer.Splitter', {
						hidden: true,
						disabled: true
					})),
					me.sksc('docsPanel', Ext.create('Ext.panel.Panel', {
						layout: 'hbox',
						align: 'stretch'
					}))
				);
			
			objs.Year = objs.holdingPeriod.Quarter.holdingYear;
			objs.Quarter = objs.holdingPeriod.Quarter.holdingQuarter;

			me.isCreate = false;

			if (me.hideFilterPnl) objs.filterPanel.hide();

			return items;
		},
		createAboutPanel: function() {
			let me = this;
			
			return me.sksc('aboutPanel', Ext.create('Ext.form.FieldContainer',
			{
				flex: 1,
				layout: { type: 'vbox', align: 'stretch' },
				padding: '5 0 0 5',
				items: [
					me.createDictEdit({
						key: 'S_RTEMA',
						mode: 'MULTI',
						code: dnl.S_RTEMA,
						fieldLabel: 'Тема',
						readOnly: true,
						initWhereArgs: function () {
							return {
								InLinksOnly: { value: 'True', type: 'bool' },
								InLinks: { value: me.objs.S_RTEMA.getLinks(true), type: 'List_int'	}
							};
						}
					}),
					me.createDictEdit({
						key: 'S_WORK',
						mode: 'SINGL',
						code: dnl.S_WORK,
						fieldLabel: 'Вид работы',
						readOnly: true,
						initWhereArgs: function () {
							return {
								InLinksOnly: { value: 'True', type: 'bool' },
								InLinks: { value: me.objs.S_WORK.getLinks(true), type: 'List_int'	}
							};
						}
					}),
					me.createDictEdit({
						key: 'S_ROSNOV',
						mode: 'SINGL',
						code: dnl.S_ROSNOV,
						fieldLabel: 'Основание',
						readOnly: true,
						initWhereArgs: function () {
							return {
								InLinksOnly: { value: 'True', type: 'bool' },
								InLinks: { value: me.objs.S_ROSNOV.getLinks(true), type: 'List_int'	}
							};
						}
					}),
					me.createDictEdit({
						key: 'S_PERSON',
						mode: 'SINGL',
						code: dnl.S_PERSON,
						fieldLabel: 'Руководитель',
						readOnly: true,
						initWhereArgs: function () {
							return {
								InLinksOnly: { value: 'True', type: 'bool' },
								InLinks: { value: me.objs.S_PERSON.getLinks(true), type: 'List_int'	}
							};
						}
					}),
					me.createDictEdit({
						key: 'S_OTDEL',
						mode: 'SINGL',
						code: dnl.S_OTDEL,
						fieldLabel: window.isRfn ? 'Ответственный исполнитель' : 'Подразделение',
						height: window.isRfn ? 38 : 24,
						readOnly: true,
						initWhereArgs: function () {
							return {
								InLinksOnly: { value: 'True', type: 'bool' },
								InLinks: { value: me.objs.S_OTDEL.getLinks(true), type: 'List_int'	}
							};
						}
					})
				]
			}));
		},
		getAboutData: function(revizLink) {
			if (revizLink === 0) return;
			
			let me = this,
				endFunc = function(data) {
					me.objs.S_RTEMA.setValue(data.S_RTEMA);
					me.objs.S_WORK.setValue(data.S_WORK);
					me.objs.S_ROSNOV.setValue(data.S_ROSNOV);
					me.objs.S_PERSON.setValue(data.S_PERSON);
					me.objs.S_OTDEL.setValue(data.S_OTDEL);
				};
			
			if (me.gksd('aboutData').hasOwnProperty(revizLink.toString())) {
				endFunc(me.gksd('aboutData')[revizLink]);
			} else {
				const loadMask = new Ext.LoadMask({
					msg: KS.L10n.RevizListView_GetAboutData,
					view: me.gksc('docsPanel'),
					autoShow: true,
					rid: ajaxRequest({
						params: {
							revizLink: revizLink
						},
						url: 'SReviz/GetAboutData_A',
						success: function(res) {
							if (!res.error.length) {
								me.gksd('aboutData')[revizLink] = res.data;
								endFunc(res.data);
							}
						},
						failure: function(val) {
							showError(KS.L10n.RevizListView_ErrorGetAboutData);
						},
						callback: function() {
							loadMask.destroy();
						}
					})
				});
			}
		},
		clearAboutPanel: function() {
			let me = this;

			me.objs.S_RTEMA.setValue();
			me.objs.S_WORK.setValue();
			me.objs.S_ROSNOV.setValue();
			me.objs.S_PERSON.setValue();
			me.objs.S_OTDEL.setValue();
		},
		createDocsGrid: function() {
			let me = this;

			return me.sksc('documentsGrid', Ext.create('Keysystems.Controls.TaskGrid',
				{
					header: false,
					userCls: 'rks-filter-panel',
					hideCollapseTool: window.Theme === 'crisp',
					flex: 4,
					height: 300,
					profilePrefix: 'reviz',
					profileGateCode: 'edit',
					profileKey: 'taskGridPrepare',
					profileCode: 'DOCUMENT_REVIZ',
					createToolBar: function() { 
						return this.ToolBar = Ext.create('Ext.Toolbar');
					},
					needColorize: false,
					editRoot: function(rec) {
						let th = this,
							tasksWithTabs = me.gksd('tasksWithTabs'),
							tabKey = '';
						
						for(var key in tasksWithTabs) {
							if (tasksWithTabs[key].indexOf(rec.get('S_TASK')) !== -1) {
								tabKey = key;
								break;
							}
						}

						me.edit('edit', me.Grid.getFrstSelect(), {
							tabKey,
							activetab: tabKey
						});
					}
				}));
		},
		getDocsData: function(revizLink) {
			if (revizLink === 0) return;
			
			let me = this,
				taskGrid = me.gksc('documentsGrid'),
				endFunc = function(data) {
					taskGrid.tempTask = data.tempTask;
					taskGrid.loadData(data.all);
				};
			
			if (me.gksd('docsData').hasOwnProperty(revizLink.toString())) {
				endFunc(me.gksd('docsData')[revizLink]);
			} else {
				const loadMask = new Ext.LoadMask({
					msg: KS.L10n.RevizListView_GetRevizListDocsData,
					view: me.gksc('docsPanel'),
					autoShow: true,
					rid: ajaxRequest({
						params: {
							link: revizLink
						},
						url: 'SReviz/GetAllTasksData_A',
						success: function (res) {
							if (!res.error.length) {
								if (res) {
									endFunc(res.data);

									me.gksd('docsData')[revizLink] = res.data;
								}
							}
						},
						failure: function (val) {
							showError(KS.L10n.RevizListView_ErrorGetRevizListDocsData);
						},
						callback: function () {
							loadMask.destroy();
						}
					})
				});
			}
		},
		setDate: function() {
			var me = this;
			me.setWhereArgs();
			me.refresh();
		},
		columnsAdapted: function(columns) {
			var me = this,
				h = function(cols) {
					if (cols) {
						Ext.each(cols,
							function(column) {
								h(column.columns);
								if (!column.xtype) {
									column.renderer = function(val, metaData, record) {
										return rendererCell(val, metaData, record);
									};
								}
							});
					}
				},
				c = ArrayLib.find(columns, ['dataIndex'], 'REPAYMENT_NAR_RESPONS');

			if (c !== -1) {
				columns[c] = {
					xtype: 'actionimg',
					dataIndex: 'IMG',
					iconCls: 'x_btn_document_error',
					getClass: function(v, meta, rec) {
						return rec.get('REPAYMENT_NAR_RESPONS') ? this.iconCls : '';
					}
				};
			}

			c = ArrayLib.find(columns, ['dataIndex'], 'S_PERSON_CLOSED');

			if (c !== -1) {
				c = columns[c];
				c.xtype = 'checkcolumn';
				//c.summaryType = 0;
				if (!c.listeners) c.listeners = {};
				c.listeners.beforecheckchange = function() {
					return false;
				};
			}

			c = ArrayLib.find(columns, ['dataIndex'], 'STATUS');

			if (c !== -1) {
				c = columns[c];
				c.isSummary = false;
				c.summaryType = false;
			}

			columns.push(
				{
					xtype: 'actioncolumn',
					dataIndex: 'PLAN',
					text: 'План',
					sortable: false,
					width: 150,
					align: 'center',
					items: [
						{
							getClass: function(v, meta, rec) {
								let hasParent = rec.get('LINK_SELF') !== null,
									hasPlanReviz = rec.get('PLANREVIZ') !== null,
									planOsnov = me.gksd('planOsnov').indexOf(rec.get('S_ROSNOV')) !== -1;

								return hasPlanReviz
									? 'x_btn_plan'
									: planOsnov && !hasParent
										? 'x_btn_plan_grey'
										: '';
							},
							handler: function(grid, rowIndex) {
								let rec = grid.getStore().getAt(rowIndex),
									hasPlanReviz = rec.get('PLANREVIZ') !== null,
									planOsnov = me.gksd('planOsnov').indexOf(rec.get('S_ROSNOV')) !== -1;
								
								if (hasPlanReviz && planOsnov) {
									Ext.create('Keysystems.Plan.Edit', {
										f: 'edit',
										data: {
											data: {
												LINK: rec.get('PLANREVIZ'),
												REVIZ: rec.get('LINK')
											}
										}
									});
								}
							}
						}
					]
				});
			
			h(columns);
			return me.callParent([columns]);
		},
		fieldsAdapted: function(fields) {
			var f = ArrayLib.find(fields, ['name'], 'S_PERSON_CLOSED');

			if (f !== -1) {
				fields[f].type = 'bool';
			}

			f = ArrayLib.find(fields, ['name'], 'NUMBER');
			if (f !== -1) {
				fields[f].sortType = "asNatural";
			}
			return this.callParent([fields]);
		},

		//#region Показатели

		reCalcs: function(links) {
			if (!links.length) return;
			let me = this;

			const loadMask = new Ext.LoadMask({
				rid: ajaxRequest({
					url: me.linkCode + '/RecalcByReviz_A',
					params: {links: JSON.stringify(links)},
					callback: function (response) {
						if (!response) return;
						//удалим стили, в вебе свои
						let log = response.substring(response.indexOf("</head>") + 7);
						loadMask.destroy();

						ChooseBox.ShowHTMLLog({
							title: 'Протокол пересчета показателей',
							text: log
						});
					},
					progress: function (response) {
						loadMask.setMsg(response);
					}
				}),
				cancelFn: function () {
					me.cancelRecalc = true;
				},
				msg: wmc.getMask('RecalcCalcsBy', 1, links.length),
				view: me.objs.view,
				autoShow: true
			});

		},

		/** Task Revizor.Reviz.Recalc */
		recalcMsg: function() {
			var me = this,
				grid = me.Grid,
				selLinks = ArrayLib.getLinks(me.getChecks()),
				allLinks = grid.store.getLinks();

			if (!selLinks || selLinks.length === 0)
				selLinks = ArrayLib.getLinks(grid.getSelectionModel().getSelection());
			const len = selLinks.length;

			me.recalcMsgShow(len, function () {
				me.reCalcs(selLinks);
			}, function () {
				me.reCalcs(allLinks);
			});
		},

		recalcMsgShow: function(len, yesFunc, extraFunc, noFunc, callBack) {
			Ext.Msg.show({
				title: KS.L10n.RECALC_TITLE,
				msg:  len > 1 ? Ext.String.format(KS.L10n.RevizTasks_RevizRecalc, ` (${len})`) : Ext.String.format(KS.L10n.RevizTasks_RevizRecalc, ''),
				buttons: Ext.MessageBox.YESNOCANCEL,
				buttonText: len > 0 ? { yes: 'Да', no: 'Все', cancel: 'Нет' } : { no: 'Все', cancel: 'Нет' },
				animateTarget: this.objs.view,
				fn: function(buttonId) {
					switch (buttonId) {
						case 'yes':
							if (yesFunc) yesFunc();
							break;
						case 'no':
							if (extraFunc) extraFunc();
							break;
						default:
							if (noFunc) noFunc();
					}
					if (callBack) callBack();
				},
				icon: Ext.MessageBox.QUESTION
			});
		},

		//#endregion Показатели

		setSBText: function(allCount, selCount, checkCount) {
			let me = this;
			me.callParent(arguments);
			if (me.hideTBar) return;

			let tbarBtns = me.objs.tbarBtns,
				sel = me.Grid ? me.Grid.getFrstSelect() : null,
				readOnly =me.readOnly || me.accessReadOnly;
			
			tbarBtns.recalc?.setDisabled(readOnly || !sel);
			tbarBtns.batch_change?.setDisabled(readOnly);
			tbarBtns.add_reviz_from_plan?.setDisabled(readOnly);

			let enabled = !readOnly && sel && !sel.get('LINK_SELF');
			[tbarBtns.add_slave, tbarBtns.childplan, tbarBtns.addcross, tbarBtns.add_obsl]
				.forEach(btn => btn && btn.setDisabled(!enabled));
		},
		
		beforeSetData: function(data, p) {
			const me = this;
			let { revizColors = {} } = data;

			data.fields
				.filter(f => ['NUMBER', 'NUMBERIKM', 'DELO', 'DOCOSNOVNUMBER', 'PPLAN'].indexOf(f.name)>=0)
				.forEach(f => f.sortType = 'asNatural');

			me.callParent(arguments);

			me.sksd('planOsnov', data.planOsnov);
			me.sksd('planStatuses', data.planStatuses);
			me.sksd('isModAvailable', data.isModAvailable);
			me.sksd('modTypeNotPlan', data.modTypeNotPlan);
			me.sksd('orgP', data.orgP);
			me.sksd('showDocs', data.showDocs);
			me.sksd('tasksWithTabs', data.tasksWithTabs);

			me.sksd('aboutData', {});
			me.sksd('docsData', {});
			
			me.objs.showDocuments.setVisible(data.showDocCheckBox);
						
			if (window.revizColors !== revizColors) {
				window.revizColors = revizColors;
				const revizColorsNames = Object.keys(revizColors);
				//Получаем текущие стили
				let cssBlock = $('#reviz-rows-styles');
				let reviz = cssBlock.text();

				revizColorsNames.map(name => {
					let newProp = revizColors[name];
					let regexp = me.revizRegularExpressions[name];
					let newString = `/*${name}*/${newProp}/*`;
					reviz = reviz.replace(regexp, newString);

					//подбор цветов отключен. для выделения и наведения исп-ся стандартные цвета темы
					// if (name.indexOf('BG') !== -1) {
					// 	//Для selected делаем темнее
					// 	let originalColor = tinycolor(newProp);
					// 	let selectedColor = null;
					// 	let hoverColor = null;
					//	
					// 	//Если фон белый, то цвета выделения делаем синими, иначе буквы не видно
					// 	if (originalColor.toString() === 'rgb(255, 255, 255)') {							
					// 		if (window.Theme === 'crisp'){
					// 			originalColor = tinycolor('rgb(230, 242, 250)');
					// 			hoverColor = originalColor.toString();
					// 			selectedColor =    tinycolor('rgb(194,221,242)').toString();
					// 		}
					// 		else{
					// 			originalColor =  tinycolor('rgb(189, 214, 255)');	
					// 		}
					// 	}
					// 	if (!selectedColor) selectedColor = originalColor.darken(25).toString();
					//	
					// 	let regexpSel = me.revizRegularExpressions[`${name}-selected`];
					//
					// 	let newStr = `/*${name}-selected*/` + selectedColor.indexOf('rgb') === -1 ?
					// 		`#${selectedColor}/*` : `${selectedColor}/*`;
					//
					// 	reviz = reviz.replace(regexpSel, newStr);
					//
					// 	//Для over делаем светлее
					// 	if (!hoverColor) hoverColor = originalColor.brighten(25).toString();
					// 	let regexpOver = me.revizRegularExpressions[`${name}-over`];
					//
					// 	newStr = `/*${name}-over*/` + hoverColor.indexOf('rgb') === -1 ?
					// 		`#${hoverColor}/*` : `${hoverColor} !important/*`;
					//
					// 	reviz = reviz.replace(regexpOver, newStr);												
					// }
				});

				cssBlock.text(reviz);
			}
		},

		getRowClass: function(record) {
			var cls = record.data.rowStyle;
			return this.filterable ? cls + ' ' + record.match : cls;
		},

		getGridCfg: function(){
			let res = this.callParent(arguments);
			res.userCls = 'rks-grid-with-filter-panel';
			return res;
		},

		afterRefresh: function() {
			let me = this,
				revizLink = me.Grid.getSelectionModel().hasSelection()
					? me.Grid.getSelectionModel().getSelection()[0].get('LINK')
					: 0;

			me.callParent(arguments);

			me.sksd('aboutData', {});
			me.sksd('docsData', {});

			if (me.Grid.rendered && !me.gksc('splitter').hidden) {
				if (me.gksd('showDocs')) {
					me.getDocsData(revizLink);
				} else {
					me.getAboutData(revizLink);
				}
			}
		},

		/** Revizor.Reviz.AddPlan */
		revizAddFromPlan: function() {
			let me = this;

			dictFunc({
					parentView: tabView,
					mode: 'SINGL',
					code: me.isVfa ? dnl.PLANREVIZ_VFA : dnl.PLANREVIZ,
					hideFilterPnl: true,
					ksReadOnly: true,
					_arrEditTBarBtns: [],
					canBold: true,
					readOnlyPlanInfo: true,
					initWhereArgs: function () {
						let wa = {
							DT1: me.whereArgs.DBegin,
							DT2: me.whereArgs.DEnd,
							Modification: {value: 'Default', type: 'KSBoolean'},
							ByRashDate: {value: true, type: 'bool'},
							PlanMode: {value: 'Reviz', type: 'PlanMode'},
							Subcomplex: {value: me.isVfa ? 'Vfa' : 'PlanReviz', type: 'SubcomplexType'},
							Statuses: {value: JSON.stringify(me.gksd('planStatuses')), type: 'List_int'}
						};

						if (me.gksd('isModAvailable') && !me.isVfa) {
							wa.ModTypeNotPlan = {
								value: JSON.stringify(me.gksd('modTypeNotPlan')), type: 'List_int'
							};
						}

						if (me.gksd('orgP')) {
							wa.SOrgps = {
								value: JSON.stringify([me.gksd('orgP')]), type: 'List_int'
							};
						}

						if (me.SORGPNodeId) {
							wa.OrgsR = {
								value: JSON.stringify([me.SORGPNodeId]), type: 'List_int'
							};
						}

						return wa;
					},
					getRowClass: function (rec) {
						return !rec.get('DTR1')
							? 'ks-main'
							: '';
					},
					beforeCreate: function (setts, callback) {
						let p = {
							whereArgs: JSON.stringify(setts.initWhereArgs()),
							GateCode: setts.GateCode,
							controlName: setts.controlName,
							page: 1,
							pageSize: setts.pageSize,
							reload: setts.reloadData,
							needToolbar: false,
							code: setts.code
						};
						
						me.showLoadMask({
							msg: KS.L10n.loading_data,
							rid: ajaxRequest({
								params: { gzipData: SignalR.pack(p) },
								url: setts.linkCode + '/Get_A',
								success: function (data) {
									if (data && data.data.total === 1) {
										me.edit('new', null, {
											LinkPlanReviz: data.data.data[0] ? data.data.data[0].LINK : 0,
											AppealLink: data.data.data[0] ? data.data.data[0].APPEAL_LINK : 0
										})										
									}
									else{
										callback(setts);
									}
								},
								callback: function() { me.hideLoadMask(); }
							})
						})						
					},

				},
				{
					ok: function (value) {
						if (!value.length) return;
						me.edit('new', null, {
							LinkPlanReviz: value[0].data.LINK,
							AppealLink: value[0].data.APPEAL_LINK
						});
					}
				});
		},

		/** Revizor.Reviz.AddRepair */
		revizAddRepair: function(){
			let me = this,
				sel = me.objs.Grid.getFrstSelect();
			if (sel) {
				sel.set('linkSelf', sel.get('LINK'));
				sel.set('childType', 1);
				me.edit('new', sel);
			}
		},

		/** Revizor.Reviz.AddRepairPlan */
		revizAddRepairPlan: function(){
			let me = this,
				sels = me.objs.Grid.getSelectionModel().getSelection();

			if (sels && sels.length) {
				const revizLinks = ArrayLib.getLinks(sels, ['LINK']);

				me.showLoadMask({
					msg: KS.L10n.loading_data,
					rid: ajaxRequest({
						url: 'SReviz/GetRevizPlanWhereArgs_A',
						params: { links: revizLinks, isVfa: me.isVfa },
						success: function(res) {
							dictFunc({
									mode: 'SINGL',
									parentView: objs.view,
									code: me.isVfa ? dnl.PLANREVIZ_VFA : dnl.PLANREVIZ,
									ksReadOnly: true,
									_arrEditTBarBtns: [],
									hideFilterPnl: true,
									canBold: true,
									readOnlyPlanInfo: true,
									initWhereArgs: function() {
										var wa = res.whereArgs;

										if (me.SORGPNodeId) {
											wa.OrgsR = {
												value: JSON.stringify([me.SORGPNodeId]), type: 'List_int'
											};
										}
										return wa;
									},
									getRowClass: function(rec) {
										return !rec.get('DTR1')
											? 'ks-main'
											: '';
									},
									show: function() {
										var d = this.Grid.store.getData();
										this.dataCount === 1
											? me.edit('new', null, { LinkPlanReviz: d[0] ? d[0].LINK : 0 })
											: this.callParent();
									}
								},
								{
									ok: function(value) {
										if (!value.length) return;
										me.edit('new', null, { LinkPlanReviz: value[0].data.LINK });
									}
								});
						},
						callback: me.hideLoadMask.bind(me)
					})
				});
			}
		},
		
		/** Task Revizor.Reviz.AddFromRevizTask */
		revizAddFromTask: function(){
			let me = this;
			dictFunc({
					parentView: tabView,
					mode: 'SINGL',
					code: 'DOCUMENT_REVIZTASK',
					fromToolbar: true,
					whereArgs: {
						DBegin: me.whereArgs.DBegin,
						DEnd: me.whereArgs.DEnd,
						OrgP: { value: window.user.org.data.LINK, type: 'int' }
					}
				},
				{
					ok: function(value) {
						if (!value.length) return;
						var data = value[0].data;
						me.edit('new',
							{ data: { linkSelf: data.MAIN_REVIZ } },
							{
								LinkSelf: data.MAIN_REVIZ,
								InAddSlave: true,
								RevizTask: data.LINK,
								RevizTaskDeadLine: data.DEADLINE || longPeriod.end,
								RevizTaskWork: data.S_WORK
							});
					}
				});
		}
		
	});