﻿//Основная вьюха рекдатирования мероприятий
Ext.define('Keysystems.Reviz.Edit', {
	title: 'Мероприятия',
	activetab: 'General',
	extend: 'Ext.tab.Panel',
	mixins: ['Keysystems.Base.Edit', 'Keysystems.Reviz.Edit.General', 'Keysystems.Reviz.Edit.Prepare', 'Keysystems.Reviz.Edit.Nar', 'Keysystems.Reviz.Edit.Formalize', 'Keysystems.Reviz.Edit.Resp'],
	//Массив с названиями табов (для взятий из ksControls)
	tabNames: ['General', 'Prepare', 'Nar', 'Formalize', 'Resp', 'Ap'],
	flex: 1,
	isWindow: true,
	bodyPadding: 0,
	tabBar: {
		border: 0
	},
	link: 0,
	whereArgs: {},
	viewMinSize: [871, 550],
	hidePrintBtn: false,
	profileListeners: [{ name: 'view', method: 'FormParam' }],
	cls: 'rks-panel-edit-reviz',
	bodyCls: 'rks-panel-edit-reviz-body',
	constructor: function(cfg){
		Ext.apply(this, cfg);
		this.callParent(arguments);
	},
	initKsData: function(ksData) {
		ksData.extras = {};
		ksData.isActual = {};
	},
	initEvents: function() {
		var me = this;

		me.callParent(arguments);

		me.on('tabchange', function (th, newCard, oldCard) {
			// когда открыли сразу вкладку АП, не грузим данные повторно
			if (!newCard.isLoaded) {
				if (newCard === me.gksc('RevizTask')) {
					me.setFullObjsAccess(me.tabRevizTaskAccess, ['RevizTask']);
				} else {
					newCard.data = me.data;
					if (!me.ksData.isActual[newCard.tabKey]) {
						newCard.f = me.f;
						newCard.ksData.link = me.link;
						me.prevTab = oldCard;
						newCard.loadData();
					} else {
						newCard.oldData = JSON.stringify(newCard.dataCollector());
						// т.к. ksData у всех вкладок общая, возвращаем перетертое значение
						me.sksd('access', newCard.getAccessStore());
					}

					me.setReadOnly.call(newCard, me.ksReadOnly, me.readOnlyReason);
				}
			}

			// Сворачивание/разворачивание списка документов
			if (newCard.tabKey === 'Resp' || newCard.tabKey === 'Prepare' || newCard.tabKey === 'Formalize' || newCard.tabKey === 'Ap'){
				me.ksControls.Resp.collapseAllNode(me.ksData.CollapseListDocuments);
				me.ksControls.Prepare.ksControls.taskGridPrepare?.collapseAllNode(me.ksData.CollapseListDocuments);
				me.ksControls.Formalize.ksControls.taskGridFormalize?.collapseAllNode(me.ksData.CollapseListDocuments);
				me.ksControls.tabAp?.collapseAllNode(me.ksData.CollapseListDocuments);
			}
		});
		me.on('beforetabchange', function(th, newTab) {
			if (me.ridGetExtra || me.inTabChange) return;
			return me.checkSave(newTab, function() {
				me.inTabChange = true;
				me.setActiveTab(newTab);
				me.inTabChange = false;
			}); 
		});
	},
	initComponent: function() {
		var me = this;

		me.beforeInitComponent();

		if (me.data && ['edit', 'readOnly'].indexOf(me.f) >= 0) {
			me.link = me.data.data.LINK || 0;
			me.infoLinks = me.data.data.infoLinks;
		}

		var ksData = me.ksData,
			ksControls = me.ksControls;

		ksData.linkPlanReviz = me.LinkPlanReviz || 0;
		ksData.orderLink = me.OrderLink || 0;
		ksData.appealLink = me.AppealLink || 0;
		ksData.link = me.link || 0;
		// при создании КМ по заданию
		me.sksd('RevizTaskDeadLine', me.RevizTaskDeadLine);
		me.sksd('RevizTask', me.RevizTask);
		me.sksd('RevizTaskWork', me.RevizTaskWork);

		//bind ksMethods
		Ext.each(['docEdit', 'docDel', 'setReadOnly', 'docAddFromDF', 'docBindDF', 'docDeleteFromDF'], function(k) { me.ksMethods[k] = me[k]; });

		me.defaults = function(c) {
			c.bodyBorder = false;
			c.border = false;
			c.docLink = -1;
			c.f = me.f;
			c.code = me.code;
			c.data = me.data;
			c.ksData = me.ksData;
			c.addRecord = me.addRecord;
			c.selectRecord = me.selectRecord;
			c.setRecord = me.setRecord;
			c.refreshFunc = me.refreshFunc;
			c.updateStamp = me.updateStamp;
			c.ksMethods = me.ksMethods;
			c.whereArgs = me.whereArgs;
			c.setAccessStore = me.setAccessStore;
			c.getAccessStore = me.getAccessStore;
		};
		let cfg = { isVfa: me.isVfa, code: me.code };
		me.items = [
			ksControls.General = Ext.create('Keysystems.Reviz.Edit.General', cfg),
			ksControls.Prepare = Ext.create('Keysystems.Reviz.Edit.Prepare', cfg),
			ksControls.Nar = Ext.create('Keysystems.Reviz.Edit.Nar', cfg),
			ksControls.Formalize = Ext.create('Keysystems.Reviz.Edit.Formalize', cfg),
			ksControls.Resp = Ext.create('Keysystems.Reviz.Edit.Resp', cfg)
		];

		me.callParent(arguments);
		me.afterInitComponent();

		me.setActiveTab(me.gksc(me.gksc(me.activetab).hidden ? 'General' : me.activetab));
		ksControls.Prepare.parentTitle = ksControls.Formalize.parentTitle = ksControls.Resp.parentTitle = ksControls.Nar.parentTitle = me.ksControls.view.title;

		//Начинаем загрузку с таба Общие
		Log.sendLog(wmc.get('createForm', me.fstTitle + me.lstTitle, me.code, me.linkCode, me.GateCode));
	},

	//Конструктор окна для вьюхи
	/*createWindow: function() {
		var me = this;

		me.fstTitle = me.title + ' - ';
		me.title = null;
		if (me.f === 'edit') me.lstTitle = 'редактирование';
		me.setKsControl('view', Ext.create('Ext.window.Window', {
			modal: true,
			autoScroll: false,
			overflowX: 'hidden',
			overflowY: 'hidden',
			minButtonWidth: 23,
			title: me.fstTitle + me.lstTitle,
			iconCls: me.f == 'edit' ? 'x_btn_edit' : 'x_btn_new',
			layout: 'anchor',
			resizable: true,
			height: 800,
			minHeight: 600,
			width: 1100,
			minWidth: 700,
			maximizable: true,
			tbar: me.createTBar(),
			buttons: me.createBtns(),
			items: me
		}));
	},*/
	//конструктор нижней панели для кнопок
	createBtns: function() {
		var me = this,
			ksControls = me.ksControls;

		return me.sksc('btns', [
			me.sksc('STATUS', Ext.create('Ext.form.field.Text', {
				fieldLabel: 'Статус',
				disabled: true,
				cleaningKey: false
			})),
			me.sksc('CHECK_CLOSE_PERSON', Ext.create('Ext.form.Checkbox', {
				boxLabel: 'Закрыл',
				handler: function(th, checked) {
					if (!checked && me.getPersonClosedAccess()) {
						ksControls.CHECK_CLOSE_PERSON.setValue(!window.user.person === ksControls.CLOSE_PERSON.getValue()[0]);
					}
				},
				listeners: {
					change: function(th, newValue) {
						var ksDataClosePerson = me.ksData.closePerson,
							//autoFill = me.ksData.AutoFillPersonClosed,
							newClosePerson = newValue
								? ksDataClosePerson && ksDataClosePerson && ksDataClosePerson.LINK
									? ksDataClosePerson
									: window.user.person.data
								: _,
							callBack = function(newClosePerson) {
								ksControls.CLOSE_PERSON.setDisabled(!newValue);
								ksControls.CLOSE_PERSON.ksSetValue(newClosePerson);
							};

						////Считаем значения для поля закрыл по формуле
						//if (autoFill && ksControls.CLOSE_PERSON.isEmpty()) {
						//	LoadMask.show({
						//		msg: KS.L10n.loading_data,
						//		view: me.gksc('view'),
						//		rid: ajaxRequest({
						//			url: me.linkCode + '/CalcAutoFillClosed_A',
						//			params: {
						//				link: me.link
						//			},
						//			success: function(result) {
						//				LoadMask.hide();
						//				if (result.closePerson) {
						//					callBack(result.closePerson);
						//				}
						//			},
						//			failure: function() {
						//				LoadMask.hide();
						//			}
						//		})
						//	});
						//} 
						callBack(newClosePerson);
					}
				}
			})),
			me.createDictEdit({
				key: 'CLOSE_PERSON',
				mode: 'SINGL',
				disabled: true,
				flex: 1,
				code: dnl.S_PERSON,
				initWhereArgs: function() {
					return {
						SOrgs: {
							value: JSON.stringify([window.user.org.data.LINK]),
							type: 'List_int'
						},
						DH1: {
							value: new Date().toDateString(),
							type: 'Date'
						},
						DH2: {
							value: new Date().toDateString(),
							type: 'Date'
						}
					};
				},
				ksSetValue: function(value) {
					ksControls.CLOSE_PERSON.setValue(value);
					me.ksData.closePerson = ksControls.CLOSE_PERSON.getCodeNameValue()[0];
					const closedValue = ksControls.CHECK_CLOSE_PERSON.getValue();
					me.setReadOnly.call(me.activeTab, closedValue, closedValue ? "Мероприятие закрыто" : null, !me.isLoaded);
					if (!me.ksData.closePerson && closedValue) ksControls.CHECK_CLOSE_PERSON.setValue(false);
				},
				setKsReadOnly: function() {
					if (!me.getPersonClosedAccess(true)) this.callParent(arguments);
				}
			})
		]);
	},
	//сообщение о наличии несохраненных данных при переключении таба
	changeTabMsgShow: function(cfg) {
		Ext.Msg.show({
			title: KS.L10n.attention,
			msg: wmc.get('NeedSaveChange'),
			buttons: Ext.MessageBox.OKCANCEL,
			buttonText: { ok: 'Сохранить' },
			fn: function(buttonId) {
				var fn = cfg[buttonId] || cfg.default;
				if (fn) fn();
			},
			icon: Ext.MessageBox.INFO
		});
	},
	//Метод для disable компонентов по состоянию checkbox "закрыл"
	setReadOnly: function(readOnly, reason, fake) {
		var isRevizTask = this.tabKey === 'RevizTask',
			th = isRevizTask ? this.ownerCt : this,
			thOwner = isRevizTask ? th : th.ownerCt,
			view = th.getKsControl('view', true, true),
			currentPersonLink = window.user.person?.data?.LINK,
			closePersonLink = th.ksData.closePerson?.LINK,
			checkClosePerson = th.gksc('CHECK_CLOSE_PERSON', true),
			personClosedAccess = !thOwner.getPersonClosedAccess(true);

		if (currentPersonLink === closePersonLink) readOnly = false;

		//пробрасываем признаки блокировки родителю, для возможности доступа из других табов
		th.ksReadOnly = thOwner.ksReadOnly = view.ksReadOnly = readOnly;
		th.readOnlyReason = thOwner.readOnlyReason = view.readOnlyReason = reason;
		th.readOnlyReasonExt = thOwner.readOnlyReasonExt = view.readOnlyReasonExt = reason;
		
		this.setKsReadOnly(readOnly);
		th.gksc('DT')?.nbDays.setDisabled(readOnly || !th.gksd('nastrRevizDuration'));
		checkClosePerson.ksReadOnly = personClosedAccess;
		checkClosePerson.setDisabled(personClosedAccess);
		thOwner.gksc('STATUS', true).setDisabled(true);
		thOwner.gksc('exitBtn', true)?.setKsReadOnly(false);
		thOwner.gksc('printBtn', true).setKsReadOnly(!th.gksd('isPrint'));

		if (fake) {
			thOwner.gksc('saveBtn', true).setKsReadOnly(false);
			thOwner.gksc('controlBtn', true).setKsReadOnly(false);
			thOwner.setStatusReadOnly();
		}
		else {
			thOwner.gksc('saveBtn', true)?.setKsReadOnly(readOnly);
			thOwner.gksc('controlBtn', true)?.setKsReadOnly(readOnly);
			thOwner.setStatusReadOnly(readOnly, reason);
			view.setTitle(readOnly ? 'Мероприятия - только просмотр' : 'Мероприятия - редактирование');
			
			const reasonExt = th.gksd('readOnlyReasonExt');
			if (reasonExt) {
				const closePersonReadOnly = (+reasonExt & ~+Ext.Object.getKey(miscTypes.ReadOnlyReasonEnum, 'RevizClosed')) !== 0;
				checkClosePerson.ksReadOnly = personClosedAccess || closePersonReadOnly;
				checkClosePerson.setDisabled(personClosedAccess || closePersonReadOnly);
			}
		}
	},

	createWindow: function() {
		const me = this,
			ksControls = me.ksControls;
		me.callParent(arguments);
		ksControls.General.editHostPanel =
			ksControls.Prepare.editHostPanel =
				ksControls.Nar.editHostPanel =
					ksControls.Prepare.editHostPanel =
						ksControls.Formalize.editHostPanel = me.editHostPanel;

		ksControls.General.objs.tbar = me.objs.tbar;
	},

	//Доступ к полю Закрыл с учётом настройки Закрыл - Блокировать редактирование для других пользователей
	getPersonClosedAccess: function(ignore) {
		var me = this,
			personClosed = me.ksData.closePerson,
			isCurrPerson = true;

		if (!ignore) {
			isCurrPerson = !personClosed || personClosed.LINK === window.user.person.data.LINK;
		}

		return me.gksd('PersonClosedAccess') && isCurrPerson;
	},

	//#region Работа с документами

	//#region окно выбора доступных документов

	taskDocTypeImgFormat: '<div class="x-action-col-icon {0}"></div>',

	getTaskDocVidColumns: function() {
		var me = this;
		return [
			{
				text: 'Тип',
				dataIndex: 'TYPE',
				renderer: function(v, m) {
					m.align = 'center';
					var imgs = '';
					for (var t in miscTypes.DocType) {
						if (v & t) {
							imgs += Ext.String.format(me.taskDocTypeImgFormat, KsLib.getTaskTypeIconCls(t * 1));
						}
					}
					return imgs;
				}
			},
			{
				text: 'Код',
				dataIndex: 'S_DOCVID_CODE'
			},
			{
				text: 'Наименование',
				dataIndex: 'S_DOCVID_NAME',
				flex: 1
			}
		];
	},

	getTaskDocVidFields: function() { return ['LINK', 'TYPE', 'S_DOCVID_CODE', 'S_DOCVID', 'S_DOCVID_NAME']; },

	getTaskDocVidDict: function(data, okFn, parentStack = "[]") {
		const me = this;
		const alreadyCreatedTasks = JSON.parse(parentStack);

		Ext.create('Keysystems.Base.List', {
			code: dnl.S_DOCVID,
			title: 'Виды документов',
			mode: 'SINGL',
			parentView: me,
			hidePagging: true,
			baseGetData: function(callBack) {
				if (callBack) {
					callBack({
						columns: me.getTaskDocVidColumns(),
						fields: me.getTaskDocVidFields(),
						data: me.getTaskDocVidData(data)
					});
				}
			},
			baseRefresh: function(callBack) { if (callBack) callBack(me.getTaskDocVidData(data)); },
			GateCode: 'edit',
			prefix: 'Task',
			profileKey: 'DocVid',
			btnsHide: {
				new: true,
				same: true,
				edit: true,
				search: true,
				treeadd: true
			},
			getRowClass: function(record) {
				let rowStyle = '';

				if (record.data.OPTIONAL) {
					rowStyle += ' ks-textgray';
				}

				if (alreadyCreatedTasks) {
					let S_DOCVID = record.get('S_DOCVID');
					let isExist;

					for (let key in alreadyCreatedTasks) {
						isExist = !!alreadyCreatedTasks[key].filter(task => task.S_DOCVID === S_DOCVID).length;
					}

					if (!isExist) {
						rowStyle += ' ks-boldtext';
					}
				}

				return rowStyle;
			},
			functions: { ok: okFn }
		});
	},

	getTaskDocVidData: function(data) {
		var d = JSON.parse(JSON.stringify(data));
		return { data: d, total: d.length };
	},

	//#endregion окно выбора доступных документов

	docShow: function(cfg) { Ext.create('Keysystems.Documents.Edit', cfg); },

	getDocParentStack: function(node) {
		var parentStack = [],
			n,
			parseNodeFn = function(node) {
				return {
					LINK: node.get('LINK'),
					LINK_SELF: node.get('LINK_SELF'),
					TYPE: node.get('TYPE'),
					S_DOCVID: node.get('S_DOCVID'),
					DTUTV: node.get('DTUTV')
				};
			};

		while (!node.parentNode.isRoot()) {
			var child = node.childNodes[0];
			n = parseNodeFn(node);
			if (child && ArrayLib.filter(parentStack, ['LINK'], child.get('LINK')).length === 0) {
				parentStack.push(parseNodeFn(child));
			}
			parentStack.push(n);
			node = node.parentNode;
		}

		if (n) n.LINK_SELF = null;

		var tmp = {};
		tmp[node.data.LINK] = parentStack;
		return JSON.stringify(tmp);
	},

	pickTaskDocType: function(v, callBack) {
		var bt = {}, i = 0;
		for (var t in miscTypes.DocType) {
			if (v & t) bt[Ext.Msg.buttonIds[i]] = miscTypes.DocType[t];
			i++;
		}

		Ext.Msg.show({
			title: 'Ввод документа',
			msg: 'Добавить документ',
			buttons: v * 1,
			buttonText: bt,
			fn: function(buttonId) {
				if (buttonId === 'cancel' || !callBack) return;
				callBack(Math.pow(2, Ext.Msg.buttonIds.indexOf(buttonId)));
			},
			icon: Ext.MessageBox.INFO
		});
	},

	pickTaskDocTypeAndEdit: function(type, cfg) {
		var me = this,
			i = 0;
		for (var t in miscTypes.DocType) if (type & t) i++;
		if (i > 1) {
			me.pickTaskDocType(type, function(pt) {
				cfg.taskDocType = pt;
				me.docShow(cfg);
			});
		} else {
			cfg.taskDocType = type;
			me.docShow(cfg);
		}
	},

	getDocCopyStack: function(rec) {
		var me = this,
			res = { LINK: rec.get('LINK'), children: [] };
		Ext.each(rec.childNodes, function(r) { res.children.push(me.getDocCopyStack(r)); });
		res.children = JSON.stringify(res.children);
		return JSON.stringify(res);
	},
	docCopyRun: function(docLink, recursive, parentNode) {
		const me = this;

		me.showLoadMask({
			msg: wmc.getMask('Copy'),
			rid: ajaxRequest({
				url: 'SDocuments/Copy_A',
				params: { link: me.getLink(), docCode: me.code, docLink: docLink, recursive: recursive },
				success: function(res) {
					me.hideLoadMask();
					if (!res || res.ErrorMsg) {
						info(res.ErrorMsg ?? wmc.get('NotChieldDoc'));
						return;
					}
					if (res.SavedStampMUC) {
						me.sksd('STAMP', res.SavedStampMUC);
						if (me.activeTab?.oldData) {
							const oldData = JSON.parse(me.activeTab.oldData);
							oldData.STAMP = res.SavedStampMUC;
							me.activeTab.oldData = JSON.stringify(oldData);
							me.activeTab.updateStamp(me.getLink(), res.SavedStampMUC);
						}
						
					}
					if (res.data) {
						parentNode.appendChild(res.data);
					}
				},
				failure: function() { me.hideLoadMask(); }
			})
		});
	},
	docCopy: function(rec) {
		var me = this,
			parentNode = rec.parentNode;

		if (parentNode.get('S_TASK') === 0) return;

		me.showLoadMask({
			msg: wmc.getMask('CanCopyDoc'),
			rid: ajaxRequest({
				url: 'SDocuments/CanCopy_A',
				params: {
					link: me.getLink(),
					docCode: me.code,
					taskLink: parentNode.get('S_TASK'),
					parentDocLink: parentNode.get('parentId') === 'root' ? 0 : parentNode.get('LINK'),
					workLink: me.ksData.sWork,
					curDocVid: rec.get('S_DOCVID')
				},
				success: function(res) {
					me.hideLoadMask();
					if (!res) {
						info(wmc.get('NotChieldDoc'));
						return;
					}

					if (rec.childNodes.length) {
						var bt = {},
							btnTxt = ['Документ', 'Всю цепочку', 'Отмена'];

						for (var i = 0; i < 3; i++) bt[Ext.Msg.buttonIds[i]] = btnTxt[i];

						Ext.Msg.show({
							title: wmc.get('Copy'),
							buttons: Ext.MessageBox.YESNO,
							buttonText: bt,
							msg: wmc.getQuestion('CopyChainDocs'),
							fn: function(buttonId) {
								if (buttonId === 'ok') me.docCopyRun(rec.get('LINK'), false, parentNode);
								if (buttonId === 'yes') me.docCopyRun(rec.get('LINK'), true, parentNode);
							},
							icon: Ext.MessageBox.QUESTION
						});
					} else {
						selectDialogShow(wmc.get('Copy'), 'Копировать документ?',
							function() { me.docCopyRun(rec.get('LINK'), false, parentNode); }
						);
					}
				},
				failure: function() { me.hideLoadMask(); }
			})
		});
	},
	
	docEdit: function(initCfg, data, taskGrid, defCfg) {
		var me = this,
			cfg = {
				data: data,
				readOnly: data.readOnly,
				title: 'Документы',
				linkCode: 'SDocuments',
				parentView: taskGrid,
				isVfa: me.isVfa,
				addRecord: function(row) {
					row.children = [];
					row.leaf = true;
					data.set('leaf', false);
					return data.appendChild(row);
				},
				//метод сохранения данных
				saveData: function (endFunc, params) {
					this.callParent([
						function (result) {
							if (result.row) {
								let sel = taskGrid.getStore().findNode('LINK', result.row.LINK);
								if (sel) taskGrid.getSelectionModel().select(sel);
								taskGrid.refreshTask(result.tempTask, result.row.S_TASK);
							}
							if (result.SavedStampMUC) {
								me.sksd('STAMP', result.SavedStampMUC);
								const oldData =  JSON.parse(me.oldData);
								oldData.STAMP = result.SavedStampMUC;
								me.oldData = JSON.stringify(oldData);
								me.updateStamp(me.getLink(), result.SavedStampMUC);
							}
							if (endFunc) endFunc(result);
						}, params
					]);
				},
				createFile: function(link, callback) { this.runCreateFile(link, callback); },

				//сообщение о наличии несохраненных данных при создании файла
				createFileMsgShow: function(c) {
					Ext.Msg.show({
						title: KS.L10n.attention,
						msg: wmc.get('NeedSaveReviz'),
						buttons: Ext.MessageBox.OKCANCEL,
						buttonText: { ok: 'Сохранить', },
						fn: function(buttonId) {
							var fn = c[buttonId] || c.default;
							if (fn) fn();
						},
						icon: Ext.MessageBox.INFO
					});
				},

				runCreateFile: function(link, callback) {
					var me1 = this;
					if (this.readOnly) return _;

					me1.checkFilled(res => {
						if (!res) return false;
						var newData = me1.saveChangesFn();
						if (!me1.getLink() || newData || me.saveChangesFn()) {
							me1.createFileMsgShow({
								ok: function () {
									me.checkFilled(res => {
										if (!res) return;
										me1.saveData(function () {
											me.ownerCt.saveData(function () {
												if (me1.gksc('fileView'))
													me1.gksc('fileView').btnNew.handler();
												else if (me1.createFile)
													me1.createFile(me1.getLink(), callback);
											});
										}, newData);
									});
								}
							});
							return false;

						}
						else {
							UploaderLib.newFile(this.code, link, 0, -1, 0, this.getLoadMaskTarget(), callback);
						}
					});
				},
			};

		Ext.apply(cfg, initCfg);
		Ext.apply(cfg, defCfg);

		if (cfg.f === 'copy') me.ownerCt.docCopy(data);
		else if (cfg.f === 'edit') me.ownerCt.docShow(cfg);
		else if (cfg.f === 'addFromDF'){
			cfg.f = 'new';
			me.docShow(cfg);
		}
		else {
			let parentStack = me.ownerCt.getDocParentStack(data);
			me.showLoadMask({
				msg: KS.L10n.loading_data,
				rid: ajaxRequest({
					url: 'SDocuments/GetNewTaskDocsData_A',
					params: {
						link: data.data.REVIZ,
						docCode: dnl.REVIZ,
						taskLink: data.data.S_TASK,
						docLink: data.data.parentId === 'root' ? 0 : data.data.LINK,
						workLink: me.ksData.sWork
					},
					success: function(result) {
						me.hideLoadMask();
						if (!result.length) {
							info(wmc.get('NotChieldDoc'));
							return;
						}
						if (result.length === 1) {
							cfg.taskDocVidLink = result[0].LINK;
							me.ownerCt.pickTaskDocTypeAndEdit(result[0].TYPE, cfg);
						} else {
							me.ownerCt.getTaskDocVidDict(result, function(taskDocVid) {
								if (taskDocVid = taskDocVid[0]) {
									cfg.taskDocVidLink = taskDocVid.data.LINK;
									me.ownerCt.pickTaskDocTypeAndEdit(taskDocVid.data.TYPE, cfg);
								}
							}, parentStack);
						}
					},
					failure: function() { me.hideLoadMask(); }
				})
			});
		}

	},
	docDel: function(nodes, taskGrid) {
		var me = this;

		me.showLoadMask({
			msg: `${KS.L10n.delete}...`,
			rid: ajaxRequest({
				url: 'SDocuments/Delete_A',
				params: { code: 'DOCUMENTS', links: ArrayLib.getLinks(nodes), recursive: true, reviz: me.getLink() },
				success: function (val) {
					let value = val.delInfo,
						notDel = value.notDel;
					if (notDel && notDel.length) relationsMsg(me.code, notDel, value.notDelLinks, me.tabMode, me);

					if (val.STAMP) {
						me.sksd('STAMP', val.STAMP);
					}
					Ext.each(nodes, function (el) { value.notDelLinks.indexOf(el.data.LINK) === -1 && el.remove(); });
					if (taskGrid) {
						if (val.tempTask) {
							taskGrid.tempTask = val.tempTask;
							taskGrid.view.refresh();
						}
						taskGrid.getRootNode().cascade(function (node) {
							node.set('NEXT_DOCVIDS', null);	
						});
					}
				},
				callback: function() { me.hideLoadMask(); }
			})
		});
	},

	docAddFromDF: function(data, taskGrid) {
		let me = this;
		
		//1. получаем возможные виды документов по регламенту, ограниченные видами документов из ДО
		//2. отображаем выбор список документов из ДО
		//3. отображаем окно создания документа по выбранному док-ту из ДО в п.2
		me.showLoadMask({
			msg: KS.L10n.loading_data,
			rid: ajaxRequest({
				url: 'SDocuments/GetNewTaskDocsData_A',
				params: {
					link: data.data.REVIZ,
					docCode: dnl.REVIZ,
					taskLink: data.data.S_TASK,
					docLink: data.data.parentId === 'root' ? 0 : data.data.LINK,
					workLink: me.ksData.sWork,
					dfValid: true
				},
				success: function (result) {
					me.hideLoadMask();
					
					let taskDocs = result,
						docvids = result.map(r=>r.S_DOCVID);
					
					dictFunc({
							parentView: tabView,
							mode: 'SINGL',
							code: dnl.DF_DOCUMENTS,
							initWhereArgs: function () {
								return {
									SDocVid: {value: JSON.stringify(docvids.length ? docvids : [0]), type: 'List_int'},
									HideSDocVid: {value: true, type: 'bool'},
									DFRegistered: {value: 2, type: 'int'},
									Reviz: {value: data.data.REVIZ, type: 'int'},
									NeedProfile: {value: false, type: 'bool'},
								}
							}
						},
						{
							ok: function (value) {
								if (!value.length) return;
								let taskDoc = taskDocs.filter(td => td.S_DOCVID === value[0].data.S_DOCVID)[0];
								if (!taskDoc) return;
								//refs #434
								me.showLoadMask({
									msg: KS.L10n.loading_data,
									rid: ajaxRequest({
										url: 'SDfDocuments/CheckDfDocIsBusy_A',
										params: {
											dfDocument: value[0].data.LINK
										},
										success: function (result) {
											// Если есть сообщение о занятости записи
											if (result) {
												warning(result);
												return;
											}
											me.ownerCt.docEdit({f: 'addFromDF', taskDocVidLink: taskDoc.LINK, type: value[0].data.TYPE, dfDocuments: value[0].data.LINK}, data, taskGrid);
										},
										callback: function () {
											me.hideLoadMask();
										}
									})
								});
							}
						});
					
				},
				failure: function () {
					me.hideLoadMask();
				}
			})
		});
	},
	
	docBindDF: function(data, taskGrid) {
		let me = this;

		dictFunc({
				parentView: tabView,
				mode: 'SINGL',
				code: dnl.DF_DOCUMENTS,
				initWhereArgs: function () {
					return {
						SDocVid: {value: JSON.stringify([data.data.S_DOCVID]), type: 'List_int'},
						HideSDocVid: {value: true, type: 'bool'},
						DFRegistered: {value: 2, type: 'int'},
						Reviz: {value: data.data.REVIZ, type: 'int'},
						RNumber: {value: data.data.NUMBER, type: 'string'},
						RNumberCondition: {value: 6, type: 'int'},						
					}
				},
				beforeCreate: function (setts, callback) {
					let wa = setts.initWhereArgs();
					// Строгое сравнение с Рег №
					wa.RNumberCondition = {value: 0, type: 'int'};
					let reviz = data.data.REVIZ;
					let documents = data.data.LINK;

					let p = {
						whereArgs: JSON.stringify(wa),
						GateCode: setts.GateCode,
						controlName: setts.controlName,
						page: 1,
						pageSize: setts.pageSize,
						reload: setts.reloadData,
						needToolbar: false,
						code: setts.code
					};

					me.showLoadMask({
						msg: KS.L10n.loading_data,
						rid: ajaxRequest({
							params: { gzipData: SignalR.pack(p) },
							url: setts.linkCode + '/Get_A',
							success: function (data) {
								if (data && data.data.total === 1) {
									// refs #435 - если только одна запись - сразу привязываем
									me.ownerCt.docSetDFRelation(data.data.data[0] ? data.data.data[0].LINK : 0, taskGrid, reviz, documents);
								}
								else{
									callback(setts);
								}
							},
							callback: function() { me.hideLoadMask(); }
						})
					})
				},
			},			
			{
				ok: function (value) {
					if (!value.length) return;
					let dfDocuments = value[0].data.LINK;
					me.ownerCt.docSetDFRelation(dfDocuments, taskGrid, data.data.REVIZ, data.data.LINK);
				}
			});
	},

	docDeleteFromDF: function(data, taskGrid) {
		if (!data.data.DF_DOCUMENTS) return;
		let me = this;
					
		selectDialogShow(KS.L10n.attention, KS.L10n.TaskGrid_tstDeleteFromDF_Click_Удалить_связь_документа_с_записью_раздела__Документооборот__, ()=>{
			me.showLoadMask({
				msg: `${KS.L10n.RevizEditPresenter_DFDeleteRelation_Удаление_связи_с_записью_раздела_Документооборот}...`,
				rid: ajaxRequest({
					url: 'SDocuments/DeleteDFRelation_A',
					params: {
						dfDocuments: data.data.DF_DOCUMENTS,
						reviz: data.data.REVIZ,
						documents:  data.data.LINK
					},
					success: function (response) {
						if (!response.res) {
							if(response.message){
								warning(response.message);
							}
							return;
						}
						let sel = taskGrid.getStore().findNode('LINK', data.data.LINK);
						if (sel) {
							sel.set('DF_DOCUMENTS', null);
							sel.set('HAS_DF_DOCUMENTS', false);
							let sm = taskGrid.getSelectionModel();
							sm?.fireEvent('selectionchange', sm, [sel]);
						}
					},
					callback: function () {
						me.hideLoadMask();
					}
				})
			});
		});
		
	},

	docSetDFRelation: function (dfDocuments, taskGrid, reviz, documents) {
		let me = this;
		if (!dfDocuments) return;
		me.showLoadMask({
			msg: KS.L10n.loading_data,
			rid: ajaxRequest({
				url: 'SDocuments/AddDFRelation_A',
				params: {
					dfDocuments: dfDocuments,
					reviz: reviz,
					documents: documents
				},
				success: function (result) {
					if (!result.res) {
						if(result.message){
							warning(result.message);
						}
						return;
					}
					let sel = taskGrid.getStore().findNode('LINK', documents);
					if (sel) {
						sel.set('DF_DOCUMENTS', dfDocuments);
						sel.set('HAS_DF_DOCUMENTS', true);
						let sm = taskGrid.getSelectionModel();
						sm?.fireEvent('selectionchange', sm, [sel]);
					}
				},
				callback: function () {
					me.hideLoadMask();
				}
			})
		});
	},

	setAccessTaskGrid: function(sTask){
		var th = this,
			taskAccessEdit = th.ksData.NastrTaskAccessEdit,
			userGroupEdit = th.ksData.NastrUserGroupEdit,
			personClosed = th.ownerCt.ksControls.CLOSE_PERSON.getValue(),
			access = ((personClosed[0] && personClosed[0].LINK !== window.user.person.data.LINK));

		if (Ext.Array.contains(taskAccessEdit, sTask) && access){
			var canEdit = Ext.Array.contains(userGroupEdit, window.user.id) || !!Ext.Array.intersect(userGroupEdit, th.ksData.UserGroups).length;
			th.setKsReadOnly(!canEdit);
			th.gksc('saveBtn', true).setKsReadOnly(!canEdit);
			th.ownerCt.readOnly = !canEdit;
		}
		else {
			th.setKsReadOnly(th.ownerCt.ksReadOnly);
			th.gksc('saveBtn', true).setKsReadOnly(th.ownerCt.ksReadOnly);
			th.ownerCt.readOnly = th.ownerCt.ksReadOnly;
		}
	},
	//#endregion Работа с документами

	//#region Загрузка данных 
	loadData: function() {
		var me = this;
		if (me.activetab === 'tabAp'){
			var tab = me.getTab.call(me, 'Ap');
			me.changeTab(tab, true);
			tab.loadData();
		}
		else me.getKsControl(me.gksc(me.activetab).hidden ? 'General' : me.activetab, true, true).loadData();
	},
	getExtra: function(endFunc) {
		var th = this,
			ksData = th.ksData;

		if (th.f === "copy") {
			ksData.sameLink = ksData.link;
		}

		ksData.linkSelf = (th.data && th.data.data.linkSelf) || 0;
		ksData.childType = (th.data && th.data.data.childType) || 0;
		th.ownerCt.needRemoveBusy = true;
		th.baseGetExtra({
			link: ksData.link,
			linkSelf: ksData.linkSelf,
			infoLinks: th.ownerCt.infoLinks || [],
			linkPlanReviz: ksData.linkPlanReviz,
			orderLink: ksData.orderLink,
			appealLink: ksData.appealLink,
			tab: th.tabKey,
			whereArgs: JSON.stringify(th.whereArgs),
			childType: ksData.childType,
			RevizTask: th.gksd('RevizTask') || 0,
			RevizTaskWork: th.gksd('RevizTaskWork') || null,
			needResource: true,
		}, function(value) {
			th.setExtra(value, endFunc);

			if (endFunc) {
				//Заполнение данных нижней панели
				//Устарело но пока оставлю
				//ksData.RevizStatus = value.RevizStatus;
				//ksData.statuses = value.statuses;
				if (ksData.closePerson.LINK && ksData.closePerson.LINK > 0) {
					th.gksc('CLOSE_PERSON', true).setValue(ksData.closePerson);
					th.gksc('CHECK_CLOSE_PERSON', true).setValue(true);
				}

				endFunc();
			}

			if (value.isAp) {
				th.ownerCt.changeTab(th.getTab.call(th.ownerCt, 'Ap'), true);
			}

			var linkSelf = th.data ? th.data.data.LINK_SELF || th.data.data.linkSelf : _;
			th.ownerCt.tabRevizTaskAccess = value.tabRevizTaskAccess;
			if (!linkSelf && value.tabRevizTaskAccess.tabRevizTask !== 0) {
				th.ownerCt.changeTab(th.getTab.call(th.ownerCt, 'RevizTask'), true);
			}
		});
		if (th.ownerCt) th.ownerCt.ridGetExtra = th.ridGetExtra; 
	},

	createTabAp: function () {
		var me = this
		res = me.sksc('Ap', Ext.create('Keysystems.Reviz.Edit.Ap', {
			isVfa: me.isVfa, parentTitle: me.ksControls.view.title
		}));
		return res;
	},

	createTabRevizTask: function () {
		var me = this,
			res = me.sksc('RevizTask', Ext.create('Ext.panel.Panel', {
				title: 'Задание на проведение КМ',
				layout: { type: 'vbox', align: 'stretch' },
				flex: 1,
				listeners: {
					activate: function() {
						me.gksc('RevizTaskDict').baseRefresh.call(me.gksc('RevizTaskDict'), Ext.emptyFn, {
							GateCode: 'DOCUMENT_REVIZTASK',
							filter: '',
							page: 1,
							whereArgs: me.gksc('RevizTaskDict').getWhereArgs(),
							pageSize: 37
						});
					}
				},
				isFilled: () => true,
				checkFilled: async function(callback) {
					if (callback) callback(true);
				},
				dataCollector: Ext.emptyFn,
				tabKey: 'RevizTask',
				setKsReadOnly: function(val) {
					me.gksc('RevizTaskDict').setKsReadOnly(val);
				}
			}));

		me.sksc('RevizTaskDict', Ext.create('Keysystems.RevizTask.List', {
			title: 'Задание на проведение КМ',
			viewCfg: function () {
				var r = this.callParent(arguments);
				r.flex = 1;
				return r;
			},
			head: false,
			readOnly: me.readOnly,
			flex: 1,
			tabMode: true,
			closable: false,
			fromToolbar: false,
			code: 'DOCUMENT_REVIZTASK',
			editClass: 'Keysystems.RevizTask.Edit',
			deleteCode: 'DOCUMENT_REVIZTASK',
			checkModel: false,
			linkCode: 'SRevizTask',
			parentView: res,
			hidePagging: true,
			pageSize: 1000,
			getWhereArgs: function () {
				var dt = me.getKsControl('General', true, true).gksc('DT').getValue();
				return {
					Reviz: {
						value: me.ksData.link,
						type: 'int'
					},
					Year: {
						value: dt.dh1.getFullYear(),
						type: 'int'
					},
					MainRevizDT1: {
						value: dt.dh1.toDateString(),
						type: 'Date'
					}
				};
			},
			_arrReadTBarBtns: []
		}));

		return res;
	},

	//Данные для всех табов
	setExtra: function(value) {
		var th = this;

		th.sksd('tRevizObjects', value.tRevizObjects || []);
		th.sksd('tRevizAudit', value.tRevizAudit || []);
		th.sksd('revizDocs', { links: value.revizDocs || [], extra: {}, save: {}, docMoney: value.docMoney });
		th.sksd('docMoney', value.docMoney);
		th.sksd('revizorStatus', value.revizorStatus);
		th.sksd('RevizStatus', value.RevizStatus);
		th.sksd('STATUS', value.STATUS);
		th.gksc('STATUS', true).setValue(miscTypes.RevizStatus[value.statuses]);
		th.sksd('closePerson', value.closePerson);
		th.sksd('PersonClosedAccess', value.PersonClosedAccess);
		th.sksd('AutoFillPersonClosed', value.AutoFillPersonClosed);
		th.sksd('DT', { dh1: new Date(value.dt1), dh2: new Date(value.dt2) });
		th.sksd('DTMONEY', { dh1: new Date(value.dtmoney1), dh2: new Date(value.dtmoney2) });
		if (value.sPerson) th.sksd('sPerson', value.sPerson.data);
		if (value.isAuthority) th.sksd('sAuthority', value.sAuthority.data);
		th.sksd('isMaskedProps', value.isMaskedProps);
		th.sksd('nastrRecalcProp', value.nastrRecalcProp);
		th.sksd('showRecalcNarProp', value.showRecalcNarProp);
		th.sksd('canEditPropNastr', value.canEditPropNastr);
		th.sksd('propNarLinks', value.propNarLinks);
		th.sksd('propDisLinks', value.propDisLinks);
		th.sksd('tRevizSAuthority', value.tRevizSAuthority || []);
		th.sksd('NastrTaskAccessEdit', value.NastrTaskAccessEdit);
		th.sksd('NastrUserGroupEdit', value.NastrUserGroupEdit);
		th.sksd('UserGroups', value.UserGroups);
		th.sksd('CollapseListDocuments', value.CollapseListDocuments);
		th.sksd('reports', value.reports);
		th.sksd('isPrint', value.isPrint);
		th.sksd('DFAccess', value.DFAccess);

		if (window.dbConfigName === 'RFN') {
			th.gksc('CHECK_CLOSE_PERSON', true, true).setBoxLabel('Редактирование запрещено');
		}

		// При редактировании КМ по Заданию
		if (value.RevizTask) th.sksd('RevizTask', value.RevizTask);
		if (value.RevizTaskDeadLine) th.sksd('RevizTaskDeadLine', value.RevizTaskDeadLine);

		let print = th.gksc('printBtn', true, true);
		if (value.isPrint) {
			let itms = [],
				mode = KsLib.getKeyByValue(miscTypes.ReportPrintMode, 'Reviz');

			for (let key in value.reports) {
				itms.push({
					link: key,
					code: value.reports[key].objectCode,
					text: value.reports[key].name,
					sysCode: value.reports[key].code,
					noNeedForm: value.reports[key].noNeedForm,
					mode: mode,
					parentLink: th.objs.link || th.ownerCt.objs.link
				});
			}

			print.setMenu(Ext.create('Ext.menu.Menu', {
				items: itms,
				listeners: {
					click: function(menu, item) {
						print.defReport = item.link;
						th.ownerCt.openReport(item);
					}
				}
			}));
		} else {
			print.setVisible(false);
		}
	},

	updRecord: function(row) {
		var me = this;
		if (row) {
			if ((me.ksData.link || row.LINK) && me.data) {
				me.setRecord(row, me);
			} else {
				me.data = me.addRecord(row);
			}
		}
		me.selectRecord(me.data);
	},

	initLoadingMaskCfg: function() {
		let me = this,
			cfg = me.callParent(arguments);
		if (cfg.opaque && me.prevTab){
			cfg.opaque = false;
		}
		return cfg;
	},
	afterCancelLoad: function(){
		const me = this;
		me.saveChanges = false;
		me.ownerCt.isExit = true;
		if (me.prevTab){
			me.setActiveTab(me.prevTab)
		}
		else {
			me.objs.view.close();
		}
	},
	//#endregion Загрузка данных 

	//#region Сохранение данных
	
	checkSave: function(newTab, callBack) {
		var me = this;
		var newData = me.saveChangesFn();
		
		const nextFn = ()=>{
			if (me.activeTab.f === 'readOnly') {
				callBack();
				return true;
			}
			if (newData || !me.ksData.link) {
				if (!newData) newData = JSON.parse(me.activeTab.oldData);
				newData.nextTab = newTab.tabKey;
				me.changeTabMsgShow({ ok: function() { me.saveData(callBack, newData); } });
				return false;
			}
			callBack();
			return true;
		}

		if (newData || !me.ksData.link){
			me.checkFilled(res=>{
				if (!res) return;
				nextFn();
			})
		} 
		else 
			nextFn();
		return false;
	},	
	saveChangesFn: function() {
		var me = this,
			tab = me.activeTab,
			newData = tab.dataCollector();

		return (me.saveChanges && (tab.oldData !== JSON.stringify(newData))) ? newData : _;
	},
	checkFilled: function(callback) {
		const me = this,
			tab = me.activeTab;
		tab.checkFilled(callback);
	},
	checkData: function () {
		const me = this,
			tab = me.activeTab;
		tab.checkData();
	},
	saveData: function (endFunc, inputParams) {
		if (this.activeTab === this.gksc('RevizTask')) return;
		var me = this,
			ksData = me.ksData,
			tab = me.activeTab,
			nextTabName,
			recalcPropFn = function() {
				var isMaskedProps = me.gksd('isMaskedProps'),
					showMsg = me.gksd('nastrRecalcProp') === 1 && isMaskedProps,
					haveNarRecs = me.gksd('propNarLinks').length,
					haveDisRecs = me.gksd('propDisLinks').length,
					factnarGrid = tab.gksc('factNarGrid'),
					disGrid = tab.gksc('disGrid'),
					checked = false;

				// скорректируем данные
				if (me.activeTab.tabKey === 'Nar' && isMaskedProps) {
					if (factnarGrid) {
						haveNarRecs = factnarGrid.store.getDataExt().length;
					}
					if (disGrid) {
						haveDisRecs = disGrid.store.getDataExt().length;
					}
				}

				if (showMsg && (haveNarRecs || haveDisRecs)) {
					var title = '',
						msg = '';
					if (haveNarRecs && haveDisRecs) {
						title = KS.L10n.RevizEditView_BeforeRecalcFactnarProps_Пересчет_реквизитов_нарушений_и_недостатков;
						msg = KS.L10n.RevizEditView_BeforeRecalcFactnarProps_Пересчитать_реквизиты_нарушений_и_недостатков_;
					} else {
						title = haveNarRecs
							? KS.L10n.RevizEditView_BeforeRecalcFactnarProps_Пересчет_реквизитов_нарушений
							: KS.L10n.RevizEditView_BeforeRecalcFactnarProps_Пересчет_реквизитов_недостатков;
						msg = haveNarRecs
							? KS.L10n.RevizEditView_tsbReCalcNarProp_Click_Пересчитать_реквизиты_нарушений_
							: KS.L10n.RevizEditView_tsbReCalcNarProp_Click_Пересчитать_реквизиты_недостатков_;
					}
					Ext.Msg.show({
						title: title,
						msg: msg,
						buttonText: { yes: 'Да', no: 'Нет'},
						fn: function (buttonId) {
							me.sksd('showPropQuestion', !checked);
							me.sksd('isRecalcProp', buttonId === 'yes')
							// при смене табов dataCollector вызывается до окна с вопросом,
							// поэтому запишем еще и в inputParams
							if (inputParams) {
								inputParams.isRecalcProp = buttonId === 'yes';
							}

							callBack();
						},
						checkVisible: me.gksd('canEditPropNastr'),
						checkHandler: function(th, check) {
							checked = check;
						},
						icon: Ext.MessageBox.QUESTION
					});
				} else {
					callBack();
				}
			},
			callBack = function() {
				ksData.isActual = {};
				ksData.extras = {};
				tab.saveData(function(res) {
					var newTab = me.gksc(nextTabName) || tab;
					ksData.link = me.link = res.SavedLink;
					me.f = 'edit';
					me.data = me.activeTab.data;
					me.infoLinks = [];

					//Данные для нового таба
					if (res.value) {
						var v = res.value;
						ksData.sameLink = 0;
						ksData.revizDocs.links = v.revizDocs || [];
						ksData.revizDocs.extra = {};
						ksData.revizDocs.save = {};

						me.sksd('bindTRevizDocs', res.bindTRevizDocs);

						if (newTab.setExtra) newTab.setExtra(v);

						//если заданы формулы автозаполнения для Закрыл, то они сработают при сохранении => значения отобразим в UI
						if (v.closePerson?.LINK && me.gksc('CLOSE_PERSON').getLink() !== v.closePerson.LINK) {
							me.gksc('CLOSE_PERSON', true).setValue(v.closePerson);
							me.gksc('CHECK_CLOSE_PERSON', true).setValue(true);
						}
						else if (v.readOnly || v.closePerson?.LINK) {
							me.setReadOnly.call(me.activeTab, true, v.readOnly ? v.readOnlyReason : "Мероприятие закрыто");
						}
					}

					if (res.hasOwnProperty('nastrRecalcProp')) {
						me.sksd('nastrRecalcProp', res.nastrRecalcProp);
					}
					me.sksd('isRecalcProp', _);
					me.sksd('showPropQuestion', _);

					//Необходимо, т.к. иначе в oldData будут устаревшие данные
					if (res.result && newTab) {
						//После setExtra иногда данные меняются, поэтому в старом табе обновляем oldData
						tab.oldData = JSON.stringify(tab.dataCollector());
						newTab.oldData = JSON.stringify(newTab.dataCollector());
					}
					if (endFunc) endFunc();
				}, inputParams);
			};

		if (inputParams && !inputParams.isClosed) {
			nextTabName = inputParams.nextTab || tab.tabKey;
		}

		switch (tab.tabKey) {
			case 'General':
				me.ksData.NumberUnique ? tab.checkNumDate(recalcPropFn) : recalcPropFn();
				break;
			case 'Formalize':
				tab.checkSaveTab(recalcPropFn);
				break;
			default:
				recalcPropFn();
		}
	},
	successSaveFunc: function(result, endFunc, inputParams) {
		const me = this,
			tab = me.activeTab;

		if (result.CheckSaveResult) {
			tab.parseCheckSaveResult(result.CheckSaveResult, function (checkSaveResult) {
				let params = tab.dataCollector();
				params.processCheckSave = false;
				params.checkSaveResult = checkSaveResult;
				params.nextTab = inputParams.nextTab;
				tab.saveData(endFunc, params);
			})
			return;
		}

		tab.callParent(arguments);
	},
	setLink: function(link){
		this.callParent(arguments);
		this.link = link;
	},
	dataCollector: function(res) {
		var me = this,
			ksData = me.ksData,
			rd = ksData.revizDocs,
			dt = me.ksControls.General.ksControls.DT.getValue();

		res.link = ksData.link = me.link || 0;
		res.sameLink = ksData.link === 0 ? ksData.sameLink || 0 : 0;
		res.closePerson = me.ksControls.CHECK_CLOSE_PERSON.getValue() ? me.ksControls.CLOSE_PERSON.getLink() : 0;
		res.docLinks = JSON.stringify(rd.links);
		res.docSaves = JSON.stringify(rd.save);
		res.docMoney = JSON.stringify(rd.docMoney);
		res.CHILD_TYPE = me.gksd('childType');
		res.infoLinks = me.infoLinks;
		res.linkSelf = ksData.linkSelf;
		res.STAMP = ksData.STAMP;

		if (dt) {
			res.DT1 = dt.dh1.toDateString();
			res.DT2 = dt.dh2.toDateString();
		} else {
			res.DT1 = "";
			res.DT2 = "";
		}

		res.showPropQuestion = me.gksd('showPropQuestion');
		res.isRecalcProp = me.gksd('isRecalcProp');

		res.isVfa = me.isVfa;
		if (me.gksd('RevizTaskDeadLine')) res.RevizTaskDeadLine = me.gksd('RevizTaskDeadLine');
		if (me.gksd('RevizTask')) res.RevizTask = me.gksd('RevizTask');

		return res;
	},
	//#endregion Сохранение данных

	setAccessStore: function(access) {
		let me = this,
			tabKey = me.tabKey;
		
		me.sksd('access' + tabKey, access);
	},
	getAccessStore: function() {
		let me = this,
			tabKey = me.tabKey;

		return me.gksd('access' + tabKey);
	}
});