﻿//Таб Принятые меры
Ext.define('Keysystems.Reviz.Edit.Resp', {
	extend: 'Keysystems.Controls.TaskGrid',
	closable: false,
	mixins: ['Keysystems.Base.Edit'],
	title: 'Принятые меры',
	tabKey: 'Resp',
	linkCode: 'SReviz',
	f: 'edit',
	flex: 1,
	dmLink: -1,	
	profileGateCode: 'edit',
	profileKey: 'taskGridResp',
	profileCode: 'DOCUMENT_REVIZ',
	bodyPadding: 0,
	ksControls: {},
	ksData: {},
	ksMethods: {},
	visibleBtnExpandCollapse: true,
	edit: function(cfg, data, defCfg) {
		var me = this;
		if (me.ownerCt.readOnly) data.readOnly = true;
		data.data.REVIZ = me.ksData.link;
		me.callKsMethod(_, 'docEdit', cfg, data, me, defCfg);
	},
	rowDelete: function(nodes) { this.callKsMethod(_, "docDel", nodes, this); },

	//#region Загрузка данных 
	loadData: function() {
		this.mixins['Keysystems.Base.Edit'].loadData.call(this);
	},
	loadCopyEditData: Ext.emptyFn,
	getExtra: function(endFunc) {
		this.ownerCt.getExtra.call(this, endFunc);
	},
	setExtra: function(value) {
		var me = this;

		me.ownerCt.setExtra.call(me, value);
		me.tempTask = value.tempTask;
		me.dfAccess = me.gksd('DFAccess');
		me.loadData1(value['tasks' + me.tabKey + 'Data']);
		me.collapseAllNode(value.CollapseListDocuments);
		me.ksData.isActual[me.tabKey] = true;
		me.ksData.access = value.access;
		me.setAccessStore(value.access);
		me.setKsReadOnly(me.ownerCt.ksReadOnly);
	},
	getExtraNew: function(endFunc) { this.getExtra(endFunc); },
	setKsReadOnly: function(v) {
		let me = this,
			res = me.callParent(arguments);
		if (v || !me.ksData.access) return;

		if (me.ksData.access.GRID_TASK_RESPONS !== _ && (me.ksData.access.GRID_TASK_RESPONS & ObjAccessMask.EDIT) !== ObjAccessMask.EDIT){
			this.setReadOnly(true);
		}		
		return res;
	},

	afterCancelLoad: function() {
		this.ownerCt.afterCancelLoad();
	},
	initLoadingMaskCfg: function() {
		return this.ownerCt.initLoadingMaskCfg();
	},	
	//#endregion Загрузка данных 

	//#region Сохранение данных
	dataCollector: function() {
		var me = this,
			res = me.ownerCt.dataCollector({});

		res.tab = me.tabKey;
		return res;
	},
	isFilled: function() {
		return true;
	},
	successSaveFunc: function(result, endFunc, inputParams){
		this.ownerCt.successSaveFunc(result, endFunc, inputParams);
	},
	getTitle: function() {
		return this.parentTitle + ' - ' + this.title;
	},
	setAccessBtns: function (sels) {
		var th = this,
			owner = th.ownerCt,
			sTask = sels.length ? sels[0].data.S_TASK : 0;
		owner.setAccessTaskGrid.call(th, sTask);
	},
	addFromDF: function(cfg, data) {
		let me = this;
		data.data.REVIZ = me.ksData.link;
		me.callKsMethod(_, "docAddFromDF", data, me);
	},
	bindDF: function(cfg, data) {
		let me = this;
		data.data.REVIZ = me.ksData.link;
		me.callKsMethod(_, "docBindDF", data, me);
	},
	deleteFromDF:  function(cfg, data) {
		let me = this;
		data.data.REVIZ = me.ksData.link;
		me.callKsMethod(_, "docDeleteFromDF", data, me);
	}
	//#endregion Сохранение данных
});