﻿//Таб Подготовка
Ext.define('Keysystems.Reviz.Edit.Prepare', {
	extend: 'Ext.panel.Panel',
	closable: false,
	mixins: ['Keysystems.Base.Edit'],
	title: 'Подготовка',
	tabKey: 'Prepare',
	f: 'edit',
	sRProgLink: -1,
	progPersonLink: -1,
	calcLink: -1,
	dmLink: -1,
	linkCode: 'SReviz',
	height: 600,
	layout: {type: 'vbox', align: 'stretch'},
	bodyPadding: 0,
	labelWidth: 150,
	border: false,
	readOnlyList: ['S_RTEMA', 'S_RPROG_Grid', 'taskGridPrepare'],
	arrDisable: [
		'PrepateBtnDict', 'PrepateBtnDel', 'PrepateBtnFill', 'PrepateBtnMoveTop', 'PrepateBtnMoveUp',
		'PrepateBtnMoveDown', 'PrepateBtnMoveBottom'
	],

	profileListeners: [
		{ name: 'ProgRequestPanel', method: 'resizeW' },
		{ name: 'taskGridPrepare', method: 'resizeH' }
	],

	initComponent: function() {
		var me = this;

		me.beforeInitComponent();
		me.createItems();
		me.callParent(arguments);
	},

	listeners: {		
		add: function (me, item) {
			if (item.xtype == 'bordersplitter') item.width = 8;
		}
	},
	
	//#region Создание компонентов
	createItems: function() {
		var me = this,
			ksControls = me.ksControls;

		me.items = [
			Ext.create('Ext.form.FieldContainer', {
				layout: { type: 'vbox', align: 'stretch' },
				padding: '5 10 0 10',
				items: [
					me.sksc('S_RTEMA', Ext.create('Keysystems.Controls.Dict.Edit',
						{
							labelWidth: me.labelWidth,
							fieldLabel: 'Тема',
							hidden: true,
							mode: me.ksData.multiTema ? 'MULTI' : 'SINGL',
							clear: function() {
								this.ksSetValue();
							},
							ksSetValue: function(value) {
								me.gksc('S_RTEMA').setValue(value);
								var len = value && value.length,
									revizVid = me.gksc('REVIZ_VID');

								if (me.gksc('S_RPROG_Grid').isVisible() && !me.gksc('S_RPROG_Grid').isReadOnly()) {
									if (len) {
										var list = [];
										for (var i = 0; i < len; i++) {
											list.push(value[i].data.LINK);
										}
										me.getSRTemaRProg(list,
											function(val) {
												me.ksData.sRtemaSRprog = val;
												selectDialogShow(me.resource.RevizEditView_dictRTema_Changed_Вопросы_программы,
													me.resource.RevizEditView_dictRTema_Changed_Заполнить_вопросы_из_типовой_программы_,
													function() {
														me.setSRProgAllGroups(val);
													});
											});
									} else {
										me.ksData.sRtemaSRprog = [];
										selectDialogShow(me.resource.RevizEditView_dictRTema_Changed_Вопросы_программы,
											me.resource.RevizEditView_dictRTema_Changed_Очистить_вопросы_программы_,
											function() {
												me.setSRProgAllGroups([]);
											});
									}
								}

								let sName = [];
								if (revizVid.isVisible()) {
									if (len > 0) {
										Ext.each(value,
											function(d) {
												if (d.get('SNAME') && d.get('SNAME').length) {
													sName.push(d.get('SNAME'));
												}
											});
									}
									revizVid.setValue(sName.join('; '));
								}
							},
							handler: function() {
								dictFunc({
										mode: me.ksData.multiTema ? 'MULTI' : 'SINGL',
										initWhereArgs: function() {
											var dh = me.gksd('DT'),
												whereArgs = {
													DH1: { value: dh.dh1.toDateString(), type: 'Date' },
													DH2: { value: dh.dh2.toDateString(), type: 'Date' },
													SPlan: {
														value: JSON.stringify(me.gksd('sPlans') || []),
														type: 'List_int'
													}
												};

											if (me.isVfa) {
												// Добавляем Ограничение по объекту контроля
												var revObjs = me.gksd('tRevizObjects');
												var orgs = [];
												var otdels = [];

												if (revObjs) {
													revObjs.filter(rec => rec.LINK_SELF === null && rec.TYPE === 64 ).forEach(rec => orgs.push(rec.TLINK));//RevizObjType.СП = 64
													revObjs.filter(rec => rec.TYPE === 1 ).forEach(rec => {if(orgs.indexOf(rec.TLINK) === -1)orgs.push(rec.TLINK)});//RevizObjType.ЮЛ = 1

													var parentLinks = [];
													revObjs.filter(rec => rec.LINK_SELF === null && rec.TYPE === 64 ).forEach(rec => parentLinks.push(rec.LINK));//RevizObjType.СП = 64
													revObjs.filter(rec => parentLinks.includes(rec.LINK_SELF) && rec.TYPE === 64).forEach(rec => otdels.push(rec.TLINK));
												}

												whereArgs.OrgsLimit = {
													value: JSON.stringify(orgs),
													type: 'List_int'
												}

												whereArgs.OtdelsLimit = {
													value: JSON.stringify(otdels),
													type: 'List_int'
												}
											}

											return whereArgs;
										},
										parentView: objs.view,
										selectLinks: me.gksc('S_RTEMA').getValue(),
										code: me.isVfa ? dnl.S_RTEMA_VFA : dnl.S_RTEMA,
										readOnly: me.gksc('S_RTEMA').readOnly,
										control: me.gksc('S_RTEMA'),
										contextSearch: me.gksc('S_RTEMA').contextSearch
									},
									{
										ok: function(value) {
											me.gksc('S_RTEMA').ksSetValue(value);
										}
									});
							}
						})),
					me.sksc('REVIZ_VID', Ext.create('Ext.form.field.Text', {
						fieldLabel: 'Вид КМ',
						labelWidth: me.labelWidth,
						readOnly: true,
						hidden: true
					}))
				]
			}),
			me.sksc('rProgContainer', Ext.create('Ext.form.FieldContainer', {
				layout: {type: 'hbox', align: 'stretch'},
				flex: 1,
				items: [
					me.sksc('S_RPROG_Grid', Ext.create('Keysystems.Controls.GroupingGrid', {
						code: me.code,
						hidden: true,
						sortCol: 'ORD',
						border: 0,
						GateCode: 'edit',
						profileKey: 'S_RPROG_Grid',
						layout: 'fit',
						resizable: true,
						minHeight: 60,
						flex: 5,
						viewConfig: {
							layout: { type: 'vbox', align: 'stretch' }
						},
						plugins: [
							Ext.create('Ext.grid.plugin.CellEditing', {
								clicksToEdit: 1,
								isDhSwap: true,
								dhSwapFields: ['DT', 'DTMONEY'],
								listeners: {
									beforeedit: function() {
										return !me.readOnly;
									},
									ksAfteredit: function(editor, e) {
										const message = me.checkDtWarning(e.grid.getFrstSelect());
										if (message) warning(message);
									}
								}
							}),
							'gridclipboard'
						],
						listeners: {
							beforeselect: function(th, record) {
								var emptyRec = record.get('LINK') === 0;

								me.gksc('revizProgs_Dict').setReadOnly(this.readOnly || emptyRec);
								me.setProgPersonValue(record);

								if (me.gksd('isDocReq')) me.filterDocReq(record.get('T_REVIZ_OBJECTS'), record.get('S_RPROG'), me.gksc('requestCombo').getValue());

								var grid = me.gksc('S_RPROG_Grid'),
									selectedGroup = grid.selectedGroup || record.data.group;

								grid.setGroupSelect(th.view.id, selectedGroup, emptyRec ? false : selectedGroup);
							}
						},
						tbar: [
							me.sksc('PrepateBtnDict', Ext.create('Ext.Button', {
								iconCls: 'x_btn_dict',
								tooltipType: 'title',
								handler: function() {
									const grid = ksControls.S_RPROG_Grid,
										sel = grid.getFrstSelect();

									if (sel) {
										var list = [],
											groupName = sel.data.group,
											groupLink = sel.data.T_REVIZ_OBJECTS,
											gData = grid.store.getClearData(groupName),
											len = gData.length,
											i = 0;
										for (; i < len; i++) {
											if (gData[i].S_RPROG) {
												list.push({ data: { LINK: gData[i].S_RPROG } });
											}
										}
										dictFunc({
											mode: 'MULTI',
											parentView: me.getKsControl('view', true, true),
											checkList: list,
											code: dnl.S_RPROG,
											getChecks: function() {
												//Вместо линков возврат нормальных данных
												var data = this.gridStore.getDataExt(),
													result = [],
													rowsRevizSrprog = me.ksControls.S_RPROG_Grid.store.getClearData();
												let rowsSRprog = this.checkList.map(r => r.data || r).sort(sortByCode);
												for (var i = 0, len = rowsSRprog.length; i < len; i++) {
													var d = rowsSRprog[i];
													if (d) {
														d = d.data || d;
														var pos = ArrayLib.find(data, ['LINK'], d.LINK);
														var rowRevizSrprog = ArrayLib.filter(rowsRevizSrprog, ['S_RPROG'], d.LINK);
														if (pos !== -1) {
															if (rowRevizSrprog.length) {
																data[pos].ORD = rowRevizSrprog[0].ORD;
																data[pos].ORD_NUM = rowRevizSrprog[0].ORD_NUM;
															}
															result.push(data[pos]);
														}
													}
												}

												return result;
											}
										}, {
											ok: function(value) {
												me.setSRProg(value, groupName, groupLink);
												me.updateRevizProgsOrdNum();
											}
										});
									}
								}
							})),
							me.sksc('PrepateBtnDel', Ext.create('Ext.Button', {
								iconCls: 'x_btn_delete',
								tooltipType: 'title',
								handler: function() {
									var grid = me.gksc('S_RPROG_Grid'),
										sel = grid.getFrstSelect();

									if (sel && sel.get('LINK') !== 0) {
										selectDialogShow(KS.L10n.delete, me.resource.RevizEditView_tsbProgDelete_Click_Удалить_вопрос_данного_объекта_, function () {
											sel.get('LINK') === 0 ? grid.deleteGroupData(sel.get('group')) : grid.store.remove(sel);
											delete me.gksd('progPerson')[sel.get('LINK')];
										});
									} else {
										selectDialogShow(KS.L10n.delete, me.resource.RevizEditView_tsbProgDelete_Click_Удалить_все_вопросы_данного_объекта_, function () {
											grid.deleteGroupData(sel ? sel.get('group') : Ext.emptyObj);
											me.sksd('progPerson', {});
										});
									}
								}
							})),
							me.sksc('PrepateBtnFill', Ext.create('Ext.Button', {
								iconCls: 'x_btn_fill',
								tooltipType: 'title',
								handler: function() {
									if (!me.gksc('S_RTEMA').isEmpty()) {
										selectDialogShow(me.resource.RevizEditView_dictRTema_Changed_Вопросы_программы, me.resource.RevizEditView_dictRTema_Changed_Заполнить_вопросы_из_типовой_программы_, function() {
											me.setSRProgAllGroups(me.ksData.sRtemaSRprog);
										});
									} else warning(me.resource.RevizEditView_tsbProgFill_Click_Выберите_тему_);
								}
							})),
							'-',
							me.sksc('PrepareBtnExpand', Ext.create('Ext.Button', {
								iconCls: 'x_btn_treeexpand',
								tooltipType: 'title',
								handler: function() {
									var grid = ksControls.S_RPROG_Grid;
									grid.selModel.deselectAll();
									grid.features[0].expandAll();
								}
							})),
							me.sksc('PrepareBtnCollapse', Ext.create('Ext.Button', {
								iconCls: 'x_btn_treecollapse',
								tooltipType: 'title',
								handler: function() {
									var grid = ksControls.S_RPROG_Grid;
									grid.selModel.deselectAll();
									grid.features[0].collapseAll();
								}
							})),
							me.sksc('PrepateBtnMoveTop', Ext.create('Ext.Button', {
								iconCls: 'x_btn_top',
								tooltipType: 'title',
								handler: function() {
									me.sRProgRowMove(function(rows, iPos) {
										if (iPos > 0) {
											var tmp = rows[iPos];
											rows.splice(iPos, 1);
											rows.unshift(tmp);
											return true;
										}
										return false;
									});
								}
							})),
							me.sksc('PrepateBtnMoveUp', Ext.create('Ext.Button', {
								iconCls: 'x_btn_up',
								tooltipType: 'title',
								handler: function() {
									me.sRProgRowMove(function(rows, iPos) {
										if (iPos > 0) {
											var tmp = rows[iPos];
											rows[iPos] = rows[iPos - 1];
											rows[iPos - 1] = tmp;
											return true;
										}
										return false;
									});
								}
							})),
							me.sksc('PrepateBtnMoveDown', Ext.create('Ext.Button', {
								iconCls: 'x_btn_down',
								tooltipType: 'title',
								handler: function() {
									me.sRProgRowMove(function(rows, iPos) {
										if (iPos < rows.length - 1) {
											var tmp = rows[iPos];
											rows[iPos] = rows[iPos + 1];
											rows[iPos + 1] = tmp;
											return true;
										}
										return false;
									});
								}
							})),
							me.sksc('PrepateBtnMoveBottom', Ext.create('Ext.Button', {
								iconCls: 'x_btn_bottom',
								tooltipType: 'title',
								handler: function() {
									me.sRProgRowMove(function(rows, iPos) {
										if (iPos < rows.length - 1) {
											var tmp = rows[iPos];
											rows.splice(iPos, 1);
											rows.push(tmp);
											return true;
										}
										return false;
									});
								}
							})),
							me.sksc('PrepateBtnRecalcBottom', Ext.create('Ext.Button', {
								iconCls: 'x_btn_calcauto',
								tooltipType: 'title',
								handler: function() {
									me.updateRevizProgsOrdNum();
								}
							}))
						]
					})),
					{xtype: 'splitter'},
					me.sksc('ProgRequestPanel', Ext.create('Ext.tab.Panel', {						
						border: 0,
						cls: 'rks-panel-edit',
						bodyCls: 'rks-panel-edit-body',
						height: '100%',
						hidden: true,
						layout: 'fit',
						header: false,
						hideCollapseTool: true,
						flex: 4,
						items: [
							me.sksc('RevizorsProgPanel', Ext.create('Ext.panel.Panel', {
									title: 'Ответственные',
									border: 0
								})
							)
						]
					})),
				]
			})),
			me.sksc('hSplitter', Ext.create('Ext.resizer.Splitter')),
			me.sksc('taskGridPrepare', Ext.create('Keysystems.Controls.TaskGrid', {
				title: 'Документы',
				header: {
					padding: '2 10 2 10'
				},
				hidden: true,
				resizable: true,
				collapsible: true,
				hideCollapseTool: window.Theme === 'crisp',
				minHeight: 80,
				height: 100,
				flex: 1,
				visibleBtnExpandCollapse: true,
				profileGateCode: 'edit',
				profileKey: 'taskGridPrepare',
				profileCode: 'DOCUMENT_REVIZ',
				
				edit: function(cfg, data) {
					data.data.REVIZ = me.ksData.link;
					if (me.ownerCt.readOnly) data.readOnly = true;
					me.callKsMethod(_, "docEdit", cfg, data, me.gksc('taskGridPrepare'));
				},
				rowDelete: function(nodes) {
					me.callKsMethod(_, "docDel", nodes, me.gksc('taskGridPrepare'));
				},
				getTitle: function() {
					return me.parentTitle + ' - ' + me.title;
				},
				setAccessBtns: function (sels) {
					var owner = me.ownerCt,
						sTask = sels.length ? sels[0].data.S_TASK : 0;
					owner.setAccessTaskGrid.call(me, sTask);
				},
				addFromDF: function(cfg, data) {
					data.data.REVIZ = me.ksData.link;					
					me.callKsMethod(_, "docAddFromDF", data, me.gksc('taskGridPrepare'));
				},
				bindDF: function(cfg, data) {
					data.data.REVIZ = me.ksData.link;
					me.callKsMethod(_, "docBindDF", data, me.gksc('taskGridPrepare'));
				},
				deleteFromDF:  function(cfg, data) {
					data.data.REVIZ = me.ksData.link;
					me.callKsMethod(_, "docDeleteFromDF", data, me.gksc('taskGridPrepare'));
				}
			}))
		];

		var tgpTbar = ksControls.taskGridPrepare.ToolBar;

		Ext.each(tgpTbar.items.items, function(btn, ind) {
			var key = 'tgpBtn' + ind;
			ksControls[key] = btn;
			me.readOnlyList.push(key);
		});

		return me.items;
	},
	//#endregion Создание компонентов

	//#region Загрузка данных 
	loadCopyEditData: Ext.emptyFn,
	getExtra: function(endFunc) {
		this.ownerCt.getExtra.call(this, endFunc);
	},
	setExtra: function(value) {
		var me = this,
			ksData = me.ksData,
			ksControls = me.ksControls;

		me.ownerCt.setExtra.call(me, value);
		
		me.resource = KS.L10n;
		ksControls.PrepateBtnDict.setTooltip(me.resource.RevizEditView_InitializeComponent_Выбрать);
		ksControls.PrepateBtnDel.setTooltip(me.resource.RevizEditView_InitializeComponent_Удалить);
		ksControls.PrepateBtnFill.setTooltip(me.resource.RevizEditView_InitializeComponent_Заполнить);
		ksControls.PrepareBtnExpand.setTooltip(me.resource.RevizEditView_InitializeComponent_Развернуть_все_узлы);
		ksControls.PrepareBtnCollapse.setTooltip(me.resource.RevizEditView_InitializeComponent_Свернуть_все_узлы);
		ksControls.PrepateBtnMoveTop.setTooltip(me.resource.RevizEditView_InitializeComponent_В_начало);
		ksControls.PrepateBtnMoveUp.setTooltip(me.resource.RevizEditView_InitializeComponent_Вверх);
		ksControls.PrepateBtnMoveDown.setTooltip(me.resource.RevizEditView_InitializeComponent_Вниз);
		ksControls.PrepateBtnMoveBottom.setTooltip(me.resource.RevizEditView_InitializeComponent_В_конец);
		ksControls.PrepateBtnRecalcBottom.setTooltip(me.resource.RevizEditView_InitializeComponent_Пересчитать_порядковый_номер);

		var tro = ksData.tRevizObjects;
		for (var i = 0, len = tro.length; i < len; i++) {
			if (!tro[i].TEMP_SNAME) tro[i].TEMP_SNAME = tro[i].TEMP_CODE;
		}

		//#region Вопросы программы
		me.genProgPerson(value.tRevizSProg.progPerson);
		ksData.S_RPROG_DATA = value.tRevizSProg.data;
		ksData.sRtemaSRprog = value.tSRtemasRprog;
		ksData.multiTema = value.multiTema;
		ksData.sPlans = value.sPlans;
		ksData.access = value.access;
		me.setAccessStore(value.access);
		
		//Настройка доступа к гриду
		if (value.access.GRID_T_REVIZ_SRPROG !== 0) {
			ksData.revProgPerson = value.REVIZORSPROG;
			me.sksc('revizProgs_Dict', me.getRevizProgsDict());
			me.gksc('revizProgs_Dict').refresh();
			me.sksd('OrdNumAcces', value.OrdNumAcces);
			ksControls.PrepateBtnRecalcBottom.setVisible((value.OrdNumAcces & ObjAccessMask.EDIT) === ObjAccessMask.EDIT);

			ksControls.S_RPROG_Grid.setVisible(true);
			ksControls.ProgRequestPanel.setVisible(true);

			var sProgGrid = ksControls.S_RPROG_Grid,
				progReadOnly = (value.access.GRID_T_REVIZ_SRPROG & ObjAccessMask.EDIT) !== ObjAccessMask.EDIT;
			sProgGrid.setReadOnly(progReadOnly);
			
			//#region GroupingGrid
			//поле group по которому будет происходить группировка
			sProgGrid.genGroupsNames.call(me, value.srprog || []);
			me.updGroupsGrid(ksData.tRevizObjects);

			value.tRevizSProg.fields.push({ name: 'MAIN', type: 'bool' });
			sProgGrid.setAdaptedFields(value.tRevizSProg.fields);
			sProgGrid.setColumns(me.groupColumnsAdapted(value.tRevizSProg.columns));
			sProgGrid.setGroupsForData(ksData.S_RPROG_DATA, sProgGrid.groups);
			if (!sProgGrid.getSelectionModel().getSelection().length) {
				sProgGrid.extraSelectFrst();
			}
			//#endregion GroupingGrid

			//#region DOCUMENTS_REQUEST
			ksData.isDocReq = value.isDocReq;
			if (value.isDocReq) {
				ksData.tObjDocs = value.tObjDocs;
				if (!me.gksc('pnlDocReq')) {
					me.gksc('ProgRequestPanel').add(me.sksc('pnlDocReq',
						Ext.create('Ext.panel.Panel',
							{
								title: 'Документы по запросам',
								border: 0,
								layout: { type: 'vbox', align: 'stretch' },
								items: [
									me.sksc('requestCombo',
										Ext.create('Keysystems.Controls.ComboBoxExtra',
											{
												padding: 10,
												fieldLabel: 'Запрос',
												labelWidth: 50,
												editable: false,
												queryMode: 'local',
												displayField: 'Name',
												valueField: 'Value',
												listeners: {
													change: function(th, val) {
														var sRprogRec = me.gksc('S_RPROG_Grid').getSelectionModel()
															.getSelection()[0];
														var obj = sRprogRec ? sRprogRec.get('T_REVIZ_OBJECTS') : null;
														if (sRprogRec) sRprogRec = sRprogRec.get('S_RPROG');
														me.filterDocReq(obj, sRprogRec, val);
													}
												},
												store: Ext.create('Ext.data.Store',
													{
														fields: [{ name: 'Value', type: 'int', useNull: true }, 'Name'],
														data: [],
														proxy: 'memory'
													})
											})),
									me.sksc('DocReqGrid',
										Ext.create('Ext.grid.Panel',
											{
												flex: 1,
												autoScroll: true,
												features: [
													{
														ftype: 'summary',
														showSummaryRow: false
													}
												],
												store: Ext.create('Ext.data.Store',
													{
														fields: [],
														data: [],
														proxy: 'memory'
													}),
												columnLines: true,
												columns: [],
												plugins: ['gridclipboard']
											}))
								],
								setReadOnly: function(state) {
									this[state ? 'addCls' : 'removeCls']('ks-readOnly');
								}
							})));
				}

				var docWithReq = value.DOCUMENTS_WITH_REQUEST,
					pos = ArrayLib.find(docWithReq, ['Value'], 0);

				pos === -1 ? docWithReq.push({ 'Name': '...', 'Value': 0 }) : docWithReq[pos].Name = '...';

				me.gksc('requestCombo').store.loadData(docWithReq, false);
				me.gksc('requestCombo').setValue(null);

				value.DOCREQUEST.columns.push({
					xtype: 'actioncolumn',
					dataIndex: 'FileColumn',
					text: 'Файл',
					minWidth: 40,
					flex: 1,
					align: 'center',
					items: [
						{
							getClass: function(v, meta, rec) {
								var files = me.getTempFiles(rec.get('LINK'));
								return files.length
									? files.length === 1
										? getExtStyle(files[0].EXTENTION)
										: 'x_btn_folder'
									: _;
							},
							handler: function(grid, rowIndex) {
								me.showFileList(grid.getStore().getAt(rowIndex));
							}
						}
					]
				});

				ksData.T_DOCREQUEST_FILES = value.T_DOCREQUEST_FILES;
				ksData.docReqData = value.DOCREQUEST.data;
				me.gksc('DocReqGrid').setMetaDate(value.DOCREQUEST,
					{
						profileCode: me.code,
						profileKey: 'DocReqGrid',
						gateCode: me.keyEdit
					});
			}
			//#endregion DOCUMENTS_REQUEST
		}
		else {
			me.gksc('rProgContainer').setVisible(false);
			me.gksc('hSplitter').setVisible(false);
		}
		//#endregion Вопросы программы

		//#region Документы
		if (value.access.GRID_TASK_PREPARE) {
			var taskGrid = ksControls.taskGridPrepare;			
			taskGrid.setVisible(true);
			if ((value.access.GRID_TASK_PREPARE & ObjAccessMask.EDIT) !== ObjAccessMask.EDIT)
				taskGrid.setReadOnly(true);
			taskGrid.tempTask = value.tempTask;
			taskGrid.dfAccess = me.gksd('DFAccess');
			taskGrid.loadData(value.tasksPrepareData);
			taskGrid.collapseAllNode(value.CollapseListDocuments);
			
		}
		else{
			me.gksc('hSplitter').setVisible(false);
		}
		//#endregion Документы

		ksControls.S_RTEMA.setValue(value.srtema);

		let revizVid = me.gksc('REVIZ_VID');
		let sName = [];
		if (revizVid.isVisible()) {
			if (value.srtema.length > 0) {
				Ext.each(value.srtema,
					function(d) {
						if (d.SNAME && d.SNAME.length) {
							sName.push(d.SNAME);
						}
					});
			}
			revizVid.setValue(sName.join('; '));
		}
		
		me.ksData.isActual.Prepare = true;
		
		me.setKsReadOnly(me.ownerCt.ksReadOnly);
	},

	setKsReadOnly: function(v) {
		let me = this,
			res = me.callParent(arguments);
		if (v || !me.ksData.access) return;

		me.gksc('REVIZ_VID').setVisible(me.ksData.access.REVIZ_VID);
		me.setFullObjsAccess(me.ksData.access, ['S_RTEMA', 'REVIZ_VID']);
		
		if (me.ksData.access.GRID_T_REVIZ_SRPROG !== _ && (me.ksData.access.GRID_T_REVIZ_SRPROG & ObjAccessMask.EDIT) !== ObjAccessMask.EDIT){
			me.gksc('ProgRequestPanel')?.setKsReadOnly(true);
			me.gksc('S_RPROG_Grid')?.setReadOnly(true);
			me.gksc('S_RPROG_Grid')?.getToolbar().items.items.forEach(item=>{
				if (['x_btn_treeexpand','x_btn_treecollapse'].indexOf(item.iconCls) === -1)
					item.setDisabled(true);
			});
		}

		if (me.ksData.access.GRID_TASK_PREPARE !== _ && (me.ksData.access.GRID_TASK_PREPARE & ObjAccessMask.EDIT) !== ObjAccessMask.EDIT)
			me.gksc('taskGridPrepare')?.setReadOnly(true);
		return res;
	},
	getExtraNew: function(endFunc) {
		var me = this,
			ksData = me.ksData;

		me.genProgPerson([]);
		ksData.S_RPROG_DATA = [];
		ksData.sRtemaSRprog = [];
		me.getExtra(endFunc);
	},

	afterCancelLoad: function() {
		this.ownerCt.afterCancelLoad();
	},

	initLoadingMaskCfg: function() {
		return this.ownerCt.initLoadingMaskCfg();
	},

	//#endregion Загрузка данных 

	getTempFiles: function(link) {
		var tdf = this.ksData.T_DOCREQUEST_FILES;
		return ArrayLib.filter(tdf, ['DOCREQUEST'], link);
	},

	showFileList: function(rec) {
		var me = this,
			link = rec.get('LINK');
		UploaderLib.showFileList({
			readOnly: true,
			getFiles: function(callBack) {
				callBack(me.getTempFiles(link));
			}
		});
	},

	//#region Сохранение данных
	dataCollector: function() {
		var me = this,
			ksControls = me.ksControls,
			ksData = me.ksData,
			res = me.ownerCt.dataCollector({}),
			i = 0,
			items = ksControls.S_RPROG_Grid.store.getClearData(),
			len = items.length,
			sProg = [];

		for (; i < len; i++) {
			sProg.push({
				LINK: items[i].LINK,
				DT1: items[i].DT1 && items[i].DT1.toDateString(),
				DT2: items[i].DT2 && items[i].DT2.toDateString(),
				DTMONEY1: items[i].DTMONEY1 && items[i].DTMONEY1.toDateString(),
				DTMONEY2: items[i].DTMONEY2 && items[i].DTMONEY2.toDateString(),
				METHOD: items[i].METHOD,
				ORD: items[i].ORD,
				S_RPROG: items[i].S_RPROG,
				T_REVIZ_OBJECTS: items[i].T_REVIZ_OBJECTS,
				ORD_NUM: items[i].ORD_NUM,
				TEMP_S_RPROG_CODE: items[i].TEMP_S_RPROG_CODE,
				TEMP_S_RPROG_NAME: items[i].TEMP_S_RPROG_NAME,
			});
		}

		res.S_RPROG = JSON.stringify(sProg);

		var data = ksData.progPerson,
			progPerson = [];

		for (var pp in data) {
			for (i = 0, len = data[pp].length; i < len; i++) {
				progPerson.push(data[pp][i]);
			}
		}

		res.PROGPERSON = JSON.stringify(progPerson);
		res.S_RTEMA = JSON.stringify(ksControls.S_RTEMA.getLinks());
		res.tab = me.tabKey;

		return res;
	},
	isFilled: function() {
		var me = this,
			progGrid = me.gksc('S_RPROG_Grid');

		let res = true;		
		progGrid && progGrid.store.each(function(r) {
			const msg = me.checkDtWarning(r);
			if (msg){
				me.errorMessages.push(msg);
				return false;
			}
		});

		// if (me.gksd('DTWarning')) {
		// 	warning(me.gksd('DTWarning'));
		// 	return false;
		// }

		return res;
	},

	successSaveFunc: function(result, endFunc, inputParams) {
		var me = this;

		me.sRProgLink = -1;
		me.progPersonLink = -1;

		me.ownerCt.successSaveFunc(result, endFunc, inputParams);
	},

	//#endregion Сохранение данных

	//#region Проверки, события
	//получение вопросов программы по теме
	getSRTemaRProg: function(links, endFunc) {
		ajaxRequest({
			url: 'SRTema/GetSRProg_A',
			timeout: 5000,
			params: { links: links },
			success: function(value) {
				if (endFunc) {
					endFunc(value);
				}
			}
		});
	},
	//сгенерировать словарь пользователей по линку строки вопросов программы
	genProgPerson: function(list) {
		var me = this,
			result = {},
			i = 0,
			len = list.length;
		for (; i < len; i++) {
			if (result[list[i].T_REVIZ_SRPROG]) {
				result[list[i].T_REVIZ_SRPROG].push(list[i]);
			} else {
				result[list[i].T_REVIZ_SRPROG] = [list[i]];
			}
		}
		me.ksData.progPerson = result;
		return result;
	},
	//Создание грида "Ответственные"
	getRevizProgsDict: function() {
		var me = this,
			ksControls = me.ksControls,
			ksData = me.ksData;

		return me.gksc('revizProgs_Dict') ||
			Ext.create('Keysystems.Base.List', {
				tabMode: true,
				closable: false,
				code: dnl.REVIZ,
				parentView: ksControls.RevizorsProgPanel,
				GateCode: 'edit',
				profileKey: 'progPersonsColumns',
				selectLinks: [],
				mode: 'MULTI',
				head: false,
				hidePagging: true,
				hideTBar: true,
				hideMsg: true,
				pageSize: 1000,
				checkModelChange: Ext.emptyFn,
				columnsAdapted: function(columns) {
					let self = this,
						cols = self.callParent(arguments);

					let index = ArrayLib.find(cols, ['dataIndex'], 'MAIN');
					if (index !== -1) {
						cols[index].listeners = {
							beforecheckchange: function (th, inx, check, rec) {
								if (self.readOnly) return false;
								return rec.data.M || false;
							},
							checkchange: function(th, rowIndex, checked, record){
								var rec = ksControls.S_RPROG_Grid.getSelectionModel().getSelection();
								if (rec.length) {
									rec = rec[0];
									var sProg = rec.data.LINK,
										row = me.ksData.progPerson[sProg],
										iPos = ArrayLib.find(row, ['S_PERSON'], record.get('S_PERSON'));
									if (iPos !== -1){
										row[iPos].MAIN = checked;
									}
								}
							}
						};
					}
					return cols;
				},
				checkListeners: {
					checkchange: function(th, rowIndex, checked, record) {
						if (!checked) record.set('MAIN', false);

						var rec = ksControls.S_RPROG_Grid.getSelectionModel().getSelection();
						if (rec.length) {
							rec = rec[0];
							var sProg = rec.data.LINK,
								row = me.ksData.progPerson[sProg],
								iPos = ArrayLib.find(row, ['S_PERSON'], record.get('S_PERSON'));
							if (iPos === -1){
								row.push({
									LINK: me.progPersonLink--,
									S_PERSON: record.get('S_PERSON'),
									T_REVIZ_SRPROG: sProg,
									MAIN: record.get('MAIN')
								})
							}
							else{
								me.ksData.progPerson[sProg] = row.filter(function(r) {
									return r.S_PERSON !== record.get('S_PERSON');
								});
							}
						}
					}
				},
				functions: {
					getData: function(endFunc, cfg) {
						loadProfile({
							code: 'DOCUMENT_REVIZ',
							prefix: 'reviz',
							gateCode: 'edit',
							profileKey: 'progPersonsColumns',
							callBack: function () {
								endFunc({
									columns: ksData.revProgPerson.columns,
									fields: ksData.revProgPerson.fields,
									data: { data: ksData.revProgPerson.data, total: ksData.revProgPerson.data.length }
								});
							}
						});
					},
					refresh: function(endFunc, cfg) {
						endFunc({
							data: ksData.revProgPerson.data,
							total: ksData.revProgPerson.data.length
						});
					}
				}
			});
	},
	////генерация словаря вопросов программы
	//genGroupsNames: function(list) {
	//	var me = this,
	//		result = {};

	//	for (var i = 0; i < list.length; i++) {
	//		result[list[i].LINK] = list[i];
	//	}

	//	me.ksData.groupsNames = result;
	//	return result;
	//},
	
	//внесение дополнительных условий в колонки
	groupColumnsAdapted: function(columns) {
		var me = this,
			ksControls = me.ksControls,
			iPos = ArrayLib.find(columns, ['dataIndex'], 'METHOD'),
			accesOrdNum = me.gksd('OrdNumAcces');

		ksControls.metodComboStore = Ext.create('Ext.data.ArrayStore', {
			fields: ['field1', 'name'],
			data: [
				[null, '...'],
				[0, 'сплошной'],
				[1, 'выборочный']
			]
		});

		for (var i = 0; i < columns.length; i++) {
			columns[i].renderer = rendererCell;
			columns[i].sortable = false;
		}

		if (iPos !== -1) {
			columns[iPos].editor =
				{
					xtype: 'comboextra',
					editable: false,
					store: ksControls.metodComboStore,
					displayField: 'name',
					valueField: 'field1'
				};
			columns[iPos].renderer = function(val) {
				return Ext.isNumber(val) ? ksControls.metodComboStore.getAt(val + 1).data.name : '';
			};
		}

		iPos = ArrayLib.find(columns, ['dataIndex'], 'ORD_NUM');
		if (iPos !== -1 && accesOrdNum !== ObjAccessMask.READ) {
			columns[iPos].editor =
				{
					xtype: 'textfield',
					maxLength: 10
				};
		}

		return columns;
	},
	//установить выбранных пользователей вопросу программы
	setProgPersonValue: function(rec) {
		var me = this,
			ksData = me.ksData;

		if (!ksData.progPerson[rec.get('LINK')]) {
			ksData.progPerson[rec.get('LINK')] = [];
		}

		var rows = ksData.progPerson[rec.get('LINK')],
			rd = me.gksc('revizProgs_Dict'),			
			i = 0,
			len = rows.length,
			items = rd.Grid.store.data.items,
			checks = [];

		for (; i < len; i++) {
			var pos = ArrayLib.find(items, ['data', 'S_PERSON'], rows[i].S_PERSON);
			if (pos !== -1){
				checks.push({
					data: {
						S_PERSON: rows[i].S_PERSON || 0,
						MAIN: rows[i].MAIN || 0
					}
				});
			}
		}

		// Проставить чеки у M и MAIN
		Ext.each(items, function(rec) {
			var find = ArrayLib.recordIndexOf(checks, rec, 'S_PERSON');
			if (find !== -1){
				rec.set('M', true);
				rec.set('MAIN', checks[find].data.MAIN);
			}
			else{
				rec.set('M', false);
				rec.set('MAIN', false);
			}
		});

		rd.objs.Grid.view.refresh();
	},
	//установить вопросы программы всем группам
	setSRProgAllGroups: function(value) {
		var me = this,
			ksData = me.ksData,
			ksControls = me.ksControls,
			list = [],
			i = 0,
			grid = ksControls.S_RPROG_Grid,
			len = value.length;

		for (; i < len; i++) {
			var link = value[i].data.LINK,
				val = ksData.groupsNames[link];
			if (val) {
				list.push(val);
			}
			else {
				for (var group in ksData.groupsNames){
					var childs = ksData.groupsNames[group].children,
						pos = ArrayLib.find(childs, ['LINK'], link, 0, ['children']);
					if (pos !== -1) {
						if (!Ext.isArray(pos)) pos = [pos];
						var valChild = { children: childs };
						Ext.each(pos, function(k) {
							valChild = valChild.children[k];
						});
						list.push(valChild);
						break;
					}
				}
			}
		}
		list.sort(sortByCode);

		//grid.deleteGroupData();
		ksData.progPerson = {};
		var groups = grid.groups;
		Ext.each(groups, function(group) {
			me.setSRProg(list, group.TEMP_NAME, group.LINK, group);
		});
		me.updateRevizProgsOrdNum();
		//grid.setGroupsForData(grid.store.getDataExt(), grid.groups);
	},
	//установить вопросы программы группе
	setSRProg: function(value, groupName, groupLink, group) {
		var me = this,
			ksControls = me.ksControls,
			ksData = me.ksData,
			newData = [],
			pos,
			grid = ksControls.S_RPROG_Grid,
			store = grid.store,
			dh = ksData.DT,
			dtMoney = ksData.DTMONEY;

		grid.getSelectionModel().deselectAll();

		if (!group) {
			var tmpGroup = ArrayLib.filter(grid.groups, ['LINK'], groupLink);
			group = tmpGroup.length ? tmpGroup[0] : grid.groups[0];
		}

		//Пересчитываем порядок
		var oldData = store.getClearData(groupName),
			ord = me.resetOrds(oldData);

        for (i = 0, len = value.length; i < len; i++) {
			var val = value[i];
			if (val.data) val = val.data;
			pos = ArrayLib.find(oldData, ['S_RPROG'], val.LINK);
			if (pos === -1) {
				//Добавляем
				newData.push({
					DT1: dh.dh1,
					DT2: dh.dh2,
					DTMONEY1: dtMoney.dh1,
					DTMONEY2: dtMoney.dh2,
					LINK: me.sRProgLink,
					METHOD: val.METHOD,
					group: groupName,
					ORD: ord++,
					REVIZ: ksData.link,
					S_RPROG: val.LINK,
					TEMP_S_RPROG_CODE: val.CODE,
					TEMP_S_RPROG_NAME: val.NAME,
					MAIN: group.MAIN,
					T_REVIZ_OBJECTS: groupLink,
					TEMP_S_RPROG_LINK_SELF: val.LINK_SELF
				});
				ksData.progPerson[me.sRProgLink] = [];
				Ext.each(ksData.sPerson, function(rec) {
					if (rec.STATUS === ksData.revizorStatus.ruc) {
						ksData.progPerson[me.sRProgLink].push({
							LINK: me.progPersonLink--,
							S_PERSON: rec.S_PERSON,
							T_REVIZ_SRPROG: me.sRProgLink,
							MAIN: false
						});
					}
				});

				me.sRProgLink--;
			} else {
				newData.push(oldData[pos]);
			}
		}
		//чистим progPerson от старых данных
        for (i = 0; i < oldData.length; i++) {
            pos = ArrayLib.find(newData, ['S_RPROG'], oldData[i].S_RPROG);
            if (pos === -1) {
                delete ksData.progPerson[oldData[i].LINK];
            }
        }

		grid.deleteGroupData(groupName);
		store.loadData(newData, true);
	},
	//сброс порядка сортировки
	resetOrds: function(value) {
		value = quickSort(value, ['ORD']);
		for (var i = 0, len = value.length; i < len; i++) {
			value[i].ORD = i + 1;
		}
		return value.length + 1;
	},
	//обновление данных грида вопросов программы
	updGroupsGrid: function(tRevizObjects) {
		var me = this,
			ksData = me.ksData,
			ksControls = me.ksControls,
			grid = ksControls.S_RPROG_Grid,
			list = ArrayLib.filter(tRevizObjects, ['LINK_SELF'], null),
			result = [],
			groups = [],
			i = 0,
			len = list.length;

		for (var j = 0; j < tRevizObjects.length; j++) {
			if (!tRevizObjects[j].TEMP_NAME) tRevizObjects[j].TEMP_NAME = tRevizObjects[j].TEMP_SNAME;
			if (tRevizObjects[j].LINK_SELF) {
				var mainPos = ArrayLib.find(list, ['LINK'], tRevizObjects[j].LINK_SELF);
				list[mainPos].TEMP_NAME += ' ' + tRevizObjects[j].TEMP_NAME;
			}
		}

		// todo: не понятно зачем этот код
		//for (; i < len; i++) {
		//	list[i].MAIN ? groups.push(list[i]) : result.push(jQuery.extend({}, list[i]));
		//}

		//var mainName = '';
		//for (i = 0, len = groups.length; i < len; i++) {
		//	if (mainName.length > 0) mainName += '; ';
		//	mainName += groups[i].TEMP_NAME || groups[i].TEMP_SNAME;
		//}

		//if (mainName) {
		//	result.unshift({
		//		MAIN: true,
		//		LINK: 0,
		//		TEMP_NAME: mainName
		//	});
		//}

		result = list;

		if (grid) {
			grid.groups = result;
			//grid.setGroupsEmptyData();
		}
	},
	//перемещение строки в таблице вопросов программы
	sRProgRowMove: function(moveFunc) {
		var grid = this.ksControls.S_RPROG_Grid,
			sel = grid.getSelectionModel().getSelection();

		if (!sel.length) return;
		sel = sel[0].data;

		var data = grid.store.getDataExt(),
			iPos = ArrayLib.find(data, ['LINK'], sel.LINK);

		if (moveFunc(data, iPos)) {
			for (var i = 0, len = data.length; i < len; i++) {
				data[i].ORD = i + 1;
			}
		}
		grid.store.loadData(data);
	},
	//фильтрация докуменотов по запросу по вопросу программы и отобранному запросу
	filterDocReq: function(obj, sRprog, requestComboVal) {
		var me = this,
			docReqData = me.ksData.docReqData;

		// фильтр по объекту
		var filteredData =
			obj
				? docReqData.filter(function(d) {
					return me.ksData.tObjDocs[obj].indexOf(d.DOCUMENTS) !== -1;
				})
				: docReqData;

		// фильтр по документу
		var filteredData = requestComboVal
			? filteredData.filter(function(d) {
				return d.DOCUMENTS === requestComboVal;
			})
			: filteredData;

		// фильтр по вопросу программы
		filteredData = sRprog ? ArrayLib.filter(filteredData, ['S_RPROG'], sRprog) : filteredData;

		me.gksc('DocReqGrid').store.loadData(filteredData);
	},

	checkDtWarning: function(sel) {
		var me = this,
			msg = false;

		if (!sel) return _;

		if (sel.get('DTMONEY1') > sel.get('DT1')) {
			msg = wmc.get('DTMoneyMoreThenDTWarning', 'начинаться');
		} else if (sel.get('DTMONEY2') > sel.get('DT2')) {
			msg = wmc.get('DTMoneyMoreThenDTWarning', 'заканчиваться');
		}

		me.sksd('DTWarning', msg);
		return msg;
	},
	//пересчитать порядковый номер вопросов программы для данных объектов (в пределах каждого объекта строго от 1 до N)
	updateRevizProgsOrdNum: function() {
		var me = this,
			tRevizObjects = me.ksData.tRevizObjects,
			items = me.ksControls.S_RPROG_Grid.store.getClearData(),
			i = 0,
			sProgLinks = [],
			accesOrdNum = me.gksd('OrdNumAcces');

		if ((accesOrdNum & ObjAccessMask.EDIT) !== ObjAccessMask.EDIT) return;

		for (; i < tRevizObjects.length; i++) {
			var tRevizSProg = ArrayLib.filter(items, ['T_REVIZ_OBJECTS'], tRevizObjects[i].LINK);
			Ext.each(tRevizSProg,
				function(value) {
					sProgLinks.push(value.S_RPROG);
				});
			var rowsRevizProg = [],
				ord = 1;
			rowsRevizProg = Ext.Array.filter(tRevizSProg,
				function(t) {
					return t.TEMP_S_RPROG_LINK_SELF === 0 ||
						!Ext.Array.contains(sProgLinks, t.TEMP_S_RPROG_LINK_SELF);
				});
			rowsRevizProg.sort(function(a, b) {
				return a.ORD - b.ORD;
			});

			Ext.each(rowsRevizProg, function(value) {
				value.ORD_NUM = ord.toString();
				ord++;
			});

			if (!sProgLinks.length) continue;

			var subRevizProg = Ext.Array.filter(tRevizSProg, function(t) {
				return Ext.Array.contains(sProgLinks, t.TEMP_S_RPROG_LINK_SELF);
			});

			subRevizProg.sort(function(a, b) {
				return a.ORD - b.ORD;
			});

			var linksSelf = [];
			Ext.each(subRevizProg,
				function(value) {
					linksSelf.push(value.TEMP_S_RPROG_LINK_SELF);
				});

			for (var j = linksSelf.length - 1; j >= 0; j--) {
				var rowsParent = ArrayLib.filter(tRevizSProg, ['S_RPROG'], linksSelf[j]);
				if (rowsParent.length) {
					ord = 1;
					var rowsChild = ArrayLib.filter(subRevizProg, ['TEMP_S_RPROG_LINK_SELF'], linksSelf[j]);
					Ext.each(rowsChild, function(value) {
						value.ORD_NUM = rowsParent[0].ORD_NUM + "." + ord;
						ord++;
					});
				}
			}

		}
		var sProgGrid = me.ksControls.S_RPROG_Grid;
		sProgGrid.setGroupsForData(items, sProgGrid.groups);
	},

	setReadOnly: function(state, reason) {
		Keysystems.Reviz.Edit.prototype.setReadOnly.call(this, state, reason);
	},
	//#endregion Проверки, события
});