﻿//Таб "Нарушения"
var greenyellowCls = 'ks-greenyellow',
	pinkCls = 'ks-pink';

Ext.define('Keysystems.RDoc.List', {
	extend: 'Keysystems.Base.List',
	fileColumn: true,
	columnsAdapted: function() {
		var me = this,
			cols = me.callParent(arguments),
			iPos = ArrayLib.find(cols, ['dataIndex'], 'NUMBER');
		if (iPos !== -1) {
			cols[iPos].renderer = function(v, meta, rec) {
				if (me.factNarData && (ArrayLib.find(me.factNarData, ['REVIZDOC'], rec.get('LINK')) !== -1)) {
					rec.data.M ? meta.tdCls = greenyellowCls : warning(me.resource.RevizEditView_gridRevizDoc_CheckChange_Не_выбрано_нарушение_);
				}
				return renderDate(v, meta, rec) || '';
			};
		}
		return cols;
	}
});

Ext.define('Keysystems.Reviz.Edit.Nar', {
	extend: 'Ext.panel.Panel',
	closable: false,
	mixins: ['Keysystems.Base.Edit'],
	layout: { type: 'vbox', align: 'stretch' },
	title: 'Нарушения',
	tabKey: 'Nar',
	border: 0,
	f: 'edit',
	rowRevizOkpLink: -1,
	rowRevizDocLink: -1,
	rowFactNarLink: -1,
	rowFactNarRemLink: -1,
	revizMoneyLink: -1,
	revizContractLink: -1,
	factNarNpaLink: -1,
	factNarNpaOtvLink: -1,
	factNarNpaExtLink: -1,
	tFactNarRevizOkpLink: -1,
	tFactNarRevizDocLink: -1,
	tFactNarObjectsLink: -1,
	tFactnarSNpaLink: -1,
	tRevizmoneyAuthorityLink: -1,

	linkCode: 'SReviz',
	bodyPadding: 0,
	//todo: убрать
	labelWidth: 150,
	
	financPageSize: 2000,
	contractPageSize: 2000,
	infoPageSize: 1000,

	readOnlyList: [
		'factNarGridTree', 'S_NAR', 'financPanel', 'contractPanel', 'infoPanel', 'rDocPanel', 'okpGrid'
	],
	arrDisable: [
		'fngBtnNew', 'fngBtnNewChild', 'fngBtnCopy', 'fngBtnEdit', 'fngBtnDelete',
		'disBtnNew', 'disBtnNewChild', 'disBtnCopy', 'disBtnEdit', 'disBtnDelete',
		'checkBtn', 'uncheckBtn'
	],

	/*profileListeners: [
		{ name: 'narTab', method: 'resizeH' }
	],*/

	initComponent: function() {
		var me = this;
		me.beforeInitComponent();
		me.createItems();
		me.callParent(arguments);
		me.on('activate', function() {
			var ksControls = me.ksControls,
				activeTab = ksControls.narTab.getActiveTab();

			if (me.isFinanc) {
				var financPanel = me.gksc('financPanel');
				financPanel ?
					financPanel.baseRefresh.call(financPanel, Ext.emptyFn, {
						GateCode: 'DOCUMENT_FINANC',
						reload: true,
						filter: '[]',
						page: 1,
						pageSize: me.financPageSize,
						whereArgs: financPanel.getWhereArgs(),
						hideMsg: !(activeTab && activeTab.tabKey === 'financ')
					}) :
					me.createFinancPanel();
			}

			if (me.isContract) {
				var contractPanel = me.gksc('contractPanel');
				contractPanel ?
					contractPanel.baseRefresh.call(contractPanel, Ext.emptyFn, {
						GateCode: 'DOCUMENT_CONTRACT',
						reload: true,
						filter: '[]',
						page: 1,
						pageSize: me.contractPageSize,
						whereArgs: contractPanel.getWhereArgs(),
						hideMsg: !(activeTab && activeTab.tabKey === 'contract')
					}) :
					me.createContractPanel();
			}

			if (me.isInfo) {
				var infoPanel = me.gksc('infoPanel');
				infoPanel ?
					infoPanel.baseRefresh.call(infoPanel, Ext.emptyFn, {
						GateCode: 'DOCUMENT_INFO',
						reload: true,
						filter: '[]',
						page: 1,
						pageSize: me.infoPageSize,
						whereArgs: infoPanel.getWhereArgs(),
						hideMsg: !(activeTab && activeTab.tabKey === 'info')
					}) :
					me.createInfoPanel();
			}

			//Иначе в первый раз не отрабатывает activate панели финансирования или информ.
			if (activeTab) activeTab.fireEvent('activate');
		});
	},

	setReadOnly: function(state, reason) {
		Keysystems.Reviz.Edit.prototype.setReadOnly.call(this, state, reason);
	},
	
	//#region Создание компонентов
	createItems: function() {
		var me = this,
			ksControls = me.ksControls;

		return me.items = [
			Ext.create('Ext.form.FieldContainer', {
				layout: { type: 'vbox', align: 'stretch' },
				flex: 1,
				items: [
					Ext.create('Ext.panel.Panel', {
						layout: { type: 'vbox', align: 'stretch' },
						border: 0,
						flex: 5,
						items: [
							me.createDictEdit({
								labelWidth: 200,
								key: 'S_NAR',
								code: dnl.S_NAR,
								padding: '5 10 0 10',
								fieldLabel: 'Фильтр по виду нарушения',
								ksSetValue: function(value) {
									ksControls.S_NAR.setValue(value);
									this.labelEl[value && value.length ? 'addCls' : 'removeCls']('ks-AllowEmpty');
									
									var narLinks = this.getLinks(),
										factNarGrid = me.gksc('factNarGrid'),
										disGrid = me.gksc('disGrid'),
										filterFn = function(grid) {
											let store = grid.getStore();
											store.filter([{
												property: 'S_NAR',
												value: narLinks,
												filterFn: function (item) {
													return narLinks.indexOf(item.get('S_NAR')) !== -1;
												}
											}]);
										};

									if (factNarGrid) {
										filterFn(factNarGrid);
									}
									if (disGrid) {
										filterFn(disGrid);
									}
								}
							}),
							me.sksc('narDisTab', Ext.create('Ext.tab.Panel', {
								border: 0,
								flex: 1,
								userCls: me.basePanelCls,
								bodyCls: me.basePanelBodyCls,
								items: [],
								listeners: {
									tabchange: function(tabPanel, newCard, oldCard) {
										if (oldCard === _) return;
										var isDis = newCard.tabKey === 'dis',
											grid = me.gksc(isDis ? 'disGrid' : 'factNarGrid'),
											selRec = grid.getFrstSelect(),
											activeTab = me.gksc('narTab').activeTab,
											panel;
			
										if (activeTab) {
											tabKey = activeTab.tabKey;
			
											switch (activeTab.tabKey) {
												case 'financ':
													panel = me.gksc('financPanel'),
														rec = panel.Grid.getFrstSelect();
			
													grid.imgHandler = grid.financHandler;
													grid.imgGetClass = grid.financGetClass;
													grid.imgGetGYCls = grid.financGetGYCls;
													grid.objectRenderer = grid.getPinkCls;
			
													if (rec) {
														grid.objLink = rec.get('SORGC');
														grid.revizMoney = rec.get('REVIZMONEY');
													}
			
													if (selRec) {
														panel.factNarRevizMoney = selRec.get('REVIZMONEY');
													}
													break;
												case 'contract':
													panel = me.gksc('contractPanel'),
														rec = panel.Grid.getFrstSelect();

													grid.imgHandler = grid.contractHandler;
													grid.imgGetClass = grid.contractGetClass;
													grid.imgGetGYCls = grid.contractGetGYCls;
													grid.objectRenderer = grid.getPinkCls;

													if (rec) {
														grid.objLink = rec.get('S_ORG');
														grid.revizContract = rec.get('REVIZCONTRACT');
													}

													if (selRec) {
														panel.factNarRevizContract = selRec.get('REVIZCONTRACT');
													}
													break;
												case 'info':
													panel = me.gksc('infoPanel'),
														rec = panel.Grid.getFrstSelect();
			
													if (rec) {
														grid.objLink = rec.get('S_ORGC');
														grid.info = rec.get('LINK');
			
														if (selRec) {
															panel.factNarInfo = selRec.get('INFO');
														}
													}
			
													grid.imgHandler = grid.infoHandler;
													grid.imgGetClass = grid.infoGetClass;
													grid.imgGetGYCls = grid.infoGetGYCls;
													grid.objectRenderer = grid.getPinkCls;
			
													break;
												case 'okp':
													panel = me.gksc('okpPanel'),
														rec = panel.getSelect(),
														narRec = grid.getFrstSelect(),
														narLink = narRec ? narRec.get('LINK') : 0;
			
													grid.imgHandler = grid.okpHandler;
													grid.imgGetClass = grid.okpGetClass;
													grid.imgGetGYCls = grid.okpGetGYCls;
													grid.objectRenderer = null;
			
													if (rec.length) {
														rec = rec[0];
			
														var filterByNar = ArrayLib.filter(me.gksd('tFactNarRevizOkp'), ['FACTNAR'], narLink);
			
														me.sksd('okpFactNarData', filterByNar);
														grid.factNarData = filterByNar;
			
														grid.okpLink = rec.get('LINK');
													}
			
													break;
												case 'rdoc':
													panel = me.gksc('rDocPanel'),
														rec = panel.getSelect(),
														narRec = grid.getFrstSelect(),
														narLink = narRec ? narRec.get('LINK') : 0;
			
													panel.factNarData = grid.factNarData = ArrayLib.filter(me.ksData.tFactNarRevizDoc, ['FACTNAR'], narLink);
			
													grid.imgHandler = grid.rDocHandler;
													grid.imgGetClass = grid.rDocGetClass;
													grid.imgGetGYCls = grid.rDocGetGYCls;
													grid.objectRenderer = null;
			
													var allRDocData = panel.Grid.store.getDataExt();
													panel.checkList = [];
													Ext.each(panel.factNarData, function(rdoc) {
														panel.checkList.push(allRDocData[ArrayLib.find(allRDocData, ['LINK'], rdoc.REVIZDOC)]);
													});
													panel.setChecks(panel.checkList);
			
													if (rec.length) {
														rec = rec[0];
														grid.rdocLink = rec.get('LINK');
													}
			
													break;
												case 'rnpa':
													grid.factNarData = [];
													grid.imgHandler = null;
													grid.imgGetClass = null;
													grid.imgGetGYCls = null;
													grid.objectRenderer = null;
			
													break;
											}
										}
			
										grid.view.refresh();
										if (panel) {
											panel.Grid.view.refresh();
										}
									}
								}
							})),
						]
					}),
					Ext.create('Ext.resizer.Splitter'),
					Ext.create('Ext.panel.Panel', {
						layout: { type: 'vbox', align: 'stretch' },
						flex: 3,
						items: [
							me.sksc('narTab', Ext.create('Ext.tab.Panel', {
								border: 0,
								flex: 1,
								scrollable: true,
								userCls: me.basePanelCls,
								bodyCls: me.basePanelBodyCls,
								items: []
							}))
						]
					})
				]
			})];
		
	},
	createFinancPanel: function() {
		var me = this,
			ksControls = me.ksControls,
			financGridReadOnly = (me.ksData.access.financGridAccess & ObjAccessMask.EDIT) === 0,
			isNpa = false,
			isOrg = false;

		return ksControls.financPanel = Ext.create('Keysystems.Financ.List', {
			title: 'Финансирование',
			head: false,
			hideFilterPanel: true,
			tabMode: true,
			closable: false,
			visibleShowFinanc: true,
			btnsHide: {
				refresh: true,
				print: true,
				search: true,
				reset: true,
				show_actual: true,
				relations: true,
				journal: true,
				autofilter: true,
				galka: true,
				unmark: true,
				batch_change: true
			},
			code: dnl.FINANC,
			checkModel: true,
			GateCode: 'DOCUMENT_FINANC',
			linkCode: 'SFinanc',
			controlName: 'revizFinanc',
			parentView: ksControls.FinancPanelContainer,
			hidePagging: true,
			pageSize: me.financPageSize,
			accessReadOnly: (me.ksData.access.financAccess & ObjAccessMask.EDIT) === 0,
			_arrReadTBarBtns: [],
			getBindText: function(rec) {
				var factNarGrid = me.gksc('factNarGrid'),
					disGrid = me.gksc('disGrid'),
					revizMoney = rec.get('REVIZMONEY') || null,
					res = '';
				
				if (factNarGrid && ArrayLib.find(factNarGrid.store.getDataExt(), ['REVIZMONEY'], revizMoney) !== -1) {
					res = me.resource.RevizEditView_QuestionHasAttachedFactNar_Имеются_привязанные_факты_нарушений;
				}

				if (disGrid && ArrayLib.find(disGrid.store.getDataExt(), ['REVIZMONEY'], revizMoney) !== -1) {
					res = res.length
						? me.resource.RevizEditView_QuestionHasAttachedFactNar_Имеются_привязанные_факты_нарушений_и_недостатки
						: me.resource.RevizEditView_QuestionHasAttachedFactNar_Имеются_привязанные_недостатки;
				}

				return res;
			},
			getGridCfg: function () {
				var cfg = this.callParent(arguments);
				if (!cfg.plugins) cfg.plugins = [];
				cfg.plugins.push(Ext.create('Ext.grid.plugin.CellEditing', { clicksToEdit: 1 }));
				return cfg;
			},
			//Отключаем серверную сортировку
			getGridStoreCfg: function() {
				var cfg = this.callParent(arguments);
				cfg.remoteSort = false;
				return cfg;
			},
			checkListeners: {
				checkchange: function(ths, rowIndex, checked, rec) {
					var summ,
						budjName,
						factNarGrid = me.gksc('factNarGrid'),
						disGrid = me.gksc('disGrid'),
						revizMoney = rec.get('REVIZMONEY'),
						th = ksControls.financPanel,
						authorityData = me.gksd('authorityData'),
						endFunc = function(checked, summ, budjName) {
							rec.set('M', checked);
							rec.set('AGAIN', false);
							rec.set('SUMMACHECK', convertToDecimal(summ, me.gksd('decimalData')));

							var columns = th.Grid.columnManager.columns,
								budjColumn = columns[ArrayLib.find(columns, ['code'], 'DICTIONARY_SVBUDJ')];

							budjColumn.setValue([
								{
									SNAME: budjName,
									LINK: budjName.length ? rec.get('S_VBUDJ') : 0
								}
							], rec);

							//var pos = ArrayLib.find(th.financData, ['LINK'], rec.get('LINK'));

							//if (pos !== -1) {
							//	th.financData[pos].M = checked;
							//	th.financData[pos].SUMMACHECK = summ;
							//}
							
							if (!checked) {
								var removeRecs = authorityData.filter(d => { return d.REVIZMONEY === rec.get('REVIZMONEY'); });
								Ext.each(removeRecs, rec => {
									var index = authorityData.indexOf(rec);
									authorityData.splice(index, 1);
								});

								rec.set('TEMP_SAUTHORITY_CODE', '');
								rec.set('TEMP_SAUTHORITY_NAME', '');
							}
							
							//Создаем привязку revizMoney
							var revizMoney = me.ksData.financ.revizMoney = me.getRevizMoney();
							var pos = ArrayLib.find(revizMoney, ['FINANC'], rec.get('LINK'));

							if (pos !== -1) rec.set('REVIZMONEY', revizMoney[pos].LINK);
							
							if (me.gksd('isAuthority') && th.Grid.getFrstSelect().get('LINK') === rec.get('LINK')) {
								me.gksc('btnAuthority').setDisabled(!checked);
							}
							
							// Автоматическое заполнение полномочия в факте финансирования
							if (checked && me.gksd('AutoFillSAuthority') && me.ksData.tRevizSAuthority.length === 1){
								var authority = me.ksData.sAuthority.filter(r => {return r.LINK === me.ksData.tRevizSAuthority[0].S_AUTHORITY});
								if (authority.length){
									authorityData.push({
										LINK: me.tRevizmoneyAuthorityLink--,
										T_REVIZ_SAUTHORITY: me.ksData.tRevizSAuthority[0].LINK,
										REVIZMONEY: rec.get('REVIZMONEY'),
										SUMMA: summ
									});
									rec.set('TEMP_SAUTHORITY_CODE', authority[0].CODE);
									rec.set('TEMP_SAUTHORITY_NAME', authority[0].NAME);
								}
							}
						};

					var bindText = th.getBindText(rec);
					if (!!(!checked && revizMoney && bindText.length)) {
						selectDialogShow(KS.L10n.attention, wmc.getContinueQuestion(bindText), function () {
							if (factNarGrid) {
								factNarGrid.store.each(function (nar) {
									if (nar.get('REVIZMONEY') === rec.get('REVIZMONEY')) nar.set('REVIZMONEY', 0);
								});
								factNarGrid.view.refresh();
							}
							
							if (disGrid) {
								disGrid.store.each(function (dis) {
									if (dis.get('REVIZMONEY') === rec.get('REVIZMONEY')) dis.set('REVIZMONEY', 0);
								});
								disGrid.view.refresh();
							}
							
							th.factNarRevizMoney = 0;
							endFunc(false, 0, '');
							th.Grid.view.refresh();
						}, function() { rec.set('M', true) });
					} else {
						if (checked) {
							summ = rec.get('SUMMA');
							budjName = rec.get('TEMP_S_VBUDJ_SNAME') || rec.get('S_VBUDJ_NAME');
						}

						endFunc(checked, summ || 0, budjName || '');
					}

					th.gksc('fillBtn')
						.setDisabled(!th.Grid.store.getDataExt().filter(function(d) { return d.M === true; }).length);
				},
				beforecheckchange: function() {
					if (me.readOnly || me.ksReadOnly || financGridReadOnly) return false;
				}
			},
			checkRenderer: function(value, meta, rec) {
				var cssPrefix = Ext.baseCSSPrefix,
					cls = cssPrefix + 'grid-checkcolumn',
					factNarRevizMoney = me.gksc('financPanel').factNarRevizMoney;

				if (this.disabled) {
					meta.tdCls += ' ' + this.disabledCls;
				}
				if (value) {
					cls += ' ' + cssPrefix + 'grid-checkcolumn-checked';
				}
				if (factNarRevizMoney && factNarRevizMoney === rec.get('REVIZMONEY')) {
					meta.tdCls += ' ' + greenyellowCls;
				}
			},
			createGridListeners: function() {
				var th = this;

				th.callParent(arguments);
				th.objs.gridListeners.select = function(dv, rec) {
					if (!rec) return;

					th.objs.tbarBtns.showFinanc.setDisabled(rec.get('S_NPA'));
					
					var activeTab = me.gksc('narDisTab').activeTab;
					if (!activeTab) return;
					
					var activeGrid = me.gksc(activeTab.tabKey === 'dis' ? 'disGrid' : 'factNarGrid');
					if (!activeGrid) return;
					
					if (me.gksd('isAuthority')) {
						me.gksc('btnAuthority').setDisabled(!rec.get('M'));
					}

					activeGrid.objLink = rec.get('SORGC');
					activeGrid.revizMoney = rec.get('REVIZMONEY');

					var selRec = activeGrid.getFrstSelect();
					if (selRec) me.gksc('financPanel').factNarRevizMoney = selRec.get('REVIZMONEY');
					
					activeGrid.view.refresh();
				};
				th.objs.gridListeners.ksAfterRefresh = function(t, items) {
					me.gksd('financ').financData = items;
				};
				th.objs.gridListeners.beforeedit = function(plugin, context) {
					if ((context.field === 'SUMMACHECK' || context.field === "TEMP_S_VBUDJ") && !context.record.get('M')) return false;
				};
			},
			createTBar: function() {
				var th = this,
					financTBar = th.callParent(arguments);

				if (!th.f) {
					financTBar.push(th.sksc('fillBtn', Ext.create('Ext.Button', {
						iconCls: 'x_btn_fill',
						tooltip: me.resource.RevizEditView_InitializeComponent_Заполнить_проверенные_суммы,
							tooltipType: 'title',
							handler: function() {
								var financGrid = me.gksc('financPanel').Grid;

								financGrid.store.each(function(rec) {
									if (rec.get('M')) {
										rec.set('SUMMACHECK', convertToDecimal(rec.get('SUMMA'), me.gksd('decimalData')));
									}
								});
								financGrid.fireEvent('select', th, financGrid.getFrstSelect());
							}
						})),
						{ xtype: 'tbseparator' },
						th.sksc('galkaBtn', Ext.create('Ext.button.Split', {
							iconCls: 'x_btn_galka',
							tooltip: me.resource.RevizEditView_InitializeComponent_Инверсия,
							tooltipType: 'title',
							disabled: financGridReadOnly,
							menu: [
								th.inversionHandler = {
									text: me.resource.RevizEditView_InitializeComponent_Инверсия,
									iconCls: 'x_btn_galka',
									handler: function() {
										var items = th.Grid.store.data.items,
											factNarGrid = me.gksc('factNarGrid'),
											disGrid = me.gksc('disGrid'),
											bindText = '';

										for (var i = 0, len = items.length; i < len; i++) {
											bindText = th.getBindText(items[i]);
											if (bindText.length) break;
										}

										if (bindText.length) {
											selectDialogShow(KS.L10n.attention, wmc.getContinueQuestion(bindText), function() {
												th.factNarRevizMoney = 0;
												if (factNarGrid) {
													factNarGrid.store.each(function (rec) {
														rec.set('REVIZMONEY', 0);
													});
												}
												if (disGrid) {
													disGrid.store.each(function (rec) {
														rec.set('REVIZMONEY', 0);
													});
												}
												th.checkInversion();
											});
										} else {
											th.checkInversion();
										}
									}
								}, {
									text: 'Отметить все',
									handler: function() {
										th.checkAll();
									}
								}, {
									text: 'С начала до текущей',
									handler: function() {
										th.checkFstToSel();
									}
								}, {
									text: 'С текущей до конца',
									handler: function() {
										th.checkSelToLst();
									}
								}, {
									text: 'Между отмеченными',
									handler: function() {
										th.checkCheckToCheck();
									}
								}
							],
							handler: function() {
								th.inversionHandler.handler();
							}
						})),
						th.sksc('markBtn', Ext.create('Ext.Button', {
							iconCls: 'x_btn_unmark',
							tooltip: me.resource.RevizEditView_InitializeComponent_Разметить_все,
							tooltipType: 'title',
							disabled: financGridReadOnly,
							handler: function() {
								var items = th.Grid.store.data.items,
									factNarGrid = me.gksc('factNarGrid'),
									disGrid = me.gksc('disGrid'),
									bindText = '';

								for (var i = 0, len = items.length; i < len; i++) {
									bindText = th.getBindText(items[i]);
									if (bindText.length) break;
								}

								if (bindText.length) {
									selectDialogShow(KS.L10n.attention, wmc.getContinueQuestion(bindText), function() {
										th.factNarRevizMoney = 0;
										if (factNarGrid) {
											factNarGrid.store.each(function (rec) {
												rec.set('REVIZMONEY', 0);
											});
										}
										if (disGrid) {
											disGrid.store.each(function (rec) {
												rec.set('REVIZMONEY', 0);
											});
										}
										th.uncheckAll();
									});
								} else {
									th.uncheckAll();
								}
							}
						}))
					);

					if (me.gksd('isAuthority')) {
						financTBar.unshift(me.sksc('btnAuthority', Ext.create('Ext.Button', {
							iconCls: 'x_btn_reviz',
							tooltip: me.resource.RevizEditView_InitializeComponent_Полномочия,
							tooltipType: 'title',
							handler: function() {
								var selFinanc = me.gksc('financPanel').Grid.getFrstSelect(),
									financLink = selFinanc.get("LINK");
								
								Ext.create('Keysystems.Row.Authority.Edit', {
									parentView: me,
									readOnly: me.readOnly,
									code: me.code,
									keyEdit: me.keyEdit,
									revizLink: me.ksData.link,
									financLink: financLink,
									financSum: selFinanc.get("SUMMACHECK"),
									revizMoney: me.gksd('financ').revizMoney,
									authorityData: me.gksd('authorityData'),
									decimalData: me.gksd('decimalData'),
									accessReadOnly: (me.ksData.access.financGridAccess & ObjAccessMask.EDIT) === 0,
									saveFunc: function(newData, endFunc) {
										var authorityData = me.gksd('authorityData'),
											revizMoneys = me.gksd('financ').revizMoney.filter(r => { return r.FINANC === financLink; }),
											revizmoneyLink = revizMoneys[0].LINK,
											codes = [],
											names = [];
										
										Ext.each(newData, data => {
											var recs = authorityData.filter(d => { 
												return d.T_REVIZ_SAUTHORITY === data.TEMP_T_REVIZ_SAUTHORITY && d.REVIZMONEY === revizmoneyLink;
											});
											if (data.CHECKED) {
												if (recs.length) {
													recs[0].SUMMA = data.SUMMA;
												} else {
													authorityData.push({
														LINK: me.tRevizmoneyAuthorityLink--,
														T_REVIZ_SAUTHORITY: data.TEMP_T_REVIZ_SAUTHORITY,
														REVIZMONEY: revizmoneyLink,
														SUMMA: data.SUMMA
													});
												}
	
												codes.push(data.CODE);
												names.push(data.NAME);
											} else {
												if (recs.length) {
													var index = authorityData.indexOf(recs[0]);
													authorityData.splice(index, 1);
												}
											}
										});
	
										selFinanc.set('TEMP_SAUTHORITY_CODE', codes.join(';'));
										selFinanc.set('TEMP_SAUTHORITY_NAME', names.join(';'));
										
										if (endFunc) {
											endFunc();
										}
									}
								});
							}
						})));
					}
				}

				return financTBar;
			},
			addRevizRecord: function(rec) {
				var th = this,
					columns = me.gksc('financPanel').Grid.visibleColumnManager.columns,
					pos = ArrayLib.find(columns, ['dataIndex'], 'M');

				if (pos !== -1) {
					columns[pos].fireEvent('checkchange', th, 0, true, rec);
					me.gksc('financPanel').Grid.getSelectionModel().select(rec);
					
					if (me.gksc('S_VBUDJ').getLinks().length) {
						me.filterByVbudj();
					}
				}
			},
			getWhereArgs: function() {
				var dtMoney = me.gksd('DTMONEY'),
					objLinks = [],
					npaLinks = [];

				if (Ext.isString(dtMoney)) {
					var tmp = JSON.parse(dtMoney);
					dtMoney = { dh1: new Date(tmp.dh1), dh2: new Date(tmp.dh2) };
					me.sksd('DTMONEY', dtMoney);
				}

				Ext.each(me.gksd('tRevizObjects'), function(obj) {
					if (obj.TTABLE === "S_NPA") {
						npaLinks.push(obj.TLINK);
					} else {
						objLinks.push(obj.TLINK);
					}
				});

				let whereArgs = {
					DBegin: {
						value: dtMoney.dh1.toDateString(),
						type: 'Date'
					},
					DEnd: {
						value: dtMoney.dh2.toDateString(),
						type: 'Date'
					},
					ObjLinks: {
						value: JSON.stringify(objLinks.length ? objLinks : null),
						type: 'List_int'
					},
					NpaObjLinks: {
						value: JSON.stringify(npaLinks.length ? npaLinks : null),
						type: 'List_int'
					},
					Statuses: {
						value: JSON.stringify([objLinks.length 
							? Ext.Object.getKey(miscTypes.FinancStatus, 'Исполнено')
							: Ext.Object.getKey(miscTypes.FinancStatus, '....')]),
						type: 'List_int'
					}
				};
				
				if (me.gksd('isAuthority')) {
					whereArgs.IsAuthority = {
						value: true, type: 'bool'
					}
				}
				
				return whereArgs;
			},
			beforeSetData: function(data) {
				var th = this,
					financ = me.gksd('financ'),
					revizMoney = financ.revizMoney;

				data.fields = me.adaptFinanceFields(data.fields);
				data.columns = me.adaptFinanceColumns(data.columns);
				data.data.data = me.adaptedFinanceData.call(th, data.data.data, revizMoney, [], me.gksd('decimalData'));
				me.gksd('financ').revizMoney = revizMoney;
				th.callParent(arguments);
				//Приходится делать, иначе есть вероятность что revizMoney изменится
				me.oldData = JSON.stringify(me.dataCollector());
			},
			setData: function (data, endFunc) {
				var th = this;
				th.callParent(arguments);
				if ((me.ksData.access.financGridAccess & ObjAccessMask.EDIT) === 0) {
					th.gksc('fillBtn').setDisabled(true);
				} else {
					th.gksc('fillBtn').setDisabled(!this.Grid.store.getDataExt().filter(d=> d.M === true).length);
				}
			},
			setChecks: Ext.emptyFn,
			baseRefresh: function(endFunc, params) {
				var th = this;
				th.callParent([
					function(data) {
						var delLst = [],
							factNarGrid = me.gksc('factNarGrid'),
							disGrid = me.gksc('disGrid');
						
						me.adaptedFinanceData.call(th, data.data, me.gksd('financ').revizMoney, delLst, me.gksd('decimalData'));
						// учитываем убранные записи финансировния
						if (delLst.length) {
							me.gksd('financ').revizMoney = me.gksd('financ').revizMoney.filter(function(i) {
								return delLst.indexOf(i) === -1;
							});

							var delRevizMoney = [];
							Ext.each(delLst, function(i) { delRevizMoney.push(i.LINK); });
							
							if (factNarGrid) {
								factNarGrid.store.each(function (nar) {
									if (delRevizMoney.indexOf(nar.get('REVIZMONEY')) !== -1) nar.set('REVIZMONEY', 0);
								});
							}
							if (disGrid) {
								disGrid.store.each(function (dis) {
									if (delRevizMoney.indexOf(dis.get('REVIZMONEY')) !== -1) dis.set('REVIZMONEY', 0);
								});
							}
						}

						//Приходится делать, иначе есть вероятность что revizMoney изменится
						me.oldData = JSON.stringify(me.dataCollector());

						if (th.objs.Grid) {
							th.objs.Grid.loadData(data.data);
						}
					}, params
				]);
			},
			'delete': function() {
				var me = this,
					grid = me.objs.Grid,
					sel = grid.getFrstSelect();
				
				if (sel && !grid.store.getDataExt().filter(d => { return d.LINK === sel.get('LINK'); }).length) {
					return;
				}
				
				me.callParent(arguments);
			},
			new: function()
			{
				let th = this;
				
				for (var type in miscTypes.RevizObjType) {
					Ext.each(me.gksd('tRevizObjects'), obj => {
						if ((obj.TYPE & type*1) !== 0) {
							if (['ЮЛ', 'ИП'].indexOf(miscTypes.RevizObjType[type]) !== -1) {
								isOrg = true;
							}

							if (miscTypes.RevizObjType[type] === 'НПА') {
								isNpa = true;
							}
						}
					})
				}
				
				if (isNpa && isOrg) {
					Ext.Msg.show({
						msg: me.resource.RevizEditView_AddOrEditFinInfoOkpDoc_Укажите_тип_объекта_для_факта_финансирования,
						buttons: Ext.MessageBox.YESNOCANCEL,
						buttonText: { yes: 'НПА', no: 'ЮЛ/ИП' },
						fn: function(buttonId) {
							if (buttonId === 'yes') {
								isOrg = false;
								th.edit('new', null);
							} else if (buttonId === 'no') {
								isNpa = false;
								th.edit('new', null);
							}
						}
					});
				} else {
					th.edit('new', null);
				}
			},
			functions: {
				edit: function(cfg) {
					if (cfg.f !== 'new' && 
						!me.gksc('financPanel').Grid.store.getDataExt().filter(d => { return d.LINK === cfg.data.data.LINK; }).length) {
						return;
					}
					
					var dh = me.gksd('DTMONEY'),
						year = dh.dh1.getFullYear();

					cfg.saveData = function(endFunc, params) {
						this.callParent([
							function (result) {
								if (result.RefreshColumns) {
									var financ = me.gksc('financPanel').Grid.store.getDataExt().filter(d => { return d.LINK === result.SavedLink; })[0];
									me.gksc('factNarGrid').store.each(function (nar) {
										if (nar.get('REVIZMONEY') === financ.REVIZMONEY){
											if (Ext.Array.contains(result.RefreshColumns, 'S_VBUDJ')){
												nar.set('TEMP_S_VBUDJ_CODE', financ.S_VBUDJ_CODE);
												nar.set('TEMP_S_VBUDJ_NAME', financ.S_VBUDJ_NAME);
											}
											if (Ext.Array.contains(result.RefreshColumns, 'S_NACPROJ')){
												nar.set('TEMP_S_NACPROJ_CODE', financ.S_NACPROJ_CODE);
												nar.set('TEMP_S_NACPROJ_NAME', financ.S_NACPROJ_NAME);
											}
										}
									});
										
								}
								if (endFunc) endFunc(result);
							}, params
						]);
					}

					if (cfg.f === 'new') {
						cfg.data = {};
						
						// Используем именно isNpa, т.к. опрделение isOrg не включает в себя ДЛ и прочие
						let obj = {};

						for (var indx in me.ksData.tRevizObjects) {
							if (me.ksData.tRevizObjects[indx].MAIN && (isNpa && me.ksData.tRevizObjects[indx].TTABLE === 'S_NPA' || 
								!isNpa && me.ksData.tRevizObjects[indx].TTABLE !== 'S_NPA')) {
								obj = me.ksData.tRevizObjects[indx];
								break;
							}
						}
						
						if (Ext.Object.isEmpty(obj)) {
							obj = me.ksData.tRevizObjects.filter(revObj => isNpa && revObj.TTABLE === 'S_NPA' || 
								!isNpa && revObj.TTABLE !== 'S_NPA')[0];
						}
						
						cfg.data.data = {
							S_ORG_CODE: obj.TEMP_CODE,
							S_ORG_NAME: obj.TEMP_NAME,
							S_ORG: obj.TLINK
						};
						cfg.isNpa = isNpa;
						
						if (!isNpa) {
							cfg.revizFinancStatus = CBDataLib.get('RevizFinancStatus');
						}
						
						var vbudjVal = me.gksc('S_VBUDJ').getValue();
						if (vbudjVal.length) {
							cfg.data.data.S_VBUDJ = vbudjVal[0].get('LINK');
							cfg.data.data.S_VBUDJ_CODE = vbudjVal[0].get('CODE');
							cfg.data.data.S_VBUDJ_NAME = vbudjVal[0].get('NAME');
						}
					}

					cfg.data.data.DT = {
						dh1: new Date(year + '/01/01'),
						dh2: new Date(year + '/12/31')
					};
					cfg.readOnly = me.readOnly;
					Ext.create(cfg.editClass, cfg);
				},
				'delete': function(links, endFunc) {
					var th = this,
						store = th.Grid.store,
						link = links[0],
						rec = store.getRecord(link, 'LINK'),
						bindText = th.getBindText(rec);

					if (bindText.length) {
						warning(wmc.get('DeleteFinancWarning'));
						endFunc(false);
					} else {
						ajaxRequest({
							params: {
								revizLink: me.ksData.link,
								financLink: link,
								revizMoneyLink: rec.get('REVIZMONEY') || 0
							},
							url: 'SReviz/DeleteFinanc_A',
							success: function(value) {
								if (value.result) {
									store.remove(rec);
									endFunc(value.result);
								}
							},
							callback: function() { delete me.ridDel; }
						});
					}
				}
			}
		});
	},

	createContractPanel: function() {
		var me = this,
			ksControls = me.ksControls,
			contractGridReadOnly = (me.ksData.access.contractGridAccess & ObjAccessMask.EDIT) === 0;

		return ksControls.contractPanel = Ext.create('Keysystems.Contract.List', {
			title: 'Контракты',
			head: false,
			hideFilterPanel: true,
			tabMode: true,
			closable: false,
			visibleShowContract: true,
			btnsHide: {
				refresh: true,
				print: true,
				search: true,
				reset: true,
				show_actual: true,
				nastr_grid: true,
				relations: true,
				journal: true,
				autofilter: true,
				galka: true,
				unmark: true,
				batch_change: true
			},
			code: dnl.CONTRACT,
			checkModel: true,
			GateCode: 'DOCUMENT_CONTRACT',
			linkCode: 'SContract',
			controlName: 'revizContract',
			parentView: ksControls.ContractPanelContainer,
			hidePagging: true,
			pageSize: me.contractPageSize,
			accessReadOnly: (me.ksData.access.contractAccess & ObjAccessMask.EDIT) === 0,
			_arrReadTBarBtns: [],
			getBindText: function(rec) {
				var factNarGrid = me.gksc('factNarGrid'),
					disGrid = me.gksc('disGrid'),
					revizContract = rec.get('REVIZCONTRACT') || null,
					res = '';

				if (factNarGrid && ArrayLib.find(factNarGrid.store.getDataExt(), ['REVIZCONTRACT'], revizContract) !== -1) {
					res = me.resource.RevizEditView_QuestionHasAttachedFactNar_Имеются_привязанные_факты_нарушений;
				}

				if (disGrid && ArrayLib.find(disGrid.store.getDataExt(), ['REVIZCONTRACT'], revizContract) !== -1) {
					res = res.length
						? me.resource.RevizEditView_QuestionHasAttachedFactNar_Имеются_привязанные_факты_нарушений_и_недостатки
						: me.resource.RevizEditView_QuestionHasAttachedFactNar_Имеются_привязанные_недостатки;
				}

				return res;
			},
			getGridCfg: function () {
				var cfg = this.callParent(arguments);
				if (!cfg.plugins) cfg.plugins = [];
				cfg.plugins.push(Ext.create('Ext.grid.plugin.CellEditing', { clicksToEdit: 1 }));
				return cfg;
			},
			//Отключаем серверную сортировку
			getGridStoreCfg: function() {
				var cfg = this.callParent(arguments);
				cfg.remoteSort = false;
				return cfg;
			},
			checkListeners: {
				checkchange: function(ths, rowIndex, checked, rec) {
					var summ,
						budjName,
						factNarGrid = me.gksc('factNarGrid'),
						disGrid = me.gksc('disGrid'),
						revizContract = rec.get('REVIZCONTRACT'),
						th = ksControls.contractPanel,
						endFunc = function(checked, summ) {
							rec.set('M', checked);
							rec.set('SUMMACHECK', convertToDecimal(summ, me.gksd('decimalData')));

							var columns = th.Grid.columnManager.columns;

							//Создаем привязку revizContract
							var revizContract = me.ksData.contract.revizContract = me.getRevizContract();
							var pos = ArrayLib.find(revizContract, ['CONTRACT'], rec.get('LINK'));

							if (pos !== -1) rec.set('REVIZCONTRACT', revizContract[pos].LINK);
						};

					var bindText = th.getBindText(rec);
					if (!!(!checked && revizContract && bindText.length)) {
						selectDialogShow(KS.L10n.attention, wmc.getContinueQuestion(bindText), function () {
							if (factNarGrid) {
								factNarGrid.store.each(function (nar) {
									if (nar.get('REVIZCONTRACT') === rec.get('REVIZCONTRACT')) nar.set('REVIZCONTRACT', 0);
								});
								factNarGrid.view.refresh();
							}

							if (disGrid) {
								disGrid.store.each(function (dis) {
									if (dis.get('REVIZCONTRACT') === rec.get('REVIZCONTRACT')) dis.set('REVIZCONTRACT', 0);
								});
								disGrid.view.refresh();
							}

							th.factNarRevizContract = 0;
							endFunc(false, 0, '');
							th.Grid.view.refresh();
						}, function() { rec.set('M', true) });
					} else {
						if (checked) {
							summ = rec.get('SUMMA');
						}

						endFunc(checked, summ || 0, budjName || '');
					}

					th.gksc('fillBtn')
						.setDisabled(!th.Grid.store.getDataExt().filter(function(d) { return d.M === true; }).length);
				},
				beforecheckchange: function() {
					if (me.readOnly || me.ksReadOnly || contractGridReadOnly) return false;
				}
			},
			checkRenderer: function(value, meta, rec) {
				var cssPrefix = Ext.baseCSSPrefix,
					cls = cssPrefix + 'grid-checkcolumn',
					factNarRevizContract = me.gksc('contractPanel').factNarRevizContract;

				if (this.disabled) {
					meta.tdCls += ' ' + this.disabledCls;
				}
				if (value) {
					cls += ' ' + cssPrefix + 'grid-checkcolumn-checked';
				}
				if (factNarRevizContract && factNarRevizContract === rec.get('REVIZCONTRACT')) {
					meta.tdCls += ' ' + greenyellowCls;
				}
			},
			createGridListeners: function() {
				var th = this;

				th.callParent(arguments);
				th.objs.gridListeners.select = function(dv, rec) {
					if (!rec) return;

					var activeTab = me.gksc('narDisTab').activeTab;
					if (!activeTab) return;

					var activeGrid = me.gksc(activeTab.tabKey === 'dis' ? 'disGrid' : 'factNarGrid');
					if (!activeGrid) return;

					activeGrid.objLink = rec.get('S_ORG');
					activeGrid.revizContract = rec.get('REVIZCONTRACT');

					var selRec = activeGrid.getFrstSelect();
					if (selRec) me.gksc('contractPanel').factNarRevizContract = selRec.get('REVIZCONTRACT');

					activeGrid.view.refresh();
				};
				th.objs.gridListeners.ksAfterRefresh = function(t, items) {
					me.gksd('contract').contractData = items;
				};
				th.objs.gridListeners.beforeedit = function(plugin, context) {
					if ((context.field === 'SUMMACHECK') && !context.record.get('M')) return false;
				};
			},
			createTBar: function() {
				var th = this,
					contractTBar = th.callParent(arguments);

				if (!th.f) {
					contractTBar.push(th.sksc('fillBtn', Ext.create('Ext.Button', {
							iconCls: 'x_btn_fill',
							tooltip: me.resource.RevizEditView_InitializeComponent_Заполнить_проверенные_суммы,
							tooltipType: 'title',
							handler: function() {
								var contractGrid = me.gksc('contractPanel').Grid;

								contractGrid.store.each(function(rec) {
									if (rec.get('M')) {
										rec.set('SUMMACHECK', convertToDecimal(rec.get('SUMMA'), me.gksd('decimalData')));
									}
								});
								contractGrid.fireEvent('select', th, contractGrid.getFrstSelect());
							}
						})),
						{ xtype: 'tbseparator' },
						th.sksc('galkaBtn', Ext.create('Ext.button.Split', {
							iconCls: 'x_btn_galka',
							tooltip: me.resource.RevizEditView_InitializeComponent_Инверсия,
							tooltipType: 'title',
							disabled: contractGridReadOnly,
							menu: [
								th.inversionHandler = {
									text: me.resource.RevizEditView_InitializeComponent_Инверсия,
									iconCls: 'x_btn_galka',
									handler: function() {
										var items = th.Grid.store.data.items,
											factNarGrid = me.gksc('factNarGrid'),
											disGrid = me.gksc('disGrid'),
											bindText = '';

										for (var i = 0, len = items.length; i < len; i++) {
											bindText = th.getBindText(items[i]);
											if (bindText.length) break;
										}

										if (bindText.length) {
											selectDialogShow(KS.L10n.attention, wmc.getContinueQuestion(bindText), function() {
												th.factNarRevizContract = 0;
												if (factNarGrid) {
													factNarGrid.store.each(function (rec) {
														rec.set('REVIZCONTRACT', 0);
													});
												}
												if (disGrid) {
													disGrid.store.each(function (rec) {
														rec.set('REVIZCONTRACT', 0);
													});
												}
												th.checkInversion();
											});
										} else {
											th.checkInversion();
										}
									}
								}, {
									text: 'Отметить все',
									handler: function() {
										th.checkAll();
									}
								}, {
									text: 'С начала до текущей',
									handler: function() {
										th.checkFstToSel();
									}
								}, {
									text: 'С текущей до конца',
									handler: function() {
										th.checkSelToLst();
									}
								}, {
									text: 'Между отмеченными',
									handler: function() {
										th.checkCheckToCheck();
									}
								}
							],
							handler: function() {
								th.inversionHandler.handler();
							}
						})),
						th.sksc('markBtn', Ext.create('Ext.Button', {
							iconCls: 'x_btn_unmark',
							tooltip: me.resource.RevizEditView_InitializeComponent_Разметить_все,
							tooltipType: 'title',
							disabled: contractGridReadOnly,
							handler: function() {
								var items = th.Grid.store.data.items,
									factNarGrid = me.gksc('factNarGrid'),
									disGrid = me.gksc('disGrid'),
									bindText = '';

								for (var i = 0, len = items.length; i < len; i++) {
									bindText = th.getBindText(items[i]);
									if (bindText.length) break;
								}

								if (bindText.length) {
									selectDialogShow(KS.L10n.attention, wmc.getContinueQuestion(bindText), function() {
										th.factNarRevizContract = 0;
										if (factNarGrid) {
											factNarGrid.store.each(function (rec) {
												rec.set('REVIZCONTRACT', 0);
											});
										}
										if (disGrid) {
											disGrid.store.each(function (rec) {
												rec.set('REVIZCONTRACT', 0);
											});
										}
										th.uncheckAll();
									});
								} else {
									th.uncheckAll();
								}
							}
						}))
					);
				}

				return contractTBar;
			},
			addRevizRecord: function(rec) {
				var th = this,
					columns = me.gksc('contractPanel').Grid.visibleColumnManager.columns,
					pos = ArrayLib.find(columns, ['dataIndex'], 'M');

				if (pos !== -1) {
					columns[pos].fireEvent('checkchange', th, 0, true, rec);
					me.gksc('contractPanel').Grid.getSelectionModel().select(rec);
				}
			},
			getWhereArgs: function() {
				var dtMoney = me.gksd('DTMONEY'),
					objLinks = [];

				if (Ext.isString(dtMoney)) {
					var tmp = JSON.parse(dtMoney);
					dtMoney = { dh1: new Date(tmp.dh1), dh2: new Date(tmp.dh2) };
					me.sksd('DTMONEY', dtMoney);
				}

				Ext.each(me.gksd('tRevizObjects'), function(obj) {
					objLinks.push(obj.TLINK);
				});

				let whereArgs = {
					DBegin: {
						value: dtMoney.dh1.toDateString(),
						type: 'Date'
					},
					DEnd: {
						value: dtMoney.dh2.toDateString(),
						type: 'Date'
					},
					ObjLinks: {
						value: Ext.isNumber(objLinks[0]) ? JSON.stringify(objLinks) : JSON.stringify([]),
						type: 'List_int'
					}
				};
				
				return whereArgs;
			},
			beforeSetData: function(data) {
				var th = this,
					contract = me.gksd('contract'),
					revizContract = contract.revizContract;

				data.fields = me.adaptContractFields(data.fields);
				data.columns = me.adaptContractColumns(data.columns);
				data.data.data = me.adaptedContractData.call(th, data.data.data, revizContract, [], me.gksd('decimalData'));
				me.gksd('contract').revizContract = revizContract;
				th.callParent(arguments);
				//Приходится делать, иначе есть вероятность что revizContract изменится
				me.oldData = JSON.stringify(me.dataCollector());
			},
			setData: function (data, endFunc) {
				var th = this;
				th.callParent(arguments);
				if ((me.ksData.access.contractGridAccess & ObjAccessMask.EDIT) === 0) {
					th.gksc('fillBtn').setDisabled(true);
				} else {
					th.gksc('fillBtn')
						.setDisabled(!this.Grid.store.getDataExt().filter(d=> d.M === true).length);
				}
			},
			setChecks: Ext.emptyFn,
			baseRefresh: function(endFunc, params) {
				var th = this;
				th.callParent([
					function(data) {
						var delLst = [],
							factNarGrid = me.gksc('factNarGrid'),
							disGrid = me.gksc('disGrid');

						me.adaptedContractData.call(th, data.data, me.gksd('contract').revizContract, delLst, me.gksd('decimalData'));
						// учитываем убранные записи финансировния
						if (delLst.length) {
							me.gksd('contract').revizContract = me.gksd('contract').revizContract.filter(function(i) {
								return delLst.indexOf(i) === -1;
							});

							var delRevizContract = [];
							Ext.each(delLst, function(i) { delRevizContract.push(i.LINK); });

							if (factNarGrid) {
								factNarGrid.store.each(function (nar) {
									if (delRevizContract.indexOf(nar.get('REVIZCONTRACT')) !== -1) nar.set('REVIZCONTRACT', 0);
								});
							}
							if (disGrid) {
								disGrid.store.each(function (dis) {
									if (delRevizContract.indexOf(dis.get('REVIZCONTRACT')) !== -1) dis.set('REVIZCONTRACT', 0);
								});
							}
						}

						//Приходится делать, иначе есть вероятность что RevizContract изменится
						me.oldData = JSON.stringify(me.dataCollector());

						if (th.objs.Grid) {
							th.objs.Grid.loadData(data.data);
						}
					}, params
				]);
			},
			'delete': function() {
				var me = this,
					grid = me.objs.Grid,
					sel = grid.getFrstSelect();

				if (sel && !grid.store.getDataExt().filter(d => { return d.LINK === sel.get('LINK'); }).length) {
					return;
				}

				me.callParent(arguments);
			},
			functions: {
				edit: function(cfg) {
					if (cfg.f !== 'new' &&
						!me.gksc('contractPanel').Grid.store.getDataExt().filter(d => { return d.LINK === cfg.data.data.LINK; }).length) {
						return;
					}

					var dh = me.gksd('DTMONEY'),
						year = dh.dh1.getFullYear();

					if (cfg.f === 'new') {
						cfg.data = {};
						var obj = me.ksData.tRevizObjects[0];
						cfg.data.data = {
							S_ORG_CODE: obj.TEMP_CODE,
							S_ORG_NAME: obj.TEMP_NAME,
							S_ORG: obj.TLINK
						};
					}

					cfg.data.data.DT = {
						dh1: new Date(year + '/01/01'),
						dh2: new Date(year + '/12/31')
					};
					cfg.readOnly = me.readOnly;
					Ext.create(cfg.editClass, cfg);
				},
				'delete': function(links, endFunc) {
					var th = this,
						store = th.Grid.store,
						link = links[0],
						rec = store.getRecord(link, 'LINK'),
						bindText = th.getBindText(rec);

					if (bindText.length) {
						warning(wmc.get('DeleteContractWarning'));
						endFunc(false);
					} else {
						ajaxRequest({
							params: {
								revizLink: me.ksData.link,
								contractLink: link,
								revizContractLink: rec.get('REVIZCONTRACT') || 0
							},
							url: 'SReviz/DeleteContract_A',
							success: function(value) {
								if (value.result) {
									store.remove(rec);
									endFunc(value.result);
								}
							},
							callback: function() { delete me.ridDel; }
						});
					}
				}
			}
		});
	},
	
	createInfoPanel: function() {
		var me = this,
			ksControls = me.ksControls;

		return ksControls.infoPanel = Ext.create('Keysystems.Info.List', {
			title: 'Информация о нарушениях',
			head: false,
			tabMode: true,
			closable: false,
			btnsHide: {
				refresh: true,
				print: true,
				search: true,
				reset: true,
				show_actual: true,
				nastr_grid: true,
				relations: true,
				journal: true,
				autofilter: true,
				batch_change: true,
			},
			code: 'DOCUMENT_INFO',
			GateCode: 'DOCUMENT_INFO',
			linkCode: 'SDocInfo',
			controlName: 'revizInfo',
			parentView: ksControls.InfoPanelContainer,
			mode: 'SINGL',
			hidePagging: true,
			pageSize: me.infoPageSize,
			checkModel: false,
			accessReadOnly: (me.ksData.access.infoAccess & ObjAccessMask.EDIT) === 0,
			getGridCfg: function() {
				var cfg = this.callParent(arguments);
				cfg.autoScroll = true;
				return cfg;
			},
			isRevizBind: function(rec) {
				var factNarGrid = me.gksc('factNarGrid'),
					disGrid = me.gksc('disGrid'),
					res = false;
				
				if (factNarGrid) {
					res |= ArrayLib.find(factNarGrid.store.getDataExt(), ['INFO'], rec.get('LINK')) !== -1;
				}
				if (disGrid) {
					res |= ArrayLib.find(disGrid.store.getDataExt(), ['INFO'], rec.get('LINK')) !== -1;
				}
				
				return res;
			},
			//Отключаем серверную сортировку
			getGridStoreCfg: function() {
				var cfg = this.callParent(arguments);
				cfg.remoteSort = false;
				return cfg;
			},
			createGridListeners: function() {
				var th = this;

				th.callParent(arguments);
				th.objs.gridListeners.select = function(dv, rec) {
					if (Array.isArray(rec) && !rec.length) {
						return;
					}

					var activeTab = me.gksc('narDisTab').activeTab;
					if (!activeTab) return;
					
					var	activeGrid = me.gksc(activeTab.tabKey === 'dis' ? 'disGrid' : 'factNarGrid');
					if (!activeGrid) return;
					
					activeGrid.objLink = rec.get('S_ORGC');
					activeGrid.info = rec.get('LINK');
					activeGrid.view.refresh();
					this.view.refresh();
				};
				//th.objs.gridListeners.ksAfterRefresh = function (t, items) {
				//	me.gksd('financ').financData = items;
				//};
			},
			getWhereArgs: function() {
				let dtMoney = me.gksd('DTMONEY'),
					troLinks = ArrayLib.getLinks(me.gksd('tRevizObjects'), 'LINK'),
					traRec = _;

				if (troLinks.length) {
					traRecs = me.gksd('tRevizAudit').filter(d => { return d.T_REVIZ_OBJECTS === troLinks[0]; });
					if (traRecs.length) {
						traRec = traRecs[0];
					}
				}

				if (Ext.isString(dtMoney)) {
					var tmp = JSON.parse(dtMoney);
					dtMoney = { dh1: new Date(tmp.dh1), dh2: new Date(tmp.dh2) };
					me.sksd('DTMONEY', dtMoney);
				}

				return {
					RevizObjects: {
						value: traRec ? traRec.S_ORG : window.user.org.data.LINK,
						type: 'RevizObjects'
					},
					DBegin: {
						value: dtMoney.dh1.toDateString(),
						type: 'Date'
					},
					DEnd: {
						value: dtMoney.dh2.toDateString(),
						type: 'Date'
					},
					InfoOnly: {value: 'False', type: 'bool'},
					OrgR: {
						value: JSON.stringify([]),
						type: 'List_int'
					}
				};
			},
			beforeSetData: function(data) {
				var th = this;

				data.columns = me.adaptInfoSubColumns(data.columns);
				th.callParent(arguments);
			},
			functions: {
				edit: function(cfg) {
					var dtMoney = me.gksd('DTMONEY'),
						dh = {
							dh1: dtMoney.dh1,
							dh2: dtMoney.dh1
						};

					if (cfg.f === 'new') {
						cfg.data = {};
						var obj = me.ksData.tRevizObjects[0];
						cfg.data.data = {
							S_ORG_CODE: obj.TEMP_CODE,
							S_ORG_NAME: obj.TEMP_NAME,
							S_ORG: obj.TLINK
						};
					}

					cfg.data.data.S_ORGR = ksControls.S_ORGP_Grid.store.getDataExt();
					cfg.data.data.DT = dh;
					cfg.readOnly = me.readOnly;
					Ext.create(cfg.editClass, cfg);
				},
				'delete': function(links, endFunc) {
					var th = this,
						store = th.Grid.store,
						link = links[0],
						rec = store.getRecord(link, 'LINK'),
						bind = th.isRevizBind(rec);

					if (bind) {
						warning(wmc.get('DeleteInfoWarning'));
						endFunc(false);
					} else {
						ajaxRequest({
							params: {
								revizLink: me.ksData.link,
								infoLink: link
							},
							url: 'SReviz/DeleteInfo_A',
							success: function(value) {
								if (value.result) {
									store.remove(rec);
									endFunc(value.result);
								}
							},
							callback: function() { delete me.ridDel; }
						});
					}
				}
			}
		});
	},
	//#endregion Создание компонентов

	//#region Загрузка данных 
	loadCopyEditData: Ext.emptyFn,
	getExtra: function(endFunc) {
		this.ownerCt.getExtra.call(this, endFunc);
	},
	setExtra: function(value) {
		var me = this,
			ksData = me.ksData,
			ksControls = me.ksControls;

		me.ownerCt.setExtra.call(me, value);
		me.resource = KS.L10n;
		me.sksd('decimalData', value.decimalData);

		me.sksd('progPerson', value.progPerson);
		me.sksd('progData', value.tRevizSProg);
		ksControls.S_ORGP_Grid = me.ownerCt.ksControls.General.ksControls.S_ORGP_Grid;
		me.sksd('sPersonsLinks', ArrayLib.getLinks(me.gksd('sPerson'), ['S_PERSON']));
		me.sksd('sAuthorityLinks', ArrayLib.getLinksTree(me.gksd('sAuthority'), ['LINK']));
		me.sksd('isAuthority', value.isAuthority);
		me.sksd('AutoFillSAuthority', value.AutoFillSAuthority);

		me.isFinanc = value.breachType & 1;
		me.isOkp = value.breachType & 2;
		me.isInfo = value.breachType & 4;
		me.isRDoc = value.breachType & 8;
		me.isRNpa = value.breachType & 16;
		me.isContract = value.breachType & 32;

		me.sksd('disLinks', value.disLinks);

		//#region FactNar
		var fn = value.factNar;
		ksData.factNarRem = fn.factNarRem;
		ksData.factNarNpa = fn.npa;
		ksData.factNarNpaOtv = fn.npaOtv;
		ksData.factNarNpaExt = fn.npaExt;
		ksData.factNarContent = fn.content;
		ksData.factNarRecommendation = fn.recommendation;
		ksData.tFactNarObjects = value.tFactNarObjects;
		ksData.CreateChildFactnar = fn.CreateChildFactnar;
		ksData.articleListData = fn.articleListData;
		ksData.isEditFactNarNpa = fn.isEditFactNarNpa;
		ksData.isEditFactNarNpaOtv = fn.isEditFactNarNpaOtv;
		ksData.autoNumericMaskOrd2 = fn.autoNumericMaskOrd2;
		ksData.access = value.access;
		me.setAccessStore(value.access);
		ksData.subStatuses = fn.subStatuses;
		ksData.visibleStatus = fn.visibleStatus;
		//#endregion FactNar

		me.allNarExtra(value);
		me.fireEvent('activate');
		me.setKsReadOnly(me.ownerCt.ksReadOnly);
		me.ksData.isActual.Nar = true;

		me.ksData.dataChangeStatus = {};
	},
	getExtraNew: function(endFunc) {
		var me = this,
			ksData = me.ksData;

		ksData.factNarRem = [];
		ksData.factNarNpa = [];
		ksData.factNarNpaOtv = [];
		ksData.factNarNpaExt = [];
		ksData.factNarContent = [];
		ksData.factNarRecommendation = [];
		ksData.tFactNarObjects = [];
		me.getExtra(endFunc);
	},
	allNarExtra: function(value) {
		var me = this,
			ksData = me.ksData,
			ksControls = me.ksControls,
			narTab = ksControls.narTab,
			i,
			len,
			fn = ksData.factNar = value.factNar;
		
		//#region Финансирование
		if (me.isFinanc) {
			if (!ksControls.FinancPanelContainer) {
				narTab.add(ksControls.FinancPanelContainer = Ext.create('Ext.panel.Panel', {
					title: 'Финансирование',
					listeners: {
						activate: function() {
							if (ksControls.financPanel) {
								var activeTab = me.gksc('narDisTab').activeTab;
								if (!activeTab) return;
								
								var isDis = activeTab.tabKey === 'dis',
									activeGrid = me.gksc(isDis ? 'disGrid' : 'factNarGrid'),
									rec = ksControls.financPanel.Grid.getFrstSelect();

								if (!activeGrid) return;
								if (rec) {
									activeGrid.objLink = rec.get('SORGC');
									activeGrid.revizMoney = rec.get('REVIZMONEY');

									var selRec = activeGrid.getFrstSelect();
									if (selRec) {
										ksControls.financPanel.factNarRevizMoney = selRec.get('REVIZMONEY');
									}
								}

								activeGrid.imgHandler = activeGrid.financHandler;
								activeGrid.imgGetClass = activeGrid.financGetClass;
								activeGrid.imgGetGYCls = activeGrid.financGetGYCls;
								activeGrid.objectRenderer = activeGrid.getPinkCls;

								var columns = activeGrid.headerCt && activeGrid.headerCt.items && activeGrid.headerCt.items.items,
									pos = ArrayLib.find(columns || [], ['dataIndex'], 'IMG');

								if (pos !== -1 && columns[pos] && columns[pos].titleEl) {
									var html = columns[pos].titleEl.dom.innerHTML,
										oldIcon = ksControls.iconCls;

									columns[pos].iconCls = ksControls.iconCls = 'x_btn_currency';
									columns[pos].titleEl.dom.innerHTML = html.replace(oldIcon, ksControls.iconCls);
								}

								ksControls.financPanel.Grid.view.refresh();
								activeGrid.view.refresh();
							}
						},
					},
					layout: { type: 'vbox', align: 'stretch' },
					scrollable: true,
					border: 0,
					tabKey: 'financ',
					items: [
						me.createDictEdit({
							labelWidth: 200,
							key: 'S_VBUDJ',
							code: dnl.S_VBUDJ,
							padding: '5 5 0 5',
							fieldLabel: 'Фильтр по виду средств',
							ksSetValue: function(value) {
								ksControls.S_VBUDJ.setValue(value);
								this.labelEl[value && value.length ? 'addCls' : 'removeCls']('ks-AllowEmpty');
								
								var grid = me.gksc('financPanel').Grid,
									store = grid.getStore(),
									sel = grid.getFrstSelect(),
									vbudjLinks = this.getLinks(),
									filter = store.filters.items.filter(f => { return f._property === 'S_VBUDJ'; })[0];
								
								if (filter) {
									store.filters.remove(filter);
								}
								if (vbudjLinks.length) {
									store.filters.add({
											property: 'S_VBUDJ',
											value: vbudjLinks,
											filterFn: function (item) {
												return vbudjLinks.indexOf(item.get('S_VBUDJ')) !== -1;
											}
										}
									);
								}

								store.filter();
								
								me.filterByVbudj();

								me.gksc('btnAuthority').setDisabled(!sel || !sel.get('M') ||
									!store.getDataExt().filter(d => { return d.LINK === sel.get('LINK'); }).length);
							}
						}),
					]
				}));
			}

			ksData.financ = {};
			ksData.financ.revizMoney = value.revizMoney;
			me.sksd('authorityData', value.authorityData);
		}
		//#endregion Финансирование

		//#region Контракты
		if (me.isContract) {
			if (!ksControls.ContractPanelContainer) {
				narTab.add(ksControls.ContractPanelContainer = Ext.create('Ext.panel.Panel', {
					title: 'Контракты',
					listeners: {
						activate: function() {
							if (ksControls.contractPanel) {
								var activeTab = me.gksc('narDisTab').activeTab;
								if (!activeTab) return;

								var isDis = activeTab.tabKey === 'dis',
									activeGrid = me.gksc(isDis ? 'disGrid' : 'factNarGrid'),
									rec = ksControls.contractPanel.Grid.getFrstSelect();

								if (!activeGrid) return;
								if (rec) {
									activeGrid.objLink = rec.get('SORGC');
									activeGrid.revizContract = rec.get('REVIZCONTRACT');

									var selRec = activeGrid.getFrstSelect();
									if (selRec) {
										ksControls.contractPanel.factNarRevizContract = selRec.get('REVIZCONTRACT');
									}
								}

								activeGrid.imgHandler = activeGrid.contractHandler;
								activeGrid.imgGetClass = activeGrid.contractGetClass;
								activeGrid.imgGetGYCls = activeGrid.contractGetGYCls;
								activeGrid.objectRenderer = activeGrid.getPinkCls;

								var columns = activeGrid.headerCt && activeGrid.headerCt.items && activeGrid.headerCt.items.items,
									pos = ArrayLib.find(columns || [], ['dataIndex'], 'IMG');

								if (pos !== -1 && columns[pos] && columns[pos].titleEl) {
									var html = columns[pos].titleEl.dom.innerHTML,
										oldIcon = ksControls.iconCls;

									columns[pos].iconCls = ksControls.iconCls = 'x_btn_contract_list';
									columns[pos].titleEl.dom.innerHTML = html.replace(oldIcon, ksControls.iconCls);
								}

								ksControls.contractPanel.Grid.view.refresh();
								activeGrid.view.refresh();
							}
						},
					},
					layout: { type: 'vbox', align: 'stretch' },
					scrollable: true,
					border: 0,
					tabKey: 'contract'
				}));
			}

			ksData.contract = {};
			ksData.contract.revizContract = value.revizContract;
		}
		//#endregion Контракты

		//#region Проверенная продукция
		me.sksd('tFactNarRevizOkp', value.tFactNarRevizOkp);
		if (me.isOkp) {
			me.sksd('TypeTransport', value.TypeTransport);

			if (!ksControls.OkpPanel) {
				narTab.add(me.sksc('OkpPanel', Ext.create('Ext.panel.Panel', {
					title: 'Проверенная продукция',
					listeners: {
						activate: function() {
							var activeTab = me.gksc('narDisTab').activeTab;
							if (!activeTab) return;
							
							var rec = ksControls.okpPanel.getSelect(),
								isDis = activeTab.tabKey === 'dis',
								activeGrid = me.gksc(isDis ? 'disGrid' : 'factNarGrid'),
								narRec = activeGrid.getFrstSelect(),
								narLink = narRec ? narRec.get('LINK') : 0;

							if (!activeGrid) return;
							
							if (rec.length) {
								rec = rec[0];

								var filterByNar = ArrayLib.filter(me.gksd('tFactNarRevizOkp'), ['FACTNAR'], narLink);

								me.sksd('okpFactNarData', filterByNar);
								
								activeGrid.okpLink = rec.get('LINK');
							}

							activeGrid.imgHandler = activeGrid.okpHandler;
							activeGrid.imgGetClass = activeGrid.okpGetClass;
							activeGrid.imgGetGYCls = activeGrid.okpGetGYCls;
							activeGrid.objectRenderer = null;

							var columns = activeGrid.headerCt && activeGrid.headerCt.items && activeGrid.headerCt.items.items,
								pos = ArrayLib.find(columns || [], ['dataIndex'], 'IMG');

							if (pos !== -1 && columns[pos] && columns[pos].titleEl) {
								var html = columns[pos].titleEl.dom.innerHTML,
									oldIcon = ksControls.iconCls;

								columns[pos].iconCls = ksControls.iconCls = 'x_btn_product';
								columns[pos].titleEl.dom.innerHTML = html.replace(oldIcon, ksControls.iconCls);
							}

							ksControls.okpPanel.Grid.view.refresh();
							activeGrid.view.refresh();
						}
					},
					layout: 'anchor',
					border: 0,
					tabKey: 'okp'
				})));
			}

			var okp = value.okp,
				okpData = okp.data || [],
				getOkpData = function() {
					return {
						data: me.gksd('okpData'),
						total: me.gksd('okpData').length
					};
				};

			me.sksd('okpData', okpData);
			ksControls.okpPanel = ksControls.okpPanel ||
				Ext.create('Keysystems.Base.List', {
					tabMode: true,
					closable: false,
					checkModel: false,
					btnsHide: {
						search: true,
						print: true,
						nastr_grid: true,
						refresh: true,
						wrap: true,
						relations: true,
						journal: true,
						autofilter: true,
						batch_change: true,
						exit: true
					},
					head: false,
					GateCode: 'edit',
					title: 'Проверенная продукция',
					code: dnl.REVIZ,
					hidePagging: true,
					accessReadOnly: (me.ksData.access.revOkpGridAccess & ObjAccessMask.EDIT) === 0,
					parentView: ksControls.OkpPanel,
					personWhere: me.gksd('sPersonsLinks'),
					columnsAdapted: function(columns) {
						var th = this,
							cols = this.callParent(arguments),
							renderer = function(v, meta, rec) {
								if (me.gksd('okpFactNarData') && (ArrayLib.find(me.gksd('okpFactNarData'), ['REVIZOKP'], rec.get('LINK')) !== -1)) {
									meta.tdCls = greenyellowCls;
								}
								return renderDate(v, meta, rec) || '';
							},
							iPos = ArrayLib.find(cols, ['dataIndex'], 'TYPE');

						if (iPos !== -1) {
							cols[iPos] = {
								xtype: 'misccolumn',
								typeName: 'TypeTransport',
								text: cols[iPos].text,
								minWidth: 100,
								dataIndex: cols[iPos].dataIndex,
								renderer: function(v, meta, rec) {
									return renderer(miscTypes['TypeTransport'][v], meta, rec);
								}
							};
						}

						iPos = ArrayLib.find(cols, ['dataIndex'], 'COUNT');
						if (iPos !== -1) cols[iPos].renderer = renderer;

						return cols;
					},
					functions: {
						edit: function(cfg1) {
							cfg1.okFunc = function(result) {
								if (result.LINK) {
									var pos = ArrayLib.find(me.gksd('okpData'), ['LINK'], result.LINK);
									if (pos !== -1) me.gksd('okpData')[pos] = result;
								} else {
									result.LINK = me.rowRevizOkpLink--;
									me.gksd('okpData').push(result);
								}

								return result;
							};
							cfg1.readOnly = me.readOnly;
							cfg1.TypeTransport = me.gksd('TypeTransport');
							Ext.create('Keysystems.Row.RevizOkp.Edit', cfg1);
						},
						'delete': function(list, endFunc) {
							var pos,
								isDel = false,
								len = list.length;

							for (i = 0; i < len; i++) {
								pos = ArrayLib.find(me.gksd('okpData'), ['LINK'], list[i]);
								if (pos !== -1) {
									isDel = true;
									me.gksd('okpData').splice(pos, 1);
								}
								var dels = ArrayLib.filter(me.gksd('tFactNarRevizOkp'), ['REVIZOKP'], list[i]);
								for (var j = 0, jLen = dels.length; j < jLen; j++) {
									pos = Ext.Array.indexOf(me.gksd('tFactNarRevizOkp'), dels[j]);
									me.gksd('tFactNarRevizOkp').splice(pos, 1);
								}
							}

							endFunc(isDel);

							var activeTab = me.gksc('narDisTab').activeTab;
							if (!activeTab) return;
							
							var activeGrid = me.gksc(activeTab.tabKey === 'dis' ? 'disGrid' : 'factNarGrid');
							if (!activeGrid) return;
							
							selRec = activeGrid.getFrstSelect();
							if (selRec) {
								me.sksd('okpFactNarData', ArrayLib.filter(me.gksd('tFactNarRevizOkp'), ['FACTNAR'], selRec.get('LINK')));
								me.gksc('okpPanel').Grid.extraSelectFrst();
							}

							activeGrid.view.refresh();
						},
						refresh: function(endFunc) { endFunc(getOkpData()); },
						getData: function(endFunc) {
							okp.data = getOkpData();
							loadProfile({
								code: 'DOCUMENT_REVIZ',
								gateCode: 'edit',
								profileKey: 'okpGridColumns',
								callBack: function() {
									endFunc(okp);
								}
							});
						},
						select: function(th, rec) {
							var activeTab = me.gksc('narDisTab').activeTab;
							if (!activeTab) return;
							
							var activeGrid = me.gksc(activeTab.tabKey === 'dis' ? 'disGrid' : 'factNarGrid');
							if (!activeGrid) return;
							
							activeGrid.factNarData = ArrayLib.filter(me.ksData.tFactNarRevizOkp, ['REVIZOKP'], rec.get('LINK'));
							activeGrid.okpLink = rec.get('LINK');
							activeGrid.view.refresh();
						}
					}
				});

			ksControls.okpPanel.Grid.view.refresh();
			ksControls.OkpPanel.Grid = ksControls.okpPanel.Grid;
		}
		//#endregion Проверенная продукция
		
		//#region Информация о нарушениях
		if (me.isInfo) {
			if (!ksControls.InfoPanelContainer) {
				narTab.add(ksControls.InfoPanelContainer = Ext.create('Ext.panel.Panel', {
					title: 'Информация о нарушениях',
					listeners: {
						activate: function() {
							if (ksControls.infoPanel) {
								var activeTab = me.gksc('narDisTab').activeTab;
								if (!activeTab) return;
								
								var isDis = activeTab.tabKey === 'dis',
									activeGrid = me.gksc(isDis  ? 'disGrid' : 'factNarGrid'),
									narRec = activeGrid.getFrstSelect(),
									rec = ksControls.infoPanel.Grid.getFrstSelect();

								if (!activeGrid) return;
								
								if (rec) {
									activeGrid.objLink = rec.get('S_ORGC');

									if (narRec) {
										ksControls.infoPanel.factNarInfo = narRec.get('INFO');
									}
								}

								activeGrid.imgHandler = activeGrid.infoHandler;
								activeGrid.imgGetClass = activeGrid.infoGetClass;
								activeGrid.imgGetGYCls = activeGrid.infoGetGYCls;
								activeGrid.objectRenderer = activeGrid.getPinkCls;

								var columns = activeGrid.headerCt && activeGrid.headerCt.items && activeGrid.headerCt.items.items,
									pos = ArrayLib.find(columns || [], ['dataIndex'], 'IMG');

								if (pos !== -1 && columns[pos] && columns[pos].titleEl) {
									var html = columns[pos].titleEl.dom.innerHTML,
										oldIcon = ksControls.iconCls;

									columns[pos].iconCls = ksControls.iconCls = 'x_btn_docinfo';
									columns[pos].titleEl.dom.innerHTML = html.replace(oldIcon, ksControls.iconCls);
								}

								ksControls.infoPanel.Grid.view.refresh();
								activeGrid.view.refresh();
							}
						}
					},
					layout: 'fit',
					border: 0,
					tabKey: 'info',
					items: [
					]
				}));
			}
		}
		//#endregion Информация о нарушениях

		//#region Проверенные документы
		//todo: после рсхн переписать
		if (me.isRDoc) {
			if (!ksControls.RDocPanel) {
				narTab.add(ksControls.RDocPanel = Ext.create('Ext.panel.Panel', {
					title: 'Проверенные документы',
					dontWaitMsg: true,
					listeners: {
						activate: function() {
							var activeTab = me.gksc('narDisTab').activeTab;
							if (!activeTab) return;
						    
							var panel = ksControls.rDocPanel,
								rec = panel.getSelect(),
								isDis = activeTab.tabKey === 'dis',
								activeGrid = me.gksc(isDis ? 'disGrid' : 'factNarGrid'),
								narRec = activeGrid.getFrstSelect(),
								narLink = narRec ? narRec.get('LINK') : 0;

							if (!activeGrid) return;
							
							panel.factNarData = activeGrid.factNarData = ArrayLib.filter(me.ksData.tFactNarRevizDoc, ['FACTNAR'], narLink);

							activeGrid.imgHandler = activeGrid.rDocHandler;
							activeGrid.imgGetClass = activeGrid.rDocGetClass;
							activeGrid.imgGetGYCls = activeGrid.rDocGetGYCls;
							activeGrid.objectRenderer = null;

							var columns = activeGrid.headerCt && activeGrid.headerCt.items && activeGrid.headerCt.items.items,
								pos = ArrayLib.find(columns || [], ['dataIndex'], 'IMG');

							if (pos !== -1 && columns[pos] && columns[pos].titleEl) {
								var html = columns[pos].titleEl.dom.innerHTML,
									oldIcon = ksControls.iconCls;

								columns[pos].iconCls = ksControls.iconCls = 'x_btn_document';
								columns[pos].titleEl.dom.innerHTML = html.replace(oldIcon, ksControls.iconCls);
							}
							
							var allRDocData = panel.Grid.store.getDataExt();
							panel.checkList = [];
							Ext.each(panel.factNarData, function(rdoc) {
								panel.checkList.push(allRDocData[ArrayLib.find(allRDocData, ['LINK'], rdoc.REVIZDOC)]);
							});
							panel.setChecks(panel.checkList);

							if (rec.length) {
								rec = rec[0];
								activeGrid.rdocLink = rec.get('LINK');
							}

							panel.Grid.view.refresh();
							activeGrid.view.refresh();
						}
					},
					layout: 'anchor',
					border: 0,
					tabKey: 'rdoc'
				}));
			}

			ksData.tFactNarRevizDoc = value.tFactNarRevizDoc;

			var rDoc = value.rDoc,
				docData = rDoc.data || [],
				getDocData = function(page, pageSize) {
					var frst = (page - 1) * pageSize,
						lst = frst + pageSize;
					return {
						data: docData.slice(frst, lst),
						total: docData.length
					};
				};

			ksControls.rDocPanel = ksControls.rDocPanel ||
				Ext.create('Keysystems.RDoc.List', {
					tabMode: true,
					closable: false,
					btnsHide: {
						search: true,
						print: true,
						nastr_grid: true,
						refresh: true,
						wrap: true,
						relations: true,
						journal: true,
						autofilter: true,
						batch_change: true,
						exit: true
					},
					head: false,
					title: 'Проверенный документ',
					mode: 'MULTI',
					GateCode: 'edit',
					code: dnl.REVIZ,
					profileKey: 'rDocPanelColumns',
					hidePagging: true,
					parentView: ksControls.RDocPanel,
					accessReadOnly: (me.ksData.access.revDocGridAccess & ObjAccessMask.EDIT) === 0,
					isRevizBind: function(rec) {
						var activeTab = me.gksc('narDisTab').activeTab;
						if (!activeTab) {
							return false;
						}
						
						var activeGrid = me.gksc(activeTab.tabKey === 'dis' ? 'disGrid' : 'factNarGrid');
						if (!activeGrid) {
							return false;
						}
						
						var sel = activeGrid.getFrstSelect();

						if (sel) {
							var tmpData = ArrayLib.filter(ksData.tFactNarRevizDoc, ['FACTNAR'], sel.get('LINK'));
							return ArrayLib.find(tmpData, ['REVIZDOC'], rec.get('LINK')) !== -1;
						} else {
							return false;
						}
					},
					baseGetExtra: function () { this.afterGetExtra(); },
					clearFile: function(rec) {
						var me = this;
						if (rec) {
							rec.set(me.fieldFile, 0);
							rec.set(me.fieldExt, '');
							var pos = ArrayLib.find(docData, ['LINK'], rec.get('LINK'));
							if (pos !== -1) {
								docData[pos].FILES = 0;
								docData[pos].TEMP_EXT = '';
							}
						} else {
							rec = me.ksControls.fileData;
							var d = rec.data;
							d[me.fieldFile] = 0;
							me.ksControls.btnFile.setIconCls(getExtStyle(d[me.fieldExt] = ''));
						}
						ksControls.rDocPanel.refresh();
					},
					checkRenderer: function(value, meta, rec) {
						var cssPrefix = Ext.baseCSSPrefix,
							factRdoc = ksControls.rDocPanel.factNarData,
							cls = cssPrefix + 'grid-checkcolumn';

						if (this.disabled) {
							meta.tdCls += ' ' + this.disabledCls;
						}
						if (value) {
							cls += ' ' + cssPrefix + 'grid-checkcolumn-checked';
						}

						if (factRdoc && factRdoc.length) {
							meta.tdCls = ArrayLib.find(factRdoc, ['REVIZDOC'], rec.get('LINK')) === -1 ? '' : greenyellowCls;
						}
					},
					checkListeners: {
						checkchange: function(ths, rowIndex, checked, rec) {
							var activeTab = me.gksc('narDisTab').activeTab;
							if (activeTab) {
								var activeGrid = me.gksc(activeTab.tabKey === 'dis' ? 'disGrid' : 'factNarGrid');
								if (!activeGrid) return;
								
								var	factRec = activeGrid.getFrstSelect();
	
								// проверка isRevizBind нужна, т.к. приходим сюда при переключении между записями фактов нарушений,
								// в том случае если у них нет отмеченных Проверенных документов
								if ((checked || ksControls.rDocPanel.isRevizBind(rec)) && factRec && activeGrid.rDocHandler) {
									activeGrid.rDocHandler(activeGrid, factRec, rec, true);
								}
							}
						},
						beforecheckchange: function() {
							let activeTab = me.gksc('narDisTab').activeTab,
								activeGrid = activeTab ? me.gksc(activeTab.tabKey === 'dis' ? 'disGrid' : 'factNarGrid') : _;
							if (!activeGrid || !activeGrid.getFrstSelect() || me.readOnly) return false;
						}
					},
					setChecks: function(checkList, source) {
						var me = this,
							grid = me.Grid;

						if (me.checkModel || me.subCheckModel) {
							if (checkList && checkList.length) {
								for (var i = 0, items = source || grid.store.data.items, len = items.length; i < len; i++) {
									var iPos = ArrayLib.find(checkList, ['data', me.fieldLink], items[i].data[me.fieldLink]);
									if (iPos === -1) iPos = ArrayLib.find(checkList, [me.fieldLink], items[i].data[me.fieldLink]);
									var check = iPos !== -1;
									items[i].data.M = check;
									if (check) checkList[iPos] = items[i];
								}
								me.checkList = checkList;
							} else {
								Ext.each(source || grid.store.data.items,
									function(rec) { me.checkRecord(rec, false); });
								me.uncheckAll();
							}
						}
						me.setSBText(me.dataCount, me.selectLinks.length, me.checkList.length);
					},
					updFileRecord: function(fileObj, rec) {
						var me = this;
						if (rec) {
							rec.set(me.fieldFile, fileObj.id);
							rec.set(me.fieldExt, fileObj.ext);
							var pos = ArrayLib.find(docData, ['LINK'], rec.get('LINK'));
							if (pos !== -1) {
								docData[pos].FILES = fileObj.id;
								docData[pos].TEMP_EXT = fileObj.ext;
							}
							ksControls.rDocPanel.refresh();
						} else {
							var d = me.objs.fileData;
							d[me.fieldFile] = fileObj.id;
							me.objs.btnFile.setIconCls(getExtStyle(d[me.fieldExt] = fileObj.ext));
						}
					},
					columnsAdapted: function(columns) {
						var th = this,
							//cols = th.__columnsAdapted(columns),
							cols = this.callParent(arguments),
							pos = ArrayLib.find(cols, ['dataIndex'], 'NUMBER');

						if (pos !== -1) {
							cols[pos].renderer = function(value, meta, rec) {
								var factRdoc = ksControls.rDocPanel.factNarData;

								if (factRdoc && factRdoc.length) {
									meta.tdCls = ArrayLib.find(factRdoc, ['REVIZDOC'], rec.get('LINK')) === -1 ? '' : greenyellowCls;
								}
								return renderDate(value, meta, rec);
							};
						}

						return cols;
					},
					functions: {
						edit: function(cfg1) {
							cfg1.okFunc = function(result) {
								if (result.LINK) {
									var pos = ArrayLib.find(docData, ['LINK'], result.LINK);
									if (pos !== -1) docData[pos] = result;
								} else {
									result.LINK = me.rowRevizDocLink--;
									docData.push(result);
								}

								return result;
							};
							cfg1.readOnly = me.readOnly;
							Ext.create('Keysystems.Row.RevizDoc.Edit', cfg1);
						},
						'delete': function(list, endFunc) {
							var pos,
								isDel = false,
							len = list.length;
							
							for (i = 0; i < len; i++) {
								pos = ArrayLib.find(docData, ['LINK'], list[i]);
								if (pos !== -1) {
									isDel = true;
									docData.splice(pos, 1);
								}
								var dels = ArrayLib.filter(ksData.tFactNarRevizDoc, ['REVIZDOC'], list[i]);
								for (var j = 0, jLen = dels.length; j < jLen; j++) {
									pos = Ext.Array.indexOf(ksData.tFactNarRevizDoc, dels[j]);
									ksData.tFactNarRevizDoc.splice(pos, 1);
								}
							}
							endFunc(isDel);

							var activeTab = me.gksc('narDisTab').activeTab;
							if (activeTab) {
								var activeGrid = me.gksc(activeTab.tabKey === 'dis' ? 'disGrid' : 'factNarGrid');
								if (activeGrid) {
									activeGrid.view.refresh();
								}
							}
						},
						refresh: function(endFunc, cfg1) { endFunc(getDocData(cfg1.page, cfg1.pageSize)); },
						getData: function(endFunc, cfg1) {
							//todo старый код?
							rDoc.data = getDocData(cfg1.page, cfg1.pageSize);
							loadProfile({
								code: 'DOCUMENT_REVIZ',								
								gateCode: 'edit',
								profileKey: 'rDocPanelColumns',
								callBack: function() {
									endFunc(rDoc);
								}
							});
						},
						select: function(th, rec) {
							var activeTab = me.gksc('narDisTab').activeTab;
							if (activeTab) {
								var activeGrid = me.gksc(activeTab.tabKey === 'dis' ? 'disGrid' : 'factNarGrid');

								if (activeGrid) {
									activeGrid.factNarData = ArrayLib.filter(ksData.tFactNarRevizDoc || [], ['REVIZDOC'], rec.get('LINK'));
									activeGrid.rdocLink = rec.get('LINK');
									activeGrid.view.refresh();
								}
							}
						}
					}
				});
			ksControls.rDocPanel.Grid.view.refresh();
			ksControls.RDocPanel.Grid = ksControls.rDocPanel.Grid;
		}
		//#endregion Проверенные документы

		//#region Проверенные НПА
		if (me.isRNpa) {
			ksData.provNpa = value.rNpa.data;
			ksData.provArticle = value.rNpa.rNpaArticle;
			if (!ksControls.RNpaPanel) {
				narTab.changeTab(me.sksc('RNpaPanel', Ext.create('Ext.panel.Panel', {
					title: 'Проверенные НПА',
					border: 0,
					layout: 'fit',
					tabKey: 'rnpa',
					listeners: {
						activate: function () {
							var activeTab = me.gksc('narDisTab').activeTab;
							if (!activeTab) return;
							
							var isDis = activeTab.tabKey === 'dis',
								activeGrid = me.gksc(isDis ? 'disGrid' : 'factNarGrid');

							if (!activeGrid) return;
							
							var columns = activeGrid.headerCt && activeGrid.headerCt.items && activeGrid.headerCt.items.items,
								pos = ArrayLib.find(columns || [], ['dataIndex'], 'IMG');

							activeGrid.imgHandler = null;
							activeGrid.imgGetClass = null;
							activeGrid.imgGetGYCls = null;
							activeGrid.objectRenderer = null;
							
							if (pos !== -1 && columns[pos] && columns[pos].titleEl) {
								var html = columns[pos].titleEl.dom.innerHTML,
									oldIcon = ksControls.iconCls;

								columns[pos].iconCls = ksControls.iconCls = '';
								columns[pos].titleEl.dom.innerHTML = html.replace(oldIcon, '');
							}
							activeGrid.view.refresh();
						}
					},
					items: [
						me.sksc('RNPA_GRID', Ext.create('Ext.grid.Panel', {
							tbar: [
								Ext.create('Ext.Button', {
									iconCls: 'x_btn_dict',
									tooltip: me.resource.RevizEditView_InitializeComponent_Выбрать_НПА,
									tooltipType: 'title',
									handler: function () {
										var sel = [];
										Ext.each(me.gksc('RNPA_GRID').getStore().getDataExt(),
											function(d) { sel.push({ LINK: d.S_NPA, NAME: d.NAME }); });
										dictFunc({
											parentView: me.getKsControl('view', true, true),
											code: dnl.S_NPA,
											checkList: sel,
											isContent: false,
											isCodeName: true,
											isArticle: true,
											getT_SNPA: function() { return me.gksd('provNpa'); },
											getT_SNPA_SARTICLE: function() { return me.gksd('provArticle'); },
											fieldTSNarSNar: 'FACTNAR_REVIZNPA',
											creTSNpa: function(rec) {
												return {
													LINK: me.tFactnarSNpaLink--,
													S_NPA: rec.LINK || rec.get('LINK'),
													CODE: rec.CODE || rec.get('CODE'),
													NAME: rec.NAME || rec.get('NAME')
												};
											},
											multiSelectGridVisible: false,
											setRecord: function (row, cmp) {
												cmp.data.set(row);
												var newRec = cmp.data.data;
												var updItem = me.gksc('RNPA_GRID').store.data.items.filter(
													function (i) { return i.data.S_NPA === newRec.LINK; })[0];
												
												updItem.data.CODE = newRec.CODE;
												updItem.data.NAME = newRec.NAME;

												me.gksc('RNPA_GRID').store.loadData(updItem, true);
											}
										},
											{
												ok: function (records) {
													var sel = [], 
														del = [], 
														npaLinks = [], 
														newLinks = [];

													Ext.each(records, function(r) { newLinks.push(r.get('LINK')); });
													Ext.each(me.gksc('RNPA_GRID').store.data.items,
														function(i) {
															npaLinks.push(i.data.S_NPA);
															if (newLinks.indexOf(i.data.S_NPA) === -1) del.push(i);
														});

													Ext.each(records,
														function(r) {
															if (npaLinks.indexOf(r.get('LINK')) === -1) {
																var npaRec = me.gksd('provNpa').filter(function(d) {
																	return d.S_NPA === r.get('LINK');
																})[0];
																var articleCodes = [];
																Ext.each(me.gksd('provArticle'),
																	function(d) {
																		if (d.FACTNAR_REVIZNPA === npaRec.LINK)
																			articleCodes.push(d.S_ARTICLE_CODE);
																	});
																sel.push({
																	LINK: npaRec.LINK,
																	CODE: npaRec.CODE,
																	NAME: npaRec.NAME,
																	S_ARTICLE_CODE: articleCodes.join(', '),
																	S_NPA: npaRec.S_NPA
																});
															}
														});

													me.gksc('RNPA_GRID').store.remove(del);
													me.gksc('RNPA_GRID').store.loadData(sel, true);
												}
											});
									}
								}),
								Ext.create('Ext.Button', {
									iconCls: 'x_btn_fill',
									tooltip: me.resource.RevizEditView_InitializeComponent_Заполнить,
									tooltipType: 'title',
									handler: function () {
										let progs = me.gksd('progData'),
											provNPA = me.gksd('provNpa');
										//если нет вопросов и нет НПА - ничего не делаем
										if (!progs.length && !provNPA.length) return;

										let progLinks = [];
										Ext.each(progs, function (prog) {
											progLinks.push(prog.S_RPROG);
										});

										// Заполнить/Очистить НПА по вопросам программы
										if (progs.length) {
											selectDialogShow(wmc.get('Question'), 
												me.resource.RevizEditView_FillNpaFromRProg_Заполнить_проверенные_НПА_из_вопросов_программы_,
												function() {
													ajaxRequest({
														url: 'SReviz/GetNpaByProgs_A',
														params: {
															progLinks: JSON.stringify(progLinks),
															tFactnarSNpaLink: me.tFactnarSNpaLink
														},
														success: function(res) {
															let rows = [];

															me.tFactnarSNpaLink = res.tFactnarSNpaLink;
															me.sksd('provNpa', res.provNpa);
															me.sksd('provArticle', res.provArticle);

															Ext.each(res.provNpa,
																function(npa) {
																	let row = Object.assign({}, npa);
																	articleCodes = [];

																	Ext.each(res.provArticle,
																		function(article) {
																			if (article.FACTNAR_REVIZNPA === row.LINK) {
																				articleCodes.push(
																					article.S_ARTICLE_CODE);
																			}
																		});

																	row.S_ARTICLE_CODE = articleCodes.join(', ');
																	rows.push(row);
																});

															me.gksc('RNPA_GRID').store.removeAll();
															me.gksc('RNPA_GRID').store.loadData(rows, true);
														}
													});
												})
										} else {
											selectDialogShow(wmc.get('Question'),
												me.resource.RevizEditView_FillNpaFromRProg_Очистить_проверенные_НПА_,
												function() {
													me.sksd('provNpa', []);
													me.sksd('provArticle', []);
													me.gksc('RNPA_GRID').store.removeAll();
												});
										}
									}
								}),
								Ext.create('Ext.Button', {
									iconCls: 'x_btn_delete',
									tooltip: me.resource.RevizEditView_InitializeComponent_Удалить,
									tooltipType: 'title',
									handler: function () {
										var sel = me.gksc('RNPA_GRID').selModel.getSelection()[0];
										if (sel) {
											me.gksc('RNPA_GRID').removeSelection(_,
												function() {
													var npaRec = me.gksd('provNpa').filter(function(i) {
														return i.LINK === sel.get('LINK');
													})[0];
													var npaIndex = me.gksd('provNpa').indexOf(npaRec);
													me.gksd('provNpa').splice(npaIndex, 1);
													me.sksd('provArticle',
														me.gksd('provArticle').filter(function(i) {
															return i.FACTNAR_REVIZNPA !== npaRec.LINK;
														}));
												});
										}
									}
								})
							],
							store: Ext.create('Ext.data.Store', {
								fields: ['LINK', 'S_NPA', 'CODE', 'NAME', 'S_ARTICLE_CODE'],
								data: value.rNpa.data,
								proxy: 'memory'
							}),
							columns: [
								{
									text: 'Код НПА',
									dataIndex: 'CODE',
									draggable: false
								},
								{
									text: 'Наименование НПА',
									dataIndex: 'NAME',
									draggable: false
								},
								{
									text: 'Статья',
									dataIndex: 'S_ARTICLE_CODE',
									draggable: false
								}
							],
							plugins: ['gridclipboard'],
							accessReadOnly: (me.ksData.access.revNpaGridAccess & ObjAccessMask.EDIT) === 0,
						}))
					]
				})), true);
			}
		}
		//#endregion Проверенные НПА

		//#region Нарушения
		if (value.access.factnarGridAccess) {
			if (value.resourceFactNar){
				Ext.apply(KS.L10n, value.resourceFactNar);
			}
			//me.sksc('resourceFactNar', value.resourceFactNar);
			if (!me.gksc('narPanelContainer')) {
				let factnarReadOnly = (value.access.factnarGridAccess & ObjAccessMask.EDIT) !== ObjAccessMask.EDIT;
				me.gksc('narDisTab').add(
					me.sksc('narPanelContainer', Ext.create('Ext.panel.Panel', {
						title: 'Нарушение',
						border: 0,
						layout: 'fit',
						tabKey: 'nar',
						items: []
					}))
				);

				me.sksc('factNarGridTree', Ext.create('Keysystems.FactNar.List.Tree', {
					border: 0,
					head: false,
					hideFilterPanel: true,
					hideBottomPanel: true,
					canCreateChildFactnar: me.gksd('CreateChildFactnar'),
					tabMode: true,
					closable: false,
					parentView: me.gksc('narPanelContainer'),
					accessReadOnly: factnarReadOnly || me.readOnly || me.ksReadOnly,
					checkModel: true,
					code: me.code,
					GateCode: 'edit',
					profileKey: 'factNarGridTree',
					linkCode: 'SFactNar',
					//mode: 'MULTI',
					hidePagging: true,
					pageSize: 100000,
					createStatusBar: Ext.emptyFn,
					createGridListeners: function () {
						var th = this,
							objs = th.objs;

						objs.gridListeners = {};
						objs.gridListeners.itemdblclick = function (th, rec) {
							me.rowFactNarEdit('edit', rec);
						};
						objs.gridListeners.select = function (th, rec) {
							if (Ext.isArray(rec)) rec = rec[0];

							var factNarRObject = [],
								okpFactNarData = [],
								factNarData = [],
								financPanel = me.gksc('financPanel'),
								contractPanel = me.gksc('contractPanel'),
								infoPanel = me.gksc('infoPanel'),
								okpPanel = me.gksc('okpPanel'),
								rDocPanel = me.gksc('rDocPanel'),
								factNarInfo = 0,
								pos,
								revizMoney = 0,
								revizContract = 0;

							ksControls.fngBtnNewChild.setDisabled(factnarReadOnly || !rec);
							ksControls.fngBtnCopy.setDisabled(factnarReadOnly || !rec);
							ksControls.fngBtnEdit.setDisabled(!rec);
							ksControls.fngBtnDelete.setDisabled(factnarReadOnly || !rec);
							ksControls.showRems.setDisabled(!rec);
							ksControls.fngBtnJournal.setDisabled(!rec);

							if (rec) {
								pos = ArrayLib.find(me.ksData.tRevizAudit, ['LINK'], rec.get('T_REVIZ_AUDIT'));
								factNarRObject = pos === -1 ? null : ArrayLib.filter(me.ksData.tRevizObjects, ['LINK'], me.ksData.tRevizAudit[pos].T_REVIZ_OBJECTS)[0];
								revizMoney = rec.get('REVIZMONEY');
								revizContract = rec.get('REVIZCONTRACT');
								okpFactNarData = ArrayLib.filter(me.ksData.tFactNarRevizOkp, ['FACTNAR'], rec.get('LINK'));
								factNarInfo = rec.get('INFO');
								factNarData = ArrayLib.filter(me.ksData.tFactNarRevizDoc || [], ['FACTNAR'], rec.get('LINK'));

								var newChildBtnState = true;

								if (rec.get('LINK_SELF') === 0 && revizMoney === 0) {
									newChildBtnState = me.countSummForChild(rec) <= 0;
								}

								ksControls.fngBtnNewChild.setDisabled(newChildBtnState);
							}

							if (financPanel) {
								financPanel.factNarRObject = factNarRObject;
								financPanel.factNarRevizMoney = revizMoney;
								financPanel.Grid.view.refresh();
							}

							if (contractPanel) {
								contractPanel.factNarRObject = factNarRObject;
								contractPanel.factNarRevizContract = revizContract;
								contractPanel.Grid.view.refresh();
							}
							
							if (okpPanel) {
								me.sksd('okpFactNarData', okpFactNarData);
								okpPanel.Grid.view.refresh();
							}

							if (infoPanel) {
								infoPanel.factNarRObject = factNarRObject;
								infoPanel.factNarInfo = factNarInfo;
								infoPanel.Grid.view.refresh();
							}

							if (rDocPanel) {
								var allRDocData = rDocPanel.Grid.store.getDataExt();
								rDocPanel.checkList = [];
								rDocPanel.factNarData = factNarData;
								Ext.each(rDocPanel.factNarData, function (rdoc) {
									rDocPanel.checkList.push(allRDocData[ArrayLib.find(allRDocData, ['LINK'], rdoc.REVIZDOC)]);
								});
								rDocPanel.setChecks(rDocPanel.checkList);
								rDocPanel.Grid.view.refresh();
							}
						};
					},
					createTBar: function () {
						var th = this;

						th.objs.tbar = [
							ksControls.fngBtnRoute = Ext.create('Ext.Button', {
								iconCls: 'x_btn_bpmn_doc_route',
								tooltip: 'Изменить статус',
								tooltipType: 'title',
								hidden: !ksData.visibleStatus,
								disabled: true,
								menu: Ext.create('Ext.menu.Menu',
									{
										items: []
									}),
								handler: function() {}
							}),
							ksControls.fngBtnNew = Ext.create('Ext.Button', {
								iconCls: 'x_btn_new',
								tooltip: me.resource.RevizEditView_tcNarSub_SelectedTabChanged_Создать_нарушение,
								tooltipType: 'title',
								handler: function () {
									me.rowFactNarEdit('new');
								}
							}),
							ksControls.fngBtnNewChild = Ext.create('Ext.Button', {
								iconCls: 'x_btn_treeadd',
								tooltip: me.resource.RevizEditView_InitializeComponent_Создать_подчиненное_нарушение,
								tooltipType: 'title',
								hidden: true,
								disabled: true,
								handler: function () {
									var sel = ksControls.factNarGrid.getFrstSelect();
									if (!sel) return;
									me.rowFactNarEdit('copy', sel, true);
								}
							}),
							ksControls.fngBtnCopy = Ext.create('Ext.Button', {
								iconCls: 'x_btn_copy',
								tooltip: me.resource.RevizEditView_tcNarSub_SelectedTabChanged_Создать_подобное_нарушение,
								tooltipType: 'title',
								disabled: true,
								handler: function () {
									var sel = ksControls.factNarGrid.getFrstSelect();
									if (!sel) return;
									me.rowFactNarEdit('copy', sel);
								}
							}),
							ksControls.fngBtnEdit = Ext.create('Ext.Button', {
								iconCls: 'x_btn_edit',
								tooltip: me.resource.RevizEditView_EnableNarTools_Редактировать_нарушение,
								tooltipType: 'title',
								disabled: true,
								handler: function () {
									var sel = ksControls.factNarGrid.getFrstSelect();
									if (!sel) return;
									me.rowFactNarEdit('edit', sel);
								}
							}),
							ksControls.fngBtnDelete = Ext.create('Ext.Button', {
								iconCls: 'x_btn_delete',
								tooltip: me.resource.RevizEditView_tcNarSub_SelectedTabChanged_Удалить_нарушение,
								tooltipType: 'title',
								disabled: true,
								handler: function () {
									ksControls.factNarGrid.removeSelection(function (rec) {
										var ksData = me.ksData,
											factNarLink = rec.get('LINK'),
											npa = ArrayLib.filter(ksData.factNarNpa, ['FACTNAR'], factNarLink),
											iPos = ArrayLib.find(ksData.tFactNarObjects, ['FACTNAR'], factNarLink),
											i = 0,
											len;

										if (iPos !== -1) ksData.tFactNarObjects.splice(iPos, 1);

										if (me.gksc('okpPanel')) {
											var tFactNarRevizOkp = ArrayLib.filter(me.gksd('tFactNarRevizOkp'), ['FACTNAR'], factNarLink);
											if (tFactNarRevizOkp.length) ArrayLib.removeList(me.gksd('tFactNarRevizOkp'), tFactNarRevizOkp);
										}

										if (ksData.factNarRem.data) {
											var factNarRem = ArrayLib.filter(ksData.factNarRem.data, ['FACTNAR'], factNarLink);
											if (factNarRem.length) ArrayLib.removeList(ksData.factNarRem.data, factNarRem);
										}

										for (i, len = npa.length; i < len; i++) {
											iPos = Ext.Array.indexOf(ksData.factNarNpa, npa[i]);
											ksData.factNarNpa.splice(iPos, 1);
										}

										// НПА(ответств.)
										ksData.factNarNpaOtv = ksData.factNarNpaOtv.filter(function (i) {
											return i.FACTNAR !== factNarLink;
										});
										// НПА(доп.)
										ksData.factNarNpaExt = ksData.factNarNpaExt.filter(function (i) {
											return i.FACTNAR !== factNarLink;
										});
									}, function () {
										ksControls.factNarGrid.getSelectionModel().select(ksControls.factNarGrid.getFrstSelect() || []);
									});
								}
							}),
							{xtype: 'tbseparator'},
							ksControls.narRecalcProp = Ext.create('Ext.Button',{
								iconCls: 'x_btn_calcauto',
								tooltip: me.resource.RevizEditView_tcNarSub_SelectedTabChanged_Пересчитать_реквизиты_нарушений,
								tooltipType: 'title',
								hidden: !(me.gksd('isMaskedProps') && me.gksd('showRecalcNarProp')),
								disabled: true,
								handler: function() {
									me.recalcFactNarProps(me.gksc('factNarGrid'));
								}
							}),
							{xtype: 'tbseparator'},
							ksControls.showRems = Ext.create('Ext.Button',
								{
									iconCls: 'x_btn_table_tick',
									tooltip: 'Замечания',
									tooltipType: 'title',
									disabled: true,
									handler: function () {
										var objs = me.objs,
											linkFactNar = ksControls.factNarGrid.getFrstSelect()
												? ksControls.factNarGrid.getFrstSelect().data.LINK
												: 0,
											profileKey = 'dictNarRem',
											gateCode = 'edit',
											prefix = 'narRem';

										if (!linkFactNar) return;

										var factNarRemGrid = Ext.create('Keysystems.Base.List',
											{
												code: me.code,
												parentView: objs.view,
												title: 'Замечания',
												checkModel: false,
												GateCode: gateCode,
												prefix: prefix,
												profileKey: profileKey,
												hidePagging: true,
												pageSize: 1000,
												accessReadOnly: me.gksc('factNarGridTree').accessReadOnly || me.readOnly || me.ksReadOnly,
												btnsShow: {
													'new': true,
													'edit': true,
													'delete': true
												},
												isDis: false,
												recordFactNar: me.ksControls.factNarGrid.getFrstSelect(),
												getFactNarRemData: function () {
													var d = ArrayLib.filter(me.ksData.factNarRem.data, ['FACTNAR'], linkFactNar);
													return {data: d, total: d.length};
												},
												updateFactnarByLastRem: function (sNar) {
													var rowsRem = this.getFactNarRemData().data;

													rowsRem.sort(function (a, b) {
														if (new Date(a.DT) > new Date(b.DT)) return -1;
														if (new Date(a.DT) < new Date(b.DT)) return 1;
														if (new Date(a.DT) - new Date(b.DT) === 0) {
															if (a.LINK > 0 && b.LINK > 0) return b.LINK - a.LINK;
															else return a.LINK - b.LINK;
														}
													});

													var pos = ArrayLib.find(me.ksData.factNar.data, ['LINK'], linkFactNar),
														rowFactNar = me.ksData.factNar.data[pos];

													this.recordFactNar.data.S_NAR = rowFactNar.S_NAR = rowsRem.length ? rowsRem[0].S_NAR2 : sNar.link;
													this.recordFactNar.data.S_NAR_CODE = rowFactNar.TEMP_S_NAR_CODE = rowsRem.length ? rowsRem[0].TEMP_SNAR2_CODE : sNar.code;
													this.recordFactNar.data.S_NAR_NAME = rowFactNar.TEMP_S_NAR_NAME = rowsRem.length ? rowsRem[0].TEMP_SNAR2_NAME : sNar.name;
													this.recordFactNar.data.SUMMA = rowFactNar.SUMMA = rowsRem.length ? rowsRem[0].SUMMA2 : sNar.summa;

													// Заполнить НПА и статьи у факта нарушения по виду нарушения
													ajaxRequest({
														url: 'SNar/GetSNarExtra_A',
														params: {
															link: rowFactNar.S_NAR
														},
														success: function (res) {
															if (res.result) {
																res = res.result;

																if (!me.ksData.isEditFactNarNpa) {
																	var iPos = ArrayLib.find(me.ksData.factNarNpa, ['FACTNAR'], rowFactNar.LINK);
																	me.ksData.factNarNpa.splice(iPos, 1);
																} else {
																	// НПА(наруш.)
																	me.sksd('S_NPA_NAR', res.sNpaNar);
																	me.sksd('articleNarData', res.articleNarListData);
																	me.ksData.factNarNpa = me.ksData.factNarNpa.filter(function (i) {
																		return i.FACTNAR !== rowFactNar.LINK;
																	});	
																	Ext.each(res.sNpaNar, function (v) {
																		me.ksData.factNarNpa.push({
																			S_NPA: v.LINK || v.data.LINK,
																			S_ARTICLE: JSON.stringify(res.articleNarListData.checkedLinks),
																			FACTNAR: rowFactNar.LINK,
																			LINK: me.factNarNpaLink--
																		});
																	});
																}

																if (!me.ksData.isEditFactNarNpa) {
																	var iPos = ArrayLib.find(me.ksData.factNarNpaOtv, ['FACTNAR'], rowFactNar.LINK);
																	me.ksData.factNarNpaOtv.splice(iPos, 1);
																} else {
																	// НПА(ответств.)
																	me.sksd('S_NPA_OTV', res.sNpaOtv);
																	me.sksd('articleData', res.articleListData);
																	me.ksData.factNarNpaOtv = me.ksData.factNarNpaOtv.filter(function (i) {
																		return i.FACTNAR !== rowFactNar.LINK;
																	});
																	Ext.each(res.sNpaOtv, function (v) {
																		me.ksData.factNarNpaOtv.push({
																			S_NPA: v.LINK || v.data.LINK,
																			S_ARTICLE: JSON.stringify(res.articleListData.checkedLinks),
																			FACTNAR: rowFactNar.LINK,
																			LINK: me.factNarNpaOtvLink--
																		});
																	});
																}
															}
														}
													});

													me.gksc('factNarGridTree').refresh();
												},
												baseRefresh: function (callBack) {
													if (callBack && me.ksData.factNarRem) {
														callBack(this.getFactNarRemData());
													}
												},
												functions: {
													getData: function (endFunc) {
														var self = this;
														loadProfile({
															code: me.code,
															prefix: prefix,
															gateCode: gateCode,
															profileKey: profileKey,
															callBack: function () {
																var columns = me.ksData.factNarRem.columns,
																	fields = me.ksData.factNarRem.fields,
																	data = self.getFactNarRemData();
																endFunc({columns: columns, fields: fields, data: data});
															}
														});
													},
													edit: function (cfg) {
														var c = {
															parentRecord: cfg.recordFactNar,
															isFinanc: me.isFinanc,
															baseSaveData: function (params, endFunc) {
																var self = this,
																	dataNarRem = me.ksData.factNarRem.data,
																	result = {};

																if (!params.link) params.link = self.objs.link = me.rowFactNarRemLink--;
																params.LINK = result.LINK = params.link;
																self.oldData = JSON.stringify(params);

																result.NOTE = params.NOTE;
																result.S_NAR1 = params.S_NAR;
																result.S_NAR2 = params.S_NAR_NEW;
																result.TEMP_SNAR1_CODE = params.S_NAR_CODE;
																result.TEMP_SNAR1_NAME = params.S_NAR_NAME;
																result.TEMP_SNAR2_CODE = params.S_NAR_NEW_CODE;
																result.TEMP_SNAR2_NAME = params.S_NAR_NEW_NAME;
																result.FACTNAR = self.recordFactNar.data.LINK;
																result.SUMMA1 = params.SUMMA;
																result.SUMMA2 = params.SUMMA_NEW;
																result.DT = params.DT;

																var pos = ArrayLib.find(dataNarRem, ['LINK'], result.LINK);

																if (pos === -1) {
																	dataNarRem.push(result);
																	dataNarRem.total = dataNarRem.length;
																} else {
																	for (var key in result) dataNarRem[pos][key] = result[key];
																}

																factNarRemGrid.refresh();
																factNarRemGrid.updateFactnarByLastRem();
																self.f = 'edit';
																QuickMsgs.save();
																if (endFunc) endFunc();
															}
														};
														Ext.apply(c, cfg);
														Ext.create('Keysystems.Row.FactNarRem.Edit', c);
													},
													'delete': function (links, endFunc) {
														var sNar = {},
															isDel = false;
														Ext.each(links,
															function (link) {
																var iPos = ArrayLib.find(me.ksData.factNarRem.data, ['LINK'], link);
																if (iPos !== -1) {
																	isDel = true;
																	sNar = {
																		link: me.ksData.factNarRem.data[iPos].S_NAR1,
																		code: me.ksData.factNarRem.data[iPos].TEMP_SNAR1_CODE,
																		name: me.ksData.factNarRem.data[iPos].TEMP_SNAR1_NAME,
																		summa: me.ksData.factNarRem.data[iPos].SUMMA1
																	}
																	me.ksData.factNarRem.data.splice(iPos, 1);
																	me.ksData.factNarRem.data.total = me.ksData.factNarRem.data.length;
																}
															});
														endFunc(isDel);
														factNarRemGrid.updateFactnarByLastRem(sNar);
													}
												}
											});
									}
								}),
							ksControls.fngBtnJournal = Ext.create('Ext.Button',
								{
									iconCls: 'x_btn_journal',
									tooltip: me.resource.RevizEditView_InitializeComponent_Журнал_событий,
									tooltipType: 'title',
									disabled: true,
									handler: function () {
										var sel = ksControls.factNarGrid.getFrstSelect();

										if (sel) {
											const loadMask = new Ext.LoadMask({
												msg: KS.L10n.loading_data,
												view: me
											});
											loadMask.show();

											ajaxRequest({
												params: {
													code: dnl.FACTNAR,
													links: [sel.data[me.fieldLink]]
												},
												url: 'data/DetailEventsLog_A',
												success: function (html) {
													showDetailEventsLog({
														html: html,
														modal: true,
														title: me.parentTitle
													});
												},
												callback: function () {
													loadMask.destroy();
												}
											});
										}
									}
								}),
							ksControls.fngBtnInverse = Ext.create('Ext.button.Split',
								{
									iconCls: 'x_btn_galka',
									tooltip: me.resource.RevizEditView_InitializeComponent_Инверсия,
									tooltipType: 'title',
									menu: [
										{
											text: me.resource.RevizEditView_InitializeComponent_Инверсия,
											iconCls: 'x_btn_galka',
											handler: function() {
												th.checkInversion();
												me.setDisabledBtnRoute(false);
											}
										}, {
											text: 'Отметить все',
											handler: function() {
												th.checkAll();
												me.setDisabledBtnRoute(false);
											}
										}, {
											text: 'С начала до текущей',
											handler: function() {
												th.checkFstToSel();
												me.setDisabledBtnRoute(false);
											}
										}, {
											text: 'С текущей до конца',
											handler: function() {
												th.checkFstToSel();
												me.setDisabledBtnRoute(false);
											}
										}, {
											text: 'Между отмеченными',
											handler: function() {
												th.checkCheckToCheck();
												me.setDisabledBtnRoute(false);
											}
										}
									],
									handler: function() {
										th.checkInversion();
										me.setDisabledBtnRoute(false);
									}
								}),
							ksControls.fngBtnUnmark = Ext.create('Ext.Button', {
								iconCls: 'x_btn_unmark',
								tooltip: me.resource.RevizEditView_InitializeComponent_Разметить_все,
								tooltipType: 'title',
								handler: function() {
									th.checkInversion();
									me.setDisabledBtnRoute(false);
								}
							})
						];
					},
					baseGetData: function (callBack) {
						var fn = me.ksData.factNar,
							disLinks = me.gksd('disLinks');

						const fOrd2 = ArrayLib.filter(fn.fields, ['name'], 'ORD2')[0];
						if (fOrd2) fOrd2.sortType = "asNatural";
						
						if (callBack) {
							callBack({
								columns: fn.columns,
								fields: fn.fields,
								data: me.getFactNarData(fn.data.filter(d => {
									return disLinks.indexOf(d.S_NAR) === -1;
								}))
							});
						}
					},
					baseRefresh: function (callBack) {
						var disLinks = me.gksd('disLinks');
						if (callBack) {
							callBack(me.getFactNarData(me.ksData.factNar.data.filter(d => {
								return disLinks.indexOf(d.S_NAR) === -1;
							})));
						}
					},
					columnsAdapted: me.factnarColumnsAdapted,
					beforeSetData: function(data, params) {
						this.callParent(arguments);

						if (me.ksData.subStatuses && Object.keys(me.ksData.subStatuses).length) {
							for (var key in me.ksData.subStatuses) {
								me.ksControls.fngBtnRoute.menu.add({
									text: me.ksData.subStatuses[key],
									statuses: key,
									handler: function () {
										me.batchChangeStatus(this.statuses, false);
									}
								})
							}
						} else {
							ksControls.fngBtnRoute.setVisible(false);
						}
					},
					getRowClass: function(rec) {
						const hasRem = ksData?.factNarRem?.data?.filter(r => r.FACTNAR === rec.get('LINK'))[0];
						return hasRem ? 'ks-overdue' : '';
					},
					checkListeners: {
						checkchange: function(ths, rowIndex, checked, rec) {
							me.setDisabledBtnRoute(false);
						}
					}
				}));

				me.sksc('factNarGrid', ksControls.factNarGridTree.Grid);
				
				//подгрузку фильтров из профиля для данного делаем вручную. осталось невыясненным почему именно на это гриде элементы rks-filter создаются с задержкой при рендере
				me.gksc('factNarGridTree').columnManager?.loadColumnFilters();

				me.gksc('factNarGrid').view.on('refresh', function() {
					// обрабатываем тут, чтобы всегда учтитывать видимые по фильтру записи
					me.gksc('narRecalcProp').setDisabled(!this.grid.store.getDataExt().length);
				});
			} else {
				me.gksc('factNarGridTree').Grid.store.loadData(me.getFactNarData(value.factNar.data.filter(d => {
					return value.disLinks.indexOf(d.S_NAR) === -1;
				})).data);
				me.gksc('factNarGridTree').Grid.store.load();
				// необходимо обновить данные getRootNode().childNodes,
				// которые берутся в dataCollectore через вызов store.each(func)
			}
		} else {
			me.gksc('S_NAR').setVisible(false);
			me.gksc('narDisTab').setVisible(false);
		}

		if (value.access.disadvantageAccess) {
			if (!me.gksc('disPanelContainer')) {
				let disadvantageReadOnly = (value.access.disadvantageAccess & ObjAccessMask.EDIT) !== ObjAccessMask.EDIT;
				me.sksc('disPanelContainer', Ext.create('Ext.panel.Panel', {
					title: 'Недостатки',
					border: 0,
					layout: 'fit',
					tabKey: 'dis',
					items: []
				}));

				me.sksc('disView', Ext.create('Keysystems.FactNar.List.Tree', {
					border: 0,
					head: false,
					hideFilterPanel: true,
					hideBottomPanel: true,
					tabMode: true,
					closable: false,
					parentView: me.gksc('disPanelContainer'),
					accessReadOnly: disadvantageReadOnly || me.readOnly || me.ksReadOnly,
					checkModel: false,
					code: dnl.FACTNAR_DIS,
					GateCode: 'edit',
					linkCode: 'SFactNar',
					mode: 'SINGL',
					hidePagging: true,
					pageSize: 100000,
					createStatusBar: Ext.emptyFn,
					createGridListeners: function () {
						var th = this,
							objs = th.objs;

						objs.gridListeners = {};
						objs.gridListeners.itemdblclick = function (th, rec) {
							if (me.readOnly) return _;
							me.rowFactNarEdit('edit', rec);
						};
						objs.gridListeners.select = function (th, rec) {
							if (Ext.isArray(rec)) rec = rec[0];

							var factNarRObject = [],
								okpFactNarData = [],
								factNarData = [],
								financPanel = me.gksc('financPanel'),
								contractPanel = me.gksc('contractPanel'),
								infoPanel = me.gksc('infoPanel'),
								okpPanel = me.gksc('okpPanel'),
								rDocPanel = me.gksc('rDocPanel'),
								factNarInfo = 0,
								pos,
								revizMoney = 0,
								revizContract = 0;

							ksControls.disBtnNewChild.setDisabled(disadvantageReadOnly || !rec);
							ksControls.disBtnCopy.setDisabled(disadvantageReadOnly || !rec);
							ksControls.disBtnEdit.setDisabled(!rec);
							ksControls.disBtnDelete.setDisabled(disadvantageReadOnly || !rec);
							ksControls.disShowRems.setDisabled(!rec);
							ksControls.disBtnJournal.setDisabled(!rec);

							if (rec) {
								pos = ArrayLib.find(me.ksData.tRevizAudit, ['LINK'], rec.get('T_REVIZ_AUDIT'));
								factNarRObject = pos === -1 ? null : ArrayLib.filter(me.ksData.tRevizObjects, ['LINK'], me.ksData.tRevizAudit[pos].T_REVIZ_OBJECTS)[0];
								revizMoney = rec.get('REVIZMONEY');
								revizContract = rec.get('REVIZCONTRACT');
								okpFactNarData = ArrayLib.filter(me.ksData.tFactNarRevizOkp, ['FACTNAR'], rec.get('LINK'));
								factNarInfo = rec.get('INFO');
								factNarData = ArrayLib.filter(me.ksData.tFactNarRevizDoc || [], ['FACTNAR'], rec.get('LINK'));

								var newChildBtnState = true;

								if (rec.get('LINK_SELF') === 0 && revizMoney === 0) {
									newChildBtnState = me.countSummForChild(rec) <= 0;
								}

								ksControls.disBtnNewChild.setDisabled(newChildBtnState);
							}

							if (financPanel) {
								financPanel.factNarRObject = factNarRObject;
								financPanel.factNarRevizMoney = revizMoney;
								financPanel.Grid.view.refresh();
							}

							if (contractPanel) {
								contractPanel.factNarRObject = factNarRObject;
								contractPanel.factNarRevizContract = revizContract;
								contractPanel.Grid.view.refresh();
							}

							if (okpPanel) {
								me.sksd('okpFactNarData', okpFactNarData);
								okpPanel.Grid.view.refresh();
							}

							if (infoPanel) {
								infoPanel.factNarRObject = factNarRObject;
								infoPanel.factNarInfo = factNarInfo;
								infoPanel.Grid.view.refresh();
							}

							if (rDocPanel) {
								var allRDocData = rDocPanel.Grid.store.getDataExt();
								rDocPanel.checkList = [];
								rDocPanel.factNarData = factNarData;
								Ext.each(rDocPanel.factNarData, function (rdoc) {
									rDocPanel.checkList.push(allRDocData[ArrayLib.find(allRDocData, ['LINK'], rdoc.REVIZDOC)]);
								});
								rDocPanel.setChecks(rDocPanel.checkList);
								rDocPanel.Grid.view.refresh();
							}
						};
					},
					createTBar: function () {
						var th = this;

						th.objs.tbar = [
							ksControls.disBtnRoute = Ext.create('Ext.Button', {
								iconCls: 'x_btn_bpmn_doc_route',
								tooltip: 'Изменить статус',
								hidden: !ksData.visibleStatus,
								tooltipType: 'title',
								disabled: true,
								menu: Ext.create('Ext.menu.Menu',
									{
										items: []
									}),
								handler: function() {}
							}),
							ksControls.disBtnNew = Ext.create('Ext.Button', {
								iconCls: 'x_btn_new',
								tooltip: me.resource.RevizEditView_tcNarSub_SelectedTabChanged_Создать_недостаток,
								tooltipType: 'title',
								handler: function () {
									me.rowFactNarEdit('new');
								}
							}),
							ksControls.disBtnNewChild = Ext.create('Ext.Button', {
								iconCls: 'x_btn_treeadd',
								tooltip: 'Создать подчиненный недостаток',
								tooltipType: 'title',
								hidden: true,
								disabled: true,
								handler: function () {
									var sel = ksControls.disGrid.getFrstSelect();
									if (!sel) return;
									me.rowFactNarEdit('copy', sel, true);
								}
							}),
							ksControls.disBtnCopy = Ext.create('Ext.Button', {
								iconCls: 'x_btn_copy',
								tooltip: me.resource.RevizEditView_tcNarSub_SelectedTabChanged_Создать_подобный_недостаток,
								tooltipType: 'title',
								disabled: true,
								handler: function () {
									var sel = ksControls.disGrid.getFrstSelect();
									if (!sel) return;
									me.rowFactNarEdit('copy', sel);
								}
							}),
							ksControls.disBtnEdit = Ext.create('Ext.Button', {
								iconCls: 'x_btn_edit',
								tooltip: me.resource.RevizEditView_tcNarSub_SelectedTabChanged_Редактировать_недостаток,
								tooltipType: 'title',
								disabled: true,
								handler: function () {
									var sel = ksControls.disGrid.getFrstSelect();
									if (!sel) return;
									me.rowFactNarEdit('edit', sel);
								}
							}),
							ksControls.disBtnDelete = Ext.create('Ext.Button', {
								iconCls: 'x_btn_delete',
								tooltip: me.resource.RevizEditView_tcNarSub_SelectedTabChanged_Удалить_недостаток,
								tooltipType: 'title',
								disabled: true,
								handler: function () {
									ksControls.disGrid.removeSelection(function (rec) {
										var ksData = me.ksData,
											factNarLink = rec.get('LINK'),
											npa = ArrayLib.filter(ksData.factNarNpa, ['FACTNAR'], factNarLink),
											iPos = ArrayLib.find(ksData.tFactNarObjects, ['FACTNAR'], factNarLink),
											i = 0,
											len;

										if (iPos !== -1) ksData.tFactNarObjects.splice(iPos, 1);

										if (me.gksc('okpPanel')) {
											var tFactNarRevizOkp = ArrayLib.filter(me.gksd('tFactNarRevizOkp'), ['FACTNAR'], factNarLink);
											if (tFactNarRevizOkp.length) ArrayLib.removeList(me.gksd('tFactNarRevizOkp'), tFactNarRevizOkp);
										}

										if (ksData.factNarRem.data) {
											var factNarRem = ArrayLib.filter(ksData.factNarRem.data, ['FACTNAR'], factNarLink);
											if (factNarRem.length) ArrayLib.removeList(ksData.factNarRem.data, factNarRem);
										}

										for (i, len = npa.length; i < len; i++) {
											iPos = Ext.Array.indexOf(ksData.factNarNpa, npa[i]);
											ksData.factNarNpa.splice(iPos, 1);
										}

										// НПА(ответств.)
										ksData.factNarNpaOtv = ksData.factNarNpaOtv.filter(function (i) {
											return i.FACTNAR !== factNarLink;
										});
										// НПА(доп.)
										ksData.factNarNpaExt = ksData.factNarNpaExt.filter(function (i) {
											return i.FACTNAR !== factNarLink;
										});
									}, function () {
										ksControls.disGrid.getSelectionModel().select(ksControls.disGrid.getFrstSelect() || []);
									});
								}
							}),
							{xtype: 'tbseparator'},
							ksControls.disRecalcProp = Ext.create('Ext.Button',{
								iconCls: 'x_btn_calcauto',
								tooltip: me.resource.RevizEditView_tcNarSub_SelectedTabChanged_Пересчитать_реквизиты_недостатков,
								tooltipType: 'title',
								disabled: true,
								hidden: !(me.gksd('isMaskedProps') && me.gksd('showRecalcNarProp')),
								handler: function() {
									me.recalcFactNarProps(me.gksc('disGrid'));
								}
							}),
							{xtype: 'tbseparator'},
							ksControls.disShowRems = Ext.create('Ext.Button',
								{
									iconCls: 'x_btn_table_tick',
									tooltip: me.resource.RevizEditView_InitializeComponent_Замечания,
									tooltipType: 'title',
									disabled: true,
									handler: function () {
										var objs = me.objs,
											linkFactNar = ksControls.disGrid.getFrstSelect()
												? ksControls.disGrid.getFrstSelect().data.LINK
												: 0,
											profileKey = 'dictNarRem',
											gateCode = 'edit',
											prefix = 'narRem';

										if (!linkFactNar) return;

										var factNarRemGrid = Ext.create('Keysystems.Base.List',
											{
												code: me.code,
												parentView: objs.view,
												title: 'Замечания',
												checkModel: false,
												GateCode: gateCode,
												prefix: prefix,
												profileKey: profileKey,
												hidePagging: true,
												pageSize: 1000,
												btnsShow: {
													'new': true,
													'edit': true,
													'delete': true
												},
												isDis: true,
												disLinks: me.gksd('disLinks'),
												recordFactNar: me.ksControls.disGrid.getFrstSelect(),
												accessReadOnly: me.gksc('disView').accessReadOnly || me.readOnly || me.ksReadOnly,
												getFactNarRemData: function () {
													var d = ArrayLib.filter(me.ksData.factNarRem.data, ['FACTNAR'], linkFactNar);
													return {data: d, total: d.length};
												},
												updateFactnarByLastRem: function (sNar) {
													var rowsRem = this.getFactNarRemData().data;

													rowsRem.sort(function (a, b) {
														if (new Date(a.DT) > new Date(b.DT)) return -1;
														if (new Date(a.DT) < new Date(b.DT)) return 1;
														if (new Date(a.DT) - new Date(b.DT) === 0) {
															if (a.LINK > 0 && b.LINK > 0) return b.LINK - a.LINK;
															else return a.LINK - b.LINK;
														}
													});

													var pos = ArrayLib.find(me.ksData.factNar.data, ['LINK'], linkFactNar),
														rowFactNar = me.ksData.factNar.data[pos];

													this.recordFactNar.data.S_NAR = rowFactNar.S_NAR = rowsRem.length ? rowsRem[0].S_NAR2 : sNar.link;
													this.recordFactNar.data.S_NAR_CODE = rowFactNar.TEMP_S_NAR_CODE = rowsRem.length ? rowsRem[0].TEMP_SNAR2_CODE : sNar.code;
													this.recordFactNar.data.S_NAR_NAME = rowFactNar.TEMP_S_NAR_NAME = rowsRem.length ? rowsRem[0].TEMP_SNAR2_NAME : sNar.name;
													this.recordFactNar.data.SUMMA = rowFactNar.SUMMA = rowsRem.length ? rowsRem[0].SUMMA2 : sNar.summa;

													// Заполнить НПА и статьи у факта нарушения по виду нарушения
													ajaxRequest({
														url: 'SNar/GetSNarExtra_A',
														params: {
															link: rowFactNar.S_NAR
														},
														success: function (res) {
															if (res.result) {
																res = res.result;

																if (!me.ksData.isEditFactNarNpa) {
																	var iPos = ArrayLib.find(me.ksData.factNarNpa, ['FACTNAR'], rowFactNar.LINK);
																	me.ksData.factNarNpa.splice(iPos, 1);
																} else {
																	// НПА(наруш.)
																	me.sksd('S_NPA_NAR', res.sNpaNar);
																	me.sksd('articleNarData', res.articleNarListData);
																	me.ksData.factNarNpa = me.ksData.factNarNpa.filter(function (i) {
																		return i.FACTNAR !== rowFactNar.LINK;
																	});
																	Ext.each(res.sNpaNar, function (v) {
																		me.ksData.factNarNpa.push({
																			S_NPA: v.LINK || v.data.LINK,
																			S_ARTICLE: JSON.stringify(res.articleNarListData.checkedLinks),
																			FACTNAR: rowFactNar.LINK,
																			LINK: me.factNarNpaLink--
																		});
																	});
																}

																if (!me.ksData.isEditFactNarNpa) {
																	var iPos = ArrayLib.find(me.ksData.factNarNpaOtv, ['FACTNAR'], rowFactNar.LINK);
																	me.ksData.factNarNpaOtv.splice(iPos, 1);
																} else {
																	// НПА(ответств.)
																	me.sksd('S_NPA_OTV', res.sNpaOtv);
																	me.sksd('articleData', res.articleListData);
																	me.ksData.factNarNpaOtv = me.ksData.factNarNpaOtv.filter(function (i) {
																		return i.FACTNAR !== rowFactNar.LINK;
																	});
																	Ext.each(res.sNpaOtv, function (v) {
																		me.ksData.factNarNpaOtv.push({
																			S_NPA: v.LINK || v.data.LINK,
																			S_ARTICLE: JSON.stringify(res.articleListData.checkedLinks),
																			FACTNAR: rowFactNar.LINK,
																			LINK: me.factNarNpaOtvLink--
																		});
																	});
																}
															}
														}
													});

													me.gksc('disView').refresh();
												},
												baseRefresh: function (callBack) {
													if (callBack && me.ksData.factNarRem) {
														callBack(this.getFactNarRemData());
													}
												},
												functions: {
													getData: function (endFunc) {
														var self = this;
														loadProfile({
															code: me.code,
															prefix: prefix,
															gateCode: gateCode,
															profileKey: profileKey,
															callBack: function () {
																var columns = me.ksData.factNarRem.columns,
																	fields = me.ksData.factNarRem.fields,
																	data = self.getFactNarRemData();
																endFunc({columns: columns, fields: fields, data: data});
															}
														});
													},
													edit: function (cfg) {
														var c = {
															parentRecord: cfg.recordFactNar,
															isFinanc: me.isFinanc,
															baseSaveData: function (params, endFunc) {
																var self = this,
																	dataNarRem = me.ksData.factNarRem.data,
																	result = {};

																if (!params.link) params.link = self.objs.link = me.rowFactNarRemLink--;
																params.LINK = result.LINK = params.link;
																self.oldData = JSON.stringify(params);

																result.NOTE = params.NOTE;
																result.S_NAR1 = params.S_NAR;
																result.S_NAR2 = params.S_NAR_NEW;
																result.TEMP_SNAR1_CODE = params.S_NAR_CODE;
																result.TEMP_SNAR1_NAME = params.S_NAR_NAME;
																result.TEMP_SNAR2_CODE = params.S_NAR_NEW_CODE;
																result.TEMP_SNAR2_NAME = params.S_NAR_NEW_NAME;
																result.FACTNAR = self.recordFactNar.data.LINK;
																result.SUMMA1 = params.SUMMA;
																result.SUMMA2 = params.SUMMA_NEW;
																result.DT = params.DT;

																var pos = ArrayLib.find(dataNarRem, ['LINK'], result.LINK);

																if (pos === -1) {
																	dataNarRem.push(result);
																	dataNarRem.total = dataNarRem.length;
																} else {
																	for (var key in result) dataNarRem[pos][key] = result[key];
																}

																factNarRemGrid.refresh();
																factNarRemGrid.updateFactnarByLastRem();
																self.f = 'edit';
																QuickMsgs.save();
																if (endFunc) endFunc();
															}
														};
														Ext.apply(c, cfg);
														Ext.create('Keysystems.Row.FactNarRem.Edit', c);
													},
													'delete': function (links, endFunc) {
														var sNar = {},
															isDel = false;
														Ext.each(links,
															function (link) {
																var iPos = ArrayLib.find(me.ksData.factNarRem.data, ['LINK'], link);
																if (iPos !== -1) {
																	isDel = true;
																	sNar = {
																		link: me.ksData.factNarRem.data[iPos].S_NAR1,
																		code: me.ksData.factNarRem.data[iPos].TEMP_SNAR1_CODE,
																		name: me.ksData.factNarRem.data[iPos].TEMP_SNAR1_NAME,
																		summa: me.ksData.factNarRem.data[iPos].SUMMA1
																	}
																	me.ksData.factNarRem.data.splice(iPos, 1);
																	me.ksData.factNarRem.data.total = me.ksData.factNarRem.data.length;
																}
															});
														endFunc(isDel);
														factNarRemGrid.updateFactnarByLastRem(sNar);
													}
												}

											});
									}
								}),
							ksControls.disBtnJournal = Ext.create('Ext.Button',
								{
									iconCls: 'x_btn_journal',
									tooltip: me.resource.RevizEditView_InitializeComponent_Журнал_событий,
									tooltipType: 'title',
									disabled: true,
									handler: function () {
										var sel = ksControls.disGrid.getFrstSelect();

										if (sel) {
											const loadMask = new Ext.LoadMask({
												msg: KS.L10n.loading_data,
												view: me
											});
											loadMask.show();
											ajaxRequest({
												params: {
													code: dnl.FACTNAR_DIS,
													links: [sel.data[me.fieldLink]]
												},
												url: 'data/DetailEventsLog_A',
												success: function (html) {
													showDetailEventsLog({
														html: html,
														modal: true,
														title: me.parentTitle
													});
												},
												callback: function () {
													loadMask.destroy();
												}
											});
										}
									}
								}),
							ksControls.disBtnInverse = Ext.create('Ext.button.Split',
								{
									iconCls: 'x_btn_galka',
									tooltip: me.resource.RevizEditView_InitializeComponent_Инверсия,
									tooltipType: 'title',
									menu: [
										{
											text: me.resource.RevizEditView_InitializeComponent_Инверсия,
											iconCls: 'x_btn_galka',
											handler: function() {
												th.checkInversion();
												me.setDisabledBtnRoute(true);
											}
										}, {
											text: 'Отметить все',
											handler: function() {
												th.checkAll();
												me.setDisabledBtnRoute(true);
											}
										}, {
											text: 'С начала до текущей',
											handler: function() {
												th.checkFstToSel();
												me.setDisabledBtnRoute(true);
											}
										}, {
											text: 'С текущей до конца',
											handler: function() {
												th.checkFstToSel();
												me.setDisabledBtnRoute(true);
											}
										}, {
											text: 'Между отмеченными',
											handler: function() {
												th.checkCheckToCheck();
												me.setDisabledBtnRoute(true);
											}
										}
									],
									handler: function() {
										th.checkInversion();
										me.setDisabledBtnRoute(true);
									}
								}),
							ksControls.disBtnUnmark = Ext.create('Ext.Button', {
								iconCls: 'x_btn_unmark',
								tooltip: me.resource.RevizEditView_InitializeComponent_Разметить_все,
								tooltipType: 'title',
								handler: function() {
									th.checkInversion();
									me.setDisabledBtnRoute(true);
								}
							})
						];
					},
					baseGetData: function (callBack) {
						var fn = me.ksData.factNar,
							disLinks = me.gksd('disLinks');
						
						const fOrd2 = ArrayLib.filter(fn.fields, ['name'], 'ORD2')[0];
						if (fOrd2) fOrd2.sortType = "asNatural";
						
						if (callBack) {
							callBack({
								columns: fn.columns,
								fields: fn.fields,
								data: me.getFactNarData(fn.data.filter(d => {
									return disLinks.indexOf(d.S_NAR) !== -1;
								}))
							});
						}
					},
					baseRefresh: function (callBack) {
						var disLinks = me.gksd('disLinks');
						if (callBack) {
							callBack(me.getFactNarData(me.ksData.factNar.data.filter(d => {
								return disLinks.indexOf(d.S_NAR) !== -1;
							})));
						}
					},
					columnsAdapted: me.factnarColumnsAdapted,
					beforeSetData: function(data, params) {
						this.callParent(arguments);

						if (me.ksData.subStatuses && Object.keys(me.ksData.subStatuses).length) {
							for (var key in me.ksData.subStatuses) {
								me.ksControls.disBtnRoute.menu.add({
									text: me.ksData.subStatuses[key],
									statuses: key,
									handler: function () {
										me.batchChangeStatus(this.statuses, true);
									}
								});
							}
						} else {
							ksControls.disBtnRoute.setVisible(false);
						}
					},
					checkListeners: {
						checkchange: function(ths, rowIndex, checked, rec) {
							me.setDisabledBtnRoute(true);
						}
					}
				}));

				me.sksc('disGrid', ksControls.disView.Grid);
				
				me.gksc('disGrid').view.on('refresh', function() {
					// обрабатываем тут, чтобы всегда учтитывать видимые по фильтру записи
					me.gksc('disRecalcProp').setDisabled(!this.grid.store.getDataExt().length);
				});

				me.gksc('narDisTab').changeTab(me.gksc('disPanelContainer'), true);
			} else {
				me.gksc('disView').Grid.store.loadData(me.getFactNarData(value.factNar.data.filter(d => {
					return value.disLinks.indexOf(d.S_NAR) !== -1;
				})).data);
				// необходимо обновить данные getRootNode().childNodes,
				// которые берутся в dataCollectore через вызов store.each(func)
				me.gksc('disView').Grid.store.load();
			}
		}

		var factNarGrid = me.gksc('factNarGrid'),
			disGrid = me.gksc('disGrid'),
			fnRenderer = function(v, meta, rec) {
				return this.rendererRem(v, meta, rec);
			},
			setFnRenderer = function(cols) {
				var cLen = cols.length,
					j = 0;

				for (; j < cLen; j++) {
					if (cols[j].columns) setFnRenderer(cols[j].columns);
					if (cols[j].xtype !== 'checkcolumn') cols[j].renderer = fnRenderer;
				}
			};

		me.sksd('factNarData', {
			links: fn.links || [],
			extra: {},
			save: {}
		});
		me.sksd('sWork', value.sWork);
		//Делаем кнопку создать подчиненное нарушение видимой по настройке
		ksControls.fngBtnNewChild?.setVisible(fn.CreateChildFactnar);
		ksControls.disBtnNewChild?.setVisible(fn.CreateChildFactnar);

		if (fn.newFactNarExta) {
			var newExtra = fn.newFactNarExta;

			ksData.factNarData.newExtra = newExtra;
			if (factNarGrid) {
				factNarGrid.row = newExtra.row;
				factNarGrid.access = newExtra.row._Access;
				factNarGrid.tabProp = newExtra.tabProp;
			}
			if (disGrid) {
				disGrid.row = newExtra.row;
				disGrid.access = newExtra.row._Access;
				disGrid.tabProp = newExtra.tabProp;
			}
			me.limitNpa = newExtra.limitNpa;
			me.limitNpaOtv = newExtra.limitNpaOtv;
		}

		//#region Колонки, рендеры
		var rendererRem = function(v, meta, rec) {
			let val = v 
				? meta.column.xtype === 'decimalcolumn' 
					? convertToDecimal(v, meta.column.decimalData) 
					: renderDate(v, meta, rec) 
				: '';
			
			return v ? 
				(ArrayLib.find(ksData.factNarRem.data, ['FACTNAR'], rec.get('LINK')) === -1) ?
					val :
					'<span style="color:red">' + val + '</span>':
				'';
		};

		setFnRenderer(fn.columns);

		var iPos1 = ArrayLib.find(fn.columns, ['dataIndex'], 'SUMMA');
		if (iPos1 !== -1) {
			fn.columns[iPos1].renderer = function(v, meta, rec) {
				me.rendererFactNarColor(v, meta, rec, this.ownerCt.ownerCt);
				return this.rendererRem(v, meta, rec);
			};
		}

		iPos1 = ArrayLib.find(fn.columns, ['dataIndex'], 'UNIT');
		if (iPos1 !== -1) {
			fn.columns[iPos1] = {
				xtype: 'misccolumn',
				typeName: 'LandUnit',
				text: fn.columns[iPos1].text,
				minWidth: 100,
				dataIndex: fn.columns[iPos1].dataIndex,
				renderer: function(v, meta, rec) {
					return fnRenderer.call(this, miscTypes['LandUnit'][v], meta, rec);
				}
			};
		}

		iPos1 = ArrayLib.find(fn.columns, ['text'], 'Объект');
		if (iPos1 !== -1) {
			var cs = fn.columns[iPos1].columns;
			len = cs.length;
			for (i = 0; i < len; i++) {
				cs[i].renderer = function(v, meta, rec) {
					if (this.objectRenderer) {
						this.objectRenderer(v, meta, rec, this);
					}
					return this.rendererRem(v, meta, rec);
				};
			}
		}
		
		var getPinkCls = function(v, meta, rec, grid) {
			var pos = ArrayLib.find(ksData.tRevizAudit, ['LINK'], rec.get('T_REVIZ_AUDIT'));
			if (pos !== -1 && grid.objLink) {
				var tro = ArrayLib.filter(ksData.tRevizObjects, ['LINK'], ksData.tRevizAudit[pos].T_REVIZ_OBJECTS)[0];

				if (tro && (tro.TTABLE === 'S_ORG' && tro.TLINK === grid.objLink) || 
					(tro.TTABLE === 'S_PERSON' && tro.TLINK === grid.objLink)) {
					meta.tdCls = pinkCls;
				}
			}
		};

		var financGetGYCls = function(v, meta, rec) {
			var rmLink = rec.get('REVIZMONEY');
			if (this.revizMoney === rmLink && ArrayLib.find(me.gksd('financ').revizMoney, ['LINK'], rmLink) !== -1) {
				meta.tdCls = greenyellowCls;
			}
		};

		var contractGetGYCls = function(v, meta, rec) {
			var rmLink = rec.get('REVIZCONTRACT');
			if (this.revizContract === rmLink && ArrayLib.find(me.gksd('contract').revizContract, ['LINK'], rmLink) !== -1) {
				meta.tdCls = greenyellowCls;
			}
		};
		
		var financGetClass = function(v, meta, rec) {
			var rmLink = rec.get('REVIZMONEY');
			return (rmLink && ArrayLib.find(me.gksd('financ').revizMoney, ['LINK'], rmLink) !== -1) ? ksControls.iconCls : '';
		};

		var contractGetClass = function(v, meta, rec) {
			var rmLink = rec.get('REVIZCONTRACT');
			return (rmLink && ArrayLib.find(me.gksd('contract').revizContract, ['LINK'], rmLink) !== -1) ? ksControls.iconCls : '';
		};

		var okpGetGYCls = function(v, meta, rec) {
			var tFactNarRevizOkp = me.gksd('tFactNarRevizOkp');
			if (!tFactNarRevizOkp && tFactNarRevizOkp.length) return;
			
			var filterByNar = ArrayLib.filter(tFactNarRevizOkp, ['FACTNAR'], rec.get('LINK')),
				findByOkp = ArrayLib.find(filterByNar, ['REVIZOKP'], this.okpLink);
				
			if (findByOkp !== -1) {
				meta.tdCls = greenyellowCls;
			}
		};
		
		var okpGetClass = function(v, meta, rec) {
			return ArrayLib.find(ksData.tFactNarRevizOkp, ['FACTNAR'], rec.get('LINK')) === -1 ? '' : ksControls.iconCls;
		};
		
		var okpHandler = function(grid, rec) {
			if (me.readOnly) return _;
			var okpGrid = ksControls.okpPanel.Grid,
				okpRec = okpGrid.getFrstSelect();

			if (okpRec) me.okpBindHandler(grid, rec.get('LINK'), okpRec.get('LINK'));
		};

		var infoGetGYCls = function(v, meta, rec, grid) {
			if (grid.info === rec.get('INFO')) {
				meta.tdCls = greenyellowCls;
			}
		};
		
		var infoGetClass = function(v, meta, rec) {
			return rec.get('INFO') ? ksControls.iconCls : '';
		};
		
		var infoHandler = function(grid, rec) {
			var infoPanel = ksControls.infoPanel,
				infoGrid = infoPanel.Grid,
				sel = infoGrid.getFrstSelect(),
				okFunc = function(iRec) {
					var tro2 = ArrayLib.filter(ArrayLib.filter(ArrayLib.filter(ksData.tRevizObjects, ['LINK_SELF'], null), ['TTABLE'], 'S_ORG'), ['TLINK'],
						sel.data.S_ORGC)[0];

					if (tro2) {
						var trao = ArrayLib.filter(ksData.tRevizAudit, ['T_REVIZ_OBJECTS'], tro2.LINK)[0];
						var infoLink = iRec.get('LINK');

						rec.set('T_REVIZ_AUDIT', trao.LINK);
						rec.set('TEMP_CODE', tro2.TEMP_CODE);
						rec.set('TEMP_NAME', tro2.TEMP_NAME);
						rec.set('TEMP_SNAME', tro2.TEMP_SNAME);
						rec.set('INFO', infoLink);
						grid.info = infoLink;
						infoPanel.factNarRObject = tro2;
					}
				},
				callBack = function() {
					if (me.readOnly) return _;
					var refreshFunc = function() {
						infoPanel.factNarInfo = rec.get('INFO');
						grid.view.refresh();
						infoGrid.view.refresh();
					};

					if (rec.get('INFO')) {
						selectDialogShow(me.resource.RevizEditView_QuestionAttachFactNarTo_Перенос, me.getBindMsg(false, grid), function () {
							rec.set('INFO', 0);
							refreshFunc();
						}, Ext.emptyFn);
					} else {
						selectDialogShow(me.resource.RevizEditView_QuestionAttachFactNarTo_Перенос, me.getBindMsg(true, grid), function() {
							okFunc(sel);
							refreshFunc();
						}, Ext.emptyFn);
					}
				};

			if (sel) {
				//sel = tmpOrgRec[tmpOrgRec.length - 1];
				var flag = true,
					tro;

				//Если объект финансирования и объект нарушения разные то нельзя привязать
				if (rec.get('T_REVIZ_AUDIT')) {
					var pos = ArrayLib.find(ksData.tRevizAudit, ['LINK'], rec.get('T_REVIZ_AUDIT'));
					if (pos !== -1) {
						tro = ArrayLib.filter(ksData.tRevizObjects, ['LINK'], ksData.tRevizAudit[pos].T_REVIZ_OBJECTS)[0];
						flag = (tro.TTABLE === 'S_ORG' && tro.TLINK === sel.data.S_ORGC);
					}
				}

				if (flag) callBack();
			}
		};
		
		var rDocGetGYCls = function(v, meta, rec, grid) {
			var filterByNar = ArrayLib.filter(me.gksd('tFactNarRevizDoc'), ['FACTNAR'], rec.get('LINK'));
			
			if (ArrayLib.find(filterByNar, ['REVIZDOC'], this.rdocLink) !== -1) {
				meta.tdCls = greenyellowCls;
			}
		};
		
		var rDocGetClass = function(v, meta, rec) {
			return ArrayLib.find(ksData.tFactNarRevizDoc, ['FACTNAR'], rec.get('LINK')) !== -1 ? ksControls.iconCls : '';
		};
		
		var rDocHandler = function(grid, rec, recDoc, isDocGrid) {
			me.rDocBindHandler(grid, rec.get('LINK'), recDoc && recDoc.get('LINK'), false, isDocGrid);
		};

		if (factNarGrid) {
            factNarGrid.rendererRem = rendererRem;
            factNarGrid.getPinkCls = getPinkCls;
            factNarGrid.financGetGYCls = financGetGYCls;
            factNarGrid.financGetClass = financGetClass;
            factNarGrid.financHandler = function(grid, rec) {
                me.financBindHandler(grid, rec);
            };
            factNarGrid.okpGetGYCls = okpGetGYCls;
            factNarGrid.okpGetClass = okpGetClass;
            factNarGrid.okpHandler = okpHandler;
            factNarGrid.infoGetGYCls = infoGetGYCls;
            factNarGrid.infoGetClass = infoGetClass;
            factNarGrid.infoHandler = infoHandler;
            factNarGrid.rDocGetGYCls = rDocGetGYCls;
            factNarGrid.rDocGetClass = rDocGetClass;
            factNarGrid.rDocHandler = rDocHandler;
			factNarGrid.contractGetGYCls = contractGetGYCls;
			factNarGrid.contractGetClass = contractGetClass;
			factNarGrid.contractHandler = function(grid, rec) {
				me.contractBindHandler(grid, rec);
			};
		}
		
		if (disGrid) {
			disGrid.rendererRem = rendererRem;
			disGrid.getPinkCls = getPinkCls;
			disGrid.financGetGYCls = financGetGYCls;
			disGrid.financGetClass = financGetClass;
			disGrid.financHandler = function(grid, rec) {
				me.financBindHandler(grid, rec);
			};
			disGrid.okpGetGYCls = okpGetGYCls;
			disGrid.okpGetClass = okpGetClass;
			disGrid.okpHandler = okpHandler;
			disGrid.infoGetGYCls = infoGetGYCls;
			disGrid.infoGetClass = infoGetClass;
			disGrid.infoHandler = infoHandler;
			disGrid.rDocGetGYCls = rDocGetGYCls;
			disGrid.rDocGetClass = rDocGetClass;
			disGrid.rDocHandler = rDocHandler;
			disGrid.contractGetGYCls = contractGetGYCls;
			disGrid.contractGetClass = contractGetClass;
			disGrid.contractHandler = function(grid, rec) {
				me.contractBindHandler(grid, rec);
			};
		}

		//#endregion Колонки, рендеры
		
		if (me.gksc('factNarGridTree')) {
			me.sksc('factNarColManager', me.gksc('factNarGridTree').columnManager);
			fn.columns = me.factnarColumnsAdapted.call(me.gksc('factNarGridTree'), fn.columns);
		}
		
		if (disGrid) {
			me.sksc('disColManager', me.gksc('disView').columnManager);			
		}
		me.factNarUpdFn(ksData.tRevizAudit);
		
		//#endregion Нарушения

		ksControls.narTab.setActiveTab(0);
		me.gksc('narDisTab').setActiveTab(0);

        if (narTab.items.items.length == 0)
		{
			me.gksc('narTab').setVisible(false);
		}
	},
	rendererFactNarColor: function(v, meta, rec, grid) {
		if (grid.imgGetGYCls) grid.imgGetGYCls(v, meta, rec, grid);
	},
	recalcFactNarProps: function(grid) {
		var me = this,
			isDis = grid === me.gksc('disGrid'),
			title = isDis ? KS.L10n.RevizEditView_BeforeRecalcFactnarProps_Пересчет_реквизитов_недостатков : KS.L10n.RevizEditView_BeforeRecalcFactnarProps_Пересчет_реквизитов_нарушений,
			msg = isDis ? KS.L10n.RevizEditView_tsbReCalcNarProp_Click_Пересчитать_реквизиты_недостатков_ : KS.L10n.RevizEditView_tsbReCalcNarProp_Click_Пересчитать_реквизиты_нарушений_,
			rec = grid.getFrstSelect(),
			buttonText = rec ? { yes: 'Да', no: 'Текущий', cancel: 'Нет' } : { yes: 'Да', no: 'Нет'},
			endFunc = function(links) {
				me.showLoadMask({
					msg: KS.L10n.RevizEditView_BeforeRecalcFactnarProps_Пересчет_реквизитов_нарушений,
					view: me,
					rid: ajaxRequest({
						params: {
							isVfa: me.isVfa,
							revizLink: me.ksData.link,
							links: JSON.stringify(links),
							data: JSON.stringify(me.dataCollector())
						},
						url: 'SReviz/RecalcFactnarProps_A',
						success: function (res) {
							me.hideLoadMask();
							
							var result = res.result,
								factNarData = me.gksd('factNarData'),
								recalcProps = me.gksd('recalcProps');
							
							if (res.errMsg.length) {
								warning("Ошибка при пересчете реквизитов нарушений");
								return;
							}
							
							// если есть данные вкладки, изменим значения там
							if (factNarData && factNarData.extra) {
								for (var fnData in factNarData.extra) {
									var tabProp = factNarData.extra[fnData].tabProp;
									if (!tabProp) continue;

									Ext.each(tabProp.data, d => {
										if (result[fnData]) {
											var calcVal = result[fnData][d.LINK];
											if (calcVal) {
												d.VAL = calcVal;
												delete result[fnData][d.LINK];
												if (!Object.keys(result[fnData]).length) {
													delete result[fnData];
												}
											}
										}
									});
								}
							}
							// сохраним отдельно оставшиеся рассчитаные значения
							if (recalcProps) {
								for (var propLink in result) {
									recalcProps[propLink] = result[propLink];
								}
							} else {
								me.sksd('recalcProps', result);
							}
						},
						failure: function(val) {
							me.hideLoadMask();
							warning("Ошибка при пересчете реквизитов нарушений");
						}
					})
				});
			};

		Ext.Msg.show({
			title: title,
			msg: msg,
			buttonText: buttonText,
			fn: function (buttonId) {
				switch (buttonId) {
					case 'yes':
						var visibleRecs = grid.store.getDataExt(),
							links = [];
						
						Ext.each(visibleRecs, r => {
							links.push(r.LINK);
						});
						endFunc(links);
						break;
					case 'no':
						if (rec) {
							endFunc([rec.get('LINK')]);
						}
						break;
				}
			},
			icon: Ext.MessageBox.QUESTION
		});
	},
	filterByVbudj: function() {
		var me = this,
			vbudjLinks = me.gksc('S_VBUDJ').getLinks(),
			data = me.gksc('financPanel').Grid.store.getDataExt(),
			financRecs = data.filter(d => { return vbudjLinks.indexOf(d.S_VBUDJ) !== -1; }),
			vbudjRevizmoney = ArrayLib.getLinks(financRecs, 'REVIZMONEY'),
			factNarGrid = me.gksc('factNarGrid'),
			disGrid = me.gksc('disGrid'),			
			filterFn = function(grid) {
				var store = grid.getStore(),
					filter = store.filters.items.filter(f => { return f._property === 'REVIZMONEY'; })[0];

				if (filter) {
					store.filters.remove(filter);
				}
				if (vbudjRevizmoney.length) {
					store.filters.add({
							property: 'REVIZMONEY',
							value: vbudjRevizmoney,
							filterFn: function (item) {
								return vbudjRevizmoney.indexOf(item.get('REVIZMONEY')) !== -1;
							}
						}
					);
				}

				store.filter();
			};
		
		if (factNarGrid) {
			filterFn(factNarGrid);
		}
		if (disGrid) {
			filterFn(disGrid);
		}
	},
	factnarColumnsAdapted: function(columns) {
		var th = this,
			ksControls = th.ksControls,
			cols = th.callParent(arguments),
			c = ArrayLib.find(cols, ['dataIndex'], 'REPAYMENT');

		if (c !== -1) {
			c = cols[c];
			c.xtype = 'checkcolumn';
			c.isSummary = false;
			c.summaryType = false;
			c.renderer = _;
			if (!c.listeners) c.listeners = {};
			c.listeners.beforecheckchange = function() {
				return false;
			};
		}

		//костыль. без рендерера не отображаются нули в колонке после reconfigure  
		const colOrd = cols.filter(c=>c.dataIndex === "ORD")[0];
		if (colOrd) colOrd.renderer = (v) => v;
		
		let cImgIdx = ArrayLib.find(cols, ['dataIndex'], 'IMG');
		if (cImgIdx === -1) {
			cols.unshift({
				xtype: 'actionimg',
				dataIndex: 'IMG',
				imgHandler: function (grid, rec) {
					let th = this,
						imgHandler = th.ownerCt.ownerCt.imgHandler;

					if (imgHandler) {
						imgHandler(th.ownerCt.ownerCt, rec);
					}
				},
				iconCls: ksControls.iconCls = 'x_btn_currency',
				renderer: function (v, meta, rec) {
					let ret = '';
						cls = th.Grid?.imgGetGYCls ? th.Grid.imgGetGYCls(v, meta, rec, th.Grid) : null; //th.rendererFactNarColor(v, meta, rec, this.ownerCt.ownerCt);

					if (cls) {
						ret += cls;
					}

					return ret;
				},
				getClass: function (v, meta, rec) {
					let th = this,
						imgGetClass = th.ownerCt.ownerCt.imgGetClass;

					return imgGetClass ? imgGetClass(v, meta, rec) : '';
				}
			});
		}

		//в Base.List.js колонка M создается явно, что вообщем-то неверно. после изменения там, этот код можно убрать
		const mColIdx = ArrayLib.find(cols, ['dataIndex'], 'M');
		if (mColIdx >= 0){
			cols[mColIdx] = cols[mColIdx].initialConfig;
			cols[mColIdx].xtype = 'checkcolumnextra';
		}
		return cols;
	},
	setDisabledBtnRoute: function(isDis){
		var me = this,
			ksControls = me.ksControls;
		if (isDis){
			ksControls.disBtnRoute.setDisabled(!me.gksc('disGrid').store.getDataExt().filter(function(d) { return d.M === true; }).length);
		}
		else{
			ksControls.fngBtnRoute.setDisabled(!me.gksc('factNarGrid').store.getDataExt().filter(function(d) { return d.M === true; }).length);
		}
	},
	//#region get и refresh для factnar
	getFactNarData: function(data) {
		var d = JSON.parse(JSON.stringify(data));
		return { data: d, total: d.length };
	},
	//#endregion get и refresh для factnar

	setKsReadOnly: function(v) {
		let me = this,
			res = me.callParent(arguments);
		if (v || !me.ksData.access) return;

		if ((me.ksData.access.financGridAccess & ObjAccessMask.EDIT) === 0) {
			let list = me.gksc('financPanel');
			list?.Grid.setReadOnly(true);
		}

		if ((me.ksData.access.infoGridAccess & ObjAccessMask.EDIT) === 0) {
			let list = me.gksc('infoPanel');
			list?.Grid.setReadOnly(true);
		}

		if ((me.ksData.access.factnarGridAccess & ObjAccessMask.EDIT) === 0) {
			let grid = me.gksc('factNarGridTree');
			grid?.setReadOnly(true);
			grid?.toolbar?.items.items.forEach(item => {
				if (['x_btn_table_tick', 'x_btn_edit', 'x_btn_journal'].indexOf(item.iconCls) === -1)
					item.setDisabled(true);
			});
			me.ksControls.fngBtnEdit?.setIconCls('x_btn_open');
			me.ksControls.fngBtnEdit?.setTooltip('Открыть');
		}

		if ((me.ksData.access.disadvantageAccess & ObjAccessMask.EDIT) === 0) {
			let list = me.gksc('disView');
			list?.setReadOnly(true);
			list?.toolbar?.items.items.forEach(item => {
				if (['x_btn_table_tick', 'x_btn_edit', 'x_btn_journal'].indexOf(item.iconCls) === -1)
					item.setDisabled(true);
			});
			me.ksControls.disBtnEdit?.setIconCls('x_btn_open');
			me.ksControls.disBtnEdit?.setTooltip('Открыть');
		}

		if ((me.ksData.access.revNpaGridAccess & ObjAccessMask.EDIT) === 0) {
			let grid = me.gksc('RNPA_GRID');
			grid?.setReadOnly(true);
			grid?.getToolbar().items.items.forEach(item => item.setDisabled(true));			
		}
		return res;
	},

	afterCancelLoad: function() {
		this.ownerCt.afterCancelLoad();
	},

	initLoadingMaskCfg: function() {
		return this.ownerCt.initLoadingMaskCfg();
	},
	
	//#endregion Загрузка данных 

	//#region Сохранение данных
	dataCollector: function() {
		var me = this,
			ksControls = me.ksControls,
			ksData = me.ksData,
			factNar = [],
			res = me.ownerCt.dataCollector({}),
			factNarGrid = me.gksc('factNarGrid'),
			disGrid = me.gksc('disGrid'),
			recalcProps = me.gksd('recalcProps');

		var func = function(rec) {
			var dt = rec.get('DTDETECT'),
				dtNar = rec.get('DTNAR'),
				tRevizAudit = rec.get('T_REVIZ_AUDIT'),
				revMoneyLink = rec.get('REVIZMONEY'),
				revContractLink = rec.get('REVIZCONTRACT'),
				fn = ksData.factNarData,
				fnLink = rec.get('LINK');
			
			factNar.push({
				//после открытия окна ред-ия в поле характер уже возвращаются \n вместо \r\n
				CONTENT: rec.get('CONTENT')?.replace(/\r?\n/g, '\r\n') ?? null,
				DTDETECT: dt ? new Date(dt).toDateString() : null,
				DTNAR: dtNar ? new Date(dtNar).toDateString() : null,
				link: fnLink,
				LINK_SELF: rec.get('LINK_SELF'),
				ORD: rec.get('ORD'),
				ORD2: rec.get('ORD2'),
				REPAYMENT: rec.get('REPAYMENT'),
				S_NAR: rec.get('S_NAR'),
				S_PERSONC: rec.get('S_PERSONC'),
				S_PERSONP: rec.get('S_PERSONP'),
				S_RPROG: rec.get('S_RPROG'),
				S_AUTHORITY: rec.get('S_AUTHORITY'),
				S_STATUS: rec.get('S_STATUS'),
				SUMMA: rec.get('SUMMA'),
				T_REVIZ_AUDIT: tRevizAudit,
				USERNAME: rec.get('USERNAME') || null,
				TEMP_CODE: rec.get('TEMP_CODE'),
				TEMP_NAME: rec.get('TEMP_NAME'),
				TEMP_SNAME: rec.get('TEMP_SNAME'),
				REVIZMONEY: revMoneyLink || null,
				REVIZCONTRACT: revContractLink || null,
				INFO: rec.get('INFO') || null,
				AREA: rec.get('AREA') || null,
				UNIT: rec.get('UNIT') || null,
				RECOMMENDATION: rec.get('RECOMMENDATION'),
				ACT_NUMBER: rec.get('ACT_NUMBER'),
				ACT_PAGE: rec.get('ACT_PAGE'),
				TEMP_S_PERSONP_CODE: rec.get('TEMP_S_PERSONP_CODE'),
				TEMP_S_PERSONP_NAME: rec.get('TEMP_S_PERSONP_NAME'),
				TEMP_S_PERSONC_CODE: rec.get('TEMP_S_PERSONC_CODE'),
				TEMP_S_PERSONC_NAME: rec.get('TEMP_S_PERSONC_NAME'),
				TEMP_S_NAR_CODE: rec.get('TEMP_S_NAR_CODE'),
				TEMP_S_NAR_NAME: rec.get('TEMP_S_NAR_NAME'),
				TEMP_S_RPROG_CODE: rec.get('TEMP_S_RPROG_CODE'),
				TEMP_S_RPROG_NAME: rec.get('TEMP_S_RPROG_NAME'),
				TEMP_S_AUTHORITY_CODE: rec.get('TEMP_S_AUTHORITY_CODE'),
				TEMP_S_AUTHORITY_NAME: rec.get('TEMP_S_AUTHORITY_NAME'),
				TEMP_S_STATUS_NAME: rec.get('TEMP_S_STATUS_NAME')
			});

			if (fn.extra[fnLink] && fn.extra[fnLink].tabProp) {
				factNar[factNar.length - 1].tabProp = fn.extra[fnLink].tabProp.data;
			}
		};
		
		if (factNarGrid) {
			factNarGrid.store.each(func);
		}
		if (disGrid) {
			disGrid.store.each(func);
		}

		if (recalcProps) {
			res.recalcProps = recalcProps;
		}
		
		res.factNar = JSON.stringify(factNar);
		// res.factNarNpa = JSON.stringify(ksData.factNarNpa.map(r => {
		// 	r.S_ARTICLE = JSON.stringify(r.S_ARTICLE);
		// 	return r;
		// }));
		res.factNarNpa = JSON.stringify(ksData.factNarNpa);
		res.factNarNpaOtv = JSON.stringify(ksData.factNarNpaOtv);
		res.factNarNpaExt = JSON.stringify(ksData.factNarNpaExt);
		res.tFactNarObjects = JSON.stringify(ksData.tFactNarObjects);
		if (ksData.factNarRem) {
			ksData.factNarRem.data.forEach(function (r) {
				r.DT = r.DT ? new Date(r.DT).toDateString() : null;
			})
			res.factNarRem = JSON.stringify(ksData.factNarRem.data);
		}
		if (ksData.financ) {
			res.revizMoney = JSON.stringify(ksData.financ.revizMoney);
		}
		if (ksData.contract) {
			res.revizContract = JSON.stringify(ksData.contract.revizContract);
		}

		if (me.isOkp) {
			var okp = [];
			ksControls.okpPanel.Grid.store.each(function(rec) {
				okp.push({
					LINK: rec.get('LINK'),
					COUNT: rec.get('COUNT'),
					COUNT_TRANSPORT: rec.get('COUNT_TRANSPORT'),
					S_OKEI: rec.get('S_OKEI'),
					S_OKP: rec.get('S_OKP'),
					S_PERSONP: rec.get('S_PERSONP'),
					S_TN_VED: rec.get('S_TN_VED'),
					S_TRANSPORT: rec.get('S_TRANSPORT'),
					S_TYPECARGO: rec.get('S_TYPECARGO'),
					TYPE: rec.get('TYPE')
				});
			});
			res.okp = JSON.stringify(okp);
			res.tFactNarRevizOkp = JSON.stringify(ksData.tFactNarRevizOkp);
		}

		if (me.isRDoc) {
			var rDoc = [];
			ksControls.rDocPanel.Grid.store.each(function(rec) {
				var dt = rec.get('DT');
				rDoc.push({
					DT: dt ? dt.toDateString() : null,
					FILES: rec.get('FILES'),
					LINK: rec.get('LINK'),
					NUMBER: rec.get('NUMBER'),
					S_RDOC: rec.get('S_RDOC')
				});
			});
			res.rDoc = JSON.stringify(rDoc);
			res.tFactNarRevizDoc = JSON.stringify(ksData.tFactNarRevizDoc);
		}

		if (me.isRNpa) {
			res.rNpa = me.gksd('provNpa');
			res.rArticle = me.gksd('provArticle');
		}

		res.authorityData = me.gksd('authorityData');

		res.tab = me.tabKey;
		
		res.dataChangeStatus = me.ksData.dataChangeStatus;

		return res;
	},
	isFilled: function() {
		var me = this,
			factNarGrid = me.gksc('factNarGrid');
		
		let res = true;		
		// у недостатков нет иерархии
		if (factNarGrid) {
			var state = factNarGrid.store.each(function (rec) {
				if (!rec.isLeaf()) {
					if (me.countSummForChild(rec) > 0) return false;
				}
			});

			if (!state) {
				me.errorMessages(wmc.get('SubSumLessWarninng'));
			}
		}

		return res;
	},
	successSaveFunc: function(result, endFunc, inputParams) {
		var me = this;

		me.revizMoneyLink = -1;
		if (result.result) {
			me.sksd('recalcProps', _);
		}

		me.ownerCt.successSaveFunc(result, endFunc, inputParams);
	},
	//#endregion Сохранение данных

	//#region Оптимизация колонок, полей, данных
	//#region Finance
	adaptedFinanceData: function(data1, data2, delLst, decimalData) {
		var rMoney,
			financ,
			iPos,
			i = 0,
			len = data2.length;
		
		for (; i < len; i++) {
			rMoney = data2[i];
			iPos = ArrayLib.find(data1, ['LINK'], rMoney.FINANC);

			if (iPos !== -1) {
				financ = data1[iPos];
				financ.AGAIN = rMoney.AGAIN;
				financ.M = true;
				financ.SUMMACHECK = rMoney.SUMMA;
				financ.REVIZMONEY = rMoney.LINK;
				financ.TEMP_S_VBUDJ = rMoney.S_VBUDJ;
				financ.TEMP_S_VBUDJ_SNAME = rMoney.TEMP_S_VBUDJ_SNAME;
				this.checkList.push(financ);
			} else {
				//Нужно для того чтобы актуализировать записи revizMoney по дате RWEB-1766
				delLst.push(data2[i]);
			}
		}

		return data1;
	},
	adaptFinanceFields: function(fields) {
		fields.push({
				name: 'AGAIN',
				type: 'bool'
			},
			{
				name: 'REVIZMONEY',
				type: 'int'
			},
			{
				name: 'M',
				type: 'bool'
			},
			{
				name: 'SUMMACHECK',
				type: 'auto'
			});
		fields.push('TEMP_S_VBUDJ_SNAME', 'TEMP_S_VBUDJ', 'REVIZMONEY');
		return fields;
	},
	adaptFinanceColumns: function(cols) {
		var me = this,
			ksControls = me.ksControls,
			pos = ArrayLib.find(cols, ['dataIndex'], 'SUMMA');

		if (pos !== -1) {
			cols[pos].text = 'Исполнено';
			cols[pos].renderer = function(value, meta, rec) {
				if (ksControls.financPanel.factNarRevizMoney && (ksControls.financPanel.factNarRevizMoney === rec.get('REVIZMONEY'))) {
					meta.tdCls = greenyellowCls;
				}
				return convertToDecimal(value, meta.column.decimalData);
			};
		}

		pos = ArrayLib.find(cols, ['dataIndex'], 'S_VBUDJ');
		if (pos !== -1)
			cols[pos].hidden = true;

		pos = ArrayLib.find(cols, ['dataIndex'], 'STATUS');
		if (pos !== -1)
			cols[pos].hidden = true;

		cols.push({
				text: 'Проверено - Сумма',
				dataIndex: 'SUMMACHECK',
				isSummary: true,
				xtype: 'decimalcolumn',
				decimalData: me.gksd('decimalData'),
				editor: {
					xtype: 'calcfield',
					fieldLabel: '',
					decimalData: me.gksd('decimalData'),
					getValue: function() {
						//todo EXTJS71 stackoverflow
						//this.callParent(arguments);
						return this.rawToValue(this.processRawValue(this.getRawValue()));
					},
					listeners: {
						blur: function(th) {
							var sel = ksControls.financPanel.Grid.getFrstSelect(),
								newVal = th.getNumValue(),
								summ = sel.get('SUMMA'),
								endFunc = function() {
									var pos = ArrayLib.find(ksControls.financPanel.Grid.store.getDataExt(),
										    ['LINK'],
										    sel.get('LINK')),
										val = th.getNumValue();

									ksControls.financPanel.Grid.store.getDataExt()[pos].SUMMACHECK = val;
									sel.set('SUMMACHECK', val);

									let revizMoney = me.gksd('financ').revizMoney;
									pos = ArrayLib.find(revizMoney, ['FINANC'], sel.get('LINK'));
									if (pos !== -1) {
										revizMoney[pos].SUMMA = val;
									}
								};

							if (newVal > summ) {
								selectDialogShow(KS.L10n.attention,
									wmc.getContinueQuestion(me.resource.RevizEditView_gridContract_BeforeExitEditMode_Проверенная_сумма_больше_суммы_контракта_),
									function() {
										th.setValue(th.getValue());
									},
									function() {
										th.setValue(summ);
									},
									_,
									endFunc);
							} else {
								th.setValue(th.getValue());
								endFunc();
							}
						}
					}
				}
			},
			{
				text: 'Проверено - По виду средств',
				dataIndex: 'TEMP_S_VBUDJ',
				xtype: 'dictcolumn',
				sortable: true,
				flex: true,
				fieldName: 'SNAME',
				ignoreCodeField: true,
				cleaningKey: false,
				code: dnl.S_VBUDJ,
				ksSetValue: function(value, rec) {
					this.setValue(value, rec);
					let revizMoney = me.gksd('financ').revizMoney,
						pos = ArrayLib.find(revizMoney, ['FINANC'], rec.get('LINK'));
					if (pos !== -1) {
						revizMoney[pos].S_VBUDJ = rec.get('TEMP_S_VBUDJ');
						revizMoney[pos].TEMP_S_VBUDJ_SNAME =
							value && value.length ? (value[0].data || value).NAME : null;
					}
				}
			});

		cols.unshift({
			dataIndex: 'AGAIN',
			width: 60,
			xtype: 'checkcolumn',
			text: 'Повторно',
			index: -2,
			listeners: {
				checkchange: function(ths, indx, checked) {
					var th = ksControls.financPanel,
						revizMoney = me.gksd('financ').revizMoney,
						rec = th.Grid.store.getAt(indx),
						pos;

					rec.set('AGAIN', checked);

					pos = ArrayLib.find(revizMoney, ['FINANC'], rec.get('LINK'));
					if (pos !== -1) {
						revizMoney[pos].AGAIN = checked;
					}
				},
				beforecheckchange: function(a, index, checked) {
					if (me.readOnly) return false;
					if (checked) {
						var th = ksControls.financPanel,
							rec = th.Grid.store.getAt(index);

						return !!rec.get('M');
					}
				}
			}
		});

		return cols;
	},
	//#region Contract
	adaptedContractData: function(data1, data2, delLst, decimalData) {
		var rContract,
			contract,
			iPos,
			i = 0,
			len = data2.length;

		for (; i < len; i++) {
			rContract = data2[i];
			iPos = ArrayLib.find(data1, ['LINK'], rContract.CONTRACT);

			if (iPos !== -1) {
				contract = data1[iPos];
				contract.M = true;
				contract.SUMMACHECK = rContract.SUMMA;
				contract.REVIZCONTRACT = rContract.LINK;
				this.checkList.push(contract);
			} else {
				//Нужно для того чтобы актуализировать записи revizMoney по дате RWEB-1766
				delLst.push(data2[i]);
			}
		}

		return data1;
	},
	adaptContractFields: function(fields) {
		fields.push(
			{
				name: 'REVIZCONTRACT',
				type: 'int'
			},
			{
				name: 'M',
				type: 'bool'
			},
			{
				name: 'SUMMACHECK',
				type: 'auto'
			});
		fields.push('REVIZCONTRACT');
		return fields;
	},
	adaptContractColumns: function(cols) {
		var me = this,
			ksControls = me.ksControls,
			pos = ArrayLib.find(cols, ['dataIndex'], 'SUMMA');

		if (pos !== -1) {
			cols[pos].text = 'Исполнено';
			cols[pos].renderer = function(value, meta, rec) {
				if (ksControls.contractPanel.factNarRevizContract && (ksControls.contractPanel.factNarRevizContract === rec.get('REVIZCONTRACT'))) {
					meta.tdCls = greenyellowCls;
				}
				return convertToDecimal(value, meta.column.decimalData);
			};
		}
		
		cols.push({
				text: 'Проверено - Сумма',
				dataIndex: 'SUMMACHECK',
				isSummary: true,
				xtype: 'decimalcolumn',
				decimalData: me.gksd('decimalData'),
				editor: {
					xtype: 'calcfield',
					fieldLabel: '',
					decimalData: me.gksd('decimalData'),
					getValue: function() {
						//todo EXTJS71 stackoverflow
						//this.callParent(arguments);
						return this.rawToValue(this.processRawValue(this.getRawValue()));
					},
					listeners: {
						blur: function(th) {
							var sel = ksControls.contractPanel.Grid.getFrstSelect(),
								newVal = th.getNumValue(),
								summ = sel.get('SUMMA'),
								endFunc = function() {
									var pos = ArrayLib.find(ksControls.contractPanel.Grid.store.getDataExt(),
										['LINK'],
										sel.get('LINK')),
										val = th.getNumValue();

									ksControls.contractPanel.Grid.store.getDataExt()[pos].SUMMACHECK = val;
									sel.set('SUMMACHECK', val);

									let revizContract = me.gksd('contract').revizContract;
									pos = ArrayLib.find(revizContract, ['CONTRACT'], sel.get('LINK'));
									if (pos !== -1) {
										revizContract[pos].SUMMA = val;
									}
								};

							if (newVal > summ) {
								warning(me.resource.RevizEditView_gridContract_BeforeExitEditMode_Проверенная_сумма_больше_суммы_контракта_);
								th.setValue(0);
							} else {
								th.setValue(th.getValue());
								endFunc();
							}
						}
					}
				}
			});
		
		return cols;
	},
	getRevizMoney: function() {
		var me = this,
			revizMoneyObj = {},
			revizMoney = [],
			financData = me.gksc('financPanel').Grid.store.getDataExt();

		Ext.each(financData, function(rec) {
			var revMoneyLink = rec.REVIZMONEY;

			if (rec.M) {
				if (!revMoneyLink) revMoneyLink = me.revizMoneyLink--;
				if (revizMoneyObj[revMoneyLink]) {
					if (ArrayLib.find(revizMoney, ['LINK'], revMoneyLink) === -1) revizMoney.push(revizMoneyObj[revMoneyLink]);
				} else {
					var sOrgPos = ArrayLib.find(me.gksd('tRevizAudit'), ['TEMP_CODE'], rec.S_ORG_CODE),
						sOrg = me.gksd('tRevizAudit')[sOrgPos === -1 ? 0 : sOrgPos].S_ORG;

					revizMoneyObj[revMoneyLink] = {
						LINK: revMoneyLink,
						REVIZ: me.gksd('link'),
						FINANC: rec.LINK,
						S_ORG: sOrg || 0,
						SUMMA: rec.SUMMACHECK,
						AGAIN: rec.AGAIN || false,
						S_VBUDJ: rec.TEMP_S_VBUDJ,
						TEMP_S_VBUDJ_SNAME: rec.TEMP_S_VBUDJ_SNAME || null
					};

					rec.REVIZMONEY = revMoneyLink;
					revizMoney.push(revizMoneyObj[revMoneyLink]);
				}
			}
		});

		return revizMoney;
	},

	getRevizContract: function() {
		var me = this,
			revizContractObj = {},
			revizContract = [],
			contractData = me.gksc('contractPanel').Grid.store.getDataExt();

		Ext.each(contractData, function(rec) {
			var revContractLink = rec.REVIZCONTRACT;

			if (rec.M) {
				if (!revContractLink) revContractLink = me.revizContractLink--;
				if (revizContractObj[revContractLink]) {
					if (ArrayLib.find(revizContract, ['LINK'], revContractLink) === -1) revizContract.push(revizContractObj[revContractLink]);
				} else {
					var sOrgPos = ArrayLib.find(me.gksd('tRevizAudit'), ['TEMP_CODE'], rec.S_ORG_CODE),
						sOrg = me.gksd('tRevizAudit')[sOrgPos === -1 ? 0 : sOrgPos].S_ORG;

					revizContractObj[revContractLink] = {
						LINK: revContractLink,
						REVIZ: me.gksd('link'),
						CONTRACT: rec.LINK,
						S_ORG: sOrg || 0,
						SUMMA: rec.SUMMACHECK
					};

					rec.REVIZCONTRACT = revContractLink;
					revizContract.push(revizContractObj[revContractLink]);
				}
			}
		});

		return revizContract;
	},
	//#endregion Finance

	adaptInfoSubColumns: function(cols) {
		var ksControls = this.ksControls,
			pos = ArrayLib.find(cols, ['dataIndex'], 'SUMMA');

		if (pos !== -1) {
			cols[pos].renderer = function(value, meta, rec) {
				if (ksControls.infoPanel.factNarInfo === rec.get('LINK')) {
					meta.tdCls = greenyellowCls;
				}
				return convertToDecimal(value, meta.column.decimalData);
			};
		}

		return cols;
	},
	//#endregion Оптимизация колонок, полей, данных

	//#region Грид нарушений
	rowFactNarEdit: function(token, rec, factNarChild) {
		var me = this,
			ksData = me.ksData,
			maxSumm = 0,
			recSumm,
			revizMoney = 0,
			ksControls = me.ksControls,
			activeTab = ksControls.narTab.activeTab,
			narTabSel,
			edit = token === 'edit',
			copy = token === 'copy',
			tabKey = '',
			panel,
			isDis = me.gksc('narDisTab').activeTab.tabKey === 'dis',
			activeGrid = me.gksc(isDis ? 'disGrid' : 'factNarGrid'),
			activeView = me.gksc(isDis ? 'disView' : 'factNarGridTree');

		if (activeTab) {
			tabKey = activeTab.tabKey;

			switch (activeTab.tabKey) {
			case 'financ':
				panel = ksControls.financPanel;
				break;
			case 'contract':
				panel = ksControls.contractPanel;
				break;
			case 'okp':
				panel = ksControls.OkpPanel;
				break;
			case 'info':
				panel = ksControls.infoPanel;
				break;
			case 'rdoc':
				panel = ksControls.RDocPanel;
				break;
			}

			narTabSel = panel && panel.Grid.getFrstSelect();
		}

		factNarChild = factNarChild || rec && !!rec.get('LINK_SELF');

		if (factNarChild && rec) {
			var parent = !rec.get('LINK_SELF') ?
				rec :
				activeView.getRowByLink(activeGrid.store.getRootNode(), rec.get('LINK_SELF'));
			maxSumm = me.countSummForChild(parent);

			if (edit) {
				recSumm = rec.get('SUMMA');
				maxSumm = maxSumm + Ext.isNumber(recSumm) ? recSumm : parseFloat((recSumm + '').replace(regSpace, ''));
			}
		}

		if (tabKey === 'financ') {
			recSumm = copy ? rec.get('SUMMA') : narTabSel && narTabSel.get('SUMMACHECK');
			revizMoney = copy ? rec.get('REVIZMONEY') : 0;

			var pos = ArrayLib.find(ksData.financ.revizMoney, ['LINK'], revizMoney);
			if (pos !== -1 && copy) {
				maxSumm = ksData.financ.revizMoney[pos].SUMMA;
				maxSumm = maxSumm + Ext.isNumber(recSumm) ? recSumm : parseFloat((recSumm + '').replace(regSpace, ''));
			} else {
				maxSumm = recSumm;
			}
		}

		if (tabKey === 'contract') {
			recSumm = copy ? rec.get('SUMMA') : narTabSel && narTabSel.get('SUMMACHECK');
			revizContract = copy ? rec.get('REVIZCONTRACT') : 0;

			var pos = ArrayLib.find(ksData.contract.revizContract, ['LINK'], revizContract);
			if (pos !== -1 && copy) {
				maxSumm = ksData.contract.revizContract[pos].SUMMA;
				maxSumm = maxSumm + Ext.isNumber(recSumm) ? recSumm : parseFloat((recSumm + '').replace(regSpace, ''));
			} else {
				maxSumm = recSumm;
			}
		}

		Ext.create('Keysystems.FactNar.Edit', {
			title: 'Факт нарушения',
			isDis: isDis,
			readOnly: me.readOnly || me.ksReadOnly || (me.ksData.access.factnarGridAccess & ObjAccessMask.EDIT) === 0,
			labelWidth: me.labelWidth,
			f: token,
			factNarChild: factNarChild,
			maxSumm: maxSumm,
			tRevizObjects: {
				columns: ksData.tRevizObjectsColumns,
				fields: ksData.tRevizObjectsFields,
				data: ksData.tRevizObjects
			},
			linkCode: 'SFactNar',
			code: dnl.FACTNAR,
			revizLink: ksData.link,
			tRevizAudit: ksData.tRevizAudit,
			lockAudit: ArrayLib.filter(ksData.tRevizAudit, ['S_ORG'], ksControls.S_ORGP_Grid.lockOrg),
			sRprogLinks: me.getSRprogList(),
			progData: me.gksd('progData'),
			personData: me.gksd('sPerson'),
			sPersonLinks: me.gksd('sPersonsLinks'),
			progPerson: ksData.progPerson,
			content: ksData.factNarContent,
			recommendation: ksData.factNarRecommendation,
			DT: me.gksd('DT'),
			DTMONEY: me.gksd('DTMONEY'),
			isFinanc: me.isFinanc,
			sWork: me.gksd('sWork'),
			sAuthorityLinks: me.gksd('sAuthorityLinks'),
			data: rec,
			parentView: me.ownerCt,
			limitNpa: me.limitNpa,
			limitNpaOtv: me.limitNpaOtv,
			filterSNar: filterSNar = me.gksc('S_NAR').getLinks(),
			autoNumericMaskOrd2: ksData.autoNumericMaskOrd2,
			decimalData: me.gksd('decimalData'),
			loadNewData: function() {
				var th = this,
					ksData = me.ksData,
					sPersonC,
					revizObjs = [], // ArrayLib.filter(th.tRevizObjects.data, ['MAIN'], true),
					now = new Date(),
					tro = th.tRevizObjects.data,
					newExtra = ksData.factNarData.newExtra,
					access = newExtra.row._Access,
					generalTab = me.ownerCt.ksControls.General,
					objsPanel = generalTab.ksControls.objsPanel,
					dt = generalTab.ksControls.DT.getValue(),
					sNarVal =  me.gksc('S_NAR').getValue(),
					disLinks = me.gksd('disLinks');

				th.isDis = isDis;
				th.sksd('decimalData', me.gksd('decimalData'));
				if (isDis) {
					th.gksc('S_NAR').fieldLabel = 'Вид недостатка';
					th.gksc('S_NAR').setKsAllowEmpty(true);
				}
				th.sksd('disLinks', disLinks);
				th.setObjsValuesAndAccess(newExtra.row, access, th._arrGeneralRow);
				th.setObjsValuesAndAccess(newExtra.row, access, th._arrGeneralSingl);
				th.setObjsValuesAndAccess(newExtra.row, access, th._arrGeneralMulti);
				
				Ext.each(newExtra.tabProp?.data, d => {
					d.FACTNAR = me.rowFactNarLink;
				})
				th.getExtraProp(newExtra);
				th.getExtraVersion(newExtra);
				th.objs.DTDETECT.setValue(PeriodLib.getPeriodsCross(dt, { dh1: now, dh2: now }) ? now : dt.dh2);
				var isRepayment = tabKey === 'info';
				if (tabKey === 'financ') {
					var selFinRec = me.gksc('financPanel').Grid.getFrstSelect();
					isRepayment |= selFinRec && ArrayLib.find(me.gksd('financ').revizMoney, ['FINANC'], selFinRec.get('LINK')) !== -1;
				}
				th.objs.REPAYMENT.setValue(isRepayment);
				th.objs.SUMMA.decimalData = me.gksd('decimalData');
				
				if (sNarVal.length) {
					if (isDis) {
						sNarVal = sNarVal.filter(d => { return disLinks.indexOf(d.get('LINK')) !== -1; });
					} else {
						sNarVal = sNarVal.filter(d => { return disLinks.indexOf(d.get('LINK')) === -1; });
					}
					if (sNarVal.length) {
						th.gksc('S_NAR').setValue({
							data: {
								LINK: sNarVal[0].get('LINK'),
								CODE: sNarVal[0].get('CODE'),
								NAME: sNarVal[0].get('NAME')
							}
						});
					}
				}

				Ext.each(objsPanel.visibleObjs, function(type) {
					var t = ksData.RevizObjType[type],
						tmp = [];

					switch (type) {
					case 'ИП':
						tmp = ArrayLib.filter(ArrayLib.filter(tro, ['TYPE'], t), ['TTABLE'], 'S_PERSON');
						break;
					case 'ДЛ':
						var allObjs = ArrayLib.filter(tro, ['TYPE'], t);
						tmp = ArrayLib.filter(allObjs, ['TTABLE'], 'S_ORG');
						Ext.each(tmp, function(org) {
							var p = ArrayLib.find(allObjs, ['LINK_SELF'], org.LINK);
							if (p !== -1) {
								org.TEMP_SNAME = allObjs[p].TEMP_SNAME;
							}
						});
						break;
					case 'СП':
						tmp = ArrayLib.filter(tro, ['TTABLE'], 'S_OTDEL');
						break;
					default:
						tmp = ArrayLib.filter(tro, ['TYPE'], t);
					}

					revizObjs = tmp.concat(revizObjs);
				});

				revizObjs[0].TEMP_NAME = revizObjs[0].TEMP_NAME || revizObjs[0].TEMP_SNAME || revizObjs[0].TEMP_CODE;
				th.objs.T_REVIZ_OBJECTS.ksSetValue(revizObjs[0]);

				switch (miscTypes.RevizObjType[revizObjs[0].TYPE]) {
				case 'ИП':
					sPersonC = objsPanel.ИП_S_PERSON.getValue();
					break;
				case 'ФЛ':
					sPersonC = objsPanel.ФЛ_S_PERSON.getValue();
					break;
				case 'ДЛ':
					sPersonC = objsPanel.ДЛ_S_PERSON.getValue();
					break;
				default:
					sPersonC = [];
				}

				th.tRevizObjects.data = revizObjs;

				//подставляем ревизора в поле Выявил, если он в мероприятии один
				if (th.sPersonLinks.length === 1) {
					var personData = me.gksd('sPerson'),
						person = ArrayLib.filter(personData, ['S_PERSON'], th.sPersonLinks[0]);

					const fioParts = person[0].TEMP_SPERSON_FIO.split(' ');
					th.objs.S_PERSONP.setValue({
						data: {
							LINK: person[0].S_PERSON,
							LASTNAME: person[0].LASTNAME ?? fioParts.length > 0 ? fioParts[0] : '',
							FIRSTNAME: person[0].FIRSTNAME ?? fioParts.length > 1 ? fioParts[1] : '',
							PATRONYMIC: person[0].PATRONYMIC ?? fioParts.length > 2 ? fioParts[2] : '',
						}
					});
				}

				//подставляем сотрудника объекта (ФЛ, ДЛ, ИП) в поле Нарушил
				if (sPersonC && sPersonC.length) {
					th.objs.S_PERSONC.setValue({
						data: {
							LINK: sPersonC[0].data.LINK,
							CODE: sPersonC[0].data.CODE,
							LASTNAME: sPersonC[0].data.LASTNAME,
							FIRSTNAME: sPersonC[0].data.FIRSTNAME,
							PATRONYMIC: sPersonC[0].data.PATRONYMIC,
						}
					});
				}

				//Площадь нарушения и единица измерения
				if (access.FactNarAreaAccess) {
					th.gksc('FactNarArea').setVisible(true);
					th.objs.AREA.setValue(newExtra.row.AREA);
					th.objs.UNITCOMBO.setValue(newExtra.row.UNIT);
				}

				//th.objs.SUMMA.setValue(recSumm);
				if (narTabSel && (narTabSel.data.M === _ || narTabSel.get('M')) &&
					narTabSel.data.SUMMA && th.objs.SUMMA && access.SUMMA) {
					th.objs.SUMMA.setValue(narTabSel.data.SUMMA);
				}
				
				th.sksd('S_NPA_NAR', []);
				//вроде не используется
				//th.sksd('S_NPA_NAR_ARTICLE', []);
				th.sksd('articleNarListData', ksData.articleNarListData);
				th.sksd('articleListData', ksData.articleListData);
				th.sksd('extArticleListData', ksData.articleListData);
				
				//Полномочие
				if (me.gksd('AutoFillSAuthority') && ksData.tRevizSAuthority.length === 1){
					var authority = ksData.sAuthority.filter(r => {return r.LINK === ksData.tRevizSAuthority[0].S_AUTHORITY});
					if (authority.length) th.objs.S_AUTHORITY.setValue(authority[0]);
				}

				th.gksc('S_STATUS').setHidden(!ksData.visibleStatus);
				if (ksData.visibleStatus){
					th.sksd('readOnlyStatuses', newExtra.readOnlyStatuses);
					th.gksc('S_STATUS').store.loadData(CBDataLib.get(_, newExtra.status === 0, newExtra.sStatus), false);
					th.gksc('S_STATUS').setValue(newExtra.status);
				}
				
				th.setFilterNar(newExtra);
				//th.__loadNewData();
				th.callParent(arguments);
			},
			baseGetExtra: function(params, endFunc) {
				var th = this,
					factNarData = ksData.factNarData,
					factNarLink = params.link,
					pos = ArrayLib.find(me.ksData.factNar.data, ['LINK'], factNarLink, _, ['children']),
					rowFactNar,
					callBack = function() {
						if (th.factNarChild) {
							th.createChild();
							th.objs.SUMMA.setValue(me.countSummForChild(th.data));
						}
						if (th.isCopy()){
							th.gksc('S_STATUS').setValue(ksData.factNarData.newExtra.status);
						}
					},
					// После изменения замечаний обновляем поля FACTNAR
					setRowFactNar = function(val) {
						val.S_NAR.data = {
							LINK: rowFactNar.S_NAR,
							CODE: rowFactNar.TEMP_S_NAR_CODE,
							NAME: rowFactNar.TEMP_S_NAR_NAME
						}
						if (me.gksd('S_NPA_NAR')) val.S_NPA_NAR = me.gksd('S_NPA_NAR');
						if (me.gksd('S_NPA_OTV')) val.S_NPA_OTV = me.gksd('S_NPA_OTV');
						if (me.gksd('articleNarData')) val.articleNarListData = me.gksd('articleNarData');
						if (me.gksd('articleData')) val.articleListData = me.gksd('articleData');
						val.row.SUMMA = rowFactNar.SUMMA;

						//данные по проверенному финансированию обновим с локальных данных
						if (rowFactNar.REVIZMONEY) {
							let actualRevizMoney = me.gksd('financ').revizMoney,
								posRM = ArrayLib.find(actualRevizMoney, ['LINK'], rowFactNar.REVIZMONEY);
							val.revizMoney = posRM !== -1 ? [actualRevizMoney[posRM]] : [];
						} else {
							val.revizMoney = [];
						}

						if (rowFactNar.REVIZCONTRACT) {
							let actualRevizContract = me.gksd('contract').revizContract,
								posRM = ArrayLib.find(actualRevizContract, ['LINK'], rowFactNar.REVIZCONTRACT);
							val.revizContract = posRM !== -1 ? [actualRevizContract[posRM]] : [];
						} else {
							val.revizContract = [];
						}
					};

				if (Ext.isArray(pos)) {
					var parentRec = me.ksData.factNar.data[pos[0]];
					rowFactNar = parentRec.children[pos[1]];
				} else {
					rowFactNar = me.ksData.factNar.data[pos];
				}

				if (factNarData.extra[factNarLink]) {
					let data = factNarData.extra[factNarLink];
					data.lockAudit = ArrayLib.filter(ksData.tRevizAudit, ['S_ORG'], ksControls.S_ORGP_Grid.lockOrg);
					data.sRprogLinks = me.getSRprogList();
					data.progData = me.gksd('progData');
					data.personData = me.gksd('sPerson');
					data.sPersonLinks = me.gksd('sPersonsLinks');
					data.progPerson = ksData.progPerson;
					setRowFactNar(factNarData.extra[factNarLink]);
					th.sksd('STAMP', data.row.STAMP);
					endFunc(factNarData.extra[factNarLink]);
					callBack();
				} else {
					th.callParent([
						params, function (value) {
							var recalcProps = me.gksd('recalcProps');
							if (recalcProps && value.tabProp) {
								Ext.each(value.tabProp.data, d => {
									if (recalcProps[d.FACTNAR]) {
										var calcVal = recalcProps[d.FACTNAR][d.LINK];
										if (calcVal) {
											d.VAL = calcVal;
										}
									}
								});
							}
							setRowFactNar(value);
							factNarData.extra[value.row.LINK] = value;
							me.appendOldFactnarData(value.row.LINK, value);
							if (th.isCopy()) me.rowFactNarLink = value.row.LINK;
							endFunc(value);
							callBack();
						}
					]);
				}
			},
			getRowByLink: function(node, link) {
				var th = this;
				if (node.data[th.fieldLink] == link) {
					return node;
				} else {
					if ((node.childNodes) && (node.childNodes.length)) {
						var res;
						Ext.each(node.childNodes, function(child) {
							res = th.getRowByLink(child, link);
							if (res) {
								return false;
							}
						});
						return res;
					} else {
						return null;
					}
				}
			},
			appendParent: function(rec) {
				var th = this,
					grid = me.gksc(th.isDis ? 'disGrid' : 'factNarGrid'),
					rootNode = grid.store.getRootNode(),
					parent = th.getRowByLink(rootNode, rec.get('LINK_SELF'));

				if (parent) {
					parent.appendChild(rec);
					parent.set('leaf', false);
					parent.expand();
				} else {
					rootNode.appendChild(rec);
				}
			},
			addRecord: function(row) {
				row.leaf = true;
				var th = this,
					grid = me.gksc(th.isDis ? 'disGrid' : 'factNarGrid'),
					rootNode = grid.store.getRootNode(),
					rec = rootNode.createNode(row);

				th.appendParent(rec);
				if (grid.store.getTreeFilters().length) {
					grid.store.filter();
				}
				return rec;
			},
			baseSaveData: function(params, endFunc) {
				if (params.checkSaveOnly){
					this.callParent(arguments);
					return;
				}
				var th = this,
					fn = ksData.factNarData,
					os = th.objs,
					link = os.link || me.rowFactNarLink--,
					res = { result: true, SavedLink: link },
					activeGrid = me.gksc(th.isDis ? 'disGrid' : 'factNarGrid'),
					store = activeGrid.store,
					okps,
					tFactNarRevizDoc,
					isNew,
					recalcProps = me.gksd('recalcProps');

				//Создаем привязку к выделенной записи
				switch (tabKey) {
					case 'financ':
						var sel = me.gksc('financPanel').Grid.getFrstSelect();
						if (!copy && !edit || (copy && rec.get('REVIZMONEY'))) {
							params.REVIZMONEY = revizMoney || (sel && sel.data && sel.data.REVIZMONEY);
						}
						break;
					case 'contract':
						var sel = me.gksc('contractPanel').Grid.getFrstSelect();
						if (!copy && !edit || (copy && rec.get('REVIZCONTRACT'))) {
							params.REVIZCONTRACT = revizContract || (sel && sel.data && sel.data.REVIZCONTRACT);
						}
						break;
					case 'info':
						var sel = me.gksc('infoPanel').Grid.getFrstSelect();
						if (!copy && !edit || (copy && rec.get('INFO'))) {
							params.INFO = rec ? rec.get('INFO') : sel && sel.data ? sel.data.LINK : _;
						}
						break;
					case 'okp':
						if (copy && me.gksd('okpFactNarData')) {
							okps = ArrayLib.filter(me.gksd('okpFactNarData'), ['FACTNAR'], rec.get('LINK'));
							Ext.each(okps, function (okp) {
								me.okpBindHandler(activeGrid, link, okp.REVIZOKP, true);
							});
						} else if (!edit && narTabSel) {
							me.okpBindHandler(activeGrid, link, narTabSel.get('LINK'), true);
						}

						break;
					case 'rdoc':
						if (copy && me.gksc('rDocPanel')) {
							tFactNarRevizDoc = ArrayLib.filter(me.gksd('tFactNarRevizDoc'), ['FACTNAR'], rec.get('LINK'));
							Ext.each(tFactNarRevizDoc, function (rdoc) {
								me.rDocBindHandler(activeGrid, link, rdoc.REVIZDOC, true);
							});
						} else if (!edit && narTabSel) {
							me.rDocBindHandler(activeGrid, link, narTabSel.get('LINK'), true);
						}

						break;
					default:
				}

				fn.save[link] = JSON.stringify(params);

				const nextFn = function() {

					if (!fn.extra[link]) {
						isNew = true;
						fn.extra[link] = {};
					}

					var extra = fn.extra[link];

					extra.isDis = th.isDis;
					if (th.isDis) {
						extra.disLinks = me.gksd('disLinks');
					}
					extra.decimalData = me.gksd('decimalData');
					extra.IGNORE_ACT = os.IGNORE_ACT.getValue();
					extra.ORD = os.ORD.getValue();
					extra.ORD2 = os.ORD2.getValue();
					extra.revizObj = th.tRevizObjects;

					extra.ACT_NUMBER = os.ACT_NUMBER.getValue();
					extra.ACT_PAGE = os.ACT_PAGE.getValue();

					var sNar = os.S_NAR.getValue();
					if (sNar.length) {
						sNar = sNar[0].data ||  sNar[0];
					}
					extra.S_NAR = sNar;
					
					extra.S_NARC = os.S_NARC.getValue();
					extra.S_NARP = os.S_NARP.getValue();
					extra.S_NPA_NAR = os.S_NPA_NAR.getValue();
					extra.S_NPA_OTV = os.S_NPA_OTV.getValue();
					extra.S_NPA_EXT = os.S_NPA_EXT.getValue();
					
					extra.status = th.gksc('S_STATUS').getValue();
					extra.visibleStatus = ksData.visibleStatus;
					extra.readOnlyStatuses = th.ksData.readOnlyStatuses;
					extra.sStatus = th.ksData.sStatus;

					// необходимо при создании подобного нарушения
					extra.articleNarListData = params.articleNarListData;
					extra.articleListData = params.articleListData;
					extra.extArticleListData = params.extArticleListData;

					var sPc = os.S_PERSONC.getValue();
					if (sPc.length) {
						sPc = sPc[0].data || sPc[0];
					}
					extra.S_PERSONC = sPc;

					var sPp = os.S_PERSONP.getValue();
					if (sPp.length) {
						sPp = sPp[0].data || sPp[0];
					}
					extra.S_PERSONP = sPp;
					extra.sPerson = th.personData;

					var sRp = os.S_RPROG.getValue();
					if (sRp.length) {
						sRp = sRp[0].data || sRp[0];
					}
					extra.S_RPROG = sRp;

					var sAt = os.S_AUTHORITY.getValue();
					if (sAt.length) {
						sAt = sAt[0].data || sAt[0];
					}
					extra.S_AUTHORITY = sAt;

					extra.T_REVIZ_AUDIT = params.T_REVIZ_AUDIT;
					extra.T_REVIZ_OBJECT = ArrayLib.filter(ksData.tRevizObjects, ['LINK'], params.T_REVIZ_OBJECTS);

					var rowArr = [
						'CONTENT', 'DTNAR', 'DTDETECT', 'ORD', 'ORD2', 'REPAYMENT', 'S_VAL', 'SUMMA', 'SUMMAVAL',
						'T_REVIZ_AUDIT', 'TEMP_CODE', 'TEMP_NAME', 'TEMP_SNAME',
						'S_NAR', 'TEMP_S_NAR_CODE', 'TEMP_S_NAR_NAME',
						'S_PERSONP', 'TEMP_S_PERSONP_CODE', 'TEMP_S_PERSONP_NAME',
						'S_RPROG', 'TEMP_S_RPROG_CODE', 'TEMP_S_RPROG_NAME',
						'S_PERSONC', 'TEMP_S_PERSONC_CODE', 'TEMP_S_PERSONC_NAME',
						'UNIT', 'AREA',
						'RECOMMENDATION', 'REVIZMONEY', 'INFO', 'ACT_NUMBER', 'ACT_PAGE',
						'S_AUTHORITY', 'TEMP_S_AUTHORITY_CODE', 'TEMP_S_AUTHORITY_NAME', 'TEMP_S_NPA_NAME', 'TEMP_S_NPA_OTV_NAME',
						'S_STATUS', 'TEMP_S_STATUS_NAME'
					];

					if (!extra.row) extra.row = {};

					ArrayLib.copyByKeys(rowArr, params, extra.row);
					extra.row.SUMMA = strToNum(params.SUMMA);
					extra.row.SUMMAVAL = strToNum(params.SUMMAVAL);
					

					if (sNar) {
						extra.row.TEMP_S_NAR_CODE = sNar.CODE;
						extra.row.TEMP_S_NAR_NAME = sNar.NAME;
					}

					if (sPp) {
						extra.row.TEMP_S_PERSONP_CODE = sPp.CODE;
						extra.row.TEMP_S_PERSONP_NAME = sPp.NAME;
					}

					if (sRp) {
						extra.row.TEMP_S_RPROG_CODE = sRp.CODE;
						extra.row.TEMP_S_RPROG_NAME = sRp.NAME;
					}

					if (sPc) {
						extra.row.TEMP_S_PERSONC_CODE = sPc.CODE;
						extra.row.TEMP_S_PERSONC_NAME = sPc.NAME;
					}

					if (sAt) {
						extra.row.TEMP_S_AUTHORITY_CODE = sAt.CODE;
						extra.row.TEMP_S_AUTHORITY_NAME = sAt.NAME;
					}

					extra.npaArticle = JSON.parse(params.npaArticle);
					extra.npaArticleOtv = JSON.parse(params.npaArticleOtv);
					extra.npaArticleExt = JSON.parse(params.npaArticleExt);

					//функция построит наименование отобранных НПА с указанием отобранных статей, с учетом заданных ссылок REF
					//ссылки будут обернуты в <a href="REF">имя<a> 
					const funcBuildNpaName = function(npaValue, npaArticleValue ){
						return npaValue.sort((r1, r2) => {
							r1 = r1.data || r1;
							r2 = r2.data || r2;

							let name1 = r1.SNAME || r1.NAME;
							let name2 = r2.SNAME || r2.NAME;
							return (name1 > name2) ? 1 : ((name2 > name1) ? -1 : 0);
						}).map(r => {
							r = r.data || r;
							const articles = npaArticleValue.filter(ra => ra.S_NPA === r.LINK)[0]?.S_ARTICLE ?? [];
							let name = '';
							if (Array.isArray(articles) && articles.length) {
								name = articles.sort((a1, a2) => {
									return (a1.CODE > a2.CODE) ? 1 : ((a2.CODE > a1.CODE) ? -1 : 0)
								}).map(a => {
									return a.REF ? '<a href="' + a.REF + '">' + a.CODE + '</a>' : a.CODE;
								}).join(', ');
								if (name) name += ' ';
							}
							name += r.SNAME || r.NAME;
							return r.REF ? '<a href="' + r.REF + '">' + name + '</a>' : name;
						}).join('; ');
					}
					if (extra.S_NPA_NAR.length) {
						extra.row.TEMP_S_NPA_NAME = funcBuildNpaName(extra.S_NPA_NAR, extra.npaArticle);						
					}

					if (extra.S_NPA_OTV.length) {
						extra.row.TEMP_S_NPA_OTV_NAME = funcBuildNpaName(extra.S_NPA_OTV, extra.npaArticleOtv);						
					}

					extra.row.DTNAR = os.DTNAR.getValue();
					extra.row.DTDETECT = os.DTDETECT.getValue();
					extra.row.IGNORE_ACT = extra.IGNORE_ACT;
					extra.row.LINK = link;

					if (fn.newExtra.tabProp) {
						if (!extra.tabProp) {
							extra.tabProp = JSON.parse(JSON.stringify(fn.newExtra.tabProp));
						}
						extra.tabProp.data = os.tabProp.store.getDataExt();
						if (isNew) {
							Ext.each(extra.tabProp.data, p => {
								p.FACTNAR = link;
							});
						}
						// при сохранении удаляем те данные, которые теперь хранятся в tabProp
						if (recalcProps) {
							Ext.each(extra.tabProp.data, d => {
								if (recalcProps[d.FACTNAR]) {
									delete recalcProps[d.FACTNAR][d.LINK];
									if (!Object.keys(recalcProps[d.FACTNAR]).length) {
										delete recalcProps[d.FACTNAR];
									}
								}
							});
						}
					}

					extra.row._Access = fn.newExtra.row._Access;
					extra.DT = me.gksd('DT');
					extra.DTMONEY = me.gksd('DTMONEY');
					extra.UNIT = params.UNIT;
					extra.AREA = params.AREA;
					extra.filterNar = th.gksd('filterNar');
					extra.limitNpa = params.limitNpa;
					extra.limitNpaOtv = params.limitNpaOtv;

					extra.FACTNARNPA = params.FACTNARNPA;
					extra.NARNPA_ARTICLE = params.NARNPA_ARTICLE;

					if (th.gksc('S_STATUS').getValue()){
						extra.row.TEMP_S_STATUS_NAME = th.gksc('S_STATUS').getRawValue();
					}

					if (isNew || th.isCopy()) {
						extra.row.leaf = true;
						fn.links.push(link);
						extra.row.LINK_SELF = th.factNarChild && th.data ? th.data.get('LINK') : 0;
						me.rowFactNarOkNew(extra.S_NPA_NAR, store.getRootNode().createNode(extra.row), extra);
					} else {
						var oldRecordFactnar = ksData.factNar.data.filter(d => d.LINK === extra.row.LINK);
						extra.row.REVIZMONEY = oldRecordFactnar.length > 0 ? oldRecordFactnar[0].REVIZMONEY : extra.row.REVIZMONEY;
						for (var i = 0, len = rowArr.length; i < len; i++) {
							th.data.set(rowArr[i], extra.row[rowArr[i]]);
						}
						me.rowFactNarOkEdit(extra.S_NPA_NAR, th.data, extra);
					}

					fn.extra[link] = extra;
					res.row = extra.row;
					th.successSaveFunc(res, function () {
						activeGrid.fireEvent('select', th, activeGrid.getSelectionModel().getSelection()[0]);

						var newData = activeGrid.store.getDataExt(),
							oldData = ksData.factNar.data;
						for (var i = 0; i < newData.length; i++) {
							var recs = oldData.filter(d => {
								return d.LINK === newData[i].LINK;
							});
							if (recs.length) {
								oldData[oldData.indexOf(recs[0])] = newData[i];
							} else {
								oldData.push(newData[i]);
							}
						}
					});
				}
				
				me.ksData.dataChangeStatus[link] = params.dataChangeStatus;

				const paramsCheck = {};
				Object.assign(paramsCheck, params);
				if (paramsCheck.link < 0) paramsCheck.link = 0;
				paramsCheck.checkSaveOptions = 1 | 4 | 8;
				paramsCheck.checkSaveOnly = true;
				paramsCheck.isVfa = me.isVfa;
				th.baseSaveData(paramsCheck, (result) => {
					if (result.State === 0) {
						nextFn();
					}
					else {
						th.parseCheckSaveResult(result, nextFn);	
					}
				});
			}
		});
	},
	rowFactNarOkEdit: function(sNpa, rec, extra) {
		var me = this,
			ksData = me.ksData,
			factNarLink = rec.get('LINK'),
			oldNpa = ArrayLib.filter(ksData.factNarNpa, ['FACTNAR'], factNarLink),
			i = 0,
			len = oldNpa.length,
			iPos = ArrayLib.find(ksData.tFactNarObjects, ['FACTNAR'], factNarLink),
			tro = extra.T_REVIZ_OBJECT.length > 0 ? extra.T_REVIZ_OBJECT : ksData.tRevizObjects;

		if (iPos === -1) iPos = 0;

		ksData.tFactNarObjects[iPos].T_REVIZ_OBJECTS = tro[0].LINK;

		for (; i < len; i++) {
			iPos = ArrayLib.find(sNpa, ['data', 'LINK'], oldNpa.S_NPA);
			if (iPos === -1) {
				iPos = Ext.Array.indexOf(ksData.factNarNpa, oldNpa[i]);
				ksData.factNarNpa.splice(iPos, 1);
			} else {
				sNpa.splice(iPos, 1);
			}
		}

		for (i = 0, len = sNpa.length; i < len; i++) {
			var npaLink = sNpa[i].LINK || sNpa[i].data.LINK,
				lstFind = ArrayLib.filter(extra.npaArticle, ['S_NPA'], npaLink),
				sArticle = lstFind.length ? lstFind[0].S_ARTICLE.map(r => r.LINK) : [];
			ksData.factNarNpa.push({
				FACTNAR: factNarLink,
				LINK: me.factNarNpaLink--,
				S_NPA: npaLink,
				S_ARTICLE: sArticle
			});
		}

		// НПА(ответств.)
		ksData.factNarNpaOtv = ksData.factNarNpaOtv.filter(function(i) { return i.FACTNAR !== factNarLink; });
		Ext.each(extra.S_NPA_OTV,
			function (npa) {
				npa = npa.data || npa;
				var npaLink = npa.LINK,
					lstFind = ArrayLib.filter(extra.npaArticleOtv, ['S_NPA'], npaLink),
					article = lstFind.length ? lstFind[0].S_ARTICLE.map(r => r.LINK) : [];

				ksData.factNarNpaOtv.push({
					LINK: me.factNarNpaOtvLink--,
					FACTNAR: factNarLink,
					S_NPA: npaLink,
					S_ARTICLE: article
				});
			});

		// НПА(доп.)
		ksData.factNarNpaExt = ksData.factNarNpaExt.filter(function(i) { return i.FACTNAR !== factNarLink; });
		Ext.each(extra.S_NPA_EXT,
			function (npa) {
				npa = npa.data || npa;
				var npaLink = npa.LINK,
					lstFind = ArrayLib.filter(extra.npaArticleExt, ['S_NPA'], npaLink),
					article = lstFind.length ? lstFind[0].S_ARTICLE : [];

				ksData.factNarNpaExt.push({
					LINK: me.factNarNpaExtLink--,
					FACTNAR: factNarLink,
					S_NPA: npaLink,
					S_ARTICLE: article
				});
			});

		//rec.set(result);
	},
	rowFactNarOkNew: function(sNpa, rec, extra) {
		var me = this,
			ksData = me.ksData;

		if (sNpa) {
			for (var i = 0, len = sNpa.length; i < len; i++) {
				var npaLink = sNpa[i].LINK || sNpa[i].data.LINK;
				var find = ArrayLib.filter(extra.npaArticle, ['S_NPA'], npaLink);
				var sArticle = find.length ? find[0].S_ARTICLE.map(r => r.LINK) : '[]';
				ksData.factNarNpa.push({
					FACTNAR: rec.get('LINK'),
					LINK: me.factNarNpaLink--,
					S_NPA: npaLink,
					S_ARTICLE: sArticle
				});
			}
		}

		var allTro = ksData.tRevizObjects,
			pos = ArrayLib.find(allTro, ['TEMP_CODE'], rec.get('TEMP_CODE'));

		if (pos === -1) {
			pos = ArrayLib.find(allTro, ['TEMP_NAME'], rec.get('TEMP_NAME'));
		}

		ksData.tFactNarObjects.push({
			LINK: me.tFactNarObjectsLink--,
			FACTNAR: rec.get('LINK'),
			T_REVIZ_OBJECTS: allTro[pos].LINK
		});

		// НПА(ответств.)
		Ext.each(extra.npaArticleOtv,
			function(npa) {
				ksData.factNarNpaOtv.push({
					LINK: me.factNarNpaOtvLink--,
					FACTNAR: rec.get('LINK'),
					S_NPA: npa.S_NPA,
					S_ARTICLE: npa.S_ARTICLE.map(r => r.LINK)
				});
			});

		// НПА(доп.)
		Ext.each(extra.npaArticleExt,
			function(npa) {
				ksData.factNarNpaExt.push({
					LINK: me.factNarNpaExtLink--,
					FACTNAR: rec.get('LINK'),
					S_NPA: npa.S_NPA,
					S_ARTICLE: npa.S_ARTICLE
				});
			});
	},
	batchChangeStatus: function(value, isDis)
	{
		if (!value) return;

		let me = this,
			activeGrid = me.gksc(isDis ? 'disGrid' : 'factNarGrid')
			links = activeGrid.store.getDataExt().filter(r => r.M).map(r => r.LINK);
		if (!links.length) return;
		
		var factNar = me.dataCollector().factNar;

		Ext.create('Keysystems.Comment',
			{
				title: 'Изменение статуса',
				labelText: 'Комментарий',
				initText: '',
				okFn: function () {
					var comment = this.textArea.getValue();
					me.showLoadMask({
						msg: wmc.getMask('StatusBatchChange'),
						rid: ajaxRequest({
							url: 'SFactNar/StatusBatchChange_A',
							params: {
								reviz: me.ksData.link,
								statuses: value,
								links: JSON.stringify(links),
								comment: comment,
								factNar: factNar
							},
							success: function (res) {
								me.hideLoadMask();
								if (res) {
									if (res.error) {
										showError(res.error);
									} else {
										var fn = function(rec) {
											var info = res.changeStatus[rec.get('LINK')];
											if (info){
												rec.set('S_STATUS', info.NewStatus);
												rec.set('TEMP_S_STATUS_NAME', me.ksData.subStatuses[info.NewStatus]);
											}
										};

										activeGrid.store.each(fn);
										
										for (var ch in res.changeStatus){
											me.ksData.dataChangeStatus[ch] = res.changeStatus[ch];
										}
																				
										ChooseBox.ShowHTML({
											text: res.text,
											hasIgnoreButton: false,
											info: true
										});
									}
								}
							},
							failure: function (){ me.hideLoadMask(); }
						})
					});
				}
			}).show();

	},
	
	/** дополнить исходные данные данными факта нарушения по реквизитам */
	appendOldFactnarData: function(factNarLink, value) {
		const me = this;
		if (!value?.tabProp?.data) return;
		
		const oldData = Ext.JSON.decode(me.oldData, true);  
		if (!oldData?.factNar) return;

		const oldFactnarData = Ext.JSON.decode(oldData.factNar, true);
		if (!oldFactnarData) return;

		let oldFactnarCur = oldFactnarData.filter(f => f.link === factNarLink)[0];
		if (!oldFactnarCur) return;
				
		oldFactnarCur.tabProp = value.tabProp.data;
		oldData.factNar = JSON.stringify(oldFactnarData);
		me.oldData = JSON.stringify(oldData);
	},
	//#endregion Грид нарушений

	getSRprogList: function() {
		var me = this,
			srp = me.gksd('progData'),
			sRprogList = [];

		Ext.each(srp, function(prog) {
			sRprogList.push(prog.S_RPROG);
		});

		return sRprogList;
	},

	//Подсчет возможной суммы для дочернего нарушения
	countSummForChild: function(parentRec) {
		var summ = parentRec.get('SUMMA') || 0,
			childSumm = 0;

		Ext.each(parentRec.childNodes, function(child) {
			var tmpSumm = child.get('SUMMA');
			tmpSumm = Ext.isNumber() ? tmpSumm : parseFloat((tmpSumm + '').replace(regSpace, ''));
			childSumm += tmpSumm;
		});

		summ = Ext.isNumber(summ) ? summ : parseFloat((summ + '').replace(regSpace, ''));
		childSumm = Ext.isNumber(childSumm) ? childSumm : parseFloat((childSumm + '').replace(regSpace, ''));

		return summ - childSumm;
	},

	factNarUpdFn: function(tRevizAudit) {
		var me = this,
			ksControls = me.ksControls,
			ksData = me.ksData,
			list = ArrayLib.filter(tRevizAudit, ['S_ORG'], ksControls.S_ORGP_Grid.lockOrg),
			factNarGrid = me.gksc('factNarGrid'),
			disGrid = me.gksc('disGrid');

		if (!list.length) return;
		var object = ArrayLib.find(ksData.tRevizObjects, ['LINK'], list[0].T_REVIZ_OBJECTS);
		if (object !== -1) {
			object = ksData.tRevizObjects[object];
			list[0].TEMP_CODE = object.TEMP_CODE;
			list[0].TEMP_NAME = object.TEMP_NAME;
			list[0].TEMP_SNAME = object.TEMP_SNAME;
		}

		var fn = function(rec) {
			var trso = rec.get('T_REVIZ_AUDIT'),
				pos = ArrayLib.find(tRevizAudit, ['LINK'], trso);
			if (pos === -1) {
				rec.set('T_REVIZ_AUDIT', list[0].LINK);
				rec.set('TEMP_CODE', list[0].TEMP_CODE);
				rec.set('TEMP_NAME', list[0].TEMP_NAME);
				rec.set('TEMP_SNAME', list[0].TEMP_SNAME);

				rec.set('S_PERSONC', 0);
				rec.set('S_PERSONC_CODE', '');
				rec.set('S_PERSONC_NAME', '');
			} else {
				if (ArrayLib.find(list, ['LINK'], trso) === -1) {
					trso = ArrayLib.filter(list, ['T_REVIZ_OBJECTS'], tRevizAudit[pos].T_REVIZ_OBJECTS);
					if (trso.length) {
						rec.set('T_REVIZ_AUDIT', trso[0].LINK);
					}
				}
			}
		};
		
		if (factNarGrid) {
			factNarGrid.store.each(fn);
		}
		if (disGrid) {
			disGrid.store.each(fn);
		}
	},

	//#region Привязка нарушений к остальным записям

	//проверенная продукция
	okpBindHandler: function(grid, factNarLink, okpLink, ignoreMsg) {
		var me = this,
			refreshFunc = function() {
				me.sksd('okpFactNarData', ArrayLib.filter(me.gksd('tFactNarRevizOkp'), ['FACTNAR'], factNarLink));
				grid.factNarData = ArrayLib.filter(me.gksd('tFactNarRevizOkp'), ['REVIZOKP'], okpLink);
				grid.view.refresh();
				me.gksc('okpPanel').Grid.view.refresh();
			};

		if (me.readOnly || grid.ownerCt?.dict?.readOnly) return _;
		
		if (okpLink) {
			if (ignoreMsg) {
				me.gksd('tFactNarRevizOkp').push({
					LINK: me.tFactNarRevizOkpLink--,
					FACTNAR: factNarLink,
					REVIZOKP: okpLink
				});
				refreshFunc();
			} else {
				var iPos,
					tmpData = ArrayLib.filter(me.gksd('tFactNarRevizOkp'), ['FACTNAR'], factNarLink),
					pos = ArrayLib.find(tmpData, ['REVIZOKP'], okpLink);

				pos === -1 ?
					selectDialogShow(me.resource.RevizEditView_QuestionAttachFactNarTo_Перенос, me.getBindMsg(true, grid), function () {
						me.gksd('tFactNarRevizOkp').push({
							LINK: me.tFactNarRevizOkpLink--,
							FACTNAR: factNarLink,
							REVIZOKP: okpLink
						});
						refreshFunc();
					}) :
					selectDialogShow(me.resource.RevizEditView_QuestionAttachFactNarTo_Перенос, me.getBindMsg(false, grid), function() {
						iPos = Ext.Array.indexOf(me.gksd('tFactNarRevizOkp'), tmpData[pos]);
						me.ksData.tFactNarRevizOkp.splice(iPos, 1);
						refreshFunc();
					});
			}
		}
	},

	//проверенные документы
	rDocBindHandler: function(grid, factNarLink, rDocLink, ignoreMsg, isDocGrid) {
		var me = this,
			rDocPanel = me.gksc('rDocPanel'),
			checked = !!rDocLink,
			docSel = rDocPanel.Grid.store.getRecord(rDocLink),
			refreshFunc = function(checked, pas) {
				if (grid.selModel.getSelection()[0].get('LINK') === factNarLink) {
					rDocPanel.factNarData = ArrayLib.filter(me.gksd('tFactNarRevizDoc'), ['FACTNAR'], factNarLink);
					if (!pas) {
						docSel && docSel.set('M', checked);
					}
				}
				grid.factNarData = ArrayLib.filter(me.gksd('tFactNarRevizDoc'), ['REVIZDOC'], rDocLink);
				rDocPanel.Grid.view.refresh();
				grid.view.refresh();
			};

		if (me.readOnly || grid.ownerCt?.dict?.readOnly) return _;

		docSel = docSel || rDocPanel.Grid.getFrstSelect();
		rDocLink = rDocLink || docSel && docSel.get('LINK');

		var tmpData = ArrayLib.filter(me.gksd('tFactNarRevizDoc'), ['FACTNAR'], factNarLink),
			pos = ArrayLib.find(tmpData, ['REVIZDOC'], rDocLink);

		if (ignoreMsg) {
			me.gksd('tFactNarRevizDoc').push({
				LINK: me.tFactNarRevizDocLink--,
				FACTNAR: factNarLink,
				REVIZDOC: rDocLink
			});
			refreshFunc(pos === -1, checked);
		} else {
			pos === -1 ?
				selectDialogShow(me.resource.RevizEditView_QuestionAttachFactNarTo_Перенос, me.getBindMsg(true, grid, isDocGrid), function() {
					me.gksd('tFactNarRevizDoc').push({
						LINK: me.tFactNarRevizDocLink--,
						FACTNAR: factNarLink,
						REVIZDOC: rDocLink
					});
					refreshFunc(pos === -1, checked);
				}, function() {
					docSel.set('M', false);
				})
				:
				selectDialogShow(me.resource.RevizEditView_QuestionAttachFactNarTo_Перенос, me.getBindMsg(false, grid, isDocGrid), function() {
					me.ksData.tFactNarRevizDoc.splice(ArrayLib.find(me.gksd('tFactNarRevizDoc'), ['LINK'], tmpData[pos].LINK), 1);
					refreshFunc(pos === -1, checked);
				}, function() {
					docSel.set('M', true);
				});
		}
	},
	
	//финансирование
	financBindHandler: function(grid, rec) {
		var me = this,
			financPanel = me.gksc('financPanel'),
			financGrid = financPanel.Grid,
			financData = financGrid.store.getDataExt(),
			fRec = financGrid.getFrstSelect(),
			allRevizMoney = me.gksd('financ').revizMoney,
			okFunc = function (fRec) {
				var pos = ArrayLib.find(me.gksd('tRevizAudit'), ['LINK'], rec.get('T_REVIZ_AUDIT'));
				let tro2 = pos !== -1 ? ArrayLib.filter(me.gksd('tRevizObjects'), ['LINK'], me.gksd('tRevizAudit')[pos].T_REVIZ_OBJECTS)[0] : null; 
				
				if (tro2) {
					var trao = ArrayLib.filter(me.gksd('tRevizAudit'), ['T_REVIZ_OBJECTS'], tro2.LINK)[0];

					if (!fRec.get('REVIZMONEY')) {
						pos = ArrayLib.find(allRevizMoney, ['FINANC'], fRec.get('LINK'));
						fRec.set('REVIZMONEY', pos === -1 ? --me.revizMoneyLink : allRevizMoney[pos].LINK);
					}

					var revizMoney = fRec.get('REVIZMONEY');

					rec.set('T_REVIZ_AUDIT', trao.LINK);
					rec.set('TEMP_CODE', tro2.TEMP_CODE);
					rec.set('TEMP_NAME', tro2.TEMP_NAME);
					rec.set('TEMP_SNAME', tro2.TEMP_SNAME);
					rec.set('REVIZMONEY', revizMoney);
					me.ksData.factNar.data = grid.store.getDataExt();

					grid.revizMoney = revizMoney;

					var currentFinanc = financData[ArrayLib.find(financData, ['LINK'], fRec.get('LINK'))];

					currentFinanc.REVIZMONEY = revizMoney;
					financPanel.factNarRObject = tro2;

					let factnarData = me.gksd('factNarData'),
						rowFactnar = factnarData ? factnarData.extra[rec.get('LINK')] : null;
					if (rowFactnar) rowFactnar["revizMoney"] = [{
						LINK: revizMoney,
						FINANC: currentFinanc.LINK,
						S_VBUDJ_FINANC: currentFinanc.S_VBUDJ
					}];
				}
			},
			callBack = function() {
				var refreshFunc = function() {
					financPanel.factNarRevizMoney = rec.get('REVIZMONEY');
					grid.view.refresh();
					financGrid.view.refresh();
				};

				if (rec.get('REVIZMONEY')) {
					selectDialogShow(me.resource.RevizEditView_QuestionAttachFactNarTo_Перенос, me.getBindMsg(false, grid), function() {
						rec.set('REVIZMONEY', 0);
						me.ksData.factNar.data = grid.store.getDataExt();
						let factnarData = me.gksd('factNarData'),
							rowFactnar = factnarData ? factnarData.extra[rec.get('LINK')] : null;
						if (rowFactnar) rowFactnar["revizMoney"] = null;
						refreshFunc();
					}, Ext.emptyFn);
				} else {
					if (!fRec || !fRec.get('M')) return;
					selectDialogShow(me.resource.RevizEditView_QuestionAttachFactNarTo_Перенос, me.getBindMsg(true, grid), function() {
						okFunc(fRec);
						refreshFunc();
					}, Ext.emptyFn);
				}
			},
			vbudjLinks = me.gksc('S_VBUDJ').getLinks();

		if (me.readOnly || grid.ownerCt?.dict?.readOnly) return _;

		if (vbudjLinks.length && vbudjLinks.indexOf(fRec.get('S_VBUDJ')) === -1) return _;
		
		var flag = true,
			tro;

		//Если объект финансирования и объект нарушения разные то нельзя привязать
		if (fRec && !rec.get('REVIZMONEY') && rec.get('T_REVIZ_AUDIT')) {
			var pos = ArrayLib.find(me.gksd('tRevizAudit'), ['LINK'], rec.get('T_REVIZ_AUDIT'));
			if (pos !== -1) {
				tro = ArrayLib.filter(me.gksd('tRevizObjects'), ['LINK'], me.gksd('tRevizAudit')[pos].T_REVIZ_OBJECTS)[0];
				flag = (tro.TTABLE === 'S_ORG' && tro.TLINK === fRec.get('SORGC')) ||
					(tro.TTABLE === 'S_NPA' && tro.TLINK === fRec.get('S_NPA'));
			}
		}

		if (flag) {
			callBack();
		} else {
			warning(grid === me.gksc('disGrid')
				? me.resource.RevizEditView_FactNarClickCellButton_Объект_в_проверенном_финансировании_не_совпадает_с_объектом_в_недостатке_
				: me.resource.RevizEditView_FactNarClickCellButton_Объект_в_проверенном_финансировании_не_совпадает_с_объектом_в_факте_нарушения_);
		}
	},

	//контракты
	contractBindHandler: function(grid, rec) {
		var me = this,
			contractPanel = me.gksc('contractPanel'),
			contractGrid = contractPanel.Grid,
			contractData = contractGrid.store.getDataExt(),
			cRec = contractGrid.getFrstSelect(),
			allRevizContract = me.gksd('contract').revizContract,
			okFunc = function (cRec) {
				var pos = ArrayLib.find(me.gksd('tRevizAudit'), ['LINK'], rec.get('T_REVIZ_AUDIT'));
				let tro2 = pos !== -1 ? ArrayLib.filter(me.gksd('tRevizObjects'), ['LINK'], me.gksd('tRevizAudit')[pos].T_REVIZ_OBJECTS)[0] : null;

				if (tro2) {
					var trao = ArrayLib.filter(me.gksd('tRevizAudit'), ['T_REVIZ_OBJECTS'], tro2.LINK)[0];

					if (!cRec.get('REVIZCONTRACT')) {
						pos = ArrayLib.find(allRevizContract, ['CONTRACT'], cRec.get('LINK'));
						cRec.set('REVIZCONTRACT', pos === -1 ? --me.revizContractLink : allRevizContract[pos].LINK);
					}

					var revizContract = cRec.get('REVIZCONTRACT');

					rec.set('T_REVIZ_AUDIT', trao.LINK);
					rec.set('TEMP_CODE', tro2.TEMP_CODE);
					rec.set('TEMP_NAME', tro2.TEMP_NAME);
					rec.set('TEMP_SNAME', tro2.TEMP_SNAME);
					rec.set('REVIZCONTRACT', revizContract);
					me.ksData.factNar.data = grid.store.getDataExt();

					grid.revizContract = revizContract;

					var currentContract = contractData[ArrayLib.find(contractData, ['LINK'], cRec.get('LINK'))];

					currentContract.REVIZCONTRACT = revizContract;
					contractPanel.factNarRObject = tro2;

					let factnarData = me.gksd('factNarData'),
						rowFactnar = factnarData ? factnarData.extra[rec.get('LINK')] : null;
					if (rowFactnar) rowFactnar["revizContract"] = [{
						LINK: revizContract,
						CONTRACT: currentContract.LINK
					}];
				}
			},
			callBack = function() {
				var refreshFunc = function() {
					contractPanel.factNarRevizContract = rec.get('REVIZCONTRACT');
					grid.view.refresh();
					contractGrid.view.refresh();
				};

				if (rec.get('REVIZCONTRACT')) {
					selectDialogShow(me.resource.RevizEditView_QuestionAttachFactNarTo_Перенос, me.getBindMsg(false, grid), function() {
						rec.set('REVIZCONTRACT', 0);
						me.ksData.factNar.data = grid.store.getDataExt();
						let factnarData = me.gksd('factNarData'),
							rowFactnar = factnarData ? factnarData.extra[rec.get('LINK')] : null;
						if (rowFactnar) rowFactnar["revizContract"] = null;
						refreshFunc();
					}, Ext.emptyFn);
				} else {
					if (!cRec || !cRec.get('M')) return;
					selectDialogShow(me.resource.RevizEditView_QuestionAttachFactNarTo_Перенос, me.getBindMsg(true, grid), function() {
						okFunc(cRec);
						refreshFunc();
					}, Ext.emptyFn);
				}
			};

		if (me.readOnly || grid.ownerCt?.dict?.readOnly) return _;

		var nacprojConditionGood = true;
		
		//удовлетворение условия на одинаковый нацпроект в финансировании и контракте
		if (cRec && !rec.get('REVIZCONTRACT') && rec.get('REVIZMONEY')){
			var financLink = ArrayLib.filter(me.gksd('financ').revizMoney, ['LINK'], rec.get('REVIZMONEY'))[0]['FINANC'];
			if (financLink) {
				var nacprojLink = ArrayLib.filter(me.gksc('financPanel').Grid.store.getDataExt(), ['LINK'], financLink)[0]['S_NACPROJ'];
				nacprojConditionGood = nacprojLink === 0 || nacprojLink === cRec.get('S_NACPROJ');
			}
		}
		
		var flag = true,
			tro;
		
		//Если объект контракта и объект нарушения разные то нельзя привязать
		if (cRec && !rec.get('REVIZCONTRACT') && rec.get('T_REVIZ_AUDIT')) {
			var pos = ArrayLib.find(me.gksd('tRevizAudit'), ['LINK'], rec.get('T_REVIZ_AUDIT'));
			if (pos !== -1) {
				tro = ArrayLib.filter(me.gksd('tRevizObjects'), ['LINK'], me.gksd('tRevizAudit')[pos].T_REVIZ_OBJECTS)[0];
				flag = (tro.TTABLE === 'S_ORG' && tro.TLINK === cRec.get('S_ORG'));
			}
		}
		
		if (flag && nacprojConditionGood) {
			callBack();
		} else {
			if (!nacprojConditionGood){
				warning(grid === me.gksc('disGrid')
					? me.resource.RevizEditView_FactNarClickCellButton_Нац_проект_в_контракте_не_совпадает_с_нац_проектом_в_привязанном_к_недостатку_финансировании_
					: me.resource.RevizEditView_FactNarClickCellButton_Нац_проект_в_контракте_не_совпадает_с_нац_проектом_в_привязанном_к_факту_нарушения_финансировании_);
			}
			if (!flag) {
				warning(grid === me.gksc('disGrid')
					? me.resource.RevizEditView_FactNarClickCellButton_Объект_в_контракте_не_совпадает_с_объектом_в_недостатке_
					: me.resource.RevizEditView_FactNarClickCellButton_Объект_в_контракте_не_совпадает_с_объектом_в_факте_нарушения_);
			}
		}
	},
	
	getBindMsg: function(bind, grid, isDocGrid) {
		var me = this,
			tabKey = me.gksc('narTab').activeTab.tabKey,
			str = '';

		switch(tabKey) {
			case 'financ':
				str = bind
					? grid === me.gksc('disGrid')
						? me.resource.RevizEditView_QuestionAttachFactNarTo_Вы_действительно_хотите_привязать_этот_недостаток_к_данному_проверенному_финансированию_
						: me.resource.RevizEditView_QuestionAttachFactNarTo_Вы_действительно_хотите_привязать_это_нарушение_к_данному_проверенному_финансированию_
					: grid === me.gksc('disGrid')
						? me.resource.RevizEditView_QuestionAttachFactNarTo_Вы_действительно_хотите_отвязать_этот_недостаток_от_проверенного_финансирования_
						: me.resource.RevizEditView_QuestionAttachFactNarTo_Вы_действительно_хотите_отвязать_это_нарушение_от_проверенного_финансирования_;
				break;
			case 'contract':
				str = bind
					? grid === me.gksc('disGrid')
						? me.resource.RevizEditView_QuestionAttachFactNarTo_Вы_действительно_хотите_привязать_этот_недостаток_к_данному_контракту_
						: me.resource.RevizEditView_QuestionAttachFactNarTo_Вы_действительно_хотите_привязать_это_нарушение_к_данному_контракту_
					: grid === me.gksc('disGrid')
						? me.resource.RevizEditView_QuestionAttachFactNarTo_Вы_действительно_хотите_отвязать_этот_недостаток_от_контракта_
						: me.resource.RevizEditView_QuestionAttachFactNarTo_Вы_действительно_хотите_отвязать_это_нарушение_от_контракта_;
				break;
			case 'okp':
				str = bind
					? grid === me.gksc('disGrid')
						? me.resource.RevizEditView_QuestionAttachFactNarTo_Вы_действительно_хотите_привязать_этот_недостаток_к_данной_проверенной_продукции_
						: me.resource.RevizEditView_QuestionAttachFactNarTo_Вы_действительно_хотите_привязать_это_нарушение_к_данной_проверенной_продукции_
					: grid === me.gksc('disGrid')
						? me.resource.RevizEditView_QuestionAttachFactNarTo_Вы_действительно_хотите_отвязать_этот_недостаток_от_проверенной_продукции_
						: me.resource.RevizEditView_QuestionAttachFactNarTo_Вы_действительно_хотите_отвязать_это_нарушение_от_проверенной_продукции_;
				break;
			case 'info':
				str = bind
					? grid === me.gksc('disGrid')
						? me.resource.RevizEditView_QuestionAttachFactNarTo_Вы_действительно_хотите_привязать_этот_недостаток_к_данной_информации_о_нарушениях_
						: me.resource.RevizEditView_QuestionAttachFactNarTo_Вы_действительно_хотите_привязать_это_нарушение_к_данной_информации_о_нарушениях_
					: grid === me.gksc('disGrid')
						? me.resource.RevizEditView_QuestionAttachFactNarTo_Вы_действительно_хотите_отвязать_этот_недостаток_от_информации_о_нарушениях_
						: me.resource.RevizEditView_QuestionAttachFactNarTo_Вы_действительно_хотите_отвязать_это_нарушение_от_информации_о_нарушениях_;
				break;
			case 'rdoc':
				str = isDocGrid
						? bind
							? grid === me.gksc('disGrid')
							? me.resource.RevizEditView_QuestionAttachFactNarTo_Вы_действительно_хотите_привязать_этот_проверенный_документ_к_данному_недостатку_
							: me.resource.RevizEditView_QuestionAttachFactNarTo_Вы_действительно_хотите_привязать_этот_проверенный_документ_к_данному_нарушению_
							: grid === me.gksc('disGrid')
							? me.resource.RevizEditView_QuestionAttachFactNarTo_Вы_действительно_хотите_отвязать_этот_проверенный_документ_от_недостатка_
							: me.resource.RevizEditView_QuestionAttachFactNarTo_Вы_действительно_хотите_отвязать_этот_проверенный_документ_от_нарушения_
						: bind
						? grid === me.gksc('disGrid')
							? me.resource.RevizEditView_QuestionAttachFactNarTo_Вы_действительно_хотите_привязать_этот_недостаток_к_данному_проверенному_документу_
							: me.resource.RevizEditView_QuestionAttachFactNarTo_Вы_действительно_хотите_привязать_это_нарушение_к_данному_проверенному_документу_
						: grid === me.gksc('disGrid')
							? me.resource.RevizEditView_QuestionAttachFactNarTo_Вы_действительно_хотите_отвязать_этот_недостаток_от_проверенного_документа_
							: me.resource.RevizEditView_QuestionAttachFactNarTo_Вы_действительно_хотите_отвязать_этот_это_нарушение_от_проверенного_документа_;
				break;
		}

		return str;
	}

	//#endregion Привязка нарушений к остальным записям
});