﻿//Таб Общие
Ext.define('Keysystems.Reviz.Edit.General', {
	extend: 'Ext.panel.Panel',
	closable: false,
	mixins: ['Keysystems.Base.Edit'],
	title: 'Общие',
	maskOnDisable: false,
	tabKey: 'General',
	tRevizAuditLink: -1,
	sPersonLink: -1,
	revizCostLink: -1,
	personPartLink: -1,
	flex: 1,
	linkCode: 'SReviz',
	layout: { type: 'vbox', align: 'stretch' },
	bodyPadding: 0,
	labelWidth: 150,
		
	setReadOnly: function(state, reason) {
		Keysystems.Reviz.Edit.prototype.setReadOnly.call(this, state, reason);
	},

	profileListeners: [
		{ name: 'S_PERSON_PART_GRID', method: 'resizeH' },
		{ name: 'PERSON_COST_GRID', method: 'resizeH' },
		{ name: 'revizObjs_Panel', method: 'resizeH' }
	],

	initComponent: function() {
		var me = this;

		me.beforeInitComponent();
		me.createItems();
		me.callParent(arguments);
	},

	createItems: function() {
		var me = this,
			ksControls = me.ksControls,
			dMListeners = {
				blur: function() {
					me.checkDtmInDt();
				}
			},
			dListeners = {
				change: function() {
					if (!me.isLoaded) this.isEdit = true;
				}
			};

		me.checkDtmInDt = function() {
			var ksControls = me.ksControls,
				dt = ksControls.DT.getValue(),
				dtMoney = ksControls.DTMONEY.getValue();

			if (ksControls.DTMONEY.isVisible()) {
				if (dtMoney.dh1 > dt.dh1) {
					warning(wmc.get('DTMoneyMoreThenDTWarning', 'начинаться'));
				} else if (dtMoney.dh2 > dt.dh2) {
					warning(wmc.get('DTMoneyMoreThenDTWarning', 'заканчиваться'));
				}

			}
		};
		return me.items = [
			Ext.create('Ext.form.FieldContainer', {
				layout: { type: 'vbox', align: 'stretch' },
				padding: '5 10 0 10',
				items: [
					Ext.create('Ext.form.FieldContainer', {
						layout: 'hbox',
						items: [
							me.sksc('NUMBER', Ext.create('Ext.form.field.Text', {
								fieldLabel: '№',
								labelWidth: me.labelWidth,
								enforceMaxLength: true,
								maxLength: 25,
								width: 175 + me.labelWidth,
								listeners: {
									blur: function() {
										if (me.ksData.NumberUnique) me.checkNumDate(Ext.emptyFn);
									}
								}
							})),
							me.sksc('NUMBERIKM', Ext.create('Ext.form.field.Text', {
								fieldLabel: '№ ИКМ',
								labelWidth: 60,
								padding: '0 0 0 20',
								enforceMaxLength: true,
								hidden: true,
								maxLength: 35,
								flex: 1,
								listeners: {
									blur: function() {
										var th = this,
											v = th.getValue();

										if (v.length < 25) {
											Ext.Msg.show({
												title: KS.L10n.RevizEditView_CheckSave_Номер_ИКМ,
												msg: KS.L10n.RevizEditView_CheckSave_Текущий_номер_ИКМ_некорректный__заменить_,
												buttons: Ext.MessageBox.OKCANCEL,
												buttonText: { ok: 'Заменить', cancel: 'Продолжить' },
												fn: function(buttonId) {
													if (buttonId === 'ok') {
														th.setValue(me.gksd('AutoNumberIKM'));
													}
												},
												icon: Ext.MessageBox.WARNING
											});
										} else if (me.gksd('CheckIkmUnique')) {
											me.checkNumDate(Ext.emptyFn, 'NUMBERIKM');
										}
									},
									afterrender: function() {
										if (this.inputEl) {
											$(this.inputEl.dom).mask('0000-AA.AAA.AAAA-0000.000', {
												translation: {
													'A': {
														pattern: /[A-Za-z0-9\u0000-\uFFFF]/
													}
												},
												placeholder: '____-__.___.____-____.___'
											});
										}
									}
								}
							})),
							me.sksc('DT0', Ext.create('Ext.form.field.Date', {
								fieldLabel: 'от',
								labelWidth: 30,
								padding: '0 0 0 20',
								flex: 1,
								maxWidth: 180,
								format: 'd.m.Y',
								hideTrigger: false,
								minValue: '01.01.1900',
								maxValue: '31.12.2100',
								sender: me,
								enableColorize: true,
								listeners: {
									blur: function() {
										me.checkDT(true);
									},
									render: function (e) {
										let me = this.sender;
										e.getEl().on('contextmenu', function (target) {
											
											let cm = new Ext.menu.Menu(
												{
													items: [
														{
															text: 'Заполнить',
															disabled: !me.gksd('AutoFillDt') || me.readOnly || me.ksReadOnly || me.ownerCt?.ksReadOnly,
															listeners: {
																click: function () {
																	const data = me.dataCollector();
																	me.showLoadMask({
																		msg: KS.L10n.updating_data,
																		rid: ajaxRequest({
																			url: 'SReviz/AutoFillDT_A',
																			params: {
																				gzipData: SignalR.pack(data)
																			},
																			success: function (result) {
																				if (!result) return;
																				me.gksc('DT0').setValue(result);
																			},
																			callback: function () {
																				if (me) me.hideLoadMask();
																			}
																		})
																	});
																}
															}
														}
													]
												}
											);
											target.stopEvent();
											cm.showAt(target.getXY());
										}, e);
									}
								}
							})),
							ksControls.imgOutDt = Ext.create('Ext.Button',
								{
									iconCls: 'x_btn_info_blue',
									tooltipType: 'title',
									margin: '0 0 0 10',
									disabled: true,
									baseCls: 'ks-btn-img-cls',
									hidden: true
								}),
							ksControls.imgHistoryChange = Ext.create('Ext.Button',
								{
									iconCls: 'x_btn_requisites_change',
									tooltipType: 'title',
									disabled: true,
									margin: '0 0 0 10',
									baseCls: 'ks-btn-img-cls',
									hidden: true
								})
						]
					}),
					me.sksc('objsPanel', Ext.create('Keysystems.RevizObj', {
						fieldLabel: 'Объект',
						layout: 'hbox',
						getRevizOneMain: function() {
							return me.ksData.RevizOneMain;
						},
						getRevizObjType: function() {
							return me.ksData.RevizObjType;
						},
						getIndivid: function() {
							return me.ksData.Individ;
						},
						getRevizSelf: function() {
							return me.ksData.RevizSelf;
						},
						getRevizObjects: function() {
							return me.ksData.tRevizObjects;
						},
						getRevizAudit: function() {
							return me.ksData.tRevizAudit;
						},
						getRevizAuditLink: function() {
							return me.tRevizAuditLink--;
						},
						getS_ORGP_Grid: function() {
							return me.gksc('S_ORGP_Grid');
						},
						setRevizObjects: function(list) {
							me.sksd('tRevizObjects', list);
						},
						setRevizAudit: function(list) {
							me.ksData.tRevizAudit = list;
						},
						getDT: function() {
							return me.gksc('DT').getValue();
						},
						isLoading: function(){
							return me.isLoaded;
						},
						checkObjectsForReviz: me.checkObjectsForReviz,
						checkObjectsHistoryChange: me.checkObjectsHistoryChange,
						changeObjProp: me.changeObjProp,
						canChangeObjects: me.canChangeObjects,
						tRevizAuditLink: me.tRevizAuditLink,
						thereMainObj: me.thereMainObj,
						labelWidth: me.labelWidth - 83,
						parentView: me
					})),
					me.sksc('EXTOBJECTS', Ext.create('Ext.form.field.ComboBox', {
						padding: '-5 0 0 ' + (me.labelWidth + 5),
						maxLength: 8000,
						enforceMaxLength: true,
						store: []
					})),
					me.createDictEdit({
						key: 'S_WORK',
						mode: 'SINGL',
						code: dnl.S_WORK,
						fieldLabel: 'Вид работы',
						ksAllowEmpty: true,
						listeners: {
							change: function(th) {
								var isReviewNar = me.gksd('reviewNar') && me.gksd('reviewNar') === th.getLink();
								me.objs.S_OTDEL.setKsAllowEmpty(!isReviewNar);
							}
						},
						initWhereArgs: function() {
							var dh = ksControls.DT.getValue(),
								whereArgs = {
									DH1: { value: dh.dh1.toDateString(), type: 'Date' },
									DH2: { value: dh.dh2.toDateString(), type: 'Date' },
									SPersons: {
										value: JSON.stringify(ksControls.S_PERSON_GRID ? ksControls.S_PERSON_GRID.store.getLinks('S_PERSON') : []),
										type: 'List_int'
									}
								};

							if (me.gksd('sWorkWhereArgs')) {
								if (me.gksd('sWorkWhereArgs').sworkInLinks !== null) {
									whereArgs.InLinksOnly = { value: 'True', type: 'bool' };
									whereArgs.InLinks = {
										value: JSON.stringify(me.gksd('sWorkWhereArgs').sworkInLinks),
										type: 'List_int'
									};
								}

								whereArgs.NotInLinks = {
									value: JSON.stringify(me.gksd('sWorkWhereArgs').sworkNotInLinks),
									type: 'List_int'
								};
							}

							return whereArgs;
						}
					}),
					ksControls.osnovPanel = Ext.create('Ext.form.FieldContainer', {
						layout: 'hbox',
						items: [
							Ext.create('Ext.form.FieldContainer', {
								layout: {type: 'hbox', align: 'left'},
								width: 150,
								padding: window.Theme === 'crisp' ? '0 2 0 0' : '0 1 0 0',
								items: [me.sksc('osnovLabel', Ext.create('Ext.form.Label', {
									text: 'Основание:',
									ksAllowEmpty: true,
									cls: 'x-form-item-label',
									margin: '5 2 0 0',
									width: 100,
									maxWidth: 100,
									setReadOnly: function (state) {
										this.readOnly = state;
										this[state ? 'addCls' : 'removeCls']('ks-readOnly');
									}
								})), 
									'->',
									me.sksc('PLAN_BTN', Ext.create('Ext.button.Split', {
										hidden: true,
										iconCls: 'x_btn_plan',
										userCls: 'rks-split-button',
										handler: function () {
											var state = me.gksd('planBtnState'),
												isPlan = false,
												code = '',
												editCls = '',
												link = 0,

												showDictFunc = function (link, code) {
													if (link) {
														me.editFn(link, editCls);
													} else {
														var objLinks = [];

														Ext.each(me.gksd('tRevizObjects'), function (obj) {
															if (obj.MAIN) objLinks.push(obj.TLINK);
														});

														var whereArgs = {
															OrgLinks: {
																value: Ext.isNumber(objLinks[0]) ? JSON.stringify(objLinks) : JSON.stringify([]),
																type: 'List_int'
															},
															InLinksOnly: {
																value: false,
																type: 'bool'
															}
														};
														
														dictFunc({
															initWhereArgs: function () {
																return whereArgs;
															},
															code: code,
															mode: 'SIMPL'
														}, {
															ok: function (value) {
																switch (state) {																	
																	case 'orders':
																		me.sksd('ORDER_LINK', value[0].get('LINK'));
																		break;
																	default:
																		me.sksd('PLANREVIZ', value[0].get('LINK'));
																}
																me.changePlanBtnState(state);
															}
														});
													}
												};

											switch (state) {
												case 'appeals':
													const appeals = me.gksd('linksAppeals') ?? [];
													//отображаем список для выбора, если обращений нет
													if (appeals.length === 0) {
														dictFunc({
															initWhereArgs: function () {
																return me.getAppealsWhereArgs();
															},
															code: dnl.APPEALS,
															mode: 'MULTI'
														}, {
															ok: function (value) {
																me.sksd('linksAppeals', value.map(v => v.get('LINK')));
																me.changePlanBtnState('appeals');
															}
														});
													}
													//отображаем окно редактирования, если обращение одно
													else if (appeals.length === 1){
														me.editFn(appeals[0], 'Keysystems.Appeals.Edit', {f:'readOnly'});
													}
													//отображаем список, если обращений несколько
													else {
														dictFunc({
																initWhereArgs: function () {
																	return {																		
																		InLinks: {
																			value: JSON.stringify(appeals),
																			type: 'List_int'
																		},
																		InLinksOnly: {value: true, type: 'bool'},
																	}
																},
																checkModel: false,
																code: dnl.APPEALS,
																accessReadOnly: true
															})
													}		
													return;
												case 'orders':
													link = me.gksd('ORDER_LINK');
													code = dnl.ORDERS;
													editCls = 'Keysystems.Orders.Edit';
													break;
												default:
													isPlan = true;
													link = me.gksd('PLANREVIZ');
													code = dnl.PLANREVIZORG; // todo: Использовать dnl.PLANREVIZ
													editCls = 'Keysystems.Plan.Edit';
											}

											if (link === 0 && isPlan) {
												me.showLoadMask({
													msg: KS.L10n.loading_data,
													rid: ajaxRequest({
														url: 'SReviz/CheckRevizObjsForExistPlanReviz_A',
														params: {gzipData: SignalR.pack(me.dataCollector())},
														success: function (result) {
															var createFn = function () {
																selectDialogShow(KS.L10n.attention,
																	'Создать новое запланированное мероприятие?',
																	function () {
																		me.editFn(0, editCls);
																	});
															};

															me.hideLoadMask();
															if (result.Links) {
																selectDialogShow(KS.L10n.attention,
																	wmc.getQuestion('PlanRevizExists', me.gksd('tRevizObjects').length > 1 ? 'выбранных объектов' : 'выбранного объекта'),
																	function () {
																		dictFunc({
																			whereArgs: {
																				InLinks: {
																					value: JSON.stringify(result.Links),
																					type: 'List_int'
																				},
																				InLinksOnly: {
																					value: 'True',
																					type: 'bool'
																				}
																			},
																			code: code
																		}, {
																			ok: function (v) {
																				if (v && v.length) {
																					me.sksd('PLANREVIZ', v[0].get('PLANREVIZ'));
																					me.gksc('TEMP_PLAN_NAME').setValue(v[0].get('PPLAN'));
																				}

																				me.changePlanBtnState('plan');
																			}
																		});
																	},
																	function () {																		
																		if (!result.closed){
																			me.ownerCt.checkFilled(res=>{
																				if (!res) return;
																				createFn();
																			})	
																		} 
																	}
																);
															} else {
																if (!result.closed){
																	me.ownerCt.checkFilled(res=>{
																		if (!res) return;
																		createFn();
																	})
																}
															}
														},
														failure: function () {
															me.hideLoadMask();
															showError(wmc.get('ErrorGetData'));
															if (endFunc) endFunc(null);
														}
													})
												});
											} else {
												showDictFunc(link, code, []);
											}
										},
										setReadOnly: function (state) {
											if (!me.readOnly) me.gksc('PLAN_BTN').setDisabled(false);
										},
										menu: [
											{
												text: 'Отвязать',
												handler: function () {
													const state = me.gksd('planBtnState');														

													if (state === 'plan') {
														me.editFn(me.gksd('PLANREVIZ'), 'Keysystems.Plan.Edit');
													} else if (state === 'appeals'){
														//привязка обращений
														let appeals = me.gksd('linksAppeals') ?? [];
														dictFunc({
															initWhereArgs: function () {
																const whereArgs =  me.getAppealsWhereArgs();
																whereArgs.NotInLinks = {
																	value: JSON.stringify(appeals),
																		type: 'List_int'
																};
																return whereArgs;
															},
															mode: 'MULTI',
															code: dnl.APPEALS,
															accessReadOnly: true
														},{
															ok: function (v) {
																if (!v?.length)  return;
																const newLinks = v.map(v=>v.get('LINK'));
																ArrayLib.addMissing(appeals, newLinks);
																me.sksd('linksAppeals', appeals);
																me.changePlanBtnState(state);
															}
														})
													} else {
														selectDialogShow(KS.L10n.attention, KS.L10n.RevizEditView_cmOrder_ItemClicked_Отвязать_поручение_,
															function () {
																me.sksd('ORDER_LINK', 0);
																me.changePlanBtnState(state);
															});
													}
												}
											},											
											{
												text: 'Изменить объект в запланированном мероприятии',
												hidden: me.gksd('PLANREVIZ') !== 0,
												handler: function () {
													var newLinks = ArrayLib.getLinks(ArrayLib.filter(me.gksd('tRevizObjects'), ['MAIN'], true), ['TLINK']);

													if (me.gksd('planObjsLinks') && !ArrayLib.equal(newLinks, me.gksd('planObjsLinks'))) {
														selectDialogShow(KS.L10n.attention, 'Изменить объект в запланированном мероприятии?', function () {
															me.synchronizePlanObject(newLinks);
														});
													} else {
														info('Изменения не требуются');
													}
												}
											},
											{
												text: 'Отвязать обращение',
												hidden: me.gksd('linksAppeals')?.length > 0,
												handler: function () {
													let appeals = me.gksd('linksAppeals') ?? [];
													if (appeals.length === 1){
														selectDialogShow(KS.L10n.attention, KS.L10n.RevizEditView_cmAppeal_ItemClicked_Отвязать_обращение_,
															function () {
																me.sksd('linksAppeals', []);
																me.changePlanBtnState('appeals');
															});
													}
													else{
														dictFunc({
															initWhereArgs: function () {
																return {
																	InLinks: {
																		value: JSON.stringify(appeals),
																		type: 'List_int'
																	},
																	InLinksOnly: {value: true, type: 'bool'},
																}
															},
															mode: 'MULTI',
															code: dnl.APPEALS,
															accessReadOnly: true
														},{
															ok: function (v) {
																if (!v?.length)  return;
																const delLinks = v.map(v=>v.get('LINK'));
																appeals = ArrayLib.diffArrays(appeals, delLinks);
																me.sksd('linksAppeals', appeals);
																me.changePlanBtnState('appeals');
															}
														});
													}
												}
											},
										]
									}))
								]
							}),														
							me.createDictEdit({
								key: 'S_ROSNOV',
								flex: 1,
								mode: 'SINGL',
								code: dnl.S_ROSNOV,
								margin: '0 10 0 3',
								ksAllowEmpty: true,
								initWhereArgs: function() {
									var dh = ksControls.DT.getValue(),
										whereArgs = {
											DH1: { value: dh.dh1.toDateString(), type: 'Date' },
											DH2: { value: dh.dh2.toDateString(), type: 'Date' }
										};

									if (me.gksd('sRosnovWhereArgs')) {
										whereArgs.InLinks = {
											value: JSON.stringify(me.gksd('sRosnovWhereArgs')),
											type: 'List_int'
										};
										whereArgs.InLinksOnly = { value: 'True', type: 'bool' };
									}

									let linkSelf = me.data ? me.data.data.LINK_SELF : me.ksData.linkSelf;
									if (!linkSelf && !me.gksd('PLANREVIZ')) {
										whereArgs.NotInLinks = {
											value: JSON.stringify(me.gksd('sRosnovPlan')),
											type: 'List_int'
										};
									}

									if (me.gksd('sRosnovInLinks')) {
										whereArgs.InLinks = {
											value: JSON.stringify(me.gksd('sRosnovInLinks')),
											type: 'List_int'
										};
										whereArgs.InLinksOnly = { value: 'True', type: 'bool' };
									}


									return whereArgs;
								},
								ksSetValue: function(value) {
									var btnState = false,
										oldVal = this.getValue();

									ksControls.S_ROSNOV.setValue(value);

									if (value && value.length) {
										value = value[0];
										btnState = me.gksd('planBtnState');

										if (!me.isLoaded) me.isPlan(value.LINK || value.data.LINK);
										/*me.isDocOsnov(value.data.LINK, function(vis) {
											me.setDocOsnovDisable(!vis);
										});*/
									}

									me.changePlanBtnState(btnState);
									if (!me.isLoaded) {
										me.gksc('docOsnov').refresh();
									}
								}
							}),
							me.sksc('docOsnov', Ext.create('Keysystems.Document.Edit.Mini', {
								labelWidth: me.labelWidth,
								padding: '0 0 0 10',
								flex: 1,
								parentView: me,
								getOsnovLink: function() {
									return me.gksc('S_ROSNOV').getLink();
								},
								getWorkLink: function() {
									return me.gksc('S_WORK').getLink();
								},
								getMasterLink: function() {
									return me.getLink();
								}
							}))
							/*me.sksc('DOCOSNOVNUMBER', Ext.create('Ext.form.field.Text', {
								labelWidth: 15,
								fieldLabel: '№',
								disabled: true,
								padding: '0 10 0 0',
								width: 80
							})),
							me.sksc('DOCOSNOVDT', Ext.create('Ext.form.field.Date', {
								labelWidth: 15,
								fieldLabel: 'от',
								disabled: true,
								padding: '0 5 0 0',
								width: 130,
								format: 'd.m.Y',
								minValue: '01.01.1900',
								maxValue: '31.12.2100'
							})),
							me.sksc('DOCOSNOV_BTN', Ext.create('Ext.Button', {
								width: 60,
								text: 'Файл',
								disabled: true,
								handler: function() { me.fileEdit(); },
								listeners: {
									afterrender: function(th) {
										UploaderLib.bind(th.el.dom, function(link, ext, callback) {
											me.updFileRecord(link, ext);
											callback();
										});
									}
								}
							}))*/
						]
					}),
					me.sksc('EXTOSNOV', Ext.create('Ext.form.field.ComboBox', {
						fieldLabel: 'Доп. основание',
						labelWidth: me.labelWidth,
						maxLength: 2000,
						enforceMaxLength: true,
						store: []
					})),
					Ext.create('Ext.form.FieldContainer', {
						layout: 'hbox',
						width: me.labelWidth,
						items: [
							me.sksc('TEMP_PLAN_NAME', Ext.create('Ext.form.field.Text', {
								fieldLabel: 'Пункт плана',
								labelWidth: me.labelWidth,
								readOnly: true
							}))
						]
					}),
					me.sksc('dtPanel', Ext.create('Ext.form.FieldContainer', {
						layout: { type: 'hbox', align: 'stretch' },
						border: 0,
						items: [
							me.sksc('DT', Ext.create('Keysystems.Controls.PeriodEdit', {
								labelWidth: me.labelWidth,
								allowBlank: false,
								fieldLabel: 'Период проведения',
								ksAllowEmpty: true,
								width: 460,
								d1Listeners: dListeners,
								d2Listeners: dListeners,
								cfgnbDays: { hidden: false },
								cfgDh: { width: 105 },
								getOrgP: function() {
									return ArrayLib.getLinks(me.gksd('tRevizAudit'), ['S_ORG'])[0] || window.user.org.data.LINK
								},
								listeners: {
									ksChange: function(dh1, dh2, changedName) {
										var th = this,
											ksControls = me.ksControls,
											personGrid = ksControls.S_PERSON_GRID,
											checkProgFunc = function (){
												if (!me.isLoaded && me.ksData.link) {
													ajaxRequest({
														url: 'SReviz/CheckRevizProg_A',
														params: {
															link: me.ksData.link,
															prdDT: me.ksControls.DT.getValue(1),
														},
														success: function (result) {
															if (result) {
																selectDialogShow(KS.L10n.RevizEditView_prdDT_KSChanged_Изменение_периода_проведения, KS.L10n.RevizEditView_prdDT_KSChanged_Изменить_сроки_исполнения_вопросов_программы_, function () {
																	me.sksd('changeProgDT', true);
																}, function () {
																	me.sksd('changeProgDT', false);
																});
															}
														}
													})
												}
											},
											endFunc = function() {
												if (!personGrid) return _;

												var data = personGrid.store.getDataExt(),
													links = [];

												if (data.length && ksControls.DTMONEY.isVisible()) {
													Ext.each(data, function(rec) {
														links.push(rec.S_PERSON);
													});

													selectDialogShow(KS.L10n.RevizEditView_prdDT_KSChanged_Изменение_периода_проведения, KS.L10n.RevizEditView_prdDT_KSChanged_Изменить_периоды_участия_, function() {
														me.fillPersonParts(links, true, !me.gksd('nastrRevizDuration'));
														me.refCostData();
														checkProgFunc();
													}, function() {
														me.checkErrorParts(links);
														me.refCostData();
														checkProgFunc();
													});
												}
												else{
													checkProgFunc();
												}

												if (th.nbDays && !me.calcByRevizors()) {
													th.swap();
													var dt = th.getValue();

													getCntDaysInPeriod(dt.dh1, dt.dh2, th.getOrgP(), function(val) {
														th.nbDays.setValue(val.workDays);
													});
												}

												me.checkDtmInDt();
											};

										if (changedName && changedName === 'dh1') {
											me.showLoadMask({
												msg: KS.L10n.updating_data,
												rid: ajaxRequest({
													url: 'Data/GetNextDay_A',
													timeout: 5000,
													params: { dt1: dh1, days: me.gksd('duration'), sOrg: th.getOrgP() },
													success: function(value) {
														me.hideLoadMask();
														value = new Date(value);
														selectDialogShow(KS.L10n.RevizEditView_prdDT_KSChanged_Изменение_периода_проведения, wmc.get('BeginDateChanged', value.toLocaleDateString()), function() {
															th.dh2.setValue(value);
															endFunc();
														}, function() {
															endFunc();
														});
													},
													failure: function() {
														me.hideLoadMask();
													}
												})
											});
										} else {
											endFunc();
										}

									}
								}
							})),
							'->',
							me.sksc('DTMONEY', Ext.create('Keysystems.Controls.PeriodEdit', {
								labelWidth: me.labelWidth,
								fieldLabel: 'Проверяемый период',
								isSwap: true,
								ignoreColorize: true,
								width: 380,
								d1Listeners: dMListeners,
								d2Listeners: dMListeners,
								cfgDh: { width: 105 }
							}))
						]
					})),
					me.sksc('S_OTDEL', me.objs.S_OTDEL = Ext.create('Keysystems.Controls.Dict.Edit',
						{
							labelWidth: me.labelWidth,
							fieldLabel: 'Ответственный исполнитель',
							padding: window.isRfn ? '-6 0 9 0' : 0,
							handler: function() {
								dictFunc({
										mode: 'SINGL',
										title: me.titleSOtdel,
										code: dnl.S_OTDEL,
										parentView: objs.view,
										selectLinks: me.objs.S_OTDEL.getValue(),
										readOnly: me.gksc('S_OTDEL').readOnly,
										accessReadOnly: me.gksc('S_OTDEL').readOnly,
										control: me.gksc('S_OTDEL'),
										contextSearch: me.gksc('S_OTDEL').contextSearch,
										initWhereArgs: function() {
											var dh = ksControls.DT.getValue(),
												whereArgs = {},
												sOrgs = me.gksc('S_ORGP_Grid').store.getLinks();
											if (!sOrgs.length) {
												sOrgs = [window.user.org.data.LINK];
											}

											whereArgs.DH1 = {
												value: dh.dh1.toDateString(),
												type: 'Date'
											};
											whereArgs.DH2 = {
												value: dh.dh2.toDateString(),
												type: 'Date'
											}
											whereArgs.SOrgs = {
												value: JSON.stringify(sOrgs),
												type: 'List_int'
											}
											if (me.gksd('onlyParent')) {
												whereArgs.OnlyParent = {
													value: 'True',
													type: 'bool'
												}
											}
											return whereArgs;
									},
										getSOrg: function() {
											return me.gksc('S_ORGP_Grid').store.getDataExt().length
												? me.gksc('S_ORGP_Grid').store.getDataExt()[0].LINK
												: window.user.org.data.LINK;
										},
									},
									{
										ok: function(value) {
											me.objs.S_OTDEL.setValue(value);
										}
									});
							}
						})),
					me.createDictEdit({
						key: 'S_ORG_EXT',
						mode: 'MULTI',
						code: dnl.S_ORG,
						fieldLabel: 'Привлекаемые организации',
						padding: '-5 0 7 0',
						initWhereArgs: function() {
							return {
								SType: {
									value: JSON.stringify([Ext.Object.getKey(miscTypes.TypeOrg, 'Проверяющая')]),
									type: 'List_int'
								},
								HasFilterOnLoad: {
									value: 'False',
									type: 'bool'
								},
								NotInLinks: {
									value: JSON.stringify(me.gksc('S_ORGP_Grid').store.getLinks()),
									type: 'List_int'
								}
							};
						}
					}),
					me.sksc('mainReviz', Ext.create('Keysystems.Controls.DictName.Edit',
						{
							labelWidth: me.labelWidth,
							fieldLabel: 'Основное мероприятие',
							cleaningKey: false,
							code: dnl.REVIZ,
							hidden: true,
							handler: {
								cls: 'x-dict-trigger x_btn_open',
								handler: function() {
									var link = me.gksc('mainReviz').getLink();
									if (!link) return;
									Ext.create(dictListController.DOCUMENT_REVIZ.editClass,
										{
											link: link,
											f: 'readOnly',
											linkCode: 'SReviz',
											data: {
												data: {
													LINK: link
													//linkPlanReviz,orderLink,appealLink,docLink
												}
											}

										});
								}
							},
							initWhereArgs: function() {
								var dh = ksControls.DT.getValue(),
									year = dh.dh1.getFullYear(),
									links = me.ksData.LINK_SELF || me.ksData.linkSelf;
								return {
									DBegin: { value: new Date(year, 0, 1), type: 'Date' },
									DEnd: { value: new Date(year, 11, 31), type: 'Date' },
									OrgsP: { value: JSON.stringify(me.mainRevizAudit), type: 'List_int' },
									InLinksOnly: { value: 'True', type: 'bool' },
									InLinks: { value: JSON.stringify(links), type: 'List_int' }
								};
							}
						}))
				]
			}),
			me.sksc('t1', Ext.create('Ext.tab.Panel', {
				border: 0,
				cls: 'rks-panel-edit',
				bodyCls: 'rks-panel-edit-body',
				//layout: { type: 'vbox', align: 'stretch' },
				//layout: 'fit',
				flex: 1,
				items: [
					me.sksc('S_ORGP_Panel', Ext.create('Ext.panel.Panel', {
						title: 'Проверяющие',
						bodyBorder: false,
						layout: { type: 'vbox', align: 'stretch' },
						border: 0,
						items: [
							me.sksc('S_ORGP_Grid', Ext.create('Ext.grid.Panel', {
								flex: 1,
								multiSelect: true,
								minHeight: 100,
								border: 0,
								tbar: [
									me.sksc('GeneralDictBtn', Ext.create('Ext.Button', {
										iconCls: 'x_btn_dict',
										key: 'dict',
										tooltip: KS.L10n.RevizEditView_InitializeComponent_Выбрать,
										tooltipType: 'title',
										handler: function() {
											var sOrgpGrid = me.gksc('S_ORGP_Grid');

											dictFunc({
												mode: window.isRfn ? 'SINGL' : 'MULTI',
												parentView: me.getKsControl('view', true, true),
												checkList: ArrayLib.copy(sOrgpGrid.store.data.items),
												selectLinks: me.gksc('S_ORGP_Grid').selModel.getSelection(),
												preserveScrollOnRefresh: true,
												whereArgs: {
													SType: {
														value: JSON.stringify([1]),
														type: 'List_int'
													},
													HasFilterOnLoad: {
														value: 'false',
														type: 'bool'
													}
												},
												checkListeners: {
													beforecheckchange: function(th, rowIndex, checked, rec) {
														return !(!checked && rec.get('LINK') === sOrgpGrid.lockOrg);
													},
													checkchange: function(th, rowIndex, checked, record) {
														var link = record.data.LINK;
														if (checked && (Ext.Array.indexOf(me.gksd('lockOrgList'), link) !== -1)) {
															sOrgpGrid.lockOrg = link;
															sOrgpGrid.lockRecord = record;
															th.ownerCt.grid.view.refresh();
														}
													}
												},
												canCheck: function(rec, checked) {
													return checked || rec.get('LINK') !== me.gksc('S_ORGP_Grid').lockOrg;
												},
												checkRenderer: function(val, meta, rec) {
													if (rec.data.LINK === sOrgpGrid.lockOrg) meta.tdCls += ' ' + this.disabledCls;
												},
												code: dnl.S_ORG
											}, {
												ok: function(value) {
													if (window.isRfn && !value.length) return;
													if (!window.isRfn && ArrayLib.find(value, ['data', 'LINK'], sOrgpGrid.lockOrg) === -1) {
														value.unshift(sOrgpGrid.lockRecord);
													}
													var del = [],
														add = [],
														i,
														len,
														j,
														jLen,
														link,
														old = me.gksd('tRevizAudit'),
														tro = me.gksd('tRevizObjects'),
														res = ArrayLib.copy(old),
														DT = me.gksc('DT'),
														oldOrgP = DT.getOrgP();

													sOrgpGrid.store.each(function(rec) {
														for (i = 0, len = value.length; i < len; i++) {
															link = value[i].data ? value[i].data.LINK : value[i].LINK;
															if (link === rec.data.LINK) {
																return;
															}
														}
														del.push(rec.data.LINK);
													});

													for (i = 0, len = value.length; i < len; i++) {
														link = value[i].data ? value[i].data.LINK : value[i].LINK;
														if (sOrgpGrid.store.find('LINK', link) === -1) {
															add.push(link);
														}
													}

													for (i = 0, len = del.length; i < len; i++) {
														var list = ArrayLib.filter(me.ksData.tRevizAudit, ['S_ORG'], del[i]);
														for (j = 0, jLen = list.length; j < jLen; j++) {
															var pos = Ext.Array.indexOf(res, list[j]);
															res.splice(pos, 1);
														}
													}

													for (i = 0, len = add.length; i < len; i++) {
														for (j = 0, jLen = tro.length; j < jLen; j++) {
															res.push({
																LINK: me.tRevizAuditLink--,
																T_REVIZ_OBJECTS: tro[j].LINK,
																MAIN: tro[j].MAIN,
																S_ORG: add[i],
																TEMP_CODE: tro[j].TEMP_CODE,
																TEMP_NAME: tro[j].TEMP_NAME,
																TEMP_SNAME: tro[j].TEMP_SNAME
															});
														}
													}

													if (add.length || del.length) {
														me.objs.S_OTDEL.setValue();
													}

													var listOrgPExt = [];
													me.gksc('S_ORG_EXT').getValue().forEach(function(item) {
														if (add.indexOf(item.LINK) === -1)
															listOrgPExt.push(item);
													});

													me.gksc('S_ORG_EXT').setValue(listOrgPExt);

													sOrgpGrid.store.loadData(value, false);
													me.sksd('tRevizAudit', res);
													me.gksc('objsPanel').eventTRAEdit(res, old);
													sOrgpGrid.extraSelectFrst();

													if (DT.nbDays && oldOrgP !== DT.getOrgP()) {
														DT.swap();
														var dtVal = DT.getValue();

														if (me.calcByRevizors()) {
															me.setDaysByRevizors();
														} else {
															getCntDaysInPeriod(dtVal.dh1, dtVal.dh2, DT.getOrgP(), function(val) {
																DT.nbDays.setValue(val.workDays);
															});
														}
													}
												}
											});
										}
									})),
									me.sksc('GeneralDeleteBtn', Ext.create('Ext.Button', {
										iconCls: 'x_btn_delete',
										key: 'delete',
										tooltip: KS.L10n.RevizEditView_InitializeComponent_Удалить,
										tooltipType: 'title',
										handler: function() {
											var orgGrid = me.gksc('S_ORGP_Grid'),
												sels = orgGrid.selModel.getSelection(),
												i = ArrayLib.find(sels, ['data', 'LINK'], orgGrid.lockOrg);

											if (i !== -1) {
												sels.splice(i, 1);
											}

											var len = sels.length;
											if (len) {
												selectDialogShow(KS.L10n.delete, wmc.get('DeleteMessage', len), function() {
													var ksData = me.ksData,
														old = ksData.tRevizAudit,
														res = ArrayLib.copy(old);

													for (i = 0, len = sels.length; i < len; i++) {
														var list = ArrayLib.filter(ksData.tRevizAudit, ['S_ORG'], sels[i].data.LINK);
														for (var j = 0, jLen = list.length; j < jLen; j++) {
															var pos = Ext.Array.indexOf(res, list[j]);
															res.splice(pos, 1);
														}
													}

													orgGrid.store.remove(sels);
													me.sksd('tRevizAudit', res);
													me.orgPSelector(orgGrid.getFrstSelect());
													me.gksc('objsPanel').eventTRAEdit(res, old);
													me.gksc('S_OTDEL').setValue();
												});
											}
										}
									}))
								],
								listeners: {
									select: function(th1, record) {
										me.orgPSelector(record);
										me.gksc('GeneralDeleteBtn').setDisabled(me.gksc('S_ORGP_Grid').store.getData().length < 2);
									}
								},
								store: Ext.create('Ext.data.Store', {
									fields: ['LINK', 'CODE', 'NAME', 'S_REGION'],
									data: [],
									proxy: 'memory'
								}),
								columnLines: true,
								columns: [
									{
										text: 'Код',
										dataIndex: 'CODE',
										draggable: false,
										width: '20%'
									},
									{
										text: 'Наименование',
										dataIndex: 'NAME',
										draggable: false,
										flex: 1
									}
								],
								plugins: ['gridclipboard']
							})),
							{
								xtype: 'splitter'
							},
							me.sksc('revizObjs_Panel', Ext.create('Ext.panel.Panel', {
								flex: 1,
							}))
						]
					}))
				]
			}))
		];
	},
	
	getAppealsWhereArgs: function(){
		const me = this;
		const appeals = me.gksd('linksAppeals') ?? [];
		const objLinks = [];		
		Ext.each(me.gksd('tRevizObjects'), function (obj) {
			if (obj.MAIN) objLinks.push(obj.TLINK);
		});

		const whereArgs = {
			OrgLinks: {
				value: Ext.isNumber(objLinks[0]) ? JSON.stringify(objLinks) : JSON.stringify([]),
				type: 'List_int'
			},
			DEnd: {
				value: PeriodLib.addDays(me.gksc('DT').getValue().dh1, -1).toDateString(),
				type: 'Date'
			},
			RevizFreeOnly: {
				value: true,
				type: 'bool'
			}
		}
		const linksDeleted = (me.gksd('initLinksAppeals') ?? []).filter(link => appeals.indexOf(link) < 0);
		if (linksDeleted.length > 0){
			whereArgs.OrInLinks = {
				value: JSON.stringify(linksDeleted),
				type: 'List_int'
			};
		}
		const planLink = me.data ? me.data.data.PLANREVIZ : me.gksd('linkPlanReviz');
		if (!planLink) {
			whereArgs.Recommendation = {
				value: 2,
				type: 'int'
			};
		}
		return whereArgs;
	},

	orgPSelector: function(record) {
		if (!record) return;
		var me = this,
			link = record.get('LINK'),
			grid = me.gksc('S_ORGP_Grid');

		grid.lastSelect = record;
		grid.selOrg = link;

		var list = ArrayLib.filter(me.ksData.tRevizAudit, ['S_ORG'], link),
			checks = [];

		for (var i = 0, len = list.length; i < len; i++) {
			checks.push({
				data: {
					LINK: list[i].T_REVIZ_OBJECTS,
					MAIN: !!list[i].MAIN
				}
			});
		}
		var rd = me.gksc('revizObjs_Dict'),
			items = rd.Grid.store.data.items;

		//Заглушка чтобы при setChecks записи чекались
		if (checks.length !== 0) {
			rd.checkList = checks;
		}

		rd.setChecks(checks);

		//Заглушка потому что setChecks не анчекает записи которые не входят в новый checkList
		Ext.each(items, function(rec) {
			var find = ArrayLib.recordIndexOf(rd.checkList, rec);
			if (rec.get('M') && find === -1) rd.checkRecord(rec, false);
		});

		me.gksc('revizObjs_Dict').objs.Grid.view.refresh();
	},

	enableToolsInnerGrid: function(gridKey){
		let me = this,
			grid = me.gksc(gridKey),
			sel = grid.getFrstSelect();

		let btnRecalc = grid.getToolbarItem('recalc');
		btnRecalc && btnRecalc.setDisabled(!grid.store.data.items.length);

		let btnDelete = grid.getToolbarItem('delete');
		btnDelete && btnDelete.setDisabled(!sel);
	},
	
	//конструктор таба Реквизиты
	createTabProp: function() {
		var me = this,
			ksControls = me.ksControls;

		me.sksc('tabProp', Ext.create('Keysystems.Panel.Prop', {
			border: 0,
			bodyBorder: false,
			parentView: me,
			decimalData: me.gksd('decimalData'),
			createTBar: function() {
				var th = this,
					tbar = th.callParent(arguments),
					tsbFillProp = th.gksc('tsbFillProp'),
					tsbExpand = th.gksc('tsbExpand'),
					tsbCollapse = th.gksc('tsbCollapse');

				tbar = tbar.filter(function(b) {
					return b.xtype !== 'tbseparator';
				});
				tsbFillProp.tooltip = KS.L10n.RevizEditView_InitializeComponent_Пересчитать;
				tsbFillProp.iconCls = 'x_btn_calcauto';
				tsbFillProp.needDisable = function() {
					return !me.propWithMask.length;
				};

				// порядок
				var index = tbar.indexOf(tsbFillProp);
				if (index !== -1) {
					tbar.splice(index, 1);
					tbar.push(tsbFillProp);
					tbar.push({ xtype: 'tbseparator' });
				}
				index = tbar.indexOf(tsbExpand);
				if (index !== -1) {
					tbar.splice(index, 1);
					tbar.push(tsbExpand);
				}
				index = tbar.indexOf(tsbCollapse);
				if (index !== -1) {
					tbar.splice(index, 1);
					tbar.push(tsbCollapse);
				}

				return tbar;
			},
			calculateProp: me.calculateProp
		}));

		return ksControls.tabProp;
	},

	// Конструктор таба Реквизиты объектов контроля
	createTabObjPropGrid: function() {
		var me = this;

		return me.sksc('ObjPropGrid',
			Ext.create('Keysystems.Controls.GroupingGrid',
				{
					title: 'Реквизиты объектов контроля',
					code: me.code,
					sortCol: 'ORD',
					border: 0,
					GateCode: 'edit',
					controlName: 'ObjPropGrid',
					groupLinkField: 'OBJECTS',
					groupNameField: 'NAME'
				}));
	},

	//конструктор таба Участники
	createTabRevizors: function() {
		var me = this,
			ksData = me.ksData,
			ksControls = me.ksControls;

		return me.sksc('revizorsPanel', Ext.create('Ext.panel.Panel', {
			title: 'Участники',
			layout: { type: 'vbox', align: 'stretch' },
			border: 0,			
			bodyBorder: false,
			items: [
				me.sksc('S_PERSON_GRID', Ext.create('Ext.grid.Panel', {
					flex: 3,
					minHeight: 100,
					border: 0,
					plugins: [
						Ext.create('Ext.grid.plugin.CellEditing', {
							clicksToEdit: 1,
							listeners: {
								beforeedit: function() {
									return !me.readOnly;
								}
							}
						}),
						'gridclipboard'
					],
					tbar: [
						ksControls.GeneralDictBtn2 = Ext.create('Ext.Button', {
							iconCls: 'x_btn_add_element',
							key: 'add_element',
							tooltip: KS.L10n.RevizEditView_InitializeComponent_Выбрать,
							tooltipType: 'title',
							handler: function() {
								var sel = [],
									itms = ksControls.S_PERSON_GRID.store.data.items,
									len = itms.length,
									i = 0,
									dh = ksControls.DT.getValue();

								for (; i < len; i++) {
									sel.push({ data: { LINK: itms[i].data.S_PERSON } });
								}

								var orgLinks = ksControls.S_ORGP_Grid.store.getLinks();
								if (me.objs.S_ORG_EXT.isVisible()) {
									ArrayLib.addMissing(orgLinks, me.objs.S_ORG_EXT.getLinks());
								}
								var settings = {
										parentView: me.getKsControl('view', true, true),
										whereArgs: {
											SOrgs: {
												value: JSON.stringify(orgLinks),
												type: 'List_int'
											},
											DH1: {
												value: dh.dh1.toDateString(),
												type: 'Date'
											},
											DH2: {
												value: dh.dh2.toDateString(),
												type: 'Date'
											},
											SWork: {
												value: ksControls.S_WORK.getLink(),
												type: 'int'
											},
											HasFilterOnLoad: {
												value: 'False',
												type: 'bool'
											},
											RevOnly: {
												value: 'True',
												type: 'bool'
											}
										},
										selectLinks: sel,
										code: dnl.S_PERSON,
										inputDicts: [
											Ext.create('InputEditDict', {
												name: 'S_ORG',
												data: [ksControls.S_ORGP_Grid.store.getAt(0)]
											})
										],
										setRecord: function(row, cmp) {
											cmp.data.set(row);
											var newRec = cmp.data.data;
											var pos = ArrayLib.find(itms, ['data', 'S_PERSON'], newRec.LINK);

											if (pos !== -1) {
												itms[pos].data.S_PERSON = newRec.LINK;
												itms[pos].data.TEMP_SPERSON_CODE = newRec.CODE;
												itms[pos].data.TEMP_SPERSON_FIO = 
													window.getTextByVisibleFields(dnl.S_PERSON, _, newRec);
												itms[pos].data.TEMP_SPERSON_OTDEL = newRec.OTDELS;
												itms[pos].data.STATUS = itms.length === 1 ? ksData.revizorStatus.ruc : ksData.revizorStatus.member;
											}

											ksControls.S_PERSON_GRID.store.loadData(itms, true);
										}
									},
									functions = {
										ok: function(value) {
											var list = [],
												links = [],
												j = 0,
												store = ksControls.S_PERSON_GRID.store,
												sppd = [],
												DT = me.gksc('DT'),
												dtVal = DT.getValue();

											for (len = value.length; j < len; j++) {
												//не использовать get
												var personLink = value[j].data.LINK;
												links.push(personLink);
												if (ArrayLib.find(itms, ['data', 'S_PERSON'], personLink) === -1) {
													var link = me.sPersonLink--;
													list.push({
														S_PERSON: personLink,
														TEMP_SPERSON_CODE: value[j].data.CODE,
														TEMP_SPERSON_FIO: window.getTextByVisibleFields(dnl.S_PERSON, _, value[j].data),
														TEMP_SPERSON_OTDEL: value[j].data.OTDELS,
														STATUS: value.length === 1 ? ksData.revizorStatus.ruc : ksData.revizorStatus.member,
														TEMP_SPERSON_ORG: value[j].data.ORGS,
														LINK: link
													});
													sppd.push(link);
												}
											}

											var dels = [];
											for (j = 0, len = itms.length; j < len; j++) {
												if (ArrayLib.find(value, ['data', 'LINK'], itms[j].data.S_PERSON) === -1) {
													dels.push(itms[j]);
												}
											}

											store.remove(dels);
											store.loadData(list, true);
											//me.setProgPerson(store.data.items);
											me.refCostData();

											if (links.length) {
												me.getPersonsOut(links, function(val) {
													me.ksData.S_PERSON_OUT_DATA = val;
													me.fillPersonParts(links, false, !me.gksd('nastrRevizDuration'));
													//if (selected.length) me.personGridSelector(selected[0]);
												});
											} else {
												me.ksData.S_PERSON_PART_DATA = {};
												me.ksControls.S_PERSON_PART_GRID.store.removeAll();
												me.personGridSelector(null);

												if (!me.gksd('nastrRevizDuration')) {
													getCntDaysInPeriod(dtVal.dh1, dtVal.dh2, DT.getOrgP(), function(val) {
														DT.nbDays.setValue(val.workDays);
													});
												}
											}

											if (!ksControls.S_PERSON_GRID.getSelectionModel().getSelection().length) {
												ksControls.S_PERSON_GRID.extraSelectFrst();
											}
											me.enableToolsInnerGrid('S_PERSON_GRID');
										},

										close: function() {
											//зачем было нужно не понятно
											//var links = [],
											//	data = this.checkList;

											//for (var i = 0, len = data.length; i < len; i++) {
											//	links.push(data[i].get('LINK'));
											//}

											//me.getPersonsOut(links, function(val) {
											//	me.ksData.S_PERSON_OUT_DATA = val;
											//	me.fillPersonParts(links);
											//	if (selected.length) me.personGridSelector(selected[0]);
											//});

											//if (!links.length) {
											//	me.personGridSelector(null);
											//}
										}
									};
								dictFunc(settings, functions);
							}
						}),
						ksControls.GeneralDeleteBtn2 = Ext.create('Ext.Button', {
							key: 'delete',
							iconCls: 'x_btn_delete_element',
							tooltip: KS.L10n.RevizEditView_InitializeComponent_Удалить,
							tooltipType: 'title',
							disabled: true,
							handler: function() {
								ksControls.S_PERSON_GRID.removeSelection(function(rec) {
									delete me.ksData.S_PERSON_PART_DATA[rec.data.S_PERSON];
									me.personGridSelector(null);

									if (!me.gksd('nastrRevizDuration')) {
										if (ksControls.S_PERSON_GRID.store.data.items.length === 1) {
											var DT = me.gksc('DT'),
												dtVal = DT.getValue();

											getCntDaysInPeriod(dtVal.dh1, dtVal.dh2, DT.getOrgP(), function(val) {
												DT.nbDays.setValue(val.workDays);
											});
										} else {
											me.setDaysByRevizors();
										}
									}

									// Удаляем затраты по участнику
									let perCostList = ArrayLib.filter(ksData.PERSON_COST_DATA, ['T_REVIZ_SPERSON'],  rec.data.LINK);
									let j = 0;
									for (; j < perCostList.length; j++) {
										var pos = Ext.Array.indexOf(ksData.PERSON_COST_DATA, perCostList[j]);
										ksData.PERSON_COST_DATA.splice(pos, 1);
									}
								}, () => {
									me.enableToolsInnerGrid('S_PERSON_GRID');
									// Обновляем грид по затратам участников КМ
									me.refCostData();
								});
							}
						}),
						ksControls.GeneralCalcBtn = Ext.create('Ext.Button', {
							key: 'recalc',
							iconCls: 'x_btn_calcauto',
							tooltip: wmc.get('FillPersonsPart'),
							tooltipType: 'title',
							handler: function() {
								var grid = me.ksControls.S_PERSON_GRID,
									data = grid.store.getDataExt(),
									links = [];

								Ext.each(data, function(rec) {
									links.push(rec.S_PERSON);
								});

								if (links.length) {
									selectDialogShow(KS.L10n.RevizEditView_tsbAllInnerRecalc_Click_Участники, KS.L10n.RevizEditView_tsbAllInnerRecalc_Click_Пересоздать_периоды_участия_, function() {
										me.fillPersonParts(links, true, !me.gksd('nastrRevizDuration'));
									}, Ext.emptyFn);
								}
							}
						})
					],
					features: [
						{
							ftype: 'summary',
							showSummaryRow: false
						}
					],
					store: Ext.create('Ext.data.Store', {
						fields: [],
						data: [],
						proxy: 'memory'
					}),
					columnLines: true,
					columns: [],
					listeners: {
						select: function(t, record) {
							me.personGridSelector(record);
						},
						selectionchange: (_, sels) => me.enableToolsGrid(me.gksc('S_PERSON_GRID'), sels),
						render: function(grid) {
							let view = grid.getView();
							view.tip = Ext.create('Ext.tip.ToolTip', {
								shadow: false,
								target: view.getId(),
								delegate: view.itemSelector + ' .warningTdCls',
								trackMouse: true,
								listeners: {
									beforeshow: function updateTipBody(tip) {
										const tipGridView = tip.target.component,
											record = tipGridView.getRecord(tip.triggerElement);
										let message = record.get('TEMP_MESSAGE');
										if (!message) return false;
										tip.update(message);
									}
								}
							});
						},
					}
				})),
				{
					xtype: 'splitter',
					collapsible: true
				},
				me.sksc('S_PERSON_PART_GRID', Ext.create('Ext.grid.Panel', {
					flex: 2,
					userCls: 'rks-filter-panel',
					header: false,
					plugins: [
						Ext.create('Ext.grid.plugin.CellEditing', {
							clicksToEdit: 1,
							listeners: {
								beforeedit: function() {
									return !me.readOnly;
								}
							}
						}),
						'gridclipboard'
					],
					tbar: [
						me.sksc('GeneralNewBtn', Ext.create('Ext.Button', {
							key: 'new',
							iconCls: 'x_btn_new',
							tooltip: KS.L10n.RevizEditView_EnableRevizorNormPropTools_Создать_период_участия,
							tooltipType: 'title',
							disabled: true,
							handler: function() {
								var personGrid = ksControls.S_PERSON_GRID,
									sel = personGrid.getSelectionModel().getSelection(),
									personPartGrid = ksControls.S_PERSON_PART_GRID,
									partLen = personPartGrid.getStore().getDataExt().length,
									isError = false,
									org = me.gksc('DT').getOrgP();

								if (sel.length && partLen) {
									Ext.each(personPartGrid.store.data.items,
										function(i) {
											isError |= i.get('TEMP_MESSAGE');
										});
								}

								if (sel.length && partLen && !isError) {
									sel = sel[0];
									var dh = ksControls.DT.getValue(),
										MIN = dh.dh1,
										MAX = dh.dh2,
										partStore = personPartGrid.store,
										curPartData = partStore.getDataExt(),
										limit = curPartData.concat(me.ksData.S_PERSON_OUT_DATA[sel.get('S_PERSON')]);

									var e = me.getCorrectPeriod(limit, MIN, MAX);

									if (curPartData.length > 0 && e.DT1 === MIN && e.DT2 === MAX) {
										var minArr = [];
										Ext.each(limit, function(rec) {
											minArr.push(new Date(rec.DT1));
										});
										var minEl = new Date(PeriodLib.findMinData(minArr));
										e.DT1 = new Date(minEl.setDate(minEl.getDate() - 1));
										e.DT2 = e.DT1;
										e.TEMP_MESSAGE = KS.L10n.BaseRevizUpdController_Участник_отсутствует_в_период_участия;
										e.DAYS = 0;
									}

									var endFunc = function() {
										getCntDaysInPeriod(e.DT1, e.DT2, org, function(value) {
											var days = Ext.isNumber(value.workDays) ? value.workDays : 0,
												personData = me.ksData.S_PERSON_PART_DATA[sel.get('S_PERSON')],
												pos = ArrayLib.find(personData, ['LINK'], e.LINK),
												gridRecs = personPartGrid.store.data.items.filter(r => {
													return r.data.LINK === e.LINK;
												});

											personData[pos].DAYS = days;
											gridRecs[0].set('DAYS', days);
											
										me.refCostData();

										if (!me.gksd('nastrRevizDuration')) {
											me.setDaysByRevizors();
										}

										//me.personGridSelector(ksControls.S_PERSON_GRID.getSelectionModel().getSelection()[0]);
										}, Ext.emptyFn);
									};
									
									// добавим визуально новый период, а затем проверим его
									me.savePersonPartData(e, 'new');

									if (dh.dh1 > e.DT1 || dh.dh2 < e.DT2) {
										selectDialogShow(KS.L10n.attention, wmc.getString('ФИО: {0}. {1}', sel.get('TEMP_SPERSON_FIO'), wmc.getContinueQuestion(KS.L10n.RevizEditView_tsbAllInnerNew_Click_Период_участия_не_попадает_в_период_проведения_)),
											endFunc,
											function() {
												me.ksData.S_PERSON_PART_DATA[sel.get('S_PERSON')] =
													me.ksData.S_PERSON_PART_DATA[sel.get('S_PERSON')].filter(function(d) {
														return d.LINK !== e.LINK;
													});
												
												// если запись активировалась через редактирование ячейки, то remove(sels) не сработает
												var delRec = ksControls.S_PERSON_PART_GRID.store.data.items.filter(
													function(d) {
														return d.get('LINK') === e.LINK;
													})[0];
												ksControls.S_PERSON_PART_GRID.store.remove(delRec);
											});
									} else {
										endFunc();
								}
							}
							}
						})),
						{ xtype: 'tbseparator' },
						me.sksc('GeneralDeleteBtn3', Ext.create('Ext.Button', {
							key: 'delete',
							iconCls: 'x_btn_delete',
							tooltip: KS.L10n.RevizEditView_EnableRevizorNormPropTools_Удалить_период_участия,
							tooltipType: 'title',
							disabled:  true,
							handler: function() {
								var sels = ksControls.S_PERSON_PART_GRID.getSelectionModel().getSelection();
								if (sels.length && ksControls.S_PERSON_PART_GRID.getStore().getDataExt().length > 1) {
									selectDialogShow(KS.L10n.delete, KS.L10n.RevizEditView_tsbAllInnerDelete_Click_Удалить_период_участия_, function() {
										var person = ksControls.S_PERSON_GRID.getSelectionModel().getSelection()[0];
										if (person) {
											var oldData = me.ksData.S_PERSON_PART_DATA[person.get('S_PERSON')],
												pos = PeriodLib.findData(oldData, ['DT1'], sels[0].get('DT1'));

											if (pos !== -1) {
												me.ksData.S_PERSON_PART_DATA[person.get('S_PERSON')].splice(pos, 1);

												if (!me.gksd('nastrRevizDuration')) {
													me.setDaysByRevizors();
												}

												// если запись активировалась через редактирование ячейки, то remove(sels) не сработает
												var delRec = ksControls.S_PERSON_PART_GRID.store.data.items.filter(
													function(d) {
														return d.get('LINK') === sels[0].get('LINK');
													})[0];
												ksControls.S_PERSON_PART_GRID.store.remove(delRec);

												me.refCostData();
											}
										}
									});
								}
							}
						}))
					],
					features: [
						{
							ftype: 'summary',
							showSummaryRow: false
						}
					],
					store: Ext.create('Ext.data.Store', {
						fields: [],
						data: [],
						proxy: 'memory'
					}),
					listeners: {
						edit: function(editor, e) {
							var row = e.record,
								sel = ksControls.S_PERSON_GRID.getSelectionModel().getSelection()[0],
								dh = ksControls.DT.getValue(),
								org = me.gksc('DT').getOrgP();

							if (+e.originalValue !== +e.value) {

								var endFunc = function() {
									// todo: можно объединить обращение в базу getCntDaysInPeriod и setDaysByRevizors
									getCntDaysInPeriod(row.data.DT1, row.data.DT2, org, function(value) {
										row.set('DAYS', Ext.isNumber(value.workDays) ? value.workDays : 0);

										me.refCostData();
										me.savePersonPartData(row.data, 'edit');

										if (!me.gksd('nastrRevizDuration')) {
											me.setDaysByRevizors();
										}
									}, function() {
										row.set('DAYS', 0);
									});
								};

								if (dh.dh1 > row.data.DT1 || dh.dh2 < row.data.DT2) {
									selectDialogShow(KS.L10n.attention, wmc.getString('ФИО: {0}. {1}<br />', sel.get('TEMP_SPERSON_FIO'), wmc.getContinueQuestion(KS.L10n.RevizEditView_tsbAllInnerNew_Click_Период_участия_не_попадает_в_период_проведения_)), endFunc, function() {
										row.set(e.field, e.originalValue);
									});
								} else {
									endFunc();
								}
							}
						},
						selectionchange: (_, sels) => me.enableToolsGrid(me.gksc('S_PERSON_PART_GRID'), sels),
						render: function(grid) {
							let view = grid.getView();
							view.tip = Ext.create('Ext.tip.ToolTip', {
								shadow: false,
								target: view.getId(),
								delegate: view.itemSelector + ' .warningTdCls',
								trackMouse: true,
								listeners: {
									beforeshow: function updateTipBody(tip) {
										const tipGridView = tip.target.component,
											record = tipGridView.getRecord(tip.triggerElement);
										let message = record.get('TEMP_MESSAGE');
										if (!message) return false;
										tip.update(message);
									}
								}
							});
						},
					},
					columnLines: true,
					columns: []
				}))
			]
		}));
	},
	//конструктор таба Затраты
	createTabRNorm: function() {
		var me = this,
			ksControls = me.ksControls;

		return me.sksc('rNormPanel', Ext.create('Ext.panel.Panel', {
			title: 'Затраты',
			layout: { type: 'vbox', align: 'stretch' },
			border: 0,
			bodyBorder: false,			
			items: [
				me.sksc('REVIZ_COST_GRID', Ext.create('Ext.grid.Panel', {
					flex: 1,
					border: 0,
					plugins: [
						Ext.create('Ext.grid.plugin.CellEditing', {
							clicksToEdit: 1,
							listeners: {
								beforeedit: function() {
									return !me.readOnly;
								}
							}
						}),
						'gridclipboard'
					],
					tbar: [
						ksControls.GeneralDictBtn4 = Ext.create('Ext.Button', {
							key: 'add_element',
							iconCls: 'x_btn_add_element',
							tooltip: KS.L10n.RevizEditView_InitializeComponent_Выбрать,
							tooltipType: 'title',
							handler: function() {
								var sel = [],
									itms = ksControls.REVIZ_COST_GRID.store.data.items,
									i = 0,
									len = itms.length;

								for (; i < len; i++) {
									sel.push({
										data: {
											LINK: itms[i].data.S_RNORM,
											UNIT: itms[i].data.UNIT
										}
									});
								}

								var settings = {
										parentView: me.getKsControl('view', true, true),
										selectLinks: sel,
										code: dnl.S_RNORM
									},
									functions = {
										ok: function(value) {
											var list = [],
												dels = [],
												ksData = me.ksData,
												org = window.user.org;

											for (i = 0, len = value.length; i < len; i++) {
												var iPos = ArrayLib.find(itms, ['data', 'S_RNORM'], value[i].data.LINK);
												if (iPos === -1) {
													list.push({
														LINK: me.revizCostLink--,
														REVIZ: ksData.link,
														S_ORG: org && org.data && org.data.LINK,
														S_RNORM: value[i].data.LINK,
														TEMP_SRNORM_CODE: value[i].data.CODE,
														TEMP_SRNORM_NAME: value[i].data.NAME,
														DEFAULT_VAL: value[i].data.VAL,
														UNIT: value[i].data.UNIT,
														VAL: me.getCostVal(value[i])
													});
												}
											}

											for (i = 0, len = itms.length; i < len; i++) {
												var tmpList = ArrayLib.filter(ksData.PERSON_COST_DATA, ['REVIZCOST'], itms[i].data.LINK),
													j = 0,
													jLen = tmpList.length,
													pos1 = ArrayLib.find(value, ['data', 'LINK'], itms[i].data.S_RNORM);
												if (pos1 === -1) {
													dels.push(itms[i]);

													for (; j < jLen; j++) {
														var pos = Ext.Array.indexOf(ksData.PERSON_COST_DATA, tmpList[j]);
														ksData.PERSON_COST_DATA.splice(pos, 1);
													}
												} else {
													var f = true;
													for (; j < jLen; j++) {
														if (tmpList[j].VAL) {
															f = false;
															break;
														}
													}
													if (f) {
														itms[i].set('VAL', me.getCostVal(value[pos1]));
													}
												}
											}

											ksControls.REVIZ_COST_GRID.store.remove(dels);
											ksControls.REVIZ_COST_GRID.store.loadData(list, true);
											ksControls.REVIZ_COST_GRID.extraSelectFrst();

											me.enableToolsInnerGrid('REVIZ_COST_GRID');
										}
									};

								dictFunc(settings, functions);
							}
						}),
						ksControls.GeneralDeleteBtn4 = Ext.create('Ext.Button', {
							key: 'delete',
							iconCls: 'x_btn_delete_element',
							tooltip: KS.L10n.RevizEditView_InitializeComponent_Удалить,
							tooltipType: 'title',
							disabled: true,
							handler: function() {
								ksControls.REVIZ_COST_GRID.removeSelection(_, function () {
										if (ksControls.REVIZ_COST_GRID.store.getCount() === 0) {
											ksControls.PERSON_COST_GRID.store.loadData([]);
											ksControls.PERSON_COST_GRID.setTitle("");
										}
										ksControls.REVIZ_COST_GRID.extraSelectFrst();
										me.enableToolsInnerGrid('REVIZ_COST_GRID');
									});
							}
						}),
						ksControls.CalcNormsBtn = Ext.create('Ext.Button', {
							key: 'recalc',
							iconCls: 'x_btn_calcauto',
							tooltip: KS.L10n.RevizEditView_InitializeComponent_Пересчитать,
							tooltipType: 'title',
							handler: function() {
								selectDialogShow(KS.L10n.RevizEditView_tsbAllInnerRecalc_Click_Затраты, KS.L10n.RevizEditView_tsbAllInnerRecalc_Click_Пересчитать_затраты_с_учетом_периода_проведения_КМ_, function() {
									me.refCostData();
								}, Ext.emptyFn());
							}
						})
					],
					features: [
						{
							ftype: 'summary',
							showSummaryRow: false
						}
					],
					store: Ext.create('Ext.data.Store', {
						fields: [],
						data: [],
						proxy: 'memory'
					}),
					columnLines: true,
					columns: [],
					listeners: {
						select: function(t, record) {
							var rowCode = record.data.S_RNORM_CODE ? '[' + record.data.S_RNORM_CODE + '] ' : '';
							ksControls.PERSON_COST_GRID.setTitle(rowCode ? rowCode + record.data.S_RNORM_NAME : "");
							ksControls.PERSON_COST_GRID.store.loadData(me.generatePersonCostData(record), false);
						},
						selectionchange: (_, sels) => me.enableToolsGrid(me.gksc('REVIZ_COST_GRID'), sels)
					}
				})),
				{
					xtype: 'splitter',
					collapsible: true
				},
				me.sksc('PERSON_COST_GRID', Ext.create('Ext.grid.Panel', {
					flex: 1,
					//collapsible: true,
					plugins: [
						Ext.create('Ext.grid.plugin.CellEditing', {
							clicksToEdit: 1,
							listeners: {
								beforeedit: function() {
									return !me.readOnly;
								}
							}
						}),
						'gridclipboard'
					],
					features: [
						{
							ftype: 'summary',
							showSummaryRow: false
						}
					],
					store: Ext.create('Ext.data.Store', {
						fields: [],
						data: [],
						proxy: 'memory'
					}),
					listeners: {
						edit: function(editor, e) {
							//if (e.value === null) return _;
							var summ = 0;
							//Считаем новую сумму
							e.store.each(function(rec) {
								if (rec.data.VAL) {
									summ += rec.data.VAL;
								}
							});
							//Находим запись участника
							var oldVal = 0,
								pcd = ArrayLib.filter(me.ksData.PERSON_COST_DATA, ['REVIZCOST'], e.record.get('REVIZCOST')),
								iPos = ArrayLib.find(pcd, ['T_REVIZ_SPERSON'], e.record.get('T_REVIZ_SPERSON'));

							if (iPos !== -1) oldVal = pcd[iPos].VAL;
							//Ничего не трогаем если значение не изменилось
							if (e.value === oldVal) {
								return _;
							} else {
								selectDialogShow(KS.L10n.RevizEditView_gridNorms_AfterCellUpdate_Изменение_затрат, KS.L10n.RevizEditView_tsbAllInnerRecalc_Click_Пересчитать_затраты_с_учетом_периода_проведения_КМ_, function() {
									ksControls.REVIZ_COST_GRID.getFrstSelect().set('VAL', summ);
									//if (iPos !== -1) {
									//	iPos = Ext.Array.indexOf(ksData.PERSON_COST_DATA, pcd[iPos]);
									//	me.ksData.PERSON_COST_DATA.splice(iPos, 1);
									//}
								}, function() {
								});

								if (iPos === -1) {
									me.ksData.PERSON_COST_DATA.push({
										LINK: e.record.get('LINK'),
										REVIZCOST: e.record.get('REVIZCOST'),
										T_REVIZ_SPERSON: e.record.get('T_REVIZ_SPERSON'),
										VAL: e.record.get('VAL')
									});
								} else {
									pcd[iPos].VAL = e.record.get('VAL');
								}
							}
						}
					},
					columnLines: true,
					columns: []
				}))
			]
		}));
	},
	//конструктор таба Полномочий
	createTabAuthority: function() {
		var me = this,
			ksControls = me.ksControls;
		return me.sksc('authorityPanel', Ext.create('Ext.panel.Panel',
			{
				title: 'Полномочия',
				layout: { type: 'vbox', align: 'stretch' },
				border: 0,
				bodyBorder: false,
				items: [
					me.sksc('S_AUTHORITY_GRID',
						Ext.create('Ext.tree.Panel',
							{
								border: 0,
								flex: 1,
								tbar: [
									ksControls.GeneralDictBtn4 = Ext.create('Ext.Button', {
										iconCls: 'x_btn_add_element',
										key: 'add_element',
										tooltip: KS.L10n.RevizEditView_InitializeComponent_Выбрать,
										tooltipType: 'title',
										handler: function () {
											const oldData = [];
											me.gksc('S_AUTHORITY_GRID').getRootNode().cascade(node =>{if (!node.isRoot()) oldData.push(node.data)});
											const sel = oldData.map(r => {
												return {data: {LINK: r.LINK}}
											});
											const dh = me.gksc('DT').getValue();
											dictFunc({
												code: dnl.S_AUTHORITY,
												selectLinks: sel,
												whereArgs: {
													DH1: {
														value: dh.dh1.toDateString(),
														type: 'Date'
													},
													DH2: {
														value: dh.dh2.toDateString(),
														type: 'Date'
													}
												},
												setRecord: function (row, cmp) {
													cmp.data.set(row);
													const newRow = cmp.data.data;
													const rec = me.gksc('S_AUTHORITY_GRID').store.findNode('LINK', newRow.LINK);
													if (!rec) return;
													['CODE', 'NAME', 'DH1', 'DH2', 'DTCREATE', 'USERNAME', 'USERCHANGENAME', 'IDENTIFIER'].forEach(field => rec.data[field] = newRow[field]);
													me.gksc('S_AUTHORITY_GRID').view.refresh();
												}
											}, {
												ok: function (value) {
													value = value.map(v => v.data || v);

													const newLinks = value.map(v => v.LINK);
													const banAuthority = me.gksd('banAuthority');
													if (banAuthority.length) {
														let cancel = false;
														Ext.each(oldData, d => {
															if (newLinks.indexOf(d.LINK) === -1 && banAuthority.indexOf(d.LINK) !== -1) {
																cancel = true;
															}
														});
														if (cancel) {
															warning(KS.L10n.RevizEditView_tsbAllInnerAddElem_Click_Сначала_необходимо_разметить_полномочие_в_проверенном_факте_финансирования_);
															return;
														}
													}
													me.gksc('S_AUTHORITY_GRID').loadDataExt(value);													
												}
											});
										}
									}),
									ksControls.GeneralDeleteBtn4 = Ext.create('Ext.Button', {
										key: 'delete',
										iconCls: 'x_btn_delete_element',
										tooltip: KS.L10n.RevizEditView_InitializeComponent_Удалить,
										tooltipType: 'title',
										disabled: true,
										handler: function() {
											var selLink = me.gksc('S_AUTHORITY_GRID').getFrstSelect().get("LINK");
											if (me.gksd('banAuthority').indexOf(selLink) !== -1) {
												warning(KS.L10n.RevizEditView_tsbAllInnerAddElem_Click_Сначала_необходимо_разметить_полномочие_в_проверенном_факте_финансирования_);
											}
											else {
												me.gksc('S_AUTHORITY_GRID').removeSelection();
											}
										}
									})
								],
								features: [
									{
										ftype: 'summary',
										showSummaryRow: false
									}
								],
								rootVisible: false,
								store: Ext.create('Ext.data.TreeStore',
									{
										fields: [],
										proxy: 'memory',
										defaultRootText: '',
										rootNode: { expanded: true, children: [] },
										sorters: ['CODE'],
									}),
								columnLines: true,
								lines: true,
								rowLines: true,
								columns: [],
								listeners: {
									selectionchange: (_, sels) => me.enableToolsGrid(me.gksc('S_AUTHORITY_GRID'), sels)
								},
								plugins: ['gridclipboard']
							}))
				]
			}));
	},
	
	//Создание грида "Проверяющие"
	getRevizObjsDict: function() {
		var me = this,
			ksControls = me.ksControls,
			ksData = me.ksData;

		return me.gksc('revizObjs_Dict') ||
			Ext.create('Keysystems.Base.List', {
				tabMode: true,
				closable: false,
				code: dnl.REVIZ,
				parentView: ksControls.revizObjs_Panel,
				GateCode: 'edit',
				profileKey: 'tRevizObjectsColumns',
				selectLinks: [],
				mode: window.isRfn ? 'SINGL' : 'MULTI',
				head: false,
				mainColumn: true,
				hidePagging: true,
				hideTBar: true,
				hideMsg: true,
				pageSize: 1000,
				mainColumnEditable: false,
				checkModelChange: Ext.emptyFn,
				checkListeners: {
					beforecheckchange: function(th, rowIndex, checked) {
						var selectedOrgP = ksControls.S_ORGP_Grid.selModel.getSelection().length > 0,
							lock = !window.isRfn && ksControls.S_ORGP_Grid.selOrg === ksControls.S_ORGP_Grid.lockOrg;

						return selectedOrgP && ((checked === true && lock) || !lock);
					},
					checkchange: function(th, rowIndex, checked, record) {
						if (!me.isVisible()) return;

						var grid = ksControls.S_ORGP_Grid,
							old = ksData.tRevizAudit,
							res = ArrayLib.copy(old),
							onlyOrgs = ArrayLib.filter(res, ['S_ORG'], grid.selOrg),
							selectedOrgLink = ksControls.S_ORGP_Grid.selModel.getSelection()[0].get('LINK'),
							filterByOrgC = old.filter(function(d) {
								return d.S_ORG === selectedOrgLink;
							}),
							checkPos = ArrayLib.find(filterByOrgC, ['T_REVIZ_OBJECTS'], record.get('LINK'));

						if (checked && checkPos === -1) {
							res.push({
								LINK: me.tRevizAuditLink--,
								S_ORG: grid.selOrg,
								MAIN: record.get('MAIN'),
								T_REVIZ_OBJECTS: record.get('LINK')
							});
						} else {
							if (checked && checkPos !== -1) return;
							var del = ArrayLib.filter(onlyOrgs, ['T_REVIZ_OBJECTS'], record.get('LINK'))[0];
							if (!del) return;
							var pos = Ext.Array.indexOf(res, del);
							if (pos === -1) return;
							res.splice(pos, 1);
						}

						me.sksd('tRevizAudit', res);
						me.gksc('objsPanel').eventTRAEdit(res, old);

						// разметим проверяющую, если у нее не осталось объектов
						if (ArrayLib.find(res, ['S_ORG'], selectedOrgLink) === -1) {
							grid.store.remove(grid.getStore().data.items.filter(function(d) {
								return d.get('LINK') === selectedOrgLink;
							}));
						}
					}
				},
				checkRenderer: function(val, meta) {
					if (!window.isRfn && ksControls.S_ORGP_Grid.selOrg === ksControls.S_ORGP_Grid.lockOrg) meta.tdCls += ' ' + this.disabledCls;
				},
				functions: {
					getData: function(endFunc, cfg) {
						var frst = (cfg.page - 1) * cfg.pageSize,
							lst = frst + cfg.pageSize,
							data = me.getRevizObjsDictData();

						loadProfile({
							code: 'DOCUMENT_REVIZ',
							prefix: 'reviz',
							gateCode: 'edit',
							profileKey: 'tRevizObjectsColumns',
							callBack: function() {
								endFunc({
									columns: ksData.tRevizObjectsColumns,
									fields: ksData.tRevizObjectsFields,
									data: {
										data: data.slice(frst, lst),
										total: data.length
									}
								});
							}
						});
					},
					refresh: function(endFunc, cfg) {
						var frst = (cfg.page - 1) * cfg.pageSize,
							lst = frst + cfg.pageSize,
							data = me.getRevizObjsDictData();

						endFunc({
							data: data.slice(frst, lst),
							total: data.length
						});

						me.orgPSelector(ksControls.S_ORGP_Grid.getFrstSelect());
					}
				}
			});
	},
	
	getRevizObjsDictData: function() {
		let me = this,
			tRevizObjects = me.gksd('tRevizObjects'),
			data = ArrayLib.filter(tRevizObjects, ['LINK_SELF'], null);

		data.forEach(r => {
			let rowChild = tRevizObjects.filter(c => c.LINK_SELF === r.LINK)[0];
			if (rowChild != null) r.TEMP_SNAME = rowChild.TEMP_NAME;
		});
		return data;
	},
	
	//селектор грида "Участники"
	personGridSelector: function(record) {
		var me = this,
			ksControls = me.ksControls,
			personPartData = me.ksData.S_PERSON_PART_DATA,
			personPartGrid = ksControls.S_PERSON_PART_GRID,
			btnNew = personPartGrid.getToolbarItem('new');

		if (!(record && record.data)) {
			personPartGrid.store.loadData([]);
			personPartGrid.setTitle("");
			btnNew && btnNew.setDisabled(true);
			return false;
		}

		var rowCode = record.get('TEMP_SPERSON_CODE') ? '[' + record.get('TEMP_SPERSON_CODE') + '] ' : '';

		personPartGrid.setTitle(rowCode + record.get('TEMP_SPERSON_FIO'));
		btnNew && btnNew.setDisabled(false);

		if (!personPartData[record.get('S_PERSON')]) {
			var dh = ksControls.DT.getValue(),
				org = me.gksc('DT').getOrgP();

			getCntDaysInPeriod(dh.dh1, dh.dh2, org, function(value) {
				personPartData[record.get('S_PERSON')] = [
					{
						DT1: dh.dh1,
						DT2: dh.dh2,
						DAYS: value.workDays,						
						TEMP_MESSAGE: null,
						LINK: me.personPartLink--
					}
				];
				personPartGrid.store.loadData(personPartData[record.get('S_PERSON')], false);
			});
		} else {
			personPartGrid.store.loadData(personPartData[record.get('S_PERSON')], false);
			//Нужно для того, чтобы данные были в формате Date, а не yyyy/mm/dd
			personPartData[record.get('S_PERSON')] = personPartGrid.store.getDataExt();
			//me.checkErrorParts([record.get('S_PERSON]);
		}
	},
	afterCancelLoad: function(){
		const me = this;
		me.ownerCt.saveChanges = false;
		me.ownerCt.isExit = true;
		me.ownerCt.objs.view.close();
	},
	initLoadingMaskCfg: function() {
		return this.ownerCt.initLoadingMaskCfg();
	},
	//#endregion Создание компонентов

	//#region Загрузка данных 

	/*loadCopyEditData: function() {
		var me = this,
			ksControls = me.ksControls;

		if (me.data) {
			var data = me.data.data;
			ksControls.DOCOSNOVNUMBER.setValue(data.DOCOSNOVNUMBER);
			ksControls.DOCOSNOVDT.setValue(data.DOCOSNOVDT);
		}
	},*/
	setExtra: function(value) {
		var me = this,
			extosnovData = [],
			extobjectsData = [],
			objsPanel = me.gksc('objsPanel'),
			S_ORGP_Grid = me.gksc('S_ORGP_Grid'),
			i,
			len;

		me.ownerCt.setExtra.call(me, value);		
		me.sksd('decimalData', value.decimalData);
		me.sksd('PLANREVIZ', value.PLANREVIZ);
		me.sksd('ORDER_LINK', value.ORDER_LINK);
		me.sksd('linksAppeals', value.linksAppeals);
		me.sksd('initLinksAppeals', value.linksAppeals);
		me.sksd('duration', value.duration);
		me.gksc('DT').nbDays.setValue(value.durationWork);
		//Обработка кнопки план
		me.sksd('planBtnState', value.isPlan);
		me.gksc('DT').setValue(new Date(value.dt1), new Date(value.dt2));

		me.sksd('reviewNar', value.reviewNar);
		me.sksd('isOtdelHide', value.isOtdelHide);
		me.sksd('onlyParent', +value.onlyParent);

		//#region Настройки объектов
		me.sksd('RevizOneMain', value.RevizOneMain);
		me.sksd('RevizObjType', value.RevizObjType);
		me.sksd('Individ', value.Individ);
		me.sksd('isNewWithoutObjects', value.isNewWithoutObjects);
		//#endregion Настройки объектов


		//Настройка - Плановое основание
		me.sksd('sRosnovPlan', value.sRosnovPlan);

		//Если из обращения или поручения
		me.sksd('sRosnovInLinks', value.sRosnovInLinks);

		//В случае создания из плана
		me.sksd('sRosnovWhereArgs', value.sRosnovWhereArgs);
		me.sksd('sWorkWhereArgs', value.sWorkWhereArgs);
		me.gksc('S_WORK').setValue(value.sWork);
		me.gksc('S_ROSNOV').ksSetValue(value.sRosnov);
		me.sksd('sWork', me.gksc('S_WORK').getLink());

		//Может ли поле "от" быть пустым
		me.sksd('AllowDtNull', value.AllowDtNull);
		//формула автозаполнения для поля "От"
		me.sksd('AutoFillDt', value.AutoFillDt);
		//Уникальность номера в пределах года
		me.sksd('NumberUnique', value.NumberUnique);

		//Номер ИКМ
		me.gksc('NUMBERIKM').setValue(value.NUMBERIKM);
		me.sksd('AutoNumberIKM', value.AutoNumberIKM);
		me.sksd('NumberIKMUniq', true);
		me.sksd('CheckIkmUnique', value.CheckIkmUnique);
		
		//доступ к полям
		me.setFullObjsAccess(value.isAccess, ['NUMBER', 'DT0', 'S_OTDEL', 'S_ORG_EXT', 'EXTOBJECTS', 'EXTOSNOV', 'NUMBERIKM']);
		me.gksc('objsPanel').isType = value.RevObjTypeAccess;
		
		//Ответственный исполнитель
		me.objs.S_OTDEL.setValue(value.sOtdel);
		me.objs.S_OTDEL.setFieldLabel(me.titleSOtdel = window.isRfn ? 'Ответственный исполнитель' : 'Подразделение');

		if (me.f === 'new') {
			//залоченная проверяющая организация
			S_ORGP_Grid.lockOrg = window.user.org.data.LINK;
			S_ORGP_Grid.lockRecord = value.orgC[0];
		}

		//Привлекаемые организации
		me.gksc('S_ORG_EXT').setValue(value.S_ORG_EXT);

		me.sksd('RevizSelf', value.RevizSelf);
		me.gksc('NUMBER').setValue(value.number);
		me.gksc('DT0').setValue(value.dt ? new Date(value.dt) : '');

		value.isDTMoneyHide ? me.gksc('DTMONEY').hide() : me.gksc('DTMONEY').setValue(new Date(value.dtmoney1), new Date(value.dtmoney2));
		me.sksd('lockOrgList', value.lockOrgList);
		S_ORGP_Grid.store.loadData(value.orgC);
		window.addRowNumbererClm(S_ORGP_Grid, S_ORGP_Grid.config.columns);
		Ext.create('Keysystems.Controls.Grid.ColumnManager',
			{
				inputColumns: S_ORGP_Grid.config.columns.slice(),
				code: me.code,
				profileKey: 'S_ORGP_Grid',
				gateCode: me.keyEdit,
				grid: S_ORGP_Grid
			});

		//залоченная проверяющая организация
		var checkLockFn = function(link) {
			if (Ext.Array.indexOf(me.gksd('lockOrgList'), link) !== -1) {
				if (ArrayLib.filter(me.gksd('tRevizAudit'), ['S_ORG'], link).length === ArrayLib.filter(me.gksd('tRevizObjects'), ['LINK_SELF'], null).length) {
					S_ORGP_Grid.lockOrg = link;
					S_ORGP_Grid.lockRecord = ArrayLib.filter(value.orgC, ['LINK'], link)[0];
					return true;
				}
			}
			return false;
		};

		if (!checkLockFn(window.user.org.data.LINK)) {
			for (i = 0, len = me.gksd('tRevizAudit').length; i < len; i++) {
				if (checkLockFn(me.gksd('tRevizAudit')[i].S_ORG)) break;
			}
		}

		me.sksd('tRevizObjectsColumns', value.tRevizObjectsColumns);
		me.sksd('tRevizObjectsFields', value.tRevizObjectsFields);
		me.sksc('revizObjs_Dict', me.getRevizObjsDict());
		me.gksc('revizObjs_Dict').refresh();

		me.sksd('nastrRevizDuration', value.nastrRevizDuration);

		me.sksd('access', value.access);
		me.setAccessStore(value.access);

		//#region Участники
		if (value.isRevizors) {
			me.gksc('t1').changeTab(me.getTab('Revizors'), true);
			me.sksd('S_PERSON_OUT_DATA', value.sPerson.outData);
			me.sksd('S_PERSON_PART_DATA', value.sPersonPart.data);

			//#region S_PERSON_PART_GRID			
			let colsPersonPart = value.sPersonPart.columns;
			if (colsPersonPart) {
				const colMessagePart = colsPersonPart.filter(col => col.dataIndex === "TEMP_MESSAGE")[0];
				if (colMessagePart) colMessagePart.hidden = true;

				if (ArrayLib.find(colsPersonPart, ['dataIndex'], 'IMG_MESSAGE') === -1) {
					colsPersonPart.unshift({
						xtype: 'actionimg',
						dataIndex: 'IMG_MESSAGE',
						imgHandler: function (grid, rec) {
							if (rec.get('TEMP_MESSAGE')) {
								warning(rec.get('TEMP_MESSAGE'));
							}
						},
						getClass: function (v, meta, rec) {
							return rec.get('TEMP_MESSAGE') ? 'x_btn_warning' : '';
						},
						tdCls: 'warningTdCls',
						index: -1
					});
				}
			}

			me.gksc('S_PERSON_PART_GRID').setMetaDate(value.sPersonPart, {
				profileCode: me.code,
				profileKey: 'S_PERSON_PART_GRID',
				gateCode: me.keyEdit
			});
			//#endregion S_PERSON_PART_GRID

			var revizorStatus = me.gksd('revizorStatus');
			var statusStore = [];
			for (let rs in revizorStatus) {
				statusStore.push(revizorStatus[rs]);
			}

			//#region S_PERSON_GRID
			const colMessage = value.sPerson.columns.filter(col=>col.dataIndex === "TEMP_MESSAGE")[0];
			if (colMessage) colMessage.hidden = true;
			
			var pos = ArrayLib.find(value.sPerson.columns, ['dataIndex'], 'STATUS');
			if (pos !== -1) {
				value.sPerson.columns[pos].editor = {
					editable: false,
					store: statusStore,
					xtype: 'combo',
					listeners: {
						beforeselect: function(th, rec) {
							if (rec.data.field1 === me.gksd('revizorStatus').ruc) {
								var f = true,
									sel = me.gksc('S_PERSON_GRID').getSelectionModel().getSelection()[0];

								if (sel) {
									me.gksc('S_PERSON_GRID').store.each(function(rec1) {
										if (rec1 !== sel && rec1.data.STATUS === me.gksd('revizorStatus').ruc) {
											f = false;
											return false;
										}
										return true;
									});

									if (!f) {
										warning(KS.L10n.BaseRevizUpdController_В_мероприятии_не_может_быть_больше_одного_руководителя_);
										return false;
									}
								}
							}
							return true;
						}
					}
				};
			}

			if (ArrayLib.find(value.sPerson.columns, ['dataIndex'], 'IMG_MESSAGE') === -1) {
				value.sPerson.columns.unshift({
					xtype: 'actionimg',
					dataIndex: 'IMG_MESSAGE',
					imgHandler: function(grid, rec) {
						if (rec.get('TEMP_MESSAGE')) {
							warning(rec.get('TEMP_MESSAGE'));
						}
					},
					text: ' ',
					getClass: function(v, meta, rec) {
						return rec.get('TEMP_MESSAGE') ? 'x_btn_warning' : '';
					},
					tdCls: 'warningTdCls',
					index: -1
				});
			}

			me.gksc('S_PERSON_GRID').setMetaDate(value.sPerson, {
				profileCode: me.code,
				profileKey: 'S_PERSON_GRID',
				gateCode: me.keyEdit
			});
			me.enableToolsInnerGrid('S_PERSON_GRID');
			
			//#endregion S_PERSON_GRID

			var sPersonLinks = [];
			for (var sPersonLink in me.gksd('S_PERSON_PART_DATA')) {
				sPersonLinks.push(sPersonLink * 1);
			}

			me.checkErrorParts(sPersonLinks);
			extraSelect(me.gksc('S_PERSON_GRID').store.getAt(0), me.gksc('S_PERSON_GRID'));
		}
		//#endregion Участники

		// на случай если поменяли настройку
		if (!me.gksd('nastrRevizDuration') && me.gksc('S_PERSON_GRID') && me.gksc('S_PERSON_GRID').getStore().getDataExt().length) {
			me.setDaysByRevizors();
		} else {
			getCntDaysInPeriod(new Date(value.dt1), new Date(value.dt2), me.gksc('DT').getOrgP(),
				function(val) {
					var nbDays = me.gksc('DT').nbDays,
						disabled = nbDays.disabled;
					// затычка, чтобы не вызывать событие изменения
					nbDays.disabled = true;
					me.gksc('DT').nbDays.setValue(val.workDays);
					nbDays.disabled = disabled;
				});
		}

		me.gksc('DT').nbDays.setDisabled(!me.gksd('nastrRevizDuration'));

		// Полномочия
		if (value.isAuthority) {
			me.gksc('t1').changeTab(me.getTab('Authority'), true);
			var S_AUTHORITY_GRID = me.gksc('S_AUTHORITY_GRID');
			me.sksd('AUTHORITY_DATA', value.sAuthority.data);

			if (!value.sAuthority.fields.filter(f=>f.name==='id')[0])
				value.sAuthority.fields.push('id');
			if (!value.sAuthority.fields.filter(f=>f.name==='tree')[0])
				value.sAuthority.fields.push('tree');
			if (!value.sAuthority.columns.filter(c=>c.dataIndex === 'tree')[0]) {
				value.sAuthority.columns.unshift(me.getTreeColumnCfg());
			}

			S_AUTHORITY_GRID.setMetaDate(value.sAuthority,
				{
					profileCode: me.code,
					profileKey: 'S_AUTHORITY_GRID',
					gateCode: me.keyEdit
				},
				true);			
			extraSelect(S_AUTHORITY_GRID.store.getAt(0), S_AUTHORITY_GRID);
		}

		//Затраты
		if (value.isRNorm) {
			me.gksc('t1').changeTab(me.getTab('RNorm'), true);

			var PERSON_COST_GRID = me.gksc('PERSON_COST_GRID'),
				REVIZ_COST_GRID = me.gksc('REVIZ_COST_GRID');

			me.sksd('PERSON_COST_DATA', value.personCost.data);

			PERSON_COST_GRID.setMetaDate(value.personCost, {
				profileCode: me.code,
				profileKey: 'PERSON_COST_GRID',
				gateCode: me.keyEdit
			});

			let col = ArrayLib.filter(value.revizCost.columns, ['dataIndex'], 'VAL')[0];
			if (col) {
				col.editor = {
					xtype: 'calcfield',
					fieldLabel: '',
					decimalData: me.gksd('decimalData'),
					getValue: function () {
						return this.rawToValue(this.processRawValue(this.getRawValue()));
					}
				};
			}

			REVIZ_COST_GRID.setMetaDate(value.revizCost, {
				profileCode: me.code,
				profileKey: 'REVIZ_COST_GRID',
				gateCode: me.keyEdit
			});
			extraSelect(REVIZ_COST_GRID.store.getAt(0), REVIZ_COST_GRID);
			me.enableToolsInnerGrid('REVIZ_COST_GRID');
		}

		//Реквизиты
		if (value.isProps) {
			me.propWithMask = value.prop.data.filter(function(d) {
				return d.MASK;
			});
			var pp = me.getTab('Prop'),
				props = value.prop;

			if (me.gksd('isProps')) {
				pp.loadData(props.data);
			} else {
				//Признак того что уже создали панель
				me.sksd('isProps', true);
				pp.loadData(props);
			}

			me.gksc('t1').changeTab(pp, true);
		}

		//Реквизиты объекта
		if (value.isObjProp) {
			me.sksd('isObjProp', value.isObjProp);
			me.sksd('objProp', value.objProp);
		}

		extraSelect(S_ORGP_Grid.store.getAt(0), S_ORGP_Grid);
		
		me.gksc('docOsnov').refresh();
		
		for (i = 0, len = value.extosnovList.length; i < len; i++) {
			extosnovData.push([value.extosnovList[i]]);
		}

		me.gksc('EXTOSNOV').store.loadData(extosnovData, true);
		me.gksc('EXTOSNOV').setValue(value.extosnov);

		for (i = 0, len = value.extobjectsList.length; i < len; i++) {
			extobjectsData.push([value.extobjectsList[i]]);
		}

		me.gksc('EXTOBJECTS').store.loadData(extobjectsData, true);
		me.gksc('EXTOBJECTS').setValue(value.extobjects);

		if (value.tempPlan.length) {
			me.gksc('TEMP_PLAN_NAME').setValue(value.tempPlan[0].PPLAN);
		}

		var rList = [],
			reportFn = function(th) {
				me.printReport(th.text, th.reportCode);
			};

		for (var key in value.ReportsReviz) {
			rList.push({
				reportCode: key,
				text: value.ReportsReviz[key],
				handler: reportFn
			});
		}

		me.isObjsDataChanging = true;
		objsPanel.setObjsData(value.tRevizObjsAccess, value.type, value.orgWhereArgs);
		me.isObjsDataChanging = false;

		me.sksd('planObjsLinks', value.planObjsLinks);
		me.gksd('isActual').General = true;

		if (value.mainRevizData) {
			me.mainRevizAudit = value.mainRevizAudit;
			me.gksc('mainReviz').setVisible(true);
			me.gksc('mainReviz').setValue(value.mainRevizData);
		}
		
		me.sksd('banAuthority', value.banAuthority);
		me.sksd('changeProgDT', false);

		me.setKsReadOnly(me.ownerCt.ksReadOnly);
	},

	getExtra: function(endFunc) {
		this.ownerCt.getExtra.call(this, endFunc);
	},

	getExtraNew: function(endFunc) {
		var me = this;
		me.getKsControl('STATUS', true, true).setValue(0);
		me.getExtra(endFunc);
	},
	
	setKsReadOnly: function(v) {
		let me = this,
			res = me.callParent(arguments);

		me.gksc('objsPanel')?.setReadOnly(v);
		if (v || !me.ksData.access) return;

		if ((me.ksData.access.revizorsGridAccess & ObjAccessMask.EDIT) === 0) {
			me.gksc('S_PERSON_GRID')?.setReadOnly(true);
			me.gksc('S_PERSON_GRID')?.getToolbar().items.items.forEach(item=>item.setDisabled(true));
			me.gksc('S_PERSON_PART_GRID')?.setReadOnly(true);
		}

		if ((me.ksData.access.rNormGridAccess & ObjAccessMask.EDIT) === 0) {
			me.gksc('REVIZ_COST_GRID')?.setReadOnly(true);
			me.gksc('REVIZ_COST_GRID')?.getToolbar().items.items.forEach(item=>item.setDisabled(true));
		}

		if ((me.ksData.access.authorityGridAccess & ObjAccessMask.EDIT) === 0) {
			me.gksc('S_AUTHORITY_GRID')?.setReadOnly(true);
			me.gksc('S_AUTHORITY_GRID')?.getToolbar().items.items.forEach(item=>item.setDisabled(true));
		}
		
		if ((me.ksData.access.propGridAccess & ObjAccessMask.EDIT) === 0) {
			me.gksc('tabProp')?.setReadOnly(true);
		}
		return res;
	},
	//#endregion Загрузка данных 

	//#region Проверки, события
	//Скрытие\отображение пункта плана
	setTempNameVisible: function(state) {
		var me = this;

		me.gksc('TEMP_PLAN_NAME').setVisible(state);
	},
	checkObjectsForReviz: function(vals, type) {
		if (!vals || !vals.length || this.isLoaded) return;
		var me = this,
			ksControls = me.ksControls,
			ksData = me.ksData,
			linkSelf = me.data ? me.data.data.LINK_SELF : ksData.linkSelf;

		if (linkSelf && (type === ksData.RevizObjType.ДЛ || type === ksData.RevizObjType.ИП)) return; //todo узнать зачем реализовано в вине
		var audits = [],
			tRevizObjects = [];

		for (var i = 0, len = ksData.tRevizAudit.length; i < len; i++) {
			audits.push(ksData.tRevizAudit[i].S_ORG);
		}
		for (i = 0, len = vals.length; i < len; i++) {
			tRevizObjects.push(vals[i].data ? vals[i].data.LINK : vals[i].LINK);
		}

		ajaxRequest({
			ignoreError: true,
			url: 'SReviz/CheckObjectsForReviz_A',
			timeout: 5000,
			params: {
				link: ksData.link,
				dt: ksControls.DT.getValue(1),
				audits: audits,
				tRevizObjects: tRevizObjects,
				type: type
			},
			success: function(value) {
				if (value) {
					var timerId = setInterval(function() {
						if (!Ext.Msg.isVisible()) {
							warning(value.replace('\r', '<br>'));
							clearInterval(timerId);
						}
					}, 2000);

					//В случае если пользователь тупит больше минуты то чистим интервал
					setTimeout(function() {
						clearInterval(timerId);
					}, 10000);
				}
			}
		});
	},

	changeObjProp: function(orgVals, personVals, oldVals, type) {
		if (!this.gksd('isObjProp')) return;

		var me = this,
			objProp = me.gksd('objProp'),
			revizObjType = me.gksd('RevizObjType'),
			newOrgLinks = [],
			newPersonLinks = [],
			oldOrgLinks = [],
			oldPersonLinks = [];

		if (type === revizObjType.ФЛ) {
			personVals = orgVals;
			orgVals = [];
		}

		if (orgVals === _ && (type === revizObjType.ИП || type === revizObjType.ДЛ)) {
			orgVals = me.gksc('objsPanel')[type === revizObjType.ИП ? 'ИП_S_ORGC' : 'ДЛ_S_ORGC'].getValue();
		}

		Ext.each(orgVals, function(v) { newOrgLinks.push(v.data.LINK); });
		if (personVals) {
			Ext.each(personVals, function(v) { newPersonLinks.push(v.data.LINK); })
		}

		Ext.each(oldVals,
			function(v) {
				if (v.TTABLE === 'S_ORG') {
					oldOrgLinks.push(v.TLINK);
				}
				if (v.TTABLE === 'S_PERSON') {
					oldPersonLinks.push(v.TLINK);
				}
			});

		if (!me.isLoaded && ArrayLib.equal(newOrgLinks, oldOrgLinks) && ArrayLib.equal(newPersonLinks, oldPersonLinks)) return;

		var propVsbl = (newOrgLinks.length || newPersonLinks.length) && type !== revizObjType.НПА &&
			(objProp.personProp && (type === revizObjType.ФЛ || type === revizObjType.ИП) ||
				objProp.orgProp && (type === revizObjType.ЮЛ || type === revizObjType.ДЛ || type === revizObjType.ИП));

		me.gksc('t1').changeTab(me.getTab('ObjPropGrid'), propVsbl);

		if (propVsbl) {
			if (!me.isLoaded || me.getLink() === 0) {
				var orgDiff = newOrgLinks.filter(function (l) { return oldOrgLinks.indexOf(l) === -1; });
				var personDiff = newPersonLinks.filter(function (l) { return oldPersonLinks.indexOf(l) === -1; });
				if (orgDiff.length || personDiff.length) {
					// если отметили новые объекты
					var selectedProps = [];
					if (me.gksc('ObjPropGrid')) {
						Ext.each(me.gksc('ObjPropGrid').getStore().getDataExt(),
							function(d) {
								if (d.CHECKED) {
									selectedProps.push(d.LINK);
								}
							});
					}
					
					ajaxRequest({
						url: 'SDocPlan/GetObejctProps_A',
						params: {
							orgLinks: JSON.stringify(newOrgLinks),
							personLinks: JSON.stringify(newPersonLinks),
							selectedProps: JSON.stringify(selectedProps)
						},
						success: function(value) {
							var objPropGrid = me.gksc('ObjPropGrid');

							objProp.mainData = value.mainData;
							objProp.data = value.data;
							if (me.getLink() === 0) {
								objPropGrid.setAdaptedFields(value.fields);
								objPropGrid.setColumns(value.columns);
							}
							objPropGrid.setGroupsForData(value.data, value.mainData);
						}
					});
				} else {
					// если разметили существующие
					objProp.mainData = objProp.mainData.filter(function(d) {
						var dataType = d.LINK.split('_')[1],
							link = +d.LINK.split('_')[2];
						return dataType === 'ORG' ? newOrgLinks.indexOf(link) !== -1 : newPersonLinks.indexOf(link) !== -1;
					});
					objProp.data = me.gksc('ObjPropGrid').getStore().getDataExt().filter(function(d) {
						var dataType = d.OBJECTS.split('_')[1],
							link = +d.OBJECTS.split('_')[2];
						return dataType === 'ORG' ? newOrgLinks.indexOf(link) !== -1 : newPersonLinks.indexOf(link) !== -1;
					});
					me.gksc('ObjPropGrid').setGroupsForData(objProp.data, objProp.mainData);
				}

			} else {
				var objPropGrid = me.gksc('ObjPropGrid');

				objPropGrid.setAdaptedFields(objProp.fields);
				objPropGrid.setColumns(objProp.columns);
				objPropGrid.setGroupsForData(objProp.data, objProp.mainData);

			}
		} else {
			objProp.mainData = objProp.data = [];
			me.gksc('ObjPropGrid').setGroupsForData(objProp.data, objProp.mainData);
		}
	},

	//проверка на то существует ли мероприятие с таким же кодом и датой
	checkNumDate: function(callBack, key) {
		var me = this,
			ksData = me.ksData,
			key = key || 'NUMBER',
			ksControls = me.ksControls,
			num = me.gksc(key).getValue(),
			dt = ksControls.DT.getValue();

		//Не проверяем уже сохраенное мероприятие
		if (ksData.link <= 0 || (JSON.parse(me.oldData))[key] !== num) {
			ajaxRequest({
				url: (me.linkCode + '/IsRevizNumberUnique_A'),
				ignoreError: true,
				params: {
					link: ksData.link,
					num: num,
					dt: dt.dh2.toDateString(),
					numberkey: key,
					vfa: me.isVfa
				},
				success: function(val) {
					if (key === 'NUMBER' && val) {
						info(wmc.get('RevizExist', num, dt.dh2.getFullYear()));
					} else if (!val) {
						info(wmc.getString(KS.L10n.RevizEditView_CheckSave_Мероприятие_с_номером_ИКМ___0___уже_присутствует_, num));
					}

					me.sksd('NumberIKMUniq', val);
					callBack && callBack();
				}
			});
		} else {
			callBack();
		}
	},
	//

	/** Проверка, можно ли сменить объект
	 * @param {string} controlName Тип изменяемого объекта
	 * @param {object} value Массив линков для объектов верхнего уровня
	 * @param {bool} silent 'Тихий' режим (без вывода предупреждения)
	 * @param {object} valueChild Массив линков для дочерних объектов
	 * @return {bool}
	 */
	canChangeObjects: function(controlName, value, silent, valueChild) {
		if (this.isLoaded || this.isObjsDataChanging || this.gksd('isNewWithoutObjects'))
			return true;

		let me = this,
			revizObjType = me.ksData.RevizObjType,
			objType = revizObjType[controlName],
			oldAllObjs = me.ksData.tRevizObjects,
			oldObjs = ArrayLib.filter(oldAllObjs, ['TYPE'], objType),
			newObjs = value ? value.map(v => v.data || v) : [];

		//линки основных объектов (до изменения)
		let oldMainLinks = ArrayLib.getLinks(oldObjs.filter(r => r.MAIN && !r.LINK_SELF), ['TLINK']);
		//линки основных объектов (измененные)
		let newMainLinks = ArrayLib.getLinks(ArrayLib.filter(newObjs, ['MAIN'], true), ['LINK']);

		if (me.ksData.RevizOneMain) {
			let validOneMain = newMainLinks.length <= 1;
			if (newMainLinks.length === 1) {
				let otherMainObjs = ArrayLib.getLinks(oldAllObjs.filter(r => r.MAIN && !r.LINK_SELF && r.TYPE !== objType));
				if (otherMainObjs.length > 0) {
					validOneMain = false;
				}
			}
			if (!validOneMain) {
				if (!silent) warning(wmc.get('RevizOneMain'));
				return false;
			}
		}

		if (me.gksd('PLANREVIZ')) {
			let valid = ArrayLib.equal(oldMainLinks, newMainLinks);

			//для СП доп логика, связанная с дочерними объектами (для ДЛ и ИП в вине она не используется)
			if (valid && controlName === 'СП' && valueChild) {
				let newChildObjs = valueChild.map(v => v.data || v);
				//перебираем основные объекты, смотрим изменились ли дочерние
				oldMainLinks.forEach(link => {
					//дочерние объекты (до изменения)
					let oldChildLinks =
						ArrayLib.getLinks(ArrayLib.filter(oldObjs, ['TLINK_SELF'], link), ['TLINK']);
					//дочерние объекты (измененные)
					let newChildLinks =
						ArrayLib.getLinks(ArrayLib.filter(newChildObjs, ['TLINK_SELF'], link), ['LINK']);
					if (!ArrayLib.equal(oldChildLinks, newChildLinks)) {
						valid = false;
						
					}

				});
			}

			if (!valid) {
				if (!silent) warning('Основной объект изменять нельзя!');
				return false;
			}
		}
		return true;
	},
	//Определяем состояние кнопки плана
	isPlan: function(link) {
		let me = this;

		me.showLoadMask({
			msg: KS.L10n.updating_data,
			rid: ajaxRequest({
				url: 'SRosnov/IsPlan_A',
				timeout: 5000,
				params: { link: link },
				success: function(value) {
					me.isVisible() && me.changePlanBtnState(value);
				},
				callback: function() {
					me.hideLoadMask();
				}
			})
		});
	},
	//Меняем состояние кнопки плана
	changePlanBtnState: function(state) {
		var me = this,
			isPlan = false,
			planBtn = me.gksc('PLAN_BTN'),
			txt = '',
			readOnly = false,
			menu1 = planBtn.menu.items.items[0];

		if (state) {
			me.sksd('planBtnState', state);
			let icon = 'x_btn_' + state;
			
			switch (state) {
				case 'appeals':
					const hasAppeals = me.gksd('linksAppeals')?.length > 0;
					planBtn.setReadOnly(readOnly = !hasAppeals);
					if (!hasAppeals) icon += "_grey";
					txt += 'Привязать обращение';
					break;
				case 'orders':
					planBtn.setReadOnly(readOnly = !me.gksd('ORDER_LINK'));
					if (!me.gksd('ORDER_LINK')) icon += "_grey";
					txt += 'Отвязать поручение';
					break;
				default:
					isPlan = true;
					planBtn.setReadOnly(readOnly = !me.gksd('PLANREVIZ'));
					if (!me.gksd('PLANREVIZ')) icon += "_grey";
					txt += 'Открыть';
			}
			planBtn.setIconCls(icon);
		}

		planBtn.setArrowVisible(!readOnly);
		if (planBtn.getEl()) {
			//ширина кнопки варьируется в зависимости от того, отображаем стрелку для выпадающего списка или нет
			//в динамике выравниваем в dom
			let btnWidth = +planBtn.getEl().getStyle('width');
			if (!btnWidth) btnWidth = readOnly ? 22 : (window.Theme === 'crisp' ? 34 : 40);			
			planBtn.getEl().setStyle('left', (me.labelWidth - btnWidth) + 'px');
		}		
		planBtn.setVisible(!!state);
		menu1.setText(txt);
		me.setTempNameVisible(isPlan && !readOnly);

	},
	//вызов окна редактирования
	editFn: function(link, editCls, cfg) {
		var me = this;
		Ext.create(editCls, {
			f: cfg?.f ?? 'edit',
			data: {
				data: {
					LINK: link,
					REVIZ: me.getLink()
				}
			},
			successSaveFunc: function(result, endFunc, params) {
				if (result.SavedLink) {
					me.sksd('PLANREVIZ', result.SavedLink);
					me.gksc('TEMP_PLAN_NAME').setValue(params.PPLAN);
				}

				this.callParent(arguments);
				me.changePlanBtnState('plan');
			}
		});
	},
	//Есть ли документ основания
	isDocOsnov: function(link, endFunc) {
		ajaxRequest({
			url: 'SReviz/IsDocOsnov_A',
			timeout: 5000,
			params: { link: link },
			success: function(value) {
				if (value && endFunc) {
					endFunc(value);
				}
			}
		});
	},
	//Обновление данных грида проверяющие
	updSOrgPDataByRevizObjs: function() {
		var ksControls = this.ksControls;

		ksControls.revizObjs_Dict.refresh();
		var sels = ksControls.S_ORGP_Grid.selModel.getSelection();
		ksControls.S_ORGP_Grid.selModel.deselectAll();
		ksControls.S_ORGP_Grid.selModel.select(sels);
	},
	//Пересчет реквизитов
	calculateProp: function() {
		var me = this,
			parentView = me.parentView,
			sel = me.propPanel.getSelectionModel().getSelection(),
			newData = parentView.dataCollector(),
			data = parentView.oldData !== JSON.stringify(newData) ? newData : '',
			calcFn = function(links) {
				parentView.showLoadMask({
					msg: 'Пересчёт реквизитов...',
					rid: ajaxRequest({
						url: 'SCalc/FillPropByMask_A',
						params: {
							code: parentView.code,
							link: me.parentView.ksData.link,
							data: SignalR.pack(data),
							sProps: JSON.stringify(links)
						},
						success: function(result) {
							if (result) {
								for (var key in result) {
									if (result[key] !== '') {
										var rec = me.propPanel.store.getRecord(key);
										if (rec) {
											var val = result[key],
												isDict = false;
											switch (miscTypes.CalcType[rec.data.TEMP_SPROP_TYPE]) {
												case 'Флаг':
													val = val.toLowerCase();
													break;
												case 'Список':
													var list = rec.get('LIST').split('\r\n');
													val = list[val];
													break;
												case 'Справочник':
													isDict = true;
													break;
											}
											if (isDict) {
												rec.set('VAL', val ? val.LINK : '');
												rec.set('VAL_CODE', val ?val.CODE : '');
												rec.set('VAL_NAME', val ?val.NAME : '');
											} else {
												rec.set('VAL', val);
											}

											me.propPanel.view.refresh();
										}
									}
								}
							}
						},
						failure: function() {
							warning('Ошибка при пересчете реквизитов');
						},
						callback: function() {
							parentView.hideLoadMask();
						}
					})
				});
			};

		if (sel.length) {
			Ext.Msg.show({
				title: KS.L10n.RevizEditView_tsbAllInnerRecalc_Click_Реквизиты,
				buttons: Ext.MessageBox.YESNOCANCEL,
				buttonText: { yes: 'Да', no: 'Текущий', cancel: 'Нет' },
				msg: KS.L10n.RevizEditView_tsbAllInnerRecalc_Click_Пересчитать_реквизиты_,
				fn: function(buttonId) {
					if (buttonId === 'yes') {
						const links = me.propPanel.getStore().getDataExt().map(r => r.S_PROP);
						calcFn(links);
					}
					if (buttonId === 'no') {
						calcFn([sel[0].get('S_PROP')]);
					}
				},
				icon: Ext.MessageBox.QUESTION
			});
		}
	},
	//Disable компонента документ основания
	/*setDocOsnovDisable: function(state) {
		this.gksc('DOCOSNOVNUMBER').setDisabled(state);
		this.gksc('DOCOSNOVDT').setDisabled(state);
		this.gksc('DOCOSNOV_BTN').setDisabled(state);
	},*/
	//Изменить объект в запланированном
	synchronizePlanObject: function(newLinks) {
		var me = this;
		me.showLoadMask({
			msg: KS.L10n.updating_data,
			rid: ajaxRequest({
				url: 'SReviz/SynchronizePlanObject_A',
				params: { gzipData: SignalR.pack(me.dataCollector()) },
				success: function() {
					me.sksd('planObjsLinks', newLinks);
				},
				failure: function() {
					showError(wmc.get('ErrorGetData'));
				},
				callback: function() {
					me.hideLoadMask();
				}
			})
		});
	},
	//Проверить дату мероприятия
	checkDT: function(dt) {
		var me = this,
			ksControls = me.ksControls,
			ksData = me.ksData;
		ajaxRequest({
			url: 'SReviz/CheckDT_A',
			params: {
				link: ksData.link,
				dt: dt,
				dtPrd: ksControls.DT.getValue(1),
				dt0: ksControls.DT0.getValue()
			},
			success: function(value) {
				ksControls.imgOutDt.setTooltip(value);
				ksControls.imgOutDt.setVisible(value);
			}
		});
	},
	//Проверить объект контроля
	checkObjectsHistoryChange: function() {
		var me = this,
			ksControls = me.ksControls,
			ksData = me.ksData;
		ajaxRequest({
			url: 'SReviz/CheckObjectsHistChange_A',
			params: {
				link: ksData.link,
				typeObj: ksControls.objsPanel.visibleObjs,
				linksIP: Ext.Array.contains(ksControls.objsPanel.visibleObjs, 'ИП')
					? ksControls.objsPanel.ИП_S_ORGC.getLinks() : [],
				linksUL: Ext.Array.contains(ksControls.objsPanel.visibleObjs, 'ЮЛ')
					? ksControls.objsPanel.ЮЛ_S_ORGC.getLinks() : [],
				linksDL: Ext.Array.contains(ksControls.objsPanel.visibleObjs, 'ДЛ')
					? ksControls.objsPanel.ДЛ_S_ORGC.getLinks() : []
			},
			success: function(value) {
				ksControls.imgHistoryChange.setTooltip(value);
				ksControls.imgHistoryChange.setVisible(value);
			}
		});
	},

	//#endregion Проверки, события

	//#region Периоды участия
	//Найти все периоды участия, которые не сходятся с периодами отсутствия
	checkErrorParts: function(sPersonLinks) {
		var me = this,
			ksControls = me.ksControls,
			partData = me.ksData.S_PERSON_PART_DATA,
			outData = me.ksData.S_PERSON_OUT_DATA,
			dh = ksControls.DT.getValue(),
			MIN = dh.dh1,
			MAX = dh.dh2;

		for (var i = 0, len = sPersonLinks.length; i < len; i++) {
			var sPerson = sPersonLinks[i],
				outPeriod = outData[sPerson],
				partPeriod = partData[sPerson];

			for (var j = 0, lenn = partPeriod.length; j < lenn; j++) {
				partPeriod[j].DT1 = new Date(partPeriod[j].DT1);
				partPeriod[j].DT2 = new Date(partPeriod[j].DT2);

				if (MIN > partPeriod[j].DT1 || MAX < partPeriod[j].DT2) {
					partPeriod[j].TEMP_MESSAGE = KS.L10n.BaseRevizUpdController_Период_участия_не_попадает_в_период_проведения_;
					continue;
				}

				let bad = false;
				Ext.each(outPeriod, function(out) {
					if (PeriodLib.getPeriodsCross(partPeriod[j], out, 'DT', true)) {
						bad = true;
						return false;
					}
				});
				partPeriod[j].TEMP_MESSAGE = bad ? KS.L10n.BaseRevizUpdController_Участник_отсутствует_в_период_участия : '';
			}
		}

		var selPerson = ksControls.S_PERSON_GRID.getSelectionModel().getSelection()[0];
		if (selPerson) me.personGridSelector(selPerson);
	},
	//Пересоздать все периоды участия в зависимости от периодов отсутствия. если required=true не смотрим на старые partData
	fillPersonParts: function(sPersonLinks, required, calcDays) {
		var me = this,
			ksControls = me.ksControls,
			ksData = me.ksData,
			partData = ksData.S_PERSON_PART_DATA,
			outData = ksData.S_PERSON_OUT_DATA,
			newPartData = {},
			dh = ksControls.DT.getValue(),
			MIN = dh.dh1,
			MAX = dh.dh2;

		for (var key in outData) {
			outData[key] = outData[key].filter(function(d) {
				var dt1 = new Date(d.DT1),
					dt2 = new Date(d.DT2);

				// персекается ли пероид отсутствия с периодом проведения
				return dt2 >= MIN && dt1 <= MAX;
			});
		}

		for (var i = 0, len = sPersonLinks.length; i < len; i++) {
			var link = sPersonLinks[i];

			if (!required && partData[link]) {
				newPartData[link] = partData[link];
			} else {
				var correctPeriod = me.getCorrectPeriod(outData[link], MIN, MAX),
					limit = outData[link].concat(correctPeriod),
					corrPeriods = [];

				if (!(MIN > correctPeriod.DT1 || MAX < correctPeriod.DT2)) {
					corrPeriods.push(correctPeriod);

					while (PeriodLib.getPeriodsCross(correctPeriod, { DT1: MIN, DT2: MAX }, 'DT')) {
						correctPeriod = me.getCorrectPeriod(limit, MIN, MAX);
						if (MIN > correctPeriod.DT1 || (MIN === correctPeriod.DT1 && MAX === correctPeriod.DT2)) break;
						corrPeriods.push(correctPeriod);
						limit = outData[link].concat(corrPeriods);
					}
				}

				newPartData[link] = corrPeriods;
			}
		}

		var org = me.gksc('DT').getOrgP();
		getCntDaysInPeriodMany(JSON.stringify(newPartData),
			org,
			function(value) {
				for (var key in value) {
					Ext.each(value[key],
						function(v) {
							v.DT1 = new Date(v.DT1);
							v.DT2 = new Date(v.DT2);
						});
				}

				ksData.S_PERSON_PART_DATA = value;

				var persGrid = ksControls.S_PERSON_GRID,
					persGridSel = persGrid.getSelectionModel().getSelection();

				me.personGridSelector((persGridSel.length ? persGridSel : null || persGrid.store.data.items)[0]);

				if (calcDays) {
					me.setDaysByRevizors();
				}
			});
	},
	//Подсчет периодов участия, учитывая период отсутствия. limit - массив с ограничениями (уже созданные периоды или периоды отсутствия)
	getCorrectPeriod: function(limit, MIN, MAX) {
		var minArr = [],
			maxArr = [];

		minArr.push(MIN);
		maxArr.push(MAX);
		Ext.each(limit, function(rec) {
			var d = rec.DT1;
			minArr.push(new Date(d));
			d = rec.DT2;
			maxArr.push(new Date(d));
		});

		var period = PeriodLib.findMinMaxPeriod(minArr, maxArr, MAX, MIN),
			min = period.min,
			max = period.max,
			e = { DAYS: 0, TEMP_MESSAGE: null };

		if ((Ext.Date.isEqual(min, MIN) && Ext.Date.isEqual(max, MAX) && limit.length > 0) || (max < MIN) || (min < MIN)) {
			var minEl = new Date(PeriodLib.findMinData(minArr));
			e.DT1 = new Date(minEl.setDate(minEl.getDate() - 1));
			e.DT2 = e.DT1;
		} else {
			e.DT1 = min > max ? PeriodLib.findMinData(minArr) : min;
			e.DT2 = max > MAX ? MAX : max;
		}

		if (min < MIN && max === MAX || limit.length === 0) {
			e.DT1 = MIN;
			e.DT2 = MAX;
		}
		e.LINK = this.personPartLink--;
		return e;
	},
	//Получить все актуальные периоды участия по линкам
	getPersonsOut: function(links, endFunc) {
		let me = this;
		if (links && links.length) {
			me.showLoadMask({
				msg: KS.L10n.updating_data,
				rid: ajaxRequest({
					url: 'SPerson/GetSPersonsOut_A',
					params: { links: links },
					success: function(value) {
						me.hideLoadMask();
						if (value && endFunc) endFunc(value);
					},
					failure: function() {
						me.hideLoadMask();
					}
				})
			});
		} else {
			if (endFunc) endFunc([]);
		}
	},
	//Сохранение периода участия
	savePersonPartData: function(data, f) {
		var me = this,
			ksControls = me.ksControls,
			sel = ksControls.S_PERSON_GRID.getSelectionModel().getSelection();

		if (sel.length) {
			//Проверку убрали в вине. Если надо - вернем
			var oldData = me.ksData.S_PERSON_PART_DATA[sel[0].data.LINK],
				personOutDate = sel[0].data.PERSON_OUT;

			if (personOutDate) {
				for (var i = 0, len = personOutDate.length; i < len; i++) {
					if (PeriodLib.getPeriodsCross(newData, personOutDate[i], 'DT', true)) {
						selectDialogShow(KS.L10n.attention, wmc.getQuestion('OutLimitPeriod', sel[0].data.NAME, personOutDate[i].REASON), function() {
							me.ksData.S_PERSON_PART_DATA[sel[0].data.LINK] = [newData];
							me.checkErrorParts();
						}, function() {
							ksControls.S_PERSON_PART_GRID.store.loadData(oldData);
						});
						break;
					}
				}
			}

			var sPersonLink = sel[0].get('S_PERSON');
			oldData = me.ksData.S_PERSON_PART_DATA[sPersonLink];
			var pos = PeriodLib.findData(oldData, ['DT1'], data.DT1);

			if (f === 'new') {
				oldData.push(data);
			} else {
				if (pos < 0) pos = PeriodLib.findData(oldData, ['DT2'], data.DT2);
				oldData[pos] = data;
			}

			me.checkErrorParts([sPersonLink]);
		}
	},

	calcByRevizors: function() {
		var me = this;

		return !me.gksd('nastrRevizDuration') && Object.keys(me.gksd('S_PERSON_PART_DATA')).length;
	},

	setDaysByRevizors: function() {
		var me = this,
			personPartData = me.gksd('S_PERSON_PART_DATA'),
			partData = [],
			org = me.gksc('DT').getOrgP();

		// отсортируем и не учитваем периоды, где DT1 > DT2
		for (var key in personPartData) {
			Ext.each(personPartData[key],
				function(d) {
					if (d.DT1 < d.DT2) partData.push({ DT1: d.DT1, DT2: d.DT2 })
				});
		}

		partData.sort(function(p1, p2) {
			return p1.DT1 - p2.DT1;
		});

		ajaxRequest({
			url: 'SReviz/GetDaysByRevizors_A',
			params: {
				periods: JSON.stringify(partData),
				sOrg: org
			},
			success: function(value) {
				me.gksc('DT').nbDays.setValue(value.workDays);
			}
		});
	},

	//#endregion Периоды участия

	//#region Затраты
	getCostVal: function(val, field) {
		var ksControls = this.ksControls,
			ksData = this.ksData;

		if (!field) field = 'VAL';
		switch (+val.data.UNIT) {
			case 1: //руб/чел
			case 'руб/чел':
				return val.data[field] * ksControls.S_PERSON_GRID.store.data.items.length;
			case 2: //руб/чел.дн
			case 'руб/чел.дн':
				var count = 0;
				ksControls.S_PERSON_GRID.store.each(function(rec) {
					var d = ksData.S_PERSON_PART_DATA[rec.data.S_PERSON];
					if (d) {
						for (var k = 0, kLen = d.length; k < kLen; k++) {
							var d1 = d[k].data ? d[k].data.DT1 : d[k].DT1,
								d2 = d[k].data ? d[k].data.DT2 : d[k].DT2;
							count += Math.ceil((new Date(d2) - new Date(d1)) / (1000 * 60 * 60 * 24)) + 1;
						}
					}
				});
				return val.data[field] * count;
			default:
				//case 0: //руб
				return val.data[field];
		}
	},
	refCostData: function() {
		var me = this,
			ksControls = me.ksControls;

		if (ksControls.REVIZ_COST_GRID) {
			ksControls.REVIZ_COST_GRID.store.each(function(rec) {
				rec.set('VAL', me.getCostVal(rec, 'DEFAULT_VAL'));
			});

			var sel = ksControls.REVIZ_COST_GRID.getSelectionModel().getSelection();

			if (sel.length) {
				ksControls.PERSON_COST_GRID.store.loadData(me.generatePersonCostData(sel[0]), false);
			}
		}

	},
	generatePersonCostData: function(rec) {
		var me = this,
			result = [],
			data = ArrayLib.filter(me.ksData.PERSON_COST_DATA, ['REVIZCOST'], rec.data.LINK);

		me.ksControls.S_PERSON_GRID.store.each(function(persRow) {
			var row1 = {
					CODE: persRow.data.TEMP_SPERSON_CODE,
					NAME: persRow.data.TEMP_SPERSON_FIO,
					T_REVIZ_SPERSON: persRow.data.LINK,
					REVIZCOST: rec.data.LINK
				},
				pos = ArrayLib.find(data, ['T_REVIZ_SPERSON'], persRow.data.LINK);
			if (pos !== -1) {
				row1.LINK = data[pos].LINK;
				row1.VAL = data[pos].VAL;
			}
			result.push(row1);
		});

		return result;
	},
	//#endregion Затраты

	//#region Сохранение данных

	setLink: function(link){
		this.ownerCt.setLink(link);
	},
	dataCollector: function() {
		var me = this,
			objsPanel = me.gksc('objsPanel'),
			ksControls = me.ksControls,
			ksData = me.ksData,
			res = me.ownerCt.dataCollector({});

		res.NUMBER = ksControls.NUMBER.getValue();
		res.NUMBERIKM = ksControls.NUMBERIKM.getValue();
		res.T_REVIZ_AUDIT = JSON.stringify(ksData.tRevizAudit);
		res.T_REVIZ_OBJECTS = JSON.stringify(ksData.tRevizObjects);

		res.S_ORG_EXT = me.gksc('S_ORG_EXT').getLinks();

		var dt = ksControls.DT0.getValue();
		res.DT = dt ? dt.toDateString() : "";

		res.EXTOSNOV = ksControls.EXTOSNOV.getValue();
		res.EXTOBJECTS = ksControls.EXTOBJECTS.getValue();

		res.durationWork = me.gksc('DT').nbDays.getValue();

		if (objsPanel.items.length) {
			res.TYPEORG = (objsPanel.ЮЛ && !objsPanel.ЮЛ.isHidden()) ? 1 : 0;
			if (objsPanel.ИП && !objsPanel.ИП.isHidden()) res.TYPEORG += 2;
			if (objsPanel.ФЛ && !objsPanel.ФЛ.isHidden()) res.TYPEORG += 4;
			if (objsPanel.ДЛ && !objsPanel.ДЛ.isHidden()) res.TYPEORG += 8;
			if (objsPanel.НПА && !objsPanel.НПА.isHidden()) res.TYPEORG += 16;
			if (objsPanel.КК && !objsPanel.КК.isHidden()) res.TYPEORG += 32;
			if (objsPanel.СП && !objsPanel.СП.isHidden()) res.TYPEORG += 64;
			if (objsPanel.ЗУ && !objsPanel.ЗУ.isHidden()) res.TYPEORG += 128;
		} else {
			res.TYPEORG = 1;
		}

		/*res.DOCOSNOVNUMBER = ksControls.DOCOSNOVNUMBER.getValue();
		res.DOCOSNOVDT = ksControls.DOCOSNOVDT.getValue();*/

		if (!ksControls.DTMONEY.isHidden()) {
			dt = ksControls.DTMONEY.getValue();
			res.DTMONEY1 = dt.dh1.toDateString();
			res.DTMONEY2 = dt.dh2.toDateString();
		}

		res.S_WORK = ksControls.S_WORK.getLink();
		ksData.S_ROSNOV = res.S_ROSNOV = ksControls.S_ROSNOV.getLink();
		res.S_OTDEL = me.objs.S_OTDEL.getLink();

		res.DOCOSNOVFILE = ksControls.DOCOSNOVFILE;
		res.DOCOSNOV = ksControls.DOCOSNOV;

		if (ksControls.S_AUTHORITY_GRID) {
			var sAuthorityData = [];
			ksControls.S_AUTHORITY_GRID.store.each(function (rec) {
				sAuthorityData.push({
					S_AUTHORITY: rec.data.LINK
				});
			});
			res.S_AUTHORITY = JSON.stringify(sAuthorityData.sort((a, b) => a.S_AUTHORITY - b.S_AUTHORITY));
		}

		var sPersonData = [];

		if (ksControls.S_PERSON_GRID) {
			ksControls.S_PERSON_GRID.store.each(function(rec) {
				sPersonData.push({
					LINK: rec.data.LINK,
					S_PERSON: rec.data.S_PERSON,
					STATUS: rec.data.STATUS
				});
			});
		}
		res.S_PERSON = JSON.stringify(sPersonData);

		var sPersonPartData = [],
			data = me.ksData.S_PERSON_PART_DATA;

		for (var ls in data) {
			var pos = ArrayLib.find(sPersonData, ['S_PERSON'], ls);
			if (pos === -1) continue;
			for (var i = 0, len = data[ls].length; i < len; i++) {
				sPersonPartData.push({
					LINK: data[ls][i].LINK || data[ls][i].data.LINK,
					DT1: new Date(data[ls][i].DT1 || data[ls][i].data.DT1).toDateString(),
					DT2: new Date(data[ls][i].DT2 || data[ls][i].data.DT2).toDateString(),
					tRevizPerson: sPersonData[pos].LINK
				});
			}
		}

		res.S_PERSONPART = JSON.stringify(sPersonPartData);

		var revizCost = [];
		if (ksControls.REVIZ_COST_GRID) {
			ksControls.REVIZ_COST_GRID.store.each(function(rec) {
				revizCost.push({
					LINK: rec.data.LINK,
					S_RNORM: rec.data.S_RNORM,
					VAL: rec.data.VAL,
					TEMP_SRNORM_CODE: rec.data.TEMP_SRNORM_CODE,
					TEMP_SRNORM_NAME: rec.data.TEMP_SRNORM_NAME
				});
			});
		}

		res.REVIZCOST = JSON.stringify(revizCost);

		var pcd = [];
		if (ksData.PERSON_COST_DATA) {
			for (i = 0, len = ksData.PERSON_COST_DATA.length; i < len; i++) {
				if (ArrayLib.find(revizCost, ['LINK'], ksData.PERSON_COST_DATA[i].REVIZCOST) !== -1) {
					pcd.push(ksData.PERSON_COST_DATA[i]);
				}
			}
		}
		res.PERSONCOST = JSON.stringify(pcd);

		if (me.gksd('isProps')) {
			res.prop = me.getTab('Prop').getData(1);
		}

		if (me.gksd('isObjProp')) {
			var objProps = {};
			if (me.gksc('ObjPropGrid')) {
				Ext.each(me.gksc('ObjPropGrid').getStore().getDataExt(),
					function(d) {
						if (d.CHECKED) objProps[d.LINK] = d.ORG_PERSON;
					});
			}
			res.objProps = JSON.stringify(objProps);
		}

		res.PLANREVIZ = me.LinkPlanReviz || me.gksd('PLANREVIZ');
		res.ORDER_LINK = me.gksd('ORDER_LINK');
		res.APPEALS = me.gksd('linksAppeals');

		res.tab = me.tabKey;
		res.infoLinks = res.link > 0 ? [] : res.infoLinks;
		res.changeProgDT = me.gksd('changeProgDT');
		return res;
	},
	//Возвращает количество главных объектов в мероприятие
	thereMainObj: function() {
		var me = this,
			ksData = me.ksData,
			main = 0,
			tros = ArrayLib.filter(ksData.tRevizObjects, ['LINK_SELF'], null);

		for (var i = 0, len = tros.length; i < len; i++) {
			if (tros[i].MAIN) {
				main++;
			}

		}

		return main;
	},
	isFilled: function() {
		var me = this,
			ksControls = me.ksControls,
			ksData = me.ksData;

		let res = true;
		if (!ksData.AllowDtNull && !ksControls.DT0.getValue()) {
			me.addToInvalidControls(ksControls.DT0, {title: 'Дата мероприятия'});
			res = false;
		}
		
		if (!me.gksd('tRevizObjects').length) {
			me.addToInvalidControls(ksControls.objsPanel, {title: 'Объект контроля'});
			res = false;
		}
		
		if (ksControls.S_WORK.isEmpty()) {
			me.addToInvalidControls(ksControls.S_WORK);
			res = false;
		}

		if (ksControls.S_ROSNOV.isEmpty()) {
			me.addToInvalidControls(ksControls.S_ROSNOV, {title: 'Основание'});
			res = false;
		}

		if (ksControls.DT.isEmpty()) {
			me.addToInvalidControls(ksControls.DT, {title: 'Период_проведения'});
			res = false;
		}

		var dh = ksControls.DT.getValue();
		if (dh.dh1 > dh.dh2) {
			me.errorMessages.push(KS.L10n.RevizEditView_CheckSave_Дата_начала_периода_не_может_быть_больше_даты_окончания_);
		}

		if (ksControls.DTMONEY.isVisible()) {
			dh = ksControls.DTMONEY.getValue();
			if (dh.dh1 > dh.dh2) {
				me.errorMessages.push(wmc.get('CheckingPeriodStartMoreThenEnd'));
			}
		}

		if (ksControls.S_PERSON_GRID) {
			var persons = ksControls.S_PERSON_GRID.store.getDataExt(),
				ruc = true;

			if (persons.length) {
				ruc = ArrayLib.find(persons, ['STATUS'], ksData.revizorStatus.ruc) !== -1;
			}

            var warnings = [];
            if (!ruc)
                warnings.push(window.isRfn ? KS.l10n.BaseRevizUpdController_CheckRevizorRuk_Не_выбран_руководитель_проверочной_группы_ : KS.L10n.BaseRevizUpdController_CheckRevizorRuk_Не_выбран_руководитель_);

            //предупреждающий контроль по периодам отсутствия
			//в текущей реализации на стороне сервера этот контроль отрабатывает некорректно, поскольку является блокирующим
			//для реализации его не серверной стороне CheckSave надо выносить из методов сохранения (возможно реализуем в дальнейшем)
            persons.forEach(person=>{
            	let rowsOut = ksData.S_PERSON_OUT_DATA ? ksData.S_PERSON_OUT_DATA[person.S_PERSON] : null;
            	if (!rowsOut) return false;
            	
				let rowsPart = ksData.S_PERSON_PART_DATA ? ksData.S_PERSON_PART_DATA[person.S_PERSON] : null;
				 if (rowsPart && rowsPart.length) {
				 	//есть период участия, проверим периоды участия на пересечение с периодами отсутствия					 
					 rowsPart.forEach(rowPart => {
						var rowOut = rowsOut.filter(r => PeriodLib.getPeriodsCross(rowPart, r, 'DT', true));
					 	if (rowOut.length) {
							 warnings.push(wmc.get('OutLimitPeriod', person.TEMP_SPERSON_FIO, rowOut[0].TEMP_SREASON_NAME || ''), '');
						 }
					 });					 
				 }
				 else{
					 //нет периода участия, проверим период проведения на пересечение с периодами отсутствия
					 let dt = ksControls.DT.getValue();
					 var rowOut = dt ? rowsOut.filter(r => PeriodLib.getPeriodsCross({DT1:dt.dh1, DT2:dt.dh2}, r, 'DT', true)) : null;
					 if (rowOut.length) {
						 warnings.push(wmc.get('OutLimitPeriod', person.TEMP_SPERSON_FIO, rowOut[0].TEMP_SREASON_NAME || ''), '');
					 }					 
				 }
			});           

			if (warnings.length) {				
				warnings = warnings.filter(w=>w!=="").map(w=>w.replace(/Продолжить\??/,''));
				//склеиваем предпреждения с переводом строки
				//.join('<br \>')//+ '<br />Продолжить?';
				me.warningMessages = me.warningMessages.concat(warnings);
			}
		}

		// Для КМ с Видом работ Рассмотрение, контроль на заполнение отключаем
		var isReviewNar = me.gksd('reviewNar') && me.gksd('reviewNar') === ksControls.S_WORK.getLink();
		if (!me.gksd('isOtdelHide') && !me.objs.S_OTDEL.getLinks().length && !isReviewNar) {
			me.addToInvalidControls(me.objs.S_OTDEL);
			res = false;
		}

		var ikm = me.gksc('NUMBERIKM');
		if (ikm && ikm.isVisible()) {
			var ikmVal = ikm.getValue();

			if (me.gksd('CheckIkmUnique') && !me.gksd('NumberIKMUniq')) {
				me.errorMessages.push(wmc.getString(KS.L10n.RevizEditView_CheckSave_Мероприятие_с_номером_ИКМ___0___уже_присутствует_, ikmVal));
			}

			if (ikmVal.length < 25) {// && !me.ikmAnswer) {
				me.warningMessages.push(KS.L10n.RevizEditView_ebNumberIKM_MaskValidationError_Номер_ИКМ_содержит_некорректные_данные_);
			}
		}

		return res;
	},
	successSaveFunc: function(result, endFunc, inputParams){
		this.ownerCt.successSaveFunc(result, endFunc, inputParams);
	}
	//#endregion Сохранение данных
});