﻿//Таб Оформление
Ext.define('Keysystems.Reviz.Edit.Formalize', {
	extend: 'Ext.tab.Panel',
	closable: false,
	mixins: ['Keysystems.Base.Edit'],
	title: 'Оформление',
	tabKey: 'Formalize',
	f: 'edit',
	calcLink: -1,
	dmLink: -1,
	linkCode: 'SReviz',
	height: 800,
	bodyPadding: 0,
	labelWidth: 150,
	readOnlyList: ['taskGridFormalize', 'panelCalc'],

	initComponent: function() {
		var me = this;

		me.beforeInitComponent();
		me.callParent(arguments);
	},

	setReadOnly: function(state, reason) {
		Keysystems.Reviz.Edit.prototype.setReadOnly.call(this, state, reason);
	},
	
	createTabFormalize: function() {
		let me = this,
			ksControls = me.ksControls,
			taskGrid = Ext.create('Keysystems.Controls.TaskGrid', {
				key: 'tabFormilize',
				title: 'Документы',
				flex: 1,
				profileGateCode: 'edit',
				profileKey: 'taskGridFormalize',
				profileCode: 'DOCUMENT_REVIZ',
				visibleBtnExpandCollapse: true,
				edit: function (cfg, data) {
					data.data.REVIZ = me.ksData.link;
					if (me.ownerCt.readOnly) data.readOnly = true;
					me.callKsMethod(_, "docEdit", cfg, data, me.gksc('taskGridFormalize'));
				},
				rowDelete: function (nodes) {
					me.callKsMethod(_, "docDel", nodes, me.gksc('taskGridFormalize'));
				},
				getTitle: function () {
					return me.parentTitle + ' - ' + me.title
				},
				setAccessBtns: function (sels) {
					var owner = me.ownerCt,
						sTask = sels.length ? sels[0].data.S_TASK : 0;
					owner.setAccessTaskGrid.call(me, sTask);
				},
				addFromDF: function(cfg, data) {					
					data.data.REVIZ = me.ksData.link;
					me.callKsMethod(_, "docAddFromDF", data, me.gksc('taskGridFormalize'));
				},
				bindDF: function(cfg, data) {
					data.data.REVIZ = me.ksData.link;
					me.callKsMethod(_, "docBindDF", data, me.gksc('taskGridFormalize'));
				},
				deleteFromDF:  function(cfg, data) {
					data.data.REVIZ = me.ksData.link;
					me.callKsMethod(_, "docDeleteFromDF", data, me.gksc('taskGridFormalize'));
				}
			});
		me.sksc('taskGridFormalize', taskGrid);
		ksControls.ToolBar = taskGrid.ToolBar;
		me.add(taskGrid);
		if (me.items.length === 1) me.setActiveTab(taskGrid);
		return taskGrid;
	},
	createTabCalc: function(){
		let me = this,
			ksControls = me.ksControls,
			panelCalc = Ext.create('Keysystems.Panel.Calc', {
				key: 'tabCalc',
				title: 'Показатели',
				bodyPadding: 0,
				decimalData: me.gksd('decimalData'),
				getTRevizObjects: function () {
					return me.ksData.tRevizObjects || [];
				},
				getTRevizAudit: function () {
					return me.ksData.tRevizAudit || [];
				},
				getDT: function () {
					return me.ksData.dt;
				},
				getDTPeriod: function () {
					return {dh1: me.ksData.dt1, dh2: me.ksData.dt2};
				},
				getRevizLink: function () {
					return me.ksData.link || 0;
				},
				getSPersons: function () {
					return me.ksData.sPerson || [];
				},
				getSCalcsBold: function () {
					return me.ksData.sCalcsBold || [];
				},
				parentSave: function (callBack) {
					if (me.ownerCt.checkSave(callBack) !== false) callBack();
				},
				listeners: {
					activate: function () {
						ksControls.panelCalc.upd();
					}
				}
			});
		me.sksc('panelCalc', panelCalc);
		me.add(panelCalc);
		if (me.items.length === 1) me.setActiveTab(panelCalc);
		return panelCalc;
	},
	//#endregion Создание компонентов

	//#region Загрузка данных 
	loadCopyEditData: Ext.emptyFn,
	getExtra: function(endFunc) {
		this.ownerCt.getExtra.call(this, endFunc);
	},
	setExtra: function(value) {
		let me = this,
			ksData = me.ksData;

		me.ownerCt.setExtra.call(me, value);
		ksData.dt = me.getDateOrToday(value.dt);
		ksData.dt1 = me.getDateOrLong(value.dt1, 1);
		ksData.dt2 = me.getDateOrLong(value.dt2, 0);
		ksData.sCalcsBold = value.nastrHighLightCalc;
		ksData.access = value.access;
		me.setAccessStore(value.access);
		
		if (value.access.GRID_TASK_FORMALIZE !== 0) {
			let taskGrid = me.gksc('taskGridFormalize') ?? me.createTabFormalize();
			taskGrid.tempTask = value.tempTask;
			taskGrid.dfAccess = me.gksd('DFAccess');
			taskGrid.loadData(value.tasksFormalizeData);
			taskGrid.collapseAllNode(value.CollapseListDocuments);
		}
		
		if (value.access.GRID_REVIZ_CALC !== 0) {
			let pc = me.gksc('panelCalc') ?? me.createTabCalc();
			pc.clear();
			if (me.activeTab === pc) pc.upd();
		}		
		me.ksData.isActual.Formalize = true;
		me.setKsReadOnly(me.ownerCt.ksReadOnly);
	},
	getExtraNew: function(endFunc) { this.getExtra(endFunc); },

	setKsReadOnly: function(v) {
		let me = this,
			res = me.callParent(arguments);
		if (v || !me.ksData.access) return;

		if (me.ksData.access.GRID_REVIZ_CALC !== _ && (me.ksData.access.GRID_REVIZ_CALC & ObjAccessMask.EDIT) !== ObjAccessMask.EDIT){
			me.gksc('panelCalc')?.setReadOnly(true);
		}
		if (me.ksData.access.GRID_TASK_FORMALIZE !== _ && (me.ksData.access.GRID_TASK_FORMALIZE & ObjAccessMask.EDIT) !== ObjAccessMask.EDIT)
			me.gksc('taskGridFormalize')?.setReadOnly(true);
		return res;
	},

	afterCancelLoad: function() {
		this.ownerCt.afterCancelLoad();
	},

	initLoadingMaskCfg: function() {
		return this.ownerCt.initLoadingMaskCfg();
	},
	
	//#endregion Загрузка данных 

	//#region Сохранение данных
	dataCollector: function() {
		var me = this,
			ksControls = me.ksControls,
			res = me.ownerCt.dataCollector({});

		res.calc = JSON.stringify(ksControls.panelCalc?.getData());
		res.tab = me.tabKey;

		return res;
	},
	isFilled: () => true,

	checkSaveTab: function(callBack) {
		let panelCalc = this.gksc('panelCalc');
		if (panelCalc && panelCalc.store.getDataExt().length)
			panelCalc.checkDsCalc(function () {
				KsLib.tryRun(callBack);
			});
		else
			KsLib.tryRun(callBack);
	},
	successSaveFunc: function(result, endFunc, inputParams){
		this.ownerCt.successSaveFunc(result, endFunc, inputParams);
	}
	//#endregion Сохранение данных
});